/* rygel-media-item.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_TRACKABLE_ITEM (rygel_trackable_item_get_type ())
#define RYGEL_TRACKABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_ITEM, RygelTrackableItem))
#define RYGEL_IS_TRACKABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_ITEM))
#define RYGEL_TRACKABLE_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_ITEM, RygelTrackableItemIface))

typedef struct _RygelTrackableItem RygelTrackableItem;
typedef struct _RygelTrackableItemIface RygelTrackableItemIface;

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()
struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
};

struct _RygelMediaItemPrivate {
	gchar* _description;
};

struct _RygelTrackableItemIface {
	GTypeInterface parent_iface;
};


static gpointer rygel_media_item_parent_class = NULL;

GQuark rygel_media_item_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemPrivate))
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY,
	RYGEL_MEDIA_ITEM_DESCRIPTION
};
static void rygel_media_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_set_creator (RygelMediaObject* self, const gchar* value);
void rygel_media_object_set_date (RygelMediaObject* self, const gchar* value);
void rygel_media_item_set_description (RygelMediaItem* self, const gchar* value);
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteItem* rygel_serializer_add_item (RygelSerializer* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
const gchar* rygel_media_object_get_date (RygelMediaObject* self);
const gchar* rygel_media_object_get_creator (RygelMediaObject* self);
const gchar* rygel_media_item_get_description (RygelMediaItem* self);
GType rygel_trackable_item_get_type (void) G_GNUC_CONST;
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
const gchar* rygel_media_object_get_artist (RygelMediaObject* self);
const gchar* rygel_media_object_get_genre (RygelMediaObject* self);
GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
RygelMediaItem* rygel_media_item_construct (GType object_type);
RygelMediaObject* rygel_media_object_construct (GType object_type);
static void rygel_media_item_finalize (GObject* obj);
static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_media_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_item_error-quark");
}


static void rygel_media_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object) {
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPDIDLLiteObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPDIDLLiteObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) base;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (didl_object != NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = didl_object;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->apply_didl_lite (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject), _tmp0_);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = didl_object;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = gupnp_didl_lite_object_get_creator (_tmp1_);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_object_set_creator ((RygelMediaObject*) self, _tmp2_);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = didl_object;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = gupnp_didl_lite_object_get_date (_tmp3_);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp5_ = _tmp4_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_object_set_date ((RygelMediaObject*) self, _tmp5_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = didl_object;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp7_ = gupnp_didl_lite_object_get_description (_tmp6_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp8_ = _tmp7_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_item_set_description (self, _tmp8_);
#line 304 "rygel-media-item.c"
}


static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteItem* didl_item = NULL;
	RygelSerializer* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	GUPnPDIDLLiteItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaContainer* _tmp10_ = NULL;
	RygelMediaContainer* _tmp11_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GUPnPDIDLLiteItem* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GUPnPDIDLLiteItem* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gboolean _tmp36_ = FALSE;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp46_ = NULL;
	gboolean _tmp52_ = FALSE;
	const gchar* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	gboolean _tmp62_ = FALSE;
	const gchar* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) base;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (serializer != NULL, NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = serializer;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = rygel_serializer_add_item (_tmp0_);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	didl_item = _tmp1_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp2_ = didl_item;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp3_ = rygel_media_object_get_id ((RygelMediaObject*) self);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp4_ = _tmp3_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) _tmp2_, _tmp4_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp5_ = rygel_media_object_get_ref_id ((RygelMediaObject*) self);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp6_ = _tmp5_;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp6_ != NULL) {
#line 367 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp7_ = didl_item;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp8_ = rygel_media_object_get_ref_id ((RygelMediaObject*) self);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp9_ = _tmp8_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_item_set_ref_id (_tmp7_, _tmp9_);
#line 379 "rygel-media-item.c"
	}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp10_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp11_ = _tmp10_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp11_ != NULL) {
#line 387 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp12_ = NULL;
		RygelMediaContainer* _tmp13_ = NULL;
		RygelMediaContainer* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp12_ = didl_item;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp13_ = rygel_media_object_get_parent ((RygelMediaObject*) self);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp14_ = _tmp13_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp15_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp14_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp16_ = _tmp15_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp12_, _tmp16_);
#line 405 "rygel-media-item.c"
	} else {
		GUPnPDIDLLiteItem* _tmp17_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp17_ = didl_item;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) _tmp17_, "0");
#line 412 "rygel-media-item.c"
	}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp18_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp19_ = _tmp18_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp19_) {
#line 420 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp20_ = NULL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp20_ = didl_item;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp20_, TRUE);
#line 426 "rygel-media-item.c"
	} else {
		GUPnPDIDLLiteItem* _tmp21_ = NULL;
		GUPnPDIDLLiteItem* _tmp22_ = NULL;
		GUPnPOCMFlags _tmp23_ = 0;
		GUPnPOCMFlags _tmp24_ = 0;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp21_ = didl_item;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) _tmp21_, FALSE);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp22_ = didl_item;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp23_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp24_ = _tmp23_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) _tmp22_, _tmp24_);
#line 444 "rygel-media-item.c"
	}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp25_ = didl_item;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp26_ = rygel_media_object_get_title ((RygelMediaObject*) self);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp27_ = _tmp26_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) _tmp25_, _tmp27_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp28_ = didl_item;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp29_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) self);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp30_ = _tmp29_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _tmp28_, _tmp30_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp31_ = rygel_media_object_get_date ((RygelMediaObject*) self);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp32_ = _tmp31_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp32_ != NULL) {
#line 468 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp33_ = didl_item;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp34_ = rygel_media_object_get_date ((RygelMediaObject*) self);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp35_ = _tmp34_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_date ((GUPnPDIDLLiteObject*) _tmp33_, _tmp35_);
#line 480 "rygel-media-item.c"
	}
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp37_ = rygel_media_object_get_creator ((RygelMediaObject*) self);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp38_ = _tmp37_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp38_ != NULL) {
#line 488 "rygel-media-item.c"
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp39_ = rygel_media_object_get_creator ((RygelMediaObject*) self);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp40_ = _tmp39_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp36_ = g_strcmp0 (_tmp40_, "") != 0;
#line 497 "rygel-media-item.c"
	} else {
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp36_ = FALSE;
#line 501 "rygel-media-item.c"
	}
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp36_) {
#line 505 "rygel-media-item.c"
		GUPnPDIDLLiteContributor* creator = NULL;
		GUPnPDIDLLiteItem* _tmp41_ = NULL;
		GUPnPDIDLLiteContributor* _tmp42_ = NULL;
		GUPnPDIDLLiteContributor* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp41_ = didl_item;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp42_ = gupnp_didl_lite_object_add_creator ((GUPnPDIDLLiteObject*) _tmp41_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		creator = _tmp42_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp43_ = creator;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp44_ = rygel_media_object_get_creator ((RygelMediaObject*) self);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp45_ = _tmp44_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_contributor_set_name (_tmp43_, _tmp45_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (creator);
#line 528 "rygel-media-item.c"
	}
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp46_ = self->priv->_description;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp46_ != NULL) {
#line 534 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp47_ = didl_item;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp48_ = self->priv->_description;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_description ((GUPnPDIDLLiteObject*) _tmp47_, _tmp48_);
#line 543 "rygel-media-item.c"
	}
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_TRACKABLE_ITEM)) {
#line 547 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp49_ = NULL;
		guint _tmp50_ = 0U;
		guint _tmp51_ = 0U;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp49_ = didl_item;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp50_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) self);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp51_ = _tmp50_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_update_id ((GUPnPDIDLLiteObject*) _tmp49_, _tmp51_);
#line 559 "rygel-media-item.c"
	}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp53_ = rygel_media_object_get_artist ((RygelMediaObject*) self);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp54_ = _tmp53_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp54_ != NULL) {
#line 567 "rygel-media-item.c"
		const gchar* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp55_ = rygel_media_object_get_artist ((RygelMediaObject*) self);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp56_ = _tmp55_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp52_ = g_strcmp0 (_tmp56_, "") != 0;
#line 576 "rygel-media-item.c"
	} else {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp52_ = FALSE;
#line 580 "rygel-media-item.c"
	}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp52_) {
#line 584 "rygel-media-item.c"
		GUPnPDIDLLiteContributor* contributor = NULL;
		GUPnPDIDLLiteItem* _tmp57_ = NULL;
		GUPnPDIDLLiteContributor* _tmp58_ = NULL;
		GUPnPDIDLLiteContributor* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp57_ = didl_item;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp58_ = gupnp_didl_lite_object_add_artist ((GUPnPDIDLLiteObject*) _tmp57_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		contributor = _tmp58_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp59_ = contributor;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp60_ = rygel_media_object_get_artist ((RygelMediaObject*) self);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp61_ = _tmp60_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_contributor_set_name (_tmp59_, _tmp61_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_g_object_unref0 (contributor);
#line 607 "rygel-media-item.c"
	}
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp63_ = rygel_media_object_get_genre ((RygelMediaObject*) self);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp64_ = _tmp63_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp64_ != NULL) {
#line 615 "rygel-media-item.c"
		const gchar* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp65_ = rygel_media_object_get_genre ((RygelMediaObject*) self);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp66_ = _tmp65_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp62_ = g_strcmp0 (_tmp66_, "") != 0;
#line 624 "rygel-media-item.c"
	} else {
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp62_ = FALSE;
#line 628 "rygel-media-item.c"
	}
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	if (_tmp62_) {
#line 632 "rygel-media-item.c"
		GUPnPDIDLLiteItem* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp67_ = didl_item;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp68_ = rygel_media_object_get_genre ((RygelMediaObject*) self);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		_tmp69_ = _tmp68_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		gupnp_didl_lite_object_set_genre ((GUPnPDIDLLiteObject*) _tmp67_, _tmp69_);
#line 644 "rygel-media-item.c"
	}
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = (GUPnPDIDLLiteObject*) didl_item;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 650 "rygel-media-item.c"
}


static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = gupnp_protocol_info_new ();
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	protocol_info = _tmp0_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = protocol;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_protocol_info_set_protocol (protocol_info, _tmp1_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_flags (protocol_info, (GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = protocol_info;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 675 "rygel-media-item.c"
}


GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->get_protocol_info (self, uri, protocol);
#line 684 "rygel-media-item.c"
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return self;
#line 694 "rygel-media-item.c"
}


const gchar* rygel_media_item_get_description (RygelMediaItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = self->priv->_description;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	result = _tmp0_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	return result;
#line 709 "rygel-media-item.c"
}


void rygel_media_item_set_description (RygelMediaItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_description);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_description = _tmp1_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_notify ((GObject *) self, "description");
#line 728 "rygel-media-item.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaItemPrivate));
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	((RygelMediaObjectClass *) klass)->apply_didl_lite = rygel_media_item_real_apply_didl_lite;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	((RygelMediaObjectClass *) klass)->serialize = rygel_media_item_real_serialize;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	((RygelMediaItemClass *) klass)->get_protocol_info = rygel_media_item_real_get_protocol_info;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_item_get_property;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_item_set_property;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 751 "rygel-media-item.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv = RYGEL_MEDIA_ITEM_GET_PRIVATE (self);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self->priv->_description = NULL;
#line 760 "rygel-media-item.c"
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	_g_free0 (self->priv->_description);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 772 "rygel-media-item.c"
}


/**
 * Abstract class representing a MediaItem
 *
 * MediaItems must live in a container and may not contain other MediaItems
 */
GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	switch (property_id) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_DESCRIPTION:
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		g_value_set_string (value, rygel_media_item_get_description (self));
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 804 "rygel-media-item.c"
		default:
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 810 "rygel-media-item.c"
	}
}


static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
	switch (property_id) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		case RYGEL_MEDIA_ITEM_DESCRIPTION:
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		rygel_media_item_set_description (self, g_value_get_string (value));
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 826 "rygel-media-item.c"
		default:
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-item.vala"
		break;
#line 832 "rygel-media-item.c"
	}
}



