/* rygel-http-subtitle-handler.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-subtitle-handler.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <rygel-core.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_SUBTITLE_HANDLER (rygel_http_subtitle_handler_get_type ())
#define RYGEL_HTTP_SUBTITLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandler))
#define RYGEL_HTTP_SUBTITLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerClass))
#define RYGEL_IS_HTTP_SUBTITLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER))
#define RYGEL_IS_HTTP_SUBTITLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER))
#define RYGEL_HTTP_SUBTITLE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerClass))

typedef struct _RygelHTTPSubtitleHandler RygelHTTPSubtitleHandler;
typedef struct _RygelHTTPSubtitleHandlerClass RygelHTTPSubtitleHandlerClass;
typedef struct _RygelHTTPSubtitleHandlerPrivate RygelHTTPSubtitleHandlerPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPSubtitleHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPSubtitleHandlerPrivate * priv;
	RygelSubtitle* subtitle;
};

struct _RygelHTTPSubtitleHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPSubtitleHandlerPrivate {
	RygelMediaFileItem* media_item;
	gint subtitle_index;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};


static gpointer rygel_http_subtitle_handler_parent_class = NULL;

GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_subtitle_handler_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SUBTITLE_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandlerPrivate))
enum  {
	RYGEL_HTTP_SUBTITLE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_new (RygelMediaFileItem* media_item, gint subtitle_index, GCancellable* cancellable, GError** error);
RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_construct (GType object_type, RygelMediaFileItem* media_item, gint subtitle_index, GCancellable* cancellable, GError** error);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self, GCancellable* value);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_video_item_get_subtitles (RygelVideoItem* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
static gboolean rygel_http_subtitle_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base, const gchar* mode);
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING "Streaming"
static void rygel_http_subtitle_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self);
GUPnPProtocolInfo* rygel_media_resource_get_protocol_info (RygelMediaResource* self, GHashTable* replacements);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static RygelHTTPResponse* rygel_http_subtitle_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
RygelDataSource* rygel_media_engine_create_data_source_for_uri (RygelMediaEngine* self, const gchar* uri, GError** error);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
static gint64 rygel_http_subtitle_handler_real_get_resource_size (RygelHTTPGetHandler* base);
static gboolean rygel_http_subtitle_handler_real_supports_byte_seek (RygelHTTPGetHandler* base);
static void rygel_http_subtitle_handler_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	return self ? g_object_ref (self) : NULL;
#line 394 "rygel-http-subtitle-handler.c"
}


RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_construct (GType object_type, RygelMediaFileItem* media_item, gint subtitle_index, GCancellable* cancellable, GError** error) {
	RygelHTTPSubtitleHandler * self = NULL;
	RygelMediaFileItem* _tmp0_ = NULL;
	RygelMediaFileItem* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GCancellable* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	RygelSubtitle* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	g_return_val_if_fail (media_item != NULL, NULL);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	self = (RygelHTTPSubtitleHandler*) rygel_http_get_handler_construct (object_type);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp0_ = media_item;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_g_object_unref0 (self->priv->media_item);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	self->priv->media_item = _tmp1_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp2_ = subtitle_index;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	self->priv->subtitle_index = _tmp2_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp3_ = cancellable;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, _tmp3_);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp5_ = subtitle_index;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	if (_tmp5_ >= 0) {
#line 432 "rygel-http-subtitle-handler.c"
		RygelMediaFileItem* _tmp6_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp6_ = media_item;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_VIDEO_ITEM);
#line 438 "rygel-http-subtitle-handler.c"
	} else {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp4_ = FALSE;
#line 442 "rygel-http-subtitle-handler.c"
	}
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	if (_tmp4_) {
#line 446 "rygel-http-subtitle-handler.c"
		RygelVideoItem* video_item = NULL;
		RygelMediaFileItem* _tmp7_ = NULL;
		RygelVideoItem* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		RygelVideoItem* _tmp10_ = NULL;
		GeeArrayList* _tmp11_ = NULL;
		GeeArrayList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp7_ = media_item;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp7_) : NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		video_item = _tmp8_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp9_ = subtitle_index;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp10_ = video_item;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp11_ = rygel_video_item_get_subtitles (_tmp10_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp12_ = _tmp11_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp14_ = _tmp13_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		if (_tmp9_ < _tmp14_) {
#line 476 "rygel-http-subtitle-handler.c"
			RygelVideoItem* _tmp15_ = NULL;
			GeeArrayList* _tmp16_ = NULL;
			GeeArrayList* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gpointer _tmp19_ = NULL;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_tmp15_ = video_item;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_tmp16_ = rygel_video_item_get_subtitles (_tmp15_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_tmp17_ = _tmp16_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_tmp18_ = subtitle_index;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_rygel_subtitle_unref0 (self->subtitle);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			self->subtitle = (RygelSubtitle*) _tmp19_;
#line 496 "rygel-http-subtitle-handler.c"
		}
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_g_object_unref0 (video_item);
#line 500 "rygel-http-subtitle-handler.c"
	}
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp20_ = self->subtitle;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	if (_tmp20_ == NULL) {
#line 506 "rygel-http-subtitle-handler.c"
		gint _tmp21_ = 0;
		RygelMediaFileItem* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		GError* _tmp25_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp21_ = subtitle_index;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp22_ = media_item;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp23_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp22_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp24_ = _tmp23_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp25_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "Subtitle index %d not found for item '%s", _tmp21_, _tmp24_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_inner_error_ = _tmp25_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			g_propagate_error (error, _inner_error_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_g_object_unref0 (self);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			return NULL;
#line 532 "rygel-http-subtitle-handler.c"
		} else {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			g_clear_error (&_inner_error_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			return NULL;
#line 540 "rygel-http-subtitle-handler.c"
		}
	}
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	return self;
#line 545 "rygel-http-subtitle-handler.c"
}


RygelHTTPSubtitleHandler* rygel_http_subtitle_handler_new (RygelMediaFileItem* media_item, gint subtitle_index, GCancellable* cancellable, GError** error) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	return rygel_http_subtitle_handler_construct (RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, media_item, subtitle_index, cancellable, error);
#line 552 "rygel-http-subtitle-handler.c"
}


static gboolean rygel_http_subtitle_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base, const gchar* mode) {
	RygelHTTPSubtitleHandler * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	self = (RygelHTTPSubtitleHandler*) base;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	g_return_val_if_fail (mode != NULL, FALSE);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp0_ = mode;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	result = g_strcmp0 (_tmp0_, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING) != 0;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	return result;
#line 570 "rygel-http-subtitle-handler.c"
}


static void rygel_http_subtitle_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPSubtitleHandler * self;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	RygelSubtitle* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelMediaResource* res = NULL;
	RygelMediaFileItem* _tmp5_ = NULL;
	GeeList* _tmp6_ = NULL;
	GeeList* _tmp7_ = NULL;
	gpointer _tmp8_ = NULL;
	RygelMediaResource* _tmp9_ = NULL;
	gchar* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp10_ = NULL;
	GUPnPProtocolInfo* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** pi_fields = NULL;
	gchar** _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint pi_fields_length1 = 0;
	gint _pi_fields_size_ = 0;
	RygelHTTPGet* _tmp16_ = NULL;
	SoupMessage* _tmp17_ = NULL;
	SoupMessageHeaders* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	RygelHTTPGet* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	self = (RygelHTTPSubtitleHandler*) base;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	g_return_if_fail (request != NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp0_ = request;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp2_ = _tmp1_->response_headers;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp3_ = self->subtitle;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp4_ = _tmp3_->mime_type;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	soup_message_headers_append (_tmp2_, "Content-Type", _tmp4_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp5_ = self->priv->media_item;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp6_ = rygel_media_object_get_resource_list ((RygelMediaObject*) _tmp5_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp7_ = _tmp6_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp8_ = gee_list_get (_tmp7_, 0);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp9_ = (RygelMediaResource*) _tmp8_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_g_object_unref0 (_tmp7_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	res = _tmp9_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp10_ = rygel_media_resource_get_protocol_info (res, NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp11_ = _tmp10_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp12_ = gupnp_protocol_info_to_string (_tmp11_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp13_ = _tmp12_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_g_object_unref0 (_tmp11_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	protocol_info = _tmp13_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp15_ = _tmp14_ = g_strsplit (protocol_info, ":", 4);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	pi_fields = _tmp15_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	pi_fields_length1 = _vala_array_length (_tmp14_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_pi_fields_size_ = pi_fields_length1;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp16_ = request;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp17_ = ((RygelHTTPRequest*) _tmp16_)->msg;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp18_ = _tmp17_->response_headers;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp19_ = pi_fields[3];
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	soup_message_headers_append (_tmp18_, "contentFeatures.dlna.org", _tmp19_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp20_ = request;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_subtitle_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), _tmp20_, &_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			g_propagate_error (error, _inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_g_free0 (protocol_info);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_g_object_unref0 (res);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			return;
#line 681 "rygel-http-subtitle-handler.c"
		} else {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_g_free0 (protocol_info);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_g_object_unref0 (res);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			g_clear_error (&_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			return;
#line 695 "rygel-http-subtitle-handler.c"
		}
	}
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_g_free0 (protocol_info);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_g_object_unref0 (res);
#line 704 "rygel-http-subtitle-handler.c"
}


static RygelHTTPResponse* rygel_http_subtitle_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPSubtitleHandler * self;
	RygelHTTPResponse* result = NULL;
	RygelDataSource* src = NULL;
	GError * _inner_error_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	self = (RygelHTTPSubtitleHandler*) base;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 717 "rygel-http-subtitle-handler.c"
	{
		RygelMediaEngine* engine = NULL;
		RygelMediaEngine* _tmp0_ = NULL;
		RygelDataSource* _tmp1_ = NULL;
		RygelMediaEngine* _tmp2_ = NULL;
		RygelSubtitle* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelDataSource* _tmp5_ = NULL;
		RygelDataSource* _tmp6_ = NULL;
		RygelHTTPResponse* _tmp7_ = NULL;
		RygelHTTPGet* _tmp8_ = NULL;
		RygelDataSource* _tmp9_ = NULL;
		RygelHTTPResponse* _tmp10_ = NULL;
		RygelHTTPResponse* _tmp11_ = NULL;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp0_ = rygel_media_engine_get_default ();
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		engine = _tmp0_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp2_ = engine;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp3_ = self->subtitle;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp4_ = _tmp3_->uri;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp5_ = rygel_media_engine_create_data_source_for_uri (_tmp2_, _tmp4_, &_inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp1_ = _tmp5_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_g_object_unref0 (engine);
#line 750 "rygel-http-subtitle-handler.c"
			goto __catch41_g_error;
		}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp6_ = _tmp1_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp1_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_g_object_unref0 (src);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		src = _tmp6_;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp8_ = request;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp9_ = src;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp10_ = rygel_http_response_new (_tmp8_, (RygelHTTPGetHandler*) self, _tmp9_, &_inner_error_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp7_ = _tmp10_;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_g_object_unref0 (_tmp1_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
			_g_object_unref0 (engine);
#line 775 "rygel-http-subtitle-handler.c"
			goto __catch41_g_error;
		}
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp11_ = _tmp7_;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp7_ = NULL;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		result = _tmp11_;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_g_object_unref0 (_tmp7_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_g_object_unref0 (_tmp1_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_g_object_unref0 (engine);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_g_object_unref0 (src);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		return result;
#line 794 "rygel-http-subtitle-handler.c"
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		err = _inner_error_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_inner_error_ = NULL;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp12_ = err;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp13_ = _tmp12_->message;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_tmp14_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp13_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_inner_error_ = _tmp14_;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_g_error_free0 (err);
#line 817 "rygel-http-subtitle-handler.c"
		goto __finally41;
	}
	__finally41:
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		g_propagate_error (error, _inner_error_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_g_object_unref0 (src);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		return NULL;
#line 829 "rygel-http-subtitle-handler.c"
	} else {
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		_g_object_unref0 (src);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		g_clear_error (&_inner_error_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
		return NULL;
#line 839 "rygel-http-subtitle-handler.c"
	}
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_g_object_unref0 (src);
#line 843 "rygel-http-subtitle-handler.c"
}


static gint64 rygel_http_subtitle_handler_real_get_resource_size (RygelHTTPGetHandler* base) {
	RygelHTTPSubtitleHandler * self;
	gint64 result = 0LL;
	RygelSubtitle* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	self = (RygelHTTPSubtitleHandler*) base;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp0_ = self->subtitle;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_tmp1_ = _tmp0_->size;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	result = _tmp1_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	return result;
#line 862 "rygel-http-subtitle-handler.c"
}


static gboolean rygel_http_subtitle_handler_real_supports_byte_seek (RygelHTTPGetHandler* base) {
	RygelHTTPSubtitleHandler * self;
	gboolean result = FALSE;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	self = (RygelHTTPSubtitleHandler*) base;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	result = TRUE;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	return result;
#line 875 "rygel-http-subtitle-handler.c"
}


static void rygel_http_subtitle_handler_class_init (RygelHTTPSubtitleHandlerClass * klass) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	rygel_http_subtitle_handler_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPSubtitleHandlerPrivate));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = rygel_http_subtitle_handler_real_supports_transfer_mode;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = rygel_http_subtitle_handler_real_add_response_headers;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->render_body = rygel_http_subtitle_handler_real_render_body;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = rygel_http_subtitle_handler_real_get_resource_size;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = rygel_http_subtitle_handler_real_supports_byte_seek;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_subtitle_handler_finalize;
#line 896 "rygel-http-subtitle-handler.c"
}


static void rygel_http_subtitle_handler_instance_init (RygelHTTPSubtitleHandler * self) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	self->priv = RYGEL_HTTP_SUBTITLE_HANDLER_GET_PRIVATE (self);
#line 903 "rygel-http-subtitle-handler.c"
}


static void rygel_http_subtitle_handler_finalize (GObject* obj) {
	RygelHTTPSubtitleHandler * self;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SUBTITLE_HANDLER, RygelHTTPSubtitleHandler);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_g_object_unref0 (self->priv->media_item);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	_rygel_subtitle_unref0 (self->subtitle);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-subtitle-handler.vala"
	G_OBJECT_CLASS (rygel_http_subtitle_handler_parent_class)->finalize (obj);
#line 917 "rygel-http-subtitle-handler.c"
}


GType rygel_http_subtitle_handler_get_type (void) {
	static volatile gsize rygel_http_subtitle_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_subtitle_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPSubtitleHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_subtitle_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPSubtitleHandler), 0, (GInstanceInitFunc) rygel_http_subtitle_handler_instance_init, NULL };
		GType rygel_http_subtitle_handler_type_id;
		rygel_http_subtitle_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPSubtitleHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_subtitle_handler_type_id__volatile, rygel_http_subtitle_handler_type_id);
	}
	return rygel_http_subtitle_handler_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



