/* rygel-http-item-uri.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-item-uri.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-core.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURIPrivate {
	gchar* _item_id;
	gint _thumbnail_index;
	gint _subtitle_index;
	gchar* _resource_name;
	RygelHTTPServer* _http_server;
	gchar* real_extension;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
	GHashTable* replacements;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
	gchar* (*get_protocol) (RygelHTTPServer* self);
	GeeArrayList* (*get_protocol_info) (RygelHTTPServer* self);
};


static gpointer rygel_http_item_uri_parent_class = NULL;
extern GeeHashMap* rygel_http_item_uri_mime_to_ext;
GeeHashMap* rygel_http_item_uri_mime_to_ext = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY,
	RYGEL_HTTP_ITEM_URI_ITEM_ID,
	RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX,
	RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX,
	RYGEL_HTTP_ITEM_URI_RESOURCE_NAME,
	RYGEL_HTTP_ITEM_URI_HTTP_SERVER,
	RYGEL_HTTP_ITEM_URI_EXTENSION
};
GType rygel_media_object_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* resource_name);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* resource_name);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
void rygel_http_item_uri_set_item_id (RygelHTTPItemURI* self, const gchar* value);
void rygel_http_item_uri_set_thumbnail_index (RygelHTTPItemURI* self, gint value);
void rygel_http_item_uri_set_subtitle_index (RygelHTTPItemURI* self, gint value);
void rygel_http_item_uri_set_http_server (RygelHTTPItemURI* self, RygelHTTPServer* value);
void rygel_http_item_uri_set_resource_name (RygelHTTPItemURI* self, const gchar* value);
void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value);
const gchar* rygel_http_item_uri_get_resource_name (RygelHTTPItemURI* self);
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
RygelMediaResource* rygel_media_object_get_resource_by_name (RygelMediaObject* self, const gchar* resource_name);
const gchar* rygel_media_resource_get_extension (RygelMediaResource* self);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self);
GType rygel_video_item_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_video_item_get_subtitles (RygelVideoItem* self);
gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self);
GeeList* rygel_media_object_get_uris (RygelMediaObject* self);
static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type);
const gchar* rygel_media_file_item_get_mime_type (RygelMediaFileItem* self);
static gchar* rygel_http_item_uri_base64_urlencode (RygelHTTPItemURI* self, const gchar* data);
static guchar* rygel_http_item_uri_base64_urldecode (RygelHTTPItemURI* self, const gchar* data, int* result_length1);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self);
gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path);
RygelHTTPServer* rygel_http_item_uri_get_http_server (RygelHTTPItemURI* self);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return self ? g_object_ref (self) : NULL;
#line 323 "rygel-http-item-uri.c"
}


static gpointer _rygel_icon_info_ref0 (gpointer self) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return self ? rygel_icon_info_ref (self) : NULL;
#line 330 "rygel-http-item-uri.c"
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 910 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 910 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 911 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 911 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 911 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 911 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 913 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 913 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 357 "rygel-http-item-uri.c"
		gchar* _tmp4_ = NULL;
#line 914 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 914 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 914 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 365 "rygel-http-item-uri.c"
	} else {
#line 916 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 916 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 371 "rygel-http-item-uri.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 395 "rygel-http-item-uri.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 403 "rygel-http-item-uri.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 415 "rygel-http-item-uri.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 439 "rygel-http-item-uri.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 445 "rygel-http-item-uri.c"
	} else {
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 449 "rygel-http-item-uri.c"
	}
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 453 "rygel-http-item-uri.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 465 "rygel-http-item-uri.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 475 "rygel-http-item-uri.c"
	}
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 481 "rygel-http-item-uri.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 495 "rygel-http-item-uri.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 505 "rygel-http-item-uri.c"
	}
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 511 "rygel-http-item-uri.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 520 "rygel-http-item-uri.c"
	}
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 540 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* resource_name) {
	RygelHTTPItemURI * self = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	RygelHTTPServer* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* _tmp16_ = NULL;
	RygelMediaFileItem* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gboolean _tmp59_ = FALSE;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (object != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = object;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp2_ = _tmp1_;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_item_id (self, _tmp2_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp3_ = thumbnail_index;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_thumbnail_index (self, _tmp3_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp4_ = subtitle_index;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_subtitle_index (self, _tmp4_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp5_ = http_server;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_http_server (self, _tmp5_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp6_ = resource_name;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_resource_name (self, _tmp6_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_extension (self, "");
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp7_ = self->priv->_resource_name;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (_tmp7_ != NULL) {
#line 598 "rygel-http-item-uri.c"
		RygelMediaResource* resource = NULL;
		RygelMediaObject* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		RygelMediaResource* _tmp10_ = NULL;
		RygelMediaResource* _tmp11_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp8_ = object;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp9_ = self->priv->_resource_name;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp10_ = rygel_media_object_get_resource_by_name (_tmp8_, _tmp9_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		resource = _tmp10_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp11_ = resource;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		if (_tmp11_ != NULL) {
#line 616 "rygel-http-item-uri.c"
			RygelMediaResource* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp12_ = resource;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp13_ = rygel_media_resource_get_extension (_tmp12_);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp14_ = _tmp13_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			rygel_http_item_uri_set_extension (self, _tmp14_);
#line 628 "rygel-http-item-uri.c"
		}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_g_object_unref0 (resource);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		return self;
#line 634 "rygel-http-item-uri.c"
	} else {
		RygelMediaObject* _tmp15_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp15_ = object;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			return self;
#line 643 "rygel-http-item-uri.c"
		}
	}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp16_ = object;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp16_) : NULL);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	item = _tmp17_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp18_ = thumbnail_index;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (_tmp18_ > (-1)) {
#line 656 "rygel-http-item-uri.c"
		RygelMediaFileItem* _tmp19_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp19_ = item;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 662 "rygel-http-item-uri.c"
			GeeArrayList* thumbnails = NULL;
			RygelMediaFileItem* _tmp20_ = NULL;
			GeeArrayList* _tmp21_ = NULL;
			GeeArrayList* _tmp22_ = NULL;
			GeeArrayList* _tmp23_ = NULL;
			GeeArrayList* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp20_ = item;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp21_ = rygel_visual_item_get_thumbnails (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp20_) : NULL);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp22_ = _tmp21_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp23_ = _g_object_ref0 (_tmp22_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			thumbnails = _tmp23_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp24_ = thumbnails;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp26_ = _tmp25_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp27_ = thumbnail_index;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			if (_tmp26_ > _tmp27_) {
#line 692 "rygel-http-item-uri.c"
				GeeArrayList* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gpointer _tmp30_ = NULL;
				RygelThumbnail* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp28_ = thumbnails;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp29_ = thumbnail_index;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp31_ = (RygelThumbnail*) _tmp30_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp32_ = ((RygelIconInfo*) _tmp31_)->file_extension;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				rygel_http_item_uri_set_extension (self, _tmp32_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_rygel_icon_info_unref0 (_tmp31_);
#line 712 "rygel-http-item-uri.c"
			}
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_object_unref0 (thumbnails);
#line 716 "rygel-http-item-uri.c"
		} else {
			RygelMediaFileItem* _tmp33_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp33_ = item;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 723 "rygel-http-item-uri.c"
				RygelThumbnail* album_art = NULL;
				RygelMediaFileItem* _tmp34_ = NULL;
				RygelThumbnail* _tmp35_ = NULL;
				RygelThumbnail* _tmp36_ = NULL;
				RygelThumbnail* _tmp37_ = NULL;
				RygelThumbnail* _tmp38_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp34_ = item;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp35_ = rygel_music_item_get_album_art (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp34_) : NULL);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp36_ = _tmp35_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp37_ = _rygel_icon_info_ref0 (_tmp36_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				album_art = _tmp37_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp38_ = album_art;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				if (_tmp38_ != NULL) {
#line 744 "rygel-http-item-uri.c"
					RygelThumbnail* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp39_ = album_art;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp40_ = ((RygelIconInfo*) _tmp39_)->file_extension;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					rygel_http_item_uri_set_extension (self, _tmp40_);
#line 753 "rygel-http-item-uri.c"
				}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_rygel_icon_info_unref0 (album_art);
#line 757 "rygel-http-item-uri.c"
			}
		}
	} else {
		gint _tmp41_ = 0;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp41_ = subtitle_index;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		if (_tmp41_ > (-1)) {
#line 766 "rygel-http-item-uri.c"
			RygelMediaFileItem* _tmp42_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp42_ = item;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, RYGEL_TYPE_VIDEO_ITEM)) {
#line 772 "rygel-http-item-uri.c"
				GeeArrayList* subtitles = NULL;
				RygelMediaFileItem* _tmp43_ = NULL;
				GeeArrayList* _tmp44_ = NULL;
				GeeArrayList* _tmp45_ = NULL;
				GeeArrayList* _tmp46_ = NULL;
				GeeArrayList* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp43_ = item;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp44_ = rygel_video_item_get_subtitles (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp43_) : NULL);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp45_ = _tmp44_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp46_ = _g_object_ref0 (_tmp45_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				subtitles = _tmp46_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp47_ = subtitles;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp48_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp47_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp49_ = _tmp48_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp50_ = subtitle_index;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				if (_tmp49_ > _tmp50_) {
#line 802 "rygel-http-item-uri.c"
					GeeArrayList* _tmp51_ = NULL;
					gint _tmp52_ = 0;
					gpointer _tmp53_ = NULL;
					RygelSubtitle* _tmp54_ = NULL;
					const gchar* _tmp55_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp51_ = subtitles;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp52_ = subtitle_index;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp51_, _tmp52_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp54_ = (RygelSubtitle*) _tmp53_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp55_ = _tmp54_->caption_type;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					rygel_http_item_uri_set_extension (self, _tmp55_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_rygel_subtitle_unref0 (_tmp54_);
#line 822 "rygel-http-item-uri.c"
				}
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_g_object_unref0 (subtitles);
#line 826 "rygel-http-item-uri.c"
			}
		}
	}
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp56_ = rygel_http_item_uri_get_extension (self);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp57_ = _tmp56_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp58_ = _tmp57_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp59_ = g_strcmp0 (_tmp58_, "") == 0;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (_tmp58_);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (_tmp59_) {
#line 842 "rygel-http-item-uri.c"
		gchar* uri_extension = NULL;
		gchar* _tmp60_ = NULL;
		const gchar* _tmp80_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp60_ = g_strdup ("");
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		uri_extension = _tmp60_;
#line 850 "rygel-http-item-uri.c"
		{
			GeeList* _uri_string_list = NULL;
			RygelMediaFileItem* _tmp61_ = NULL;
			GeeList* _tmp62_ = NULL;
			gint _uri_string_size = 0;
			GeeList* _tmp63_ = NULL;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			gint _uri_string_index = 0;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp61_ = item;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp62_ = rygel_media_object_get_uris ((RygelMediaObject*) _tmp61_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_uri_string_list = _tmp62_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp63_ = _uri_string_list;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp64_ = gee_collection_get_size ((GeeCollection*) _tmp63_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp65_ = _tmp64_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_uri_string_size = _tmp65_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_uri_string_index = -1;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			while (TRUE) {
#line 878 "rygel-http-item-uri.c"
				gint _tmp66_ = 0;
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
				gchar* uri_string = NULL;
				GeeList* _tmp69_ = NULL;
				gint _tmp70_ = 0;
				gpointer _tmp71_ = NULL;
				gchar* basename = NULL;
				const gchar* _tmp72_ = NULL;
				gchar* _tmp73_ = NULL;
				gint dot_index = 0;
				const gchar* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp66_ = _uri_string_index;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_uri_string_index = _tmp66_ + 1;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp67_ = _uri_string_index;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp68_ = _uri_string_size;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				if (!(_tmp67_ < _tmp68_)) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					break;
#line 905 "rygel-http-item-uri.c"
				}
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp69_ = _uri_string_list;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp70_ = _uri_string_index;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp71_ = gee_list_get (_tmp69_, _tmp70_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				uri_string = (gchar*) _tmp71_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp72_ = uri_string;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp73_ = g_path_get_basename (_tmp72_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				basename = _tmp73_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp74_ = basename;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp75_ = string_last_index_of (_tmp74_, ".", 0);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				dot_index = _tmp75_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp76_ = dot_index;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				if (_tmp76_ > (-1)) {
#line 931 "rygel-http-item-uri.c"
					const gchar* _tmp77_ = NULL;
					gint _tmp78_ = 0;
					gchar* _tmp79_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp77_ = basename;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp78_ = dot_index;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp79_ = string_substring (_tmp77_, (glong) (_tmp78_ + 1), (glong) (-1));
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_g_free0 (uri_extension);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					uri_extension = _tmp79_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_g_free0 (basename);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_g_free0 (uri_string);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					break;
#line 951 "rygel-http-item-uri.c"
				}
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_g_free0 (basename);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_g_free0 (uri_string);
#line 957 "rygel-http-item-uri.c"
			}
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_object_unref0 (_uri_string_list);
#line 961 "rygel-http-item-uri.c"
		}
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp80_ = uri_extension;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		if (g_strcmp0 (_tmp80_, "") == 0) {
#line 967 "rygel-http-item-uri.c"
			RygelMediaFileItem* _tmp81_ = NULL;
			const gchar* _tmp82_ = NULL;
			const gchar* _tmp83_ = NULL;
			gchar* _tmp84_ = NULL;
			gchar* _tmp85_ = NULL;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp81_ = item;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp82_ = rygel_media_file_item_get_mime_type (_tmp81_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp83_ = _tmp82_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp84_ = rygel_http_item_uri_ext_from_mime_type (self, _tmp83_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp85_ = _tmp84_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			rygel_http_item_uri_set_extension (self, _tmp85_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_free0 (_tmp85_);
#line 987 "rygel-http-item-uri.c"
		} else {
			const gchar* _tmp86_ = NULL;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp86_ = uri_extension;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			rygel_http_item_uri_set_extension (self, _tmp86_);
#line 994 "rygel-http-item-uri.c"
		}
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_g_free0 (uri_extension);
#line 998 "rygel-http-item-uri.c"
	}
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_object_unref0 (item);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return self;
#line 1004 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* resource_name) {
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, object, http_server, thumbnail_index, subtitle_index, resource_name);
#line 1011 "rygel-http-item-uri.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1307 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1308 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1308 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1308 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1308 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1308 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1309 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1309 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1310 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1310 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1310 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1310 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1310 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1311 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1311 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1311 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1311 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 1066 "rygel-http-item-uri.c"
	}
#line 1311 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1311 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1072 "rygel-http-item-uri.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1085 "rygel-http-item-uri.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1116 "rygel-http-item-uri.c"
				goto __catch42_g_regex_error;
			}
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1125 "rygel-http-item-uri.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1141 "rygel-http-item-uri.c"
				goto __catch42_g_regex_error;
			}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 1152 "rygel-http-item-uri.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1166 "rygel-http-item-uri.c"
	}
	goto __finally42;
	__catch42_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1180 "rygel-http-item-uri.c"
	}
	__finally42:
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 1191 "rygel-http-item-uri.c"
	}
}


static gchar* rygel_http_item_uri_base64_urlencode (RygelHTTPItemURI* self, const gchar* data) {
	gchar* result = NULL;
	gchar* enc64 = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = data;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp3_ = (guchar*) _tmp2_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guchar);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp4_ = g_base64_encode (_tmp3_, (_tmp1_ * sizeof (gchar)) / sizeof (guchar));
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp5_ = _tmp4_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	enc64 = _tmp5_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp6_ = enc64;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp7_ = string_replace (_tmp6_, "/", "_");
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (enc64);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	enc64 = _tmp7_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp8_ = enc64;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp9_ = string_replace (_tmp8_, "+", "-");
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp9_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (enc64);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 1248 "rygel-http-item-uri.c"
}


static guchar* rygel_http_item_uri_base64_urldecode (RygelHTTPItemURI* self, const gchar* data, int* result_length1) {
	guchar* result = NULL;
	gchar* dec64 = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	size_t _tmp5_;
	guchar* _tmp6_ = NULL;
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = data;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp1_ = string_replace (_tmp0_, "_", "/");
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	dec64 = _tmp1_;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp2_ = dec64;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp3_ = string_replace (_tmp2_, "-", "+");
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (dec64);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	dec64 = _tmp3_;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp4_ = dec64;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp6_ = g_base64_decode (_tmp4_, &_tmp5_);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp7_ = _tmp6_;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp7__length1 = _tmp5_;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (result_length1) {
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		*result_length1 = _tmp7__length1;
#line 1294 "rygel-http-item-uri.c"
	}
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp7_;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (dec64);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 1302 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	RygelHTTPItemURI * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	gchar* request_uri = NULL;
	const gchar* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** parts = NULL;
	const gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gchar* last_part = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gint dot_index = 0;
	const gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	const gchar* _tmp68_ = NULL;
	GError * _inner_error_ = NULL;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_thumbnail_index (self, -1);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_subtitle_index (self, -1);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = http_server;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_http_server (self, _tmp0_);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_extension (self, "");
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp1_ = uri;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp2_ = http_server;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp3_ = rygel_http_server_get_path_root (_tmp2_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp4_ = _tmp3_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp5_ = string_replace (_tmp1_, _tmp4_, "");
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	request_uri = _tmp5_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp6_ = request_uri;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "/", 0);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	parts = _tmp8_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	parts_length1 = _vala_array_length (_tmp7_);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_parts_size_ = parts_length1;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp10_ = parts;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp10__length1 = parts_length1;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (_tmp10__length1 < 2) {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp9_ = TRUE;
#line 1383 "rygel-http-item-uri.c"
	} else {
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp11_ = parts;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp11__length1 = parts_length1;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp9_ = (_tmp11__length1 % 2) == 0;
#line 1393 "rygel-http-item-uri.c"
	}
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (_tmp9_) {
#line 1397 "rygel-http-item-uri.c"
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp12_ = _ ("Invalid URI '%s'");
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp13_ = request_uri;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp14_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _tmp12_, _tmp13_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_inner_error_ = _tmp14_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			g_propagate_error (error, _inner_error_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_object_unref0 (self);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			return NULL;
#line 1421 "rygel-http-item-uri.c"
		} else {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			g_clear_error (&_inner_error_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			return NULL;
#line 1433 "rygel-http-item-uri.c"
		}
	}
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp15_ = parts;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp15__length1 = parts_length1;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp16_ = parts;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp16__length1 = parts_length1;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp17_ = _tmp15_[_tmp16__length1 - 1];
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	last_part = _tmp18_;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp19_ = last_part;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp20_ = string_last_index_of (_tmp19_, ".", 0);
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	dot_index = _tmp20_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp21_ = dot_index;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (_tmp21_ > (-1)) {
#line 1460 "rygel-http-item-uri.c"
		const gchar* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		const gchar* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp22_ = last_part;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp23_ = dot_index;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp24_ = string_substring (_tmp22_, (glong) (_tmp23_ + 1), (glong) (-1));
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp25_ = _tmp24_;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_extension (self, _tmp25_);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_g_free0 (_tmp25_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp26_ = parts;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp26__length1 = parts_length1;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp27_ = parts;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp27__length1 = parts_length1;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp28_ = last_part;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp29_ = dot_index;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp30_ = string_substring (_tmp28_, (glong) 0, (glong) _tmp29_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_g_free0 (_tmp26_[_tmp27__length1 - 1]);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp26_[_tmp27__length1 - 1] = _tmp30_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp31_ = _tmp26_[_tmp27__length1 - 1];
#line 1505 "rygel-http-item-uri.c"
	}
	{
		gint i = 0;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		i = 1;
#line 1511 "rygel-http-item-uri.c"
		{
			gboolean _tmp32_ = FALSE;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp32_ = TRUE;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			while (TRUE) {
#line 1518 "rygel-http-item-uri.c"
				gint _tmp34_ = 0;
				gchar** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gchar** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gint _tmp37_ = 0;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				GQuark _tmp41_ = 0U;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				static GQuark _tmp40_label0 = 0;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				static GQuark _tmp40_label1 = 0;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				static GQuark _tmp40_label2 = 0;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				static GQuark _tmp40_label3 = 0;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				if (!_tmp32_) {
#line 1538 "rygel-http-item-uri.c"
					gint _tmp33_ = 0;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp33_ = i;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					i = _tmp33_ + 2;
#line 1544 "rygel-http-item-uri.c"
				}
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp32_ = FALSE;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp34_ = i;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp35_ = parts;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp35__length1 = parts_length1;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				if (!(_tmp34_ < (_tmp35__length1 - 1))) {
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					break;
#line 1558 "rygel-http-item-uri.c"
				}
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp36_ = parts;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp36__length1 = parts_length1;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp37_ = i;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp38_ = _tmp36_[_tmp37_];
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp39_ = _tmp38_;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp41_ = (NULL == _tmp39_) ? 0 : g_quark_from_string (_tmp39_);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				if (_tmp41_ == ((0 != _tmp40_label0) ? _tmp40_label0 : (_tmp40_label0 = g_quark_from_static_string ("i")))) {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					switch (0) {
#line 1576 "rygel-http-item-uri.c"
						default:
						{
							guchar* data = NULL;
							gchar** _tmp42_ = NULL;
							gint _tmp42__length1 = 0;
							gint _tmp43_ = 0;
							const gchar* _tmp44_ = NULL;
							gchar* _tmp45_ = NULL;
							gchar* _tmp46_ = NULL;
							gint _tmp47_ = 0;
							guchar* _tmp48_ = NULL;
							guchar* _tmp49_ = NULL;
							gint _tmp49__length1 = 0;
							gint data_length1 = 0;
							gint _data_size_ = 0;
							GString* builder = NULL;
							GString* _tmp50_ = NULL;
							GString* _tmp51_ = NULL;
							guchar* _tmp52_ = NULL;
							gint _tmp52__length1 = 0;
							GString* _tmp53_ = NULL;
							const gchar* _tmp54_ = NULL;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp42_ = parts;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp42__length1 = parts_length1;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp43_ = i;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp44_ = _tmp42_[_tmp43_ + 1];
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp45_ = soup_uri_decode (_tmp44_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp46_ = _tmp45_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp48_ = rygel_http_item_uri_base64_urldecode (self, _tmp46_, &_tmp47_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp49_ = _tmp48_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp49__length1 = _tmp47_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_g_free0 (_tmp46_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							data = _tmp49_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							data_length1 = _tmp49__length1;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_data_size_ = data_length1;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp50_ = g_string_new ("");
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							builder = _tmp50_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp51_ = builder;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp52_ = data;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp52__length1 = data_length1;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							g_string_append (_tmp51_, (const gchar*) _tmp52_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp53_ = builder;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp54_ = _tmp53_->str;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							rygel_http_item_uri_set_item_id (self, _tmp54_);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_g_string_free0 (builder);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							data = (g_free (data), NULL);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							break;
#line 1649 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp41_ == ((0 != _tmp40_label1) ? _tmp40_label1 : (_tmp40_label1 = g_quark_from_static_string ("th")))) {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					switch (0) {
#line 1655 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp55_ = NULL;
							gint _tmp55__length1 = 0;
							gint _tmp56_ = 0;
							const gchar* _tmp57_ = NULL;
							gint _tmp58_ = 0;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp55_ = parts;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp55__length1 = parts_length1;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp56_ = i;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp57_ = _tmp55_[_tmp56_ + 1];
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp58_ = atoi (_tmp57_);
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							rygel_http_item_uri_set_thumbnail_index (self, _tmp58_);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							break;
#line 1677 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp41_ == ((0 != _tmp40_label2) ? _tmp40_label2 : (_tmp40_label2 = g_quark_from_static_string ("sub")))) {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					switch (0) {
#line 1683 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp59_ = NULL;
							gint _tmp59__length1 = 0;
							gint _tmp60_ = 0;
							const gchar* _tmp61_ = NULL;
							gint _tmp62_ = 0;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp59_ = parts;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp59__length1 = parts_length1;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp60_ = i;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp61_ = _tmp59_[_tmp60_ + 1];
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp62_ = atoi (_tmp61_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							rygel_http_item_uri_set_subtitle_index (self, _tmp62_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							break;
#line 1705 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp41_ == ((0 != _tmp40_label3) ? _tmp40_label3 : (_tmp40_label3 = g_quark_from_static_string ("res")))) {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					switch (0) {
#line 1711 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp63_ = NULL;
							gint _tmp63__length1 = 0;
							gint _tmp64_ = 0;
							const gchar* _tmp65_ = NULL;
							gchar* _tmp66_ = NULL;
							gchar* _tmp67_ = NULL;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp63_ = parts;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp63__length1 = parts_length1;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp64_ = i;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp65_ = _tmp63_[_tmp64_ + 1];
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp66_ = soup_uri_decode (_tmp65_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_tmp67_ = _tmp66_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							rygel_http_item_uri_set_resource_name (self, _tmp67_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							_g_free0 (_tmp67_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							break;
#line 1738 "rygel-http-item-uri.c"
						}
					}
				} else {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					switch (0) {
#line 1744 "rygel-http-item-uri.c"
						default:
						{
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
							break;
#line 1749 "rygel-http-item-uri.c"
						}
					}
				}
			}
		}
	}
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp68_ = self->priv->_item_id;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (_tmp68_ == NULL) {
#line 1760 "rygel-http-item-uri.c"
		const gchar* _tmp69_ = NULL;
		GError* _tmp70_ = NULL;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp69_ = _ ("Not found");
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp70_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp69_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_inner_error_ = _tmp70_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_free0 (last_part);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_object_unref0 (self);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			return NULL;
#line 1783 "rygel-http-item-uri.c"
		} else {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_free0 (last_part);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			g_clear_error (&_inner_error_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			return NULL;
#line 1797 "rygel-http-item-uri.c"
		}
	}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (last_part);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (request_uri);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return self;
#line 1808 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error) {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
#line 1815 "rygel-http-item-uri.c"
}


gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
	gchar* result = NULL;
	gchar* data = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* escaped = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_item_id;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp1_ = rygel_http_item_uri_base64_urlencode (self, _tmp0_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	data = _tmp1_;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp2_ = data;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp3_ = g_uri_escape_string (_tmp2_, "", TRUE);
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	escaped = _tmp3_;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp4_ = escaped;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp5_ = g_strconcat ("/i/", _tmp4_, NULL);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	path = _tmp5_;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp6_ = self->priv->_thumbnail_index;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (_tmp6_ >= 0) {
#line 1862 "rygel-http-item-uri.c"
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp7_ = path;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp8_ = self->priv->_thumbnail_index;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp10_ = _tmp9_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp11_ = g_strconcat ("/th/", _tmp10_, NULL);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp12_ = _tmp11_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp13_ = g_strconcat (_tmp7_, _tmp12_, NULL);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_g_free0 (path);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		path = _tmp13_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_g_free0 (_tmp12_);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_g_free0 (_tmp10_);
#line 1892 "rygel-http-item-uri.c"
	} else {
		gint _tmp14_ = 0;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp14_ = self->priv->_subtitle_index;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		if (_tmp14_ >= 0) {
#line 1899 "rygel-http-item-uri.c"
			const gchar* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp15_ = path;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp16_ = self->priv->_subtitle_index;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp17_ = g_strdup_printf ("%i", _tmp16_);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp18_ = _tmp17_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp19_ = g_strconcat ("/sub/", _tmp18_, NULL);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp20_ = _tmp19_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp21_ = g_strconcat (_tmp15_, _tmp20_, NULL);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_free0 (path);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			path = _tmp21_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_free0 (_tmp20_);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_g_free0 (_tmp18_);
#line 1929 "rygel-http-item-uri.c"
		} else {
			const gchar* _tmp22_ = NULL;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			_tmp22_ = self->priv->_resource_name;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			if (_tmp22_ != NULL) {
#line 1936 "rygel-http-item-uri.c"
				const gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp23_ = path;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp24_ = self->priv->_resource_name;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp25_ = g_uri_escape_string (_tmp24_, "", TRUE);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp26_ = _tmp25_;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp27_ = g_strconcat ("/res/", _tmp26_, NULL);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp28_ = _tmp27_;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp29_ = g_strconcat (_tmp23_, _tmp28_, NULL);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_g_free0 (path);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				path = _tmp29_;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_g_free0 (_tmp28_);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_g_free0 (_tmp26_);
#line 1966 "rygel-http-item-uri.c"
			}
		}
	}
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp30_ = path;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp31_ = rygel_http_item_uri_get_extension (self);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp32_ = _tmp31_;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp33_ = _tmp32_;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp34_ = g_strconcat (_tmp30_, _tmp33_, NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (path);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	path = _tmp34_;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (_tmp33_);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp35_ = path;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp36_ = rygel_http_item_uri_create_uri_for_path (self, _tmp35_);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp36_;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (path);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (escaped);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (data);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 2000 "rygel-http-item-uri.c"
}


static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path) {
	gchar* result = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelHTTPServer* _tmp4_ = NULL;
	GUPnPContext* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	RygelHTTPServer* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_http_server;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp1_ = _tmp0_->context;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp2_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp1_);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp3_ = _tmp2_;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp4_ = self->priv->_http_server;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp5_ = _tmp4_->context;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp6_ = gupnp_context_get_port (_tmp5_);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp7_ = _tmp6_;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp8_ = self->priv->_http_server;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp9_ = rygel_http_server_get_path_root (_tmp8_);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp10_ = _tmp9_;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp11_ = path;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp12_ = g_strdup_printf ("http://%s:%u%s%s", _tmp3_, _tmp7_, _tmp10_, _tmp11_);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp12_;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 2053 "rygel-http-item-uri.c"
}


static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type) {
	gchar* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	gchar* _tmp35_ = NULL;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = rygel_http_item_uri_mime_to_ext;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (_tmp0_ == NULL) {
#line 2072 "rygel-http-item-uri.c"
		GeeHashMap* _tmp1_ = NULL;
		gchar** videos = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gint videos_length1 = 0;
		gint _videos_size_ = 0;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		GeeHashMap* _tmp13_ = NULL;
		GeeHashMap* _tmp14_ = NULL;
		GeeHashMap* _tmp15_ = NULL;
		gchar** images = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gint images_length1 = 0;
		gint _images_size_ = 0;
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		GeeHashMap* _tmp26_ = NULL;
		GeeHashMap* _tmp27_ = NULL;
		GeeHashMap* _tmp28_ = NULL;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_g_object_unref0 (rygel_http_item_uri_mime_to_ext);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		rygel_http_item_uri_mime_to_ext = _tmp1_;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp2_ = g_strdup ("mpeg");
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp3_ = g_strdup ("webm");
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp4_ = g_strdup ("ogg");
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp5_ = g_new0 (gchar*, 3 + 1);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp5_[0] = _tmp2_;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp5_[1] = _tmp3_;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp5_[2] = _tmp4_;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		videos = _tmp5_;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		videos_length1 = 3;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_videos_size_ = videos_length1;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp6_ = videos;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp6__length1 = videos_length1;
#line 2127 "rygel-http-item-uri.c"
		{
			gchar** video_collection = NULL;
			gint video_collection_length1 = 0;
			gint _video_collection_size_ = 0;
			gint video_it = 0;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			video_collection = _tmp6_;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			video_collection_length1 = _tmp6__length1;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			for (video_it = 0; video_it < _tmp6__length1; video_it = video_it + 1) {
#line 2139 "rygel-http-item-uri.c"
				gchar* _tmp7_ = NULL;
				gchar* video = NULL;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp7_ = g_strdup (video_collection[video_it]);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				video = _tmp7_;
#line 2146 "rygel-http-item-uri.c"
				{
					GeeHashMap* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp8_ = rygel_http_item_uri_mime_to_ext;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp9_ = video;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp10_ = g_strconcat ("video/", _tmp9_, NULL);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp11_ = _tmp10_;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp12_ = video;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_g_free0 (_tmp11_);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_g_free0 (video);
#line 2169 "rygel-http-item-uri.c"
				}
			}
		}
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp13_ = rygel_http_item_uri_mime_to_ext;
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "video/x-matroska", "mkv");
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp14_ = rygel_http_item_uri_mime_to_ext;
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "audio/x-wav", "wav");
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp15_ = rygel_http_item_uri_mime_to_ext;
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "audio/x-matroska", "mka");
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp16_ = g_strdup ("jpeg");
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp17_ = g_strdup ("png");
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp18_ = g_new0 (gchar*, 2 + 1);
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp18_[0] = _tmp16_;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp18_[1] = _tmp17_;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		images = _tmp18_;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		images_length1 = 2;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_images_size_ = images_length1;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp19_ = images;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp19__length1 = images_length1;
#line 2205 "rygel-http-item-uri.c"
		{
			gchar** image_collection = NULL;
			gint image_collection_length1 = 0;
			gint _image_collection_size_ = 0;
			gint image_it = 0;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			image_collection = _tmp19_;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			image_collection_length1 = _tmp19__length1;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
			for (image_it = 0; image_it < _tmp19__length1; image_it = image_it + 1) {
#line 2217 "rygel-http-item-uri.c"
				gchar* _tmp20_ = NULL;
				gchar* image = NULL;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				_tmp20_ = g_strdup (image_collection[image_it]);
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
				image = _tmp20_;
#line 2224 "rygel-http-item-uri.c"
				{
					GeeHashMap* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp21_ = rygel_http_item_uri_mime_to_ext;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp22_ = image;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp23_ = g_strconcat ("image/", _tmp22_, NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp24_ = _tmp23_;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_tmp25_ = image;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp24_, _tmp25_);
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_g_free0 (_tmp24_);
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
					_g_free0 (image);
#line 2247 "rygel-http-item-uri.c"
				}
			}
		}
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp26_ = rygel_http_item_uri_mime_to_ext;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, "text/srt", "srt");
#line 249 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp27_ = rygel_http_item_uri_mime_to_ext;
#line 249 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "text/xml", "xml");
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp28_ = rygel_http_item_uri_mime_to_ext;
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, "application/ogg", "ogg");
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		images = (_vala_array_free (images, images_length1, (GDestroyNotify) g_free), NULL);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
#line 2267 "rygel-http-item-uri.c"
	}
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp29_ = rygel_http_item_uri_mime_to_ext;
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp30_ = mime_type;
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp31_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp29_, _tmp30_);
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (_tmp31_) {
#line 2277 "rygel-http-item-uri.c"
		GeeHashMap* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gpointer _tmp34_ = NULL;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp32_ = rygel_http_item_uri_mime_to_ext;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp33_ = mime_type;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp33_);
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		result = (gchar*) _tmp34_;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		return result;
#line 2291 "rygel-http-item-uri.c"
	}
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp35_ = g_strdup ("");
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp35_;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 2299 "rygel-http-item-uri.c"
}


const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_item_id;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 2314 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_item_id (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (self->priv->_item_id);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self->priv->_item_id = _tmp1_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "item-id");
#line 2333 "rygel-http-item-uri.c"
}


gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self) {
	gint result;
	gint _tmp0_ = 0;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_thumbnail_index;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp0_;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 2348 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_thumbnail_index (RygelHTTPItemURI* self, gint value) {
	gint _tmp0_ = 0;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self->priv->_thumbnail_index = _tmp0_;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "thumbnail-index");
#line 2362 "rygel-http-item-uri.c"
}


gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self) {
	gint result;
	gint _tmp0_ = 0;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_subtitle_index;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 2377 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_subtitle_index (RygelHTTPItemURI* self, gint value) {
	gint _tmp0_ = 0;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self->priv->_subtitle_index = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "subtitle-index");
#line 2391 "rygel-http-item-uri.c"
}


const gchar* rygel_http_item_uri_get_resource_name (RygelHTTPItemURI* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_resource_name;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 2406 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_resource_name (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (self->priv->_resource_name);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self->priv->_resource_name = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "resource-name");
#line 2425 "rygel-http-item-uri.c"
}


RygelHTTPServer* rygel_http_item_uri_get_http_server (RygelHTTPItemURI* self) {
	RygelHTTPServer* result;
	RygelHTTPServer* _tmp0_ = NULL;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->_http_server;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 2440 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_http_server (RygelHTTPItemURI* self, RygelHTTPServer* value) {
	RygelHTTPServer* _tmp0_ = NULL;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self->priv->_http_server = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "http-server");
#line 2454 "rygel-http-item-uri.c"
}


gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp3_ = NULL;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->real_extension;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	if (g_strcmp0 (_tmp0_, "") != 0) {
#line 2468 "rygel-http-item-uri.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp1_ = self->priv->real_extension;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		_tmp2_ = g_strconcat (".", _tmp1_, NULL);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		result = _tmp2_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		return result;
#line 2479 "rygel-http-item-uri.c"
	}
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp3_ = g_strdup ("");
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	result = _tmp3_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	return result;
#line 2487 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (self->priv->real_extension);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self->priv->real_extension = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "extension");
#line 2506 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURIPrivate));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_item_uri_get_property;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_item_uri_set_property;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_ITEM_ID, g_param_spec_string ("item-id", "item-id", "item-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX, g_param_spec_int ("thumbnail-index", "thumbnail-index", "thumbnail-index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX, g_param_spec_int ("subtitle-index", "subtitle-index", "subtitle-index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_RESOURCE_NAME, g_param_spec_string ("resource-name", "resource-name", "resource-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_HTTP_SERVER, g_param_spec_object ("http-server", "http-server", "http-server", RYGEL_TYPE_HTTP_SERVER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2533 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self->priv = RYGEL_HTTP_ITEM_URI_GET_PRIVATE (self);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self->priv->_thumbnail_index = -1;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self->priv->_subtitle_index = -1;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self->priv->_resource_name = NULL;
#line 2546 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (self->priv->_item_id);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (self->priv->_resource_name);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	_g_free0 (self->priv->real_extension);
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
#line 2562 "rygel-http-item-uri.c"
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_ITEM_ID:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		g_value_set_string (value, rygel_http_item_uri_get_item_id (self));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		g_value_set_int (value, rygel_http_item_uri_get_thumbnail_index (self));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		g_value_set_int (value, rygel_http_item_uri_get_subtitle_index (self));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_RESOURCE_NAME:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		g_value_set_string (value, rygel_http_item_uri_get_resource_name (self));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_HTTP_SERVER:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		g_value_set_object (value, rygel_http_item_uri_get_http_server (self));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		g_value_take_string (value, rygel_http_item_uri_get_extension (self));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 2619 "rygel-http-item-uri.c"
		default:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 2625 "rygel-http-item-uri.c"
	}
}


static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_ITEM_ID:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_item_id (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_thumbnail_index (self, g_value_get_int (value));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_subtitle_index (self, g_value_get_int (value));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_RESOURCE_NAME:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_resource_name (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_HTTP_SERVER:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_http_server (self, g_value_get_object (value));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_extension (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 2671 "rygel-http-item-uri.c"
		default:
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/src/librygel-server/rygel-http-item-uri.vala"
		break;
#line 2677 "rygel-http-item-uri.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



