/* rygel-rendering-control.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-rendering-control.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_RENDERING_CONTROL (rygel_rendering_control_get_type ())
#define RYGEL_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl))
#define RYGEL_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))
#define RYGEL_IS_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_IS_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_RENDERING_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))

typedef struct _RygelRenderingControl RygelRenderingControl;
typedef struct _RygelRenderingControlClass RygelRenderingControlClass;
typedef struct _RygelRenderingControlPrivate RygelRenderingControlPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;

struct _RygelRenderingControl {
	GUPnPService parent_instance;
	RygelRenderingControlPrivate * priv;
};

struct _RygelRenderingControlClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gboolean (*seek_bytes) (RygelMediaPlayer* self, gint64 bytes);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_size) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gboolean (*get_can_seek_bytes) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
	gint64 (*get_byte_position) (RygelMediaPlayer* self);
};

struct _RygelRenderingControlPrivate {
	gboolean _mute;
	guint _volume;
	gchar* preset_name_list;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
};


static gpointer rygel_rendering_control_parent_class = NULL;

GType rygel_rendering_control_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_RENDERING_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlPrivate))
enum  {
	RYGEL_RENDERING_CONTROL_DUMMY_PROPERTY,
	RYGEL_RENDERING_CONTROL_MUTE,
	RYGEL_RENDERING_CONTROL_VOLUME
};
#define RYGEL_RENDERING_CONTROL_UPNP_ID "urn:upnp-org:serviceId:RenderingControl"
#define RYGEL_RENDERING_CONTROL_UPNP_TYPE "urn:schemas-upnp-org:service:RenderingControl:2"
#define RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH "xml/RenderingControl2.xml"
#define RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/RCS/"
static void rygel_rendering_control_real_constructed (GObject* base);
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
static RygelMediaPlayer* rygel_rendering_control_get_player (RygelRenderingControl* self);
static void rygel_rendering_control_query_last_change_cb (RygelRenderingControl* self, GUPnPService* service, const gchar* variable, GValue* value);
static void _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_rendering_control_list_presets_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_select_preset_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_get_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_set_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_get_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_set_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_rendering_control_notify_volume_cb (RygelRenderingControl* self, GObject* player, GParamSpec* p);
static void _rygel_rendering_control_notify_volume_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gdouble rygel_media_player_get_volume (RygelMediaPlayer* self);
guint rygel_volume_to_percentage (gdouble volume);
gboolean rygel_rendering_control_get_mute (RygelRenderingControl* self);
void rygel_change_log_log_with_channel (RygelChangeLog* self, const gchar* variable, const gchar* value, const gchar* channel);
guint rygel_rendering_control_get_volume (RygelRenderingControl* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
static gboolean rygel_rendering_control_check_instance_id (RygelRenderingControl* self, GUPnPServiceAction* action);
static gboolean rygel_rendering_control_check_channel (RygelRenderingControl* self, GUPnPServiceAction* action);
void rygel_rendering_control_set_mute (RygelRenderingControl* self, gboolean value);
void rygel_rendering_control_set_volume (RygelRenderingControl* self, guint value);
RygelRenderingControl* rygel_rendering_control_new (void);
RygelRenderingControl* rygel_rendering_control_construct (GType object_type);
void rygel_media_player_set_volume (RygelMediaPlayer* self, gdouble value);
gdouble rygel_volume_from_percentage (guint percentage);
static void rygel_rendering_control_finalize (GObject* obj);
static void _vala_rygel_rendering_control_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_rendering_control_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_query_last_change_cb ((RygelRenderingControl*) self, _sender, variable, value);
#line 186 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 88 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_list_presets_cb ((RygelRenderingControl*) self, _sender, action);
#line 193 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_select_preset_cb ((RygelRenderingControl*) self, _sender, action);
#line 200 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_get_mute_cb ((RygelRenderingControl*) self, _sender, action);
#line 207 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_set_mute_cb ((RygelRenderingControl*) self, _sender, action);
#line 214 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_get_volume_cb ((RygelRenderingControl*) self, _sender, action);
#line 221 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_set_volume_cb ((RygelRenderingControl*) self, _sender, action);
#line 228 "rygel-rendering-control.c"
}


static void _rygel_rendering_control_notify_volume_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_notify_volume_cb ((RygelRenderingControl*) self, _sender, pspec);
#line 235 "rygel-rendering-control.c"
}


static void rygel_rendering_control_real_constructed (GObject* base) {
	RygelRenderingControl * self;
	RygelChangeLog* _tmp0_ = NULL;
	RygelMediaPlayer* _tmp1_ = NULL;
	RygelMediaPlayer* _tmp2_ = NULL;
	RygelMediaPlayer* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	RygelMediaPlayer* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	guint _tmp9_ = 0U;
#line 80 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self = (RygelRenderingControl*) base;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	G_OBJECT_CLASS (rygel_rendering_control_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS);
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_object_unref0 (self->priv->changelog);
#line 83 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv->changelog = _tmp0_;
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_get_player (self);
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_object_unref0 (self->priv->player);
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv->player = _tmp1_;
#line 86 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_rendering_control_query_last_change_cb_gupnp_service_query_variable, self, 0);
#line 88 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ListPresets", (GCallback) _rygel_rendering_control_list_presets_cb_gupnp_service_action_invoked, self, 0);
#line 89 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SelectPreset", (GCallback) _rygel_rendering_control_select_preset_cb_gupnp_service_action_invoked, self, 0);
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMute", (GCallback) _rygel_rendering_control_get_mute_cb_gupnp_service_action_invoked, self, 0);
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetMute", (GCallback) _rygel_rendering_control_set_mute_cb_gupnp_service_action_invoked, self, 0);
#line 92 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetVolume", (GCallback) _rygel_rendering_control_get_volume_cb_gupnp_service_action_invoked, self, 0);
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetVolume", (GCallback) _rygel_rendering_control_set_volume_cb_gupnp_service_action_invoked, self, 0);
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = self->priv->player;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_signal_connect_object ((GObject*) _tmp2_, "notify::volume", (GCallback) _rygel_rendering_control_notify_volume_cb_g_object_notify, self, 0);
#line 97 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp3_ = self->priv->player;
#line 97 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp4_ = rygel_media_player_get_volume (_tmp3_);
#line 97 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp5_ = _tmp4_;
#line 97 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv->_mute = _tmp5_ == ((gdouble) 0);
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp6_ = self->priv->player;
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp7_ = rygel_media_player_get_volume (_tmp6_);
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp8_ = _tmp7_;
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp9_ = rygel_volume_to_percentage (_tmp8_);
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv->_volume = _tmp9_;
#line 303 "rygel-rendering-control.c"
}


static void rygel_rendering_control_query_last_change_cb (RygelRenderingControl* self, GUPnPService* service, const gchar* variable, GValue* value) {
	RygelChangeLog* log = NULL;
	RygelChangeLog* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	RygelChangeLog* _tmp4_ = NULL;
	RygelChangeLog* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	RygelChangeLog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	RygelChangeLog* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (variable != NULL);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (value != NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_RENDERING_CONTROL_LAST_CHANGE_NS);
#line 105 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	log = _tmp0_;
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = rygel_rendering_control_get_mute (self);
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp3_ = _tmp2_;
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp3_) {
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp1_ = "1";
#line 344 "rygel-rendering-control.c"
	} else {
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp1_ = "0";
#line 348 "rygel-rendering-control.c"
	}
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp4_ = log;
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (_tmp4_, "Mute", _tmp1_, "Master");
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp5_ = log;
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp6_ = rygel_rendering_control_get_volume (self);
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp7_ = _tmp6_;
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp8_ = g_strdup_printf ("%u", _tmp7_);
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp9_ = _tmp8_;
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (_tmp5_, "Volume", _tmp9_, "Master");
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_free0 (_tmp9_);
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp10_ = log;
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp11_ = self->priv->preset_name_list;
#line 109 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (_tmp10_, "PresetNameList", _tmp11_, "Master");
#line 113 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_value_init (value, G_TYPE_STRING);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp12_ = log;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp13_ = rygel_change_log_finish (_tmp12_);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp14_ = _tmp13_;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_value_set_string (value, _tmp14_);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_free0 (_tmp14_);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_object_unref0 (log);
#line 388 "rygel-rendering-control.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	return self ? g_object_ref (self) : NULL;
#line 395 "rygel-rendering-control.c"
}


static RygelMediaPlayer* rygel_rendering_control_get_player (RygelRenderingControl* self) {
	RygelMediaPlayer* result = NULL;
	RygelMediaRendererPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	RygelMediaRendererPlugin* _tmp5_ = NULL;
	RygelMediaRendererPlugin* _tmp6_ = NULL;
	RygelMediaPlayer* _tmp7_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = _tmp0_;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = _tmp1_;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp4_ = _tmp3_;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp6_ = _tmp5_;
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_object_unref0 (_tmp2_);
#line 118 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	plugin = _tmp6_;
#line 120 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp7_ = rygel_media_renderer_plugin_get_player (plugin);
#line 120 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	result = _tmp7_;
#line 120 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_object_unref0 (plugin);
#line 120 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	return result;
#line 438 "rygel-rendering-control.c"
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	endptr = _tmp1_;
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_vala_result = _tmp2_;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = endptr;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4_ = str;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = str;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp6_ = strlen (_tmp5_);
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7_ = _tmp6_;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = TRUE;
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_result_) {
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 482 "rygel-rendering-control.c"
		}
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 486 "rygel-rendering-control.c"
	} else {
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = FALSE;
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_result_) {
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 494 "rygel-rendering-control.c"
		}
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 498 "rygel-rendering-control.c"
	}
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_result_) {
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*_result_ = _vala_result;
#line 504 "rygel-rendering-control.c"
	}
}


static gboolean rygel_rendering_control_check_instance_id (RygelRenderingControl* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	gchar* instance_id_string = NULL;
	gint64 instance_id = 0LL;
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gint64 _tmp8_ = 0LL;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	instance_id = (gint64) (-1);
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 128 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp0_, "InstanceID", G_TYPE_STRING, &instance_id_string, NULL);
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = instance_id_string;
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp2_ == NULL) {
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp1_ = TRUE;
#line 533 "rygel-rendering-control.c"
	} else {
		const gchar* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		gboolean _tmp5_ = FALSE;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp3_ = instance_id_string;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_);
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		instance_id = _tmp4_;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp1_ = !_tmp5_;
#line 546 "rygel-rendering-control.c"
	}
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp1_) {
#line 550 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp6_ = action;
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp7_ = _ ("Invalid argument");
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp6_, (guint) 402, _tmp7_);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		result = FALSE;
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_g_free0 (instance_id_string);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return result;
#line 565 "rygel-rendering-control.c"
	}
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp8_ = instance_id;
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp8_ != ((gint64) 0)) {
#line 571 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp9_ = action;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp10_ = _ ("Invalid InstanceID");
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp9_, (guint) 702, _tmp10_);
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		result = FALSE;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_g_free0 (instance_id_string);
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return result;
#line 586 "rygel-rendering-control.c"
	}
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	result = TRUE;
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_free0 (instance_id_string);
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	return result;
#line 594 "rygel-rendering-control.c"
}


static void rygel_rendering_control_list_presets_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 145 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 618 "rygel-rendering-control.c"
	}
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp3_ = self->priv->preset_name_list;
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_set (_tmp2_, "CurrentPresetNameList", G_TYPE_STRING, _tmp3_, NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp4_ = action;
#line 155 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp4_);
#line 630 "rygel-rendering-control.c"
}


static void rygel_rendering_control_select_preset_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* preset_name = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 655 "rygel-rendering-control.c"
	}
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp2_, "PresetName", G_TYPE_STRING, &preset_name, NULL);
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp3_ = preset_name;
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (g_strcmp0 (_tmp3_, "") != 0) {
#line 665 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp4_ = action;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp5_ = _ ("Invalid Name");
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp4_, (guint) 701, _tmp5_);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_g_free0 (preset_name);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 678 "rygel-rendering-control.c"
	}
#line 173 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp6_ = action;
#line 173 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp6_);
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_free0 (preset_name);
#line 686 "rygel-rendering-control.c"
}


static gboolean rygel_rendering_control_check_channel (RygelRenderingControl* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	gchar* channel = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 177 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 180 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 180 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp0_, "Channel", G_TYPE_STRING, &channel, NULL);
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = channel;
#line 181 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (g_strcmp0 (_tmp1_, "Master") != 0) {
#line 707 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp2_ = action;
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp3_ = _ ("Invalid Channel");
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 703, _tmp3_);
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		result = FALSE;
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_g_free0 (channel);
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return result;
#line 722 "rygel-rendering-control.c"
	}
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	result = TRUE;
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_free0 (channel);
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	return result;
#line 730 "rygel-rendering-control.c"
}


static void rygel_rendering_control_get_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GUPnPServiceAction* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GUPnPServiceAction* _tmp7_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 192 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 757 "rygel-rendering-control.c"
	}
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp3_ = rygel_rendering_control_check_channel (self, _tmp2_);
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp3_) {
#line 197 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 767 "rygel-rendering-control.c"
	}
#line 200 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp4_ = action;
#line 200 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp5_ = rygel_rendering_control_get_mute (self);
#line 200 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp6_ = _tmp5_;
#line 200 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_set (_tmp4_, "CurrentMute", G_TYPE_BOOLEAN, _tmp6_, NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp7_ = action;
#line 202 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp7_);
#line 781 "rygel-rendering-control.c"
}


static void rygel_rendering_control_set_mute_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* mute_str = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean mute = FALSE;
	GUPnPServiceAction* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GUPnPServiceAction* _tmp11_ = NULL;
#line 205 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 205 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 207 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 207 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 208 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 812 "rygel-rendering-control.c"
	}
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp3_ = rygel_rendering_control_check_channel (self, _tmp2_);
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp3_) {
#line 212 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 822 "rygel-rendering-control.c"
	}
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp4_ = action;
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp4_, "DesiredMute", G_TYPE_STRING, &mute_str, NULL);
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp5_ = mute_str;
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp6_ = g_str_has_prefix (_tmp5_, "-");
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp6_) {
#line 834 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 218 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp7_ = action;
#line 218 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp8_ = _ ("Action Failed");
#line 218 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp7_, (guint) 501, _tmp8_);
#line 220 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_g_free0 (mute_str);
#line 220 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 847 "rygel-rendering-control.c"
	}
#line 225 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp9_ = action;
#line 225 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp9_, "DesiredMute", G_TYPE_BOOLEAN, &mute, NULL);
#line 227 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp10_ = mute;
#line 227 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_set_mute (self, _tmp10_);
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp11_ = action;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp11_);
#line 205 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_free0 (mute_str);
#line 863 "rygel-rendering-control.c"
}


static void rygel_rendering_control_get_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GUPnPServiceAction* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	GUPnPServiceAction* _tmp7_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 232 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 232 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 234 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 234 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 234 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 235 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 890 "rygel-rendering-control.c"
	}
#line 238 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 238 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp3_ = rygel_rendering_control_check_channel (self, _tmp2_);
#line 238 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp3_) {
#line 239 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 900 "rygel-rendering-control.c"
	}
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp4_ = action;
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp5_ = rygel_rendering_control_get_volume (self);
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp6_ = _tmp5_;
#line 242 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_set (_tmp4_, "CurrentVolume", G_TYPE_UINT, _tmp6_, NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp7_ = action;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp7_);
#line 914 "rygel-rendering-control.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 934 "rygel-rendering-control.c"
}


static void rygel_rendering_control_set_volume_cb (RygelRenderingControl* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* volume_str = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	guint volume = 0U;
	GUPnPServiceAction* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	guint _tmp16_ = 0U;
	GUPnPServiceAction* _tmp17_ = NULL;
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (service != NULL);
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (action != NULL);
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = action;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_check_instance_id (self, _tmp0_);
#line 249 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp1_) {
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 967 "rygel-rendering-control.c"
	}
#line 253 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = action;
#line 253 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp3_ = rygel_rendering_control_check_channel (self, _tmp2_);
#line 253 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp3_) {
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 977 "rygel-rendering-control.c"
	}
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp4_ = action;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp4_, "DesiredVolume", G_TYPE_STRING, &volume_str, NULL);
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp6_ = volume_str;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp7_ = string_contains (_tmp6_, ".");
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp7_) {
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp5_ = TRUE;
#line 991 "rygel-rendering-control.c"
	} else {
		const gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp8_ = volume_str;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp9_ = string_contains (_tmp8_, ",");
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp5_ = _tmp9_;
#line 1001 "rygel-rendering-control.c"
	}
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp5_) {
#line 1005 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp10_ = action;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp11_ = _ ("Action Failed");
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp10_, (guint) 501, _tmp11_);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_g_free0 (volume_str);
#line 262 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 1018 "rygel-rendering-control.c"
	}
#line 267 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp12_ = action;
#line 267 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_get (_tmp12_, "DesiredVolume", G_TYPE_UINT, &volume, NULL);
#line 268 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp13_ = volume;
#line 268 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp13_ > ((guint) 100)) {
#line 1028 "rygel-rendering-control.c"
		GUPnPServiceAction* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 269 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp14_ = action;
#line 269 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp15_ = _ ("Action Failed");
#line 269 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		gupnp_service_action_return_error (_tmp14_, (guint) 501, _tmp15_);
#line 271 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_g_free0 (volume_str);
#line 271 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		return;
#line 1041 "rygel-rendering-control.c"
	}
#line 274 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp16_ = volume;
#line 274 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_set_volume (self, _tmp16_);
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp17_ = action;
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	gupnp_service_action_return (_tmp17_);
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_free0 (volume_str);
#line 1053 "rygel-rendering-control.c"
}


static void rygel_rendering_control_notify_volume_cb (RygelRenderingControl* self, GObject* player, GParamSpec* p) {
	RygelMediaPlayer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	guint _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	RygelChangeLog* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (player != NULL);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (p != NULL);
#line 280 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = self->priv->player;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = rygel_media_player_get_volume (_tmp0_);
#line 280 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = _tmp1_;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp3_ = rygel_volume_to_percentage (_tmp2_);
#line 280 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv->_volume = _tmp3_;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp5_ = self->priv->_mute;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp5_) {
#line 1089 "rygel-rendering-control.c"
		RygelMediaPlayer* _tmp6_ = NULL;
		gdouble _tmp7_ = 0.0;
		gdouble _tmp8_ = 0.0;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp6_ = self->priv->player;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp7_ = rygel_media_player_get_volume (_tmp6_);
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp8_ = _tmp7_;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp4_ = _tmp8_ > ((gdouble) 0);
#line 1101 "rygel-rendering-control.c"
	} else {
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp4_ = FALSE;
#line 1105 "rygel-rendering-control.c"
	}
#line 282 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp4_) {
#line 1109 "rygel-rendering-control.c"
		RygelChangeLog* _tmp9_ = NULL;
#line 284 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		self->priv->_mute = FALSE;
#line 285 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp9_ = self->priv->changelog;
#line 285 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		rygel_change_log_log_with_channel (_tmp9_, "Mute", "0", "Master");
#line 1117 "rygel-rendering-control.c"
	}
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp10_ = self->priv->changelog;
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp11_ = rygel_rendering_control_get_volume (self);
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp12_ = _tmp11_;
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp13_ = g_strdup_printf ("%u", _tmp12_);
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp14_ = _tmp13_;
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (_tmp10_, "Volume", _tmp14_, "Master");
#line 290 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_free0 (_tmp14_);
#line 1133 "rygel-rendering-control.c"
}


RygelRenderingControl* rygel_rendering_control_construct (GType object_type) {
	RygelRenderingControl * self = NULL;
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self = (RygelRenderingControl*) g_object_new (object_type, NULL);
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	return self;
#line 1143 "rygel-rendering-control.c"
}


RygelRenderingControl* rygel_rendering_control_new (void) {
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	return rygel_rendering_control_construct (RYGEL_TYPE_RENDERING_CONTROL);
#line 1150 "rygel-rendering-control.c"
}


gboolean rygel_rendering_control_get_mute (RygelRenderingControl* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 37 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = self->priv->_mute;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	return result;
#line 1165 "rygel-rendering-control.c"
}


void rygel_rendering_control_set_mute (RygelRenderingControl* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	RygelChangeLog* _tmp10_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv->_mute = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = self->priv->_mute;
#line 44 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp1_) {
#line 1186 "rygel-rendering-control.c"
		RygelMediaPlayer* _tmp2_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp2_ = self->priv->player;
#line 45 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		rygel_media_player_set_volume (_tmp2_, (gdouble) 0);
#line 1192 "rygel-rendering-control.c"
	} else {
		RygelMediaPlayer* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		gdouble _tmp6_ = 0.0;
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp3_ = self->priv->player;
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp4_ = rygel_rendering_control_get_volume (self);
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp5_ = _tmp4_;
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp6_ = rygel_volume_from_percentage (_tmp5_);
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		rygel_media_player_set_volume (_tmp3_, _tmp6_);
#line 1208 "rygel-rendering-control.c"
	}
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp8_ = rygel_rendering_control_get_mute (self);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp9_ = _tmp8_;
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (_tmp9_) {
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp7_ = "1";
#line 1218 "rygel-rendering-control.c"
	} else {
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp7_ = "0";
#line 1222 "rygel-rendering-control.c"
	}
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp10_ = self->priv->changelog;
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (_tmp10_, "Mute", _tmp7_, "Master");
#line 41 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_object_notify ((GObject *) self, "mute");
#line 1230 "rygel-rendering-control.c"
}


guint rygel_rendering_control_get_volume (RygelRenderingControl* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = self->priv->_volume;
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	result = _tmp0_;
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	return result;
#line 1245 "rygel-rendering-control.c"
}


void rygel_rendering_control_set_volume (RygelRenderingControl* self, guint value) {
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	RygelChangeLog* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_return_if_fail (self != NULL);
#line 63 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = value;
#line 63 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv->_volume = _tmp0_;
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp1_ = rygel_rendering_control_get_mute (self);
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp2_ = _tmp1_;
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	if (!_tmp2_) {
#line 1270 "rygel-rendering-control.c"
		RygelMediaPlayer* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		gdouble _tmp6_ = 0.0;
#line 66 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp3_ = self->priv->player;
#line 66 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp4_ = rygel_rendering_control_get_volume (self);
#line 66 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp5_ = _tmp4_;
#line 66 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		_tmp6_ = rygel_volume_from_percentage (_tmp5_);
#line 66 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		rygel_media_player_set_volume (_tmp3_, _tmp6_);
#line 1285 "rygel-rendering-control.c"
	}
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp7_ = self->priv->changelog;
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp8_ = rygel_rendering_control_get_volume (self);
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp9_ = _tmp8_;
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp10_ = g_strdup_printf ("%u", _tmp9_);
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp11_ = _tmp10_;
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_change_log_log_with_channel (_tmp7_, "Volume", _tmp11_, "Master");
#line 69 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_free0 (_tmp11_);
#line 62 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_object_notify ((GObject *) self, "volume");
#line 1303 "rygel-rendering-control.c"
}


static void rygel_rendering_control_class_init (RygelRenderingControlClass * klass) {
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	rygel_rendering_control_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_type_class_add_private (klass, sizeof (RygelRenderingControlPrivate));
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	((GObjectClass *) klass)->constructed = rygel_rendering_control_real_constructed;
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_rendering_control_get_property;
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_rendering_control_set_property;
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_rendering_control_finalize;
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RENDERING_CONTROL_MUTE, g_param_spec_boolean ("mute", "mute", "mute", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RENDERING_CONTROL_VOLUME, g_param_spec_uint ("volume", "volume", "volume", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1324 "rygel-rendering-control.c"
}


static void rygel_rendering_control_instance_init (RygelRenderingControl * self) {
	gchar* _tmp0_ = NULL;
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv = RYGEL_RENDERING_CONTROL_GET_PRIVATE (self);
#line 35 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv->_mute = FALSE;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv->_volume = (guint) 0;
#line 75 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_tmp0_ = g_strdup ("FactoryDefaults");
#line 75 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self->priv->preset_name_list = _tmp0_;
#line 1340 "rygel-rendering-control.c"
}


static void rygel_rendering_control_finalize (GObject* obj) {
	RygelRenderingControl * self;
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl);
#line 75 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_free0 (self->priv->preset_name_list);
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_object_unref0 (self->priv->changelog);
#line 78 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	_g_object_unref0 (self->priv->player);
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	G_OBJECT_CLASS (rygel_rendering_control_parent_class)->finalize (obj);
#line 1356 "rygel-rendering-control.c"
}


GType rygel_rendering_control_get_type (void) {
	static volatile gsize rygel_rendering_control_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_rendering_control_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRenderingControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_rendering_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRenderingControl), 0, (GInstanceInitFunc) rygel_rendering_control_instance_init, NULL };
		GType rygel_rendering_control_type_id;
		rygel_rendering_control_type_id = g_type_register_static (gupnp_service_get_type (), "RygelRenderingControl", &g_define_type_info, 0);
		g_once_init_leave (&rygel_rendering_control_type_id__volatile, rygel_rendering_control_type_id);
	}
	return rygel_rendering_control_type_id__volatile;
}


static void _vala_rygel_rendering_control_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelRenderingControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl);
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	switch (property_id) {
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		case RYGEL_RENDERING_CONTROL_MUTE:
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		g_value_set_boolean (value, rygel_rendering_control_get_mute (self));
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		case RYGEL_RENDERING_CONTROL_VOLUME:
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		g_value_set_uint (value, rygel_rendering_control_get_volume (self));
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		break;
#line 1389 "rygel-rendering-control.c"
		default:
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		break;
#line 1395 "rygel-rendering-control.c"
	}
}


static void _vala_rygel_rendering_control_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelRenderingControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl);
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
	switch (property_id) {
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		case RYGEL_RENDERING_CONTROL_MUTE:
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		rygel_rendering_control_set_mute (self, g_value_get_boolean (value));
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		case RYGEL_RENDERING_CONTROL_VOLUME:
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		rygel_rendering_control_set_volume (self, g_value_get_uint (value));
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		break;
#line 1417 "rygel-rendering-control.c"
		default:
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/home/jens/Source/rygel/src/librygel-renderer/rygel-rendering-control.vala"
		break;
#line 1423 "rygel-rendering-control.c"
	}
}



