/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_MEDIA_OBJECT_H__
#define __RYGEL_MEDIA_OBJECT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>

G_BEGIN_DECLS


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelParamSpecMediaObject RygelParamSpecMediaObject;

/**
 * Represents a media object (container and item). Subclasses should implement
 * the abstract serialize method.
 */
struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* parent_id;
	char* title;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
	void (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* didl_writer, GError** error);
};

struct _RygelParamSpecMediaObject {
	GParamSpec parent_instance;
};


void rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* didl_writer, GError** error);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer rygel_value_get_media_object (const GValue* value);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
GType rygel_media_object_get_type (void);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);


G_END_DECLS

#endif
