/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <rygel-content-directory.h>
#include <libsoup/soup.h>
#include <rygel-media-object.h>
#include <gobject/gvaluecollector.h>




enum  {
	BROWSE_ARGS_DUMMY_PROPERTY
};
static gpointer browse_args_parent_class = NULL;
static void browse_args_finalize (BrowseArgs* obj);
struct _RygelContentDirectoryPrivate {
	GUPnPDIDLLiteWriter* didl_writer;
};

#define RYGEL_CONTENT_DIRECTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryPrivate))
enum  {
	RYGEL_CONTENT_DIRECTORY_DUMMY_PROPERTY
};
static void rygel_content_directory_real_add_children_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static void rygel_content_directory_real_add_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static void rygel_content_directory_real_add_root_children_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (RygelContentDirectory* _sender, GUPnPServiceAction* action, gpointer self);
static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (RygelContentDirectory* _sender, GUPnPServiceAction* action, gpointer self);
static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (RygelContentDirectory* _sender, const char* variable, const GValue* value, gpointer self);
static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (RygelContentDirectory* _sender, GUPnPServiceAction* action, gpointer self);
static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (RygelContentDirectory* _sender, const char* variable, const GValue* value, gpointer self);
static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (RygelContentDirectory* _sender, GUPnPServiceAction* action, gpointer self);
static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (RygelContentDirectory* _sender, const char* variable, const GValue* value, gpointer self);
static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (RygelContentDirectory* _sender, GUPnPServiceAction* action, gpointer self);
static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (RygelContentDirectory* _sender, const char* variable, const GValue* value, gpointer self);
static void rygel_content_directory_real_constructed (GObject* base);
static void rygel_content_directory_real_browse_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, RygelContentDirectory* content_dir, const char* variable, GValue* value);
static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, RygelContentDirectory* content_dir, const char* variable, GValue* value);
static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, RygelContentDirectory* content_dir, const char* variable, GValue* value);
static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, RygelContentDirectory* content_dir, const char* variable, GValue* value);
static void rygel_content_directory_setup_root_container (RygelContentDirectory* self);
static void rygel_content_directory_browse_metadata (RygelContentDirectory* self, BrowseArgs* args, GError** error);
static void rygel_content_directory_browse_direct_children (RygelContentDirectory* self, BrowseArgs* args, GError** error);
static gboolean rygel_content_directory_parse_browse_args (RygelContentDirectory* self, GUPnPServiceAction* action, BrowseArgs* args, GError** error);
static void rygel_content_directory_conclude_browse (RygelContentDirectory* self, GUPnPServiceAction* action, const char* didl, BrowseArgs* args);
static gpointer rygel_content_directory_parent_class = NULL;
static void rygel_content_directory_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_content_directory_error_quark (void) {
	return g_quark_from_static_string ("rygel_content_directory_error-quark");
}


BrowseArgs* browse_args_construct (GType object_type) {
	BrowseArgs* self;
	self = (BrowseArgs*) g_type_create_instance (object_type);
	return self;
}


BrowseArgs* browse_args_new (void) {
	return browse_args_construct (TYPE_BROWSE_ARGS);
}


static void value_browse_args_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_browse_args_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		browse_args_unref (value->data[0].v_pointer);
	}
}


static void value_browse_args_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = browse_args_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_browse_args_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_browse_args_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BrowseArgs* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = browse_args_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_browse_args_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BrowseArgs** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = browse_args_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_browse_args (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBrowseArgs* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BROWSE_ARGS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_browse_args (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BROWSE_ARGS), NULL);
	return value->data[0].v_pointer;
}


void value_set_browse_args (GValue* value, gpointer v_object) {
	BrowseArgs* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BROWSE_ARGS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BROWSE_ARGS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		browse_args_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		browse_args_unref (old);
	}
}


static void browse_args_class_init (BrowseArgsClass * klass) {
	browse_args_parent_class = g_type_class_peek_parent (klass);
	BROWSE_ARGS_CLASS (klass)->finalize = browse_args_finalize;
}


static void browse_args_instance_init (BrowseArgs * self) {
	self->ref_count = 1;
}


static void browse_args_finalize (BrowseArgs* obj) {
	BrowseArgs * self;
	self = BROWSE_ARGS (obj);
	self->object_id = (g_free (self->object_id), NULL);
	self->browse_flag = (g_free (self->browse_flag), NULL);
	self->filter = (g_free (self->filter), NULL);
	self->sort_criteria = (g_free (self->sort_criteria), NULL);
}


GType browse_args_get_type (void) {
	static GType browse_args_type_id = 0;
	if (browse_args_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_browse_args_init, value_browse_args_free_value, value_browse_args_copy_value, value_browse_args_peek_pointer, "p", value_browse_args_collect_value, "p", value_browse_args_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BrowseArgsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) browse_args_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BrowseArgs), 0, (GInstanceInitFunc) browse_args_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		browse_args_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BrowseArgs", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return browse_args_type_id;
}


gpointer browse_args_ref (gpointer instance) {
	BrowseArgs* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void browse_args_unref (gpointer instance) {
	BrowseArgs* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BROWSE_ARGS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


/* Public abstract methods derived classes need to implement*/
static void rygel_content_directory_real_add_children_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	inner_error = g_error_new_literal (GUPNP_SERVER_ERROR, GUPNP_SERVER_ERROR_NOT_IMPLEMENTED, "Not Implemented\n");
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
}


void rygel_content_directory_add_children_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RYGEL_CONTENT_DIRECTORY_GET_CLASS (self)->add_children_metadata (self, didl_writer, args, error);
}


static void rygel_content_directory_real_add_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	inner_error = g_error_new_literal (GUPNP_SERVER_ERROR, GUPNP_SERVER_ERROR_NOT_IMPLEMENTED, "Not Implemented\n");
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
}


void rygel_content_directory_add_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RYGEL_CONTENT_DIRECTORY_GET_CLASS (self)->add_metadata (self, didl_writer, args, error);
}


static void rygel_content_directory_real_add_root_children_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	inner_error = g_error_new_literal (GUPNP_SERVER_ERROR, GUPNP_SERVER_ERROR_NOT_IMPLEMENTED, "Not Implemented\n");
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
}


void rygel_content_directory_add_root_children_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RYGEL_CONTENT_DIRECTORY_GET_CLASS (self)->add_root_children_metadata (self, didl_writer, args, error);
}


static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (RygelContentDirectory* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_browse_cb (self, _sender, action);
}


static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (RygelContentDirectory* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_system_update_id_cb (self, _sender, action);
}


static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (RygelContentDirectory* _sender, const char* variable, const GValue* value, gpointer self) {
	rygel_content_directory_query_system_update_id (self, _sender, variable, value);
}


static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (RygelContentDirectory* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_search_capabilities_cb (self, _sender, action);
}


static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (RygelContentDirectory* _sender, const char* variable, const GValue* value, gpointer self) {
	rygel_content_directory_query_search_capabilities (self, _sender, variable, value);
}


static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (RygelContentDirectory* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_sort_capabilities_cb (self, _sender, action);
}


static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (RygelContentDirectory* _sender, const char* variable, const GValue* value, gpointer self) {
	rygel_content_directory_query_sort_capabilities (self, _sender, variable, value);
}


static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (RygelContentDirectory* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_feature_list_cb (self, _sender, action);
}


static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (RygelContentDirectory* _sender, const char* variable, const GValue* value, gpointer self) {
	rygel_content_directory_query_feature_list (self, _sender, variable, value);
}


static void rygel_content_directory_real_constructed (GObject* base) {
	RygelContentDirectory * self;
	GUPnPDIDLLiteWriter* _tmp0;
	RygelHTTPServer* _tmp1;
	char* _tmp2;
	char* _tmp3;
	char* _tmp4;
	self = (RygelContentDirectory*) base;
	_tmp0 = NULL;
	self->priv->didl_writer = (_tmp0 = gupnp_didl_lite_writer_new (), (self->priv->didl_writer == NULL) ? NULL : (self->priv->didl_writer = (g_object_unref (self->priv->didl_writer), NULL)), _tmp0);
	rygel_content_directory_setup_root_container (self);
	_tmp1 = NULL;
	self->http_server = (_tmp1 = rygel_http_server_new (gupnp_service_info_get_context ((GUPnPServiceInfo*) self), g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self))), (self->http_server == NULL) ? NULL : (self->http_server = (g_object_unref (self->http_server), NULL)), _tmp1);
	self->system_update_id = (guint32) 0;
	_tmp2 = NULL;
	self->feature_list = (_tmp2 = g_strdup ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" "<Features xmlns=\"urn:schemas-upnp-org:av:avs\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"urn:schemas-upnp-org:av:avs" "http://www.upnp.org/schemas/av/avs-v1-20060531.xsd\">" "</Features>"), self->feature_list = (g_free (self->feature_list), NULL), _tmp2);
	_tmp3 = NULL;
	self->search_caps = (_tmp3 = g_strdup (""), self->search_caps = (g_free (self->search_caps), NULL), _tmp3);
	_tmp4 = NULL;
	self->sort_caps = (_tmp4 = g_strdup (""), self->sort_caps = (g_free (self->sort_caps), NULL), _tmp4);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Browse", (GCallback) _rygel_content_directory_browse_cb_gupnp_service_action_invoked, self, 0);
	/* Connect SystemUpdateID related signals */
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSystemUpdateID", (GCallback) _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SystemUpdateID", (GCallback) _rygel_content_directory_query_system_update_id_gupnp_service_query_variable, self, 0);
	/* Connect SearchCapabilities related signals */
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSearchCapabilities", (GCallback) _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SearchCapabilities", (GCallback) _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable, self, 0);
	/* Connect SortCapabilities related signals */
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSortCapabilities", (GCallback) _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SortCapabilities", (GCallback) _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable, self, 0);
	/* Connect FeatureList related signals */
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetFeatureList", (GCallback) _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::FeatureList", (GCallback) _rygel_content_directory_query_feature_list_gupnp_service_query_variable, self, 0);
}


/* Browse action implementation */
static void rygel_content_directory_real_browse_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	GError * inner_error;
	gboolean metadata;
	BrowseArgs* args;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	inner_error = NULL;
	metadata = FALSE;
	args = browse_args_new ();
	/* Start DIDL-Lite fragment */
	gupnp_didl_lite_writer_start_didl_lite (self->priv->didl_writer, NULL, NULL, TRUE);
	{
		gboolean _tmp0;
		const char* _tmp1;
		char* didl;
		_tmp0 = rygel_content_directory_parse_browse_args (self, action, args, &inner_error);
		if (inner_error != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
		/* Handle incoming arguments */
		metadata = _tmp0;
		if (metadata) {
			/* BrowseMetadata*/
			rygel_content_directory_browse_metadata (self, args, &inner_error);
			if (inner_error != NULL) {
				goto __catch0_g_error;
				goto __finally0;
			}
		} else {
			/* BrowseDirectChildren*/
			rygel_content_directory_browse_direct_children (self, args, &inner_error);
			if (inner_error != NULL) {
				goto __catch0_g_error;
				goto __finally0;
			}
		}
		/* End DIDL-Lite fragment */
		gupnp_didl_lite_writer_end_didl_lite (self->priv->didl_writer);
		/* Retrieve generated string */
		_tmp1 = NULL;
		didl = (_tmp1 = gupnp_didl_lite_writer_get_string (self->priv->didl_writer), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
		/* Conclude the successful Browse action*/
		rygel_content_directory_conclude_browse (self, action, didl, args);
		didl = (g_free (didl), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			gupnp_service_action_return_error (action, (guint) error->code, error->message);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
		}
	}
	__finally0:
	if (inner_error != NULL) {
		(args == NULL) ? NULL : (args = (browse_args_unref (args), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	/* Reset the parser state */
	gupnp_didl_lite_writer_reset (self->priv->didl_writer);
	(args == NULL) ? NULL : (args = (browse_args_unref (args), NULL));
}


void rygel_content_directory_browse_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RYGEL_CONTENT_DIRECTORY_GET_CLASS (self)->browse_cb (self, content_dir, action);
}


/* GetSystemUpdateID action implementation */
static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	/* Set action return arguments */
	gupnp_service_action_set (action, "Id", G_TYPE_UINT, self->system_update_id, NULL);
	gupnp_service_action_return (action);
}


/* Query GetSystemUpdateID */
static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, RygelContentDirectory* content_dir, const char* variable, GValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	/* Set action return arguments */
	g_value_init (&(*value), G_TYPE_UINT);
	g_value_set_uint (&(*value), (guint) self->system_update_id);
}


/* action GetSearchCapabilities implementation */
static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	/* Set action return arguments */
	gupnp_service_action_set (action, "SearchCaps", G_TYPE_STRING, self->search_caps, NULL);
	gupnp_service_action_return (action);
}


/* Query SearchCapabilities */
static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, RygelContentDirectory* content_dir, const char* variable, GValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	/* Set action return arguments */
	g_value_init (&(*value), G_TYPE_STRING);
	g_value_set_string (&(*value), self->search_caps);
}


/* action GetSortCapabilities implementation */
static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	/* Set action return arguments */
	gupnp_service_action_set (action, "SortCaps", G_TYPE_STRING, self->sort_caps, NULL);
	gupnp_service_action_return (action);
}


/* Query SortCapabilities */
static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, RygelContentDirectory* content_dir, const char* variable, GValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	/* Set action return arguments */
	g_value_init (&(*value), G_TYPE_STRING);
	g_value_set_string (&(*value), self->sort_caps);
}


/* action GetFeatureList implementation */
static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	/* Set action return arguments */
	gupnp_service_action_set (action, "FeatureList", G_TYPE_STRING, self->feature_list, NULL);
	gupnp_service_action_return (action);
}


/* Query FeatureList */
static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, RygelContentDirectory* content_dir, const char* variable, GValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	/* Set action return arguments */
	g_value_init (&(*value), G_TYPE_STRING);
	g_value_set_string (&(*value), self->feature_list);
}


static void rygel_content_directory_setup_root_container (RygelContentDirectory* self) {
	GUPnPRootDevice* _tmp1;
	GUPnPRootDevice* _tmp0;
	char* _tmp2;
	char* friendly_name;
	RygelMediaContainer* _tmp3;
	g_return_if_fail (self != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	friendly_name = (_tmp2 = gupnp_device_info_get_friendly_name ((GUPnPDeviceInfo*) (_tmp1 = (g_object_get ((GUPnPService*) self, "root-device", &_tmp0, NULL), _tmp0))), (_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)), _tmp2);
	_tmp3 = NULL;
	self->root_container = (_tmp3 = rygel_media_container_new_root (friendly_name, (guint) 0), (self->root_container == NULL) ? NULL : (self->root_container = (rygel_media_object_unref (self->root_container), NULL)), _tmp3);
	friendly_name = (g_free (friendly_name), NULL);
}


static void rygel_content_directory_browse_metadata (RygelContentDirectory* self, BrowseArgs* args, GError** error) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	if (_vala_strcmp0 (args->object_id, ((RygelMediaObject*) self->root_container)->id) == 0) {
		rygel_media_object_serialize ((RygelMediaObject*) self->root_container, self->priv->didl_writer, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return;
		}
		args->update_id = (guint) self->system_update_id;
	} else {
		rygel_content_directory_add_metadata (self, self->priv->didl_writer, args, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return;
		}
	}
	args->number_returned = (guint) 1;
	args->total_matches = (guint) 1;
}


static void rygel_content_directory_browse_direct_children (RygelContentDirectory* self, BrowseArgs* args, GError** error) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	if (_vala_strcmp0 (args->object_id, ((RygelMediaObject*) self->root_container)->id) == 0) {
		rygel_content_directory_add_root_children_metadata (self, self->priv->didl_writer, args, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return;
		}
	} else {
		rygel_content_directory_add_children_metadata (self, self->priv->didl_writer, args, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return;
		}
	}
}


static gboolean rygel_content_directory_parse_browse_args (RygelContentDirectory* self, GUPnPServiceAction* action, BrowseArgs* args, GError** error) {
	GError * inner_error;
	gboolean metadata;
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	inner_error = NULL;
	gupnp_service_action_get (action, "ObjectID", G_TYPE_STRING, &args->object_id, "BrowseFlag", G_TYPE_STRING, &args->browse_flag, "Filter", G_TYPE_STRING, &args->filter, "StartingIndex", G_TYPE_UINT, &args->index, "RequestedCount", G_TYPE_UINT, &args->requested_count, "SortCriteria", G_TYPE_STRING, &args->sort_criteria, NULL);
	/* BrowseFlag */
	metadata = FALSE;
	_tmp0 = FALSE;
	if (args->browse_flag != NULL) {
		_tmp0 = _vala_strcmp0 (args->browse_flag, "BrowseDirectChildren") == 0;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		metadata = FALSE;
	} else {
		gboolean _tmp1;
		_tmp1 = FALSE;
		if (args->browse_flag != NULL) {
			_tmp1 = _vala_strcmp0 (args->browse_flag, "BrowseMetadata") == 0;
		} else {
			_tmp1 = FALSE;
		}
		if (_tmp1) {
			metadata = TRUE;
		} else {
			inner_error = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Invalid Args");
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				return FALSE;
			}
		}
	}
	/* ObjectID */
	if (args->object_id == NULL) {
		/* Stupid Xbox */
		gupnp_service_action_get (action, "ContainerID", G_TYPE_STRING, &args->object_id, NULL);
	}
	if (args->object_id == NULL) {
		/* Sorry we can't do anything without ObjectID*/
		inner_error = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "No such object");
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return FALSE;
		}
	}
	return metadata;
}


static void rygel_content_directory_conclude_browse (RygelContentDirectory* self, GUPnPServiceAction* action, const char* didl, BrowseArgs* args) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (didl != NULL);
	g_return_if_fail (args != NULL);
	if (args->update_id == G_MAXUINT32) {
		args->update_id = (guint) self->system_update_id;
	}
	/* Set action return arguments */
	gupnp_service_action_set (action, "Result", G_TYPE_STRING, didl, "NumberReturned", G_TYPE_UINT, args->number_returned, "TotalMatches", G_TYPE_UINT, args->total_matches, "UpdateID", G_TYPE_UINT, args->update_id, NULL);
	gupnp_service_action_return (action);
}


/**
 * Basic implementation of UPnP ContentDirectory service version 2. Most often
 * plugins will provide a child of this class. The inheriting classes should
 * override add_children_metadata and add_metadata virtual methods.
 */
RygelContentDirectory* rygel_content_directory_construct (GType object_type) {
	RygelContentDirectory * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


RygelContentDirectory* rygel_content_directory_new (void) {
	return rygel_content_directory_construct (RYGEL_TYPE_CONTENT_DIRECTORY);
}


static void rygel_content_directory_class_init (RygelContentDirectoryClass * klass) {
	rygel_content_directory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelContentDirectoryPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_content_directory_finalize;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_children_metadata = rygel_content_directory_real_add_children_metadata;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_metadata = rygel_content_directory_real_add_metadata;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_root_children_metadata = rygel_content_directory_real_add_root_children_metadata;
	G_OBJECT_CLASS (klass)->constructed = rygel_content_directory_real_constructed;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->browse_cb = rygel_content_directory_real_browse_cb;
}


static void rygel_content_directory_instance_init (RygelContentDirectory * self) {
	self->priv = RYGEL_CONTENT_DIRECTORY_GET_PRIVATE (self);
}


static void rygel_content_directory_finalize (GObject* obj) {
	RygelContentDirectory * self;
	self = RYGEL_CONTENT_DIRECTORY (obj);
	{
		rygel_http_server_destroy (self->http_server);
	}
	self->feature_list = (g_free (self->feature_list), NULL);
	self->search_caps = (g_free (self->search_caps), NULL);
	self->sort_caps = (g_free (self->sort_caps), NULL);
	(self->http_server == NULL) ? NULL : (self->http_server = (g_object_unref (self->http_server), NULL));
	(self->root_container == NULL) ? NULL : (self->root_container = (rygel_media_object_unref (self->root_container), NULL));
	(self->priv->didl_writer == NULL) ? NULL : (self->priv->didl_writer = (g_object_unref (self->priv->didl_writer), NULL));
	G_OBJECT_CLASS (rygel_content_directory_parent_class)->finalize (obj);
}


GType rygel_content_directory_get_type (void) {
	static GType rygel_content_directory_type_id = 0;
	if (rygel_content_directory_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelContentDirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_content_directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelContentDirectory), 0, (GInstanceInitFunc) rygel_content_directory_instance_init, NULL };
		rygel_content_directory_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelContentDirectory", &g_define_type_info, 0);
	}
	return rygel_content_directory_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




