/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <rygel-live-response.h>




static gboolean string_contains (const char* self, const char* needle);
struct _RygelLiveResponsePrivate {
	GstPipeline* pipeline;
	GAsyncQueue* buffers;
};

#define RYGEL_LIVE_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponsePrivate))
enum  {
	RYGEL_LIVE_RESPONSE_DUMMY_PROPERTY
};
#define RYGEL_LIVE_RESPONSE_SINK_NAME "fakesink"
static void rygel_live_response_real_end (RygelHTTPResponse* base, gboolean aborted, guint status);
static inline void _dynamic_set_signal_handoffs1 (GstElement* obj, gboolean value);
static void _rygel_live_response_on_new_buffer_dynamic_handoff0_ (GstElement* _sender, GstBuffer* buffer, GstPad* pad, gpointer self);
void _dynamic_handoff1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void _rygel_live_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static gboolean _rygel_live_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static void rygel_live_response_prepare_pipeline (RygelLiveResponse* self, const char* name, GstElement* src, GError** error);
static void rygel_live_response_src_pad_added (RygelLiveResponse* self, GstElement* src, GstPad* src_pad);
static gboolean rygel_live_response_need_rtp_depayloader (RygelLiveResponse* self, GstCaps* caps);
static gboolean _rygel_live_response_rtp_depay_filter_gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self);
static void _g_list_free_gst_object_unref (GList* self);
static GstElement* rygel_live_response_get_rtp_depayloader (RygelLiveResponse* self, GstCaps* caps);
static gint _rygel_live_response_compare_factories_gcompare_func (void* a, void* b);
static GstElement* rygel_live_response_get_best_depay (RygelLiveResponse* self, GList* features, GstCaps* caps);
static gboolean rygel_live_response_rtp_depay_filter (RygelLiveResponse* self, GstPluginFeature* feature);
static gint rygel_live_response_compare_factories (void* a, void* b);
static gboolean _rygel_live_response_idle_handler_gsource_func (gpointer self);
static void rygel_live_response_on_new_buffer (RygelLiveResponse* self, GstElement* sink, GstBuffer* buffer, GstPad* pad);
static gboolean rygel_live_response_idle_handler (RygelLiveResponse* self);
static gboolean rygel_live_response_bus_handler (RygelLiveResponse* self, GstBus* bus, GstMessage* message);
static gpointer rygel_live_response_parent_class = NULL;
static void rygel_live_response_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__POINTER_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static gboolean string_contains (const char* self, const char* needle) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	return strstr (self, needle) != NULL;
}


GQuark rygel_live_response_error_quark (void) {
	return g_quark_from_static_string ("rygel_live_response_error-quark");
}


RygelLiveResponse* rygel_live_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, GError** error) {
	GError * inner_error;
	RygelLiveResponse * self;
	GAsyncQueue* _tmp0;
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (src != NULL, NULL);
	inner_error = NULL;
	self = (RygelLiveResponse*) rygel_http_response_construct (object_type, server, msg, FALSE);
	soup_message_headers_set_encoding (((RygelHTTPResponse*) self)->msg->response_headers, SOUP_ENCODING_CHUNKED);
	soup_message_body_set_accumulate (((RygelHTTPResponse*) self)->msg->response_body, FALSE);
	_tmp0 = NULL;
	self->priv->buffers = (_tmp0 = g_async_queue_new (), (self->priv->buffers == NULL) ? NULL : (self->priv->buffers = (g_async_queue_unref (self->priv->buffers), NULL)), _tmp0);
	rygel_live_response_prepare_pipeline (self, name, src, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	return self;
}


RygelLiveResponse* rygel_live_response_new (SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, GError** error) {
	return rygel_live_response_construct (RYGEL_TYPE_LIVE_RESPONSE, server, msg, name, src, error);
}


void rygel_live_response_start (RygelLiveResponse* self) {
	g_return_if_fail (self != NULL);
	/* Go to PAUSED first*/
	gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_PLAYING);
}


static void rygel_live_response_real_end (RygelHTTPResponse* base, gboolean aborted, guint status) {
	RygelLiveResponse * self;
	GstBuffer* buffer;
	self = (RygelLiveResponse*) base;
	gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_NULL);
	/* Flush the queue of buffers*/
	buffer = NULL;
	do {
		GstBuffer* _tmp0;
		_tmp0 = NULL;
		buffer = (_tmp0 = (GstBuffer*) g_async_queue_try_pop (self->priv->buffers), (buffer == NULL) ? NULL : (buffer = (gst_buffer_unref (buffer), NULL)), _tmp0);
	} while (buffer != NULL);
	if (!aborted) {
		soup_message_body_complete (((RygelHTTPResponse*) self)->msg->response_body);
	}
	RYGEL_HTTP_RESPONSE_CLASS (rygel_live_response_parent_class)->end (RYGEL_HTTP_RESPONSE (self), aborted, status);
	(buffer == NULL) ? NULL : (buffer = (gst_buffer_unref (buffer), NULL));
}


static inline void _dynamic_set_signal_handoffs1 (GstElement* obj, gboolean value) {
	g_object_set (obj, "signal-handoffs", value, NULL);
}


static void _rygel_live_response_on_new_buffer_dynamic_handoff0_ (GstElement* _sender, GstBuffer* buffer, GstPad* pad, gpointer self) {
	rygel_live_response_on_new_buffer (self, _sender, buffer, pad);
}


void _dynamic_handoff1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
	g_signal_connect_object (obj, signal_name, handler, data, 0);
}


static void _rygel_live_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	rygel_live_response_src_pad_added (self, _sender, pad);
}


static gboolean _rygel_live_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	return rygel_live_response_bus_handler (self, bus, message);
}


static void rygel_live_response_prepare_pipeline (RygelLiveResponse* self, const char* name, GstElement* src, GError** error) {
	GError * inner_error;
	GstElement* sink;
	GstPipeline* _tmp0;
	GstElement* _tmp2;
	GstElement* _tmp1;
	GstBus* bus;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (src != NULL);
	inner_error = NULL;
	sink = gst_element_factory_make ("fakesink", RYGEL_LIVE_RESPONSE_SINK_NAME);
	if (sink == NULL) {
		inner_error = g_error_new_literal (RYGEL_LIVE_RESPONSE_ERROR, RYGEL_LIVE_RESPONSE_ERROR_MISSING_PLUGIN, "Required plugin 'fakesink' missing");
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
			return;
		}
	}
	_dynamic_set_signal_handoffs1 (sink, TRUE);
	_dynamic_handoff1_connect (sink, "handoff", (GCallback) _rygel_live_response_on_new_buffer_dynamic_handoff0_, self);
	_tmp0 = NULL;
	self->priv->pipeline = (_tmp0 = (GstPipeline*) gst_pipeline_new (name), (self->priv->pipeline == NULL) ? NULL : (self->priv->pipeline = (gst_object_unref (self->priv->pipeline), NULL)), _tmp0);
	g_assert (self->priv->pipeline != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	gst_bin_add_many ((GstBin*) self->priv->pipeline, (_tmp1 = src, (_tmp1 == NULL) ? NULL : gst_object_ref (_tmp1)), (_tmp2 = sink, (_tmp2 == NULL) ? NULL : gst_object_ref (_tmp2)), NULL);
	if (src->numpads == 0) {
		/* Seems source uses dynamic pads, link when pad available*/
		g_signal_connect_object (src, "pad-added", (GCallback) _rygel_live_response_src_pad_added_gst_element_pad_added, self, 0);
	} else {
		/* static pads? easy!*/
		if (!gst_element_link (src, sink)) {
			inner_error = g_error_new (RYGEL_LIVE_RESPONSE_ERROR, RYGEL_LIVE_RESPONSE_ERROR_LINK, "Failed to link %s to %s", gst_object_get_name ((GstObject*) src), gst_object_get_name ((GstObject*) sink));
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
				return;
			}
		}
	}
	/* Bus handler*/
	bus = gst_pipeline_get_bus (self->priv->pipeline);
	gst_bus_add_watch (bus, _rygel_live_response_bus_handler_gst_bus_func, self);
	(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
	(bus == NULL) ? NULL : (bus = (gst_object_unref (bus), NULL));
}


static void rygel_live_response_src_pad_added (RygelLiveResponse* self, GstElement* src, GstPad* src_pad) {
	GstCaps* caps;
	GstElement* sink;
	GstPad* sink_pad;
	GstElement* depay;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (src_pad != NULL);
	caps = gst_pad_get_caps (src_pad);
	sink = gst_bin_get_by_name ((GstBin*) self->priv->pipeline, RYGEL_LIVE_RESPONSE_SINK_NAME);
	sink_pad = NULL;
	depay = rygel_live_response_get_rtp_depayloader (self, caps);
	if (depay != NULL) {
		GstElement* _tmp0;
		GstPad* _tmp2;
		GstPad* _tmp1;
		_tmp0 = NULL;
		gst_bin_add ((GstBin*) self->priv->pipeline, (_tmp0 = depay, (_tmp0 == NULL) ? NULL : gst_object_ref (_tmp0)));
		if (!gst_element_link (depay, sink)) {
			g_critical ("rygel-live-response.vala:121: Failed to link %s to %s", gst_object_get_name ((GstObject*) depay), gst_object_get_name ((GstObject*) sink));
			rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
			(caps == NULL) ? NULL : (caps = (gst_caps_unref (caps), NULL));
			(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
			(sink_pad == NULL) ? NULL : (sink_pad = (gst_object_unref (sink_pad), NULL));
			(depay == NULL) ? NULL : (depay = (gst_object_unref (depay), NULL));
			return;
		}
		_tmp2 = NULL;
		_tmp1 = NULL;
		sink_pad = (_tmp2 = (_tmp1 = gst_element_get_compatible_pad (depay, src_pad, caps), (_tmp1 == NULL) ? NULL : gst_object_ref (_tmp1)), (sink_pad == NULL) ? NULL : (sink_pad = (gst_object_unref (sink_pad), NULL)), _tmp2);
	} else {
		GstPad* _tmp4;
		GstPad* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		sink_pad = (_tmp4 = (_tmp3 = gst_element_get_compatible_pad (sink, src_pad, caps), (_tmp3 == NULL) ? NULL : gst_object_ref (_tmp3)), (sink_pad == NULL) ? NULL : (sink_pad = (gst_object_unref (sink_pad), NULL)), _tmp4);
	}
	if (gst_pad_link (src_pad, sink_pad) != GST_PAD_LINK_OK) {
		g_critical ("rygel-live-response.vala:134: Failed to link pad %s to %s", gst_object_get_name ((GstObject*) src_pad), gst_object_get_name ((GstObject*) sink_pad));
		rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
		(caps == NULL) ? NULL : (caps = (gst_caps_unref (caps), NULL));
		(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
		(sink_pad == NULL) ? NULL : (sink_pad = (gst_object_unref (sink_pad), NULL));
		(depay == NULL) ? NULL : (depay = (gst_object_unref (depay), NULL));
		return;
	}
	if (depay != NULL) {
		gst_element_sync_state_with_parent (depay);
	}
	(caps == NULL) ? NULL : (caps = (gst_caps_unref (caps), NULL));
	(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
	(sink_pad == NULL) ? NULL : (sink_pad = (gst_object_unref (sink_pad), NULL));
	(depay == NULL) ? NULL : (depay = (gst_object_unref (depay), NULL));
}


static gboolean rygel_live_response_need_rtp_depayloader (RygelLiveResponse* self, GstCaps* caps) {
	const GstStructure* _tmp0;
	GstStructure* structure;
	gboolean _tmp1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (caps != NULL, FALSE);
	_tmp0 = NULL;
	structure = (_tmp0 = gst_caps_get_structure (caps, (guint) 0), (_tmp0 == NULL) ? NULL : gst_structure_copy (_tmp0));
	return (_tmp1 = _vala_strcmp0 (gst_structure_get_name (structure), "application/x-rtp") == 0, (structure == NULL) ? NULL : (structure = (gst_structure_free (structure), NULL)), _tmp1);
}


static gboolean _rygel_live_response_rtp_depay_filter_gst_plugin_feature_filter (GstPluginFeature* feature, gpointer self) {
	return rygel_live_response_rtp_depay_filter (self, feature);
}


static void _g_list_free_gst_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) gst_object_unref, NULL);
	g_list_free (self);
}


static GstElement* rygel_live_response_get_rtp_depayloader (RygelLiveResponse* self, GstCaps* caps) {
	GstRegistry* registry;
	GList* features;
	GstElement* _tmp1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (caps != NULL, NULL);
	if (!rygel_live_response_need_rtp_depayloader (self, caps)) {
		return NULL;
	}
	registry = gst_registry_get_default ();
	features = gst_registry_feature_filter (registry, _rygel_live_response_rtp_depay_filter_gst_plugin_feature_filter, FALSE, self);
	_tmp1 = NULL;
	return (_tmp1 = rygel_live_response_get_best_depay (self, features, caps), (features == NULL) ? NULL : (features = (_g_list_free_gst_object_unref (features), NULL)), _tmp1);
}


static gint _rygel_live_response_compare_factories_gcompare_func (void* a, void* b) {
	return rygel_live_response_compare_factories (a, b);
}


static GstElement* rygel_live_response_get_best_depay (RygelLiveResponse* self, GList* features, GstCaps* caps) {
	GList* relevant_factories;
	GstElementFactory* _tmp4;
	GstElementFactory* factory;
	GstElement* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (features != NULL, NULL);
	g_return_val_if_fail (caps != NULL, NULL);
	relevant_factories = NULL;
	/* First construct a list of relevant factories*/
	{
		GList* feature_collection;
		GList* feature_it;
		feature_collection = features;
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
			GstPluginFeature* _tmp2;
			GstPluginFeature* feature;
			_tmp2 = NULL;
			feature = (_tmp2 = (GstPluginFeature*) feature_it->data, (_tmp2 == NULL) ? NULL : gst_object_ref (_tmp2));
			{
				GstElementFactory* _tmp0;
				GstElementFactory* factory;
				_tmp0 = NULL;
				factory = (_tmp0 = GST_ELEMENT_FACTORY (feature), (_tmp0 == NULL) ? NULL : gst_object_ref (_tmp0));
				if (gst_element_factory_can_sink_caps (factory, caps)) {
					GstElementFactory* _tmp1;
					_tmp1 = NULL;
					relevant_factories = g_list_append (relevant_factories, (_tmp1 = factory, (_tmp1 == NULL) ? NULL : gst_object_ref (_tmp1)));
				}
				(feature == NULL) ? NULL : (feature = (gst_object_unref (feature), NULL));
				(factory == NULL) ? NULL : (factory = (gst_object_unref (factory), NULL));
			}
		}
	}
	if (g_list_length (relevant_factories) == 0) {
		GstElement* _tmp3;
		/* No relevant factory available, hence no depayloader*/
		_tmp3 = NULL;
		return (_tmp3 = NULL, (relevant_factories == NULL) ? NULL : (relevant_factories = (_g_list_free_gst_object_unref (relevant_factories), NULL)), _tmp3);
	}
	/* Then sort the list through their ranks*/
	relevant_factories = g_list_sort (relevant_factories, _rygel_live_response_compare_factories_gcompare_func);
	/* create an element of the top ranking factory and return it*/
	_tmp4 = NULL;
	factory = (_tmp4 = (GstElementFactory*) relevant_factories->data, (_tmp4 == NULL) ? NULL : gst_object_ref (_tmp4));
	_tmp5 = NULL;
	return (_tmp5 = gst_element_factory_make (gst_plugin_feature_get_name ((GstPluginFeature*) factory), NULL), (relevant_factories == NULL) ? NULL : (relevant_factories = (_g_list_free_gst_object_unref (relevant_factories), NULL)), (factory == NULL) ? NULL : (factory = (gst_object_unref (factory), NULL)), _tmp5);
}


static gboolean rygel_live_response_rtp_depay_filter (RygelLiveResponse* self, GstPluginFeature* feature) {
	GstElementFactory* _tmp1;
	GstElementFactory* factory;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (feature != NULL, FALSE);
	if (!g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) feature), GST_TYPE_ELEMENT_FACTORY)) {
		return FALSE;
	}
	_tmp1 = NULL;
	factory = (_tmp1 = GST_ELEMENT_FACTORY (feature), (_tmp1 == NULL) ? NULL : gst_object_ref (_tmp1));
	return (_tmp2 = string_contains (gst_element_factory_get_klass (factory), "Depayloader"), (factory == NULL) ? NULL : (factory = (gst_object_unref (factory), NULL)), _tmp2);
}


static gint rygel_live_response_compare_factories (void* a, void* b) {
	GstElementFactory* _tmp0;
	GstElementFactory* factory_a;
	GstElementFactory* _tmp1;
	GstElementFactory* factory_b;
	gint _tmp2;
	_tmp0 = NULL;
	factory_a = (_tmp0 = GST_ELEMENT_FACTORY (a), (_tmp0 == NULL) ? NULL : gst_object_ref (_tmp0));
	_tmp1 = NULL;
	factory_b = (_tmp1 = GST_ELEMENT_FACTORY (b), (_tmp1 == NULL) ? NULL : gst_object_ref (_tmp1));
	return (_tmp2 = (gint) (gst_plugin_feature_get_rank ((GstPluginFeature*) factory_b) - gst_plugin_feature_get_rank ((GstPluginFeature*) factory_a)), (factory_a == NULL) ? NULL : (factory_a = (gst_object_unref (factory_a), NULL)), (factory_b == NULL) ? NULL : (factory_b = (gst_object_unref (factory_b), NULL)), _tmp2);
}


static gboolean _rygel_live_response_idle_handler_gsource_func (gpointer self) {
	return rygel_live_response_idle_handler (self);
}


static void rygel_live_response_on_new_buffer (RygelLiveResponse* self, GstElement* sink, GstBuffer* buffer, GstPad* pad) {
	GstBuffer* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sink != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (pad != NULL);
	_tmp0 = NULL;
	g_async_queue_push (self->priv->buffers, (_tmp0 = buffer, (_tmp0 == NULL) ? NULL : gst_buffer_ref (_tmp0)));
	g_idle_add_full (G_PRIORITY_HIGH_IDLE, _rygel_live_response_idle_handler_gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean rygel_live_response_idle_handler (RygelLiveResponse* self) {
	GstBuffer* buffer;
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	buffer = (GstBuffer*) g_async_queue_try_pop (self->priv->buffers);
	if (buffer != NULL) {
		rygel_http_response_push_data ((RygelHTTPResponse*) self, buffer->data, (gsize) buffer->size);
	}
	return (_tmp0 = FALSE, (buffer == NULL) ? NULL : (buffer = (gst_buffer_unref (buffer), NULL)), _tmp0);
}


static gboolean rygel_live_response_bus_handler (RygelLiveResponse* self, GstBus* bus, GstMessage* message) {
	gboolean ret;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	ret = TRUE;
	if (message->type == GST_MESSAGE_EOS) {
		ret = FALSE;
	} else {
		GError* err;
		char* err_msg;
		err = NULL;
		err_msg = NULL;
		if (message->type == GST_MESSAGE_ERROR) {
			char* _tmp3;
			char* _tmp2;
			GError* _tmp1;
			GError* _tmp0;
			_tmp3 = NULL;
			_tmp2 = NULL;
			_tmp1 = NULL;
			_tmp0 = NULL;
			(gst_message_parse_error (message, &_tmp0, &_tmp2), err = (_tmp1 = _tmp0, (err == NULL) ? NULL : (err = (g_error_free (err), NULL)), _tmp1));
			err_msg = (_tmp3 = _tmp2, err_msg = (g_free (err_msg), NULL), _tmp3);
			g_critical ("rygel-live-response.vala:234: Error from pipeline %s:%s", gst_object_get_name ((GstObject*) self->priv->pipeline), err_msg);
			ret = FALSE;
		} else {
			if (message->type == GST_MESSAGE_WARNING) {
				char* _tmp7;
				char* _tmp6;
				GError* _tmp5;
				GError* _tmp4;
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp5 = NULL;
				_tmp4 = NULL;
				(gst_message_parse_warning (message, &_tmp4, &_tmp6), err = (_tmp5 = _tmp4, (err == NULL) ? NULL : (err = (g_error_free (err), NULL)), _tmp5));
				err_msg = (_tmp7 = _tmp6, err_msg = (g_free (err_msg), NULL), _tmp7);
				g_warning ("rygel-live-response.vala:241: Warning from pipeline %s:%s", gst_object_get_name ((GstObject*) self->priv->pipeline), err_msg);
			}
		}
		(err == NULL) ? NULL : (err = (g_error_free (err), NULL));
		err_msg = (g_free (err_msg), NULL);
	}
	if (!ret) {
		rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
	}
	return ret;
}


static void rygel_live_response_class_init (RygelLiveResponseClass * klass) {
	rygel_live_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelLiveResponsePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_live_response_finalize;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->end = rygel_live_response_real_end;
}


static void rygel_live_response_instance_init (RygelLiveResponse * self) {
	self->priv = RYGEL_LIVE_RESPONSE_GET_PRIVATE (self);
}


static void rygel_live_response_finalize (GObject* obj) {
	RygelLiveResponse * self;
	self = RYGEL_LIVE_RESPONSE (obj);
	(self->priv->pipeline == NULL) ? NULL : (self->priv->pipeline = (gst_object_unref (self->priv->pipeline), NULL));
	(self->priv->buffers == NULL) ? NULL : (self->priv->buffers = (g_async_queue_unref (self->priv->buffers), NULL));
	G_OBJECT_CLASS (rygel_live_response_parent_class)->finalize (obj);
}


GType rygel_live_response_get_type (void) {
	static GType rygel_live_response_type_id = 0;
	if (rygel_live_response_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLiveResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_live_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLiveResponse), 0, (GInstanceInitFunc) rygel_live_response_instance_init, NULL };
		rygel_live_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE, "RygelLiveResponse", &g_define_type_info, 0);
	}
	return rygel_live_response_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__POINTER_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, gst_value_get_mini_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}



