/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_CONTENT_DIRECTORY_H__
#define __RYGEL_CONTENT_DIRECTORY_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-http-server.h>
#include <rygel-media-container.h>

G_BEGIN_DECLS


#define TYPE_BROWSE_ARGS (browse_args_get_type ())
#define BROWSE_ARGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSE_ARGS, BrowseArgs))
#define BROWSE_ARGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSE_ARGS, BrowseArgsClass))
#define IS_BROWSE_ARGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSE_ARGS))
#define IS_BROWSE_ARGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSE_ARGS))
#define BROWSE_ARGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSE_ARGS, BrowseArgsClass))

typedef struct _BrowseArgs BrowseArgs;
typedef struct _BrowseArgsClass BrowseArgsClass;
typedef struct _BrowseArgsPrivate BrowseArgsPrivate;
typedef struct _ParamSpecBrowseArgs ParamSpecBrowseArgs;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

/**
 * Errors used by ContentDirectory and deriving classes.
 */
typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _BrowseArgs {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BrowseArgsPrivate * priv;
	char* object_id;
	char* browse_flag;
	char* filter;
	guint index;
	guint requested_count;
	char* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
};

struct _BrowseArgsClass {
	GTypeClass parent_class;
	void (*finalize) (BrowseArgs *self);
};

struct _ParamSpecBrowseArgs {
	GParamSpec parent_instance;
};

/**
 * Basic implementation of UPnP ContentDirectory service version 2. Most often
 * plugins will provide a child of this class. The inheriting classes should
 * override add_children_metadata and add_metadata virtual methods.
 */
struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	guint32 system_update_id;
	char* feature_list;
	char* search_caps;
	char* sort_caps;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
	void (*add_children_metadata) (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
	void (*add_metadata) (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
	void (*add_root_children_metadata) (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
	void (*browse_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
};


GQuark rygel_content_directory_error_quark (void);
BrowseArgs* browse_args_construct (GType object_type);
BrowseArgs* browse_args_new (void);
GParamSpec* param_spec_browse_args (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer value_get_browse_args (const GValue* value);
void value_set_browse_args (GValue* value, gpointer v_object);
GType browse_args_get_type (void);
gpointer browse_args_ref (gpointer instance);
void browse_args_unref (gpointer instance);
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:2"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
void rygel_content_directory_add_children_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
void rygel_content_directory_add_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
void rygel_content_directory_add_root_children_metadata (RygelContentDirectory* self, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
void rygel_content_directory_browse_cb (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelContentDirectory* rygel_content_directory_construct (GType object_type);
RygelContentDirectory* rygel_content_directory_new (void);
GType rygel_content_directory_get_type (void);


G_END_DECLS

#endif
