/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-tracker-item.h"
#include <rygel-media-object.h>
#include <rygel-http-server.h>




enum  {
	RYGEL_TRACKER_ITEM_DUMMY_PROPERTY
};
static void rygel_tracker_item_real_fetch_metadata (RygelTrackerItem* self, GError** error);
static gpointer rygel_tracker_item_parent_class = NULL;
static void rygel_tracker_item_finalize (RygelMediaObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



RygelTrackerItem* rygel_tracker_item_construct (GType object_type, const char* id, const char* path, RygelTrackerContainer* parent, GError** error) {
	GError * inner_error;
	RygelTrackerItem* self;
	char* _tmp1;
	const char* _tmp0;
	RygelTrackerContainer* _tmp3;
	RygelTrackerContainer* _tmp2;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	inner_error = NULL;
	self = (RygelTrackerItem*) rygel_media_item_construct (object_type, id, ((RygelMediaObject*) parent)->id, "", parent->child_class, parent->http_server);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->path = (_tmp1 = (_tmp0 = path, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->path = (g_free (self->path), NULL), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->parent = (_tmp3 = (_tmp2 = parent, (_tmp2 == NULL) ? NULL : rygel_media_object_ref (_tmp2)), (self->parent == NULL) ? NULL : (self->parent = (rygel_media_object_unref (self->parent), NULL)), _tmp3);
	rygel_tracker_item_fetch_metadata (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return NULL;
	}
	return self;
}


RygelTrackerItem* rygel_tracker_item_new (const char* id, const char* path, RygelTrackerContainer* parent, GError** error) {
	return rygel_tracker_item_construct (RYGEL_TYPE_TRACKER_ITEM, id, path, parent, error);
}


char* rygel_tracker_item_seconds_to_iso8601 (RygelTrackerItem* self, const char* seconds) {
	char* date;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (seconds != NULL, NULL);
	date = NULL;
	if (_vala_strcmp0 (seconds, "") != 0) {
		GTimeVal _tmp0 = {0};
		GTimeVal tv;
		char* _tmp1;
		tv = (g_get_current_time (&_tmp0), _tmp0);
		tv.tv_sec = (glong) atoi (seconds);
		tv.tv_usec = (glong) 0;
		_tmp1 = NULL;
		date = (_tmp1 = g_time_val_to_iso8601 (&tv), date = (g_free (date), NULL), _tmp1);
	} else {
		char* _tmp2;
		_tmp2 = NULL;
		date = (_tmp2 = g_strdup (""), date = (g_free (date), NULL), _tmp2);
	}
	return date;
}


char* rygel_tracker_item_uri_from_path (RygelTrackerItem* self, const char* path) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	return g_strdup_printf ("file://%s", path);
}


static void rygel_tracker_item_real_fetch_metadata (RygelTrackerItem* self, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_tracker_item_fetch_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void rygel_tracker_item_fetch_metadata (RygelTrackerItem* self, GError** error) {
	RYGEL_TRACKER_ITEM_GET_CLASS (self)->fetch_metadata (self, error);
}


static void rygel_tracker_item_class_init (RygelTrackerItemClass * klass) {
	rygel_tracker_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_tracker_item_finalize;
	RYGEL_TRACKER_ITEM_CLASS (klass)->fetch_metadata = rygel_tracker_item_real_fetch_metadata;
}


static void rygel_tracker_item_instance_init (RygelTrackerItem * self) {
}


static void rygel_tracker_item_finalize (RygelMediaObject* obj) {
	RygelTrackerItem * self;
	self = RYGEL_TRACKER_ITEM (obj);
	(self->parent == NULL) ? NULL : (self->parent = (rygel_media_object_unref (self->parent), NULL));
	self->path = (g_free (self->path), NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_tracker_item_parent_class)->finalize (obj);
}


GType rygel_tracker_item_get_type (void) {
	static GType rygel_tracker_item_type_id = 0;
	if (rygel_tracker_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerItem), 0, (GInstanceInitFunc) rygel_tracker_item_instance_init, NULL };
		rygel_tracker_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelTrackerItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return rygel_tracker_item_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




