/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-dvb-content-dir.h"
#include <gee/arraylist.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <rygel-media-object.h>
#include <rygel-http-server.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include "rygel-dvb-channel-group.h"
#include "rygel-dvb-channel.h"




struct _RygelDVBContentDirPrivate {
	GeeArrayList* groups;
};

#define RYGEL_DVB_CONTENT_DIR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DVB_CONTENT_DIR, RygelDVBContentDirPrivate))
enum  {
	RYGEL_DVB_CONTENT_DIR_DUMMY_PROPERTY
};
#define RYGEL_DVB_CONTENT_DIR_DVB_SERVICE "org.gnome.DVB"
#define RYGEL_DVB_CONTENT_DIR_MANAGER_PATH "/org/gnome/DVB/Manager"
#define RYGEL_DVB_CONTENT_DIR_MANAGER_IFACE "org.gnome.DVB.Manager"
#define RYGEL_DVB_CONTENT_DIR_CHANNEL_LIST_IFACE "org.gnome.DVB.ChannelList"
guint* _dynamic_GetRegisteredDeviceGroups0 (DBusGProxy* self, int* result_length1, GError** error);
char* _dynamic_GetChannelList1 (DBusGProxy* self, guint param1, GError** error);
char* _dynamic_GetDeviceGroupName2 (DBusGProxy* self, guint param1, GError** error);
static void rygel_dvb_content_dir_real_constructed (GObject* base);
static void rygel_dvb_content_dir_real_add_children_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static void rygel_dvb_content_dir_real_add_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static void rygel_dvb_content_dir_real_add_root_children_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error);
static RygelDVBChannelGroup* rygel_dvb_content_dir_find_group_by_id (RygelDVBContentDir* self, const char* id);
static gboolean rygel_dvb_content_dir_add_channel (RygelDVBContentDir* self, GUPnPDIDLLiteWriter* didl_writer, const char* id, GError** error);
static gpointer rygel_dvb_content_dir_parent_class = NULL;
static void rygel_dvb_content_dir_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



guint* _dynamic_GetRegisteredDeviceGroups0 (DBusGProxy* self, int* result_length1, GError** error) {
	GArray* result;
	dbus_g_proxy_call (self, "GetRegisteredDeviceGroups", error, G_TYPE_INVALID, dbus_g_type_get_collection ("GArray", G_TYPE_UINT), &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	*result_length1 = result->len;
	return (guint*) result->data;
}


char* _dynamic_GetChannelList1 (DBusGProxy* self, guint param1, GError** error) {
	char* result;
	dbus_g_proxy_call (self, "GetChannelList", error, G_TYPE_UINT, param1, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


char* _dynamic_GetDeviceGroupName2 (DBusGProxy* self, guint param1, GError** error) {
	char* result;
	dbus_g_proxy_call (self, "GetDeviceGroupName", error, G_TYPE_UINT, param1, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


/* Pubic methods*/
static void rygel_dvb_content_dir_real_constructed (GObject* base) {
	RygelDVBContentDir * self;
	GError * inner_error;
	DBusGConnection* connection;
	DBusGProxy* _tmp2;
	guint* _tmp3;
	gint dev_groups_size;
	gint dev_groups_length1;
	guint* dev_groups;
	GeeArrayList* _tmp8;
	self = (RygelDVBContentDir*) base;
	inner_error = NULL;
	/* Chain-up to base first*/
	G_OBJECT_CLASS (rygel_dvb_content_dir_parent_class)->constructed ((GObject*) RYGEL_CONTENT_DIRECTORY (self));
	connection = NULL;
	{
		DBusGConnection* _tmp0;
		DBusGConnection* _tmp1;
		_tmp0 = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			goto __finally0;
		}
		_tmp1 = NULL;
		connection = (_tmp1 = _tmp0, (connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL)), _tmp1);
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			g_critical ("rygel-dvb-content-dir.vala:53: Failed to connect to Session bus: %s\n", error->message);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
			(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
			return;
		}
	}
	__finally0:
	if (inner_error != NULL) {
		(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	/* Get a proxy to DVB Manager object*/
	_tmp2 = NULL;
	self->manager = (_tmp2 = dbus_g_proxy_new_for_name (connection, RYGEL_DVB_CONTENT_DIR_DVB_SERVICE, RYGEL_DVB_CONTENT_DIR_MANAGER_PATH, RYGEL_DVB_CONTENT_DIR_MANAGER_IFACE), (self->manager == NULL) ? NULL : (self->manager = (g_object_unref (self->manager), NULL)), _tmp2);
	_tmp3 = NULL;
	dev_groups = (_tmp3 = NULL, dev_groups_length1 = 0, dev_groups_size = dev_groups_length1, _tmp3);
	{
		guint* _tmp6;
		gint _tmp5_size;
		gint _tmp5_length1;
		gint _tmp4;
		guint* _tmp5;
		guint* _tmp7;
		_tmp6 = NULL;
		_tmp5 = (_tmp6 = _dynamic_GetRegisteredDeviceGroups0 (self->manager, &_tmp4, &inner_error), _tmp5_length1 = _tmp4, _tmp5_size = _tmp5_length1, _tmp6);
		if (inner_error != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
		_tmp7 = NULL;
		dev_groups = (_tmp7 = _tmp5, dev_groups = (g_free (dev_groups), NULL), dev_groups_length1 = _tmp5_length1, dev_groups_size = dev_groups_length1, _tmp7);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			g_critical ("rygel-dvb-content-dir.vala:67: error: %s", error->message);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
			(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
			dev_groups = (g_free (dev_groups), NULL);
			return;
		}
	}
	__finally1:
	if (inner_error != NULL) {
		(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
		dev_groups = (g_free (dev_groups), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	if (self->priv->groups == NULL) {
		(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
		dev_groups = (g_free (dev_groups), NULL);
		return;
	}
	_tmp8 = NULL;
	self->priv->groups = (_tmp8 = gee_array_list_new (RYGEL_TYPE_DVB_CHANNEL_GROUP, (GBoxedCopyFunc) rygel_media_object_ref, rygel_media_object_unref, g_direct_equal), (self->priv->groups == NULL) ? NULL : (self->priv->groups = (g_object_unref (self->priv->groups), NULL)), _tmp8);
	{
		guint* group_id_collection;
		int group_id_collection_length1;
		int group_id_it;
		group_id_collection = dev_groups;
		group_id_collection_length1 = dev_groups_length1;
		for (group_id_it = 0; group_id_it < dev_groups_length1; group_id_it = group_id_it + 1) {
			guint group_id;
			group_id = group_id_collection[group_id_it];
			{
				char* channel_list_path;
				char* group_name;
				DBusGProxy* channel_list;
				RygelDVBChannelGroup* _tmp13;
				channel_list_path = NULL;
				group_name = NULL;
				{
					char* _tmp9;
					char* _tmp10;
					char* _tmp11;
					char* _tmp12;
					_tmp9 = _dynamic_GetChannelList1 (self->manager, group_id, &inner_error);
					if (inner_error != NULL) {
						goto __catch2_g_error;
						goto __finally2;
					}
					_tmp10 = NULL;
					channel_list_path = (_tmp10 = _tmp9, channel_list_path = (g_free (channel_list_path), NULL), _tmp10);
					_tmp11 = _dynamic_GetDeviceGroupName2 (self->manager, group_id, &inner_error);
					if (inner_error != NULL) {
						goto __catch2_g_error;
						goto __finally2;
					}
					/* Get the name of the group*/
					_tmp12 = NULL;
					group_name = (_tmp12 = _tmp11, group_name = (g_free (group_name), NULL), _tmp12);
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError * error;
					error = inner_error;
					inner_error = NULL;
					{
						g_critical ("rygel-dvb-content-dir.vala:86: error: %s", error->message);
						(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
						channel_list_path = (g_free (channel_list_path), NULL);
						group_name = (g_free (group_name), NULL);
						(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
						dev_groups = (g_free (dev_groups), NULL);
						return;
					}
				}
				__finally2:
				if (inner_error != NULL) {
					channel_list_path = (g_free (channel_list_path), NULL);
					group_name = (g_free (group_name), NULL);
					(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
					dev_groups = (g_free (dev_groups), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
					return;
				}
				/* Get a proxy to DVB ChannelList object*/
				channel_list = dbus_g_proxy_new_for_name (connection, RYGEL_DVB_CONTENT_DIR_DVB_SERVICE, channel_list_path, RYGEL_DVB_CONTENT_DIR_CHANNEL_LIST_IFACE);
				/* Create ChannelGroup for each registered device group*/
				_tmp13 = NULL;
				gee_collection_add ((GeeCollection*) self->priv->groups, _tmp13 = rygel_dvb_channel_group_new (group_id, group_name, ((RygelMediaObject*) ((RygelContentDirectory*) self)->root_container)->id, channel_list, ((RygelContentDirectory*) self)->http_server));
				(_tmp13 == NULL) ? NULL : (_tmp13 = (rygel_media_object_unref (_tmp13), NULL));
				channel_list_path = (g_free (channel_list_path), NULL);
				group_name = (g_free (group_name), NULL);
				(channel_list == NULL) ? NULL : (channel_list = (g_object_unref (channel_list), NULL));
			}
		}
	}
	(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
	dev_groups = (g_free (dev_groups), NULL);
}


static void rygel_dvb_content_dir_real_add_children_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RygelDVBContentDir * self;
	GError * inner_error;
	RygelDVBChannelGroup* group;
	RygelDVBChannelGroup* _tmp0;
	guint _tmp1;
	self = (RygelDVBContentDir*) base;
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	group = NULL;
	_tmp0 = NULL;
	group = (_tmp0 = rygel_dvb_content_dir_find_group_by_id (self, args->object_id), (group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL)), _tmp0);
	if (group == NULL) {
		inner_error = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "No such object");
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
			return;
		}
	}
	_tmp1 = rygel_dvb_channel_group_add_channels (group, didl_writer, args->index, args->requested_count, &args->total_matches, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
		return;
	}
	args->number_returned = _tmp1;
	args->update_id = (guint) G_MAXUINT32;
	(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
}


static void rygel_dvb_content_dir_real_add_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RygelDVBContentDir * self;
	GError * inner_error;
	gboolean found;
	RygelDVBChannelGroup* group;
	RygelDVBChannelGroup* _tmp0;
	self = (RygelDVBContentDir*) base;
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	found = FALSE;
	group = NULL;
	/* First try groups*/
	_tmp0 = NULL;
	group = (_tmp0 = rygel_dvb_content_dir_find_group_by_id (self, args->object_id), (group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL)), _tmp0);
	if (group != NULL) {
		rygel_media_object_serialize ((RygelMediaObject*) group, didl_writer, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
			return;
		}
		found = TRUE;
	} else {
		gboolean _tmp1;
		_tmp1 = rygel_dvb_content_dir_add_channel (self, didl_writer, args->object_id, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
			return;
		}
		/* Now try channels*/
		found = _tmp1;
	}
	if (!found) {
		inner_error = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "No such object");
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
			return;
		}
	}
	args->update_id = (guint) G_MAXUINT32;
	(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
}


static void rygel_dvb_content_dir_real_add_root_children_metadata (RygelContentDirectory* base, GUPnPDIDLLiteWriter* didl_writer, BrowseArgs* args, GError** error) {
	RygelDVBContentDir * self;
	GError * inner_error;
	self = (RygelDVBContentDir*) base;
	g_return_if_fail (didl_writer != NULL);
	g_return_if_fail (args != NULL);
	inner_error = NULL;
	{
		GeeIterator* _group_it;
		_group_it = gee_iterable_iterator ((GeeIterable*) self->priv->groups);
		while (gee_iterator_next (_group_it)) {
			RygelDVBChannelGroup* group;
			group = (RygelDVBChannelGroup*) gee_iterator_get (_group_it);
			rygel_media_object_serialize ((RygelMediaObject*) group, didl_writer, &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
				(_group_it == NULL) ? NULL : (_group_it = (g_object_unref (_group_it), NULL));
				return;
			}
			(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
		}
		(_group_it == NULL) ? NULL : (_group_it = (g_object_unref (_group_it), NULL));
	}
	args->total_matches = args->number_returned = (guint) gee_collection_get_size ((GeeCollection*) self->priv->groups);
	args->update_id = (guint) G_MAXUINT32;
}


/* Private methods*/
static RygelDVBChannelGroup* rygel_dvb_content_dir_find_group_by_id (RygelDVBContentDir* self, const char* id) {
	RygelDVBChannelGroup* group;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	group = NULL;
	{
		GeeIterator* _tmp_it;
		_tmp_it = gee_iterable_iterator ((GeeIterable*) self->priv->groups);
		while (gee_iterator_next (_tmp_it)) {
			RygelDVBChannelGroup* tmp;
			tmp = (RygelDVBChannelGroup*) gee_iterator_get (_tmp_it);
			if (_vala_strcmp0 (id, ((RygelMediaObject*) tmp)->id) == 0) {
				RygelDVBChannelGroup* _tmp1;
				RygelDVBChannelGroup* _tmp0;
				_tmp1 = NULL;
				_tmp0 = NULL;
				group = (_tmp1 = (_tmp0 = tmp, (_tmp0 == NULL) ? NULL : rygel_media_object_ref (_tmp0)), (group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL)), _tmp1);
				(tmp == NULL) ? NULL : (tmp = (rygel_media_object_unref (tmp), NULL));
				break;
			}
			(tmp == NULL) ? NULL : (tmp = (rygel_media_object_unref (tmp), NULL));
		}
		(_tmp_it == NULL) ? NULL : (_tmp_it = (g_object_unref (_tmp_it), NULL));
	}
	return group;
}


static gboolean rygel_dvb_content_dir_add_channel (RygelDVBContentDir* self, GUPnPDIDLLiteWriter* didl_writer, const char* id, GError** error) {
	GError * inner_error;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (didl_writer != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	inner_error = NULL;
	found = FALSE;
	{
		GeeIterator* _group_it;
		_group_it = gee_iterable_iterator ((GeeIterable*) self->priv->groups);
		while (gee_iterator_next (_group_it)) {
			RygelDVBChannelGroup* group;
			RygelDVBChannel* channel;
			group = (RygelDVBChannelGroup*) gee_iterator_get (_group_it);
			channel = rygel_dvb_channel_group_find_channel (group, id);
			if (channel != NULL) {
				rygel_media_object_serialize ((RygelMediaObject*) channel, didl_writer, &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
					(channel == NULL) ? NULL : (channel = (rygel_media_object_unref (channel), NULL));
					(_group_it == NULL) ? NULL : (_group_it = (g_object_unref (_group_it), NULL));
					return FALSE;
				}
				found = TRUE;
				(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
				(channel == NULL) ? NULL : (channel = (rygel_media_object_unref (channel), NULL));
				break;
			}
			(group == NULL) ? NULL : (group = (rygel_media_object_unref (group), NULL));
			(channel == NULL) ? NULL : (channel = (rygel_media_object_unref (channel), NULL));
		}
		(_group_it == NULL) ? NULL : (_group_it = (g_object_unref (_group_it), NULL));
	}
	return found;
}


/**
 * Implementation of DVB ContentDirectory service.
 */
RygelDVBContentDir* rygel_dvb_content_dir_construct (GType object_type) {
	RygelDVBContentDir * self;
	self = (RygelDVBContentDir*) rygel_content_directory_construct (object_type);
	return self;
}


RygelDVBContentDir* rygel_dvb_content_dir_new (void) {
	return rygel_dvb_content_dir_construct (RYGEL_TYPE_DVB_CONTENT_DIR);
}


static void rygel_dvb_content_dir_class_init (RygelDVBContentDirClass * klass) {
	rygel_dvb_content_dir_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDVBContentDirPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_dvb_content_dir_finalize;
	G_OBJECT_CLASS (klass)->constructed = rygel_dvb_content_dir_real_constructed;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_children_metadata = rygel_dvb_content_dir_real_add_children_metadata;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_metadata = rygel_dvb_content_dir_real_add_metadata;
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->add_root_children_metadata = rygel_dvb_content_dir_real_add_root_children_metadata;
}


static void rygel_dvb_content_dir_instance_init (RygelDVBContentDir * self) {
	self->priv = RYGEL_DVB_CONTENT_DIR_GET_PRIVATE (self);
}


static void rygel_dvb_content_dir_finalize (GObject* obj) {
	RygelDVBContentDir * self;
	self = RYGEL_DVB_CONTENT_DIR (obj);
	(self->manager == NULL) ? NULL : (self->manager = (g_object_unref (self->manager), NULL));
	(self->priv->groups == NULL) ? NULL : (self->priv->groups = (g_object_unref (self->priv->groups), NULL));
	G_OBJECT_CLASS (rygel_dvb_content_dir_parent_class)->finalize (obj);
}


GType rygel_dvb_content_dir_get_type (void) {
	static GType rygel_dvb_content_dir_type_id = 0;
	if (rygel_dvb_content_dir_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDVBContentDirClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dvb_content_dir_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDVBContentDir), 0, (GInstanceInitFunc) rygel_dvb_content_dir_instance_init, NULL };
		rygel_dvb_content_dir_type_id = g_type_register_static (RYGEL_TYPE_CONTENT_DIRECTORY, "RygelDVBContentDir", &g_define_type_info, 0);
	}
	return rygel_dvb_content_dir_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




