/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_DVB_CHANNEL_GROUP_H__
#define __RYGEL_DVB_CHANNEL_GROUP_H__

#include <glib.h>
#include <glib-object.h>
#include <rygel-media-container.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <rygel-http-server.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include "rygel-dvb-channel.h"

G_BEGIN_DECLS


#define RYGEL_TYPE_DVB_CHANNEL_GROUP (rygel_dvb_channel_group_get_type ())
#define RYGEL_DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DVB_CHANNEL_GROUP, RygelDVBChannelGroup))
#define RYGEL_DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DVB_CHANNEL_GROUP, RygelDVBChannelGroupClass))
#define RYGEL_IS_DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DVB_CHANNEL_GROUP))
#define RYGEL_IS_DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DVB_CHANNEL_GROUP))
#define RYGEL_DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DVB_CHANNEL_GROUP, RygelDVBChannelGroupClass))

typedef struct _RygelDVBChannelGroup RygelDVBChannelGroup;
typedef struct _RygelDVBChannelGroupClass RygelDVBChannelGroupClass;
typedef struct _RygelDVBChannelGroupPrivate RygelDVBChannelGroupPrivate;

/**
 * Represents DVB channel group.
 */
struct _RygelDVBChannelGroup {
	RygelMediaContainer parent_instance;
	RygelDVBChannelGroupPrivate * priv;
	RygelHTTPServer* http_server;
};

struct _RygelDVBChannelGroupClass {
	RygelMediaContainerClass parent_class;
};


extern DBusGProxy* rygel_dvb_channel_group_channel_list;
RygelDVBChannelGroup* rygel_dvb_channel_group_construct (GType object_type, guint gid, const char* title, const char* parent_id, DBusGProxy* channel_list, RygelHTTPServer* http_server);
RygelDVBChannelGroup* rygel_dvb_channel_group_new (guint gid, const char* title, const char* parent_id, DBusGProxy* channel_list, RygelHTTPServer* http_server);
guint rygel_dvb_channel_group_add_channels (RygelDVBChannelGroup* self, GUPnPDIDLLiteWriter* didl_writer, guint index, guint requested_count, guint* total_matches, GError** error);
RygelDVBChannel* rygel_dvb_channel_group_find_channel (RygelDVBChannelGroup* self, const char* id);
GType rygel_dvb_channel_group_get_type (void);


G_END_DECLS

#endif
