/* rygel-tracker-insertion-query.c generated by valac 0.18.1, the Vala compiler
 * generated from rygel-tracker-insertion-query.vala, do not modify */

/*
 * Copyright (C) 2010-2012 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-server.h>


#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;

#define RYGEL_TRACKER_TYPE_INSERTION_QUERY (rygel_tracker_insertion_query_get_type ())
#define RYGEL_TRACKER_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQuery))
#define RYGEL_TRACKER_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))
#define RYGEL_TRACKER_IS_INSERTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_IS_INSERTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_INSERTION_QUERY))
#define RYGEL_TRACKER_INSERTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryClass))

typedef struct _RygelTrackerInsertionQuery RygelTrackerInsertionQuery;
typedef struct _RygelTrackerInsertionQueryClass RygelTrackerInsertionQueryClass;
typedef struct _RygelTrackerInsertionQueryPrivate RygelTrackerInsertionQueryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE (rygel_tracker_miner_files_index_iface_get_type ())
#define RYGEL_TRACKER_MINER_FILES_INDEX_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE, RygelTrackerMinerFilesIndexIface))
#define RYGEL_TRACKER_IS_MINER_FILES_INDEX_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE))
#define RYGEL_TRACKER_MINER_FILES_INDEX_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE, RygelTrackerMinerFilesIndexIfaceIface))

typedef struct _RygelTrackerMinerFilesIndexIface RygelTrackerMinerFilesIndexIface;
typedef struct _RygelTrackerMinerFilesIndexIfaceIface RygelTrackerMinerFilesIndexIfaceIface;

#define RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE_PROXY (rygel_tracker_miner_files_index_iface_proxy_get_type ())
typedef struct _RygelTrackerInsertionQueryExecuteData RygelTrackerInsertionQueryExecuteData;

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerInsertionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerInsertionQueryPrivate * priv;
	gchar* id;
};

struct _RygelTrackerInsertionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerInsertionQueryPrivate {
	gchar* uri;
};

struct _RygelTrackerMinerFilesIndexIfaceIface {
	GTypeInterface parent_iface;
	void (*index_file) (RygelTrackerMinerFilesIndexIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*index_file_finish) (RygelTrackerMinerFilesIndexIface* self, GAsyncResult* _res_, GError** error);
};

struct _RygelTrackerInsertionQueryExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerInsertionQuery* self;
	TrackerSparqlConnection* resources;
	gchar* _tmp0_;
	gchar* str;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* v;
	GVariantIter* iter1;
	GVariantIter* iter2;
	GVariantIter* iter3;
	gchar* key;
	GVariant* _tmp5_;
	GVariantIter* _tmp6_;
	GVariantIter* _tmp7_;
	gboolean _tmp8_;
	GVariantIter* _tmp9_;
	gboolean _tmp10_;
	GVariantIter* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	TrackerSparqlConnection* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	TrackerSparqlCursor* _tmp17_;
	TrackerSparqlCursor* _tmp18_;
	TrackerSparqlCursor* cursor;
	TrackerSparqlCursor* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	TrackerSparqlCursor* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	GError* _error_;
	const gchar* _tmp25_;
	GFile* _tmp26_;
	GFile* file;
	gboolean _tmp27_;
	GFile* _tmp28_;
	gboolean _tmp29_;
	GFile* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	RygelTrackerMinerFilesIndexIface* _tmp33_;
	RygelTrackerMinerFilesIndexIface* miner;
	RygelTrackerMinerFilesIndexIface* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_insertion_query_parent_class = NULL;

gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
GType rygel_tracker_insertion_query_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_INSERTION_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQueryPrivate))
enum  {
	RYGEL_TRACKER_INSERTION_QUERY_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID "x"
#define RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID "_:" RYGEL_TRACKER_INSERTION_QUERY_TEMP_ID
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_SERVICE "org.freedesktop.Tracker1.Miner.Files.Index"
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_PATH "/org/freedesktop/Tracker1/Miner/Files/Index"
#define RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH "urn:uuid:472ed0cc-40ff-4e37-9c0c-062d78656540"
#define RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_ID_QUERY_TEMPLATE "SELECT ?resource WHERE { ?resource a nie:DataObject; nie:url '%s' }"
#define RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_NOT_BOUND_TEMPLATE "OPTIONAL { ?resource a nie:DataObject; nie:url '%s' } " "FILTER (!bound(?resource))"
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_new (RygelMediaItem* item, const gchar* category);
RygelTrackerInsertionQuery* rygel_tracker_insertion_query_construct (GType object_type, RygelMediaItem* item, const gchar* category);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const gchar* subject, const gchar* predicate, const gchar* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const gchar* subject, const gchar* predicate, const gchar* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new_with_graph (const gchar* graph, const gchar* subject, const gchar* predicate, const gchar* object);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct_with_graph (GType object_type, const gchar* graph, const gchar* subject, const gchar* predicate, const gchar* object);
RygelTrackerQuery* rygel_tracker_query_construct (GType object_type, RygelTrackerQueryTriplets* triplets);
static void rygel_tracker_insertion_query_real_execute_data_free (gpointer _data);
static void rygel_tracker_insertion_query_real_execute (RygelTrackerQuery* base, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_insertion_query_real_execute_co (RygelTrackerInsertionQueryExecuteData* _data_);
gchar* rygel_tracker_query_to_string (RygelTrackerQuery* self);
static void rygel_tracker_insertion_query_execute_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* rygel_tracker_insertion_query_get_resource_id_query (RygelTrackerInsertionQuery* self);
GType rygel_tracker_miner_files_index_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_miner_files_index_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_tracker_miner_files_index_iface_get_type (void) G_GNUC_CONST;
void rygel_tracker_miner_files_index_iface_index_file (RygelTrackerMinerFilesIndexIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_miner_files_index_iface_index_file_finish (RygelTrackerMinerFilesIndexIface* self, GAsyncResult* _res_, GError** error);
static gchar* rygel_tracker_insertion_query_real_to_string (RygelTrackerQuery* base);
static void rygel_tracker_insertion_query_finalize (RygelTrackerQuery* obj);


RygelTrackerInsertionQuery* rygel_tracker_insertion_query_construct (GType object_type, RygelMediaItem* item, const gchar* category) {
	RygelTrackerInsertionQuery* self = NULL;
	gchar* _tmp0_;
	gchar* type;
	RygelMediaItem* _tmp1_;
	GeeArrayList* _tmp2_;
	gpointer _tmp3_ = NULL;
	gchar* _tmp4_;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_;
	GFile* file;
	GFile* _tmp7_;
	gboolean _tmp8_ = FALSE;
	RygelTrackerQueryTriplets* _tmp10_;
	RygelTrackerQueryTriplets* triplets;
	RygelTrackerQueryTriplets* _tmp11_;
	const gchar* _tmp12_;
	RygelTrackerQueryTriplet* _tmp13_;
	RygelTrackerQueryTriplet* _tmp14_;
	RygelTrackerQueryTriplets* _tmp15_;
	const gchar* _tmp16_;
	RygelTrackerQueryTriplet* _tmp17_;
	RygelTrackerQueryTriplet* _tmp18_;
	RygelTrackerQueryTriplets* _tmp19_;
	RygelTrackerQueryTriplet* _tmp20_;
	RygelTrackerQueryTriplet* _tmp21_;
	RygelTrackerQueryTriplets* _tmp22_;
	RygelTrackerQueryTriplet* _tmp23_;
	RygelTrackerQueryTriplet* _tmp24_;
	RygelTrackerQueryTriplets* _tmp25_;
	RygelTrackerQueryTriplet* _tmp26_;
	RygelTrackerQueryTriplet* _tmp27_;
	RygelTrackerQueryTriplets* _tmp28_;
	RygelMediaItem* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	RygelTrackerQueryTriplet* _tmp36_;
	RygelTrackerQueryTriplet* _tmp37_;
	RygelTrackerQueryTriplets* _tmp38_;
	RygelMediaItem* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	RygelTrackerQueryTriplet* _tmp46_;
	RygelTrackerQueryTriplet* _tmp47_;
	gchar* _tmp48_;
	gchar* dlna_profile;
	RygelMediaItem* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	RygelTrackerQueryTriplets* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	RygelTrackerQueryTriplet* _tmp62_;
	RygelTrackerQueryTriplet* _tmp63_;
	RygelTrackerQueryTriplets* _tmp64_;
	RygelMediaItem* _tmp65_;
	GeeArrayList* _tmp66_;
	gpointer _tmp67_ = NULL;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	RygelTrackerQueryTriplet* _tmp73_;
	RygelTrackerQueryTriplet* _tmp74_;
	gchar* date = NULL;
	RygelMediaItem* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	RygelTrackerQueryTriplets* _tmp83_;
	const gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	RygelTrackerQueryTriplet* _tmp89_;
	RygelTrackerQueryTriplet* _tmp90_;
	RygelMediaItem* _tmp91_;
	gint64 _tmp92_;
	gint64 _tmp93_;
	RygelTrackerQueryTriplets* _tmp106_;
	RygelMediaItem* _tmp107_;
	GeeArrayList* _tmp108_;
	gpointer _tmp109_ = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = g_strdup ("nie:DataObject");
	type = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = ((RygelMediaObject*) _tmp1_)->uris;
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, 0);
	_tmp4_ = (gchar*) _tmp3_;
	_tmp5_ = g_file_new_for_uri (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	file = _tmp6_;
	_tmp7_ = file;
	_tmp8_ = g_file_is_native (_tmp7_);
	if (!_tmp8_) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("nfo:RemoteDataObject");
		_g_free0 (type);
		type = _tmp9_;
	}
	_tmp10_ = rygel_tracker_query_triplets_new ();
	triplets = _tmp10_;
	_tmp11_ = triplets;
	_tmp12_ = category;
	_tmp13_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "a", _tmp12_);
	_tmp14_ = _tmp13_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp14_);
	_rygel_tracker_query_triplet_unref0 (_tmp14_);
	_tmp15_ = triplets;
	_tmp16_ = type;
	_tmp17_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "a", _tmp16_);
	_tmp18_ = _tmp17_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp18_);
	_rygel_tracker_query_triplet_unref0 (_tmp18_);
	_tmp19_ = triplets;
	_tmp20_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nmm:uPnPShared", "true");
	_tmp21_ = _tmp20_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp21_);
	_rygel_tracker_query_triplet_unref0 (_tmp21_);
	_tmp22_ = triplets;
	_tmp23_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "tracker:available", "true");
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp24_);
	_rygel_tracker_query_triplet_unref0 (_tmp24_);
	_tmp25_ = triplets;
	_tmp26_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:generator", "\"rygel\"");
	_tmp27_ = _tmp26_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp27_);
	_rygel_tracker_query_triplet_unref0 (_tmp27_);
	_tmp28_ = triplets;
	_tmp29_ = item;
	_tmp30_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat ("\"", _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, "\"", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:title", _tmp35_);
	_tmp37_ = _tmp36_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp37_);
	_rygel_tracker_query_triplet_unref0 (_tmp37_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_tmp38_ = triplets;
	_tmp39_ = item;
	_tmp40_ = rygel_media_item_get_mime_type (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = rygel_tracker_query_triplet_new_with_graph (RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH, RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:mimeType", _tmp45_);
	_tmp47_ = _tmp46_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, _tmp47_);
	_rygel_tracker_query_triplet_unref0 (_tmp47_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp43_);
	_tmp48_ = g_strdup ("");
	dlna_profile = _tmp48_;
	_tmp49_ = item;
	_tmp50_ = rygel_media_item_get_dlna_profile (_tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_ != NULL) {
		RygelMediaItem* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp52_ = item;
		_tmp53_ = rygel_media_item_get_dlna_profile (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strdup (_tmp54_);
		_g_free0 (dlna_profile);
		dlna_profile = _tmp55_;
	}
	_tmp56_ = triplets;
	_tmp57_ = dlna_profile;
	_tmp58_ = g_strconcat ("\"", _tmp57_, NULL);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_strconcat (_tmp59_, "\"", NULL);
	_tmp61_ = _tmp60_;
	_tmp62_ = rygel_tracker_query_triplet_new_with_graph (RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH, RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nmm:dlnaProfile", _tmp61_);
	_tmp63_ = _tmp62_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp63_);
	_rygel_tracker_query_triplet_unref0 (_tmp63_);
	_g_free0 (_tmp61_);
	_g_free0 (_tmp59_);
	_tmp64_ = triplets;
	_tmp65_ = item;
	_tmp66_ = ((RygelMediaObject*) _tmp65_)->uris;
	_tmp67_ = gee_abstract_list_get ((GeeAbstractList*) _tmp66_, 0);
	_tmp68_ = (gchar*) _tmp67_;
	_tmp69_ = g_strconcat ("\"", _tmp68_, NULL);
	_tmp70_ = _tmp69_;
	_tmp71_ = g_strconcat (_tmp70_, "\"", NULL);
	_tmp72_ = _tmp71_;
	_tmp73_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:url", _tmp72_);
	_tmp74_ = _tmp73_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, _tmp74_);
	_rygel_tracker_query_triplet_unref0 (_tmp74_);
	_g_free0 (_tmp72_);
	_g_free0 (_tmp70_);
	_g_free0 (_tmp68_);
	_tmp75_ = item;
	_tmp76_ = rygel_media_item_get_date (_tmp75_);
	_tmp77_ = _tmp76_;
	if (_tmp77_ == NULL) {
		GTimeVal now = {0};
		gchar* _tmp78_ = NULL;
		g_get_current_time (&now);
		_tmp78_ = g_time_val_to_iso8601 (&now);
		_g_free0 (date);
		date = _tmp78_;
	} else {
		RygelMediaItem* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		gchar* _tmp82_;
		_tmp79_ = item;
		_tmp80_ = rygel_media_item_get_date (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_strdup (_tmp81_);
		_g_free0 (date);
		date = _tmp82_;
	}
	_tmp83_ = triplets;
	_tmp84_ = date;
	_tmp85_ = g_strconcat ("\"", _tmp84_, NULL);
	_tmp86_ = _tmp85_;
	_tmp87_ = g_strconcat (_tmp86_, "\"", NULL);
	_tmp88_ = _tmp87_;
	_tmp89_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:contentCreated", _tmp88_);
	_tmp90_ = _tmp89_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp83_, _tmp90_);
	_rygel_tracker_query_triplet_unref0 (_tmp90_);
	_g_free0 (_tmp88_);
	_g_free0 (_tmp86_);
	_tmp91_ = item;
	_tmp92_ = rygel_media_item_get_size (_tmp91_);
	_tmp93_ = _tmp92_;
	if (_tmp93_ > ((gint64) 0)) {
		RygelTrackerQueryTriplets* _tmp94_;
		RygelMediaItem* _tmp95_;
		gint64 _tmp96_;
		gint64 _tmp97_;
		gchar* _tmp98_ = NULL;
		gchar* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		RygelTrackerQueryTriplet* _tmp104_;
		RygelTrackerQueryTriplet* _tmp105_;
		_tmp94_ = triplets;
		_tmp95_ = item;
		_tmp96_ = rygel_media_item_get_size (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = g_strconcat ("\"", _tmp99_, NULL);
		_tmp101_ = _tmp100_;
		_tmp102_ = g_strconcat (_tmp101_, "\"", NULL);
		_tmp103_ = _tmp102_;
		_tmp104_ = rygel_tracker_query_triplet_new_with_graph (RYGEL_TRACKER_INSERTION_QUERY_MINER_GRAPH, RYGEL_TRACKER_INSERTION_QUERY_QUERY_ID, "nie:byteSize", _tmp103_);
		_tmp105_ = _tmp104_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp94_, _tmp105_);
		_rygel_tracker_query_triplet_unref0 (_tmp105_);
		_g_free0 (_tmp103_);
		_g_free0 (_tmp101_);
		_g_free0 (_tmp99_);
	}
	_tmp106_ = triplets;
	self = (RygelTrackerInsertionQuery*) rygel_tracker_query_construct (object_type, _tmp106_);
	_tmp107_ = item;
	_tmp108_ = ((RygelMediaObject*) _tmp107_)->uris;
	_tmp109_ = gee_abstract_list_get ((GeeAbstractList*) _tmp108_, 0);
	_g_free0 (self->priv->uri);
	self->priv->uri = (gchar*) _tmp109_;
	_g_free0 (date);
	_g_free0 (dlna_profile);
	_g_object_unref0 (triplets);
	_g_object_unref0 (file);
	_g_free0 (type);
	return self;
}


RygelTrackerInsertionQuery* rygel_tracker_insertion_query_new (RygelMediaItem* item, const gchar* category) {
	return rygel_tracker_insertion_query_construct (RYGEL_TRACKER_TYPE_INSERTION_QUERY, item, category);
}


static void rygel_tracker_insertion_query_real_execute_data_free (gpointer _data) {
	RygelTrackerInsertionQueryExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->resources);
	_rygel_tracker_query_unref0 (_data_->self);
	g_slice_free (RygelTrackerInsertionQueryExecuteData, _data_);
}


static gpointer _rygel_tracker_query_ref0 (gpointer self) {
	return self ? rygel_tracker_query_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_insertion_query_real_execute (RygelTrackerQuery* base, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerInsertionQuery * self;
	RygelTrackerInsertionQueryExecuteData* _data_;
	RygelTrackerInsertionQuery* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	self = (RygelTrackerInsertionQuery*) base;
	_data_ = g_slice_new0 (RygelTrackerInsertionQueryExecuteData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_tracker_insertion_query_real_execute);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_insertion_query_real_execute_data_free);
	_tmp0_ = _rygel_tracker_query_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = resources;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->resources);
	_data_->resources = _tmp2_;
	rygel_tracker_insertion_query_real_execute_co (_data_);
}


static void rygel_tracker_insertion_query_real_execute_finish (RygelTrackerQuery* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerInsertionQueryExecuteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_insertion_query_execute_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerInsertionQueryExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_insertion_query_real_execute_co (_data_);
}


static gboolean rygel_tracker_insertion_query_real_execute_co (RygelTrackerInsertionQueryExecuteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_tracker_query_to_string ((RygelTrackerQuery*) _data_->self);
	_data_->str = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->str;
	g_debug ("rygel-tracker-insertion-query.vala:127: Executing SPARQL query: %s", _data_->_tmp1_);
	_data_->_tmp2_ = _data_->resources;
	_data_->_tmp3_ = _data_->str;
	_data_->_state_ = 1;
	tracker_sparql_connection_update_blank_async (_data_->_tmp2_, _data_->_tmp3_, G_PRIORITY_DEFAULT, NULL, rygel_tracker_insertion_query_execute_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = tracker_sparql_connection_update_blank_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
	_data_->v = _data_->_tmp4_;
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->str);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->key = NULL;
	_data_->_tmp5_ = _data_->v;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_variant_iter_new (_data_->_tmp5_);
	_g_variant_iter_free0 (_data_->iter1);
	_data_->iter1 = _data_->_tmp6_;
	while (TRUE) {
		_data_->_tmp7_ = _data_->iter1;
		_data_->_tmp8_ = FALSE;
		_data_->_tmp8_ = g_variant_iter_next (_data_->_tmp7_, "aa{ss}", &_data_->iter2, NULL);
		if (!_data_->_tmp8_) {
			break;
		}
		while (TRUE) {
			_data_->_tmp9_ = _data_->iter2;
			_data_->_tmp10_ = FALSE;
			_data_->_tmp10_ = g_variant_iter_next (_data_->_tmp9_, "a{ss}", &_data_->iter3, NULL);
			if (!_data_->_tmp10_) {
				break;
			}
			while (TRUE) {
				_data_->_tmp11_ = _data_->iter3;
				_data_->_tmp12_ = FALSE;
				_data_->_tmp12_ = g_variant_iter_next (_data_->_tmp11_, "{ss}", &_data_->key, &_data_->self->id, NULL);
				if (!_data_->_tmp12_) {
					break;
				}
				break;
			}
		}
	}
	_data_->_tmp13_ = _data_->self->id;
	if (_data_->_tmp13_ == NULL) {
		_data_->_tmp14_ = _data_->resources;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = rygel_tracker_insertion_query_get_resource_id_query (_data_->self);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_state_ = 2;
		tracker_sparql_connection_query_async (_data_->_tmp14_, _data_->_tmp16_, NULL, rygel_tracker_insertion_query_execute_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = tracker_sparql_connection_query_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_g_free0 (_data_->_tmp16_);
		_data_->cursor = _data_->_tmp18_;
		if (_data_->_inner_error_ != NULL) {
			if (((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_free0 (_data_->key);
				_g_variant_iter_free0 (_data_->iter3);
				_g_variant_iter_free0 (_data_->iter2);
				_g_variant_iter_free0 (_data_->iter1);
				_g_variant_unref0 (_data_->v);
				_g_free0 (_data_->str);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_free0 (_data_->key);
				_g_variant_iter_free0 (_data_->iter3);
				_g_variant_iter_free0 (_data_->iter2);
				_g_variant_iter_free0 (_data_->iter1);
				_g_variant_unref0 (_data_->v);
				_g_free0 (_data_->str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		{
			while (TRUE) {
				_data_->_tmp19_ = _data_->cursor;
				_data_->_tmp20_ = FALSE;
				_data_->_tmp20_ = tracker_sparql_cursor_next (_data_->_tmp19_, NULL, &_data_->_inner_error_);
				_data_->_tmp21_ = _data_->_tmp20_;
				if (_data_->_inner_error_ != NULL) {
					goto __catch10_g_error;
				}
				if (!_data_->_tmp21_) {
					break;
				}
				_data_->_tmp22_ = _data_->cursor;
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = tracker_sparql_cursor_get_string (_data_->_tmp22_, 0, NULL);
				_data_->_tmp24_ = g_strdup (_data_->_tmp23_);
				_g_free0 (_data_->self->id);
				_data_->self->id = _data_->_tmp24_;
				break;
			}
		}
		goto __finally10;
		__catch10_g_error:
		{
			_data_->_error_ = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->_error_);
		}
		__finally10:
		if (_data_->_inner_error_ != NULL) {
			if (((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->cursor);
				_g_free0 (_data_->key);
				_g_variant_iter_free0 (_data_->iter3);
				_g_variant_iter_free0 (_data_->iter2);
				_g_variant_iter_free0 (_data_->iter1);
				_g_variant_unref0 (_data_->v);
				_g_free0 (_data_->str);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->cursor);
				_g_free0 (_data_->key);
				_g_variant_iter_free0 (_data_->iter3);
				_g_variant_iter_free0 (_data_->iter2);
				_g_variant_iter_free0 (_data_->iter1);
				_g_variant_unref0 (_data_->v);
				_g_free0 (_data_->str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_g_object_unref0 (_data_->cursor);
	} else {
		_data_->_tmp25_ = _data_->self->priv->uri;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = g_file_new_for_uri (_data_->_tmp25_);
		_data_->file = _data_->_tmp26_;
		_data_->_tmp28_ = _data_->file;
		_data_->_tmp29_ = FALSE;
		_data_->_tmp29_ = g_file_is_native (_data_->_tmp28_);
		if (_data_->_tmp29_) {
			_data_->_tmp30_ = _data_->file;
			_data_->_tmp31_ = FALSE;
			_data_->_tmp31_ = g_file_query_exists (_data_->_tmp30_, NULL);
			_data_->_tmp27_ = _data_->_tmp31_;
		} else {
			_data_->_tmp27_ = FALSE;
		}
		_data_->_tmp32_ = _data_->_tmp27_;
		if (_data_->_tmp32_) {
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = g_initable_new (RYGEL_TRACKER_TYPE_MINER_FILES_INDEX_IFACE_PROXY, NULL, &_data_->_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_TRACKER_INSERTION_QUERY_MINER_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_TRACKER_INSERTION_QUERY_MINER_PATH, "g-interface-name", "org.freedesktop.Tracker1.Miner.Files.Index", NULL);
			_data_->miner = (RygelTrackerMinerFilesIndexIface*) _data_->_tmp33_;
			if (_data_->_inner_error_ != NULL) {
				if (((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_object_unref0 (_data_->file);
					_g_free0 (_data_->key);
					_g_variant_iter_free0 (_data_->iter3);
					_g_variant_iter_free0 (_data_->iter2);
					_g_variant_iter_free0 (_data_->iter1);
					_g_variant_unref0 (_data_->v);
					_g_free0 (_data_->str);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				} else {
					_g_object_unref0 (_data_->file);
					_g_free0 (_data_->key);
					_g_variant_iter_free0 (_data_->iter3);
					_g_variant_iter_free0 (_data_->iter2);
					_g_variant_iter_free0 (_data_->iter1);
					_g_variant_unref0 (_data_->v);
					_g_free0 (_data_->str);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
			_data_->_tmp34_ = _data_->miner;
			_data_->_tmp35_ = _data_->self->priv->uri;
			rygel_tracker_miner_files_index_iface_index_file (_data_->_tmp34_, _data_->_tmp35_, NULL, NULL);
			_g_object_unref0 (_data_->miner);
		}
		_g_object_unref0 (_data_->file);
	}
	_data_->_tmp36_ = _data_->self->id;
	g_debug ("rygel-tracker-insertion-query.vala:167: Created item in Tracker store " \
"with ID '%s'", _data_->_tmp36_);
	_g_free0 (_data_->key);
	_g_variant_iter_free0 (_data_->iter3);
	_g_variant_iter_free0 (_data_->iter2);
	_g_variant_iter_free0 (_data_->iter1);
	_g_variant_unref0 (_data_->v);
	_g_free0 (_data_->str);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* rygel_tracker_insertion_query_real_to_string (RygelTrackerQuery* base) {
	RygelTrackerInsertionQuery * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* query;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	self = (RygelTrackerInsertionQuery*) base;
	_tmp0_ = RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_insertion_query_parent_class)->to_string (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("INSERT { ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, " }", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	query = _tmp5_;
	_tmp6_ = query;
	_tmp7_ = self->priv->uri;
	_tmp8_ = g_strdup_printf (RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_NOT_BOUND_TEMPLATE, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("WHERE {", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "}", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp6_, _tmp13_, NULL);
	_g_free0 (query);
	query = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	result = query;
	return result;
}


static gchar* rygel_tracker_insertion_query_get_resource_id_query (RygelTrackerInsertionQuery* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_strdup_printf (RYGEL_TRACKER_INSERTION_QUERY_RESOURCE_ID_QUERY_TEMPLATE, _tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_tracker_insertion_query_class_init (RygelTrackerInsertionQueryClass * klass) {
	rygel_tracker_insertion_query_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_QUERY_CLASS (klass)->finalize = rygel_tracker_insertion_query_finalize;
	g_type_class_add_private (klass, sizeof (RygelTrackerInsertionQueryPrivate));
	RYGEL_TRACKER_QUERY_CLASS (klass)->execute = rygel_tracker_insertion_query_real_execute;
	RYGEL_TRACKER_QUERY_CLASS (klass)->execute_finish = rygel_tracker_insertion_query_real_execute_finish;
	RYGEL_TRACKER_QUERY_CLASS (klass)->to_string = rygel_tracker_insertion_query_real_to_string;
}


static void rygel_tracker_insertion_query_instance_init (RygelTrackerInsertionQuery * self) {
	self->priv = RYGEL_TRACKER_INSERTION_QUERY_GET_PRIVATE (self);
}


static void rygel_tracker_insertion_query_finalize (RygelTrackerQuery* obj) {
	RygelTrackerInsertionQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_INSERTION_QUERY, RygelTrackerInsertionQuery);
	_g_free0 (self->id);
	_g_free0 (self->priv->uri);
	RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_insertion_query_parent_class)->finalize (obj);
}


/**
 * Represents Tracker SPARQL Insertion query
 */
GType rygel_tracker_insertion_query_get_type (void) {
	static volatile gsize rygel_tracker_insertion_query_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_insertion_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerInsertionQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_insertion_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerInsertionQuery), 0, (GInstanceInitFunc) rygel_tracker_insertion_query_instance_init, NULL };
		GType rygel_tracker_insertion_query_type_id;
		rygel_tracker_insertion_query_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_QUERY, "RygelTrackerInsertionQuery", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_insertion_query_type_id__volatile, rygel_tracker_insertion_query_type_id);
	}
	return rygel_tracker_insertion_query_type_id__volatile;
}



