/* preview.c generated by valac 0.42.2, the Vala compiler
 * generated from preview.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PREVIEW (preview_get_type ())
#define PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREVIEW, Preview))
#define PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREVIEW, PreviewClass))
#define IS_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREVIEW))
#define IS_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREVIEW))
#define PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREVIEW, PreviewClass))

typedef struct _Preview Preview;
typedef struct _PreviewClass PreviewClass;
typedef struct _PreviewPrivate PreviewPrivate;

#define TYPE_BLOCK_TEXTURE (block_texture_get_type ())
#define BLOCK_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_TEXTURE, BlockTexture))
#define BLOCK_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_TEXTURE, BlockTextureClass))
#define IS_BLOCK_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_TEXTURE))
#define IS_BLOCK_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_TEXTURE))
#define BLOCK_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_TEXTURE, BlockTextureClass))

typedef struct _BlockTexture BlockTexture;
typedef struct _BlockTextureClass BlockTextureClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	PREVIEW_0_PROPERTY,
	PREVIEW_THEME_PROPERTY,
	PREVIEW_GAME_PROPERTY,
	PREVIEW_ENABLED_PROPERTY,
	PREVIEW_NUM_PROPERTIES
};
static GParamSpec* preview_properties[PREVIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GamePrivate GamePrivate;

#define TYPE_SHAPE (shape_get_type ())
#define SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHAPE, Shape))
#define SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHAPE, ShapeClass))
#define IS_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHAPE))
#define IS_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHAPE))
#define SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHAPE, ShapeClass))

typedef struct _Shape Shape;
typedef struct _ShapeClass ShapeClass;

#define TYPE_BLOCK (block_get_type ())
#define BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK, Block))
#define BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK, BlockClass))
#define IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK))
#define IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK))
#define BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK, BlockClass))

typedef struct _Block Block;
typedef struct _BlockClass BlockClass;
typedef struct _ShapePrivate ShapePrivate;
typedef struct _BlockPrivate BlockPrivate;

struct _Preview {
	GtkClutterEmbed parent_instance;
	PreviewPrivate * priv;
};

struct _PreviewClass {
	GtkClutterEmbedClass parent_class;
};

struct _PreviewPrivate {
	BlockTexture** block_textures;
	gint block_textures_length1;
	gint _block_textures_size_;
	ClutterActor* piece;
	GtkFrame* parent_frame;
	Game* _game;
	gboolean _enabled;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Shape* shape;
	Shape* next_shape;
	Block** blocks;
	gint blocks_length1;
	gint blocks_length2;
	gint n_lines_destroyed;
	gint score;
	gboolean game_over;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Shape {
	GObject parent_instance;
	ShapePrivate * priv;
	gint x;
	gint y;
	gint rotation;
	gint type;
	GList* blocks;
};

struct _ShapeClass {
	GObjectClass parent_class;
};

struct _Block {
	GObject parent_instance;
	BlockPrivate * priv;
	gint x;
	gint y;
	gint color;
};

struct _BlockClass {
	GObjectClass parent_class;
};


static gint Preview_private_offset;
static gpointer preview_parent_class = NULL;

GType preview_get_type (void) G_GNUC_CONST;
GType block_texture_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
Preview* preview_new (GtkFrame* parent);
Preview* preview_construct (GType object_type,
                            GtkFrame* parent);
static void preview_size_allocate_cb (Preview* self,
                               GtkAllocation* allocation);
static void _preview_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                         GtkAllocation* allocation,
                                                         gpointer self);
#define NCOLORS 7
BlockTexture* block_texture_new (gint color);
BlockTexture* block_texture_construct (GType object_type,
                                       gint color);
static void preview_shape_added_cb (Preview* self);
static void preview_update_block (Preview* self);
Game* preview_get_game (Preview* self);
GType shape_get_type (void) G_GNUC_CONST;
GType block_get_type (void) G_GNUC_CONST;
gboolean preview_get_enabled (Preview* self);
void preview_set_visible (Preview* self,
                          gboolean visible);
static gint preview_get_cell_size (Preview* self);
void preview_set_theme (Preview* self,
                        const gchar* value);
void block_texture_set_theme (BlockTexture* self,
                              const gchar* value);
void preview_set_game (Preview* self,
                       Game* value);
static void _preview_shape_added_cb_game_shape_added (Game* _sender,
                                               gpointer self);
void preview_set_enabled (Preview* self,
                          gboolean value);
static void preview_finalize (GObject * obj);
static void _vala_preview_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec);
static void _vala_preview_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static inline gpointer
preview_get_instance_private (Preview* self)
{
	return G_STRUCT_MEMBER_P (self, Preview_private_offset);
}


static void
_preview_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                    GtkAllocation* allocation,
                                                    gpointer self)
{
	preview_size_allocate_cb ((Preview*) self, allocation);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


Preview*
preview_construct (GType object_type,
                   GtkFrame* parent)
{
	Preview * self = NULL;
	GtkFrame* _tmp0_;
	ClutterStage* stage = NULL;
	ClutterActor* _tmp1_;
	ClutterStage* _tmp2_;
	ClutterColor stage_color = {0};
	ClutterColor _tmp3_ = {0};
	ClutterStage* _tmp4_;
	ClutterColor _tmp5_;
	BlockTexture** _tmp6_;
	self = (Preview*) g_object_new (object_type, NULL);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _preview_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (self->priv->parent_frame);
	self->priv->parent_frame = _tmp0_;
	gtk_widget_set_size_request ((GtkWidget*) self, 120, 120);
	_tmp1_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) self);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, clutter_stage_get_type (), ClutterStage));
	stage = _tmp2_;
	_tmp3_.red = (guint8) 0x0;
	_tmp3_.green = (guint8) 0x0;
	_tmp3_.blue = (guint8) 0x0;
	_tmp3_.alpha = (guint8) 0xff;
	stage_color = _tmp3_;
	_tmp4_ = stage;
	_tmp5_ = stage_color;
	clutter_actor_set_background_color ((ClutterActor*) _tmp4_, &_tmp5_);
	_tmp6_ = g_new0 (BlockTexture*, NCOLORS + 1);
	self->priv->block_textures = (_vala_array_free (self->priv->block_textures, self->priv->block_textures_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->block_textures = _tmp6_;
	self->priv->block_textures_length1 = NCOLORS;
	self->priv->_block_textures_size_ = self->priv->block_textures_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				BlockTexture** _tmp10_;
				gint _tmp10__length1;
				BlockTexture** _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				gint _tmp13_;
				BlockTexture* _tmp14_;
				BlockTexture* _tmp15_;
				BlockTexture** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				BlockTexture* _tmp18_;
				BlockTexture** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				BlockTexture* _tmp21_;
				ClutterStage* _tmp22_;
				BlockTexture** _tmp23_;
				gint _tmp23__length1;
				gint _tmp24_;
				BlockTexture* _tmp25_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = self->priv->block_textures;
				_tmp10__length1 = self->priv->block_textures_length1;
				if (!(_tmp9_ < _tmp10__length1)) {
					break;
				}
				_tmp11_ = self->priv->block_textures;
				_tmp11__length1 = self->priv->block_textures_length1;
				_tmp12_ = i;
				_tmp13_ = i;
				_tmp14_ = block_texture_new (_tmp13_);
				g_object_ref_sink (_tmp14_);
				_g_object_unref0 (_tmp11_[_tmp12_]);
				_tmp11_[_tmp12_] = _tmp14_;
				_tmp15_ = _tmp11_[_tmp12_];
				_tmp16_ = self->priv->block_textures;
				_tmp16__length1 = self->priv->block_textures_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				clutter_cairo_texture_set_surface_size ((ClutterCairoTexture*) _tmp18_, (guint) 1, (guint) 1);
				_tmp19_ = self->priv->block_textures;
				_tmp19__length1 = self->priv->block_textures_length1;
				_tmp20_ = i;
				_tmp21_ = _tmp19_[_tmp20_];
				clutter_actor_hide ((ClutterActor*) _tmp21_);
				_tmp22_ = stage;
				_tmp23_ = self->priv->block_textures;
				_tmp23__length1 = self->priv->block_textures_length1;
				_tmp24_ = i;
				_tmp25_ = _tmp23_[_tmp24_];
				clutter_actor_add_child ((ClutterActor*) _tmp22_, (ClutterActor*) _tmp25_);
			}
		}
	}
	_g_object_unref0 (stage);
	return self;
}


Preview*
preview_new (GtkFrame* parent)
{
	return preview_construct (TYPE_PREVIEW, parent);
}


static void
preview_shape_added_cb (Preview* self)
{
	g_return_if_fail (self != NULL);
	preview_update_block (self);
}


static void
preview_update_block (Preview* self)
{
	ClutterActor* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Game* _tmp4_;
	Game* _tmp5_;
	ClutterActor* _tmp13_;
	ClutterStage* stage = NULL;
	ClutterActor* _tmp14_;
	ClutterStage* _tmp15_;
	ClutterStage* _tmp16_;
	ClutterActor* _tmp17_;
	gint min_width = 0;
	gint max_width = 0;
	gint min_height = 0;
	gint max_height = 0;
	Game* _tmp18_;
	Game* _tmp19_;
	Shape* _tmp20_;
	GList* _tmp21_;
	ClutterActor* _tmp56_;
	ClutterActor* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	ClutterActor* _tmp66_;
	ClutterActor* _tmp67_;
	ClutterActor* _tmp68_;
	ClutterActor* _tmp69_;
	ClutterActor* _tmp70_;
	ClutterActor* _tmp71_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->piece;
	if (_tmp0_ != NULL) {
		ClutterActor* _tmp1_;
		_tmp1_ = self->priv->piece;
		clutter_actor_destroy (_tmp1_);
	}
	_tmp4_ = preview_get_game (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		Game* _tmp6_;
		Game* _tmp7_;
		Shape* _tmp8_;
		_tmp6_ = preview_get_game (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->next_shape;
		_tmp3_ = _tmp8_ == NULL;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = preview_get_enabled (self);
		_tmp10_ = _tmp9_;
		_tmp2_ = !_tmp10_;
	}
	if (_tmp2_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = preview_get_enabled (self);
		_tmp12_ = _tmp11_;
		preview_set_visible (self, _tmp12_);
		return;
	}
	preview_set_visible (self, TRUE);
	_tmp13_ = clutter_actor_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->piece);
	self->priv->piece = _tmp13_;
	_tmp14_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) self);
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, clutter_stage_get_type (), ClutterStage));
	stage = _tmp15_;
	_tmp16_ = stage;
	_tmp17_ = self->priv->piece;
	clutter_actor_add_child ((ClutterActor*) _tmp16_, _tmp17_);
	min_width = 4;
	max_width = 0;
	min_height = 4;
	max_height = 0;
	_tmp18_ = preview_get_game (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_->next_shape;
	_tmp21_ = _tmp20_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp21_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp22_;
			Block* b = NULL;
			_tmp22_ = _g_object_ref0 ((Block*) b_it->data);
			b = _tmp22_;
			{
				Block* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				Block* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				Block* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				Block* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				ClutterClone* a = NULL;
				BlockTexture** _tmp35_;
				gint _tmp35__length1;
				Block* _tmp36_;
				gint _tmp37_;
				BlockTexture* _tmp38_;
				ClutterClone* _tmp39_;
				ClutterClone* _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				ClutterClone* _tmp45_;
				Block* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				Block* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				ClutterActor* _tmp54_;
				ClutterClone* _tmp55_;
				_tmp23_ = b;
				_tmp24_ = _tmp23_->x;
				_tmp25_ = min_width;
				min_width = MIN (_tmp24_, _tmp25_);
				_tmp26_ = b;
				_tmp27_ = _tmp26_->x;
				_tmp28_ = max_width;
				max_width = MAX (_tmp27_ + 1, _tmp28_);
				_tmp29_ = b;
				_tmp30_ = _tmp29_->y;
				_tmp31_ = min_height;
				min_height = MIN (_tmp30_, _tmp31_);
				_tmp32_ = b;
				_tmp33_ = _tmp32_->y;
				_tmp34_ = max_height;
				max_height = MAX (_tmp33_ + 1, _tmp34_);
				_tmp35_ = self->priv->block_textures;
				_tmp35__length1 = self->priv->block_textures_length1;
				_tmp36_ = b;
				_tmp37_ = _tmp36_->color;
				_tmp38_ = _tmp35_[_tmp37_];
				_tmp39_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp38_);
				g_object_ref_sink (_tmp39_);
				a = _tmp39_;
				_tmp40_ = a;
				_tmp41_ = preview_get_cell_size (self);
				_tmp42_ = _tmp41_;
				_tmp43_ = preview_get_cell_size (self);
				_tmp44_ = _tmp43_;
				clutter_actor_set_size ((ClutterActor*) _tmp40_, (gfloat) _tmp42_, (gfloat) _tmp44_);
				_tmp45_ = a;
				_tmp46_ = b;
				_tmp47_ = _tmp46_->x;
				_tmp48_ = preview_get_cell_size (self);
				_tmp49_ = _tmp48_;
				_tmp50_ = b;
				_tmp51_ = _tmp50_->y;
				_tmp52_ = preview_get_cell_size (self);
				_tmp53_ = _tmp52_;
				clutter_actor_set_position ((ClutterActor*) _tmp45_, (gfloat) (_tmp47_ * _tmp49_), (gfloat) (_tmp51_ * _tmp53_));
				_tmp54_ = self->priv->piece;
				_tmp55_ = a;
				clutter_actor_add_child (_tmp54_, (ClutterActor*) _tmp55_);
				_g_object_unref0 (a);
				_g_object_unref0 (b);
			}
		}
	}
	_tmp56_ = self->priv->piece;
	clutter_actor_set_pivot_point (_tmp56_, 0.5f, 0.5f);
	_tmp57_ = self->priv->piece;
	_tmp58_ = min_width;
	_tmp59_ = max_width;
	_tmp60_ = preview_get_cell_size (self);
	_tmp61_ = _tmp60_;
	_tmp62_ = min_height;
	_tmp63_ = max_height;
	_tmp64_ = preview_get_cell_size (self);
	_tmp65_ = _tmp64_;
	clutter_actor_set_position (_tmp57_, (gfloat) ((gtk_widget_get_allocated_width ((GtkWidget*) self) - ((_tmp58_ + _tmp59_) * _tmp61_)) / 2), (gfloat) ((gtk_widget_get_allocated_height ((GtkWidget*) self) - ((_tmp62_ + _tmp63_) * _tmp65_)) / 2));
	_tmp66_ = self->priv->piece;
	clutter_actor_set_scale (_tmp66_, 0.6, 0.6);
	_tmp67_ = self->priv->piece;
	clutter_actor_save_easing_state (_tmp67_);
	_tmp68_ = self->priv->piece;
	clutter_actor_set_easing_mode (_tmp68_, CLUTTER_EASE_IN_OUT_SINE);
	_tmp69_ = self->priv->piece;
	clutter_actor_set_easing_duration (_tmp69_, (guint) 180);
	_tmp70_ = self->priv->piece;
	clutter_actor_set_scale (_tmp70_, 1.0, 1.0);
	_tmp71_ = self->priv->piece;
	clutter_actor_restore_easing_state (_tmp71_);
	_g_object_unref0 (stage);
}


void
preview_set_visible (Preview* self,
                     gboolean visible)
{
	GtkFrame* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_set_visible ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_embed_get_type (), GtkClutterEmbed), visible);
	_tmp0_ = self->priv->parent_frame;
	if (_tmp0_ != NULL) {
		GtkFrame* _tmp1_;
		_tmp1_ = self->priv->parent_frame;
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, visible);
	}
}


static void
preview_size_allocate_cb (Preview* self,
                          GtkAllocation* allocation)
{
	BlockTexture** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = self->priv->block_textures;
	_tmp0__length1 = self->priv->block_textures_length1;
	{
		BlockTexture** texture_collection = NULL;
		gint texture_collection_length1 = 0;
		gint _texture_collection_size_ = 0;
		gint texture_it = 0;
		texture_collection = _tmp0_;
		texture_collection_length1 = _tmp0__length1;
		for (texture_it = 0; texture_it < _tmp0__length1; texture_it = texture_it + 1) {
			BlockTexture* _tmp1_;
			BlockTexture* texture = NULL;
			_tmp1_ = _g_object_ref0 (texture_collection[texture_it]);
			texture = _tmp1_;
			{
				BlockTexture* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				_tmp2_ = texture;
				_tmp3_ = preview_get_cell_size (self);
				_tmp4_ = _tmp3_;
				_tmp5_ = preview_get_cell_size (self);
				_tmp6_ = _tmp5_;
				clutter_actor_set_size ((ClutterActor*) _tmp2_, (gfloat) _tmp4_, (gfloat) _tmp6_);
				_g_object_unref0 (texture);
			}
		}
	}
	preview_update_block (self);
}


void
preview_set_theme (Preview* self,
                   const gchar* value)
{
	BlockTexture** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->block_textures;
	_tmp0__length1 = self->priv->block_textures_length1;
	{
		BlockTexture** texture_collection = NULL;
		gint texture_collection_length1 = 0;
		gint _texture_collection_size_ = 0;
		gint texture_it = 0;
		texture_collection = _tmp0_;
		texture_collection_length1 = _tmp0__length1;
		for (texture_it = 0; texture_it < _tmp0__length1; texture_it = texture_it + 1) {
			BlockTexture* _tmp1_;
			BlockTexture* texture = NULL;
			_tmp1_ = _g_object_ref0 (texture_collection[texture_it]);
			texture = _tmp1_;
			{
				BlockTexture* _tmp2_;
				_tmp2_ = texture;
				block_texture_set_theme (_tmp2_, value);
				_g_object_unref0 (texture);
			}
		}
	}
	preview_update_block (self);
	g_object_notify_by_pspec ((GObject *) self, preview_properties[PREVIEW_THEME_PROPERTY]);
}


static gint
preview_get_cell_size (Preview* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ((gtk_widget_get_allocated_width ((GtkWidget*) self) + gtk_widget_get_allocated_height ((GtkWidget*) self)) / 2) / 5;
	return result;
}


Game*
preview_get_game (Preview* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static void
_preview_shape_added_cb_game_shape_added (Game* _sender,
                                          gpointer self)
{
	preview_shape_added_cb ((Preview*) self);
}


void
preview_set_game (Preview* self,
                  Game* value)
{
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp2_;
	_tmp3_ = self->priv->_game;
	g_signal_connect_object (_tmp3_, "shape-added", (GCallback) _preview_shape_added_cb_game_shape_added, self, 0);
	preview_update_block (self);
	g_object_notify_by_pspec ((GObject *) self, preview_properties[PREVIEW_GAME_PROPERTY]);
}


gboolean
preview_get_enabled (Preview* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


void
preview_set_enabled (Preview* self,
                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_enabled = value;
	preview_update_block (self);
	g_object_notify_by_pspec ((GObject *) self, preview_properties[PREVIEW_ENABLED_PROPERTY]);
}


static void
preview_class_init (PreviewClass * klass)
{
	preview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Preview_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_preview_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_preview_set_property;
	G_OBJECT_CLASS (klass)->finalize = preview_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREVIEW_THEME_PROPERTY, preview_properties[PREVIEW_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREVIEW_GAME_PROPERTY, preview_properties[PREVIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREVIEW_ENABLED_PROPERTY, preview_properties[PREVIEW_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
preview_instance_init (Preview * self)
{
	self->priv = preview_get_instance_private (self);
	self->priv->piece = NULL;
	self->priv->parent_frame = NULL;
	self->priv->_game = NULL;
	self->priv->_enabled = TRUE;
}


static void
preview_finalize (GObject * obj)
{
	Preview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREVIEW, Preview);
	self->priv->block_textures = (_vala_array_free (self->priv->block_textures, self->priv->block_textures_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->piece);
	_g_object_unref0 (self->priv->parent_frame);
	_g_object_unref0 (self->priv->_game);
	G_OBJECT_CLASS (preview_parent_class)->finalize (obj);
}


GType
preview_get_type (void)
{
	static volatile gsize preview_type_id__volatile = 0;
	if (g_once_init_enter (&preview_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Preview), 0, (GInstanceInitFunc) preview_instance_init, NULL };
		GType preview_type_id;
		preview_type_id = g_type_register_static (gtk_clutter_embed_get_type (), "Preview", &g_define_type_info, 0);
		Preview_private_offset = g_type_add_instance_private (preview_type_id, sizeof (PreviewPrivate));
		g_once_init_leave (&preview_type_id__volatile, preview_type_id);
	}
	return preview_type_id__volatile;
}


static void
_vala_preview_get_property (GObject * object,
                            guint property_id,
                            GValue * value,
                            GParamSpec * pspec)
{
	Preview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PREVIEW, Preview);
	switch (property_id) {
		case PREVIEW_GAME_PROPERTY:
		g_value_set_object (value, preview_get_game (self));
		break;
		case PREVIEW_ENABLED_PROPERTY:
		g_value_set_boolean (value, preview_get_enabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_preview_set_property (GObject * object,
                            guint property_id,
                            const GValue * value,
                            GParamSpec * pspec)
{
	Preview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PREVIEW, Preview);
	switch (property_id) {
		case PREVIEW_THEME_PROPERTY:
		preview_set_theme (self, g_value_get_string (value));
		break;
		case PREVIEW_GAME_PROPERTY:
		preview_set_game (self, g_value_get_object (value));
		break;
		case PREVIEW_ENABLED_PROPERTY:
		preview_set_enabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



