/* game.c generated by valac 0.42.2, the Vala compiler
 * generated from game.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <math.h>
#include <float.h>
#include <string.h>


#define TYPE_BLOCK (block_get_type ())
#define BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK, Block))
#define BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK, BlockClass))
#define IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK))
#define IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK))
#define BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK, BlockClass))

typedef struct _Block Block;
typedef struct _BlockClass BlockClass;
typedef struct _BlockPrivate BlockPrivate;
enum  {
	BLOCK_0_PROPERTY,
	BLOCK_NUM_PROPERTIES
};
static GParamSpec* block_properties[BLOCK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SHAPE (shape_get_type ())
#define SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHAPE, Shape))
#define SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHAPE, ShapeClass))
#define IS_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHAPE))
#define IS_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHAPE))
#define SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHAPE, ShapeClass))

typedef struct _Shape Shape;
typedef struct _ShapeClass ShapeClass;
typedef struct _ShapePrivate ShapePrivate;
enum  {
	SHAPE_0_PROPERTY,
	SHAPE_NUM_PROPERTIES
};
static GParamSpec* shape_properties[SHAPE_NUM_PROPERTIES];

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;
enum  {
	GAME_0_PROPERTY,
	GAME_WIDTH_PROPERTY,
	GAME_HEIGHT_PROPERTY,
	GAME_LEVEL_PROPERTY,
	GAME_PAUSED_PROPERTY,
	GAME_SHADOW_Y_PROPERTY,
	GAME_NUM_PROPERTIES
};
static GParamSpec* game_properties[GAME_NUM_PROPERTIES];
enum  {
	GAME_STARTED_SIGNAL,
	GAME_SHAPE_ADDED_SIGNAL,
	GAME_SHAPE_MOVED_SIGNAL,
	GAME_SHAPE_DROPPED_SIGNAL,
	GAME_SHAPE_ROTATED_SIGNAL,
	GAME_SHAPE_LANDED_SIGNAL,
	GAME_PAUSE_CHANGED_SIGNAL,
	GAME_COMPLETE_SIGNAL,
	GAME_NUM_SIGNALS
};
static guint game_signals[GAME_NUM_SIGNALS] = {0};

struct _Block {
	GObject parent_instance;
	BlockPrivate * priv;
	gint x;
	gint y;
	gint color;
};

struct _BlockClass {
	GObjectClass parent_class;
};

struct _Shape {
	GObject parent_instance;
	ShapePrivate * priv;
	gint x;
	gint y;
	gint rotation;
	gint type;
	GList* blocks;
};

struct _ShapeClass {
	GObjectClass parent_class;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Shape* shape;
	Shape* next_shape;
	Block** blocks;
	gint blocks_length1;
	gint blocks_length2;
	gint n_lines_destroyed;
	gint score;
	gboolean game_over;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GamePrivate {
	gint starting_level;
	gboolean pick_difficult_blocks;
	gint fast_move_direction;
	guint fast_move_timeout;
	gboolean fast_forward;
	guint drop_timeout;
	gboolean has_started;
	gboolean _paused;
};


static gpointer block_parent_class = NULL;
static gpointer shape_parent_class = NULL;
static gint Game_private_offset;
static gpointer game_parent_class = NULL;

#define NCOLORS 7
GType block_get_type (void) G_GNUC_CONST;
Block* block_copy (Block* self);
Block* block_new (void);
Block* block_construct (GType object_type);
static void block_finalize (GObject * obj);
GType shape_get_type (void) G_GNUC_CONST;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
Shape* shape_copy (Shape* self);
Shape* shape_new (void);
Shape* shape_construct (GType object_type);
static void shape_finalize (GObject * obj);
GType game_get_type (void) G_GNUC_CONST;
Game* game_new (gint lines,
                gint columns,
                gint starting_level,
                gint filled_lines,
                gint fill_prob,
                gboolean pick_difficult_blocks);
Game* game_construct (GType object_type,
                      gint lines,
                      gint columns,
                      gint starting_level,
                      gint filled_lines,
                      gint fill_prob,
                      gboolean pick_difficult_blocks);
gint game_get_height (Game* self);
gint game_get_width (Game* self);
static Shape* game_pick_random_shape (Game* self);
Game* game_copy (Game* self);
void game_start (Game* self);
static void game_add_shape (Game* self);
static void game_setup_drop_timer (Game* self);
gboolean game_move_left (Game* self);
static gboolean game_move_direction (Game* self,
                              gint direction);
gboolean game_move_right (Game* self);
gboolean game_stop_moving (Game* self);
gboolean game_rotate_left (Game* self);
static gboolean game_move_shape (Game* self,
                          gint x_step,
                          gint y_step,
                          gint r_step);
gboolean game_rotate_right (Game* self);
void game_set_fast_forward (Game* self,
                            gboolean enable);
void game_drop (Game* self);
static gboolean game_fall_timeout_cb (Game* self);
void game_stop (Game* self);
static gboolean game_move (Game* self);
static gboolean game_setup_fast_move_cb (Game* self);
static gboolean _game_setup_fast_move_cb_gsource_func (gpointer self);
static gboolean _game_move_gsource_func (gpointer self);
gint game_get_level (Game* self);
gboolean game_get_paused (Game* self);
static gboolean _game_fall_timeout_cb_gsource_func (gpointer self);
static void game_land_shape (Game* self);
static Shape* game_pick_difficult_shape (Game* self);
static Shape* game_make_shape (Game* self,
                        gint type,
                        gint rotation);
static void game_rotate_shape (Game* self,
                        gint r_step);
void game_set_paused (Game* self,
                      gboolean value);
gint game_get_shadow_y (Game* self);
static void g_cclosure_user_marshal_VOID__POINTER_INT_POINTER (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static void game_finalize (GObject * obj);
static void _vala_game_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_game_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

const gint block_table[448] = {0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0};

Block*
block_copy (Block* self)
{
	Block* result = NULL;
	Block* b = NULL;
	Block* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = block_new ();
	b = _tmp0_;
	_tmp1_ = self->x;
	b->x = _tmp1_;
	_tmp2_ = self->y;
	b->y = _tmp2_;
	_tmp3_ = self->color;
	b->color = _tmp3_;
	result = b;
	return result;
}


Block*
block_construct (GType object_type)
{
	Block * self = NULL;
	self = (Block*) g_object_new (object_type, NULL);
	return self;
}


Block*
block_new (void)
{
	return block_construct (TYPE_BLOCK);
}


static void
block_class_init (BlockClass * klass)
{
	block_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = block_finalize;
}


static void
block_instance_init (Block * self)
{
}


static void
block_finalize (GObject * obj)
{
	Block * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLOCK, Block);
	G_OBJECT_CLASS (block_parent_class)->finalize (obj);
}


GType
block_get_type (void)
{
	static volatile gsize block_type_id__volatile = 0;
	if (g_once_init_enter (&block_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Block), 0, (GInstanceInitFunc) block_instance_init, NULL };
		GType block_type_id;
		block_type_id = g_type_register_static (G_TYPE_OBJECT, "Block", &g_define_type_info, 0);
		g_once_init_leave (&block_type_id__volatile, block_type_id);
	}
	return block_type_id__volatile;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


Shape*
shape_copy (Shape* self)
{
	Shape* result = NULL;
	Shape* s = NULL;
	Shape* _tmp0_;
	Shape* _tmp1_;
	gint _tmp2_;
	Shape* _tmp3_;
	gint _tmp4_;
	Shape* _tmp5_;
	gint _tmp6_;
	Shape* _tmp7_;
	gint _tmp8_;
	GList* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = shape_new ();
	s = _tmp0_;
	_tmp1_ = s;
	_tmp2_ = self->x;
	_tmp1_->x = _tmp2_;
	_tmp3_ = s;
	_tmp4_ = self->y;
	_tmp3_->y = _tmp4_;
	_tmp5_ = s;
	_tmp6_ = self->rotation;
	_tmp5_->rotation = _tmp6_;
	_tmp7_ = s;
	_tmp8_ = self->type;
	_tmp7_->type = _tmp8_;
	_tmp9_ = self->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp9_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp10_;
			Block* b = NULL;
			_tmp10_ = _g_object_ref0 ((Block*) b_it->data);
			b = _tmp10_;
			{
				Shape* _tmp11_;
				Block* _tmp12_;
				Block* _tmp13_;
				_tmp11_ = s;
				_tmp12_ = b;
				_tmp13_ = block_copy (_tmp12_);
				_tmp11_->blocks = g_list_append (_tmp11_->blocks, _tmp13_);
				_g_object_unref0 (b);
			}
		}
	}
	result = s;
	return result;
}


Shape*
shape_construct (GType object_type)
{
	Shape * self = NULL;
	self = (Shape*) g_object_new (object_type, NULL);
	return self;
}


Shape*
shape_new (void)
{
	return shape_construct (TYPE_SHAPE);
}


static void
shape_class_init (ShapeClass * klass)
{
	shape_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = shape_finalize;
}


static void
shape_instance_init (Shape * self)
{
	self->blocks = NULL;
}


static void
shape_finalize (GObject * obj)
{
	Shape * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHAPE, Shape);
	(self->blocks == NULL) ? NULL : (self->blocks = (_g_list_free__g_object_unref0_ (self->blocks), NULL));
	G_OBJECT_CLASS (shape_parent_class)->finalize (obj);
}


GType
shape_get_type (void)
{
	static volatile gsize shape_type_id__volatile = 0;
	if (g_once_init_enter (&shape_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ShapeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shape_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Shape), 0, (GInstanceInitFunc) shape_instance_init, NULL };
		GType shape_type_id;
		shape_type_id = g_type_register_static (G_TYPE_OBJECT, "Shape", &g_define_type_info, 0);
		g_once_init_leave (&shape_type_id__volatile, shape_type_id);
	}
	return shape_type_id__volatile;
}


static inline gpointer
game_get_instance_private (Game* self)
{
	return G_STRUCT_MEMBER_P (self, Game_private_offset);
}


Game*
game_construct (GType object_type,
                gint lines,
                gint columns,
                gint starting_level,
                gint filled_lines,
                gint fill_prob,
                gboolean pick_difficult_blocks)
{
	Game * self = NULL;
	Block** _tmp0_;
	self = (Game*) g_object_new (object_type, NULL);
	self->priv->starting_level = starting_level;
	self->priv->pick_difficult_blocks = pick_difficult_blocks;
	_tmp0_ = g_new0 (Block*, (columns * lines) + 1);
	self->blocks = (_vala_array_free (self->blocks, self->blocks_length1 * self->blocks_length2, (GDestroyNotify) g_object_unref), NULL);
	self->blocks = _tmp0_;
	self->blocks_length1 = columns;
	self->blocks_length2 = lines;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gint32 blank = 0;
				gint _tmp6_;
				gint _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = y;
					y = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = y;
				_tmp4_ = game_get_height (self);
				_tmp5_ = _tmp4_;
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				_tmp6_ = game_get_width (self);
				_tmp7_ = _tmp6_;
				blank = g_random_int_range ((gint32) 0, (gint32) _tmp7_);
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gint _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							gboolean _tmp13_ = FALSE;
							gboolean _tmp14_ = FALSE;
							gint _tmp15_;
							gint _tmp16_;
							gint _tmp17_;
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = x;
								x = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = x;
							_tmp11_ = game_get_width (self);
							_tmp12_ = _tmp11_;
							if (!(_tmp10_ < _tmp12_)) {
								break;
							}
							_tmp15_ = y;
							_tmp16_ = game_get_height (self);
							_tmp17_ = _tmp16_;
							if (_tmp15_ >= (_tmp17_ - filled_lines)) {
								gint _tmp18_;
								gint32 _tmp19_;
								_tmp18_ = x;
								_tmp19_ = blank;
								_tmp14_ = _tmp18_ != ((gint) _tmp19_);
							} else {
								_tmp14_ = FALSE;
							}
							if (_tmp14_) {
								_tmp13_ = g_random_int_range ((gint32) 0, (gint32) 10) < ((gint32) fill_prob);
							} else {
								_tmp13_ = FALSE;
							}
							if (_tmp13_) {
								Block** _tmp20_;
								gint _tmp20__length1;
								gint _tmp20__length2;
								gint _tmp21_;
								gint _tmp22_;
								Block* _tmp23_;
								Block* _tmp24_;
								Block** _tmp25_;
								gint _tmp25__length1;
								gint _tmp25__length2;
								gint _tmp26_;
								gint _tmp27_;
								Block* _tmp28_;
								gint _tmp29_;
								Block** _tmp30_;
								gint _tmp30__length1;
								gint _tmp30__length2;
								gint _tmp31_;
								gint _tmp32_;
								Block* _tmp33_;
								gint _tmp34_;
								Block** _tmp35_;
								gint _tmp35__length1;
								gint _tmp35__length2;
								gint _tmp36_;
								gint _tmp37_;
								Block* _tmp38_;
								_tmp20_ = self->blocks;
								_tmp20__length1 = self->blocks_length1;
								_tmp20__length2 = self->blocks_length2;
								_tmp21_ = x;
								_tmp22_ = y;
								_tmp23_ = block_new ();
								_g_object_unref0 (_tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_]);
								_tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_] = _tmp23_;
								_tmp24_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
								_tmp25_ = self->blocks;
								_tmp25__length1 = self->blocks_length1;
								_tmp25__length2 = self->blocks_length2;
								_tmp26_ = x;
								_tmp27_ = y;
								_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
								_tmp29_ = x;
								_tmp28_->x = _tmp29_;
								_tmp30_ = self->blocks;
								_tmp30__length1 = self->blocks_length1;
								_tmp30__length2 = self->blocks_length2;
								_tmp31_ = x;
								_tmp32_ = y;
								_tmp33_ = _tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_];
								_tmp34_ = y;
								_tmp33_->y = _tmp34_;
								_tmp35_ = self->blocks;
								_tmp35__length1 = self->blocks_length1;
								_tmp35__length2 = self->blocks_length2;
								_tmp36_ = x;
								_tmp37_ = y;
								_tmp38_ = _tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_];
								_tmp38_->color = (gint) g_random_int_range ((gint32) 0, (gint32) NCOLORS);
							} else {
								Block** _tmp39_;
								gint _tmp39__length1;
								gint _tmp39__length2;
								gint _tmp40_;
								gint _tmp41_;
								Block* _tmp42_;
								_tmp39_ = self->blocks;
								_tmp39__length1 = self->blocks_length1;
								_tmp39__length2 = self->blocks_length2;
								_tmp40_ = x;
								_tmp41_ = y;
								_g_object_unref0 (_tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_]);
								_tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_] = NULL;
								_tmp42_ = _tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_];
							}
						}
					}
				}
			}
		}
	}
	if (!pick_difficult_blocks) {
		Shape* _tmp43_;
		_tmp43_ = game_pick_random_shape (self);
		_g_object_unref0 (self->next_shape);
		self->next_shape = _tmp43_;
	}
	return self;
}


Game*
game_new (gint lines,
          gint columns,
          gint starting_level,
          gint filled_lines,
          gint fill_prob,
          gboolean pick_difficult_blocks)
{
	return game_construct (TYPE_GAME, lines, columns, starting_level, filled_lines, fill_prob, pick_difficult_blocks);
}


Game*
game_copy (Game* self)
{
	Game* result = NULL;
	Game* g = NULL;
	Game* _tmp0_;
	Shape* _tmp1_;
	Shape* _tmp5_;
	Game* _tmp33_;
	gint _tmp34_;
	Game* _tmp35_;
	gint _tmp36_;
	Game* _tmp37_;
	gint _tmp38_;
	Game* _tmp39_;
	gboolean _tmp40_;
	Game* _tmp41_;
	gint _tmp42_;
	Game* _tmp43_;
	gboolean _tmp44_;
	Game* _tmp45_;
	gboolean _tmp46_;
	Game* _tmp47_;
	gboolean _tmp48_;
	Game* _tmp49_;
	gboolean _tmp50_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = game_new (20, 14, 1, 0, 5, FALSE);
	g = _tmp0_;
	_tmp1_ = self->shape;
	if (_tmp1_ != NULL) {
		Game* _tmp2_;
		Shape* _tmp3_;
		Shape* _tmp4_;
		_tmp2_ = g;
		_tmp3_ = self->shape;
		_tmp4_ = shape_copy (_tmp3_);
		_g_object_unref0 (_tmp2_->shape);
		_tmp2_->shape = _tmp4_;
	}
	_tmp5_ = self->next_shape;
	if (_tmp5_ != NULL) {
		Game* _tmp6_;
		Shape* _tmp7_;
		Shape* _tmp8_;
		_tmp6_ = g;
		_tmp7_ = self->next_shape;
		_tmp8_ = shape_copy (_tmp7_);
		_g_object_unref0 (_tmp6_->next_shape);
		_tmp6_->next_shape = _tmp8_;
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = x;
					x = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = x;
				_tmp12_ = game_get_width (self);
				_tmp13_ = _tmp12_;
				if (!(_tmp11_ < _tmp13_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							gint _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							Block** _tmp19_;
							gint _tmp19__length1;
							gint _tmp19__length2;
							gint _tmp20_;
							gint _tmp21_;
							Block* _tmp22_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = y;
								y = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							_tmp16_ = y;
							_tmp17_ = game_get_height (self);
							_tmp18_ = _tmp17_;
							if (!(_tmp16_ < _tmp18_)) {
								break;
							}
							_tmp19_ = self->blocks;
							_tmp19__length1 = self->blocks_length1;
							_tmp19__length2 = self->blocks_length2;
							_tmp20_ = x;
							_tmp21_ = y;
							_tmp22_ = _tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_];
							if (_tmp22_ != NULL) {
								Game* _tmp23_;
								Block** _tmp24_;
								gint _tmp24__length1;
								gint _tmp24__length2;
								gint _tmp25_;
								gint _tmp26_;
								Block** _tmp27_;
								gint _tmp27__length1;
								gint _tmp27__length2;
								gint _tmp28_;
								gint _tmp29_;
								Block* _tmp30_;
								Block* _tmp31_;
								Block* _tmp32_;
								_tmp23_ = g;
								_tmp24_ = _tmp23_->blocks;
								_tmp24__length1 = _tmp23_->blocks_length1;
								_tmp24__length2 = _tmp23_->blocks_length2;
								_tmp25_ = x;
								_tmp26_ = y;
								_tmp27_ = self->blocks;
								_tmp27__length1 = self->blocks_length1;
								_tmp27__length2 = self->blocks_length2;
								_tmp28_ = x;
								_tmp29_ = y;
								_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
								_tmp31_ = block_copy (_tmp30_);
								_g_object_unref0 (_tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_]);
								_tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_] = _tmp31_;
								_tmp32_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
							}
						}
					}
				}
			}
		}
	}
	_tmp33_ = g;
	_tmp34_ = self->n_lines_destroyed;
	_tmp33_->n_lines_destroyed = _tmp34_;
	_tmp35_ = g;
	_tmp36_ = self->score;
	_tmp35_->score = _tmp36_;
	_tmp37_ = g;
	_tmp38_ = self->priv->starting_level;
	_tmp37_->priv->starting_level = _tmp38_;
	_tmp39_ = g;
	_tmp40_ = self->priv->pick_difficult_blocks;
	_tmp39_->priv->pick_difficult_blocks = _tmp40_;
	_tmp41_ = g;
	_tmp42_ = self->priv->fast_move_direction;
	_tmp41_->priv->fast_move_direction = _tmp42_;
	_tmp43_ = g;
	_tmp44_ = self->priv->fast_forward;
	_tmp43_->priv->fast_forward = _tmp44_;
	_tmp45_ = g;
	_tmp46_ = self->priv->has_started;
	_tmp45_->priv->has_started = _tmp46_;
	_tmp47_ = g;
	_tmp48_ = self->priv->_paused;
	_tmp47_->priv->_paused = _tmp48_;
	_tmp49_ = g;
	_tmp50_ = self->game_over;
	_tmp49_->game_over = _tmp50_;
	result = g;
	return result;
}


void
game_start (Game* self)
{
	g_return_if_fail (self != NULL);
	self->priv->has_started = TRUE;
	game_add_shape (self);
	game_setup_drop_timer (self);
	g_signal_emit (self, game_signals[GAME_STARTED_SIGNAL], 0);
	g_signal_emit (self, game_signals[GAME_PAUSE_CHANGED_SIGNAL], 0);
}


gboolean
game_move_left (Game* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = game_move_direction (self, -1);
	return result;
}


gboolean
game_move_right (Game* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = game_move_direction (self, 1);
	return result;
}


gboolean
game_stop_moving (Game* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->game_over;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->fast_move_timeout;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_;
		_tmp2_ = self->priv->fast_move_timeout;
		g_source_remove (_tmp2_);
	}
	self->priv->fast_move_timeout = (guint) 0;
	self->priv->fast_move_direction = 0;
	result = TRUE;
	return result;
}


gboolean
game_rotate_left (Game* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = game_move_shape (self, 0, 0, 1);
	return result;
}


gboolean
game_rotate_right (Game* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = game_move_shape (self, 0, 0, -1);
	return result;
}


void
game_set_fast_forward (Game* self,
                       gboolean enable)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->fast_forward;
	if (_tmp1_ == enable) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->game_over;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	if (enable) {
		if (!game_move_shape (self, 0, 1, 0)) {
			return;
		}
	}
	self->priv->fast_forward = enable;
	game_setup_drop_timer (self);
}


void
game_drop (Game* self)
{
	Shape* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->shape;
	if (_tmp0_ == NULL) {
		return;
	}
	while (TRUE) {
		if (!game_move_shape (self, 0, 1, 0)) {
			break;
		}
	}
	game_fall_timeout_cb (self);
}


void
game_stop (Game* self)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drop_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->drop_timeout;
		g_source_remove (_tmp1_);
	}
}


static gboolean
_game_setup_fast_move_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = game_setup_fast_move_cb ((Game*) self);
	return result;
}


static gboolean
game_move_direction (Game* self,
                     gint direction)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->game_over;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->fast_move_direction;
	if (_tmp1_ == direction) {
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->fast_move_timeout;
	if (_tmp2_ != ((guint) 0)) {
		guint _tmp3_;
		_tmp3_ = self->priv->fast_move_timeout;
		g_source_remove (_tmp3_);
	}
	self->priv->fast_move_timeout = (guint) 0;
	self->priv->fast_move_direction = direction;
	if (!game_move (self)) {
		result = FALSE;
		return result;
	}
	self->priv->fast_move_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _game_setup_fast_move_cb_gsource_func, g_object_ref (self), g_object_unref);
	result = TRUE;
	return result;
}


static gboolean
_game_move_gsource_func (gpointer self)
{
	gboolean result;
	result = game_move ((Game*) self);
	return result;
}


static gboolean
game_setup_fast_move_cb (Game* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!game_move (self)) {
		result = FALSE;
		return result;
	}
	self->priv->fast_move_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 40, _game_move_gsource_func, g_object_ref (self), g_object_unref);
	result = FALSE;
	return result;
}


static gboolean
game_move (Game* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->fast_move_direction;
	if (!game_move_shape (self, _tmp0_, 0, 0)) {
		self->priv->fast_move_timeout = (guint) 0;
		self->priv->fast_move_direction = 0;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean
_game_fall_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = game_fall_timeout_cb ((Game*) self);
	return result;
}


static void
game_setup_drop_timer (Game* self)
{
	gint timestep = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	guint _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_get_level (self);
	_tmp1_ = _tmp0_;
	timestep = (gint) round (80 + (800.0 * pow (0.75, (gdouble) (_tmp1_ - 1))));
	_tmp2_ = timestep;
	timestep = MAX (10, _tmp2_);
	_tmp3_ = self->priv->fast_forward;
	if (_tmp3_) {
		timestep = 80;
	}
	_tmp4_ = self->priv->drop_timeout;
	if (_tmp4_ != ((guint) 0)) {
		guint _tmp5_;
		_tmp5_ = self->priv->drop_timeout;
		g_source_remove (_tmp5_);
	}
	self->priv->drop_timeout = (guint) 0;
	_tmp6_ = game_get_paused (self);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		gint _tmp8_;
		_tmp8_ = timestep;
		self->priv->drop_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp8_, _game_fall_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gboolean
game_fall_timeout_cb (Game* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!game_move_shape (self, 0, 1, 0)) {
		game_land_shape (self);
		game_add_shape (self);
	}
	result = TRUE;
	return result;
}


static void
game_add_shape (Game* self)
{
	gboolean _tmp0_;
	Shape* _tmp4_;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pick_difficult_blocks;
	if (_tmp0_) {
		Shape* _tmp1_;
		_tmp1_ = game_pick_difficult_shape (self);
		_g_object_unref0 (self->shape);
		self->shape = _tmp1_;
	} else {
		Shape* _tmp2_;
		Shape* _tmp3_;
		_tmp2_ = self->next_shape;
		self->next_shape = NULL;
		_g_object_unref0 (self->shape);
		self->shape = _tmp2_;
		_tmp3_ = game_pick_random_shape (self);
		_g_object_unref0 (self->next_shape);
		self->next_shape = _tmp3_;
	}
	_tmp4_ = self->shape;
	_tmp5_ = _tmp4_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp5_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp6_;
			Block* b = NULL;
			_tmp6_ = _g_object_ref0 ((Block*) b_it->data);
			b = _tmp6_;
			{
				gint x = 0;
				Shape* _tmp7_;
				gint _tmp8_;
				Block* _tmp9_;
				gint _tmp10_;
				gint y = 0;
				Shape* _tmp11_;
				gint _tmp12_;
				Block* _tmp13_;
				gint _tmp14_;
				gboolean _tmp15_ = FALSE;
				gint _tmp16_;
				_tmp7_ = self->shape;
				_tmp8_ = _tmp7_->x;
				_tmp9_ = b;
				_tmp10_ = _tmp9_->x;
				x = _tmp8_ + _tmp10_;
				_tmp11_ = self->shape;
				_tmp12_ = _tmp11_->y;
				_tmp13_ = b;
				_tmp14_ = _tmp13_->y;
				y = _tmp12_ + _tmp14_;
				_tmp16_ = y;
				if (_tmp16_ >= 0) {
					Block** _tmp17_;
					gint _tmp17__length1;
					gint _tmp17__length2;
					gint _tmp18_;
					gint _tmp19_;
					Block* _tmp20_;
					_tmp17_ = self->blocks;
					_tmp17__length1 = self->blocks_length1;
					_tmp17__length2 = self->blocks_length2;
					_tmp18_ = x;
					_tmp19_ = y;
					_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
					_tmp15_ = _tmp20_ != NULL;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					guint _tmp21_;
					_tmp21_ = self->priv->drop_timeout;
					if (_tmp21_ != ((guint) 0)) {
						guint _tmp22_;
						_tmp22_ = self->priv->drop_timeout;
						g_source_remove (_tmp22_);
					}
					self->priv->drop_timeout = (guint) 0;
					_g_object_unref0 (self->shape);
					self->shape = NULL;
					self->game_over = TRUE;
					g_signal_emit (self, game_signals[GAME_COMPLETE_SIGNAL], 0);
					_g_object_unref0 (b);
					return;
				}
				_g_object_unref0 (b);
			}
		}
	}
	g_signal_emit (self, game_signals[GAME_SHAPE_ADDED_SIGNAL], 0);
}


static Shape*
game_pick_random_shape (Game* self)
{
	Shape* result = NULL;
	Shape* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = game_make_shape (self, (gint) g_random_int_range ((gint32) 0, (gint32) NCOLORS), (gint) g_random_int_range ((gint32) 0, (gint32) 4));
	result = _tmp0_;
	return result;
}


static Shape*
game_pick_difficult_shape (Game* self)
{
	Shape* result = NULL;
	gint* metrics = NULL;
	gint* _tmp0_;
	gint metrics_length1;
	gint _metrics_size_;
	gint* possible_types = NULL;
	gint* _tmp68_;
	gint possible_types_length1;
	gint _possible_types_size_;
	gint32 rnd = 0;
	gint32 _tmp105_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gint, NCOLORS);
	metrics = _tmp0_;
	metrics_length1 = NCOLORS;
	_metrics_size_ = metrics_length1;
	{
		gint type = 0;
		type = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint* _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = type;
					type = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = type;
				if (!(_tmp3_ < NCOLORS)) {
					break;
				}
				_tmp4_ = metrics;
				_tmp4__length1 = metrics_length1;
				_tmp5_ = type;
				_tmp4_[_tmp5_] = -32000;
				_tmp6_ = _tmp4_[_tmp5_];
				{
					gint rotation = 0;
					rotation = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = rotation;
								rotation = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = rotation;
							if (!(_tmp9_ < 4)) {
								break;
							}
							{
								gint pos = 0;
								pos = 0;
								{
									gboolean _tmp10_ = FALSE;
									_tmp10_ = TRUE;
									while (TRUE) {
										gint _tmp12_;
										gint _tmp13_;
										gint _tmp14_;
										Game* g = NULL;
										Game* _tmp15_;
										Game* _tmp16_;
										Game* _tmp17_;
										gint _tmp18_;
										gint _tmp19_;
										Shape* _tmp20_;
										gboolean valid_position = FALSE;
										gboolean _tmp27_;
										gint orig_lines = 0;
										Game* _tmp28_;
										gint _tmp29_;
										Game* _tmp30_;
										gint metric = 0;
										Game* _tmp31_;
										gint _tmp32_;
										gint _tmp33_;
										gint _tmp53_;
										gint* _tmp54_;
										gint _tmp54__length1;
										gint _tmp55_;
										gint _tmp56_;
										Game* _tmp61_;
										if (!_tmp10_) {
											gint _tmp11_;
											_tmp11_ = pos;
											pos = _tmp11_ + 1;
										}
										_tmp10_ = FALSE;
										_tmp12_ = pos;
										_tmp13_ = game_get_width (self);
										_tmp14_ = _tmp13_;
										if (!(_tmp12_ < _tmp14_)) {
											break;
										}
										_tmp15_ = game_copy (self);
										g = _tmp15_;
										_tmp16_ = g;
										_tmp16_->priv->pick_difficult_blocks = FALSE;
										_tmp17_ = g;
										_tmp18_ = type;
										_tmp19_ = rotation;
										_tmp20_ = game_make_shape (self, _tmp18_, _tmp19_);
										_g_object_unref0 (_tmp17_->shape);
										_tmp17_->shape = _tmp20_;
										valid_position = TRUE;
										while (TRUE) {
											Game* _tmp21_;
											_tmp21_ = g;
											if (!game_move_left (_tmp21_)) {
												break;
											}
										}
										{
											gint x = 0;
											x = 0;
											{
												gboolean _tmp22_ = FALSE;
												_tmp22_ = TRUE;
												while (TRUE) {
													gint _tmp24_;
													gint _tmp25_;
													Game* _tmp26_;
													if (!_tmp22_) {
														gint _tmp23_;
														_tmp23_ = x;
														x = _tmp23_ + 1;
													}
													_tmp22_ = FALSE;
													_tmp24_ = x;
													_tmp25_ = pos;
													if (!(_tmp24_ < _tmp25_)) {
														break;
													}
													_tmp26_ = g;
													if (!game_move_right (_tmp26_)) {
														valid_position = FALSE;
														break;
													}
												}
											}
										}
										_tmp27_ = valid_position;
										if (!_tmp27_) {
											_g_object_unref0 (g);
											break;
										}
										_tmp28_ = g;
										_tmp29_ = _tmp28_->n_lines_destroyed;
										orig_lines = _tmp29_;
										_tmp30_ = g;
										game_drop (_tmp30_);
										_tmp31_ = g;
										_tmp32_ = _tmp31_->n_lines_destroyed;
										_tmp33_ = orig_lines;
										metric = (_tmp32_ - _tmp33_) * 5000;
										{
											gint x = 0;
											x = 0;
											{
												gboolean _tmp34_ = FALSE;
												_tmp34_ = TRUE;
												while (TRUE) {
													gint _tmp36_;
													gint _tmp37_;
													gint _tmp38_;
													gint y = 0;
													gint _tmp49_;
													gint _tmp50_;
													gint _tmp51_;
													gint _tmp52_;
													if (!_tmp34_) {
														gint _tmp35_;
														_tmp35_ = x;
														x = _tmp35_ + 1;
													}
													_tmp34_ = FALSE;
													_tmp36_ = x;
													_tmp37_ = game_get_width (self);
													_tmp38_ = _tmp37_;
													if (!(_tmp36_ < _tmp38_)) {
														break;
													}
													{
														gboolean _tmp39_ = FALSE;
														y = 0;
														_tmp39_ = TRUE;
														while (TRUE) {
															gint _tmp41_;
															gint _tmp42_;
															gint _tmp43_;
															Game* _tmp44_;
															Block** _tmp45_;
															gint _tmp45__length1;
															gint _tmp45__length2;
															gint _tmp46_;
															gint _tmp47_;
															Block* _tmp48_;
															if (!_tmp39_) {
																gint _tmp40_;
																_tmp40_ = y;
																y = _tmp40_ + 1;
															}
															_tmp39_ = FALSE;
															_tmp41_ = y;
															_tmp42_ = game_get_height (self);
															_tmp43_ = _tmp42_;
															if (!(_tmp41_ < _tmp43_)) {
																break;
															}
															_tmp44_ = g;
															_tmp45_ = _tmp44_->blocks;
															_tmp45__length1 = _tmp44_->blocks_length1;
															_tmp45__length2 = _tmp44_->blocks_length2;
															_tmp46_ = x;
															_tmp47_ = y;
															_tmp48_ = _tmp45_[(_tmp46_ * _tmp45__length2) + _tmp47_];
															if (_tmp48_ != NULL) {
																break;
															}
														}
													}
													_tmp49_ = metric;
													_tmp50_ = game_get_height (self);
													_tmp51_ = _tmp50_;
													_tmp52_ = y;
													metric = _tmp49_ - (5 * (_tmp51_ - _tmp52_));
												}
											}
										}
										_tmp53_ = metric;
										_tmp54_ = metrics;
										_tmp54__length1 = metrics_length1;
										_tmp55_ = type;
										_tmp56_ = _tmp54_[_tmp55_];
										if (_tmp53_ > _tmp56_) {
											gint* _tmp57_;
											gint _tmp57__length1;
											gint _tmp58_;
											gint _tmp59_;
											gint _tmp60_;
											_tmp57_ = metrics;
											_tmp57__length1 = metrics_length1;
											_tmp58_ = type;
											_tmp59_ = metric;
											_tmp57_[_tmp58_] = _tmp59_;
											_tmp60_ = _tmp57_[_tmp58_];
										}
										_tmp61_ = g;
										game_stop (_tmp61_);
										_g_object_unref0 (g);
									}
								}
							}
						}
					}
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp62_ = FALSE;
			_tmp62_ = TRUE;
			while (TRUE) {
				gint _tmp64_;
				gint* _tmp65_;
				gint _tmp65__length1;
				gint _tmp66_;
				gint _tmp67_;
				if (!_tmp62_) {
					gint _tmp63_;
					_tmp63_ = i;
					i = _tmp63_ + 1;
				}
				_tmp62_ = FALSE;
				_tmp64_ = i;
				if (!(_tmp64_ < NCOLORS)) {
					break;
				}
				_tmp65_ = metrics;
				_tmp65__length1 = metrics_length1;
				_tmp66_ = i;
				_tmp65_[_tmp66_] += (gint) g_random_int_range ((gint32) -2, (gint32) 2);
				_tmp67_ = _tmp65_[_tmp66_];
			}
		}
	}
	_tmp68_ = g_new0 (gint, NCOLORS);
	possible_types = _tmp68_;
	possible_types_length1 = NCOLORS;
	_possible_types_size_ = possible_types_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp69_ = FALSE;
			_tmp69_ = TRUE;
			while (TRUE) {
				gint _tmp71_;
				gint* _tmp72_;
				gint _tmp72__length1;
				gint _tmp73_;
				gint _tmp74_;
				gint _tmp75_;
				if (!_tmp69_) {
					gint _tmp70_;
					_tmp70_ = i;
					i = _tmp70_ + 1;
				}
				_tmp69_ = FALSE;
				_tmp71_ = i;
				if (!(_tmp71_ < NCOLORS)) {
					break;
				}
				_tmp72_ = possible_types;
				_tmp72__length1 = possible_types_length1;
				_tmp73_ = i;
				_tmp74_ = i;
				_tmp72_[_tmp73_] = _tmp74_;
				_tmp75_ = _tmp72_[_tmp73_];
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp76_ = FALSE;
			_tmp76_ = TRUE;
			while (TRUE) {
				gint _tmp78_;
				if (!_tmp76_) {
					gint _tmp77_;
					_tmp77_ = i;
					i = _tmp77_ + 1;
				}
				_tmp76_ = FALSE;
				_tmp78_ = i;
				if (!(_tmp78_ < NCOLORS)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp79_ = FALSE;
						_tmp79_ = TRUE;
						while (TRUE) {
							gint _tmp81_;
							gint* _tmp82_;
							gint _tmp82__length1;
							gint* _tmp83_;
							gint _tmp83__length1;
							gint _tmp84_;
							gint _tmp85_;
							gint _tmp86_;
							gint* _tmp87_;
							gint _tmp87__length1;
							gint* _tmp88_;
							gint _tmp88__length1;
							gint _tmp89_;
							gint _tmp90_;
							gint _tmp91_;
							if (!_tmp79_) {
								gint _tmp80_;
								_tmp80_ = j;
								j = _tmp80_ + 1;
							}
							_tmp79_ = FALSE;
							_tmp81_ = j;
							if (!(_tmp81_ < (NCOLORS - 1))) {
								break;
							}
							_tmp82_ = metrics;
							_tmp82__length1 = metrics_length1;
							_tmp83_ = possible_types;
							_tmp83__length1 = possible_types_length1;
							_tmp84_ = j;
							_tmp85_ = _tmp83_[_tmp84_];
							_tmp86_ = _tmp82_[_tmp85_];
							_tmp87_ = metrics;
							_tmp87__length1 = metrics_length1;
							_tmp88_ = possible_types;
							_tmp88__length1 = possible_types_length1;
							_tmp89_ = j;
							_tmp90_ = _tmp88_[_tmp89_ + 1];
							_tmp91_ = _tmp87_[_tmp90_];
							if (_tmp86_ > _tmp91_) {
								gint t = 0;
								gint* _tmp92_;
								gint _tmp92__length1;
								gint _tmp93_;
								gint _tmp94_;
								gint* _tmp95_;
								gint _tmp95__length1;
								gint _tmp96_;
								gint* _tmp97_;
								gint _tmp97__length1;
								gint _tmp98_;
								gint _tmp99_;
								gint _tmp100_;
								gint* _tmp101_;
								gint _tmp101__length1;
								gint _tmp102_;
								gint _tmp103_;
								gint _tmp104_;
								_tmp92_ = possible_types;
								_tmp92__length1 = possible_types_length1;
								_tmp93_ = j;
								_tmp94_ = _tmp92_[_tmp93_];
								t = _tmp94_;
								_tmp95_ = possible_types;
								_tmp95__length1 = possible_types_length1;
								_tmp96_ = j;
								_tmp97_ = possible_types;
								_tmp97__length1 = possible_types_length1;
								_tmp98_ = j;
								_tmp99_ = _tmp97_[_tmp98_ + 1];
								_tmp95_[_tmp96_] = _tmp99_;
								_tmp100_ = _tmp95_[_tmp96_];
								_tmp101_ = possible_types;
								_tmp101__length1 = possible_types_length1;
								_tmp102_ = j;
								_tmp103_ = t;
								_tmp101_[_tmp102_ + 1] = _tmp103_;
								_tmp104_ = _tmp101_[_tmp102_ + 1];
							}
						}
					}
				}
			}
		}
	}
	rnd = g_random_int_range ((gint32) 0, (gint32) 99);
	_tmp105_ = rnd;
	if (_tmp105_ < ((gint32) 75)) {
		gint* _tmp106_;
		gint _tmp106__length1;
		gint _tmp107_;
		Shape* _tmp108_;
		_tmp106_ = possible_types;
		_tmp106__length1 = possible_types_length1;
		_tmp107_ = _tmp106_[0];
		_tmp108_ = game_make_shape (self, _tmp107_, (gint) g_random_int_range ((gint32) 0, (gint32) 4));
		result = _tmp108_;
		possible_types = (g_free (possible_types), NULL);
		metrics = (g_free (metrics), NULL);
		return result;
	} else {
		gint32 _tmp109_;
		_tmp109_ = rnd;
		if (_tmp109_ < ((gint32) 92)) {
			gint* _tmp110_;
			gint _tmp110__length1;
			gint _tmp111_;
			Shape* _tmp112_;
			_tmp110_ = possible_types;
			_tmp110__length1 = possible_types_length1;
			_tmp111_ = _tmp110_[1];
			_tmp112_ = game_make_shape (self, _tmp111_, (gint) g_random_int_range ((gint32) 0, (gint32) 4));
			result = _tmp112_;
			possible_types = (g_free (possible_types), NULL);
			metrics = (g_free (metrics), NULL);
			return result;
		} else {
			gint32 _tmp113_;
			_tmp113_ = rnd;
			if (_tmp113_ < ((gint32) 98)) {
				gint* _tmp114_;
				gint _tmp114__length1;
				gint _tmp115_;
				Shape* _tmp116_;
				_tmp114_ = possible_types;
				_tmp114__length1 = possible_types_length1;
				_tmp115_ = _tmp114_[2];
				_tmp116_ = game_make_shape (self, _tmp115_, (gint) g_random_int_range ((gint32) 0, (gint32) 4));
				result = _tmp116_;
				possible_types = (g_free (possible_types), NULL);
				metrics = (g_free (metrics), NULL);
				return result;
			} else {
				gint* _tmp117_;
				gint _tmp117__length1;
				gint _tmp118_;
				Shape* _tmp119_;
				_tmp117_ = possible_types;
				_tmp117__length1 = possible_types_length1;
				_tmp118_ = _tmp117_[3];
				_tmp119_ = game_make_shape (self, _tmp118_, (gint) g_random_int_range ((gint32) 0, (gint32) 4));
				result = _tmp119_;
				possible_types = (g_free (possible_types), NULL);
				metrics = (g_free (metrics), NULL);
				return result;
			}
		}
	}
	possible_types = (g_free (possible_types), NULL);
	metrics = (g_free (metrics), NULL);
}


static Shape*
game_make_shape (Game* self,
                 gint type,
                 gint rotation)
{
	Shape* result = NULL;
	Shape* shape = NULL;
	Shape* _tmp0_;
	Shape* _tmp1_;
	Shape* _tmp2_;
	gint offset = 0;
	Shape* _tmp3_;
	gint _tmp4_;
	Shape* _tmp5_;
	gint _tmp6_;
	gint min_width = 0;
	gint max_width = 0;
	gint min_height = 0;
	gint max_height = 0;
	gint block_width = 0;
	gint _tmp36_;
	gint _tmp37_;
	Shape* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	Shape* _tmp42_;
	gint _tmp43_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = shape_new ();
	shape = _tmp0_;
	_tmp1_ = shape;
	_tmp1_->type = type;
	_tmp2_ = shape;
	_tmp2_->rotation = rotation;
	_tmp3_ = shape;
	_tmp4_ = _tmp3_->type;
	_tmp5_ = shape;
	_tmp6_ = _tmp5_->rotation;
	offset = (_tmp4_ * 64) + (_tmp6_ * 16);
	min_width = 4;
	max_width = 0;
	min_height = 4;
	max_height = 0;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = x;
					x = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = x;
				if (!(_tmp9_ < 4)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							gint _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							gint _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							gint _tmp21_;
							gint _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							Block* b = NULL;
							Block* _tmp25_;
							Block* _tmp26_;
							Shape* _tmp27_;
							gint _tmp28_;
							Block* _tmp29_;
							gint _tmp30_;
							Block* _tmp31_;
							gint _tmp32_;
							Shape* _tmp33_;
							Block* _tmp34_;
							Block* _tmp35_;
							if (!_tmp10_) {
								gint _tmp11_;
								_tmp11_ = y;
								y = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = y;
							if (!(_tmp12_ < 4)) {
								break;
							}
							_tmp13_ = offset;
							_tmp14_ = y;
							_tmp15_ = x;
							_tmp16_ = block_table[(_tmp13_ + (_tmp14_ * 4)) + _tmp15_];
							if (_tmp16_ == 0) {
								continue;
							}
							_tmp17_ = x;
							_tmp18_ = min_width;
							min_width = MIN (_tmp17_, _tmp18_);
							_tmp19_ = x;
							_tmp20_ = max_width;
							max_width = MAX (_tmp19_ + 1, _tmp20_);
							_tmp21_ = y;
							_tmp22_ = min_height;
							min_height = MIN (_tmp21_, _tmp22_);
							_tmp23_ = y;
							_tmp24_ = max_height;
							max_height = MAX (_tmp23_ + 1, _tmp24_);
							_tmp25_ = block_new ();
							b = _tmp25_;
							_tmp26_ = b;
							_tmp27_ = shape;
							_tmp28_ = _tmp27_->type;
							_tmp26_->color = _tmp28_;
							_tmp29_ = b;
							_tmp30_ = x;
							_tmp29_->x = _tmp30_;
							_tmp31_ = b;
							_tmp32_ = y;
							_tmp31_->y = _tmp32_;
							_tmp33_ = shape;
							_tmp34_ = b;
							_tmp35_ = _g_object_ref0 (_tmp34_);
							_tmp33_->blocks = g_list_append (_tmp33_->blocks, _tmp35_);
							_g_object_unref0 (b);
						}
					}
				}
			}
		}
	}
	_tmp36_ = max_width;
	_tmp37_ = min_width;
	block_width = _tmp36_ - _tmp37_;
	_tmp38_ = shape;
	_tmp39_ = game_get_width (self);
	_tmp40_ = _tmp39_;
	_tmp41_ = min_width;
	_tmp38_->x = ((_tmp40_ - block_width) / 2) - _tmp41_;
	_tmp42_ = shape;
	_tmp43_ = min_height;
	_tmp42_->y = -_tmp43_;
	result = shape;
	return result;
}


static void
game_land_shape (Game* self)
{
	Shape* _tmp0_;
	GList* _tmp1_;
	gint fall_distance = 0;
	gint* lines = NULL;
	gint* _tmp21_;
	gint lines_length1;
	gint _lines_size_;
	gint n_lines = 0;
	gboolean base_line_destroyed = FALSE;
	gint _tmp45_;
	gint _tmp46_;
	GList* line_blocks = NULL;
	gint old_level = 0;
	gint _tmp105_;
	gint _tmp106_;
	gint _tmp107_;
	gint _tmp108_;
	gint _tmp109_;
	gboolean _tmp122_;
	gint _tmp126_;
	gint _tmp127_;
	gint _tmp128_;
	gint* _tmp129_;
	gint _tmp129__length1;
	GList* _tmp130_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->shape;
	_tmp1_ = _tmp0_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp1_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp2_;
			Block* b = NULL;
			_tmp2_ = _g_object_ref0 ((Block*) b_it->data);
			b = _tmp2_;
			{
				Block* _tmp3_;
				Block* _tmp4_;
				gint _tmp5_;
				Shape* _tmp6_;
				gint _tmp7_;
				Block* _tmp8_;
				Block* _tmp9_;
				gint _tmp10_;
				Shape* _tmp11_;
				gint _tmp12_;
				Block** _tmp13_;
				gint _tmp13__length1;
				gint _tmp13__length2;
				Block* _tmp14_;
				gint _tmp15_;
				Block* _tmp16_;
				gint _tmp17_;
				Block* _tmp18_;
				Block* _tmp19_;
				Block* _tmp20_;
				_tmp3_ = b;
				_tmp4_ = b;
				_tmp5_ = _tmp4_->x;
				_tmp6_ = self->shape;
				_tmp7_ = _tmp6_->x;
				_tmp4_->x = _tmp5_ + _tmp7_;
				_tmp8_ = b;
				_tmp9_ = b;
				_tmp10_ = _tmp9_->y;
				_tmp11_ = self->shape;
				_tmp12_ = _tmp11_->y;
				_tmp9_->y = _tmp10_ + _tmp12_;
				_tmp13_ = self->blocks;
				_tmp13__length1 = self->blocks_length1;
				_tmp13__length2 = self->blocks_length2;
				_tmp14_ = b;
				_tmp15_ = _tmp14_->x;
				_tmp16_ = b;
				_tmp17_ = _tmp16_->y;
				_tmp18_ = b;
				_tmp19_ = _g_object_ref0 (_tmp18_);
				_g_object_unref0 (_tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_]);
				_tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_] = _tmp19_;
				_tmp20_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
				_g_object_unref0 (b);
			}
		}
	}
	fall_distance = 0;
	_tmp21_ = g_new0 (gint, 4);
	lines = _tmp21_;
	lines_length1 = 4;
	_lines_size_ = lines_length1;
	n_lines = 0;
	base_line_destroyed = FALSE;
	{
		gint y = 0;
		gint _tmp22_;
		gint _tmp23_;
		_tmp22_ = game_get_height (self);
		_tmp23_ = _tmp22_;
		y = _tmp23_ - 1;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				gint _tmp26_;
				gboolean explode = FALSE;
				gboolean _tmp36_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = y;
					y = _tmp25_ - 1;
				}
				_tmp24_ = FALSE;
				_tmp26_ = y;
				if (!(_tmp26_ >= 0)) {
					break;
				}
				explode = TRUE;
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp27_ = FALSE;
						_tmp27_ = TRUE;
						while (TRUE) {
							gint _tmp29_;
							gint _tmp30_;
							gint _tmp31_;
							Block** _tmp32_;
							gint _tmp32__length1;
							gint _tmp32__length2;
							gint _tmp33_;
							gint _tmp34_;
							Block* _tmp35_;
							if (!_tmp27_) {
								gint _tmp28_;
								_tmp28_ = x;
								x = _tmp28_ + 1;
							}
							_tmp27_ = FALSE;
							_tmp29_ = x;
							_tmp30_ = game_get_width (self);
							_tmp31_ = _tmp30_;
							if (!(_tmp29_ < _tmp31_)) {
								break;
							}
							_tmp32_ = self->blocks;
							_tmp32__length1 = self->blocks_length1;
							_tmp32__length2 = self->blocks_length2;
							_tmp33_ = x;
							_tmp34_ = y;
							_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
							if (_tmp35_ == NULL) {
								explode = FALSE;
								break;
							}
						}
					}
				}
				_tmp36_ = explode;
				if (_tmp36_) {
					gint _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gint* _tmp40_;
					gint _tmp40__length1;
					gint _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					_tmp37_ = y;
					_tmp38_ = game_get_height (self);
					_tmp39_ = _tmp38_;
					if (_tmp37_ == (_tmp39_ - 1)) {
						base_line_destroyed = TRUE;
					}
					_tmp40_ = lines;
					_tmp40__length1 = lines_length1;
					_tmp41_ = n_lines;
					_tmp42_ = y;
					_tmp40_[_tmp41_] = _tmp42_;
					_tmp43_ = _tmp40_[_tmp41_];
					_tmp44_ = n_lines;
					n_lines = _tmp44_ + 1;
				}
			}
		}
	}
	_tmp45_ = n_lines;
	_tmp46_ = _tmp45_;
	lines = g_renew (gint, lines, _tmp45_);
	(_tmp46_ > lines_length1) ? memset (lines + lines_length1, 0, sizeof (gint) * (_tmp46_ - lines_length1)) : NULL;
	lines_length1 = _tmp46_;
	_lines_size_ = _tmp46_;
	line_blocks = NULL;
	{
		gint y = 0;
		gint _tmp47_;
		gint _tmp48_;
		_tmp47_ = game_get_height (self);
		_tmp48_ = _tmp47_;
		y = _tmp48_ - 1;
		{
			gboolean _tmp49_ = FALSE;
			_tmp49_ = TRUE;
			while (TRUE) {
				gint _tmp51_;
				gboolean explode = FALSE;
				gboolean _tmp61_;
				if (!_tmp49_) {
					gint _tmp50_;
					_tmp50_ = y;
					y = _tmp50_ - 1;
				}
				_tmp49_ = FALSE;
				_tmp51_ = y;
				if (!(_tmp51_ >= 0)) {
					break;
				}
				explode = TRUE;
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp52_ = FALSE;
						_tmp52_ = TRUE;
						while (TRUE) {
							gint _tmp54_;
							gint _tmp55_;
							gint _tmp56_;
							Block** _tmp57_;
							gint _tmp57__length1;
							gint _tmp57__length2;
							gint _tmp58_;
							gint _tmp59_;
							Block* _tmp60_;
							if (!_tmp52_) {
								gint _tmp53_;
								_tmp53_ = x;
								x = _tmp53_ + 1;
							}
							_tmp52_ = FALSE;
							_tmp54_ = x;
							_tmp55_ = game_get_width (self);
							_tmp56_ = _tmp55_;
							if (!(_tmp54_ < _tmp56_)) {
								break;
							}
							_tmp57_ = self->blocks;
							_tmp57__length1 = self->blocks_length1;
							_tmp57__length2 = self->blocks_length2;
							_tmp58_ = x;
							_tmp59_ = y;
							_tmp60_ = _tmp57_[(_tmp58_ * _tmp57__length2) + _tmp59_];
							if (_tmp60_ == NULL) {
								explode = FALSE;
								break;
							}
						}
					}
				}
				_tmp61_ = explode;
				if (_tmp61_) {
					gint _tmp76_;
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp62_ = FALSE;
							_tmp62_ = TRUE;
							while (TRUE) {
								gint _tmp64_;
								gint _tmp65_;
								gint _tmp66_;
								Block** _tmp67_;
								gint _tmp67__length1;
								gint _tmp67__length2;
								gint _tmp68_;
								gint _tmp69_;
								Block* _tmp70_;
								Block* _tmp71_;
								Block** _tmp72_;
								gint _tmp72__length1;
								gint _tmp72__length2;
								gint _tmp73_;
								gint _tmp74_;
								Block* _tmp75_;
								if (!_tmp62_) {
									gint _tmp63_;
									_tmp63_ = x;
									x = _tmp63_ + 1;
								}
								_tmp62_ = FALSE;
								_tmp64_ = x;
								_tmp65_ = game_get_width (self);
								_tmp66_ = _tmp65_;
								if (!(_tmp64_ < _tmp66_)) {
									break;
								}
								_tmp67_ = self->blocks;
								_tmp67__length1 = self->blocks_length1;
								_tmp67__length2 = self->blocks_length2;
								_tmp68_ = x;
								_tmp69_ = y;
								_tmp70_ = _tmp67_[(_tmp68_ * _tmp67__length2) + _tmp69_];
								_tmp71_ = _g_object_ref0 (_tmp70_);
								line_blocks = g_list_append (line_blocks, _tmp71_);
								_tmp72_ = self->blocks;
								_tmp72__length1 = self->blocks_length1;
								_tmp72__length2 = self->blocks_length2;
								_tmp73_ = x;
								_tmp74_ = y;
								_g_object_unref0 (_tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_]);
								_tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_] = NULL;
								_tmp75_ = _tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_];
							}
						}
					}
					_tmp76_ = fall_distance;
					fall_distance = _tmp76_ + 1;
				} else {
					gint _tmp77_;
					_tmp77_ = fall_distance;
					if (_tmp77_ > 0) {
						{
							gint x = 0;
							x = 0;
							{
								gboolean _tmp78_ = FALSE;
								_tmp78_ = TRUE;
								while (TRUE) {
									gint _tmp80_;
									gint _tmp81_;
									gint _tmp82_;
									Block* b = NULL;
									Block** _tmp83_;
									gint _tmp83__length1;
									gint _tmp83__length2;
									gint _tmp84_;
									gint _tmp85_;
									Block* _tmp86_;
									Block* _tmp87_;
									Block* _tmp88_;
									if (!_tmp78_) {
										gint _tmp79_;
										_tmp79_ = x;
										x = _tmp79_ + 1;
									}
									_tmp78_ = FALSE;
									_tmp80_ = x;
									_tmp81_ = game_get_width (self);
									_tmp82_ = _tmp81_;
									if (!(_tmp80_ < _tmp82_)) {
										break;
									}
									_tmp83_ = self->blocks;
									_tmp83__length1 = self->blocks_length1;
									_tmp83__length2 = self->blocks_length2;
									_tmp84_ = x;
									_tmp85_ = y;
									_tmp86_ = _tmp83_[(_tmp84_ * _tmp83__length2) + _tmp85_];
									_tmp87_ = _g_object_ref0 (_tmp86_);
									b = _tmp87_;
									_tmp88_ = b;
									if (_tmp88_ != NULL) {
										Block* _tmp89_;
										Block* _tmp90_;
										gint _tmp91_;
										gint _tmp92_;
										Block** _tmp93_;
										gint _tmp93__length1;
										gint _tmp93__length2;
										Block* _tmp94_;
										gint _tmp95_;
										Block* _tmp96_;
										gint _tmp97_;
										Block* _tmp98_;
										Block* _tmp99_;
										Block* _tmp100_;
										Block** _tmp101_;
										gint _tmp101__length1;
										gint _tmp101__length2;
										gint _tmp102_;
										gint _tmp103_;
										Block* _tmp104_;
										_tmp89_ = b;
										_tmp90_ = b;
										_tmp91_ = _tmp90_->y;
										_tmp92_ = fall_distance;
										_tmp90_->y = _tmp91_ + _tmp92_;
										_tmp93_ = self->blocks;
										_tmp93__length1 = self->blocks_length1;
										_tmp93__length2 = self->blocks_length2;
										_tmp94_ = b;
										_tmp95_ = _tmp94_->x;
										_tmp96_ = b;
										_tmp97_ = _tmp96_->y;
										_tmp98_ = b;
										_tmp99_ = _g_object_ref0 (_tmp98_);
										_g_object_unref0 (_tmp93_[(_tmp95_ * _tmp93__length2) + _tmp97_]);
										_tmp93_[(_tmp95_ * _tmp93__length2) + _tmp97_] = _tmp99_;
										_tmp100_ = _tmp93_[(_tmp95_ * _tmp93__length2) + _tmp97_];
										_tmp101_ = self->blocks;
										_tmp101__length1 = self->blocks_length1;
										_tmp101__length2 = self->blocks_length2;
										_tmp102_ = x;
										_tmp103_ = y;
										_g_object_unref0 (_tmp101_[(_tmp102_ * _tmp101__length2) + _tmp103_]);
										_tmp101_[(_tmp102_ * _tmp101__length2) + _tmp103_] = NULL;
										_tmp104_ = _tmp101_[(_tmp102_ * _tmp101__length2) + _tmp103_];
									}
									_g_object_unref0 (b);
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp105_ = game_get_level (self);
	_tmp106_ = _tmp105_;
	old_level = _tmp106_;
	_tmp107_ = self->n_lines_destroyed;
	_tmp108_ = n_lines;
	self->n_lines_destroyed = _tmp107_ + _tmp108_;
	_tmp109_ = n_lines;
	switch (_tmp109_) {
		case 0:
		{
			break;
		}
		case 1:
		{
			gint _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			_tmp110_ = self->score;
			_tmp111_ = game_get_level (self);
			_tmp112_ = _tmp111_;
			self->score = _tmp110_ + (40 * _tmp112_);
			break;
		}
		case 2:
		{
			gint _tmp113_;
			gint _tmp114_;
			gint _tmp115_;
			_tmp113_ = self->score;
			_tmp114_ = game_get_level (self);
			_tmp115_ = _tmp114_;
			self->score = _tmp113_ + (100 * _tmp115_);
			break;
		}
		case 3:
		{
			gint _tmp116_;
			gint _tmp117_;
			gint _tmp118_;
			_tmp116_ = self->score;
			_tmp117_ = game_get_level (self);
			_tmp118_ = _tmp117_;
			self->score = _tmp116_ + (300 * _tmp118_);
			break;
		}
		case 4:
		{
			gint _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			_tmp119_ = self->score;
			_tmp120_ = game_get_level (self);
			_tmp121_ = _tmp120_;
			self->score = _tmp119_ + (1200 * _tmp121_);
			break;
		}
		default:
		break;
	}
	_tmp122_ = base_line_destroyed;
	if (_tmp122_) {
		gint _tmp123_;
		gint _tmp124_;
		gint _tmp125_;
		_tmp123_ = self->score;
		_tmp124_ = game_get_level (self);
		_tmp125_ = _tmp124_;
		self->score = _tmp123_ + (10000 * _tmp125_);
	}
	_tmp126_ = game_get_level (self);
	_tmp127_ = _tmp126_;
	_tmp128_ = old_level;
	if (_tmp127_ != _tmp128_) {
		game_setup_drop_timer (self);
	}
	_tmp129_ = lines;
	_tmp129__length1 = lines_length1;
	_tmp130_ = line_blocks;
	g_signal_emit (self, game_signals[GAME_SHAPE_LANDED_SIGNAL], 0, _tmp129_, _tmp129__length1, _tmp130_);
	_g_object_unref0 (self->shape);
	self->shape = NULL;
	(line_blocks == NULL) ? NULL : (line_blocks = (_g_list_free__g_object_unref0_ (line_blocks), NULL));
	lines = (g_free (lines), NULL);
}


static gboolean
game_move_shape (Game* self,
                 gint x_step,
                 gint y_step,
                 gint r_step)
{
	gboolean result = FALSE;
	Shape* _tmp0_;
	gboolean can_move = FALSE;
	Shape* _tmp1_;
	GList* _tmp2_;
	gboolean _tmp26_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->shape;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	game_rotate_shape (self, r_step);
	can_move = TRUE;
	_tmp1_ = self->shape;
	_tmp2_ = _tmp1_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp2_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp3_;
			Block* b = NULL;
			_tmp3_ = _g_object_ref0 ((Block*) b_it->data);
			b = _tmp3_;
			{
				gint x = 0;
				Shape* _tmp4_;
				gint _tmp5_;
				Block* _tmp6_;
				gint _tmp7_;
				gint y = 0;
				Shape* _tmp8_;
				gint _tmp9_;
				Block* _tmp10_;
				gint _tmp11_;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				_tmp4_ = self->shape;
				_tmp5_ = _tmp4_->x;
				_tmp6_ = b;
				_tmp7_ = _tmp6_->x;
				x = (_tmp5_ + x_step) + _tmp7_;
				_tmp8_ = self->shape;
				_tmp9_ = _tmp8_->y;
				_tmp10_ = b;
				_tmp11_ = _tmp10_->y;
				y = (_tmp9_ + y_step) + _tmp11_;
				_tmp15_ = x;
				if (_tmp15_ < 0) {
					_tmp14_ = TRUE;
				} else {
					gint _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp16_ = x;
					_tmp17_ = game_get_width (self);
					_tmp18_ = _tmp17_;
					_tmp14_ = _tmp16_ >= _tmp18_;
				}
				if (_tmp14_) {
					_tmp13_ = TRUE;
				} else {
					gint _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					_tmp19_ = y;
					_tmp20_ = game_get_height (self);
					_tmp21_ = _tmp20_;
					_tmp13_ = _tmp19_ >= _tmp21_;
				}
				if (_tmp13_) {
					_tmp12_ = TRUE;
				} else {
					Block** _tmp22_;
					gint _tmp22__length1;
					gint _tmp22__length2;
					gint _tmp23_;
					gint _tmp24_;
					Block* _tmp25_;
					_tmp22_ = self->blocks;
					_tmp22__length1 = self->blocks_length1;
					_tmp22__length2 = self->blocks_length2;
					_tmp23_ = x;
					_tmp24_ = y;
					_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
					_tmp12_ = _tmp25_ != NULL;
				}
				if (_tmp12_) {
					can_move = FALSE;
					_g_object_unref0 (b);
					break;
				}
				_g_object_unref0 (b);
			}
		}
	}
	_tmp26_ = can_move;
	if (_tmp26_) {
		Shape* _tmp27_;
		Shape* _tmp28_;
		gint _tmp29_;
		Shape* _tmp30_;
		Shape* _tmp31_;
		gint _tmp32_;
		_tmp27_ = self->shape;
		_tmp28_ = self->shape;
		_tmp29_ = _tmp28_->x;
		_tmp28_->x = _tmp29_ + x_step;
		_tmp30_ = self->shape;
		_tmp31_ = self->shape;
		_tmp32_ = _tmp31_->y;
		_tmp31_->y = _tmp32_ + y_step;
		if (x_step != 0) {
			g_signal_emit (self, game_signals[GAME_SHAPE_MOVED_SIGNAL], 0);
		} else {
			if (y_step > 0) {
				g_signal_emit (self, game_signals[GAME_SHAPE_DROPPED_SIGNAL], 0);
			} else {
				g_signal_emit (self, game_signals[GAME_SHAPE_ROTATED_SIGNAL], 0);
			}
		}
	} else {
		game_rotate_shape (self, -r_step);
	}
	result = can_move;
	return result;
}


static void
game_rotate_shape (Game* self,
                   gint r_step)
{
	gint r = 0;
	Shape* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp4_;
	gint _tmp6_;
	Shape* _tmp7_;
	gint _tmp8_;
	Shape* _tmp9_;
	gint _tmp10_;
	GList* b = NULL;
	Shape* _tmp11_;
	GList* _tmp12_;
	gint offset = 0;
	Shape* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->shape;
	_tmp1_ = _tmp0_->rotation;
	r = _tmp1_ + r_step;
	_tmp2_ = r;
	if (_tmp2_ < 0) {
		gint _tmp3_;
		_tmp3_ = r;
		r = _tmp3_ + 4;
	}
	_tmp4_ = r;
	if (_tmp4_ >= 4) {
		gint _tmp5_;
		_tmp5_ = r;
		r = _tmp5_ - 4;
	}
	_tmp6_ = r;
	_tmp7_ = self->shape;
	_tmp8_ = _tmp7_->rotation;
	if (_tmp6_ == _tmp8_) {
		return;
	}
	_tmp9_ = self->shape;
	_tmp10_ = r;
	_tmp9_->rotation = _tmp10_;
	_tmp11_ = self->shape;
	_tmp12_ = _tmp11_->blocks;
	b = _tmp12_;
	_tmp13_ = self->shape;
	_tmp14_ = _tmp13_->type;
	_tmp15_ = r;
	offset = (_tmp14_ * 64) + (_tmp15_ * 16);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = x;
					x = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = x;
				if (!(_tmp18_ < 4)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp19_ = FALSE;
						_tmp19_ = TRUE;
						while (TRUE) {
							gint _tmp21_;
							gint _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							gint _tmp25_;
							if (!_tmp19_) {
								gint _tmp20_;
								_tmp20_ = y;
								y = _tmp20_ + 1;
							}
							_tmp19_ = FALSE;
							_tmp21_ = y;
							if (!(_tmp21_ < 4)) {
								break;
							}
							_tmp22_ = offset;
							_tmp23_ = y;
							_tmp24_ = x;
							_tmp25_ = block_table[(_tmp22_ + (_tmp23_ * 4)) + _tmp24_];
							if (_tmp25_ != 0) {
								GList* _tmp26_;
								gconstpointer _tmp27_;
								gint _tmp28_;
								GList* _tmp29_;
								gconstpointer _tmp30_;
								gint _tmp31_;
								GList* _tmp32_;
								GList* _tmp33_;
								_tmp26_ = b;
								_tmp27_ = _tmp26_->data;
								_tmp28_ = x;
								((Block*) _tmp27_)->x = _tmp28_;
								_tmp29_ = b;
								_tmp30_ = _tmp29_->data;
								_tmp31_ = y;
								((Block*) _tmp30_)->y = _tmp31_;
								_tmp32_ = b;
								_tmp33_ = _tmp32_->next;
								b = _tmp33_;
							}
						}
					}
				}
			}
		}
	}
}


gint
game_get_width (Game* self)
{
	gint result;
	Block** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->blocks;
	_tmp0__length1 = self->blocks_length1;
	_tmp0__length2 = self->blocks_length2;
	_tmp1_ = _tmp0__length1;
	result = _tmp1_;
	return result;
}


gint
game_get_height (Game* self)
{
	gint result;
	Block** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->blocks;
	_tmp0__length1 = self->blocks_length1;
	_tmp0__length2 = self->blocks_length2;
	_tmp1_ = _tmp0__length2;
	result = _tmp1_;
	return result;
}


gint
game_get_level (Game* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->starting_level;
	_tmp1_ = self->n_lines_destroyed;
	result = _tmp0_ + (_tmp1_ / 10);
	return result;
}


gboolean
game_get_paused (Game* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paused;
	result = _tmp0_;
	return result;
}


void
game_set_paused (Game* self,
                 gboolean value)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_paused = value;
	_tmp1_ = self->priv->has_started;
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->game_over;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		game_setup_drop_timer (self);
	}
	g_signal_emit (self, game_signals[GAME_PAUSE_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_PAUSED_PROPERTY]);
}


gint
game_get_shadow_y (Game* self)
{
	gint result;
	Shape* _tmp0_;
	gint d = 0;
	Game* g = NULL;
	Game* _tmp1_;
	Shape* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->shape;
	if (_tmp0_ == NULL) {
		result = 0;
		return result;
	}
	d = 0;
	_tmp1_ = game_copy (self);
	g = _tmp1_;
	while (TRUE) {
		Game* _tmp2_;
		gint _tmp3_;
		_tmp2_ = g;
		if (!game_move_shape (_tmp2_, 0, 1, 0)) {
			break;
		}
		_tmp3_ = d;
		d = _tmp3_ + 1;
	}
	_tmp4_ = self->shape;
	_tmp5_ = _tmp4_->y;
	_tmp6_ = d;
	result = _tmp5_ + _tmp6_;
	_g_object_unref0 (g);
	return result;
}


static void
g_cclosure_user_marshal_VOID__POINTER_INT_POINTER (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__POINTER_INT_POINTER) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_pointer (param_values + 3), data2);
}


static void
game_class_init (GameClass * klass)
{
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Game_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WIDTH_PROPERTY, game_properties[GAME_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HEIGHT_PROPERTY, game_properties[GAME_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_LEVEL_PROPERTY, game_properties[GAME_LEVEL_PROPERTY] = g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_PAUSED_PROPERTY, game_properties[GAME_PAUSED_PROPERTY] = g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SHADOW_Y_PROPERTY, game_properties[GAME_SHADOW_Y_PROPERTY] = g_param_spec_int ("shadow-y", "shadow-y", "shadow-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	game_signals[GAME_STARTED_SIGNAL] = g_signal_new ("started", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_SHAPE_ADDED_SIGNAL] = g_signal_new ("shape-added", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_SHAPE_MOVED_SIGNAL] = g_signal_new ("shape-moved", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_SHAPE_DROPPED_SIGNAL] = g_signal_new ("shape-dropped", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_SHAPE_ROTATED_SIGNAL] = g_signal_new ("shape-rotated", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_SHAPE_LANDED_SIGNAL] = g_signal_new ("shape-landed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_POINTER, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_POINTER);
	game_signals[GAME_PAUSE_CHANGED_SIGNAL] = g_signal_new ("pause-changed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_COMPLETE_SIGNAL] = g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
game_instance_init (Game * self)
{
	self->priv = game_get_instance_private (self);
	self->shape = NULL;
	self->next_shape = NULL;
	self->n_lines_destroyed = 0;
	self->score = 0;
	self->priv->starting_level = 1;
	self->priv->pick_difficult_blocks = FALSE;
	self->priv->fast_move_direction = 0;
	self->priv->fast_move_timeout = (guint) 0;
	self->priv->fast_forward = FALSE;
	self->priv->drop_timeout = (guint) 0;
	self->priv->has_started = FALSE;
	self->priv->_paused = FALSE;
	self->game_over = FALSE;
}


static void
game_finalize (GObject * obj)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	_g_object_unref0 (self->shape);
	_g_object_unref0 (self->next_shape);
	self->blocks = (_vala_array_free (self->blocks, self->blocks_length1 * self->blocks_length2, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}


GType
game_get_type (void)
{
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		Game_private_offset = g_type_add_instance_private (game_type_id, sizeof (GamePrivate));
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void
_vala_game_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_WIDTH_PROPERTY:
		g_value_set_int (value, game_get_width (self));
		break;
		case GAME_HEIGHT_PROPERTY:
		g_value_set_int (value, game_get_height (self));
		break;
		case GAME_LEVEL_PROPERTY:
		g_value_set_int (value, game_get_level (self));
		break;
		case GAME_PAUSED_PROPERTY:
		g_value_set_boolean (value, game_get_paused (self));
		break;
		case GAME_SHADOW_Y_PROPERTY:
		g_value_set_int (value, game_get_shadow_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_game_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_PAUSED_PROPERTY:
		game_set_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



