/* game-view.c generated by valac 0.42.2, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_TEXT_OVERLAY (text_overlay_get_type ())
#define TEXT_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_OVERLAY, TextOverlay))
#define TEXT_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_OVERLAY, TextOverlayClass))
#define IS_TEXT_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_OVERLAY))
#define IS_TEXT_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_OVERLAY))
#define TEXT_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_OVERLAY, TextOverlayClass))

typedef struct _TextOverlay TextOverlay;
typedef struct _TextOverlayClass TextOverlayClass;

#define TYPE_BLOCK_TEXTURE (block_texture_get_type ())
#define BLOCK_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_TEXTURE, BlockTexture))
#define BLOCK_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_TEXTURE, BlockTextureClass))
#define IS_BLOCK_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_TEXTURE))
#define IS_BLOCK_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_TEXTURE))
#define BLOCK_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_TEXTURE, BlockTextureClass))

typedef struct _BlockTexture BlockTexture;
typedef struct _BlockTextureClass BlockTextureClass;

#define TYPE_BLOCK (block_get_type ())
#define BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK, Block))
#define BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK, BlockClass))
#define IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK))
#define IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK))
#define BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK, BlockClass))

typedef struct _Block Block;
typedef struct _BlockClass BlockClass;

#define TYPE_BLOCK_ACTOR (block_actor_get_type ())
#define BLOCK_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_ACTOR, BlockActor))
#define BLOCK_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_ACTOR, BlockActorClass))
#define IS_BLOCK_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_ACTOR))
#define IS_BLOCK_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_ACTOR))
#define BLOCK_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_ACTOR, BlockActorClass))

typedef struct _BlockActor BlockActor;
typedef struct _BlockActorClass BlockActorClass;
enum  {
	GAME_VIEW_0_PROPERTY,
	GAME_VIEW_GAME_PROPERTY,
	GAME_VIEW_THEME_PROPERTY,
	GAME_VIEW_SHOW_SHADOW_PROPERTY,
	GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* game_view_properties[GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GamePrivate GamePrivate;

#define TYPE_SHAPE (shape_get_type ())
#define SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHAPE, Shape))
#define SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHAPE, ShapeClass))
#define IS_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHAPE))
#define IS_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHAPE))
#define SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHAPE, ShapeClass))

typedef struct _Shape Shape;
typedef struct _ShapeClass ShapeClass;
typedef struct _ShapePrivate ShapePrivate;
typedef struct _BlockPrivate BlockPrivate;
typedef struct _BlockActorPrivate BlockActorPrivate;
enum  {
	BLOCK_ACTOR_0_PROPERTY,
	BLOCK_ACTOR_NUM_PROPERTIES
};
static GParamSpec* block_actor_properties[BLOCK_ACTOR_NUM_PROPERTIES];
typedef struct _TextOverlayPrivate TextOverlayPrivate;
enum  {
	TEXT_OVERLAY_0_PROPERTY,
	TEXT_OVERLAY_TEXT_PROPERTY,
	TEXT_OVERLAY_NUM_PROPERTIES
};
static GParamSpec* text_overlay_properties[TEXT_OVERLAY_NUM_PROPERTIES];
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _BlockTexturePrivate BlockTexturePrivate;
enum  {
	BLOCK_TEXTURE_0_PROPERTY,
	BLOCK_TEXTURE_THEME_PROPERTY,
	BLOCK_TEXTURE_NUM_PROPERTIES
};
static GParamSpec* block_texture_properties[BLOCK_TEXTURE_NUM_PROPERTIES];
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

struct _GameView {
	GtkClutterEmbed parent_instance;
	GameViewPrivate * priv;
	gboolean mute;
};

struct _GameViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _GameViewPrivate {
	Game* _game;
	ClutterActor* playing_field;
	ClutterActor* shape;
	ClutterClone* shape_shadow;
	gboolean _show_shadow;
	TextOverlay* text_overlay;
	BlockTexture** block_textures;
	gint block_textures_length1;
	gint _block_textures_size_;
	GHashTable* blocks;
	GHashTable* shape_blocks;
	gint n_lines_destroyed;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Shape* shape;
	Shape* next_shape;
	Block** blocks;
	gint blocks_length1;
	gint blocks_length2;
	gint n_lines_destroyed;
	gint score;
	gboolean game_over;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Shape {
	GObject parent_instance;
	ShapePrivate * priv;
	gint x;
	gint y;
	gint rotation;
	gint type;
	GList* blocks;
};

struct _ShapeClass {
	GObjectClass parent_class;
};

struct _Block {
	GObject parent_instance;
	BlockPrivate * priv;
	gint x;
	gint y;
	gint color;
};

struct _BlockClass {
	GObjectClass parent_class;
};

struct _BlockActor {
	ClutterClone parent_instance;
	BlockActorPrivate * priv;
	Block* block;
};

struct _BlockActorClass {
	ClutterCloneClass parent_class;
};

struct _TextOverlay {
	ClutterCairoTexture parent_instance;
	TextOverlayPrivate * priv;
};

struct _TextOverlayClass {
	ClutterCairoTextureClass parent_class;
};

struct _TextOverlayPrivate {
	gchar* _text;
};

struct _BlockTexture {
	ClutterCairoTexture parent_instance;
	BlockTexturePrivate * priv;
};

struct _BlockTextureClass {
	ClutterCairoTextureClass parent_class;
};

struct _BlockTexturePrivate {
	gint color;
	gchar* _theme;
};


static gint GameView_private_offset;
static gpointer game_view_parent_class = NULL;
static gpointer block_actor_parent_class = NULL;
static gint TextOverlay_private_offset;
static gpointer text_overlay_parent_class = NULL;
static gint BlockTexture_private_offset;
static gpointer block_texture_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
GType text_overlay_get_type (void) G_GNUC_CONST;
GType block_texture_get_type (void) G_GNUC_CONST;
GType block_get_type (void) G_GNUC_CONST;
GType block_actor_get_type (void) G_GNUC_CONST;
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
static void game_view_size_allocate_cb (GameView* self,
                                 GtkWidget* widget,
                                 GtkAllocation* allocation);
static void _game_view_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                           GtkAllocation* allocation,
                                                           gpointer self);
TextOverlay* text_overlay_new (void);
TextOverlay* text_overlay_construct (GType object_type);
#define NCOLORS 7
BlockTexture* block_texture_new (gint color);
BlockTexture* block_texture_construct (GType object_type,
                                       gint color);
static void game_view_play_sound (GameView* self,
                           const gchar* name);
static void game_view_shape_added_cb (GameView* self);
Game* game_view_get_game (GameView* self);
GType shape_get_type (void) G_GNUC_CONST;
static gint game_view_get_cell_size (GameView* self);
static void game_view_update_shadow (GameView* self);
BlockActor* block_actor_new (Block* block,
                             ClutterActor* texture);
BlockActor* block_actor_construct (GType object_type,
                                   Block* block,
                                   ClutterActor* texture);
static void game_view_shape_moved_cb (GameView* self);
gint game_get_shadow_y (Game* self);
gboolean game_view_get_show_shadow (GameView* self);
static void game_view_shape_dropped_cb (GameView* self);
static void game_view_shape_rotated_cb (GameView* self);
static void game_view_shape_landed_cb (GameView* self,
                                gint* lines,
                                int lines_length1,
                                GList* line_blocks);
void block_actor_explode (BlockActor* self);
gint game_get_width (Game* self);
gint game_get_height (Game* self);
static void game_view_pause_changed_cb (GameView* self);
static void game_view_update_message (GameView* self);
static void game_view_game_complete_cb (GameView* self);
gboolean game_get_paused (Game* self);
void text_overlay_set_text (TextOverlay* self,
                            const gchar* value);
void game_view_set_game (GameView* self,
                         Game* value);
static void _game_view_shape_added_cb_game_shape_added (Game* _sender,
                                                 gpointer self);
static void _game_view_shape_moved_cb_game_shape_moved (Game* _sender,
                                                 gpointer self);
static void _game_view_shape_dropped_cb_game_shape_dropped (Game* _sender,
                                                     gpointer self);
static void _game_view_shape_rotated_cb_game_shape_rotated (Game* _sender,
                                                     gpointer self);
static void _game_view_shape_landed_cb_game_shape_landed (Game* _sender,
                                                   gint* lines,
                                                   int lines_length1,
                                                   GList* line_blocks,
                                                   gpointer self);
static void _game_view_pause_changed_cb_game_pause_changed (Game* _sender,
                                                     gpointer self);
static void _game_view_game_complete_cb_game_complete (Game* _sender,
                                                gpointer self);
void game_view_set_theme (GameView* self,
                          const gchar* value);
void block_texture_set_theme (BlockTexture* self,
                              const gchar* value);
void game_view_set_show_shadow (GameView* self,
                                gboolean value);
static void game_view_finalize (GObject * obj);
static void _vala_game_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static void block_actor_explode_complete_cb (BlockActor* self);
static void _block_actor_explode_complete_cb_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                           gpointer self);
static void block_actor_finalize (GObject * obj);
static gboolean text_overlay_real_draw (ClutterCairoTexture* base,
                                 cairo_t* cr);
const gchar* text_overlay_get_text (TextOverlay* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void text_overlay_finalize (GObject * obj);
static void _vala_text_overlay_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_text_overlay_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static gboolean block_texture_real_draw (ClutterCairoTexture* base,
                                  cairo_t* cr);
const gchar* block_texture_get_theme (BlockTexture* self);
static void block_texture_draw_clean (BlockTexture* self,
                               cairo_t* cr);
static void block_texture_draw_tango (BlockTexture* self,
                               cairo_t* cr,
                               gboolean use_gradients);
static void block_texture_draw_plain (BlockTexture* self,
                               cairo_t* cr);
static void block_texture_draw_rounded_rectangle (BlockTexture* self,
                                           cairo_t* cr,
                                           gdouble x,
                                           gdouble y,
                                           gdouble w,
                                           gdouble h,
                                           gdouble r);
static void block_texture_finalize (GObject * obj);
static void _vala_block_texture_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_block_texture_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static inline gpointer
game_view_get_instance_private (GameView* self)
{
	return G_STRUCT_MEMBER_P (self, GameView_private_offset);
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void
_game_view_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                      GtkAllocation* allocation,
                                                      gpointer self)
{
	game_view_size_allocate_cb ((GameView*) self, _sender, allocation);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


GameView*
game_view_construct (GType object_type)
{
	GameView * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	ClutterStage* stage = NULL;
	ClutterActor* _tmp6_;
	ClutterStage* _tmp7_;
	ClutterColor stage_color = {0};
	ClutterColor _tmp8_ = {0};
	ClutterColor field_color = {0};
	ClutterColor _tmp9_ = {0};
	ClutterStage* _tmp10_;
	ClutterColor _tmp11_;
	ClutterActor* _tmp12_;
	ClutterActor* _tmp13_;
	ClutterColor _tmp14_;
	ClutterStage* _tmp15_;
	ClutterActor* _tmp16_;
	TextOverlay* _tmp17_;
	TextOverlay* _tmp18_;
	ClutterStage* _tmp19_;
	TextOverlay* _tmp20_;
	BlockTexture** _tmp21_;
	self = (GameView*) g_object_new (object_type, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->blocks);
	self->priv->blocks = _tmp2_;
	_tmp3_ = g_direct_hash;
	_tmp4_ = g_direct_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->shape_blocks);
	self->priv->shape_blocks = _tmp5_;
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _game_view_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp6_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) self);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, clutter_stage_get_type (), ClutterStage));
	stage = _tmp7_;
	_tmp8_.red = (guint8) 0x10;
	_tmp8_.green = (guint8) 0x10;
	_tmp8_.blue = (guint8) 0x10;
	_tmp8_.alpha = (guint8) 0xff;
	stage_color = _tmp8_;
	_tmp9_.red = (guint8) 0x0;
	_tmp9_.green = (guint8) 0x0;
	_tmp9_.blue = (guint8) 0x0;
	_tmp9_.alpha = (guint8) 0xff;
	field_color = _tmp9_;
	_tmp10_ = stage;
	_tmp11_ = stage_color;
	clutter_actor_set_background_color ((ClutterActor*) _tmp10_, &_tmp11_);
	_tmp12_ = clutter_actor_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->playing_field);
	self->priv->playing_field = _tmp12_;
	_tmp13_ = self->priv->playing_field;
	_tmp14_ = field_color;
	clutter_actor_set_background_color (_tmp13_, &_tmp14_);
	_tmp15_ = stage;
	_tmp16_ = self->priv->playing_field;
	clutter_actor_add_child ((ClutterActor*) _tmp15_, _tmp16_);
	_tmp17_ = text_overlay_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->text_overlay);
	self->priv->text_overlay = _tmp17_;
	_tmp18_ = self->priv->text_overlay;
	clutter_cairo_texture_set_surface_size ((ClutterCairoTexture*) _tmp18_, (guint) 1, (guint) 1);
	_tmp19_ = stage;
	_tmp20_ = self->priv->text_overlay;
	clutter_container_add ((ClutterContainer*) _tmp19_, (ClutterActor*) _tmp20_, NULL);
	_tmp21_ = g_new0 (BlockTexture*, NCOLORS + 1);
	self->priv->block_textures = (_vala_array_free (self->priv->block_textures, self->priv->block_textures_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->block_textures = _tmp21_;
	self->priv->block_textures_length1 = NCOLORS;
	self->priv->_block_textures_size_ = self->priv->block_textures_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gint _tmp24_;
				BlockTexture** _tmp25_;
				gint _tmp25__length1;
				BlockTexture** _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				gint _tmp28_;
				BlockTexture* _tmp29_;
				BlockTexture* _tmp30_;
				BlockTexture** _tmp31_;
				gint _tmp31__length1;
				gint _tmp32_;
				BlockTexture* _tmp33_;
				BlockTexture** _tmp34_;
				gint _tmp34__length1;
				gint _tmp35_;
				BlockTexture* _tmp36_;
				ClutterStage* _tmp37_;
				BlockTexture** _tmp38_;
				gint _tmp38__length1;
				gint _tmp39_;
				BlockTexture* _tmp40_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = self->priv->block_textures;
				_tmp25__length1 = self->priv->block_textures_length1;
				if (!(_tmp24_ < _tmp25__length1)) {
					break;
				}
				_tmp26_ = self->priv->block_textures;
				_tmp26__length1 = self->priv->block_textures_length1;
				_tmp27_ = i;
				_tmp28_ = i;
				_tmp29_ = block_texture_new (_tmp28_);
				g_object_ref_sink (_tmp29_);
				_g_object_unref0 (_tmp26_[_tmp27_]);
				_tmp26_[_tmp27_] = _tmp29_;
				_tmp30_ = _tmp26_[_tmp27_];
				_tmp31_ = self->priv->block_textures;
				_tmp31__length1 = self->priv->block_textures_length1;
				_tmp32_ = i;
				_tmp33_ = _tmp31_[_tmp32_];
				clutter_cairo_texture_set_surface_size ((ClutterCairoTexture*) _tmp33_, (guint) 1, (guint) 1);
				_tmp34_ = self->priv->block_textures;
				_tmp34__length1 = self->priv->block_textures_length1;
				_tmp35_ = i;
				_tmp36_ = _tmp34_[_tmp35_];
				clutter_actor_hide ((ClutterActor*) _tmp36_);
				_tmp37_ = stage;
				_tmp38_ = self->priv->block_textures;
				_tmp38__length1 = self->priv->block_textures_length1;
				_tmp39_ = i;
				_tmp40_ = _tmp38_[_tmp39_];
				clutter_actor_add_child ((ClutterActor*) _tmp37_, (ClutterActor*) _tmp40_);
			}
		}
	}
	_g_object_unref0 (stage);
	return self;
}


GameView*
game_view_new (void)
{
	return game_view_construct (TYPE_GAME_VIEW);
}


static void
game_view_play_sound (GameView* self,
                      const gchar* name)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->mute;
	if (!_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = g_strdup_printf ("%s.ogg", name);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_build_filename (SOUND_DIRECTORY, _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		ca_gtk_play_for_widget ((GtkWidget*) self, (guint32) 0, CA_PROP_MEDIA_NAME, name, CA_PROP_MEDIA_FILENAME, _tmp4_, NULL);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	}
}


static void
game_view_shape_added_cb (GameView* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Shape* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Game* _tmp10_;
	Game* _tmp11_;
	Shape* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	Game* _tmp16_;
	Game* _tmp17_;
	Shape* _tmp18_;
	GList* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->shape);
	self->priv->shape = _tmp0_;
	_tmp1_ = self->priv->playing_field;
	_tmp2_ = self->priv->shape;
	clutter_container_add ((ClutterContainer*) _tmp1_, _tmp2_, NULL);
	_tmp3_ = self->priv->shape;
	_tmp4_ = game_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->shape;
	_tmp7_ = _tmp6_->x;
	_tmp8_ = game_view_get_cell_size (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = game_view_get_game (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->shape;
	_tmp13_ = _tmp12_->y;
	_tmp14_ = game_view_get_cell_size (self);
	_tmp15_ = _tmp14_;
	clutter_actor_set_position (_tmp3_, (gfloat) (_tmp7_ * _tmp9_), (gfloat) (_tmp13_ * _tmp15_));
	game_view_update_shadow (self);
	_tmp16_ = game_view_get_game (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_->shape;
	_tmp19_ = _tmp18_->blocks;
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = _tmp19_;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			Block* _tmp20_;
			Block* block = NULL;
			_tmp20_ = _g_object_ref0 ((Block*) block_it->data);
			block = _tmp20_;
			{
				BlockActor* actor = NULL;
				Block* _tmp21_;
				BlockTexture** _tmp22_;
				gint _tmp22__length1;
				Block* _tmp23_;
				gint _tmp24_;
				BlockTexture* _tmp25_;
				BlockActor* _tmp26_;
				GHashTable* _tmp27_;
				Block* _tmp28_;
				Block* _tmp29_;
				BlockActor* _tmp30_;
				BlockActor* _tmp31_;
				ClutterActor* _tmp32_;
				BlockActor* _tmp33_;
				BlockActor* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				BlockActor* _tmp39_;
				Block* _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				Block* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				_tmp21_ = block;
				_tmp22_ = self->priv->block_textures;
				_tmp22__length1 = self->priv->block_textures_length1;
				_tmp23_ = block;
				_tmp24_ = _tmp23_->color;
				_tmp25_ = _tmp22_[_tmp24_];
				_tmp26_ = block_actor_new (_tmp21_, (ClutterActor*) _tmp25_);
				g_object_ref_sink (_tmp26_);
				actor = _tmp26_;
				_tmp27_ = self->priv->shape_blocks;
				_tmp28_ = block;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_tmp30_ = actor;
				_tmp31_ = _g_object_ref0 (_tmp30_);
				g_hash_table_insert (_tmp27_, _tmp29_, _tmp31_);
				_tmp32_ = self->priv->shape;
				_tmp33_ = actor;
				clutter_container_add ((ClutterContainer*) _tmp32_, (ClutterActor*) _tmp33_, NULL);
				_tmp34_ = actor;
				_tmp35_ = game_view_get_cell_size (self);
				_tmp36_ = _tmp35_;
				_tmp37_ = game_view_get_cell_size (self);
				_tmp38_ = _tmp37_;
				clutter_actor_set_size ((ClutterActor*) _tmp34_, (gfloat) _tmp36_, (gfloat) _tmp38_);
				_tmp39_ = actor;
				_tmp40_ = block;
				_tmp41_ = _tmp40_->x;
				_tmp42_ = game_view_get_cell_size (self);
				_tmp43_ = _tmp42_;
				_tmp44_ = block;
				_tmp45_ = _tmp44_->y;
				_tmp46_ = game_view_get_cell_size (self);
				_tmp47_ = _tmp46_;
				clutter_actor_set_position ((ClutterActor*) _tmp39_, (gfloat) (_tmp41_ * _tmp43_), (gfloat) (_tmp45_ * _tmp47_));
				_g_object_unref0 (actor);
				_g_object_unref0 (block);
			}
		}
	}
}


static void
game_view_shape_moved_cb (GameView* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Shape* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	ClutterClone* _tmp10_;
	ClutterActor* _tmp24_;
	g_return_if_fail (self != NULL);
	game_view_play_sound (self, "slide");
	_tmp0_ = self->priv->shape;
	clutter_actor_save_easing_state (_tmp0_);
	_tmp1_ = self->priv->shape;
	clutter_actor_set_easing_mode (_tmp1_, CLUTTER_EASE_IN_QUAD);
	_tmp2_ = self->priv->shape;
	clutter_actor_set_easing_duration (_tmp2_, (guint) 30);
	_tmp3_ = self->priv->shape;
	_tmp4_ = game_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->shape;
	_tmp7_ = _tmp6_->x;
	_tmp8_ = game_view_get_cell_size (self);
	_tmp9_ = _tmp8_;
	clutter_actor_set_x (_tmp3_, ((gfloat) _tmp7_) * _tmp9_);
	_tmp10_ = self->priv->shape_shadow;
	if (_tmp10_ != NULL) {
		ClutterClone* _tmp11_;
		Game* _tmp12_;
		Game* _tmp13_;
		Shape* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		Game* _tmp18_;
		Game* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp11_ = self->priv->shape_shadow;
		_tmp12_ = game_view_get_game (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->shape;
		_tmp15_ = _tmp14_->x;
		_tmp16_ = game_view_get_cell_size (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = game_view_get_game (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = game_get_shadow_y (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = game_view_get_cell_size (self);
		_tmp23_ = _tmp22_;
		clutter_actor_set_position ((ClutterActor*) _tmp11_, (gfloat) (_tmp15_ * _tmp17_), (gfloat) (_tmp21_ * _tmp23_));
	}
	_tmp24_ = self->priv->shape;
	clutter_actor_restore_easing_state (_tmp24_);
}


static void
game_view_update_shadow (GameView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_;
	Game* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp2_ = game_view_get_game (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		Game* _tmp4_;
		Game* _tmp5_;
		Shape* _tmp6_;
		_tmp4_ = game_view_get_game (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->shape;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = game_view_get_show_shadow (self);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ClutterClone* _tmp9_;
		ClutterClone* _tmp15_;
		Game* _tmp16_;
		Game* _tmp17_;
		Shape* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		Game* _tmp22_;
		Game* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp9_ = self->priv->shape_shadow;
		if (_tmp9_ == NULL) {
			ClutterActor* _tmp10_;
			ClutterClone* _tmp11_;
			ClutterClone* _tmp12_;
			ClutterActor* _tmp13_;
			ClutterClone* _tmp14_;
			_tmp10_ = self->priv->shape;
			_tmp11_ = (ClutterClone*) clutter_clone_new (_tmp10_);
			g_object_ref_sink (_tmp11_);
			_g_object_unref0 (self->priv->shape_shadow);
			self->priv->shape_shadow = _tmp11_;
			_tmp12_ = self->priv->shape_shadow;
			clutter_actor_set_opacity ((ClutterActor*) _tmp12_, (guint8) 32);
			_tmp13_ = self->priv->playing_field;
			_tmp14_ = self->priv->shape_shadow;
			clutter_container_add ((ClutterContainer*) _tmp13_, (ClutterActor*) _tmp14_, NULL);
		}
		_tmp15_ = self->priv->shape_shadow;
		_tmp16_ = game_view_get_game (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_->shape;
		_tmp19_ = _tmp18_->x;
		_tmp20_ = game_view_get_cell_size (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = game_view_get_game (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = game_get_shadow_y (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = game_view_get_cell_size (self);
		_tmp27_ = _tmp26_;
		clutter_actor_set_position ((ClutterActor*) _tmp15_, (gfloat) (_tmp19_ * _tmp21_), (gfloat) (_tmp25_ * _tmp27_));
	} else {
		ClutterClone* _tmp28_;
		_tmp28_ = self->priv->shape_shadow;
		if (_tmp28_ != NULL) {
			ClutterClone* _tmp29_;
			_tmp29_ = self->priv->shape_shadow;
			clutter_actor_destroy ((ClutterActor*) _tmp29_);
		}
		_g_object_unref0 (self->priv->shape_shadow);
		self->priv->shape_shadow = NULL;
	}
}


static void
game_view_shape_dropped_cb (GameView* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Shape* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	ClutterActor* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shape;
	clutter_actor_save_easing_state (_tmp0_);
	_tmp1_ = self->priv->shape;
	clutter_actor_set_easing_mode (_tmp1_, CLUTTER_EASE_IN_QUAD);
	_tmp2_ = self->priv->shape;
	clutter_actor_set_easing_duration (_tmp2_, (guint) 60);
	_tmp3_ = self->priv->shape;
	_tmp4_ = game_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->shape;
	_tmp7_ = _tmp6_->y;
	_tmp8_ = game_view_get_cell_size (self);
	_tmp9_ = _tmp8_;
	clutter_actor_set_y (_tmp3_, ((gfloat) _tmp7_) * _tmp9_);
	game_view_update_shadow (self);
	_tmp10_ = self->priv->shape;
	clutter_actor_restore_easing_state (_tmp10_);
}


static void
game_view_shape_rotated_cb (GameView* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	Shape* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	game_view_play_sound (self, "turn");
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->shape;
	_tmp3_ = _tmp2_->blocks;
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = _tmp3_;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			Block* _tmp4_;
			Block* block = NULL;
			_tmp4_ = _g_object_ref0 ((Block*) block_it->data);
			block = _tmp4_;
			{
				BlockActor* actor = NULL;
				GHashTable* _tmp5_;
				Block* _tmp6_;
				gconstpointer _tmp7_;
				BlockActor* _tmp8_;
				BlockActor* _tmp9_;
				Block* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				Block* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				_tmp5_ = self->priv->shape_blocks;
				_tmp6_ = block;
				_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
				_tmp8_ = _g_object_ref0 ((BlockActor*) _tmp7_);
				actor = _tmp8_;
				_tmp9_ = actor;
				_tmp10_ = block;
				_tmp11_ = _tmp10_->x;
				_tmp12_ = game_view_get_cell_size (self);
				_tmp13_ = _tmp12_;
				_tmp14_ = block;
				_tmp15_ = _tmp14_->y;
				_tmp16_ = game_view_get_cell_size (self);
				_tmp17_ = _tmp16_;
				clutter_actor_set_position ((ClutterActor*) _tmp9_, (gfloat) (_tmp11_ * _tmp13_), (gfloat) (_tmp15_ * _tmp17_));
				_g_object_unref0 (actor);
				_g_object_unref0 (block);
			}
		}
	}
	game_view_update_shadow (self);
}


static void
game_view_shape_landed_cb (GameView* self,
                           gint* lines,
                           int lines_length1,
                           GList* line_blocks)
{
	ClutterActor* _tmp0_;
	ClutterClone* _tmp1_;
	GHashTable* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Shape* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	switch (lines_length1) {
		default:
		{
			game_view_play_sound (self, "land");
			break;
		}
		case 1:
		{
			game_view_play_sound (self, "lines1");
			break;
		}
		case 2:
		{
			game_view_play_sound (self, "lines2");
			break;
		}
		case 3:
		case 4:
		{
			game_view_play_sound (self, "lines3");
			break;
		}
	}
	_tmp0_ = self->priv->shape;
	clutter_actor_destroy (_tmp0_);
	_g_object_unref0 (self->priv->shape);
	self->priv->shape = NULL;
	_tmp1_ = self->priv->shape_shadow;
	if (_tmp1_ != NULL) {
		ClutterClone* _tmp2_;
		_tmp2_ = self->priv->shape_shadow;
		clutter_actor_destroy ((ClutterActor*) _tmp2_);
	}
	_g_object_unref0 (self->priv->shape_shadow);
	self->priv->shape_shadow = NULL;
	_tmp3_ = self->priv->shape_blocks;
	g_hash_table_remove_all (_tmp3_);
	self->priv->n_lines_destroyed = lines_length1;
	_tmp4_ = game_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->shape;
	_tmp7_ = _tmp6_->blocks;
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = _tmp7_;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			Block* _tmp8_;
			Block* block = NULL;
			_tmp8_ = _g_object_ref0 ((Block*) block_it->data);
			block = _tmp8_;
			{
				BlockActor* actor = NULL;
				Block* _tmp9_;
				BlockTexture** _tmp10_;
				gint _tmp10__length1;
				Block* _tmp11_;
				gint _tmp12_;
				BlockTexture* _tmp13_;
				BlockActor* _tmp14_;
				ClutterActor* _tmp15_;
				BlockActor* _tmp16_;
				GHashTable* _tmp17_;
				Block* _tmp18_;
				Block* _tmp19_;
				BlockActor* _tmp20_;
				BlockActor* _tmp21_;
				BlockActor* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				BlockActor* _tmp27_;
				Block* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				Block* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				_tmp9_ = block;
				_tmp10_ = self->priv->block_textures;
				_tmp10__length1 = self->priv->block_textures_length1;
				_tmp11_ = block;
				_tmp12_ = _tmp11_->color;
				_tmp13_ = _tmp10_[_tmp12_];
				_tmp14_ = block_actor_new (_tmp9_, (ClutterActor*) _tmp13_);
				g_object_ref_sink (_tmp14_);
				actor = _tmp14_;
				_tmp15_ = self->priv->playing_field;
				_tmp16_ = actor;
				clutter_container_add ((ClutterContainer*) _tmp15_, (ClutterActor*) _tmp16_, NULL);
				_tmp17_ = self->priv->blocks;
				_tmp18_ = block;
				_tmp19_ = _g_object_ref0 (_tmp18_);
				_tmp20_ = actor;
				_tmp21_ = _g_object_ref0 (_tmp20_);
				g_hash_table_insert (_tmp17_, _tmp19_, _tmp21_);
				_tmp22_ = actor;
				_tmp23_ = game_view_get_cell_size (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = game_view_get_cell_size (self);
				_tmp26_ = _tmp25_;
				clutter_actor_set_size ((ClutterActor*) _tmp22_, (gfloat) _tmp24_, (gfloat) _tmp26_);
				_tmp27_ = actor;
				_tmp28_ = block;
				_tmp29_ = _tmp28_->x;
				_tmp30_ = game_view_get_cell_size (self);
				_tmp31_ = _tmp30_;
				_tmp32_ = block;
				_tmp33_ = _tmp32_->y;
				_tmp34_ = self->priv->n_lines_destroyed;
				_tmp35_ = game_view_get_cell_size (self);
				_tmp36_ = _tmp35_;
				clutter_actor_set_position ((ClutterActor*) _tmp27_, (gfloat) (_tmp29_ * _tmp31_), (gfloat) ((_tmp33_ - _tmp34_) * _tmp36_));
				_g_object_unref0 (actor);
				_g_object_unref0 (block);
			}
		}
	}
	{
		GList* block_collection = NULL;
		GList* block_it = NULL;
		block_collection = line_blocks;
		for (block_it = block_collection; block_it != NULL; block_it = block_it->next) {
			Block* _tmp37_;
			Block* block = NULL;
			_tmp37_ = _g_object_ref0 ((Block*) block_it->data);
			block = _tmp37_;
			{
				BlockActor* actor = NULL;
				GHashTable* _tmp38_;
				Block* _tmp39_;
				gconstpointer _tmp40_;
				BlockActor* _tmp41_;
				BlockActor* _tmp42_;
				GHashTable* _tmp43_;
				Block* _tmp44_;
				_tmp38_ = self->priv->blocks;
				_tmp39_ = block;
				_tmp40_ = g_hash_table_lookup (_tmp38_, _tmp39_);
				_tmp41_ = _g_object_ref0 ((BlockActor*) _tmp40_);
				actor = _tmp41_;
				_tmp42_ = actor;
				block_actor_explode (_tmp42_);
				_tmp43_ = self->priv->blocks;
				_tmp44_ = block;
				g_hash_table_remove (_tmp43_, _tmp44_);
				_g_object_unref0 (actor);
				_g_object_unref0 (block);
			}
		}
	}
	if (lines_length1 > 0) {
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp45_ = FALSE;
				_tmp45_ = TRUE;
				while (TRUE) {
					gint _tmp47_;
					Game* _tmp48_;
					Game* _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					if (!_tmp45_) {
						gint _tmp46_;
						_tmp46_ = x;
						x = _tmp46_ + 1;
					}
					_tmp45_ = FALSE;
					_tmp47_ = x;
					_tmp48_ = game_view_get_game (self);
					_tmp49_ = _tmp48_;
					_tmp50_ = game_get_width (_tmp49_);
					_tmp51_ = _tmp50_;
					if (!(_tmp47_ < _tmp51_)) {
						break;
					}
					{
						gint y = 0;
						y = 0;
						{
							gboolean _tmp52_ = FALSE;
							_tmp52_ = TRUE;
							while (TRUE) {
								gint _tmp54_;
								Game* _tmp55_;
								Game* _tmp56_;
								gint _tmp57_;
								gint _tmp58_;
								Block* block = NULL;
								Game* _tmp59_;
								Game* _tmp60_;
								Block** _tmp61_;
								gint _tmp61__length1;
								gint _tmp61__length2;
								gint _tmp62_;
								gint _tmp63_;
								Block* _tmp64_;
								Block* _tmp65_;
								Block* _tmp66_;
								BlockActor* actor = NULL;
								GHashTable* _tmp67_;
								Block* _tmp68_;
								gconstpointer _tmp69_;
								BlockActor* _tmp70_;
								BlockActor* _tmp71_;
								BlockActor* _tmp72_;
								BlockActor* _tmp73_;
								gint _tmp74_;
								BlockActor* _tmp75_;
								Block* _tmp76_;
								gint _tmp77_;
								gint _tmp78_;
								gint _tmp79_;
								Block* _tmp80_;
								gint _tmp81_;
								gint _tmp82_;
								gint _tmp83_;
								BlockActor* _tmp84_;
								if (!_tmp52_) {
									gint _tmp53_;
									_tmp53_ = y;
									y = _tmp53_ + 1;
								}
								_tmp52_ = FALSE;
								_tmp54_ = y;
								_tmp55_ = game_view_get_game (self);
								_tmp56_ = _tmp55_;
								_tmp57_ = game_get_height (_tmp56_);
								_tmp58_ = _tmp57_;
								if (!(_tmp54_ < _tmp58_)) {
									break;
								}
								_tmp59_ = game_view_get_game (self);
								_tmp60_ = _tmp59_;
								_tmp61_ = _tmp60_->blocks;
								_tmp61__length1 = _tmp60_->blocks_length1;
								_tmp61__length2 = _tmp60_->blocks_length2;
								_tmp62_ = x;
								_tmp63_ = y;
								_tmp64_ = _tmp61_[(_tmp62_ * _tmp61__length2) + _tmp63_];
								_tmp65_ = _g_object_ref0 (_tmp64_);
								block = _tmp65_;
								_tmp66_ = block;
								if (_tmp66_ == NULL) {
									_g_object_unref0 (block);
									continue;
								}
								_tmp67_ = self->priv->blocks;
								_tmp68_ = block;
								_tmp69_ = g_hash_table_lookup (_tmp67_, _tmp68_);
								_tmp70_ = _g_object_ref0 ((BlockActor*) _tmp69_);
								actor = _tmp70_;
								_tmp71_ = actor;
								clutter_actor_save_easing_state ((ClutterActor*) _tmp71_);
								_tmp72_ = actor;
								clutter_actor_set_easing_mode ((ClutterActor*) _tmp72_, CLUTTER_EASE_OUT_BOUNCE);
								_tmp73_ = actor;
								_tmp74_ = self->priv->n_lines_destroyed;
								clutter_actor_set_easing_duration ((ClutterActor*) _tmp73_, (guint) ((gint) (300 * sqrt ((gdouble) _tmp74_))));
								_tmp75_ = actor;
								_tmp76_ = block;
								_tmp77_ = _tmp76_->x;
								_tmp78_ = game_view_get_cell_size (self);
								_tmp79_ = _tmp78_;
								_tmp80_ = block;
								_tmp81_ = _tmp80_->y;
								_tmp82_ = game_view_get_cell_size (self);
								_tmp83_ = _tmp82_;
								clutter_actor_set_position ((ClutterActor*) _tmp75_, ((gfloat) _tmp77_) * _tmp79_, ((gfloat) _tmp81_) * _tmp83_);
								_tmp84_ = actor;
								clutter_actor_restore_easing_state ((ClutterActor*) _tmp84_);
								_g_object_unref0 (actor);
								_g_object_unref0 (block);
							}
						}
					}
				}
			}
		}
	}
}


static void
game_view_size_allocate_cb (GameView* self,
                            GtkWidget* widget,
                            GtkAllocation* allocation)
{
	Game* _tmp0_;
	Game* _tmp1_;
	BlockTexture** _tmp2_;
	gint _tmp2__length1;
	GHashTableIter iter = {0};
	GHashTable* _tmp9_;
	GHashTableIter shape_iter = {0};
	GHashTable* _tmp29_;
	ClutterActor* _tmp49_;
	TextOverlay* _tmp63_;
	TextOverlay* _tmp64_;
	ClutterActor* _tmp65_;
	TextOverlay* _tmp66_;
	ClutterActor* _tmp67_;
	Game* _tmp68_;
	Game* _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	Game* _tmp74_;
	Game* _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	ClutterActor* _tmp80_;
	ClutterActor* _tmp81_;
	ClutterActor* _tmp82_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->block_textures;
	_tmp2__length1 = self->priv->block_textures_length1;
	{
		BlockTexture** texture_collection = NULL;
		gint texture_collection_length1 = 0;
		gint _texture_collection_size_ = 0;
		gint texture_it = 0;
		texture_collection = _tmp2_;
		texture_collection_length1 = _tmp2__length1;
		for (texture_it = 0; texture_it < _tmp2__length1; texture_it = texture_it + 1) {
			BlockTexture* _tmp3_;
			BlockTexture* texture = NULL;
			_tmp3_ = _g_object_ref0 (texture_collection[texture_it]);
			texture = _tmp3_;
			{
				BlockTexture* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp4_ = texture;
				_tmp5_ = game_view_get_cell_size (self);
				_tmp6_ = _tmp5_;
				_tmp7_ = game_view_get_cell_size (self);
				_tmp8_ = _tmp7_;
				clutter_actor_set_size ((ClutterActor*) _tmp4_, (gfloat) _tmp6_, (gfloat) _tmp8_);
				_g_object_unref0 (texture);
			}
		}
	}
	_tmp9_ = self->priv->blocks;
	g_hash_table_iter_init (&iter, _tmp9_);
	while (TRUE) {
		Block* block = NULL;
		BlockActor* actor = NULL;
		gconstpointer _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		gboolean _tmp12_;
		Block* _tmp13_;
		BlockActor* _tmp14_;
		BlockActor* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		BlockActor* _tmp20_;
		Block* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		Block* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp12_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp10_), (gpointer*) (&_tmp11_));
		_g_object_unref0 (block);
		_tmp13_ = _g_object_ref0 (_tmp10_);
		block = _tmp13_;
		_g_object_unref0 (actor);
		_tmp14_ = _g_object_ref0 (_tmp11_);
		actor = _tmp14_;
		if (!_tmp12_) {
			_g_object_unref0 (actor);
			_g_object_unref0 (block);
			break;
		}
		_tmp15_ = actor;
		_tmp16_ = game_view_get_cell_size (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = game_view_get_cell_size (self);
		_tmp19_ = _tmp18_;
		clutter_actor_set_size ((ClutterActor*) _tmp15_, (gfloat) _tmp17_, (gfloat) _tmp19_);
		_tmp20_ = actor;
		_tmp21_ = block;
		_tmp22_ = _tmp21_->x;
		_tmp23_ = game_view_get_cell_size (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = block;
		_tmp26_ = _tmp25_->y;
		_tmp27_ = game_view_get_cell_size (self);
		_tmp28_ = _tmp27_;
		clutter_actor_set_position ((ClutterActor*) _tmp20_, (gfloat) (_tmp22_ * _tmp24_), (gfloat) (_tmp26_ * _tmp28_));
		_g_object_unref0 (actor);
		_g_object_unref0 (block);
	}
	_tmp29_ = self->priv->shape_blocks;
	g_hash_table_iter_init (&shape_iter, _tmp29_);
	while (TRUE) {
		Block* block = NULL;
		BlockActor* actor = NULL;
		gconstpointer _tmp30_ = NULL;
		gconstpointer _tmp31_ = NULL;
		gboolean _tmp32_;
		Block* _tmp33_;
		BlockActor* _tmp34_;
		BlockActor* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		BlockActor* _tmp40_;
		Block* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		Block* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		_tmp32_ = g_hash_table_iter_next (&shape_iter, (gpointer*) (&_tmp30_), (gpointer*) (&_tmp31_));
		_g_object_unref0 (block);
		_tmp33_ = _g_object_ref0 (_tmp30_);
		block = _tmp33_;
		_g_object_unref0 (actor);
		_tmp34_ = _g_object_ref0 (_tmp31_);
		actor = _tmp34_;
		if (!_tmp32_) {
			_g_object_unref0 (actor);
			_g_object_unref0 (block);
			break;
		}
		_tmp35_ = actor;
		_tmp36_ = game_view_get_cell_size (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = game_view_get_cell_size (self);
		_tmp39_ = _tmp38_;
		clutter_actor_set_size ((ClutterActor*) _tmp35_, (gfloat) _tmp37_, (gfloat) _tmp39_);
		_tmp40_ = actor;
		_tmp41_ = block;
		_tmp42_ = _tmp41_->x;
		_tmp43_ = game_view_get_cell_size (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = block;
		_tmp46_ = _tmp45_->y;
		_tmp47_ = game_view_get_cell_size (self);
		_tmp48_ = _tmp47_;
		clutter_actor_set_position ((ClutterActor*) _tmp40_, (gfloat) (_tmp42_ * _tmp44_), (gfloat) (_tmp46_ * _tmp48_));
		_g_object_unref0 (actor);
		_g_object_unref0 (block);
	}
	_tmp49_ = self->priv->shape;
	if (_tmp49_ != NULL) {
		ClutterActor* _tmp50_;
		Game* _tmp51_;
		Game* _tmp52_;
		Shape* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		Game* _tmp57_;
		Game* _tmp58_;
		Shape* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		_tmp50_ = self->priv->shape;
		_tmp51_ = game_view_get_game (self);
		_tmp52_ = _tmp51_;
		_tmp53_ = _tmp52_->shape;
		_tmp54_ = _tmp53_->x;
		_tmp55_ = game_view_get_cell_size (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = game_view_get_game (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = _tmp58_->shape;
		_tmp60_ = _tmp59_->y;
		_tmp61_ = game_view_get_cell_size (self);
		_tmp62_ = _tmp61_;
		clutter_actor_set_position (_tmp50_, (gfloat) (_tmp54_ * _tmp56_), (gfloat) (_tmp60_ * _tmp62_));
	}
	game_view_update_shadow (self);
	_tmp63_ = self->priv->text_overlay;
	clutter_actor_set_size ((ClutterActor*) _tmp63_, (gfloat) gtk_widget_get_allocated_width ((GtkWidget*) self), (gfloat) gtk_widget_get_allocated_height ((GtkWidget*) self));
	_tmp64_ = self->priv->text_overlay;
	_tmp65_ = clutter_actor_get_parent ((ClutterActor*) _tmp64_);
	_tmp66_ = self->priv->text_overlay;
	clutter_actor_set_child_above_sibling (_tmp65_, (ClutterActor*) _tmp66_, NULL);
	_tmp67_ = self->priv->playing_field;
	_tmp68_ = game_view_get_game (self);
	_tmp69_ = _tmp68_;
	_tmp70_ = game_get_width (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = game_view_get_cell_size (self);
	_tmp73_ = _tmp72_;
	_tmp74_ = game_view_get_game (self);
	_tmp75_ = _tmp74_;
	_tmp76_ = game_get_height (_tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = game_view_get_cell_size (self);
	_tmp79_ = _tmp78_;
	clutter_actor_set_size (_tmp67_, (gfloat) (_tmp71_ * _tmp73_), (gfloat) (_tmp77_ * _tmp79_));
	_tmp80_ = self->priv->playing_field;
	_tmp81_ = self->priv->playing_field;
	_tmp82_ = self->priv->playing_field;
	clutter_actor_set_position (_tmp80_, (gtk_widget_get_allocated_width ((GtkWidget*) self) - clutter_actor_get_width (_tmp81_)) * 0.5f, gtk_widget_get_allocated_height ((GtkWidget*) self) - clutter_actor_get_height (_tmp82_));
}


static void
game_view_pause_changed_cb (GameView* self)
{
	g_return_if_fail (self != NULL);
	game_view_update_message (self);
}


static void
game_view_game_complete_cb (GameView* self)
{
	g_return_if_fail (self != NULL);
	game_view_play_sound (self, "gameover");
	game_view_update_message (self);
}


static void
game_view_update_message (GameView* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		TextOverlay* _tmp4_;
		_tmp4_ = self->priv->text_overlay;
		text_overlay_set_text (_tmp4_, _ ("Paused"));
	} else {
		Game* _tmp5_;
		Game* _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = game_view_get_game (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->game_over;
		if (_tmp7_) {
			TextOverlay* _tmp8_;
			_tmp8_ = self->priv->text_overlay;
			text_overlay_set_text (_tmp8_, _ ("Game Over"));
		} else {
			TextOverlay* _tmp9_;
			_tmp9_ = self->priv->text_overlay;
			text_overlay_set_text (_tmp9_, NULL);
		}
	}
}


Game*
game_view_get_game (GameView* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static void
_game_view_shape_added_cb_game_shape_added (Game* _sender,
                                            gpointer self)
{
	game_view_shape_added_cb ((GameView*) self);
}


static void
_game_view_shape_moved_cb_game_shape_moved (Game* _sender,
                                            gpointer self)
{
	game_view_shape_moved_cb ((GameView*) self);
}


static void
_game_view_shape_dropped_cb_game_shape_dropped (Game* _sender,
                                                gpointer self)
{
	game_view_shape_dropped_cb ((GameView*) self);
}


static void
_game_view_shape_rotated_cb_game_shape_rotated (Game* _sender,
                                                gpointer self)
{
	game_view_shape_rotated_cb ((GameView*) self);
}


static void
_game_view_shape_landed_cb_game_shape_landed (Game* _sender,
                                              gint* lines,
                                              int lines_length1,
                                              GList* line_blocks,
                                              gpointer self)
{
	game_view_shape_landed_cb ((GameView*) self, lines, lines_length1, line_blocks);
}


static void
_game_view_pause_changed_cb_game_pause_changed (Game* _sender,
                                                gpointer self)
{
	game_view_pause_changed_cb ((GameView*) self);
}


static void
_game_view_game_complete_cb_game_complete (Game* _sender,
                                           gpointer self)
{
	game_view_game_complete_cb ((GameView*) self);
}


void
game_view_set_game (GameView* self,
                    Game* value)
{
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	Game* _tmp7_;
	Game* _tmp8_;
	Game* _tmp9_;
	GHashTable* _tmp10_;
	ClutterActor* _tmp11_;
	Game* _tmp12_;
	Game* _tmp13_;
	Shape* _tmp14_;
	Game* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	Game* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp2_;
	_tmp3_ = self->priv->_game;
	g_signal_connect_object (_tmp3_, "shape-added", (GCallback) _game_view_shape_added_cb_game_shape_added, self, 0);
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (_tmp4_, "shape-moved", (GCallback) _game_view_shape_moved_cb_game_shape_moved, self, 0);
	_tmp5_ = self->priv->_game;
	g_signal_connect_object (_tmp5_, "shape-dropped", (GCallback) _game_view_shape_dropped_cb_game_shape_dropped, self, 0);
	_tmp6_ = self->priv->_game;
	g_signal_connect_object (_tmp6_, "shape-rotated", (GCallback) _game_view_shape_rotated_cb_game_shape_rotated, self, 0);
	_tmp7_ = self->priv->_game;
	g_signal_connect_object (_tmp7_, "shape-landed", (GCallback) _game_view_shape_landed_cb_game_shape_landed, self, 0);
	_tmp8_ = self->priv->_game;
	g_signal_connect_object (_tmp8_, "pause-changed", (GCallback) _game_view_pause_changed_cb_game_pause_changed, self, 0);
	_tmp9_ = self->priv->_game;
	g_signal_connect_object (_tmp9_, "complete", (GCallback) _game_view_game_complete_cb_game_complete, self, 0);
	_tmp10_ = self->priv->blocks;
	g_hash_table_remove_all (_tmp10_);
	_tmp11_ = self->priv->playing_field;
	clutter_actor_remove_all_children (_tmp11_);
	_g_object_unref0 (self->priv->shape_shadow);
	self->priv->shape_shadow = NULL;
	_tmp12_ = game_view_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_->shape;
	if (_tmp14_ != NULL) {
		game_view_shape_added_cb (self);
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_;
				Game* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = x;
					x = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = x;
				_tmp18_ = self->priv->_game;
				_tmp19_ = game_get_width (_tmp18_);
				_tmp20_ = _tmp19_;
				if (!(_tmp17_ < _tmp20_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp21_ = FALSE;
						_tmp21_ = TRUE;
						while (TRUE) {
							gint _tmp23_;
							Game* _tmp24_;
							gint _tmp25_;
							gint _tmp26_;
							Block* block = NULL;
							Game* _tmp27_;
							Block** _tmp28_;
							gint _tmp28__length1;
							gint _tmp28__length2;
							gint _tmp29_;
							gint _tmp30_;
							Block* _tmp31_;
							Block* _tmp32_;
							Block* _tmp33_;
							if (!_tmp21_) {
								gint _tmp22_;
								_tmp22_ = y;
								y = _tmp22_ + 1;
							}
							_tmp21_ = FALSE;
							_tmp23_ = y;
							_tmp24_ = self->priv->_game;
							_tmp25_ = game_get_height (_tmp24_);
							_tmp26_ = _tmp25_;
							if (!(_tmp23_ < _tmp26_)) {
								break;
							}
							_tmp27_ = self->priv->_game;
							_tmp28_ = _tmp27_->blocks;
							_tmp28__length1 = _tmp27_->blocks_length1;
							_tmp28__length2 = _tmp27_->blocks_length2;
							_tmp29_ = x;
							_tmp30_ = y;
							_tmp31_ = _tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_];
							_tmp32_ = _g_object_ref0 (_tmp31_);
							block = _tmp32_;
							_tmp33_ = block;
							if (_tmp33_ != NULL) {
								BlockActor* actor = NULL;
								Block* _tmp34_;
								BlockTexture** _tmp35_;
								gint _tmp35__length1;
								Block* _tmp36_;
								gint _tmp37_;
								BlockTexture* _tmp38_;
								BlockActor* _tmp39_;
								GHashTable* _tmp40_;
								Block* _tmp41_;
								Block* _tmp42_;
								BlockActor* _tmp43_;
								BlockActor* _tmp44_;
								BlockActor* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gint _tmp48_;
								gint _tmp49_;
								BlockActor* _tmp50_;
								Block* _tmp51_;
								gint _tmp52_;
								gint _tmp53_;
								gint _tmp54_;
								Block* _tmp55_;
								gint _tmp56_;
								gint _tmp57_;
								gint _tmp58_;
								ClutterActor* _tmp59_;
								BlockActor* _tmp60_;
								_tmp34_ = block;
								_tmp35_ = self->priv->block_textures;
								_tmp35__length1 = self->priv->block_textures_length1;
								_tmp36_ = block;
								_tmp37_ = _tmp36_->color;
								_tmp38_ = _tmp35_[_tmp37_];
								_tmp39_ = block_actor_new (_tmp34_, (ClutterActor*) _tmp38_);
								g_object_ref_sink (_tmp39_);
								actor = _tmp39_;
								_tmp40_ = self->priv->blocks;
								_tmp41_ = block;
								_tmp42_ = _g_object_ref0 (_tmp41_);
								_tmp43_ = actor;
								_tmp44_ = _g_object_ref0 (_tmp43_);
								g_hash_table_insert (_tmp40_, _tmp42_, _tmp44_);
								_tmp45_ = actor;
								_tmp46_ = game_view_get_cell_size (self);
								_tmp47_ = _tmp46_;
								_tmp48_ = game_view_get_cell_size (self);
								_tmp49_ = _tmp48_;
								clutter_actor_set_size ((ClutterActor*) _tmp45_, (gfloat) _tmp47_, (gfloat) _tmp49_);
								_tmp50_ = actor;
								_tmp51_ = block;
								_tmp52_ = _tmp51_->x;
								_tmp53_ = game_view_get_cell_size (self);
								_tmp54_ = _tmp53_;
								_tmp55_ = block;
								_tmp56_ = _tmp55_->y;
								_tmp57_ = game_view_get_cell_size (self);
								_tmp58_ = _tmp57_;
								clutter_actor_set_position ((ClutterActor*) _tmp50_, (gfloat) (_tmp52_ * _tmp54_), (gfloat) (_tmp56_ * _tmp58_));
								_tmp59_ = self->priv->playing_field;
								_tmp60_ = actor;
								clutter_container_add ((ClutterContainer*) _tmp59_, (ClutterActor*) _tmp60_, NULL);
								_g_object_unref0 (actor);
							}
							_g_object_unref0 (block);
						}
					}
				}
			}
		}
	}
	_tmp61_ = self->priv->_game;
	_tmp62_ = game_get_width (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = self->priv->_game;
	_tmp65_ = game_get_height (_tmp64_);
	_tmp66_ = _tmp65_;
	gtk_widget_set_size_request ((GtkWidget*) self, (_tmp63_ * 190) / _tmp66_, 190);
	game_view_update_message (self);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_GAME_PROPERTY]);
}


void
game_view_set_theme (GameView* self,
                     const gchar* value)
{
	BlockTexture** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->block_textures;
	_tmp0__length1 = self->priv->block_textures_length1;
	{
		BlockTexture** texture_collection = NULL;
		gint texture_collection_length1 = 0;
		gint _texture_collection_size_ = 0;
		gint texture_it = 0;
		texture_collection = _tmp0_;
		texture_collection_length1 = _tmp0__length1;
		for (texture_it = 0; texture_it < _tmp0__length1; texture_it = texture_it + 1) {
			BlockTexture* _tmp1_;
			BlockTexture* texture = NULL;
			_tmp1_ = _g_object_ref0 (texture_collection[texture_it]);
			texture = _tmp1_;
			{
				BlockTexture* _tmp2_;
				_tmp2_ = texture;
				block_texture_set_theme (_tmp2_, value);
				_g_object_unref0 (texture);
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_THEME_PROPERTY]);
}


gboolean
game_view_get_show_shadow (GameView* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_shadow;
	result = _tmp0_;
	return result;
}


void
game_view_set_show_shadow (GameView* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_shadow = value;
	game_view_update_shadow (self);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_SHOW_SHADOW_PROPERTY]);
}


static gint
game_view_get_cell_size (GameView* self)
{
	gint result;
	Game* _tmp0_;
	Game* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		Game* _tmp2_;
		Game* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		Game* _tmp6_;
		Game* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp2_ = game_view_get_game (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = game_get_width (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = game_view_get_game (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = game_get_height (_tmp7_);
		_tmp9_ = _tmp8_;
		result = MIN (gtk_widget_get_allocated_width ((GtkWidget*) self) / _tmp5_, gtk_widget_get_allocated_height ((GtkWidget*) self) / _tmp9_);
		return result;
	} else {
		result = 0;
		return result;
	}
}


static void
game_view_class_init (GameViewClass * klass)
{
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME_PROPERTY, game_view_properties[GAME_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME_PROPERTY, game_view_properties[GAME_VIEW_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SHOW_SHADOW_PROPERTY, game_view_properties[GAME_VIEW_SHOW_SHADOW_PROPERTY] = g_param_spec_boolean ("show-shadow", "show-shadow", "show-shadow", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
game_view_instance_init (GameView * self)
{
	self->priv = game_view_get_instance_private (self);
	self->priv->_game = NULL;
	self->priv->shape = NULL;
	self->priv->shape_shadow = NULL;
	self->priv->_show_shadow = FALSE;
}


static void
game_view_finalize (GObject * obj)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->_game);
	_g_object_unref0 (self->priv->playing_field);
	_g_object_unref0 (self->priv->shape);
	_g_object_unref0 (self->priv->shape_shadow);
	_g_object_unref0 (self->priv->text_overlay);
	self->priv->block_textures = (_vala_array_free (self->priv->block_textures, self->priv->block_textures_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->blocks);
	_g_hash_table_unref0 (self->priv->shape_blocks);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType
game_view_get_type (void)
{
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (gtk_clutter_embed_get_type (), "GameView", &g_define_type_info, 0);
		GameView_private_offset = g_type_add_instance_private (game_view_type_id, sizeof (GameViewPrivate));
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void
_vala_game_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME_PROPERTY:
		g_value_set_object (value, game_view_get_game (self));
		break;
		case GAME_VIEW_SHOW_SHADOW_PROPERTY:
		g_value_set_boolean (value, game_view_get_show_shadow (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_game_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME_PROPERTY:
		game_view_set_game (self, g_value_get_object (value));
		break;
		case GAME_VIEW_THEME_PROPERTY:
		game_view_set_theme (self, g_value_get_string (value));
		break;
		case GAME_VIEW_SHOW_SHADOW_PROPERTY:
		game_view_set_show_shadow (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


BlockActor*
block_actor_construct (GType object_type,
                       Block* block,
                       ClutterActor* texture)
{
	BlockActor * self = NULL;
	Block* _tmp0_;
	g_return_val_if_fail (block != NULL, NULL);
	g_return_val_if_fail (texture != NULL, NULL);
	self = (BlockActor*) g_object_new (object_type, "source", texture, NULL);
	_tmp0_ = _g_object_ref0 (block);
	_g_object_unref0 (self->block);
	self->block = _tmp0_;
	return self;
}


BlockActor*
block_actor_new (Block* block,
                 ClutterActor* texture)
{
	return block_actor_construct (TYPE_BLOCK_ACTOR, block, texture);
}


static void
_block_actor_explode_complete_cb_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                      gpointer self)
{
	block_actor_explode_complete_cb ((BlockActor*) self);
}


void
block_actor_explode (BlockActor* self)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
	clutter_actor_set_child_above_sibling (_tmp0_, (ClutterActor*) self, NULL);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUINT);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 720);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_set_scale ((ClutterActor*) self, (gdouble) 2.f, (gdouble) 2.f);
	g_signal_connect_object ((ClutterActor*) self, "transitions-completed", (GCallback) _block_actor_explode_complete_cb_clutter_actor_transitions_completed, self, 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


static void
block_actor_explode_complete_cb (BlockActor* self)
{
	g_return_if_fail (self != NULL);
	clutter_actor_destroy ((ClutterActor*) self);
}


static void
block_actor_class_init (BlockActorClass * klass)
{
	block_actor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = block_actor_finalize;
}


static void
block_actor_instance_init (BlockActor * self)
{
}


static void
block_actor_finalize (GObject * obj)
{
	BlockActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLOCK_ACTOR, BlockActor);
	_g_object_unref0 (self->block);
	G_OBJECT_CLASS (block_actor_parent_class)->finalize (obj);
}


GType
block_actor_get_type (void)
{
	static volatile gsize block_actor_type_id__volatile = 0;
	if (g_once_init_enter (&block_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlockActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlockActor), 0, (GInstanceInitFunc) block_actor_instance_init, NULL };
		GType block_actor_type_id;
		block_actor_type_id = g_type_register_static (clutter_clone_get_type (), "BlockActor", &g_define_type_info, 0);
		g_once_init_leave (&block_actor_type_id__volatile, block_actor_type_id);
	}
	return block_actor_type_id__volatile;
}


static inline gpointer
text_overlay_get_instance_private (TextOverlay* self)
{
	return G_STRUCT_MEMBER_P (self, TextOverlay_private_offset);
}


TextOverlay*
text_overlay_construct (GType object_type)
{
	TextOverlay * self = NULL;
	self = (TextOverlay*) g_object_new (object_type, NULL);
	clutter_cairo_texture_set_auto_resize ((ClutterCairoTexture*) self, TRUE);
	return self;
}


TextOverlay*
text_overlay_new (void)
{
	return text_overlay_construct (TYPE_TEXT_OVERLAY);
}


static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}


static gboolean
text_overlay_real_draw (ClutterCairoTexture* base,
                        cairo_t* cr)
{
	TextOverlay * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint w = 0U;
	guint h = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_;
	guint _tmp5_;
	PangoFontDescription* desc = NULL;
	PangoFontDescription* _tmp6_;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp7_;
	PangoLayout* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	PangoLayout* dummy_layout = NULL;
	PangoLayout* _tmp11_;
	PangoLayout* _tmp12_;
	PangoLayout* _tmp13_;
	PangoFontDescription* _tmp14_;
	gint lw = 0;
	gint lh = 0;
	PangoLayout* _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	PangoFontDescription* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	guint _tmp21_;
	PangoLayout* _tmp22_;
	PangoFontDescription* _tmp23_;
	PangoLayout* _tmp24_;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_;
	gint _tmp28_;
	PangoLayout* _tmp29_;
	gfloat _tmp30_;
	gfloat _tmp31_;
	self = (TextOverlay*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	clutter_cairo_texture_clear ((ClutterCairoTexture*) self);
	_tmp0_ = text_overlay_get_text (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	clutter_cairo_texture_get_surface_size ((ClutterCairoTexture*) self, &_tmp2_, &_tmp3_);
	w = _tmp2_;
	h = _tmp3_;
	_tmp4_ = w;
	_tmp5_ = h;
	cairo_translate (cr, (gdouble) (_tmp4_ / 2), (gdouble) (_tmp5_ / 2));
	_tmp6_ = pango_font_description_from_string ("Sans");
	desc = _tmp6_;
	_tmp7_ = pango_cairo_create_layout (cr);
	layout = _tmp7_;
	_tmp8_ = layout;
	_tmp9_ = text_overlay_get_text (self);
	_tmp10_ = _tmp9_;
	pango_layout_set_text (_tmp8_, _tmp10_, -1);
	_tmp11_ = layout;
	_tmp12_ = pango_layout_copy (_tmp11_);
	dummy_layout = _tmp12_;
	_tmp13_ = dummy_layout;
	_tmp14_ = desc;
	pango_layout_set_font_description (_tmp13_, _tmp14_);
	_tmp15_ = dummy_layout;
	pango_layout_get_size (_tmp15_, &_tmp16_, &_tmp17_);
	lw = _tmp16_;
	lh = _tmp17_;
	_tmp18_ = desc;
	_tmp19_ = lh;
	_tmp20_ = lw;
	_tmp21_ = w;
	pango_font_description_set_absolute_size (_tmp18_, (((((gfloat) _tmp19_) / _tmp20_) * PANGO_SCALE) * _tmp21_) * 0.7);
	_tmp22_ = layout;
	_tmp23_ = desc;
	pango_layout_set_font_description (_tmp22_, _tmp23_);
	_tmp24_ = layout;
	pango_layout_get_size (_tmp24_, &_tmp25_, &_tmp26_);
	lw = _tmp25_;
	lh = _tmp26_;
	_tmp27_ = lw;
	_tmp28_ = lh;
	cairo_move_to (cr, (-(((gdouble) _tmp27_) / PANGO_SCALE)) / 2, (-(((gdouble) _tmp28_) / PANGO_SCALE)) / 2);
	_tmp29_ = layout;
	pango_cairo_layout_path (cr, _tmp29_);
	cairo_set_source_rgb (cr, 0.333333333333, 0.341176470588, 0.32549019607);
	_tmp30_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp31_ = _tmp30_;
	cairo_set_line_width (cr, _tmp31_ / 100.0);
	cairo_stroke_preserve (cr);
	cairo_set_source_rgb (cr, 1.0, 1.0, 1.0);
	cairo_fill (cr);
	result = FALSE;
	_g_object_unref0 (dummy_layout);
	_g_object_unref0 (layout);
	__vala_PangoFontDescription_free0 (desc);
	return result;
}


const gchar*
text_overlay_get_text (TextOverlay* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}


void
text_overlay_set_text (TextOverlay* self,
                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp0_;
	clutter_cairo_texture_invalidate ((ClutterCairoTexture*) self);
	g_object_notify_by_pspec ((GObject *) self, text_overlay_properties[TEXT_OVERLAY_TEXT_PROPERTY]);
}


static void
text_overlay_class_init (TextOverlayClass * klass)
{
	text_overlay_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TextOverlay_private_offset);
	((ClutterCairoTextureClass *) klass)->draw = (gboolean (*) (ClutterCairoTexture *, cairo_t*)) text_overlay_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_text_overlay_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_text_overlay_set_property;
	G_OBJECT_CLASS (klass)->finalize = text_overlay_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEXT_OVERLAY_TEXT_PROPERTY, text_overlay_properties[TEXT_OVERLAY_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
text_overlay_instance_init (TextOverlay * self)
{
	self->priv = text_overlay_get_instance_private (self);
	self->priv->_text = NULL;
}


static void
text_overlay_finalize (GObject * obj)
{
	TextOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_OVERLAY, TextOverlay);
	_g_free0 (self->priv->_text);
	G_OBJECT_CLASS (text_overlay_parent_class)->finalize (obj);
}


GType
text_overlay_get_type (void)
{
	static volatile gsize text_overlay_type_id__volatile = 0;
	if (g_once_init_enter (&text_overlay_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TextOverlayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_overlay_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextOverlay), 0, (GInstanceInitFunc) text_overlay_instance_init, NULL };
		GType text_overlay_type_id;
		text_overlay_type_id = g_type_register_static (clutter_cairo_texture_get_type (), "TextOverlay", &g_define_type_info, 0);
		TextOverlay_private_offset = g_type_add_instance_private (text_overlay_type_id, sizeof (TextOverlayPrivate));
		g_once_init_leave (&text_overlay_type_id__volatile, text_overlay_type_id);
	}
	return text_overlay_type_id__volatile;
}


static void
_vala_text_overlay_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	TextOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEXT_OVERLAY, TextOverlay);
	switch (property_id) {
		case TEXT_OVERLAY_TEXT_PROPERTY:
		g_value_set_string (value, text_overlay_get_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_text_overlay_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	TextOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEXT_OVERLAY, TextOverlay);
	switch (property_id) {
		case TEXT_OVERLAY_TEXT_PROPERTY:
		text_overlay_set_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static inline gpointer
block_texture_get_instance_private (BlockTexture* self)
{
	return G_STRUCT_MEMBER_P (self, BlockTexture_private_offset);
}


BlockTexture*
block_texture_construct (GType object_type,
                         gint color)
{
	BlockTexture * self = NULL;
	self = (BlockTexture*) g_object_new (object_type, NULL);
	clutter_cairo_texture_set_auto_resize ((ClutterCairoTexture*) self, TRUE);
	self->priv->color = CLAMP (color, 0, 6);
	return self;
}


BlockTexture*
block_texture_new (gint color)
{
	return block_texture_construct (TYPE_BLOCK_TEXTURE, color);
}


static gboolean
block_texture_real_draw (ClutterCairoTexture* base,
                         cairo_t* cr)
{
	BlockTexture * self;
	gboolean result = FALSE;
	guint w = 0U;
	guint h = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GQuark _tmp8_ = 0U;
	static GQuark _tmp7_label0 = 0;
	static GQuark _tmp7_label1 = 0;
	static GQuark _tmp7_label2 = 0;
	self = (BlockTexture*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	clutter_cairo_texture_clear ((ClutterCairoTexture*) self);
	clutter_cairo_texture_get_surface_size ((ClutterCairoTexture*) self, &_tmp0_, &_tmp1_);
	w = _tmp0_;
	h = _tmp1_;
	_tmp2_ = w;
	_tmp3_ = h;
	cairo_scale (cr, (gdouble) _tmp2_, (gdouble) _tmp3_);
	_tmp4_ = block_texture_get_theme (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("clean")))) {
		switch (0) {
			default:
			{
				block_texture_draw_clean (self, cr);
				break;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("tangoflat")))) {
		switch (0) {
			default:
			{
				block_texture_draw_tango (self, cr, FALSE);
				break;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string ("tangoshaded")))) {
		switch (0) {
			default:
			{
				block_texture_draw_tango (self, cr, TRUE);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				block_texture_draw_plain (self, cr);
				break;
			}
		}
	}
	result = FALSE;
	return result;
}


static void
block_texture_draw_plain (BlockTexture* self,
                          cairo_t* cr)
{
	static const gdouble colors[21] = {1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0};
	gint _tmp0_;
	gdouble _tmp1_;
	gint _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->color;
	_tmp1_ = colors[_tmp0_ * 3];
	_tmp2_ = self->priv->color;
	_tmp3_ = colors[(_tmp2_ * 3) + 1];
	_tmp4_ = self->priv->color;
	_tmp5_ = colors[(_tmp4_ * 3) + 2];
	cairo_set_source_rgb (cr, _tmp1_, _tmp3_, _tmp5_);
	cairo_paint (cr);
}


static void
block_texture_draw_rounded_rectangle (BlockTexture* self,
                                      cairo_t* cr,
                                      gdouble x,
                                      gdouble y,
                                      gdouble w,
                                      gdouble h,
                                      gdouble r)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_move_to (cr, x + r, y);
	cairo_line_to (cr, (x + w) - r, y);
	cairo_curve_to (cr, (x + w) - (r / 2), y, x + w, y + (r / 2), x + w, y + r);
	cairo_line_to (cr, x + w, (y + h) - r);
	cairo_curve_to (cr, x + w, (y + h) - (r / 2), (x + w) - (r / 2), y + h, (x + w) - r, y + h);
	cairo_line_to (cr, x + r, y + h);
	cairo_curve_to (cr, x + (r / 2), y + h, x, (y + h) - (r / 2), x, (y + h) - r);
	cairo_line_to (cr, x, y + r);
	cairo_curve_to (cr, x, y + (r / 2), x + (r / 2), y, x + r, y);
}


static void
block_texture_draw_clean (BlockTexture* self,
                          cairo_t* cr)
{
	static const gdouble colors[72] = {0.780392156863, 0.247058823529, 0.247058823529, 0.713725490196, 0.192156862745, 0.192156862745, 0.61568627451, 0.164705882353, 0.164705882353, 0.552941176471, 0.788235294118, 0.32549019607, 0.474509803922, 0.713725490196, 0.243137254902, 0.388235294118, 0.596078431373, 0.18431372549, 0.313725490196, 0.450980392157, 0.623529411765, 0.239215686275, 0.345098039216, 0.474509803922, 0.21568627451, 0.313725490196, 0.435294117647, 1.0, 1.0, 1.0, 0.909803921569, 0.909803921569, 0.898039215686, 0.701960784314, 0.701960784314, 0.670588235294, 0.945098039216, 0.878431372549, 0.321568627451, 0.929411764706, 0.839215686275, 0.113725490196, 0.760784313725, 0.682352941176, 0.0274509803922, 0.576470588235, 0.364705882353, 0.607843137255, 0.443137254902, 0.282352941176, 0.46666666666, 0.439215686275, 0.266666666667, 0.46666666666, 0.890196078431, 0.572549019608, 0.258823529412, 0.803921568627, 0.450980392157, 0.101960784314, 0.690196078431, 0.388235294118, 0.0901960784314, 0.392156862745, 0.392156862745, 0.392156862745, 0.262745098039, 0.262745098039, 0.262745098039, 0.21568627451, 0.235294117647, 0.23921568627};
	gint _tmp0_;
	gdouble _tmp1_;
	gint _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	cairo_pattern_t* pat = NULL;
	cairo_pattern_t* _tmp6_;
	gint _tmp7_;
	gdouble _tmp8_;
	gint _tmp9_;
	gdouble _tmp10_;
	gint _tmp11_;
	gdouble _tmp12_;
	gint _tmp13_;
	gdouble _tmp14_;
	gint _tmp15_;
	gdouble _tmp16_;
	gint _tmp17_;
	gdouble _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	block_texture_draw_rounded_rectangle (self, cr, 0.05, 0.05, 0.9, 0.9, 0.05);
	_tmp0_ = self->priv->color;
	_tmp1_ = colors[(_tmp0_ * 9) + 6];
	_tmp2_ = self->priv->color;
	_tmp3_ = colors[(_tmp2_ * 9) + 7];
	_tmp4_ = self->priv->color;
	_tmp5_ = colors[(_tmp4_ * 9) + 8];
	cairo_set_source_rgb (cr, _tmp1_, _tmp3_, _tmp5_);
	cairo_set_line_width (cr, 0.1);
	cairo_stroke_preserve (cr);
	_tmp6_ = cairo_pattern_create_linear (0.35, (gdouble) 0, 0.55, 0.9);
	pat = _tmp6_;
	_tmp7_ = self->priv->color;
	_tmp8_ = colors[_tmp7_ * 9];
	_tmp9_ = self->priv->color;
	_tmp10_ = colors[(_tmp9_ * 9) + 1];
	_tmp11_ = self->priv->color;
	_tmp12_ = colors[(_tmp11_ * 9) + 2];
	cairo_pattern_add_color_stop_rgb (pat, 0.0, _tmp8_, _tmp10_, _tmp12_);
	_tmp13_ = self->priv->color;
	_tmp14_ = colors[(_tmp13_ * 9) + 3];
	_tmp15_ = self->priv->color;
	_tmp16_ = colors[(_tmp15_ * 9) + 4];
	_tmp17_ = self->priv->color;
	_tmp18_ = colors[(_tmp17_ * 9) + 5];
	cairo_pattern_add_color_stop_rgb (pat, 1.0, _tmp14_, _tmp16_, _tmp18_);
	cairo_set_source (cr, pat);
	cairo_fill (cr);
	_cairo_pattern_destroy0 (pat);
}


static void
block_texture_draw_tango (BlockTexture* self,
                          cairo_t* cr,
                          gboolean use_gradients)
{
	static const gdouble colors[72] = {0.93725490196078431, 0.16078431372549021, 0.16078431372549021, 0.8, 0.0, 0.0, 0.64313725490196083, 0.0, 0.0, 0.54117647058823526, 0.88627450980392153, 0.20392156862745098, 0.45098039215686275, 0.82352941176470584, 0.086274509803921567, 0.30588235294117649, 0.60392156862745094, 0.023529411764705882, 0.44705882352941179, 0.62352941176470589, 0.81176470588235294, 0.20392156862745098, 0.396078431372549, 0.64313725490196083, 0.12549019607843137, 0.29019607843137257, 0.52941176470588236, 0.93333333333333335, 0.93333333333333335, 0.92549019607843142, 0.82745098039215681, 0.84313725490196079, 0.81176470588235294, 0.72941176470588232, 0.74117647058823533, 0.71372549019607845, 0.9882352941176471, 0.9137254901960784, 0.30980392156862746, 0.92941176470588238, 0.83137254901960789, 0.0, 0.7686274509803922, 0.62745098039215685, 0.0, 0.67843137254901964, 0.49803921568627452, 0.6588235294117647, 0.45882352941176469, 0.31372549019607843, 0.4823529411764706, 0.36078431372549019, 0.20784313725490197, 0.4, 0.9882352941176471, 0.68627450980392157, 0.24313725490196078, 0.96078431372549022, 0.47450980392156861, 0.0, 0.80784313725490198, 0.36078431372549019, 0.0, 0.33, 0.34, 0.32, 0.18, 0.2, 0.21, 0.10, 0.12, 0.13};
	gint _tmp22_;
	gdouble _tmp23_;
	gint _tmp24_;
	gdouble _tmp25_;
	gint _tmp26_;
	gdouble _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (use_gradients) {
		cairo_pattern_t* pat = NULL;
		cairo_pattern_t* _tmp0_;
		cairo_pattern_t* _tmp1_;
		gint _tmp2_;
		gdouble _tmp3_;
		gint _tmp4_;
		gdouble _tmp5_;
		gint _tmp6_;
		gdouble _tmp7_;
		cairo_pattern_t* _tmp8_;
		gint _tmp9_;
		gdouble _tmp10_;
		gint _tmp11_;
		gdouble _tmp12_;
		gint _tmp13_;
		gdouble _tmp14_;
		cairo_pattern_t* _tmp15_;
		_tmp0_ = cairo_pattern_create_linear (0.35, (gdouble) 0, 0.55, 0.9);
		pat = _tmp0_;
		_tmp1_ = pat;
		_tmp2_ = self->priv->color;
		_tmp3_ = colors[_tmp2_ * 9];
		_tmp4_ = self->priv->color;
		_tmp5_ = colors[(_tmp4_ * 9) + 1];
		_tmp6_ = self->priv->color;
		_tmp7_ = colors[(_tmp6_ * 9) + 2];
		cairo_pattern_add_color_stop_rgb (_tmp1_, 0.0, _tmp3_, _tmp5_, _tmp7_);
		_tmp8_ = pat;
		_tmp9_ = self->priv->color;
		_tmp10_ = colors[(_tmp9_ * 9) + 3];
		_tmp11_ = self->priv->color;
		_tmp12_ = colors[(_tmp11_ * 9) + 4];
		_tmp13_ = self->priv->color;
		_tmp14_ = colors[(_tmp13_ * 9) + 5];
		cairo_pattern_add_color_stop_rgb (_tmp8_, 1.0, _tmp10_, _tmp12_, _tmp14_);
		_tmp15_ = pat;
		cairo_set_source (cr, _tmp15_);
		_cairo_pattern_destroy0 (pat);
	} else {
		gint _tmp16_;
		gdouble _tmp17_;
		gint _tmp18_;
		gdouble _tmp19_;
		gint _tmp20_;
		gdouble _tmp21_;
		_tmp16_ = self->priv->color;
		_tmp17_ = colors[_tmp16_ * 9];
		_tmp18_ = self->priv->color;
		_tmp19_ = colors[(_tmp18_ * 9) + 1];
		_tmp20_ = self->priv->color;
		_tmp21_ = colors[(_tmp20_ * 9) + 2];
		cairo_set_source_rgb (cr, _tmp17_, _tmp19_, _tmp21_);
	}
	block_texture_draw_rounded_rectangle (self, cr, 0.05, 0.05, 0.9, 0.9, 0.2);
	cairo_fill_preserve (cr);
	_tmp22_ = self->priv->color;
	_tmp23_ = colors[(_tmp22_ * 9) + 6];
	_tmp24_ = self->priv->color;
	_tmp25_ = colors[(_tmp24_ * 9) + 7];
	_tmp26_ = self->priv->color;
	_tmp27_ = colors[(_tmp26_ * 9) + 8];
	cairo_set_source_rgb (cr, _tmp23_, _tmp25_, _tmp27_);
	cairo_set_line_width (cr, 0.1);
	cairo_stroke (cr);
	block_texture_draw_rounded_rectangle (self, cr, 0.15, 0.15, 0.7, 0.7, 0.08);
	if (use_gradients) {
		cairo_pattern_t* pat = NULL;
		cairo_pattern_t* _tmp28_;
		gint _tmp29_;
		cairo_pattern_t* _tmp34_;
		_tmp28_ = cairo_pattern_create_linear (-0.3, -0.3, 0.8, 0.8);
		pat = _tmp28_;
		_tmp29_ = self->priv->color;
		switch (_tmp29_) {
			case 3:
			case 4:
			{
				cairo_pattern_t* _tmp30_;
				cairo_pattern_t* _tmp31_;
				_tmp30_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp30_, 0.0, 1.0, 1.0, 1.0, 1.0);
				_tmp31_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp31_, 1.0, 1.0, 1.0, 1.0, 0.0);
				break;
			}
			default:
			{
				cairo_pattern_t* _tmp32_;
				cairo_pattern_t* _tmp33_;
				_tmp32_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp32_, 0.0, 0.9295, 0.9295, 0.9295, 1.0);
				_tmp33_ = pat;
				cairo_pattern_add_color_stop_rgba (_tmp33_, 1.0, 0.9295, 0.9295, 0.9295, 0.0);
				break;
			}
		}
		_tmp34_ = pat;
		cairo_set_source (cr, _tmp34_);
		_cairo_pattern_destroy0 (pat);
	} else {
		cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.35);
	}
	cairo_stroke (cr);
}


const gchar*
block_texture_get_theme (BlockTexture* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}


void
block_texture_set_theme (BlockTexture* self,
                         const gchar* value)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_theme;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp1_;
	clutter_cairo_texture_invalidate ((ClutterCairoTexture*) self);
	g_object_notify_by_pspec ((GObject *) self, block_texture_properties[BLOCK_TEXTURE_THEME_PROPERTY]);
}


static void
block_texture_class_init (BlockTextureClass * klass)
{
	block_texture_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BlockTexture_private_offset);
	((ClutterCairoTextureClass *) klass)->draw = (gboolean (*) (ClutterCairoTexture *, cairo_t*)) block_texture_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_block_texture_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_block_texture_set_property;
	G_OBJECT_CLASS (klass)->finalize = block_texture_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLOCK_TEXTURE_THEME_PROPERTY, block_texture_properties[BLOCK_TEXTURE_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
block_texture_instance_init (BlockTexture * self)
{
	self->priv = block_texture_get_instance_private (self);
	self->priv->_theme = NULL;
}


static void
block_texture_finalize (GObject * obj)
{
	BlockTexture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLOCK_TEXTURE, BlockTexture);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (block_texture_parent_class)->finalize (obj);
}


GType
block_texture_get_type (void)
{
	static volatile gsize block_texture_type_id__volatile = 0;
	if (g_once_init_enter (&block_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlockTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlockTexture), 0, (GInstanceInitFunc) block_texture_instance_init, NULL };
		GType block_texture_type_id;
		block_texture_type_id = g_type_register_static (clutter_cairo_texture_get_type (), "BlockTexture", &g_define_type_info, 0);
		BlockTexture_private_offset = g_type_add_instance_private (block_texture_type_id, sizeof (BlockTexturePrivate));
		g_once_init_leave (&block_texture_type_id__volatile, block_texture_type_id);
	}
	return block_texture_type_id__volatile;
}


static void
_vala_block_texture_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	BlockTexture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BLOCK_TEXTURE, BlockTexture);
	switch (property_id) {
		case BLOCK_TEXTURE_THEME_PROPERTY:
		g_value_set_string (value, block_texture_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_block_texture_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	BlockTexture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BLOCK_TEXTURE, BlockTexture);
	switch (property_id) {
		case BLOCK_TEXTURE_THEME_PROPERTY:
		block_texture_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



