// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#![cfg(unix)]

use gtk4_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gtk4"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {cmd:?} returned {}", out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {abi_cmd:?} failed, {output:?}").into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GtkAccessibleAutocomplete",
        Layout {
            size: size_of::<GtkAccessibleAutocomplete>(),
            alignment: align_of::<GtkAccessibleAutocomplete>(),
        },
    ),
    (
        "GtkAccessibleInterface",
        Layout {
            size: size_of::<GtkAccessibleInterface>(),
            alignment: align_of::<GtkAccessibleInterface>(),
        },
    ),
    (
        "GtkAccessibleInvalidState",
        Layout {
            size: size_of::<GtkAccessibleInvalidState>(),
            alignment: align_of::<GtkAccessibleInvalidState>(),
        },
    ),
    (
        "GtkAccessiblePlatformState",
        Layout {
            size: size_of::<GtkAccessiblePlatformState>(),
            alignment: align_of::<GtkAccessiblePlatformState>(),
        },
    ),
    (
        "GtkAccessibleProperty",
        Layout {
            size: size_of::<GtkAccessibleProperty>(),
            alignment: align_of::<GtkAccessibleProperty>(),
        },
    ),
    (
        "GtkAccessibleRangeInterface",
        Layout {
            size: size_of::<GtkAccessibleRangeInterface>(),
            alignment: align_of::<GtkAccessibleRangeInterface>(),
        },
    ),
    (
        "GtkAccessibleRelation",
        Layout {
            size: size_of::<GtkAccessibleRelation>(),
            alignment: align_of::<GtkAccessibleRelation>(),
        },
    ),
    (
        "GtkAccessibleRole",
        Layout {
            size: size_of::<GtkAccessibleRole>(),
            alignment: align_of::<GtkAccessibleRole>(),
        },
    ),
    (
        "GtkAccessibleSort",
        Layout {
            size: size_of::<GtkAccessibleSort>(),
            alignment: align_of::<GtkAccessibleSort>(),
        },
    ),
    (
        "GtkAccessibleState",
        Layout {
            size: size_of::<GtkAccessibleState>(),
            alignment: align_of::<GtkAccessibleState>(),
        },
    ),
    (
        "GtkAccessibleTristate",
        Layout {
            size: size_of::<GtkAccessibleTristate>(),
            alignment: align_of::<GtkAccessibleTristate>(),
        },
    ),
    (
        "GtkActionableInterface",
        Layout {
            size: size_of::<GtkActionableInterface>(),
            alignment: align_of::<GtkActionableInterface>(),
        },
    ),
    (
        "GtkAdjustment",
        Layout {
            size: size_of::<GtkAdjustment>(),
            alignment: align_of::<GtkAdjustment>(),
        },
    ),
    (
        "GtkAdjustmentClass",
        Layout {
            size: size_of::<GtkAdjustmentClass>(),
            alignment: align_of::<GtkAdjustmentClass>(),
        },
    ),
    (
        "GtkAlertDialogClass",
        Layout {
            size: size_of::<GtkAlertDialogClass>(),
            alignment: align_of::<GtkAlertDialogClass>(),
        },
    ),
    (
        "GtkAlign",
        Layout {
            size: size_of::<GtkAlign>(),
            alignment: align_of::<GtkAlign>(),
        },
    ),
    (
        "GtkAllocation",
        Layout {
            size: size_of::<GtkAllocation>(),
            alignment: align_of::<GtkAllocation>(),
        },
    ),
    (
        "GtkApplication",
        Layout {
            size: size_of::<GtkApplication>(),
            alignment: align_of::<GtkApplication>(),
        },
    ),
    (
        "GtkApplicationClass",
        Layout {
            size: size_of::<GtkApplicationClass>(),
            alignment: align_of::<GtkApplicationClass>(),
        },
    ),
    (
        "GtkApplicationInhibitFlags",
        Layout {
            size: size_of::<GtkApplicationInhibitFlags>(),
            alignment: align_of::<GtkApplicationInhibitFlags>(),
        },
    ),
    (
        "GtkApplicationWindow",
        Layout {
            size: size_of::<GtkApplicationWindow>(),
            alignment: align_of::<GtkApplicationWindow>(),
        },
    ),
    (
        "GtkApplicationWindowClass",
        Layout {
            size: size_of::<GtkApplicationWindowClass>(),
            alignment: align_of::<GtkApplicationWindowClass>(),
        },
    ),
    (
        "GtkArrowType",
        Layout {
            size: size_of::<GtkArrowType>(),
            alignment: align_of::<GtkArrowType>(),
        },
    ),
    (
        "GtkAssistantPageType",
        Layout {
            size: size_of::<GtkAssistantPageType>(),
            alignment: align_of::<GtkAssistantPageType>(),
        },
    ),
    (
        "GtkBaselinePosition",
        Layout {
            size: size_of::<GtkBaselinePosition>(),
            alignment: align_of::<GtkBaselinePosition>(),
        },
    ),
    (
        "GtkBinLayoutClass",
        Layout {
            size: size_of::<GtkBinLayoutClass>(),
            alignment: align_of::<GtkBinLayoutClass>(),
        },
    ),
    (
        "GtkBitsetIter",
        Layout {
            size: size_of::<GtkBitsetIter>(),
            alignment: align_of::<GtkBitsetIter>(),
        },
    ),
    (
        "GtkBookmarkListClass",
        Layout {
            size: size_of::<GtkBookmarkListClass>(),
            alignment: align_of::<GtkBookmarkListClass>(),
        },
    ),
    (
        "GtkBoolFilterClass",
        Layout {
            size: size_of::<GtkBoolFilterClass>(),
            alignment: align_of::<GtkBoolFilterClass>(),
        },
    ),
    (
        "GtkBorder",
        Layout {
            size: size_of::<GtkBorder>(),
            alignment: align_of::<GtkBorder>(),
        },
    ),
    (
        "GtkBorderStyle",
        Layout {
            size: size_of::<GtkBorderStyle>(),
            alignment: align_of::<GtkBorderStyle>(),
        },
    ),
    (
        "GtkBox",
        Layout {
            size: size_of::<GtkBox>(),
            alignment: align_of::<GtkBox>(),
        },
    ),
    (
        "GtkBoxClass",
        Layout {
            size: size_of::<GtkBoxClass>(),
            alignment: align_of::<GtkBoxClass>(),
        },
    ),
    (
        "GtkBoxLayoutClass",
        Layout {
            size: size_of::<GtkBoxLayoutClass>(),
            alignment: align_of::<GtkBoxLayoutClass>(),
        },
    ),
    (
        "GtkBuildableIface",
        Layout {
            size: size_of::<GtkBuildableIface>(),
            alignment: align_of::<GtkBuildableIface>(),
        },
    ),
    (
        "GtkBuildableParser",
        Layout {
            size: size_of::<GtkBuildableParser>(),
            alignment: align_of::<GtkBuildableParser>(),
        },
    ),
    (
        "GtkBuilderCScope",
        Layout {
            size: size_of::<GtkBuilderCScope>(),
            alignment: align_of::<GtkBuilderCScope>(),
        },
    ),
    (
        "GtkBuilderCScopeClass",
        Layout {
            size: size_of::<GtkBuilderCScopeClass>(),
            alignment: align_of::<GtkBuilderCScopeClass>(),
        },
    ),
    (
        "GtkBuilderClosureFlags",
        Layout {
            size: size_of::<GtkBuilderClosureFlags>(),
            alignment: align_of::<GtkBuilderClosureFlags>(),
        },
    ),
    (
        "GtkBuilderError",
        Layout {
            size: size_of::<GtkBuilderError>(),
            alignment: align_of::<GtkBuilderError>(),
        },
    ),
    (
        "GtkBuilderScopeInterface",
        Layout {
            size: size_of::<GtkBuilderScopeInterface>(),
            alignment: align_of::<GtkBuilderScopeInterface>(),
        },
    ),
    (
        "GtkButton",
        Layout {
            size: size_of::<GtkButton>(),
            alignment: align_of::<GtkButton>(),
        },
    ),
    (
        "GtkButtonClass",
        Layout {
            size: size_of::<GtkButtonClass>(),
            alignment: align_of::<GtkButtonClass>(),
        },
    ),
    (
        "GtkButtonsType",
        Layout {
            size: size_of::<GtkButtonsType>(),
            alignment: align_of::<GtkButtonsType>(),
        },
    ),
    (
        "GtkCellArea",
        Layout {
            size: size_of::<GtkCellArea>(),
            alignment: align_of::<GtkCellArea>(),
        },
    ),
    (
        "GtkCellAreaClass",
        Layout {
            size: size_of::<GtkCellAreaClass>(),
            alignment: align_of::<GtkCellAreaClass>(),
        },
    ),
    (
        "GtkCellAreaContext",
        Layout {
            size: size_of::<GtkCellAreaContext>(),
            alignment: align_of::<GtkCellAreaContext>(),
        },
    ),
    (
        "GtkCellAreaContextClass",
        Layout {
            size: size_of::<GtkCellAreaContextClass>(),
            alignment: align_of::<GtkCellAreaContextClass>(),
        },
    ),
    (
        "GtkCellEditableIface",
        Layout {
            size: size_of::<GtkCellEditableIface>(),
            alignment: align_of::<GtkCellEditableIface>(),
        },
    ),
    (
        "GtkCellLayoutIface",
        Layout {
            size: size_of::<GtkCellLayoutIface>(),
            alignment: align_of::<GtkCellLayoutIface>(),
        },
    ),
    (
        "GtkCellRenderer",
        Layout {
            size: size_of::<GtkCellRenderer>(),
            alignment: align_of::<GtkCellRenderer>(),
        },
    ),
    (
        "GtkCellRendererAccelMode",
        Layout {
            size: size_of::<GtkCellRendererAccelMode>(),
            alignment: align_of::<GtkCellRendererAccelMode>(),
        },
    ),
    (
        "GtkCellRendererClass",
        Layout {
            size: size_of::<GtkCellRendererClass>(),
            alignment: align_of::<GtkCellRendererClass>(),
        },
    ),
    (
        "GtkCellRendererMode",
        Layout {
            size: size_of::<GtkCellRendererMode>(),
            alignment: align_of::<GtkCellRendererMode>(),
        },
    ),
    (
        "GtkCellRendererState",
        Layout {
            size: size_of::<GtkCellRendererState>(),
            alignment: align_of::<GtkCellRendererState>(),
        },
    ),
    (
        "GtkCellRendererText",
        Layout {
            size: size_of::<GtkCellRendererText>(),
            alignment: align_of::<GtkCellRendererText>(),
        },
    ),
    (
        "GtkCellRendererTextClass",
        Layout {
            size: size_of::<GtkCellRendererTextClass>(),
            alignment: align_of::<GtkCellRendererTextClass>(),
        },
    ),
    (
        "GtkCenterLayoutClass",
        Layout {
            size: size_of::<GtkCenterLayoutClass>(),
            alignment: align_of::<GtkCenterLayoutClass>(),
        },
    ),
    (
        "GtkCheckButton",
        Layout {
            size: size_of::<GtkCheckButton>(),
            alignment: align_of::<GtkCheckButton>(),
        },
    ),
    (
        "GtkCheckButtonClass",
        Layout {
            size: size_of::<GtkCheckButtonClass>(),
            alignment: align_of::<GtkCheckButtonClass>(),
        },
    ),
    (
        "GtkCollation",
        Layout {
            size: size_of::<GtkCollation>(),
            alignment: align_of::<GtkCollation>(),
        },
    ),
    (
        "GtkColorChooserInterface",
        Layout {
            size: size_of::<GtkColorChooserInterface>(),
            alignment: align_of::<GtkColorChooserInterface>(),
        },
    ),
    (
        "GtkColorDialogButtonClass",
        Layout {
            size: size_of::<GtkColorDialogButtonClass>(),
            alignment: align_of::<GtkColorDialogButtonClass>(),
        },
    ),
    (
        "GtkColorDialogClass",
        Layout {
            size: size_of::<GtkColorDialogClass>(),
            alignment: align_of::<GtkColorDialogClass>(),
        },
    ),
    (
        "GtkColumnViewSorterClass",
        Layout {
            size: size_of::<GtkColumnViewSorterClass>(),
            alignment: align_of::<GtkColumnViewSorterClass>(),
        },
    ),
    (
        "GtkComboBox",
        Layout {
            size: size_of::<GtkComboBox>(),
            alignment: align_of::<GtkComboBox>(),
        },
    ),
    (
        "GtkComboBoxClass",
        Layout {
            size: size_of::<GtkComboBoxClass>(),
            alignment: align_of::<GtkComboBoxClass>(),
        },
    ),
    (
        "GtkConstraintAttribute",
        Layout {
            size: size_of::<GtkConstraintAttribute>(),
            alignment: align_of::<GtkConstraintAttribute>(),
        },
    ),
    (
        "GtkConstraintClass",
        Layout {
            size: size_of::<GtkConstraintClass>(),
            alignment: align_of::<GtkConstraintClass>(),
        },
    ),
    (
        "GtkConstraintGuideClass",
        Layout {
            size: size_of::<GtkConstraintGuideClass>(),
            alignment: align_of::<GtkConstraintGuideClass>(),
        },
    ),
    (
        "GtkConstraintLayoutChildClass",
        Layout {
            size: size_of::<GtkConstraintLayoutChildClass>(),
            alignment: align_of::<GtkConstraintLayoutChildClass>(),
        },
    ),
    (
        "GtkConstraintLayoutClass",
        Layout {
            size: size_of::<GtkConstraintLayoutClass>(),
            alignment: align_of::<GtkConstraintLayoutClass>(),
        },
    ),
    (
        "GtkConstraintRelation",
        Layout {
            size: size_of::<GtkConstraintRelation>(),
            alignment: align_of::<GtkConstraintRelation>(),
        },
    ),
    (
        "GtkConstraintStrength",
        Layout {
            size: size_of::<GtkConstraintStrength>(),
            alignment: align_of::<GtkConstraintStrength>(),
        },
    ),
    (
        "GtkConstraintVflParserError",
        Layout {
            size: size_of::<GtkConstraintVflParserError>(),
            alignment: align_of::<GtkConstraintVflParserError>(),
        },
    ),
    (
        "GtkContentFit",
        Layout {
            size: size_of::<GtkContentFit>(),
            alignment: align_of::<GtkContentFit>(),
        },
    ),
    (
        "GtkCornerType",
        Layout {
            size: size_of::<GtkCornerType>(),
            alignment: align_of::<GtkCornerType>(),
        },
    ),
    (
        "GtkCssLocation",
        Layout {
            size: size_of::<GtkCssLocation>(),
            alignment: align_of::<GtkCssLocation>(),
        },
    ),
    (
        "GtkCssParserError",
        Layout {
            size: size_of::<GtkCssParserError>(),
            alignment: align_of::<GtkCssParserError>(),
        },
    ),
    (
        "GtkCssParserWarning",
        Layout {
            size: size_of::<GtkCssParserWarning>(),
            alignment: align_of::<GtkCssParserWarning>(),
        },
    ),
    (
        "GtkCssProvider",
        Layout {
            size: size_of::<GtkCssProvider>(),
            alignment: align_of::<GtkCssProvider>(),
        },
    ),
    (
        "GtkCustomFilterClass",
        Layout {
            size: size_of::<GtkCustomFilterClass>(),
            alignment: align_of::<GtkCustomFilterClass>(),
        },
    ),
    (
        "GtkCustomLayoutClass",
        Layout {
            size: size_of::<GtkCustomLayoutClass>(),
            alignment: align_of::<GtkCustomLayoutClass>(),
        },
    ),
    (
        "GtkCustomSorterClass",
        Layout {
            size: size_of::<GtkCustomSorterClass>(),
            alignment: align_of::<GtkCustomSorterClass>(),
        },
    ),
    (
        "GtkDebugFlags",
        Layout {
            size: size_of::<GtkDebugFlags>(),
            alignment: align_of::<GtkDebugFlags>(),
        },
    ),
    (
        "GtkDeleteType",
        Layout {
            size: size_of::<GtkDeleteType>(),
            alignment: align_of::<GtkDeleteType>(),
        },
    ),
    (
        "GtkDialog",
        Layout {
            size: size_of::<GtkDialog>(),
            alignment: align_of::<GtkDialog>(),
        },
    ),
    (
        "GtkDialogClass",
        Layout {
            size: size_of::<GtkDialogClass>(),
            alignment: align_of::<GtkDialogClass>(),
        },
    ),
    (
        "GtkDialogError",
        Layout {
            size: size_of::<GtkDialogError>(),
            alignment: align_of::<GtkDialogError>(),
        },
    ),
    (
        "GtkDialogFlags",
        Layout {
            size: size_of::<GtkDialogFlags>(),
            alignment: align_of::<GtkDialogFlags>(),
        },
    ),
    (
        "GtkDirectionType",
        Layout {
            size: size_of::<GtkDirectionType>(),
            alignment: align_of::<GtkDirectionType>(),
        },
    ),
    (
        "GtkDirectoryListClass",
        Layout {
            size: size_of::<GtkDirectoryListClass>(),
            alignment: align_of::<GtkDirectoryListClass>(),
        },
    ),
    (
        "GtkDragIconClass",
        Layout {
            size: size_of::<GtkDragIconClass>(),
            alignment: align_of::<GtkDragIconClass>(),
        },
    ),
    (
        "GtkDrawingArea",
        Layout {
            size: size_of::<GtkDrawingArea>(),
            alignment: align_of::<GtkDrawingArea>(),
        },
    ),
    (
        "GtkDrawingAreaClass",
        Layout {
            size: size_of::<GtkDrawingAreaClass>(),
            alignment: align_of::<GtkDrawingAreaClass>(),
        },
    ),
    (
        "GtkDropDownClass",
        Layout {
            size: size_of::<GtkDropDownClass>(),
            alignment: align_of::<GtkDropDownClass>(),
        },
    ),
    (
        "GtkEditableInterface",
        Layout {
            size: size_of::<GtkEditableInterface>(),
            alignment: align_of::<GtkEditableInterface>(),
        },
    ),
    (
        "GtkEditableLabelClass",
        Layout {
            size: size_of::<GtkEditableLabelClass>(),
            alignment: align_of::<GtkEditableLabelClass>(),
        },
    ),
    (
        "GtkEditableProperties",
        Layout {
            size: size_of::<GtkEditableProperties>(),
            alignment: align_of::<GtkEditableProperties>(),
        },
    ),
    (
        "GtkEntry",
        Layout {
            size: size_of::<GtkEntry>(),
            alignment: align_of::<GtkEntry>(),
        },
    ),
    (
        "GtkEntryBuffer",
        Layout {
            size: size_of::<GtkEntryBuffer>(),
            alignment: align_of::<GtkEntryBuffer>(),
        },
    ),
    (
        "GtkEntryBufferClass",
        Layout {
            size: size_of::<GtkEntryBufferClass>(),
            alignment: align_of::<GtkEntryBufferClass>(),
        },
    ),
    (
        "GtkEntryClass",
        Layout {
            size: size_of::<GtkEntryClass>(),
            alignment: align_of::<GtkEntryClass>(),
        },
    ),
    (
        "GtkEntryIconPosition",
        Layout {
            size: size_of::<GtkEntryIconPosition>(),
            alignment: align_of::<GtkEntryIconPosition>(),
        },
    ),
    (
        "GtkEventControllerScrollFlags",
        Layout {
            size: size_of::<GtkEventControllerScrollFlags>(),
            alignment: align_of::<GtkEventControllerScrollFlags>(),
        },
    ),
    (
        "GtkEventSequenceState",
        Layout {
            size: size_of::<GtkEventSequenceState>(),
            alignment: align_of::<GtkEventSequenceState>(),
        },
    ),
    (
        "GtkFileChooserAction",
        Layout {
            size: size_of::<GtkFileChooserAction>(),
            alignment: align_of::<GtkFileChooserAction>(),
        },
    ),
    (
        "GtkFileChooserError",
        Layout {
            size: size_of::<GtkFileChooserError>(),
            alignment: align_of::<GtkFileChooserError>(),
        },
    ),
    (
        "GtkFileChooserNativeClass",
        Layout {
            size: size_of::<GtkFileChooserNativeClass>(),
            alignment: align_of::<GtkFileChooserNativeClass>(),
        },
    ),
    (
        "GtkFileDialogClass",
        Layout {
            size: size_of::<GtkFileDialogClass>(),
            alignment: align_of::<GtkFileDialogClass>(),
        },
    ),
    (
        "GtkFileLauncherClass",
        Layout {
            size: size_of::<GtkFileLauncherClass>(),
            alignment: align_of::<GtkFileLauncherClass>(),
        },
    ),
    (
        "GtkFilter",
        Layout {
            size: size_of::<GtkFilter>(),
            alignment: align_of::<GtkFilter>(),
        },
    ),
    (
        "GtkFilterChange",
        Layout {
            size: size_of::<GtkFilterChange>(),
            alignment: align_of::<GtkFilterChange>(),
        },
    ),
    (
        "GtkFilterClass",
        Layout {
            size: size_of::<GtkFilterClass>(),
            alignment: align_of::<GtkFilterClass>(),
        },
    ),
    (
        "GtkFilterListModelClass",
        Layout {
            size: size_of::<GtkFilterListModelClass>(),
            alignment: align_of::<GtkFilterListModelClass>(),
        },
    ),
    (
        "GtkFilterMatch",
        Layout {
            size: size_of::<GtkFilterMatch>(),
            alignment: align_of::<GtkFilterMatch>(),
        },
    ),
    (
        "GtkFixed",
        Layout {
            size: size_of::<GtkFixed>(),
            alignment: align_of::<GtkFixed>(),
        },
    ),
    (
        "GtkFixedClass",
        Layout {
            size: size_of::<GtkFixedClass>(),
            alignment: align_of::<GtkFixedClass>(),
        },
    ),
    (
        "GtkFixedLayoutChildClass",
        Layout {
            size: size_of::<GtkFixedLayoutChildClass>(),
            alignment: align_of::<GtkFixedLayoutChildClass>(),
        },
    ),
    (
        "GtkFixedLayoutClass",
        Layout {
            size: size_of::<GtkFixedLayoutClass>(),
            alignment: align_of::<GtkFixedLayoutClass>(),
        },
    ),
    (
        "GtkFlattenListModelClass",
        Layout {
            size: size_of::<GtkFlattenListModelClass>(),
            alignment: align_of::<GtkFlattenListModelClass>(),
        },
    ),
    (
        "GtkFlowBoxChild",
        Layout {
            size: size_of::<GtkFlowBoxChild>(),
            alignment: align_of::<GtkFlowBoxChild>(),
        },
    ),
    (
        "GtkFlowBoxChildClass",
        Layout {
            size: size_of::<GtkFlowBoxChildClass>(),
            alignment: align_of::<GtkFlowBoxChildClass>(),
        },
    ),
    (
        "GtkFontChooserIface",
        Layout {
            size: size_of::<GtkFontChooserIface>(),
            alignment: align_of::<GtkFontChooserIface>(),
        },
    ),
    (
        "GtkFontChooserLevel",
        Layout {
            size: size_of::<GtkFontChooserLevel>(),
            alignment: align_of::<GtkFontChooserLevel>(),
        },
    ),
    (
        "GtkFontDialogButtonClass",
        Layout {
            size: size_of::<GtkFontDialogButtonClass>(),
            alignment: align_of::<GtkFontDialogButtonClass>(),
        },
    ),
    (
        "GtkFontDialogClass",
        Layout {
            size: size_of::<GtkFontDialogClass>(),
            alignment: align_of::<GtkFontDialogClass>(),
        },
    ),
    (
        "GtkFontLevel",
        Layout {
            size: size_of::<GtkFontLevel>(),
            alignment: align_of::<GtkFontLevel>(),
        },
    ),
    (
        "GtkFrame",
        Layout {
            size: size_of::<GtkFrame>(),
            alignment: align_of::<GtkFrame>(),
        },
    ),
    (
        "GtkFrameClass",
        Layout {
            size: size_of::<GtkFrameClass>(),
            alignment: align_of::<GtkFrameClass>(),
        },
    ),
    (
        "GtkGLArea",
        Layout {
            size: size_of::<GtkGLArea>(),
            alignment: align_of::<GtkGLArea>(),
        },
    ),
    (
        "GtkGLAreaClass",
        Layout {
            size: size_of::<GtkGLAreaClass>(),
            alignment: align_of::<GtkGLAreaClass>(),
        },
    ),
    (
        "GtkGrid",
        Layout {
            size: size_of::<GtkGrid>(),
            alignment: align_of::<GtkGrid>(),
        },
    ),
    (
        "GtkGridClass",
        Layout {
            size: size_of::<GtkGridClass>(),
            alignment: align_of::<GtkGridClass>(),
        },
    ),
    (
        "GtkGridLayoutChildClass",
        Layout {
            size: size_of::<GtkGridLayoutChildClass>(),
            alignment: align_of::<GtkGridLayoutChildClass>(),
        },
    ),
    (
        "GtkGridLayoutClass",
        Layout {
            size: size_of::<GtkGridLayoutClass>(),
            alignment: align_of::<GtkGridLayoutClass>(),
        },
    ),
    (
        "GtkIMContext",
        Layout {
            size: size_of::<GtkIMContext>(),
            alignment: align_of::<GtkIMContext>(),
        },
    ),
    (
        "GtkIMContextClass",
        Layout {
            size: size_of::<GtkIMContextClass>(),
            alignment: align_of::<GtkIMContextClass>(),
        },
    ),
    (
        "GtkIMContextSimple",
        Layout {
            size: size_of::<GtkIMContextSimple>(),
            alignment: align_of::<GtkIMContextSimple>(),
        },
    ),
    (
        "GtkIMContextSimpleClass",
        Layout {
            size: size_of::<GtkIMContextSimpleClass>(),
            alignment: align_of::<GtkIMContextSimpleClass>(),
        },
    ),
    (
        "GtkIMMulticontext",
        Layout {
            size: size_of::<GtkIMMulticontext>(),
            alignment: align_of::<GtkIMMulticontext>(),
        },
    ),
    (
        "GtkIMMulticontextClass",
        Layout {
            size: size_of::<GtkIMMulticontextClass>(),
            alignment: align_of::<GtkIMMulticontextClass>(),
        },
    ),
    (
        "GtkIconLookupFlags",
        Layout {
            size: size_of::<GtkIconLookupFlags>(),
            alignment: align_of::<GtkIconLookupFlags>(),
        },
    ),
    (
        "GtkIconSize",
        Layout {
            size: size_of::<GtkIconSize>(),
            alignment: align_of::<GtkIconSize>(),
        },
    ),
    (
        "GtkIconThemeError",
        Layout {
            size: size_of::<GtkIconThemeError>(),
            alignment: align_of::<GtkIconThemeError>(),
        },
    ),
    (
        "GtkIconViewDropPosition",
        Layout {
            size: size_of::<GtkIconViewDropPosition>(),
            alignment: align_of::<GtkIconViewDropPosition>(),
        },
    ),
    (
        "GtkImageType",
        Layout {
            size: size_of::<GtkImageType>(),
            alignment: align_of::<GtkImageType>(),
        },
    ),
    (
        "GtkInputHints",
        Layout {
            size: size_of::<GtkInputHints>(),
            alignment: align_of::<GtkInputHints>(),
        },
    ),
    (
        "GtkInputPurpose",
        Layout {
            size: size_of::<GtkInputPurpose>(),
            alignment: align_of::<GtkInputPurpose>(),
        },
    ),
    (
        "GtkInscriptionClass",
        Layout {
            size: size_of::<GtkInscriptionClass>(),
            alignment: align_of::<GtkInscriptionClass>(),
        },
    ),
    (
        "GtkInscriptionOverflow",
        Layout {
            size: size_of::<GtkInscriptionOverflow>(),
            alignment: align_of::<GtkInscriptionOverflow>(),
        },
    ),
    (
        "GtkJustification",
        Layout {
            size: size_of::<GtkJustification>(),
            alignment: align_of::<GtkJustification>(),
        },
    ),
    (
        "GtkLayoutChild",
        Layout {
            size: size_of::<GtkLayoutChild>(),
            alignment: align_of::<GtkLayoutChild>(),
        },
    ),
    (
        "GtkLayoutChildClass",
        Layout {
            size: size_of::<GtkLayoutChildClass>(),
            alignment: align_of::<GtkLayoutChildClass>(),
        },
    ),
    (
        "GtkLayoutManager",
        Layout {
            size: size_of::<GtkLayoutManager>(),
            alignment: align_of::<GtkLayoutManager>(),
        },
    ),
    (
        "GtkLayoutManagerClass",
        Layout {
            size: size_of::<GtkLayoutManagerClass>(),
            alignment: align_of::<GtkLayoutManagerClass>(),
        },
    ),
    (
        "GtkLevelBarMode",
        Layout {
            size: size_of::<GtkLevelBarMode>(),
            alignment: align_of::<GtkLevelBarMode>(),
        },
    ),
    (
        "GtkLicense",
        Layout {
            size: size_of::<GtkLicense>(),
            alignment: align_of::<GtkLicense>(),
        },
    ),
    (
        "GtkListBoxRow",
        Layout {
            size: size_of::<GtkListBoxRow>(),
            alignment: align_of::<GtkListBoxRow>(),
        },
    ),
    (
        "GtkListBoxRowClass",
        Layout {
            size: size_of::<GtkListBoxRowClass>(),
            alignment: align_of::<GtkListBoxRowClass>(),
        },
    ),
    (
        "GtkListStore",
        Layout {
            size: size_of::<GtkListStore>(),
            alignment: align_of::<GtkListStore>(),
        },
    ),
    (
        "GtkListStoreClass",
        Layout {
            size: size_of::<GtkListStoreClass>(),
            alignment: align_of::<GtkListStoreClass>(),
        },
    ),
    (
        "GtkListTabBehavior",
        Layout {
            size: size_of::<GtkListTabBehavior>(),
            alignment: align_of::<GtkListTabBehavior>(),
        },
    ),
    (
        "GtkMapListModelClass",
        Layout {
            size: size_of::<GtkMapListModelClass>(),
            alignment: align_of::<GtkMapListModelClass>(),
        },
    ),
    (
        "GtkMediaControlsClass",
        Layout {
            size: size_of::<GtkMediaControlsClass>(),
            alignment: align_of::<GtkMediaControlsClass>(),
        },
    ),
    (
        "GtkMediaFile",
        Layout {
            size: size_of::<GtkMediaFile>(),
            alignment: align_of::<GtkMediaFile>(),
        },
    ),
    (
        "GtkMediaFileClass",
        Layout {
            size: size_of::<GtkMediaFileClass>(),
            alignment: align_of::<GtkMediaFileClass>(),
        },
    ),
    (
        "GtkMediaStream",
        Layout {
            size: size_of::<GtkMediaStream>(),
            alignment: align_of::<GtkMediaStream>(),
        },
    ),
    (
        "GtkMediaStreamClass",
        Layout {
            size: size_of::<GtkMediaStreamClass>(),
            alignment: align_of::<GtkMediaStreamClass>(),
        },
    ),
    (
        "GtkMessageDialog",
        Layout {
            size: size_of::<GtkMessageDialog>(),
            alignment: align_of::<GtkMessageDialog>(),
        },
    ),
    (
        "GtkMessageType",
        Layout {
            size: size_of::<GtkMessageType>(),
            alignment: align_of::<GtkMessageType>(),
        },
    ),
    (
        "GtkMountOperation",
        Layout {
            size: size_of::<GtkMountOperation>(),
            alignment: align_of::<GtkMountOperation>(),
        },
    ),
    (
        "GtkMountOperationClass",
        Layout {
            size: size_of::<GtkMountOperationClass>(),
            alignment: align_of::<GtkMountOperationClass>(),
        },
    ),
    (
        "GtkMovementStep",
        Layout {
            size: size_of::<GtkMovementStep>(),
            alignment: align_of::<GtkMovementStep>(),
        },
    ),
    (
        "GtkMultiSelectionClass",
        Layout {
            size: size_of::<GtkMultiSelectionClass>(),
            alignment: align_of::<GtkMultiSelectionClass>(),
        },
    ),
    (
        "GtkMultiSorterClass",
        Layout {
            size: size_of::<GtkMultiSorterClass>(),
            alignment: align_of::<GtkMultiSorterClass>(),
        },
    ),
    (
        "GtkNativeDialog",
        Layout {
            size: size_of::<GtkNativeDialog>(),
            alignment: align_of::<GtkNativeDialog>(),
        },
    ),
    (
        "GtkNativeDialogClass",
        Layout {
            size: size_of::<GtkNativeDialogClass>(),
            alignment: align_of::<GtkNativeDialogClass>(),
        },
    ),
    (
        "GtkNaturalWrapMode",
        Layout {
            size: size_of::<GtkNaturalWrapMode>(),
            alignment: align_of::<GtkNaturalWrapMode>(),
        },
    ),
    (
        "GtkNoSelectionClass",
        Layout {
            size: size_of::<GtkNoSelectionClass>(),
            alignment: align_of::<GtkNoSelectionClass>(),
        },
    ),
    (
        "GtkNotebookTab",
        Layout {
            size: size_of::<GtkNotebookTab>(),
            alignment: align_of::<GtkNotebookTab>(),
        },
    ),
    (
        "GtkNumberUpLayout",
        Layout {
            size: size_of::<GtkNumberUpLayout>(),
            alignment: align_of::<GtkNumberUpLayout>(),
        },
    ),
    (
        "GtkNumericSorterClass",
        Layout {
            size: size_of::<GtkNumericSorterClass>(),
            alignment: align_of::<GtkNumericSorterClass>(),
        },
    ),
    (
        "GtkOrdering",
        Layout {
            size: size_of::<GtkOrdering>(),
            alignment: align_of::<GtkOrdering>(),
        },
    ),
    (
        "GtkOrientableIface",
        Layout {
            size: size_of::<GtkOrientableIface>(),
            alignment: align_of::<GtkOrientableIface>(),
        },
    ),
    (
        "GtkOrientation",
        Layout {
            size: size_of::<GtkOrientation>(),
            alignment: align_of::<GtkOrientation>(),
        },
    ),
    (
        "GtkOverflow",
        Layout {
            size: size_of::<GtkOverflow>(),
            alignment: align_of::<GtkOverflow>(),
        },
    ),
    (
        "GtkOverlayLayoutChildClass",
        Layout {
            size: size_of::<GtkOverlayLayoutChildClass>(),
            alignment: align_of::<GtkOverlayLayoutChildClass>(),
        },
    ),
    (
        "GtkOverlayLayoutClass",
        Layout {
            size: size_of::<GtkOverlayLayoutClass>(),
            alignment: align_of::<GtkOverlayLayoutClass>(),
        },
    ),
    (
        "GtkPackType",
        Layout {
            size: size_of::<GtkPackType>(),
            alignment: align_of::<GtkPackType>(),
        },
    ),
    (
        "GtkPadActionEntry",
        Layout {
            size: size_of::<GtkPadActionEntry>(),
            alignment: align_of::<GtkPadActionEntry>(),
        },
    ),
    (
        "GtkPadActionType",
        Layout {
            size: size_of::<GtkPadActionType>(),
            alignment: align_of::<GtkPadActionType>(),
        },
    ),
    (
        "GtkPageOrientation",
        Layout {
            size: size_of::<GtkPageOrientation>(),
            alignment: align_of::<GtkPageOrientation>(),
        },
    ),
    (
        "GtkPageRange",
        Layout {
            size: size_of::<GtkPageRange>(),
            alignment: align_of::<GtkPageRange>(),
        },
    ),
    (
        "GtkPageSet",
        Layout {
            size: size_of::<GtkPageSet>(),
            alignment: align_of::<GtkPageSet>(),
        },
    ),
    (
        "GtkPanDirection",
        Layout {
            size: size_of::<GtkPanDirection>(),
            alignment: align_of::<GtkPanDirection>(),
        },
    ),
    (
        "GtkParamSpecExpression",
        Layout {
            size: size_of::<GtkParamSpecExpression>(),
            alignment: align_of::<GtkParamSpecExpression>(),
        },
    ),
    (
        "GtkPasswordEntryBufferClass",
        Layout {
            size: size_of::<GtkPasswordEntryBufferClass>(),
            alignment: align_of::<GtkPasswordEntryBufferClass>(),
        },
    ),
    (
        "GtkPickFlags",
        Layout {
            size: size_of::<GtkPickFlags>(),
            alignment: align_of::<GtkPickFlags>(),
        },
    ),
    (
        "GtkPictureClass",
        Layout {
            size: size_of::<GtkPictureClass>(),
            alignment: align_of::<GtkPictureClass>(),
        },
    ),
    (
        "GtkPolicyType",
        Layout {
            size: size_of::<GtkPolicyType>(),
            alignment: align_of::<GtkPolicyType>(),
        },
    ),
    (
        "GtkPopover",
        Layout {
            size: size_of::<GtkPopover>(),
            alignment: align_of::<GtkPopover>(),
        },
    ),
    (
        "GtkPopoverClass",
        Layout {
            size: size_of::<GtkPopoverClass>(),
            alignment: align_of::<GtkPopoverClass>(),
        },
    ),
    (
        "GtkPopoverMenuFlags",
        Layout {
            size: size_of::<GtkPopoverMenuFlags>(),
            alignment: align_of::<GtkPopoverMenuFlags>(),
        },
    ),
    (
        "GtkPositionType",
        Layout {
            size: size_of::<GtkPositionType>(),
            alignment: align_of::<GtkPositionType>(),
        },
    ),
    (
        "GtkPrintCapabilities",
        Layout {
            size: size_of::<GtkPrintCapabilities>(),
            alignment: align_of::<GtkPrintCapabilities>(),
        },
    ),
    (
        "GtkPrintDuplex",
        Layout {
            size: size_of::<GtkPrintDuplex>(),
            alignment: align_of::<GtkPrintDuplex>(),
        },
    ),
    (
        "GtkPrintError",
        Layout {
            size: size_of::<GtkPrintError>(),
            alignment: align_of::<GtkPrintError>(),
        },
    ),
    (
        "GtkPrintOperation",
        Layout {
            size: size_of::<GtkPrintOperation>(),
            alignment: align_of::<GtkPrintOperation>(),
        },
    ),
    (
        "GtkPrintOperationAction",
        Layout {
            size: size_of::<GtkPrintOperationAction>(),
            alignment: align_of::<GtkPrintOperationAction>(),
        },
    ),
    (
        "GtkPrintOperationClass",
        Layout {
            size: size_of::<GtkPrintOperationClass>(),
            alignment: align_of::<GtkPrintOperationClass>(),
        },
    ),
    (
        "GtkPrintOperationPreviewIface",
        Layout {
            size: size_of::<GtkPrintOperationPreviewIface>(),
            alignment: align_of::<GtkPrintOperationPreviewIface>(),
        },
    ),
    (
        "GtkPrintOperationResult",
        Layout {
            size: size_of::<GtkPrintOperationResult>(),
            alignment: align_of::<GtkPrintOperationResult>(),
        },
    ),
    (
        "GtkPrintPages",
        Layout {
            size: size_of::<GtkPrintPages>(),
            alignment: align_of::<GtkPrintPages>(),
        },
    ),
    (
        "GtkPrintQuality",
        Layout {
            size: size_of::<GtkPrintQuality>(),
            alignment: align_of::<GtkPrintQuality>(),
        },
    ),
    (
        "GtkPrintStatus",
        Layout {
            size: size_of::<GtkPrintStatus>(),
            alignment: align_of::<GtkPrintStatus>(),
        },
    ),
    (
        "GtkPropagationLimit",
        Layout {
            size: size_of::<GtkPropagationLimit>(),
            alignment: align_of::<GtkPropagationLimit>(),
        },
    ),
    (
        "GtkPropagationPhase",
        Layout {
            size: size_of::<GtkPropagationPhase>(),
            alignment: align_of::<GtkPropagationPhase>(),
        },
    ),
    (
        "GtkRange",
        Layout {
            size: size_of::<GtkRange>(),
            alignment: align_of::<GtkRange>(),
        },
    ),
    (
        "GtkRangeClass",
        Layout {
            size: size_of::<GtkRangeClass>(),
            alignment: align_of::<GtkRangeClass>(),
        },
    ),
    (
        "GtkRecentData",
        Layout {
            size: size_of::<GtkRecentData>(),
            alignment: align_of::<GtkRecentData>(),
        },
    ),
    (
        "GtkRecentManager",
        Layout {
            size: size_of::<GtkRecentManager>(),
            alignment: align_of::<GtkRecentManager>(),
        },
    ),
    (
        "GtkRecentManagerClass",
        Layout {
            size: size_of::<GtkRecentManagerClass>(),
            alignment: align_of::<GtkRecentManagerClass>(),
        },
    ),
    (
        "GtkRecentManagerError",
        Layout {
            size: size_of::<GtkRecentManagerError>(),
            alignment: align_of::<GtkRecentManagerError>(),
        },
    ),
    (
        "GtkRequestedSize",
        Layout {
            size: size_of::<GtkRequestedSize>(),
            alignment: align_of::<GtkRequestedSize>(),
        },
    ),
    (
        "GtkRequisition",
        Layout {
            size: size_of::<GtkRequisition>(),
            alignment: align_of::<GtkRequisition>(),
        },
    ),
    (
        "GtkResponseType",
        Layout {
            size: size_of::<GtkResponseType>(),
            alignment: align_of::<GtkResponseType>(),
        },
    ),
    (
        "GtkRevealerTransitionType",
        Layout {
            size: size_of::<GtkRevealerTransitionType>(),
            alignment: align_of::<GtkRevealerTransitionType>(),
        },
    ),
    (
        "GtkScale",
        Layout {
            size: size_of::<GtkScale>(),
            alignment: align_of::<GtkScale>(),
        },
    ),
    (
        "GtkScaleButton",
        Layout {
            size: size_of::<GtkScaleButton>(),
            alignment: align_of::<GtkScaleButton>(),
        },
    ),
    (
        "GtkScaleButtonClass",
        Layout {
            size: size_of::<GtkScaleButtonClass>(),
            alignment: align_of::<GtkScaleButtonClass>(),
        },
    ),
    (
        "GtkScaleClass",
        Layout {
            size: size_of::<GtkScaleClass>(),
            alignment: align_of::<GtkScaleClass>(),
        },
    ),
    (
        "GtkScrollStep",
        Layout {
            size: size_of::<GtkScrollStep>(),
            alignment: align_of::<GtkScrollStep>(),
        },
    ),
    (
        "GtkScrollType",
        Layout {
            size: size_of::<GtkScrollType>(),
            alignment: align_of::<GtkScrollType>(),
        },
    ),
    (
        "GtkScrollableInterface",
        Layout {
            size: size_of::<GtkScrollableInterface>(),
            alignment: align_of::<GtkScrollableInterface>(),
        },
    ),
    (
        "GtkScrollablePolicy",
        Layout {
            size: size_of::<GtkScrollablePolicy>(),
            alignment: align_of::<GtkScrollablePolicy>(),
        },
    ),
    (
        "GtkSectionModelInterface",
        Layout {
            size: size_of::<GtkSectionModelInterface>(),
            alignment: align_of::<GtkSectionModelInterface>(),
        },
    ),
    (
        "GtkSelectionFilterModelClass",
        Layout {
            size: size_of::<GtkSelectionFilterModelClass>(),
            alignment: align_of::<GtkSelectionFilterModelClass>(),
        },
    ),
    (
        "GtkSelectionMode",
        Layout {
            size: size_of::<GtkSelectionMode>(),
            alignment: align_of::<GtkSelectionMode>(),
        },
    ),
    (
        "GtkSelectionModelInterface",
        Layout {
            size: size_of::<GtkSelectionModelInterface>(),
            alignment: align_of::<GtkSelectionModelInterface>(),
        },
    ),
    (
        "GtkSensitivityType",
        Layout {
            size: size_of::<GtkSensitivityType>(),
            alignment: align_of::<GtkSensitivityType>(),
        },
    ),
    (
        "GtkShortcutActionFlags",
        Layout {
            size: size_of::<GtkShortcutActionFlags>(),
            alignment: align_of::<GtkShortcutActionFlags>(),
        },
    ),
    (
        "GtkShortcutClass",
        Layout {
            size: size_of::<GtkShortcutClass>(),
            alignment: align_of::<GtkShortcutClass>(),
        },
    ),
    (
        "GtkShortcutManagerInterface",
        Layout {
            size: size_of::<GtkShortcutManagerInterface>(),
            alignment: align_of::<GtkShortcutManagerInterface>(),
        },
    ),
    (
        "GtkShortcutScope",
        Layout {
            size: size_of::<GtkShortcutScope>(),
            alignment: align_of::<GtkShortcutScope>(),
        },
    ),
    (
        "GtkShortcutType",
        Layout {
            size: size_of::<GtkShortcutType>(),
            alignment: align_of::<GtkShortcutType>(),
        },
    ),
    (
        "GtkSingleSelectionClass",
        Layout {
            size: size_of::<GtkSingleSelectionClass>(),
            alignment: align_of::<GtkSingleSelectionClass>(),
        },
    ),
    (
        "GtkSizeGroup",
        Layout {
            size: size_of::<GtkSizeGroup>(),
            alignment: align_of::<GtkSizeGroup>(),
        },
    ),
    (
        "GtkSizeGroupMode",
        Layout {
            size: size_of::<GtkSizeGroupMode>(),
            alignment: align_of::<GtkSizeGroupMode>(),
        },
    ),
    (
        "GtkSizeRequestMode",
        Layout {
            size: size_of::<GtkSizeRequestMode>(),
            alignment: align_of::<GtkSizeRequestMode>(),
        },
    ),
    (
        "GtkSliceListModelClass",
        Layout {
            size: size_of::<GtkSliceListModelClass>(),
            alignment: align_of::<GtkSliceListModelClass>(),
        },
    ),
    (
        "GtkSortListModelClass",
        Layout {
            size: size_of::<GtkSortListModelClass>(),
            alignment: align_of::<GtkSortListModelClass>(),
        },
    ),
    (
        "GtkSortType",
        Layout {
            size: size_of::<GtkSortType>(),
            alignment: align_of::<GtkSortType>(),
        },
    ),
    (
        "GtkSorter",
        Layout {
            size: size_of::<GtkSorter>(),
            alignment: align_of::<GtkSorter>(),
        },
    ),
    (
        "GtkSorterChange",
        Layout {
            size: size_of::<GtkSorterChange>(),
            alignment: align_of::<GtkSorterChange>(),
        },
    ),
    (
        "GtkSorterClass",
        Layout {
            size: size_of::<GtkSorterClass>(),
            alignment: align_of::<GtkSorterClass>(),
        },
    ),
    (
        "GtkSorterOrder",
        Layout {
            size: size_of::<GtkSorterOrder>(),
            alignment: align_of::<GtkSorterOrder>(),
        },
    ),
    (
        "GtkSpinButtonUpdatePolicy",
        Layout {
            size: size_of::<GtkSpinButtonUpdatePolicy>(),
            alignment: align_of::<GtkSpinButtonUpdatePolicy>(),
        },
    ),
    (
        "GtkSpinType",
        Layout {
            size: size_of::<GtkSpinType>(),
            alignment: align_of::<GtkSpinType>(),
        },
    ),
    (
        "GtkStackTransitionType",
        Layout {
            size: size_of::<GtkStackTransitionType>(),
            alignment: align_of::<GtkStackTransitionType>(),
        },
    ),
    (
        "GtkStateFlags",
        Layout {
            size: size_of::<GtkStateFlags>(),
            alignment: align_of::<GtkStateFlags>(),
        },
    ),
    (
        "GtkStringFilterClass",
        Layout {
            size: size_of::<GtkStringFilterClass>(),
            alignment: align_of::<GtkStringFilterClass>(),
        },
    ),
    (
        "GtkStringFilterMatchMode",
        Layout {
            size: size_of::<GtkStringFilterMatchMode>(),
            alignment: align_of::<GtkStringFilterMatchMode>(),
        },
    ),
    (
        "GtkStringListClass",
        Layout {
            size: size_of::<GtkStringListClass>(),
            alignment: align_of::<GtkStringListClass>(),
        },
    ),
    (
        "GtkStringObjectClass",
        Layout {
            size: size_of::<GtkStringObjectClass>(),
            alignment: align_of::<GtkStringObjectClass>(),
        },
    ),
    (
        "GtkStringSorterClass",
        Layout {
            size: size_of::<GtkStringSorterClass>(),
            alignment: align_of::<GtkStringSorterClass>(),
        },
    ),
    (
        "GtkStyleContext",
        Layout {
            size: size_of::<GtkStyleContext>(),
            alignment: align_of::<GtkStyleContext>(),
        },
    ),
    (
        "GtkStyleContextClass",
        Layout {
            size: size_of::<GtkStyleContextClass>(),
            alignment: align_of::<GtkStyleContextClass>(),
        },
    ),
    (
        "GtkStyleContextPrintFlags",
        Layout {
            size: size_of::<GtkStyleContextPrintFlags>(),
            alignment: align_of::<GtkStyleContextPrintFlags>(),
        },
    ),
    (
        "GtkSymbolicColor",
        Layout {
            size: size_of::<GtkSymbolicColor>(),
            alignment: align_of::<GtkSymbolicColor>(),
        },
    ),
    (
        "GtkSymbolicPaintableInterface",
        Layout {
            size: size_of::<GtkSymbolicPaintableInterface>(),
            alignment: align_of::<GtkSymbolicPaintableInterface>(),
        },
    ),
    (
        "GtkSystemSetting",
        Layout {
            size: size_of::<GtkSystemSetting>(),
            alignment: align_of::<GtkSystemSetting>(),
        },
    ),
    (
        "GtkText",
        Layout {
            size: size_of::<GtkText>(),
            alignment: align_of::<GtkText>(),
        },
    ),
    (
        "GtkTextBuffer",
        Layout {
            size: size_of::<GtkTextBuffer>(),
            alignment: align_of::<GtkTextBuffer>(),
        },
    ),
    (
        "GtkTextBufferClass",
        Layout {
            size: size_of::<GtkTextBufferClass>(),
            alignment: align_of::<GtkTextBufferClass>(),
        },
    ),
    (
        "GtkTextChildAnchor",
        Layout {
            size: size_of::<GtkTextChildAnchor>(),
            alignment: align_of::<GtkTextChildAnchor>(),
        },
    ),
    (
        "GtkTextChildAnchorClass",
        Layout {
            size: size_of::<GtkTextChildAnchorClass>(),
            alignment: align_of::<GtkTextChildAnchorClass>(),
        },
    ),
    (
        "GtkTextDirection",
        Layout {
            size: size_of::<GtkTextDirection>(),
            alignment: align_of::<GtkTextDirection>(),
        },
    ),
    (
        "GtkTextExtendSelection",
        Layout {
            size: size_of::<GtkTextExtendSelection>(),
            alignment: align_of::<GtkTextExtendSelection>(),
        },
    ),
    (
        "GtkTextIter",
        Layout {
            size: size_of::<GtkTextIter>(),
            alignment: align_of::<GtkTextIter>(),
        },
    ),
    (
        "GtkTextMark",
        Layout {
            size: size_of::<GtkTextMark>(),
            alignment: align_of::<GtkTextMark>(),
        },
    ),
    (
        "GtkTextMarkClass",
        Layout {
            size: size_of::<GtkTextMarkClass>(),
            alignment: align_of::<GtkTextMarkClass>(),
        },
    ),
    (
        "GtkTextSearchFlags",
        Layout {
            size: size_of::<GtkTextSearchFlags>(),
            alignment: align_of::<GtkTextSearchFlags>(),
        },
    ),
    (
        "GtkTextTag",
        Layout {
            size: size_of::<GtkTextTag>(),
            alignment: align_of::<GtkTextTag>(),
        },
    ),
    (
        "GtkTextTagClass",
        Layout {
            size: size_of::<GtkTextTagClass>(),
            alignment: align_of::<GtkTextTagClass>(),
        },
    ),
    (
        "GtkTextView",
        Layout {
            size: size_of::<GtkTextView>(),
            alignment: align_of::<GtkTextView>(),
        },
    ),
    (
        "GtkTextViewClass",
        Layout {
            size: size_of::<GtkTextViewClass>(),
            alignment: align_of::<GtkTextViewClass>(),
        },
    ),
    (
        "GtkTextViewLayer",
        Layout {
            size: size_of::<GtkTextViewLayer>(),
            alignment: align_of::<GtkTextViewLayer>(),
        },
    ),
    (
        "GtkTextWindowType",
        Layout {
            size: size_of::<GtkTextWindowType>(),
            alignment: align_of::<GtkTextWindowType>(),
        },
    ),
    (
        "GtkToggleButton",
        Layout {
            size: size_of::<GtkToggleButton>(),
            alignment: align_of::<GtkToggleButton>(),
        },
    ),
    (
        "GtkToggleButtonClass",
        Layout {
            size: size_of::<GtkToggleButtonClass>(),
            alignment: align_of::<GtkToggleButtonClass>(),
        },
    ),
    (
        "GtkTreeDragDestIface",
        Layout {
            size: size_of::<GtkTreeDragDestIface>(),
            alignment: align_of::<GtkTreeDragDestIface>(),
        },
    ),
    (
        "GtkTreeDragSourceIface",
        Layout {
            size: size_of::<GtkTreeDragSourceIface>(),
            alignment: align_of::<GtkTreeDragSourceIface>(),
        },
    ),
    (
        "GtkTreeExpanderClass",
        Layout {
            size: size_of::<GtkTreeExpanderClass>(),
            alignment: align_of::<GtkTreeExpanderClass>(),
        },
    ),
    (
        "GtkTreeIter",
        Layout {
            size: size_of::<GtkTreeIter>(),
            alignment: align_of::<GtkTreeIter>(),
        },
    ),
    (
        "GtkTreeListModelClass",
        Layout {
            size: size_of::<GtkTreeListModelClass>(),
            alignment: align_of::<GtkTreeListModelClass>(),
        },
    ),
    (
        "GtkTreeListRowClass",
        Layout {
            size: size_of::<GtkTreeListRowClass>(),
            alignment: align_of::<GtkTreeListRowClass>(),
        },
    ),
    (
        "GtkTreeListRowSorterClass",
        Layout {
            size: size_of::<GtkTreeListRowSorterClass>(),
            alignment: align_of::<GtkTreeListRowSorterClass>(),
        },
    ),
    (
        "GtkTreeModelFilter",
        Layout {
            size: size_of::<GtkTreeModelFilter>(),
            alignment: align_of::<GtkTreeModelFilter>(),
        },
    ),
    (
        "GtkTreeModelFilterClass",
        Layout {
            size: size_of::<GtkTreeModelFilterClass>(),
            alignment: align_of::<GtkTreeModelFilterClass>(),
        },
    ),
    (
        "GtkTreeModelFlags",
        Layout {
            size: size_of::<GtkTreeModelFlags>(),
            alignment: align_of::<GtkTreeModelFlags>(),
        },
    ),
    (
        "GtkTreeModelIface",
        Layout {
            size: size_of::<GtkTreeModelIface>(),
            alignment: align_of::<GtkTreeModelIface>(),
        },
    ),
    (
        "GtkTreeModelSort",
        Layout {
            size: size_of::<GtkTreeModelSort>(),
            alignment: align_of::<GtkTreeModelSort>(),
        },
    ),
    (
        "GtkTreeModelSortClass",
        Layout {
            size: size_of::<GtkTreeModelSortClass>(),
            alignment: align_of::<GtkTreeModelSortClass>(),
        },
    ),
    (
        "GtkTreeSortableIface",
        Layout {
            size: size_of::<GtkTreeSortableIface>(),
            alignment: align_of::<GtkTreeSortableIface>(),
        },
    ),
    (
        "GtkTreeStore",
        Layout {
            size: size_of::<GtkTreeStore>(),
            alignment: align_of::<GtkTreeStore>(),
        },
    ),
    (
        "GtkTreeStoreClass",
        Layout {
            size: size_of::<GtkTreeStoreClass>(),
            alignment: align_of::<GtkTreeStoreClass>(),
        },
    ),
    (
        "GtkTreeView",
        Layout {
            size: size_of::<GtkTreeView>(),
            alignment: align_of::<GtkTreeView>(),
        },
    ),
    (
        "GtkTreeViewClass",
        Layout {
            size: size_of::<GtkTreeViewClass>(),
            alignment: align_of::<GtkTreeViewClass>(),
        },
    ),
    (
        "GtkTreeViewColumnSizing",
        Layout {
            size: size_of::<GtkTreeViewColumnSizing>(),
            alignment: align_of::<GtkTreeViewColumnSizing>(),
        },
    ),
    (
        "GtkTreeViewDropPosition",
        Layout {
            size: size_of::<GtkTreeViewDropPosition>(),
            alignment: align_of::<GtkTreeViewDropPosition>(),
        },
    ),
    (
        "GtkTreeViewGridLines",
        Layout {
            size: size_of::<GtkTreeViewGridLines>(),
            alignment: align_of::<GtkTreeViewGridLines>(),
        },
    ),
    (
        "GtkUnit",
        Layout {
            size: size_of::<GtkUnit>(),
            alignment: align_of::<GtkUnit>(),
        },
    ),
    (
        "GtkUriLauncherClass",
        Layout {
            size: size_of::<GtkUriLauncherClass>(),
            alignment: align_of::<GtkUriLauncherClass>(),
        },
    ),
    (
        "GtkVideoClass",
        Layout {
            size: size_of::<GtkVideoClass>(),
            alignment: align_of::<GtkVideoClass>(),
        },
    ),
    (
        "GtkVolumeButton",
        Layout {
            size: size_of::<GtkVolumeButton>(),
            alignment: align_of::<GtkVolumeButton>(),
        },
    ),
    (
        "GtkWidget",
        Layout {
            size: size_of::<GtkWidget>(),
            alignment: align_of::<GtkWidget>(),
        },
    ),
    (
        "GtkWidgetClass",
        Layout {
            size: size_of::<GtkWidgetClass>(),
            alignment: align_of::<GtkWidgetClass>(),
        },
    ),
    (
        "GtkWidgetPaintableClass",
        Layout {
            size: size_of::<GtkWidgetPaintableClass>(),
            alignment: align_of::<GtkWidgetPaintableClass>(),
        },
    ),
    (
        "GtkWindow",
        Layout {
            size: size_of::<GtkWindow>(),
            alignment: align_of::<GtkWindow>(),
        },
    ),
    (
        "GtkWindowClass",
        Layout {
            size: size_of::<GtkWindowClass>(),
            alignment: align_of::<GtkWindowClass>(),
        },
    ),
    (
        "GtkWindowControlsClass",
        Layout {
            size: size_of::<GtkWindowControlsClass>(),
            alignment: align_of::<GtkWindowControlsClass>(),
        },
    ),
    (
        "GtkWindowGroup",
        Layout {
            size: size_of::<GtkWindowGroup>(),
            alignment: align_of::<GtkWindowGroup>(),
        },
    ),
    (
        "GtkWindowGroupClass",
        Layout {
            size: size_of::<GtkWindowGroupClass>(),
            alignment: align_of::<GtkWindowGroupClass>(),
        },
    ),
    (
        "GtkWindowHandleClass",
        Layout {
            size: size_of::<GtkWindowHandleClass>(),
            alignment: align_of::<GtkWindowHandleClass>(),
        },
    ),
    (
        "GtkWrapMode",
        Layout {
            size: size_of::<GtkWrapMode>(),
            alignment: align_of::<GtkWrapMode>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) GTK_ACCESSIBLE_AUTOCOMPLETE_BOTH", "3"),
    ("(gint) GTK_ACCESSIBLE_AUTOCOMPLETE_INLINE", "1"),
    ("(gint) GTK_ACCESSIBLE_AUTOCOMPLETE_LIST", "2"),
    ("(gint) GTK_ACCESSIBLE_AUTOCOMPLETE_NONE", "0"),
    ("(gint) GTK_ACCESSIBLE_INVALID_FALSE", "0"),
    ("(gint) GTK_ACCESSIBLE_INVALID_GRAMMAR", "2"),
    ("(gint) GTK_ACCESSIBLE_INVALID_SPELLING", "3"),
    ("(gint) GTK_ACCESSIBLE_INVALID_TRUE", "1"),
    ("(gint) GTK_ACCESSIBLE_PLATFORM_STATE_ACTIVE", "2"),
    ("(gint) GTK_ACCESSIBLE_PLATFORM_STATE_FOCUSABLE", "0"),
    ("(gint) GTK_ACCESSIBLE_PLATFORM_STATE_FOCUSED", "1"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_AUTOCOMPLETE", "0"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_DESCRIPTION", "1"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_HAS_POPUP", "2"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_KEY_SHORTCUTS", "3"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_LABEL", "4"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_LEVEL", "5"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_MODAL", "6"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_MULTI_LINE", "7"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_MULTI_SELECTABLE", "8"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_ORIENTATION", "9"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_PLACEHOLDER", "10"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_READ_ONLY", "11"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_REQUIRED", "12"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_ROLE_DESCRIPTION", "13"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_SORT", "14"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_VALUE_MAX", "15"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_VALUE_MIN", "16"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_VALUE_NOW", "17"),
    ("(gint) GTK_ACCESSIBLE_PROPERTY_VALUE_TEXT", "18"),
    ("(gint) GTK_ACCESSIBLE_RELATION_ACTIVE_DESCENDANT", "0"),
    ("(gint) GTK_ACCESSIBLE_RELATION_COL_COUNT", "1"),
    ("(gint) GTK_ACCESSIBLE_RELATION_COL_INDEX", "2"),
    ("(gint) GTK_ACCESSIBLE_RELATION_COL_INDEX_TEXT", "3"),
    ("(gint) GTK_ACCESSIBLE_RELATION_COL_SPAN", "4"),
    ("(gint) GTK_ACCESSIBLE_RELATION_CONTROLS", "5"),
    ("(gint) GTK_ACCESSIBLE_RELATION_DESCRIBED_BY", "6"),
    ("(gint) GTK_ACCESSIBLE_RELATION_DETAILS", "7"),
    ("(gint) GTK_ACCESSIBLE_RELATION_ERROR_MESSAGE", "8"),
    ("(gint) GTK_ACCESSIBLE_RELATION_FLOW_TO", "9"),
    ("(gint) GTK_ACCESSIBLE_RELATION_LABELLED_BY", "10"),
    ("(gint) GTK_ACCESSIBLE_RELATION_OWNS", "11"),
    ("(gint) GTK_ACCESSIBLE_RELATION_POS_IN_SET", "12"),
    ("(gint) GTK_ACCESSIBLE_RELATION_ROW_COUNT", "13"),
    ("(gint) GTK_ACCESSIBLE_RELATION_ROW_INDEX", "14"),
    ("(gint) GTK_ACCESSIBLE_RELATION_ROW_INDEX_TEXT", "15"),
    ("(gint) GTK_ACCESSIBLE_RELATION_ROW_SPAN", "16"),
    ("(gint) GTK_ACCESSIBLE_RELATION_SET_SIZE", "17"),
    ("(gint) GTK_ACCESSIBLE_ROLE_ALERT", "0"),
    ("(gint) GTK_ACCESSIBLE_ROLE_ALERT_DIALOG", "1"),
    ("(gint) GTK_ACCESSIBLE_ROLE_APPLICATION", "79"),
    ("(gint) GTK_ACCESSIBLE_ROLE_BANNER", "2"),
    ("(gint) GTK_ACCESSIBLE_ROLE_BUTTON", "3"),
    ("(gint) GTK_ACCESSIBLE_ROLE_CAPTION", "4"),
    ("(gint) GTK_ACCESSIBLE_ROLE_CELL", "5"),
    ("(gint) GTK_ACCESSIBLE_ROLE_CHECKBOX", "6"),
    ("(gint) GTK_ACCESSIBLE_ROLE_COLUMN_HEADER", "7"),
    ("(gint) GTK_ACCESSIBLE_ROLE_COMBO_BOX", "8"),
    ("(gint) GTK_ACCESSIBLE_ROLE_COMMAND", "9"),
    ("(gint) GTK_ACCESSIBLE_ROLE_COMPOSITE", "10"),
    ("(gint) GTK_ACCESSIBLE_ROLE_DIALOG", "11"),
    ("(gint) GTK_ACCESSIBLE_ROLE_DOCUMENT", "12"),
    ("(gint) GTK_ACCESSIBLE_ROLE_FEED", "13"),
    ("(gint) GTK_ACCESSIBLE_ROLE_FORM", "14"),
    ("(gint) GTK_ACCESSIBLE_ROLE_GENERIC", "15"),
    ("(gint) GTK_ACCESSIBLE_ROLE_GRID", "16"),
    ("(gint) GTK_ACCESSIBLE_ROLE_GRID_CELL", "17"),
    ("(gint) GTK_ACCESSIBLE_ROLE_GROUP", "18"),
    ("(gint) GTK_ACCESSIBLE_ROLE_HEADING", "19"),
    ("(gint) GTK_ACCESSIBLE_ROLE_IMG", "20"),
    ("(gint) GTK_ACCESSIBLE_ROLE_INPUT", "21"),
    ("(gint) GTK_ACCESSIBLE_ROLE_LABEL", "22"),
    ("(gint) GTK_ACCESSIBLE_ROLE_LANDMARK", "23"),
    ("(gint) GTK_ACCESSIBLE_ROLE_LEGEND", "24"),
    ("(gint) GTK_ACCESSIBLE_ROLE_LINK", "25"),
    ("(gint) GTK_ACCESSIBLE_ROLE_LIST", "26"),
    ("(gint) GTK_ACCESSIBLE_ROLE_LIST_BOX", "27"),
    ("(gint) GTK_ACCESSIBLE_ROLE_LIST_ITEM", "28"),
    ("(gint) GTK_ACCESSIBLE_ROLE_LOG", "29"),
    ("(gint) GTK_ACCESSIBLE_ROLE_MAIN", "30"),
    ("(gint) GTK_ACCESSIBLE_ROLE_MARQUEE", "31"),
    ("(gint) GTK_ACCESSIBLE_ROLE_MATH", "32"),
    ("(gint) GTK_ACCESSIBLE_ROLE_MENU", "34"),
    ("(gint) GTK_ACCESSIBLE_ROLE_MENU_BAR", "35"),
    ("(gint) GTK_ACCESSIBLE_ROLE_MENU_ITEM", "36"),
    ("(gint) GTK_ACCESSIBLE_ROLE_MENU_ITEM_CHECKBOX", "37"),
    ("(gint) GTK_ACCESSIBLE_ROLE_MENU_ITEM_RADIO", "38"),
    ("(gint) GTK_ACCESSIBLE_ROLE_METER", "33"),
    ("(gint) GTK_ACCESSIBLE_ROLE_NAVIGATION", "39"),
    ("(gint) GTK_ACCESSIBLE_ROLE_NONE", "40"),
    ("(gint) GTK_ACCESSIBLE_ROLE_NOTE", "41"),
    ("(gint) GTK_ACCESSIBLE_ROLE_OPTION", "42"),
    ("(gint) GTK_ACCESSIBLE_ROLE_PRESENTATION", "43"),
    ("(gint) GTK_ACCESSIBLE_ROLE_PROGRESS_BAR", "44"),
    ("(gint) GTK_ACCESSIBLE_ROLE_RADIO", "45"),
    ("(gint) GTK_ACCESSIBLE_ROLE_RADIO_GROUP", "46"),
    ("(gint) GTK_ACCESSIBLE_ROLE_RANGE", "47"),
    ("(gint) GTK_ACCESSIBLE_ROLE_REGION", "48"),
    ("(gint) GTK_ACCESSIBLE_ROLE_ROW", "49"),
    ("(gint) GTK_ACCESSIBLE_ROLE_ROW_GROUP", "50"),
    ("(gint) GTK_ACCESSIBLE_ROLE_ROW_HEADER", "51"),
    ("(gint) GTK_ACCESSIBLE_ROLE_SCROLLBAR", "52"),
    ("(gint) GTK_ACCESSIBLE_ROLE_SEARCH", "53"),
    ("(gint) GTK_ACCESSIBLE_ROLE_SEARCH_BOX", "54"),
    ("(gint) GTK_ACCESSIBLE_ROLE_SECTION", "55"),
    ("(gint) GTK_ACCESSIBLE_ROLE_SECTION_HEAD", "56"),
    ("(gint) GTK_ACCESSIBLE_ROLE_SELECT", "57"),
    ("(gint) GTK_ACCESSIBLE_ROLE_SEPARATOR", "58"),
    ("(gint) GTK_ACCESSIBLE_ROLE_SLIDER", "59"),
    ("(gint) GTK_ACCESSIBLE_ROLE_SPIN_BUTTON", "60"),
    ("(gint) GTK_ACCESSIBLE_ROLE_STATUS", "61"),
    ("(gint) GTK_ACCESSIBLE_ROLE_STRUCTURE", "62"),
    ("(gint) GTK_ACCESSIBLE_ROLE_SWITCH", "63"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TAB", "64"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TABLE", "65"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TAB_LIST", "66"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TAB_PANEL", "67"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TEXT_BOX", "68"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TIME", "69"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TIMER", "70"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TOGGLE_BUTTON", "78"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TOOLBAR", "71"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TOOLTIP", "72"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TREE", "73"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TREE_GRID", "74"),
    ("(gint) GTK_ACCESSIBLE_ROLE_TREE_ITEM", "75"),
    ("(gint) GTK_ACCESSIBLE_ROLE_WIDGET", "76"),
    ("(gint) GTK_ACCESSIBLE_ROLE_WINDOW", "77"),
    ("(gint) GTK_ACCESSIBLE_SORT_ASCENDING", "1"),
    ("(gint) GTK_ACCESSIBLE_SORT_DESCENDING", "2"),
    ("(gint) GTK_ACCESSIBLE_SORT_NONE", "0"),
    ("(gint) GTK_ACCESSIBLE_SORT_OTHER", "3"),
    ("(gint) GTK_ACCESSIBLE_STATE_BUSY", "0"),
    ("(gint) GTK_ACCESSIBLE_STATE_CHECKED", "1"),
    ("(gint) GTK_ACCESSIBLE_STATE_DISABLED", "2"),
    ("(gint) GTK_ACCESSIBLE_STATE_EXPANDED", "3"),
    ("(gint) GTK_ACCESSIBLE_STATE_HIDDEN", "4"),
    ("(gint) GTK_ACCESSIBLE_STATE_INVALID", "5"),
    ("(gint) GTK_ACCESSIBLE_STATE_PRESSED", "6"),
    ("(gint) GTK_ACCESSIBLE_STATE_SELECTED", "7"),
    ("(gint) GTK_ACCESSIBLE_STATE_VISITED", "8"),
    ("(gint) GTK_ACCESSIBLE_TRISTATE_FALSE", "0"),
    ("(gint) GTK_ACCESSIBLE_TRISTATE_MIXED", "2"),
    ("(gint) GTK_ACCESSIBLE_TRISTATE_TRUE", "1"),
    ("GTK_ACCESSIBLE_VALUE_UNDEFINED", "-1"),
    ("(gint) GTK_ALIGN_BASELINE", "4"),
    ("(gint) GTK_ALIGN_BASELINE_CENTER", "5"),
    ("(gint) GTK_ALIGN_BASELINE_FILL", "4"),
    ("(gint) GTK_ALIGN_CENTER", "3"),
    ("(gint) GTK_ALIGN_END", "2"),
    ("(gint) GTK_ALIGN_FILL", "0"),
    ("(gint) GTK_ALIGN_START", "1"),
    ("(guint) GTK_APPLICATION_INHIBIT_IDLE", "8"),
    ("(guint) GTK_APPLICATION_INHIBIT_LOGOUT", "1"),
    ("(guint) GTK_APPLICATION_INHIBIT_SUSPEND", "4"),
    ("(guint) GTK_APPLICATION_INHIBIT_SWITCH", "2"),
    ("(gint) GTK_ARROW_DOWN", "1"),
    ("(gint) GTK_ARROW_LEFT", "2"),
    ("(gint) GTK_ARROW_NONE", "4"),
    ("(gint) GTK_ARROW_RIGHT", "3"),
    ("(gint) GTK_ARROW_UP", "0"),
    ("(gint) GTK_ASSISTANT_PAGE_CONFIRM", "2"),
    ("(gint) GTK_ASSISTANT_PAGE_CONTENT", "0"),
    ("(gint) GTK_ASSISTANT_PAGE_CUSTOM", "5"),
    ("(gint) GTK_ASSISTANT_PAGE_INTRO", "1"),
    ("(gint) GTK_ASSISTANT_PAGE_PROGRESS", "4"),
    ("(gint) GTK_ASSISTANT_PAGE_SUMMARY", "3"),
    ("(gint) GTK_BASELINE_POSITION_BOTTOM", "2"),
    ("(gint) GTK_BASELINE_POSITION_CENTER", "1"),
    ("(gint) GTK_BASELINE_POSITION_TOP", "0"),
    ("(gint) GTK_BORDER_STYLE_DASHED", "6"),
    ("(gint) GTK_BORDER_STYLE_DOTTED", "5"),
    ("(gint) GTK_BORDER_STYLE_DOUBLE", "7"),
    ("(gint) GTK_BORDER_STYLE_GROOVE", "8"),
    ("(gint) GTK_BORDER_STYLE_HIDDEN", "1"),
    ("(gint) GTK_BORDER_STYLE_INSET", "3"),
    ("(gint) GTK_BORDER_STYLE_NONE", "0"),
    ("(gint) GTK_BORDER_STYLE_OUTSET", "4"),
    ("(gint) GTK_BORDER_STYLE_RIDGE", "9"),
    ("(gint) GTK_BORDER_STYLE_SOLID", "2"),
    ("(guint) GTK_BUILDER_CLOSURE_SWAPPED", "1"),
    ("(gint) GTK_BUILDER_ERROR_DUPLICATE_ID", "8"),
    ("(gint) GTK_BUILDER_ERROR_INVALID_ATTRIBUTE", "3"),
    ("(gint) GTK_BUILDER_ERROR_INVALID_FUNCTION", "14"),
    ("(gint) GTK_BUILDER_ERROR_INVALID_ID", "13"),
    ("(gint) GTK_BUILDER_ERROR_INVALID_PROPERTY", "11"),
    ("(gint) GTK_BUILDER_ERROR_INVALID_SIGNAL", "12"),
    ("(gint) GTK_BUILDER_ERROR_INVALID_TAG", "4"),
    ("(gint) GTK_BUILDER_ERROR_INVALID_TYPE_FUNCTION", "0"),
    ("(gint) GTK_BUILDER_ERROR_INVALID_VALUE", "6"),
    ("(gint) GTK_BUILDER_ERROR_MISSING_ATTRIBUTE", "2"),
    ("(gint) GTK_BUILDER_ERROR_MISSING_PROPERTY_VALUE", "5"),
    ("(gint) GTK_BUILDER_ERROR_OBJECT_TYPE_REFUSED", "9"),
    ("(gint) GTK_BUILDER_ERROR_TEMPLATE_MISMATCH", "10"),
    ("(gint) GTK_BUILDER_ERROR_UNHANDLED_TAG", "1"),
    ("(gint) GTK_BUILDER_ERROR_VERSION_MISMATCH", "7"),
    ("(gint) GTK_BUTTONS_CANCEL", "3"),
    ("(gint) GTK_BUTTONS_CLOSE", "2"),
    ("(gint) GTK_BUTTONS_NONE", "0"),
    ("(gint) GTK_BUTTONS_OK", "1"),
    ("(gint) GTK_BUTTONS_OK_CANCEL", "5"),
    ("(gint) GTK_BUTTONS_YES_NO", "4"),
    ("(gint) GTK_CELL_RENDERER_ACCEL_MODE_GTK", "0"),
    ("(gint) GTK_CELL_RENDERER_ACCEL_MODE_OTHER", "1"),
    ("(guint) GTK_CELL_RENDERER_EXPANDABLE", "32"),
    ("(guint) GTK_CELL_RENDERER_EXPANDED", "64"),
    ("(guint) GTK_CELL_RENDERER_FOCUSED", "16"),
    ("(guint) GTK_CELL_RENDERER_INSENSITIVE", "4"),
    ("(gint) GTK_CELL_RENDERER_MODE_ACTIVATABLE", "1"),
    ("(gint) GTK_CELL_RENDERER_MODE_EDITABLE", "2"),
    ("(gint) GTK_CELL_RENDERER_MODE_INERT", "0"),
    ("(guint) GTK_CELL_RENDERER_PRELIT", "2"),
    ("(guint) GTK_CELL_RENDERER_SELECTED", "1"),
    ("(guint) GTK_CELL_RENDERER_SORTED", "8"),
    ("(gint) GTK_COLLATION_FILENAME", "2"),
    ("(gint) GTK_COLLATION_NONE", "0"),
    ("(gint) GTK_COLLATION_UNICODE", "1"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_BASELINE", "11"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_BOTTOM", "4"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_CENTER_X", "9"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_CENTER_Y", "10"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_END", "6"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_HEIGHT", "8"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_LEFT", "1"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_NONE", "0"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_RIGHT", "2"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_START", "5"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_TOP", "3"),
    ("(gint) GTK_CONSTRAINT_ATTRIBUTE_WIDTH", "7"),
    ("(gint) GTK_CONSTRAINT_RELATION_EQ", "0"),
    ("(gint) GTK_CONSTRAINT_RELATION_GE", "1"),
    ("(gint) GTK_CONSTRAINT_RELATION_LE", "-1"),
    ("(gint) GTK_CONSTRAINT_STRENGTH_MEDIUM", "1000"),
    ("(gint) GTK_CONSTRAINT_STRENGTH_REQUIRED", "1001001000"),
    ("(gint) GTK_CONSTRAINT_STRENGTH_STRONG", "1000000000"),
    ("(gint) GTK_CONSTRAINT_STRENGTH_WEAK", "1"),
    (
        "(gint) GTK_CONSTRAINT_VFL_PARSER_ERROR_INVALID_ATTRIBUTE",
        "1",
    ),
    ("(gint) GTK_CONSTRAINT_VFL_PARSER_ERROR_INVALID_METRIC", "3"),
    (
        "(gint) GTK_CONSTRAINT_VFL_PARSER_ERROR_INVALID_PRIORITY",
        "4",
    ),
    (
        "(gint) GTK_CONSTRAINT_VFL_PARSER_ERROR_INVALID_RELATION",
        "5",
    ),
    ("(gint) GTK_CONSTRAINT_VFL_PARSER_ERROR_INVALID_SYMBOL", "0"),
    ("(gint) GTK_CONSTRAINT_VFL_PARSER_ERROR_INVALID_VIEW", "2"),
    ("(gint) GTK_CONTENT_FIT_CONTAIN", "1"),
    ("(gint) GTK_CONTENT_FIT_COVER", "2"),
    ("(gint) GTK_CONTENT_FIT_FILL", "0"),
    ("(gint) GTK_CONTENT_FIT_SCALE_DOWN", "3"),
    ("(gint) GTK_CORNER_BOTTOM_LEFT", "1"),
    ("(gint) GTK_CORNER_BOTTOM_RIGHT", "3"),
    ("(gint) GTK_CORNER_TOP_LEFT", "0"),
    ("(gint) GTK_CORNER_TOP_RIGHT", "2"),
    ("(gint) GTK_CSS_PARSER_ERROR_FAILED", "0"),
    ("(gint) GTK_CSS_PARSER_ERROR_IMPORT", "2"),
    ("(gint) GTK_CSS_PARSER_ERROR_NAME", "3"),
    ("(gint) GTK_CSS_PARSER_ERROR_SYNTAX", "1"),
    ("(gint) GTK_CSS_PARSER_ERROR_UNKNOWN_VALUE", "4"),
    ("(gint) GTK_CSS_PARSER_WARNING_DEPRECATED", "0"),
    ("(gint) GTK_CSS_PARSER_WARNING_SYNTAX", "1"),
    ("(gint) GTK_CSS_PARSER_WARNING_UNIMPLEMENTED", "2"),
    ("(guint) GTK_DEBUG_A11Y", "131072"),
    ("(guint) GTK_DEBUG_ACTIONS", "4096"),
    ("(guint) GTK_DEBUG_BUILDER", "128"),
    ("(guint) GTK_DEBUG_BUILDER_OBJECTS", "65536"),
    ("(guint) GTK_DEBUG_CONSTRAINTS", "32768"),
    ("(guint) GTK_DEBUG_GEOMETRY", "16"),
    ("(guint) GTK_DEBUG_ICONFALLBACK", "262144"),
    ("(guint) GTK_DEBUG_ICONTHEME", "32"),
    ("(guint) GTK_DEBUG_INTERACTIVE", "1024"),
    ("(guint) GTK_DEBUG_INVERT_TEXT_DIR", "524288"),
    ("(guint) GTK_DEBUG_KEYBINDINGS", "4"),
    ("(guint) GTK_DEBUG_LAYOUT", "8192"),
    ("(guint) GTK_DEBUG_MODULES", "8"),
    ("(guint) GTK_DEBUG_NO_CSS_CACHE", "512"),
    ("(guint) GTK_DEBUG_PRINTING", "64"),
    ("(guint) GTK_DEBUG_SIZE_REQUEST", "256"),
    ("(guint) GTK_DEBUG_SNAPSHOT", "16384"),
    ("(guint) GTK_DEBUG_TEXT", "1"),
    ("(guint) GTK_DEBUG_TOUCHSCREEN", "2048"),
    ("(guint) GTK_DEBUG_TREE", "2"),
    ("(gint) GTK_DELETE_CHARS", "0"),
    ("(gint) GTK_DELETE_DISPLAY_LINES", "3"),
    ("(gint) GTK_DELETE_DISPLAY_LINE_ENDS", "4"),
    ("(gint) GTK_DELETE_PARAGRAPHS", "6"),
    ("(gint) GTK_DELETE_PARAGRAPH_ENDS", "5"),
    ("(gint) GTK_DELETE_WHITESPACE", "7"),
    ("(gint) GTK_DELETE_WORDS", "2"),
    ("(gint) GTK_DELETE_WORD_ENDS", "1"),
    ("(guint) GTK_DIALOG_DESTROY_WITH_PARENT", "2"),
    ("(gint) GTK_DIALOG_ERROR_CANCELLED", "1"),
    ("(gint) GTK_DIALOG_ERROR_DISMISSED", "2"),
    ("(gint) GTK_DIALOG_ERROR_FAILED", "0"),
    ("(guint) GTK_DIALOG_MODAL", "1"),
    ("(guint) GTK_DIALOG_USE_HEADER_BAR", "4"),
    ("(gint) GTK_DIR_DOWN", "3"),
    ("(gint) GTK_DIR_LEFT", "4"),
    ("(gint) GTK_DIR_RIGHT", "5"),
    ("(gint) GTK_DIR_TAB_BACKWARD", "1"),
    ("(gint) GTK_DIR_TAB_FORWARD", "0"),
    ("(gint) GTK_DIR_UP", "2"),
    ("(gint) GTK_EDITABLE_NUM_PROPERTIES", "8"),
    ("(gint) GTK_EDITABLE_PROP_CURSOR_POSITION", "1"),
    ("(gint) GTK_EDITABLE_PROP_EDITABLE", "3"),
    ("(gint) GTK_EDITABLE_PROP_ENABLE_UNDO", "7"),
    ("(gint) GTK_EDITABLE_PROP_MAX_WIDTH_CHARS", "5"),
    ("(gint) GTK_EDITABLE_PROP_SELECTION_BOUND", "2"),
    ("(gint) GTK_EDITABLE_PROP_TEXT", "0"),
    ("(gint) GTK_EDITABLE_PROP_WIDTH_CHARS", "4"),
    ("(gint) GTK_EDITABLE_PROP_XALIGN", "6"),
    ("(gint) GTK_ENTRY_ICON_PRIMARY", "0"),
    ("(gint) GTK_ENTRY_ICON_SECONDARY", "1"),
    ("(guint) GTK_EVENT_CONTROLLER_SCROLL_BOTH_AXES", "3"),
    ("(guint) GTK_EVENT_CONTROLLER_SCROLL_DISCRETE", "4"),
    ("(guint) GTK_EVENT_CONTROLLER_SCROLL_HORIZONTAL", "2"),
    ("(guint) GTK_EVENT_CONTROLLER_SCROLL_KINETIC", "8"),
    ("(guint) GTK_EVENT_CONTROLLER_SCROLL_NONE", "0"),
    ("(guint) GTK_EVENT_CONTROLLER_SCROLL_VERTICAL", "1"),
    ("(gint) GTK_EVENT_SEQUENCE_CLAIMED", "1"),
    ("(gint) GTK_EVENT_SEQUENCE_DENIED", "2"),
    ("(gint) GTK_EVENT_SEQUENCE_NONE", "0"),
    ("(gint) GTK_FILE_CHOOSER_ACTION_OPEN", "0"),
    ("(gint) GTK_FILE_CHOOSER_ACTION_SAVE", "1"),
    ("(gint) GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER", "2"),
    ("(gint) GTK_FILE_CHOOSER_ERROR_ALREADY_EXISTS", "2"),
    ("(gint) GTK_FILE_CHOOSER_ERROR_BAD_FILENAME", "1"),
    ("(gint) GTK_FILE_CHOOSER_ERROR_INCOMPLETE_HOSTNAME", "3"),
    ("(gint) GTK_FILE_CHOOSER_ERROR_NONEXISTENT", "0"),
    ("(gint) GTK_FILTER_CHANGE_DIFFERENT", "0"),
    ("(gint) GTK_FILTER_CHANGE_LESS_STRICT", "1"),
    ("(gint) GTK_FILTER_CHANGE_MORE_STRICT", "2"),
    ("(gint) GTK_FILTER_MATCH_ALL", "2"),
    ("(gint) GTK_FILTER_MATCH_NONE", "1"),
    ("(gint) GTK_FILTER_MATCH_SOME", "0"),
    ("(guint) GTK_FONT_CHOOSER_LEVEL_FAMILY", "0"),
    ("(guint) GTK_FONT_CHOOSER_LEVEL_FEATURES", "8"),
    ("(guint) GTK_FONT_CHOOSER_LEVEL_SIZE", "2"),
    ("(guint) GTK_FONT_CHOOSER_LEVEL_STYLE", "1"),
    ("(guint) GTK_FONT_CHOOSER_LEVEL_VARIATIONS", "4"),
    ("(gint) GTK_FONT_LEVEL_FACE", "1"),
    ("(gint) GTK_FONT_LEVEL_FAMILY", "0"),
    ("(gint) GTK_FONT_LEVEL_FEATURES", "3"),
    ("(gint) GTK_FONT_LEVEL_FONT", "2"),
    ("(guint) GTK_ICON_LOOKUP_FORCE_REGULAR", "1"),
    ("(guint) GTK_ICON_LOOKUP_FORCE_SYMBOLIC", "2"),
    ("(guint) GTK_ICON_LOOKUP_PRELOAD", "4"),
    ("(gint) GTK_ICON_SIZE_INHERIT", "0"),
    ("(gint) GTK_ICON_SIZE_LARGE", "2"),
    ("(gint) GTK_ICON_SIZE_NORMAL", "1"),
    ("(gint) GTK_ICON_THEME_FAILED", "1"),
    ("(gint) GTK_ICON_THEME_NOT_FOUND", "0"),
    ("(gint) GTK_ICON_VIEW_DROP_ABOVE", "4"),
    ("(gint) GTK_ICON_VIEW_DROP_BELOW", "5"),
    ("(gint) GTK_ICON_VIEW_DROP_INTO", "1"),
    ("(gint) GTK_ICON_VIEW_DROP_LEFT", "2"),
    ("(gint) GTK_ICON_VIEW_DROP_RIGHT", "3"),
    ("(gint) GTK_ICON_VIEW_NO_DROP", "0"),
    ("(gint) GTK_IMAGE_EMPTY", "0"),
    ("(gint) GTK_IMAGE_GICON", "2"),
    ("(gint) GTK_IMAGE_ICON_NAME", "1"),
    ("(gint) GTK_IMAGE_PAINTABLE", "3"),
    ("GTK_IM_MODULE_EXTENSION_POINT_NAME", "gtk-im-module"),
    ("GTK_INPUT_ERROR", "-1"),
    ("(guint) GTK_INPUT_HINT_EMOJI", "512"),
    ("(guint) GTK_INPUT_HINT_INHIBIT_OSK", "128"),
    ("(guint) GTK_INPUT_HINT_LOWERCASE", "8"),
    ("(guint) GTK_INPUT_HINT_NONE", "0"),
    ("(guint) GTK_INPUT_HINT_NO_EMOJI", "1024"),
    ("(guint) GTK_INPUT_HINT_NO_SPELLCHECK", "2"),
    ("(guint) GTK_INPUT_HINT_PRIVATE", "2048"),
    ("(guint) GTK_INPUT_HINT_SPELLCHECK", "1"),
    ("(guint) GTK_INPUT_HINT_UPPERCASE_CHARS", "16"),
    ("(guint) GTK_INPUT_HINT_UPPERCASE_SENTENCES", "64"),
    ("(guint) GTK_INPUT_HINT_UPPERCASE_WORDS", "32"),
    ("(guint) GTK_INPUT_HINT_VERTICAL_WRITING", "256"),
    ("(guint) GTK_INPUT_HINT_WORD_COMPLETION", "4"),
    ("(gint) GTK_INPUT_PURPOSE_ALPHA", "1"),
    ("(gint) GTK_INPUT_PURPOSE_DIGITS", "2"),
    ("(gint) GTK_INPUT_PURPOSE_EMAIL", "6"),
    ("(gint) GTK_INPUT_PURPOSE_FREE_FORM", "0"),
    ("(gint) GTK_INPUT_PURPOSE_NAME", "7"),
    ("(gint) GTK_INPUT_PURPOSE_NUMBER", "3"),
    ("(gint) GTK_INPUT_PURPOSE_PASSWORD", "8"),
    ("(gint) GTK_INPUT_PURPOSE_PHONE", "4"),
    ("(gint) GTK_INPUT_PURPOSE_PIN", "9"),
    ("(gint) GTK_INPUT_PURPOSE_TERMINAL", "10"),
    ("(gint) GTK_INPUT_PURPOSE_URL", "5"),
    ("(gint) GTK_INSCRIPTION_OVERFLOW_CLIP", "0"),
    ("(gint) GTK_INSCRIPTION_OVERFLOW_ELLIPSIZE_END", "3"),
    ("(gint) GTK_INSCRIPTION_OVERFLOW_ELLIPSIZE_MIDDLE", "2"),
    ("(gint) GTK_INSCRIPTION_OVERFLOW_ELLIPSIZE_START", "1"),
    ("GTK_INVALID_LIST_POSITION", "4294967295"),
    ("(gint) GTK_JUSTIFY_CENTER", "2"),
    ("(gint) GTK_JUSTIFY_FILL", "3"),
    ("(gint) GTK_JUSTIFY_LEFT", "0"),
    ("(gint) GTK_JUSTIFY_RIGHT", "1"),
    ("(gint) GTK_LEVEL_BAR_MODE_CONTINUOUS", "0"),
    ("(gint) GTK_LEVEL_BAR_MODE_DISCRETE", "1"),
    ("GTK_LEVEL_BAR_OFFSET_FULL", "full"),
    ("GTK_LEVEL_BAR_OFFSET_HIGH", "high"),
    ("GTK_LEVEL_BAR_OFFSET_LOW", "low"),
    ("(gint) GTK_LICENSE_AGPL_3_0", "13"),
    ("(gint) GTK_LICENSE_AGPL_3_0_ONLY", "14"),
    ("(gint) GTK_LICENSE_APACHE_2_0", "16"),
    ("(gint) GTK_LICENSE_ARTISTIC", "8"),
    ("(gint) GTK_LICENSE_BSD", "6"),
    ("(gint) GTK_LICENSE_BSD_3", "15"),
    ("(gint) GTK_LICENSE_CUSTOM", "1"),
    ("(gint) GTK_LICENSE_GPL_2_0", "2"),
    ("(gint) GTK_LICENSE_GPL_2_0_ONLY", "9"),
    ("(gint) GTK_LICENSE_GPL_3_0", "3"),
    ("(gint) GTK_LICENSE_GPL_3_0_ONLY", "10"),
    ("(gint) GTK_LICENSE_LGPL_2_1", "4"),
    ("(gint) GTK_LICENSE_LGPL_2_1_ONLY", "11"),
    ("(gint) GTK_LICENSE_LGPL_3_0", "5"),
    ("(gint) GTK_LICENSE_LGPL_3_0_ONLY", "12"),
    ("(gint) GTK_LICENSE_MIT_X11", "7"),
    ("(gint) GTK_LICENSE_MPL_2_0", "17"),
    ("(gint) GTK_LICENSE_UNKNOWN", "0"),
    ("(gint) GTK_LIMIT_NONE", "0"),
    ("(gint) GTK_LIMIT_SAME_NATIVE", "1"),
    ("(gint) GTK_LIST_TAB_ALL", "0"),
    ("(gint) GTK_LIST_TAB_CELL", "2"),
    ("(gint) GTK_LIST_TAB_ITEM", "1"),
    ("GTK_MAX_COMPOSE_LEN", "7"),
    ("GTK_MEDIA_FILE_EXTENSION_POINT_NAME", "gtk-media-file"),
    ("(gint) GTK_MESSAGE_ERROR", "3"),
    ("(gint) GTK_MESSAGE_INFO", "0"),
    ("(gint) GTK_MESSAGE_OTHER", "4"),
    ("(gint) GTK_MESSAGE_QUESTION", "2"),
    ("(gint) GTK_MESSAGE_WARNING", "1"),
    ("(gint) GTK_MOVEMENT_BUFFER_ENDS", "8"),
    ("(gint) GTK_MOVEMENT_DISPLAY_LINES", "3"),
    ("(gint) GTK_MOVEMENT_DISPLAY_LINE_ENDS", "4"),
    ("(gint) GTK_MOVEMENT_HORIZONTAL_PAGES", "9"),
    ("(gint) GTK_MOVEMENT_LOGICAL_POSITIONS", "0"),
    ("(gint) GTK_MOVEMENT_PAGES", "7"),
    ("(gint) GTK_MOVEMENT_PARAGRAPHS", "5"),
    ("(gint) GTK_MOVEMENT_PARAGRAPH_ENDS", "6"),
    ("(gint) GTK_MOVEMENT_VISUAL_POSITIONS", "1"),
    ("(gint) GTK_MOVEMENT_WORDS", "2"),
    ("(gint) GTK_NATURAL_WRAP_INHERIT", "0"),
    ("(gint) GTK_NATURAL_WRAP_NONE", "1"),
    ("(gint) GTK_NATURAL_WRAP_WORD", "2"),
    ("(gint) GTK_NOTEBOOK_TAB_FIRST", "0"),
    ("(gint) GTK_NOTEBOOK_TAB_LAST", "1"),
    (
        "(gint) GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_LEFT_TO_RIGHT",
        "6",
    ),
    (
        "(gint) GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_RIGHT_TO_LEFT",
        "7",
    ),
    (
        "(gint) GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_BOTTOM_TO_TOP",
        "1",
    ),
    (
        "(gint) GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_TOP_TO_BOTTOM",
        "0",
    ),
    (
        "(gint) GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_BOTTOM_TO_TOP",
        "3",
    ),
    (
        "(gint) GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_TOP_TO_BOTTOM",
        "2",
    ),
    (
        "(gint) GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_LEFT_TO_RIGHT",
        "4",
    ),
    (
        "(gint) GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_RIGHT_TO_LEFT",
        "5",
    ),
    ("(gint) GTK_ORDERING_EQUAL", "0"),
    ("(gint) GTK_ORDERING_LARGER", "1"),
    ("(gint) GTK_ORDERING_SMALLER", "-1"),
    ("(gint) GTK_ORIENTATION_HORIZONTAL", "0"),
    ("(gint) GTK_ORIENTATION_VERTICAL", "1"),
    ("(gint) GTK_OVERFLOW_HIDDEN", "1"),
    ("(gint) GTK_OVERFLOW_VISIBLE", "0"),
    ("(gint) GTK_PACK_END", "1"),
    ("(gint) GTK_PACK_START", "0"),
    ("(gint) GTK_PAD_ACTION_BUTTON", "0"),
    ("(gint) GTK_PAD_ACTION_RING", "1"),
    ("(gint) GTK_PAD_ACTION_STRIP", "2"),
    ("(gint) GTK_PAGE_ORIENTATION_LANDSCAPE", "1"),
    ("(gint) GTK_PAGE_ORIENTATION_PORTRAIT", "0"),
    ("(gint) GTK_PAGE_ORIENTATION_REVERSE_LANDSCAPE", "3"),
    ("(gint) GTK_PAGE_ORIENTATION_REVERSE_PORTRAIT", "2"),
    ("(gint) GTK_PAGE_SET_ALL", "0"),
    ("(gint) GTK_PAGE_SET_EVEN", "1"),
    ("(gint) GTK_PAGE_SET_ODD", "2"),
    ("(gint) GTK_PAN_DIRECTION_DOWN", "3"),
    ("(gint) GTK_PAN_DIRECTION_LEFT", "0"),
    ("(gint) GTK_PAN_DIRECTION_RIGHT", "1"),
    ("(gint) GTK_PAN_DIRECTION_UP", "2"),
    ("GTK_PAPER_NAME_A3", "iso_a3"),
    ("GTK_PAPER_NAME_A4", "iso_a4"),
    ("GTK_PAPER_NAME_A5", "iso_a5"),
    ("GTK_PAPER_NAME_B5", "iso_b5"),
    ("GTK_PAPER_NAME_EXECUTIVE", "na_executive"),
    ("GTK_PAPER_NAME_LEGAL", "na_legal"),
    ("GTK_PAPER_NAME_LETTER", "na_letter"),
    ("(gint) GTK_PHASE_BUBBLE", "2"),
    ("(gint) GTK_PHASE_CAPTURE", "1"),
    ("(gint) GTK_PHASE_NONE", "0"),
    ("(gint) GTK_PHASE_TARGET", "3"),
    ("(guint) GTK_PICK_DEFAULT", "0"),
    ("(guint) GTK_PICK_INSENSITIVE", "1"),
    ("(guint) GTK_PICK_NON_TARGETABLE", "2"),
    ("(gint) GTK_POLICY_ALWAYS", "0"),
    ("(gint) GTK_POLICY_AUTOMATIC", "1"),
    ("(gint) GTK_POLICY_EXTERNAL", "3"),
    ("(gint) GTK_POLICY_NEVER", "2"),
    ("(guint) GTK_POPOVER_MENU_NESTED", "1"),
    ("(gint) GTK_POS_BOTTOM", "3"),
    ("(gint) GTK_POS_LEFT", "0"),
    ("(gint) GTK_POS_RIGHT", "1"),
    ("(gint) GTK_POS_TOP", "2"),
    ("(guint) GTK_PRINT_CAPABILITY_COLLATE", "4"),
    ("(guint) GTK_PRINT_CAPABILITY_COPIES", "2"),
    ("(guint) GTK_PRINT_CAPABILITY_GENERATE_PDF", "32"),
    ("(guint) GTK_PRINT_CAPABILITY_GENERATE_PS", "64"),
    ("(guint) GTK_PRINT_CAPABILITY_NUMBER_UP", "256"),
    ("(guint) GTK_PRINT_CAPABILITY_NUMBER_UP_LAYOUT", "512"),
    ("(guint) GTK_PRINT_CAPABILITY_PAGE_SET", "1"),
    ("(guint) GTK_PRINT_CAPABILITY_PREVIEW", "128"),
    ("(guint) GTK_PRINT_CAPABILITY_REVERSE", "8"),
    ("(guint) GTK_PRINT_CAPABILITY_SCALE", "16"),
    ("(gint) GTK_PRINT_DUPLEX_HORIZONTAL", "1"),
    ("(gint) GTK_PRINT_DUPLEX_SIMPLEX", "0"),
    ("(gint) GTK_PRINT_DUPLEX_VERTICAL", "2"),
    ("(gint) GTK_PRINT_ERROR_GENERAL", "0"),
    ("(gint) GTK_PRINT_ERROR_INTERNAL_ERROR", "1"),
    ("(gint) GTK_PRINT_ERROR_INVALID_FILE", "3"),
    ("(gint) GTK_PRINT_ERROR_NOMEM", "2"),
    ("(gint) GTK_PRINT_OPERATION_ACTION_EXPORT", "3"),
    ("(gint) GTK_PRINT_OPERATION_ACTION_PREVIEW", "2"),
    ("(gint) GTK_PRINT_OPERATION_ACTION_PRINT", "1"),
    ("(gint) GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG", "0"),
    ("(gint) GTK_PRINT_OPERATION_RESULT_APPLY", "1"),
    ("(gint) GTK_PRINT_OPERATION_RESULT_CANCEL", "2"),
    ("(gint) GTK_PRINT_OPERATION_RESULT_ERROR", "0"),
    ("(gint) GTK_PRINT_OPERATION_RESULT_IN_PROGRESS", "3"),
    ("(gint) GTK_PRINT_PAGES_ALL", "0"),
    ("(gint) GTK_PRINT_PAGES_CURRENT", "1"),
    ("(gint) GTK_PRINT_PAGES_RANGES", "2"),
    ("(gint) GTK_PRINT_PAGES_SELECTION", "3"),
    ("(gint) GTK_PRINT_QUALITY_DRAFT", "3"),
    ("(gint) GTK_PRINT_QUALITY_HIGH", "2"),
    ("(gint) GTK_PRINT_QUALITY_LOW", "0"),
    ("(gint) GTK_PRINT_QUALITY_NORMAL", "1"),
    ("GTK_PRINT_SETTINGS_COLLATE", "collate"),
    ("GTK_PRINT_SETTINGS_DEFAULT_SOURCE", "default-source"),
    ("GTK_PRINT_SETTINGS_DITHER", "dither"),
    ("GTK_PRINT_SETTINGS_DUPLEX", "duplex"),
    ("GTK_PRINT_SETTINGS_FINISHINGS", "finishings"),
    ("GTK_PRINT_SETTINGS_MEDIA_TYPE", "media-type"),
    ("GTK_PRINT_SETTINGS_NUMBER_UP", "number-up"),
    ("GTK_PRINT_SETTINGS_NUMBER_UP_LAYOUT", "number-up-layout"),
    ("GTK_PRINT_SETTINGS_N_COPIES", "n-copies"),
    ("GTK_PRINT_SETTINGS_ORIENTATION", "orientation"),
    ("GTK_PRINT_SETTINGS_OUTPUT_BASENAME", "output-basename"),
    ("GTK_PRINT_SETTINGS_OUTPUT_BIN", "output-bin"),
    ("GTK_PRINT_SETTINGS_OUTPUT_DIR", "output-dir"),
    (
        "GTK_PRINT_SETTINGS_OUTPUT_FILE_FORMAT",
        "output-file-format",
    ),
    ("GTK_PRINT_SETTINGS_OUTPUT_URI", "output-uri"),
    ("GTK_PRINT_SETTINGS_PAGE_RANGES", "page-ranges"),
    ("GTK_PRINT_SETTINGS_PAGE_SET", "page-set"),
    ("GTK_PRINT_SETTINGS_PAPER_FORMAT", "paper-format"),
    ("GTK_PRINT_SETTINGS_PAPER_HEIGHT", "paper-height"),
    ("GTK_PRINT_SETTINGS_PAPER_WIDTH", "paper-width"),
    ("GTK_PRINT_SETTINGS_PRINTER", "printer"),
    ("GTK_PRINT_SETTINGS_PRINTER_LPI", "printer-lpi"),
    ("GTK_PRINT_SETTINGS_PRINT_PAGES", "print-pages"),
    ("GTK_PRINT_SETTINGS_QUALITY", "quality"),
    ("GTK_PRINT_SETTINGS_RESOLUTION", "resolution"),
    ("GTK_PRINT_SETTINGS_RESOLUTION_X", "resolution-x"),
    ("GTK_PRINT_SETTINGS_RESOLUTION_Y", "resolution-y"),
    ("GTK_PRINT_SETTINGS_REVERSE", "reverse"),
    ("GTK_PRINT_SETTINGS_SCALE", "scale"),
    ("GTK_PRINT_SETTINGS_USE_COLOR", "use-color"),
    (
        "GTK_PRINT_SETTINGS_WIN32_DRIVER_EXTRA",
        "win32-driver-extra",
    ),
    (
        "GTK_PRINT_SETTINGS_WIN32_DRIVER_VERSION",
        "win32-driver-version",
    ),
    ("(gint) GTK_PRINT_STATUS_FINISHED", "7"),
    ("(gint) GTK_PRINT_STATUS_FINISHED_ABORTED", "8"),
    ("(gint) GTK_PRINT_STATUS_GENERATING_DATA", "2"),
    ("(gint) GTK_PRINT_STATUS_INITIAL", "0"),
    ("(gint) GTK_PRINT_STATUS_PENDING", "4"),
    ("(gint) GTK_PRINT_STATUS_PENDING_ISSUE", "5"),
    ("(gint) GTK_PRINT_STATUS_PREPARING", "1"),
    ("(gint) GTK_PRINT_STATUS_PRINTING", "6"),
    ("(gint) GTK_PRINT_STATUS_SENDING_DATA", "3"),
    ("GTK_PRIORITY_RESIZE", "110"),
    ("(gint) GTK_RECENT_MANAGER_ERROR_INVALID_ENCODING", "2"),
    ("(gint) GTK_RECENT_MANAGER_ERROR_INVALID_URI", "1"),
    ("(gint) GTK_RECENT_MANAGER_ERROR_NOT_FOUND", "0"),
    ("(gint) GTK_RECENT_MANAGER_ERROR_NOT_REGISTERED", "3"),
    ("(gint) GTK_RECENT_MANAGER_ERROR_READ", "4"),
    ("(gint) GTK_RECENT_MANAGER_ERROR_UNKNOWN", "6"),
    ("(gint) GTK_RECENT_MANAGER_ERROR_WRITE", "5"),
    ("(gint) GTK_RESPONSE_ACCEPT", "-3"),
    ("(gint) GTK_RESPONSE_APPLY", "-10"),
    ("(gint) GTK_RESPONSE_CANCEL", "-6"),
    ("(gint) GTK_RESPONSE_CLOSE", "-7"),
    ("(gint) GTK_RESPONSE_DELETE_EVENT", "-4"),
    ("(gint) GTK_RESPONSE_HELP", "-11"),
    ("(gint) GTK_RESPONSE_NO", "-9"),
    ("(gint) GTK_RESPONSE_NONE", "-1"),
    ("(gint) GTK_RESPONSE_OK", "-5"),
    ("(gint) GTK_RESPONSE_REJECT", "-2"),
    ("(gint) GTK_RESPONSE_YES", "-8"),
    ("(gint) GTK_REVEALER_TRANSITION_TYPE_CROSSFADE", "1"),
    ("(gint) GTK_REVEALER_TRANSITION_TYPE_NONE", "0"),
    ("(gint) GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN", "5"),
    ("(gint) GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT", "3"),
    ("(gint) GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT", "2"),
    ("(gint) GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP", "4"),
    ("(gint) GTK_REVEALER_TRANSITION_TYPE_SWING_DOWN", "9"),
    ("(gint) GTK_REVEALER_TRANSITION_TYPE_SWING_LEFT", "7"),
    ("(gint) GTK_REVEALER_TRANSITION_TYPE_SWING_RIGHT", "6"),
    ("(gint) GTK_REVEALER_TRANSITION_TYPE_SWING_UP", "8"),
    ("(gint) GTK_SCROLL_END", "15"),
    ("(gint) GTK_SCROLL_ENDS", "2"),
    ("(gint) GTK_SCROLL_HORIZONTAL_ENDS", "5"),
    ("(gint) GTK_SCROLL_HORIZONTAL_PAGES", "4"),
    ("(gint) GTK_SCROLL_HORIZONTAL_STEPS", "3"),
    ("(gint) GTK_SCROLL_JUMP", "1"),
    ("(gint) GTK_SCROLL_MINIMUM", "0"),
    ("(gint) GTK_SCROLL_NATURAL", "1"),
    ("(gint) GTK_SCROLL_NONE", "0"),
    ("(gint) GTK_SCROLL_PAGES", "1"),
    ("(gint) GTK_SCROLL_PAGE_BACKWARD", "4"),
    ("(gint) GTK_SCROLL_PAGE_DOWN", "9"),
    ("(gint) GTK_SCROLL_PAGE_FORWARD", "5"),
    ("(gint) GTK_SCROLL_PAGE_LEFT", "12"),
    ("(gint) GTK_SCROLL_PAGE_RIGHT", "13"),
    ("(gint) GTK_SCROLL_PAGE_UP", "8"),
    ("(gint) GTK_SCROLL_START", "14"),
    ("(gint) GTK_SCROLL_STEPS", "0"),
    ("(gint) GTK_SCROLL_STEP_BACKWARD", "2"),
    ("(gint) GTK_SCROLL_STEP_DOWN", "7"),
    ("(gint) GTK_SCROLL_STEP_FORWARD", "3"),
    ("(gint) GTK_SCROLL_STEP_LEFT", "10"),
    ("(gint) GTK_SCROLL_STEP_RIGHT", "11"),
    ("(gint) GTK_SCROLL_STEP_UP", "6"),
    ("(gint) GTK_SELECTION_BROWSE", "2"),
    ("(gint) GTK_SELECTION_MULTIPLE", "3"),
    ("(gint) GTK_SELECTION_NONE", "0"),
    ("(gint) GTK_SELECTION_SINGLE", "1"),
    ("(gint) GTK_SENSITIVITY_AUTO", "0"),
    ("(gint) GTK_SENSITIVITY_OFF", "2"),
    ("(gint) GTK_SENSITIVITY_ON", "1"),
    ("(gint) GTK_SHORTCUT_ACCELERATOR", "0"),
    ("(guint) GTK_SHORTCUT_ACTION_EXCLUSIVE", "1"),
    ("(gint) GTK_SHORTCUT_GESTURE", "7"),
    ("(gint) GTK_SHORTCUT_GESTURE_PINCH", "1"),
    ("(gint) GTK_SHORTCUT_GESTURE_ROTATE_CLOCKWISE", "3"),
    ("(gint) GTK_SHORTCUT_GESTURE_ROTATE_COUNTERCLOCKWISE", "4"),
    ("(gint) GTK_SHORTCUT_GESTURE_STRETCH", "2"),
    ("(gint) GTK_SHORTCUT_GESTURE_SWIPE_LEFT", "8"),
    ("(gint) GTK_SHORTCUT_GESTURE_SWIPE_RIGHT", "9"),
    ("(gint) GTK_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_LEFT", "5"),
    ("(gint) GTK_SHORTCUT_GESTURE_TWO_FINGER_SWIPE_RIGHT", "6"),
    ("(gint) GTK_SHORTCUT_SCOPE_GLOBAL", "2"),
    ("(gint) GTK_SHORTCUT_SCOPE_LOCAL", "0"),
    ("(gint) GTK_SHORTCUT_SCOPE_MANAGED", "1"),
    ("(gint) GTK_SIZE_GROUP_BOTH", "3"),
    ("(gint) GTK_SIZE_GROUP_HORIZONTAL", "1"),
    ("(gint) GTK_SIZE_GROUP_NONE", "0"),
    ("(gint) GTK_SIZE_GROUP_VERTICAL", "2"),
    ("(gint) GTK_SIZE_REQUEST_CONSTANT_SIZE", "2"),
    ("(gint) GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH", "0"),
    ("(gint) GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT", "1"),
    ("(gint) GTK_SORTER_CHANGE_DIFFERENT", "0"),
    ("(gint) GTK_SORTER_CHANGE_INVERTED", "1"),
    ("(gint) GTK_SORTER_CHANGE_LESS_STRICT", "2"),
    ("(gint) GTK_SORTER_CHANGE_MORE_STRICT", "3"),
    ("(gint) GTK_SORTER_ORDER_NONE", "1"),
    ("(gint) GTK_SORTER_ORDER_PARTIAL", "0"),
    ("(gint) GTK_SORTER_ORDER_TOTAL", "2"),
    ("(gint) GTK_SORT_ASCENDING", "0"),
    ("(gint) GTK_SORT_DESCENDING", "1"),
    ("(gint) GTK_SPIN_END", "5"),
    ("(gint) GTK_SPIN_HOME", "4"),
    ("(gint) GTK_SPIN_PAGE_BACKWARD", "3"),
    ("(gint) GTK_SPIN_PAGE_FORWARD", "2"),
    ("(gint) GTK_SPIN_STEP_BACKWARD", "1"),
    ("(gint) GTK_SPIN_STEP_FORWARD", "0"),
    ("(gint) GTK_SPIN_USER_DEFINED", "6"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_CROSSFADE", "1"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_NONE", "0"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_OVER_DOWN", "9"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_OVER_DOWN_UP", "17"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_OVER_LEFT", "10"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_OVER_LEFT_RIGHT", "18"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_OVER_RIGHT", "11"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_OVER_RIGHT_LEFT", "19"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_OVER_UP", "8"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_OVER_UP_DOWN", "16"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_ROTATE_LEFT", "20"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_ROTATE_LEFT_RIGHT", "22"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_ROTATE_RIGHT", "21"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN", "5"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT", "3"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT", "6"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT", "2"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_SLIDE_UP", "4"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_SLIDE_UP_DOWN", "7"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_UNDER_DOWN", "13"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_UNDER_LEFT", "14"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_UNDER_RIGHT", "15"),
    ("(gint) GTK_STACK_TRANSITION_TYPE_UNDER_UP", "12"),
    ("(guint) GTK_STATE_FLAG_ACTIVE", "1"),
    ("(guint) GTK_STATE_FLAG_BACKDROP", "64"),
    ("(guint) GTK_STATE_FLAG_CHECKED", "2048"),
    ("(guint) GTK_STATE_FLAG_DIR_LTR", "128"),
    ("(guint) GTK_STATE_FLAG_DIR_RTL", "256"),
    ("(guint) GTK_STATE_FLAG_DROP_ACTIVE", "4096"),
    ("(guint) GTK_STATE_FLAG_FOCUSED", "32"),
    ("(guint) GTK_STATE_FLAG_FOCUS_VISIBLE", "8192"),
    ("(guint) GTK_STATE_FLAG_FOCUS_WITHIN", "16384"),
    ("(guint) GTK_STATE_FLAG_INCONSISTENT", "16"),
    ("(guint) GTK_STATE_FLAG_INSENSITIVE", "8"),
    ("(guint) GTK_STATE_FLAG_LINK", "512"),
    ("(guint) GTK_STATE_FLAG_NORMAL", "0"),
    ("(guint) GTK_STATE_FLAG_PRELIGHT", "2"),
    ("(guint) GTK_STATE_FLAG_SELECTED", "4"),
    ("(guint) GTK_STATE_FLAG_VISITED", "1024"),
    ("(gint) GTK_STRING_FILTER_MATCH_MODE_EXACT", "0"),
    ("(gint) GTK_STRING_FILTER_MATCH_MODE_PREFIX", "2"),
    ("(gint) GTK_STRING_FILTER_MATCH_MODE_SUBSTRING", "1"),
    ("(guint) GTK_STYLE_CONTEXT_PRINT_NONE", "0"),
    ("(guint) GTK_STYLE_CONTEXT_PRINT_RECURSE", "1"),
    ("(guint) GTK_STYLE_CONTEXT_PRINT_SHOW_CHANGE", "4"),
    ("(guint) GTK_STYLE_CONTEXT_PRINT_SHOW_STYLE", "2"),
    ("GTK_STYLE_PROVIDER_PRIORITY_APPLICATION", "600"),
    ("GTK_STYLE_PROVIDER_PRIORITY_FALLBACK", "1"),
    ("GTK_STYLE_PROVIDER_PRIORITY_SETTINGS", "400"),
    ("GTK_STYLE_PROVIDER_PRIORITY_THEME", "200"),
    ("GTK_STYLE_PROVIDER_PRIORITY_USER", "800"),
    ("(gint) GTK_SYMBOLIC_COLOR_ERROR", "1"),
    ("(gint) GTK_SYMBOLIC_COLOR_FOREGROUND", "0"),
    ("(gint) GTK_SYMBOLIC_COLOR_SUCCESS", "3"),
    ("(gint) GTK_SYMBOLIC_COLOR_WARNING", "2"),
    ("(gint) GTK_SYSTEM_SETTING_DISPLAY", "3"),
    ("(gint) GTK_SYSTEM_SETTING_DPI", "0"),
    ("(gint) GTK_SYSTEM_SETTING_FONT_CONFIG", "2"),
    ("(gint) GTK_SYSTEM_SETTING_FONT_NAME", "1"),
    ("(gint) GTK_SYSTEM_SETTING_ICON_THEME", "4"),
    ("(gint) GTK_TEXT_DIR_LTR", "1"),
    ("(gint) GTK_TEXT_DIR_NONE", "0"),
    ("(gint) GTK_TEXT_DIR_RTL", "2"),
    ("(gint) GTK_TEXT_EXTEND_SELECTION_LINE", "1"),
    ("(gint) GTK_TEXT_EXTEND_SELECTION_WORD", "0"),
    ("(guint) GTK_TEXT_SEARCH_CASE_INSENSITIVE", "4"),
    ("(guint) GTK_TEXT_SEARCH_TEXT_ONLY", "2"),
    ("(guint) GTK_TEXT_SEARCH_VISIBLE_ONLY", "1"),
    ("(gint) GTK_TEXT_VIEW_LAYER_ABOVE_TEXT", "1"),
    ("(gint) GTK_TEXT_VIEW_LAYER_BELOW_TEXT", "0"),
    ("GTK_TEXT_VIEW_PRIORITY_VALIDATE", "125"),
    ("(gint) GTK_TEXT_WINDOW_BOTTOM", "6"),
    ("(gint) GTK_TEXT_WINDOW_LEFT", "3"),
    ("(gint) GTK_TEXT_WINDOW_RIGHT", "4"),
    ("(gint) GTK_TEXT_WINDOW_TEXT", "2"),
    ("(gint) GTK_TEXT_WINDOW_TOP", "5"),
    ("(gint) GTK_TEXT_WINDOW_WIDGET", "1"),
    ("(guint) GTK_TREE_MODEL_ITERS_PERSIST", "1"),
    ("(guint) GTK_TREE_MODEL_LIST_ONLY", "2"),
    ("GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID", "-1"),
    ("GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID", "-2"),
    ("(gint) GTK_TREE_VIEW_COLUMN_AUTOSIZE", "1"),
    ("(gint) GTK_TREE_VIEW_COLUMN_FIXED", "2"),
    ("(gint) GTK_TREE_VIEW_COLUMN_GROW_ONLY", "0"),
    ("(gint) GTK_TREE_VIEW_DROP_AFTER", "1"),
    ("(gint) GTK_TREE_VIEW_DROP_BEFORE", "0"),
    ("(gint) GTK_TREE_VIEW_DROP_INTO_OR_AFTER", "3"),
    ("(gint) GTK_TREE_VIEW_DROP_INTO_OR_BEFORE", "2"),
    ("(gint) GTK_TREE_VIEW_GRID_LINES_BOTH", "3"),
    ("(gint) GTK_TREE_VIEW_GRID_LINES_HORIZONTAL", "1"),
    ("(gint) GTK_TREE_VIEW_GRID_LINES_NONE", "0"),
    ("(gint) GTK_TREE_VIEW_GRID_LINES_VERTICAL", "2"),
    ("(gint) GTK_UNIT_INCH", "2"),
    ("(gint) GTK_UNIT_MM", "3"),
    ("(gint) GTK_UNIT_NONE", "0"),
    ("(gint) GTK_UNIT_POINTS", "1"),
    ("(gint) GTK_UPDATE_ALWAYS", "0"),
    ("(gint) GTK_UPDATE_IF_VALID", "1"),
    ("(gint) GTK_WRAP_CHAR", "1"),
    ("(gint) GTK_WRAP_NONE", "0"),
    ("(gint) GTK_WRAP_WORD", "2"),
    ("(gint) GTK_WRAP_WORD_CHAR", "3"),
];
