/* gtkmusic-internals-0.2.vapi generated by valac 0.15.1.5-a0bfe, do not modify. */

namespace GtkMusic {
	[CCode (cheader_filename = "gtkmusic-internals.h")]
	public class GuitarString {
		public string note;
		public bool vibrate;
		public double vibrateSeed;
		public float[] color;
		public float[] labelColor;
		public GuitarString (string note);
	}
	[CCode (cheader_filename = "gtkmusic-internals.h")]
	public class GuitarFretMark {
		public enum Style {
			NONE,
			SOLID_CIRCLE,
			RECTANGLE,
			FANCY
		}
		public ushort position;
		public GtkMusic.GuitarFretMark.Style style;
		public float[] color;
		public GuitarFretMark (ushort position);
	}
	[CCode (cheader_filename = "gtkmusic-internals.h")]
	public class GuitarPosition {
		public ushort stringIndex;
		public ushort fretIndex;
		public GuitarPosition (ushort stringIndex, ushort fretIndex);
		public static uint hash_func (GtkMusic.GuitarPosition key);
		public static bool equal_func (GtkMusic.GuitarPosition a, GtkMusic.GuitarPosition b);
	}
	[CCode (cheader_filename = "gtkmusic-internals.h")]
	public class Guitar : Gtk.DrawingArea {
		public class MarkedNoteStyle {
			public float[] color;
			public MarkedNoteStyle (float[] color);
		}
		public bool showLabels;
		public bool detailedLabels;
		public bool highlightFirstFret;
		public bool autoUpdate;
		public ushort fretNumber;
		public float[] gridBgColor;
		public float[] fretColor;
		public Gee.ArrayList<GtkMusic.GuitarString> guitarStrings;
		public Gee.HashSet<GtkMusic.GuitarFretMark> fretMarks;
		public Gee.HashMap<GtkMusic.GuitarPosition,GtkMusic.Guitar.MarkedNoteStyle> markedNotes;
		public Guitar ();
		public void start_animation ();
		public void stop_animation ();
		public void mark_position (ushort stringIndex, ushort fretIndex, float[] color = new float[4] { 0.0f, 0.0f, 0.0f, 1.0f });
		public void unmark_position (ushort stringIndex, ushort fretIndex);
		public void unmark_all ();
		public void mark_note (string note, float[] color = new float[4] { 0.0f, 0.0f, 0.0f, 1.0f });
		public void unmark_note (string note);
		public short note_position_in_string (ushort stringIndex, string note);
		public Gee.HashSet<GtkMusic.GuitarPosition>? find_positions (string note);
		public ushort position_to_midi (GtkMusic.GuitarPosition position);
		public string position_to_note (GtkMusic.GuitarPosition position);
		public override bool button_press_event (Gdk.EventButton event);
		public override bool button_release_event (Gdk.EventButton event);
		public override bool draw (Cairo.Context cr);
		public void redraw ();
		public signal void note_pressed (Gtk.Widget widget, Gdk.EventButton event, GtkMusic.GuitarPosition pos);
		public signal void note_released (Gtk.Widget widget, Gdk.EventButton event, GtkMusic.GuitarPosition pos);
	}
	[CCode (cheader_filename = "gtkmusic-internals.h")]
	public class Piano : Gtk.DrawingArea {
		public class MarkedNoteStyle {
			public float[] color;
			public MarkedNoteStyle (float[] color);
		}
		public enum LabelPosition {
			UP,
			DOWN
		}
		public bool autoUpdate;
		public ushort key_count;
		public ushort firstNote;
		public float[] nat_key_color;
		public float[] accident_key_color;
		public bool showLabels;
		public bool detailedLabels;
		public GtkMusic.Piano.LabelPosition labelsPosition;
		public Gee.HashMap<ushort,GtkMusic.Piano.MarkedNoteStyle> markedNotes;
		public Piano ();
		public void mark_midi (ushort midi_note, float[] color = new float[4] { 0.0f, 0.0f, 0.5f, 1.0f });
		public void unmark_midi (ushort midi_note);
		public void mark_note (string note, float[] color = new float[4] { 0.0f, 0.0f, 0.5f, 1.0f });
		public void unmark_note (string note);
		public void unmark_all ();
		public ushort point_to_midi (double x, double y) throws GtkMusic.PianoError;
		public double midi_to_x (ushort midi_code);
		public Gee.HashSet<ushort>? find_positions (string note);
		public override bool button_press_event (Gdk.EventButton event);
		public override bool button_release_event (Gdk.EventButton event);
		public override bool draw (Cairo.Context cr);
		public void redraw ();
		public signal void note_pressed (Gtk.Widget widget, Gdk.EventButton event, int midi_note);
		public signal void note_released (Gtk.Widget widget, Gdk.EventButton event, int midi_note);
	}
	[CCode (cheader_filename = "gtkmusic-internals.h")]
	public class MusicalNotes {
		public enum DiatonicIntervals {
			UNISON,
			MINOR_SECOND,
			MAJOR_SECOND,
			MINOR_THIRD,
			MAJOR_THIRD,
			PERFECT_FOURTH,
			DIMINISHED_FIFTH,
			PERFECT_FIFTH,
			MINOR_SIXTH,
			MAJOR_SIXTH,
			MINOR_SEVENTH,
			MAJOR_SEVENTH,
			PERFECT_OCTAVE
		}
		public const string[] note_names;
		public static bool validate (string note);
		public static bool is_incomplete (string needle);
		public static Gee.HashSet<string> make (string incompleteNote) throws GtkMusic.MusicalNoteError;
		public static ushort get_note_as_midi_code (string note) throws GtkMusic.MusicalNoteError;
		public static string get_note_from_midi_code (ushort midi) throws GtkMusic.MusicalNoteError;
		public static bool midi_is_accident (ushort midi);
		public static bool midi_can_have_accident (ushort midi);
		public MusicalNotes ();
	}
	[CCode (cheader_filename = "gtkmusic-internals.h")]
	public errordomain PianoError {
		INVALID_COORDINATES
	}
	[CCode (cheader_filename = "gtkmusic-internals.h")]
	public errordomain MusicalNoteError {
		INVALID_NOTE,
		INVALID_MIDI,
		ALREADY_COMPLETE
	}
}
