/* gnome-db-handler-text.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_HANDLER_TEXT__
#define __GNOME_DB_HANDLER_TEXT__

#include <libgnomedb/gnome-db-base.h>
#include <libgnomedb/gnome-db-server.h>
#include <libgnomedb/gnome-db-data-handler.h>

G_BEGIN_DECLS

#define GNOME_DB_HANDLER_TEXT_TYPE          (gnome_db_handler_text_get_type())
#define GNOME_DB_HANDLER_TEXT(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_handler_text_get_type(), GnomeDbHandlerText)
#define GNOME_DB_HANDLER_TEXT_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_handler_text_get_type (), GnomeDbHandlerTextClass)
#define IS_GNOME_DB_HANDLER_TEXT(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_handler_text_get_type ())


typedef struct _GnomeDbHandlerText      GnomeDbHandlerText;
typedef struct _GnomeDbHandlerTextClass GnomeDbHandlerTextClass;
typedef struct _GnomeDbHandlerTextPriv  GnomeDbHandlerTextPriv;


/* struct for the object's data */
struct _GnomeDbHandlerText
{
	GnomeDbBase                object;

	GnomeDbHandlerTextPriv  *priv;
};

/* struct for the object's class */
struct _GnomeDbHandlerTextClass
{
	GnomeDbBaseClass            parent_class;
};


guint           gnome_db_handler_text_get_type      (void);
GObject        *gnome_db_handler_text_new           (GnomeDbServer *srv);

G_END_DECLS

#endif
