/* gnome-db-qf-agg.h
 *
 * Copyright (C) 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_QF_AGG_H_
#define __GNOME_DB_QF_AGG_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include "gnome-db-server-aggregate.h"
#include "gnome-db-qfield.h"

G_BEGIN_DECLS

#define GNOME_DB_QF_AGG_TYPE          (gnome_db_qf_agg_get_type())
#define GNOME_DB_QF_AGG(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_qf_agg_get_type(), GnomeDbQfAgg)
#define GNOME_DB_QF_AGG_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_qf_agg_get_type (), GnomeDbQfAggClass)
#define IS_GNOME_DB_QF_AGG(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_qf_agg_get_type ())


/* error reporting */
extern GQuark gnome_db_qf_agg_error_quark (void);
#define GNOME_DB_QF_AGG_ERROR gnome_db_qf_agg_error_quark ()

enum
{
	GNOME_DB_QF_AGG_XML_LOAD_ERROR,
	GNOME_DB_QF_AGG_RENDER_ERROR
};


/* struct for the object's data */
struct _GnomeDbQfAgg
{
	GnomeDbQfield               object;
	GnomeDbQfAggPrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbQfAggClass
{
	GnomeDbQfieldClass                  class;

	/* signals */
	void   (*templ_signal)        (GnomeDbQfAgg *obj);
};

guint                   gnome_db_qf_agg_get_type         (void);
GObject                *gnome_db_qf_agg_new_with_agg     (GnomeDbQuery *query, GnomeDbServerAggregate *agg);
GObject                *gnome_db_qf_agg_new_with_xml_id  (GnomeDbQuery *query, const gchar *agg_xml_id);

GnomeDbServerAggregate *gnome_db_qf_agg_get_ref_agg      (GnomeDbQfAgg *agg);
gboolean                gnome_db_qf_agg_set_arg          (GnomeDbQfAgg *agg, GnomeDbQfield *arg);
GnomeDbQfield          *gnome_db_qf_agg_get_arg          (GnomeDbQfAgg *agg);

G_END_DECLS

#endif
