/* gnome-db-enums.h
 *
 * Copyright (C) 2003 - 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_ENUMS__
#define __GNOME_DB_ENUMS__

/* status of a value */
typedef enum  {
        GNOME_DB_VALUE_IS_NULL        = 1 << 0, /* READ | WRITE */
        GNOME_DB_VALUE_CAN_BE_NULL    = 1 << 1, /* READ | WRITE */
        GNOME_DB_VALUE_IS_DEFAULT     = 1 << 2, /* READ | WRITE */
        GNOME_DB_VALUE_CAN_BE_DEFAULT = 1 << 3, /* READ | WRITE */
        GNOME_DB_VALUE_IS_UNCHANGED   = 1 << 4, /* READ | WRITE */
        GNOME_DB_VALUE_ACTIONS_SHOWN  = 1 << 5, /* READ | WRITE */
        GNOME_DB_VALUE_DATA_NON_VALID = 1 << 6, /* READ */
        GNOME_DB_VALUE_HAS_VALUE_ORIG = 1 << 7  /* READ */
} GnomeDbValueAttribute;

/* enum for the different modes of action */
typedef enum {
	/* navigation modes */
	GNOME_DB_ACTION_NAVIGATION_ARROWS       = 1 << 0,
	GNOME_DB_ACTION_NAVIGATION_SCROLL       = 1 << 1,

	/* modifications */
	GNOME_DB_ACTION_MODIF_AUTO_COMMIT       = 1 << 2,
	GNOME_DB_ACTION_MODIF_COMMIT_IMMEDIATE  = 1 << 3,
	GNOME_DB_ACTION_ASK_CONFIRM_UPDATE      = 1 << 4,
	GNOME_DB_ACTION_ASK_CONFIRM_DELETE      = 1 << 5,
	GNOME_DB_ACTION_ASK_CONFIRM_INSERT      = 1 << 6,

	/* Error reporting */
	GNOME_DB_ACTION_REPORT_ERROR            = 1 << 7
} GnomeDbActionMode;

/* enum for the different possible actions */
typedef enum {
	/* actions in GnomeDbDataWidget widgets */
	GNOME_DB_ACTION_NEW_DATA,
	GNOME_DB_ACTION_WRITE_MODIFIED_DATA,
	GNOME_DB_ACTION_DELETE_SELECTED_DATA,
	GNOME_DB_ACTION_UNDELETE_SELECTED_DATA,
	GNOME_DB_ACTION_RESET_DATA,
	GNOME_DB_ACTION_MOVE_FIRST_RECORD,
	GNOME_DB_ACTION_MOVE_PREV_RECORD,
	GNOME_DB_ACTION_MOVE_NEXT_RECORD,
	GNOME_DB_ACTION_MOVE_LAST_RECORD,
	GNOME_DB_ACTION_MOVE_FIRST_CHUNCK,
        GNOME_DB_ACTION_MOVE_PREV_CHUNCK,
        GNOME_DB_ACTION_MOVE_NEXT_CHUNCK,
        GNOME_DB_ACTION_MOVE_LAST_CHUNCK
} GnomeDbAction;

/* different possible types for a GnomeDbGraph object */
typedef enum {
        GNOME_DB_GRAPH_DB_RELATIONS,
	GNOME_DB_GRAPH_QUERY_JOINS,
        GNOME_DB_GRAPH_MODELLING /* for future extensions */
} GnomeDbGraphType;

typedef enum {
	GNOME_DB_FIELD_VISIBLE   = 1 << 0,
	GNOME_DB_FIELD_INVISIBLE = 1 << 1,
	GNOME_DB_FIELD_ANY       = GNOME_DB_FIELD_VISIBLE | GNOME_DB_FIELD_INVISIBLE
} GnomeDbFieldState;

#endif



