/* iagno.c generated by valac 0.42.1.36-3777c, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <stdio.h>
#include <canberra-gtk.h>
#include <canberra.h>

#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_THEMES_DIALOG (themes_dialog_get_type ())
#define THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMES_DIALOG, ThemesDialog))
#define THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMES_DIALOG, ThemesDialogClass))
#define IS_THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMES_DIALOG))
#define IS_THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMES_DIALOG))
#define THEMES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMES_DIALOG, ThemesDialogClass))

typedef struct _ThemesDialog ThemesDialog;
typedef struct _ThemesDialogClass ThemesDialogClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	IAGNO_0_PROPERTY,
	IAGNO_NUM_PROPERTIES
};
static GParamSpec* iagno_properties[IAGNO_NUM_PROPERTIES];
typedef enum  {
	IAGNO_SOUND_FLIP,
	IAGNO_SOUND_GAMEOVER
} IagnoSound;

#define IAGNO_TYPE_SOUND (iagno_sound_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameWindowPrivate GameWindowPrivate;

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

struct _IagnoPrivate {
	GSettings* settings;
	GameWindow* window;
	GameView* view;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	ThemesDialog* themes_dialog;
	ComputerPlayer* computer;
	Player player_one;
	Game* game;
};

struct _Block3Data {
	int _ref_count_;
	Iagno* self;
	GtkBox* level_box;
	GtkBox* color_box;
};

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};

static gint Iagno_private_offset;
static gpointer iagno_parent_class = NULL;
static gboolean iagno_fast_mode;
static gboolean iagno_fast_mode = FALSE;
static gboolean iagno_alternative_start;
static gboolean iagno_alternative_start = FALSE;
static gchar* iagno_level;
static gchar* iagno_level = NULL;
static gint iagno_size;
static gint iagno_size = 8;
static gboolean* iagno_sound;
static gboolean* iagno_sound = NULL;
static gboolean iagno_two_players;
static gboolean iagno_two_players = FALSE;
static gboolean* iagno_play_first;
static gboolean* iagno_play_first = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType themes_dialog_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
static GType iagno_sound_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define IAGNO_QUICK_MOVE_DELAY 0.4
#define IAGNO_MODERATE_MOVE_DELAY 1.7
#define IAGNO_SLOW_MOVE_DELAY 2.0
static void iagno_theme_cb (Iagno* self);
static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
gint iagno_main (gchar** args,
                 gint args_length1);
static Iagno* iagno_new (void);
static Iagno* iagno_construct (GType object_type);
static gint iagno_real_handle_local_options (GApplication* base,
                                      GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static void iagno_real_startup (GApplication* base);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void iagno_player_move_cb (Iagno* self,
                           gint x,
                           gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender,
                                           gint x,
                                           gint y,
                                           gpointer self);
void game_view_set_scoreboard (GameView* self,
                               GtkDrawingArea* value);
void game_view_set_theme (GameView* self,
                          const gchar* value);
GType game_window_flags_get_type (void) G_GNUC_CONST;
GameWindow* game_window_new (const gchar* css_resource,
                             const gchar* name,
                             gint width,
                             gint height,
                             gboolean maximized,
                             gboolean start_now,
                             GameWindowFlags flags,
                             GtkBox* new_game_screen,
                             GtkWidget* _view);
GameWindow* game_window_construct (GType object_type,
                                   const gchar* css_resource,
                                   const gchar* name,
                                   gint width,
                                   gint height,
                                   gboolean maximized,
                                   gboolean start_now,
                                   GameWindowFlags flags,
                                   GtkBox* new_game_screen,
                                   GtkWidget* _view);
void game_window_add_to_sidebox (GameWindow* self,
                                 GtkWidget* widget);
static void iagno_start_game (Iagno* self);
static void _iagno_start_game_game_window_play (GameWindow* _sender,
                                         gpointer self);
static void iagno_wait_cb (Iagno* self);
static void _iagno_wait_cb_game_window_wait (GameWindow* _sender,
                                      gpointer self);
static void iagno_back_cb (Iagno* self);
static void _iagno_back_cb_game_window_back (GameWindow* _sender,
                                      gpointer self);
static void iagno_undo_cb (Iagno* self);
static void _iagno_undo_cb_game_window_undo (GameWindow* _sender,
                                      gpointer self);
static void __lambda8_ (Block3Data* _data3_);
static void ___lambda8__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void iagno_real_activate (GApplication* base);
static void iagno_real_shutdown (GApplication* base);
void game_window_shutdown (GameWindow* self,
                           GSettings* settings);
ThemesDialog* themes_dialog_new (GSettings* settings,
                                 GameView* view);
ThemesDialog* themes_dialog_construct (GType object_type,
                                       GSettings* settings,
                                       GameView* view);
Player game_get_current_color (Game* self);
gboolean game_get_is_complete (Game* self);
void computer_player_move_async (ComputerPlayer* self,
                                 gdouble delay_seconds,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
void computer_player_move_finish (ComputerPlayer* self,
                                  GAsyncResult* _res_);
static void iagno_game_complete (Iagno* self,
                          gboolean play_gameover_sound);
void computer_player_cancel_move (ComputerPlayer* self);
Game* game_new (gboolean alternative_start,
                gint tmp_size);
Game* game_construct (GType object_type,
                      gboolean alternative_start,
                      gint tmp_size);
static void iagno_turn_ended_cb (Iagno* self);
static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender,
                                           gpointer self);
void game_view_set_game (GameView* self,
                         Game* value);
ComputerPlayer* computer_player_new (Game* game,
                                     gint difficulty_level);
ComputerPlayer* computer_player_construct (GType object_type,
                                           Game* game,
                                           gint difficulty_level);
static void iagno_update_ui (Iagno* self);
void game_window_set_subtitle (GameWindow* self,
                               const gchar* subtitle);
gint game_get_number_of_moves (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self,
                gint count);
gboolean game_get_current_player_can_move (Game* self);
static void iagno_play_sound (Iagno* self,
                       IagnoSound sound);
void game_view_update_scoreboard (GameView* self);
static void iagno_prepare_move (Iagno* self);
static void iagno_pass (Iagno* self);
void game_pass (Game* self);
void game_window_finish_game (GameWindow* self);
gint game_place_tile (Game* self,
                      gint x,
                      gint y,
                      gboolean apply);
const gchar* game_view_get_sound_flip (GameView* self);
const gchar* game_view_get_sound_gameover (GameView* self);
static void iagno_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry IAGNO_option_entries[11] = {{"alternative-start", (gchar) 0, 0, G_OPTION_ARG_NONE, &iagno_alternative_start, N_ ("Start with an alternative position"), NULL}, {"fast-mode", 'f', 0, G_OPTION_ARG_NONE, &iagno_fast_mode, N_ ("Reduce delay before AI moves"), NULL}, {"first", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, N_ ("Play first"), NULL}, {"level", 'l', 0, G_OPTION_ARG_STRING, &iagno_level, N_ ("Set the level of the computer’s AI"), "LEVEL"}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, N_ ("Turn off the sound"), NULL}, {"second", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, N_ ("Play second"), NULL}, {"size", 's', 0, G_OPTION_ARG_INT, &iagno_size, N_ ("Size of the board (debug only)"), "SIZE"}, {"two-players", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, N_ ("Two-players mode"), NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, N_ ("Turn on the sound"), NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Print release version and exit"), NULL}, {NULL}};
static const GActionEntry IAGNO_app_actions[4] = {{"theme", _iagno_theme_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static inline gpointer
iagno_get_instance_private (Iagno* self)
{
	return G_STRUCT_MEMBER_P (self, Iagno_private_offset);
}

static GType
iagno_sound_get_type (void)
{
	static volatile gsize iagno_sound_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_sound_type_id__volatile)) {
		static const GEnumValue values[] = {{IAGNO_SOUND_FLIP, "IAGNO_SOUND_FLIP", "flip"}, {IAGNO_SOUND_GAMEOVER, "IAGNO_SOUND_GAMEOVER", "gameover"}, {0, NULL, NULL}};
		GType iagno_sound_type_id;
		iagno_sound_type_id = g_enum_register_static ("IagnoSound", values);
		g_once_init_leave (&iagno_sound_type_id__volatile, iagno_sound_type_id);
	}
	return iagno_sound_type_id__volatile;
}

static void
_iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	iagno_theme_cb ((Iagno*) self);
}

static void
_iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                 GVariant* parameter,
                                                 gpointer self)
{
	iagno_help_cb ((Iagno*) self);
}

static void
_iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	iagno_about_cb ((Iagno*) self);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

gint
iagno_main (gchar** args,
            gint args_length1)
{
	gint result = 0;
	Iagno* _tmp0_;
	Iagno* _tmp1_;
	gint _tmp2_;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (_ ("Iagno"));
	gtk_window_set_default_icon_name ("iagno");
	_tmp0_ = iagno_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return iagno_main (argv, argc);
}

static Iagno*
iagno_construct (GType object_type)
{
	Iagno * self = NULL;
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, IAGNO_option_entries);
	return self;
}

static Iagno*
iagno_new (void)
{
	return iagno_construct (TYPE_IAGNO);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gint
iagno_real_handle_local_options (GApplication* base,
                                 GVariantDict* options)
{
	Iagno * self;
	gint result = 0;
	self = (Iagno*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%1$s %2$s\n", "iagno", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (iagno_size < 4) {
		FILE* _tmp1_;
		_tmp1_ = stderr;
		fprintf (_tmp1_, "%s\n", _ ("Size must be at least 4."));
		result = EXIT_FAILURE;
		return result;
	}
	if (g_variant_dict_contains (options, "mute")) {
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp2_ = FALSE;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (iagno_sound);
		iagno_sound = _tmp3_;
	} else {
		if (g_variant_dict_contains (options, "unmute")) {
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp4_ = TRUE;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (iagno_sound);
			iagno_sound = _tmp5_;
		}
	}
	if (g_variant_dict_contains (options, "two-players")) {
		iagno_two_players = TRUE;
	} else {
		if (g_variant_dict_contains (options, "first")) {
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp6_ = TRUE;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (iagno_play_first);
			iagno_play_first = _tmp7_;
		} else {
			if (g_variant_dict_contains (options, "second")) {
				gboolean _tmp8_;
				gboolean* _tmp9_;
				_tmp8_ = FALSE;
				_tmp9_ = __bool_dup0 (&_tmp8_);
				_g_free0 (iagno_play_first);
				iagno_play_first = _tmp9_;
			}
		}
	}
	result = -1;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Iagno* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->color_box);
		_g_object_unref0 (_data3_->level_box);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_iagno_player_move_cb_game_view_move (GameView* _sender,
                                      gint x,
                                      gint y,
                                      gpointer self)
{
	iagno_player_move_cb ((Iagno*) self, x, y);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_iagno_start_game_game_window_play (GameWindow* _sender,
                                    gpointer self)
{
	iagno_start_game ((Iagno*) self);
}

static void
_iagno_wait_cb_game_window_wait (GameWindow* _sender,
                                 gpointer self)
{
	iagno_wait_cb ((Iagno*) self);
}

static void
_iagno_back_cb_game_window_back (GameWindow* _sender,
                                 gpointer self)
{
	iagno_back_cb ((Iagno*) self);
}

static void
_iagno_undo_cb_game_window_undo (GameWindow* _sender,
                                 gpointer self)
{
	iagno_undo_cb ((Iagno*) self);
}

static void
__lambda8_ (Block3Data* _data3_)
{
	Iagno* self;
	gboolean solo = FALSE;
	GSettings* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	self = _data3_->self;
	_tmp0_ = self->priv->settings;
	solo = g_settings_get_int (_tmp0_, "num-players") == 1;
	_tmp1_ = _data3_->level_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, solo);
	_tmp2_ = _data3_->color_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, solo);
}

static void
___lambda8__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda8_ (self);
}

static void
iagno_real_startup (GApplication* base)
{
	Iagno * self;
	Block3Data* _data3_;
	GSettings* _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean start_now = FALSE;
	gboolean* _tmp8_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp27_;
	GameView* _tmp28_;
	GameView* _tmp29_;
	GtkDrawingArea* scoredrawing = NULL;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_;
	GtkDrawingArea* _tmp32_;
	GameView* _tmp33_;
	GtkDrawingArea* _tmp34_;
	GameView* _tmp35_;
	GSettings* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GSettings* _tmp39_;
	GSettings* _tmp40_;
	GSettings* _tmp41_;
	GtkBuilder* _tmp42_;
	GObject* _tmp43_;
	GameView* _tmp44_;
	GameWindow* _tmp45_;
	GtkWidget* scoregrid = NULL;
	GtkBuilder* _tmp46_;
	GObject* _tmp47_;
	GtkWidget* _tmp48_;
	GameWindow* _tmp49_;
	GtkWidget* _tmp50_;
	GameWindow* _tmp51_;
	GameWindow* _tmp52_;
	GameWindow* _tmp53_;
	GameWindow* _tmp54_;
	gchar* _tmp55_;
	gchar** _tmp56_;
	gchar** _tmp57_;
	gint _tmp57__length1;
	gchar* _tmp58_;
	gchar** _tmp59_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	gchar* _tmp61_;
	gchar** _tmp62_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	gchar* _tmp64_;
	gchar** _tmp65_;
	gchar** _tmp66_;
	gint _tmp66__length1;
	gchar* _tmp67_;
	gchar** _tmp68_;
	gchar** _tmp69_;
	gint _tmp69__length1;
	gchar* _tmp70_;
	gchar** _tmp71_;
	gchar** _tmp72_;
	gint _tmp72__length1;
	gchar* _tmp73_;
	gchar** _tmp74_;
	gchar** _tmp75_;
	gint _tmp75__length1;
	gchar* _tmp76_;
	gchar** _tmp77_;
	gchar** _tmp78_;
	gint _tmp78__length1;
	gchar* _tmp79_;
	gchar** _tmp80_;
	gchar** _tmp81_;
	gint _tmp81__length1;
	GSettings* _tmp82_;
	GAction* _tmp83_;
	GAction* _tmp84_;
	GSettings* _tmp85_;
	GAction* _tmp86_;
	GAction* _tmp87_;
	GSettings* _tmp88_;
	GAction* _tmp89_;
	GAction* _tmp90_;
	GSettings* _tmp91_;
	GAction* _tmp92_;
	GAction* _tmp93_;
	GtkBuilder* _tmp94_;
	GObject* _tmp95_;
	GtkBox* _tmp96_;
	GtkBuilder* _tmp97_;
	GObject* _tmp98_;
	GtkBox* _tmp99_;
	GSettings* _tmp100_;
	gboolean solo = FALSE;
	GSettings* _tmp101_;
	GtkBox* _tmp102_;
	GtkBox* _tmp103_;
	GtkBuilder* _tmp104_;
	GObject* _tmp105_;
	GtkLabel* _tmp106_;
	GtkBuilder* _tmp107_;
	GObject* _tmp108_;
	GtkLabel* _tmp109_;
	GameWindow* _tmp110_;
	self = (Iagno*) base;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.iagno");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = iagno_sound;
	if (_tmp1_ != NULL) {
		GSettings* _tmp2_;
		gboolean* _tmp3_;
		_tmp2_ = self->priv->settings;
		_tmp3_ = iagno_sound;
		g_settings_set_boolean (_tmp2_, "sound", *_tmp3_);
	}
	if (iagno_two_players == TRUE) {
		_tmp4_ = TRUE;
	} else {
		gboolean* _tmp5_;
		_tmp5_ = iagno_play_first;
		_tmp4_ = _tmp5_ != NULL;
	}
	start_now = _tmp4_;
	if (start_now) {
		gint _tmp6_ = 0;
		GSettings* _tmp7_;
		if (iagno_two_players) {
			_tmp6_ = 2;
		} else {
			_tmp6_ = 1;
		}
		_tmp7_ = self->priv->settings;
		g_settings_set_int (_tmp7_, "num-players", _tmp6_);
	}
	_tmp8_ = iagno_play_first;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_ = NULL;
		gboolean* _tmp10_;
		GSettings* _tmp11_;
		_tmp10_ = iagno_play_first;
		if (*_tmp10_) {
			_tmp9_ = "dark";
		} else {
			_tmp9_ = "light";
		}
		_tmp11_ = self->priv->settings;
		g_settings_set_string (_tmp11_, "color", _tmp9_);
	}
	_tmp14_ = iagno_level;
	if (g_strcmp0 (_tmp14_, "1") == 0) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = iagno_level;
		_tmp13_ = g_strcmp0 (_tmp15_, "2") == 0;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp16_;
		_tmp16_ = iagno_level;
		_tmp12_ = g_strcmp0 (_tmp16_, "3") == 0;
	}
	if (_tmp12_) {
		GSettings* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = self->priv->settings;
		_tmp18_ = iagno_level;
		g_settings_set_int (_tmp17_, "computer-level", atoi (_tmp18_));
	} else {
		const gchar* _tmp19_;
		_tmp19_ = iagno_level;
		if (g_strcmp0 (_tmp19_, "one") == 0) {
			GSettings* _tmp20_;
			_tmp20_ = self->priv->settings;
			g_settings_set_int (_tmp20_, "computer-level", 1);
		} else {
			const gchar* _tmp21_;
			_tmp21_ = iagno_level;
			if (g_strcmp0 (_tmp21_, "two") == 0) {
				GSettings* _tmp22_;
				_tmp22_ = self->priv->settings;
				g_settings_set_int (_tmp22_, "computer-level", 2);
			} else {
				const gchar* _tmp23_;
				_tmp23_ = iagno_level;
				if (g_strcmp0 (_tmp23_, "three") == 0) {
					GSettings* _tmp24_;
					_tmp24_ = self->priv->settings;
					g_settings_set_int (_tmp24_, "computer-level", 3);
				} else {
					const gchar* _tmp25_;
					_tmp25_ = iagno_level;
					if (_tmp25_ != NULL) {
						FILE* _tmp26_;
						_tmp26_ = stderr;
						fprintf (_tmp26_, "%s\n", _ ("Level should be between 1 (easy) and 3 (hard). Settings unchanged."));
					}
				}
			}
		}
	}
	_tmp27_ = gtk_builder_new_from_resource ("/org/gnome/iagno/ui/iagno-screens.ui");
	builder = _tmp27_;
	_tmp28_ = game_view_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp28_;
	_tmp29_ = self->priv->view;
	g_signal_connect_object (_tmp29_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
	_tmp30_ = builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "scoredrawing");
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_drawing_area_get_type (), GtkDrawingArea));
	scoredrawing = _tmp32_;
	_tmp33_ = self->priv->view;
	_tmp34_ = scoredrawing;
	game_view_set_scoreboard (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->view;
	_tmp36_ = self->priv->settings;
	_tmp37_ = g_settings_get_string (_tmp36_, "theme");
	_tmp38_ = _tmp37_;
	game_view_set_theme (_tmp35_, _tmp38_);
	_g_free0 (_tmp38_);
	_tmp39_ = self->priv->settings;
	_tmp40_ = self->priv->settings;
	_tmp41_ = self->priv->settings;
	_tmp42_ = builder;
	_tmp43_ = gtk_builder_get_object (_tmp42_, "new-game-screen");
	_tmp44_ = self->priv->view;
	_tmp45_ = game_window_new ("/org/gnome/iagno/ui/iagno.css", _ ("Iagno"), g_settings_get_int (_tmp39_, "window-width"), g_settings_get_int (_tmp40_, "window-height"), g_settings_get_boolean (_tmp41_, "window-is-maximized"), start_now, GAME_WINDOW_FLAGS_SHOW_UNDO | GAME_WINDOW_FLAGS_SHOW_START_BUTTON, G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp45_;
	_tmp46_ = builder;
	_tmp47_ = gtk_builder_get_object (_tmp46_, "scoregrid");
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_widget_get_type (), GtkWidget));
	scoregrid = _tmp48_;
	_tmp49_ = self->priv->window;
	_tmp50_ = scoregrid;
	game_window_add_to_sidebox (_tmp49_, _tmp50_);
	_tmp51_ = self->priv->window;
	g_signal_connect_object (_tmp51_, "play", (GCallback) _iagno_start_game_game_window_play, self, 0);
	_tmp52_ = self->priv->window;
	g_signal_connect_object (_tmp52_, "wait", (GCallback) _iagno_wait_cb_game_window_wait, self, 0);
	_tmp53_ = self->priv->window;
	g_signal_connect_object (_tmp53_, "back", (GCallback) _iagno_back_cb_game_window_back, self, 0);
	_tmp54_ = self->priv->window;
	g_signal_connect_object (_tmp54_, "undo", (GCallback) _iagno_undo_cb_game_window_undo, self, 0);
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, (gint) G_N_ELEMENTS (IAGNO_app_actions), self);
	_tmp55_ = g_strdup ("<Primary>n");
	_tmp56_ = g_new0 (gchar*, 1 + 1);
	_tmp56_[0] = _tmp55_;
	_tmp57_ = _tmp56_;
	_tmp57__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new-game", _tmp57_);
	_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
	_tmp58_ = g_strdup ("<Shift><Primary>n");
	_tmp59_ = g_new0 (gchar*, 1 + 1);
	_tmp59_[0] = _tmp58_;
	_tmp60_ = _tmp59_;
	_tmp60__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.start-game", _tmp60_);
	_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
	_tmp61_ = g_strdup ("<Primary>q");
	_tmp62_ = g_new0 (gchar*, 1 + 1);
	_tmp62_[0] = _tmp61_;
	_tmp63_ = _tmp62_;
	_tmp63__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp63_);
	_tmp63_ = (_vala_array_free (_tmp63_, _tmp63__length1, (GDestroyNotify) g_free), NULL);
	_tmp64_ = g_strdup ("<Primary>z");
	_tmp65_ = g_new0 (gchar*, 1 + 1);
	_tmp65_[0] = _tmp64_;
	_tmp66_ = _tmp65_;
	_tmp66__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp66_);
	_tmp66_ = (_vala_array_free (_tmp66_, _tmp66__length1, (GDestroyNotify) g_free), NULL);
	_tmp67_ = g_strdup ("<Shift><Primary>z");
	_tmp68_ = g_new0 (gchar*, 1 + 1);
	_tmp68_[0] = _tmp67_;
	_tmp69_ = _tmp68_;
	_tmp69__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp69_);
	_tmp69_ = (_vala_array_free (_tmp69_, _tmp69__length1, (GDestroyNotify) g_free), NULL);
	_tmp70_ = g_strdup ("Escape");
	_tmp71_ = g_new0 (gchar*, 1 + 1);
	_tmp71_[0] = _tmp70_;
	_tmp72_ = _tmp71_;
	_tmp72__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.back", _tmp72_);
	_tmp72_ = (_vala_array_free (_tmp72_, _tmp72__length1, (GDestroyNotify) g_free), NULL);
	_tmp73_ = g_strdup ("F10");
	_tmp74_ = g_new0 (gchar*, 1 + 1);
	_tmp74_[0] = _tmp73_;
	_tmp75_ = _tmp74_;
	_tmp75__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.toggle-hamburger", _tmp75_);
	_tmp75_ = (_vala_array_free (_tmp75_, _tmp75__length1, (GDestroyNotify) g_free), NULL);
	_tmp76_ = g_strdup ("F1");
	_tmp77_ = g_new0 (gchar*, 1 + 1);
	_tmp77_[0] = _tmp76_;
	_tmp78_ = _tmp77_;
	_tmp78__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp78_);
	_tmp78_ = (_vala_array_free (_tmp78_, _tmp78__length1, (GDestroyNotify) g_free), NULL);
	_tmp79_ = g_strdup ("<Shift>F1");
	_tmp80_ = g_new0 (gchar*, 1 + 1);
	_tmp80_[0] = _tmp79_;
	_tmp81_ = _tmp80_;
	_tmp81__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.about", _tmp81_);
	_tmp81_ = (_vala_array_free (_tmp81_, _tmp81__length1, (GDestroyNotify) g_free), NULL);
	_tmp82_ = self->priv->settings;
	_tmp83_ = g_settings_create_action (_tmp82_, "sound");
	_tmp84_ = _tmp83_;
	g_action_map_add_action ((GActionMap*) self, _tmp84_);
	_g_object_unref0 (_tmp84_);
	_tmp85_ = self->priv->settings;
	_tmp86_ = g_settings_create_action (_tmp85_, "color");
	_tmp87_ = _tmp86_;
	g_action_map_add_action ((GActionMap*) self, _tmp87_);
	_g_object_unref0 (_tmp87_);
	_tmp88_ = self->priv->settings;
	_tmp89_ = g_settings_create_action (_tmp88_, "num-players");
	_tmp90_ = _tmp89_;
	g_action_map_add_action ((GActionMap*) self, _tmp90_);
	_g_object_unref0 (_tmp90_);
	_tmp91_ = self->priv->settings;
	_tmp92_ = g_settings_create_action (_tmp91_, "computer-level");
	_tmp93_ = _tmp92_;
	g_action_map_add_action ((GActionMap*) self, _tmp93_);
	_g_object_unref0 (_tmp93_);
	_tmp94_ = builder;
	_tmp95_ = gtk_builder_get_object (_tmp94_, "difficulty-box");
	_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, gtk_box_get_type (), GtkBox));
	_data3_->level_box = _tmp96_;
	_tmp97_ = builder;
	_tmp98_ = gtk_builder_get_object (_tmp97_, "color-box");
	_tmp99_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, gtk_box_get_type (), GtkBox));
	_data3_->color_box = _tmp99_;
	_tmp100_ = self->priv->settings;
	g_signal_connect_data (_tmp100_, "changed::num-players", (GCallback) ___lambda8__g_settings_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp101_ = self->priv->settings;
	solo = g_settings_get_int (_tmp101_, "num-players") == 1;
	_tmp102_ = _data3_->level_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp102_, solo);
	_tmp103_ = _data3_->color_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp103_, solo);
	_tmp104_ = builder;
	_tmp105_ = gtk_builder_get_object (_tmp104_, "light-score-label");
	_tmp106_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->light_score_label);
	self->priv->light_score_label = _tmp106_;
	_tmp107_ = builder;
	_tmp108_ = gtk_builder_get_object (_tmp107_, "dark-score-label");
	_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp108_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->dark_score_label);
	self->priv->dark_score_label = _tmp109_;
	if (start_now) {
		iagno_start_game (self);
	}
	_tmp110_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp110_);
	_g_object_unref0 (scoregrid);
	_g_object_unref0 (scoredrawing);
	_g_object_unref0 (builder);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
iagno_real_activate (GApplication* base)
{
	Iagno * self;
	GameWindow* _tmp0_;
	self = (Iagno*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}

static void
iagno_real_shutdown (GApplication* base)
{
	Iagno * self;
	GameWindow* _tmp0_;
	GSettings* _tmp1_;
	self = (Iagno*) base;
	_tmp0_ = self->priv->window;
	_tmp1_ = self->priv->settings;
	game_window_shutdown (_tmp0_, _tmp1_);
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static void
iagno_theme_cb (Iagno* self)
{
	ThemesDialog* _tmp0_;
	ThemesDialog* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->themes_dialog;
	if (_tmp0_ == NULL) {
		GSettings* _tmp1_;
		GameView* _tmp2_;
		ThemesDialog* _tmp3_;
		ThemesDialog* _tmp4_;
		GameWindow* _tmp5_;
		_tmp1_ = self->priv->settings;
		_tmp2_ = self->priv->view;
		_tmp3_ = themes_dialog_new (_tmp1_, _tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->themes_dialog);
		self->priv->themes_dialog = _tmp3_;
		_tmp4_ = self->priv->themes_dialog;
		_tmp5_ = self->priv->window;
		gtk_window_set_transient_for ((GtkWindow*) _tmp4_, (GtkWindow*) _tmp5_);
	}
	_tmp6_ = self->priv->themes_dialog;
	gtk_window_present ((GtkWindow*) _tmp6_);
}

static void
iagno_help_cb (Iagno* self)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GameWindow* _tmp0_;
		GdkScreen* _tmp1_;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		gtk_show_uri (_tmp1_, "help:iagno", gtk_get_current_event_time (), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("iagno.vala:261: Failed to show help: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}

static void
iagno_about_cb (Iagno* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint authors_length1;
	gint _authors_size_;
	gchar** documenters = NULL;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint documenters_length1;
	gint _documenters_size_;
	GameWindow* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Ian Peters");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Tiffany Antopolski");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	documenters = _tmp4_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp5_ = self->priv->window;
	gtk_show_about_dialog ((GtkWindow*) _tmp5_, "name", _ ("Iagno"), "version", VERSION, "copyright", "Copyright © 1998–2008 Ian Peters\n" "Copyright © 2013–2015 Michael Catanzaro\n" "Copyright © 2014–2019 Arnaud Bonatti", "license-type", GTK_LICENSE_GPL_3_0, "comments", _ ("A disk flipping game derived from Reversi"), "authors", authors, "documenters", documenters, "translator-credits", _ ("translator-credits"), "logo-icon-name", "iagno", "website", "https://wiki.gnome.org/Apps/Iagno", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static void
iagno_back_cb (Iagno* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	Player _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->player_one;
	if (_tmp4_ != _tmp5_) {
		ComputerPlayer* _tmp6_;
		_tmp6_ = self->priv->computer;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Game* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_is_complete (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = !_tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ComputerPlayer* _tmp10_;
		_tmp10_ = self->priv->computer;
		computer_player_move_async (_tmp10_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
	} else {
		Game* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = self->priv->game;
		_tmp12_ = game_get_is_complete (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			iagno_game_complete (self, FALSE);
		}
	}
}

static void
iagno_wait_cb (Iagno* self)
{
	ComputerPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer;
	if (_tmp0_ != NULL) {
		ComputerPlayer* _tmp1_;
		_tmp1_ = self->priv->computer;
		computer_player_cancel_move (_tmp1_);
	}
}

static void
_iagno_turn_ended_cb_game_turn_ended (Game* _sender,
                                      gpointer self)
{
	iagno_turn_ended_cb ((Iagno*) self);
}

static void
iagno_start_game (Iagno* self)
{
	Game* _tmp0_;
	ComputerPlayer* _tmp2_;
	Game* _tmp4_;
	Game* _tmp5_;
	GameView* _tmp6_;
	Game* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp12_;
	gboolean _tmp13_ = FALSE;
	Player _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = self->priv->computer;
	if (_tmp2_ != NULL) {
		ComputerPlayer* _tmp3_;
		_tmp3_ = self->priv->computer;
		computer_player_cancel_move (_tmp3_);
	}
	_tmp4_ = game_new (iagno_alternative_start, iagno_size);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp4_;
	_tmp5_ = self->priv->game;
	g_signal_connect_object (_tmp5_, "turn-ended", (GCallback) _iagno_turn_ended_cb_game_turn_ended, self, 0);
	_tmp6_ = self->priv->view;
	_tmp7_ = self->priv->game;
	game_view_set_game (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->settings;
	if (g_settings_get_int (_tmp8_, "num-players") == 2) {
		_g_object_unref0 (self->priv->computer);
		self->priv->computer = NULL;
	} else {
		Game* _tmp9_;
		GSettings* _tmp10_;
		ComputerPlayer* _tmp11_;
		_tmp9_ = self->priv->game;
		_tmp10_ = self->priv->settings;
		_tmp11_ = computer_player_new (_tmp9_, g_settings_get_int (_tmp10_, "computer-level"));
		_g_object_unref0 (self->priv->computer);
		self->priv->computer = _tmp11_;
	}
	_tmp12_ = self->priv->settings;
	if (g_settings_get_enum (_tmp12_, "color") == 1) {
		self->priv->player_one = PLAYER_LIGHT;
	} else {
		self->priv->player_one = PLAYER_DARK;
	}
	iagno_update_ui (self);
	_tmp14_ = self->priv->player_one;
	if (_tmp14_ != PLAYER_DARK) {
		ComputerPlayer* _tmp15_;
		_tmp15_ = self->priv->computer;
		_tmp13_ = _tmp15_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ComputerPlayer* _tmp16_;
		_tmp16_ = self->priv->computer;
		computer_player_move_async (_tmp16_, IAGNO_MODERATE_MOVE_DELAY, NULL, NULL);
	}
}

static void
iagno_update_ui (Iagno* self)
{
	GameWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Player _tmp2_;
	GtkLabel* _tmp14_;
	Game* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GtkLabel* _tmp20_;
	Game* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	game_window_set_subtitle (_tmp0_, NULL);
	_tmp2_ = self->priv->player_one;
	if (_tmp2_ == PLAYER_DARK) {
		_tmp1_ = TRUE;
	} else {
		ComputerPlayer* _tmp3_;
		_tmp3_ = self->priv->computer;
		_tmp1_ = _tmp3_ == NULL;
	}
	if (_tmp1_) {
		GameWindow* _tmp4_;
		GSimpleAction* _tmp5_;
		Game* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp4_ = self->priv->window;
		_tmp5_ = _tmp4_->undo_action;
		_tmp6_ = self->priv->game;
		_tmp7_ = game_get_number_of_moves (_tmp6_);
		_tmp8_ = _tmp7_;
		g_simple_action_set_enabled (_tmp5_, _tmp8_ >= 1);
	} else {
		GameWindow* _tmp9_;
		GSimpleAction* _tmp10_;
		Game* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp9_ = self->priv->window;
		_tmp10_ = _tmp9_->undo_action;
		_tmp11_ = self->priv->game;
		_tmp12_ = game_get_number_of_moves (_tmp11_);
		_tmp13_ = _tmp12_;
		g_simple_action_set_enabled (_tmp10_, _tmp13_ >= 2);
	}
	_tmp14_ = self->priv->dark_score_label;
	_tmp15_ = self->priv->game;
	_tmp16_ = game_get_n_dark_tiles (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf (_ ("%.2d"), _tmp17_);
	_tmp19_ = _tmp18_;
	gtk_label_set_text (_tmp14_, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = self->priv->light_score_label;
	_tmp21_ = self->priv->game;
	_tmp22_ = game_get_n_light_tiles (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup_printf (_ ("%.2d"), _tmp23_);
	_tmp25_ = _tmp24_;
	gtk_label_set_text (_tmp20_, _tmp25_);
	_g_free0 (_tmp25_);
}

static void
iagno_undo_cb (Iagno* self)
{
	ComputerPlayer* _tmp0_;
	GameView* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer;
	if (_tmp0_ == NULL) {
		Game* _tmp1_;
		Game* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->game;
		game_undo (_tmp1_, 1);
		_tmp2_ = self->priv->game;
		_tmp3_ = game_get_current_player_can_move (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!_tmp4_) {
			Game* _tmp5_;
			_tmp5_ = self->priv->game;
			game_undo (_tmp5_, 1);
		}
	} else {
		ComputerPlayer* _tmp6_;
		Game* _tmp7_;
		Player _tmp8_;
		Player _tmp9_;
		Player _tmp10_;
		_tmp6_ = self->priv->computer;
		computer_player_cancel_move (_tmp6_);
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_current_color (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->player_one;
		if (_tmp9_ != _tmp10_) {
			Game* _tmp11_;
			_tmp11_ = self->priv->game;
			game_undo (_tmp11_, 1);
		} else {
			Game* _tmp12_;
			_tmp12_ = self->priv->game;
			game_undo (_tmp12_, 2);
		}
		while (TRUE) {
			Game* _tmp13_;
			gboolean _tmp14_;
			gboolean _tmp15_;
			Game* _tmp16_;
			_tmp13_ = self->priv->game;
			_tmp14_ = game_get_current_player_can_move (_tmp13_);
			_tmp15_ = _tmp14_;
			if (!(!_tmp15_)) {
				break;
			}
			_tmp16_ = self->priv->game;
			game_undo (_tmp16_, 2);
		}
	}
	iagno_update_ui (self);
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
	_tmp17_ = self->priv->view;
	game_view_update_scoreboard (_tmp17_);
}

static void
iagno_turn_ended_cb (Iagno* self)
{
	Game* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	iagno_update_ui (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_current_player_can_move (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		iagno_prepare_move (self);
	} else {
		Game* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->game;
		_tmp4_ = game_get_is_complete (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			iagno_game_complete (self, TRUE);
		} else {
			iagno_pass (self);
		}
	}
}

static void
iagno_prepare_move (Iagno* self)
{
	GameView* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	Player _tmp5_;
	g_return_if_fail (self != NULL);
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
	_tmp0_ = self->priv->view;
	game_view_update_scoreboard (_tmp0_);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->player_one;
	if (_tmp4_ != _tmp5_) {
		ComputerPlayer* _tmp6_;
		_tmp6_ = self->priv->computer;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gdouble _tmp7_ = 0.0;
		ComputerPlayer* _tmp8_;
		if (iagno_fast_mode) {
			_tmp7_ = IAGNO_QUICK_MOVE_DELAY;
		} else {
			_tmp7_ = IAGNO_SLOW_MOVE_DELAY;
		}
		_tmp8_ = self->priv->computer;
		computer_player_move_async (_tmp8_, _tmp7_, NULL, NULL);
	}
}

static void
iagno_pass (Iagno* self)
{
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	g_return_if_fail (self != NULL);
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
	_tmp0_ = self->priv->view;
	game_view_update_scoreboard (_tmp0_);
	_tmp1_ = self->priv->game;
	game_pass (_tmp1_);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == PLAYER_DARK) {
		GameWindow* _tmp5_;
		_tmp5_ = self->priv->window;
		game_window_set_subtitle (_tmp5_, _ ("Light must pass, Dark’s move"));
	} else {
		GameWindow* _tmp6_;
		_tmp6_ = self->priv->window;
		game_window_set_subtitle (_tmp6_, _ ("Dark must pass, Light’s move"));
	}
}

static void
iagno_game_complete (Iagno* self,
                     gboolean play_gameover_sound)
{
	GameWindow* _tmp0_;
	Game* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Game* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	game_window_finish_game (_tmp0_);
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_n_light_tiles (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->game;
	_tmp5_ = game_get_n_dark_tiles (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp3_ > _tmp6_) {
		GameWindow* _tmp7_;
		_tmp7_ = self->priv->window;
		game_window_set_subtitle (_tmp7_, _ ("Light wins!"));
	} else {
		Game* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		Game* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp8_ = self->priv->game;
		_tmp9_ = game_get_n_dark_tiles (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->game;
		_tmp12_ = game_get_n_light_tiles (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp10_ > _tmp13_) {
			GameWindow* _tmp14_;
			_tmp14_ = self->priv->window;
			game_window_set_subtitle (_tmp14_, _ ("Dark wins!"));
		} else {
			GameWindow* _tmp15_;
			_tmp15_ = self->priv->window;
			game_window_set_subtitle (_tmp15_, _ ("The game is draw."));
		}
	}
	if (play_gameover_sound) {
		iagno_play_sound (self, IAGNO_SOUND_GAMEOVER);
	}
}

static void
iagno_player_move_cb (Iagno* self,
                      gint x,
                      gint y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	Player _tmp5_;
	Game* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->player_one;
	if (_tmp4_ != _tmp5_) {
		ComputerPlayer* _tmp6_;
		_tmp6_ = self->priv->computer;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Game* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_current_player_can_move (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = !_tmp9_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp10_ = self->priv->game;
	if (game_place_tile (_tmp10_, x, y, TRUE) == 0) {
		GameWindow* _tmp11_;
		_tmp11_ = self->priv->window;
		game_window_set_subtitle (_tmp11_, _ ("You can’t move there!"));
	}
}

static void
iagno_play_sound (Iagno* self,
                  IagnoSound sound)
{
	GSettings* _tmp0_;
	gchar* name = NULL;
	gchar* path = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gint r = 0;
	GameView* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (!g_settings_get_boolean (_tmp0_, "sound")) {
		return;
	}
	switch (sound) {
		case IAGNO_SOUND_FLIP:
		{
			GameView* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp1_ = self->priv->view;
			_tmp2_ = game_view_get_sound_flip (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (name);
			name = _tmp4_;
			break;
		}
		case IAGNO_SOUND_GAMEOVER:
		{
			GameView* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = self->priv->view;
			_tmp6_ = game_view_get_sound_gameover (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (name);
			name = _tmp8_;
			break;
		}
		default:
		{
			_g_free0 (name);
			return;
		}
	}
	_tmp9_ = name;
	_tmp10_ = g_build_filename (SOUND_DIRECTORY, _tmp9_, NULL);
	path = _tmp10_;
	_tmp11_ = self->priv->view;
	_tmp12_ = name;
	_tmp13_ = path;
	r = ca_gtk_play_for_widget ((GtkWidget*) _tmp11_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp12_, CA_PROP_MEDIA_FILENAME, _tmp13_, NULL);
	if (r != 0) {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = path;
		_tmp15_ = ca_strerror (r);
		g_warning ("iagno.vala:490: Error playing %s: %s", _tmp14_, _tmp15_);
	}
	_g_free0 (path);
	_g_free0 (name);
}

static void
iagno_class_init (IagnoClass * klass,
                  gpointer klass_data)
{
	iagno_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Iagno_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) iagno_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) iagno_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) iagno_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) iagno_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
}

static void
iagno_instance_init (Iagno * self,
                     gpointer klass)
{
	self->priv = iagno_get_instance_private (self);
	self->priv->computer = NULL;
	self->priv->game = NULL;
}

static void
iagno_finalize (GObject * obj)
{
	Iagno * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->dark_score_label);
	_g_object_unref0 (self->priv->light_score_label);
	_g_object_unref0 (self->priv->themes_dialog);
	_g_object_unref0 (self->priv->computer);
	_g_object_unref0 (self->priv->game);
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
}

GType
iagno_get_type (void)
{
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (gtk_application_get_type (), "Iagno", &g_define_type_info, 0);
		Iagno_private_offset = g_type_add_instance_private (iagno_type_id, sizeof (IagnoPrivate));
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

