/* game.c generated by valac 0.42.1.36-3777c, the Vala compiler
 * generated from game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;
typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

#define TYPE_PLAYER (player_get_type ())
enum  {
	GAME_0_PROPERTY,
	GAME_SIZE_PROPERTY,
	GAME_CURRENT_COLOR_PROPERTY,
	GAME_NUMBER_OF_MOVES_PROPERTY,
	GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY,
	GAME_IS_COMPLETE_PROPERTY,
	GAME_INITIAL_NUMBER_OF_TILES_PROPERTY,
	GAME_N_TILES_PROPERTY,
	GAME_N_LIGHT_TILES_PROPERTY,
	GAME_N_DARK_TILES_PROPERTY,
	GAME_N_CURRENT_TILES_PROPERTY,
	GAME_N_OPPONENT_TILES_PROPERTY,
	GAME_NUM_PROPERTIES
};
static GParamSpec* game_properties[GAME_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GAME_TURN_ENDED_SIGNAL,
	GAME_SQUARE_CHANGED_SIGNAL,
	GAME_NUM_SIGNALS
};
static guint game_signals[GAME_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GamePrivate {
	Player* tiles;
	gint tiles_length1;
	gint tiles_length2;
	gint _size;
	gint** undo_stack;
	gint undo_stack_length1;
	gint _undo_stack_size_;
	gint history_index;
	Player _current_color;
	gint _number_of_moves;
	gboolean _current_player_can_move;
	gboolean _is_complete;
	gint _initial_number_of_tiles;
	gint _n_light_tiles;
	gint _n_dark_tiles;
};

static gint Game_private_offset;
static gpointer game_parent_class = NULL;

GType game_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
Game* game_new (gboolean alternative_start,
                gint tmp_size);
Game* game_construct (GType object_type,
                      gboolean alternative_start,
                      gint tmp_size);
static void game_set_size (Game* self,
                    gint value);
gint game_get_size (Game* self);
static void game_set_initial_number_of_tiles (Game* self,
                                       gint value);
static void game_set_n_current_tiles (Game* self,
                               gint value);
static void game_set_n_opponent_tiles (Game* self,
                                gint value);
Game* game_new_from_strings (gchar** setup,
                             gint setup_length1,
                             Player to_move,
                             gint tmp_size);
Game* game_construct_from_strings (GType object_type,
                                   gchar** setup,
                                   gint setup_length1,
                                   Player to_move,
                                   gint tmp_size);
Player player_from_char (gchar c);
static void game_set_current_color (Game* self,
                             Player value);
gchar* game_to_string (Game* self);
gchar* player_to_string (Player self);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type,
                           Game* game);
gint game_get_number_of_moves (Game* self);
static void game_set_number_of_moves (Game* self,
                               gint value);
Player game_get_current_color (Game* self);
gint game_get_n_current_tiles (Game* self);
gint game_get_n_opponent_tiles (Game* self);
gboolean game_is_valid_location (Game* self,
                                 gint x,
                                 gint y);
Player game_get_owner (Game* self,
                       gint x,
                       gint y);
gboolean game_can_place (Game* self,
                         gint x,
                         gint y,
                         Player color);
static gint game_can_flip_tiles (Game* self,
                          gint x,
                          gint y,
                          gint x_step,
                          gint y_step,
                          Player color);
gint game_place_tile (Game* self,
                      gint x,
                      gint y,
                      gboolean apply);
static gint game_flip_tiles (Game* self,
                      gint x,
                      gint y,
                      gint x_step,
                      gint y_step,
                      gboolean apply);
static void game_set_tile (Game* self,
                    gint x,
                    gint y);
static void game_end_of_turn (Game* self);
void game_pass (Game* self);
gboolean game_get_current_player_can_move (Game* self);
Player player_flip_color (Player p);
static void game_update_who_can_move (Game* self);
static void game_set_current_player_can_move (Game* self,
                                       gboolean value);
static void game_set_is_complete (Game* self,
                           gboolean value);
static gint* _int_dup (gint* self);
void game_undo (Game* self,
                gint count);
static void game_unset_tile (Game* self,
                      gint tile_number,
                      Player replacement_color);
gboolean game_get_is_complete (Game* self);
gint game_get_initial_number_of_tiles (Game* self);
gint game_get_n_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
static void g_cclosure_user_marshal_VOID__INT_INT_ENUM (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data);
static void game_finalize (GObject * obj);
static void _vala_game_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_game_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
game_get_instance_private (Game* self)
{
	return G_STRUCT_MEMBER_P (self, Game_private_offset);
}

Game*
game_construct (GType object_type,
                gboolean alternative_start,
                gint tmp_size)
{
	Game * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Player* _tmp4_;
	gint _tmp14_;
	gint _tmp15_;
	gint** _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	_vala_return_val_if_fail (tmp_size >= 4, "tmp_size >= 4", NULL);
	self = (Game*) g_object_new (object_type, NULL);
	game_set_size (self, tmp_size);
	_tmp0_ = game_get_size (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_size (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_new0 (Player, _tmp1_ * _tmp3_);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->tiles = _tmp4_;
	self->priv->tiles_length1 = _tmp1_;
	self->priv->tiles_length2 = _tmp3_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = x;
					x = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = game_get_size (self);
				_tmp8_ = _tmp7_;
				if (!(x < _tmp8_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_;
							gint _tmp12_;
							Player* _tmp13_;
							gint _tmp13__length1;
							gint _tmp13__length2;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = y;
								y = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = game_get_size (self);
							_tmp12_ = _tmp11_;
							if (!(y < _tmp12_)) {
								break;
							}
							_tmp13_ = self->priv->tiles;
							_tmp13__length1 = self->priv->tiles_length1;
							_tmp13__length2 = self->priv->tiles_length2;
							_tmp13_[(x * _tmp13__length2) + y] = PLAYER_NONE;
						}
					}
				}
			}
		}
	}
	_tmp14_ = game_get_size (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_new0 (gint*, 180 * (_tmp15_ - 1));
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
	self->priv->undo_stack = _tmp16_;
	self->priv->undo_stack_length1 = 180 * (_tmp15_ - 1);
	self->priv->_undo_stack_size_ = self->priv->undo_stack_length1;
	_tmp17_ = game_get_size (self);
	_tmp18_ = _tmp17_;
	if ((_tmp18_ % 2) == 0) {
		Player _tmp19_ = 0;
		Player* _tmp20_;
		gint _tmp20__length1;
		gint _tmp20__length2;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		Player* _tmp25_;
		gint _tmp25__length1;
		gint _tmp25__length2;
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		Player _tmp30_ = 0;
		Player* _tmp31_;
		gint _tmp31__length1;
		gint _tmp31__length2;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		Player* _tmp36_;
		gint _tmp36__length1;
		gint _tmp36__length2;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		game_set_initial_number_of_tiles (self, 4);
		if (alternative_start) {
			_tmp19_ = PLAYER_DARK;
		} else {
			_tmp19_ = PLAYER_LIGHT;
		}
		_tmp20_ = self->priv->tiles;
		_tmp20__length1 = self->priv->tiles_length1;
		_tmp20__length2 = self->priv->tiles_length2;
		_tmp21_ = game_get_size (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = game_get_size (self);
		_tmp24_ = _tmp23_;
		_tmp20_[(((_tmp22_ / 2) - 1) * _tmp20__length2) + ((_tmp24_ / 2) - 1)] = _tmp19_;
		_tmp25_ = self->priv->tiles;
		_tmp25__length1 = self->priv->tiles_length1;
		_tmp25__length2 = self->priv->tiles_length2;
		_tmp26_ = game_get_size (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = game_get_size (self);
		_tmp29_ = _tmp28_;
		_tmp25_[(((_tmp27_ / 2) - 1) * _tmp25__length2) + (_tmp29_ / 2)] = PLAYER_DARK;
		if (alternative_start) {
			_tmp30_ = PLAYER_LIGHT;
		} else {
			_tmp30_ = PLAYER_DARK;
		}
		_tmp31_ = self->priv->tiles;
		_tmp31__length1 = self->priv->tiles_length1;
		_tmp31__length2 = self->priv->tiles_length2;
		_tmp32_ = game_get_size (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = game_get_size (self);
		_tmp35_ = _tmp34_;
		_tmp31_[((_tmp33_ / 2) * _tmp31__length2) + ((_tmp35_ / 2) - 1)] = _tmp30_;
		_tmp36_ = self->priv->tiles;
		_tmp36__length1 = self->priv->tiles_length1;
		_tmp36__length2 = self->priv->tiles_length2;
		_tmp37_ = game_get_size (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = game_get_size (self);
		_tmp40_ = _tmp39_;
		_tmp36_[((_tmp38_ / 2) * _tmp36__length2) + (_tmp40_ / 2)] = PLAYER_LIGHT;
		game_set_n_current_tiles (self, 2);
		game_set_n_opponent_tiles (self, 2);
	} else {
		Player* _tmp41_;
		gint _tmp41__length1;
		gint _tmp41__length2;
		gint _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		Player _tmp46_ = 0;
		Player* _tmp47_;
		gint _tmp47__length1;
		gint _tmp47__length2;
		gint _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		Player _tmp52_ = 0;
		Player* _tmp53_;
		gint _tmp53__length1;
		gint _tmp53__length2;
		gint _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		Player* _tmp58_;
		gint _tmp58__length1;
		gint _tmp58__length2;
		gint _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		Player _tmp63_ = 0;
		Player* _tmp64_;
		gint _tmp64__length1;
		gint _tmp64__length2;
		gint _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		Player _tmp69_ = 0;
		Player* _tmp70_;
		gint _tmp70__length1;
		gint _tmp70__length2;
		gint _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		Player* _tmp75_;
		gint _tmp75__length1;
		gint _tmp75__length2;
		gint _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		game_set_initial_number_of_tiles (self, 7);
		_tmp41_ = self->priv->tiles;
		_tmp41__length1 = self->priv->tiles_length1;
		_tmp41__length2 = self->priv->tiles_length2;
		_tmp42_ = game_get_size (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = game_get_size (self);
		_tmp45_ = _tmp44_;
		_tmp41_[(((_tmp43_ - 1) / 2) * _tmp41__length2) + ((_tmp45_ - 1) / 2)] = PLAYER_DARK;
		if (alternative_start) {
			_tmp46_ = PLAYER_LIGHT;
		} else {
			_tmp46_ = PLAYER_DARK;
		}
		_tmp47_ = self->priv->tiles;
		_tmp47__length1 = self->priv->tiles_length1;
		_tmp47__length2 = self->priv->tiles_length2;
		_tmp48_ = game_get_size (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = game_get_size (self);
		_tmp51_ = _tmp50_;
		_tmp47_[(((_tmp49_ + 1) / 2) * _tmp47__length2) + ((_tmp51_ - 3) / 2)] = _tmp46_;
		if (alternative_start) {
			_tmp52_ = PLAYER_LIGHT;
		} else {
			_tmp52_ = PLAYER_DARK;
		}
		_tmp53_ = self->priv->tiles;
		_tmp53__length1 = self->priv->tiles_length1;
		_tmp53__length2 = self->priv->tiles_length2;
		_tmp54_ = game_get_size (self);
		_tmp55_ = _tmp54_;
		_tmp56_ = game_get_size (self);
		_tmp57_ = _tmp56_;
		_tmp53_[(((_tmp55_ - 3) / 2) * _tmp53__length2) + ((_tmp57_ + 1) / 2)] = _tmp52_;
		_tmp58_ = self->priv->tiles;
		_tmp58__length1 = self->priv->tiles_length1;
		_tmp58__length2 = self->priv->tiles_length2;
		_tmp59_ = game_get_size (self);
		_tmp60_ = _tmp59_;
		_tmp61_ = game_get_size (self);
		_tmp62_ = _tmp61_;
		_tmp58_[(((_tmp60_ - 1) / 2) * _tmp58__length2) + ((_tmp62_ - 3) / 2)] = PLAYER_LIGHT;
		if (alternative_start) {
			_tmp63_ = PLAYER_DARK;
		} else {
			_tmp63_ = PLAYER_LIGHT;
		}
		_tmp64_ = self->priv->tiles;
		_tmp64__length1 = self->priv->tiles_length1;
		_tmp64__length2 = self->priv->tiles_length2;
		_tmp65_ = game_get_size (self);
		_tmp66_ = _tmp65_;
		_tmp67_ = game_get_size (self);
		_tmp68_ = _tmp67_;
		_tmp64_[(((_tmp66_ - 3) / 2) * _tmp64__length2) + ((_tmp68_ - 1) / 2)] = _tmp63_;
		if (alternative_start) {
			_tmp69_ = PLAYER_DARK;
		} else {
			_tmp69_ = PLAYER_LIGHT;
		}
		_tmp70_ = self->priv->tiles;
		_tmp70__length1 = self->priv->tiles_length1;
		_tmp70__length2 = self->priv->tiles_length2;
		_tmp71_ = game_get_size (self);
		_tmp72_ = _tmp71_;
		_tmp73_ = game_get_size (self);
		_tmp74_ = _tmp73_;
		_tmp70_[(((_tmp72_ + 1) / 2) * _tmp70__length2) + ((_tmp74_ - 1) / 2)] = _tmp69_;
		_tmp75_ = self->priv->tiles;
		_tmp75__length1 = self->priv->tiles_length1;
		_tmp75__length2 = self->priv->tiles_length2;
		_tmp76_ = game_get_size (self);
		_tmp77_ = _tmp76_;
		_tmp78_ = game_get_size (self);
		_tmp79_ = _tmp78_;
		_tmp75_[(((_tmp77_ - 1) / 2) * _tmp75__length2) + ((_tmp79_ + 1) / 2)] = PLAYER_LIGHT;
		game_set_n_current_tiles (self, 3);
		game_set_n_opponent_tiles (self, 4);
	}
	return self;
}

Game*
game_new (gboolean alternative_start,
          gint tmp_size)
{
	return game_construct (TYPE_GAME, alternative_start, tmp_size);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}

Game*
game_construct_from_strings (GType object_type,
                             gchar** setup,
                             gint setup_length1,
                             Player to_move,
                             gint tmp_size)
{
	Game * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Player* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint** _tmp7_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	_vala_return_val_if_fail (setup_length1 == tmp_size, "setup.length == tmp_size", NULL);
	self = (Game*) g_object_new (object_type, NULL);
	game_set_size (self, tmp_size);
	_tmp0_ = game_get_size (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_size (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_new0 (Player, _tmp1_ * _tmp3_);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->tiles = _tmp4_;
	self->priv->tiles_length1 = _tmp1_;
	self->priv->tiles_length2 = _tmp3_;
	_tmp5_ = game_get_size (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (gint*, 180 * (_tmp6_ - 1));
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
	self->priv->undo_stack = _tmp7_;
	self->priv->undo_stack_length1 = 180 * (_tmp6_ - 1);
	self->priv->_undo_stack_size_ = self->priv->undo_stack_length1;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = y;
					y = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = game_get_size (self);
				_tmp11_ = _tmp10_;
				if (!(y < _tmp11_)) {
					break;
				}
				_tmp12_ = setup[y];
				_tmp13_ = strlen (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = game_get_size (self);
				_tmp16_ = _tmp15_;
				if (_tmp14_ != (_tmp16_ * 2)) {
					g_warn_if_reached ();
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							gint _tmp19_;
							gint _tmp20_;
							Player* _tmp21_;
							gint _tmp21__length1;
							gint _tmp21__length2;
							const gchar* _tmp22_;
							if (!_tmp17_) {
								gint _tmp18_;
								_tmp18_ = x;
								x = _tmp18_ + 1;
							}
							_tmp17_ = FALSE;
							_tmp19_ = game_get_size (self);
							_tmp20_ = _tmp19_;
							if (!(x < _tmp20_)) {
								break;
							}
							_tmp21_ = self->priv->tiles;
							_tmp21__length1 = self->priv->tiles_length1;
							_tmp21__length2 = self->priv->tiles_length2;
							_tmp22_ = setup[y];
							_tmp21_[(x * _tmp21__length2) + y] = player_from_char (string_get (_tmp22_, (glong) ((x * 2) + 1)));
						}
					}
				}
			}
		}
	}
	game_set_current_color (self, to_move);
	_tmp23_ = _vala_g_strjoinv ("\n", setup, (gint) setup_length1);
	_tmp24_ = _tmp23_;
	_tmp25_ = string_strip (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = game_to_string (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = string_strip (_tmp28_);
	_tmp30_ = _tmp29_;
	g_warn_if_fail (g_strcmp0 (_tmp26_, _tmp30_) == 0);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	return self;
}

Game*
game_new_from_strings (gchar** setup,
                       gint setup_length1,
                       Player to_move,
                       gint tmp_size)
{
	return game_construct_from_strings (TYPE_GAME, setup, setup_length1, to_move, tmp_size);
}

gchar*
game_to_string (Game* self)
{
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\n");
	s = _tmp0_;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = y;
					y = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = game_get_size (self);
				_tmp4_ = _tmp3_;
				if (!(y < _tmp4_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_;
							gint _tmp8_;
							const gchar* _tmp9_;
							Player* _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							Player _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							gchar* _tmp16_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = x;
								x = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = game_get_size (self);
							_tmp8_ = _tmp7_;
							if (!(x < _tmp8_)) {
								break;
							}
							_tmp9_ = s;
							_tmp10_ = self->priv->tiles;
							_tmp10__length1 = self->priv->tiles_length1;
							_tmp10__length2 = self->priv->tiles_length2;
							_tmp11_ = _tmp10_[(x * _tmp10__length2) + y];
							_tmp12_ = player_to_string (_tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = g_strconcat (" ", _tmp13_, NULL);
							_tmp15_ = _tmp14_;
							_tmp16_ = g_strconcat (_tmp9_, _tmp15_, NULL);
							_g_free0 (s);
							s = _tmp16_;
							_g_free0 (_tmp15_);
							_g_free0 (_tmp13_);
						}
					}
				}
				_tmp17_ = s;
				_tmp18_ = g_strconcat (_tmp17_, "\n", NULL);
				_g_free0 (s);
				s = _tmp18_;
			}
		}
	}
	result = s;
	return result;
}

Game*
game_construct_copy (GType object_type,
                     Game* game)
{
	Game * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Player* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint** _tmp9_;
	gint _tmp21_;
	Player _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	g_return_val_if_fail (game != NULL, NULL);
	self = (Game*) g_object_new (object_type, NULL);
	_tmp0_ = game_get_size (game);
	_tmp1_ = _tmp0_;
	game_set_size (self, _tmp1_);
	_tmp2_ = game_get_size (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = game_get_size (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_new0 (Player, _tmp3_ * _tmp5_);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->tiles = _tmp6_;
	self->priv->tiles_length1 = _tmp3_;
	self->priv->tiles_length2 = _tmp5_;
	_tmp7_ = game_get_size (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_new0 (gint*, 180 * (_tmp8_ - 1));
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
	self->priv->undo_stack = _tmp9_;
	self->priv->undo_stack_length1 = 180 * (_tmp8_ - 1);
	self->priv->_undo_stack_size_ = self->priv->undo_stack_length1;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint _tmp12_;
				gint _tmp13_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = x;
					x = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = game_get_size (self);
				_tmp13_ = _tmp12_;
				if (!(x < _tmp13_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							gint _tmp16_;
							gint _tmp17_;
							Player* _tmp18_;
							gint _tmp18__length1;
							gint _tmp18__length2;
							Player* _tmp19_;
							gint _tmp19__length1;
							gint _tmp19__length2;
							Player _tmp20_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = y;
								y = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							_tmp16_ = game_get_size (self);
							_tmp17_ = _tmp16_;
							if (!(y < _tmp17_)) {
								break;
							}
							_tmp18_ = self->priv->tiles;
							_tmp18__length1 = self->priv->tiles_length1;
							_tmp18__length2 = self->priv->tiles_length2;
							_tmp19_ = game->priv->tiles;
							_tmp19__length1 = game->priv->tiles_length1;
							_tmp19__length2 = game->priv->tiles_length2;
							_tmp20_ = _tmp19_[(x * _tmp19__length2) + y];
							_tmp18_[(x * _tmp18__length2) + y] = _tmp20_;
						}
					}
				}
			}
		}
	}
	_tmp21_ = game->priv->_number_of_moves;
	game_set_number_of_moves (self, _tmp21_);
	_tmp22_ = game->priv->_current_color;
	game_set_current_color (self, _tmp22_);
	_tmp23_ = game_get_n_current_tiles (game);
	_tmp24_ = _tmp23_;
	game_set_n_current_tiles (self, _tmp24_);
	_tmp25_ = game_get_n_opponent_tiles (game);
	_tmp26_ = _tmp25_;
	game_set_n_opponent_tiles (self, _tmp26_);
	return self;
}

Game*
game_new_copy (Game* game)
{
	return game_construct_copy (TYPE_GAME, game);
}

gboolean
game_is_valid_location (Game* self,
                        gint x,
                        gint y)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (x >= 0) {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = game_get_size (self);
		_tmp4_ = _tmp3_;
		_tmp2_ = x < _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = y >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp5_;
		gint _tmp6_;
		_tmp5_ = game_get_size (self);
		_tmp6_ = _tmp5_;
		_tmp0_ = y < _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Player
game_get_owner (Game* self,
                gint x,
                gint y)
{
	Player result = 0;
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Player _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_vala_return_val_if_fail (game_is_valid_location (self, x, y), "is_valid_location (x, y)", 0);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	result = _tmp1_;
	return result;
}

gboolean
game_can_place (Game* self,
                gint x,
                gint y,
                Player color)
{
	gboolean result = FALSE;
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Player _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_return_val_if_fail (game_is_valid_location (self, x, y), "is_valid_location (x, y)", FALSE);
	_vala_return_val_if_fail (color != PLAYER_NONE, "color != Player.NONE", FALSE);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	if (_tmp1_ != PLAYER_NONE) {
		result = FALSE;
		return result;
	}
	if (game_can_flip_tiles (self, x, y, 1, 0, color) > 0) {
		result = TRUE;
		return result;
	}
	if (game_can_flip_tiles (self, x, y, 1, 1, color) > 0) {
		result = TRUE;
		return result;
	}
	if (game_can_flip_tiles (self, x, y, 0, 1, color) > 0) {
		result = TRUE;
		return result;
	}
	if (game_can_flip_tiles (self, x, y, -1, 1, color) > 0) {
		result = TRUE;
		return result;
	}
	if (game_can_flip_tiles (self, x, y, -1, 0, color) > 0) {
		result = TRUE;
		return result;
	}
	if (game_can_flip_tiles (self, x, y, -1, -1, color) > 0) {
		result = TRUE;
		return result;
	}
	if (game_can_flip_tiles (self, x, y, 0, -1, color) > 0) {
		result = TRUE;
		return result;
	}
	if (game_can_flip_tiles (self, x, y, 1, -1, color) > 0) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gint
game_place_tile (Game* self,
                 gint x,
                 gint y,
                 gboolean apply)
{
	gint result = 0;
	Player* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Player _tmp1_;
	gint tiles_turned = 0;
	g_return_val_if_fail (self != NULL, 0);
	_vala_return_val_if_fail (game_is_valid_location (self, x, y), "is_valid_location (x, y)", 0);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	if (_tmp1_ != PLAYER_NONE) {
		result = 0;
		return result;
	}
	tiles_turned = 0;
	tiles_turned += game_flip_tiles (self, x, y, 1, 0, apply);
	tiles_turned += game_flip_tiles (self, x, y, 1, 1, apply);
	tiles_turned += game_flip_tiles (self, x, y, 0, 1, apply);
	tiles_turned += game_flip_tiles (self, x, y, -1, 1, apply);
	tiles_turned += game_flip_tiles (self, x, y, -1, 0, apply);
	tiles_turned += game_flip_tiles (self, x, y, -1, -1, apply);
	tiles_turned += game_flip_tiles (self, x, y, 0, -1, apply);
	tiles_turned += game_flip_tiles (self, x, y, 1, -1, apply);
	if (tiles_turned == 0) {
		result = 0;
		return result;
	}
	if (apply) {
		game_set_tile (self, x, y);
		game_end_of_turn (self);
	}
	result = tiles_turned;
	return result;
}

void
game_pass (Game* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_player_can_move;
	_vala_return_if_fail (!_tmp0_, "!current_player_can_move");
	game_end_of_turn (self);
}

static void
game_end_of_turn (Game* self)
{
	gint** _tmp0_;
	gint _tmp0__length1;
	Player _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_stack;
	_tmp0__length1 = self->priv->undo_stack_length1;
	_vala_return_if_fail ((self->priv->history_index >= -1) && (self->priv->history_index < (_tmp0__length1 - 2)), "history_index >= -1 && history_index < undo_stack.length - 2");
	_tmp1_ = self->priv->_current_color;
	game_set_current_color (self, player_flip_color (_tmp1_));
	_tmp2_ = self->priv->_number_of_moves;
	game_set_number_of_moves (self, _tmp2_ + 1);
	_tmp3_ = self->priv->history_index;
	self->priv->history_index = _tmp3_ + 1;
	_tmp4_ = self->priv->undo_stack;
	_tmp4__length1 = self->priv->undo_stack_length1;
	_g_free0 (_tmp4_[self->priv->history_index]);
	_tmp4_[self->priv->history_index] = NULL;
	game_update_who_can_move (self);
	g_signal_emit (self, game_signals[GAME_TURN_ENDED_SIGNAL], 0);
}

static void
game_update_who_can_move (Game* self)
{
	Player enemy = 0;
	Player _tmp0_;
	gboolean opponent_can_move = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_color;
	enemy = player_flip_color (_tmp0_);
	opponent_can_move = FALSE;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = game_get_size (self);
				_tmp4_ = _tmp3_;
				if (!(x < _tmp4_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_;
							gint _tmp8_;
							Player _tmp9_;
							Player _tmp10_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = game_get_size (self);
							_tmp8_ = _tmp7_;
							if (!(y < _tmp8_)) {
								break;
							}
							_tmp9_ = self->priv->_current_color;
							if (game_can_place (self, x, y, _tmp9_)) {
								game_set_current_player_can_move (self, TRUE);
								return;
							}
							_tmp10_ = enemy;
							if (game_can_place (self, x, y, _tmp10_)) {
								opponent_can_move = TRUE;
							}
						}
					}
				}
			}
		}
	}
	game_set_current_player_can_move (self, FALSE);
	if (!opponent_can_move) {
		game_set_is_complete (self, TRUE);
	}
}

static gint
game_flip_tiles (Game* self,
                 gint x,
                 gint y,
                 gint x_step,
                 gint y_step,
                 gboolean apply)
{
	gint result = 0;
	gint enemy_count = 0;
	Player _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_current_color;
	enemy_count = game_can_flip_tiles (self, x, y, x_step, y_step, _tmp0_);
	if (enemy_count == 0) {
		result = 0;
		return result;
	}
	if (apply) {
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_;
					gint _tmp4_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					if (!(i <= enemy_count)) {
						break;
					}
					_tmp3_ = game_get_n_opponent_tiles (self);
					_tmp4_ = _tmp3_;
					game_set_n_opponent_tiles (self, _tmp4_ - 1);
					game_set_tile (self, x + (i * x_step), y + (i * y_step));
				}
			}
		}
	}
	result = enemy_count;
	return result;
}

static gint
game_can_flip_tiles (Game* self,
                     gint x,
                     gint y,
                     gint x_step,
                     gint y_step,
                     Player color)
{
	gint result = 0;
	Player enemy = 0;
	gint enemy_count = 0;
	gint xt = 0;
	gint yt = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	enemy = player_flip_color (color);
	enemy_count = -1;
	xt = x;
	yt = y;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp5_;
			if (!_tmp0_) {
				gboolean _tmp1_ = FALSE;
				if (game_is_valid_location (self, xt, yt)) {
					Player* _tmp2_;
					gint _tmp2__length1;
					gint _tmp2__length2;
					Player _tmp3_;
					Player _tmp4_;
					_tmp2_ = self->priv->tiles;
					_tmp2__length1 = self->priv->tiles_length1;
					_tmp2__length2 = self->priv->tiles_length2;
					_tmp3_ = _tmp2_[(xt * _tmp2__length2) + yt];
					_tmp4_ = enemy;
					_tmp1_ = _tmp3_ == _tmp4_;
				} else {
					_tmp1_ = FALSE;
				}
				if (!_tmp1_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp5_ = enemy_count;
			enemy_count = _tmp5_ + 1;
			xt += x_step;
			yt += y_step;
		}
	}
	if (enemy_count == 0) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = !game_is_valid_location (self, xt, yt);
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		Player* _tmp8_;
		gint _tmp8__length1;
		gint _tmp8__length2;
		Player _tmp9_;
		_tmp8_ = self->priv->tiles;
		_tmp8__length1 = self->priv->tiles_length1;
		_tmp8__length2 = self->priv->tiles_length2;
		_tmp9_ = _tmp8_[(xt * _tmp8__length2) + yt];
		_tmp6_ = _tmp9_ != color;
	}
	if (_tmp6_) {
		result = 0;
		return result;
	}
	result = enemy_count;
	return result;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static void
game_set_tile (Game* self,
               gint x,
               gint y)
{
	gint** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint* _tmp8_;
	Player* _tmp9_;
	gint _tmp9__length1;
	gint _tmp9__length2;
	Player _tmp10_;
	Player _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_stack;
	_tmp0__length1 = self->priv->undo_stack_length1;
	_vala_return_if_fail ((self->priv->history_index >= -1) && (self->priv->history_index < (_tmp0__length1 - 2)), "history_index >= -1 && history_index < undo_stack.length - 2");
	_tmp1_ = game_get_n_current_tiles (self);
	_tmp2_ = _tmp1_;
	game_set_n_current_tiles (self, _tmp2_ + 1);
	_tmp3_ = self->priv->history_index;
	self->priv->history_index = _tmp3_ + 1;
	_tmp4_ = self->priv->undo_stack;
	_tmp4__length1 = self->priv->undo_stack_length1;
	_tmp5_ = game_get_size (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = x + (y * _tmp6_);
	_tmp8_ = __int_dup0 (&_tmp7_);
	_g_free0 (_tmp4_[self->priv->history_index]);
	_tmp4_[self->priv->history_index] = _tmp8_;
	_tmp9_ = self->priv->tiles;
	_tmp9__length1 = self->priv->tiles_length1;
	_tmp9__length2 = self->priv->tiles_length2;
	_tmp10_ = self->priv->_current_color;
	_tmp9_[(x * _tmp9__length2) + y] = _tmp10_;
	_tmp11_ = self->priv->_current_color;
	g_signal_emit (self, game_signals[GAME_SQUARE_CHANGED_SIGNAL], 0, x, y, _tmp11_);
}

void
game_undo (Game* self,
           gint count)
{
	gint _tmp0_;
	gint** _tmp1_;
	gint _tmp1__length1;
	Player enemy = 0;
	Player _tmp2_;
	Player _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint** _tmp6_;
	gint _tmp6__length1;
	gint* _tmp7_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail ((count == 1) || (count == 2), "count == 1 || count == 2");
	_tmp0_ = self->priv->_number_of_moves;
	_vala_return_if_fail (_tmp0_ >= count, "number_of_moves >= count");
	_tmp1_ = self->priv->undo_stack;
	_tmp1__length1 = self->priv->undo_stack_length1;
	_vala_return_if_fail (self->priv->history_index < _tmp1__length1, "history_index < undo_stack.length");
	_tmp2_ = self->priv->_current_color;
	enemy = _tmp2_;
	_tmp3_ = self->priv->_current_color;
	game_set_current_color (self, player_flip_color (_tmp3_));
	_tmp4_ = self->priv->_number_of_moves;
	game_set_number_of_moves (self, _tmp4_ - 1);
	_tmp5_ = self->priv->history_index;
	self->priv->history_index = _tmp5_ - 1;
	_tmp6_ = self->priv->undo_stack;
	_tmp6__length1 = self->priv->undo_stack_length1;
	_tmp7_ = _tmp6_[self->priv->history_index];
	if (_tmp7_ != NULL) {
		gint** _tmp8_;
		gint _tmp8__length1;
		gint* _tmp9_;
		_tmp8_ = self->priv->undo_stack;
		_tmp8__length1 = self->priv->undo_stack_length1;
		_tmp9_ = _tmp8_[self->priv->history_index];
		game_unset_tile (self, *_tmp9_, PLAYER_NONE);
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			gint _tmp13_;
			gint _tmp14_;
			gint** _tmp15_;
			gint _tmp15__length1;
			gint* _tmp16_;
			Player _tmp17_;
			if (self->priv->history_index > -1) {
				gint** _tmp11_;
				gint _tmp11__length1;
				gint* _tmp12_;
				_tmp11_ = self->priv->undo_stack;
				_tmp11__length1 = self->priv->undo_stack_length1;
				_tmp12_ = _tmp11_[self->priv->history_index];
				_tmp10_ = _tmp12_ != NULL;
			} else {
				_tmp10_ = FALSE;
			}
			if (!_tmp10_) {
				break;
			}
			_tmp13_ = game_get_n_opponent_tiles (self);
			_tmp14_ = _tmp13_;
			game_set_n_opponent_tiles (self, _tmp14_ + 1);
			_tmp15_ = self->priv->undo_stack;
			_tmp15__length1 = self->priv->undo_stack_length1;
			_tmp16_ = _tmp15_[self->priv->history_index];
			_tmp17_ = enemy;
			game_unset_tile (self, *_tmp16_, _tmp17_);
		}
	}
	if (count == 1) {
		game_set_is_complete (self, FALSE);
		game_update_who_can_move (self);
	} else {
		game_undo (self, count - 1);
	}
}

static void
game_unset_tile (Game* self,
                 gint tile_number,
                 Player replacement_color)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint x = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint y = 0;
	gint _tmp5_;
	gint _tmp6_;
	Player* _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_get_n_current_tiles (self);
	_tmp1_ = _tmp0_;
	game_set_n_current_tiles (self, _tmp1_ - 1);
	_tmp2_ = self->priv->history_index;
	self->priv->history_index = _tmp2_ - 1;
	_tmp3_ = game_get_size (self);
	_tmp4_ = _tmp3_;
	x = tile_number % _tmp4_;
	_tmp5_ = game_get_size (self);
	_tmp6_ = _tmp5_;
	y = tile_number / _tmp6_;
	_tmp7_ = self->priv->tiles;
	_tmp7__length1 = self->priv->tiles_length1;
	_tmp7__length2 = self->priv->tiles_length2;
	_tmp7_[(x * _tmp7__length2) + y] = replacement_color;
	g_signal_emit (self, game_signals[GAME_SQUARE_CHANGED_SIGNAL], 0, x, y, replacement_color);
}

gint
game_get_size (Game* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_size;
	return result;
}

static void
game_set_size (Game* self,
               gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_size = value;
	g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_SIZE_PROPERTY]);
}

Player
game_get_current_color (Game* self)
{
	Player result;
	Player _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_current_color;
	result = _tmp0_;
	return result;
}

static void
game_set_current_color (Game* self,
                        Player value)
{
	g_return_if_fail (self != NULL);
	if (game_get_current_color (self) != value) {
		self->priv->_current_color = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_CURRENT_COLOR_PROPERTY]);
	}
}

gint
game_get_number_of_moves (Game* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_number_of_moves;
	return result;
}

static void
game_set_number_of_moves (Game* self,
                          gint value)
{
	g_return_if_fail (self != NULL);
	if (game_get_number_of_moves (self) != value) {
		self->priv->_number_of_moves = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_NUMBER_OF_MOVES_PROPERTY]);
	}
}

gboolean
game_get_current_player_can_move (Game* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_current_player_can_move;
	return result;
}

static void
game_set_current_player_can_move (Game* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	if (game_get_current_player_can_move (self) != value) {
		self->priv->_current_player_can_move = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY]);
	}
}

gboolean
game_get_is_complete (Game* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_complete;
	return result;
}

static void
game_set_is_complete (Game* self,
                      gboolean value)
{
	g_return_if_fail (self != NULL);
	if (game_get_is_complete (self) != value) {
		self->priv->_is_complete = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_IS_COMPLETE_PROPERTY]);
	}
}

gint
game_get_initial_number_of_tiles (Game* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_initial_number_of_tiles;
	return result;
}

static void
game_set_initial_number_of_tiles (Game* self,
                                  gint value)
{
	g_return_if_fail (self != NULL);
	if (game_get_initial_number_of_tiles (self) != value) {
		self->priv->_initial_number_of_tiles = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_INITIAL_NUMBER_OF_TILES_PROPERTY]);
	}
}

gint
game_get_n_tiles (Game* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_get_n_dark_tiles (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_n_light_tiles (self);
	_tmp3_ = _tmp2_;
	result = _tmp1_ + _tmp3_;
	return result;
}

gint
game_get_n_light_tiles (Game* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_n_light_tiles;
	return result;
}

gint
game_get_n_dark_tiles (Game* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_n_dark_tiles;
	return result;
}

gint
game_get_n_current_tiles (Game* self)
{
	gint result;
	gint _tmp0_ = 0;
	Player _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_current_color;
	if (_tmp1_ == PLAYER_LIGHT) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = game_get_n_light_tiles (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = game_get_n_dark_tiles (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

static void
game_set_n_current_tiles (Game* self,
                          gint value)
{
	Player _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_color;
	if (_tmp0_ == PLAYER_LIGHT) {
		self->priv->_n_light_tiles = value;
	} else {
		self->priv->_n_dark_tiles = value;
	}
	g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_N_CURRENT_TILES_PROPERTY]);
}

gint
game_get_n_opponent_tiles (Game* self)
{
	gint result;
	gint _tmp0_ = 0;
	Player _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_current_color;
	if (_tmp1_ == PLAYER_DARK) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = game_get_n_light_tiles (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = game_get_n_dark_tiles (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

static void
game_set_n_opponent_tiles (Game* self,
                           gint value)
{
	Player _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_color;
	if (_tmp0_ == PLAYER_DARK) {
		self->priv->_n_light_tiles = value;
	} else {
		self->priv->_n_dark_tiles = value;
	}
	g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_N_OPPONENT_TILES_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__INT_INT_ENUM (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_ENUM) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_enum (param_values + 3), data2);
}

static void
game_class_init (GameClass * klass,
                 gpointer klass_data)
{
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Game_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SIZE_PROPERTY, game_properties[GAME_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CURRENT_COLOR_PROPERTY, game_properties[GAME_CURRENT_COLOR_PROPERTY] = g_param_spec_enum ("current-color", "current-color", "current-color", TYPE_PLAYER, PLAYER_DARK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_NUMBER_OF_MOVES_PROPERTY, game_properties[GAME_NUMBER_OF_MOVES_PROPERTY] = g_param_spec_int ("number-of-moves", "number-of-moves", "number-of-moves", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY, game_properties[GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY] = g_param_spec_boolean ("current-player-can-move", "current-player-can-move", "current-player-can-move", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_IS_COMPLETE_PROPERTY, game_properties[GAME_IS_COMPLETE_PROPERTY] = g_param_spec_boolean ("is-complete", "is-complete", "is-complete", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_INITIAL_NUMBER_OF_TILES_PROPERTY, game_properties[GAME_INITIAL_NUMBER_OF_TILES_PROPERTY] = g_param_spec_int ("initial-number-of-tiles", "initial-number-of-tiles", "initial-number-of-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_TILES_PROPERTY, game_properties[GAME_N_TILES_PROPERTY] = g_param_spec_int ("n-tiles", "n-tiles", "n-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_LIGHT_TILES_PROPERTY, game_properties[GAME_N_LIGHT_TILES_PROPERTY] = g_param_spec_int ("n-light-tiles", "n-light-tiles", "n-light-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_DARK_TILES_PROPERTY, game_properties[GAME_N_DARK_TILES_PROPERTY] = g_param_spec_int ("n-dark-tiles", "n-dark-tiles", "n-dark-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_CURRENT_TILES_PROPERTY, game_properties[GAME_N_CURRENT_TILES_PROPERTY] = g_param_spec_int ("n-current-tiles", "n-current-tiles", "n-current-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_OPPONENT_TILES_PROPERTY, game_properties[GAME_N_OPPONENT_TILES_PROPERTY] = g_param_spec_int ("n-opponent-tiles", "n-opponent-tiles", "n-opponent-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	game_signals[GAME_TURN_ENDED_SIGNAL] = g_signal_new ("turn-ended", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_SQUARE_CHANGED_SIGNAL] = g_signal_new ("square-changed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_ENUM, G_TYPE_NONE, 3, G_TYPE_INT, G_TYPE_INT, TYPE_PLAYER);
}

static void
game_instance_init (Game * self,
                    gpointer klass)
{
	self->priv = game_get_instance_private (self);
	self->priv->history_index = -1;
	self->priv->_current_color = PLAYER_DARK;
	self->priv->_number_of_moves = 0;
	self->priv->_current_player_can_move = TRUE;
	self->priv->_is_complete = FALSE;
	self->priv->_n_light_tiles = 2;
	self->priv->_n_dark_tiles = 2;
}

static void
game_finalize (GObject * obj)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->undo_stack = (_vala_array_free (self->priv->undo_stack, self->priv->undo_stack_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}

GType
game_get_type (void)
{
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		Game_private_offset = g_type_add_instance_private (game_type_id, sizeof (GamePrivate));
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}

static void
_vala_game_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		g_value_set_int (value, game_get_size (self));
		break;
		case GAME_CURRENT_COLOR_PROPERTY:
		g_value_set_enum (value, game_get_current_color (self));
		break;
		case GAME_NUMBER_OF_MOVES_PROPERTY:
		g_value_set_int (value, game_get_number_of_moves (self));
		break;
		case GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY:
		g_value_set_boolean (value, game_get_current_player_can_move (self));
		break;
		case GAME_IS_COMPLETE_PROPERTY:
		g_value_set_boolean (value, game_get_is_complete (self));
		break;
		case GAME_INITIAL_NUMBER_OF_TILES_PROPERTY:
		g_value_set_int (value, game_get_initial_number_of_tiles (self));
		break;
		case GAME_N_TILES_PROPERTY:
		g_value_set_int (value, game_get_n_tiles (self));
		break;
		case GAME_N_LIGHT_TILES_PROPERTY:
		g_value_set_int (value, game_get_n_light_tiles (self));
		break;
		case GAME_N_DARK_TILES_PROPERTY:
		g_value_set_int (value, game_get_n_dark_tiles (self));
		break;
		case GAME_N_CURRENT_TILES_PROPERTY:
		g_value_set_int (value, game_get_n_current_tiles (self));
		break;
		case GAME_N_OPPONENT_TILES_PROPERTY:
		g_value_set_int (value, game_get_n_opponent_tiles (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		game_set_size (self, g_value_get_int (value));
		break;
		case GAME_CURRENT_COLOR_PROPERTY:
		game_set_current_color (self, g_value_get_enum (value));
		break;
		case GAME_NUMBER_OF_MOVES_PROPERTY:
		game_set_number_of_moves (self, g_value_get_int (value));
		break;
		case GAME_CURRENT_PLAYER_CAN_MOVE_PROPERTY:
		game_set_current_player_can_move (self, g_value_get_boolean (value));
		break;
		case GAME_IS_COMPLETE_PROPERTY:
		game_set_is_complete (self, g_value_get_boolean (value));
		break;
		case GAME_INITIAL_NUMBER_OF_TILES_PROPERTY:
		game_set_initial_number_of_tiles (self, g_value_get_int (value));
		break;
		case GAME_N_CURRENT_TILES_PROPERTY:
		game_set_n_current_tiles (self, g_value_get_int (value));
		break;
		case GAME_N_OPPONENT_TILES_PROPERTY:
		game_set_n_opponent_tiles (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

