
#ifndef __GLOBAL_H__
#define __GLOBAL_H__

#include <gnome.h>

/* GtkWidget is the storage type for widgets */
extern GtkWidget *window;
extern GtkWidget *notebook;

#include "dummy.h"

/*
  Menus
  &
  Toolbar
  */

#define MN(x) (g_list_nth (GTK_MENUBAR (GNOME_APP (window)->menubar) \
			   ->children, GTOP_MENU_ ## x)->data)

#define TBC(x) ((GtkToolbarChild *) \
			    (g_list_nth (GTK_TOOLBAR (GNOME_APP (window)->toolbar) \
					->children, GTOP_TBAR_ ## x))->data)

#define GTOP_MENU_VIEW           1
#define GTOP_MENU_MEMUSAGE       2
#define GTOP_MENU_SYSTEM         3
#define GTOP_MENU_HELP           4

#define GTOP_MENU_HIDE_BEGIN     GTOP_MENU_MEMUSAGE
#define GTOP_MENU_HIDE_END       GTOP_MENU_SYSTEM

#define GTOP_TBAR_RUN            0
#define GTOP_TBAR_STOP           1

extern GnomeUIInfo procViewMenu [];
extern GnomeUIInfo fileMenu [];

extern void procview_start_stop ();

extern char *tb_timer_xpm [];
extern char *tb_timer_stopped_xpm [];

extern GnomeUIInfo tbar [];
extern void (*gtop_time_cb)(GtkWidget *w, gpointer gp);

/* enums */

enum _gtop_pages {
	GTOP_PROCESSES,
	GTOP_SYSTEM,
};

enum _GTopPageSignal {
	GTOP_PAGE_LEAVE,
	GTOP_PAGE_ENTER,
	GTOP_PAGE_CFG_READ,
	GTOP_PAGE_CFG_SAVE,
};

typedef enum _GTopPageSignal GTopPageSignal;
typedef enum _GTopPages      GTopPages;

#define gnome_app_menu_hide(a, f, l) gnome_app_menu_traverse (gtk_widget_hide, a, f, l);
#define gnome_app_menu_show(a, f, l) gnome_app_menu_traverse (gtk_widget_show, a, f, l);

void gnome_app_menu_traverse (void (*fn) (GtkWidget *),
			      GnomeApp *app, gint first, gint last);

extern gint tb_ss;

#endif
