#ifndef __PROPERTIES_H__
#define __PROPERTIES_H__

typedef struct _GTopProperties GTopProperties;
typedef enum   _GTopPropFsMode GTopPropFsMode;
typedef enum   _GTopProcSelect GTopProcSelect;

#define MEMUSAGE_FIELDS		5

enum _GTopPropFsMode {
	GTOP_FSMODE_SUBLOCKS = 0,
	GTOP_FSMODE_BLOCKS,
	GTOP_FSMODE_INODES
};

enum _GTopProcSelect {
	GTOP_PROC_SELECT_ALL = 0,
	GTOP_PROC_SELECT_USER,
	GTOP_PROC_SELECT_TTY
};

struct _GTopProperties {
	GdkColor summary_cpu [4];
	GdkColor summary_mem [4];
	GdkColor summary_swap [2];
	glong memusage_thresholds [MEMUSAGE_FIELDS];
	GTopProcSelect proc_select;
	gint selected_fs;
	glong selected_fs_mask;
	GTopPropFsMode fsmode;
};

typedef struct _GTopPropertiesHook GTopPropertiesHook;

struct _GTopPropertiesHook {
	void (*init_func) (GTopPropertiesHook *, GtkWidget *);
	void (*apply_func) (GTopPropertiesHook *);
	void (*update_func) (GTopPropertiesHook *);
	void (*load_func) (GTopPropertiesHook *);
	void (*save_func) (GTopPropertiesHook *);
	GList *next;
};

extern GList *gtop_properties_hook;

extern GTopProperties gtop_temp_properties;
extern GTopProperties gtop_properties;

void gtop_properties_changed (void);
void gtop_show_properties (void);
void gtop_init_properties (void);

#endif
