// Generated by gmmproc 2.80.0 -- DO NOT MODIFY!
#ifndef _GDKMM_CICPPARAMS_H
#define _GDKMM_CICPPARAMS_H

#include <gdkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2024 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkCicpParams = struct _GdkCicpParams;
using GdkCicpParamsClass = struct _GdkCicpParamsClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class GDKMM_API CicpParams_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{
class GDKMM_API ColorState;

/** %Gdk::CicpParams contains the parameters that define
 * a colorstate according to the ITU-T H.273
 * [specification](https://www.itu.int/rec/T-REC-H.273/en).
 *
 * See the documentation of individual properties for supported values.
 *
 * The 'unspecified' value (2) is not treated in any special way, and
 * must be replaced by a different value before creating a color state.
 *
 * %Gdk::CicpParams can be used as a builder object to construct a color
 * state from Cicp data with build_color_state().
 * The function will throw an exception if the given parameters are not
 * supported.
 *
 * You can obtain a %Gdk::CicpParams object from a color state with
 * Gdk::ColorState::create_cicp_params(). This can be used to
 * create a variant of a color state, by changing just one of the cicp
 * parameters, or just to obtain information about the color state.
 *
 * @newin{4,16}
 */

class GDKMM_API CicpParams : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = CicpParams;
  using CppClassType = CicpParams_Class;
  using BaseObjectType = GdkCicpParams;
  using BaseClassType = GdkCicpParamsClass;

  // noncopyable
  CicpParams(const CicpParams&) = delete;
  CicpParams& operator=(const CicpParams&) = delete;

private:  friend class CicpParams_Class;
  static CppClassType cicpparams_class_;

protected:
  explicit CicpParams(const Glib::ConstructParams& construct_params);
  explicit CicpParams(GdkCicpParams* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  CicpParams(CicpParams&& src) noexcept;
  CicpParams& operator=(CicpParams&& src) noexcept;

  ~CicpParams() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkCicpParams*       gobj()       { return reinterpret_cast<GdkCicpParams*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkCicpParams* gobj() const { return reinterpret_cast<GdkCicpParams*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkCicpParams* gobj_copy();

private:

   
protected:
  CicpParams();

public:
  /** @addtogroup gdkmmEnums gdkmm Enums and Flags */

  /** 
   *  @var Range::NARROW
   * The values use the range of 16-235 (for Y) and 16-240 for u and v.
   * 
   *  @var Range::FULL
   * The values use the full range.
   */
   /** The values of this enumeration describe whether image data uses
   * the full range of 8-bit values.
   * 
   * In digital broadcasting, it is common to reserve the lowest and
   * highest values. Typically the allowed values for the narrow range
   * are 16-235 for Y and 16-240 for u,v (when dealing with YUV data).
   * 
   * @newin{4,16}
   *
   * @ingroup gdkmmEnums
   */
  enum class Range
  {
    NARROW,
    FULL
  };


  /** Creates a new `Gdk::CicpParams` object.
   * 
   * The initial values of the properties are the values for "undefined"
   * and need to be set before a color state object can be built.
   * 
   * @newin{4,16}
   * 
   * @return A new `Gdk::CicpParams`.
   */

  
  static Glib::RefPtr<CicpParams> create();


  /** Returns the value of the color-primaries property
   * of @a self.
   * 
   * @newin{4,16}
   * 
   * @return The color-primaries value.
   */
  guint get_color_primaries() const;
  
  /** Sets the color-primaries property of @a self.
   * 
   * @newin{4,16}
   * 
   * @param color_primaries The new color primaries value.
   */
  void set_color_primaries(guint color_primaries);

  
  /** Gets the transfer-function property of @a self.
   * 
   * @newin{4,16}
   * 
   * @return The transfer-function value.
   */
  guint get_transfer_function() const;
  
  /** Sets the transfer-function property of @a self.
   * 
   * @newin{4,16}
   * 
   * @param transfer_function The new transfer-function value.
   */
  void set_transfer_function(guint transfer_function);

  
  /** Gets the matrix-coefficients property of @a self.
   * 
   * @newin{4,16}
   * 
   * @return The matrix-coefficients value.
   */
  guint get_matrix_coefficients() const;
  
  /** Sets the matrix-coefficients property of @a self.
   * 
   * @newin{4,16}
   * 
   * @param matrix_coefficients The new matrix-coefficients value.
   */
  void set_matrix_coefficients(guint matrix_coefficients);

  
  /** Gets the range property of @a self.
   * 
   * @newin{4,16}
   * 
   * @return The range value.
   */
  Range get_range() const;
  
  /** Sets the range property of @a self
   * 
   * @newin{4,16}
   * 
   * @param range The range value.
   */
  void set_range(Range range);

  
  /** Creates a new `Gdk::ColorState` object for the cicp parameters in @a self.
   * 
   * Note that this may fail if the cicp parameters in @a self are not
   * supported by GTK. In that case, <tt>nullptr</tt> is returned, and @a error is set
   * with an error message that can be presented to the user.
   * 
   * @newin{4,16}
   * 
   * @return A newly allocated `Gdk::ColorState`.
   * 
   * @throws Gio::Error
   */
  Glib::RefPtr<ColorState> build_color_state() const;

  /** The color primaries to use.
   * 
   * Supported values:
   * 
   * - 1: BT.709 / sRGB
   * - 2: unspecified
   * - 5: PAL
   * - 6,7: BT.601 / NTSC
   * - 9: BT.2020
   * - 10: CIE XYZ
   * - 12: Display P3
   * 
   * @newin{4,16}
   *
   * Default value: 2
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_color_primaries() ;

/** The color primaries to use.
   * 
   * Supported values:
   * 
   * - 1: BT.709 / sRGB
   * - 2: unspecified
   * - 5: PAL
   * - 6,7: BT.601 / NTSC
   * - 9: BT.2020
   * - 10: CIE XYZ
   * - 12: Display P3
   * 
   * @newin{4,16}
   *
   * Default value: 2
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_color_primaries() const;

  /** The transfer function to use.
   * 
   * Supported values:
   * 
   * - 1,6,14,15: BT.709, BT.601, BT.2020
   * - 2: unspecified
   * - 4: gamma 2.2
   * - 5: gamma 2.8
   * - 8: linear
   * - 13: sRGB
   * - 16: BT.2100 PQ
   * - 18: BT.2100 HLG
   * 
   * @newin{4,16}
   *
   * Default value: 2
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_transfer_function() ;

/** The transfer function to use.
   * 
   * Supported values:
   * 
   * - 1,6,14,15: BT.709, BT.601, BT.2020
   * - 2: unspecified
   * - 4: gamma 2.2
   * - 5: gamma 2.8
   * - 8: linear
   * - 13: sRGB
   * - 16: BT.2100 PQ
   * - 18: BT.2100 HLG
   * 
   * @newin{4,16}
   *
   * Default value: 2
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_transfer_function() const;

  /** The matrix coefficients (for YUV to RGB conversion).
   * 
   * Supported values:
   * 
   * - 0: RGB
   * - 2: unspecified
   * 
   * @newin{4,16}
   *
   * Default value: 2
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_matrix_coefficients() ;

/** The matrix coefficients (for YUV to RGB conversion).
   * 
   * Supported values:
   * 
   * - 0: RGB
   * - 2: unspecified
   * 
   * @newin{4,16}
   *
   * Default value: 2
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_matrix_coefficients() const;

  /** Whether the data is using the full range of values.
   * 
   * The range of the data.
   * 
   * @newin{4,16}
   *
   * Default value: Gdk::CicpParams::Range::NARROW
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Range > property_range() ;

/** Whether the data is using the full range of values.
   * 
   * The range of the data.
   * 
   * @newin{4,16}
   *
   * Default value: Gdk::CicpParams::Range::NARROW
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Range > property_range() const;


  // There are no signals or public vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GDKMM_API Value<Gdk::CicpParams::Range> : public Glib::Value_Enum<Gdk::CicpParams::Range>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::CicpParams
   */
  GDKMM_API
  Glib::RefPtr<Gdk::CicpParams> wrap(GdkCicpParams* object, bool take_copy = false);
}


#endif /* _GDKMM_CICPPARAMS_H */

