// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_WINDOW_H
#define _GDKMM_WINDOW_H

#include <gdkmmconfig.h>


#include <glibmm.h>

/* Copyright(C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not write to the Free
 * Software Foundation Inc. 675 Mass Ave Cambridge MA 02139 USA.
 */

 
#include <gdkmm/drawable.h>
#include <gdkmm/bitmap.h>
//#include <gdkmm/cursor.h>
#include <gdkmm/types.h>
#include <gdkmm/region.h>
#include <gdk/gdk.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" {
// Custom struct prototype, because this isn't what the code-generator expects:
typedef struct _GdkDrawable GdkWindow;
} // extern "C"
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Window_Class; } // namespace Gdk
namespace Gdk
{

/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%EventMask operator|(EventMask, EventMask)</tt><br>
 * <tt>%EventMask operator&(EventMask, EventMask)</tt><br>
 * <tt>%EventMask operator^(EventMask, EventMask)</tt><br>
 * <tt>%EventMask operator~(EventMask)</tt><br>
 * <tt>%EventMask& operator|=(EventMask&, EventMask)</tt><br>
 * <tt>%EventMask& operator&=(EventMask&, EventMask)</tt><br>
 * <tt>%EventMask& operator^=(EventMask&, EventMask)</tt><br>
 */
enum EventMask
{
  EXPOSURE_MASK = 1 << 1,
  POINTER_MOTION_MASK = 1 << 2,
  POINTER_MOTION_HINT_MASK = 1 << 3,
  BUTTON_MOTION_MASK = 1 << 4,
  BUTTON1_MOTION_MASK = 1 << 5,
  BUTTON2_MOTION_MASK = 1 << 6,
  BUTTON3_MOTION_MASK = 1 << 7,
  BUTTON_PRESS_MASK = 1 << 8,
  BUTTON_RELEASE_MASK = 1 << 9,
  KEY_PRESS_MASK = 1 << 10,
  KEY_RELEASE_MASK = 1 << 11,
  ENTER_NOTIFY_MASK = 1 << 12,
  LEAVE_NOTIFY_MASK = 1 << 13,
  FOCUS_CHANGE_MASK = 1 << 14,
  STRUCTURE_MASK = 1 << 15,
  PROPERTY_CHANGE_MASK = 1 << 16,
  VISIBILITY_NOTIFY_MASK = 1 << 17,
  PROXIMITY_IN_MASK = 1 << 18,
  PROXIMITY_OUT_MASK = 1 << 19,
  SUBSTRUCTURE_MASK = 1 << 20,
  SCROLL_MASK = 1 << 21,
  ALL_EVENTS_MASK = 0x3FFFFE
};

/** @ingroup gdkmmEnums */
inline EventMask operator|(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator&(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator^(EventMask lhs, EventMask rhs)
  { return static_cast<EventMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline EventMask operator~(EventMask flags)
  { return static_cast<EventMask>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline EventMask& operator|=(EventMask& lhs, EventMask rhs)
  { return (lhs = static_cast<EventMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline EventMask& operator&=(EventMask& lhs, EventMask rhs)
  { return (lhs = static_cast<EventMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline EventMask& operator^=(EventMask& lhs, EventMask rhs)
  { return (lhs = static_cast<EventMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::EventMask> : public Glib::Value_Flags<Gdk::EventMask>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WindowState operator|(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator&(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator^(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator~(WindowState)</tt><br>
 * <tt>%WindowState& operator|=(WindowState&, WindowState)</tt><br>
 * <tt>%WindowState& operator&=(WindowState&, WindowState)</tt><br>
 * <tt>%WindowState& operator^=(WindowState&, WindowState)</tt><br>
 */
enum WindowState
{
  WINDOW_STATE_WITHDRAWN = 1 << 0,
  WINDOW_STATE_ICONIFIED = 1 << 1,
  WINDOW_STATE_MAXIMIZED = 1 << 2,
  WINDOW_STATE_STICKY = 1 << 3,
  WINDOW_STATE_FULLSCREEN = 1 << 4,
  WINDOW_STATE_ABOVE = 1 << 5,
  WINDOW_STATE_BELOW = 1 << 6
};

/** @ingroup gdkmmEnums */
inline WindowState operator|(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowState operator&(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowState operator^(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowState operator~(WindowState flags)
  { return static_cast<WindowState>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WindowState& operator|=(WindowState& lhs, WindowState rhs)
  { return (lhs = static_cast<WindowState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowState& operator&=(WindowState& lhs, WindowState rhs)
  { return (lhs = static_cast<WindowState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowState& operator^=(WindowState& lhs, WindowState rhs)
  { return (lhs = static_cast<WindowState>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowState> : public Glib::Value_Flags<Gdk::WindowState>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum WindowType
{
  WINDOW_ROOT,
  WINDOW_TOPLEVEL,
  WINDOW_CHILD,
  WINDOW_DIALOG,
  WINDOW_TEMP,
  WINDOW_FOREIGN,
  WINDOW_OFFSCREEN
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowType> : public Glib::Value_Enum<Gdk::WindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WindowAttributesType operator|(WindowAttributesType, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType operator&(WindowAttributesType, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType operator^(WindowAttributesType, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType operator~(WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType& operator|=(WindowAttributesType&, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType& operator&=(WindowAttributesType&, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType& operator^=(WindowAttributesType&, WindowAttributesType)</tt><br>
 */
enum WindowAttributesType
{
  WA_TITLE = 1 << 1,
  WA_X = 1 << 2,
  WA_Y = 1 << 3,
  WA_CURSOR = 1 << 4,
  WA_COLORMAP = 1 << 5,
  WA_VISUAL = 1 << 6,
  WA_WMCLASS = 1 << 7,
  WA_NOREDIR = 1 << 8,
  WA_TYPE_HINT = 1 << 9
};

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator|(WindowAttributesType lhs, WindowAttributesType rhs)
  { return static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator&(WindowAttributesType lhs, WindowAttributesType rhs)
  { return static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator^(WindowAttributesType lhs, WindowAttributesType rhs)
  { return static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator~(WindowAttributesType flags)
  { return static_cast<WindowAttributesType>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType& operator|=(WindowAttributesType& lhs, WindowAttributesType rhs)
  { return (lhs = static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType& operator&=(WindowAttributesType& lhs, WindowAttributesType rhs)
  { return (lhs = static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType& operator^=(WindowAttributesType& lhs, WindowAttributesType rhs)
  { return (lhs = static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowAttributesType> : public Glib::Value_Flags<Gdk::WindowAttributesType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WindowHints operator|(WindowHints, WindowHints)</tt><br>
 * <tt>%WindowHints operator&(WindowHints, WindowHints)</tt><br>
 * <tt>%WindowHints operator^(WindowHints, WindowHints)</tt><br>
 * <tt>%WindowHints operator~(WindowHints)</tt><br>
 * <tt>%WindowHints& operator|=(WindowHints&, WindowHints)</tt><br>
 * <tt>%WindowHints& operator&=(WindowHints&, WindowHints)</tt><br>
 * <tt>%WindowHints& operator^=(WindowHints&, WindowHints)</tt><br>
 */
enum WindowHints
{
  HINT_POS = 1 << 0,
  HINT_MIN_SIZE = 1 << 1,
  HINT_MAX_SIZE = 1 << 2,
  HINT_BASE_SIZE = 1 << 3,
  HINT_ASPECT = 1 << 4,
  HINT_RESIZE_INC = 1 << 5,
  HINT_WIN_GRAVITY = 1 << 6,
  HINT_USER_POS = 1 << 7,
  HINT_USER_SIZE = 1 << 8
};

/** @ingroup gdkmmEnums */
inline WindowHints operator|(WindowHints lhs, WindowHints rhs)
  { return static_cast<WindowHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowHints operator&(WindowHints lhs, WindowHints rhs)
  { return static_cast<WindowHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowHints operator^(WindowHints lhs, WindowHints rhs)
  { return static_cast<WindowHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowHints operator~(WindowHints flags)
  { return static_cast<WindowHints>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WindowHints& operator|=(WindowHints& lhs, WindowHints rhs)
  { return (lhs = static_cast<WindowHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowHints& operator&=(WindowHints& lhs, WindowHints rhs)
  { return (lhs = static_cast<WindowHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowHints& operator^=(WindowHints& lhs, WindowHints rhs)
  { return (lhs = static_cast<WindowHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowHints> : public Glib::Value_Flags<Gdk::WindowHints>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum WindowTypeHint
{
  WINDOW_TYPE_HINT_NORMAL,
  WINDOW_TYPE_HINT_DIALOG,
  WINDOW_TYPE_HINT_MENU,
  WINDOW_TYPE_HINT_TOOLBAR,
  WINDOW_TYPE_HINT_SPLASHSCREEN,
  WINDOW_TYPE_HINT_UTILITY,
  WINDOW_TYPE_HINT_DOCK,
  WINDOW_TYPE_HINT_DESKTOP,
  WINDOW_TYPE_HINT_DROPDOWN_MENU,
  WINDOW_TYPE_HINT_POPUP_MENU,
  WINDOW_TYPE_HINT_TOOLTIP,
  WINDOW_TYPE_HINT_NOTIFICATION,
  WINDOW_TYPE_HINT_COMBO,
  WINDOW_TYPE_HINT_DND
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowTypeHint> : public Glib::Value_Enum<Gdk::WindowTypeHint>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WMDecoration operator|(WMDecoration, WMDecoration)</tt><br>
 * <tt>%WMDecoration operator&(WMDecoration, WMDecoration)</tt><br>
 * <tt>%WMDecoration operator^(WMDecoration, WMDecoration)</tt><br>
 * <tt>%WMDecoration operator~(WMDecoration)</tt><br>
 * <tt>%WMDecoration& operator|=(WMDecoration&, WMDecoration)</tt><br>
 * <tt>%WMDecoration& operator&=(WMDecoration&, WMDecoration)</tt><br>
 * <tt>%WMDecoration& operator^=(WMDecoration&, WMDecoration)</tt><br>
 */
enum WMDecoration
{
  DECOR_ALL = 1 << 0,
  DECOR_BORDER = 1 << 1,
  DECOR_RESIZEH = 1 << 2,
  DECOR_TITLE = 1 << 3,
  DECOR_MENU = 1 << 4,
  DECOR_MINIMIZE = 1 << 5,
  DECOR_MAXIMIZE = 1 << 6
};

/** @ingroup gdkmmEnums */
inline WMDecoration operator|(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator&(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator^(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator~(WMDecoration flags)
  { return static_cast<WMDecoration>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WMDecoration& operator|=(WMDecoration& lhs, WMDecoration rhs)
  { return (lhs = static_cast<WMDecoration>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMDecoration& operator&=(WMDecoration& lhs, WMDecoration rhs)
  { return (lhs = static_cast<WMDecoration>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMDecoration& operator^=(WMDecoration& lhs, WMDecoration rhs)
  { return (lhs = static_cast<WMDecoration>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WMDecoration> : public Glib::Value_Flags<Gdk::WMDecoration>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WMFunction operator|(WMFunction, WMFunction)</tt><br>
 * <tt>%WMFunction operator&(WMFunction, WMFunction)</tt><br>
 * <tt>%WMFunction operator^(WMFunction, WMFunction)</tt><br>
 * <tt>%WMFunction operator~(WMFunction)</tt><br>
 * <tt>%WMFunction& operator|=(WMFunction&, WMFunction)</tt><br>
 * <tt>%WMFunction& operator&=(WMFunction&, WMFunction)</tt><br>
 * <tt>%WMFunction& operator^=(WMFunction&, WMFunction)</tt><br>
 */
enum WMFunction
{
  FUNC_ALL = 1 << 0,
  FUNC_RESIZE = 1 << 1,
  FUNC_MOVE = 1 << 2,
  FUNC_MINIMIZE = 1 << 3,
  FUNC_MAXIMIZE = 1 << 4,
  FUNC_CLOSE = 1 << 5
};

/** @ingroup gdkmmEnums */
inline WMFunction operator|(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator&(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator^(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator~(WMFunction flags)
  { return static_cast<WMFunction>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WMFunction& operator|=(WMFunction& lhs, WMFunction rhs)
  { return (lhs = static_cast<WMFunction>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMFunction& operator&=(WMFunction& lhs, WMFunction rhs)
  { return (lhs = static_cast<WMFunction>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMFunction& operator^=(WMFunction& lhs, WMFunction rhs)
  { return (lhs = static_cast<WMFunction>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WMFunction> : public Glib::Value_Flags<Gdk::WMFunction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum WindowEdge
{
  WINDOW_EDGE_NORTH_WEST,
  WINDOW_EDGE_NORTH,
  WINDOW_EDGE_NORTH_EAST,
  WINDOW_EDGE_WEST,
  WINDOW_EDGE_EAST,
  WINDOW_EDGE_SOUTH_WEST,
  WINDOW_EDGE_SOUTH,
  WINDOW_EDGE_SOUTH_EAST
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowEdge> : public Glib::Value_Enum<Gdk::WindowEdge>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum Gravity
{
  GRAVITY_NORTH_WEST = 1,
  GRAVITY_NORTH,
  GRAVITY_NORTH_EAST,
  GRAVITY_WEST,
  GRAVITY_CENTER,
  GRAVITY_EAST,
  GRAVITY_SOUTH_WEST,
  GRAVITY_SOUTH,
  GRAVITY_SOUTH_EAST,
  GRAVITY_STATIC
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Gravity> : public Glib::Value_Enum<Gdk::Gravity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum GrabStatus
{
  GRAB_SUCCESS,
  GRAB_ALREADY_GRABBED,
  GRAB_INVALID_TIME,
  GRAB_NOT_VIEWABLE,
  GRAB_FROZEN
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::GrabStatus> : public Glib::Value_Enum<Gdk::GrabStatus>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class Cursor;

/** A Gdk::Window is a rectangular region on the screen. It's a low-level object, used to implement high-level objects such
 * as Gtk::Widget and Gtk::Window on the GTK+ level. A Gtk::Window is a toplevel window, the thing a user might think of as
 * a "window" with a titlebar and so on; a Gtk::Window may contain many Gdk::Windows. For example, each Gtk::Button has a
 * Gdk::Window associated with it.
 */

class Window : public Gdk::Drawable
{
  // GdkWindow is a typedef to GdkDrawable, but it's actually a GdkWindowObject.
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef GdkWindow BaseObjectType;
  typedef GdkWindowObjectClass BaseClassType;

private:  friend class Window_Class;
  static CppClassType window_class_;

private:
  // noncopyable
  Window(const Window&);
  Window& operator=(const Window&);

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(GdkWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Window();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkWindow*       gobj()       { return reinterpret_cast<GdkWindow*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkWindow* gobj() const { return reinterpret_cast<GdkWindow*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkWindow* gobj_copy();

private:

  
protected:
  Window(const Glib::RefPtr<Window>& parent, GdkWindowAttr* attributes, int attributes_mask);

public:
  
  static Glib::RefPtr<Window> create(const Glib::RefPtr<Window>& parent, GdkWindowAttr* attributes, int attributes_mask);


  /** Gets the type of the window. See Gdk::WindowType.
   * @return Type of window.
   */
  WindowType get_window_type() const;
  
  /** Like gdk_window_show_unraised(), but also raises the window to the
   * top of the window stack (moves the window to the front of the
   * Z-order).
   * 
   * This function maps a window so it's visible onscreen. Its opposite
   * is gdk_window_hide().
   * 
   * When implementing a Gtk::Widget, you should call this function on the widget's
   * Gdk::Window as part of the "map" method.
   */
  void show();
  
  /** For toplevel windows, withdraws them, so they will no longer be
   * known to the window manager; for all windows, unmaps them, so
   * they won't be displayed. Normally done automatically as
   * part of gtk_widget_hide().
   */
  void hide();
  
  /** Withdraws a window (unmaps it and asks the window manager to forget about it).
   * This function is not really useful as gdk_window_hide() automatically
   * withdraws toplevel windows before hiding them.
   */
  void withdraw();
  
  /** Shows a Gdk::Window onscreen, but does not modify its stacking
   * order. In contrast, gdk_window_show() will raise the window
   * to the top of the window stack.
   * 
   * On the X11 platform, in Xlib terms, this function calls
   * XMapWindow() (it also updates some internal GDK state, which means
   * that you can't really use XMapWindow() directly on a GDK window).
   */
  void show_unraised();
  
  /** Repositions a window relative to its parent window.
   * For toplevel windows, window managers may ignore or modify the move;
   * you should probably use gtk_window_move() on a Gtk::Window widget
   * anyway, instead of using GDK functions. For child windows,
   * the move will reliably succeed.
   * 
   * If you're also planning to resize the window, use gdk_window_move_resize()
   * to both move and resize simultaneously, for a nicer visual effect.
   * @param x X coordinate relative to window's parent.
   * @param y Y coordinate relative to window's parent.
   */
  void move(int x, int y);
  
  /** Resizes @a window; for toplevel windows, asks the window manager to resize
   * the window. The window manager may not allow the resize. When using GTK+,
   * use gtk_window_resize() instead of this low-level GDK function.
   * 
   * Windows may not be resized below 1x1.
   * 
   * If you're also planning to move the window, use gdk_window_move_resize()
   * to both move and resize simultaneously, for a nicer visual effect.
   * @param width New width of the window.
   * @param height New height of the window.
   */
  void resize(int width, int height);
  
  /** Equivalent to calling gdk_window_move() and gdk_window_resize(),
   * except that both operations are performed at once, avoiding strange
   * visual effects. (i.e. the user may be able to see the window first
   * move, then resize, if you don't use gdk_window_move_resize().)
   * @param x New X position relative to window's parent.
   * @param y New Y position relative to window's parent.
   * @param width New width.
   * @param height New height.
   */
  void move_resize(int x, int y, int width, int height);
  
  /** Reparents @a window into the given @a new_parent. The window being
   * reparented will be unmapped as a side effect.
   * @param new_parent New parent to move @a window into.
   * @param x X location inside the new parent.
   * @param y Y location inside the new parent.
   */
  void reparent(const Glib::RefPtr<Window>& new_parent, int x, int y);
  
  /** Clears an entire @a window to the background color or background pixmap.
   */
  void clear();
  
  /** Clears an area of @a window to the background color or background pixmap.
   * @param x X coordinate of rectangle to clear.
   * @param y Y coordinate of rectangle to clear.
   * @param width Width of rectangle to clear.
   * @param height Height of rectangle to clear.
   */
  void clear_area(int x, int y, int width, int height);
  
  /** Like gdk_window_clear_area(), but also generates an expose event for
   * the cleared area.
   * 
   * This function has a stupid name because it dates back to the mists
   * time, pre-GDK-1.0.
   * @param x X coordinate of rectangle to clear.
   * @param y Y coordinate of rectangle to clear.
   * @param width Width of rectangle to clear.
   * @param height Height of rectangle to clear.
   */
  void clear_area_e(int x, int y, int width, int height);
  
  /** Raises @a window to the top of the Z-order (stacking order), so that
   * other windows with the same parent window appear below @a window.
   * This is true whether or not the windows are visible.
   * 
   * If @a window is a toplevel, the window manager may choose to deny the
   * request to move the window in the Z-order, gdk_window_raise() only
   * requests the restack, does not guarantee it.
   */
  void raise();
  
  /** Lowers @a window to the bottom of the Z-order (stacking order), so that
   * other windows with the same parent window appear above @a window.
   * This is true whether or not the other windows are visible.
   * 
   * If @a window is a toplevel, the window manager may choose to deny the
   * request to move the window in the Z-order, gdk_window_lower() only
   * requests the restack, does not guarantee it.
   * 
   * Note that gdk_window_show() raises the window again, so don't call this
   * function before gdk_window_show(). (Try gdk_window_show_unraised().)
   */
  void lower();

  
  /** Changes the position of  @a window in the Z-order (stacking order), so that
   * it is above @a sibling (if @a above is <tt>true</tt>) or below @a sibling (if @a above is
   * <tt>false</tt>).
   * 
   * If @a sibling is <tt>0</tt>, then this either raises (if @a above is <tt>true</tt>) or
   * lowers the window.
   * 
   * If @a window is a toplevel, the window manager may choose to deny the
   * request to move the window in the Z-order, gdk_window_restack() only
   * requests the restack, does not guarantee it.
   * 
   * @newin{2,18}
   * @param sibling A Gdk::Window that is a sibling of @a window, or <tt>0</tt>.
   * @param above A boolean.
   */
  void restack(const Glib::RefPtr<Window>& sibling, bool above);

  /** Changes the position of this window in the Z-order (stacking order). This
   * either raises (if @a above is true) or lowers the window.
   *
   * If this is a toplevel, the window manager may choose to deny the
   * request to move the window in the Z-order. restack() only
   * requests the restack but does not guarantee it.
   *
   * @param above Whether to raise or lower the window.
   *
   * @newin{2,18}
   */
  void restack(bool above);

  
  /** Sets keyboard focus to @a window. In most cases, gtk_window_present() 
   * should be used on a Gtk::Window, rather than calling this function.
   * @param timestamp Timestamp of the event triggering the window focus.
   */
  void focus(guint32 timestamp);
  
  /** For most purposes this function is deprecated in favor of
   * Glib::object_set_data(). However, for historical reasons GTK+ stores
   * the Gtk::Widget that owns a Gdk::Window as user data on the
   * Gdk::Window. So, custom widget implementations should use
   * this function for that. If GTK+ receives an event for a Gdk::Window,
   * and the user data for the window is non-<tt>0</tt>, GTK+ will assume the
   * user data is a Gtk::Widget, and forward the event to that widget.
   * @param user_data User data.
   */
  void set_user_data(gpointer user_data);
  
  /** An override redirect window is not under the control of the window manager.
   * This means it won't have a titlebar, won't be minimizable, etc. - it will
   * be entirely under the control of the application. The window manager
   * can't see the override redirect window at all.
   * 
   * Override redirect should only be used for short-lived temporary
   * windows, such as popup menus. Gtk::Menu uses an override redirect
   * window in its implementation, for example.
   * @param override_redirect <tt>true</tt> if window should be override redirect.
   */
  void set_override_redirect(bool override_redirect = true);

  //We could wrap these with a Slot instead of a C callback, but these methods are very low-level anyway.
  
  /** Adds an event filter to @a window, allowing you to intercept events
   * before they reach GDK. This is a low-level operation and makes it
   * easy to break GDK and/or GTK+, so you have to know what you're
   * doing. Pass <tt>0</tt> for @a window to get all events for all windows,
   * instead of events for a specific window.
   * 
   * See Gdk::Display::add_client_message_filter() if you are interested
   * in X ClientMessage events.
   * @param function Filter callback.
   * @param data Data to pass to filter callback.
   */
  void add_filter(GdkFilterFunc function, gpointer data);
  
  /** Remove a filter previously added with gdk_window_add_filter().
   * @param function Previously-added filter function.
   * @param data User data for previously-added filter function.
   */
  void remove_filter(GdkFilterFunc function, gpointer data);

  
  /** Scroll the contents of its window, both pixels and children, by
   * the given amount. Portions of the window that the scroll operation
   * brings in from offscreen areas are invalidated.
   * @param dx Amount to scroll in the X direction.
   * @param dy Amount to scroll in the Y direction.
   */
  void scroll(int dx, int dy);
  
  /** Move the part of @a window indicated by @a region by @a dy pixels in the Y 
   * direction and @a dx pixels in the X direction. The portions of @a region 
   * that not covered by the new position of @a region are invalidated.
   * 
   * Child windows are not moved.
   * 
   * @newin{2,8}
   * @param region The Gdk::Region to move.
   * @param dx Amount to move in the X direction.
   * @param dy Amount to move in the Y direction.
   */
  void move_region(const Region& region, int dx, int dy);
  
  /** Tries to ensure that there is a window-system native window for this
   * GdkWindow. This may fail in some situations, returning <tt>false</tt>.
   * 
   * Offscreen window and children of them can never have native windows.
   * 
   * Some backends may not support native child windows.
   * @return <tt>true</tt> if the window has a native window, <tt>false</tt> otherwise
   * 
   * @newin{2,18}.
   */
  bool ensure_native();

  
  /** Applies a shape mask to @a window. Pixels in @a window corresponding to
   * set bits in the @a mask will be visible; pixels in @a window
   * corresponding to unset bits in the @a mask will be transparent. This
   * gives a non-rectangular window.
   * 
   * If @a mask is <tt>0</tt>, the shape mask will be unset, and the @a x/ @a y
   * parameters are not used.
   * 
   * On the X11 platform, this uses an X server extension which is
   * widely available on most common platforms, but not available on
   * very old X servers, and occasionally the implementation will be
   * buggy. On servers without the shape extension, this function
   * will do nothing.
   * 
   * This function works on both toplevel and child windows.
   * @param mask Shape mask.
   * @param x X position of shape mask with respect to @a window.
   * @param y Y position of shape mask with respect to @a window.
   */
  void shape_combine_mask(const Glib::RefPtr<Bitmap>& mask, int x, int y);
  void unset_shape_combine_mask();

  
  /** Makes pixels in @a window outside @a shape_region be transparent,
   * so that the window may be nonrectangular. See also
   * gdk_window_shape_combine_mask() to use a bitmap as the mask.
   * 
   * If @a shape_region is <tt>0</tt>, the shape will be unset, so the whole
   * window will be opaque again. @a offset_x and @a offset_y are ignored
   * if @a shape_region is <tt>0</tt>.
   * 
   * On the X11 platform, this uses an X server extension which is
   * widely available on most common platforms, but not available on
   * very old X servers, and occasionally the implementation will be
   * buggy. On servers without the shape extension, this function
   * will do nothing.
   * 
   * This function works on both toplevel and child windows.
   * @param shape_region Region of window to be non-transparent.
   * @param offset_x X position of @a shape_region in @a window coordinates.
   * @param offset_y Y position of @a shape_region in @a window coordinates.
   */
  void shape_combine_region(const Region& shape_region, int offset_x, int offset_y);
  
  /** Sets the shape mask of @a window to the union of shape masks
   * for all children of @a window, ignoring the shape mask of @a window
   * itself. Contrast with gdk_window_merge_child_shapes() which includes
   * the shape mask of @a window in the masks to be merged.
   */
  void set_child_shapes();
  
  /** Sets a Gdk::Window as composited, or unsets it. Composited
   * windows do not automatically have their contents drawn to
   * the screen. Drawing is redirected to an offscreen buffer
   * and an expose event is emitted on the parent of the composited
   * window. It is the responsibility of the parent's expose handler
   * to manually merge the off-screen content onto the screen in
   * whatever way it sees fit. See <xref linkend="composited-window-example"/>
   * for an example.
   * 
   * It only makes sense for child windows to be composited; see
   * gdk_window_set_opacity() if you need translucent toplevel
   * windows.
   * 
   * An additional effect of this call is that the area of this
   * window is no longer clipped from regions marked for
   * invalidation on its parent. Draws done on the parent
   * window are also no longer clipped by the child.
   * 
   * This call is only supported on some systems (currently,
   * only X11 with new enough Xcomposite and Xdamage extensions).
   * You must call Gdk::Display::supports_composite() to check if
   * setting a window as composited is supported before
   * attempting to do so.
   * 
   * @newin{2,12}
   * @param composited <tt>true</tt> to set the window as composited.
   */
  void set_composited(bool composited = TRUE);
  
  /** Merges the shape masks for any child windows into the
   * shape mask for @a window. i.e. the union of all masks
   * for @a window and its children will become the new mask
   * for @a window. See gdk_window_shape_combine_mask().
   * 
   * This function is distinct from gdk_window_set_child_shapes()
   * because it includes @a window's shape mask in the set of shapes to
   * be merged.
   */
  void merge_child_shapes();

  
  /** Like gdk_window_shape_combine_mask(), but the shape applies
   * only to event handling. Mouse events which happen while
   * the pointer position corresponds to an unset bit in the
   * mask will be passed on the window below @a window.
   * 
   * An input shape is typically used with RGBA windows.
   * The alpha channel of the window defines which pixels are
   * invisible and allows for nicely antialiased borders,
   * and the input shape controls where the window is
   * "clickable".
   * 
   * On the X11 platform, this requires version 1.1 of the
   * shape extension.
   * 
   * On the Win32 platform, this functionality is not present and the
   * function does nothing.
   * 
   * @newin{2,10}
   * @param mask Shape mask, or <tt>0</tt>.
   * @param x X position of shape mask with respect to @a window.
   * @param y Y position of shape mask with respect to @a window.
   */
  void input_shape_combine_mask(const Glib::RefPtr<Bitmap>& mask, int x, int y);
  
  /** Like gdk_window_shape_combine_region(), but the shape applies
   * only to event handling. Mouse events which happen while
   * the pointer position corresponds to an unset bit in the
   * mask will be passed on the window below @a window.
   * 
   * An input shape is typically used with RGBA windows.
   * The alpha channel of the window defines which pixels are
   * invisible and allows for nicely antialiased borders,
   * and the input shape controls where the window is
   * "clickable".
   * 
   * On the X11 platform, this requires version 1.1 of the
   * shape extension.
   * 
   * On the Win32 platform, this functionality is not present and the
   * function does nothing.
   * 
   * @newin{2,10}
   * @param shape_region Region of window to be non-transparent.
   * @param offset_x X position of @a shape_region in @a window coordinates.
   * @param offset_y Y position of @a shape_region in @a window coordinates.
   */
  void input_shape_combine_region (const Region& shape_region, int offset_x, int offset_y);
  
  /** Sets the input shape mask of @a window to the union of input shape masks
   * for all children of @a window, ignoring the input shape mask of @a window
   * itself. Contrast with gdk_window_merge_child_input_shapes() which includes
   * the input shape mask of @a window in the masks to be merged.
   * 
   * @newin{2,10}
   */
  void set_child_input_shapes();
  
  /** Merges the input shape masks for any child windows into the
   * input shape mask for @a window. i.e. the union of all input masks
   * for @a window and its children will become the new input mask
   * for @a window. See gdk_window_input_shape_combine_mask().
   * 
   * This function is distinct from gdk_window_set_child_input_shapes()
   * because it includes @a window's input shape mask in the set of
   * shapes to be merged.
   * 
   * @newin{2,10}
   */
  void merge_child_input_shapes();

  
  /** Checks whether the window has been mapped (with gdk_window_show() or
   * gdk_window_show_unraised()).
   * @return <tt>true</tt> if the window is mapped.
   */
  bool is_visible() const;
  
  /** Check if the window and all ancestors of the window are
   * mapped. (This is not necessarily "viewable" in the X sense, since
   * we only check as far as we have GDK window parents, not to the root
   * window.)
   * @return <tt>true</tt> if the window is viewable.
   */
  bool is_viewable() const;
  
  /** Gets the bitwise OR of the currently active window state flags,
   * from the Gdk::WindowState enumeration.
   * @return Window state bitfield.
   */
  WindowState get_state() const;
  
  /** Set the bit gravity of the given window to static, and flag it so
   * all children get static subwindow gravity. This is used if you are
   * implementing scary features that involve deep knowledge of the
   * windowing system. Don't worry about it unless you have to.
   * @param use_static <tt>true</tt> to turn on static gravity.
   * @return <tt>true</tt> if the server supports static gravity.
   */
  bool set_static_gravities(bool use_static = true);
  
  /** The application can use this call to provide a hint to the window
   * manager about the functionality of a window. The window manager
   * can use this information when determining the decoration and behaviour
   * of the window.
   * 
   * The hint must be set before the window is mapped.
   * @param hint A hint of the function this window will have.
   */
  void set_type_hint(WindowTypeHint hint);
  
  /** This function returns the type hint set for a window.
   * @return The type hint set for @a window
   * 
   * @newin{2,10}.
   */
  WindowTypeHint get_type_hint();
  
  /** The application can use this hint to tell the window manager
   * that a certain window has modal behaviour. The window manager
   * can use this information to handle modal windows in a special
   * way.
   * 
   * You should only use this on windows for which you have
   * previously called gdk_window_set_transient_for()
   * @param modal <tt>true</tt> if the window is modal, <tt>false</tt> otherwise.
   */
  void set_modal_hint(bool modal = true);
  
  /** Sets the geometry hints for @a window. Hints flagged in @a geom_mask
   * are set, hints not flagged in @a geom_mask are unset.
   * To unset all hints, use a @a geom_mask of 0 and a @a geometry of <tt>0</tt>.
   * 
   * This function provides hints to the windowing system about
   * acceptable sizes for a toplevel window. The purpose of 
   * this is to constrain user resizing, but the windowing system
   * will typically  (but is not required to) also constrain the
   * current size of the window to the provided values and
   * constrain programatic resizing via gdk_window_resize() or
   * gdk_window_move_resize().
   * 
   * Note that on X11, this effect has no effect on windows
   * of type Gdk::WINDOW_TEMP or windows where override redirect
   * has been turned on via gdk_window_set_override_redirect()
   * since these windows are not resizable by the user.
   * 
   * Since you can't count on the windowing system doing the
   * constraints for programmatic resizes, you should generally
   * call gdk_window_constrain_size() yourself to determine
   * appropriate sizes.
   * @param geometry Geometry hints.
   * @param geom_mask Bitmask indicating fields of @a geometry to pay attention to.
   */
  void set_geometry_hints(const Geometry& geometry, WindowHints geom_mask);
  
  /** Sets the <tt>SM_CLIENT_ID</tt> property on the application's leader window so that
   * the window manager can save the application's state using the X11R6 ICCCM
   * session management protocol.
   * 
   * See the X Session Management Library documentation for more information on
   * session management and the Inter-Client Communication Conventions Manual
   * (ICCCM) for information on the <tt>WM_CLIENT_LEADER</tt> property.
   * (Both documents are part of the X&nbsp;%Window System distribution.)
   * @param sm_client_id The client id assigned by the session manager when the
   * connection was opened.
   */
  static void set_sm_client_id(const Glib::ustring& sm_client_id);
  static void unset_sm_client_id();

  //Note: The rectangle parameter was made const in GTK+ 2.16, but we can't change that in our C++ API. TODO: Change it when we can do an ABI break.
   

  /** A convenience wrapper around gdk_window_begin_paint_region() which
   * creates a rectangular region for you. See
   * gdk_window_begin_paint_region() for details.
   * @param rectangle Rectangle you intend to draw to.
   */
  void begin_paint_rect(Rectangle& rectangle);
  
  /** Indicates that you are beginning the process of redrawing @a region.
   * A backing store (offscreen buffer) large enough to contain @a region
   * will be created. The backing store will be initialized with the
   * background color or background pixmap for @a window. Then, all
   * drawing operations performed on @a window will be diverted to the
   * backing store.  When you call gdk_window_end_paint(), the backing
   * store will be copied to @a window, making it visible onscreen. Only
   * the part of @a window contained in @a region will be modified; that is,
   * drawing operations are clipped to @a region.
   * 
   * The net result of all this is to remove flicker, because the user
   * sees the finished product appear all at once when you call
   * gdk_window_end_paint(). If you draw to @a window directly without
   * calling gdk_window_begin_paint_region(), the user may see flicker
   * as individual drawing operations are performed in sequence.  The
   * clipping and background-initializing features of
   * gdk_window_begin_paint_region() are conveniences for the
   * programmer, so you can avoid doing that work yourself.
   * 
   * When using GTK+, the widget system automatically places calls to
   * gdk_window_begin_paint_region() and gdk_window_end_paint() around
   * emissions of the expose_event signal. That is, if you're writing an
   * expose event handler, you can assume that the exposed area in
   * Gdk::EventExpose has already been cleared to the window background,
   * is already set as the clip region, and already has a backing store.
   * Therefore in most cases, application code need not call
   * gdk_window_begin_paint_region(). (You can disable the automatic
   * calls around expose events on a widget-by-widget basis by calling
   * gtk_widget_set_double_buffered().)
   * 
   * If you call this function multiple times before calling the
   * matching gdk_window_end_paint(), the backing stores are pushed onto
   * a stack. gdk_window_end_paint() copies the topmost backing store
   * onscreen, subtracts the topmost region from all other regions in
   * the stack, and pops the stack. All drawing operations affect only
   * the topmost backing store in the stack. One matching call to
   * gdk_window_end_paint() is required for each call to
   * gdk_window_begin_paint_region().
   * @param region Region you intend to draw to.
   */
  void begin_paint_region(const Region& region);
  
  /** Indicates that the backing store created by the most recent call to
   * gdk_window_begin_paint_region() should be copied onscreen and
   * deleted, leaving the next-most-recent backing store or no backing
   * store at all as the active paint region. See
   * gdk_window_begin_paint_region() for full details. It is an error to
   * call this function without a matching
   * gdk_window_begin_paint_region() first.
   */
  void end_paint();
  
  /** Flush all outstanding cached operations on a window, leaving the
   * window in a state which reflects all that has been drawn before.
   * 
   * Gdk uses multiple kinds of caching to get better performance and
   * nicer drawing. For instance, during exposes all paints to a window
   * using double buffered rendering are keep on a pixmap until the last
   * window has been exposed. It also delays window moves/scrolls until
   * as long as possible until next update to avoid tearing when moving
   * windows.
   * 
   * Normally this should be completely invisible to applications, as
   * we automatically flush the windows when required, but this might
   * be needed if you for instance mix direct native drawing with
   * gdk drawing. For Gtk widgets that don't use double buffering this
   * will be called automatically before sending the expose event.
   * 
   * @newin{2,18}
   */
  void flush();
  
  /** Sets the title of a toplevel window, to be displayed in the titlebar.
   * If you haven't explicitly set the icon name for the window
   * (using gdk_window_set_icon_name()), the icon name will be set to
   *  @a title as well. @a title must be in UTF-8 encoding (as with all
   * user-readable strings in GDK/GTK+). @a title may not be <tt>0</tt>.
   * @param title Title of @a window.
   */
  void set_title(const Glib::ustring& title);
  
  /** When using GTK+, typically you should use gtk_window_set_role() instead
   * of this low-level function.
   * 
   * The window manager and session manager use a window's role to
   * distinguish it from other kinds of window in the same application.
   * When an application is restarted after being saved in a previous
   * session, all windows with the same title and role are treated as
   * interchangeable.  So if you have two windows with the same title
   * that should be distinguished for session management purposes, you
   * should set the role on those windows. It doesn't matter what string
   * you use for the role, as long as you have a different role for each
   * non-interchangeable kind of window.
   * @param role A string indicating its role.
   */
  void set_role(const Glib::ustring& role);
  
  /** When using GTK+, typically you should use gtk_window_set_startup_id()
   * instead of this low-level function.
   * 
   * @newin{2,12}
   * @param startup_id A string with startup-notification identifier.
   */
  void set_startup_id(const Glib::ustring& startup_id);
  
  /** Indicates to the window manager that @a window is a transient dialog
   * associated with the application window @a parent. This allows the
   * window manager to do things like center @a window on @a parent and
   * keep @a window above @a parent.
   * 
   * See gtk_window_set_transient_for() if you're using Gtk::Window or
   * Gtk::Dialog.
   * @param parent Another toplevel Gdk::Window.
   */
  void set_transient_for(const Glib::RefPtr<Window>& parent);
  
  /** Sets the background color of @a window. (However, when using GTK+,
   * set the background of a widget with gtk_widget_modify_bg() - if
   * you're an application - or gtk_style_set_background() - if you're
   * implementing a custom widget.)
   * 
   * The @a color must be allocated; gdk_rgb_find_color() is the best way
   * to allocate a color.
   * 
   * See also gdk_window_set_back_pixmap().
   * @param color An allocated Gdk::Color.
   */
  void set_background(const Color& color);
  
  /** Sets the background pixmap of @a window. 
   * A background pixmap will be tiled, positioning the first tile at the origin of
   *  @a window, or if @a parent_relative is <tt>true</tt>, the tiling will be done based on the
   * origin of the parent window (useful to align tiles in a parent with tiles
   * in a child).
   * 
   * The windowing system will normally fill a window with its background
   * when the window is obscured then exposed, and when you call
   * gdk_window_clear().
   * 
   * See also unset_back_pixmap().
   * @param pixmap A Gdk::Pixmap.
   * @param parent_relative Whether the tiling origin is at the origin of @a window's parent.
   */
  void set_back_pixmap(const Glib::RefPtr<Pixmap>&pixmap, bool parent_relative = true);

  /** Unsets the background pixmap of @a window so that the window will have no
   * background.  A window with no background will never have its
   * background filled by the windowing system, instead the window will
   * contain whatever pixels were already in the corresponding area of
   * the display.
   *
   * @see set_back_pixmap().
   * @newin{2,14}
   */
  void unset_back_pixmap();

 
  /** Sets the mouse pointer for a Gdk::Window. 
   * To make the cursor invisible, use gdk_cursor_new_from_pixmap() to create
   * a cursor with no pixels in it.
   * @param cursor A cursor.
   */
  void set_cursor(const Cursor& cursor);

  /** Use the parent window's cursor.
   * For top-level windows this means that it will use the default cursor for the ROOT window.
   */
  void set_cursor();

  //TODO: GdkCursor is a ref-counted boxed type,
  //so we could add a copy constructor and then return by value.
  //We would also need a Cursor::operator bool() to check for a null value.
  //TODO: _WRAP_METHOD(Cursor get_cursor(), gdk_window_get_cursor)

  
  /** Retrieves the user data for @a window, which is normally the widget
   * that @a window belongs to. See gdk_window_set_user_data().
   * @param data Return location for user data.
   */
  void get_user_data(gpointer* data);
  
  /** Any of the return location arguments to this function may be <tt>0</tt>,
   * if you aren't interested in getting the value of that field.
   * 
   * The X and Y coordinates returned are relative to the parent window
   * of @a window, which for toplevels usually means relative to the
   * window decorations (titlebar, etc.) rather than relative to the
   * root window (screen-size background window).
   * 
   * On the X11 platform, the geometry is obtained from the X server,
   * so reflects the latest position of @a window; this may be out-of-sync
   * with the position of @a window delivered in the most-recently-processed
   * Gdk::EventConfigure. gdk_window_get_position() in contrast gets the
   * position from the most recent configure event.
   * 
   * <note>
   * If @a window is not a toplevel, it is <emphasis>much</emphasis> better
   * to call gdk_window_get_position() and Gdk::Drawable::get_size() instead,
   * because it avoids the roundtrip to the X server and because
   * Gdk::Drawable::get_size() supports the full 32-bit coordinate space,
   * whereas gdk_window_get_geometry() is restricted to the 16-bit
   * coordinates of X11.
   * </note>
   * @param x Return location for X coordinate of window (relative to its parent).
   * @param y Return location for Y coordinate of window (relative to its parent).
   * @param width Return location for width of window.
   * @param height Return location for height of window.
   * @param depth Return location for bit depth of window.
   */
  void get_geometry(int& x, int& y, int& width, int& height, int& depth) const;
  
  /** Obtains the position of the window as reported in the
   * most-recently-processed Gdk::EventConfigure. Contrast with
   * gdk_window_get_geometry() which queries the X server for the
   * current window position, regardless of which events have been
   * received or processed.
   * 
   * The position coordinates are relative to the window's parent window.
   * @param x X coordinate of window.
   * @param y Y coordinate of window.
   */
  void get_position(int& x, int& y) const;
  
  /** Obtains the position of a window in root window coordinates.
   * (Compare with gdk_window_get_position() and
   * gdk_window_get_geometry() which return the position of a window
   * relative to its parent window.)
   * @param x Return location for X coordinate.
   * @param y Return location for Y coordinate.
   * @return Not meaningful, ignore.
   */
  int get_origin(int& x, int& y) const;
  
  /** Obtains the position of a window position in root
   * window coordinates. This is similar to
   * gdk_window_get_origin() but allows you go pass
   * in any position in the window, not just the origin.
   * 
   * @newin{2,18}
   * @param x X coordinate in window.
   * @param y Y coordinate in window.
   * @param root_x Return location for X coordinate.
   * @param root_y Return location for Y coordinate.
   */
  void get_root_coords(int x, int y, int& root_x, int& root_y);
  
  
  /** Obtains the top-left corner of the window manager frame in root
   * window coordinates.
   * @param x Return location for X position of window frame.
   * @param y Return location for Y position of window frame.
   */
  void get_root_origin(int& x, int& y) const;
  
  /** Obtains the bounding box of the window, including window manager
   * titlebar/borders if any. The frame position is given in root window
   * coordinates. To get the position of the window itself (rather than
   * the frame) in root window coordinates, use gdk_window_get_origin().
   * @param rect Rectangle to fill with bounding box of the window frame.
   */
  void get_frame_extents(Rectangle& rect);
  
  /** Obtains the current pointer position and modifier state.
   * The position is given in coordinates relative to the upper left
   * corner of @a window.
   * @param x Return location for X coordinate of pointer or <tt>0</tt> to not
   * return the X coordinate.
   * @param y Return location for Y coordinate of pointer or <tt>0</tt> to not
   * return the Y coordinate.
   * @param mask Return location for modifier mask or <tt>0</tt> to not return the
   * modifier mask.
   * @return The window containing the pointer (as with
   * gdk_window_at_pointer()), or <tt>0</tt> if the window containing the
   * pointer isn't known to GDK.
   */
  Glib::RefPtr<Window> get_pointer(int& x, int& y, ModifierType& mask);
  
  /** Obtains the parent of @a window, as known to GDK. Does not query the
   * X server; thus this returns the parent as passed to gdk_window_new(),
   * not the actual parent. This should never matter unless you're using
   * Xlib calls mixed with GDK calls on the X11 platform. It may also
   * matter for toplevel windows, because the window manager may choose
   * to reparent them.
   * @return Parent of @a window.
   */
  Glib::RefPtr<Window> get_parent();
  
  /** Obtains the parent of @a window, as known to GDK. Does not query the
   * X server; thus this returns the parent as passed to gdk_window_new(),
   * not the actual parent. This should never matter unless you're using
   * Xlib calls mixed with GDK calls on the X11 platform. It may also
   * matter for toplevel windows, because the window manager may choose
   * to reparent them.
   * @return Parent of @a window.
   */
  Glib::RefPtr<const Window> get_parent() const;
  
  /** Gets the toplevel window that's an ancestor of @a window.
   * 
   * Any window type but Gdk::WINDOW_CHILD is considered a
   * toplevel window, as is a Gdk::WINDOW_CHILD window that
   * has a root window as parent.
   * @return The toplevel window containing @a window.
   */
  Glib::RefPtr<Window> get_toplevel();
  
  /** Gets the toplevel window that's an ancestor of @a window.
   * 
   * Any window type but Gdk::WINDOW_CHILD is considered a
   * toplevel window, as is a Gdk::WINDOW_CHILD window that
   * has a root window as parent.
   * @return The toplevel window containing @a window.
   */
  Glib::RefPtr<const Window> get_toplevel() const;

  
  /** Gets the list of children of @a window known to GDK.
   * This function only returns children created via GDK,
   * so for example it's useless when used with the root window;
   * it only returns windows an application created itself.
   * 
   * The returned list must be freed, but the elements in the
   * list need not be.
   * @return List of child windows inside @a window.
   */
  Glib::ListHandle< Glib::RefPtr<Window> > get_children();
  
  /** Gets the list of children of @a window known to GDK.
   * This function only returns children created via GDK,
   * so for example it's useless when used with the root window;
   * it only returns windows an application created itself.
   * 
   * The returned list must be freed, but the elements in the
   * list need not be.
   * @return List of child windows inside @a window.
   */
  Glib::ListHandle< Glib::RefPtr<const Window> > get_children() const;
   //gdk_window_peek_children() is the same as gdk_window_get_children() with different memory mangement of the list.

  
  /** Gets the event mask for @a window. See gdk_window_set_events().
   * @return Event mask for @a window.
   */
  EventMask get_events() const;
  
  /** The event mask for a window determines which events will be reported
   * for that window. For example, an event mask including Gdk::BUTTON_PRESS_MASK
   * means the window should report button press events. The event mask
   * is the bitwise OR of values from the Gdk::EventMask enumeration.
   * @param event_mask Event mask for @a window.
   */
  void set_events(EventMask event_mask);

  
  /** Sets a list of icons for the window. One of these will be used
   * to represent the window when it has been iconified. The icon is
   * usually shown in an icon box or some sort of task bar. Which icon
   * size is shown depends on the window manager. The window manager
   * can scale the icon  but setting several size icons can give better
   * image quality since the window manager may only need to scale the
   * icon by a small amount or not at all.
   * @param pixbufs A list of pixbufs, of different sizes.
   */
  void set_icon_list(const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& pixbufs);
  
  /** Sets the icon of @a window as a pixmap or window. If using GTK+, investigate
   * gtk_window_set_default_icon_list() first, and then gtk_window_set_icon_list()
   * and gtk_window_set_icon(). If those don't meet your needs, look at
   * gdk_window_set_icon_list(). Only if all those are too high-level do you
   * want to fall back to gdk_window_set_icon().
   * @param icon_window A Gdk::Window to use for the icon.
   * @param pixmap A Gdk::Pixmap to use as the icon,.
   * @param mask A 1-bit pixmap (Gdk::Bitmap) to use as mask for @a pixmap.
   */
  void set_icon(const Glib::RefPtr<Window>& icon_window, const Glib::RefPtr<Pixmap>& pixmap, const Glib::RefPtr<Bitmap>& mask);
  void set_icon(const Glib::RefPtr<Window>& icon_window, const Glib::RefPtr<Pixmap>& pixmap);
  void unset_icon();
  
  /** Windows may have a name used while minimized, distinct from the
   * name they display in their titlebar. Most of the time this is a bad
   * idea from a user interface standpoint. But you can set such a name
   * with this function, if you like.
   * 
   * After calling this with a non-<tt>0</tt> @a name, calls to gdk_window_set_title()
   * will not update the icon title.
   * 
   * Using <tt>0</tt> for @a name unsets the icon title; further calls to
   * gdk_window_set_title() will again update the icon title as well.
   * @param name Name of window while iconified (minimized).
   */
  void set_icon_name(const Glib::ustring& name);

  
  /** Sets the group leader window for @a window. By default,
   * GDK sets the group leader for all toplevel windows
   * to a global window implicitly created by GDK. With this function
   * you can override this default.
   * 
   * The group leader window allows the window manager to distinguish
   * all windows that belong to a single application. It may for example
   * allow users to minimize/unminimize all windows belonging to an
   * application at once. You should only set a non-default group window
   * if your application pretends to be multiple applications.
   * @param leader Group leader window, or <tt>0</tt> to restore the default group leader window.
   */
  void set_group(const Glib::RefPtr<Window>& leader);
  
  /** Return value: the group leader window for @a window
   * @return The group leader window for @a window
   * 
   * @newin{2,4}.
   */
  Glib::RefPtr<Window> get_group();
  
  /** Return value: the group leader window for @a window
   * @return The group leader window for @a window
   * 
   * @newin{2,4}.
   */
  Glib::RefPtr<const Window> get_group() const;

  
  /** "Decorations" are the features the window manager adds to a toplevel Gdk::Window.
   * This function sets the traditional Motif window manager hints that tell the
   * window manager which decorations you would like your window to have.
   * Usually you should use gtk_window_set_decorated() on a Gtk::Window instead of
   * using the GDK function directly.
   * 
   * The @a decorations argument is the logical OR of the fields in
   * the Gdk::WMDecoration enumeration. If Gdk::DECOR_ALL is included in the
   * mask, the other bits indicate which decorations should be turned off.
   * If Gdk::DECOR_ALL is not included, then the other bits indicate
   * which decorations should be turned on.
   * 
   * Most window managers honor a decorations hint of 0 to disable all decorations,
   * but very few honor all possible combinations of bits.
   * @param decorations Decoration hint mask.
   */
  void set_decorations(WMDecoration decorations);
  
  /** Returns: <tt>true</tt> if the window has decorations set, <tt>false</tt> otherwise.
   * @param decorations The window decorations will be written here.
   * @return <tt>true</tt> if the window has decorations set, <tt>false</tt> otherwise.
   */
  bool get_decorations(WMDecoration& decorations) const;
  
  /** Sets hints about the window management functions to make available
   * via buttons on the window frame.
   * 
   * On the X backend, this function sets the traditional Motif window 
   * manager hint for this purpose. However, few window managers do
   * anything reliable or interesting with this hint. Many ignore it
   * entirely.
   * 
   * The @a functions argument is the logical OR of values from the
   * Gdk::WMFunction enumeration. If the bitmask includes Gdk::FUNC_ALL,
   * then the other bits indicate which functions to disable; if
   * it doesn't include Gdk::FUNC_ALL, it indicates which functions to
   * enable.
   * @param functions Bitmask of operations to allow on @a window.
   */
  void set_functions(WMFunction functions);

  
#ifndef GDKMM_DISABLE_DEPRECATED

  /** Obtains a list of all toplevel windows known to GDK on the default
   * screen (see gdk_window_get_toplevels_for_screen()).
   * A toplevel window is a child of the root window (see
   * gdk_get_default_root_window()).
   * @return List of toplevel windows.
   */
  static Glib::ListHandle< Glib::RefPtr<Window> > get_toplevels();
#endif // GDKMM_DISABLE_DEPRECATED


  /** Emits a short beep associated to @a window in the appropriate
   * display, if supported. Otherwise, emits a short beep on
   * the display just as Gdk::Display::beep().
   * 
   * @newin{2,12}
   */
  void beep();

  
  /** Asks to iconify (minimize) @a window. The window manager may choose
   * to ignore the request, but normally will honor it. Using
   * gtk_window_iconify() is preferred, if you have a Gtk::Window widget.
   * 
   * This function only makes sense when @a window is a toplevel window.
   */
  void iconify();
  
  /** Attempt to deiconify (unminimize) @a window. On X11 the window manager may
   * choose to ignore the request to deiconify. When using GTK+,
   * use gtk_window_deiconify() instead of the Gdk::Window variant. Or better yet,
   * you probably want to use gtk_window_present(), which raises the window, focuses it,
   * unminimizes it, and puts it on the current desktop.
   */
  void deiconify();
  
  /** "Pins" a window such that it's on all workspaces and does not scroll
   * with viewports, for window managers that have scrollable viewports.
   * (When using Gtk::Window, gtk_window_stick() may be more useful.)
   * 
   * On the X11 platform, this function depends on window manager
   * support, so may have no effect with many window managers. However,
   * GDK will do the best it can to convince the window manager to stick
   * the window. For window managers that don't support this operation,
   * there's nothing you can do to force it to happen.
   */
  void stick();
  
  /** Reverse operation for gdk_window_stick(); see gdk_window_stick(),
   * and gtk_window_unstick().
   */
  void unstick();
  
  /** Maximizes the window. If the window was already maximized, then
   * this function does nothing.
   * 
   * On X11, asks the window manager to maximize @a window, if the window
   * manager supports this operation. Not all window managers support
   * this, and some deliberately ignore it or don't have a concept of
   * "maximized"; so you can't rely on the maximization actually
   * happening. But it will happen with most standard window managers,
   * and GDK makes a best effort to get it to happen.
   * 
   * On Windows, reliably maximizes the window.
   */
  void maximize();
  
  /** Unmaximizes the window. If the window wasn't maximized, then this
   * function does nothing.
   * 
   * On X11, asks the window manager to unmaximize @a window, if the
   * window manager supports this operation. Not all window managers
   * support this, and some deliberately ignore it or don't have a
   * concept of "maximized"; so you can't rely on the unmaximization
   * actually happening. But it will happen with most standard window
   * managers, and GDK makes a best effort to get it to happen.
   * 
   * On Windows, reliably unmaximizes the window.
   */
  void unmaximize();
  
  void register_dnd();
  
  /** Begins a window resize operation (for a toplevel window).
   * You might use this function to implement a "window resize grip," for
   * example; in fact Gtk::Statusbar uses it. The function works best
   * with window managers that support the <ulink url="http://www.freedesktop.org/Standards/wm-spec">Extended Window Manager Hints</ulink>, but has a 
   * fallback implementation for other window managers.
   * @param edge The edge or corner from which the drag is started.
   * @param button The button being used to drag.
   * @param root_x Root window X coordinate of mouse click that began the drag.
   * @param root_y Root window Y coordinate of mouse click that began the drag.
   * @param timestamp Timestamp of mouse click that began the drag (use gdk_event_get_time()).
   */
  void begin_resize_drag(WindowEdge  edge, int button, int root_x, int root_y, guint32 timestamp);
  
  /** Begins a window move operation (for a toplevel window).  You might
   * use this function to implement a "window move grip," for
   * example. The function works best with window managers that support
   * the <ulink url="http://www.freedesktop.org/Standards/wm-spec">Extended 
   * Window Manager Hints</ulink>, but has a fallback implementation for
   * other window managers.
   * @param button The button being used to drag.
   * @param root_x Root window X coordinate of mouse click that began the drag.
   * @param root_y Root window Y coordinate of mouse click that began the drag.
   * @param timestamp Timestamp of mouse click that began the drag.
   */
  void begin_move_drag(int button, int root_x, int root_y, guint32 timestamp);

  
  /** A convenience wrapper around invalidate_region() which
   * invalidates a rectangular region. See invalidate_region() for details.
   * See also the invalidate_rect() method overload with no rect parameter, to 
   * invalidate the whole region.
   * @param rect Rectangle to invalidate.
   * @param invalidate_children Whether to also invalidate child windows.
   */
  void invalidate_rect(const Rectangle& rect, bool invalidate_children);

  /** A convenience wrapper around invalidate_region() which
   * invalidates the whole region. See invalidate_region() for details.
   * @param invalidate_children Whether to also invalidate child windows.
   */
  void invalidate(bool invalidate_children);

  
  /** Adds @a region to the update area for @a window. The update area is the
   * region that needs to be redrawn, or "dirty region." The call
   * gdk_window_process_updates() sends one or more expose events to the
   * window, which together cover the entire update area. An
   * application would normally redraw the contents of @a window in
   * response to those expose events.
   * 
   * GDK will call gdk_window_process_all_updates() on your behalf
   * whenever your program returns to the main loop and becomes idle, so
   * normally there's no need to do that manually, you just need to
   * invalidate regions that you know should be redrawn.
   * 
   * The @a invalidate_children parameter controls whether the region of
   * each child window that intersects @a region will also be invalidated.
   * If <tt>false</tt>, then the update area for child windows will remain
   * unaffected. See gdk_window_invalidate_maybe_recurse if you need
   * fine grained control over which children are invalidated.
   * @param region A Gdk::Region.
   * @param invalidate_children <tt>true</tt> to also invalidate child windows.
   */
  void invalidate_region(const Region& region, bool invalidate_children = true);

  
  /** Transfers ownership of the update area from @a window to the caller
   * of the function. That is, after calling this function, @a window will
   * no longer have an invalid/dirty region; the update area is removed
   * from @a window and handed to you. If a window has no update area,
   * get_update_area() returns an invalid Region.
   * @return The update area for @a window.
   */
  Region get_update_area();
  //This method should not have a const version - see the docs.

  
  /** Temporarily freezes a window such that it won't receive expose
   * events.  The window will begin receiving expose events again when
   * Gdk::Window::thaw_updates() is called. If Gdk::Window::freeze_updates()
   * has been called more than once, Gdk::Window::thaw_updates() must be called
   * an equal number of times to begin processing exposes.
   */
  void freeze_updates();
  
  /** Thaws a window frozen with Gdk::Window::freeze_updates().
   */
  void thaw_updates();
  
  /** Calls gdk_window_process_updates() for all windows (see Gdk::Window)
   * in the application.
   */
  static void process_all_updates();
  
  /** Sends one or more expose events to @a window. The areas in each
   * expose event will cover the entire update area for the window (see
   * gdk_window_invalidate_region() for details). Normally GDK calls
   * gdk_window_process_all_updates() on your behalf, so there's no
   * need to call this function unless you want to force expose events
   * to be delivered immediately and synchronously (vs. the usual
   * case, where GDK delivers them in an idle handler). Occasionally
   * this is useful to produce nicer scrolling behavior, for example.
   * @param update_children Whether to also process updates for child windows.
   */
  void process_updates(bool update_children);
  
  /** With update debugging enabled, calls to
   * gdk_window_invalidate_region() clear the invalidated region of the
   * screen to a noticeable color, and GDK pauses for a short time
   * before sending exposes to windows during
   * gdk_window_process_updates().  The net effect is that you can see
   * the invalid region for each window and watch redraws as they
   * occur. This allows you to diagnose inefficiencies in your application.
   * 
   * In essence, because the GDK rendering model prevents all flicker,
   * if you are redrawing the same region 400 times you may never
   * notice, aside from noticing a speed problem. Enabling update
   * debugging causes GTK to flicker slowly and noticeably, so you can
   * see exactly what's being redrawn when, in what order.
   * 
   * The --gtk-debug=updates command line option passed to GTK+ programs
   * enables this debug option at application startup time. That's
   * usually more useful than calling gdk_window_set_debug_updates()
   * yourself, though you might want to use this function to enable
   * updates sometime after application startup time.
   * @param setting <tt>true</tt> to turn on update debugging.
   */
  static void set_debug_updates(bool setting = true);
  
  /** Constrains a desired width and height according to a
   * set of geometry hints (such as minimum and maximum size).
   * @param geometry A Gdk::Geometry structure.
   * @param flags A mask indicating what portions of @a geometry are set.
   * @param width Desired width of window.
   * @param height Desired height of the window.
   * @param new_width Location to store resulting width.
   * @param new_height Location to store resulting height.
   */
  static void constrain_size(const Geometry& geometry, guint flags, int width, int height, int& new_width, int& new_height);
  void get_internal_paint_info(Glib::RefPtr<Drawable>& real_drawable, int& x_offset, int& y_offset) const;

  
  /** Indicates that the application will cooperate with the window
   * system in synchronizing the window repaint with the window
   * manager during resizing operations. After an application calls
   * this function, it must call gdk_window_configure_finished() every
   * time it has finished all processing associated with a set of
   * Configure events. Toplevel GTK+ windows automatically use this
   * protocol.
   * 
   * On X, calling this function makes @a window participate in the
   * _NET_WM_SYNC_REQUEST window manager protocol.
   * 
   * @newin{2,6}
   */
  void enable_synchronized_configure();
  
  /** Signal to the window system that the application has finished
   * handling Configure events it has received. Window Managers can
   * use this to better synchronize the frame repaint with the
   * application. GTK+ applications will automatically call this
   * function when appropriate.
   * 
   * This function can only be called if gdk_window_enable_synchronized_configure()
   * was called previously.
   * 
   * @newin{2,6}
   */
  void configure_finished();

  
  /** Toggles whether a window should appear in a task list or window
   * list. If a window's semantic type as specified with
   * gdk_window_set_type_hint() already fully describes the window, this
   * function should <emphasis>not</emphasis> be called in addition, 
   * instead you should allow the window to be treated according to 
   * standard policy for its semantic type.
   * 
   * @newin{2,2}
   * @param skips_taskbar <tt>true</tt> to skip the taskbar.
   */
  void set_skip_taskbar_hint(bool skips_taskbar = true);
  
  /** Toggles whether a window should appear in a pager (workspace
   * switcher, or other desktop utility program that displays a small
   * thumbnail representation of the windows on the desktop). If a
   * window's semantic type as specified with gdk_window_set_type_hint()
   * already fully describes the window, this function should 
   * <emphasis>not</emphasis> be called in addition, instead you should 
   * allow the window to be treated according to standard policy for 
   * its semantic type.
   * 
   * @newin{2,2}
   * @param skips_pager <tt>true</tt> to skip the pager.
   */
  void set_skip_pager_hint(bool skips_pager = true);

  
  /** Toggles whether a window needs the user's
   * urgent attention.
   * 
   * @newin{2,8}
   * @param urgent <tt>true</tt> if the window is urgent.
   */
  void set_urgency_hint(bool urgent = true);

  
  /** Moves the window into fullscreen mode. This means the
   * window covers the entire screen and is above any panels
   * or task bars.
   * 
   * If the window was already fullscreen, then this function does nothing.
   * 
   * On X11, asks the window manager to put @a window in a fullscreen
   * state, if the window manager supports this operation. Not all
   * window managers support this, and some deliberately ignore it or
   * don't have a concept of "fullscreen"; so you can't rely on the
   * fullscreenification actually happening. But it will happen with
   * most standard window managers, and GDK makes a best effort to get
   * it to happen.
   * 
   * @newin{2,2}
   */
  void fullscreen();
  
  /** Moves the window out of fullscreen mode. If the window was not
   * fullscreen, does nothing.
   * 
   * On X11, asks the window manager to move @a window out of the fullscreen
   * state, if the window manager supports this operation. Not all
   * window managers support this, and some deliberately ignore it or
   * don't have a concept of "fullscreen"; so you can't rely on the
   * unfullscreenification actually happening. But it will happen with
   * most standard window managers, and GDK makes a best effort to get
   * it to happen. 
   * 
   * @newin{2,2}
   */
  void unfullscreen();

  
  GrabStatus pointer_grab(bool owner_events, EventMask event_mask, const Glib::RefPtr<const Window>& confine_to, const Cursor& cursor, guint32 time_);

  /** Grabs the pointer to a specific window.
   * Requires a corresponding call to pointer_ungrab().
   *
   * Arguments:
   * @param owner_events Specifies whether events will be reported as is, or relative to the window.
   * @param event_mask Masks only interesting events.
   * @param cursor Changes the cursor for the duration of the grab.
   * @param timestamp Specifies the time.
   */
  GrabStatus pointer_grab(bool owner_events, EventMask event_mask, const Cursor& cursor, guint32 timestamp);

  /** Grabs the pointer to a specific window.
   * Requires a corresponding call to pointer_ungrab().
   *
   * Arguments:
   * @param owner_events Specifies whether events will be reported as is, or relative to the window.
   * @param event_mask Masks only interesting events.
   * @param timestamp Specifies the time.
   */
  GrabStatus pointer_grab(bool owner_events, EventMask event_mask, guint32 timestamp);

  
  /** Ungrabs the pointer on the default display, if it is grabbed by this 
   * application.
   * @param timestamp A timestamp from a Gdk::Event, or Gdk::CURRENT_TIME if no 
   * timestamp is available.
   */
  static void pointer_ungrab(guint32 timestamp);
  
  GrabStatus keyboard_grab(bool owner_events, guint32 timestamp);
  
  /** Ungrabs the keyboard on the default display, if it is grabbed by this 
   * application.
   * @param timestamp A timestamp from a Gdk::Event, or Gdk::CURRENT_TIME if no
   * timestamp is available.
   */
  static void keyboard_ungrab(guint32 timestamp);

  
  /** Set if @a window must be kept above other windows. If the
   * window was already above, then this function does nothing.
   * 
   * On X11, asks the window manager to keep @a window above, if the window
   * manager supports this operation. Not all window managers support
   * this, and some deliberately ignore it or don't have a concept of
   * "keep above"; so you can't rely on the window being kept above.
   * But it will happen with most standard window managers,
   * and GDK makes a best effort to get it to happen.
   * 
   * @newin{2,4}
   * @param setting Whether to keep @a window above other windows.
   */
  void set_keep_above(bool setting = true);
  
  /** Set if @a window must be kept below other windows. If the
   * window was already below, then this function does nothing.
   * 
   * On X11, asks the window manager to keep @a window below, if the window
   * manager supports this operation. Not all window managers support
   * this, and some deliberately ignore it or don't have a concept of
   * "keep below"; so you can't rely on the window being kept below.
   * But it will happen with most standard window managers,
   * and GDK makes a best effort to get it to happen.
   * 
   * @newin{2,4}
   * @param setting Whether to keep @a window below other windows.
   */
  void set_keep_below(bool setting = true);

  
  /** Request the windowing system to make @a window partially transparent,
   * with opacity 0 being fully transparent and 1 fully opaque. (Values
   * of the opacity parameter are clamped to the [0,1] range.) 
   * 
   * On X11, this works only on X screens with a compositing manager 
   * running.
   * 
   * For setting up per-pixel alpha, see Gdk::Screen::get_rgba_colormap().
   * For making non-toplevel windows translucent, see 
   * gdk_window_set_composited().
   * 
   * @newin{2,12}
   * @param opacity Opacity.
   */
  void set_opacity(double opacity);

  
  /** Setting @a accept_focus to <tt>false</tt> hints the desktop environment that the
   * window doesn't want to receive input focus. 
   * 
   * On X, it is the responsibility of the window manager to interpret this 
   * hint. ICCCM-compliant window manager usually respect it.
   * 
   * @newin{2,4}
   * @param accept_focus <tt>true</tt> if the window should receive input focus.
   */
  void set_accept_focus(bool accept_focus = true);

  
  /** Setting @a focus_on_map to <tt>false</tt> hints the desktop environment that the
   * window doesn't want to receive input focus when it is mapped.  
   * focus_on_map should be turned off for windows that aren't triggered
   * interactively (such as popups from network activity).
   * 
   * On X, it is the responsibility of the window manager to interpret
   * this hint. %Window managers following the freedesktop.org window
   * manager extension specification should respect it.
   * 
   * @newin{2,6}
   * @param focus_on_map <tt>true</tt> if the window should receive input focus when mapped.
   */
  void set_focus_on_map(bool focus_on_map);

  
  /** Obtains the root window (parent all other windows are inside)
   * for the default display and screen.
   * @return The default root window.
   */
  static Glib::RefPtr<Window> get_default_root_window();

  
  /** Gets the offscreen pixmap that an offscreen window renders into.
   * If you need to keep this around over window resizes, you need to
   * add a reference to it.
   * @param window A Gdk::Window.
   * @return The offscreen pixmap, or <tt>0</tt> if not offscreen
   * 
   * @newin{2,18}.
   */
  Glib::RefPtr<Pixmap> get_offscreen_pixmap();
  
  /** Gets the offscreen pixmap that an offscreen window renders into.
   * If you need to keep this around over window resizes, you need to
   * add a reference to it.
   * @param window A Gdk::Window.
   * @return The offscreen pixmap, or <tt>0</tt> if not offscreen
   * 
   * @newin{2,18}.
   */
  Glib::RefPtr<const Pixmap> get_offscreen_pixmap() const;

  
  /** Gets the window that @a window is embedded in.
   * @param window A Gdk::Window.
   * @return The embedding Gdk::Window, or <tt>0</tt> if @a window is not an
   * embedded offscreen window
   * 
   * @newin{2,18}.
   */
  Glib::RefPtr<Window> get_offscreen_embedder();
  
  /** Gets the window that @a window is embedded in.
   * @param window A Gdk::Window.
   * @return The embedding Gdk::Window, or <tt>0</tt> if @a window is not an
   * embedded offscreen window
   * 
   * @newin{2,18}.
   */
  Glib::RefPtr<const Window> get_offscreen_embedder() const;
  
   
  /** Sets @a window to be embedded in @a embedder.
   * 
   * To fully embed an offscreen window, in addition to calling this
   * function, it is also necessary to handle the Gdk::Window::pick-embedded-child
   * signal on the @a embedder and the Gdk::Window::to-embedder and
   * Gdk::Window::from-embedder signals on @a window.
   * 
   * @newin{2,18}
   * @param window A Gdk::Window.
   * @param embedder The Gdk::Window that @a window gets embedded in.
   */
  void set_offscreen_embedder(const Glib::RefPtr<Window>& embedder);

  
  /** Redirects drawing into @a window so that drawing to the
   * window in the rectangle specified by @a src_x, @a src_y,
   *  @a width and @a height is also drawn into @a drawable at
   *  @a dest_x, @a dest_y.
   * 
   * Only drawing between gdk_window_begin_paint_region() or
   * gdk_window_begin_paint_rect() and gdk_window_end_paint() is
   * redirected.
   * 
   * Redirection is active until gdk_window_remove_redirection()
   * is called.
   * 
   * @newin{2,14}
   * @param drawable A Gdk::Drawable.
   * @param src_x X position in @a window.
   * @param src_y Y position in @a window.
   * @param dest_x X position in @a drawable.
   * @param dest_y Y position in @a drawable.
   * @param width Width of redirection, or -1 to use the width of @a window.
   * @param height Height of redirection or -1 to use the height of @a window.
   */
  void redirect_to_drawable(const Glib::RefPtr<Drawable>& drawable, int src_x, int src_y, int dest_x, int dest_y, int width, int height);
  
  /** Removes any active redirection started by
   * gdk_window_redirect_to_drawable().
   * 
   * @newin{2,14}
   */
  void remove_redirection();

  
  /** This function informs GDK that the geometry of an embedded
   * offscreen window has changed. This is necessary for GDK to keep
   * track of which offscreen window the pointer is in.
   * 
   * @newin{2,18}
   */
  void geometry_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Window
   */
  Glib::RefPtr<Gdk::Window> wrap(GdkWindowObject* object, bool take_copy = false);
}


#endif /* _GDKMM_WINDOW_H */

