/************************************************************/
/* THIS FILE IS GENERATED DO NOT EDIT */
/************************************************************/

/**
 * GAction:enabled:
 *
 * If @action is currently enabled.
 *
 * If the action is disabled then calls to g_action_activate() and
 * g_action_change_state() have no effect.
 *
 * Since: 2.28
 */


/**
 * GAction:name:
 *
 * The name of the action.  This is mostly meaningful for identifying
 * the action once it has been added to a #GActionGroup.
 *
 * Since: 2.28
 */


/**
 * GAction:parameter-type:
 *
 * The type of the parameter that must be given when activating the
 * action.
 *
 * Since: 2.28
 */


/**
 * GAction:state:
 *
 * The state of the action, or %NULL if the action is stateless.
 *
 * Since: 2.28
 */


/**
 * GAction:state-type:
 *
 * The #GVariantType of the state that the action has, or %NULL if the
 * action is stateless.
 *
 * Since: 2.28
 */


/**
 * GActionEntry:
 * @name: the name of the action
 * @activate: the callback to connect to the "activate" signal of the action
 * @parameter_type: the type of the parameter that must be passed to the activate function for this action, given as a single GVariant type string (or %NULL for no parameter)
 * @state: the initial state for this action, given in GVariant text format.  The state is parsed with no extra type information, so type tags must be added to the string if they are necessary.
 * @change_state: the callback to connect to the "change-state" signal of the action
 *
 * This struct defines a single action.  It is for use with
 * g_action_map_add_action_entries().
 *
 * The order of the items in the structure are intended to reflect
 * frequency of use.  It is permissible to use an incomplete initialiser
 * in order to leave some of the later values as %NULL.  All values
 * after @name are optional.  Additional optional fields may be added in
 * the future.
 *
 * See g_action_map_add_action_entries() for an example.
 */


/**
 * GActionGroup::action-added:
 * @action_group: the #GActionGroup that changed
 * @action_name: the name of the action in @action_group
 *
 * Signals that a new action was just added to the group.
 * This signal is emitted after the action has been added
 * and is now visible.
 *
 * Since: 2.28
 */


/**
 * GActionGroup::action-enabled-changed:
 * @action_group: the #GActionGroup that changed
 * @action_name: the name of the action in @action_group
 * @enabled: whether the action is enabled or not
 *
 * Signals that the enabled status of the named action has changed.
 *
 * Since: 2.28
 */


/**
 * GActionGroup::action-removed:
 * @action_group: the #GActionGroup that changed
 * @action_name: the name of the action in @action_group
 *
 * Signals that an action is just about to be removed from the group.
 * This signal is emitted before the action is removed, so the action
 * is still visible and can be queried from the signal handler.
 *
 * Since: 2.28
 */


/**
 * GActionGroup::action-state-changed:
 * @action_group: the #GActionGroup that changed
 * @action_name: the name of the action in @action_group
 * @value: the new value of the state
 *
 * Signals that the state of the named action has changed.
 *
 * Since: 2.28
 */


/**
 * GActionGroupInterface:
 * @has_action: the virtual function pointer for g_action_group_has_action()
 * @list_actions: the virtual function pointer for g_action_group_list_actions()
 * @get_action_parameter_type: the virtual function pointer for g_action_group_get_action_parameter_type()
 * @get_action_state_type: the virtual function pointer for g_action_group_get_action_state_type()
 * @get_action_state_hint: the virtual function pointer for g_action_group_get_action_state_hint()
 * @get_action_enabled: the virtual function pointer for g_action_group_get_action_enabled()
 * @get_action_state: the virtual function pointer for g_action_group_get_action_state()
 * @set_action_state: the virtual function pointer for g_action_group_set_action_state()
 * @query_action: the virtual function pointer for g_action_group_query_action()
 * @activate_action: the virtual function pointer for g_action_group_activate_action()
 * @change_action_state: the virtual function pointer for g_action_group_change_action_state()
 * @action_added: the class closure for the #GActionGroup::action-added signal
 * @action_removed: the class closure for the #GActionGroup::action-removed signal
 * @action_enabled_changed: the class closure for the #GActionGroup::action-enabled-changed signal
 * @action_state_changed: the class closure for the #GActionGroup::action-enabled-changed signal
 *
 * The virtual function table for #GActionGroup.
 *
 * Since: 2.28
 */


/**
 * GActionInterface:
 * @get_name: the virtual function pointer for g_action_get_name()
 * @get_parameter_type: the virtual function pointer for g_action_get_parameter_type()
 * @get_state_type: the virtual function pointer for g_action_get_state_type()
 * @get_state_hint: the virtual function pointer for g_action_get_state_hint()
 * @get_enabled: the virtual function pointer for g_action_get_enabled()
 * @get_state: the virtual function pointer for g_action_get_state()
 * @change_state: the virtual function pointer for g_action_change_state()
 * @activate: the virtual function pointer for g_action_activate().  Note that #GAction does not have an 'activate' signal but that implementations of it may have one.
 *
 * The virtual function table for #GAction.
 *
 * Since: 2.28
 */


/**
 * GActionMapInterface:
 * @lookup_action: the virtual function pointer for g_action_map_lookup_action()
 * @add_action: the virtual function pointer for g_action_map_add_action()
 * @remove_action: the virtual function pointer for g_action_map_remove_action()
 *
 * The virtual function table for #GActionMap.
 *
 * Since: 2.32
 */


/**
 * GAppInfo:
 *
 * Information about an installed application and methods to launch
 * it (with file arguments).
 */


/**
 * GAppInfoCreateFlags:
 * @G_APP_INFO_CREATE_NONE: No flags.
 * @G_APP_INFO_CREATE_NEEDS_TERMINAL: Application opens in a terminal window.
 * @G_APP_INFO_CREATE_SUPPORTS_URIS: Application supports URI arguments.
 * @G_APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION: Application supports startup notification. Since 2.26
 *
 * Flags used when creating a #GAppInfo.
 */


/**
 * GAppInfoIface:
 * @g_iface: The parent interface.
 * @dup: Copies a #GAppInfo.
 * @equal: Checks two #GAppInfo<!-- -->s for equality.
 * @get_id: Gets a string identifier for a #GAppInfo.
 * @get_name: Gets the name of the application for a #GAppInfo.
 * @get_description: Gets a short description for the application described by the #GAppInfo.
 * @get_executable: Gets the executable name for the #GAppInfo.
 * @get_icon: Gets the #GIcon for the #GAppInfo.
 * @launch: Launches an application specified by the #GAppInfo.
 * @supports_uris: Indicates whether the application specified supports launching URIs.
 * @supports_files: Indicates whether the application specified accepts filename arguments.
 * @launch_uris: Launches an application with a list of URIs.
 * @should_show: Returns whether an application should be shown (e.g. when getting a list of installed applications). <ulink url="http://standards.freedesktop.org/startup-notification-spec/startup-notification-latest.txt"> <citetitle>FreeDesktop.Org Startup Notification Specification</citetitle></ulink>.
 * @set_as_default_for_type: Sets an application as default for a given content type.
 * @set_as_default_for_extension: Sets an application as default for a given file extension.
 * @add_supports_type: Adds to the #GAppInfo information about supported file types.
 * @can_remove_supports_type: Checks for support for removing supported file types from a #GAppInfo.
 * @remove_supports_type: Removes a supported application type from a #GAppInfo.
 * @can_delete: Checks if a #GAppInfo can be deleted. Since 2.20
 * @do_delete: Deletes a #GAppInfo. Since 2.20
 * @get_commandline: Gets the commandline for the #GAppInfo. Since 2.20
 * @get_display_name: Gets the display name for the #GAppInfo. Since 2.24
 * @set_as_last_used_for_type: Sets the application as the last used. See g_app_info_set_as_last_used_for_type().
 *
 * Application Information interface, for operating system portability.
 */


/**
 * GAppLaunchContext:
 *
 * Integrating the launch with the launching application. This is used to
 * handle for instance startup notification and launching the new application
 * on the same screen as the launching window.
 */


/**
 * GApplication:
 *
 *
 *
 * Since: 2.28
 */


/**
 * GApplication::activate:
 * @application: the application
 *
 * The ::activate signal is emitted on the primary instance when an
 * activation occurs. See g_application_activate().
 */


/**
 * GApplication::command-line:
 * @application: the application
 * @command_line: a #GApplicationCommandLine representing the passed commandline
 *
 * The ::command-line signal is emitted on the primary instance when
 * a commandline is not handled locally. See g_application_run() and
 * the #GApplicationCommandline documentation for more information.
 *
 * process. See g_application_command_line_set_exit_status().
 *
 * Returns: An integer that is set as the exit status for the calling
 */


/**
 * GApplication::open:
 * @application: the application
 * @files: (array length=n_files) (element-type GFile): an array of #GFiles
 * @n_files: the length of @files
 * @hint: a hint provided by the calling instance
 *
 * The ::open signal is emitted on the primary instance when there are
 * files to open. See g_application_open() for more information.
 */


/**
 * GApplication::shutdown:
 * @application: the application
 *
 * The ::shutdown signal is emitted only on the registered primary instance
 * immediately after the main loop terminates.
 */


/**
 * GApplication::startup:
 * @application: the application
 *
 * The ::startup signal is emitted on the primary instance immediately
 * after registration. See g_application_register().
 */


/**
 * GApplicationClass:
 * @startup: invoked on the primary instance immediately after registration
 * @shutdown: invoked only on the registered primary instance immediately after the main loop terminates
 * @activate: invoked on the primary instance when an activation occurs
 * @open: invoked on the primary instance when there are files to open
 * @command_line: invoked on the primary instance when a command-line is not handled locally
 * @local_command_line: invoked (locally) when the process has been invoked via commandline execution (as opposed to, say, D-Bus activation - which is not currently supported by GApplication). The virtual function has the chance to inspect (and possibly replace) the list of command line arguments. See g_application_run() for more information.
 * @before_emit: invoked on the primary instance before 'activate', 'open', 'command-line' or any action invocation, gets the 'platform data' from the calling instance
 * @after_emit: invoked on the primary instance after 'activate', 'open', 'command-line' or any action invocation, gets the 'platform data' from the calling instance
 * @add_platform_data: invoked (locally) to add 'platform data' to be sent to the primary instance when activating, opening or invoking actions
 * @quit_mainloop: Used to be invoked on the primary instance when the use count of the application drops to zero (and after any inactivity timeout, if requested). Not used anymore since 2.32
 * @run_mainloop: Used to be invoked on the primary instance from g_application_run() if the use-count is non-zero. Since 2.32, GApplication is iterating the main context directly and is not using @run_mainloop anymore
 *
 * Virtual function table for #GApplication.
 *
 * Since: 2.28
 */


/**
 * GApplicationCommandLineClass:
 *
 * The <structname>GApplicationCommandLineClass</structname> structure
 * contains private data only
 *
 * Since: 2.28
 */


/**
 * GApplicationFlags:
 * @G_APPLICATION_FLAGS_NONE: Default
 * @G_APPLICATION_IS_SERVICE: Run as a service. In this mode, registration fails if the service is already running, and the application will stay around for a while when the use count falls to zero.
 * @G_APPLICATION_IS_LAUNCHER: Don't try to become the primary instance.
 * @G_APPLICATION_HANDLES_OPEN: This application handles opening files (in the primary instance). Note that this flag only affects the default implementation of local_command_line(), and has no effect if %G_APPLICATION_HANDLES_COMMAND_LINE is given. See g_application_run() for details.
 * @G_APPLICATION_HANDLES_COMMAND_LINE: This application handles command line arguments (in the primary instance). Note that this flag only affect the default implementation of local_command_line(). See g_application_run() for details.
 * @G_APPLICATION_SEND_ENVIRONMENT: Send the environment of the launching process to the primary instance. Set this flag if your application is expected to behave differently depending on certain environment variables. For instance, an editor might be expected to use the <envar>GIT_COMMITTER_NAME</envar> environment variable when editing a git commit message. The environment is available to the #GApplication::command-line signal handler, via g_application_command_line_getenv().
 * @G_APPLICATION_NON_UNIQUE: Make no attempts to do any of the typical single-instance application negotiation.  The application neither attempts to become the owner of the application ID nor does it check if an existing owner already exists.  Everything occurs in the local process.  Since: 2.30.
 *
 * Flags used to define the behaviour of a #GApplication.
 *
 * Since: 2.28
 */


/**
 * GAskPasswordFlags:
 * @G_ASK_PASSWORD_NEED_PASSWORD: operation requires a password.
 * @G_ASK_PASSWORD_NEED_USERNAME: operation requires a username.
 * @G_ASK_PASSWORD_NEED_DOMAIN: operation requires a domain.
 * @G_ASK_PASSWORD_SAVING_SUPPORTED: operation supports saving settings.
 * @G_ASK_PASSWORD_ANONYMOUS_SUPPORTED: operation supports anonymous users.
 *
 * #GAskPasswordFlags are used to request specific information from the
 * user, or to notify the user of their choices in an authentication
 * situation.
 */


/**
 * GAsyncInitable:
 *
 * Interface for asynchronously initializable objects.
 *
 * Since: 2.22
 */


/**
 * GAsyncInitableIface:
 * @g_iface: The parent interface.
 * @init_async: Starts initialization of the object.
 * @init_finish: Finishes initialization of the object.
 *
 * Provides an interface for asynchronous initializing object such that
 * initialization may fail.
 *
 * Since: 2.22
 */


/**
 * GAsyncReadyCallback:
 * @source_object: the object the asynchronous operation was started with.
 * @res: a #GAsyncResult.
 * @user_data: user data passed to the callback.
 *
 * Type definition for a function that will be called back when an asynchronous
 * operation within GIO has been completed.
 */


/**
 * GAsyncResult:
 *
 * Holds results information for an asynchronous operation,
 * usually passed directly to a asynchronous _finish() operation.
 */


/**
 * GAsyncResultIface:
 * @g_iface: The parent interface.
 * @get_user_data: Gets the user data passed to the callback.
 * @get_source_object: Gets the source object that issued the asynchronous operation.
 *
 * Interface definition for #GAsyncResult.
 */


/**
 * GBaseFinalizeFunc:
 * @g_class: The #GTypeClass structure to finalize.
 *
 * A callback function used by the type system to finalize those portions
 * of a derived types class structure that were setup from the corresponding
 * GBaseInitFunc() function. Class finalization basically works the inverse
 * way in which class intialization is performed.
 * See GClassInitFunc() for a discussion of the class intialization process.
 */


/**
 * GBaseInitFunc:
 * @g_class: The #GTypeClass structure to initialize.
 *
 * A callback function used by the type system to do base initialization
 * of the class structures of derived types. It is called as part of the
 * initialization process of all derived classes and should reallocate
 * or reset all dynamic class members copied over from the parent class.
 * For example, class members (such as strings) that are not sufficiently
 * handled by a plain memory copy of the parent class into the derived class
 * have to be altered. See GClassInitFunc() for a discussion of the class
 * intialization process.
 */


/**
 * GBinding:
 *
 * <structname>GBinding</structname> is an opaque structure whose members
 * cannot be accessed directly.
 *
 * Since: 2.26
 */


/**
 * GBindingFlags:
 * @G_BINDING_DEFAULT: The default binding; if the source property changes, the target property is updated with its value.
 * @G_BINDING_BIDIRECTIONAL: Bidirectional binding; if either the property of the source or the property of the target changes, the other is updated.
 * @G_BINDING_SYNC_CREATE: Synchronize the values of the source and target properties when creating the binding; the direction of the synchronization is always from the source to the target.
 * @G_BINDING_INVERT_BOOLEAN: If the two properties being bound are booleans, setting one to %TRUE will result in the other being set to %FALSE and vice versa. This flag will only work for boolean properties, and cannot be used when passing custom transformation functions to g_object_bind_property_full().
 *
 * Flags to be passed to g_object_bind_property() or
 * g_object_bind_property_full().
 *
 * This enumeration can be extended at later date.
 *
 * Since: 2.26
 */


/**
 * GBindingTransformFunc:
 * @binding: a #GBinding
 * @source_value: the value of the source property
 * @target_value: the value of the target property
 * @user_data: data passed to the transform function
 *
 * A function to be called to transform the source property of @source
 * from @source_value into the target property of @target
 * using @target_value.
 *
 * otherwise
 *
 * Returns: %TRUE if the transformation was successful, and %FALSE
 * Since: 2.26
 */


/**
 * GBookmarkFile:
 *
 * The <structname>GBookmarkFile</structname> struct contains only
 * private data and should not be directly accessed.
 */


/**
 * GBookmarkFileError:
 * @G_BOOKMARK_FILE_ERROR_INVALID_URI: URI was ill-formed
 * @G_BOOKMARK_FILE_ERROR_INVALID_VALUE: a requested field was not found
 * @G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED: a requested application did not register a bookmark
 * @G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND: a requested URI was not found
 * @G_BOOKMARK_FILE_ERROR_READ: document was ill formed
 * @G_BOOKMARK_FILE_ERROR_UNKNOWN_ENCODING: the text being parsed was in an unknown encoding
 * @G_BOOKMARK_FILE_ERROR_WRITE: an error occurred while writing
 * @G_BOOKMARK_FILE_ERROR_FILE_NOT_FOUND: requested file was not found
 *
 * Error codes returned by bookmark file parsing.
 */


/**
 * GBoxedCopyFunc:
 * @boxed: The boxed structure to be copied.
 *
 * This function is provided by the user and should produce a copy
 * of the passed in boxed structure.
 *
 * Returns: The newly created copy of the boxed structure.
 */


/**
 * GBoxedFreeFunc:
 * @boxed: The boxed structure to be freed.
 *
 * This function is provided by the user and should free the boxed
 * structure passed.
 */


/**
 * GBufferedInputStream:
 *
 * Implements #GFilterInputStream with a sized input buffer.
 */


/**
 * GBufferedOutputStream:
 *
 * An implementation of #GFilterOutputStream with a sized buffer.
 */


/**
 * GBusAcquiredCallback:
 * @connection: The #GDBusConnection to a message bus.
 * @name: The name that is requested to be owned.
 * @user_data: User data passed to g_bus_own_name().
 *
 * Invoked when a connection to a message bus has been obtained.
 *
 * Since: 2.26
 */


/**
 * GBusNameAcquiredCallback:
 * @connection: The #GDBusConnection on which to acquired the name.
 * @name: The name being owned.
 * @user_data: User data passed to g_bus_own_name() or g_bus_own_name_on_connection().
 *
 * Invoked when the name is acquired.
 *
 * Since: 2.26
 */


/**
 * GBusNameAppearedCallback:
 * @connection: The #GDBusConnection the name is being watched on.
 * @name: The name being watched.
 * @name_owner: Unique name of the owner of the name being watched.
 * @user_data: User data passed to g_bus_watch_name().
 *
 * Invoked when the name being watched is known to have to have a owner.
 *
 * Since: 2.26
 */


/**
 * GBusNameLostCallback:
 * @connection: The #GDBusConnection on which to acquire the name or %NULL if the connection was disconnected.
 * @name: The name being owned.
 * @user_data: User data passed to g_bus_own_name() or g_bus_own_name_on_connection().
 *
 * Invoked when the name is lost or @connection has been closed.
 *
 * Since: 2.26
 */


/**
 * GBusNameOwnerFlags:
 * @G_BUS_NAME_OWNER_FLAGS_NONE: No flags set.
 * @G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT: Allow another message bus connection to claim the the name.
 * @G_BUS_NAME_OWNER_FLAGS_REPLACE: If another message bus connection owns the name and have specified #G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT, then take the name from the other connection.
 *
 * Flags used in g_bus_own_name().
 *
 * Since: 2.26
 */


/**
 * GBusNameVanishedCallback:
 * @connection: The #GDBusConnection the name is being watched on.
 * @name: The name being watched.
 * @user_data: User data passed to g_bus_watch_name().
 *
 * Invoked when the name being watched is known not to have to have a owner.
 *
 * Since: 2.26
 */


/**
 * GBusNameWatcherFlags:
 * @G_BUS_NAME_WATCHER_FLAGS_NONE: No flags set.
 * @G_BUS_NAME_WATCHER_FLAGS_AUTO_START: If no-one owns the name when beginning to watch the name, ask the bus to launch an owner for the name.
 *
 * Flags used in g_bus_watch_name().
 *
 * Since: 2.26
 */


/**
 * GBusType:
 * @G_BUS_TYPE_STARTER: An alias for the message bus that activated the process, if any.
 * @G_BUS_TYPE_NONE: Not a message bus.
 * @G_BUS_TYPE_SYSTEM: The system-wide message bus.
 * @G_BUS_TYPE_SESSION: The login session message bus.
 *
 * An enumeration for well-known message buses.
 *
 * Since: 2.26
 */


/**
 * GCClosure:
 * @closure: the #GClosure
 * @callback: the callback function
 *
 * A #GCClosure is a specialization of #GClosure for C function callbacks.
 */


/**
 * GCallback:
 *
 * The type used for callback functions in structure definitions and function
 * signatures. This doesn't mean that all callback functions must take no
 * parameters and return void. The required signature of a callback function
 * is determined by the context in which is used (e.g. the signal to which it
 * is connected). Use G_CALLBACK() to cast the callback function to a #GCallback.
 */


/**
 * GCancellable:
 *
 * Allows actions to be cancelled.
 */


/**
 * GCancellable::cancelled:
 * @cancellable: a #GCancellable.
 *
 * Emitted when the operation has been cancelled.
 *
 * Can be used by implementations of cancellable operations. If the
 * operation is cancelled from another thread, the signal will be
 * emitted in the thread that cancelled the operation, not the
 * thread that is running the operation.
 *
 * Note that disconnecting from this signal (or any signal) in a
 * multi-threaded program is prone to race conditions. For instance
 * it is possible that a signal handler may be invoked even
 * <emphasis>after</emphasis> a call to
 * g_signal_handler_disconnect() for that handler has already
 * returned.
 *
 * There is also a problem when cancellation happen
 * right before connecting to the signal. If this happens the
 * signal will unexpectedly not be emitted, and checking before
 * connecting to the signal leaves a race condition where this is
 * still happening.
 *
 * In order to make it safe and easy to connect handlers there
 * are two helper functions: g_cancellable_connect() and
 * g_cancellable_disconnect() which protect against problems
 * like this.
 *
 * An example of how to us this:
 * |[
 * /<!-- -->* Make sure we don't do any unnecessary work if already cancelled *<!-- -->/
 * if (g_cancellable_set_error_if_cancelled (cancellable))
 * return;
 *
 * /<!-- -->* Set up all the data needed to be able to
 * * handle cancellation of the operation *<!-- -->/
 * my_data = my_data_new (...);
 *
 * id = 0;
 * if (cancellable)
 * id = g_cancellable_connect (cancellable,
 * G_CALLBACK (cancelled_handler)
 * data, NULL);
 *
 * /<!-- -->* cancellable operation here... *<!-- -->/
 *
 * g_cancellable_disconnect (cancellable, id);
 *
 * /<!-- -->* cancelled_handler is never called after this, it
 * * is now safe to free the data *<!-- -->/
 * my_data_free (my_data);
 * ]|
 *
 * Note that the cancelled signal is emitted in the thread that
 * the user cancelled from, which may be the main thread. So, the
 * cancellable signal should not do something that can block.
 */


/**
 * GCancellableSourceFunc:
 * @cancellable: the #GCancellable
 * @user_data: data passed in by the user.
 *
 * This is the function type of the callback used for the #GSource
 * returned by g_cancellable_source_new().
 *
 * Returns: it should return %FALSE if the source should be removed.
 * Since: 2.28
 */


/**
 * GCharsetConverter:
 *
 * Conversions between character sets.
 */


/**
 * GChecksum:
 *
 * An opaque structure representing a checksumming operation.
 * To create a new GChecksum, use g_checksum_new(). To free
 * a GChecksum, use g_checksum_free().
 *
 * Since: 2.16
 */


/**
 * GChecksumType:
 * @G_CHECKSUM_MD5: Use the MD5 hashing algorithm
 * @G_CHECKSUM_SHA1: Use the SHA-1 hashing algorithm
 * @G_CHECKSUM_SHA256: Use the SHA-256 hashing algorithm
 *
 * The hashing algorithm to be used by #GChecksum when performing the
 * digest of some data.
 *
 * Note that the #GChecksumType enumeration may be extended at a later
 * date to include new hashing algorithm types.
 *
 * Since: 2.16
 */


/**
 * GChildWatchFunc:
 * @pid: the process id of the child process
 * @status: Status information about the child process, see waitpid(2) for more information about this field
 * @user_data: user data passed to g_child_watch_add()
 *
 * The type of functions to be called when a child exists.
 */


/**
 * GClassFinalizeFunc:
 * @g_class: The #GTypeClass structure to finalize.
 * @class_data: The @class_data member supplied via the #GTypeInfo structure.
 *
 * A callback function used by the type system to finalize a class.
 * This function is rarely needed, as dynamically allocated class resources
 * should be handled by GBaseInitFunc() and GBaseFinalizeFunc().
 * Also, specification of a GClassFinalizeFunc() in the #GTypeInfo
 * structure of a static type is invalid, because classes of static types
 * will never be finalized (they are artificially kept alive when their
 * reference count drops to zero).
 */


/**
 * GClassInitFunc:
 * @g_class: The #GTypeClass structure to initialize.
 * @class_data: The @class_data member supplied via the #GTypeInfo structure.
 *
 * A callback function used by the type system to initialize the class
 * of a specific type. This function should initialize all static class
 * members.
 * The initialization process of a class involves:
 * <itemizedlist>
 * <listitem><para>
 * 1 - Copying common members from the parent class over to the
 * derived class structure.
 * </para></listitem>
 * <listitem><para>
 * 2 -  Zero initialization of the remaining members not copied
 * over from the parent class.
 * </para></listitem>
 * <listitem><para>
 * 3 - Invocation of the GBaseInitFunc() initializers of all parent
 * types and the class' type.
 * </para></listitem>
 * <listitem><para>
 * 4 - Invocation of the class' GClassInitFunc() initializer.
 * </para></listitem>
 * </itemizedlist>
 * Since derived classes are partially initialized through a memory copy
 * of the parent class, the general rule is that GBaseInitFunc() and
 * GBaseFinalizeFunc() should take care of necessary reinitialization
 * and release of those class members that were introduced by the type
 * that specified these GBaseInitFunc()/GBaseFinalizeFunc().
 * GClassInitFunc() should only care about initializing static
 * class members, while dynamic class members (such as allocated strings
 * or reference counted resources) are better handled by a GBaseInitFunc()
 * for this type, so proper initialization of the dynamic class members
 * is performed for class initialization of derived types as well.
 * An example may help to correspond the intend of the different class
 * initializers:
 *
 * |[
 * typedef struct {
 * GObjectClass parent_class;
 * gint         static_integer;
 * gchar       *dynamic_string;
 * } TypeAClass;
 * static void
 * type_a_base_class_init (TypeAClass *class)
 * {
 * class->dynamic_string = g_strdup ("some string");
 * }
 * static void
 * type_a_base_class_finalize (TypeAClass *class)
 * {
 * g_free (class->dynamic_string);
 * }
 * static void
 * type_a_class_init (TypeAClass *class)
 * {
 * class->static_integer = 42;
 * }
 *
 * typedef struct {
 * TypeAClass   parent_class;
 * gfloat       static_float;
 * GString     *dynamic_gstring;
 * } TypeBClass;
 * static void
 * type_b_base_class_init (TypeBClass *class)
 * {
 * class->dynamic_gstring = g_string_new ("some other string");
 * }
 * static void
 * type_b_base_class_finalize (TypeBClass *class)
 * {
 * g_string_free (class->dynamic_gstring);
 * }
 * static void
 * type_b_class_init (TypeBClass *class)
 * {
 * class->static_float = 3.14159265358979323846;
 * }
 * ]|
 * Initialization of TypeBClass will first cause initialization of
 * TypeAClass (derived classes reference their parent classes, see
 * g_type_class_ref() on this).
 * Initialization of TypeAClass roughly involves zero-initializing its fields,
 * then calling its GBaseInitFunc() type_a_base_class_init() to allocate
 * its dynamic members (dynamic_string), and finally calling its GClassInitFunc()
 * type_a_class_init() to initialize its static members (static_integer).
 * The first step in the initialization process of TypeBClass is then
 * a plain memory copy of the contents of TypeAClass into TypeBClass and
 * zero-initialization of the remaining fields in TypeBClass.
 * The dynamic members of TypeAClass within TypeBClass now need
 * reinitialization which is performed by calling type_a_base_class_init()
 * with an argument of TypeBClass.
 * After that, the GBaseInitFunc() of TypeBClass, type_b_base_class_init()
 * is called to allocate the dynamic members of TypeBClass (dynamic_gstring),
 * and finally the GClassInitFunc() of TypeBClass, type_b_class_init(),
 * is called to complete the initialization process with the static members
 * (static_float).
 * Corresponding finalization counter parts to the GBaseInitFunc() functions
 * have to be provided to release allocated resources at class finalization
 * time.
 */


/**
 * GClosure:
 * @in_marshal: Indicates whether the closure is currently being invoked with g_closure_invoke()
 * @is_invalid: Indicates whether the closure has been invalidated by g_closure_invalidate()
 *
 * A #GClosure represents a callback supplied by the programmer.
 */


/**
 * GClosureMarshal:
 * @closure: the #GClosure to which the marshaller belongs
 * @return_value: (allow-none): a #GValue to store the return value. May be %NULL if the callback of @closure doesn't return a value.
 * @n_param_values: the length of the @param_values array
 * @param_values: (array length=n_param_values): an array of #GValue<!-- -->s holding the arguments on which to invoke the callback of @closure
 * @invocation_hint: (allow-none): the invocation hint given as the last argument to g_closure_invoke()
 * @marshal_data: (allow-none): additional data specified when registering the marshaller, see g_closure_set_marshal() and g_closure_set_meta_marshal()
 *
 * The type used for marshaller functions.
 */


/**
 * GClosureNotify:
 * @data: data specified when registering the notification callback
 * @closure: the #GClosure on which the notification is emitted
 *
 * The type used for the various notification callbacks which can be registered
 * on closures.
 */


/**
 * GConnectFlags:
 * @G_CONNECT_AFTER: whether the handler should be called before or after the default handler of the signal.
 * @G_CONNECT_SWAPPED: whether the instance and data should be swapped when calling the handler.
 *
 * The connection flags are used to specify the behaviour of a signal's
 * connection.
 */


/**
 * GConvertError:
 * @G_CONVERT_ERROR_NO_CONVERSION: Conversion between the requested character sets is not supported.
 * @G_CONVERT_ERROR_ILLEGAL_SEQUENCE: Invalid byte sequence in conversion input.
 * @G_CONVERT_ERROR_FAILED: Conversion failed for some reason.
 * @G_CONVERT_ERROR_PARTIAL_INPUT: Partial character sequence at end of input.
 * @G_CONVERT_ERROR_BAD_URI: URI is invalid.
 * @G_CONVERT_ERROR_NOT_ABSOLUTE_PATH: Pathname is not an absolute path.
 *
 * Error codes returned by character set conversion routines.
 */


/**
 * GConverter:
 *
 * Seek object for streaming operations.
 *
 * Since: 2.24
 */


/**
 * GConverterFlags:
 * @G_CONVERTER_NO_FLAGS: No flags.
 * @G_CONVERTER_INPUT_AT_END: At end of input data
 * @G_CONVERTER_FLUSH: Flush data
 *
 * Flags used when calling a g_converter_convert().
 *
 * Since: 2.24
 */


/**
 * GConverterIface:
 * @g_iface: The parent interface.
 * @convert: Converts data.
 * @reset: Reverts the internal state of the converter to its initial state.
 *
 * Provides an interface for converting data from one type
 * to another type. The conversion can be stateful
 * and may fail at any place.
 *
 * Since: 2.24
 */


/**
 * GConverterInputStream:
 *
 * An implementation of #GFilterInputStream that allows data
 * conversion.
 */


/**
 * GConverterOutputStream:
 *
 * An implementation of #GFilterOutputStream that allows data
 * conversion.
 */


/**
 * GConverterResult:
 * @G_CONVERTER_ERROR: There was an error during conversion.
 * @G_CONVERTER_CONVERTED: Some data was consumed or produced
 * @G_CONVERTER_FINISHED: The conversion is finished
 * @G_CONVERTER_FLUSHED: Flushing is finished
 *
 * Results returned from g_converter_convert().
 *
 * Since: 2.24
 */


/**
 * GCopyFunc:
 * @src: A pointer to the data which should be copied
 * @data: Additional data
 *
 * A function of this signature is used to copy the node data
 * when doing a deep-copy of a tree.
 *
 * Returns: A pointer to the copy
 * Since: 2.4
 */


/**
 * GCredentials:
 *
 * The #GCredentials structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GCredentialsClass:
 *
 * Class structure for #GCredentials.
 *
 * Since: 2.26
 */


/**
 * GCredentialsType:
 * @G_CREDENTIALS_TYPE_INVALID: Indicates an invalid native credential type.
 * @G_CREDENTIALS_TYPE_LINUX_UCRED: The native credentials type is a <type>struct ucred</type>.
 * @G_CREDENTIALS_TYPE_FREEBSD_CMSGCRED: The native credentials type is a <type>struct cmsgcred</type>.
 * @G_CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED: The native credentials type is a <type>struct sockpeercred</type>. Added in 2.30.
 *
 * Enumeration describing different kinds of native credential types.
 *
 * Since: 2.26
 */


/**
 * GDBusAnnotationInfo:
 * @ref_count: The reference count or -1 if statically allocated.
 * @key: The name of the annotation, e.g. "org.freedesktop.DBus.Deprecated".
 * @value: The value of the annotation.
 * @annotations: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusAnnotationInfo structures or %NULL if there are no annotations.
 *
 * Information about an annotation.
 *
 * Since: 2.26
 */


/**
 * GDBusArgInfo:
 * @ref_count: The reference count or -1 if statically allocated.
 * @name: Name of the argument, e.g. @unix_user_id.
 * @signature: D-Bus signature of the argument (a single complete type).
 * @annotations: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusAnnotationInfo structures or %NULL if there are no annotations.
 *
 * Information about an argument for a method or a signal.
 *
 * Since: 2.26
 */


/**
 * GDBusAuthMechanism:credentials:
 *
 * If authenticating as a server, this property contains the
 * received credentials, if any.
 *
 * If authenticating as a client, the property contains the
 * credentials that were sent, if any.
 */


/**
 * GDBusAuthObserver:
 *
 * The #GDBusAuthObserver structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusAuthObserver::authorize-authenticated-peer:
 * @observer: The #GDBusAuthObserver emitting the signal.
 * @stream: A #GIOStream for the #GDBusConnection.
 * @credentials: Credentials received from the peer or %NULL.
 *
 * Emitted to check if a peer that is successfully authenticated
 * is authorized.
 *
 * Returns: %TRUE if the peer is authorized, %FALSE if not.
 * Since: 2.26
 */


/**
 * GDBusAuthObserverClass:
 * @authorize_authenticated_peer: Signal class handler for the #GDBusAuthObserver::authorize-authenticated-peer signal.
 *
 * Class structure for #GDBusAuthObserverClass.
 *
 * Since: 2.26
 */


/**
 * GDBusCallFlags:
 * @G_DBUS_CALL_FLAGS_NONE: No flags set.
 * @G_DBUS_CALL_FLAGS_NO_AUTO_START: The bus must not launch an owner for the destination name in response to this method invocation.
 *
 * Flags used in g_dbus_connection_call() and similar APIs.
 *
 * Since: 2.26
 */


/**
 * GDBusCapabilityFlags:
 * @G_DBUS_CAPABILITY_FLAGS_NONE: No flags set.
 * @G_DBUS_CAPABILITY_FLAGS_UNIX_FD_PASSING: The connection supports exchanging UNIX file descriptors with the remote peer.
 *
 * Capabilities negotiated with the remote peer.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:
 *
 * The #GDBusConnection structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection::closed:
 * @connection: The #GDBusConnection emitting the signal.
 * @remote_peer_vanished: %TRUE if @connection is closed because the remote peer closed its end of the connection.
 * @error: A #GError with more details about the event or %NULL.
 *
 * Emitted when the connection is closed.
 *
 * The cause of this event can be
 * <itemizedlist>
 * <listitem><para>
 * If g_dbus_connection_close() is called. In this case
 * @remote_peer_vanished is set to %FALSE and @error is %NULL.
 * </para></listitem>
 * <listitem><para>
 * If the remote peer closes the connection. In this case
 * @remote_peer_vanished is set to %TRUE and @error is set.
 * </para></listitem>
 * <listitem><para>
 * If the remote peer sends invalid or malformed data. In this
 * case @remote_peer_vanished is set to %FALSE and @error
 * is set.
 * </para></listitem>
 * </itemizedlist>
 *
 * Upon receiving this signal, you should give up your reference to
 * @connection. You are guaranteed that this signal is emitted only
 * once.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:address:
 *
 * A D-Bus address specifying potential endpoints that can be used
 * when establishing the connection.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:authentication-observer:
 *
 * A #GDBusAuthObserver object to assist in the authentication process or %NULL.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:capabilities:
 *
 * Flags from the #GDBusCapabilityFlags enumeration
 * representing connection features negotiated with the other peer.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:closed:
 *
 * A boolean specifying whether the connection has been closed.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:exit-on-close:
 *
 * A boolean specifying whether the process will be terminated (by
 * calling <literal>raise(SIGTERM)</literal>) if the connection
 * is closed by the remote peer.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:flags:
 *
 * Flags from the #GDBusConnectionFlags enumeration.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:guid:
 *
 * The GUID of the peer performing the role of server when
 * authenticating.
 *
 * If you are constructing a #GDBusConnection and pass
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER in the
 * #GDBusConnection:flags property then you MUST also set this
 * property to a valid guid.
 *
 * If you are constructing a #GDBusConnection and pass
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT in the
 * #GDBusConnection:flags property you will be able to read the GUID
 * of the other peer here after the connection has been successfully
 * initialized.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:locked:
 *
 * A boolean specifying whether the message is locked.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:stream:
 *
 * The underlying #GIOStream used for I/O.
 *
 * If this is passed on construction and is a #GSocketConnection,
 * then the corresponding #GSocket will be put into non-blocking mode.
 *
 * While the #GDBusConnection is active, it will interact with this
 * stream from a worker thread, so it is not safe to interact with
 * the stream directly.
 *
 * Since: 2.26
 */


/**
 * GDBusConnection:unique-name:
 *
 * The unique name as assigned by the message bus or %NULL if the
 * connection is not open or not a message bus connection.
 *
 * Since: 2.26
 */


/**
 * GDBusConnectionClass:
 * @closed: Signal class handler for the #GDBusConnection::closed signal.
 *
 * Class structure for #GDBusConnection.
 *
 * Since: 2.26
 */


/**
 * GDBusConnectionFlags:
 * @G_DBUS_CONNECTION_FLAGS_NONE: No flags set.
 * @G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT: Perform authentication against server.
 * @G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER: Perform authentication against client.
 * @G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS: When authenticating as a server, allow the anonymous authentication method.
 * @G_DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION: Pass this flag if connecting to a peer that is a message bus. This means that the Hello() method will be invoked as part of the connection setup.
 * @G_DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING: If set, processing of D-Bus messages is delayed until g_dbus_connection_start_message_processing() is called.
 *
 * Flags used when creating a new #GDBusConnection.
 *
 * Since: 2.26
 */


/**
 * GDBusError:
 *
 * Certain timeout errors, e.g. while starting a service. Warning: this is
 * Error codes for the %G_DBUS_ERROR error domain.
 *
 * Since: 2.26
 */


/**
 * GDBusErrorEntry:
 * @error_code: An error code.
 * @dbus_error_name: The D-Bus error name to associate with @error_code.
 *
 * Struct used in g_dbus_error_register_error_domain().
 *
 * Since: 2.26
 */


/**
 * GDBusInterface:
 *
 * Base type for D-Bus interfaces.
 *
 * Since: 2.30
 */


/**
 * GDBusInterfaceGetPropertyFunc:
 * @connection: A #GDBusConnection.
 * @sender: The unique bus name of the remote caller.
 * @object_path: The object path that the method was invoked on.
 * @interface_name: The D-Bus interface name for the property.
 * @property_name: The name of the property to get the value of.
 * @error: Return location for error.
 * @user_data: The @user_data #gpointer passed to g_dbus_connection_register_object().
 *
 * The type of the @get_property function in #GDBusInterfaceVTable.
 *
 * @error is set. If the returned #GVariant is floating, it is
 * consumed - otherwise its reference count is decreased by one.
 *
 * Returns: A #GVariant with the value for @property_name or %NULL if
 * Since: 2.26
 */


/**
 * GDBusInterfaceIface:
 * @parent_iface: The parent interface.
 * @get_info: Returns a #GDBusInterfaceInfo. See g_dbus_interface_get_info().
 * @get_object: Gets the enclosing #GDBusObject. See g_dbus_interface_get_object().
 * @set_object: Sets the enclosing #GDBusObject. See g_dbus_interface_set_object().
 *
 * Base type for D-Bus interfaces.
 *
 * Since: 2.30
 */


/**
 * GDBusInterfaceInfo:
 * @ref_count: The reference count or -1 if statically allocated.
 * @name: The name of the D-Bus interface, e.g. "org.freedesktop.DBus.Properties".
 * @methods: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusMethodInfo structures or %NULL if there are no methods.
 * @signals: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusSignalInfo structures or %NULL if there are no signals.
 * @properties: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusPropertyInfo structures or %NULL if there are no properties.
 * @annotations: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusAnnotationInfo structures or %NULL if there are no annotations.
 *
 * Information about a D-Bus interface.
 *
 * Since: 2.26
 */


/**
 * GDBusInterfaceMethodCallFunc:
 * @connection: A #GDBusConnection.
 * @sender: The unique bus name of the remote caller.
 * @object_path: The object path that the method was invoked on.
 * @interface_name: The D-Bus interface name the method was invoked on.
 * @method_name: The name of the method that was invoked.
 * @parameters: A #GVariant tuple with parameters.
 * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
 * @user_data: The @user_data #gpointer passed to g_dbus_connection_register_object().
 *
 * The type of the @method_call function in #GDBusInterfaceVTable.
 *
 * Since: 2.26
 */


/**
 * GDBusInterfaceSetPropertyFunc:
 * @connection: A #GDBusConnection.
 * @sender: The unique bus name of the remote caller.
 * @object_path: The object path that the method was invoked on.
 * @interface_name: The D-Bus interface name for the property.
 * @property_name: The name of the property to get the value of.
 * @value: The value to set the property to.
 * @error: Return location for error.
 * @user_data: The @user_data #gpointer passed to g_dbus_connection_register_object().
 *
 * The type of the @set_property function in #GDBusInterfaceVTable.
 *
 * Returns: %TRUE if the property was set to @value, %FALSE if @error is set.
 * Since: 2.26
 */


/**
 * GDBusInterfaceSkeleton:
 *
 * The #GDBusInterfaceSkeleton structure contains private data and should
 * only be accessed using the provided API.
 *
 * Since: 2.30
 */


/**
 * GDBusInterfaceSkeleton::g-authorize-method:
 * @interface: The #GDBusInterfaceSkeleton emitting the signal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Emitted when a method is invoked by a remote caller and used to
 * determine if the method call is authorized.
 *
 * Note that this signal is emitted in a thread dedicated to
 * handling the method call so handlers are allowed to perform
 * blocking IO. This means that it is appropriate to call
 * e.g. <ulink
 * url="http://hal.freedesktop.org/docs/polkit/PolkitAuthority.html#polkit-authority-check-authorization-sync">polkit_authority_check_authorization_sync()</ulink>
 * with the <ulink
 * url="http://hal.freedesktop.org/docs/polkit/PolkitAuthority.html#POLKIT-CHECK-AUTHORIZATION-FLAGS-ALLOW-USER-INTERACTION:CAPS">POLKIT_CHECK_AUTHORIZATION_FLAGS_ALLOW_USER_INTERACTION</ulink> flag set.
 *
 * If %FALSE is returned then no further handlers are run and the
 * signal handler must take a reference to @invocation and finish
 * handling the call (e.g. return an error via
 * g_dbus_method_invocation_return_error()).
 *
 * Otherwise, if %TRUE is returned, signal emission continues. If no
 * handlers return %FALSE, then the method is dispatched. If
 * @interface has an enclosing #GDBusObjectSkeleton, then the
 * #GDBusObjectSkeleton::authorize-method signal handlers run before
 * the handlers for this signal.
 *
 * The default class handler just returns %TRUE.
 *
 * Please note that the common case is optimized: if no signals
 * handlers are connected and the default class handler isn't
 * overridden (for both @interface and the enclosing
 * #GDBusObjectSkeleton, if any) and #GDBusInterfaceSkeleton:g-flags does
 * not have the
 * %G_DBUS_INTERFACE_SKELETON_FLAGS_HANDLE_METHOD_INVOCATIONS_IN_THREAD
 * flags set, no dedicated thread is ever used and the call will be
 * handled in the same thread as the object that @interface belongs
 * to was exported in.
 *
 * Returns: %TRUE if the call is authorized, %FALSE otherwise.
 * Since: 2.30
 */


/**
 * GDBusInterfaceSkeleton:g-flags:
 *
 * Flags from the #GDBusInterfaceSkeletonFlags enumeration.
 *
 * Since: 2.30
 */


/**
 * GDBusInterfaceSkeletonClass:
 * @parent_class: The parent class.
 * @get_info: Returns a #GDBusInterfaceInfo. See g_dbus_interface_skeleton_get_info() for details.
 * @get_vtable: Returns a #GDBusInterfaceVTable. See g_dbus_interface_skeleton_get_vtable() for details.
 * @get_properties: Returns a #GVariant with all properties. See g_dbus_interface_skeleton_get_properties().
 * @flush: Emits outstanding changes, if any. See g_dbus_interface_skeleton_flush().
 * @g_authorize_method: Signal class handler for the #GDBusInterfaceSkeleton::g-authorize-method signal.
 *
 * Class structure for #GDBusInterfaceSkeleton.
 *
 * Since: 2.30
 */


/**
 * GDBusInterfaceSkeletonFlags:
 * @G_DBUS_INTERFACE_SKELETON_FLAGS_NONE: No flags set.
 * @G_DBUS_INTERFACE_SKELETON_FLAGS_HANDLE_METHOD_INVOCATIONS_IN_THREAD: Each method invocation is handled in a thread dedicated to the invocation. This means that the method implementation can use blocking IO without blocking any other part of the process. It also means that the method implementation must use locking to access data structures used by other threads.
 *
 * Flags describing the behavior of a #GDBusInterfaceSkeleton instance.
 *
 * Since: 2.30
 */


/**
 * GDBusInterfaceVTable:
 * @method_call: Function for handling incoming method calls.
 * @get_property: Function for getting a property.
 * @set_property: Function for setting a property.
 *
 * Virtual table for handling properties and method calls for a D-Bus
 * interface.
 *
 * If you want to handle getting/setting D-Bus properties asynchronously, simply
 * register an object with the <literal>org.freedesktop.DBus.Properties</literal>
 * D-Bus interface using g_dbus_connection_register_object().
 *
 * Since: 2.26
 */


/**
 * GDBusMessage:
 *
 * The #GDBusMessage structure contains only private data and should
 * only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusMessageByteOrder:
 * @G_DBUS_MESSAGE_BYTE_ORDER_BIG_ENDIAN: The byte order is big endian.
 * @G_DBUS_MESSAGE_BYTE_ORDER_LITTLE_ENDIAN: The byte order is little endian.
 *
 * Enumeration used to describe the byte order of a D-Bus message.
 *
 * Since: 2.26
 */


/**
 * GDBusMessageClass:
 *
 * Class structure for #GDBusMessage.
 *
 * Since: 2.26
 */


/**
 * GDBusMessageFilterFunction:
 * @connection: (transfer none): A #GDBusConnection.
 * @message: (transfer full): A locked #GDBusMessage that the filter function takes ownership of.
 * @incoming: %TRUE if it is a message received from the other peer, %FALSE if it is a message to be sent to the other peer.
 * @user_data: User data passed when adding the filter.
 *
 * Signature for function used in g_dbus_connection_add_filter().
 *
 * A filter function is passed a #GDBusMessage and expected to return
 * a #GDBusMessage too. Passive filter functions that don't modify the
 * message can simply return the @message object:
 * |[
 * static GDBusMessage *
 * passive_filter (GDBusConnection *connection
 * GDBusMessage    *message,
 * gboolean         incoming,
 * gpointer         user_data)
 * {
 * /<!-- -->* inspect @message *<!-- -->/
 * return message;
 * }
 * ]|
 * Filter functions that wants to drop a message can simply return %NULL:
 * |[
 * static GDBusMessage *
 * drop_filter (GDBusConnection *connection
 * GDBusMessage    *message,
 * gboolean         incoming,
 * gpointer         user_data)
 * {
 * if (should_drop_message)
 * {
 * g_object_unref (message);
 * message = NULL;
 * }
 * return message;
 * }
 * ]|
 * Finally, a filter function may modify a message by copying it:
 * |[
 * static GDBusMessage *
 * modifying_filter (GDBusConnection *connection
 * GDBusMessage    *message,
 * gboolean         incoming,
 * gpointer         user_data)
 * {
 * GDBusMessage *copy;
 * GError *error;
 *
 * error = NULL;
 * copy = g_dbus_message_copy (message, &error);
 * /<!-- -->* handle @error being is set *<!-- -->/
 * g_object_unref (message);
 *
 * /<!-- -->* modify @copy *<!-- -->/
 *
 * return copy;
 * }
 * ]|
 * If the returned #GDBusMessage is different from @message and cannot
 * be sent on @connection (it could use features, such as file
 * descriptors, not compatible with @connection), then a warning is
 * logged to <emphasis>standard error</emphasis>. Applications can
 * check this ahead of time using g_dbus_message_to_blob() passing a
 * #GDBusCapabilityFlags value obtained from @connection.
 *
 * g_object_unref() or %NULL to drop the message. Passive filter
 * functions can simply return the passed @message object.
 *
 * Returns: (transfer full) (allow-none): A #GDBusMessage that will be freed with
 * Since: 2.26
 */


/**
 * GDBusMessageFlags:
 * @G_DBUS_MESSAGE_FLAGS_NONE: No flags set.
 * @G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED: A reply is not expected.
 * @G_DBUS_MESSAGE_FLAGS_NO_AUTO_START: The bus must not launch an owner for the destination name in response to this message.
 *
 * Message flags used in #GDBusMessage.
 *
 * Since: 2.26
 */


/**
 * GDBusMessageHeaderField:
 * @G_DBUS_MESSAGE_HEADER_FIELD_INVALID: Not a valid header field.
 * @G_DBUS_MESSAGE_HEADER_FIELD_PATH: The object path.
 * @G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE: The interface name.
 * @G_DBUS_MESSAGE_HEADER_FIELD_MEMBER: The method or signal name.
 * @G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME: The name of the error that occurred.
 * @G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL: The serial number the message is a reply to.
 * @G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION: The name the message is intended for.
 * @G_DBUS_MESSAGE_HEADER_FIELD_SENDER: Unique name of the sender of the message (filled in by the bus).
 * @G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE: The signature of the message body.
 * @G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS: The number of UNIX file descriptors that accompany the message.
 *
 * Header fields used in #GDBusMessage.
 *
 * Since: 2.26
 */


/**
 * GDBusMessageType:
 * @G_DBUS_MESSAGE_TYPE_INVALID: Message is of invalid type.
 * @G_DBUS_MESSAGE_TYPE_METHOD_CALL: Method call.
 * @G_DBUS_MESSAGE_TYPE_METHOD_RETURN: Method reply.
 * @G_DBUS_MESSAGE_TYPE_ERROR: Error reply.
 * @G_DBUS_MESSAGE_TYPE_SIGNAL: Signal emission.
 *
 * Message types used in #GDBusMessage.
 *
 * Since: 2.26
 */


/**
 * GDBusMethodInfo:
 * @ref_count: The reference count or -1 if statically allocated.
 * @name: The name of the D-Bus method, e.g. @RequestName.
 * @in_args: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusArgInfo structures or %NULL if there are no in arguments.
 * @out_args: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusArgInfo structures or %NULL if there are no out arguments.
 * @annotations: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusAnnotationInfo structures or %NULL if there are no annotations.
 *
 * Information about a method on an D-Bus interface.
 *
 * Since: 2.26
 */


/**
 * GDBusMethodInvocation:
 *
 * The #GDBusMethodInvocation structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusMethodInvocationClass:
 *
 * Class structure for #GDBusMethodInvocation.
 *
 * Since: 2.26
 */


/**
 * GDBusNodeInfo:
 * @ref_count: The reference count or -1 if statically allocated.
 * @path: The path of the node or %NULL if omitted. Note that this may be a relative path. See the D-Bus specification for more details.
 * @interfaces: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusInterfaceInfo structures or %NULL if there are no interfaces.
 * @nodes: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusNodeInfo structures or %NULL if there are no nodes.
 * @annotations: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusAnnotationInfo structures or %NULL if there are no annotations.
 *
 * Information about nodes in a remote object hierarchy.
 *
 * Since: 2.26
 */


/**
 * GDBusObject::interface-added:
 * @object: The #GDBusObject emitting the signal.
 * @interface: The #GDBusInterface that was added.
 *
 * Emitted when @interface is added to @object.
 *
 * Since: 2.30
 */


/**
 * GDBusObject::interface-removed:
 * @object: The #GDBusObject emitting the signal.
 * @interface: The #GDBusInterface that was removed.
 *
 * Emitted when @interface is removed from @object.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectIface:
 * @parent_iface: The parent interface.
 * @get_object_path: Returns the object path. See g_dbus_object_get_object_path().
 * @get_interfaces: Returns all interfaces. See g_dbus_object_get_interfaces().
 * @get_interface: Returns an interface by name. See g_dbus_object_get_interface().
 * @interface_added: Signal handler for the #GDBusObject::interface-added signal.
 * @interface_removed: Signal handler for the #GDBusObject::interface-removed signal.
 *
 * Base object type for D-Bus objects.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManager::interface-added:
 * @manager: The #GDBusObjectManager emitting the signal.
 * @object: The #GDBusObject on which an interface was added.
 * @interface: The #GDBusInterface that was added.
 *
 * Emitted when @interface is added to @object.
 *
 * This signal exists purely as a convenience to avoid having to
 * connect signals to all objects managed by @manager.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManager::interface-removed:
 * @manager: The #GDBusObjectManager emitting the signal.
 * @object: The #GDBusObject on which an interface was removed.
 * @interface: The #GDBusInterface that was removed.
 *
 * Emitted when @interface has been removed from @object.
 *
 * This signal exists purely as a convenience to avoid having to
 * connect signals to all objects managed by @manager.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManager::object-added:
 * @manager: The #GDBusObjectManager emitting the signal.
 * @object: The #GDBusObject that was added.
 *
 * Emitted when @object is added to @manager.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManager::object-removed:
 * @manager: The #GDBusObjectManager emitting the signal.
 * @object: The #GDBusObject that was removed.
 *
 * Emitted when @object is removed from @manager.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:
 *
 * The #GDBusObjectManagerClient structure contains private data and should
 * only be accessed using the provided API.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient::interface-proxy-properties-changed:
 * @manager: The #GDBusObjectManagerClient emitting the signal.
 * @object_proxy: The #GDBusObjectProxy on which an interface has properties that are changing.
 * @interface_proxy: The #GDBusProxy that has properties that are changing.
 * @changed_properties: A #GVariant containing the properties that changed.
 * @invalidated_properties: A %NULL terminated array of properties that was invalidated.
 *
 * Emitted when one or more D-Bus properties on proxy changes. The
 * local cache has already been updated when this signal fires. Note
 * that both @changed_properties and @invalidated_properties are
 * guaranteed to never be %NULL (either may be empty though).
 *
 * This signal exists purely as a convenience to avoid having to
 * connect signals to all interface proxies managed by @manager.
 *
 * This signal is emitted in the
 * <link linkend="g-main-context-push-thread-default">thread-default main loop</link>
 * that @manager was constructed in.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient::interface-proxy-signal:
 * @manager: The #GDBusObjectManagerClient emitting the signal.
 * @object_proxy: The #GDBusObjectProxy on which an interface is emitting a D-Bus signal.
 * @interface_proxy: The #GDBusProxy that is emitting a D-Bus signal.
 * @sender_name: The sender of the signal or NULL if the connection is not a bus connection.
 * @signal_name: The signal name.
 * @parameters: A #GVariant tuple with parameters for the signal.
 *
 * Emitted when a D-Bus signal is received on @interface_proxy.
 *
 * This signal exists purely as a convenience to avoid having to
 * connect signals to all interface proxies managed by @manager.
 *
 * This signal is emitted in the
 * <link linkend="g-main-context-push-thread-default">thread-default main loop</link>
 * that @manager was constructed in.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:bus-type:
 *
 * If this property is not %G_BUS_TYPE_NONE, then
 * #GDBusObjectManagerClient:connection must be %NULL and will be set to the
 * #GDBusConnection obtained by calling g_bus_get() with the value
 * of this property.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:connection:
 *
 * The #GDBusConnection to use.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:flags:
 *
 * Flags from the #GDBusObjectManagerClientFlags enumeration.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:get-proxy-type-destroy-notify:
 *
 * A #GDestroyNotify for the #gpointer user_data in #GDBusObjectManagerClient:get-proxy-type-user-data.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:get-proxy-type-func:
 *
 * The #GDBusProxyTypeFunc to use when determining what #GType to
 * use for interface proxies or %NULL.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:get-proxy-type-user-data:
 *
 * The #gpointer user_data to pass to #GDBusObjectManagerClient:get-proxy-type-func.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:name:
 *
 * The well-known name or unique name that the manager is for.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:name-owner:
 *
 * The unique name that owns #GDBusObjectManagerClient:name or %NULL if
 * no-one is currently owning the name. Connect to the
 * #GObject::notify signal to track changes to this property.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClient:object-path:
 *
 * The object path the manager is for.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClientClass:
 * @parent_class: The parent class.
 * @interface_proxy_signal: Signal class handler for the #GDBusObjectManagerClient::interface-proxy-signal signal.
 * @interface_proxy_properties_changed: Signal class handler for the #GDBusObjectManagerClient::interface-proxy-properties-changed signal.
 *
 * Class structure for #GDBusObjectManagerClient.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerClientFlags:
 * @G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE: No flags set.
 * @G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_DO_NOT_AUTO_START: If not set and the manager is for a well-known name, then request the bus to launch an owner for the name if no-one owns the name. This flag can only be used in managers for well-known names.
 *
 * Flags used when constructing a #GDBusObjectManagerClient.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerIface:
 * @parent_iface: The parent interface.
 * @get_object_path: Virtual function for g_dbus_object_manager_get_object_path().
 * @get_objects: Virtual function for g_dbus_object_manager_get_objects().
 * @get_object: Virtual function for g_dbus_object_manager_get_object().
 * @get_interface: Virtual function for g_dbus_object_manager_get_interface().
 * @object_added: Signal handler for the #GDBusObjectManager::object-added signal.
 * @object_removed: Signal handler for the #GDBusObjectManager::object-removed signal.
 * @interface_added: Signal handler for the #GDBusObjectManager::interface-added signal.
 * @interface_removed: Signal handler for the #GDBusObjectManager::interface-removed signal.
 *
 * Base type for D-Bus object managers.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerServer:
 *
 * The #GDBusObjectManagerServer structure contains private data and should
 * only be accessed using the provided API.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerServer:connection:
 *
 * The #GDBusConnection to export objects on.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerServer:object-path:
 *
 * The object path to register the manager object at.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectManagerServerClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GDBusObjectManagerServer.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectProxy:
 *
 * The #GDBusObjectProxy structure contains private data and should
 * only be accessed using the provided API.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectProxy:g-connection:
 *
 * The connection of the proxy.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectProxy:g-object-path:
 *
 * The object path of the proxy.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GDBusObjectProxy.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectSkeleton:
 *
 * The #GDBusObjectSkeleton structure contains private data and should only be
 * accessed using the provided API.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectSkeleton::authorize-method:
 * @object: The #GDBusObjectSkeleton emitting the signal.
 * @interface: The #GDBusInterfaceSkeleton that @invocation is for.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Emitted when a method is invoked by a remote caller and used to
 * determine if the method call is authorized.
 *
 * This signal is like #GDBusInterfaceSkeleton<!-- -->'s
 * #GDBusInterfaceSkeleton::g-authorize-method signal, except that it is
 * for the enclosing object.
 *
 * The default class handler just returns %TRUE.
 *
 * Returns: %TRUE if the call is authorized, %FALSE otherwise.
 * Since: 2.30
 */


/**
 * GDBusObjectSkeleton:g-object-path:
 *
 * The object path where the object is exported.
 *
 * Since: 2.30
 */


/**
 * GDBusObjectSkeletonClass:
 * @parent_class: The parent class.
 * @authorize_method: Signal class handler for the #GDBusObjectSkeleton::authorize-method signal.
 *
 * Class structure for #GDBusObjectSkeleton.
 *
 * Since: 2.30
 */


/**
 * GDBusPropertyInfo:
 * @ref_count: The reference count or -1 if statically allocated.
 * @name: The name of the D-Bus property, e.g. "SupportedFilesystems".
 * @signature: The D-Bus signature of the property (a single complete type).
 * @flags: Access control flags for the property.
 * @annotations: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusAnnotationInfo structures or %NULL if there are no annotations.
 *
 * Information about a D-Bus property on a D-Bus interface.
 *
 * Since: 2.26
 */


/**
 * GDBusPropertyInfoFlags:
 * @G_DBUS_PROPERTY_INFO_FLAGS_NONE: No flags set.
 * @G_DBUS_PROPERTY_INFO_FLAGS_READABLE: Property is readable.
 * @G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE: Property is writable.
 *
 * Flags describing the access control of a D-Bus property.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:
 *
 * The #GDBusProxy structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy::g-properties-changed:
 * @proxy: The #GDBusProxy emitting the signal.
 * @changed_properties: A #GVariant containing the properties that changed
 * @invalidated_properties: A %NULL terminated array of properties that was invalidated
 *
 * Emitted when one or more D-Bus properties on @proxy changes. The
 * local cache has already been updated when this signal fires. Note
 * that both @changed_properties and @invalidated_properties are
 * guaranteed to never be %NULL (either may be empty though).
 *
 * This signal corresponds to the
 * <literal>PropertiesChanged</literal> D-Bus signal on the
 * <literal>org.freedesktop.DBus.Properties</literal> interface.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy::g-signal:
 * @proxy: The #GDBusProxy emitting the signal.
 * @sender_name: The sender of the signal or %NULL if the connection is not a bus connection.
 * @signal_name: The name of the signal.
 * @parameters: A #GVariant tuple with parameters for the signal.
 *
 * Emitted when a signal from the remote object and interface that @proxy is for, has been received.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-bus-type:
 *
 * If this property is not %G_BUS_TYPE_NONE, then
 * #GDBusProxy:g-connection must be %NULL and will be set to the
 * #GDBusConnection obtained by calling g_bus_get() with the value
 * of this property.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-connection:
 *
 * The #GDBusConnection the proxy is for.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-default-timeout:
 *
 * The timeout to use if -1 (specifying default timeout) is passed
 * as @timeout_msec in the g_dbus_proxy_call() and
 * g_dbus_proxy_call_sync() functions.
 *
 * This allows applications to set a proxy-wide timeout for all
 * remote method invocations on the proxy. If this property is -1,
 * the default timeout (typically 25 seconds) is used. If set to
 * %G_MAXINT, then no timeout is used.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-flags:
 *
 * Flags from the #GDBusProxyFlags enumeration.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-interface-info:
 *
 * Ensure that interactions with this proxy conform to the given
 * interface. This is mainly to ensure that malformed data received
 * from the other peer is ignored. The given #GDBusInterfaceInfo is
 * said to be the <emphasis>expected interface</emphasis>.
 *
 * The checks performed are:
 * <itemizedlist>
 * <listitem><para>
 * When completing a method call, if the type signature of
 * the reply message isn't what's expected, the reply is
 * discarded and the #GError is set to %G_IO_ERROR_INVALID_ARGUMENT.
 * </para></listitem>
 * <listitem><para>
 * Received signals that have a type signature mismatch are dropped and
 * a warning is logged via g_warning().
 * </para></listitem>
 * <listitem><para>
 * Properties received via the initial <literal>GetAll()</literal> call
 * or via the <literal>::PropertiesChanged</literal> signal (on the
 * <ulink url="http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-properties">org.freedesktop.DBus.Properties</ulink> interface) or
 * set using g_dbus_proxy_set_cached_property() with a type signature
 * mismatch are ignored and a warning is logged via g_warning().
 * </para></listitem>
 * </itemizedlist>
 * Note that these checks are never done on methods, signals and
 * properties that are not referenced in the given
 * #GDBusInterfaceInfo, since extending a D-Bus interface on the
 * service-side is not considered an ABI break.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-interface-name:
 *
 * The D-Bus interface name the proxy is for.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-name:
 *
 * The well-known or unique name that the proxy is for.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-name-owner:
 *
 * The unique name that owns #GDBusProxy:name or %NULL if no-one
 * currently owns that name. You may connect to #GObject::notify signal to
 * track changes to this property.
 *
 * Since: 2.26
 */


/**
 * GDBusProxy:g-object-path:
 *
 * The object path the proxy is for.
 *
 * Since: 2.26
 */


/**
 * GDBusProxyClass:
 * @g_properties_changed: Signal class handler for the #GDBusProxy::g-properties-changed signal.
 * @g_signal: Signal class handler for the #GDBusProxy::g-signal signal.
 *
 * Class structure for #GDBusProxy.
 *
 * Since: 2.26
 */


/**
 * GDBusProxyFlags:
 * @G_DBUS_PROXY_FLAGS_NONE: No flags set.
 * @G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES: Don't load properties.
 * @G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS: Don't connect to signals on the remote object.
 * @G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START: If not set and the proxy if for a well-known name, then request the bus to launch an owner for the name if no-one owns the name. This flag can only be used in proxies for well-known names.
 *
 * Flags used when constructing an instance of a #GDBusProxy derived class.
 *
 * Since: 2.26
 */


/**
 * GDBusProxyTypeFunc:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object.
 * @interface_name: (allow-none): The interface name of the remote object or %NULL if a #GDBusObjectProxy #GType is requested.
 * @user_data: User data.
 *
 * Function signature for a function used to determine the #GType to
 * use for an interface proxy (if @interface_name is not %NULL) or
 * object proxy (if @interface_name is %NULL).
 *
 * This function is called in the
 * <link linkend="g-main-context-push-thread-default">thread-default main loop</link>
 * that @manager was constructed in.
 *
 * must be a #GDBusProxy<!-- -->- or #GDBusObjectProxy<!-- -->-derived
 * type.
 *
 * Returns: A #GType to use for the remote object. The returned type
 * Since: 2.30
 */


/**
 * GDBusSendMessageFlags:
 * @G_DBUS_SEND_MESSAGE_FLAGS_NONE: No flags set.
 * @G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL: Do not automatically assign a serial number from the #GDBusConnection object when sending a message.
 *
 * Flags used when sending #GDBusMessage<!-- -->s on a #GDBusConnection.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:
 *
 * The #GDBusServer structure contains only private data and
 * should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GDBusServer::new-connection:
 * @server: The #GDBusServer emitting the signal.
 * @connection: A #GDBusConnection for the new connection.
 *
 * Emitted when a new authenticated connection has been made. Use
 * g_dbus_connection_get_peer_credentials() to figure out what
 * identity (if any), was authenticated.
 *
 * If you want to accept the connection, take a reference to the
 * @connection object and return %TRUE. When you are done with the
 * connection call g_dbus_connection_close() and give up your
 * reference. Note that the other peer may disconnect at any time -
 * a typical thing to do when accepting a connection is to listen to
 * the #GDBusConnection::closed signal.
 *
 * If #GDBusServer:flags contains %G_DBUS_SERVER_FLAGS_RUN_IN_THREAD
 * then the signal is emitted in a new thread dedicated to the
 * connection. Otherwise the signal is emitted in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * loop</link> of the thread that @server was constructed in.
 *
 * You are guaranteed that signal handlers for this signal runs
 * before incoming messages on @connection are processed. This means
 * that it's suitable to call g_dbus_connection_register_object() or
 * similar from the signal handler.
 *
 * run.
 *
 * Returns: %TRUE to claim @connection, %FALSE to let other handlers
 * Since: 2.26
 */


/**
 * GDBusServer:active:
 *
 * Whether the server is currently active.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:address:
 *
 * The D-Bus address to listen on.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:authentication-observer:
 *
 * A #GDBusAuthObserver object to assist in the authentication process or %NULL.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:client-address:
 *
 * The D-Bus address that clients can use.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:flags:
 *
 * Flags from the #GDBusServerFlags enumeration.
 *
 * Since: 2.26
 */


/**
 * GDBusServer:guid:
 *
 * The guid of the server.
 *
 * Since: 2.26
 */


/**
 * GDBusServerClass:
 * @new_connection: Signal class handler for the #GDBusServer::new-connection signal.
 *
 * Class structure for #GDBusServer.
 *
 * Since: 2.26
 */


/**
 * GDBusServerFlags:
 * @G_DBUS_SERVER_FLAGS_NONE: No flags set.
 * @G_DBUS_SERVER_FLAGS_RUN_IN_THREAD: All #GDBusServer::new-connection signals will run in separated dedicated threads (see signal for details).
 * @G_DBUS_SERVER_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS: Allow the anonymous authentication method.
 *
 * Flags used when creating a #GDBusServer.
 *
 * Since: 2.26
 */


/**
 * GDBusSignalCallback:
 * @connection: A #GDBusConnection.
 * @sender_name: The unique bus name of the sender of the signal.
 * @object_path: The object path that the signal was emitted on.
 * @interface_name: The name of the interface.
 * @signal_name: The name of the signal.
 * @parameters: A #GVariant tuple with parameters for the signal.
 * @user_data: User data passed when subscribing to the signal.
 *
 * Signature for callback function used in g_dbus_connection_signal_subscribe().
 *
 * Since: 2.26
 */


/**
 * GDBusSignalFlags:
 * @G_DBUS_SIGNAL_FLAGS_NONE: No flags set.
 * @G_DBUS_SIGNAL_FLAGS_NO_MATCH_RULE: Don't actually send the AddMatch D-Bus call for this signal subscription.  This gives you more control over which match rules you add (but you must add them manually).
 *
 * Flags used when subscribing to signals via g_dbus_connection_signal_subscribe().
 *
 * Since: 2.26
 */


/**
 * GDBusSignalInfo:
 * @ref_count: The reference count or -1 if statically allocated.
 * @name: The name of the D-Bus signal, e.g. "NameOwnerChanged".
 * @args: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusArgInfo structures or %NULL if there are no arguments.
 * @annotations: (array zero-terminated=1): A pointer to a %NULL-terminated array of pointers to #GDBusAnnotationInfo structures or %NULL if there are no annotations.
 *
 * Information about a signal on a D-Bus interface.
 *
 * Since: 2.26
 */


/**
 * GDBusSubtreeDispatchFunc:
 * @connection: A #GDBusConnection.
 * @sender: The unique bus name of the remote caller.
 * @object_path: The object path that was registered with g_dbus_connection_register_subtree().
 * @interface_name: The D-Bus interface name that the method call or property access is for.
 * @node: A node that is a child of @object_path (relative to @object_path) or %NULL for the root of the subtree.
 * @out_user_data: Return location for user data to pass to functions in the returned #GDBusInterfaceVTable (never %NULL).
 * @user_data: The @user_data #gpointer passed to g_dbus_connection_register_subtree().
 *
 * The type of the @dispatch function in #GDBusSubtreeVTable.
 *
 * Subtrees are flat.  @node, if non-%NULL, is always exactly one
 * segment of the object path (ie: it never contains a slash).
 *
 * Returns: A #GDBusInterfaceVTable or %NULL if you don't want to handle the methods.
 * Since: 2.26
 */


/**
 * GDBusSubtreeEnumerateFunc:
 * @connection: A #GDBusConnection.
 * @sender: The unique bus name of the remote caller.
 * @object_path: The object path that was registered with g_dbus_connection_register_subtree().
 * @user_data: The @user_data #gpointer passed to g_dbus_connection_register_subtree().
 *
 * The type of the @enumerate function in #GDBusSubtreeVTable.
 *
 * This function is called when generating introspection data and also
 * when preparing to dispatch incoming messages in the event that the
 * %G_DBUS_SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES flag is not
 * specified (ie: to verify that the object path is valid).
 *
 * Hierarchies are not supported; the items that you return should not
 * contain the '/' character.
 *
 * The return value will be freed with g_strfreev().
 *
 * Returns: A newly allocated array of strings for node names that are children of @object_path.
 * Since: 2.26
 */


/**
 * GDBusSubtreeFlags:
 * @G_DBUS_SUBTREE_FLAGS_NONE: No flags set.
 * @G_DBUS_SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES: Method calls to objects not in the enumerated range will still be dispatched. This is useful if you want to dynamically spawn objects in the subtree.
 *
 * Flags passed to g_dbus_connection_register_subtree().
 *
 * Since: 2.26
 */


/**
 * GDBusSubtreeIntrospectFunc:
 * @connection: A #GDBusConnection.
 * @sender: The unique bus name of the remote caller.
 * @object_path: The object path that was registered with g_dbus_connection_register_subtree().
 * @node: A node that is a child of @object_path (relative to @object_path) or %NULL for the root of the subtree.
 * @user_data: The @user_data #gpointer passed to g_dbus_connection_register_subtree().
 *
 * The type of the @introspect function in #GDBusSubtreeVTable.
 *
 * Subtrees are flat.  @node, if non-%NULL, is always exactly one
 * segment of the object path (ie: it never contains a slash).
 *
 * This function should return %NULL to indicate that there is no object
 * at this node.
 *
 * If this function returns non-%NULL, the return value is expected to
 * be a %NULL-terminated array of pointers to #GDBusInterfaceInfo
 * structures describing the interfaces implemented by @node.  This
 * array will have g_dbus_interface_info_unref() called on each item
 * before being freed with g_free().
 *
 * The difference between returning %NULL and an array containing zero
 * items is that the standard DBus interfaces will returned to the
 * remote introspector in the empty array case, but not in the %NULL
 * case.
 *
 * Returns: A %NULL-terminated array of pointers to #GDBusInterfaceInfo, or %NULL.
 * Since: 2.26
 */


/**
 * GDBusSubtreeVTable:
 * @enumerate: Function for enumerating child nodes.
 * @introspect: Function for introspecting a child node.
 * @dispatch: Function for dispatching a remote call on a child node.
 *
 * Virtual table for handling subtrees registered with g_dbus_connection_register_subtree().
 *
 * Since: 2.26
 */


/**
 * GDataInputStream:
 *
 * An implementation of #GBufferedInputStream that allows for high-level
 * data manipulation of arbitrary data (including binary operations).
 */


/**
 * GDataOutputStream:
 *
 * An implementation of #GBufferedOutputStream that allows for high-level
 * data manipulation of arbitrary data (including binary operations).
 */


/**
 * GDataOutputStream:byte-order:
 *
 * Determines the byte ordering that is used when writing
 * multi-byte entities (such as integers) to the stream.
 */


/**
 * GDataStream:byte-order:
 *
 * The ::byte-order property determines the byte ordering that
 * is used when reading multi-byte entities (such as integers)
 * from the stream.
 */


/**
 * GDataStream:newline-type:
 *
 * The :newline-type property determines what is considered
 * as a line ending when reading complete lines from the stream.
 */


/**
 * GDataStreamByteOrder:
 * @G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN: Selects Big Endian byte order.
 * @G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN: Selects Little Endian byte order.
 * @G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN: Selects endianness based on host machine's architecture.
 *
 * #GDataStreamByteOrder is used to ensure proper endianness of streaming data sources
 * across various machine architectures.
 */


/**
 * GDataStreamNewlineType:
 * @G_DATA_STREAM_NEWLINE_TYPE_LF: Selects "LF" line endings, common on most modern UNIX platforms.
 * @G_DATA_STREAM_NEWLINE_TYPE_CR: Selects "CR" line endings.
 * @G_DATA_STREAM_NEWLINE_TYPE_CR_LF: Selects "CR, LF" line ending, common on Microsoft Windows.
 * @G_DATA_STREAM_NEWLINE_TYPE_ANY: Automatically try to handle any line ending type.
 *
 * #GDataStreamNewlineType is used when checking for or setting the line endings for a given file.
 */


/**
 * GDateTime:
 *
 * <structname>GDateTime</structname> is an opaque structure whose members
 * cannot be accessed directly.
 *
 * Since: 2.26
 */


/**
 * GDebugKey:
 * @key: the string
 * @value: the flag
 *
 * Associates a string with a bit flag.
 * Used in g_parse_debug_string().
 */


/**
 * GDesktopAppInfo:
 *
 * Information about an installed application from a desktop file.
 */


/**
 * GDesktopAppInfo:filename:
 *
 * The origin filename of this #GDesktopAppInfo
 */


/**
 * GDesktopAppInfoLookup:
 *
 * Interface that is used by backends to associate default
 * handlers with URI schemes.
 */


/**
 * GDesktopAppLaunchCallback:
 * @appinfo: a #GDesktopAppInfo
 * @pid: Process identifier
 * @user_data: User data
 *
 * During invocation, g_desktop_app_info_launch_uris_as_manager() may
 * create one or more child processes.  This callback is invoked once
 * for each, providing the process ID.
 */


/**
 * GDrive:
 *
 * Opaque drive object.
 */


/**
 * GDrive::changed:
 * @drive: a #GDrive.
 *
 * Emitted when the drive's state has changed.
 */


/**
 * GDrive::disconnected:
 * @drive: a #GDrive.
 *
 * This signal is emitted when the #GDrive have been
 * disconnected. If the recipient is holding references to the
 * object they should release them so the object can be
 * finalized.
 */


/**
 * GDrive::eject-button:
 * @drive: a #GDrive.
 *
 * Emitted when the physical eject button (if any) of a drive has
 * been pressed.
 */


/**
 * GDrive::stop-button:
 * @drive: a #GDrive.
 *
 * Emitted when the physical stop button (if any) of a drive has
 * been pressed.
 *
 * Since: 2.22
 */


/**
 * GDriveIface:
 * @g_iface: The parent interface.
 * @changed: Signal emitted when the drive is changed.
 * @disconnected: The removed signal that is emitted when the #GDrive have been disconnected. If the recipient is holding references to the object they should release them so the object can be finalized.
 * @eject_button: Signal emitted when the physical eject button (if any) of a drive have been pressed.
 * @get_name: Returns the name for the given #GDrive.
 * @get_icon: Returns a #GIcon for the given #GDrive.
 * @has_volumes: Returns %TRUE if the #GDrive has mountable volumes.
 * @get_volumes: Returns a list #GList of #GVolume for the #GDrive.
 * @is_media_removable: Returns %TRUE if the #GDrive supports removal and insertion of media.
 * @has_media: Returns %TRUE if the #GDrive has media inserted.
 * @is_media_check_automatic: Returns %TRUE if the #GDrive is capabable of automatically detecting media changes.
 * @can_poll_for_media: Returns %TRUE if the #GDrive is capable of manually polling for media change.
 * @can_eject: Returns %TRUE if the #GDrive can eject media.
 * @eject: Ejects a #GDrive.
 * @eject_finish: Finishes an eject operation.
 * @poll_for_media: Poll for media insertion/removal on a #GDrive.
 * @poll_for_media_finish: Finishes a media poll operation.
 * @get_identifier: Returns the identifier of the given kind, or %NULL if the #GDrive doesn't have one.
 * @enumerate_identifiers: Returns an array strings listing the kinds of identifiers which the #GDrive has.
 * @get_start_stop_type: Gets a #GDriveStartStopType with details about starting/stopping the drive. Since 2.22.
 * @can_stop: Returns %TRUE if a #GDrive can be stopped. Since 2.22.
 * @stop: Stops a #GDrive. Since 2.22.
 * @stop_finish: Finishes a stop operation. Since 2.22.
 * @can_start: Returns %TRUE if a #GDrive can be started. Since 2.22.
 * @can_start_degraded: Returns %TRUE if a #GDrive can be started degraded. Since 2.22.
 * @start: Starts a #GDrive. Since 2.22.
 * @start_finish: Finishes a start operation. Since 2.22.
 * @stop_button: Signal emitted when the physical stop button (if any) of a drive have been pressed. Since 2.22.
 * @eject_with_operation: Starts ejecting a #GDrive using a #GMountOperation. Since 2.22.
 * @eject_with_operation_finish: Finishes an eject operation using a #GMountOperation. Since 2.22.
 * @get_sort_key: Gets a key used for sorting #GDrive instances or %NULL if no such key exists. Since 2.32.
 *
 * Interface for creating #GDrive implementations.
 */


/**
 * GDriveStartFlags:
 * @G_DRIVE_START_NONE: No flags set.
 *
 * Flags used when starting a drive.
 *
 * Since: 2.22
 */


/**
 * GDriveStartStopType:
 * @G_DRIVE_START_STOP_TYPE_UNKNOWN: Unknown or drive doesn't support start/stop.
 * @G_DRIVE_START_STOP_TYPE_SHUTDOWN: The stop method will physically shut down the drive and e.g. power down the port the drive is attached to.
 * @G_DRIVE_START_STOP_TYPE_NETWORK: The start/stop methods are used for connecting/disconnect to the drive over the network.
 * @G_DRIVE_START_STOP_TYPE_MULTIDISK: The start/stop methods will assemble/disassemble a virtual drive from several physical drives.
 * @G_DRIVE_START_STOP_TYPE_PASSWORD: The start/stop methods will unlock/lock the disk (for example using the ATA <quote>SECURITY UNLOCK DEVICE</quote> command)
 *
 * Enumeration describing how a drive can be started/stopped.
 *
 * Since: 2.22
 */


/**
 * GEmblem:
 *
 * An object for Emblems
 */


/**
 * GEmblemOrigin:
 * @G_EMBLEM_ORIGIN_UNKNOWN: Emblem of unknown origin
 * @G_EMBLEM_ORIGIN_DEVICE: Emblem adds device-specific information
 * @G_EMBLEM_ORIGIN_LIVEMETADATA: Emblem depicts live metadata, such as "readonly"
 * @G_EMBLEM_ORIGIN_TAG: Emblem comes from a user-defined tag, e.g. set by nautilus (in the future)
 *
 * GEmblemOrigin is used to add information about the origin of the emblem
 * to #GEmblem.
 *
 * Since: 2.18
 */


/**
 * GEmblemedIcon:
 *
 * An implementation of #GIcon for icons with emblems.
 */


/**
 * GEnumClass:
 * @g_type_class: the parent class
 * @minimum: the smallest possible value.
 * @maximum: the largest possible value.
 * @n_values: the number of possible values.
 * @values: an array of #GEnumValue structs describing the individual values.
 *
 * The class of an enumeration type holds information about its
 * possible values.
 */


/**
 * GEnumValue:
 * @value: the enum value
 * @value_name: the name of the value
 * @value_nick: the nickname of the value
 *
 * A structure which contains a single enum value, its name, and its
 * nickname.
 */


/**
 * GError:
 * @domain: error domain, e.g. #G_FILE_ERROR
 * @code: error code, e.g. %G_FILE_ERROR_NOENT
 * @message: human-readable informative error message
 *
 * The <structname>GError</structname> structure contains
 * information about an error that has occurred.
 */


/**
 * GFile:
 *
 * A handle to an object implementing the #GFileIface interface.
 * Generally stores a location within the file system. Handles do not
 * necessarily represent files or directories that currently exist.
 */


/**
 * GFileAttributeInfo:
 * @name: the name of the attribute.
 * @type: the #GFileAttributeType type of the attribute.
 * @flags: a set of #GFileAttributeInfoFlags.
 *
 * Information about a specific attribute.
 */


/**
 * GFileAttributeInfoFlags:
 * @G_FILE_ATTRIBUTE_INFO_NONE: no flags set.
 * @G_FILE_ATTRIBUTE_INFO_COPY_WITH_FILE: copy the attribute values when the file is copied.
 * @G_FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED: copy the attribute values when the file is moved.
 *
 * Flags specifying the behaviour of an attribute.
 */


/**
 * GFileAttributeInfoList:
 * @infos: an array of #GFileAttributeInfo<!-- -->s.
 * @n_infos: the number of values in the array.
 *
 * Acts as a lightweight registry for possible valid file attributes.
 * The registry stores Key-Value pair formats as #GFileAttributeInfo<!-- -->s.
 */


/**
 * GFileAttributeMatcher:
 *
 * Determines if a string matches a file attribute.
 */


/**
 * GFileAttributeStatus:
 * @G_FILE_ATTRIBUTE_STATUS_UNSET: Attribute value is unset (empty).
 * @G_FILE_ATTRIBUTE_STATUS_SET: Attribute value is set.
 * @G_FILE_ATTRIBUTE_STATUS_ERROR_SETTING: Indicates an error in setting the value.
 *
 * Used by g_file_set_attributes_from_info() when setting file attributes.
 */


/**
 * GFileAttributeType:
 * @G_FILE_ATTRIBUTE_TYPE_INVALID: indicates an invalid or uninitalized type.
 * @G_FILE_ATTRIBUTE_TYPE_STRING: a null terminated UTF8 string.
 * @G_FILE_ATTRIBUTE_TYPE_BYTE_STRING: a zero terminated string of non-zero bytes.
 * @G_FILE_ATTRIBUTE_TYPE_BOOLEAN: a boolean value.
 * @G_FILE_ATTRIBUTE_TYPE_UINT32: an unsigned 4-byte/32-bit integer.
 * @G_FILE_ATTRIBUTE_TYPE_INT32: a signed 4-byte/32-bit integer.
 * @G_FILE_ATTRIBUTE_TYPE_UINT64: an unsigned 8-byte/64-bit integer.
 * @G_FILE_ATTRIBUTE_TYPE_INT64: a signed 8-byte/64-bit integer.
 * @G_FILE_ATTRIBUTE_TYPE_OBJECT: a #GObject.
 * @G_FILE_ATTRIBUTE_TYPE_STRINGV: a %NULL terminated char **. Since 2.22
 *
 * The data types for file attributes.
 */


/**
 * GFileCopyFlags:
 * @G_FILE_COPY_NONE: No flags set.
 * @G_FILE_COPY_OVERWRITE: Overwrite any existing files
 * @G_FILE_COPY_BACKUP: Make a backup of any existing files.
 * @G_FILE_COPY_NOFOLLOW_SYMLINKS: Don't follow symlinks.
 * @G_FILE_COPY_ALL_METADATA: Copy all file metadata instead of just default set used for copy (see #GFileInfo).
 * @G_FILE_COPY_NO_FALLBACK_FOR_MOVE: Don't use copy and delete fallback if native move not supported.
 * @G_FILE_COPY_TARGET_DEFAULT_PERMS: Leaves target file with default perms, instead of setting the source file perms.
 *
 * Flags used when copying or moving files.
 */


/**
 * GFileCreateFlags:
 * @G_FILE_CREATE_NONE: No flags set.
 * @G_FILE_CREATE_PRIVATE: Create a file that can only be accessed by the current user.
 * @G_FILE_CREATE_REPLACE_DESTINATION: Replace the destination as if it didn't exist before. Don't try to keep any old permissions, replace instead of following links. This is generally useful if you're doing a "copy over" rather than a "save new version of" replace operation. You can think of it as "unlink destination" before writing to it, although the implementation may not be exactly like that. Since 2.20
 *
 * Flags used when an operation may create a file.
 */


/**
 * GFileDescriptorBased:
 *
 * An interface for file descriptor based io objects.
 */


/**
 * GFileDescriptorBasedIface:
 * @g_iface: The parent interface.
 *
 *
 */


/**
 * GFileEnumerator:
 *
 * A per matched file iterator.
 */


/**
 * GFileIOStream:
 *
 * A subclass of GIOStream for opened files. This adds
 * a few file-specific operations and seeking and truncating.
 *
 * #GFileIOStream implements GSeekable.
 */


/**
 * GFileIcon:
 *
 * Gets an icon for a #GFile. Implements #GLoadableIcon.
 */


/**
 * GFileIcon:file:
 *
 * The file containing the icon.
 */


/**
 * GFileIface:
 * @g_iface: The parent interface.
 * @dup: Duplicates a #GFile.
 * @hash: Creates a hash of a #GFile.
 * @equal: Checks equality of two given #GFile<!-- -->s.
 * @is_native: Checks to see if a file is native to the system.
 * @has_uri_scheme: Checks to see if a #GFile has a given URI scheme.
 * @get_uri_scheme: Gets the URI scheme for a #GFile.
 * @get_basename: Gets the basename for a given #GFile.
 * @get_path: Gets the current path within a #GFile.
 * @get_uri: Gets a URI for the path within a #GFile.
 * @get_parse_name: Gets the parsed name for the #GFile.
 * @get_parent: Gets the parent directory for the #GFile.
 * @prefix_matches: Checks whether a #GFile contains a specified file.
 * @get_relative_path: Gets the path for a #GFile relative to a given path.
 * @resolve_relative_path: Resolves a relative path for a #GFile to an absolute path.
 * @get_child_for_display_name: Gets the child #GFile for a given display name.
 * @enumerate_children: Gets a #GFileEnumerator with the children of a #GFile.
 * @enumerate_children_async: Asynchronously gets a #GFileEnumerator with the children of a #GFile.
 * @enumerate_children_finish: Finishes asynchronously enumerating the children.
 * @query_info: Gets the #GFileInfo for a #GFile.
 * @query_info_async: Asynchronously gets the #GFileInfo for a #GFile.
 * @query_info_finish: Finishes an asynchronous query info operation.
 * @query_filesystem_info: Gets a #GFileInfo for the file system #GFile is on.
 * @query_filesystem_info_async: Asynchronously gets a #GFileInfo for the file system #GFile is on.
 * @query_filesystem_info_finish: Finishes asynchronously getting the file system info.
 * @find_enclosing_mount: Gets a #GMount for the #GFile.
 * @find_enclosing_mount_async: Asynchronously gets the #GMount for a #GFile.
 * @find_enclosing_mount_finish: Finishes asynchronously getting the volume.
 * @set_display_name: Sets the display name for a #GFile.
 * @set_display_name_async: Asynchronously sets a #GFile's display name.
 * @set_display_name_finish: Finishes asynchronously setting a #GFile's display name.
 * @query_settable_attributes: Returns a list of #GFileAttribute<!-- -->s that can be set.
 * @_query_settable_attributes_async: Asynchronously gets a list of #GFileAttribute<!-- -->s that can be set.
 * @_query_settable_attributes_finish: Finishes asynchronously querying settable attributes.
 * @query_writable_namespaces: Returns a list of #GFileAttribute namespaces that are writable.
 * @_query_writable_namespaces_async: Asynchronously gets a list of #GFileAttribute namespaces that are writable.
 * @_query_writable_namespaces_finish: Finishes asynchronously querying the writable namespaces.
 * @set_attribute: Sets a #GFileAttribute.
 * @set_attributes_from_info: Sets a #GFileAttribute with information from a #GFileInfo.
 * @set_attributes_async: Asynchronously sets a file's attributes.
 * @set_attributes_finish: Finishes setting a file's attributes asynchronously.
 * @read_fn: Reads a file asynchronously.
 * @read_async: Asynchronously reads a file.
 * @read_finish: Finishes asynchronously reading a file.
 * @append_to: Writes to the end of a file.
 * @append_to_async: Asynchronously writes to the end of a file.
 * @append_to_finish: Finishes an asynchronous file append operation.
 * @create: Creates a new file.
 * @create_async: Asynchronously creates a file.
 * @create_finish: Finishes asynchronously creating a file.
 * @replace: Replaces the contents of a file.
 * @replace_async: Asynchronously replaces the contents of a file.
 * @replace_finish: Finishes asynchronously replacing a file.
 * @delete_file: Deletes a file.
 * @_delete_file_async: Asynchronously deletes a file.
 * @_delete_file_finish: Finishes an asynchronous delete.
 * @trash: Sends a #GFile to the Trash location.
 * @_trash_async: Asynchronously sends a #GFile to the Trash location.
 * @_trash_finish: Finishes an asynchronous file trashing operation.
 * @make_directory: Makes a directory.
 * @_make_directory_async: Asynchronously makes a directory.
 * @_make_directory_finish: Finishes making a directory asynchronously.
 * @make_symbolic_link: Makes a symbolic link.
 * @_make_symbolic_link_async: Asynchronously makes a symbolic link
 * @_make_symbolic_link_finish: Finishes making a symbolic link asynchronously.
 * @copy: Copies a file.
 * @copy_async: Asynchronously copies a file.
 * @copy_finish: Finishes an asynchronous copy operation.
 * @move: Moves a file.
 * @_move_async: Asynchronously moves a file.
 * @_move_finish: Finishes an asynchronous move operation.
 * @mount_mountable: Mounts a mountable object.
 * @mount_mountable_finish: Finishes a mounting operation.
 * @unmount_mountable: Unmounts a mountable object.
 * @unmount_mountable_finish: Finishes an unmount operation.
 * @eject_mountable: Ejects a mountable.
 * @eject_mountable_finish: Finishes an eject operation.
 * @mount_enclosing_volume: Mounts a specified location.
 * @mount_enclosing_volume_finish: Finishes mounting a specified location.
 * @monitor_dir: Creates a #GFileMonitor for the location.
 * @monitor_file: Creates a #GFileMonitor for the location.
 * @open_readwrite: Open file read/write. Since 2.22.
 * @open_readwrite_async: Asynchronously opens file read/write. Since 2.22.
 * @open_readwrite_finish: Finishes an asynchronous open read/write. Since 2.22.
 * @create_readwrite: Creates file read/write. Since 2.22.
 * @create_readwrite_async: Asynchronously creates file read/write. Since 2.22.
 * @create_readwrite_finish: Finishes an asynchronous creates read/write. Since 2.22.
 * @replace_readwrite: Replaces file read/write. Since 2.22.
 * @replace_readwrite_async: Asynchronously replaces file read/write. Since 2.22.
 * @replace_readwrite_finish: Finishes an asynchronous replace read/write. Since 2.22.
 * @start_mountable: Starts a mountable object. Since 2.22.
 * @start_mountable_finish: Finishes an start operation. Since 2.22.
 * @stop_mountable: Stops a mountable. Since 2.22.
 * @stop_mountable_finish: Finishes an stop operation. Since 2.22.
 * @supports_thread_contexts: a boolean that indicates whether the #GFile implementation supports thread-default contexts. Since 2.22.
 * @unmount_mountable_with_operation: Unmounts a mountable object using a #GMountOperation. Since 2.22.
 * @unmount_mountable_with_operation_finish: Finishes an unmount operation using a #GMountOperation. Since 2.22.
 * @eject_mountable_with_operation: Ejects a mountable object using a #GMountOperation. Since 2.22.
 * @eject_mountable_with_operation_finish: Finishes an eject operation using a #GMountOperation. Since 2.22.
 * @poll_mountable: Polls a mountable object for media changes. Since 2.22.
 * @poll_mountable_finish: Finishes an poll operation for media changes. Since 2.22.
 *
 * An interface for writing VFS file handles.
 */


/**
 * GFileInfo:
 *
 * Stores information about a file system object referenced by a #GFile.
 */


/**
 * GFileInputStream:
 *
 * A subclass of GInputStream for opened files. This adds
 * a few file-specific operations and seeking.
 *
 * #GFileInputStream implements #GSeekable.
 */


/**
 * GFileMonitor:
 *
 * Watches for changes to a file.
 */


/**
 * GFileMonitor::changed:
 * @monitor: a #GFileMonitor.
 * @file: a #GFile.
 * @other_file: a #GFile or #NULL.
 * @event_type: a #GFileMonitorEvent.
 *
 * Emitted when @file has been changed.
 *
 * If using #G_FILE_MONITOR_SEND_MOVED flag and @event_type is
 * #G_FILE_MONITOR_SEND_MOVED, @file will be set to a #GFile containing the
 * old path, and @other_file will be set to a #GFile containing the new path.
 *
 * In all the other cases, @other_file will be set to #NULL.
 */


/**
 * GFileMonitorEvent:
 * @G_FILE_MONITOR_EVENT_CHANGED: a file changed.
 * @G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT: a hint that this was probably the last change in a set of changes.
 * @G_FILE_MONITOR_EVENT_DELETED: a file was deleted.
 * @G_FILE_MONITOR_EVENT_CREATED: a file was created.
 * @G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED: a file attribute was changed.
 * @G_FILE_MONITOR_EVENT_PRE_UNMOUNT: the file location will soon be unmounted.
 * @G_FILE_MONITOR_EVENT_UNMOUNTED: the file location was unmounted.
 * @G_FILE_MONITOR_EVENT_MOVED: the file was moved.
 *
 * Specifies what type of event a monitor event is.
 */


/**
 * GFileMonitorFlags:
 * @G_FILE_MONITOR_NONE: No flags set.
 * @G_FILE_MONITOR_WATCH_MOUNTS: Watch for mount events.
 * @G_FILE_MONITOR_SEND_MOVED: Pair DELETED and CREATED events caused by file renames (moves) and send a single G_FILE_MONITOR_EVENT_MOVED event instead (NB: not supported on all backends; the default behaviour -without specifying this flag- is to send single DELETED and CREATED events).
 *
 * Flags used to set what a #GFileMonitor will watch for.
 */


/**
 * GFileOutputStream:
 *
 * A subclass of GOutputStream for opened files. This adds
 * a few file-specific operations and seeking and truncating.
 *
 * #GFileOutputStream implements GSeekable.
 */


/**
 * GFileProgressCallback:
 * @current_num_bytes: the current number of bytes in the operation.
 * @total_num_bytes: the total number of bytes in the operation.
 * @user_data: user data passed to the callback.
 *
 * When doing file operations that may take a while, such as moving
 * a file or copying a file, a progress callback is used to pass how
 * far along that operation is to the application.
 */


/**
 * GFileQueryInfoFlags:
 * @G_FILE_QUERY_INFO_NONE: No flags set.
 * @G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS: Don't follow symlinks.
 *
 * Flags used when querying a #GFileInfo.
 */


/**
 * GFileReadMoreCallback:
 * @file_contents: the data as currently read.
 * @file_size: the size of the data currently read.
 * @callback_data: data passed to the callback.
 *
 * When loading the partial contents of a file with g_file_load_partial_contents_async(),
 * it may become necessary to determine if any more data from the file should be loaded.
 * A #GFileReadMoreCallback function facilitates this by returning %TRUE if more data
 * should be read, or %FALSE otherwise.
 *
 * Returns: %TRUE if more data should be read back. %FALSE otherwise.
 */


/**
 * GFileType:
 * @G_FILE_TYPE_UNKNOWN: File's type is unknown.
 * @G_FILE_TYPE_REGULAR: File handle represents a regular file.
 * @G_FILE_TYPE_DIRECTORY: File handle represents a directory.
 * @G_FILE_TYPE_SYMBOLIC_LINK: File handle represents a symbolic link (Unix systems).
 * @G_FILE_TYPE_SPECIAL: File is a "special" file, such as a socket, fifo, block device, or character device.
 * @G_FILE_TYPE_SHORTCUT: File is a shortcut (Windows systems).
 * @G_FILE_TYPE_MOUNTABLE: File is a mountable location.
 *
 * Indicates the file's on-disk type.
 */


/**
 * GFilenameCompleter:
 *
 * Completes filenames based on files that exist within the file system.
 */


/**
 * GFilenameCompleter::got-completion-data:
 *
 * Emitted when the file name completion information comes available.
 */


/**
 * GFilesystemPreviewType:
 * @G_FILESYSTEM_PREVIEW_TYPE_IF_ALWAYS: Only preview files if user has explicitly requested it.
 * @G_FILESYSTEM_PREVIEW_TYPE_IF_LOCAL: Preview files if user has requested preview of "local" files.
 * @G_FILESYSTEM_PREVIEW_TYPE_NEVER: Never preview files.
 *
 * Indicates a hint from the file system whether files should be
 * previewed in a file manager. Returned as the value of the key
 * #G_FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW.
 */


/**
 * GFilterInputStream:
 *
 * A base class for all input streams that work on an underlying stream.
 */


/**
 * GFilterOutputStream:
 *
 * A base class for all output streams that work on an underlying stream.
 */


/**
 * GFlagsClass:
 * @g_type_class: the parent class
 * @mask: a mask covering all possible values.
 * @n_values: the number of possible values.
 * @values: an array of #GFlagsValue structs describing the individual values.
 *
 * The class of a flags type holds information about its
 * possible values.
 */


/**
 * GFlagsValue:
 * @value: the flags value
 * @value_name: the name of the value
 * @value_nick: the nickname of the value
 *
 * A structure which contains a single flags value, its name, and its
 * nickname.
 */


/**
 * GFreeFunc:
 * @data: a data pointer
 *
 * Declares a type of function which takes an arbitrary
 * data pointer argument and has no return value. It is
 * not currently used in GLib or GTK+.
 */


/**
 * GHmac:
 *
 * An opaque structure representing a HMAC operation.
 * To create a new GHmac, use g_hmac_new(). To free
 * a GHmac, use g_hmac_unref().
 *
 * Since: 2.30
 */


/**
 * GIOErrorEnum:
 * @G_IO_ERROR_FAILED: Generic error condition for when any operation fails.
 * @G_IO_ERROR_NOT_FOUND: File not found error.
 * @G_IO_ERROR_EXISTS: File already exists error.
 * @G_IO_ERROR_IS_DIRECTORY: File is a directory error.
 * @G_IO_ERROR_NOT_DIRECTORY: File is not a directory.
 * @G_IO_ERROR_NOT_EMPTY: File is a directory that isn't empty.
 * @G_IO_ERROR_NOT_REGULAR_FILE: File is not a regular file.
 * @G_IO_ERROR_NOT_SYMBOLIC_LINK: File is not a symbolic link.
 * @G_IO_ERROR_NOT_MOUNTABLE_FILE: File cannot be mounted.
 * @G_IO_ERROR_FILENAME_TOO_LONG: Filename is too many characters.
 * @G_IO_ERROR_INVALID_FILENAME: Filename is invalid or contains invalid characters.
 * @G_IO_ERROR_TOO_MANY_LINKS: File contains too many symbolic links.
 * @G_IO_ERROR_NO_SPACE: No space left on drive.
 * @G_IO_ERROR_INVALID_ARGUMENT: Invalid argument.
 * @G_IO_ERROR_PERMISSION_DENIED: Permission denied.
 * @G_IO_ERROR_NOT_SUPPORTED: Operation not supported for the current backend.
 * @G_IO_ERROR_NOT_MOUNTED: File isn't mounted.
 * @G_IO_ERROR_ALREADY_MOUNTED: File is already mounted.
 * @G_IO_ERROR_CLOSED: File was closed.
 * @G_IO_ERROR_CANCELLED: Operation was cancelled. See #GCancellable.
 * @G_IO_ERROR_PENDING: Operations are still pending.
 * @G_IO_ERROR_READ_ONLY: File is read only.
 * @G_IO_ERROR_CANT_CREATE_BACKUP: Backup couldn't be created.
 * @G_IO_ERROR_WRONG_ETAG: File's Entity Tag was incorrect.
 * @G_IO_ERROR_TIMED_OUT: Operation timed out.
 * @G_IO_ERROR_WOULD_RECURSE: Operation would be recursive.
 * @G_IO_ERROR_BUSY: File is busy.
 * @G_IO_ERROR_WOULD_BLOCK: Operation would block.
 * @G_IO_ERROR_HOST_NOT_FOUND: Host couldn't be found (remote operations).
 * @G_IO_ERROR_WOULD_MERGE: Operation would merge files.
 * @G_IO_ERROR_FAILED_HANDLED: Operation failed and a helper program has already interacted with the user. Do not display any error dialog.
 * @G_IO_ERROR_TOO_MANY_OPEN_FILES: The current process has too many files open and can't open any more. Duplicate descriptors do count toward this limit. Since 2.20
 * @G_IO_ERROR_NOT_INITIALIZED: The object has not been initialized. Since 2.22
 * @G_IO_ERROR_ADDRESS_IN_USE: The requested address is already in use. Since 2.22
 * @G_IO_ERROR_PARTIAL_INPUT: Need more input to finish operation. Since 2.24
 * @G_IO_ERROR_INVALID_DATA: There input data was invalid. Since 2.24
 * @G_IO_ERROR_DBUS_ERROR: A remote object generated an error that doesn't correspond to a locally registered #GError error domain. Use g_dbus_error_get_remote_error() to extract the D-Bus error name and g_dbus_error_strip_remote_error() to fix up the message so it matches what was received on the wire. Since 2.26.
 * @G_IO_ERROR_HOST_UNREACHABLE: Host unreachable. Since 2.26
 * @G_IO_ERROR_NETWORK_UNREACHABLE: Network unreachable. Since 2.26
 * @G_IO_ERROR_CONNECTION_REFUSED: Connection refused. Since 2.26
 * @G_IO_ERROR_PROXY_FAILED: Connection to proxy server failed. Since 2.26
 * @G_IO_ERROR_PROXY_AUTH_FAILED: Proxy authentication failed. Since 2.26
 * @G_IO_ERROR_PROXY_NEED_AUTH: Proxy server needs authentication. Since 2.26
 * @G_IO_ERROR_PROXY_NOT_ALLOWED: Proxy connection is not allowed by ruleset. Since 2.26
 *
 * Error codes returned by GIO functions.
 */


/**
 * GIOModule:
 *
 * Opaque module base class for extending GIO.
 */


/**
 * GIOModuleScope:
 *
 * Represents a scope for loading IO modules. A scope can be used for blocking
 * duplicate modules, or blocking a module you don't want to load.
 *
 * The scope can be used with g_io_modules_load_all_in_directory_with_scope()
 * or g_io_modules_scan_all_in_directory_with_scope().
 *
 * Since: 2.30
 */


/**
 * GIOModuleScopeFlags:
 * @G_IO_MODULES_SCOPE_NONE: No module scan flags
 * @G_IO_MODULES_SCOPE_BLOCK_DUPLICATES: When using this scope to load or scan modules, automatically block a modules which has the same base basename as previously loaded module.
 *
 * Flags for use with g_io_module_scope_new().
 *
 * Since: 2.30
 */


/**
 * GIOSchedulerJob:
 *
 * Opaque class for defining and scheduling IO jobs.
 */


/**
 * GIOSchedulerJobFunc:
 * @job: a #GIOSchedulerJob.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @user_data: the data to pass to callback function
 *
 * I/O Job function.
 *
 * Long-running jobs should periodically check the @cancellable
 * to see if they have been cancelled.
 *
 * complete the job, %FALSE if the job is complete (or cancelled)
 *
 * Returns: %TRUE if this function should be called again to
 */


/**
 * GIOStream:
 *
 * Base class for read-write streams.
 */


/**
 * GIOStreamSpliceFlags:
 * @G_IO_STREAM_SPLICE_NONE: Do not close either stream.
 * @G_IO_STREAM_SPLICE_CLOSE_STREAM1: Close the first stream after the splice.
 * @G_IO_STREAM_SPLICE_CLOSE_STREAM2: Close the second stream after the splice.
 * @G_IO_STREAM_SPLICE_WAIT_FOR_BOTH: Wait for both splice operations to finish before calling the callback.
 *
 * GIOStreamSpliceFlags determine how streams should be spliced.
 *
 * Since: 2.28
 */


/**
 * GIcon:
 *
 * An abstract type that specifies an icon.
 */


/**
 * GIconIface:
 * @g_iface: The parent interface.
 * @hash: A hash for a given #GIcon.
 * @equal: Checks if two #GIcon<!-- -->s are equal.
 * @to_tokens: Serializes a #GIcon into tokens. The tokens must not contain any whitespace. Don't implement if the #GIcon can't be serialized (Since 2.20).
 * @from_tokens: Constructs a #GIcon from tokens. Set the #GError if the tokens are malformed. Don't implement if the #GIcon can't be serialized (Since 2.20).
 *
 * GIconIface is used to implement GIcon types for various
 * different systems. See #GThemedIcon and #GLoadableIcon for
 * examples of how to implement this interface.
 */


/**
 * GIconv:
 *
 * The <structname>GIConv</structname> struct wraps an
 * iconv() conversion descriptor. It contains private data
 * and should only be accessed using the following functions.
 */


/**
 * GInetAddress:
 *
 * An IPv4 or IPv6 internet address.
 */


/**
 * GInetAddress:is-any:
 *
 * Whether this is the "any" address for its family.
 * See g_inet_address_get_is_any().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-link-local:
 *
 * Whether this is a link-local address.
 * See g_inet_address_get_is_link_local().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-loopback:
 *
 * Whether this is the loopback address for its family.
 * See g_inet_address_get_is_loopback().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-mc-global:
 *
 * Whether this is a global multicast address.
 * See g_inet_address_get_is_mc_global().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-mc-link-local:
 *
 * Whether this is a link-local multicast address.
 * See g_inet_address_get_is_mc_link_local().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-mc-node-local:
 *
 * Whether this is a node-local multicast address.
 * See g_inet_address_get_is_mc_node_local().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-mc-org-local:
 *
 * Whether this is an organization-local multicast address.
 * See g_inet_address_get_is_mc_org_local().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-mc-site-local:
 *
 * Whether this is a site-local multicast address.
 * See g_inet_address_get_is_mc_site_local().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-multicast:
 *
 * Whether this is a multicast address.
 * See g_inet_address_get_is_multicast().
 *
 * Since: 2.22
 */


/**
 * GInetAddress:is-site-local:
 *
 * Whether this is a site-local address.
 * See g_inet_address_get_is_loopback().
 *
 * Since: 2.22
 */


/**
 * GInetAddressMask:
 *
 * A combination of an IPv4 or IPv6 base address and a length,
 * representing a range of IP addresses.
 *
 * Since: 2.32
 */


/**
 * GInetSocketAddress:
 *
 * An IPv4 or IPv6 socket address, corresponding to a <type>struct
 * sockaddr_in</type> or <type>struct sockaddr_in6</type>.
 */


/**
 * GInitable:
 *
 * Interface for initializable objects.
 *
 * Since: 2.22
 */


/**
 * GInitableIface:
 * @g_iface: The parent interface.
 * @init: Initializes the object.
 *
 * Provides an interface for initializing object such that initialization
 * may fail.
 *
 * Since: 2.22
 */


/**
 * GInitiallyUnowned:
 *
 * All the fields in the <structname>GInitiallyUnowned</structname> structure
 * are private to the #GInitiallyUnowned implementation and should never be
 * accessed directly.
 */


/**
 * GInitiallyUnownedClass:
 *
 * The class structure for the <structname>GInitiallyUnowned</structname> type.
 */


/**
 * GInputStream:
 *
 * Base class for streaming input operations.
 */


/**
 * GInputVector:
 * @buffer: Pointer to a buffer where data will be written.
 * @size: the available size in @buffer.
 *
 * Structure used for scatter/gather data input.
 * You generally pass in an array of #GInputVector<!-- -->s
 * and the operation will store the read data starting in the
 * first buffer, switching to the next as needed.
 *
 * Since: 2.22
 */


/**
 * GInstanceInitFunc:
 * @instance: The instance to initialize.
 * @g_class: The class of the type the instance is created for.
 *
 * A callback function used by the type system to initialize a new
 * instance of a type. This function initializes all instance members and
 * allocates any resources required by it.
 * Initialization of a derived instance involves calling all its parent
 * types instance initializers, so the class member of the instance
 * is altered during its initialization to always point to the class that
 * belongs to the type the current initializer was introduced for.
 */


/**
 * GInterfaceFinalizeFunc:
 * @g_iface: The interface structure to finalize.
 * @iface_data: The @interface_data supplied via the #GInterfaceInfo structure.
 *
 * A callback function used by the type system to finalize an interface.
 * This function should destroy any internal data and release any resources
 * allocated by the corresponding GInterfaceInitFunc() function.
 */


/**
 * GInterfaceInfo:
 * @interface_init: location of the interface initialization function
 * @interface_finalize: location of the interface finalization function
 * @interface_data: user-supplied data passed to the interface init/finalize functions
 *
 * A structure that provides information to the type system which is
 * used specifically for managing interface types.
 */


/**
 * GInterfaceInitFunc:
 * @g_iface: The interface structure to initialize.
 * @iface_data: The @interface_data supplied via the #GInterfaceInfo structure.
 *
 * A callback function used by the type system to initialize a new
 * interface.  This function should initialize all internal data and
 * allocate any resources required by the interface.
 */


/**
 * GLIB_CHECK_VERSION:
 * @major: the major version to check for
 * @minor: the minor version to check for
 * @micro: the micro version to check for
 *
 * Checks the version of the GLib library that is being compiled
 * against.
 *
 * <example>
 * <title>Checking the version of the GLib library</title>
 * <programlisting>
 * if (!GLIB_CHECK_VERSION (1, 2, 0))
 * g_error ("GLib version 1.2.0 or above is needed");
 * </programlisting>
 * </example>
 *
 * See glib_check_version() for a runtime check.
 *
 * is the same as or newer than the passed-in version.
 *
 * Returns: %TRUE if the version of the GLib header files
 */


/**
 * GLoadableIcon:
 *
 * Generic type for all kinds of icons that can be loaded
 * as a stream.
 */


/**
 * GLoadableIconIface:
 * @g_iface: The parent interface.
 * @load: Loads an icon.
 * @load_async: Loads an icon asynchronously.
 * @load_finish: Finishes an asynchronous icon load.
 *
 * Interface for icons that can be loaded as a stream.
 */


/**
 * GMainContext:
 *
 * The <structname>GMainContext</structname> struct is an opaque data
 * type representing a set of sources to be handled in a main loop.
 */


/**
 * GMainLoop:
 *
 * The <structname>GMainLoop</structname> struct is an opaque data type
 * representing the main event loop of a GLib or GTK+ application.
 */


/**
 * GMarkupError:
 * @G_MARKUP_ERROR_BAD_UTF8: text being parsed was not valid UTF-8
 * @G_MARKUP_ERROR_EMPTY: document contained nothing, or only whitespace
 * @G_MARKUP_ERROR_PARSE: document was ill-formed
 * @G_MARKUP_ERROR_UNKNOWN_ELEMENT: error should be set by #GMarkupParser functions; element wasn't known
 * @G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE: error should be set by #GMarkupParser functions; attribute wasn't known
 * @G_MARKUP_ERROR_INVALID_CONTENT: error should be set by #GMarkupParser functions; content was invalid
 * @G_MARKUP_ERROR_MISSING_ATTRIBUTE: error should be set by #GMarkupParser functions; a required attribute was missing
 *
 * Error codes returned by markup parsing.
 */


/**
 * GMarkupParseContext:
 *
 * A parse context is used to parse a stream of bytes that
 * you expect to contain marked-up text.
 *
 * See g_markup_parse_context_new(), #GMarkupParser, and so
 * on for more details.
 */


/**
 * GMarkupParseFlags:
 * @G_MARKUP_DO_NOT_USE_THIS_UNSUPPORTED_FLAG: flag you should not use
 * @G_MARKUP_TREAT_CDATA_AS_TEXT: When this flag is set, CDATA marked sections are not passed literally to the @passthrough function of the parser. Instead, the content of the section (without the <literal>&lt;![CDATA[</literal> and <literal>]]&gt;</literal>) is passed to the @text function. This flag was added in GLib 2.12
 * @G_MARKUP_PREFIX_ERROR_POSITION: Normally errors caught by GMarkup itself have line/column information prefixed to them to let the caller know the location of the error. When this flag is set the location information is also prefixed to errors generated by the #GMarkupParser implementation functions
 *
 * Flags that affect the behaviour of the parser.
 */


/**
 * GMarkupParser:
 * @start_element: Callback to invoke when the opening tag of an element is seen.
 * @end_element: Callback to invoke when the closing tag of an element is seen. Note that this is also called for empty tags like <literal>&lt;empty/&gt;</literal>.
 * @text: Callback to invoke when some text is seen (text is always inside an element). Note that the text of an element may be spread over multiple calls of this function. If the %G_MARKUP_TREAT_CDATA_AS_TEXT flag is set, this function is also called for the content of CDATA marked sections.
 * @passthrough: Callback to invoke for comments, processing instructions and doctype declarations; if you're re-writing the parsed document, write the passthrough text back out in the same position. If the %G_MARKUP_TREAT_CDATA_AS_TEXT flag is not set, this function is also called for CDATA marked sections.
 * @error: Callback to invoke when an error occurs.
 *
 * Any of the fields in #GMarkupParser can be %NULL, in which case they
 * will be ignored. Except for the @error function, any of these callbacks
 * can set an error; in particular the %G_MARKUP_ERROR_UNKNOWN_ELEMENT,
 * %G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, and %G_MARKUP_ERROR_INVALID_CONTENT
 * errors are intended to be set from these callbacks. If you set an error
 * from a callback, g_markup_parse_context_parse() will report that error
 * back to its caller.
 */


/**
 * GMemVTable:
 * @malloc: function to use for allocating memory.
 * @realloc: function to use for reallocating memory.
 * @free: function to use to free memory.
 * @calloc: function to use for allocating zero-filled memory.
 * @try_malloc: function to use for allocating memory without a default error handler.
 * @try_realloc: function to use for reallocating memory without a default error handler.
 *
 * A set of functions used to perform memory allocation. The same #GMemVTable must
 * be used for all allocations in the same program; a call to g_mem_set_vtable(),
 * if it exists, should be prior to any use of GLib.
 */


/**
 * GMemoryInputStream:
 *
 * Implements #GInputStream for arbitrary memory chunks.
 */


/**
 * GMemoryOutputStream:
 *
 * Implements #GOutputStream for arbitrary memory chunks.
 */


/**
 * GMemoryOutputStream:data:
 *
 * Pointer to buffer where data will be written.
 *
 * Since: 2.24
 */


/**
 * GMemoryOutputStream:data-size:
 *
 * Size of data written to the buffer.
 *
 * Since: 2.24
 */


/**
 * GMemoryOutputStream:destroy-function: (skip)
 *
 * Function called with the buffer as argument when the stream is destroyed.
 *
 * Since: 2.24
 */


/**
 * GMemoryOutputStream:realloc-function: (skip)
 *
 * Function with realloc semantics called to enlarge the buffer.
 *
 * Since: 2.24
 */


/**
 * GMemoryOutputStream:size:
 *
 * Current size of the data buffer.
 *
 * Since: 2.24
 */


/**
 * GMenu:
 *
 * #GMenu is an opaque structure type.  You must access it using the
 * functions below.
 *
 * Since: 2.32
 */


/**
 * GMenuAttributeIter:
 *
 * #GMenuAttributeIter is an opaque structure type.  You must access it
 * using the functions below.
 *
 * Since: 2.32
 */


/**
 * GMenuItem:
 *
 * #GMenuItem is an opaque structure type.  You must access it using the
 * functions below.
 *
 * Since: 2.32
 */


/**
 * GMenuLinkIter:
 *
 * #GMenuLinkIter is an opaque structure type.  You must access it using
 * the functions below.
 *
 * Since: 2.32
 */


/**
 * GMenuModel:
 *
 * #GMenuModel is an opaque structure type.  You must access it using the
 * functions below.
 *
 * Since: 2.32
 */


/**
 * GMenuModel::items-changed:
 * @model: the #GMenuModel that is changing
 * @position: the position of the change
 * @removed: the number of items removed
 * @added: the number of items added
 *
 * Emitted when a change has occured to the menu.
 *
 * The only changes that can occur to a menu is that items are removed
 * or added.  Items may not change (except by being removed and added
 * back in the same location).  This signal is capable of describing
 * both of those changes (at the same time).
 *
 * The signal means that starting at the index @position, @removed
 * items were removed and @added items were added in their place.  If
 * @removed is zero then only items were added.  If @added is zero
 * then only items were removed.
 *
 * As an example, if the menu contains items a, b, c, d (in that
 * order) and the signal (2, 1, 3) occurs then the new composition of
 * the menu will be a, b, _, _, _, d (with each _ representing some
 * new item).
 *
 * Signal handlers may query the model (particularly the added items)
 * and expect to see the results of the modification that is being
 * reported.  The signal is emitted after the modification.
 */


/**
 * GMount:
 *
 * A handle to an object implementing the #GMountIface interface.
 */


/**
 * GMount::changed:
 * @mount: the object on which the signal is emitted
 *
 * Emitted when the mount has been changed.
 */


/**
 * GMount::pre-unmount:
 * @mount: the object on which the signal is emitted
 *
 * This signal is emitted when the #GMount is about to be
 * unmounted.
 *
 * Since: 2.22
 */


/**
 * GMount::unmounted:
 * @mount: the object on which the signal is emitted
 *
 * This signal is emitted when the #GMount have been
 * unmounted. If the recipient is holding references to the
 * object they should release them so the object can be
 * finalized.
 */


/**
 * GMountIface:
 * @g_iface: The parent interface.
 * @changed: Changed signal that is emitted when the mount's state has changed.
 * @unmounted: The unmounted signal that is emitted when the #GMount have been unmounted. If the recipient is holding references to the object they should release them so the object can be finalized.
 * @pre_unmount: The pre_unmout signal that is emitted when the #GMount will soon be emitted. If the recipient is somehow holding the mount open by keeping an open file on it it should close the file.
 * @get_root: Gets a #GFile to the root directory of the #GMount.
 * @get_name: Gets a string containing the name of the #GMount.
 * @get_icon: Gets a #GIcon for the #GMount.
 * @get_uuid: Gets the UUID for the #GMount. The reference is typically based on the file system UUID for the mount in question and should be considered an opaque string. Returns %NULL if there is no UUID available.
 * @get_volume: Gets a #GVolume the mount is located on. Returns %NULL if the #GMount is not associated with a #GVolume.
 * @get_drive: Gets a #GDrive the volume of the mount is located on. Returns %NULL if the #GMount is not associated with a #GDrive or a #GVolume. This is convenience method for getting the #GVolume and using that to get the #GDrive.
 * @can_unmount: Checks if a #GMount can be unmounted.
 * @can_eject: Checks if a #GMount can be ejected.
 * @unmount: Starts unmounting a #GMount.
 * @unmount_finish: Finishes an unmounting operation.
 * @eject: Starts ejecting a #GMount.
 * @eject_finish: Finishes an eject operation.
 * @remount: Starts remounting a #GMount.
 * @remount_finish: Finishes a remounting operation.
 * @guess_content_type: Starts guessing the type of the content of a #GMount. See g_mount_guess_content_type() for more information on content type guessing. This operation was added in 2.18.
 * @guess_content_type_finish: Finishes a contenet type guessing operation. Added in 2.18.
 * @guess_content_type_sync: Synchronous variant of @guess_content_type. Added in 2.18
 * @unmount_with_operation: Starts unmounting a #GMount using a #GMountOperation. Since 2.22.
 * @unmount_with_operation_finish: Finishes an unmounting operation using a #GMountOperation. Since 2.22.
 * @eject_with_operation: Starts ejecting a #GMount using a #GMountOperation. Since 2.22.
 * @eject_with_operation_finish: Finishes an eject operation using a #GMountOperation. Since 2.22.
 * @get_default_location: Gets a #GFile indication a start location that can be use as the entry point for this mount. Since 2.24.
 * @get_sort_key: Gets a key used for sorting #GMount instance or %NULL if no such key exists. Since 2.32.
 *
 * Interface for implementing operations for mounts.
 */


/**
 * GMountMountFlags:
 * @G_MOUNT_MOUNT_NONE: No flags set.
 *
 * Flags used when mounting a mount.
 */


/**
 * GMountOperation:
 *
 * Class for providing authentication methods for mounting operations,
 * such as mounting a file locally, or authenticating with a server.
 */


/**
 * GMountOperation::aborted:
 *
 * Emitted by the backend when e.g. a device becomes unavailable
 * while a mount operation is in progress.
 *
 * Implementations of GMountOperation should handle this signal
 * by dismissing open password dialogs.
 *
 * Since: 2.20
 */


/**
 * GMountOperation::ask-password:
 * @op: a #GMountOperation requesting a password.
 * @message: string containing a message to display to the user.
 * @default_user: string containing the default user name.
 * @default_domain: string containing the default domain.
 * @flags: a set of #GAskPasswordFlags.
 *
 * Emitted when a mount operation asks the user for a password.
 *
 * If the message contains a line break, the first line should be
 * presented as a heading. For example, it may be used as the
 * primary text in a #GtkMessageDialog.
 */


/**
 * GMountOperation::ask-question:
 * @op: a #GMountOperation asking a question.
 * @message: string containing a message to display to the user.
 * @choices: an array of strings for each possible choice.
 *
 * Emitted when asking the user a question and gives a list of
 * choices for the user to choose from.
 *
 * If the message contains a line break, the first line should be
 * presented as a heading. For example, it may be used as the
 * primary text in a #GtkMessageDialog.
 */


/**
 * GMountOperation::reply:
 * @op: a #GMountOperation.
 * @result: a #GMountOperationResult indicating how the request was handled
 *
 * Emitted when the user has replied to the mount operation.
 */


/**
 * GMountOperation::show-processes:
 * @op: a #GMountOperation.
 * @message: string containing a message to display to the user.
 * @processes: an array of #GPid for processes blocking the operation.
 * @choices: an array of strings for each possible choice.
 *
 * Emitted when one or more processes are blocking an operation
 * e.g. unmounting/ejecting a #GMount or stopping a #GDrive.
 *
 * Note that this signal may be emitted several times to update the
 * list of blocking processes as processes close files. The
 * application should only respond with g_mount_operation_reply() to
 * the latest signal (setting #GMountOperation:choice to the choice
 * the user made).
 *
 * If the message contains a line break, the first line should be
 * presented as a heading. For example, it may be used as the
 * primary text in a #GtkMessageDialog.
 *
 * Since: 2.22
 */


/**
 * GMountOperation:anonymous:
 *
 * Whether to use an anonymous user when authenticating.
 */


/**
 * GMountOperation:choice:
 *
 * The index of the user's choice when a question is asked during the
 * mount operation. See the #GMountOperation::ask-question signal.
 */


/**
 * GMountOperation:domain:
 *
 * The domain to use for the mount operation.
 */


/**
 * GMountOperation:password:
 *
 * The password that is used for authentication when carrying out
 * the mount operation.
 */


/**
 * GMountOperation:password-save:
 *
 * Determines if and how the password information should be saved.
 */


/**
 * GMountOperation:username:
 *
 * The user name that is used for authentication when carrying out
 * the mount operation.
 */


/**
 * GMountOperationResult:
 * @G_MOUNT_OPERATION_HANDLED: The request was fulfilled and the user specified data is now available
 * @G_MOUNT_OPERATION_ABORTED: The user requested the mount operation to be aborted
 * @G_MOUNT_OPERATION_UNHANDLED: The request was unhandled (i.e. not implemented)
 *
 * #GMountOperationResult is returned as a result when a request for
 * information is send by the mounting operation.
 */


/**
 * GMountUnmountFlags:
 * @G_MOUNT_UNMOUNT_NONE: No flags set.
 * @G_MOUNT_UNMOUNT_FORCE: Unmount even if there are outstanding file operations on the mount.
 *
 * Flags used when an unmounting a mount.
 */


/**
 * GNetworkAddress:
 *
 * A #GSocketConnectable for resolving a hostname and connecting to
 * that host.
 */


/**
 * GNetworkMonitor:
 *
 * #GNetworkMonitor monitors the status of network connections and
 * indicates when a possibly-user-visible change has occurred.
 *
 * Since: 2.32
 */


/**
 * GNetworkMonitor::network-changed:
 * @monitor: a #GNetworkMonitor
 * @available: the current value of #GNetworkMonitor:network-available
 *
 * Emitted when the network configuration changes. If @available is
 * %TRUE, then some hosts may be reachable that were not reachable
 * before, while others that were reachable before may no longer be
 * reachable. If @available is %FALSE, then no remote hosts are
 * reachable.
 *
 * Since: 2.32
 */


/**
 * GNetworkMonitor:network-available:
 *
 * Whether the network is considered available. That is, whether the
 * system has a default route for at least one of IPv4 or IPv6.
 *
 * Real-world networks are of course much more complicated than
 * this; the machine may be connected to a wifi hotspot that
 * requires payment before allowing traffic through, or may be
 * connected to a functioning router that has lost its own upstream
 * connectivity. Some hosts might only be accessible when a VPN is
 * active. Other hosts might only be accessible when the VPN is
 * <emphasis>not</emphasis> active. Thus, it is best to use
 * g_network_monitor_can_reach() or
 * g_network_monitor_can_reach_async() to test for reachability on a
 * host-by-host basis. (On the other hand, when the property is
 * %FALSE, the application can reasonably expect that no remote
 * hosts at all are reachable, and should indicate this to the user
 * in its UI.)
 *
 * See also #GNetworkMonitor::network-changed.
 *
 * Since: 2.32
 */


/**
 * GNetworkService:
 *
 * A #GSocketConnectable for resolving a SRV record and connecting to
 * that service.
 */


/**
 * GNormalizeMode:
 * @G_NORMALIZE_DEFAULT: standardize differences that do not affect the text content, such as the above-mentioned accent representation
 * @G_NORMALIZE_NFD: another name for %G_NORMALIZE_DEFAULT
 * @G_NORMALIZE_DEFAULT_COMPOSE: like %G_NORMALIZE_DEFAULT, but with composed forms rather than a maximally decomposed form
 * @G_NORMALIZE_NFC: another name for %G_NORMALIZE_DEFAULT_COMPOSE
 * @G_NORMALIZE_ALL: beyond %G_NORMALIZE_DEFAULT also standardize the "compatibility" characters in Unicode, such as SUPERSCRIPT THREE to the standard forms (in this case DIGIT THREE). Formatting information may be lost but for most text operations such characters should be considered the same
 * @G_NORMALIZE_NFKD: another name for %G_NORMALIZE_ALL
 * @G_NORMALIZE_ALL_COMPOSE: like %G_NORMALIZE_ALL, but with composed forms rather than a maximally decomposed form
 * @G_NORMALIZE_NFKC: another name for %G_NORMALIZE_ALL_COMPOSE
 *
 * Defines how a Unicode string is transformed in a canonical
 * form, standardizing such issues as whether a character with
 * an accent is represented as a base character and combining
 * accent or as a single precomposed character. Unicode strings
 * should generally be normalized before comparing them.
 */


/**
 * GObject:
 *
 * All the fields in the <structname>GObject</structname> structure are private
 * to the #GObject implementation and should never be accessed directly.
 */


/**
 * GObjectClass:
 * @g_type_class: the parent class
 * @constructor: the @constructor function is called by g_object_new () to complete the object initialization after all the construction properties are set. The first thing a @constructor implementation must do is chain up to the @constructor of the parent class. Overriding @constructor should be rarely needed, e.g. to handle construct properties, or to implement singletons.
 * @set_property: the generic setter for all properties of this type. Should be overridden for every type with properties. Implementations of @set_property don't need to emit property change notification explicitly, this is handled by the type system.
 * @get_property: the generic getter for all properties of this type. Should be overridden for every type with properties.
 * @dispose: the @dispose function is supposed to drop all references to other objects, but keep the instance otherwise intact, so that client method invocations still work. It may be run multiple times (due to reference loops). Before returning, @dispose should chain up to the @dispose method of the parent class.
 * @finalize: instance finalization function, should finish the finalization of the instance begun in @dispose and chain up to the @finalize method of the parent class.
 * @dispatch_properties_changed: emits property change notification for a bunch of properties. Overriding @dispatch_properties_changed should be rarely needed.
 * @notify: the class closure for the notify signal
 * @constructed: the @constructed function is called by g_object_new() as the final step of the object creation process.  At the point of the call, all construction properties have been set on the object.  The purpose of this call is to allow for object initialisation steps that can only be performed after construction properties have been set.  @constructed implementors should chain up to the @constructed call of their parent class to allow it to complete its initialisation.
 *
 * The class structure for the <structname>GObject</structname> type.
 *
 * <example>
 * <title>Implementing singletons using a constructor</title>
 * <programlisting>
 * static MySingleton *the_singleton = NULL;
 *
 * static GObject*
 * my_singleton_constructor (GType                  type,
 * guint                  n_construct_params,
 * GObjectConstructParam *construct_params)
 * {
 * GObject *object;
 *
 * if (!the_singleton)
 * {
 * object = G_OBJECT_CLASS (parent_class)->constructor (type,
 * n_construct_params,
 * construct_params);
 * the_singleton = MY_SINGLETON (object);
 * }
 * else
 * object = g_object_ref (G_OBJECT (the_singleton));
 *
 * return object;
 * }
 * </programlisting></example>
 */


/**
 * GObjectConstructParam:
 * @pspec: the #GParamSpec of the construct parameter
 * @value: the value to set the parameter to
 *
 * The <structname>GObjectConstructParam</structname> struct is an auxiliary
 * structure used to hand #GParamSpec/#GValue pairs to the @constructor of
 * a #GObjectClass.
 */


/**
 * GObjectFinalizeFunc:
 * @object: the #GObject being finalized
 *
 * The type of the @finalize function of #GObjectClass.
 */


/**
 * GObjectGetPropertyFunc:
 * @object: a #GObject
 * @property_id: the numeric id under which the property was registered with g_object_class_install_property().
 * @value: a #GValue to return the property value in
 * @pspec: the #GParamSpec describing the property
 *
 * The type of the @get_property function of #GObjectClass.
 */


/**
 * GObjectSetPropertyFunc:
 * @object: a #GObject
 * @property_id: the numeric id under which the property was registered with g_object_class_install_property().
 * @value: the new value for the property
 * @pspec: the #GParamSpec describing the property
 *
 * The type of the @set_property function of #GObjectClass.
 */


/**
 * GOptionArg:
 * @G_OPTION_ARG_NONE: No extra argument. This is useful for simple flags.
 * @G_OPTION_ARG_STRING: The option takes a string argument.
 * @G_OPTION_ARG_INT: The option takes an integer argument.
 * @G_OPTION_ARG_CALLBACK: The option provides a callback to parse the extra argument.
 * @G_OPTION_ARG_FILENAME: The option takes a filename as argument.
 * @G_OPTION_ARG_STRING_ARRAY: The option takes a string argument, multiple uses of the option are collected into an array of strings.
 * @G_OPTION_ARG_FILENAME_ARRAY: The option takes a filename as argument, multiple uses of the option are collected into an array of strings.
 * @G_OPTION_ARG_DOUBLE: The option takes a double argument. The argument can be formatted either for the user's locale or for the "C" locale. Since 2.12
 * @G_OPTION_ARG_INT64: The option takes a 64-bit integer. Like %G_OPTION_ARG_INT but for larger numbers. The number can be in decimal base, or in hexadecimal (when prefixed with <literal>0x</literal>, for example, <literal>0xffffffff</literal>). Since 2.12
 *
 * The #GOptionArg enum values determine which type of extra argument the
 * options expect to find. If an option expects an extra argument, it
 * can be specified in several ways; with a short option:
 * <option>-x arg</option>, with a long option: <option>--name arg</option>
 * or combined in a single argument: <option>--name=arg</option>.
 */


/**
 * GOptionArgFunc:
 * @option_name: The name of the option being parsed. This will be either a single dash followed by a single letter (for a short name) or two dashes followed by a long option name.
 * @value: The value to be parsed.
 * @data: User data added to the #GOptionGroup containing the option when it was created with g_option_group_new()
 * @error: A return location for errors. The error code %G_OPTION_ERROR_FAILED is intended to be used for errors in #GOptionArgFunc callbacks.
 *
 * The type of function to be passed as callback for %G_OPTION_ARG_CALLBACK
 * options.
 *
 * occurred, in which case @error should be set with g_set_error()
 *
 * Returns: %TRUE if the option was successfully parsed, %FALSE if an error
 */


/**
 * GOptionContext:
 *
 * A <structname>GOptionContext</structname> struct defines which options
 * are accepted by the commandline option parser. The struct has only private
 * fields and should not be directly accessed.
 */


/**
 * GOptionEntry:
 * @long_name: The long name of an option can be used to specify it in a commandline as --<replaceable>long_name</replaceable>. Every option must have a long name. To resolve conflicts if multiple option groups contain the same long name, it is also possible to specify the option as --<replaceable>groupname</replaceable>-<replaceable>long_name</replaceable>.
 * @short_name: If an option has a short name, it can be specified -<replaceable>short_name</replaceable> in a commandline. @short_name must be a printable ASCII character different from '-', or zero if the option has no short name.
 * @flags: Flags from #GOptionFlags.
 * @arg: The type of the option, as a #GOptionArg.
 * @arg_data: If the @arg type is %G_OPTION_ARG_CALLBACK, then @arg_data must point to a #GOptionArgFunc callback function, which will be called to handle the extra argument. Otherwise, @arg_data is a pointer to a location to store the value, the required type of the location depends on the @arg type: <variablelist> <varlistentry> <term>%G_OPTION_ARG_NONE</term> <listitem><para>%gboolean</para></listitem> </varlistentry> <varlistentry> <term>%G_OPTION_ARG_STRING</term> <listitem><para>%gchar*</para></listitem> </varlistentry> <varlistentry> <term>%G_OPTION_ARG_INT</term> <listitem><para>%gint</para></listitem> </varlistentry> <varlistentry> <term>%G_OPTION_ARG_FILENAME</term> <listitem><para>%gchar*</para></listitem> </varlistentry> <varlistentry> <term>%G_OPTION_ARG_STRING_ARRAY</term> <listitem><para>%gchar**</para></listitem> </varlistentry> <varlistentry> <term>%G_OPTION_ARG_FILENAME_ARRAY</term> <listitem><para>%gchar**</para></listitem> </varlistentry> <varlistentry> <term>%G_OPTION_ARG_DOUBLE</term> <listitem><para>%gdouble</para></listitem> </varlistentry> </variablelist> If @arg type is %G_OPTION_ARG_STRING or %G_OPTION_ARG_FILENAME the location will contain a newly allocated string if the option was given. That string needs to be freed by the callee using g_free(). Likewise if @arg type is %G_OPTION_ARG_STRING_ARRAY or %G_OPTION_ARG_FILENAME_ARRAY, the data should be freed using g_strfreev().
 * @description: the description for the option in <option>--help</option> output. The @description is translated using the @translate_func of the group, see g_option_group_set_translation_domain().
 * @arg_description: The placeholder to use for the extra argument parsed by the option in <option>--help</option> output. The @arg_description is translated using the @translate_func of the group, see g_option_group_set_translation_domain().
 *
 * A <structname>GOptionEntry</structname> defines a single option.
 * To have an effect, they must be added to a #GOptionGroup with
 * g_option_context_add_main_entries() or g_option_group_add_entries().
 */


/**
 * GOptionError:
 * @G_OPTION_ERROR_UNKNOWN_OPTION: An option was not known to the parser. This error will only be reported, if the parser hasn't been instructed to ignore unknown options, see g_option_context_set_ignore_unknown_options().
 * @G_OPTION_ERROR_BAD_VALUE: A value couldn't be parsed.
 * @G_OPTION_ERROR_FAILED: A #GOptionArgFunc callback failed.
 *
 * Error codes returned by option parsing.
 */


/**
 * GOptionErrorFunc:
 * @context: The active #GOptionContext
 * @group: The group to which the function belongs
 * @data: User data added to the #GOptionGroup containing the option when it was created with g_option_group_new()
 * @error: The #GError containing details about the parse error
 *
 * The type of function to be used as callback when a parse error occurs.
 */


/**
 * GOptionFlags:
 * @G_OPTION_FLAG_HIDDEN: The option doesn't appear in <option>--help</option> output.
 * @G_OPTION_FLAG_IN_MAIN: The option appears in the main section of the <option>--help</option> output, even if it is defined in a group.
 * @G_OPTION_FLAG_REVERSE: For options of the %G_OPTION_ARG_NONE kind, this flag indicates that the sense of the option is reversed.
 * @G_OPTION_FLAG_NO_ARG: For options of the %G_OPTION_ARG_CALLBACK kind, this flag indicates that the callback does not take any argument (like a %G_OPTION_ARG_NONE option). Since 2.8
 * @G_OPTION_FLAG_FILENAME: For options of the %G_OPTION_ARG_CALLBACK kind, this flag indicates that the argument should be passed to the callback in the GLib filename encoding rather than UTF-8. Since 2.8
 * @G_OPTION_FLAG_OPTIONAL_ARG: For options of the %G_OPTION_ARG_CALLBACK kind, this flag indicates that the argument supply is optional. If no argument is given then data of %GOptionParseFunc will be set to NULL. Since 2.8
 * @G_OPTION_FLAG_NOALIAS: This flag turns off the automatic conflict resolution which prefixes long option names with <literal>groupname-</literal> if there is a conflict. This option should only be used in situations where aliasing is necessary to model some legacy commandline interface. It is not safe to use this option, unless all option groups are under your direct control. Since 2.8.
 *
 * Flags which modify individual options.
 */


/**
 * GOptionGroup:
 *
 * A <structname>GOptionGroup</structname> struct defines the options in a single
 * group. The struct has only private fields and should not be directly accessed.
 *
 * All options in a group share the same translation function. Libraries which
 * need to parse commandline options are expected to provide a function for
 * getting a <structname>GOptionGroup</structname> holding their options, which
 * the application can then add to its #GOptionContext.
 */


/**
 * GOptionParseFunc:
 * @context: The active #GOptionContext
 * @group: The group to which the function belongs
 * @data: User data added to the #GOptionGroup containing the option when it was created with g_option_group_new()
 * @error: A return location for error details
 *
 * The type of function that can be called before and after parsing.
 *
 * occurred, in which case @error should be set with g_set_error()
 *
 * Returns: %TRUE if the function completed successfully, %FALSE if an error
 */


/**
 * GOutputStream:
 *
 * Base class for writing output.
 *
 * All classes derived from GOutputStream should implement synchronous
 * writing, splicing, flushing and closing streams, but may implement
 * asynchronous versions.
 */


/**
 * GOutputStreamSpliceFlags:
 * @G_OUTPUT_STREAM_SPLICE_NONE: Do not close either stream.
 * @G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE: Close the source stream after the splice.
 * @G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET: Close the target stream after the splice.
 *
 * GOutputStreamSpliceFlags determine how streams should be spliced.
 */


/**
 * GOutputVector:
 * @buffer: Pointer to a buffer of data to read.
 * @size: the size of @buffer.
 *
 * Structure used for scatter/gather data output.
 * You generally pass in an array of #GOutputVector<!-- -->s
 * and the operation will use all the buffers as if they were
 * one buffer.
 *
 * Since: 2.22
 */


/**
 * GParamFlags:
 * @G_PARAM_READABLE: the parameter is readable
 * @G_PARAM_WRITABLE: the parameter is writable
 * @G_PARAM_CONSTRUCT: the parameter will be set upon object construction
 * @G_PARAM_CONSTRUCT_ONLY: the parameter will only be set upon object construction
 * @G_PARAM_LAX_VALIDATION: upon parameter conversion (see g_param_value_convert()) strict validation is not required
 * @G_PARAM_STATIC_NAME: the string used as name when constructing the parameter is guaranteed to remain valid and unmodified for the lifetime of the parameter. Since 2.8
 * @G_PARAM_STATIC_NICK: the string used as nick when constructing the parameter is guaranteed to remain valid and unmmodified for the lifetime of the parameter. Since 2.8
 * @G_PARAM_STATIC_BLURB: the string used as blurb when constructing the parameter is guaranteed to remain valid and unmodified for the lifetime of the parameter. Since 2.8
 * @G_PARAM_PRIVATE: internal
 * @G_PARAM_DEPRECATED: the parameter is deprecated and will be removed in a future version. A warning will be generated if it is used while running with G_ENABLE_DIAGNOSTIC=1. Since: 2.26
 *
 * Through the #GParamFlags flag values, certain aspects of parameters
 * can be configured.
 */


/**
 * GParamSpec:
 * @g_type_instance: private #GTypeInstance portion
 * @name: name of this parameter: always an interned string
 * @flags: #GParamFlags flags for this parameter
 * @value_type: the #GValue type for this parameter
 * @owner_type: #GType type that uses (introduces) this parameter
 *
 * All other fields of the <structname>GParamSpec</structname> struct are private and
 * should not be used directly.
 */


/**
 * GParamSpecBoolean:
 * @parent_instance: private #GParamSpec portion
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for boolean properties.
 */


/**
 * GParamSpecBoxed:
 * @parent_instance: private #GParamSpec portion
 *
 * A #GParamSpec derived structure that contains the meta data for boxed properties.
 */


/**
 * GParamSpecChar:
 * @parent_instance: private #GParamSpec portion
 * @minimum: minimum value for the property specified
 * @maximum: maximum value for the property specified
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for character properties.
 */


/**
 * GParamSpecClass:
 * @g_type_class: the parent class
 * @value_type: the #GValue type for this parameter
 * @finalize: The instance finalization function (optional), should chain up to the finalize method of the parent class.
 * @value_set_default: Resets a @value to the default value for this type (recommended, the default is g_value_reset()), see g_param_value_set_default().
 * @value_validate: Ensures that the contents of @value comply with the specifications set out by this type (optional), see g_param_value_validate().
 * @values_cmp: Compares @value1 with @value2 according to this type (recommended, the default is memcmp()), see g_param_values_cmp().
 *
 * The class structure for the <structname>GParamSpec</structname> type.
 * Normally, <structname>GParamSpec</structname> classes are filled by
 * g_param_type_register_static().
 */


/**
 * GParamSpecDouble:
 * @parent_instance: private #GParamSpec portion
 * @minimum: minimum value for the property specified
 * @maximum: maximum value for the property specified
 * @default_value: default value for the property specified
 * @epsilon: values closer than @epsilon will be considered identical by g_param_values_cmp(); the default value is 1e-90.
 *
 * A #GParamSpec derived structure that contains the meta data for double properties.
 */


/**
 * GParamSpecEnum:
 * @parent_instance: private #GParamSpec portion
 * @enum_class: the #GEnumClass for the enum
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for enum
 * properties.
 */


/**
 * GParamSpecFlags:
 * @parent_instance: private #GParamSpec portion
 * @flags_class: the #GFlagsClass for the flags
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for flags
 * properties.
 */


/**
 * GParamSpecFloat:
 * @parent_instance: private #GParamSpec portion
 * @minimum: minimum value for the property specified
 * @maximum: maximum value for the property specified
 * @default_value: default value for the property specified
 * @epsilon: values closer than @epsilon will be considered identical by g_param_values_cmp(); the default value is 1e-30.
 *
 * A #GParamSpec derived structure that contains the meta data for float properties.
 */


/**
 * GParamSpecGType:
 * @parent_instance: private #GParamSpec portion
 * @is_a_type: a #GType whose subtypes can occur as values
 *
 * A #GParamSpec derived structure that contains the meta data for #GType properties.
 *
 * Since: 2.10
 */


/**
 * GParamSpecInt:
 * @parent_instance: private #GParamSpec portion
 * @minimum: minimum value for the property specified
 * @maximum: maximum value for the property specified
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for integer properties.
 */


/**
 * GParamSpecInt64:
 * @parent_instance: private #GParamSpec portion
 * @minimum: minimum value for the property specified
 * @maximum: maximum value for the property specified
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for 64bit integer properties.
 */


/**
 * GParamSpecLong:
 * @parent_instance: private #GParamSpec portion
 * @minimum: minimum value for the property specified
 * @maximum: maximum value for the property specified
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for long integer properties.
 */


/**
 * GParamSpecObject:
 * @parent_instance: private #GParamSpec portion
 *
 * A #GParamSpec derived structure that contains the meta data for object properties.
 */


/**
 * GParamSpecOverride:
 *
 * This is a type of #GParamSpec type that simply redirects operations to
 * another paramspec.  All operations other than getting or
 * setting the value are redirected, including accessing the nick and
 * blurb, validating a value, and so forth. See
 * g_param_spec_get_redirect_target() for retrieving the overidden
 * property. #GParamSpecOverride is used in implementing
 * g_object_class_override_property(), and will not be directly useful
 * unless you are implementing a new base type similar to GObject.
 *
 * Since: 2.4
 */


/**
 * GParamSpecParam:
 * @parent_instance: private #GParamSpec portion
 *
 * A #GParamSpec derived structure that contains the meta data for %G_TYPE_PARAM
 * properties.
 */


/**
 * GParamSpecPointer:
 * @parent_instance: private #GParamSpec portion
 *
 * A #GParamSpec derived structure that contains the meta data for pointer properties.
 */


/**
 * GParamSpecString:
 * @parent_instance: private #GParamSpec portion
 * @default_value: default value for the property specified
 * @cset_first: a string containing the allowed values for the first byte
 * @cset_nth: a string containing the allowed values for the subsequent bytes
 * @substitutor: the replacement byte for bytes which don't match @cset_first or @cset_nth.
 * @null_fold_if_empty: replace empty string by %NULL
 * @ensure_non_null: replace %NULL strings by an empty string
 *
 * A #GParamSpec derived structure that contains the meta data for string
 * properties.
 */


/**
 * GParamSpecTypeInfo:
 * @instance_size: Size of the instance (object) structure.
 * @n_preallocs: Prior to GLib 2.10, it specified the number of pre-allocated (cached) instances to reserve memory for (0 indicates no caching). Since GLib 2.10, it is ignored, since instances are allocated with the <link linkend="glib-Memory-Slices">slice allocator</link> now.
 * @instance_init: Location of the instance initialization function (optional).
 * @value_type: The #GType of values conforming to this #GParamSpec
 * @finalize: The instance finalization function (optional).
 * @value_set_default: Resets a @value to the default value for @pspec (recommended, the default is g_value_reset()), see g_param_value_set_default().
 * @value_validate: Ensures that the contents of @value comply with the specifications set out by @pspec (optional), see g_param_value_validate().
 * @values_cmp: Compares @value1 with @value2 according to @pspec (recommended, the default is memcmp()), see g_param_values_cmp().
 *
 * This structure is used to provide the type system with the information
 * required to initialize and destruct (finalize) a parameter's class and
 * instances thereof.
 * The initialized structure is passed to the g_param_type_register_static()
 * The type system will perform a deep copy of this structure, so its memory
 * does not need to be persistent across invocation of
 * g_param_type_register_static().
 */


/**
 * GParamSpecUChar:
 * @parent_instance: private #GParamSpec portion
 * @minimum: minimum value for the property specified
 * @maximum: maximum value for the property specified
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for unsigned character properties.
 */


/**
 * GParamSpecUInt:
 * @parent_instance: private #GParamSpec portion
 * @minimum: minimum value for the property specified
 * @maximum: maximum value for the property specified
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for unsigned integer properties.
 */


/**
 * GParamSpecUInt64:
 * @parent_instance: private #GParamSpec portion
 * @minimum: minimum value for the property specified
 * @maximum: maximum value for the property specified
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for unsigned 64bit integer properties.
 */


/**
 * GParamSpecULong:
 * @parent_instance: private #GParamSpec portion
 * @minimum: minimum value for the property specified
 * @maximum: maximum value for the property specified
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for unsigned long integer properties.
 */


/**
 * GParamSpecUnichar:
 * @parent_instance: private #GParamSpec portion
 * @default_value: default value for the property specified
 *
 * A #GParamSpec derived structure that contains the meta data for unichar (unsigned integer) properties.
 */


/**
 * GParamSpecValueArray:
 * @parent_instance: private #GParamSpec portion
 * @element_spec: a #GParamSpec describing the elements contained in arrays of this property, may be %NULL
 * @fixed_n_elements: if greater than 0, arrays of this property will always have this many elements
 *
 * A #GParamSpec derived structure that contains the meta data for #GValueArray properties.
 */


/**
 * GParamSpecVariant:
 * @parent_instance: private #GParamSpec portion
 * @type: a #GVariantType, or %NULL
 * @default_value: a #GVariant, or %NULL
 *
 * A #GParamSpec derived structure that contains the meta data for #GVariant properties.
 *
 * Since: 2.26
 */


/**
 * GParameter:
 * @name: the parameter name
 * @value: the parameter value
 *
 * The <structname>GParameter</structname> struct is an auxiliary structure used
 * to hand parameter name/value pairs to g_object_newv().
 */


/**
 * GPasswordSave:
 * @G_PASSWORD_SAVE_NEVER: never save a password.
 * @G_PASSWORD_SAVE_FOR_SESSION: save a password for the session.
 * @G_PASSWORD_SAVE_PERMANENTLY: save a password permanently.
 *
 * #GPasswordSave is used to indicate the lifespan of a saved password.
 *
 * #Gvfs stores passwords in the Gnome keyring when this flag allows it
 * to, and later retrieves it again from there.
 */


/**
 * GPermission:
 *
 * #GPermission is an opaque data structure and can only be accessed
 * using the following functions.
 */


/**
 * GPermission:allowed:
 *
 * %TRUE if the caller currently has permission to perform the action that
 * @permission represents the permission to perform.
 */


/**
 * GPermission:can-acquire:
 *
 * %TRUE if it is generally possible to acquire the permission by calling
 * g_permission_acquire().
 */


/**
 * GPermission:can-release:
 *
 * %TRUE if it is generally possible to release the permission by calling
 * g_permission_release().
 */


/**
 * GPid:
 *
 * A type which is used to hold a process identification.
 *
 * On UNIX, processes are identified by a process id (an integer),
 * while Windows uses process handles (which are pointers).
 */


/**
 * GPollFD:
 * @fd: the file descriptor to poll (or a <type>HANDLE</type> on Win32)
 * @events: a bitwise combination from #GIOCondition, specifying which events should be polled for. Typically for reading from a file descriptor you would use %G_IO_IN | %G_IO_HUP | %G_IO_ERR, and for writing you would use %G_IO_OUT | %G_IO_ERR.
 * @revents: a bitwise combination of flags from #GIOCondition, returned from the poll() function to indicate which events occurred.
 *
 * Represents a file descriptor, which events to poll for, and which events
 * occurred.
 */


/**
 * GPollFunc:
 * @ufds: an array of #GPollFD elements
 * @nfsd: the number of elements in @ufds
 * @timeout_: the maximum time to wait for an event of the file descriptors. A negative value indicates an infinite timeout.
 *
 * Specifies the type of function passed to g_main_context_set_poll_func().
 * The semantics of the function should match those of the poll() system call.
 *
 * reported, or -1 if an error occurred.
 *
 * Returns: the number of #GPollFD elements which have events or errors
 */


/**
 * GPollableInputStream:
 *
 * An interface for a #GInputStream that can be polled for readability.
 *
 * Since: 2.28
 */


/**
 * GPollableInputStreamInterface:
 * @g_iface: The parent interface.
 * @can_poll: Checks if the #GPollableInputStream instance is actually pollable
 * @is_readable: Checks if the stream is readable
 * @create_source: Creates a #GSource to poll the stream
 * @read_nonblocking: Does a non-blocking read or returns %G_IO_ERROR_WOULD_BLOCK
 *
 * The interface for pollable input streams.
 *
 * The default implementation of @can_poll always returns %TRUE.
 *
 * The default implementation of @read_nonblocking calls
 * g_pollable_input_stream_is_readable(), and then calls
 * g_input_stream_read() if it returns %TRUE. This means you only need
 * to override it if it is possible that your @is_readable
 * implementation may return %TRUE when the stream is not actually
 * readable.
 *
 * Since: 2.28
 */


/**
 * GPollableOutputStream:
 *
 * An interface for a #GOutputStream that can be polled for readability.
 *
 * Since: 2.28
 */


/**
 * GPollableOutputStreamInterface:
 * @g_iface: The parent interface.
 * @can_poll: Checks if the #GPollableOutputStream instance is actually pollable
 * @is_writable: Checks if the stream is writable
 * @create_source: Creates a #GSource to poll the stream
 * @write_nonblocking: Does a non-blocking write or returns %G_IO_ERROR_WOULD_BLOCK
 *
 * The interface for pollable output streams.
 *
 * The default implementation of @can_poll always returns %TRUE.
 *
 * The default implementation of @write_nonblocking calls
 * g_pollable_output_stream_is_writable(), and then calls
 * g_output_stream_write() if it returns %TRUE. This means you only
 * need to override it if it is possible that your @is_writable
 * implementation may return %TRUE when the stream is not actually
 * writable.
 *
 * Since: 2.28
 */


/**
 * GPollableSourceFunc:
 * @pollable_stream: the #GPollableInputStream or #GPollableOutputStream
 * @user_data: data passed in by the user.
 *
 * This is the function type of the callback used for the #GSource
 * returned by g_pollable_input_stream_create_source() and
 * g_pollable_output_stream_create_source().
 *
 * Returns: it should return %FALSE if the source should be removed.
 * Since: 2.28
 */


/**
 * GPrintFunc:
 * @string: the message to output
 *
 * Specifies the type of the print handler functions.
 * These are called with the complete formatted string to output.
 */


/**
 * GProxy:
 *
 * Interface that handles proxy connection and payload.
 *
 * Since: 2.26
 */


/**
 * GProxyAddress:
 *
 * A #GInetSocketAddress representing a connection via a proxy server
 *
 * Since: 2.26
 */


/**
 * GProxyAddressEnumerator:
 *
 * A subclass of #GSocketAddressEnumerator that takes another address
 * enumerator and wraps its results in #GProxyAddress<!-- -->es as
 * directed by the default #GProxyResolver.
 */


/**
 * GProxyInterface:
 * @g_iface: The parent interface.
 * @connect: Connect to proxy server and wrap (if required) the #connection to handle payload.
 * @connect_async: Same has connect() but asynchronous.
 * @connect_finish: Returns the result of connect_async()
 *
 * Provides an interface for handling proxy connection and payload.
 *
 * Since: 2.26
 */


/**
 * GProxyResolver:
 *
 * Interface that can be used to resolve proxy address.
 */


/**
 * GQueue:
 * @head: a pointer to the first element of the queue
 * @tail: a pointer to the last element of the queue
 * @length: the number of elements in the queue
 *
 * Contains the public fields of a
 * <link linkend="glib-Double-ended-Queues">Queue</link>.
 */


/**
 * GReallocFunc:
 * @data: memory block to reallocate
 * @size: size to reallocate @data to
 *
 * Changes the size of the memory block pointed to by @data to
 * @size bytes.
 *
 * The function should have the same semantics as realloc().
 *
 * Returns: a pointer to the reallocated memory
 */


/**
 * GRegex:
 *
 * A GRegex is the "compiled" form of a regular expression pattern. This
 * structure is opaque and its fields cannot be accessed directly.
 *
 * Since: 2.14
 */


/**
 * GRegexCompileFlags:
 * @G_REGEX_CASELESS: Letters in the pattern match both upper- and lowercase letters. This option can be changed within a pattern by a "(?i)" option setting.
 * @G_REGEX_MULTILINE: By default, GRegex treats the strings as consisting of a single line of characters (even if it actually contains newlines). The "start of line" metacharacter ("^") matches only at the start of the string, while the "end of line" metacharacter ("$") matches only at the end of the string, or before a terminating newline (unless #G_REGEX_DOLLAR_ENDONLY is set). When #G_REGEX_MULTILINE is set, the "start of line" and "end of line" constructs match immediately following or immediately before any newline in the string, respectively, as well as at the very start and end. This can be changed within a pattern by a "(?m)" option setting.
 * @G_REGEX_DOTALL: A dot metacharater (".") in the pattern matches all characters, including newlines. Without it, newlines are excluded. This option can be changed within a pattern by a ("?s") option setting.
 * @G_REGEX_EXTENDED: Whitespace data characters in the pattern are totally ignored except when escaped or inside a character class. Whitespace does not include the VT character (code 11). In addition, characters between an unescaped "#" outside a character class and the next newline character, inclusive, are also ignored. This can be changed within a pattern by a "(?x)" option setting.
 * @G_REGEX_ANCHORED: The pattern is forced to be "anchored", that is, it is constrained to match only at the first matching point in the string that is being searched. This effect can also be achieved by appropriate constructs in the pattern itself such as the "^" metacharater.
 * @G_REGEX_DOLLAR_ENDONLY: A dollar metacharacter ("$") in the pattern matches only at the end of the string. Without this option, a dollar also matches immediately before the final character if it is a newline (but not before any other newlines). This option is ignored if #G_REGEX_MULTILINE is set.
 * @G_REGEX_UNGREEDY: Inverts the "greediness" of the quantifiers so that they are not greedy by default, but become greedy if followed by "?". It can also be set by a "(?U)" option setting within the pattern.
 * @G_REGEX_RAW: Usually strings must be valid UTF-8 strings, using this flag they are considered as a raw sequence of bytes. @G_REGEX_NO_AUTO_CAPTURE: Disables the use of numbered capturing parentheses in the pattern. Any opening parenthesis that is not followed by "?" behaves as if it were followed by "?:" but named parentheses can still be used for capturing (and they acquire numbers in the usual way).
 * @G_REGEX_OPTIMIZE: Optimize the regular expression. If the pattern will be used many times, then it may be worth the effort to optimize it to improve the speed of matches.
 * @G_REGEX_DUPNAMES: Names used to identify capturing subpatterns need not be unique. This can be helpful for certain types of pattern when it is known that only one instance of the named subpattern can ever be matched.
 * @G_REGEX_NEWLINE_CR: Usually any newline character is recognized, if this option is set, the only recognized newline character is '\r'.
 * @G_REGEX_NEWLINE_LF: Usually any newline character is recognized, if this option is set, the only recognized newline character is '\n'.
 * @G_REGEX_NEWLINE_CRLF: Usually any newline character is recognized, if this option is set, the only recognized newline character sequence is '\r\n'.
 *
 * Flags specifying compile-time options.
 *
 * Since: 2.14
 */


/**
 * GRegexError:
 * @G_REGEX_ERROR_COMPILE: Compilation of the regular expression failed.
 * @G_REGEX_ERROR_OPTIMIZE: Optimization of the regular expression failed.
 * @G_REGEX_ERROR_REPLACE: Replacement failed due to an ill-formed replacement string.
 * @G_REGEX_ERROR_MATCH: The match process failed.
 * @G_REGEX_ERROR_INTERNAL: Internal error of the regular expression engine. Since 2.16
 * @G_REGEX_ERROR_STRAY_BACKSLASH: "\\" at end of pattern. Since 2.16
 * @G_REGEX_ERROR_MISSING_CONTROL_CHAR: "\\c" at end of pattern. Since 2.16
 * @G_REGEX_ERROR_UNRECOGNIZED_ESCAPE: Unrecognized character follows "\\". Since 2.16
 * @G_REGEX_ERROR_QUANTIFIERS_OUT_OF_ORDER: Numbers out of order in "{}" quantifier. Since 2.16
 * @G_REGEX_ERROR_QUANTIFIER_TOO_BIG: Number too big in "{}" quantifier. Since 2.16
 * @G_REGEX_ERROR_UNTERMINATED_CHARACTER_CLASS: Missing terminating "]" for character class. Since 2.16
 * @G_REGEX_ERROR_INVALID_ESCAPE_IN_CHARACTER_CLASS: Invalid escape sequence in character class. Since 2.16
 * @G_REGEX_ERROR_RANGE_OUT_OF_ORDER: Range out of order in character class. Since 2.16
 * @G_REGEX_ERROR_NOTHING_TO_REPEAT: Nothing to repeat. Since 2.16
 * @G_REGEX_ERROR_UNRECOGNIZED_CHARACTER: Unrecognized character after "(?", "(?&lt;" or "(?P". Since 2.16
 * @G_REGEX_ERROR_POSIX_NAMED_CLASS_OUTSIDE_CLASS: POSIX named classes are supported only within a class. Since 2.16
 * @G_REGEX_ERROR_UNMATCHED_PARENTHESIS: Missing terminating ")" or ")" without opening "(". Since 2.16
 * @G_REGEX_ERROR_INEXISTENT_SUBPATTERN_REFERENCE: Reference to non-existent subpattern. Since 2.16
 * @G_REGEX_ERROR_UNTERMINATED_COMMENT: Missing terminating ")" after comment. Since 2.16
 * @G_REGEX_ERROR_EXPRESSION_TOO_LARGE: Regular expression too large. Since 2.16
 * @G_REGEX_ERROR_MEMORY_ERROR: Failed to get memory. Since 2.16
 * @G_REGEX_ERROR_VARIABLE_LENGTH_LOOKBEHIND: Lookbehind assertion is not fixed length. Since 2.16
 * @G_REGEX_ERROR_MALFORMED_CONDITION: Malformed number or name after "(?(". Since 2.16
 * @G_REGEX_ERROR_TOO_MANY_CONDITIONAL_BRANCHES: Conditional group contains more than two branches. Since 2.16
 * @G_REGEX_ERROR_ASSERTION_EXPECTED: Assertion expected after "(?(". Since 2.16
 * @G_REGEX_ERROR_UNKNOWN_POSIX_CLASS_NAME: Unknown POSIX class name. Since 2.16
 * @G_REGEX_ERROR_POSIX_COLLATING_ELEMENTS_NOT_SUPPORTED: POSIX collating elements are not supported. Since 2.16
 * @G_REGEX_ERROR_HEX_CODE_TOO_LARGE: Character value in "\\x{...}" sequence is too large. Since 2.16
 * @G_REGEX_ERROR_INVALID_CONDITION: Invalid condition "(?(0)". Since 2.16
 * @G_REGEX_ERROR_SINGLE_BYTE_MATCH_IN_LOOKBEHIND: \\C not allowed in lookbehind assertion. Since 2.16
 * @G_REGEX_ERROR_INFINITE_LOOP: Recursive call could loop indefinitely. Since 2.16
 * @G_REGEX_ERROR_MISSING_SUBPATTERN_NAME_TERMINATOR: Missing terminator in subpattern name. Since 2.16
 * @G_REGEX_ERROR_DUPLICATE_SUBPATTERN_NAME: Two named subpatterns have the same name. Since 2.16
 * @G_REGEX_ERROR_MALFORMED_PROPERTY: Malformed "\\P" or "\\p" sequence. Since 2.16
 * @G_REGEX_ERROR_UNKNOWN_PROPERTY: Unknown property name after "\\P" or "\\p". Since 2.16
 * @G_REGEX_ERROR_SUBPATTERN_NAME_TOO_LONG: Subpattern name is too long (maximum 32 characters). Since 2.16
 * @G_REGEX_ERROR_TOO_MANY_SUBPATTERNS: Too many named subpatterns (maximum 10,000). Since 2.16
 * @G_REGEX_ERROR_INVALID_OCTAL_VALUE: Octal value is greater than "\\377". Since 2.16
 * @G_REGEX_ERROR_TOO_MANY_BRANCHES_IN_DEFINE: "DEFINE" group contains more than one branch. Since 2.16
 * @G_REGEX_ERROR_DEFINE_REPETION: Repeating a "DEFINE" group is not allowed. Since 2.16
 * @G_REGEX_ERROR_INCONSISTENT_NEWLINE_OPTIONS: Inconsistent newline options. Since 2.16
 * @G_REGEX_ERROR_MISSING_BACK_REFERENCE: "\\g" is not followed by a braced name or an optionally braced non-zero number. Since 2.16
 *
 * Error codes returned by regular expressions functions.
 *
 * Since: 2.14
 */


/**
 * GRegexEvalCallback:
 * @match_info: the #GMatchInfo generated by the match. Use g_match_info_get_regex() and g_match_info_get_string() if you need the #GRegex or the matched string.
 * @result: a #GString containing the new string
 * @user_data: user data passed to g_regex_replace_eval()
 *
 * Specifies the type of the function passed to g_regex_replace_eval().
 * It is called for each occurrence of the pattern in the string passed
 * to g_regex_replace_eval(), and it should append the replacement to
 * @result.
 *
 * Returns: %FALSE to continue the replacement process, %TRUE to stop it
 * Since: 2.14
 */


/**
 * GRegexMatchFlags:
 * @G_REGEX_MATCH_ANCHORED: The pattern is forced to be "anchored", that is, it is constrained to match only at the first matching point in the string that is being searched. This effect can also be achieved by appropriate constructs in the pattern itself such as the "^" metacharater.
 * @G_REGEX_MATCH_NOTBOL: Specifies that first character of the string is not the beginning of a line, so the circumflex metacharacter should not match before it. Setting this without #G_REGEX_MULTILINE (at compile time) causes circumflex never to match. This option affects only the behaviour of the circumflex metacharacter, it does not affect "\A".
 * @G_REGEX_MATCH_NOTEOL: Specifies that the end of the subject string is not the end of a line, so the dollar metacharacter should not match it nor (except in multiline mode) a newline immediately before it. Setting this without #G_REGEX_MULTILINE (at compile time) causes dollar never to match. This option affects only the behaviour of the dollar metacharacter, it does not affect "\Z" or "\z".
 * @G_REGEX_MATCH_NOTEMPTY: An empty string is not considered to be a valid match if this option is set. If there are alternatives in the pattern, they are tried. If all the alternatives match the empty string, the entire match fails. For example, if the pattern "a?b?" is applied to a string not beginning with "a" or "b", it matches the empty string at the start of the string. With this flag set, this match is not valid, so GRegex searches further into the string for occurrences of "a" or "b".
 * @G_REGEX_MATCH_PARTIAL: Turns on the partial matching feature, for more documentation on partial matching see g_match_info_is_partial_match().
 * @G_REGEX_MATCH_NEWLINE_CR: Overrides the newline definition set when creating a new #GRegex, setting the '\r' character as line terminator.
 * @G_REGEX_MATCH_NEWLINE_LF: Overrides the newline definition set when creating a new #GRegex, setting the '\n' character as line terminator.
 * @G_REGEX_MATCH_NEWLINE_CRLF: Overrides the newline definition set when creating a new #GRegex, setting the '\r\n' characters as line terminator.
 * @G_REGEX_MATCH_NEWLINE_ANY: Overrides the newline definition set when creating a new #GRegex, any newline character or character sequence is recognized.
 *
 * Flags specifying match-time options.
 *
 * Since: 2.14
 */


/**
 * GRemoteActionGroupInterface:
 * @activate_action_full: the virtual function pointer for g_remote_action_group_activate_action_full()
 * @change_action_state_full: the virtual function pointer for g_remote_action_group_change_action_state_full()
 *
 * The virtual function table for #GRemoteActionGroup.
 *
 * Since: 2.32
 */


/**
 * GResolver:
 *
 * The object that handles DNS resolution. Use g_resolver_get_default()
 * to get the default resolver.
 */


/**
 * GResolver::reload:
 * @resolver: a #GResolver
 *
 * Emitted when the resolver notices that the system resolver
 * configuration has changed.
 */


/**
 * GResolverError:
 * @G_RESOLVER_ERROR_NOT_FOUND: the requested name/address/service was not found
 * @G_RESOLVER_ERROR_TEMPORARY_FAILURE: the requested information could not be looked up due to a network error or similar problem
 * @G_RESOLVER_ERROR_INTERNAL: unknown error
 *
 * An error code used with %G_RESOLVER_ERROR in a #GError returned
 * from a #GResolver routine.
 *
 * Since: 2.22
 */


/**
 * GSeekable:
 *
 * Seek object for streaming operations.
 */


/**
 * GSeekableIface:
 * @g_iface: The parent interface.
 * @tell: Tells the current location within a stream.
 * @can_seek: Checks if seeking is supported by the stream.
 * @seek: Seeks to a location within a stream.
 * @can_truncate: Chekcs if truncation is suppored by the stream.
 * @truncate_fn: Truncates a stream.
 *
 * Provides an interface for implementing seekable functionality on I/O Streams.
 */


/**
 * GSettings::change-event:
 * @settings: the object on which the signal was emitted
 * @keys: (array length=n_keys) (element-type GQuark) (allow-none):  an array of #GQuark<!-- -->s for the changed keys, or %NULL
 * @n_keys: the length of the @keys array, or 0
 *
 * The "change-event" signal is emitted once per change event that
 * affects this settings object.  You should connect to this signal
 * only if you are interested in viewing groups of changes before they
 * are split out into multiple emissions of the "changed" signal.
 * For most use cases it is more appropriate to use the "changed" signal.
 *
 * In the event that the change event applies to one or more specified
 * keys, @keys will be an array of #GQuark of length @n_keys.  In the
 * event that the change event applies to the #GSettings object as a
 * whole (ie: potentially every key has been changed) then @keys will
 * be %NULL and @n_keys will be 0.
 *
 * The default handler for this signal invokes the "changed" signal
 * for each affected key.  If any other connected handler returns
 * %TRUE then this default functionality will be suppressed.
 *
 * event. FALSE to propagate the event further.
 *
 * Returns: %TRUE to stop other handlers from being invoked for the
 */


/**
 * GSettings::changed:
 * @settings: the object on which the signal was emitted
 * @key: the name of the key that changed
 *
 * The "changed" signal is emitted when a key has potentially changed.
 * You should call one of the g_settings_get() calls to check the new
 * value.
 *
 * This signal supports detailed connections.  You can connect to the
 * detailed signal "changed::x" in order to only receive callbacks
 * when key "x" changes.
 */


/**
 * GSettings::writable-change-event:
 * @settings: the object on which the signal was emitted
 * @key: the quark of the key, or 0
 *
 * The "writable-change-event" signal is emitted once per writability
 * change event that affects this settings object.  You should connect
 * to this signal if you are interested in viewing groups of changes
 * before they are split out into multiple emissions of the
 * "writable-changed" signal.  For most use cases it is more
 * appropriate to use the "writable-changed" signal.
 *
 * In the event that the writability change applies only to a single
 * key, @key will be set to the #GQuark for that key.  In the event
 * that the writability change affects the entire settings object,
 * @key will be 0.
 *
 * The default handler for this signal invokes the "writable-changed"
 * and "changed" signals for each affected key.  This is done because
 * changes in writability might also imply changes in value (if for
 * example, a new mandatory setting is introduced).  If any other
 * connected handler returns %TRUE then this default functionality
 * will be suppressed.
 *
 * event. FALSE to propagate the event further.
 *
 * Returns: %TRUE to stop other handlers from being invoked for the
 */


/**
 * GSettings::writable-changed:
 * @settings: the object on which the signal was emitted
 * @key: the key
 *
 * The "writable-changed" signal is emitted when the writability of a
 * key has potentially changed.  You should call
 * g_settings_is_writable() in order to determine the new status.
 *
 * This signal supports detailed connections.  You can connect to the
 * detailed signal "writable-changed::x" in order to only receive
 * callbacks when the writability of "x" changes.
 */


/**
 * GSettings:context:
 *
 * The name of the context that the settings are stored in.
 */


/**
 * GSettings:delay-apply:
 *
 * Whether the #GSettings object is in 'delay-apply' mode. See
 * g_settings_delay() for details.
 *
 * Since: 2.28
 */


/**
 * GSettings:has-unapplied:
 *
 * If this property is %TRUE, the #GSettings object has outstanding
 * changes that will be applied when g_settings_apply() is called.
 */


/**
 * GSettings:path:
 *
 * The path within the backend where the settings are stored.
 */


/**
 * GSettings:schema:
 *
 * The name of the schema that describes the types of keys
 * for this #GSettings object.
 *
 * The type of this property is *not* #GSettingsSchema.
 * #GSettingsSchema has only existed since version 2.32 and
 * unfortunately this name was used in previous versions to refer to
 * the schema ID rather than the schema itself.  Take care to use the
 * 'settings-schema' property if you wish to pass in a
 * #GSettingsSchema.
 *
 * Deprecated:2.32:Use the 'schema-id' property instead.  In a future
 * version, this property may instead refer to a #GSettingsSchema.
 */


/**
 * GSettings:schema-id:
 *
 * The name of the schema that describes the types of keys
 * for this #GSettings object.
 */


/**
 * GSettings:settings-schema:
 *
 * The #GSettingsSchema describing the types of keys for this
 * #GSettings object.
 *
 * Ideally, this property would be called 'schema'.  #GSettingsSchema
 * has only existed since version 2.32, however, and before then the
 * 'schema' property was used to refer to the ID of the schema rather
 * than the schema itself.  Take care.
 */


/**
 * GSettingsBackend:
 *
 * An implementation of a settings storage repository.
 */


/**
 * GSettingsBindFlags:
 * @G_SETTINGS_BIND_DEFAULT: Equivalent to <literal>G_SETTINGS_BIND_GET|G_SETTINGS_BIND_SET</literal>
 * @G_SETTINGS_BIND_GET: Update the #GObject property when the setting changes. It is an error to use this flag if the property is not writable.
 * @G_SETTINGS_BIND_SET: Update the setting when the #GObject property changes. It is an error to use this flag if the property is not readable.
 * @G_SETTINGS_BIND_NO_SENSITIVITY: Do not try to bind a "sensitivity" property to the writability of the setting
 * @G_SETTINGS_BIND_GET_NO_CHANGES: When set in addition to #G_SETTINGS_BIND_GET, set the #GObject property value initially from the setting, but do not listen for changes of the setting
 * @G_SETTINGS_BIND_INVERT_BOOLEAN: When passed to g_settings_bind(), uses a pair of mapping functions that invert the boolean value when mapping between the setting and the property.  The setting and property must both be booleans.  You cannot pass this flag to g_settings_bind_with_mapping().
 *
 * Flags used when creating a binding. These flags determine in which
 * direction the binding works. The default is to synchronize in both
 * directions.
 */


/**
 * GSettingsBindGetMapping:
 * @value: return location for the property value
 * @variant: the #GVariant
 * @user_data: user data that was specified when the binding was created
 *
 * The type for the function that is used to convert from #GSettings to
 * an object property. The @value is already initialized to hold values
 * of the appropriate type.
 *
 * Returns: %TRUE if the conversion succeeded, %FALSE in case of an error
 */


/**
 * GSettingsBindSetMapping:
 * @value: a #GValue containing the property value to map
 * @expected_type: the #GVariantType to create
 * @user_data: user data that was specified when the binding was created
 *
 * The type for the function that is used to convert an object property
 * value to a #GVariant for storing it in #GSettings.
 *
 * or %NULL in case of an error
 *
 * Returns: a new #GVariant holding the data from @value,
 */


/**
 * GSettingsGetMapping:
 * @value: the #GVariant to map, or %NULL
 * @result: (out): the result of the mapping
 * @user_data: (closure): the user data that was passed to g_settings_get_mapped()
 *
 * The type of the function that is used to convert from a value stored
 * in a #GSettings to a value that is useful to the application.
 *
 * If the value is successfully mapped, the result should be stored at
 * @result and %TRUE returned.  If mapping fails (for example, if @value
 * is not in the right format) then %FALSE should be returned.
 *
 * If @value is %NULL then it means that the mapping function is being
 * given a "last chance" to successfully return a valid value.  %TRUE
 * must be returned in this case.
 *
 * Returns: %TRUE if the conversion succeeded, %FALSE in case of an error
 */


/**
 * GSettingsSchema:
 *
 * This is an opaque structure type.  You may not access it directly.
 *
 * Since: 2.32
 */


/**
 * GSettingsSchemaSource:
 *
 * This is an opaque structure type.  You may not access it directly.
 *
 * Since: 2.32
 */


/**
 * GSignalAccumulator:
 * @ihint: Signal invocation hint, see #GSignalInvocationHint.
 * @return_accu: Accumulator to collect callback return values in, this is the return value of the current signal emission.
 * @handler_return: A #GValue holding the return value of the signal handler.
 * @data: Callback data that was specified when creating the signal.
 *
 * The signal accumulator is a special callback function that can be used
 * to collect return values of the various callbacks that are called
 * during a signal emission. The signal accumulator is specified at signal
 * creation time, if it is left %NULL, no accumulation of callback return
 * values is performed. The return value of signal emissions is then the
 * value returned by the last callback.
 *
 * should be aborted. Returning %FALSE means to abort the
 * current emission and %TRUE is returned for continuation.
 *
 * Returns: The accumulator function returns whether the signal emission
 */


/**
 * GSignalCMarshaller:
 *
 * This is the signature of marshaller functions, required to marshall
 * arrays of parameter values to signal emissions into C language callback
 * invocations. It is merely an alias to #GClosureMarshal since the #GClosure
 * mechanism takes over responsibility of actual function invocation for the
 * signal system.
 */


/**
 * GSignalEmissionHook:
 * @ihint: Signal invocation hint, see #GSignalInvocationHint.
 * @n_param_values: the number of parameters to the function, including the instance on which the signal was emitted.
 * @param_values: (array length=n_param_values): the instance on which the signal was emitted, followed by the parameters of the emission.
 * @data: user data associated with the hook.
 *
 * A simple function pointer to get invoked when the signal is emitted. This
 * allows you to tie a hook to the signal type, so that it will trap all
 * emissions of that signal, from any object.
 *
 * You may not attach these to signals created with the #G_SIGNAL_NO_HOOKS flag.
 *
 * hook is disconnected (and destroyed).
 *
 * Returns: whether it wants to stay connected. If it returns %FALSE, the signal
 */


/**
 * GSignalFlags:
 * @G_SIGNAL_RUN_FIRST: Invoke the object method handler in the first emission stage.
 * @G_SIGNAL_RUN_LAST: Invoke the object method handler in the third emission stage.
 * @G_SIGNAL_RUN_CLEANUP: Invoke the object method handler in the last emission stage.
 * @G_SIGNAL_NO_RECURSE: Signals being emitted for an object while currently being in emission for this very object will not be emitted recursively, but instead cause the first emission to be restarted.
 * @G_SIGNAL_DETAILED: This signal supports "::detail" appendices to the signal name upon handler connections and emissions.
 * @G_SIGNAL_ACTION: Action signals are signals that may freely be emitted on alive objects from user code via g_signal_emit() and friends, without the need of being embedded into extra code that performs pre or post emission adjustments on the object. They can also be thought of as object methods which can be called generically by third-party code.
 * @G_SIGNAL_NO_HOOKS: No emissions hooks are supported for this signal.
 * @G_SIGNAL_MUST_COLLECT: Varargs signal emission will always collect the arguments, even if there are no signal handlers connected.  Since 2.30.
 * @G_SIGNAL_DEPRECATED: The signal is deprecated and will be removed in a future version. A warning will be generated if it is connected while running with G_ENABLE_DIAGNOSTIC=1.  Since 2.32.
 *
 * The signal flags are used to specify a signal's behaviour, the overall
 * signal description outlines how especially the RUN flags control the
 * stages of a signal emission.
 */


/**
 * GSignalInvocationHint:
 * @signal_id: The signal id of the signal invoking the callback
 * @detail: The detail passed on for this emission
 * @run_type: The stage the signal emission is currently in, this field will contain one of %G_SIGNAL_RUN_FIRST, %G_SIGNAL_RUN_LAST or %G_SIGNAL_RUN_CLEANUP.
 *
 * The #GSignalInvocationHint structure is used to pass on additional information
 * to callbacks during a signal emission.
 */


/**
 * GSignalMatchType:
 * @G_SIGNAL_MATCH_ID: The signal id must be equal.
 * @G_SIGNAL_MATCH_DETAIL: The signal detail be equal.
 * @G_SIGNAL_MATCH_CLOSURE: The closure must be the same.
 * @G_SIGNAL_MATCH_FUNC: The C closure callback must be the same.
 * @G_SIGNAL_MATCH_DATA: The closure data must be the same.
 * @G_SIGNAL_MATCH_UNBLOCKED: Only unblocked signals may matched.
 *
 * The match types specify what g_signal_handlers_block_matched(),
 * g_signal_handlers_unblock_matched() and g_signal_handlers_disconnect_matched()
 * match signals by.
 */


/**
 * GSignalQuery:
 * @signal_id: The signal id of the signal being queried, or 0 if the signal to be queried was unknown.
 * @signal_name: The signal name.
 * @itype: The interface/instance type that this signal can be emitted for.
 * @signal_flags: The signal flags as passed in to g_signal_new().
 * @return_type: The return type for user callbacks.
 * @n_params: The number of parameters that user callbacks take.
 * @param_types: The individual parameter types for user callbacks, note that the effective callback signature is: <programlisting> @return_type callback (#gpointer     data1, [param_types param_names,] gpointer     data2); </programlisting>
 *
 * A structure holding in-depth information for a specific signal. It is
 * filled in by the g_signal_query() function.
 */


/**
 * GSimpleAction::activate:
 * @simple: the #GSimpleAction
 * @parameter: (allow-none): the parameter to the activation
 *
 * Indicates that the action was just activated.
 *
 * @parameter will always be of the expected type.  In the event that
 * an incorrect type was given, no signal will be emitted.
 *
 * Since: 2.28
 */


/**
 * GSimpleAction::change-state:
 * @simple: the #GSimpleAction
 * @value: (allow-none): the requested value for the state
 *
 * Indicates that the action just received a request to change its
 * state.
 *
 * @value will always be of the correct state type.  In the event that
 * an incorrect type was given, no signal will be emitted.
 *
 * If no handler is connected to this signal then the default
 * behaviour is to call g_simple_action_set_state() to set the state
 * to the requested value.  If you connect a signal handler then no
 * default action is taken.  If the state should change then you must
 * call g_simple_action_set_state() from the handler.
 *
 * <example>
 * <title>Example 'change-state' handler</title>
 * <programlisting>
 * static void
 * change_volume_state (GSimpleAction *action,
 * GVariant      *value,
 * gpointer       user_data)
 * {
 * gint requested;
 *
 * requested = g_variant_get_int32 (value);
 *
 * // Volume only goes from 0 to 10
 * if (0 <= requested && requested <= 10)
 * g_simple_action_set_state (action, value);
 * }
 * </programlisting>
 * </example>
 *
 * The handler need not set the state to the requested value.  It
 * could set it to any value at all, or take some other action.
 *
 * Since: 2.30
 */


/**
 * GSimpleAction:enabled:
 *
 * If @action is currently enabled.
 *
 * If the action is disabled then calls to g_action_activate() and
 * g_action_change_state() have no effect.
 *
 * Since: 2.28
 */


/**
 * GSimpleAction:name:
 *
 * The name of the action.  This is mostly meaningful for identifying
 * the action once it has been added to a #GSimpleActionGroup.
 *
 * Since: 2.28
 */


/**
 * GSimpleAction:parameter-type:
 *
 * The type of the parameter that must be given when activating the
 * action.
 *
 * Since: 2.28
 */


/**
 * GSimpleAction:state:
 *
 * The state of the action, or %NULL if the action is stateless.
 *
 * Since: 2.28
 */


/**
 * GSimpleAction:state-type:
 *
 * The #GVariantType of the state that the action has, or %NULL if the
 * action is stateless.
 *
 * Since: 2.28
 */


/**
 * GSimpleActionGroup:
 *
 * The #GSimpleActionGroup structure contains private data and should only be accessed using the provided API.
 *
 * Since: 2.28
 */


/**
 * GSimpleAsyncResult:
 *
 * A simple implementation of #GAsyncResult.
 */


/**
 * GSimpleAsyncThreadFunc:
 * @res: a #GSimpleAsyncResult.
 * @object: a #GObject.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 *
 * Simple thread function that runs an asynchronous operation and
 * checks for cancellation.
 */


/**
 * GSimplePermission:
 *
 * #GSimplePermission is an opaque data structure.  There are no methods
 * except for those defined by #GPermission.
 */


/**
 * GSocket:
 *
 * A lowlevel network socket object.
 *
 * Since: 2.22
 */


/**
 * GSocket:timeout:
 *
 * The timeout in seconds on socket I/O
 *
 * Since: 2.26
 */


/**
 * GSocketAddress:
 *
 * A socket endpoint address, corresponding to <type>struct sockaddr</type>
 * or one of its subtypes.
 */


/**
 * GSocketAddressEnumerator:
 *
 * Enumerator type for objects that contain or generate
 * #GSocketAddress<!-- -->es.
 */


/**
 * GSocketClient:
 *
 * A helper class for network servers to listen for and accept connections.
 *
 * Since: 2.22
 */


/**
 * GSocketConnectable:
 *
 * Interface for objects that contain or generate #GSocketAddress<!-- -->es.
 */


/**
 * GSocketConnectableIface:
 * @g_iface: The parent interface.
 * @enumerate: Creates a #GSocketAddressEnumerator
 * @proxy_enumerate: Creates a #GProxyAddressEnumerator
 *
 * Provides an interface for returning a #GSocketAddressEnumerator
 * and #GProxyAddressEnumerator
 */


/**
 * GSocketConnection:
 *
 * A socket connection GIOStream object for connection-oriented sockets.
 *
 * Since: 2.22
 */


/**
 * GSocketControlMessage:
 *
 * Base class for socket-type specific control messages that can be sent and
 * received over #GSocket.
 */


/**
 * GSocketControlMessageClass:
 * @get_size: gets the size of the message.
 * @get_level: gets the protocol of the message.
 * @get_type: gets the protocol specific type of the message.
 * @serialize: Writes out the message data.
 * @deserialize: Tries to deserialize a message.
 *
 *
 */


/**
 * GSocketFamily:
 * @G_SOCKET_FAMILY_INVALID: no address family
 * @G_SOCKET_FAMILY_IPV4: the IPv4 family
 * @G_SOCKET_FAMILY_IPV6: the IPv6 family
 * @G_SOCKET_FAMILY_UNIX: the UNIX domain family
 *
 * The protocol family of a #GSocketAddress. (These values are
 * identical to the system defines %AF_INET, %AF_INET6 and %AF_UNIX,
 * if available.)
 *
 * Since: 2.22
 */


/**
 * GSocketListenerClass:
 * @changed: virtual method called when the set of socket listened to changes
 *
 *
 */


/**
 * GSocketMsgFlags:
 * @G_SOCKET_MSG_NONE: No flags.
 * @G_SOCKET_MSG_OOB: Request to send/receive out of band data.
 * @G_SOCKET_MSG_PEEK: Read data from the socket without removing it from the queue.
 * @G_SOCKET_MSG_DONTROUTE: Don't use a gateway to send out the packet, only send to hosts on directly connected networks.
 *
 * Flags used in g_socket_receive_message() and g_socket_send_message().
 * The flags listed in the enum are some commonly available flags, but the
 * values used for them are the same as on the platform, and any other flags
 * are passed in/out as is. So to use a platform specific flag, just include
 * the right system header and pass in the flag.
 *
 * Since: 2.22
 */


/**
 * GSocketProtocol:
 * @G_SOCKET_PROTOCOL_UNKNOWN: The protocol type is unknown
 * @G_SOCKET_PROTOCOL_DEFAULT: The default protocol for the family/type
 * @G_SOCKET_PROTOCOL_TCP: TCP over IP
 * @G_SOCKET_PROTOCOL_UDP: UDP over IP
 * @G_SOCKET_PROTOCOL_SCTP: SCTP over IP
 *
 * A protocol identifier is specified when creating a #GSocket, which is a
 * family/type specific identifier, where 0 means the default protocol for
 * the particular family/type.
 *
 * This enum contains a set of commonly available and used protocols. You
 * can also pass any other identifiers handled by the platform in order to
 * use protocols not listed here.
 *
 * Since: 2.22
 */


/**
 * GSocketService:
 *
 * A helper class for handling accepting incomming connections in the
 * glib mainloop.
 *
 * Since: 2.22
 */


/**
 * GSocketService::incoming:
 * @service: the #GSocketService
 * @connection: a new #GSocketConnection object
 * @source_object: the source_object passed to g_socket_listener_add_address()
 *
 * The ::incoming signal is emitted when a new incoming connection
 * to @service needs to be handled. The handler must initiate the
 * handling of @connection, but may not block; in essence,
 * asynchronous operations must be used.
 *
 * @connection will be unreffed once the signal handler returns,
 * so you need to ref it yourself if you are planning to use it.
 *
 * Returns: %TRUE to stop other handlers from being called
 * Since: 2.22
 */


/**
 * GSocketServiceClass:
 * @incomming: signal emitted when new connections are accepted
 *
 *
 */


/**
 * GSocketSourceFunc:
 * @socket: the #GSocket
 * @condition: the current condition at the source fired.
 * @user_data: data passed in by the user.
 *
 * This is the function type of the callback used for the #GSource
 * returned by g_socket_create_source().
 *
 * Returns: it should return %FALSE if the source should be removed.
 * Since: 2.22
 */


/**
 * GSocketType:
 * @G_SOCKET_TYPE_INVALID: Type unknown or wrong
 * @G_SOCKET_TYPE_STREAM: Reliable connection-based byte streams (e.g. TCP).
 * @G_SOCKET_TYPE_DATAGRAM: Connectionless, unreliable datagram passing. (e.g. UDP)
 * @G_SOCKET_TYPE_SEQPACKET: Reliable connection-based passing of datagrams of fixed maximum length (e.g. SCTP).
 *
 * Flags used when creating a #GSocket. Some protocols may not implement
 * all the socket types.
 *
 * Since: 2.22
 */


/**
 * GSource:
 *
 * The <structname>GSource</structname> struct is an opaque data type
 * representing an event source.
 */


/**
 * GSourceCallbackFuncs:
 * @ref: Called when a reference is added to the callback object
 * @unref: Called when a reference to the callback object is dropped
 * @get: Called to extract the callback function and data from the callback object. The <structname>GSourceCallbackFuncs</structname> struct contains functions for managing callback objects.
 *
 *
 */


/**
 * GSourceDummyMarshal:
 *
 * This is just a placeholder for #GClosureMarshal,
 * which cannot be used here for dependency reasons.
 */


/**
 * GSourceFunc:
 * @user_data: data passed to the function, set when the source was created with one of the above functions
 *
 * Specifies the type of function passed to g_timeout_add(),
 * g_timeout_add_full(), g_idle_add(), and g_idle_add_full().
 *
 * Returns: %FALSE if the source should be removed
 */


/**
 * GSourceFuncs:
 * @prepare: Called before all the file descriptors are polled. If the source can determine that it is ready here (without waiting for the results of the poll() call) it should return %TRUE. It can also return a @timeout_ value which should be the maximum timeout (in milliseconds) which should be passed to the poll() call. The actual timeout used will be -1 if all sources returned -1, or it will be the minimum of all the @timeout_ values returned which were >= 0.
 * @check: Called after all the file descriptors are polled. The source should return %TRUE if it is ready to be dispatched. Note that some time may have passed since the previous prepare function was called, so the source should be checked again here.
 * @dispatch: Called to dispatch the event source, after it has returned %TRUE in either its @prepare or its @check function. The @dispatch function is passed in a callback function and data. The callback function may be %NULL if the source was never connected to a callback using g_source_set_callback(). The @dispatch function should call the callback function with @user_data and whatever additional parameters are needed for this type of event source.
 * @finalize: Called when the source is finalized.
 *
 * The <structname>GSourceFuncs</structname> struct contains a table of
 * functions used to handle event sources in a generic manner.
 *
 * For idle sources, the prepare and check functions always return %TRUE
 * to indicate that the source is always ready to be processed. The prepare
 * function also returns a timeout value of 0 to ensure that the poll() call
 * doesn't block (since that would be time wasted which could have been spent
 * running the idle function).
 *
 * For timeout sources, the prepare and check functions both return %TRUE
 * if the timeout interval has expired. The prepare function also returns
 * a timeout value to ensure that the poll() call doesn't block too long
 * and miss the next timeout.
 *
 * For file descriptor sources, the prepare function typically returns %FALSE,
 * since it must wait until poll() has been called before it knows whether
 * any events need to be processed. It sets the returned timeout to -1 to
 * indicate that it doesn't mind how long the poll() call blocks. In the
 * check function, it tests the results of the poll() call to see if the
 * required condition has been met, and returns %TRUE if so.
 */


/**
 * GSpawnChildSetupFunc:
 * @user_data: user data to pass to the function.
 *
 * Specifies the type of the setup function passed to g_spawn_async(),
 * g_spawn_sync() and g_spawn_async_with_pipes(), which can, in very
 * limited ways, be used to affect the child's execution.
 *
 * On POSIX platforms, the function is called in the child after GLib
 * has performed all the setup it plans to perform, but before calling
 * exec(). Actions taken in this function will only affect the child,
 * not the parent.
 *
 * On Windows, the function is called in the parent. Its usefulness on
 * Windows is thus questionable. In many cases executing the child setup
 * function in the parent can have ill effects, and you should be very
 * careful when porting software to Windows that uses child setup
 * functions.
 *
 * However, even on POSIX, you are extremely limited in what you can
 * safely do from a #GSpawnChildSetupFunc, because any mutexes that
 * were held by other threads in the parent process at the time of the
 * fork() will still be locked in the child process, and they will
 * never be unlocked (since the threads that held them don't exist in
 * the child). POSIX allows only async-signal-safe functions (see
 * <citerefentry><refentrytitle>signal</refentrytitle><manvolnum>7</manvolnum></citerefentry>)
 * to be called in the child between fork() and exec(), which
 * drastically limits the usefulness of child setup functions.
 *
 * In particular, it is not safe to call any function which may
 * call malloc(), which includes POSIX functions such as setenv().
 * If you need to set up the child environment differently from
 * the parent, you should use g_get_environ(), g_environ_setenv(),
 * and g_environ_unsetenv(), and then pass the complete environment
 * list to the <literal>g_spawn...</literal> function.
 */


/**
 * GSpawnError:
 * @G_SPAWN_ERROR_FORK: Fork failed due to lack of memory.
 * @G_SPAWN_ERROR_READ: Read or select on pipes failed.
 * @G_SPAWN_ERROR_CHDIR: Changing to working directory failed.
 * @G_SPAWN_ERROR_ACCES: execv() returned <literal>EACCES</literal>
 * @G_SPAWN_ERROR_PERM: execv() returned <literal>EPERM</literal>
 * @G_SPAWN_ERROR_2BIG: execv() returned <literal>E2BIG</literal>
 * @G_SPAWN_ERROR_NOEXEC: execv() returned <literal>ENOEXEC</literal>
 * @G_SPAWN_ERROR_NAMETOOLONG: execv() returned <literal>ENAMETOOLONG</literal>
 * @G_SPAWN_ERROR_NOENT: execv() returned <literal>ENOENT</literal>
 * @G_SPAWN_ERROR_NOMEM: execv() returned <literal>ENOMEM</literal>
 * @G_SPAWN_ERROR_NOTDIR: execv() returned <literal>ENOTDIR</literal>
 * @G_SPAWN_ERROR_LOOP: execv() returned <literal>ELOOP</literal>
 * @G_SPAWN_ERROR_TXTBUSY: execv() returned <literal>ETXTBUSY</literal>
 * @G_SPAWN_ERROR_IO: execv() returned <literal>EIO</literal>
 * @G_SPAWN_ERROR_NFILE: execv() returned <literal>ENFILE</literal>
 * @G_SPAWN_ERROR_MFILE: execv() returned <literal>EMFILE</literal>
 * @G_SPAWN_ERROR_INVAL: execv() returned <literal>EINVAL</literal>
 * @G_SPAWN_ERROR_ISDIR: execv() returned <literal>EISDIR</literal>
 * @G_SPAWN_ERROR_LIBBAD: execv() returned <literal>ELIBBAD</literal>
 * @G_SPAWN_ERROR_FAILED: Some other fatal failure, <literal>error-&gt;message</literal> should explain.
 *
 * Error codes returned by spawning processes.
 */


/**
 * GSpawnFlags:
 * @G_SPAWN_LEAVE_DESCRIPTORS_OPEN: the parent's open file descriptors will be inherited by the child; otherwise all descriptors except stdin/stdout/stderr will be closed before calling exec() in the child.
 * @G_SPAWN_DO_NOT_REAP_CHILD: the child will not be automatically reaped; you must use g_child_watch_add() yourself (or call waitpid() or handle <literal>SIGCHLD</literal> yourself), or the child will become a zombie.
 * @G_SPAWN_SEARCH_PATH: <literal>argv[0]</literal> need not be an absolute path, it will be looked for in the user's <envar>PATH</envar>.
 * @G_SPAWN_STDOUT_TO_DEV_NULL: the child's standard output will be discarded, instead of going to the same location as the parent's standard output.
 * @G_SPAWN_STDERR_TO_DEV_NULL: the child's standard error will be discarded.
 * @G_SPAWN_CHILD_INHERITS_STDIN: the child will inherit the parent's standard input (by default, the child's standard input is attached to <filename>/dev/null</filename>).
 * @G_SPAWN_FILE_AND_ARGV_ZERO: the first element of <literal>argv</literal> is the file to execute, while the remaining elements are the actual argument vector to pass to the file. Normally g_spawn_async_with_pipes() uses <literal>argv[0]</literal> as the file to execute, and passes all of <literal>argv</literal> to the child.
 *
 * Flags passed to g_spawn_sync(), g_spawn_async() and g_spawn_async_with_pipes().
 */


/**
 * GSrvTarget:
 *
 * A single target host/port that a network service is running on.
 */


/**
 * GStrv:
 *
 * A C representable type name for #G_TYPE_STRV.
 */


/**
 * GTcpConnection:
 *
 * A #GSocketConnection for UNIX domain socket connections.
 *
 * Since: 2.22
 */


/**
 * GTestLogFatalFunc:
 * @log_domain: the log domain of the message
 * @log_level: the log level of the message (including the fatal and recursion flags)
 * @message: the message to process
 * @user_data: user data, set in g_test_log_set_fatal_handler()
 *
 * Specifies the prototype of fatal log handler functions.
 *
 * Returns: %TRUE if the program should abort, %FALSE otherwise
 * Since: 2.22
 */


/**
 * GThemedIcon:
 *
 * An implementation of #GIcon for themed icons.
 */


/**
 * GThemedIcon:name:
 *
 * The icon name.
 */


/**
 * GThemedIcon:names:
 *
 * A %NULL-terminated array of icon names.
 */


/**
 * GThemedIcon:use-default-fallbacks:
 *
 * Whether to use the default fallbacks found by shortening the icon name
 * at '-' characters. If the "names" array has more than one element,
 * ignores any past the first.
 *
 * For example, if the icon name was "gnome-dev-cdrom-audio", the array
 * would become
 * |[
 * {
 * "gnome-dev-cdrom-audio",
 * "gnome-dev-cdrom",
 * "gnome-dev",
 * "gnome",
 * NULL
 * };
 * ]|
 */


/**
 * GThreadedSocketService:
 *
 * A helper class for handling accepting incoming connections in the
 * glib mainloop and handling them in a thread.
 *
 * Since: 2.22
 */


/**
 * GThreadedSocketService::run:
 * @service: the #GThreadedSocketService.
 * @connection: a new #GSocketConnection object.
 * @source_object: the source_object passed to g_socket_listener_add_address().
 *
 * The ::run signal is emitted in a worker thread in response to an
 * incoming connection. This thread is dedicated to handling
 * @connection and may perform blocking IO. The signal handler need
 * not return until the connection is closed.
 *
 * Returns: %TRUE to stop further signal handlers from being called
 */


/**
 * GTimeSpan:
 *
 * A value representing an interval of time, in microseconds.
 *
 * Since: 2.26
 */


/**
 * GTimeType:
 * @G_TIME_TYPE_STANDARD: the time is in local standard time
 * @G_TIME_TYPE_DAYLIGHT: the time is in local daylight time
 * @G_TIME_TYPE_UNIVERSAL: the time is in UTC
 *
 * Disambiguates a given time in two ways.
 *
 * First, specifies if the given time is in universal or local time.
 *
 * Second, if the time is in local time, specifies if it is local
 * standard time or local daylight time.  This is important for the case
 * where the same local time occurs twice (during daylight savings time
 * transitions, for example).
 */


/**
 * GTlsAuthenticationMode:
 * @G_TLS_AUTHENTICATION_NONE: client authentication not required
 * @G_TLS_AUTHENTICATION_REQUESTED: client authentication is requested
 * @G_TLS_AUTHENTICATION_REQUIRED: client authentication is required
 *
 * The client authentication mode for a #GTlsServerConnection.
 *
 * Since: 2.28
 */


/**
 * GTlsBackend:
 *
 * TLS (Transport Layer Security, aka SSL) backend. This is an
 * internal type used to coordinate the different classes implemented
 * by a TLS backend.
 *
 * Since: 2.28
 */


/**
 * GTlsBackendInterface:
 * @g_iface: The parent interface.
 * @supports_tls: returns whether the backend supports TLS.
 * @get_default_database: returns a default #GTlsDatabase instance.
 * @get_certificate_type: returns the #GTlsCertificate implementation type
 * @get_client_connection_type: returns the #GTlsClientConnection implementation type
 * @get_server_connection_type: returns the #GTlsServerConnection implementation type
 * @get_file_database_type: returns the #GTlsFileDatabase implementation type.
 *
 * Provides an interface for describing TLS-related types.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:
 *
 * Abstract base class for TLS certificate types.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:certificate:
 *
 * The DER (binary) encoded representation of the certificate's
 * public key. This property and the
 * #GTlsCertificate:certificate-pem property represent the same
 * data, just in different forms.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:certificate-pem:
 *
 * The PEM (ASCII) encoded representation of the certificate's
 * public key. This property and the #GTlsCertificate:certificate
 * property represent the same data, just in different forms.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:issuer:
 *
 * A #GTlsCertificate representing the entity that issued this
 * certificate. If %NULL, this means that the certificate is either
 * self-signed, or else the certificate of the issuer is not
 * available.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:private-key:
 *
 * The DER (binary) encoded representation of the certificate's
 * private key, in either PKCS#1 format or unencrypted PKCS#8
 * format. This property (or the #GTlsCertificate:private-key-pem
 * property) can be set when constructing a key (eg, from a file),
 * but cannot be read.
 *
 * PKCS#8 format is supported since 2.32; earlier releases only
 * support PKCS#1. You can use the <literal>openssl rsa</literal>
 * tool to convert PKCS#8 keys to PKCS#1.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificate:private-key-pem:
 *
 * The PEM (ASCII) encoded representation of the certificate's
 * private key in either PKCS#1 format ("<literal>BEGIN RSA PRIVATE
 * KEY</literal>") or unencrypted PKCS#8 format ("<literal>BEGIN
 * PRIVATE KEY</literal>"). This property (or the
 * #GTlsCertificate:private-key property) can be set when
 * constructing a key (eg, from a file), but cannot be read.
 *
 * PKCS#8 format is supported since 2.32; earlier releases only
 * support PKCS#1. You can use the <literal>openssl rsa</literal>
 * tool to convert PKCS#8 keys to PKCS#1.
 *
 * Since: 2.28
 */


/**
 * GTlsCertificateFlags:
 * @G_TLS_CERTIFICATE_UNKNOWN_CA: The signing certificate authority is not known.
 * @G_TLS_CERTIFICATE_BAD_IDENTITY: The certificate does not match the expected identity of the site that it was retrieved from.
 * @G_TLS_CERTIFICATE_NOT_ACTIVATED: The certificate's activation time is still in the future
 * @G_TLS_CERTIFICATE_EXPIRED: The certificate has expired
 * @G_TLS_CERTIFICATE_REVOKED: The certificate has been revoked according to the #GTlsConnection's certificate revocation list.
 * @G_TLS_CERTIFICATE_INSECURE: The certificate's algorithm is considered insecure.
 * @G_TLS_CERTIFICATE_GENERIC_ERROR: Some other error occurred validating the certificate
 * @G_TLS_CERTIFICATE_VALIDATE_ALL: the combination of all of the above flags
 *
 * A set of flags describing TLS certification validation. This can be
 * used to set which validation steps to perform (eg, with
 * g_tls_client_connection_set_validation_flags()), or to describe why
 * a particular certificate was rejected (eg, in
 * #GTlsConnection::accept-certificate).
 *
 * Since: 2.28
 */


/**
 * GTlsClientConnection:
 *
 * TLS client-side connection; the client-side implementation of a
 * #GTlsConnection
 *
 * Since: 2.28
 */


/**
 * GTlsClientConnection:accepted-cas:
 *
 * A list of the distinguished names of the Certificate Authorities
 * that the server will accept client certificates signed by. If the
 * server requests a client certificate during the handshake, then
 * this property will be set after the handshake completes.
 *
 * Each item in the list is a #GByteArray which contains the complete
 * subject DN of the certificate authority.
 *
 * Since: 2.28
 */


/**
 * GTlsClientConnection:server-identity:
 *
 * A #GSocketConnectable describing the identity of the server that
 * is expected on the other end of the connection.
 *
 * If the %G_TLS_CERTIFICATE_BAD_IDENTITY flag is set in
 * #GTlsClientConnection:validation-flags, this object will be used
 * to determine the expected identify of the remote end of the
 * connection; if #GTlsClientConnection:server-identity is not set,
 * or does not match the identity presented by the server, then the
 * %G_TLS_CERTIFICATE_BAD_IDENTITY validation will fail.
 *
 * In addition to its use in verifying the server certificate,
 * this is also used to give a hint to the server about what
 * certificate we expect, which is useful for servers that serve
 * virtual hosts.
 *
 * Since: 2.28
 */


/**
 * GTlsClientConnection:use-ssl3:
 *
 * If %TRUE, tells the connection to use SSL 3.0 rather than trying
 * to negotiate the best version of TLS or SSL to use. This can be
 * used when talking to servers that don't implement version
 * negotiation correctly and therefore refuse to handshake at all with
 * a "modern" TLS handshake.
 *
 * Since: 2.28
 */


/**
 * GTlsClientConnection:validation-flags:
 *
 * What steps to perform when validating a certificate received from
 * a server. Server certificates that fail to validate in all of the
 * ways indicated here will be rejected unless the application
 * overrides the default via #GTlsConnection::accept-certificate.
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:
 *
 * TLS connection. This is an abstract type that will be subclassed by
 * a TLS-library-specific subtype.
 *
 * Since: 2.28
 */


/**
 * GTlsConnection::accept-certificate:
 * @conn: a #GTlsConnection
 * @peer_cert: the peer's #GTlsCertificate
 * @errors: the problems with @peer_cert.
 *
 * Emitted during the TLS handshake after the peer certificate has
 * been received. You can examine @peer_cert's certification path by
 * calling g_tls_certificate_get_issuer() on it.
 *
 * For a client-side connection, @peer_cert is the server's
 * certificate, and the signal will only be emitted if the
 * certificate was not acceptable according to @conn's
 * #GTlsClientConnection:validation_flags. If you would like the
 * certificate to be accepted despite @errors, return %TRUE from the
 * signal handler. Otherwise, if no handler accepts the certificate,
 * the handshake will fail with %G_TLS_ERROR_BAD_CERTIFICATE.
 *
 * For a server-side connection, @peer_cert is the certificate
 * presented by the client, if this was requested via the server's
 * #GTlsServerConnection:authentication_mode. On the server side,
 * the signal is always emitted when the client presents a
 * certificate, and the certificate will only be accepted if a
 * handler returns %TRUE.
 *
 * Note that if this signal is emitted as part of asynchronous I/O
 * in the main thread, then you should not attempt to interact with
 * the user before returning from the signal handler. If you want to
 * let the user decide whether or not to accept the certificate, you
 * would have to return %FALSE from the signal handler on the first
 * attempt, and then after the connection attempt returns a
 * %G_TLS_ERROR_HANDSHAKE, you can interact with the user, and if
 * the user decides to accept the certificate, remember that fact,
 * create a new connection, and return %TRUE from the signal handler
 * the next time.
 *
 * If you are doing I/O in another thread, you do not
 * need to worry about this, and can simply block in the signal
 * handler until the UI thread returns an answer.
 *
 * immediately end the signal emission). %FALSE to allow the signal
 * emission to continue, which will cause the handshake to fail if
 * no one else overrides it.
 *
 * Returns: %TRUE to accept @peer_cert (which will also
 * Since: 2.28
 */


/**
 * GTlsConnection:base-io-stream:
 *
 * The #GIOStream that the connection wraps
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:certificate:
 *
 * The connection's certificate; see
 * g_tls_connection_set_certificate().
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:database:
 *
 * The certificate database to use when verifying this TLS connection.
 * If no cerificate database is set, then the default database will be
 * used. See g_tls_backend_get_default_database().
 *
 * Since: 2.30
 */


/**
 * GTlsConnection:interaction:
 *
 * A #GTlsInteraction object to be used when the connection or certificate
 * database need to interact with the user. This will be used to prompt the
 * user for passwords where necessary.
 *
 * Since: 2.30
 */


/**
 * GTlsConnection:peer-certificate:
 *
 * The connection's peer's certificate, after the TLS handshake has
 * completed and the certificate has been accepted. Note in
 * particular that this is not yet set during the emission of
 * #GTlsConnection::accept-certificate.
 *
 * (You can watch for a #GObject::notify signal on this property to
 * detect when a handshake has occurred.)
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:peer-certificate-errors:
 *
 * The errors noticed-and-ignored while verifying
 * #GTlsConnection:peer-certificate. Normally this should be 0, but
 * it may not be if #GTlsClientConnection:validation-flags is not
 * %G_TLS_CERTIFICATE_VALIDATE_ALL, or if
 * #GTlsConnection::accept-certificate overrode the default
 * behavior.
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:rehandshake-mode:
 *
 * The rehandshaking mode. See
 * g_tls_connection_set_rehandshake_mode().
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:require-close-notify:
 *
 * Whether or not proper TLS close notification is required.
 * See g_tls_connection_set_require_close_notify().
 *
 * Since: 2.28
 */


/**
 * GTlsConnection:use-system-certdb:
 *
 * Whether or not the system certificate database will be used to
 * verify peer certificates. See
 * g_tls_connection_set_use_system_certdb().
 *
 * Deprecated: 2.30: Use GTlsConnection:database instead
 */


/**
 * GTlsDatabase:
 *
 * Abstract base class for the backend-specific database types.
 *
 * Since: 2.30
 */


/**
 * GTlsDatabaseLookupFlags:
 * @G_TLS_DATABASE_LOOKUP_NONE: No lookup flags
 * @G_TLS_DATABASE_LOOKUP_KEYPAIR: Restrict lookup to certificates that have a private key.
 *
 * Flags for g_tls_database_lookup_handle(), g_tls_database_lookup_issuer(),
 * and g_tls_database_lookup_issued().
 *
 * Since: 2.30
 */


/**
 * GTlsError:
 * @G_TLS_ERROR_UNAVAILABLE: No TLS provider is available
 * @G_TLS_ERROR_MISC: Miscellaneous TLS error
 * @G_TLS_ERROR_BAD_CERTIFICATE: A certificate could not be parsed
 * @G_TLS_ERROR_NOT_TLS: The TLS handshake failed because the peer does not seem to be a TLS server.
 * @G_TLS_ERROR_HANDSHAKE: The TLS handshake failed because the peer's certificate was not acceptable.
 * @G_TLS_ERROR_CERTIFICATE_REQUIRED: The TLS handshake failed because the server requested a client-side certificate, but none was provided. See g_tls_connection_set_certificate().
 * @G_TLS_ERROR_EOF: The TLS connection was closed without proper notice, which may indicate an attack. See g_tls_connection_set_require_close_notify().
 *
 * An error code used with %G_TLS_ERROR in a #GError returned from a
 * TLS-related routine.
 *
 * Since: 2.28
 */


/**
 * GTlsFileDatabase:
 *
 * Implemented by a #GTlsDatabase which allows you to load certificates
 * from a file.
 *
 * Since: 2.30
 */


/**
 * GTlsFileDatabase:anchors:
 *
 * The path to a file containing PEM encoded certificate authority
 * root anchors. The certificates in this file will be treated as
 * root authorities for the purpose of verifying other certificates
 * via the g_tls_database_verify_chain() operation.
 *
 * Since: 2.30
 */


/**
 * GTlsFileDatabaseInterface:
 * @g_iface: The parent interface.
 *
 * Provides an interface for #GTlsFileDatabase implementations.
 */


/**
 * GTlsInteraction:
 *
 * An object representing interaction that the TLS connection and database
 * might have with the user.
 *
 * Since: 2.30
 */


/**
 * GTlsInteractionClass:
 * @ask_password: ask for a password synchronously. If the implementation returns %G_TLS_INTERACTION_HANDLED, then the password argument should have been filled in by using g_tls_password_set_value() or a similar function.
 * @ask_password_async: ask for a password asynchronously.
 * @ask_password_finish: complete operation to ask for a password asynchronously. If the implementation returns %G_TLS_INTERACTION_HANDLED, then the password argument of the async method should have been filled in by using g_tls_password_set_value() or a similar function.
 *
 * The class for #GTlsInteraction. Derived classes implement the various
 * virtual interaction methods to handle TLS interactions.
 *
 * Derived classes can choose to implement whichever interactions methods they'd
 * like to support by overriding those virtual methods in their class
 * initialization function. If a derived class implements an async method,
 * it must also implement the corresponding finish method.
 *
 * The synchronous interaction methods should implement to display modal dialogs,
 * and the asynchronous methods to display modeless dialogs.
 *
 * If the user cancels an interaction, then the result should be
 * %G_TLS_INTERACTION_FAILED and the error should be set with a domain of
 * %G_IO_ERROR and code of %G_IO_ERROR_CANCELLED.
 *
 * Since: 2.30
 */


/**
 * GTlsInteractionResult:
 * @G_TLS_INTERACTION_UNHANDLED: The interaction was unhandled (i.e. not implemented).
 * @G_TLS_INTERACTION_HANDLED: The interaction completed, and resulting data is available.
 * @G_TLS_INTERACTION_FAILED: The interaction has failed, or was cancelled. and the operation should be aborted.
 *
 * #GTlsInteractionResult is returned by various functions in #GTlsInteraction
 * when finishing an interaction request.
 *
 * Since: 2.30
 */


/**
 * GTlsPassword:
 *
 * An abstract interface representing a password used in TLS. Often used in
 * user interaction such as unlocking a key storage token.
 *
 * Since: 2.30
 */


/**
 * GTlsPasswordFlags:
 * @G_TLS_PASSWORD_NONE: No flags
 * @G_TLS_PASSWORD_RETRY: The password was wrong, and the user should retry.
 * @G_TLS_PASSWORD_MANY_TRIES: Hint to the user that the password has been wrong many times, and the user may not have many chances left.
 * @G_TLS_PASSWORD_FINAL_TRY: Hint to the user that this is the last try to get this password right.
 *
 * Various flags for the password.
 *
 * Since: 2.30
 */


/**
 * GTlsRehandshakeMode:
 * @G_TLS_REHANDSHAKE_NEVER: Never allow rehandshaking
 * @G_TLS_REHANDSHAKE_SAFELY: Allow safe rehandshaking only
 * @G_TLS_REHANDSHAKE_UNSAFELY: Allow unsafe rehandshaking
 *
 * When to allow rehandshaking. See
 * g_tls_connection_set_rehandshake_mode().
 *
 * Since: 2.28
 */


/**
 * GTlsServerConnection:
 *
 * TLS server-side connection. This is the server-side implementation
 * of a #GTlsConnection.
 *
 * Since: 2.28
 */


/**
 * GTlsServerConnection:authentication-mode:
 *
 * The #GTlsAuthenticationMode for the server. This can be changed
 * before calling g_tls_connection_handshake() if you want to
 * rehandshake with a different mode from the initial handshake.
 *
 * Since: 2.28
 */


/**
 * GToggleNotify:
 * @data: Callback data passed to g_object_add_toggle_ref()
 * @object: The object on which g_object_add_toggle_ref() was called.
 * @is_last_ref: %TRUE if the toggle reference is now the last reference to the object. %FALSE if the toggle reference was the last reference and there are now other references.
 *
 * A callback function used for notification when the state
 * of a toggle reference changes. See g_object_add_toggle_ref().
 */


/**
 * GTranslateFunc:
 * @str: the untranslated string
 * @data: user data specified when installing the function, e.g. in g_option_group_set_translate_func()
 *
 * The type of functions which are used to translate user-visible
 * strings, for <option>--help</option> output.
 *
 * The returned string is owned by GLib and must not be freed.
 *
 * Returns: a translation of the string for the current locale.
 */


/**
 * GType:
 *
 * A numerical value which represents the unique identifier of a registered
 * type.
 */


/**
 * GTypeClass:
 *
 * An opaque structure used as the base of all classes.
 */


/**
 * GTypeClassCacheFunc:
 * @cache_data: data that was given to the g_type_add_class_cache_func() call
 * @g_class: The #GTypeClass structure which is unreferenced
 *
 * A callback function which is called when the reference count of a class
 * drops to zero. It may use g_type_class_ref() to prevent the class from
 * being freed. You should not call g_type_class_unref() from a
 * #GTypeClassCacheFunc function to prevent infinite recursion, use
 * g_type_class_unref_uncached() instead.
 *
 * The functions have to check the class id passed in to figure
 * whether they actually want to cache the class of this type, since all
 * classes are routed through the same #GTypeClassCacheFunc chain.
 *
 * called, %FALSE to continue.
 *
 * Returns: %TRUE to stop further #GTypeClassCacheFunc<!-- -->s from being
 */


/**
 * GTypeDebugFlags:
 * @G_TYPE_DEBUG_NONE: Print no messages.
 * @G_TYPE_DEBUG_OBJECTS: Print messages about object bookkeeping.
 * @G_TYPE_DEBUG_SIGNALS: Print messages about signal emissions.
 * @G_TYPE_DEBUG_MASK: Mask covering all debug flags.
 *
 * The <type>GTypeDebugFlags</type> enumeration values can be passed to
 * g_type_init_with_debug_flags() to trigger debugging messages during runtime.
 * Note that the messages can also be triggered by setting the
 * <envar>GOBJECT_DEBUG</envar> environment variable to a ':'-separated list of
 * "objects" and "signals".
 */


/**
 * GTypeFlags:
 * @G_TYPE_FLAG_ABSTRACT: Indicates an abstract type. No instances can be created for an abstract type.
 * @G_TYPE_FLAG_VALUE_ABSTRACT: Indicates an abstract value type, i.e. a type that introduces a value table, but can't be used for g_value_init().
 *
 * Bit masks used to check or determine characteristics of a type.
 */


/**
 * GTypeFundamentalFlags:
 * @G_TYPE_FLAG_CLASSED: Indicates a classed type.
 * @G_TYPE_FLAG_INSTANTIATABLE: Indicates an instantiable type (implies classed).
 * @G_TYPE_FLAG_DERIVABLE: Indicates a flat derivable type.
 * @G_TYPE_FLAG_DEEP_DERIVABLE: Indicates a deep derivable type (implies derivable).
 *
 * Bit masks used to check or determine specific characteristics of a
 * fundamental type.
 */


/**
 * GTypeFundamentalInfo:
 * @type_flags: #GTypeFundamentalFlags describing the characteristics of the fundamental type
 *
 * A structure that provides information to the type system which is
 * used specifically for managing fundamental types.
 */


/**
 * GTypeInfo:
 * @class_size: Size of the class structure (required for interface, classed and instantiatable types).
 * @base_init: Location of the base initialization function (optional).
 * @base_finalize: Location of the base finalization function (optional).
 * @class_init: Location of the class initialization function for classed and instantiatable types. Location of the default vtable inititalization function for interface types. (optional) This function is used both to fill in virtual functions in the class or default vtable, and to do type-specific setup such as registering signals and object properties.
 * @class_finalize: Location of the class finalization function for classed and instantiatable types. Location fo the default vtable finalization function for interface types. (optional)
 * @class_data: User-supplied data passed to the class init/finalize functions.
 * @instance_size: Size of the instance (object) structure (required for instantiatable types only).
 * @n_preallocs: Prior to GLib 2.10, it specified the number of pre-allocated (cached) instances to reserve memory for (0 indicates no caching). Since GLib 2.10, it is ignored, since instances are allocated with the <link linkend="glib-Memory-Slices">slice allocator</link> now.
 * @instance_init: Location of the instance initialization function (optional, for instantiatable types only).
 * @value_table: A #GTypeValueTable function table for generic handling of GValues of this type (usually only useful for fundamental types).
 *
 * This structure is used to provide the type system with the information
 * required to initialize and destruct (finalize) a type's class and
 * its instances.
 * The initialized structure is passed to the g_type_register_static() function
 * (or is copied into the provided #GTypeInfo structure in the
 * g_type_plugin_complete_type_info()). The type system will perform a deep
 * copy of this structure, so its memory does not need to be persistent
 * across invocation of g_type_register_static().
 */


/**
 * GTypeInstance:
 *
 * An opaque structure used as the base of all type instances.
 */


/**
 * GTypeInterface:
 *
 * An opaque structure used as the base of all interface types.
 */


/**
 * GTypeInterfaceCheckFunc:
 * @check_data: data passed to g_type_add_interface_check().
 * @g_iface: the interface that has been initialized
 *
 * A callback called after an interface vtable is initialized.
 * See g_type_add_interface_check().
 *
 * Since: 2.4
 */


/**
 * GTypeModule:
 * @name: the name of the module
 *
 * The members of the <structname>GTypeModule</structname> structure should not
 * be accessed directly, except for the @name field.
 */


/**
 * GTypeModuleClass:
 * @parent_class: the parent class
 * @load: loads the module and registers one or more types using g_type_module_register_type().
 * @unload: unloads the module
 *
 * In order to implement dynamic loading of types based on #GTypeModule,
 * the @load and @unload functions in #GTypeModuleClass must be implemented.
 */


/**
 * GTypePlugin:
 *
 * The <structname>GTypePlugin</structname> typedef is used as a placeholder
 * for objects that implement the <structname>GTypePlugin</structname>
 * interface.
 */


/**
 * GTypePluginClass:
 * @use_plugin: Increases the use count of the plugin.
 * @unuse_plugin: Decreases the use count of the plugin.
 * @complete_type_info: Fills in the #GTypeInfo and #GTypeValueTable structs for the type. The structs are initialized with <literal>memset(s, 0, sizeof (s))</literal> before calling this function.
 * @complete_interface_info: Fills in missing parts of the #GInterfaceInfo for the interface. The structs is initialized with <literal>memset(s, 0, sizeof (s))</literal> before calling this function.
 *
 * The #GTypePlugin interface is used by the type system in order to handle
 * the lifecycle of dynamically loaded types.
 */


/**
 * GTypePluginCompleteInterfaceInfo:
 * @plugin: the #GTypePlugin
 * @instance_type: the #GType of an instantiable type to which the interface is added
 * @interface_type: the #GType of the interface whose info is completed
 * @info: the #GInterfaceInfo to fill in
 *
 * The type of the @complete_interface_info function of #GTypePluginClass.
 */


/**
 * GTypePluginCompleteTypeInfo:
 * @plugin: the #GTypePlugin
 * @g_type: the #GType whose info is completed
 * @info: the #GTypeInfo struct to fill in
 * @value_table: the #GTypeValueTable to fill in
 *
 * The type of the @complete_type_info function of #GTypePluginClass.
 */


/**
 * GTypePluginUnuse:
 * @plugin: the #GTypePlugin whose use count should be decreased
 *
 * The type of the @unuse_plugin function of #GTypePluginClass.
 */


/**
 * GTypePluginUse:
 * @plugin: the #GTypePlugin whose use count should be increased
 *
 * The type of the @use_plugin function of #GTypePluginClass, which gets called
 * to increase the use count of @plugin.
 */


/**
 * GTypeQuery:
 * @type: the #GType value of the type.
 * @type_name: the name of the type.
 * @class_size: the size of the class structure.
 * @instance_size: the size of the instance structure.
 *
 * A structure holding information for a specific type. It is
 * filled in by the g_type_query() function.
 */


/**
 * GTypeValueTable:
 * @value_init: Default initialize @values contents by poking values directly into the value->data array. The data array of the #GValue passed into this function was zero-filled with <function>memset()</function>, so no care has to be taken to free any old contents. E.g. for the implementation of a string value that may never be %NULL, the implementation might look like: |[ value->data[0].v_pointer = g_strdup (""); ]|
 * @value_free: Free any old contents that might be left in the data array of the passed in @value. No resources may remain allocated through the #GValue contents after this function returns. E.g. for our above string type: |[ // only free strings without a specific flag for static storage if (!(value->data[1].v_uint & G_VALUE_NOCOPY_CONTENTS)) g_free (value->data[0].v_pointer); ]|
 * @value_copy: @dest_value is a #GValue with zero-filled data section and @src_value is a properly setup #GValue of same or derived type. The purpose of this function is to copy the contents of @src_value into @dest_value in a way, that even after @src_value has been freed, the contents of @dest_value remain valid. String type example: |[ dest_value->data[0].v_pointer = g_strdup (src_value->data[0].v_pointer); ]|
 * @value_peek_pointer: If the value contents fit into a pointer, such as objects or strings, return this pointer, so the caller can peek at the current contents. To extend on our above string example: |[ return value->data[0].v_pointer; ]|
 * @collect_format: A string format describing how to collect the contents of this value bit-by-bit. Each character in the format represents an argument to be collected, and the characters themselves indicate the type of the argument. Currently supported arguments are: <variablelist> <varlistentry><term /><listitem><para> 'i' - Integers. passed as collect_values[].v_int. </para></listitem></varlistentry> <varlistentry><term /><listitem><para> 'l' - Longs. passed as collect_values[].v_long. </para></listitem></varlistentry> <varlistentry><term /><listitem><para> 'd' - Doubles. passed as collect_values[].v_double. </para></listitem></varlistentry> <varlistentry><term /><listitem><para> 'p' - Pointers. passed as collect_values[].v_pointer. </para></listitem></varlistentry> </variablelist> It should be noted that for variable argument list construction, ANSI C promotes every type smaller than an integer to an int, and floats to doubles. So for collection of short int or char, 'i' needs to be used, and for collection of floats 'd'.
 * @collect_value: The collect_value() function is responsible for converting the values collected from a variable argument list into contents suitable for storage in a GValue. This function should setup @value similar to value_init(); e.g. for a string value that does not allow %NULL pointers, it needs to either spew an error, or do an implicit conversion by storing an empty string. The @value passed in to this function has a zero-filled data array, so just like for value_init() it is guaranteed to not contain any old contents that might need freeing. @n_collect_values is exactly the string length of @collect_format, and @collect_values is an array of unions #GTypeCValue with length @n_collect_values, containing the collected values according to @collect_format. @collect_flags is an argument provided as a hint by the caller. It may contain the flag %G_VALUE_NOCOPY_CONTENTS indicating, that the collected value contents may be considered "static" for the duration of the @value lifetime. Thus an extra copy of the contents stored in @collect_values is not required for assignment to @value. For our above string example, we continue with: |[ if (!collect_values[0].v_pointer) value->data[0].v_pointer = g_strdup (""); else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) { value->data[0].v_pointer = collect_values[0].v_pointer; // keep a flag for the value_free() implementation to not free this string value->data[1].v_uint = G_VALUE_NOCOPY_CONTENTS; } else value->data[0].v_pointer = g_strdup (collect_values[0].v_pointer); return NULL; ]| It should be noted, that it is generally a bad idea to follow the #G_VALUE_NOCOPY_CONTENTS hint for reference counted types. Due to reentrancy requirements and reference count assertions performed by the signal emission code, reference counts should always be incremented for reference counted contents stored in the value->data array.  To deviate from our string example for a moment, and taking a look at an exemplary implementation for collect_value() of #GObject: |[ if (collect_values[0].v_pointer) { GObject *object = G_OBJECT (collect_values[0].v_pointer); // never honour G_VALUE_NOCOPY_CONTENTS for ref-counted types value->data[0].v_pointer = g_object_ref (object); return NULL; } else return g_strdup_printf ("Object passed as invalid NULL pointer"); } ]| The reference count for valid objects is always incremented, regardless of @collect_flags. For invalid objects, the example returns a newly allocated string without altering @value. Upon success, collect_value() needs to return %NULL. If, however, an error condition occurred, collect_value() may spew an error by returning a newly allocated non-%NULL string, giving a suitable description of the error condition. The calling code makes no assumptions about the @value contents being valid upon error returns, @value is simply thrown away without further freeing. As such, it is a good idea to not allocate #GValue contents, prior to returning an error, however, collect_values() is not obliged to return a correctly setup @value for error returns, simply because any non-%NULL return is considered a fatal condition so further program behaviour is undefined.
 * @lcopy_format: Format description of the arguments to collect for @lcopy_value, analogous to @collect_format. Usually, @lcopy_format string consists only of 'p's to provide lcopy_value() with pointers to storage locations.
 * @lcopy_value: This function is responsible for storing the @value contents into arguments passed through a variable argument list which got collected into @collect_values according to @lcopy_format. @n_collect_values equals the string length of @lcopy_format, and @collect_flags may contain %G_VALUE_NOCOPY_CONTENTS. In contrast to collect_value(), lcopy_value() is obliged to always properly support %G_VALUE_NOCOPY_CONTENTS. Similar to collect_value() the function may prematurely abort by returning a newly allocated string describing an error condition. To complete the string example: |[ gchar **string_p = collect_values[0].v_pointer; if (!string_p) return g_strdup_printf ("string location passed as NULL"); if (collect_flags & G_VALUE_NOCOPY_CONTENTS) *string_p = value->data[0].v_pointer; else *string_p = g_strdup (value->data[0].v_pointer); ]| And an illustrative version of lcopy_value() for reference-counted types: |[ GObject **object_p = collect_values[0].v_pointer; if (!object_p) return g_strdup_printf ("object location passed as NULL"); if (!value->data[0].v_pointer) *object_p = NULL; else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) /&ast; always honour &ast;/ *object_p = value->data[0].v_pointer; else *object_p = g_object_ref (value->data[0].v_pointer); return NULL; ]|
 *
 * The #GTypeValueTable provides the functions required by the #GValue implementation,
 * to serve as a container for values of a type.
 */


/**
 * GUnicodeBreakType:
 * @G_UNICODE_BREAK_MANDATORY: Mandatory Break (BK)
 * @G_UNICODE_BREAK_CARRIAGE_RETURN: Carriage Return (CR)
 * @G_UNICODE_BREAK_LINE_FEED: Line Feed (LF)
 * @G_UNICODE_BREAK_COMBINING_MARK: Attached Characters and Combining Marks (CM)
 * @G_UNICODE_BREAK_SURROGATE: Surrogates (SG)
 * @G_UNICODE_BREAK_ZERO_WIDTH_SPACE: Zero Width Space (ZW)
 * @G_UNICODE_BREAK_INSEPARABLE: Inseparable (IN)
 * @G_UNICODE_BREAK_NON_BREAKING_GLUE: Non-breaking ("Glue") (GL)
 * @G_UNICODE_BREAK_CONTINGENT: Contingent Break Opportunity (CB)
 * @G_UNICODE_BREAK_SPACE: Space (SP)
 * @G_UNICODE_BREAK_AFTER: Break Opportunity After (BA)
 * @G_UNICODE_BREAK_BEFORE: Break Opportunity Before (BB)
 * @G_UNICODE_BREAK_BEFORE_AND_AFTER: Break Opportunity Before and After (B2)
 * @G_UNICODE_BREAK_HYPHEN: Hyphen (HY)
 * @G_UNICODE_BREAK_NON_STARTER: Nonstarter (NS)
 * @G_UNICODE_BREAK_OPEN_PUNCTUATION: Opening Punctuation (OP)
 * @G_UNICODE_BREAK_CLOSE_PUNCTUATION: Closing Punctuation (CL)
 * @G_UNICODE_BREAK_QUOTATION: Ambiguous Quotation (QU)
 * @G_UNICODE_BREAK_EXCLAMATION: Exclamation/Interrogation (EX)
 * @G_UNICODE_BREAK_IDEOGRAPHIC: Ideographic (ID)
 * @G_UNICODE_BREAK_NUMERIC: Numeric (NU)
 * @G_UNICODE_BREAK_INFIX_SEPARATOR: Infix Separator (Numeric) (IS)
 * @G_UNICODE_BREAK_SYMBOL: Symbols Allowing Break After (SY)
 * @G_UNICODE_BREAK_ALPHABETIC: Ordinary Alphabetic and Symbol Characters (AL)
 * @G_UNICODE_BREAK_PREFIX: Prefix (Numeric) (PR)
 * @G_UNICODE_BREAK_POSTFIX: Postfix (Numeric) (PO)
 * @G_UNICODE_BREAK_COMPLEX_CONTEXT: Complex Content Dependent (South East Asian) (SA)
 * @G_UNICODE_BREAK_AMBIGUOUS: Ambiguous (Alphabetic or Ideographic) (AI)
 * @G_UNICODE_BREAK_UNKNOWN: Unknown (XX)
 * @G_UNICODE_BREAK_NEXT_LINE: Next Line (NL)
 * @G_UNICODE_BREAK_WORD_JOINER: Word Joiner (WJ)
 * @G_UNICODE_BREAK_HANGUL_L_JAMO: Hangul L Jamo (JL)
 * @G_UNICODE_BREAK_HANGUL_V_JAMO: Hangul V Jamo (JV)
 * @G_UNICODE_BREAK_HANGUL_T_JAMO: Hangul T Jamo (JT)
 * @G_UNICODE_BREAK_HANGUL_LV_SYLLABLE: Hangul LV Syllable (H2)
 * @G_UNICODE_BREAK_HANGUL_LVT_SYLLABLE: Hangul LVT Syllable (H3)
 * @G_UNICODE_BREAK_CLOSE_PARANTHESIS: Closing Parenthesis (CP). Since 2.28
 *
 * These are the possible line break classifications.
 *
 * The five Hangul types were added in Unicode 4.1, so, has been
 * introduced in GLib 2.10. Note that new types may be added in the future.
 * Applications should be ready to handle unknown values.
 * They may be regarded as %G_UNICODE_BREAK_UNKNOWN.
 *
 * See <ulink url="http://www.unicode.org/unicode/reports/tr14/">http://www.unicode.org/unicode/reports/tr14/</ulink>.
 */


/**
 * GUnicodeScript:
 * @G_UNICODE_SCRIPT_COMMON: a character used by multiple different scripts
 * @G_UNICODE_SCRIPT_INHERITED: a mark glyph that takes its script from the i                             base glyph to which it is attached
 * @G_UNICODE_SCRIPT_ARABIC: Arabic
 * @G_UNICODE_SCRIPT_ARMENIAN: Armenian
 * @G_UNICODE_SCRIPT_BENGALI: Bengali
 * @G_UNICODE_SCRIPT_BOPOMOFO: Bopomofo
 * @G_UNICODE_SCRIPT_CHEROKEE: Cherokee
 * @G_UNICODE_SCRIPT_COPTIC: Coptic
 * @G_UNICODE_SCRIPT_CYRILLIC: Cyrillic
 * @G_UNICODE_SCRIPT_DESERET: Deseret
 * @G_UNICODE_SCRIPT_DEVANAGARI: Devanagari
 * @G_UNICODE_SCRIPT_ETHIOPIC: Ethiopic
 * @G_UNICODE_SCRIPT_GEORGIAN: Georgian
 * @G_UNICODE_SCRIPT_GOTHIC: Gothic
 * @G_UNICODE_SCRIPT_GREEK: Greek
 * @G_UNICODE_SCRIPT_GUJARATI: Gujarati
 * @G_UNICODE_SCRIPT_GURMUKHI: Gurmukhi
 * @G_UNICODE_SCRIPT_HAN: Han
 * @G_UNICODE_SCRIPT_HANGUL: Hangul
 * @G_UNICODE_SCRIPT_HEBREW: Hebrew
 * @G_UNICODE_SCRIPT_HIRAGANA: Hiragana
 * @G_UNICODE_SCRIPT_KANNADA: Kannada
 * @G_UNICODE_SCRIPT_KATAKANA: Katakana
 * @G_UNICODE_SCRIPT_KHMER: Khmer
 * @G_UNICODE_SCRIPT_LAO: Lao
 * @G_UNICODE_SCRIPT_LATIN: Latin
 * @G_UNICODE_SCRIPT_MALAYALAM: Malayalam
 * @G_UNICODE_SCRIPT_MONGOLIAN: Mongolian
 * @G_UNICODE_SCRIPT_MYANMAR: Myanmar
 * @G_UNICODE_SCRIPT_OGHAM: Ogham
 * @G_UNICODE_SCRIPT_OLD_ITALIC: Old Italic
 * @G_UNICODE_SCRIPT_ORIYA: Oriya
 * @G_UNICODE_SCRIPT_RUNIC: Runic
 * @G_UNICODE_SCRIPT_SINHALA: Sinhala
 * @G_UNICODE_SCRIPT_SYRIAC: Syriac
 * @G_UNICODE_SCRIPT_TAMIL: Tamil
 * @G_UNICODE_SCRIPT_TELUGU: Telugu
 * @G_UNICODE_SCRIPT_THAANA: Thaana
 * @G_UNICODE_SCRIPT_THAI: Thai
 * @G_UNICODE_SCRIPT_TIBETAN: Tibetan Canadian Aboriginal
 * @G_UNICODE_SCRIPT_YI: Yi
 * @G_UNICODE_SCRIPT_TAGALOG: Tagalog
 * @G_UNICODE_SCRIPT_HANUNOO: Hanunoo
 * @G_UNICODE_SCRIPT_BUHID: Buhid
 * @G_UNICODE_SCRIPT_TAGBANWA: Tagbanwa
 * @G_UNICODE_SCRIPT_BRAILLE: Braille
 * @G_UNICODE_SCRIPT_CYPRIOT: Cypriot
 * @G_UNICODE_SCRIPT_LIMBU: Limbu
 * @G_UNICODE_SCRIPT_OSMANYA: Osmanya
 * @G_UNICODE_SCRIPT_SHAVIAN: Shavian
 * @G_UNICODE_SCRIPT_LINEAR_B: Linear B
 * @G_UNICODE_SCRIPT_TAI_LE: Tai Le
 * @G_UNICODE_SCRIPT_UGARITIC: Ugaritic New Tai Lue
 * @G_UNICODE_SCRIPT_BUGINESE: Buginese
 * @G_UNICODE_SCRIPT_GLAGOLITIC: Glagolitic
 * @G_UNICODE_SCRIPT_TIFINAGH: Tifinagh Syloti Nagri Old Persian
 * @G_UNICODE_SCRIPT_KHAROSHTHI: Kharoshthi
 * @G_UNICODE_SCRIPT_UNKNOWN: an unassigned code point
 * @G_UNICODE_SCRIPT_BALINESE: Balinese
 * @G_UNICODE_SCRIPT_CUNEIFORM: Cuneiform
 * @G_UNICODE_SCRIPT_PHOENICIAN: Phoenician
 * @G_UNICODE_SCRIPT_PHAGS_PA: Phags-pa
 * @G_UNICODE_SCRIPT_NKO: N'Ko
 * @G_UNICODE_SCRIPT_KAYAH_LI: Kayah Li. Since 2.16.3
 * @G_UNICODE_SCRIPT_LEPCHA: Lepcha. Since 2.16.3
 * @G_UNICODE_SCRIPT_REJANG: Rejang. Since 2.16.3
 * @G_UNICODE_SCRIPT_SUNDANESE: Sundanese. Since 2.16.3
 * @G_UNICODE_SCRIPT_SAURASHTRA: Saurashtra. Since 2.16.3
 * @G_UNICODE_SCRIPT_CHAM: Cham. Since 2.16.3
 * @G_UNICODE_SCRIPT_OL_CHIKI: Ol Chiki. Since 2.16.3
 * @G_UNICODE_SCRIPT_VAI: Vai. Since 2.16.3
 * @G_UNICODE_SCRIPT_CARIAN: Carian. Since 2.16.3
 * @G_UNICODE_SCRIPT_LYCIAN: Lycian. Since 2.16.3
 * @G_UNICODE_SCRIPT_LYDIAN: Lydian. Since 2.16.3
 * @G_UNICODE_SCRIPT_AVESTAN: Avestan. Since 2.26
 * @G_UNICODE_SCRIPT_BAMUM: Bamum. Since 2.26 Egyptian Hieroglpyhs. Since 2.26 Imperial Aramaic. Since 2.26 Inscriptional Pahlavi. Since 2.26 Inscriptional Parthian. Since 2.26
 * @G_UNICODE_SCRIPT_JAVANESE: Javanese. Since 2.26
 * @G_UNICODE_SCRIPT_KAITHI: Kaithi. Since 2.26
 * @G_UNICODE_SCRIPT_LISU: Lisu. Since 2.26 Meetei Mayek. Since 2.26 Old South Arabian. Since 2.26
 * @G_UNICODE_SCRIPT_OLD_TURKIC: Old Turkic. Since 2.28
 * @G_UNICODE_SCRIPT_SAMARITAN: Samaritan. Since 2.26
 * @G_UNICODE_SCRIPT_TAI_THAM: Tai Tham. Since 2.26
 * @G_UNICODE_SCRIPT_TAI_VIET: Tai Viet. Since 2.26
 * @G_UNICODE_SCRIPT_BATAK: Batak. Since 2.28
 * @G_UNICODE_SCRIPT_BRAHMI: Brahmi. Since 2.28
 * @G_UNICODE_SCRIPT_MANDAIC: Mandaic. Since 2.28
 *
 * The #GUnicodeScript enumeration identifies different writing
 * systems. The values correspond to the names as defined in the
 * Unicode standard. The enumeration has been added in GLib 2.14,
 * and is interchangeable with #PangoScript.
 *
 * Note that new types may be added in the future. Applications
 * should be ready to handle unknown values.
 * See <ulink
 * url="http://www.unicode.org/reports/tr24/">Unicode Standard Annex
 * #24: Script names</ulink>.
 */


/**
 * GUnicodeType:
 * @G_UNICODE_CONTROL: General category "Other, Control" (Cc)
 * @G_UNICODE_FORMAT: General category "Other, Format" (Cf)
 * @G_UNICODE_UNASSIGNED: General category "Other, Not Assigned" (Cn)
 * @G_UNICODE_PRIVATE_USE: General category "Other, Private Use" (Co)
 * @G_UNICODE_SURROGATE: General category "Other, Surrogate" (Cs)
 * @G_UNICODE_LOWERCASE_LETTER: General category "Letter, Lowercase" (Ll)
 * @G_UNICODE_MODIFIER_LETTER: General category "Letter, Modifier" (Lm)
 * @G_UNICODE_OTHER_LETTER: General category "Letter, Other" (Lo)
 * @G_UNICODE_TITLECASE_LETTER: General category "Letter, Titlecase" (Lt)
 * @G_UNICODE_UPPERCASE_LETTER: General category "Letter, Uppercase" (Lu)
 * @G_UNICODE_SPACING_MARK: General category "Mark, Spacing" (Mc)
 * @G_UNICODE_ENCLOSING_MARK: General category "Mark, Enclosing" (Me)
 * @G_UNICODE_NON_SPACING_MARK: General category "Mark, Nonspacing" (Mn)
 * @G_UNICODE_DECIMAL_NUMBER: General category "Number, Decimal Digit" (Nd)
 * @G_UNICODE_LETTER_NUMBER: General category "Number, Letter" (Nl)
 * @G_UNICODE_OTHER_NUMBER: General category "Number, Other" (No)
 * @G_UNICODE_CONNECT_PUNCTUATION: General category "Punctuation, Connector" (Pc)
 * @G_UNICODE_DASH_PUNCTUATION: General category "Punctuation, Dash" (Pd)
 * @G_UNICODE_CLOSE_PUNCTUATION: General category "Punctuation, Close" (Pe)
 * @G_UNICODE_FINAL_PUNCTUATION: General category "Punctuation, Final quote" (Pf)
 * @G_UNICODE_INITIAL_PUNCTUATION: General category "Punctuation, Initial quote" (Pi)
 * @G_UNICODE_OTHER_PUNCTUATION: General category "Punctuation, Other" (Po)
 * @G_UNICODE_OPEN_PUNCTUATION: General category "Punctuation, Open" (Ps)
 * @G_UNICODE_CURRENCY_SYMBOL: General category "Symbol, Currency" (Sc)
 * @G_UNICODE_MODIFIER_SYMBOL: General category "Symbol, Modifier" (Sk)
 * @G_UNICODE_MATH_SYMBOL: General category "Symbol, Math" (Sm)
 * @G_UNICODE_OTHER_SYMBOL: General category "Symbol, Other" (So)
 * @G_UNICODE_LINE_SEPARATOR: General category "Separator, Line" (Zl)
 * @G_UNICODE_PARAGRAPH_SEPARATOR: General category "Separator, Paragraph" (Zp)
 * @G_UNICODE_SPACE_SEPARATOR: General category "Separator, Space" (Zs)
 *
 * These are the possible character classifications from the
 * Unicode specification.
 * See <ulink url="http://www.unicode.org/Public/UNIDATA/UnicodeData.html">http://www.unicode.org/Public/UNIDATA/UnicodeData.html</ulink>.
 */


/**
 * GUnixCredentialsMessage:
 *
 * The #GUnixCredentialsMessage structure contains only private data
 * and should only be accessed using the provided API.
 *
 * Since: 2.26
 */


/**
 * GUnixCredentialsMessage:credentials:
 *
 * The credentials stored in the message.
 *
 * Since: 2.26
 */


/**
 * GUnixCredentialsMessageClass:
 *
 * Class structure for #GUnixCredentialsMessage.
 *
 * Since: 2.26
 */


/**
 * GUnixInputStream:
 *
 * Implements #GInputStream for reading from selectable unix file descriptors
 */


/**
 * GUnixInputStream:close-fd:
 *
 * Whether to close the file descriptor when the stream is closed.
 *
 * Since: 2.20
 */


/**
 * GUnixInputStream:fd:
 *
 * The file descriptor that the stream reads from.
 *
 * Since: 2.20
 */


/**
 * GUnixMountEntry:
 *
 * Defines a Unix mount entry (e.g. <filename>/media/cdrom</filename>).
 * This corresponds roughly to a mtab entry.
 */


/**
 * GUnixMountMonitor:
 *
 * Watches #GUnixMount<!-- -->s for changes.
 */


/**
 * GUnixMountMonitor::mountpoints-changed:
 * @monitor: the object on which the signal is emitted
 *
 * Emitted when the unix mount points have changed.
 */


/**
 * GUnixMountMonitor::mounts-changed:
 * @monitor: the object on which the signal is emitted
 *
 * Emitted when the unix mounts have changed.
 */


/**
 * GUnixMountPoint:
 *
 * Defines a Unix mount point (e.g. <filename>/dev</filename>).
 * This corresponds roughly to a fstab entry.
 */


/**
 * GUnixOutputStream:
 *
 * Implements #GOutputStream for outputting to selectable unix file descriptors
 */


/**
 * GUnixOutputStream:close-fd:
 *
 * Whether to close the file descriptor when the stream is closed.
 *
 * Since: 2.20
 */


/**
 * GUnixOutputStream:fd:
 *
 * The file descriptor that the stream writes to.
 *
 * Since: 2.20
 */


/**
 * GUnixSocketAddress:
 *
 * A UNIX-domain (local) socket address, corresponding to a
 * <type>struct sockaddr_un</type>.
 */


/**
 * GUnixSocketAddress:abstract:
 *
 * Whether or not this is an abstract address
 *
 * distinguishes between zero-padded and non-zero-padded
 * abstract addresses.
 *
 * Deprecated: Use #GUnixSocketAddress:address-type, which
 */


/**
 * GUnixSocketAddressType:
 * @G_UNIX_SOCKET_ADDRESS_INVALID: invalid
 * @G_UNIX_SOCKET_ADDRESS_ANONYMOUS: anonymous
 * @G_UNIX_SOCKET_ADDRESS_PATH: a filesystem path
 * @G_UNIX_SOCKET_ADDRESS_ABSTRACT: an abstract name
 * @G_UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED: an abstract name, 0-padded to the full length of a unix socket name
 *
 * The type of name used by a #GUnixSocketAddress.
 * %G_UNIX_SOCKET_ADDRESS_PATH indicates a traditional unix domain
 * socket bound to a filesystem path. %G_UNIX_SOCKET_ADDRESS_ANONYMOUS
 * indicates a socket not bound to any name (eg, a client-side socket,
 * or a socket created with socketpair()).
 *
 * For abstract sockets, there are two incompatible ways of naming
 * them; the man pages suggest using the entire <literal>struct
 * sockaddr_un</literal> as the name, padding the unused parts of the
 * %sun_path field with zeroes; this corresponds to
 * %G_UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED. However, many programs
 * instead just use a portion of %sun_path, and pass an appropriate
 * smaller length to bind() or connect(). This is
 * %G_UNIX_SOCKET_ADDRESS_ABSTRACT.
 *
 * Since: 2.26
 */


/**
 * GUserDirectory:
 * @G_USER_DIRECTORY_DESKTOP: the user's Desktop directory
 * @G_USER_DIRECTORY_DOCUMENTS: the user's Documents directory
 * @G_USER_DIRECTORY_DOWNLOAD: the user's Downloads directory
 * @G_USER_DIRECTORY_MUSIC: the user's Music directory
 * @G_USER_DIRECTORY_PICTURES: the user's Pictures directory
 * @G_USER_DIRECTORY_PUBLIC_SHARE: the user's shared directory
 * @G_USER_DIRECTORY_TEMPLATES: the user's Templates directory
 * @G_USER_DIRECTORY_VIDEOS: the user's Movies directory
 * @G_USER_N_DIRECTORIES: the number of enum values
 *
 * These are logical ids for special directories which are defined
 * depending on the platform used. You should use g_get_user_special_dir()
 * to retrieve the full path associated to the logical id.
 *
 * The #GUserDirectory enumeration can be extended at later date. Not
 * every platform has a directory for every logical id in this
 * enumeration.
 *
 * Since: 2.14
 */


/**
 * GValue:
 *
 * An opaque structure used to hold different types of values.
 * The data within the structure has protected scope: it is accessible only
 * to functions within a #GTypeValueTable structure, or implementations of
 * the g_value_*() API. That is, code portions which implement new fundamental
 * types.
 * #GValue users cannot make any assumptions about how data is stored
 * within the 2 element @data union, and the @g_type member should
 * only be accessed through the G_VALUE_TYPE() macro.
 */


/**
 * GValueArray:
 * @n_values: number of values contained in the array
 * @values: array of values
 *
 * A #GValueArray contains an array of #GValue elements.
 */


/**
 * GValueTransform:
 * @src_value: Source value.
 * @dest_value: Target value.
 *
 * The type of value transformation functions which can be registered with
 * g_value_register_transform_func().
 */


/**
 * GVariantType:
 *
 * A type in the GVariant type system.
 *
 * Two types may not be compared by value; use g_variant_type_equal() or
 * g_variant_type_is_subtype_of().  May be copied using
 * g_variant_type_copy() and freed using g_variant_type_free().
 */


/**
 * GVfs:
 *
 * Virtual File System object.
 */


/**
 * GVoidFunc:
 *
 * Declares a type of function which takes no arguments
 * and has no return value. It is used to specify the type
 * function passed to g_atexit().
 */


/**
 * GVolume:
 *
 * Opaque mountable volume object.
 */


/**
 * GVolume::changed:
 *
 * Emitted when the volume has been changed.
 */


/**
 * GVolume::removed:
 *
 * This signal is emitted when the #GVolume have been removed. If
 * the recipient is holding references to the object they should
 * release them so the object can be finalized.
 */


/**
 * GVolumeIface:
 * @g_iface: The parent interface.
 * @changed: Changed signal that is emitted when the volume's state has changed.
 * @removed: The removed signal that is emitted when the #GVolume have been removed. If the recipient is holding references to the object they should release them so the object can be finalized.
 * @get_name: Gets a string containing the name of the #GVolume.
 * @get_icon: Gets a #GIcon for the #GVolume.
 * @get_uuid: Gets the UUID for the #GVolume. The reference is typically based on the file system UUID for the mount in question and should be considered an opaque string. Returns %NULL if there is no UUID available.
 * @get_drive: Gets a #GDrive the volume is located on. Returns %NULL if the #GVolume is not associated with a #GDrive.
 * @get_mount: Gets a #GMount representing the mounted volume. Returns %NULL if the #GVolume is not mounted.
 * @can_mount: Returns %TRUE if the #GVolume can be mounted.
 * @can_eject: Checks if a #GVolume can be ejected.
 * @mount_fn: Mounts a given #GVolume. #GVolume implementations must emit the #GMountOperation::aborted signal before completing a mount operation that is aborted while awaiting input from the user through a #GMountOperation instance.
 * @mount_finish: Finishes a mount operation.
 * @eject: Ejects a given #GVolume.
 * @eject_finish: Finishes an eject operation.
 * @get_identifier: Returns the <link linkend="volume-identifier">identifier</link> of the given kind, or %NULL if the #GVolume doesn't have one.
 * @enumerate_identifiers: Returns an array strings listing the kinds of <link linkend="volume-identifier">identifiers</link> which the #GVolume has.
 * @should_automount: Returns %TRUE if the #GVolume should be automatically mounted.
 * @get_activation_root: Returns the activation root for the #GVolume if it is known in advance or %NULL if it is not known.
 * @eject_with_operation: Starts ejecting a #GVolume using a #GMountOperation. Since 2.22.
 * @eject_with_operation_finish: Finishes an eject operation using a #GMountOperation. Since 2.22.
 * @get_sort_key: Gets a key used for sorting #GVolume instance or %NULL if no such key exists. Since 2.32.
 *
 * Interface for implementing operations for mountable volumes.
 */


/**
 * GVolumeMonitor:
 *
 * A Volume Monitor that watches for volume events.
 */


/**
 * GVolumeMonitor::drive-changed:
 * @volume_monitor: The volume monitor emitting the signal.
 * @drive: the drive that changed
 *
 * Emitted when a drive changes.
 */


/**
 * GVolumeMonitor::drive-connected:
 * @volume_monitor: The volume monitor emitting the signal.
 * @drive: a #GDrive that was connected.
 *
 * Emitted when a drive is connected to the system.
 */


/**
 * GVolumeMonitor::drive-disconnected:
 * @volume_monitor: The volume monitor emitting the signal.
 * @drive: a #GDrive that was disconnected.
 *
 * Emitted when a drive is disconnected from the system.
 */


/**
 * GVolumeMonitor::drive-eject-button:
 * @volume_monitor: The volume monitor emitting the signal.
 * @drive: the drive where the eject button was pressed
 *
 * Emitted when the eject button is pressed on @drive.
 *
 * Since: 2.18
 */


/**
 * GVolumeMonitor::drive-stop-button:
 * @volume_monitor: The volume monitor emitting the signal.
 * @drive: the drive where the stop button was pressed
 *
 * Emitted when the stop button is pressed on @drive.
 *
 * Since: 2.22
 */


/**
 * GVolumeMonitor::mount-added:
 * @volume_monitor: The volume monitor emitting the signal.
 * @mount: a #GMount that was added.
 *
 * Emitted when a mount is added.
 */


/**
 * GVolumeMonitor::mount-changed:
 * @volume_monitor: The volume monitor emitting the signal.
 * @mount: a #GMount that changed.
 *
 * Emitted when a mount changes.
 */


/**
 * GVolumeMonitor::mount-pre-unmount:
 * @volume_monitor: The volume monitor emitting the signal.
 * @mount: a #GMount that is being unmounted.
 *
 * Emitted when a mount is about to be removed.
 */


/**
 * GVolumeMonitor::mount-removed:
 * @volume_monitor: The volume monitor emitting the signal.
 * @mount: a #GMount that was removed.
 *
 * Emitted when a mount is removed.
 */


/**
 * GVolumeMonitor::volume-added:
 * @volume_monitor: The volume monitor emitting the signal.
 * @volume: a #GVolume that was added.
 *
 * Emitted when a mountable volume is added to the system.
 */


/**
 * GVolumeMonitor::volume-changed:
 * @volume_monitor: The volume monitor emitting the signal.
 * @volume: a #GVolume that changed.
 *
 * Emitted when mountable volume is changed.
 */


/**
 * GVolumeMonitor::volume-removed:
 * @volume_monitor: The volume monitor emitting the signal.
 * @volume: a #GVolume that was removed.
 *
 * Emitted when a mountable volume is removed from the system.
 */


/**
 * GWeakNotify:
 * @data: data that was provided when the weak reference was established
 * @where_the_object_was: the object being finalized
 *
 * A #GWeakNotify function can be added to an object as a callback that gets
 * triggered when the object is finalized. Since the object is already being
 * finalized when the #GWeakNotify is called, there's not much you could do
 * with the object, apart from e.g. using its address as hash-index or the like.
 */


/**
 * GWin32InputStream:close-handle:
 *
 * Whether to close the file handle when the stream is closed.
 *
 * Since: 2.26
 */


/**
 * GWin32InputStream:handle:
 *
 * The handle that the stream reads from.
 *
 * Since: 2.26
 */


/**
 * GWin32OutputStream:close-handle:
 *
 * Whether to close the file handle when the stream is closed.
 *
 * Since: 2.26
 */


/**
 * GWin32OutputStream:handle:
 *
 * The file handle that the stream writes to.
 *
 * Since: 2.26
 */


/**
 * GZlibCompressor:
 *
 * Zlib decompression
 */


/**
 * GZlibCompressor:file-info:
 *
 * If set to a non-%NULL #GFileInfo object, and #GZlibCompressor:format is
 * %G_ZLIB_COMPRESSOR_FORMAT_GZIP, the compressor will write the file name
 * and modification time from the file info to the the GZIP header.
 *
 * Since: 2.26
 */


/**
 * GZlibCompressorFormat:
 * @G_ZLIB_COMPRESSOR_FORMAT_ZLIB: deflate compression with zlib header
 * @G_ZLIB_COMPRESSOR_FORMAT_GZIP: gzip file format
 * @G_ZLIB_COMPRESSOR_FORMAT_RAW: deflate compression with no header
 *
 * Used to select the type of data format to use for #GZlibDecompressor
 * and #GZlibCompressor.
 *
 * Since: 2.24
 */


/**
 * GZlibDecompressor:
 *
 * Zlib decompression
 */


/**
 * GZlibDecompressor:file-info:
 *
 * A #GFileInfo containing the information found in the GZIP header
 * of the data stream processed, or %NULL if the header was not yet
 * fully processed, is not present at all, or the compressor's
 * #GZlibDecompressor:format property is not %G_ZLIB_COMPRESSOR_FORMAT_GZIP.
 *
 * Since: 2.26
 */


/**
 * G_BOOKMARK_FILE_ERROR:
 *
 * Error domain for bookmark file parsing.
 * Errors in this domain will be from the #GBookmarkFileError
 * enumeration. See #GError for information on error domains.
 */


/**
 * G_BREAKPOINT:
 *
 * Inserts a breakpoint instruction into the code.
 *
 * On x86 and alpha systems this is implemented as a soft interrupt
 * and on other architectures it raises a <literal>SIGTRAP</literal> signal.
 */


/**
 * G_CALLBACK:
 * @f: a function pointer.
 *
 * Cast a function pointer to a #GCallback.
 */


/**
 * G_CCLOSURE_SWAP_DATA:
 * @cclosure: a #GCClosure
 *
 * Checks whether the user data of the #GCClosure should be passed as the
 * first parameter to the callback. See g_cclosure_new_swap().
 *
 * Returns: %TRUE if data has to be swapped.
 */


/**
 * G_CLOSURE_NEEDS_MARSHAL:
 * @closure: a #GClosure
 *
 * Check if the closure still needs a marshaller. See g_closure_set_marshal().
 *
 * @closure.
 *
 * Returns: %TRUE if a #GClosureMarshal marshaller has not yet been set on
 */


/**
 * G_CLOSURE_N_NOTIFIERS:
 * @cl: a #GClosure
 *
 * Get the total number of notifiers connected with the closure @cl.
 * The count includes the meta marshaller, the finalize and invalidate notifiers
 * and the marshal guards. Note that each guard counts as two notifiers.
 * See g_closure_set_meta_marshal(), g_closure_add_finalize_notifier(),
 * g_closure_add_invalidate_notifier() and g_closure_add_marshal_guards().
 *
 * Returns: number of notifiers
 */


/**
 * G_CONVERT_ERROR:
 *
 * Error domain for character set conversions. Errors in this domain will
 * be from the #GConvertError enumeration. See #GError for information on
 * error domains.
 */


/**
 * G_DATALIST_FLAGS_MASK:
 *
 * A bitmask that restricts the possible flags passed to
 * g_datalist_set_flags(). Passing a flags value where
 * flags & ~G_DATALIST_FLAGS_MASK != 0 is an error.
 */


/**
 * G_DBUS_ERROR:
 *
 * Error domain for errors generated by a remote message bus. Errors
 * in this domain will be from the #GDBusError enumeration.  See
 * #GError for more information on error domains.
 *
 * Note that errors in this error domain is intended only for
 * returning errors from a remote message bus process. Errors
 * generated locally in-process by e.g. #GDBusConnection is from the
 * %G_IO_ERROR domain.
 *
 * Since: 2.26
 */


/**
 * G_DEFINE_ABSTRACT_TYPE:
 * @TN: The name of the new type, in Camel case.
 * @t_n: The name of the new type, in lowercase, with words separated by '_'.
 * @T_P: The #GType of the parent type.
 *
 * A convenience macro for type implementations.
 * Similar to G_DEFINE_TYPE(), but defines an abstract type.
 * See G_DEFINE_TYPE_EXTENDED() for an example.
 *
 * Since: 2.4
 */


/**
 * G_DEFINE_ABSTRACT_TYPE_WITH_CODE:
 * @TN: The name of the new type, in Camel case.
 * @t_n: The name of the new type, in lowercase, with words separated by '_'.
 * @T_P: The #GType of the parent type.
 * @_C_: Custom code that gets inserted in the @type_name_get_type() function.
 *
 * A convenience macro for type implementations.
 * Similar to G_DEFINE_TYPE_WITH_CODE(), but defines an abstract type and allows you to
 * insert custom code into the *_get_type() function, e.g. interface implementations
 * via G_IMPLEMENT_INTERFACE(). See G_DEFINE_TYPE_EXTENDED() for an example.
 *
 * Since: 2.4
 */


/**
 * G_DEFINE_BOXED_TYPE:
 * @TypeName: The name of the new type, in Camel case.
 * @type_name: The name of the new type, in lowercase, with words separated by '_'.
 * @copy_func: the #GBoxedCopyFunc for the new type
 * @free_func: the #GBoxedFreeFunc for the new type
 *
 * A convenience macro for boxed type implementations, which defines a
 * type_name_get_type() function registering the boxed type.
 *
 * Since: 2.26
 */


/**
 * G_DEFINE_BOXED_TYPE_WITH_CODE:
 * @TypeName: The name of the new type, in Camel case.
 * @type_name: The name of the new type, in lowercase, with words separated by '_'.
 * @copy_func: the #GBoxedCopyFunc for the new type
 * @free_func: the #GBoxedFreeFunc for the new type
 * @_C_: Custom code that gets inserted in the *_get_type() function.
 *
 * A convenience macro for boxed type implementations.
 * Similar to G_DEFINE_BOXED_TYPE(), but allows to insert custom code into the
 * type_name_get_type() function, e.g. to register value transformations with
 * g_value_register_transform_func().
 *
 * Since: 2.26
 */


/**
 * G_DEFINE_DYNAMIC_TYPE:
 * @TN: The name of the new type, in Camel case.
 * @t_n: The name of the new type, in lowercase, with words separated by '_'.
 * @T_P: The #GType of the parent type.
 *
 * A convenience macro for dynamic type implementations, which declares a
 * class initialization function, an instance initialization function (see
 * #GTypeInfo for information about these) and a static variable named
 * @t_n<!-- -->_parent_class pointing to the parent class. Furthermore,
 * it defines a <function>*_get_type()</function> and a static
 * <function>*_register_type()</function> function for use in your
 * <function>module_init()</function>.
 * See G_DEFINE_DYNAMIC_TYPE_EXTENDED() for an example.
 *
 * Since: 2.14
 */


/**
 * G_DEFINE_DYNAMIC_TYPE_EXTENDED:
 * @TypeName: The name of the new type, in Camel case.
 * @type_name: The name of the new type, in lowercase, with words separated by '_'.
 * @TYPE_PARENT: The #GType of the parent type.
 * @flags: #GTypeFlags to pass to g_type_module_register_type()
 * @CODE: Custom code that gets inserted in the *_get_type() function.
 *
 * A more general version of G_DEFINE_DYNAMIC_TYPE() which
 * allows to specify #GTypeFlags and custom code.
 *
 * |[
 * G_DEFINE_DYNAMIC_TYPE_EXTENDED (GtkGadget,
 * gtk_gadget,
 * GTK_TYPE_THING,
 * 0,
 * G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_GIZMO,
 * gtk_gadget_gizmo_init));
 * ]|
 * expands to
 * |[
 * static void     gtk_gadget_init              (GtkGadget      *self);
 * static void     gtk_gadget_class_init        (GtkGadgetClass *klass);
 * static void     gtk_gadget_class_finalize    (GtkGadgetClass *klass);
 *
 * static gpointer gtk_gadget_parent_class = NULL;
 * static GType    gtk_gadget_type_id = 0;
 *
 * static void     gtk_gadget_class_intern_init (gpointer klass)
 * {
 * gtk_gadget_parent_class = g_type_class_peek_parent (klass);
 * gtk_gadget_class_init ((GtkGadgetClass*) klass);
 * }
 *
 * GType
 * gtk_gadget_get_type (void)
 * {
 * return gtk_gadget_type_id;
 * }
 *
 * static void
 * gtk_gadget_register_type (GTypeModule *type_module)
 * {
 * const GTypeInfo g_define_type_info = {
 * sizeof (GtkGadgetClass),
 * (GBaseInitFunc) NULL,
 * (GBaseFinalizeFunc) NULL,
 * (GClassInitFunc) gtk_gadget_class_intern_init,
 * (GClassFinalizeFunc) gtk_gadget_class_finalize,
 * NULL,   // class_data
 * sizeof (GtkGadget),
 * 0,      // n_preallocs
 * (GInstanceInitFunc) gtk_gadget_init,
 * NULL    // value_table
 * };
 * gtk_gadget_type_id = g_type_module_register_type (type_module,
 * GTK_TYPE_THING,
 * GtkGadget,
 * &g_define_type_info,
 * (GTypeFlags) flags);
 * {
 * const GInterfaceInfo g_implement_interface_info = {
 * (GInterfaceInitFunc) gtk_gadget_gizmo_init
 * };
 * g_type_module_add_interface (type_module, g_define_type_id, TYPE_GIZMO, &g_implement_interface_info);
 * }
 * }
 * ]|
 *
 * Since: 2.14
 */


/**
 * G_DEFINE_INTERFACE:
 * @TN: The name of the new type, in Camel case.
 * @t_n: The name of the new type, in lowercase, with words separated by '_'.
 * @T_P: The #GType of the prerequisite type for the interface, or 0 (%G_TYPE_INVALID) for no prerequisite type.
 *
 * A convenience macro for #GTypeInterface definitions, which declares
 * a default vtable initialization function and defines a *_get_type()
 * function.
 *
 * The macro expects the interface initialization function to have the
 * name <literal>t_n ## _default_init</literal>, and the interface
 * structure to have the name <literal>TN ## Interface</literal>.
 *
 * Since: 2.24
 */


/**
 * G_DEFINE_INTERFACE_WITH_CODE:
 * @TN: The name of the new type, in Camel case.
 * @t_n: The name of the new type, in lowercase, with words separated by '_'.
 * @T_P: The #GType of the prerequisite type for the interface, or 0 (%G_TYPE_INVALID) for no prerequisite type.
 * @_C_: Custom code that gets inserted in the *_get_type() function.
 *
 * A convenience macro for #GTypeInterface definitions. Similar to
 * G_DEFINE_INTERFACE(), but allows you to insert custom code into the
 * *_get_type() function, e.g. additional interface implementations
 * via G_IMPLEMENT_INTERFACE(), or additional prerequisite types. See
 * G_DEFINE_TYPE_EXTENDED() for a similar example using
 * G_DEFINE_TYPE_WITH_CODE().
 *
 * Since: 2.24
 */


/**
 * G_DEFINE_POINTER_TYPE:
 * @TypeName: The name of the new type, in Camel case.
 * @type_name: The name of the new type, in lowercase, with words separated by '_'.
 *
 * A convenience macro for pointer type implementations, which defines a
 * type_name_get_type() function registering the pointer type.
 *
 * Since: 2.26
 */


/**
 * G_DEFINE_POINTER_TYPE_WITH_CODE:
 * @TypeName: The name of the new type, in Camel case.
 * @type_name: The name of the new type, in lowercase, with words separated by '_'.
 * @_C_: Custom code that gets inserted in the *_get_type() function.
 *
 * A convenience macro for pointer type implementations.
 * Similar to G_DEFINE_POINTER_TYPE(), but allows to insert custom code into the
 * type_name_get_type() function.
 *
 * Since: 2.26
 */


/**
 * G_DEFINE_TYPE:
 * @TN: The name of the new type, in Camel case.
 * @t_n: The name of the new type, in lowercase, with words separated by '_'.
 * @T_P: The #GType of the parent type.
 *
 * A convenience macro for type implementations, which declares a
 * class initialization function, an instance initialization function (see #GTypeInfo for information about
 * these) and a static variable named @t_n<!-- -->_parent_class pointing to the parent class. Furthermore, it defines
 * a *_get_type() function. See G_DEFINE_TYPE_EXTENDED() for an example.
 *
 * Since: 2.4
 */


/**
 * G_DEFINE_TYPE_EXTENDED:
 * @TN: The name of the new type, in Camel case.
 * @t_n: The name of the new type, in lowercase, with words separated by '_'.
 * @T_P: The #GType of the parent type.
 * @_f_: #GTypeFlags to pass to g_type_register_static()
 * @_C_: Custom code that gets inserted in the *_get_type() function.
 *
 * The most general convenience macro for type implementations, on which
 * G_DEFINE_TYPE(), etc are based.
 *
 * |[
 * G_DEFINE_TYPE_EXTENDED (GtkGadget,
 * gtk_gadget,
 * GTK_TYPE_WIDGET,
 * 0,
 * G_IMPLEMENT_INTERFACE (TYPE_GIZMO,
 * gtk_gadget_gizmo_init));
 * ]|
 * expands to
 * |[
 * static void     gtk_gadget_init       (GtkGadget      *self);
 * static void     gtk_gadget_class_init (GtkGadgetClass *klass);
 * static gpointer gtk_gadget_parent_class = NULL;
 * static void     gtk_gadget_class_intern_init (gpointer klass)
 * {
 * gtk_gadget_parent_class = g_type_class_peek_parent (klass);
 * gtk_gadget_class_init ((GtkGadgetClass*) klass);
 * }
 *
 * GType
 * gtk_gadget_get_type (void)
 * {
 * static volatile gsize g_define_type_id__volatile = 0;
 * if (g_once_init_enter (&g_define_type_id__volatile))
 * {
 * GType g_define_type_id =
 * g_type_register_static_simple (GTK_TYPE_WIDGET,
 * g_intern_static_string ("GtkGadget"),
 * sizeof (GtkGadgetClass),
 * (GClassInitFunc) gtk_gadget_class_intern_init,
 * sizeof (GtkGadget),
 * (GInstanceInitFunc) gtk_gadget_init,
 * (GTypeFlags) flags);
 * {
 * const GInterfaceInfo g_implement_interface_info = {
 * (GInterfaceInitFunc) gtk_gadget_gizmo_init
 * };
 * g_type_add_interface_static (g_define_type_id, TYPE_GIZMO, &g_implement_interface_info);
 * }
 * g_once_init_leave (&g_define_type_id__volatile, g_define_type_id);
 * }
 * return g_define_type_id__volatile;
 * }
 * ]|
 * The only pieces which have to be manually provided are the definitions of
 * the instance and class structure and the definitions of the instance and
 * class init functions.
 *
 * Since: 2.4
 */


/**
 * G_DEFINE_TYPE_WITH_CODE:
 * @TN: The name of the new type, in Camel case.
 * @t_n: The name of the new type in lowercase, with words separated by '_'.
 * @T_P: The #GType of the parent type.
 * @_C_: Custom code that gets inserted in the *_get_type() function.
 *
 * A convenience macro for type implementations.
 * Similar to G_DEFINE_TYPE(), but allows you to insert custom code into the
 * *_get_type() function, e.g. interface implementations via G_IMPLEMENT_INTERFACE().
 * See G_DEFINE_TYPE_EXTENDED() for an example.
 *
 * Since: 2.4
 */


/**
 * G_DESKTOP_APP_INFO_LOOKUP_EXTENSION_POINT_NAME:
 *
 * Extension point for default handler to URI association. See
 * <link linkend="extending-gio">Extending GIO</link>.
 */


/**
 * G_ENUM_CLASS:
 * @class: a valid #GEnumClass
 *
 * Casts a derived #GEnumClass structure into a #GEnumClass structure.
 */


/**
 * G_ENUM_CLASS_TYPE:
 * @class: a #GEnumClass
 *
 * Get the type identifier from a given #GEnumClass structure.
 *
 * Returns: the #GType
 */


/**
 * G_ENUM_CLASS_TYPE_NAME:
 * @class: a #GEnumClass
 *
 * Get the static type name from a given #GEnumClass structure.
 *
 * Returns: the type name.
 */


/**
 * G_FILE_ATTRIBUTE_ACCESS_CAN_DELETE:
 *
 * A key in the "access" namespace for checking deletion privileges.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 * This attribute will be %TRUE if the user is able to delete the file.
 */


/**
 * G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE:
 *
 * A key in the "access" namespace for getting execution privileges.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 * This attribute will be %TRUE if the user is able to execute the file.
 */


/**
 * G_FILE_ATTRIBUTE_ACCESS_CAN_READ:
 *
 * A key in the "access" namespace for getting read privileges.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 * This attribute will be %TRUE if the user is able to read the file.
 */


/**
 * G_FILE_ATTRIBUTE_ACCESS_CAN_RENAME:
 *
 * A key in the "access" namespace for checking renaming privileges.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 * This attribute will be %TRUE if the user is able to rename the file.
 */


/**
 * G_FILE_ATTRIBUTE_ACCESS_CAN_TRASH:
 *
 * A key in the "access" namespace for checking trashing privileges.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 * This attribute will be %TRUE if the user is able to move the file to
 * the trash.
 */


/**
 * G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE:
 *
 * A key in the "access" namespace for getting write privileges.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 * This attribute will be %TRUE if the user is able to write to the file.
 */


/**
 * G_FILE_ATTRIBUTE_DOS_IS_ARCHIVE:
 *
 * A key in the "dos" namespace for checking if the file's archive flag
 * is set. This attribute is %TRUE if the archive flag is set. This attribute
 * is only available for DOS file systems. Corresponding #GFileAttributeType
 * is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_DOS_IS_SYSTEM:
 *
 * A key in the "dos" namespace for checking if the file's backup flag
 * is set. This attribute is %TRUE if the backup flag is set. This attribute
 * is only available for DOS file systems. Corresponding #GFileAttributeType
 * is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_ETAG_VALUE:
 *
 * A key in the "etag" namespace for getting the value of the file's
 * entity tag. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_FILESYSTEM_FREE:
 *
 * A key in the "filesystem" namespace for getting the number of bytes of free space left on the
 * file system. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_UINT64.
 */


/**
 * G_FILE_ATTRIBUTE_FILESYSTEM_READONLY:
 *
 * A key in the "filesystem" namespace for checking if the file system
 * is read only. Is set to %TRUE if the file system is read only.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_FILESYSTEM_SIZE:
 *
 * A key in the "filesystem" namespace for getting the total size (in bytes) of the file system,
 * used in g_file_query_filesystem_info(). Corresponding #GFileAttributeType
 * is %G_FILE_ATTRIBUTE_TYPE_UINT64.
 */


/**
 * G_FILE_ATTRIBUTE_FILESYSTEM_TYPE:
 *
 * A key in the "filesystem" namespace for getting the file system's type.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW:
 *
 * A key in the "filesystem" namespace for hinting a file manager
 * application whether it should preview (e.g. thumbnail) files on the
 * file system. The value for this key contain a
 * #GFilesystemPreviewType.
 */


/**
 * G_FILE_ATTRIBUTE_GVFS_BACKEND:
 *
 * A key in the "gvfs" namespace that gets the name of the current
 * GVFS backend in use. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_ID_FILE:
 *
 * A key in the "id" namespace for getting a file identifier.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 * An example use would be during listing files, to avoid recursive
 * directory scanning.
 */


/**
 * G_FILE_ATTRIBUTE_ID_FILESYSTEM:
 *
 * A key in the "id" namespace for getting the file system identifier.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 * An example use would be during drag and drop to see if the source
 * and target are on the same filesystem (default to move) or not (default
 * to copy).
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_CAN_EJECT:
 *
 * A key in the "mountable" namespace for checking if a file (of type G_FILE_TYPE_MOUNTABLE) can be ejected.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_CAN_MOUNT:
 *
 * A key in the "mountable" namespace for checking if a file (of type G_FILE_TYPE_MOUNTABLE) is mountable.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_CAN_POLL:
 *
 * A key in the "mountable" namespace for checking if a file (of type G_FILE_TYPE_MOUNTABLE) can be polled.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 *
 * Since: 2.22
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_CAN_START:
 *
 * A key in the "mountable" namespace for checking if a file (of type G_FILE_TYPE_MOUNTABLE) can be started.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 *
 * Since: 2.22
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_CAN_START_DEGRADED:
 *
 * A key in the "mountable" namespace for checking if a file (of type G_FILE_TYPE_MOUNTABLE) can be started
 * degraded.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 *
 * Since: 2.22
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_CAN_STOP:
 *
 * A key in the "mountable" namespace for checking if a file (of type G_FILE_TYPE_MOUNTABLE) can be stopped.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 *
 * Since: 2.22
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT:
 *
 * A key in the "mountable" namespace for checking if a file (of type G_FILE_TYPE_MOUNTABLE)  is unmountable.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_HAL_UDI:
 *
 * A key in the "mountable" namespace for getting the HAL UDI for the mountable
 * file. Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_IS_MEDIA_CHECK_AUTOMATIC:
 *
 * A key in the "mountable" namespace for checking if a file (of type G_FILE_TYPE_MOUNTABLE)
 * is automatically polled for media.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 *
 * Since: 2.22
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_START_STOP_TYPE:
 *
 * A key in the "mountable" namespace for getting the #GDriveStartStopType.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
 *
 * Since: 2.22
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE:
 *
 * A key in the "mountable" namespace for getting the unix device.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE_FILE:
 *
 * A key in the "mountable" namespace for getting the unix device file.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 *
 * Since: 2.22
 */


/**
 * G_FILE_ATTRIBUTE_OWNER_GROUP:
 *
 * A key in the "owner" namespace for getting the file owner's group.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_OWNER_USER:
 *
 * A key in the "owner" namespace for getting the user name of the
 * file's owner. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_OWNER_USER_REAL:
 *
 * A key in the "owner" namespace for getting the real name of the
 * user that owns the file. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_PREVIEW_ICON:
 *
 * A key in the "preview" namespace for getting a #GIcon that can be
 * used to get preview of the file. For example, it may be a low
 * resolution thumbnail without metadata. Corresponding
 * #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_OBJECT.  The value
 * for this key should contain a #GIcon.
 *
 * Since: 2.20
 */


/**
 * G_FILE_ATTRIBUTE_SELINUX_CONTEXT:
 *
 * A key in the "selinux" namespace for getting the file's SELinux
 * context. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_STRING. Note that this attribute is only
 * available if GLib has been built with SELinux support.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE:
 *
 * A key in the "standard" namespace for getting the amount of disk space
 * that is consumed by the file (in bytes).  This will generally be larger
 * than the file size (due to block size overhead) but can occasionally be
 * smaller (for example, for sparse files).
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
 *
 * Since: 2.20
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE:
 *
 * A key in the "standard" namespace for getting the content type of the file.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 * The value for this key should contain a valid content type.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_COPY_NAME:
 *
 * A key in the "standard" namespace for getting the copy name of the file.
 * The copy name is an optional version of the name. If available it's always
 * in UTF8, and corresponds directly to the original filename (only transcoded to
 * UTF8). This is useful if you want to copy the file to another filesystem that
 * might have a different encoding. If the filename is not a valid string in the
 * encoding selected for the filesystem it is in then the copy name will not be set.
 *
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION:
 *
 * A key in the "standard" namespace for getting the description of the file.
 * The description is a utf8 string that describes the file, generally containing
 * the filename, but can also contain furter information. Example descriptions
 * could be "filename (on hostname)" for a remote file or "filename (in trash)"
 * for a file in the trash. This is useful for instance as the window title
 * when displaying a directory or for a bookmarks menu.
 *
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME:
 *
 * A key in the "standard" namespace for getting the display name of the file.
 * A display name is guaranteed to be in UTF8 and can thus be displayed in
 * the UI.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_EDIT_NAME:
 *
 * A key in the "standard" namespace for edit name of the file.
 * An edit name is similar to the display name, but it is meant to be
 * used when you want to rename the file in the UI. The display name
 * might contain information you don't want in the new filename (such as
 * "(invalid unicode)" if the filename was in an invalid encoding).
 *
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE:
 *
 * A key in the "standard" namespace for getting the fast content type.
 * The fast content type isn't as reliable as the regular one, as it
 * only uses the filename to guess it, but it is faster to calculate than the
 * regular content type.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_ICON:
 *
 * A key in the "standard" namespace for getting the icon for the file.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_OBJECT.
 * The value for this key should contain a #GIcon.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP:
 *
 * A key in the "standard" namespace for checking if a file is a backup file.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN:
 *
 * A key in the "standard" namespace for checking if a file is hidden.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK:
 *
 * A key in the "standard" namespace for checking if the file is a symlink.
 * Typically the actual type is something else, if we followed the symlink
 * to get the type.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_IS_VIRTUAL:
 *
 * A key in the "standard" namespace for checking if a file is virtual.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_NAME:
 *
 * A key in the "standard" namespace for getting the name of the file.
 * The name is the on-disk filename which may not be in any known encoding,
 * and can thus not be generally displayed as is.
 * Use #G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME if you need to display the
 * name in a user interface.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_SIZE:
 *
 * A key in the "standard" namespace for getting the file's size (in bytes).
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_SORT_ORDER:
 *
 * A key in the "standard" namespace for setting the sort order of a file.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_INT32.
 * An example use would be in file managers, which would use this key
 * to set the order files are displayed. Files with smaller sort order
 * should be sorted first, and files without sort order as if sort order
 * was zero.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET:
 *
 * A key in the "standard" namespace for getting the symlink target, if the file
 * is a symlink. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_TARGET_URI:
 *
 * A key in the "standard" namespace for getting the target URI for the file, in
 * the case of %G_FILE_TYPE_SHORTCUT or %G_FILE_TYPE_MOUNTABLE files.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_STANDARD_TYPE:
 *
 * A key in the "standard" namespace for storing file types.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
 * The value for this key should contain a #GFileType.
 */


/**
 * G_FILE_ATTRIBUTE_THUMBNAILING_FAILED:
 *
 * A key in the "thumbnail" namespace for checking if thumbnailing failed.
 * This attribute is %TRUE if thumbnailing failed. Corresponding
 * #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_THUMBNAIL_PATH:
 *
 * A key in the "thumbnail" namespace for getting the path to the thumbnail
 * image. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING.
 */


/**
 * G_FILE_ATTRIBUTE_TIME_ACCESS:
 *
 * A key in the "time" namespace for getting the time the file was last
 * accessed. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_UINT64, and contains the UNIX time since the
 * file was last accessed.
 */


/**
 * G_FILE_ATTRIBUTE_TIME_ACCESS_USEC:
 *
 * A key in the "time" namespace for getting the microseconds of the time
 * the file was last accessed. This should be used in conjunction with
 * #G_FILE_ATTRIBUTE_TIME_ACCESS. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_TIME_CHANGED:
 *
 * A key in the "time" namespace for getting the time the file was last
 * changed. Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64,
 * and contains the UNIX time since the file was last changed.
 *
 * This corresponds to the traditional UNIX ctime.
 */


/**
 * G_FILE_ATTRIBUTE_TIME_CHANGED_USEC:
 *
 * A key in the "time" namespace for getting the microseconds of the time
 * the file was last changed. This should be used in conjunction with
 * #G_FILE_ATTRIBUTE_TIME_CHANGED. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_TIME_CREATED:
 *
 * A key in the "time" namespace for getting the time the file was created.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64,
 * and contains the UNIX time since the file was created.
 *
 * This corresponds to the NTFS ctime.
 */


/**
 * G_FILE_ATTRIBUTE_TIME_CREATED_USEC:
 *
 * A key in the "time" namespace for getting the microseconds of the time
 * the file was created. This should be used in conjunction with
 * #G_FILE_ATTRIBUTE_TIME_CREATED. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_TIME_MODIFIED:
 *
 * A key in the "time" namespace for getting the time the file was last
 * modified. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_UINT64, and contains the UNIX time since the
 * file was modified.
 */


/**
 * G_FILE_ATTRIBUTE_TIME_MODIFIED_USEC:
 *
 * A key in the "time" namespace for getting the miliseconds of the time
 * the file was last modified. This should be used in conjunction with
 * #G_FILE_ATTRIBUTE_TIME_MODIFIED. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_TRASH_DELETION_DATE:
 *
 * A key in the "trash" namespace.  When requested against
 * items in "trash:///", will return the date and time when the file
 * was trashed. The format of the returned string is YYYY-MM-DDThh:mm:ss.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_STRING.
 *
 * Since: 2.24.
 */


/**
 * G_FILE_ATTRIBUTE_TRASH_ITEM_COUNT:
 *
 * A key in the "trash" namespace.  When requested against
 * "trash:///" returns the number of (toplevel) items in the trash folder.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_TRASH_ORIG_PATH:
 *
 * A key in the "trash" namespace.  When requested against
 * items in "trash:///", will return the original path to the file before it
 * was trashed. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_STRING.
 *
 * Since: 2.24.
 */


/**
 * G_FILE_ATTRIBUTE_UNIX_BLOCKS:
 *
 * A key in the "unix" namespace for getting the number of blocks allocated
 * for the file. This attribute is only available for UNIX file systems.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
 */


/**
 * G_FILE_ATTRIBUTE_UNIX_BLOCK_SIZE:
 *
 * A key in the "unix" namespace for getting the block size for the file
 * system. This attribute is only available for UNIX file systems.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_UNIX_DEVICE:
 *
 * A key in the "unix" namespace for getting the device id of the device the
 * file is located on (see stat() documentation). This attribute is only
 * available for UNIX file systems. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_UNIX_GID:
 *
 * A key in the "unix" namespace for getting the group ID for the file.
 * This attribute is only available for UNIX file systems.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_UNIX_INODE:
 *
 * A key in the "unix" namespace for getting the inode of the file.
 * This attribute is only available for UNIX file systems. Corresponding
 * #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT64.
 */


/**
 * G_FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT:
 *
 * A key in the "unix" namespace for checking if the file represents a
 * UNIX mount point. This attribute is %TRUE if the file is a UNIX mount
 * point. This attribute is only available for UNIX file systems.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_BOOLEAN.
 */


/**
 * G_FILE_ATTRIBUTE_UNIX_MODE:
 *
 * A key in the "unix" namespace for getting the mode of the file
 * (e.g. whether the file is a regular file, symlink, etc). See lstat()
 * documentation. This attribute is only available for UNIX file systems.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_UNIX_NLINK:
 *
 * A key in the "unix" namespace for getting the number of hard links
 * for a file. See lstat() documentation. This attribute is only available
 * for UNIX file systems. Corresponding #GFileAttributeType is
 * %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_UNIX_RDEV:
 *
 * A key in the "unix" namespace for getting the device ID for the file
 * (if it is a special file). See lstat() documentation. This attribute
 * is only available for UNIX file systems. Corresponding #GFileAttributeType
 * is %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FILE_ATTRIBUTE_UNIX_UID:
 *
 * A key in the "unix" namespace for getting the user ID for the file.
 * This attribute is only available for UNIX file systems.
 * Corresponding #GFileAttributeType is %G_FILE_ATTRIBUTE_TYPE_UINT32.
 */


/**
 * G_FLAGS_CLASS:
 * @class: a valid #GFlagsClass
 *
 * Casts a derived #GFlagsClass structure into a #GFlagsClass structure.
 */


/**
 * G_FLAGS_CLASS_TYPE:
 * @class: a #GFlagsClass
 *
 * Get the type identifier from a given #GFlagsClass structure.
 *
 * Returns: the #GType
 */


/**
 * G_FLAGS_CLASS_TYPE_NAME:
 * @class: a #GFlagsClass
 *
 * Get the static type name from a given #GFlagsClass structure.
 *
 * Returns: the type name.
 */


/**
 * G_IMPLEMENT_INTERFACE:
 * @TYPE_IFACE: The #GType of the interface to add
 * @iface_init: The interface init function
 *
 * A convenience macro to ease interface addition in the @_C_ section
 * of G_DEFINE_TYPE_WITH_CODE() or G_DEFINE_ABSTRACT_TYPE_WITH_CODE().
 * See G_DEFINE_TYPE_EXTENDED() for an example.
 *
 * Note that this macro can only be used together with the G_DEFINE_TYPE_*
 * macros, since it depends on variable names from those macros.
 *
 * Since: 2.4
 */


/**
 * G_IMPLEMENT_INTERFACE_DYNAMIC:
 * @TYPE_IFACE: The #GType of the interface to add
 * @iface_init: The interface init function
 *
 * A convenience macro to ease interface addition in the @_C_ section
 * of G_DEFINE_DYNAMIC_TYPE_EXTENDED(). See G_DEFINE_DYNAMIC_TYPE_EXTENDED()
 * for an example.
 *
 * Note that this macro can only be used together with the
 * G_DEFINE_DYNAMIC_TYPE_EXTENDED macros, since it depends on variable
 * names from that macro.
 *
 * Since: 2.24
 */


/**
 * G_INITIALLY_UNOWNED:
 * @object: Object which is subject to casting.
 *
 * Casts a #GInitiallyUnowned or derived pointer into a (GInitiallyUnowned*)
 * pointer. Depending on the current debugging level, this function may invoke
 * certain runtime checks to identify invalid casts.
 */


/**
 * G_INITIALLY_UNOWNED_CLASS:
 * @class: a valid #GInitiallyUnownedClass
 *
 * Casts a derived #GInitiallyUnownedClass structure into a
 * #GInitiallyUnownedClass structure.
 */


/**
 * G_INITIALLY_UNOWNED_GET_CLASS:
 * @object: a #GInitiallyUnowned instance.
 *
 * Get the class structure associated to a #GInitiallyUnowned instance.
 *
 * Returns: pointer to object class structure.
 */


/**
 * G_IO_ERROR:
 *
 * Error domain for GIO. Errors in this domain will be from the #GIOErrorEnum enumeration.
 * See #GError for more information on error domains.
 */


/**
 * G_IS_ENUM_CLASS:
 * @class: a #GEnumClass
 *
 * Checks whether @class "is a" valid #GEnumClass structure of type %G_TYPE_ENUM
 * or derived.
 */


/**
 * G_IS_FLAGS_CLASS:
 * @class: a #GFlagsClass
 *
 * Checks whether @class "is a" valid #GFlagsClass structure of type %G_TYPE_FLAGS
 * or derived.
 */


/**
 * G_IS_INITIALLY_UNOWNED:
 * @object: Instance to check for being a %G_TYPE_INITIALLY_UNOWNED.
 *
 * Checks whether a valid #GTypeInstance pointer is of type %G_TYPE_INITIALLY_UNOWNED.
 */


/**
 * G_IS_INITIALLY_UNOWNED_CLASS:
 * @class: a #GInitiallyUnownedClass
 *
 * Checks whether @class "is a" valid #GInitiallyUnownedClass structure of type
 * %G_TYPE_INITIALLY_UNOWNED or derived.
 */


/**
 * G_IS_OBJECT:
 * @object: Instance to check for being a %G_TYPE_OBJECT.
 *
 * Checks whether a valid #GTypeInstance pointer is of type %G_TYPE_OBJECT.
 */


/**
 * G_IS_OBJECT_CLASS:
 * @class: a #GObjectClass
 *
 * Checks whether @class "is a" valid #GObjectClass structure of type
 * %G_TYPE_OBJECT or derived.
 */


/**
 * G_IS_PARAM_SPEC:
 * @pspec: a #GParamSpec
 *
 * Checks whether @pspec "is a" valid #GParamSpec structure of type %G_TYPE_PARAM
 * or derived.
 */


/**
 * G_IS_PARAM_SPEC_BOOLEAN:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_BOOLEAN.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_BOXED:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_BOXED.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_CHAR:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_CHAR.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_CLASS:
 * @pclass: a #GParamSpecClass
 *
 * Checks whether @pclass "is a" valid #GParamSpecClass structure of type
 * %G_TYPE_PARAM or derived.
 */


/**
 * G_IS_PARAM_SPEC_DOUBLE:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_DOUBLE.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_ENUM:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_ENUM.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_FLAGS:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_FLAGS.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_FLOAT:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_FLOAT.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_GTYPE:
 * @pspec: a #GParamSpec
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_GTYPE.
 *
 * Since: 2.10
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_INT:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_INT.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_INT64:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_INT64.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_LONG:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_LONG.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_OBJECT:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_OBJECT.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_OVERRIDE:
 * @pspec: a #GParamSpec
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_OVERRIDE.
 *
 * Since: 2.4
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_PARAM:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_PARAM.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_POINTER:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_POINTER.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_STRING:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_STRING.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_UCHAR:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_UCHAR.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_UINT:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_UINT.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_UINT64:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_UINT64.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_ULONG:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_ULONG.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_UNICHAR:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_UNICHAR.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_VALUE_ARRAY:
 * @pspec: a valid #GParamSpec instance
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_VALUE_ARRAY.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_IS_PARAM_SPEC_VARIANT:
 * @pspec: a #GParamSpec
 *
 * Checks whether the given #GParamSpec is of type %G_TYPE_PARAM_VARIANT.
 *
 * Returns: %TRUE on success
 * Since: 2.26
 */


/**
 * G_IS_VALUE:
 * @value: A #GValue structure.
 *
 * Checks if @value is a valid and initialized #GValue structure.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_MARKUP_ERROR:
 *
 * Error domain for markup parsing.
 * Errors in this domain will be from the #GMarkupError enumeration.
 * See #GError for information on error domains.
 */


/**
 * G_NETWORK_MONITOR_EXTENSION_POINT_NAME:
 *
 * Extension point for network status monitoring functionality.
 * See <link linkend="extending-gio">Extending GIO</link>.
 *
 * Since: 2.30
 */


/**
 * G_NODE_IS_LEAF:
 * @node: a #GNode
 *
 * Returns %TRUE if a #GNode is a leaf node.
 *
 * (i.e. it has no children)
 *
 * Returns: %TRUE if the #GNode is a leaf node
 */


/**
 * G_NODE_IS_ROOT:
 * @node: a #GNode
 *
 * Returns %TRUE if a #GNode is the root of a tree.
 *
 * (i.e. it has no parent or siblings)
 *
 * Returns: %TRUE if the #GNode is the root of a tree
 */


/**
 * G_OBJECT:
 * @object: Object which is subject to casting.
 *
 * Casts a #GObject or derived pointer into a (GObject*) pointer.
 * Depending on the current debugging level, this function may invoke
 * certain runtime checks to identify invalid casts.
 */


/**
 * G_OBJECT_CLASS:
 * @class: a valid #GObjectClass
 *
 * Casts a derived #GObjectClass structure into a #GObjectClass structure.
 */


/**
 * G_OBJECT_CLASS_NAME:
 * @class: a valid #GObjectClass
 *
 * Return the name of a class structure's type.
 *
 * should not be freed.
 *
 * Returns: Type name of @class. The string is owned by the type system and
 */


/**
 * G_OBJECT_CLASS_TYPE:
 * @class: a valid #GObjectClass
 *
 * Get the type id of a class structure.
 *
 * Returns: Type id of @class.
 */


/**
 * G_OBJECT_GET_CLASS:
 * @object: a #GObject instance.
 *
 * Get the class structure associated to a #GObject instance.
 *
 * Returns: pointer to object class structure.
 */


/**
 * G_OBJECT_TYPE:
 * @object: Object to return the type id for.
 *
 * Get the type id of an object.
 *
 * Returns: Type id of @object.
 */


/**
 * G_OBJECT_TYPE_NAME:
 * @object: Object to return the type name for.
 *
 * Get the name of an object's type.
 *
 * should not be freed.
 *
 * Returns: Type name of @object. The string is owned by the type system and
 */


/**
 * G_OBJECT_WARN_INVALID_PROPERTY_ID:
 * @object: the #GObject on which set_property() or get_property() was called
 * @property_id: the numeric id of the property
 * @pspec: the #GParamSpec of the property
 *
 * This macro should be used to emit a standard warning about unexpected
 * properties in set_property() and get_property() implementations.
 */


/**
 * G_OPTION_ERROR:
 *
 * Error domain for option parsing. Errors in this domain will
 * be from the #GOptionError enumeration. See #GError for information on
 * error domains.
 */


/**
 * G_OPTION_REMAINING:
 *
 * If a long option in the main group has this name, it is not treated as a
 * regular option. Instead it collects all non-option arguments which would
 * otherwise be left in <literal>argv</literal>. The option must be of type
 * %G_OPTION_ARG_CALLBACK, %G_OPTION_ARG_STRING_ARRAY
 * or %G_OPTION_ARG_FILENAME_ARRAY.
 *
 *
 * Using #G_OPTION_REMAINING instead of simply scanning <literal>argv</literal>
 * for leftover arguments has the advantage that GOption takes care of
 * necessary encoding conversions for strings or filenames.
 *
 * Since: 2.6
 */


/**
 * G_PARAM_MASK:
 *
 * Mask containing the bits of #GParamSpec.flags which are reserved for GLib.
 */


/**
 * G_PARAM_READWRITE:
 *
 * #GParamFlags value alias for %G_PARAM_READABLE | %G_PARAM_WRITABLE.
 */


/**
 * G_PARAM_SPEC:
 * @pspec: a valid #GParamSpec
 *
 * Casts a derived #GParamSpec object (e.g. of type #GParamSpecInt) into
 * a #GParamSpec object.
 */


/**
 * G_PARAM_SPEC_BOOLEAN:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecBoolean.
 */


/**
 * G_PARAM_SPEC_BOXED:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecBoxed.
 */


/**
 * G_PARAM_SPEC_CHAR:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecChar.
 */


/**
 * G_PARAM_SPEC_CLASS:
 * @pclass: a valid #GParamSpecClass
 *
 * Casts a derived #GParamSpecClass structure into a #GParamSpecClass structure.
 */


/**
 * G_PARAM_SPEC_DOUBLE:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecDouble.
 */


/**
 * G_PARAM_SPEC_ENUM:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecEnum.
 */


/**
 * G_PARAM_SPEC_FLAGS:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecFlags.
 */


/**
 * G_PARAM_SPEC_FLOAT:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecFloat.
 */


/**
 * G_PARAM_SPEC_GET_CLASS:
 * @pspec: a valid #GParamSpec
 *
 * Retrieves the #GParamSpecClass of a #GParamSpec.
 */


/**
 * G_PARAM_SPEC_GTYPE:
 * @pspec: a #GParamSpec
 *
 * Casts a #GParamSpec into a #GParamSpecGType.
 *
 * Since: 2.10
 */


/**
 * G_PARAM_SPEC_INT:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecInt.
 */


/**
 * G_PARAM_SPEC_INT64:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecInt64.
 */


/**
 * G_PARAM_SPEC_LONG:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecLong.
 */


/**
 * G_PARAM_SPEC_OBJECT:
 * @pspec: a valid #GParamSpec instance
 *
 * Casts a #GParamSpec instance into a #GParamSpecObject.
 */


/**
 * G_PARAM_SPEC_OVERRIDE:
 * @pspec: a #GParamSpec
 *
 * Casts a #GParamSpec into a #GParamSpecOverride.
 *
 * Since: 2.4
 */


/**
 * G_PARAM_SPEC_PARAM:
 * @pspec: a valid #GParamSpec instance
 *
 * Casts a #GParamSpec instance into a #GParamSpecParam.
 */


/**
 * G_PARAM_SPEC_POINTER:
 * @pspec: a valid #GParamSpec instance
 *
 * Casts a #GParamSpec instance into a #GParamSpecPointer.
 */


/**
 * G_PARAM_SPEC_STRING:
 * @pspec: a valid #GParamSpec instance
 *
 * Casts a #GParamSpec instance into a #GParamSpecString.
 */


/**
 * G_PARAM_SPEC_TYPE:
 * @pspec: a valid #GParamSpec
 *
 * Retrieves the #GType of this @pspec.
 */


/**
 * G_PARAM_SPEC_TYPE_NAME:
 * @pspec: a valid #GParamSpec
 *
 * Retrieves the #GType name of this @pspec.
 */


/**
 * G_PARAM_SPEC_UCHAR:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecUChar.
 */


/**
 * G_PARAM_SPEC_UINT:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecUInt.
 */


/**
 * G_PARAM_SPEC_UINT64:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecUInt64.
 */


/**
 * G_PARAM_SPEC_ULONG:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecULong.
 */


/**
 * G_PARAM_SPEC_UNICHAR:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecUnichar.
 */


/**
 * G_PARAM_SPEC_VALUE_ARRAY:
 * @pspec: a valid #GParamSpec instance
 *
 * Cast a #GParamSpec instance into a #GParamSpecValueArray.
 */


/**
 * G_PARAM_SPEC_VALUE_TYPE:
 * @pspec: a valid #GParamSpec
 *
 * Retrieves the #GType to initialize a #GValue for this parameter.
 */


/**
 * G_PARAM_SPEC_VARIANT:
 * @pspec: a #GParamSpec
 *
 * Casts a #GParamSpec into a #GParamSpecVariant.
 *
 * Since: 2.26
 */


/**
 * G_PARAM_STATIC_STRINGS:
 *
 * #GParamFlags value alias for %G_PARAM_STATIC_NAME | %G_PARAM_STATIC_NICK | %G_PARAM_STATIC_BLURB.
 *
 * Since 2.13.0
 */


/**
 * G_PARAM_USER_SHIFT:
 *
 * Minimum shift count to be used for user defined flags, to be stored in
 * #GParamSpec.flags. The maximum allowed is 30 + G_PARAM_USER_SHIFT.
 */


/**
 * G_PRIORITY_DEFAULT:
 *
 * Use this for default priority event sources.
 *
 * In GLib this priority is used when adding timeout functions
 * with g_timeout_add(). In GDK this priority is used for events
 * from the X server.
 */


/**
 * G_PRIORITY_DEFAULT_IDLE:
 *
 * Use this for default priority idle functions.
 *
 * In GLib this priority is used when adding idle functions with
 * g_idle_add().
 */


/**
 * G_PRIORITY_HIGH:
 *
 * Use this for high priority event sources.
 *
 * It is not used within GLib or GTK+.
 */


/**
 * G_PRIORITY_HIGH_IDLE:
 *
 * Use this for high priority idle functions.
 *
 * GTK+ uses #G_PRIORITY_HIGH_IDLE + 10 for resizing operations,
 * and #G_PRIORITY_HIGH_IDLE + 20 for redrawing operations. (This is
 * done to ensure that any pending resizes are processed before any
 * pending redraws, so that widgets are not redrawn twice unnecessarily.)
 */


/**
 * G_PRIORITY_LOW:
 *
 * Use this for very low priority background tasks.
 *
 * It is not used within GLib or GTK+.
 */


/**
 * G_PROXY_EXTENSION_POINT_NAME:
 *
 * Extension point for proxy functionality.
 * See <link linkend="extending-gio">Extending GIO</link>.
 *
 * Since: 2.26
 */


/**
 * G_PROXY_RESOLVER_EXTENSION_POINT_NAME:
 *
 * Extension point for proxy resolving functionality.
 * See <link linkend="extending-gio">Extending GIO</link>.
 */


/**
 * G_QUEUE_INIT:
 *
 * A statically-allocated #GQueue must be initialized with this
 * macro before it can be used. This macro can be used to initialize
 * a variable, but it cannot be assigned to a variable. In that case
 * you have to use g_queue_init().
 *
 * |[
 * GQueue my_queue = G_QUEUE_INIT;
 * ]|
 *
 * Since: 2.14
 */


/**
 * G_REGEX_ERROR:
 *
 * Error domain for regular expressions. Errors in this domain will be
 * from the #GRegexError enumeration. See #GError for information on
 * error domains.
 *
 * Since: 2.14
 */


/**
 * G_RESOLVER_ERROR:
 *
 * Error domain for #GResolver. Errors in this domain will be from the
 * #GResolverError enumeration. See #GError for more information on
 * error domains.
 */


/**
 * G_SETTINGS_BACKEND_EXTENSION_POINT_NAME:
 *
 * Extension point for #GSettingsBackend functionality.
 */


/**
 * G_SIGNAL_FLAGS_MASK:
 *
 * A mask for all #GSignalFlags bits.
 */


/**
 * G_SIGNAL_MATCH_MASK:
 *
 * A mask for all #GSignalMatchType bits.
 */


/**
 * G_SIGNAL_TYPE_STATIC_SCOPE:
 *
 * This macro flags signal argument types for which the signal system may
 * assume that instances thereof remain persistent across all signal emissions
 * they are used in. This is only useful for non ref-counted, value-copy types.
 *
 * To flag a signal argument in this way, add
 * <literal>| G_SIGNAL_TYPE_STATIC_SCOPE</literal> to the corresponding argument
 * of g_signal_new().
 * |[
 * g_signal_new ("size_request",
 * G_TYPE_FROM_CLASS (gobject_class),
 * G_SIGNAL_RUN_FIRST,
 * G_STRUCT_OFFSET (GtkWidgetClass, size_request),
 * NULL, NULL,
 * _gtk_marshal_VOID__BOXED,
 * G_TYPE_NONE, 1,
 * GTK_TYPE_REQUISITION | G_SIGNAL_TYPE_STATIC_SCOPE);
 * ]|
 */


/**
 * G_SOURCE_CONTINUE:
 *
 * Use this macro as the return value of a #GSourceFunc to leave
 * the #GSource in the main loop.
 *
 * Since: 2.28
 */


/**
 * G_SOURCE_REMOVE:
 *
 * Use this macro as the return value of a #GSourceFunc to remove
 * the #GSource from the main loop.
 *
 * Since: 2.28
 */


/**
 * G_SPAWN_ERROR:
 *
 * Error domain for spawning processes. Errors in this domain will
 * be from the #GSpawnError enumeration. See #GError for information on
 * error domains.
 */


/**
 * G_TIME_SPAN_DAY:
 *
 * Evaluates to a time span of one day.
 *
 * Since: 2.26
 */


/**
 * G_TIME_SPAN_HOUR:
 *
 * Evaluates to a time span of one hour.
 *
 * Since: 2.26
 */


/**
 * G_TIME_SPAN_MILLISECOND:
 *
 * Evaluates to a time span of one millisecond.
 *
 * Since: 2.26
 */


/**
 * G_TIME_SPAN_MINUTE:
 *
 * Evaluates to a time span of one minute.
 *
 * Since: 2.26
 */


/**
 * G_TIME_SPAN_SECOND:
 *
 * Evaluates to a time span of one second.
 *
 * Since: 2.26
 */


/**
 * G_TLS_BACKEND_EXTENSION_POINT_NAME:
 *
 * Extension point for TLS functionality via #GTlsBackend.
 * See <link linkend="extending-gio">Extending GIO</link>.
 */


/**
 * G_TLS_DATABASE_PURPOSE_AUTHENTICATE_CLIENT:
 *
 * The purpose used to verify the client certificate in a TLS connection.
 * Used by TLS servers.
 */


/**
 * G_TLS_DATABASE_PURPOSE_AUTHENTICATE_SERVER:
 *
 * The purpose used to verify the server certificate in a TLS connection. This
 * is the most common purpose in use. Used by TLS clients.
 */


/**
 * G_TLS_ERROR:
 *
 * Error domain for TLS. Errors in this domain will be from the
 * #GTlsError enumeration. See #GError for more information on error
 * domains.
 */


/**
 * G_TYPE_ARRAY:
 *
 * The #GType for a boxed type holding a #GArray reference.
 *
 * Since: 2.22
 */


/**
 * G_TYPE_BOOLEAN:
 *
 * The fundamental type corresponding to #gboolean.
 */


/**
 * G_TYPE_BOXED:
 *
 * The fundamental type from which all boxed types are derived.
 */


/**
 * G_TYPE_BYTES:
 *
 * The #GType for #GBytes.
 *
 * Since: 2.32
 */


/**
 * G_TYPE_BYTE_ARRAY:
 *
 * The #GType for a boxed type holding a #GByteArray reference.
 *
 * Since: 2.22
 */


/**
 * G_TYPE_CHAR:
 *
 * The fundamental type corresponding to #gchar.
 * The type designated by G_TYPE_CHAR is unconditionally an 8-bit signed integer.
 * This may or may not be the same type a the C type "gchar".
 */


/**
 * G_TYPE_CHECK_CLASS_CAST:
 * @g_class: Location of a #GTypeClass structure.
 * @g_type: The type to be returned.
 * @c_type: The corresponding C type of class structure of @g_type.
 *
 * Checks that @g_class is a class structure of the type identified by @g_type
 * and issues a warning if this is not the case. Returns @g_class casted
 * to a pointer to @c_type.
 *
 * This macro should only be used in type implementations.
 */


/**
 * G_TYPE_CHECK_CLASS_TYPE:
 * @g_class: Location of a #GTypeClass structure.
 * @g_type: The type to be checked.
 *
 * Checks if @g_class is a class structure of the type identified by
 * @g_type.
 *
 * This macro should only be used in type implementations.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_CHECK_INSTANCE:
 * @instance: Location of a #GTypeInstance structure.
 *
 * Checks if @instance is a valid #GTypeInstance structure,
 * otherwise issues a warning and returns %FALSE.
 *
 * This macro should only be used in type implementations.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_CHECK_INSTANCE_CAST:
 * @instance: Location of a #GTypeInstance structure.
 * @g_type: The type to be returned.
 * @c_type: The corresponding C type of @g_type.
 *
 * Checks that @instance is an instance of the type identified by @g_type
 * and issues a warning if this is not the case. Returns @instance casted
 * to a pointer to @c_type.
 *
 * This macro should only be used in type implementations.
 */


/**
 * G_TYPE_CHECK_INSTANCE_TYPE:
 * @instance: Location of a #GTypeInstance structure.
 * @g_type: The type to be checked
 *
 * Checks if @instance is an instance of the type identified by @g_type.
 *
 * This macro should only be used in type implementations.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_CHECK_VALUE:
 * @value: a #GValue
 *
 * Checks if @value has been initialized to hold values
 * of a value type.
 *
 * This macro should only be used in type implementations.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_CHECK_VALUE_TYPE:
 * @value: a #GValue
 * @g_type: The type to be checked.
 *
 * Checks if @value has been initialized to hold values
 * of type @g_type.
 *
 * This macro should only be used in type implementations.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_CLASS_GET_PRIVATE:
 * @klass: the class of a type deriving from @private_type.
 * @g_type: the type identifying which private data to retrieve.
 * @c_type: The C type for the private structure.
 *
 * Gets the private class structure for a particular type.
 * The private structure must have been registered in the
 * get_type() function with g_type_add_class_private().
 *
 * This macro should only be used in type implementations.
 *
 * Since: 2.24
 * Returns: a pointer to the private data structure.
 */


/**
 * G_TYPE_CLOSURE:
 *
 * The #GType for #GClosure.
 */


/**
 * G_TYPE_DATE:
 *
 * The #GType for #GDate.
 */


/**
 * G_TYPE_DATE_TIME:
 *
 * The #GType for a boxed type holding a #GDateTime.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_DBUS_ANNOTATION_INFO:
 *
 * The #GType for a boxed type holding a #GDBusAnnotationInfo.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_DBUS_ARG_INFO:
 *
 * The #GType for a boxed type holding a #GDBusArgInfo.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_DBUS_INTERFACE_INFO:
 *
 * The #GType for a boxed type holding a #GDBusInterfaceInfo.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_DBUS_METHOD_INFO:
 *
 * The #GType for a boxed type holding a #GDBusMethodInfo.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_DBUS_NODE_INFO:
 *
 * The #GType for a boxed type holding a #GDBusNodeInfo.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_DBUS_PROPERTY_INFO:
 *
 * The #GType for a boxed type holding a #GDBusPropertyInfo.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_DBUS_SIGNAL_INFO:
 *
 * The #GType for a boxed type holding a #GDBusSignalInfo.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_DOUBLE:
 *
 * The fundamental type corresponding to #gdouble.
 */


/**
 * G_TYPE_ENUM:
 *
 * The fundamental type from which all enumeration types are derived.
 */


/**
 * G_TYPE_ERROR:
 *
 * The #GType for a boxed type holding a #GError.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_FLAGS:
 *
 * The fundamental type from which all flags types are derived.
 */


/**
 * G_TYPE_FLAG_RESERVED_ID_BIT:
 *
 * A bit in the type number that's supposed to be left untouched.
 */


/**
 * G_TYPE_FLOAT:
 *
 * The fundamental type corresponding to #gfloat.
 */


/**
 * G_TYPE_FROM_CLASS:
 * @g_class: Location of a valid #GTypeClass structure.
 *
 * Get the type identifier from a given @class structure.
 *
 * This macro should only be used in type implementations.
 *
 * Returns: the #GType
 */


/**
 * G_TYPE_FROM_INSTANCE:
 * @instance: Location of a valid #GTypeInstance structure.
 *
 * Get the type identifier from a given @instance structure.
 *
 * This macro should only be used in type implementations.
 *
 * Returns: the #GType
 */


/**
 * G_TYPE_FROM_INTERFACE:
 * @g_iface: Location of a valid #GTypeInterface structure.
 *
 * Get the type identifier from a given @interface structure.
 *
 * This macro should only be used in type implementations.
 *
 * Returns: the #GType
 */


/**
 * G_TYPE_FUNDAMENTAL:
 * @type: A #GType value.
 *
 * The fundamental type which is the ancestor of @type.
 * Fundamental types are types that serve as ultimate bases for the derived types,
 * thus they are the roots of distinct inheritance hierarchies.
 */


/**
 * G_TYPE_FUNDAMENTAL_MAX:
 *
 * An integer constant that represents the number of identifiers reserved
 * for types that are assigned at compile-time.
 */


/**
 * G_TYPE_FUNDAMENTAL_SHIFT:
 *
 * Shift value used in converting numbers to type IDs.
 */


/**
 * G_TYPE_GSTRING:
 *
 * The #GType for #GString.
 */


/**
 * G_TYPE_GTYPE:
 *
 * The type for #GType.
 */


/**
 * G_TYPE_HASH_TABLE:
 *
 * The #GType for a boxed type holding a #GHashTable reference.
 *
 * Since: 2.10
 */


/**
 * G_TYPE_HAS_VALUE_TABLE:
 * @type: A #GType value.
 *
 * Checks if @type has a #GTypeValueTable.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_INITIALLY_UNOWNED:
 *
 * The type for #GInitiallyUnowned.
 */


/**
 * G_TYPE_INSTANCE_GET_CLASS:
 * @instance: Location of the #GTypeInstance structure.
 * @g_type: The #GType of the class to be returned.
 * @c_type: The C type of the class structure.
 *
 * Get the class structure of a given @instance, casted
 * to a specified ancestor type @g_type of the instance.
 *
 * Note that while calling a GInstanceInitFunc(), the class pointer gets
 * modified, so it might not always return the expected pointer.
 *
 * This macro should only be used in type implementations.
 *
 * Returns: a pointer to the class structure
 */


/**
 * G_TYPE_INSTANCE_GET_INTERFACE:
 * @instance: Location of the #GTypeInstance structure.
 * @g_type: The #GType of the interface to be returned.
 * @c_type: The C type of the interface structure.
 *
 * Get the interface structure for interface @g_type of a given @instance.
 *
 * This macro should only be used in type implementations.
 *
 * Returns: a pointer to the interface structure
 */


/**
 * G_TYPE_INSTANCE_GET_PRIVATE:
 * @instance: the instance of a type deriving from @private_type.
 * @g_type: the type identifying which private data to retrieve.
 * @c_type: The C type for the private structure.
 *
 * Gets the private structure for a particular type.
 * The private structure must have been registered in the
 * class_init function with g_type_class_add_private().
 *
 * This macro should only be used in type implementations.
 *
 * Since: 2.4
 * Returns: a pointer to the private data structure.
 */


/**
 * G_TYPE_INT:
 *
 * The fundamental type corresponding to #gint.
 */


/**
 * G_TYPE_INT64:
 *
 * The fundamental type corresponding to #gint64.
 */


/**
 * G_TYPE_INTERFACE:
 *
 * The fundamental type from which all interfaces are derived.
 */


/**
 * G_TYPE_INVALID:
 *
 * An invalid #GType used as error return value in some functions which return
 * a #GType.
 */


/**
 * G_TYPE_IO_CHANNEL:
 *
 * The #GType for #GIOChannel.
 */


/**
 * G_TYPE_IO_CONDITION:
 *
 * The #GType for #GIOCondition.
 */


/**
 * G_TYPE_IS_ABSTRACT:
 * @type: A #GType value.
 *
 * Checks if @type is an abstract type.  An abstract type cannot be
 * instantiated and is normally used as an abstract base class for
 * derived classes.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_IS_CLASSED:
 * @type: A #GType value.
 *
 * Checks if @type is a classed type.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_IS_DEEP_DERIVABLE:
 * @type: A #GType value.
 *
 * Checks if @type is a deep derivable type.  A deep derivable type
 * can be used as the base class of a deep (multi-level) class hierarchy.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_IS_DERIVABLE:
 * @type: A #GType value.
 *
 * Checks if @type is a derivable type.  A derivable type can
 * be used as the base class of a flat (single-level) class hierarchy.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_IS_DERIVED:
 * @type: A #GType value.
 *
 * Checks if @type is derived (or in object-oriented terminology:
 * inherited) from another type (this holds true for all non-fundamental
 * types).
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_IS_ENUM:
 * @type: a #GType ID.
 *
 * Checks whether @type "is a" %G_TYPE_ENUM.
 *
 * Returns: %TRUE if @type "is a" %G_TYPE_ENUM.
 */


/**
 * G_TYPE_IS_FLAGS:
 * @type: a #GType ID.
 *
 * Checks whether @type "is a" %G_TYPE_FLAGS.
 *
 * Returns: %TRUE if @type "is a" %G_TYPE_FLAGS.
 */


/**
 * G_TYPE_IS_FUNDAMENTAL:
 * @type: A #GType value.
 *
 * Checks if @type is a fundamental type.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_IS_INSTANTIATABLE:
 * @type: A #GType value.
 *
 * Checks if @type can be instantiated.  Instantiation is the
 * process of creating an instance (object) of this type.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_IS_INTERFACE:
 * @type: A #GType value.
 *
 * Checks if @type is an interface type.
 * An interface type provides a pure API, the implementation
 * of which is provided by another type (which is then said to conform
 * to the interface).  GLib interfaces are somewhat analogous to Java
 * interfaces and C++ classes containing only pure virtual functions,
 * with the difference that GType interfaces are not derivable (but see
 * g_type_interface_add_prerequisite() for an alternative).
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_IS_OBJECT:
 * @type: Type id to check
 *
 * Check if the passed in type id is a %G_TYPE_OBJECT or derived from it.
 *
 * Returns: %FALSE or %TRUE, indicating whether @type is a %G_TYPE_OBJECT.
 */


/**
 * G_TYPE_IS_PARAM:
 * @type: a #GType ID
 *
 * Checks whether @type "is a" %G_TYPE_PARAM.
 */


/**
 * G_TYPE_IS_VALUE:
 * @type: A #GType value.
 *
 * Checks whether the passed in type ID can be used for g_value_init().
 * That is, this macro checks whether this type provides an implementation
 * of the #GTypeValueTable functions required for a type to create a #GValue of.
 *
 * Returns: Whether @type is suitable as a #GValue type.
 */


/**
 * G_TYPE_IS_VALUE_ABSTRACT:
 * @type: A #GType value.
 *
 * Checks if @type is an abstract value type.  An abstract value type introduces
 * a value table, but can't be used for g_value_init() and is normally used as
 * an abstract base type for derived value types.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_IS_VALUE_TYPE:
 * @type: A #GType value.
 *
 * Checks if @type is a value type and can be used with g_value_init().
 *
 * Returns: %TRUE on success.
 */


/**
 * G_TYPE_KEY_FILE:
 *
 * The #GType for a boxed type holding a #GKeyFile.
 *
 * Since: 2.32
 */


/**
 * G_TYPE_LONG:
 *
 * The fundamental type corresponding to #glong.
 */


/**
 * G_TYPE_MAIN_CONTEXT:
 *
 * The #GType for a boxed type holding a #GMainContext.
 *
 * Since: 2.30
 */


/**
 * G_TYPE_MAIN_LOOP:
 *
 * The #GType for a boxed type holding a #GMainLoop.
 *
 * Since: 2.30
 */


/**
 * G_TYPE_MAKE_FUNDAMENTAL:
 * @x: the fundamental type number.
 *
 * Get the type ID for the fundamental type number @x.
 * Use g_type_fundamental_next() instead of this macro to create new fundamental
 * types.
 *
 * Returns: the GType
 */


/**
 * G_TYPE_MATCH_INFO:
 *
 * The #GType for a boxed type holding a #GMatchInfo reference.
 *
 * Since: 2.30
 */


/**
 * G_TYPE_NONE:
 *
 * A fundamental type which is used as a replacement for the C
 * <literal>void</literal> return type.
 */


/**
 * G_TYPE_OBJECT:
 *
 * The fundamental type for #GObject.
 */


/**
 * G_TYPE_PARAM:
 *
 * The fundamental type from which all #GParamSpec types are derived.
 */


/**
 * G_TYPE_PARAM_BOOLEAN:
 *
 * The #GType of #GParamSpecBoolean.
 */


/**
 * G_TYPE_PARAM_BOXED:
 *
 * The #GType of #GParamSpecBoxed.
 */


/**
 * G_TYPE_PARAM_CHAR:
 *
 * The #GType of #GParamSpecChar.
 */


/**
 * G_TYPE_PARAM_DOUBLE:
 *
 * The #GType of #GParamSpecDouble.
 */


/**
 * G_TYPE_PARAM_ENUM:
 *
 * The #GType of #GParamSpecEnum.
 */


/**
 * G_TYPE_PARAM_FLAGS:
 *
 * The #GType of #GParamSpecFlags.
 */


/**
 * G_TYPE_PARAM_FLOAT:
 *
 * The #GType of #GParamSpecFloat.
 */


/**
 * G_TYPE_PARAM_GTYPE:
 *
 * The #GType of #GParamSpecGType.
 *
 * Since: 2.10
 */


/**
 * G_TYPE_PARAM_INT:
 *
 * The #GType of #GParamSpecInt.
 */


/**
 * G_TYPE_PARAM_INT64:
 *
 * The #GType of #GParamSpecInt64.
 */


/**
 * G_TYPE_PARAM_LONG:
 *
 * The #GType of #GParamSpecLong.
 */


/**
 * G_TYPE_PARAM_OBJECT:
 *
 * The #GType of #GParamSpecObject.
 */


/**
 * G_TYPE_PARAM_OVERRIDE:
 *
 * The #GType of #GParamSpecOverride.
 *
 * Since: 2.4
 */


/**
 * G_TYPE_PARAM_PARAM:
 *
 * The #GType of #GParamSpecParam.
 */


/**
 * G_TYPE_PARAM_POINTER:
 *
 * The #GType of #GParamSpecPointer.
 */


/**
 * G_TYPE_PARAM_STRING:
 *
 * The #GType of #GParamSpecString.
 */


/**
 * G_TYPE_PARAM_UCHAR:
 *
 * The #GType of #GParamSpecUChar.
 */


/**
 * G_TYPE_PARAM_UINT:
 *
 * The #GType of #GParamSpecUInt.
 */


/**
 * G_TYPE_PARAM_UINT64:
 *
 * The #GType of #GParamSpecUInt64.
 */


/**
 * G_TYPE_PARAM_ULONG:
 *
 * The #GType of #GParamSpecULong.
 */


/**
 * G_TYPE_PARAM_UNICHAR:
 *
 * The #GType of #GParamSpecUnichar.
 */


/**
 * G_TYPE_PARAM_VALUE_ARRAY:
 *
 * The #GType of #GParamSpecValueArray.
 */


/**
 * G_TYPE_PARAM_VARIANT:
 *
 * The #GType of #GParamSpecVariant.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_POINTER:
 *
 * The fundamental type corresponding to #gpointer.
 */


/**
 * G_TYPE_PTR_ARRAY:
 *
 * The #GType for a boxed type holding a #GPtrArray reference.
 *
 * Since: 2.22
 */


/**
 * G_TYPE_REGEX:
 *
 * The #GType for a boxed type holding a #GRegex reference.
 *
 * Since: 2.14
 */


/**
 * G_TYPE_RESERVED_BSE_FIRST:
 *
 * First fundamental type number to create a new fundamental type id with
 * G_TYPE_MAKE_FUNDAMENTAL() reserved for BSE.
 */


/**
 * G_TYPE_RESERVED_BSE_LAST:
 *
 * Last fundamental type number reserved for BSE.
 */


/**
 * G_TYPE_RESERVED_GLIB_FIRST:
 *
 * First fundamental type number to create a new fundamental type id with
 * G_TYPE_MAKE_FUNDAMENTAL() reserved for GLib.
 */


/**
 * G_TYPE_RESERVED_GLIB_LAST:
 *
 * Last fundamental type number reserved for GLib.
 */


/**
 * G_TYPE_RESERVED_USER_FIRST:
 *
 * First available fundamental type number to create new fundamental
 * type id with G_TYPE_MAKE_FUNDAMENTAL().
 */


/**
 * G_TYPE_SETTINGS_SCHEMA:
 *
 * A boxed #GType corresponding to #GSettingsSchema.
 *
 * Since: 2.32
 */


/**
 * G_TYPE_SETTINGS_SCHEMA_SOURCE:
 *
 * A boxed #GType corresponding to #GSettingsSchemaSource.
 *
 * Since: 2.32
 */


/**
 * G_TYPE_SOURCE:
 *
 * The #GType for a boxed type holding a #GSource.
 *
 * Since: 2.30
 */


/**
 * G_TYPE_STRING:
 *
 * The fundamental type corresponding to nul-terminated C strings.
 */


/**
 * G_TYPE_STRV:
 *
 * The #GType for a boxed type holding a %NULL-terminated array of strings.
 *
 * The code fragments in the following example show the use of a property of
 * type #G_TYPE_STRV with g_object_class_install_property(), g_object_set()
 * and g_object_get().
 *
 * |[
 * g_object_class_install_property (object_class,
 * PROP_AUTHORS,
 * g_param_spec_boxed ("authors",
 * _("Authors"),
 * _("List of authors"),
 * G_TYPE_STRV,
 * G_PARAM_READWRITE));
 *
 * gchar *authors[] = { "Owen", "Tim", NULL };
 * g_object_set (obj, "authors", authors, NULL);
 *
 * gchar *writers[];
 * g_object_get (obj, "authors", &writers, NULL);
 * /&ast; do something with writers &ast;/
 * g_strfreev (writers);
 * ]|
 *
 * Since: 2.4
 */


/**
 * G_TYPE_UCHAR:
 *
 * The fundamental type corresponding to #guchar.
 */


/**
 * G_TYPE_UINT:
 *
 * The fundamental type corresponding to #guint.
 */


/**
 * G_TYPE_UINT64:
 *
 * The fundamental type corresponding to #guint64.
 */


/**
 * G_TYPE_ULONG:
 *
 * The fundamental type corresponding to #gulong.
 */


/**
 * G_TYPE_VALUE:
 *
 * The type ID of the "GValue" type which is a boxed type,
 * used to pass around pointers to GValues.
 */


/**
 * G_TYPE_VALUE_ARRAY:
 *
 * The type ID of the "GValueArray" type which is a boxed type,
 * used to pass around pointers to GValueArrays.
 */


/**
 * G_TYPE_VARIANT:
 *
 * The fundamental type corresponding to #GVariant.
 *
 * All floating #GVariant instances passed through the #GType system are
 * consumed.
 *
 * Note that callbacks in closures, and signal handlers
 * for signals of return type %G_TYPE_VARIANT, must never return floating
 * variants.
 *
 * Note: GLib 2.24 did include a boxed type with this name. It was replaced
 * with this fundamental type in 2.26.
 *
 * Since: 2.26
 */


/**
 * G_TYPE_VARIANT_BUILDER:
 *
 * The #GType for a boxed type holding a #GVariantBuilder.
 *
 * Since: 2.30
 */


/**
 * G_TYPE_VARIANT_TYPE:
 *
 * The #GType for a boxed type holding a #GVariantType.
 *
 * Since: 2.24
 */


/**
 * G_UNICHAR_MAX_DECOMPOSITION_LENGTH:
 *
 * The maximum length (in codepoints) of a compatibility or canonical
 * decomposition of a single Unicode character.
 *
 * This is as defined by Unicode 6.1.
 *
 * Since: 2.32
 */


/**
 * G_UNICODE_COMBINING_MARK:
 *
 * Older name for %G_UNICODE_SPACING_MARK.
 *
 * Deprecated: 2.30: Use %G_UNICODE_SPACING_MARK.
 */


/**
 * G_URI_RESERVED_CHARS_ALLOWED_IN_PATH:
 *
 * Allowed characters in a path. Includes "!$&'()*+,;=:@/".
 */


/**
 * G_URI_RESERVED_CHARS_ALLOWED_IN_PATH_ELEMENT:
 *
 * Allowed characters in path elements. Includes "!$&'()*+,;=:@".
 */


/**
 * G_URI_RESERVED_CHARS_ALLOWED_IN_USERINFO:
 *
 * Allowed characters in userinfo as defined in RFC 3986. Includes "!$&'()*+,;=:".
 */


/**
 * G_URI_RESERVED_CHARS_GENERIC_DELIMITERS:
 *
 * Generic delimiters characters as defined in RFC 3986. Includes ":/?#[]@".
 */


/**
 * G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS:
 *
 * Subcomponent delimiter characters as defined in RFC 3986. Includes "!$&'()*+,;=".
 */


/**
 * G_VALUE_HOLDS:
 * @value: A #GValue structure.
 * @type: A #GType value.
 *
 * Checks if @value holds (or contains) a value of @type.
 * This macro will also check for @value != %NULL and issue a
 * warning if the check fails.
 *
 * Returns: %TRUE if @value holds the @type.
 */


/**
 * G_VALUE_HOLDS_BOOLEAN:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_BOOLEAN.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_BOXED:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values derived
 * from type %G_TYPE_BOXED.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_CHAR:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_CHAR.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_DOUBLE:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_DOUBLE.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_ENUM:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values derived from type %G_TYPE_ENUM.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_FLAGS:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values derived from type %G_TYPE_FLAGS.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_FLOAT:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_FLOAT.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_GTYPE:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_GTYPE.
 *
 * Since: 2.12
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_INT:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_INT.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_INT64:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_INT64.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_LONG:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_LONG.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_OBJECT:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values derived from type %G_TYPE_OBJECT.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_PARAM:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values derived from type %G_TYPE_PARAM.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_POINTER:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_POINTER.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_STRING:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_STRING.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_UCHAR:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_UCHAR.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_UINT:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_UINT.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_UINT64:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_UINT64.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_ULONG:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_ULONG.
 *
 * Returns: %TRUE on success.
 */


/**
 * G_VALUE_HOLDS_VARIANT:
 * @value: a valid #GValue structure
 *
 * Checks whether the given #GValue can hold values of type %G_TYPE_VARIANT.
 *
 * Returns: %TRUE on success.
 * Since: 2.26
 */


/**
 * G_VALUE_INIT:
 *
 * A #GValue must be initialized before it can be used.
 * This macro can be used as initializer instead of an explicit
 * <literal>{ 0 }</literal> when declaring a variable,
 * but it cannot be assigned to a variable.
 *
 * |[
 * GValue value = G_VALUE_INIT;
 * ]|
 *
 * Since: 2.30
 */


/**
 * G_VALUE_NOCOPY_CONTENTS:
 *
 * If passed to G_VALUE_COLLECT(), allocated data won't be copied
 * but used verbatim. This does not affect ref-counted types like
 * objects.
 */


/**
 * G_VALUE_TYPE:
 * @value: A #GValue structure.
 *
 * Get the type identifier of @value.
 *
 * Returns: the #GType.
 */


/**
 * G_VALUE_TYPE_NAME:
 * @value: A #GValue structure.
 *
 * Gets the the type name of @value.
 *
 * Returns: the type name.
 */


/**
 * G_VARIANT_TYPE:
 * @type_string: a well-formed #GVariantType type string
 *
 * Converts a string to a const #GVariantType.  Depending on the
 * current debugging level, this function may perform a runtime check
 * to ensure that @string is a valid GVariant type string.
 *
 * It is always a programmer error to use this macro with an invalid
 * type string. If in doubt, use g_variant_type_string_is_valid() to
 * check if the string is valid.
 *
 * Since 2.24
 */


/**
 * G_VARIANT_TYPE_ANY:
 *
 * An indefinite type that is a supertype of every type (including
 * itself).
 */


/**
 * G_VARIANT_TYPE_ARRAY:
 *
 * An indefinite type that is a supertype of every array type.
 */


/**
 * G_VARIANT_TYPE_BASIC:
 *
 * An indefinite type that is a supertype of every basic (ie:
 * non-container) type.
 */


/**
 * G_VARIANT_TYPE_BOOLEAN:
 *
 * The type of a value that can be either %TRUE or %FALSE.
 */


/**
 * G_VARIANT_TYPE_BYTE:
 *
 * The type of an integer value that can range from 0 to 255.
 */


/**
 * G_VARIANT_TYPE_BYTESTRING:
 *
 * The type of an array of bytes.  This type is commonly used to pass
 * around strings that may not be valid utf8.  In that case, the
 * convention is that the nul terminator character should be included as
 * the last character in the array.
 */


/**
 * G_VARIANT_TYPE_BYTESTRING_ARRAY:
 *
 * The type of an array of byte strings (an array of arrays of bytes).
 */


/**
 * G_VARIANT_TYPE_DICTIONARY:
 *
 * An indefinite type that is a supertype of every dictionary type --
 * that is, any array type that has an element type equal to any
 * dictionary entry type.
 */


/**
 * G_VARIANT_TYPE_DICT_ENTRY:
 *
 * An indefinite type that is a supertype of every dictionary entry
 * type.
 */


/**
 * G_VARIANT_TYPE_DOUBLE:
 *
 * The type of a double precision IEEE754 floating point number.
 * These guys go up to about 1.80e308 (plus and minus) but miss out on
 * some numbers in between.  In any case, that's far greater than the
 * estimated number of fundamental particles in the observable
 * universe.
 */


/**
 * G_VARIANT_TYPE_HANDLE:
 *
 * The type of a 32bit signed integer value, that by convention, is used
 * as an index into an array of file descriptors that are sent alongside
 * a D-Bus message.
 *
 * If you are not interacting with D-Bus, then there is no reason to make
 * use of this type.
 */


/**
 * G_VARIANT_TYPE_INT16:
 *
 * The type of an integer value that can range from -32768 to 32767.
 */


/**
 * G_VARIANT_TYPE_INT32:
 *
 * The type of an integer value that can range from -2147483648 to
 * 2147483647.
 */


/**
 * G_VARIANT_TYPE_INT64:
 *
 * The type of an integer value that can range from
 * -9223372036854775808 to 9223372036854775807.
 */


/**
 * G_VARIANT_TYPE_MAYBE:
 *
 * An indefinite type that is a supertype of every maybe type.
 */


/**
 * G_VARIANT_TYPE_OBJECT_PATH:
 *
 * The type of a D-Bus object reference.  These are strings of a
 * specific format used to identify objects at a given destination on
 * the bus.
 *
 * If you are not interacting with D-Bus, then there is no reason to make
 * use of this type.  If you are, then the D-Bus specification contains a
 * precise description of valid object paths.
 */


/**
 * G_VARIANT_TYPE_OBJECT_PATH_ARRAY:
 *
 * The type of an array of object paths.
 */


/**
 * G_VARIANT_TYPE_SIGNATURE:
 *
 * The type of a D-Bus type signature.  These are strings of a specific
 * format used as type signatures for D-Bus methods and messages.
 *
 * If you are not interacting with D-Bus, then there is no reason to make
 * use of this type.  If you are, then the D-Bus specification contains a
 * precise description of valid signature strings.
 */


/**
 * G_VARIANT_TYPE_STRING:
 *
 * The type of a string.  "" is a string.  %NULL is not a string.
 */


/**
 * G_VARIANT_TYPE_STRING_ARRAY:
 *
 * The type of an array of strings.
 */


/**
 * G_VARIANT_TYPE_TUPLE:
 *
 * An indefinite type that is a supertype of every tuple type,
 * regardless of the number of items in the tuple.
 */


/**
 * G_VARIANT_TYPE_UINT16:
 *
 * The type of an integer value that can range from 0 to 65535.
 * There were about this many people living in Toronto in the 1870s.
 */


/**
 * G_VARIANT_TYPE_UINT32:
 *
 * The type of an integer value that can range from 0 to 4294967295.
 * That's one number for everyone who was around in the late 1970s.
 */


/**
 * G_VARIANT_TYPE_UINT64:
 *
 * The type of an integer value that can range from 0 to
 * 18446744073709551616.  That's a really big number, but a Rubik's
 * cube can have a bit more than twice as many possible positions.
 */


/**
 * G_VARIANT_TYPE_UNIT:
 *
 * The empty tuple type.  Has only one instance.  Known also as "triv"
 * or "void".
 */


/**
 * G_VARIANT_TYPE_VARDICT:
 *
 * The type of a dictionary mapping strings to variants (the ubiquitous
 * "a{sv}" type).
 *
 * Since: 2.30
 */


/**
 * G_VARIANT_TYPE_VARIANT:
 *
 * The type of a box that contains any other value (including another
 * variant).
 */


/**
 * G_VFS_EXTENSION_POINT_NAME:
 *
 * Extension point for #GVfs functionality.
 * See <link linkend="extending-gio">Extending GIO</link>.
 */


/**
 * G_VOLUME_IDENTIFIER_KIND_HAL_UDI:
 *
 * The string used to obtain a Hal UDI with g_volume_get_identifier().
 */


/**
 * G_VOLUME_IDENTIFIER_KIND_LABEL:
 *
 * The string used to obtain a filesystem label with g_volume_get_identifier().
 */


/**
 * G_VOLUME_IDENTIFIER_KIND_NFS_MOUNT:
 *
 * The string used to obtain a NFS mount with g_volume_get_identifier().
 */


/**
 * G_VOLUME_IDENTIFIER_KIND_UNIX_DEVICE:
 *
 * The string used to obtain a Unix device path with g_volume_get_identifier().
 */


/**
 * G_VOLUME_IDENTIFIER_KIND_UUID:
 *
 * The string used to obtain a UUID with g_volume_get_identifier().
 */


/**
 * G_VOLUME_MONITOR_EXTENSION_POINT_NAME:
 *
 * Extension point for volume monitor functionality.
 * See <link linkend="extending-gio">Extending GIO</link>.
 */


/**
 * SECTION:extensionpoints
 * @short_description: Extension Points
 * @include: gio.h
 * @see_also: <link linkend="extending-gio">Extending GIO</link>
 *
 * #GIOExtensionPoint provides a mechanism for modules to extend the
 * functionality of the library or application that loaded it in an
 * organized fashion.
 *
 * An extension point is identified by a name, and it may optionally
 * require that any implementation must by of a certain type (or derived
 * thereof). Use g_io_extension_point_register() to register an
 * extension point, and g_io_extension_point_set_required_type() to
 * set a required type.
 *
 * A module can implement an extension point by specifying the #GType
 * that implements the functionality. Additionally, each implementation
 * of an extension point has a name, and a priority. Use
 * g_io_extension_point_implement() to implement an extension point.
 *
 * |[
 * GIOExtensionPoint *ep;
 *
 * /&ast; Register an extension point &ast;/
 * ep = g_io_extension_point_register ("my-extension-point");
 * g_io_extension_point_set_required_type (ep, MY_TYPE_EXAMPLE);
 * ]|
 *
 * |[
 * /&ast; Implement an extension point &ast;/
 * G_DEFINE_TYPE (MyExampleImpl, my_example_impl, MY_TYPE_EXAMPLE);
 * g_io_extension_point_implement ("my-extension-point",
 * my_example_impl_get_type (),
 * "my-example",
 * 10);
 * ]|
 *
 * It is up to the code that registered the extension point how
 * it uses the implementations that have been associated with it.
 * Depending on the use case, it may use all implementations, or
 * only the one with the highest priority, or pick a specific
 * one by name.
 *
 * To avoid opening all modules just to find out what extension
 * points they implement, GIO makes use of a caching mechanism,
 * see <link linkend="gio-querymodules">gio-querymodules</link>.
 * You are expected to run this command after installing a
 * GIO module.
 *
 * The <envar>GIO_EXTRA_MODULES</envar> environment variable can be
 * used to specify additional directories to automatically load modules
 * from. This environment variable has the same syntax as the
 * <envar>PATH</envar>. If two modules have the same base name in different
 * directories, then the latter one will be ignored. If additional
 * directories are specified GIO will load modules from the built-in
 * directory last.
 */


/**
 * SECTION:gaction
 * @title: GAction
 * @short_description: An action interface
 *
 * #GAction represents a single named action.
 *
 * The main interface to an action is that it can be activated with
 * g_action_activate().  This results in the 'activate' signal being
 * emitted.  An activation has a #GVariant parameter (which may be
 * %NULL).  The correct type for the parameter is determined by a static
 * parameter type (which is given at construction time).
 *
 * An action may optionally have a state, in which case the state may be
 * set with g_action_change_state().  This call takes a #GVariant.  The
 * correct type for the state is determined by a static state type
 * (which is given at construction time).
 *
 * The state may have a hint associated with it, specifying its valid
 * range.
 *
 * #GAction is merely the interface to the concept of an action, as
 * described above.  Various implementations of actions exist, including
 * #GSimpleAction and #GtkAction.
 *
 * In all cases, the implementing class is responsible for storing the
 * name of the action, the parameter type, the enabled state, the
 * optional state type and the state and emitting the appropriate
 * signals when these change.  The implementor responsible for filtering
 * calls to g_action_activate() and g_action_change_state() for type
 * safety and for the state being enabled.
 *
 * Probably the only useful thing to do with a #GAction is to put it
 * inside of a #GSimpleActionGroup.
 */


/**
 * SECTION:gactiongroup
 * @title: GActionGroup
 * @short_description: A group of actions
 * @see_also: #GAction
 *
 * #GActionGroup represents a group of actions. Actions can be used to
 * expose functionality in a structured way, either from one part of a
 * program to another, or to the outside world. Action groups are often
 * used together with a #GMenuModel that provides additional
 * representation data for displaying the actions to the user, e.g. in
 * a menu.
 *
 * The main way to interact with the actions in a GActionGroup is to
 * activate them with g_action_group_activate_action(). Activating an
 * action may require a #GVariant parameter. The required type of the
 * parameter can be inquired with g_action_group_get_action_parameter_type().
 * Actions may be disabled, see g_action_group_get_action_enabled().
 * Activating a disabled action has no effect.
 *
 * Actions may optionally have a state in the form of a #GVariant. The
 * current state of an action can be inquired with
 * g_action_group_get_action_state(). Activating a stateful action may
 * change its state, but it is also possible to set the state by calling
 * g_action_group_change_action_state().
 *
 * As typical example, consider a text editing application which has an
 * option to change the current font to 'bold'. A good way to represent
 * this would be a stateful action, with a boolean state. Activating the
 * action would toggle the state.
 *
 * Each action in the group has a unique name (which is a string).  All
 * method calls, except g_action_group_list_actions() take the name of
 * an action as an argument.
 *
 * The #GActionGroup API is meant to be the 'public' API to the action
 * group.  The calls here are exactly the interaction that 'external
 * forces' (eg: UI, incoming D-Bus messages, etc.) are supposed to have
 * with actions.  'Internal' APIs (ie: ones meant only to be accessed by
 * the action group implementation) are found on subclasses.  This is
 * why you will find - for example - g_action_group_get_action_enabled()
 * but not an equivalent <function>set()</function> call.
 *
 * Signals are emitted on the action group in response to state changes
 * on individual actions.
 *
 * Implementations of #GActionGroup should provide implementations for
 * the virtual functions g_action_group_list_actions() and
 * g_action_group_query_action().  The other virtual functions should
 * not be implemented - their "wrappers" are actually implemented with
 * calls to g_action_group_query_action().
 */


/**
 * SECTION:gactiongroupexporter
 * @title: GActionGroup exporter
 * @short_description: Export GActionGroups on D-Bus
 * @see_also: #GActionGroup, #GDBusActionGroup
 *
 * These functions support exporting a #GActionGroup on D-Bus.
 * The D-Bus interface that is used is a private implementation
 * detail.
 *
 * To access an exported #GActionGroup remotely, use
 * g_dbus_action_group_new() to obtain a #GDBusActionGroup.
 */


/**
 * SECTION:gactionmap
 * @title: GActionMap
 * @short_description: Interface for action containers
 *
 * The GActionMap interface is implemented by #GActionGroup
 * implementations that operate by containing a number of
 * named #GAction instances, such as #GSimpleActionGroup.
 *
 * One useful application of this interface is to map the
 * names of actions from various action groups to unique,
 * prefixed names (e.g. by prepending "app." or "win.").
 * This is the motivation for the 'Map' part of the interface
 * name.
 *
 * Since: 2.32
 */


/**
 * SECTION:gappinfo
 * @short_description: Application information and launch contexts
 * @include: gio/gio.h
 *
 * #GAppInfo and #GAppLaunchContext are used for describing and launching
 * applications installed on the system.
 *
 * As of GLib 2.20, URIs will always be converted to POSIX paths
 * (using g_file_get_path()) when using g_app_info_launch() even if
 * the application requested an URI and not a POSIX path. For example
 * for an desktop-file based application with Exec key <literal>totem
 * &percnt;U</literal> and a single URI,
 * <literal>sftp://foo/file.avi</literal>, then
 * <literal>/home/user/.gvfs/sftp on foo/file.avi</literal> will be
 * passed. This will only work if a set of suitable GIO extensions
 * (such as gvfs 2.26 compiled with FUSE support), is available and
 * operational; if this is not the case, the URI will be passed
 * unmodified to the application. Some URIs, such as
 * <literal>mailto:</literal>, of course cannot be mapped to a POSIX
 * path (in gvfs there's no FUSE mount for it); such URIs will be
 * passed unmodified to the application.
 *
 * Specifically for gvfs 2.26 and later, the POSIX URI will be mapped
 * back to the GIO URI in the #GFile constructors (since gvfs
 * implements the #GVfs extension point). As such, if the application
 * needs to examine the URI, it needs to use g_file_get_uri() or
 * similar on #GFile. In other words, an application cannot assume
 * that the URI passed to e.g. g_file_new_for_commandline_arg() is
 * equal to the result of g_file_get_uri(). The following snippet
 * illustrates this:
 *
 * <programlisting>
 * GFile *f;
 * char *uri;
 *
 * file = g_file_new_for_commandline_arg (uri_from_commandline);
 *
 * uri = g_file_get_uri (file);
 * strcmp (uri, uri_from_commandline) == 0; // FALSE
 * g_free (uri);
 *
 * if (g_file_has_uri_scheme (file, "cdda"))
 * {
 * // do something special with uri
 * }
 * g_object_unref (file);
 * </programlisting>
 *
 * This code will work when both <literal>cdda://sr0/Track
 * 1.wav</literal> and <literal>/home/user/.gvfs/cdda on sr0/Track
 * 1.wav</literal> is passed to the application. It should be noted
 * that it's generally not safe for applications to rely on the format
 * of a particular URIs. Different launcher applications (e.g. file
 * managers) may have different ideas of what a given URI means.
 */


/**
 * SECTION:gapplication
 * @title: GApplication
 * @short_description: Core application class
 *
 * A #GApplication is the foundation of an application, unique for a
 * given application identifier.  The GApplication class wraps some
 * low-level platform-specific services and is intended to act as the
 * foundation for higher-level application classes such as
 * #GtkApplication or #MxApplication.  In general, you should not use
 * this class outside of a higher level framework.
 *
 * One of the core features that GApplication provides is process
 * uniqueness, in the context of a "session".  The session concept is
 * platform-dependent, but corresponds roughly to a graphical desktop
 * login.  When your application is launched again, its arguments
 * are passed through platform communication to the already running
 * program. The already running instance of the program is called the
 * <firstterm>primary instance</firstterm>. On Linux, the D-Bus session
 * bus is used for communication.
 *
 * GApplication provides convenient life cycle management by maintaining
 * a <firstterm>use count</firstterm> for the primary application instance.
 * The use count can be changed using g_application_hold() and
 * g_application_release(). If it drops to zero, the application exits.
 * Higher-level classes such as #GtkApplication employ the use count to
 * ensure that the application stays alive as long as it has any opened
 * windows.
 *
 * Before using GApplication, you must choose an "application identifier".
 * The expected form of an application identifier is very close to that of
 * of a <ulink url="http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names-interface">DBus bus name</ulink>.
 * Examples include: "com.example.MyApp", "org.example.internal-apps.Calculator".
 * For details on valid application identifiers, see g_application_id_is_valid().
 *
 * On Linux, the application identifier is claimed as a well-known bus name
 * on the user's session bus.  This means that the uniqueness of your
 * application is scoped to the current session.  It also means that your
 * application may provide additional services (through registration of other
 * object paths) at that bus name.  The registration of these object paths
 * should be done with the shared GDBus session bus.  Note that due to the
 * internal architecture of GDBus, method calls can be dispatched at any time
 * (even if a main loop is not running).  For this reason, you must ensure that
 * any object paths that you wish to register are registered before #GApplication
 * attempts to acquire the bus name of your application (which happens in
 * g_application_register()).  Unfortunately, this means that you cannot use
 * g_application_get_is_remote() to decide if you want to register object paths.
 *
 * GApplication also implements the #GActionGroup and #GActionMap
 * interfaces and lets you easily export actions by adding them with
 * g_action_map_add_action(). When invoking an action by calling
 * g_action_group_activate_action() on the application, it is always
 * invoked in the primary instance. The actions are also exported on
 * the session bus, and GIO provides the #GDBusActionGroup wrapper to
 * conveniently access them remotely. Additionally, g_application_set_app_menu()
 * and g_application_set_menubar() can be used to export representation
 * data for the actions, in the form of #GMenuModels. GIO provides
 * a #GDBusMenuModel wrapper for remote access to exported #GMenuModels.
 *
 * There is a number of different entry points into a GApplication:
 * <itemizedlist>
 * <listitem>via 'Activate' (i.e. just starting the application)</listitem>
 * <listitem>via 'Open' (i.e. opening some files)</listitem>
 * <listitem>by handling a command-line</listitem>
 * <listitem>via activating an action</listitem>
 * </itemizedlist>
 * The #GApplication::startup signal lets you handle the application
 * initialization for all of these in a single place.
 *
 * Regardless of which of these entry points is used to start the application,
 * GApplication passes some <firstterm id="platform-data">platform
 * data</firstterm> from the launching instance to the primary instance,
 * in the form of a #GVariant dictionary mapping strings to variants.
 * To use platform data, override the @before_emit or @after_emit virtual
 * functions in your #GApplication subclass. When dealing with
 * #GApplicationCommandline objects, the platform data is directly
 * available via g_application_command_line_get_cwd(),
 * g_application_command_line_get_environ() and
 * g_application_command_line_get_platform_data().
 *
 * As the name indicates, the platform data may vary depending on the
 * operating system, but it always includes the current directory (key
 * "cwd"), and optionally the environment (ie the set of environment
 * variables and their values) of the calling process (key "environ").
 * The environment is only added to the platform data if the
 * #G_APPLICATION_SEND_ENVIONMENT flag is set. GApplication subclasses
 * can add their own platform data by overriding the @add_platform_data
 * virtual function. For instance, #GtkApplication adds startup notification
 * data in this way.
 *
 * To parse commandline arguments you may handle the
 * #GApplication::command-line signal or override the local_command_line()
 * vfunc, to parse them in either the primary instance or the local instance,
 * respectively.
 *
 * <example id="gapplication-example-open"><title>Opening files with a GApplication</title>
 * <programlisting>
 * <xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gapplication-example-open.c">
 * <xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback>
 * </xi:include>
 * </programlisting>
 * </example>
 *
 * <example id="gapplication-example-actions"><title>A GApplication with actions</title>
 * <programlisting>
 * <xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gapplication-example-actions.c">
 * <xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback>
 * </xi:include>
 * </programlisting>
 * </example>
 *
 * <example id="gapplication-example-menu"><title>A GApplication with menus</title>
 * <programlisting>
 * <xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gapplication-example-menu.c">
 * <xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback>
 * </xi:include>
 * </programlisting>
 * </example>
 */


/**
 * SECTION:gapplicationcommandline
 * @title: GApplicationCommandLine
 * @short_description: A command-line invocation of an application
 * @see_also: #GApplication
 *
 * #GApplicationCommandLine represents a command-line invocation of
 * an application.  It is created by #GApplication and emitted
 * in the #GApplication::command-line signal and virtual function.
 *
 * The class contains the list of arguments that the program was invoked
 * with.  It is also possible to query if the commandline invocation was
 * local (ie: the current process is running in direct response to the
 * invocation) or remote (ie: some other process forwarded the
 * commandline to this process).
 *
 * The GApplicationCommandLine object can provide the @argc and @argv
 * parameters for use with the #GOptionContext command-line parsing API,
 * with the g_application_command_line_get_arguments() function. See
 * <xref linkend="gapplication-example-cmdline3"/> for an example.
 *
 * The exit status of the originally-invoked process may be set and
 * messages can be printed to stdout or stderr of that process.  The
 * lifecycle of the originally-invoked process is tied to the lifecycle
 * of this object (ie: the process exits when the last reference is
 * dropped).
 *
 * The main use for #GApplicationCommandline (and the
 * #GApplication::command-line signal) is 'Emacs server' like use cases:
 * You can set the <envar>EDITOR</envar> environment variable to have
 * e.g. git use your favourite editor to edit commit messages, and if you
 * already have an instance of the editor running, the editing will happen
 * in the running instance, instead of opening a new one. An important
 * aspect of this use case is that the process that gets started by git
 * does not return until the editing is done.
 *
 * <example id="gapplication-example-cmdline"><title>Handling commandline arguments with GApplication</title>
 * <para>
 * A simple example where the commandline is completely handled
 * in the #GApplication::command-line handler. The launching instance exits
 * once the signal handler in the primary instance has returned, and the
 * return value of the signal handler becomes the exit status of the launching
 * instance.
 * </para>
 * <programlisting>
 * <xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gapplication-example-cmdline.c">
 * <xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback>
 * </xi:include>
 * </programlisting>
 * </example>
 *
 * <example id="gapplication-example-cmdline2"><title>Split commandline handling</title>
 * <para>
 * An example of split commandline handling. Options that start with
 * <literal>--local-</literal> are handled locally, all other options are
 * passed to the #GApplication::command-line handler which runs in the primary
 * instance.
 * </para>
 * <programlisting>
 * <xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gapplication-example-cmdline2.c">
 * <xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback>
 * </xi:include>
 * </programlisting>
 * </example>
 *
 * <example id="gapplication-example-cmdline3"><title>Deferred commandline handling</title>
 * <para>
 * An example of deferred commandline handling. Here, the commandline is
 * not completely handled before the #GApplication::command-line handler
 * returns. Instead, we keep a reference to the GApplicationCommandline
 * object and handle it later(in this example, in an idle). Note that it
 * is necessary to hold the application until you are done with the
 * commandline.
 * </para>
 * <para>
 * This example also shows how to use #GOptionContext for parsing the
 * commandline arguments. Note that it is necessary to disable the
 * built-in help-handling of #GOptionContext, since it calls exit()
 * after printing help, which is not what you want to happen in
 * the primary instance.
 * </para>
 * <programlisting>
 * <xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gapplication-example-cmdline3.c">
 * <xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback>
 * </xi:include>
 * </programlisting>
 * </example>
 */


/**
 * SECTION:gasyncinitable
 * @short_description: Asynchronously failable object initialization interface
 * @include: gio/gio.h
 * @see_also: #GInitable
 *
 * This is the asynchronous version of #GInitable; it behaves the same
 * in all ways except that initialization is asynchronous. For more details
 * see the descriptions on #GInitable.
 *
 * A class may implement both the #GInitable and #GAsyncInitable interfaces.
 *
 * Users of objects implementing this are not intended to use the interface
 * method directly; instead it will be used automatically in various ways.
 * For C applications you generally just call g_async_initable_new_async()
 * directly, or indirectly via a foo_thing_new_async() wrapper. This will call
 * g_async_initable_init_async() under the cover, calling back with %NULL and
 * a set %GError on failure.
 *
 * A typical implementation might look something like this:
 *
 * |[
 * enum {
 * NOT_INITIALIZED,
 * INITIALIZING,
 * INITIALIZED
 * };
 *
 * static void
 * _foo_ready_cb (Foo *self)
 * {
 * GList *l;
 *
 * self->priv->state = INITIALIZED;
 *
 * for (l = self->priv->init_results; l != NULL; l = l->next)
 * {
 * GSimpleAsyncResult *simple = l->data;
 *
 * if (!self->priv->success)
 * g_simple_async_result_set_error (simple, ...);
 *
 * g_simple_async_result_complete (simple);
 * g_object_unref (simple);
 * }
 *
 * g_list_free (self->priv->init_results);
 * self->priv->init_results = NULL;
 * }
 *
 * static void
 * foo_init_async (GAsyncInitable       *initable,
 * int                   io_priority,
 * GCancellable         *cancellable,
 * GAsyncReadyCallback   callback,
 * gpointer              user_data)
 * {
 * Foo *self = FOO (initable);
 * GSimpleAsyncResult *simple;
 *
 * simple = g_simple_async_result_new (G_OBJECT (initable)
 * callback,
 * user_data,
 * foo_init_async);
 *
 * switch (self->priv->state)
 * {
 * case NOT_INITIALIZED:
 * _foo_get_ready (self);
 * self->priv->init_results = g_list_append (self->priv->init_results,
 * simple);
 * self->priv->state = INITIALIZING;
 * break;
 * case INITIALIZING:
 * self->priv->init_results = g_list_append (self->priv->init_results,
 * simple);
 * break;
 * case INITIALIZED:
 * if (!self->priv->success)
 * g_simple_async_result_set_error (simple, ...);
 *
 * g_simple_async_result_complete_in_idle (simple);
 * g_object_unref (simple);
 * break;
 * }
 * }
 *
 * static gboolean
 * foo_init_finish (GAsyncInitable       *initable,
 * GAsyncResult         *result,
 * GError              **error)
 * {
 * g_return_val_if_fail (g_simple_async_result_is_valid (result,
 * G_OBJECT (initable), foo_init_async), FALSE);
 *
 * if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (result),
 * error))
 * return FALSE;
 *
 * return TRUE;
 * }
 *
 * static void
 * foo_async_initable_iface_init (gpointer g_iface,
 * gpointer data)
 * {
 * GAsyncInitableIface *iface = g_iface;
 *
 * iface->init_async = foo_init_async;
 * iface->init_finish = foo_init_finish;
 * }
 * ]|
 */


/**
 * SECTION:gasyncresult
 * @short_description: Asynchronous Function Results
 * @include: gio/gio.h
 * @see_also: #GSimpleAsyncResult
 *
 * Provides a base class for implementing asynchronous function results.
 *
 * Asynchronous operations are broken up into two separate operations
 * which are chained together by a #GAsyncReadyCallback. To begin
 * an asynchronous operation, provide a #GAsyncReadyCallback to the
 * asynchronous function. This callback will be triggered when the
 * operation has completed, and will be passed a #GAsyncResult instance
 * filled with the details of the operation's success or failure, the
 * object the asynchronous function was started for and any error codes
 * returned. The asynchronous callback function is then expected to call
 * the corresponding "_finish()" function, passing the object the
 * function was called for, the #GAsyncResult instance, and (optionally)
 * an @error to grab any error conditions that may have occurred.
 *
 * The "_finish()" function for an operation takes the generic result
 * (of type #GAsyncResult) and returns the specific result that the
 * operation in question yields (e.g. a #GFileEnumerator for a
 * "enumerate children" operation). If the result or error status of the
 * operation is not needed, there is no need to call the "_finish()"
 * function; GIO will take care of cleaning up the result and error
 * information after the #GAsyncReadyCallback returns. You can pass
 * %NULL for the #GAsyncReadyCallback if you don't need to take any
 * action at all after the operation completes. Applications may also
 * take a reference to the #GAsyncResult and call "_finish()" later;
 * however, the "_finish()" function may be called at most once.
 *
 * Example of a typical asynchronous operation flow:
 * |[
 * void _theoretical_frobnitz_async (Theoretical         *t,
 * GCancellable        *c,
 * GAsyncReadyCallback *cb,
 * gpointer             u);
 *
 * gboolean _theoretical_frobnitz_finish (Theoretical   *t,
 * GAsyncResult  *res,
 * GError       **e);
 *
 * static void
 * frobnitz_result_func (GObject      *source_object,
 * GAsyncResult *res,
 * gpointer      user_data)
 * {
 * gboolean success = FALSE;
 *
 * success = _theoretical_frobnitz_finish (source_object, res, NULL);
 *
 * if (success)
 * g_printf ("Hurray!\n");
 * else
 * g_printf ("Uh oh!\n");
 *
 * /<!-- -->* ... *<!-- -->/
 *
 * }
 *
 * int main (int argc, void *argv[])
 * {
 * /<!-- -->* ... *<!-- -->/
 *
 * _theoretical_frobnitz_async (theoretical_data,
 * NULL,
 * frobnitz_result_func,
 * NULL);
 *
 * /<!-- -->* ... *<!-- -->/
 * }
 * ]|
 *
 * The callback for an asynchronous operation is called only once, and is
 * always called, even in the case of a cancelled operation. On cancellation
 * the result is a %G_IO_ERROR_CANCELLED error.
 */


/**
 * SECTION:gbufferedinputstream
 * @short_description: Buffered Input Stream
 * @include: gio/gio.h
 * @see_also: #GFilterInputStream, #GInputStream
 *
 * Buffered input stream implements #GFilterInputStream and provides
 * for buffered reads.
 *
 * By default, #GBufferedInputStream's buffer size is set at 4 kilobytes.
 *
 * To create a buffered input stream, use g_buffered_input_stream_new(),
 * or g_buffered_input_stream_new_sized() to specify the buffer's size at
 * construction.
 *
 * To get the size of a buffer within a buffered input stream, use
 * g_buffered_input_stream_get_buffer_size(). To change the size of a
 * buffered input stream's buffer, use
 * g_buffered_input_stream_set_buffer_size(). Note that the buffer's size
 * cannot be reduced below the size of the data within the buffer.
 */


/**
 * SECTION:gbufferedoutputstream
 * @short_description: Buffered Output Stream
 * @include: gio/gio.h
 * @see_also: #GFilterOutputStream, #GOutputStream
 *
 * Buffered output stream implements #GFilterOutputStream and provides
 * for buffered writes.
 *
 * By default, #GBufferedOutputStream's buffer size is set at 4 kilobytes.
 *
 * To create a buffered output stream, use g_buffered_output_stream_new(),
 * or g_buffered_output_stream_new_sized() to specify the buffer's size
 * at construction.
 *
 * To get the size of a buffer within a buffered input stream, use
 * g_buffered_output_stream_get_buffer_size(). To change the size of a
 * buffered output stream's buffer, use
 * g_buffered_output_stream_set_buffer_size(). Note that the buffer's
 * size cannot be reduced below the size of the data within the buffer.
 */


/**
 * SECTION:gcancellable
 * @short_description: Thread-safe Operation Cancellation Stack
 * @include: gio/gio.h
 *
 * GCancellable is a thread-safe operation cancellation stack used
 * throughout GIO to allow for cancellation of synchronous and
 * asynchronous operations.
 */


/**
 * SECTION:gcharsetconverter
 * @short_description: Convert between charsets
 * @include: gio/gio.h
 *
 * #GCharsetConverter is an implementation of #GConverter based on
 * GIConv.
 */


/**
 * SECTION:gcontenttype
 * @short_description: Platform-specific content typing
 * @include: gio/gio.h
 *
 * A content type is a platform specific string that defines the type
 * of a file. On UNIX it is a <ulink url="http://www.wikipedia.org/wiki/Internet_media_type">mime type</ulink> like "text/plain" or "image/png".
 * On Win32 it is an extension string like ".doc", ".txt" or a perceived
 * string like "audio". Such strings can be looked up in the registry at
 * HKEY_CLASSES_ROOT.
 */


/**
 * SECTION:gconverter
 * @short_description: Data conversion interface
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GOutputStream
 *
 * #GConverter is implemented by objects that convert
 * binary data in various ways. The conversion can be
 * stateful and may fail at any place.
 *
 * Some example conversions are: character set conversion,
 * compression, decompression and regular expression
 * replace.
 *
 * Since: 2.24
 */


/**
 * SECTION:gconverterinputstream
 * @short_description: Converter Input Stream
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GConverter
 *
 * Converter input stream implements #GInputStream and allows
 * conversion of data of various types during reading.
 */


/**
 * SECTION:gconverteroutputstream
 * @short_description: Converter Output Stream
 * @include: gio/gio.h
 * @see_also: #GOutputStream, #GConverter
 *
 * Converter output stream implements #GOutputStream and allows
 * conversion of data of various types during reading.
 */


/**
 * SECTION:gcredentials
 * @short_description: An object containing credentials
 * @include: gio/gio.h
 *
 * The #GCredentials type is a reference-counted wrapper for native
 * credentials. This information is typically used for identifying,
 * authenticating and authorizing other processes.
 *
 * Some operating systems supports looking up the credentials of the
 * remote peer of a communication endpoint - see e.g.
 * g_socket_get_credentials().
 *
 * Some operating systems supports securely sending and receiving
 * credentials over a Unix Domain Socket, see
 * #GUnixCredentialsMessage, g_unix_connection_send_credentials() and
 * g_unix_connection_receive_credentials() for details.
 *
 * On Linux, the native credential type is a <type>struct ucred</type>
 * - see the
 * <citerefentry><refentrytitle>unix</refentrytitle><manvolnum>7</manvolnum></citerefentry>
 * man page for details. This corresponds to
 * %G_CREDENTIALS_TYPE_LINUX_UCRED.
 *
 * On FreeBSD, the native credential type is a <type>struct cmsgcred</type>.
 * This corresponds to %G_CREDENTIALS_TYPE_FREEBSD_CMSGCRED.
 *
 * On OpenBSD, the native credential type is a <type>struct sockpeercred</type>.
 * This corresponds to %G_CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED.
 */


/**
 * SECTION:gdatainputstream
 * @short_description: Data Input Stream
 * @include: gio/gio.h
 * @see_also: #GInputStream
 *
 * Data input stream implements #GInputStream and includes functions for
 * reading structured data directly from a binary input stream.
 */


/**
 * SECTION:gdataoutputstream
 * @short_description: Data Output Stream
 * @include: gio/gio.h
 * @see_also: #GOutputStream
 *
 * Data output stream implements #GOutputStream and includes functions for
 * writing data directly to an output stream.
 */


/**
 * SECTION:gdbusactiongroup
 * @title: GDBusActionGroup
 * @short_description: A D-Bus GActionGroup implementation
 * @see_also: <link linkend="gio-GActionGroup-exporter">GActionGroup exporter</link>
 *
 * #GDBusActionGroup is an implementation of the #GActionGroup
 * interface that can be used as a proxy for an action group
 * that is exported over D-Bus with g_dbus_connection_export_action_group().
 */


/**
 * SECTION:gdbusaddress
 * @title: D-Bus Addresses
 * @short_description: D-Bus connection endpoints
 * @include: gio/gio.h
 *
 * Routines for working with D-Bus addresses. A D-Bus address is a string
 * like "unix:tmpdir=/tmp/my-app-name". The exact format of addresses
 * is explained in detail in the <link linkend="http://dbus.freedesktop.org/doc/dbus-specification.html&num;addresses">D-Bus specification</link>.
 */


/**
 * SECTION:gdbusauthobserver
 * @short_description: Object used for authenticating connections
 * @include: gio/gio.h
 *
 * The #GDBusAuthObserver type provides a mechanism for participating
 * in how a #GDBusServer (or a #GDBusConnection) authenticates remote
 * peers. Simply instantiate a #GDBusAuthObserver and connect to the
 * signals you are interested in. Note that new signals may be added
 * in the future
 *
 * For example, if you only want to allow D-Bus connections from
 * processes owned by the same uid as the server, you would use a
 * signal handler like the following:
 * <example id="auth-observer"><title>Controlling Authentication</title><programlisting>
 * static gboolean
 * on_authorize_authenticated_peer (GDBusAuthObserver *observer,
 * GIOStream         *stream,
 * GCredentials      *credentials,
 * gpointer           user_data)
 * {
 * gboolean authorized;
 *
 * authorized = FALSE;
 * if (credentials != NULL)
 * {
 * GCredentials *own_credentials;
 * own_credentials = g_credentials_new ();
 * if (g_credentials_is_same_user (credentials, own_credentials, NULL))
 * authorized = TRUE;
 * g_object_unref (own_credentials);
 * }
 *
 * return authorized;
 * }
 * </programlisting></example>
 */


/**
 * SECTION:gdbusconnection
 * @short_description: D-Bus Connections
 * @include: gio/gio.h
 *
 * The #GDBusConnection type is used for D-Bus connections to remote
 * peers such as a message buses. It is a low-level API that offers a
 * lot of flexibility. For instance, it lets you establish a connection
 * over any transport that can by represented as an #GIOStream.
 *
 * This class is rarely used directly in D-Bus clients. If you are writing
 * an D-Bus client, it is often easier to use the g_bus_own_name(),
 * g_bus_watch_name() or g_dbus_proxy_new_for_bus() APIs.
 *
 * As an exception to the usual GLib rule that a particular object must not be
 * used by two threads at the same time, #GDBusConnection's methods may be
 * called from any thread<footnote>
 * <para>
 * This is so that g_bus_get() and g_bus_get_sync() can safely return the
 * same #GDBusConnection when called from any thread.
 * </para>
 * </footnote>.
 *
 * Most of the ways to obtain a #GDBusConnection automatically initialize it
 * (i.e. connect to D-Bus): for instance, g_dbus_connection_new() and
 * g_bus_get(), and the synchronous versions of those methods, give you an
 * initialized connection. Language bindings for GIO should use
 * g_initable_new() or g_async_initable_new(), which also initialize the
 * connection.
 *
 * If you construct an uninitialized #GDBusConnection, such as via
 * g_object_new(), you must initialize it via g_initable_init() or
 * g_async_initable_init() before using its methods or properties. Calling
 * methods or accessing properties on a #GDBusConnection that has not completed
 * initialization successfully is considered to be invalid, and leads to
 * undefined behaviour. In particular, if initialization fails with a #GError,
 * the only valid thing you can do with that #GDBusConnection is to free it
 * with g_object_unref().
 *
 * <example id="gdbus-server"><title>D-Bus server example</title><programlisting><xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gdbus-example-server.c"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include></programlisting></example>
 *
 * <example id="gdbus-subtree-server"><title>D-Bus subtree example</title><programlisting><xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gdbus-example-subtree.c"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include></programlisting></example>
 *
 * <example id="gdbus-unix-fd-client"><title>D-Bus UNIX File Descriptor example</title><programlisting><xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gdbus-example-unix-fd-client.c"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include></programlisting></example>
 *
 * <example id="gdbus-export"><title>Exporting a GObject</title><programlisting><xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gdbus-example-export.c"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include></programlisting></example>
 */


/**
 * SECTION:gdbuserror
 * @title: GDBusError
 * @short_description: Mapping D-Bus errors to and from GError
 * @include: gio/gio.h
 *
 * All facilities that return errors from remote methods (such as
 * g_dbus_connection_call_sync()) use #GError to represent both D-Bus
 * errors (e.g. errors returned from the other peer) and locally
 * in-process generated errors.
 *
 * To check if a returned #GError is an error from a remote peer, use
 * g_dbus_error_is_remote_error(). To get the actual D-Bus error name,
 * use g_dbus_error_get_remote_error(). Before presenting an error,
 * always use g_dbus_error_strip_remote_error().
 *
 * In addition, facilities used to return errors to a remote peer also
 * use #GError. See g_dbus_method_invocation_return_error() for
 * discussion about how the D-Bus error name is set.
 *
 * Applications can associate a #GError error domain with a set of D-Bus errors in order to
 * automatically map from D-Bus errors to #GError and back. This
 * is typically done in the function returning the #GQuark for the
 * error domain:
 * <example id="error-registration"><title>Error Registration</title><programlisting>
 * /<!-- -->* foo-bar-error.h: *<!-- -->/
 *
 * #define FOO_BAR_ERROR (foo_bar_error_quark ())
 * GQuark foo_bar_error_quark (void);
 *
 * typedef enum
 * {
 * FOO_BAR_ERROR_FAILED,
 * FOO_BAR_ERROR_ANOTHER_ERROR,
 * FOO_BAR_ERROR_SOME_THIRD_ERROR,
 * } FooBarError;
 *
 * /<!-- -->* foo-bar-error.c: *<!-- -->/
 *
 * static const GDBusErrorEntry foo_bar_error_entries[] =
 * {
 * {FOO_BAR_ERROR_FAILED,           "org.project.Foo.Bar.Error.Failed"},
 * {FOO_BAR_ERROR_ANOTHER_ERROR,    "org.project.Foo.Bar.Error.AnotherError"},
 * {FOO_BAR_ERROR_SOME_THIRD_ERROR, "org.project.Foo.Bar.Error.SomeThirdError"},
 * };
 *
 * GQuark
 * foo_bar_error_quark (void)
 * {
 * static volatile gsize quark_volatile = 0;
 * g_dbus_error_register_error_domain ("foo-bar-error-quark",
 * &quark_volatile,
 * foo_bar_error_entries,
 * G_N_ELEMENTS (foo_bar_error_entries));
 * G_STATIC_ASSERT (G_N_ELEMENTS (foo_bar_error_entries) - 1 == FOO_BAR_ERROR_SOME_THIRD_ERROR);
 * return (GQuark) quark_volatile;
 * }
 * </programlisting></example>
 * With this setup, a D-Bus peer can transparently pass e.g. %FOO_BAR_ERROR_ANOTHER_ERROR and
 * other peers will see the D-Bus error name <literal>org.project.Foo.Bar.Error.AnotherError</literal>.
 * If the other peer is using GDBus, the peer will see also %FOO_BAR_ERROR_ANOTHER_ERROR instead
 * of %G_IO_ERROR_DBUS_ERROR. Note that GDBus clients can still recover
 * <literal>org.project.Foo.Bar.Error.AnotherError</literal> using g_dbus_error_get_remote_error().
 *
 * Note that errors in the %G_DBUS_ERROR error domain is intended only
 * for returning errors from a remote message bus process. Errors
 * generated locally in-process by e.g. #GDBusConnection is from the
 * %G_IO_ERROR domain.
 */


/**
 * SECTION:gdbusinterface
 * @short_description: Base type for D-Bus interfaces
 * @include: gio/gio.h
 *
 * The #GDBusInterface type is the base type for D-Bus interfaces both
 * on the service side (see #GDBusInterfaceSkeleton) and client side
 * (see #GDBusProxy).
 */


/**
 * SECTION:gdbusinterfaceskeleton
 * @short_description: Service-side D-Bus interface
 * @include: gio/gio.h
 *
 * Abstract base class for D-Bus interfaces on the service side.
 */


/**
 * SECTION:gdbusintrospection
 * @title: D-Bus Introspection Data
 * @short_description: Node and interface description data structures
 * @include: gio/gio.h
 *
 * Various data structures and convenience routines to parse and
 * generate D-Bus introspection XML. Introspection information is
 * used when registering objects with g_dbus_connection_register_object().
 *
 * The format of D-Bus introspection XML is specified in the
 * <ulink url="http://dbus.freedesktop.org/doc/dbus-specification.html#introspection-format">D-Bus specification</ulink>.
 */


/**
 * SECTION:gdbusmenumodel
 * @title: GDBusMenuModel
 * @short_description: A D-Bus GMenuModel implementation
 * @see_also: <link linkend="gio-GMenuModel-exporter">GMenuModel Exporter</link>
 *
 * #GDBusMenuModel is an implementation of #GMenuModel that can be used
 * as a proxy for a menu model that is exported over D-Bus with
 * g_dbus_connection_export_menu_model().
 */


/**
 * SECTION:gdbusmessage
 * @short_description: D-Bus Message
 * @include: gio/gio.h
 *
 * A type for representing D-Bus messages that can be sent or received
 * on a #GDBusConnection.
 */


/**
 * SECTION:gdbusmethodinvocation
 * @short_description: Object for handling remote calls
 * @include: gio/gio.h
 *
 * Instances of the #GDBusMethodInvocation class are used when
 * handling D-Bus method calls. It provides a way to asynchronously
 * return results and errors.
 *
 * The normal way to obtain a #GDBusMethodInvocation object is to receive
 * it as an argument to the handle_method_call() function in a
 * #GDBusInterfaceVTable that was passed to g_dbus_connection_register_object().
 */


/**
 * SECTION:gdbusnameowning
 * @title: Owning Bus Names
 * @short_description: Simple API for owning bus names
 * @include: gio/gio.h
 *
 * Convenience API for owning bus names.
 *
 * <example id="gdbus-owning-names"><title>Simple application owning a name</title><programlisting><xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gdbus-example-own-name.c"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include></programlisting></example>
 */


/**
 * SECTION:gdbusnamewatching
 * @title: Watching Bus Names
 * @short_description: Simple API for watching bus names
 * @include: gio/gio.h
 *
 * Convenience API for watching bus names.
 *
 * <example id="gdbus-watching-names"><title>Simple application watching a name</title><programlisting><xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gdbus-example-watch-name.c"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include></programlisting></example>
 */


/**
 * SECTION:gdbusobject
 * @short_description: Base type for D-Bus objects
 * @include: gio/gio.h
 *
 * The #GDBusObject type is the base type for D-Bus objects on both
 * the service side (see #GDBusObjectSkeleton) and the client side
 * (see #GDBusObjectProxy). It is essentially just a container of
 * interfaces.
 */


/**
 * SECTION:gdbusobjectmanager
 * @short_description: Base type for D-Bus object managers
 * @include: gio/gio.h
 *
 * The #GDBusObjectManager type is the base type for service- and
 * client-side implementations of the standardized <ulink
 * url="http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager">org.freedesktop.DBus.ObjectManager</ulink>
 * interface.
 *
 * See #GDBusObjectManagerClient for the client-side implementation
 * and #GDBusObjectManagerServer for the service-side implementation.
 */


/**
 * SECTION:gdbusobjectmanagerclient
 * @short_description: Client-side object manager
 * @include: gio/gio.h
 *
 * #GDBusObjectManagerClient is used to create, monitor and delete object
 * proxies for remote objects exported by a #GDBusObjectManagerServer (or any
 * code implementing the <ulink
 * url="http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager">org.freedesktop.DBus.ObjectManager</ulink>
 * interface).
 *
 * Once an instance of this type has been created, you can connect to
 * the #GDBusObjectManager::object-added and
 * #GDBusObjectManager::object-removed signals and inspect the
 * #GDBusObjectProxy objects returned by
 * g_dbus_object_manager_get_objects().
 *
 * If the name for a #GDBusObjectManagerClient is not owned by anyone at
 * object construction time, the default behavior is to request the
 * message bus to launch an owner for the name. This behavior can be
 * disabled using the %G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_DO_NOT_AUTO_START
 * flag. It's also worth noting that this only works if the name of
 * interest is activatable in the first place. E.g. in some cases it
 * is not possible to launch an owner for the requested name. In this
 * case, #GDBusObjectManagerClient object construction still succeeds but
 * there will be no object proxies
 * (e.g. g_dbus_object_manager_get_objects() returns the empty list) and
 * the #GDBusObjectManagerClient:name-owner property is %NULL.
 *
 * The owner of the requested name can come and go (for example
 * consider a system service being restarted) – #GDBusObjectManagerClient
 * handles this case too; simply connect to the #GObject::notify
 * signal to watch for changes on the #GDBusObjectManagerClient:name-owner
 * property. When the name owner vanishes, the behavior is that
 * #GDBusObjectManagerClient:name-owner is set to %NULL (this includes
 * emission of the #GObject::notify signal) and then
 * #GDBusObjectManager::object-removed signals are synthesized
 * for all currently existing object proxies. Since
 * #GDBusObjectManagerClient:name-owner is %NULL when this happens, you can
 * use this information to disambiguate a synthesized signal from a
 * genuine signal caused by object removal on the remote
 * #GDBusObjectManager. Similarly, when a new name owner appears,
 * #GDBusObjectManager::object-added signals are synthesized
 * while #GDBusObjectManagerClient:name-owner is still %NULL. Only when all
 * object proxies have been added, the #GDBusObjectManagerClient:name-owner
 * is set to the new name owner (this includes emission of the
 * #GObject::notify signal).  Furthermore, you are guaranteed that
 * #GDBusObjectManagerClient:name-owner will alternate between a name owner
 * (e.g. <literal>:1.42</literal>) and %NULL even in the case where
 * the name of interest is atomically replaced
 *
 * Ultimately, #GDBusObjectManagerClient is used to obtain #GDBusProxy
 * instances. All signals (including the
 * <literal>org.freedesktop.DBus.Properties::PropertiesChanged</literal>
 * signal) delivered to #GDBusProxy instances are guaranteed to
 * originate from the name owner. This guarantee along with the
 * behavior described above, means that certain race conditions
 * including the <emphasis><quote>half the proxy is from the old owner
 * and the other half is from the new owner</quote></emphasis> problem
 * cannot happen.
 *
 * To avoid having the application connect to signals on the returned
 * #GDBusObjectProxy and #GDBusProxy objects, the
 * #GDBusObject::interface-added,
 * #GDBusObject::interface-removed,
 * #GDBusProxy::g-properties-changed and
 * #GDBusProxy::g-signal signals
 * are also emitted on the #GDBusObjectManagerClient instance managing these
 * objects. The signals emitted are
 * #GDBusObjectManager::interface-added,
 * #GDBusObjectManager::interface-removed,
 * #GDBusObjectManagerClient::interface-proxy-properties-changed and
 * #GDBusObjectManagerClient::interface-proxy-signal.
 *
 * Note that all callbacks and signals are emitted in the
 * <link linkend="g-main-context-push-thread-default">thread-default main loop</link>
 * that the #GDBusObjectManagerClient object was constructed
 * in. Additionally, the #GDBusObjectProxy and #GDBusProxy objects
 * originating from the #GDBusObjectManagerClient object will be created in
 * the same context and, consequently, will deliver signals in the
 * same main loop.
 */


/**
 * SECTION:gdbusobjectmanagerserver
 * @short_description: Service-side object manager
 * @include: gio/gio.h
 *
 * #GDBusObjectManagerServer is used to export #GDBusObject instances using
 * the standardized <ulink
 * url="http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager">org.freedesktop.DBus.ObjectManager</ulink>
 * interface. For example, remote D-Bus clients can get all objects
 * and properties in a single call. Additionally, any change in the
 * object hierarchy is broadcast using signals. This means that D-Bus
 * clients can keep caches up to date by only listening to D-Bus
 * signals.
 *
 * See #GDBusObjectManagerClient for the client-side code that is
 * intended to be used with #GDBusObjectManagerServer or any D-Bus
 * object implementing the org.freedesktop.DBus.ObjectManager
 * interface.
 */


/**
 * SECTION:gdbusobjectproxy
 * @short_description: Client-side D-Bus object
 * @include: gio/gio.h
 *
 * A #GDBusObjectProxy is an object used to represent a remote object
 * with one or more D-Bus interfaces. Normally, you don't instantiate
 * a #GDBusObjectProxy yourself - typically #GDBusObjectManagerClient
 * is used to obtain it.
 *
 * Since: 2.30
 */


/**
 * SECTION:gdbusobjectskeleton
 * @short_description: Service-side D-Bus object
 * @include: gio/gio.h
 *
 * A #GDBusObjectSkeleton instance is essentially a group of D-Bus
 * interfaces. The set of exported interfaces on the object may be
 * dynamic and change at runtime.
 *
 * This type is intended to be used with #GDBusObjectManager.
 */


/**
 * SECTION:gdbusproxy
 * @short_description: Client-side D-Bus interface proxy
 * @include: gio/gio.h
 *
 * #GDBusProxy is a base class used for proxies to access a D-Bus
 * interface on a remote object. A #GDBusProxy can be constructed for
 * both well-known and unique names.
 *
 * By default, #GDBusProxy will cache all properties (and listen to
 * changes) of the remote object, and proxy all signals that gets
 * emitted. This behaviour can be changed by passing suitable
 * #GDBusProxyFlags when the proxy is created. If the proxy is for a
 * well-known name, the property cache is flushed when the name owner
 * vanishes and reloaded when a name owner appears.
 *
 * If a #GDBusProxy is used for a well-known name, the owner of the
 * name is tracked and can be read from
 * #GDBusProxy:g-name-owner. Connect to the #GObject::notify signal to
 * get notified of changes. Additionally, only signals and property
 * changes emitted from the current name owner are considered and
 * calls are always sent to the current name owner. This avoids a
 * number of race conditions when the name is lost by one owner and
 * claimed by another. However, if no name owner currently exists,
 * then calls will be sent to the well-known name which may result in
 * the message bus launching an owner (unless
 * %G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START is set).
 *
 * The generic #GDBusProxy::g-properties-changed and
 * #GDBusProxy::g-signal signals are not very convenient to work
 * with. Therefore, the recommended way of working with proxies is to
 * subclass #GDBusProxy, and have more natural properties and signals
 * in your derived class. See <xref linkend="gdbus-example-gdbus-codegen"/>
 * for how this can easily be done using the
 * <command><link linkend="gdbus-codegen">gdbus-codegen</link></command>
 * tool.
 *
 * A #GDBusProxy instance can be used from multiple threads but note
 * that all signals (e.g. #GDBusProxy::g-signal, #GDBusProxy::g-properties-changed
 * and #GObject::notify) are emitted in the
 * <link linkend="g-main-context-push-thread-default">thread-default main loop</link>
 * of the thread where the instance was constructed.
 *
 * <example id="gdbus-wellknown-proxy"><title>GDBusProxy for a well-known-name</title><programlisting><xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gdbus-example-watch-proxy.c"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include></programlisting></example>
 */


/**
 * SECTION:gdbusserver
 * @short_description: Helper for accepting connections
 * @include: gio/gio.h
 *
 * #GDBusServer is a helper for listening to and accepting D-Bus
 * connections. This can be used to create a new D-Bus server, allowing two
 * peers to use the D-Bus protocol for their own specialized communication.
 * A server instance provided in this way will not perform message routing or
 * implement the org.freedesktop.DBus interface.
 *
 * To just export an object on a well-known name on a message bus, such as the
 * session or system bus, you should instead use g_bus_own_name().
 *
 * <example id="gdbus-peer-to-peer"><title>D-Bus peer-to-peer example</title><programlisting><xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/tests/gdbus-example-peer.c"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include></programlisting></example>
 */


/**
 * SECTION:gdbusutils
 * @title: D-Bus Utilities
 * @short_description: Various utilities related to D-Bus.
 * @include: gio/gio.h
 *
 * Various utility routines related to D-Bus.
 */


/**
 * SECTION:gdesktopappinfo
 * @title: GDesktopAppInfo
 * @short_description: Application information from desktop files
 * @include: gio/gdesktopappinfo.h
 *
 * #GDesktopAppInfo is an implementation of #GAppInfo based on
 * desktop files.
 *
 * Note that <filename>&lt;gio/gdesktopappinfo.h&gt;</filename> belongs to
 * the UNIX-specific GIO interfaces, thus you have to use the
 * <filename>gio-unix-2.0.pc</filename> pkg-config file when using it.
 */


/**
 * SECTION:gdrive
 * @short_description: Drive management
 * @include: gio/gio.h
 *
 * #GDrive - this represent a piece of hardware connected to the machine.
 * It's generally only created for removable hardware or hardware with
 * removable media.
 *
 * #GDrive is a container class for #GVolume objects that stem from
 * the same piece of media. As such, #GDrive abstracts a drive with
 * (or without) removable media and provides operations for querying
 * whether media is available, determing whether media change is
 * automatically detected and ejecting the media.
 *
 * If the #GDrive reports that media isn't automatically detected, one
 * can poll for media; typically one should not do this periodically
 * as a poll for media operation is potententially expensive and may
 * spin up the drive creating noise.
 *
 * #GDrive supports starting and stopping drives with authentication
 * support for the former. This can be used to support a diverse set
 * of use cases including connecting/disconnecting iSCSI devices,
 * powering down external disk enclosures and starting/stopping
 * multi-disk devices such as RAID devices. Note that the actual
 * semantics and side-effects of starting/stopping a #GDrive may vary
 * according to implementation. To choose the correct verbs in e.g. a
 * file manager, use g_drive_get_start_stop_type().
 *
 * For porting from GnomeVFS note that there is no equivalent of
 * #GDrive in that API.
 */


/**
 * SECTION:gemblem
 * @short_description: An object for emblems
 * @include: gio/gio.h
 * @see_also: #GIcon, #GEmblemedIcon, #GLoadableIcon, #GThemedIcon
 *
 * #GEmblem is an implementation of #GIcon that supports
 * having an emblem, which is an icon with additional properties.
 * It can than be added to a #GEmblemedIcon.
 *
 * Currently, only metainformation about the emblem's origin is
 * supported. More may be added in the future.
 */


/**
 * SECTION:gemblemedicon
 * @short_description: Icon with emblems
 * @include: gio/gio.h
 * @see_also: #GIcon, #GLoadableIcon, #GThemedIcon, #GEmblem
 *
 * #GEmblemedIcon is an implementation of #GIcon that supports
 * adding an emblem to an icon. Adding multiple emblems to an
 * icon is ensured via g_emblemed_icon_add_emblem().
 *
 * Note that #GEmblemedIcon allows no control over the position
 * of the emblems. See also #GEmblem for more information.
 */


/**
 * SECTION:gfile
 * @short_description: File and Directory Handling
 * @include: gio/gio.h
 * @see_also: #GFileInfo, #GFileEnumerator
 *
 * #GFile is a high level abstraction for manipulating files on a
 * virtual file system. #GFile<!-- -->s are lightweight, immutable
 * objects that do no I/O upon creation. It is necessary to understand that
 * #GFile objects do not represent files, merely an identifier for a file. All
 * file content I/O is implemented as streaming operations (see #GInputStream and
 * #GOutputStream).
 *
 * To construct a #GFile, you can use:
 * g_file_new_for_path() if you have a path.
 * g_file_new_for_uri() if you have a URI.
 * g_file_new_for_commandline_arg() for a command line argument.
 * g_file_new_tmp() to create a temporary file from a template.
 * g_file_parse_name() from a utf8 string gotten from g_file_get_parse_name().
 *
 * One way to think of a #GFile is as an abstraction of a pathname. For normal
 * files the system pathname is what is stored internally, but as #GFile<!-- -->s
 * are extensible it could also be something else that corresponds to a pathname
 * in a userspace implementation of a filesystem.
 *
 * #GFile<!-- -->s make up hierarchies of directories and files that correspond to the
 * files on a filesystem. You can move through the file system with #GFile using
 * g_file_get_parent() to get an identifier for the parent directory, g_file_get_child()
 * to get a child within a directory, g_file_resolve_relative_path() to resolve a relative
 * path between two #GFile<!-- -->s. There can be multiple hierarchies, so you may not
 * end up at the same root if you repeatedly call g_file_get_parent() on two different
 * files.
 *
 * All #GFile<!-- -->s have a basename (get with g_file_get_basename()). These names
 * are byte strings that are used to identify the file on the filesystem (relative to
 * its parent directory) and there is no guarantees that they have any particular charset
 * encoding or even make any sense at all. If you want to use filenames in a user
 * interface you should use the display name that you can get by requesting the
 * %G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME attribute with g_file_query_info().
 * This is guaranteed to be in utf8 and can be used in a user interface. But always
 * store the real basename or the #GFile to use to actually access the file, because
 * there is no way to go from a display name to the actual name.
 *
 * Using #GFile as an identifier has the same weaknesses as using a path in that
 * there may be multiple aliases for the same file. For instance, hard or
 * soft links may cause two different #GFile<!-- -->s to refer to the same file.
 * Other possible causes for aliases are: case insensitive filesystems, short
 * and long names on Fat/NTFS, or bind mounts in Linux. If you want to check if
 * two #GFile<!-- -->s point to the same file you can query for the
 * %G_FILE_ATTRIBUTE_ID_FILE attribute. Note that #GFile does some trivial
 * canonicalization of pathnames passed in, so that trivial differences in the
 * path string used at creation (duplicated slashes, slash at end of path, "."
 * or ".." path segments, etc) does not create different #GFile<!-- -->s.
 *
 * Many #GFile operations have both synchronous and asynchronous versions
 * to suit your application. Asynchronous versions of synchronous functions
 * simply have _async() appended to their function names. The asynchronous
 * I/O functions call a #GAsyncReadyCallback which is then used to finalize
 * the operation, producing a GAsyncResult which is then passed to the
 * function's matching _finish() operation.
 *
 * Some #GFile operations do not have synchronous analogs, as they may
 * take a very long time to finish, and blocking may leave an application
 * unusable. Notable cases include:
 * g_file_mount_mountable() to mount a mountable file.
 * g_file_unmount_mountable_with_operation() to unmount a mountable file.
 * g_file_eject_mountable_with_operation() to eject a mountable file.
 *
 * <para id="gfile-etag"><indexterm><primary>entity tag</primary></indexterm>
 * One notable feature of #GFile<!-- -->s are entity tags, or "etags" for
 * short. Entity tags are somewhat like a more abstract version of the
 * traditional mtime, and can be used to quickly determine if the file has
 * been modified from the version on the file system. See the HTTP 1.1
 * <ulink url="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html">specification</ulink>
 * for HTTP Etag headers, which are a very similar concept.
 * </para>
 */


/**
 * SECTION:gfileattribute
 * @short_description: Key-Value Paired File Attributes
 * @include: gio/gio.h
 * @see_also: #GFile, #GFileInfo
 *
 * File attributes in GIO consist of a list of key-value pairs.
 *
 * Keys are strings that contain a key namespace and a key name, separated
 * by a colon, e.g. "namespace:keyname". Namespaces are included to sort
 * key-value pairs by namespaces for relevance. Keys can be retrived
 * using wildcards, e.g. "standard::*" will return all of the keys in the
 * "standard" namespace.
 *
 * Values are stored within the list in #GFileAttributeValue structures.
 * Values can store different types, listed in the enum #GFileAttributeType.
 * Upon creation of a #GFileAttributeValue, the type will be set to
 * %G_FILE_ATTRIBUTE_TYPE_INVALID.
 *
 * The list of possible attributes for a filesystem (pointed to by a #GFile) is
 * available as a #GFileAttributeInfoList. This list is queryable by key names
 * as indicated earlier.
 *
 * Classes that implement #GFileIface will create a #GFileAttributeInfoList and
 * install default keys and values for their given file system, architecture,
 * and other possible implementation details (e.g., on a UNIX system, a file
 * attribute key will be registered for the user id for a given file).
 *
 * <para>
 * <table>
 * <title>GFileAttributes Default Namespaces</title>
 * <tgroup cols='2' align='left'><thead>
 * <row><entry>Namspace</entry><entry>Description</entry></row>
 * </thead>
 * <tbody>
 * <row><entry>"standard"</entry><entry>The "Standard" namespace. General file
 * information that any application may need should be put in this namespace.
 * Examples include the file's name, type, and size.</entry></row>
 * <row><entry>"etag"</entry><entry>The <link linkend="gfile-etag">"Entity Tag"</link>
 * namespace. Currently, the only key in this namespace is "value", which contains
 * the value of the current entity tag.</entry></row>
 * <row><entry>"id"</entry><entry>The "Identification" namespace. This
 * namespace is used by file managers and applications that list directories
 * to check for loops and to uniquely identify files.</entry></row>
 * <row><entry>"access"</entry><entry>The "Access" namespace. Used to check
 * if a user has the proper privilidges to access files and perform
 * file operations. Keys in this namespace are made to be generic
 * and easily understood, e.g. the "can_read" key is %TRUE if
 * the current user has permission to read the file. UNIX permissions and
 * NTFS ACLs in Windows should be mapped to these values.</entry></row>
 * <row><entry>"mountable"</entry><entry>The "Mountable" namespace. Includes
 * simple boolean keys for checking if a file or path supports mount operations, e.g.
 * mount, unmount, eject. These are used for files of type %G_FILE_TYPE_MOUNTABLE.</entry></row>
 * <row><entry>"time"</entry><entry>The "Time" namespace. Includes file
 * access, changed, created times. </entry></row>
 * <row><entry>"unix"</entry><entry>The "Unix" namespace. Includes UNIX-specific
 * information and may not be available for all files. Examples include
 * the UNIX "UID", "GID", etc.</entry></row>
 * <row><entry>"dos"</entry><entry>The "DOS" namespace. Includes DOS-specific
 * information and may not be available for all files. Examples include
 * "is_system" for checking if a file is marked as a system file, and "is_archive"
 * for checking if a file is marked as an archive file.</entry></row>
 * <row><entry>"owner"</entry><entry>The "Owner" namespace. Includes information
 * about who owns a file. May not be available for all file systems. Examples include
 * "user" for getting the user name of the file owner. This information is often mapped from
 * some backend specific data such as a unix UID.</entry></row>
 * <row><entry>"thumbnail"</entry><entry>The "Thumbnail" namespace. Includes
 * information about file thumbnails and their location within the file system. Examples of
 * keys in this namespace include "path" to get the location of a thumbnail, and "failed"
 * to check if thumbnailing of the file failed.</entry></row>
 * <row><entry>"filesystem"</entry><entry>The "Filesystem" namespace. Gets information
 * about the file system where a file is located, such as its type, how much
 * space is left available, and the overall size of the file system.</entry></row>
 * <row><entry>"gvfs"</entry><entry>The "GVFS" namespace. Keys in this namespace
 * contain information about the current GVFS backend in use. </entry></row>
 * <row><entry>"xattr"</entry><entry>The "xattr" namespace. Gets information
 * about extended user attributes. See attr(5). The "user." prefix of the
 * extended user attribute name is stripped away when constructing keys in
 * this namespace, e.g. "xattr::mime_type" for the extended attribute with
 * the name "user.mime_type". Note that this information is only available
 * if GLib has been built with extended attribute support.</entry></row>
 * <row><entry>"xattr-sys"</entry><entry>The "xattr-sys" namespace.
 * Gets information about extended attributes which are not user-specific.
 * See attr(5). Note that this information is only available if GLib
 * has been built with extended attribute support.</entry></row>
 * <row><entry>"selinux"</entry><entry>The "SELinux" namespace. Includes
 * information about the SELinux context of files. Note that this information
 * is only available if GLib has been built with SELinux support.</entry></row>
 * </tbody>
 * </tgroup>
 * </table>
 * </para>
 *
 * Please note that these are not all of the possible namespaces.
 * More namespaces can be added from GIO modules or by individual applications.
 * For more information about writing GIO modules, see #GIOModule.
 *
 * <!-- TODO: Implementation note about using extended attributes on supported
 * file systems -->
 *
 * <para><table>
 * <title>GFileAttributes Built-in Keys and Value Types</title>
 * <tgroup cols='3' align='left'><thead>
 * <row><entry>Enum Value</entry><entry>Namespace:Key</entry><entry>Value Type</entry></row>
 * </thead><tbody>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_TYPE</entry><entry>standard::type</entry><entry>uint32 (#GFileType)</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN</entry><entry>standard::is-hidden</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP</entry><entry>standard::is-backup</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK</entry><entry>standard::is-symlink</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_IS_VIRTUAL</entry><entry>standard::is-virtual</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_NAME</entry><entry>standard::name</entry><entry>byte string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME</entry><entry>standard::display-name</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_EDIT_NAME</entry><entry>standard::edit-name</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_ICON</entry><entry>standard::icon</entry><entry>object (#GIcon)</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE</entry><entry>standard::content-type</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE</entry><entry>standard::fast-content-type</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_SIZE</entry><entry>standard::size</entry><entry>uint64</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE</entry><entry>standard::allocated-size</entry><entry>uint64</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET</entry><entry>standard::symlink-target</entry><entry>byte string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_TARGET_URI</entry><entry>standard::target-uri</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_STANDARD_SORT_ORDER</entry><entry>standard::sort-order</entry><entry>int32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_ETAG_VALUE</entry><entry>etag::value</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_ID_FILE</entry><entry>id::file</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_ID_FILESYSTEM</entry><entry>id::filesystem</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_ACCESS_CAN_READ</entry><entry>access::can-read</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE</entry><entry>access::can-write</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE</entry><entry>access::can-execute</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_ACCESS_CAN_DELETE</entry><entry>access::can-delete</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_ACCESS_CAN_TRASH</entry><entry>access::can-trash</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_ACCESS_CAN_RENAME</entry><entry>access::can-rename</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_MOUNTABLE_CAN_MOUNT</entry><entry>mountable::can-mount</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT</entry><entry>mountable::can-unmount</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_MOUNTABLE_CAN_EJECT</entry><entry>mountable::can-eject</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE</entry><entry>mountable::unix-device</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE_FILE</entry><entry>mountable::unix-device-file</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_MOUNTABLE_HAL_UDI</entry><entry>mountable::hal-udi</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_TIME_MODIFIED</entry><entry>time::modified</entry><entry>uint64</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_TIME_MODIFIED_USEC</entry><entry>time::modified-usec</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_TIME_ACCESS</entry><entry>time::access</entry><entry>uint64</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_TIME_ACCESS_USEC</entry><entry>time::access-usec</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_TIME_CHANGED</entry><entry>time::changed</entry><entry>uint64</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_TIME_CHANGED_USEC</entry><entry>time::changed-usec</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_TIME_CREATED</entry><entry>time::created</entry><entry>uint64</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_TIME_CREATED_USEC</entry><entry>time::created-usec</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_UNIX_DEVICE</entry><entry>unix::device</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_UNIX_INODE</entry><entry>unix::inode</entry><entry>uint64</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_UNIX_MODE</entry><entry>unix::mode</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_UNIX_NLINK</entry><entry>unix::nlink</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_UNIX_UID</entry><entry>unix::uid</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_UNIX_GID</entry><entry>unix::gid</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_UNIX_RDEV</entry><entry>unix::rdev</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_UNIX_BLOCK_SIZE</entry><entry>unix::block-size</entry><entry>uint32</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_UNIX_BLOCKS</entry><entry>unix::blocks</entry><entry>uint64</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT</entry><entry>unix::is-mountpoint</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_DOS_IS_ARCHIVE</entry><entry>dos::is-archive</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_DOS_IS_SYSTEM</entry><entry>dos::is-system</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_OWNER_USER</entry><entry>owner::user</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_OWNER_USER_REAL</entry><entry>owner::user-real</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_OWNER_GROUP</entry><entry>owner::group</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_THUMBNAIL_PATH</entry><entry>thumbnail::path</entry><entry>bytestring</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_THUMBNAILING_FAILED</entry><entry>thumbnail::failed</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_PREVIEW_ICON</entry><entry>preview::icon</entry><entry>object (#GIcon)</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_FILESYSTEM_SIZE</entry><entry>filesystem::size</entry><entry>uint64</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_FILESYSTEM_FREE</entry><entry>filesystem::free</entry><entry>uint64</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_FILESYSTEM_TYPE</entry><entry>filesystem::type</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_FILESYSTEM_READONLY</entry><entry>filesystem::readonly</entry><entry>boolean</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_GVFS_BACKEND</entry><entry>gvfs::backend</entry><entry>string</entry></row>
 * <row><entry>%G_FILE_ATTRIBUTE_SELINUX_CONTEXT</entry><entry>selinux::context</entry><entry>string</entry></row>
 * </tbody></tgroup></table></para>
 *
 * Note that there are no predefined keys in the "xattr" and "xattr-sys"
 * namespaces. Keys for the "xattr" namespace are constructed by stripping
 * away the "user." prefix from the extended user attribute, and prepending
 * "xattr::". Keys for the "xattr-sys" namespace are constructed by
 * concatenating "xattr-sys::" with the extended attribute name. All extended
 * attribute values are returned as hex-encoded strings in which bytes outside
 * the ASCII range are encoded as hexadecimal escape sequences of the form
 * \x<replaceable>nn</replaceable>.
 */


/**
 * SECTION:gfiledescriptorbased
 * @short_description: Interface for file descriptor based IO
 * @include: gio/gfiledescriptorbased.h
 * @see_also: #GInputStream, #GOutputStream
 *
 * #GFileDescriptorBased is implemented by streams (implementations of
 * #GInputStream or #GOutputStream) that are based on file descriptors.
 *
 * Note that <filename>&lt;gio/gfiledescriptorbased.h&gt;</filename> belongs to
 * the UNIX-specific GIO interfaces, thus you have to use the
 * <filename>gio-unix-2.0.pc</filename> pkg-config file when using it.
 *
 * Since: 2.24
 */


/**
 * SECTION:gfileenumerator
 * @short_description: Enumerated Files Routines
 * @include: gio/gio.h
 *
 * #GFileEnumerator allows you to operate on a set of #GFile<!-- -->s,
 * returning a #GFileInfo structure for each file enumerated (e.g.
 * g_file_enumerate_children() will return a #GFileEnumerator for each
 * of the children within a directory).
 *
 * To get the next file's information from a #GFileEnumerator, use
 * g_file_enumerator_next_file() or its asynchronous version,
 * g_file_enumerator_next_files_async(). Note that the asynchronous
 * version will return a list of #GFileInfo<!---->s, whereas the
 * synchronous will only return the next file in the enumerator.
 *
 * To close a #GFileEnumerator, use g_file_enumerator_close(), or
 * its asynchronous version, g_file_enumerator_close_async(). Once
 * a #GFileEnumerator is closed, no further actions may be performed
 * on it, and it should be freed with g_object_unref().
 */


/**
 * SECTION:gfileicon
 * @short_description: Icons pointing to an image file
 * @include: gio/gio.h
 * @see_also: #GIcon, #GLoadableIcon
 *
 * #GFileIcon specifies an icon by pointing to an image file
 * to be used as icon.
 */


/**
 * SECTION:gfileinfo
 * @short_description: File Information and Attributes
 * @include: gio/gio.h
 * @see_also: #GFile, <link linkend="gio-GFileAttribute">GFileAttribute</link>
 *
 * Functionality for manipulating basic metadata for files. #GFileInfo
 * implements methods for getting information that all files should
 * contain, and allows for manipulation of extended attributes.
 *
 * See <link linkend="gio-GFileAttribute">GFileAttribute</link> for more
 * information on how GIO handles file attributes.
 *
 * To obtain a #GFileInfo for a #GFile, use g_file_query_info() (or its
 * async variant). To obtain a #GFileInfo for a file input or output
 * stream, use g_file_input_stream_query_info() or
 * g_file_output_stream_query_info() (or their async variants).
 *
 * To change the actual attributes of a file, you should then set the
 * attribute in the #GFileInfo and call g_file_set_attributes_from_info()
 * or g_file_set_attributes_async() on a GFile.
 *
 * However, not all attributes can be changed in the file. For instance,
 * the actual size of a file cannot be changed via g_file_info_set_size().
 * You may call g_file_query_settable_attributes() and
 * g_file_query_writable_namespaces() to discover the settable attributes
 * of a particular file at runtime.
 *
 * #GFileAttributeMatcher allows for searching through a #GFileInfo for
 * attributes.
 */


/**
 * SECTION:gfileinputstream
 * @short_description: File input streaming operations
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GDataInputStream, #GSeekable
 *
 * GFileInputStream provides input streams that take their
 * content from a file.
 *
 * GFileInputStream implements #GSeekable, which allows the input
 * stream to jump to arbitrary positions in the file, provided the
 * filesystem of the file allows it. To find the position of a file
 * input stream, use g_seekable_tell(). To find out if a file input
 * stream supports seeking, use g_seekable_stream_can_seek().
 * To position a file input stream, use g_seekable_seek().
 */


/**
 * SECTION:gfileiostream
 * @short_description: File read and write streaming operations
 * @include: gio/gio.h
 * @see_also: #GIOStream, #GFileInputStream, #GFileOutputStream, #GSeekable
 *
 * GFileIOStream provides io streams that both read and write to the same
 * file handle.
 *
 * GFileIOStream implements #GSeekable, which allows the io
 * stream to jump to arbitrary positions in the file and to truncate
 * the file, provided the filesystem of the file supports these
 * operations.
 *
 * To find the position of a file io stream, use
 * g_seekable_tell().
 *
 * To find out if a file io stream supports seeking, use g_seekable_can_seek().
 * To position a file io stream, use g_seekable_seek().
 * To find out if a file io stream supports truncating, use
 * g_seekable_can_truncate(). To truncate a file io
 * stream, use g_seekable_truncate().
 *
 * The default implementation of all the #GFileIOStream operations
 * and the implementation of #GSeekable just call into the same operations
 * on the output stream.
 *
 * Since: 2.22
 */


/**
 * SECTION:gfilemonitor
 * @short_description: File Monitor
 * @include: gio/gio.h
 *
 * Monitors a file or directory for changes.
 *
 * To obtain a #GFileMonitor for a file or directory, use
 * g_file_monitor(), g_file_monitor_file(), or
 * g_file_monitor_directory().
 *
 * To get informed about changes to the file or directory you are
 * monitoring, connect to the #GFileMonitor::changed signal. The
 * signal will be emitted in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * context</link> of the thread that the monitor was created in
 * (though if the global default main context is blocked, this may
 * cause notifications to be blocked even if the thread-default
 * context is still running).
 */


/**
 * SECTION:gfilenamecompleter
 * @short_description: Filename Completer
 * @include: gio/gio.h
 *
 * Completes partial file and directory names given a partial string by
 * looking in the file system for clues. Can return a list of possible
 * completion strings for widget implementations.
 */


/**
 * SECTION:gfileoutputstream
 * @short_description: File output streaming operations
 * @include: gio/gio.h
 * @see_also: #GOutputStream, #GDataOutputStream, #GSeekable
 *
 * GFileOutputStream provides output streams that write their
 * content to a file.
 *
 * GFileOutputStream implements #GSeekable, which allows the output
 * stream to jump to arbitrary positions in the file and to truncate
 * the file, provided the filesystem of the file supports these
 * operations.
 *
 * To find the position of a file output stream, use g_seekable_tell().
 * To find out if a file output stream supports seeking, use
 * g_seekable_can_seek().To position a file output stream, use
 * g_seekable_seek(). To find out if a file output stream supports
 * truncating, use g_seekable_can_truncate(). To truncate a file output
 * stream, use g_seekable_truncate().
 */


/**
 * SECTION:gfilterinputstream
 * @short_description: Filter Input Stream
 * @include: gio/gio.h
 *
 * Base class for input stream implementations that perform some
 * kind of filtering operation on a base stream. Typical examples
 * of filtering operations are character set conversion, compression
 * and byte order flipping.
 */


/**
 * SECTION:gfilteroutputstream
 * @short_description: Filter Output Stream
 * @include: gio/gio.h
 *
 * Base class for output stream implementations that perform some
 * kind of filtering operation on a base stream. Typical examples
 * of filtering operations are character set conversion, compression
 * and byte order flipping.
 */


/**
 * SECTION:gicon
 * @short_description: Interface for icons
 * @include: gio/gio.h
 *
 * #GIcon is a very minimal interface for icons. It provides functions
 * for checking the equality of two icons, hashing of icons and
 * serializing an icon to and from strings.
 *
 * #GIcon does not provide the actual pixmap for the icon as this is out
 * of GIO's scope, however implementations of #GIcon may contain the name
 * of an icon (see #GThemedIcon), or the path to an icon (see #GLoadableIcon).
 *
 * To obtain a hash of a #GIcon, see g_icon_hash().
 *
 * To check if two #GIcons are equal, see g_icon_equal().
 *
 * For serializing a #GIcon, use g_icon_to_string() and
 * g_icon_new_for_string().
 *
 * If your application or library provides one or more #GIcon
 * implementations you need to ensure that each #GType is registered
 * with the type system prior to calling g_icon_new_for_string().
 */


/**
 * SECTION:ginetaddress
 * @short_description: An IPv4/IPv6 address
 *
 * #GInetAddress represents an IPv4 or IPv6 internet address. Use
 * g_resolver_lookup_by_name() or g_resolver_lookup_by_name_async() to
 * look up the #GInetAddress for a hostname. Use
 * g_resolver_lookup_by_address() or
 * g_resolver_lookup_by_address_async() to look up the hostname for a
 * #GInetAddress.
 *
 * To actually connect to a remote host, you will need a
 * #GInetSocketAddress (which includes a #GInetAddress as well as a
 * port number).
 */


/**
 * SECTION:ginetaddressmask
 * @short_description: An IPv4/IPv6 address mask
 *
 * #GInetAddressMask represents a range of IPv4 or IPv6 addresses
 * described by a base address and a length indicating how many bits
 * of the base address are relevant for matching purposes. These are
 * often given in string form. Eg, "10.0.0.0/8", or "fe80::/10".
 */


/**
 * SECTION:ginetsocketaddress
 * @short_description: Internet GSocketAddress
 *
 * An IPv4 or IPv6 socket address; that is, the combination of a
 * #GInetAddress and a port number.
 */


/**
 * SECTION:ginitable
 * @short_description: Failable object initialization interface
 * @include: gio/gio.h
 * @see_also: #GAsyncInitable
 *
 * #GInitable is implemented by objects that can fail during
 * initialization. If an object implements this interface then
 * it must be initialized as the first thing after construction,
 * either via g_initable_init() or g_async_initable_init_async()
 * (the latter is only available if it also implements #GAsyncInitable).
 *
 * If the object is not initialized, or initialization returns with an
 * error, then all operations on the object except g_object_ref() and
 * g_object_unref() are considered to be invalid, and have undefined
 * behaviour. They will often fail with g_critical() or g_warning(), but
 * this must not be relied on.
 *
 * Users of objects implementing this are not intended to use
 * the interface method directly, instead it will be used automatically
 * in various ways. For C applications you generally just call
 * g_initable_new() directly, or indirectly via a foo_thing_new() wrapper.
 * This will call g_initable_init() under the cover, returning %NULL and
 * setting a #GError on failure (at which point the instance is
 * unreferenced).
 *
 * For bindings in languages where the native constructor supports
 * exceptions the binding could check for objects implemention %GInitable
 * during normal construction and automatically initialize them, throwing
 * an exception on failure.
 */


/**
 * SECTION:ginputstream
 * @short_description: Base class for implementing streaming input
 * @include: gio/gio.h
 *
 * GInputStream has functions to read from a stream (g_input_stream_read()),
 * to close a stream (g_input_stream_close()) and to skip some content
 * (g_input_stream_skip()).
 *
 * To copy the content of an input stream to an output stream without
 * manually handling the reads and writes, use g_output_stream_splice().
 *
 * All of these functions have async variants too.
 */


/**
 * SECTION:gioerror
 * @short_description: Error helper functions
 * @include: gio/gio.h
 *
 * Contains helper functions for reporting errors to the user.
 */


/**
 * SECTION:giomodule
 * @short_description: Loadable GIO Modules
 * @include: gio/gio.h
 *
 * Provides an interface and default functions for loading and unloading
 * modules. This is used internally to make GIO extensible, but can also
 * be used by others to implement module loading.
 */


/**
 * SECTION:gioscheduler
 * @short_description: I/O Scheduler
 * @include: gio/gio.h
 *
 * Schedules asynchronous I/O operations. #GIOScheduler integrates
 * into the main event loop (#GMainLoop) and uses threads.
 *
 * <para id="io-priority"><indexterm><primary>I/O priority</primary></indexterm>
 * Each I/O operation has a priority, and the scheduler uses the priorities
 * to determine the order in which operations are executed. They are
 * <emphasis>not</emphasis> used to determine system-wide I/O scheduling.
 * Priorities are integers, with lower numbers indicating higher priority.
 * It is recommended to choose priorities between %G_PRIORITY_LOW and
 * %G_PRIORITY_HIGH, with %G_PRIORITY_DEFAULT as a default.
 * </para>
 */


/**
 * SECTION:giostream
 * @short_description: Base class for implementing read/write streams
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GOutputStream
 *
 * GIOStream represents an object that has both read and write streams.
 * Generally the two streams acts as separate input and output streams,
 * but they share some common resources and state. For instance, for
 * seekable streams they may use the same position in both streams.
 *
 * Examples of #GIOStream objects are #GSocketConnection which represents
 * a two-way network connection, and #GFileIOStream which represent a
 * file handle opened in read-write mode.
 *
 * To do the actual reading and writing you need to get the substreams
 * with g_io_stream_get_input_stream() and g_io_stream_get_output_stream().
 *
 * The #GIOStream object owns the input and the output streams, not the other
 * way around, so keeping the substreams alive will not keep the #GIOStream
 * object alive. If the #GIOStream object is freed it will be closed, thus
 * closing the substream, so even if the substreams stay alive they will
 * always just return a %G_IO_ERROR_CLOSED for all operations.
 *
 * To close a stream use g_io_stream_close() which will close the common
 * stream object and also the individual substreams. You can also close
 * the substreams themselves. In most cases this only marks the
 * substream as closed, so further I/O on it fails. However, some streams
 * may support "half-closed" states where one direction of the stream
 * is actually shut down.
 *
 * Since: 2.22
 */


/**
 * SECTION:gloadableicon
 * @short_description: Loadable Icons
 * @include: gio/gio.h
 * @see_also: #GIcon, #GThemedIcon
 *
 * Extends the #GIcon interface and adds the ability to
 * load icons from streams.
 */


/**
 * SECTION:gmemoryinputstream
 * @short_description: Streaming input operations on memory chunks
 * @include: gio/gio.h
 * @see_also: #GMemoryOutputStream
 *
 * #GMemoryInputStream is a class for using arbitrary
 * memory chunks as input for GIO streaming input operations.
 */


/**
 * SECTION:gmemoryoutputstream
 * @short_description: Streaming output operations on memory chunks
 * @include: gio/gio.h
 * @see_also: #GMemoryInputStream
 *
 * #GMemoryOutputStream is a class for using arbitrary
 * memory chunks as output for GIO streaming output operations.
 */


/**
 * SECTION:gmenu
 * @title: GMenu
 * @short_description: A simple implementation of GMenuModel
 *
 * #GMenu is a simple implementation of #GMenuModel.
 * You populate a #GMenu by adding #GMenuItem instances to it.
 *
 * There are some convenience functions to allow you to directly
 * add items (avoiding #GMenuItem) for the common cases. To add
 * a regular item, use g_menu_insert(). To add a section, use
 * g_menu_insert_section(). To add a submenu, use
 * g_menu_insert_submenu().
 *
 * Often it is more convenient to create a #GMenu from an XML
 * fragment, using <link linkend="gio-GMenu-Markup">GMenu Markup</link>.
 */


/**
 * SECTION:gmenuexporter
 * @title: GMenuModel exporter
 * @short_description: Export GMenuModels on D-Bus
 * @see_also: #GMenuModel, #GDBusMenuModel
 *
 * These functions support exporting a #GMenuModel on D-Bus.
 * The D-Bus interface that is used is a private implementation
 * detail.
 *
 * To access an exported #GMenuModel remotely, use
 * g_dbus_menu_model_get() to obtain a #GDBusMenuModel.
 */


/**
 * SECTION:gmenumarkup
 * @title: GMenu Markup
 * @short_description: parsing and printing GMenuModel XML
 *
 * The functions here allow to instantiate #GMenuModels by parsing
 * fragments of an XML document.
 * * The XML format for #GMenuModel consists of a toplevel
 * <tag class="starttag">menu</tag> element, which contains one or more
 * <tag class="starttag">item</tag> elements. Each <tag class="starttag">item</tag>
 * element contains <tag class="starttag">attribute</tag> and <tag class="starttag">link</tag>
 * elements with a mandatory name attribute.
 * <tag class="starttag">link</tag> elements have the same content
 * model as <tag class="starttag">menu</tag>.
 *
 * Here is the XML for <xref linkend="menu-example"/>:
 * |[<xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/menumarkup2.xml"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include>]|
 *
 * The parser also understands a somewhat less verbose format, in which
 * attributes are encoded as actual XML attributes of <tag class="starttag">item</tag>
 * elements, and <tag class="starttag">link</tag> elements are replaced by
 * <tag class="starttag">section</tag> and <tag class="starttag">submenu</tag> elements.
 *
 * Here is how the example looks in this format:
 * |[<xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/menumarkup.xml"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include>]|
 *
 * The parser can obtaing translations for attribute values using gettext.
 * To make use of this, the <tag class="starttag">menu</tag> element must
 * have a domain attribute which specifies the gettext domain to use, and
 * <tag class="starttag">attribute</tag> elements can be marked for translation
 * with a <literal>translatable="yes"</literal> attribute. It is also possible
 * to specify message context and translator comments, using the context
 * and comments attributes.
 *
 * The following DTD describes the XML format approximately:
 * |[<xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/menumarkup.dtd"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include>]|
 *
 * To serialize a #GMenuModel into an XML fragment, use
 * g_menu_markup_print_string().
 */


/**
 * SECTION:gmenumodel
 * @title: GMenuModel
 * @short_description: An abstract class representing the contents of a menu
 * @see_also: #GActionGroup
 *
 * #GMenuModel represents the contents of a menu -- an ordered list of
 * menu items. The items are associated with actions, which can be
 * activated through them. Items can be grouped in sections, and may
 * have submenus associated with them. Both items and sections usually
 * have some representation data, such as labels or icons. The type of
 * the associated action (ie whether it is stateful, and what kind of
 * state it has) can influence the representation of the item.
 *
 * The conceptual model of menus in #GMenuModel is hierarchical:
 * sections and submenus are again represented by #GMenuModels.
 * Menus themselves do not define their own roles. Rather, the role
 * of a particular #GMenuModel is defined by the item that references
 * it (or, in the case of the 'root' menu, is defined by the context
 * in which it is used).
 *
 * As an example, consider the visible portions of the menu in
 * <xref linkend="menu-example"/>.
 *
 * <figure id="menu-example">
 * <title>An example menu</title>
 * <graphic fileref="menu-example.png" format="PNG"></graphic>
 * </figure>
 *
 * There are 8 "menus" visible in the screenshot: one menubar, two
 * submenus and 5 sections:
 * <itemizedlist>
 * <listitem>the toplevel menubar (containing 4 items)</listitem>
 * <listitem>the View submenu (containing 3 sections)</listitem>
 * <listitem>the first section of the View submenu (containing 2 items)</listitem>
 * <listitem>the second section of the View submenu (containing 1 item)</listitem>
 * <listitem>the final section of the View submenu (containing 1 item)</listitem>
 * <listitem>the Highlight Mode submenu (containing 2 sections)</listitem>
 * <listitem>the Sources section (containing 2 items)</listitem>
 * <listitem>the Markup section (containing 2 items)</listitem>
 * </itemizedlist>
 *
 * <xref linkend="menu-model"/> illustrates the conceptual connection between
 * these 8 menus. Each large block in the figure represents a menu and the
 * smaller blocks within the large block represent items in that menu. Some
 * items contain references to other menus.
 *
 * <figure id="menu-model">
 * <title>A menu model</title>
 * <graphic fileref="menu-model.png" format="PNG"></graphic>
 * </figure>
 *
 * Notice that the separators visible in <xref linkend="menu-example"/>
 * appear nowhere in <xref linkend="menu-model"/>. This is because
 * separators are not explicitly represented in the menu model. Instead,
 * a separator is inserted between any two non-empty sections of a menu.
 * Section items can have labels just like any other item. In that case,
 * a display system may show a section header instead of a separator.
 *
 * The motivation for this abstract model of application controls is
 * that modern user interfaces tend to make these controls available
 * outside the application. Examples include global menus, jumplists,
 * dash boards, etc. To support such uses, it is necessary to 'export'
 * information about actions and their representation in menus, which
 * is exactly what the
 * <link linkend="gio-GActionGroup-exporter">GActionGroup exporter</link>
 * and the
 * <link linkend="gio-GMenuModel-exporter">GMenuModel exporter</link>
 * do for #GActionGroup and #GMenuModel. The client-side counterparts
 * to make use of the exported information are #GDBusActionGroup and
 * #GDBusMenuModel.
 *
 * The API of #GMenuModel is very generic, with iterators for the
 * attributes and links of an item, see g_menu_model_iterate_item_attributes()
 * and g_menu_model_iterate_item_links(). The 'standard' attributes and
 * link types have predefined names: %G_MENU_ATTRIBUTE_LABEL,
 * %G_MENU_ATTRIBUTE_ACTION, %G_MENU_ATTRIBUTE_TARGET, %G_MENU_LINK_SECTION
 * and %G_MENU_LINK_SUBMENU.
 *
 * Items in a #GMenuModel represent active controls if they refer to
 * an action that can get activated when the user interacts with the
 * menu item. The reference to the action is encoded by the string id
 * in the %G_MENU_ATTRIBUTE_ACTION attribute. An action id uniquely
 * identifies an action in an action group. Which action group(s) provide
 * actions depends on the context in which the menu model is used.
 * E.g. when the model is exported as the application menu of a
 * #GtkApplication, actions can be application-wide or window-specific
 * (and thus come from two different action groups). By convention, the
 * application-wide actions have names that start with "app.", while the
 * names of window-specific actions start with "win.".
 *
 * While a wide variety of stateful actions is possible, the following
 * is the minimum that is expected to be supported by all users of exported
 * menu information:
 * <itemizedlist>
 * <listitem>an action with no parameter type and no state</listitem>
 * <listitem>an action with no parameter type and boolean state</listitem>
 * <listitem>an action with string parameter type and string state</listitem>
 * </itemizedlist>
 *
 * <formalpara><title>Stateless</title>
 * <para>
 * A stateless action typically corresponds to an ordinary menu item.
 * </para>
 * <para>
 * Selecting such a menu item will activate the action (with no parameter).
 * </para>
 * </formalpara>
 *
 * <formalpara><title>Boolean State</title>
 * <para>
 * An action with a boolean state will most typically be used with a "toggle"
 * or "switch" menu item. The state can be set directly, but activating the
 * action (with no parameter) results in the state being toggled.
 * </para>
 * <para>
 * Selecting a toggle menu item will activate the action. The menu item should
 * be rendered as "checked" when the state is true.
 * </para>
 * </formalpara>
 *
 * <formalpara><title>String Parameter and State</title>
 * <para>
 * Actions with string parameters and state will most typically be used to
 * represent an enumerated choice over the items available for a group of
 * radio menu items. Activating the action with a string parameter is
 * equivalent to setting that parameter as the state.
 * </para>
 * <para>
 * Radio menu items, in addition to being associated with the action, will
 * have a target value. Selecting that menu item will result in activation
 * of the action with the target value as the parameter. The menu item should
 * be rendered as "selected" when the state of the action is equal to the
 * target value of the menu item.
 * </para>
 * </formalpara>
 */


/**
 * SECTION:gmount
 * @short_description: Mount management
 * @include: gio/gio.h
 * @see_also: GVolume, GUnixMount
 *
 * The #GMount interface represents user-visible mounts. Note, when
 * porting from GnomeVFS, #GMount is the moral equivalent of #GnomeVFSVolume.
 *
 * #GMount is a "mounted" filesystem that you can access. Mounted is in
 * quotes because it's not the same as a unix mount, it might be a gvfs
 * mount, but you can still access the files on it if you use GIO. Might or
 * might not be related to a volume object.
 *
 * Unmounting a #GMount instance is an asynchronous operation. For
 * more information about asynchronous operations, see #GAsyncReady
 * and #GSimpleAsyncReady. To unmount a #GMount instance, first call
 * g_mount_unmount_with_operation() with (at least) the #GMount instance and a
 * #GAsyncReadyCallback.  The callback will be fired when the
 * operation has resolved (either with success or failure), and a
 * #GAsyncReady structure will be passed to the callback.  That
 * callback should then call g_mount_unmount_with_operation_finish() with the #GMount
 * and the #GAsyncReady data to see if the operation was completed
 * successfully.  If an @error is present when g_mount_unmount_with_operation_finish()
 * is called, then it will be filled with any error information.
 */


/**
 * SECTION:gmountoperation
 * @short_description: Object used for authentication and user interaction
 * @include: gio/gio.h
 *
 * #GMountOperation provides a mechanism for interacting with the user.
 * It can be used for authenticating mountable operations, such as loop
 * mounting files, hard drive partitions or server locations. It can
 * also be used to ask the user questions or show a list of applications
 * preventing unmount or eject operations from completing.
 *
 * Note that #GMountOperation is used for more than just #GMount
 * objects – for example it is also used in g_drive_start() and
 * g_drive_stop().
 *
 * Users should instantiate a subclass of this that implements all the
 * various callbacks to show the required dialogs, such as
 * #GtkMountOperation. If no user interaction is desired (for example
 * when automounting filesystems at login time), usually %NULL can be
 * passed, see each method taking a #GMountOperation for details.
 */


/**
 * SECTION:gnetworkaddress
 * @short_description: A GSocketConnectable for resolving hostnames
 * @include: gio/gio.h
 *
 * #GNetworkAddress provides an easy way to resolve a hostname and
 * then attempt to connect to that host, handling the possibility of
 * multiple IP addresses and multiple address families.
 *
 * See #GSocketConnectable for and example of using the connectable
 * interface.
 */


/**
 * SECTION:gnetworkmonitor
 * @title: GNetworkMonitor
 * @short_description: Network status monitor
 * @include: gio/gio.h
 *
 *
 */


/**
 * SECTION:gnetworkservice
 * @short_description: A GSocketConnectable for resolving SRV records
 * @include: gio/gio.h
 *
 * Like #GNetworkAddress does with hostnames, #GNetworkService
 * provides an easy way to resolve a SRV record, and then attempt to
 * connect to one of the hosts that implements that service, handling
 * service priority/weighting, multiple IP addresses, and multiple
 * address families.
 *
 * See #GSrvTarget for more information about SRV records, and see
 * #GSocketConnectable for and example of using the connectable
 * interface.
 */


/**
 * SECTION:goutputstream
 * @short_description: Base class for implementing streaming output
 * @include: gio/gio.h
 *
 * GOutputStream has functions to write to a stream (g_output_stream_write()),
 * to close a stream (g_output_stream_close()) and to flush pending writes
 * (g_output_stream_flush()).
 *
 * To copy the content of an input stream to an output stream without
 * manually handling the reads and writes, use g_output_stream_splice().
 *
 * All of these functions have async variants too.
 */


/**
 * SECTION:gpermission
 * @title: GPermission
 * @short_description: An object representing the permission to perform a certain action
 *
 * A #GPermission represents the status of the caller's permission to
 * perform a certain action.
 *
 * You can query if the action is currently allowed and if it is
 * possible to acquire the permission so that the action will be allowed
 * in the future.
 *
 * There is also an API to actually acquire the permission and one to
 * release it.
 *
 * As an example, a #GPermission might represent the ability for the
 * user to write to a #GSettings object.  This #GPermission object could
 * then be used to decide if it is appropriate to show a "Click here to
 * unlock" button in a dialog and to provide the mechanism to invoke
 * when that button is clicked.
 */


/**
 * SECTION:gpollableinputstream
 * @short_description: Interface for pollable input streams
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GPollableOutputStream, #GFileDescriptorBased
 *
 * #GPollableInputStream is implemented by #GInputStream<!-- -->s that
 * can be polled for readiness to read. This can be used when
 * interfacing with a non-GIO API that expects
 * UNIX-file-descriptor-style asynchronous I/O rather than GIO-style.
 *
 * Since: 2.28
 */


/**
 * SECTION:gpollableoutputstream
 * @short_description: Interface for pollable output streams
 * @include: gio/gio.h
 * @see_also: #GOutputStream, #GFileDescriptorBased, #GPollableInputStream
 *
 * #GPollableOutputStream is implemented by #GOutputStream<!-- -->s that
 * can be polled for readiness to write. This can be used when
 * interfacing with a non-GIO API that expects
 * UNIX-file-descriptor-style asynchronous I/O rather than GIO-style.
 *
 * Since: 2.28
 */


/**
 * SECTION:gproxy
 * @short_description: Interface for proxy handling
 *
 * A #GProxy handles connecting to a remote host via a given type of
 * proxy server. It is implemented by the 'gio-proxy' extension point.
 * The extensions are named after their proxy protocol name. As an
 * example, a SOCKS5 proxy implementation can be retrieved with the
 * name 'socks5' using the function
 * g_io_extension_point_get_extension_by_name().
 *
 * Since: 2.26
 */


/**
 * SECTION:gproxyaddress
 * @short_description: An internet address with proxy information
 *
 * Support for proxied #GInetSocketAddress.
 */


/**
 * SECTION:gproxyresolver
 * @short_description: Asynchronous and cancellable network proxy resolver
 * @include: gio/gio.h
 *
 * #GProxyResolver provides synchronous and asynchronous network proxy
 * resolution. #GProxyResolver is used within #GSocketClient through
 * the method g_socket_connectable_proxy_enumerate().
 */


/**
 * SECTION:gremoteactiongroup
 * @title: GRemoteActionGroup
 * @short_description: a #GActionGroup that interacts with other processes
 *
 * The GRemoteActionGroup interface is implemented by #GActionGroup
 * instances that either transmit action invocations to other processes
 * or receive action invocations in the local process from other
 * processes.
 *
 * The interface has <literal>_full</literal> variants of the two
 * methods on #GActionGroup used to activate actions:
 * g_action_group_activate_action() and
 * g_action_group_change_action_state().  These variants allow a
 * "platform data" #GVariant to be specified: a dictionary providing
 * context for the action invocation (for example: timestamps, startup
 * notification IDs, etc).
 *
 * #GDBusActionGroup implements #GRemoteActionGroup.  This provides a
 * mechanism to send platform data for action invocations over D-Bus.
 *
 * Additionally, g_dbus_connection_export_action_group() will check if
 * the exported #GActionGroup implements #GRemoteActionGroup and use the
 * <literal>_full</literal> variants of the calls if available.  This
 * provides a mechanism by which to receive platform data for action
 * invocations that arrive by way of D-Bus.
 *
 * Since: 2.32
 */


/**
 * SECTION:gresolver
 * @short_description: Asynchronous and cancellable DNS resolver
 * @include: gio/gio.h
 *
 * #GResolver provides cancellable synchronous and asynchronous DNS
 * resolution, for hostnames (g_resolver_lookup_by_address(),
 * g_resolver_lookup_by_name() and their async variants) and SRV
 * (service) records (g_resolver_lookup_service()).
 *
 * #GNetworkAddress and #GNetworkService provide wrappers around
 * #GResolver functionality that also implement #GSocketConnectable,
 * making it easy to connect to a remote host/service.
 */


/**
 * SECTION:gseekable
 * @short_description: Stream seeking interface
 * @include: gio/gio.h
 * @see_also: #GInputStream, #GOutputStream
 *
 * #GSeekable is implemented by streams (implementations of
 * #GInputStream or #GOutputStream) that support seeking.
 */


/**
 * SECTION:gsettings
 * @short_description: High-level API for application settings
 *
 * The #GSettings class provides a convenient API for storing and retrieving
 * application settings.
 *
 * Reads and writes can be considered to be non-blocking.  Reading
 * settings with #GSettings is typically extremely fast: on
 * approximately the same order of magnitude (but slower than) a
 * #GHashTable lookup.  Writing settings is also extremely fast in terms
 * of time to return to your application, but can be extremely expensive
 * for other threads and other processes.  Many settings backends
 * (including dconf) have lazy initialisation which means in the common
 * case of the user using their computer without modifying any settings
 * a lot of work can be avoided.  For dconf, the D-Bus service doesn't
 * even need to be started in this case.  For this reason, you should
 * only ever modify #GSettings keys in response to explicit user action.
 * Particular care should be paid to ensure that modifications are not
 * made during startup -- for example, when setting the initial value
 * of preferences widgets.  The built-in g_settings_bind() functionality
 * is careful not to write settings in response to notify signals as a
 * result of modifications that it makes to widgets.
 *
 * When creating a GSettings instance, you have to specify a schema
 * that describes the keys in your settings and their types and default
 * values, as well as some other information.
 *
 * Normally, a schema has as fixed path that determines where the settings
 * are stored in the conceptual global tree of settings. However, schemas
 * can also be 'relocatable', i.e. not equipped with a fixed path. This is
 * useful e.g. when the schema describes an 'account', and you want to be
 * able to store a arbitrary number of accounts.
 *
 * Unlike other configuration systems (like GConf), GSettings does not
 * restrict keys to basic types like strings and numbers. GSettings stores
 * values as #GVariant, and allows any #GVariantType for keys. Key names
 * are restricted to lowercase characters, numbers and '-'. Furthermore,
 * the names must begin with a lowercase character, must not end
 * with a '-', and must not contain consecutive dashes.
 *
 * Similar to GConf, the default values in GSettings schemas can be
 * localized, but the localized values are stored in gettext catalogs
 * and looked up with the domain that is specified in the
 * <tag class="attribute">gettext-domain</tag> attribute of the
 * <tag class="starttag">schemalist</tag> or <tag class="starttag">schema</tag>
 * elements and the category that is specified in the l10n attribute of the
 * <tag class="starttag">key</tag> element.
 *
 * GSettings uses schemas in a compact binary form that is created
 * by the <link linkend="glib-compile-schemas">glib-compile-schemas</link>
 * utility. The input is a schema description in an XML format that can be
 * described by the following DTD:
 * |[<xi:include xmlns:xi="http://www.w3.org/2001/XInclude" parse="text" href="../../../../gio/gschema.dtd"><xi:fallback>FIXME: MISSING XINCLUDE CONTENT</xi:fallback></xi:include>]|
 *
 * glib-compile-schemas expects schema files to have the extension <filename>.gschema.xml</filename>
 *
 * At runtime, schemas are identified by their id (as specified
 * in the <tag class="attribute">id</tag> attribute of the
 * <tag class="starttag">schema</tag> element). The
 * convention for schema ids is to use a dotted name, similar in
 * style to a D-Bus bus name, e.g. "org.gnome.SessionManager". In particular,
 * if the settings are for a specific service that owns a D-Bus bus name,
 * the D-Bus bus name and schema id should match. For schemas which deal
 * with settings not associated with one named application, the id should
 * not use StudlyCaps, e.g. "org.gnome.font-rendering".
 *
 * In addition to #GVariant types, keys can have types that have enumerated
 * types. These can be described by a <tag class="starttag">choice</tag>,
 * <tag class="starttag">enum</tag> or <tag class="starttag">flags</tag> element, see
 * <xref linkend="schema-enumerated"/>. The underlying type of
 * such a key is string, but you can use g_settings_get_enum(),
 * g_settings_set_enum(), g_settings_get_flags(), g_settings_set_flags()
 * access the numeric values corresponding to the string value of enum
 * and flags keys.
 *
 * <example id="schema-default-values"><title>Default values</title>
 * <programlisting><![CDATA[
 * <schemalist>
 * <schema id="org.gtk.Test" path="/tests/" gettext-domain="test">
 *
 * <key name="greeting" type="s">
 * <default l10n="messages">"Hello, earthlings"</default>
 * <summary>A greeting</summary>
 * <description>
 * Greeting of the invading martians
 * </description>
 * </key>
 *
 * <key name="box" type="(ii)">
 * <default>(20,30)</default>
 * </key>
 *
 * </schema>
 * </schemalist>
 * ]]></programlisting></example>
 *
 * <example id="schema-enumerated"><title>Ranges, choices and enumerated types</title>
 * <programlisting><![CDATA[
 * <schemalist>
 *
 * <enum id="org.gtk.Test.myenum">
 * <value nick="first" value="1"/>
 * <value nick="second" value="2"/>
 * </enum>
 *
 * <flags id="org.gtk.Test.myflags">
 * <value nick="flag1" value="1"/>
 * <value nick="flag2" value="2"/>
 * <value nick="flag3" value="4"/>
 * </flags>
 *
 * <schema id="org.gtk.Test">
 *
 * <key name="key-with-range" type="i">
 * <range min="1" max="100"/>
 * <default>10</default>
 * </key>
 *
 * <key name="key-with-choices" type="s">
 * <choices>
 * <choice value='Elisabeth'/>
 * <choice value='Annabeth'/>
 * <choice value='Joe'/>
 * </choices>
 * <aliases>
 * <alias value='Anna' target='Annabeth'/>
 * <alias value='Beth' target='Elisabeth'/>
 * </aliases>
 * <default>'Joe'</default>
 * </key>
 *
 * <key name='enumerated-key' enum='org.gtk.Test.myenum'>
 * <default>'first'</default>
 * </key>
 *
 * <key name='flags-key' flags='org.gtk.Test.myflags'>
 * <default>["flag1",flag2"]</default>
 * </key>
 * </schema>
 * </schemalist>
 * ]]></programlisting></example>
 *
 * <refsect2>
 * <title>Vendor overrides</title>
 * <para>
 * Default values are defined in the schemas that get installed by
 * an application. Sometimes, it is necessary for a vendor or distributor
 * to adjust these defaults. Since patching the XML source for the schema
 * is inconvenient and error-prone,
 * <link linkend="glib-compile-schemas">glib-compile-schemas</link> reads
 * so-called 'vendor override' files. These are keyfiles in the same
 * directory as the XML schema sources which can override default values.
 * The schema id serves as the group name in the key file, and the values
 * are expected in serialized GVariant form, as in the following example:
 * <informalexample><programlisting>
 * [org.gtk.Example]
 * key1='string'
 * key2=1.5
 * </programlisting></informalexample>
 * </para>
 * <para>
 * glib-compile-schemas expects schema files to have the extension
 * <filename>.gschema.override</filename>
 * </para>
 * </refsect2>
 *
 * <refsect2>
 * <title>Binding</title>
 * <para>
 * A very convenient feature of GSettings lets you bind #GObject properties
 * directly to settings, using g_settings_bind(). Once a GObject property
 * has been bound to a setting, changes on either side are automatically
 * propagated to the other side. GSettings handles details like
 * mapping between GObject and GVariant types, and preventing infinite
 * cycles.
 * </para>
 * <para>
 * This makes it very easy to hook up a preferences dialog to the
 * underlying settings. To make this even more convenient, GSettings
 * looks for a boolean property with the name "sensitivity" and
 * automatically binds it to the writability of the bound setting.
 * If this 'magic' gets in the way, it can be suppressed with the
 * #G_SETTINGS_BIND_NO_SENSITIVITY flag.
 * </para>
 * </refsect2>
 */


/**
 * SECTION:gsettingsbackend
 * @title: GSettingsBackend
 * @short_description: Interface for settings backend implementations
 * @include: gio/gsettingsbackend.h
 * @see_also: #GSettings, #GIOExtensionPoint
 *
 * The #GSettingsBackend interface defines a generic interface for
 * non-strictly-typed data that is stored in a hierarchy. To implement
 * an alternative storage backend for #GSettings, you need to implement
 * the #GSettingsBackend interface and then make it implement the
 * extension point #G_SETTINGS_BACKEND_EXTENSION_POINT_NAME.
 *
 * The interface defines methods for reading and writing values, a
 * method for determining if writing of certain values will fail
 * (lockdown) and a change notification mechanism.
 *
 * The semantics of the interface are very precisely defined and
 * implementations must carefully adhere to the expectations of
 * callers that are documented on each of the interface methods.
 *
 * Some of the GSettingsBackend functions accept or return a #GTree.
 * These trees always have strings as keys and #GVariant as values.
 * g_settings_backend_create_tree() is a convenience function to create
 * suitable trees.
 *
 * <note><para>
 * The #GSettingsBackend API is exported to allow third-party
 * implementations, but does not carry the same stability guarantees
 * as the public GIO API. For this reason, you have to define the
 * C preprocessor symbol #G_SETTINGS_ENABLE_BACKEND before including
 * <filename>gio/gsettingsbackend.h</filename>
 * </para></note>
 */


/**
 * SECTION:gsettingsschema
 * @short_description: introspecting and controlling the loading of #GSettings schemas
 *
 * The #GSettingsSchemaSource and #GSettingsSchema APIs provide a
 * mechanism for advanced control over the loading of schemas and a
 * mechanism for introspecting their content.
 *
 * Plugin loading systems that wish to provide plugins a way to access
 * settings face the problem of how to make the schemas for these
 * settings visible to GSettings.  Typically, a plugin will want to ship
 * the schema along with itself and it won't be installed into the
 * standard system directories for schemas.
 *
 * #GSettingsSchemaSource provides a mechanism for dealing with this by
 * allowing the creation of a new 'schema source' from which schemas can
 * be acquired.  This schema source can then become part of the metadata
 * associated with the plugin and queried whenever the plugin requires
 * access to some settings.
 *
 * Consider the following example:
 *
 * |[
 * typedef struct
 * {
 * ...
 * GSettingsSchemaSource *schema_source;
 * ...
 * } Plugin;
 *
 * Plugin *
 * initialise_plugin (const gchar *dir)
 * {
 * Plugin *plugin;
 *
 * ...
 *
 * plugin->schema_source =
 * g_settings_new_schema_source_from_directory (dir,
 * g_settings_schema_source_get_default (), FALSE, NULL);
 *
 * ...
 *
 * return plugin;
 * }
 *
 * ...
 *
 * GSettings *
 * plugin_get_settings (Plugin      *plugin,
 * const gchar *schema_id)
 * {
 * GSettingsSchema *schema;
 *
 * if (schema_id == NULL)
 * schema_id = plugin->identifier;
 *
 * schema = g_settings_schema_source_lookup (plugin->schema_source,
 * schema_id, FALSE);
 *
 * if (schema == NULL)
 * {
 * ... disable the plugin or abort, etc ...
 * }
 *
 * return g_settings_new_full (schema, NULL, NULL);
 * }
 * ]|
 *
 * The code above shows how hooks should be added to the code that
 * initialises (or enables) the plugin to create the schema source and
 * how an API can be added to the plugin system to provide a convenient
 * way for the plugin to access its settings, using the schemas that it
 * ships.
 *
 * From the standpoint of the plugin, it would need to ensure that it
 * ships a gschemas.compiled file as part of itself, and then simply do
 * the following:
 *
 * |[
 * {
 * GSettings *settings;
 * gint some_value;
 *
 * settings = plugin_get_settings (self, NULL);
 * some_value = g_settings_get_int (settings, "some-value");
 * ...
 * }
 * ]|
 *
 * It's also possible that the plugin system expects the schema source
 * files (ie: .gschema.xml files) instead of a gschemas.compiled file.
 * In that case, the plugin loading system must compile the schemas for
 * itself before attempting to create the settings source.
 *
 * Since: 2.32
 */


/**
 * SECTION:gsimpleaction
 * @title: GSimpleAction
 * @short_description: A simple GAction implementation
 *
 * A #GSimpleAction is the obvious simple implementation of the #GAction
 * interface. This is the easiest way to create an action for purposes of
 * adding it to a #GSimpleActionGroup.
 *
 * See also #GtkAction.
 */


/**
 * SECTION:gsimpleactiongroup
 * @title: GSimpleActionGroup
 * @short_description: A simple GActionGroup implementation
 *
 * #GSimpleActionGroup is a hash table filled with #GAction objects,
 * implementing the #GActionGroup and #GActionMap interfaces.
 */


/**
 * SECTION:gsimpleasyncresult
 * @short_description: Simple asynchronous results implementation
 * @include: gio/gio.h
 * @see_also: #GAsyncResult
 *
 * Implements #GAsyncResult for simple cases. Most of the time, this
 * will be all an application needs, and will be used transparently.
 * Because of this, #GSimpleAsyncResult is used throughout GIO for
 * handling asynchronous functions.
 *
 * GSimpleAsyncResult handles #GAsyncReadyCallback<!-- -->s, error
 * reporting, operation cancellation and the final state of an operation,
 * completely transparent to the application. Results can be returned
 * as a pointer e.g. for functions that return data that is collected
 * asynchronously, a boolean value for checking the success or failure
 * of an operation, or a #gssize for operations which return the number
 * of bytes modified by the operation; all of the simple return cases
 * are covered.
 *
 * Most of the time, an application will not need to know of the details
 * of this API; it is handled transparently, and any necessary operations
 * are handled by #GAsyncResult's interface. However, if implementing a
 * new GIO module, for writing language bindings, or for complex
 * applications that need better control of how asynchronous operations
 * are completed, it is important to understand this functionality.
 *
 * GSimpleAsyncResults are tagged with the calling function to ensure
 * that asynchronous functions and their finishing functions are used
 * together correctly.
 *
 * To create a new #GSimpleAsyncResult, call g_simple_async_result_new().
 * If the result needs to be created for a #GError, use
 * g_simple_async_result_new_from_error() or
 * g_simple_async_result_new_take_error(). If a #GError is not available
 * (e.g. the asynchronous operation's doesn't take a #GError argument),
 * but the result still needs to be created for an error condition, use
 * g_simple_async_result_new_error() (or g_simple_async_result_set_error_va()
 * if your application or binding requires passing a variable argument list
 * directly), and the error can then be propagated through the use of
 * g_simple_async_result_propagate_error().
 *
 * An asynchronous operation can be made to ignore a cancellation event by
 * calling g_simple_async_result_set_handle_cancellation() with a
 * #GSimpleAsyncResult for the operation and %FALSE. This is useful for
 * operations that are dangerous to cancel, such as close (which would
 * cause a leak if cancelled before being run).
 *
 * GSimpleAsyncResult can integrate into GLib's event loop, #GMainLoop,
 * or it can use #GThread<!-- -->s.
 * g_simple_async_result_complete() will finish an I/O task directly
 * from the point where it is called. g_simple_async_result_complete_in_idle()
 * will finish it from an idle handler in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * context</link>. g_simple_async_result_run_in_thread() will run the
 * job in a separate thread and then deliver the result to the
 * thread-default main context.
 *
 * To set the results of an asynchronous function,
 * g_simple_async_result_set_op_res_gpointer(),
 * g_simple_async_result_set_op_res_gboolean(), and
 * g_simple_async_result_set_op_res_gssize()
 * are provided, setting the operation's result to a gpointer, gboolean, or
 * gssize, respectively.
 *
 * Likewise, to get the result of an asynchronous function,
 * g_simple_async_result_get_op_res_gpointer(),
 * g_simple_async_result_get_op_res_gboolean(), and
 * g_simple_async_result_get_op_res_gssize() are
 * provided, getting the operation's result as a gpointer, gboolean, and
 * gssize, respectively.
 *
 * For the details of the requirements implementations must respect, see
 * #GAsyncResult.  A typical implementation of an asynchronous operation
 * using GSimpleAsyncResult looks something like this:
 *
 * |[
 * static void
 * baked_cb (Cake    *cake,
 * gpointer user_data)
 * {
 * /&ast; In this example, this callback is not given a reference to the cake, so
 * &ast; the GSimpleAsyncResult has to take a reference to it.
 * &ast;/
 * GSimpleAsyncResult *result = user_data;
 *
 * if (cake == NULL)
 * g_simple_async_result_set_error (result,
 * BAKER_ERRORS,
 * BAKER_ERROR_NO_FLOUR,
 * "Go to the supermarket");
 * else
 * g_simple_async_result_set_op_res_gpointer (result,
 * g_object_ref (cake),
 * g_object_unref);
 *
 *
 * /&ast; In this example, we assume that baked_cb is called as a callback from
 * &ast; the mainloop, so it's safe to complete the operation synchronously here.
 * &ast; If, however, _baker_prepare_cake () might call its callback without
 * &ast; first returning to the mainloop — inadvisable, but some APIs do so —
 * &ast; we would need to use g_simple_async_result_complete_in_idle().
 * &ast;/
 * g_simple_async_result_complete (result);
 * g_object_unref (result);
 * }
 *
 * void
 * baker_bake_cake_async (Baker              *self,
 * guint               radius,
 * GAsyncReadyCallback callback,
 * gpointer            user_data)
 * {
 * GSimpleAsyncResult *simple;
 * Cake               *cake;
 *
 * if (radius < 3)
 * {
 * g_simple_async_report_error_in_idle (G_OBJECT (self),
 * callback,
 * user_data,
 * BAKER_ERRORS,
 * BAKER_ERROR_TOO_SMALL,
 * "%ucm radius cakes are silly",
 * radius);
 * return;
 * }
 *
 * simple = g_simple_async_result_new (G_OBJECT (self),
 * callback,
 * user_data,
 * baker_bake_cake_async);
 * cake = _baker_get_cached_cake (self, radius);
 *
 * if (cake != NULL)
 * {
 * g_simple_async_result_set_op_res_gpointer (simple,
 * g_object_ref (cake),
 * g_object_unref);
 * g_simple_async_result_complete_in_idle (simple);
 * g_object_unref (simple);
 * /&ast; Drop the reference returned by _baker_get_cached_cake(); the
 * &ast; GSimpleAsyncResult has taken its own reference.
 * &ast;/
 * g_object_unref (cake);
 * return;
 * }
 *
 * _baker_prepare_cake (self, radius, baked_cb, simple);
 * }
 *
 * Cake *
 * baker_bake_cake_finish (Baker        *self,
 * GAsyncResult *result,
 * GError      **error)
 * {
 * GSimpleAsyncResult *simple;
 * Cake               *cake;
 *
 * g_return_val_if_fail (g_simple_async_result_is_valid (result,
 * G_OBJECT (self),
 * baker_bake_cake_async),
 * NULL);
 *
 * simple = (GSimpleAsyncResult *) result;
 *
 * if (g_simple_async_result_propagate_error (simple, error))
 * return NULL;
 *
 * cake = CAKE (g_simple_async_result_get_op_res_gpointer (simple));
 * return g_object_ref (cake);
 * }
 * ]|
 */


/**
 * SECTION:gsimplepermission
 * @title: GSimplePermission
 * @short_description: A GPermission that doesn't change value
 *
 * #GSimplePermission is a trivial implementation of #GPermission that
 * represents a permission that is either always or never allowed.  The
 * value is given at construction and doesn't change.
 *
 * Calling request or release will result in errors.
 */


/**
 * SECTION:gsocket
 * @short_description: Low-level socket object
 * @include: gio/gio.h
 * @see_also: #GInitable
 *
 * A #GSocket is a low-level networking primitive. It is a more or less
 * direct mapping of the BSD socket API in a portable GObject based API.
 * It supports both the UNIX socket implementations and winsock2 on Windows.
 *
 * #GSocket is the platform independent base upon which the higher level
 * network primitives are based. Applications are not typically meant to
 * use it directly, but rather through classes like #GSocketClient,
 * #GSocketService and #GSocketConnection. However there may be cases where
 * direct use of #GSocket is useful.
 *
 * #GSocket implements the #GInitable interface, so if it is manually constructed
 * by e.g. g_object_new() you must call g_initable_init() and check the
 * results before using the object. This is done automatically in
 * g_socket_new() and g_socket_new_from_fd(), so these functions can return
 * %NULL.
 *
 * Sockets operate in two general modes, blocking or non-blocking. When
 * in blocking mode all operations block until the requested operation
 * is finished or there is an error. In non-blocking mode all calls that
 * would block return immediately with a %G_IO_ERROR_WOULD_BLOCK error.
 * To know when a call would successfully run you can call g_socket_condition_check(),
 * or g_socket_condition_wait(). You can also use g_socket_create_source() and
 * attach it to a #GMainContext to get callbacks when I/O is possible.
 * Note that all sockets are always set to non blocking mode in the system, and
 * blocking mode is emulated in GSocket.
 *
 * When working in non-blocking mode applications should always be able to
 * handle getting a %G_IO_ERROR_WOULD_BLOCK error even when some other
 * function said that I/O was possible. This can easily happen in case
 * of a race condition in the application, but it can also happen for other
 * reasons. For instance, on Windows a socket is always seen as writable
 * until a write returns %G_IO_ERROR_WOULD_BLOCK.
 *
 * #GSocket<!-- -->s can be either connection oriented or datagram based.
 * For connection oriented types you must first establish a connection by
 * either connecting to an address or accepting a connection from another
 * address. For connectionless socket types the target/source address is
 * specified or received in each I/O operation.
 *
 * All socket file descriptors are set to be close-on-exec.
 *
 * Note that creating a #GSocket causes the signal %SIGPIPE to be
 * ignored for the remainder of the program. If you are writing a
 * command-line utility that uses #GSocket, you may need to take into
 * account the fact that your program will not automatically be killed
 * if it tries to write to %stdout after it has been closed.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsocketaddress
 * @short_description: Abstract base class representing endpoints for socket communication
 *
 * #GSocketAddress is the equivalent of <type>struct sockaddr</type>
 * in the BSD sockets API. This is an abstract class; use
 * #GInetSocketAddress for internet sockets, or #GUnixSocketAddress
 * for UNIX domain sockets.
 */


/**
 * SECTION:gsocketclient
 * @short_description: Helper for connecting to a network service
 * @include: gio/gio.h
 * @see_also: #GSocketConnection, #GSocketListener
 *
 * #GSocketClient is a high-level utility class for connecting to a
 * network host using a connection oriented socket type.
 *
 * You create a #GSocketClient object, set any options you want, and then
 * call a sync or async connect operation, which returns a #GSocketConnection
 * subclass on success.
 *
 * The type of the #GSocketConnection object returned depends on the type of
 * the underlying socket that is in use. For instance, for a TCP/IP connection
 * it will be a #GTcpConnection.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsocketconnectable
 * @short_description: Interface for potential socket endpoints
 *
 * Objects that describe one or more potential socket endpoints
 * implement #GSocketConnectable. Callers can then use
 * g_socket_connectable_enumerate() to get a #GSocketAddressEnumerator
 * to try out each socket address in turn until one succeeds, as shown
 * in the sample code below.
 *
 * |[
 * MyConnectionType *
 * connect_to_host (const char    *hostname,
 * guint16        port,
 * GCancellable  *cancellable,
 * GError       **error)
 * {
 * MyConnection *conn = NULL;
 * GSocketConnectable *addr;
 * GSocketAddressEnumerator *enumerator;
 * GSocketAddress *sockaddr;
 * GError *conn_error = NULL;
 *
 * addr = g_network_address_new ("www.gnome.org", 80);
 * enumerator = g_socket_connectable_enumerate (addr);
 * g_object_unref (addr);
 *
 * /<!-- -->* Try each sockaddr until we succeed. Record the first
 * * connection error, but not any further ones (since they'll probably
 * * be basically the same as the first).
 * *<!-- -->/
 * while (!conn && (sockaddr = g_socket_address_enumerator_next (enumerator, cancellable, error))
 * {
 * conn = connect_to_sockaddr (sockaddr, conn_error ? NULL : &conn_error);
 * g_object_unref (sockaddr);
 * }
 * g_object_unref (enumerator);
 *
 * if (conn)
 * {
 * if (conn_error)
 * {
 * /<!-- -->* We couldn't connect to the first address, but we succeeded
 * * in connecting to a later address.
 * *<!-- -->/
 * g_error_free (conn_error);
 * }
 * return conn;
 * }
 * else if (error)
 * {
 * /<!-- -->* Either the initial lookup failed, or else the caller
 * * cancelled us.
 * *<!-- -->/
 * if (conn_error)
 * g_error_free (conn_error);
 * return NULL;
 * }
 * else
 * {
 * g_error_propagate (error, conn_error);
 * return NULL;
 * }
 * }
 * ]|
 */


/**
 * SECTION:gsocketconnection
 * @short_description: A socket connection
 * @include: gio/gio.h
 * @see_also: #GIOStream, #GSocketClient, #GSocketListener
 *
 * #GSocketConnection is a #GIOStream for a connected socket. They
 * can be created either by #GSocketClient when connecting to a host,
 * or by #GSocketListener when accepting a new client.
 *
 * The type of the #GSocketConnection object returned from these calls
 * depends on the type of the underlying socket that is in use. For
 * instance, for a TCP/IP connection it will be a #GTcpConnection.
 *
 * Choosing what type of object to construct is done with the socket
 * connection factory, and it is possible for 3rd parties to register
 * custom socket connection types for specific combination of socket
 * family/type/protocol using g_socket_connection_factory_register_type().
 *
 * Since: 2.22
 */


/**
 * SECTION:gsocketcontrolmessage
 * @title: GSocketControlMessage
 * @short_description: A GSocket control message
 * @see_also: #GSocket.
 *
 * A #GSocketControlMessage is a special-purpose utility message that
 * can be sent to or received from a #GSocket. These types of
 * messages are often called "ancillary data".
 *
 * The message can represent some sort of special instruction to or
 * information from the socket or can represent a special kind of
 * transfer to the peer (for example, sending a file description over
 * a UNIX socket).
 *
 * These messages are sent with g_socket_send_message() and received
 * with g_socket_receive_message().
 *
 * To extend the set of control message that can be sent, subclass this
 * class and override the get_size, get_level, get_type and serialize
 * methods.
 *
 * To extend the set of control messages that can be received, subclass
 * this class and implement the deserialize method. Also, make sure your
 * class is registered with the GType typesystem before calling
 * g_socket_receive_message() to read such a message.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsocketlistener
 * @title: GSocketListener
 * @short_description: Helper for accepting network client connections
 * @see_also: #GThreadedSocketService, #GSocketService.
 *
 * A #GSocketListener is an object that keeps track of a set
 * of server sockets and helps you accept sockets from any of the
 * socket, either sync or async.
 *
 * If you want to implement a network server, also look at #GSocketService
 * and #GThreadedSocketService which are subclass of #GSocketListener
 * that makes this even easier.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsocketservice
 * @title: GSocketService
 * @short_description: Make it easy to implement a network service
 * @see_also: #GThreadedSocketService, #GSocketListener.
 *
 * A #GSocketService is an object that represents a service that
 * is provided to the network or over local sockets.  When a new
 * connection is made to the service the #GSocketService::incoming
 * signal is emitted.
 *
 * A #GSocketService is a subclass of #GSocketListener and you need
 * to add the addresses you want to accept connections on with the
 * #GSocketListener APIs.
 *
 * There are two options for implementing a network service based on
 * #GSocketService. The first is to create the service using
 * g_socket_service_new() and to connect to the #GSocketService::incoming
 * signal. The second is to subclass #GSocketService and override the
 * default signal handler implementation.
 *
 * In either case, the handler must immediately return, or else it
 * will block additional incoming connections from being serviced.
 * If you are interested in writing connection handlers that contain
 * blocking code then see #GThreadedSocketService.
 *
 * The socket service runs on the main loop of the <link
 * linkend="g-main-context-push-thread-default-context">thread-default
 * context</link> of the thread it is created in, and is not
 * threadsafe in general. However, the calls to start and stop the
 * service are thread-safe so these can be used from threads that
 * handle incoming clients.
 *
 * Since: 2.22
 */


/**
 * SECTION:gsrvtarget
 * @short_description: DNS SRV record target
 * @include: gio/gio.h
 *
 * SRV (service) records are used by some network protocols to provide
 * service-specific aliasing and load-balancing. For example, XMPP
 * (Jabber) uses SRV records to locate the XMPP server for a domain;
 * rather than connecting directly to "example.com" or assuming a
 * specific server hostname like "xmpp.example.com", an XMPP client
 * would look up the "xmpp-client" SRV record for "example.com", and
 * then connect to whatever host was pointed to by that record.
 *
 * You can use g_resolver_lookup_service() or
 * g_resolver_lookup_service_async() to find the #GSrvTarget<!-- -->s
 * for a given service. However, if you are simply planning to connect
 * to the remote service, you can use #GNetworkService's
 * #GSocketConnectable interface and not need to worry about
 * #GSrvTarget at all.
 */


/**
 * SECTION:gtcpconnection
 * @title: GTcpConnection
 * @short_description: A TCP GSocketConnection
 * @see_also: #GSocketConnection.
 *
 * This is the subclass of #GSocketConnection that is created
 * for TCP/IP sockets.
 *
 * Since: 2.22
 */


/**
 * SECTION:gtcpwrapperconnection
 * @title: GTcpWrapperConnection
 * @short_description: wrapper for non-GSocketConnection-based, GSocket-based GIOStreams
 * @see_also: #GSocketConnection.
 *
 * A #GTcpWrapperConnection can be used to wrap a #GIOStream that is
 * based on a #GSocket, but which is not actually a
 * #GSocketConnection. This is used by #GSocketClient so that it can
 * always return a #GSocketConnection, even when the connection it has
 * actually created is not directly a #GSocketConnection.
 *
 * Since: 2.28
 */


/**
 * SECTION:gthemedicon
 * @short_description: Icon theming support
 * @include: gio/gio.h
 * @see_also: #GIcon, #GLoadableIcon
 *
 * #GThemedIcon is an implementation of #GIcon that supports icon themes.
 * #GThemedIcon contains a list of all of the icons present in an icon
 * theme, so that icons can be looked up quickly. #GThemedIcon does
 * not provide actual pixmaps for icons, just the icon names.
 * Ideally something like gtk_icon_theme_choose_icon() should be used to
 * resolve the list of names so that fallback icons work nicely with
 * themes that inherit other themes.
 */


/**
 * SECTION:gthreadedsocketservice
 * @title: GThreadedSocketService
 * @short_description: A threaded GSocketService
 * @see_also: #GSocketService.
 *
 * A #GThreadedSocketService is a simple subclass of #GSocketService
 * that handles incoming connections by creating a worker thread and
 * dispatching the connection to it by emitting the
 * #GThreadedSocketService::run signal in the new thread.
 *
 * The signal handler may perform blocking IO and need not return
 * until the connection is closed.
 *
 * The service is implemented using a thread pool, so there is a
 * limited amount of threads available to serve incoming requests.
 * The service automatically stops the #GSocketService from accepting
 * new connections when all threads are busy.
 *
 * As with #GSocketService, you may connect to #GThreadedSocketService::run,
 * or subclass and override the default handler.
 */


/**
 * SECTION:gtls
 * @title: TLS Overview
 * @short_description: TLS (aka SSL) support for GSocketConnection
 * @include: gio/gio.h
 *
 * #GTlsConnection and related classes provide TLS (Transport Layer
 * Security, previously known as SSL, Secure Sockets Layer) support for
 * gio-based network streams.
 *
 * In the simplest case, for a client connection, you can just set the
 * #GSocketClient:tls flag on a #GSocketClient, and then any
 * connections created by that client will have TLS negotiated
 * automatically, using appropriate default settings, and rejecting
 * any invalid or self-signed certificates (unless you change that
 * default by setting the #GSocketClient:tls-validation-flags
 * property). The returned object will be a #GTcpWrapperConnection,
 * which wraps the underlying #GTlsClientConnection.
 *
 * For greater control, you can create your own #GTlsClientConnection,
 * wrapping a #GSocketConnection (or an arbitrary #GIOStream with
 * pollable input and output streams) and then connect to its signals,
 * such as #GTlsConnection::accept-certificate, before starting the
 * handshake.
 *
 * Server-side TLS is similar, using #GTlsServerConnection. At the
 * moment, there is no support for automatically wrapping server-side
 * connections in the way #GSocketClient does for client-side
 * connections.
 */


/**
 * SECTION:gtlsbackend
 * @title: GTlsBackend
 * @short_description: TLS backend implementation
 * @include: gio/gio.h
 *
 *
 */


/**
 * SECTION:gtlscertificate
 * @title: GTlsCertificate
 * @short_description: TLS certificate
 * @see_also: #GTlsConnection
 *
 * A certificate used for TLS authentication and encryption.
 * This can represent either a public key only (eg, the certificate
 * received by a client from a server), or the combination of
 * a public key and a private key (which is needed when acting as a
 * #GTlsServerConnection).
 *
 * Since: 2.28
 */


/**
 * SECTION:gtlsclientconnection
 * @short_description: TLS client-side connection
 * @include: gio/gio.h
 *
 * #GTlsClientConnection is the client-side subclass of
 * #GTlsConnection, representing a client-side TLS connection.
 */


/**
 * SECTION:gtlsconnection
 * @short_description: TLS connection type
 * @include: gio/gio.h
 *
 * #GTlsConnection is the base TLS connection class type, which wraps
 * a #GIOStream and provides TLS encryption on top of it. Its
 * subclasses, #GTlsClientConnection and #GTlsServerConnection,
 * implement client-side and server-side TLS, respectively.
 *
 * Since: 2.28
 */


/**
 * SECTION:gtlsdatabase
 * @short_description: TLS database type
 * @include: gio/gio.h
 *
 * #GTlsDatabase is used to lookup certificates and other information
 * from a certificate or key store. It is an abstract base class which
 * TLS library specific subtypes override.
 *
 * Most common client applications will not directly interact with
 * #GTlsDatabase. It is used internally by #GTlsConnection.
 *
 * Since: 2.30
 */


/**
 * SECTION:gtlsfiledatabase
 * @short_description: TLS file based database type
 * @include: gio/gio.h
 *
 * #GTlsFileDatabase is implemented by #GTlsDatabase objects which load
 * their certificate information from a file. It is in interface which
 * TLS library specific subtypes implement.
 *
 * Since: 2.30
 */


/**
 * SECTION:gtlsinteraction
 * @short_description: Interaction with the user during TLS operations.
 * @include: gio/gio.h
 *
 * #GTlsInteraction provides a mechanism for the TLS connection and database
 * code to interact with the user. It can be used to ask the user for passwords.
 *
 * To use a #GTlsInteraction with a TLS connection use
 * g_tls_connection_set_interaction().
 *
 * Callers should instantiate a derived class that implements the various
 * interaction methods to show the required dialogs.
 *
 * Callers should use the 'invoke' functions like
 * g_tls_interaction_invoke_ask_password() to run interaction methods. These
 * functions make sure that the interaction is invoked in the main loop
 * and not in the current thread, if the current thread is not running the
 * main loop.
 *
 * Derived classes can choose to implement whichever interactions methods they'd
 * like to support by overriding those virtual methods in their class
 * initialization function. Any interactions not implemented will return
 * %G_TLS_INTERACTION_UNHANDLED. If a derived class implements an async method,
 * it must also implement the corresponding finish method.
 */


/**
 * SECTION:gtlspassword
 * @title: GTlsPassword
 * @short_description: TLS Passwords for prompting
 * @include: gio/gio.h
 *
 * Holds a password used in TLS.
 */


/**
 * SECTION:gtlsserverconnection
 * @short_description: TLS server-side connection
 * @include: gio/gio.h
 *
 * #GTlsServerConnection is the server-side subclass of #GTlsConnection,
 * representing a server-side TLS connection.
 *
 * Since: 2.28
 */


/**
 * SECTION:gunixconnection
 * @title: GUnixConnection
 * @short_description: A UNIX domain GSocketConnection
 * @include: gio/gunixconnection.h
 * @see_also: #GSocketConnection.
 *
 * This is the subclass of #GSocketConnection that is created
 * for UNIX domain sockets.
 *
 * It contains functions to do some of the UNIX socket specific
 * functionality like passing file descriptors.
 *
 * Note that <filename>&lt;gio/gunixconnection.h&gt;</filename> belongs to
 * the UNIX-specific GIO interfaces, thus you have to use the
 * <filename>gio-unix-2.0.pc</filename> pkg-config file when using it.
 *
 * Since: 2.22
 */


/**
 * SECTION:gunixcredentialsmessage
 * @title: GUnixCredentialsMessage
 * @short_description: A GSocketControlMessage containing credentials
 * @include: gio/gunixcredentialsmessage.h
 * @see_also: #GUnixConnection, #GSocketControlMessage
 *
 * This #GSocketControlMessage contains a #GCredentials instance.  It
 * may be sent using g_socket_send_message() and received using
 * g_socket_receive_message() over UNIX sockets (ie: sockets in the
 * %G_SOCKET_FAMILY_UNIX family).
 *
 * For an easier way to send and receive credentials over
 * stream-oriented UNIX sockets, see
 * g_unix_connection_send_credentials() and
 * g_unix_connection_receive_credentials(). To receive credentials of
 * a foreign process connected to a socket, use
 * g_socket_get_credentials().
 */


/**
 * SECTION:gunixfdlist
 * @title: GUnixFDList
 * @short_description: An object containing a set of UNIX file descriptors
 * @include: gio/gunixfdlist.h
 * @see_also: #GUnixFDMessage
 *
 * A #GUnixFDList contains a list of file descriptors.  It owns the file
 * descriptors that it contains, closing them when finalized.
 *
 * It may be wrapped in a #GUnixFDMessage and sent over a #GSocket in
 * the %G_SOCKET_ADDRESS_UNIX family by using g_socket_send_message()
 * and received using g_socket_receive_message().
 *
 * Note that <filename>&lt;gio/gunixfdlist.h&gt;</filename> belongs to
 * the UNIX-specific GIO interfaces, thus you have to use the
 * <filename>gio-unix-2.0.pc</filename> pkg-config file when using it.
 */


/**
 * SECTION:gunixfdmessage
 * @title: GUnixFDMessage
 * @short_description: A GSocketControlMessage containing a GUnixFDList
 * @include: gio/gunixfdmessage.h
 * @see_also: #GUnixConnection, #GUnixFDList, #GSocketControlMessage
 *
 * This #GSocketControlMessage contains a #GUnixFDList.
 * It may be sent using g_socket_send_message() and received using
 * g_socket_receive_message() over UNIX sockets (ie: sockets in the
 * %G_SOCKET_ADDRESS_UNIX family). The file descriptors are copied
 * between processes by the kernel.
 *
 * For an easier way to send and receive file descriptors over
 * stream-oriented UNIX sockets, see g_unix_connection_send_fd() and
 * g_unix_connection_receive_fd().
 *
 * Note that <filename>&lt;gio/gunixfdmessage.h&gt;</filename> belongs to
 * the UNIX-specific GIO interfaces, thus you have to use the
 * <filename>gio-unix-2.0.pc</filename> pkg-config file when using it.
 */


/**
 * SECTION:gunixinputstream
 * @short_description: Streaming input operations for UNIX file descriptors
 * @include: gio/gunixinputstream.h
 * @see_also: #GInputStream
 *
 * #GUnixInputStream implements #GInputStream for reading from a UNIX
 * file descriptor, including asynchronous operations. (If the file
 * descriptor refers to a socket or pipe, this will use poll() to do
 * asynchronous I/O. If it refers to a regular file, it will fall back
 * to doing asynchronous I/O in another thread.)
 *
 * Note that <filename>&lt;gio/gunixinputstream.h&gt;</filename> belongs
 * to the UNIX-specific GIO interfaces, thus you have to use the
 * <filename>gio-unix-2.0.pc</filename> pkg-config file when using it.
 */


/**
 * SECTION:gunixmounts
 * @include: gio/gunixmounts.h
 * @short_description: UNIX mounts
 *
 * Routines for managing mounted UNIX mount points and paths.
 *
 * Note that <filename>&lt;gio/gunixmounts.h&gt;</filename> belongs to the
 * UNIX-specific GIO interfaces, thus you have to use the
 * <filename>gio-unix-2.0.pc</filename> pkg-config file when using it.
 */


/**
 * SECTION:gunixoutputstream
 * @short_description: Streaming output operations for UNIX file descriptors
 * @include: gio/gunixoutputstream.h
 * @see_also: #GOutputStream
 *
 * #GUnixOutputStream implements #GOutputStream for writing to a UNIX
 * file descriptor, including asynchronous operations. (If the file
 * descriptor refers to a socket or pipe, this will use poll() to do
 * asynchronous I/O. If it refers to a regular file, it will fall back
 * to doing asynchronous I/O in another thread.)
 *
 * Note that <filename>&lt;gio/gunixoutputstream.h&gt;</filename> belongs
 * to the UNIX-specific GIO interfaces, thus you have to use the
 * <filename>gio-unix-2.0.pc</filename> pkg-config file when using it.
 */


/**
 * SECTION:gunixsocketaddress
 * @short_description: UNIX GSocketAddress
 * @include: gio/gunixsocketaddress.h
 *
 * Support for UNIX-domain (also known as local) sockets.
 *
 * UNIX domain sockets are generally visible in the filesystem.
 * However, some systems support abstract socket names which are not
 * visible in the filesystem and not affected by the filesystem
 * permissions, visibility, etc. Currently this is only supported
 * under Linux. If you attempt to use abstract sockets on other
 * systems, function calls may return %G_IO_ERROR_NOT_SUPPORTED
 * errors. You can use g_unix_socket_address_abstract_names_supported()
 * to see if abstract names are supported.
 *
 * Note that <filename>&lt;gio/gunixsocketaddress.h&gt;</filename> belongs to
 * the UNIX-specific GIO interfaces, thus you have to use the
 * <filename>gio-unix-2.0.pc</filename> pkg-config file when using it.
 */


/**
 * SECTION:gvfs
 * @short_description: Virtual File System
 * @include: gio/gio.h
 *
 * Entry point for using GIO functionality.
 */


/**
 * SECTION:gvolume
 * @short_description: Volume management
 * @include: gio/gio.h
 *
 * The #GVolume interface represents user-visible objects that can be
 * mounted. Note, when porting from GnomeVFS, #GVolume is the moral
 * equivalent of #GnomeVFSDrive.
 *
 * Mounting a #GVolume instance is an asynchronous operation. For more
 * information about asynchronous operations, see #GAsyncReady and
 * #GSimpleAsyncReady. To mount a #GVolume, first call
 * g_volume_mount() with (at least) the #GVolume instance, optionally
 * a #GMountOperation object and a #GAsyncReadyCallback.
 *
 * Typically, one will only want to pass %NULL for the
 * #GMountOperation if automounting all volumes when a desktop session
 * starts since it's not desirable to put up a lot of dialogs asking
 * for credentials.
 *
 * The callback will be fired when the operation has resolved (either
 * with success or failure), and a #GAsyncReady structure will be
 * passed to the callback.  That callback should then call
 * g_volume_mount_finish() with the #GVolume instance and the
 * #GAsyncReady data to see if the operation was completed
 * successfully.  If an @error is present when g_volume_mount_finish()
 * is called, then it will be filled with any error information.
 *
 * <para id="volume-identifier">
 * It is sometimes necessary to directly access the underlying
 * operating system object behind a volume (e.g. for passing a volume
 * to an application via the commandline). For this purpose, GIO
 * allows to obtain an 'identifier' for the volume. There can be
 * different kinds of identifiers, such as Hal UDIs, filesystem labels,
 * traditional Unix devices (e.g. <filename>/dev/sda2</filename>),
 * uuids. GIO uses predefind strings as names for the different kinds
 * of identifiers: #G_VOLUME_IDENTIFIER_KIND_HAL_UDI,
 * #G_VOLUME_IDENTIFIER_KIND_LABEL, etc. Use g_volume_get_identifier()
 * to obtain an identifier for a volume.
 * </para>
 *
 * Note that #G_VOLUME_IDENTIFIER_KIND_HAL_UDI will only be available
 * when the gvfs hal volume monitor is in use. Other volume monitors
 * will generally be able to provide the #G_VOLUME_IDENTIFIER_KIND_UNIX_DEVICE
 * identifier, which can be used to obtain a hal device by means of
 * libhal_manger_find_device_string_match().
 */


/**
 * SECTION:gvolumemonitor
 * @short_description: Volume Monitor
 * @include: gio/gio.h
 * @see_also: #GFileMonitor
 *
 * #GVolumeMonitor is for listing the user interesting devices and volumes
 * on the computer. In other words, what a file selector or file manager
 * would show in a sidebar.
 *
 * #GVolumeMonitor is not <link
 * linkend="g-main-context-push-thread-default">thread-default-context
 * aware</link>, and so should not be used other than from the main
 * thread, with no thread-default-context active.
 */


/**
 * SECTION:gwin32inputstream
 * @short_description: Streaming input operations for Windows file handles
 * @include: gio/gwin32inputstream.h
 * @see_also: #GInputStream
 *
 * #GWin32InputStream implements #GInputStream for reading from a
 * Windows file handle.
 *
 * Note that <filename>&lt;gio/gwin32inputstream.h&gt;</filename> belongs
 * to the Windows-specific GIO interfaces, thus you have to use the
 * <filename>gio-windows-2.0.pc</filename> pkg-config file when using it.
 */


/**
 * SECTION:gwin32outputstream
 * @short_description: Streaming output operations for Windows file handles
 * @include: gio/gwin32outputstream.h
 * @see_also: #GOutputStream
 *
 * #GWin32OutputStream implements #GOutputStream for writing to a
 * Windows file handle.
 *
 * Note that <filename>&lt;gio/gwin32outputstream.h&gt;</filename> belongs
 * to the Windows-specific GIO interfaces, thus you have to use the
 * <filename>gio-windows-2.0.pc</filename> pkg-config file when using it.
 */


/**
 * SECTION:gzcompressor
 * @short_description: Zlib compressor
 * @include: gio/gio.h
 *
 * #GZlibCompressor is an implementation of #GConverter that
 * compresses data using zlib.
 */


/**
 * SECTION:gzdecompressor
 * @short_description: Zlib decompressor
 * @include: gio/gio.h
 *
 * #GZlibDecompressor is an implementation of #GConverter that
 * decompresses data compressed with zlib.
 */


/**
 * The string info map is an efficient data structure designed to be:
 *
 * 1) Implement <choices> with a list of valid strings
 *
 * 2) Implement <alias> by mapping one string to another
 *
 * 3) Implement enumerated types by mapping strings to integer values
 * (and back).
 *
 * The map is made out of an array of uint32s.  Each entry in the array
 * is an integer value, followed by a specially formatted string value:
 *
 * The string starts with the byte 0xff or 0xfe, followed by the
 * content of the string, followed by a nul byte, followed by
 * additional nul bytes for padding, followed by a 0xff byte.
 *
 * Padding is added so that the entire formatted string takes up a
 * multiple of 4 bytes, and not less than 8 bytes.  The requirement
 * for a string to take up 8 bytes is so that the scanner doesn't lose
 * synch and mistake a string for an integer value.
 *
 * The first byte of the formatted string depends on if the integer is
 * an enum value (0xff) or an alias (0xfe).  If it is an alias then the
 * number refers to the word offset within the info map at which the
 * integer corresponding to the "target" value is stored.
 *
 * For example, consider the case of the string info map representing an
 * enumerated type of 'foo' (value 1) and 'bar' (value 2) and 'baz'
 * (alias for 'bar').  Note that string info maps are always little
 * endian.
 *
 * x01 x00 x00 x00   xff 'f' 'o' 'o'   x00 x00 x00 xff   x02 x00 x00 x00
 * xff 'b' 'a' 'r'   x00 x00 x00 xff   x03 x00 x00 x00   xfe 'b' 'a' 'z'
 * x00 x00 x00 xff
 *
 *
 * The operations that someone may want to perform with the map:
 *
 * - lookup if a string is valid (and not an alias)
 * - lookup the integer value for a enum 'nick'
 * - lookup the integer value for the target of an alias
 * - lookup an alias and convert it to its target string
 * - lookup the enum nick for a given value
 *
 * In order to lookup if a string is valid, it is padded on either side
 * (as described) and scanned for in the array.  For example, you might
 * look for "foo":
 *
 * xff 'f' 'o' 'o'   x00 x00 x00 xff
 *
 * In order to lookup the integer value for a nick, the string is padded
 * on either side and scanned for in the array, as above.  Instead of
 * merely succeeding, we look at the integer value to the left of the
 * match.  This is the enum value.
 *
 * In order to lookup an alias and convert it to its target enum value,
 * the string is padded on either side (as described, with 0xfe) and
 * scanned for.  For example, you might look for "baz":
 *
 * xfe 'b' 'a' 'z'  x00 x00 x00 xff
 *
 * The integer immediately preceding the match then contains the offset
 * of the integer value of the target.  In our example, that's '3'.
 * This index is dereferenced to find the enum value of '2'.
 *
 * To convert the alias to its target string, 5 bytes just need to be
 * added past the start of the integer value to find the start of the
 * string.
 *
 * To lookup the enum nick for a given value, the value is searched for
 * in the array.  To ensure that the value isn't matching the inside of a
 * string, we must check that it is either the first item in the array or
 * immediately preceded by the byte 0xff.  It must also be immediately
 * followed by the byte 0xff.
 *
 * Because strings always take up a minimum of 2 words, because 0xff or
 * 0xfe never appear inside of a utf-8 string and because no two integer
 * values ever appear in sequence, the only way we can have the
 * sequence:
 *
 * xff __ __ __ __ xff (or 0xfe)
 *
 * is in the event of an integer nested between two strings.
 *
 * For implementation simplicity/efficiency, strings may not be more
 * than 65 characters in length (ie: 17 32bit words after padding).
 *
 * In the event that we are doing <choices> (ie: not an enum type) then
 * the value of each choice is set to zero and ignored.
 */


/**
 * _g_io_module_get_default:
 * @extension_point: the name of an extension point
 * @envvar: (allow-none): the name of an environment variable to override the default implementation.
 * @verify_func: (allow-none): a function to call to verify that a given implementation is usable in the current environment.
 *
 * Retrieves the default object implementing @extension_point.
 *
 * If @envvar is not %NULL, and the environment variable with that
 * name is set, then the implementation it specifies will be tried
 * first. After that, or if @envvar is not set, all other
 * implementations will be tried in order of decreasing priority.
 *
 * If an extension point implementation implements #GInitable, then
 * that implementation will only be used if it initializes
 * successfully. Otherwise, if @verify_func is not %NULL, then it will
 * be called on each candidate implementation after construction, to
 * check if it is actually usable or not.
 *
 * The result is cached after it is generated the first time, and
 * the function is thread-safe.
 *
 * @extension_point, or %NULL if there are no usable
 * implementations.
 *
 * Returns: (transfer none): an object implementing
 */


/**
 * g_action_activate:
 * @action: a #GAction
 * @parameter: (allow-none): the parameter to the activation
 *
 * Activates the action.
 *
 * @parameter must be the correct type of parameter for the action (ie:
 * the parameter type given at construction time).  If the parameter
 * type was %NULL then @parameter must also be %NULL.
 *
 * Since: 2.28
 */


/**
 * g_action_change_state:
 * @action: a #GAction
 * @value: the new state
 *
 * Request for the state of @action to be changed to @value.
 *
 * The action must be stateful and @value must be of the correct type.
 * See g_action_get_state_type().
 *
 * This call merely requests a change.  The action may refuse to change
 * its state or may change its state to something other than @value.
 * See g_action_get_state_hint().
 *
 * If the @value GVariant is floating, it is consumed.
 *
 * Since: 2.30
 */


/**
 * g_action_get_enabled:
 * @action: a #GAction
 *
 * Checks if @action is currently enabled.
 *
 * An action must be enabled in order to be activated or in order to
 * have its state changed from outside callers.
 *
 * Returns: whether the action is enabled
 * Since: 2.28
 */


/**
 * g_action_get_name:
 * @action: a #GAction
 *
 * Queries the name of @action.
 *
 * Returns: the name of the action
 * Since: 2.28
 */


/**
 * g_action_get_parameter_type:
 * @action: a #GAction
 *
 * Queries the type of the parameter that must be given when activating
 * @action.
 *
 * When activating the action using g_action_activate(), the #GVariant
 * given to that function must be of the type returned by this function.
 *
 * In the case that this function returns %NULL, you must not give any
 * #GVariant, but %NULL instead.
 *
 * Returns: (allow-none): the parameter type
 * Since: 2.28
 */


/**
 * g_action_get_state:
 * @action: a #GAction
 *
 * Queries the current state of @action.
 *
 * If the action is not stateful then %NULL will be returned.  If the
 * action is stateful then the type of the return value is the type
 * given by g_action_get_state_type().
 *
 * The return value (if non-%NULL) should be freed with
 * g_variant_unref() when it is no longer required.
 *
 * Returns: (transfer full): the current state of the action
 * Since: 2.28
 */


/**
 * g_action_get_state_hint:
 * @action: a #GAction
 *
 * Requests a hint about the valid range of values for the state of
 * @action.
 *
 * If %NULL is returned it either means that the action is not stateful
 * or that there is no hint about the valid range of values for the
 * state of the action.
 *
 * If a #GVariant array is returned then each item in the array is a
 * possible value for the state.  If a #GVariant pair (ie: two-tuple) is
 * returned then the tuple specifies the inclusive lower and upper bound
 * of valid values for the state.
 *
 * In any case, the information is merely a hint.  It may be possible to
 * have a state value outside of the hinted range and setting a value
 * within the range may fail.
 *
 * The return value (if non-%NULL) should be freed with
 * g_variant_unref() when it is no longer required.
 *
 * Returns: (transfer full): the state range hint
 * Since: 2.28
 */


/**
 * g_action_get_state_type:
 * @action: a #GAction
 *
 * Queries the type of the state of @action.
 *
 * If the action is stateful (e.g. created with
 * g_simple_action_new_stateful()) then this function returns the
 * #GVariantType of the state.  This is the type of the initial value
 * given as the state. All calls to g_action_change_state() must give a
 * #GVariant of this type and g_action_get_state() will return a
 * #GVariant of the same type.
 *
 * If the action is not stateful (e.g. created with g_simple_action_new())
 * then this function will return %NULL. In that case, g_action_get_state()
 * will return %NULL and you must not call g_action_change_state().
 *
 * Returns: (allow-none): the state type, if the action is stateful
 * Since: 2.28
 */


/**
 * g_action_group_action_added:
 * @action_group: a #GActionGroup
 * @action_name: the name of an action in the group
 *
 * Emits the #GActionGroup::action-added signal on @action_group.
 *
 * This function should only be called by #GActionGroup implementations.
 *
 * Since: 2.28
 */


/**
 * g_action_group_action_enabled_changed:
 * @action_group: a #GActionGroup
 * @action_name: the name of an action in the group
 * @enabled: whether or not the action is now enabled
 *
 * Emits the #GActionGroup::action-enabled-changed signal on @action_group.
 *
 * This function should only be called by #GActionGroup implementations.
 *
 * Since: 2.28
 */


/**
 * g_action_group_action_removed:
 * @action_group: a #GActionGroup
 * @action_name: the name of an action in the group
 *
 * Emits the #GActionGroup::action-removed signal on @action_group.
 *
 * This function should only be called by #GActionGroup implementations.
 *
 * Since: 2.28
 */


/**
 * g_action_group_action_state_changed:
 * @action_group: a #GActionGroup
 * @action_name: the name of an action in the group
 * @state: the new state of the named action
 *
 * Emits the #GActionGroup::action-state-changed signal on @action_group.
 *
 * This function should only be called by #GActionGroup implementations.
 *
 * Since: 2.28
 */


/**
 * g_action_group_activate_action:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to activate
 * @parameter: (allow-none): parameters to the activation
 *
 * Activate the named action within @action_group.
 *
 * If the action is expecting a parameter, then the correct type of
 * parameter must be given as @parameter.  If the action is expecting no
 * parameters then @parameter must be %NULL.  See
 * g_action_group_get_action_parameter_type().
 *
 * Since: 2.28
 */


/**
 * g_action_group_change_action_state:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to request the change on
 * @value: the new state
 *
 * Request for the state of the named action within @action_group to be
 * changed to @value.
 *
 * The action must be stateful and @value must be of the correct type.
 * See g_action_group_get_action_state_type().
 *
 * This call merely requests a change.  The action may refuse to change
 * its state or may change its state to something other than @value.
 * See g_action_group_get_action_state_hint().
 *
 * If the @value GVariant is floating, it is consumed.
 *
 * Since: 2.28
 */


/**
 * g_action_group_get_action_enabled:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to query
 *
 * Checks if the named action within @action_group is currently enabled.
 *
 * An action must be enabled in order to be activated or in order to
 * have its state changed from outside callers.
 *
 * Returns: whether or not the action is currently enabled
 * Since: 2.28
 */


/**
 * g_action_group_get_action_parameter_type:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to query
 *
 * Queries the type of the parameter that must be given when activating
 * the named action within @action_group.
 *
 * When activating the action using g_action_group_activate_action(),
 * the #GVariant given to that function must be of the type returned
 * by this function.
 *
 * In the case that this function returns %NULL, you must not give any
 * #GVariant, but %NULL instead.
 *
 * The parameter type of a particular action will never change but it is
 * possible for an action to be removed and for a new action to be added
 * with the same name but a different parameter type.
 *
 * Returns: the parameter type
 * Since: 2.28
 */


/**
 * g_action_group_get_action_state:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to query
 *
 * Queries the current state of the named action within @action_group.
 *
 * If the action is not stateful then %NULL will be returned.  If the
 * action is stateful then the type of the return value is the type
 * given by g_action_group_get_action_state_type().
 *
 * The return value (if non-%NULL) should be freed with
 * g_variant_unref() when it is no longer required.
 *
 * Returns: (allow-none): the current state of the action
 * Since: 2.28
 */


/**
 * g_action_group_get_action_state_hint:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to query
 *
 * Requests a hint about the valid range of values for the state of the
 * named action within @action_group.
 *
 * If %NULL is returned it either means that the action is not stateful
 * or that there is no hint about the valid range of values for the
 * state of the action.
 *
 * If a #GVariant array is returned then each item in the array is a
 * possible value for the state.  If a #GVariant pair (ie: two-tuple) is
 * returned then the tuple specifies the inclusive lower and upper bound
 * of valid values for the state.
 *
 * In any case, the information is merely a hint.  It may be possible to
 * have a state value outside of the hinted range and setting a value
 * within the range may fail.
 *
 * The return value (if non-%NULL) should be freed with
 * g_variant_unref() when it is no longer required.
 *
 * Returns: (transfer full): the state range hint
 * Since: 2.28
 */


/**
 * g_action_group_get_action_state_type:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to query
 *
 * Queries the type of the state of the named action within
 * @action_group.
 *
 * If the action is stateful then this function returns the
 * #GVariantType of the state.  All calls to
 * g_action_group_change_action_state() must give a #GVariant of this
 * type and g_action_group_get_action_state() will return a #GVariant
 * of the same type.
 *
 * If the action is not stateful then this function will return %NULL.
 * In that case, g_action_group_get_action_state() will return %NULL
 * and you must not call g_action_group_change_action_state().
 *
 * The state type of a particular action will never change but it is
 * possible for an action to be removed and for a new action to be added
 * with the same name but a different state type.
 *
 * Returns: (transfer full): the state type, if the action is stateful
 * Since: 2.28
 */


/**
 * g_action_group_has_action:
 * @action_group: a #GActionGroup
 * @action_name: the name of the action to check for
 *
 * Checks if the named action exists within @action_group.
 *
 * Returns: whether the named action exists
 * Since: 2.28
 */


/**
 * g_action_group_list_actions:
 * @action_group: a #GActionGroup
 *
 * Lists the actions contained within @action_group.
 *
 * The caller is responsible for freeing the list with g_strfreev() when
 * it is no longer required.
 *
 * actions in the groupb
 *
 * Returns: (transfer full): a %NULL-terminated array of the names of the
 * Since: 2.28
 */


/**
 * g_action_group_query_action:
 * @action_group: a #GActionGroup
 * @action_name: the name of an action in the group
 * @enabled: (out): if the action is presently enabled
 * @parameter_type: (out): the parameter type, or %NULL if none needed
 * @state_type: (out): the state type, or %NULL if stateless
 * @state_hint: (out): the state hint, or %NULL if none
 * @state: (out): the current state, or %NULL if stateless
 *
 * Queries all aspects of the named action within an @action_group.
 *
 * This function acquires the information available from
 * g_action_group_has_action(), g_action_group_get_action_enabled(),
 * g_action_group_get_action_parameter_type(),
 * g_action_group_get_action_state_type(),
 * g_action_group_get_action_state_hint() and
 * g_action_group_get_state() with a single function call.
 *
 * This provides two main benefits.
 *
 * The first is the improvement in efficiency that comes with not having
 * to perform repeated lookups of the action in order to discover
 * different things about it.  The second is that implementing
 * #GActionGroup can now be done by only overriding this one virtual
 * function.
 *
 * The interface provides a default implementation of this function that
 * calls the individual functions, as required, to fetch the
 * information.  The interface also provides default implementations of
 * those functions that call this function.  All implementations,
 * therefore, must override either this function or all of the others.
 *
 * If the action exists, %TRUE is returned and any of the requested
 * fields (as indicated by having a non-%NULL reference passed in) are
 * filled.  If the action doesn't exist, %FALSE is returned and the
 * fields may or may not have been modified.
 *
 * Returns: %TRUE if the action exists, else %FALSE
 * Since: 2.32
 */


/**
 * g_action_map_add_action:
 * @action_map: a #GActionMap
 * @action: a #GAction
 *
 * Adds an action to the @action_map.
 *
 * If the action map already contains an action with the same name
 * as @action then the old action is dropped from the action map.
 *
 * The action map takes its own reference on @action.
 *
 * Since: 2.32
 */


/**
 * g_action_map_add_action_entries:
 * @action_map: a #GActionMap
 * @entries: a pointer to the first item in an array of #GActionEntry structs
 * @n_entries: the length of @entries, or -1 if @entries is %NULL-terminated
 * @user_data: the user data for signal connections
 *
 * A convenience function for creating multiple #GSimpleAction instances
 * and adding them to a #GActionMap.
 *
 * Each action is constructed as per one #GActionEntry.
 *
 * <example>
 * <title>Using g_action_map_add_action_entries()</title>
 * <programlisting>
 * static void
 * activate_quit (GSimpleAction *simple,
 * GVariant      *parameter,
 * gpointer       user_data)
 * {
 * exit (0);
 * }
 *
 * static void
 * activate_print_string (GSimpleAction *simple,
 * GVariant      *parameter,
 * gpointer       user_data)
 * {
 * g_print ("%s\n", g_variant_get_string (parameter, NULL));
 * }
 *
 * static GActionGroup *
 * create_action_group (void)
 * {
 * const GActionEntry entries[] = {
 * { "quit",         activate_quit              },
 * { "print-string", activate_print_string, "s" }
 * };
 * GSimpleActionGroup *group;
 *
 * group = g_simple_action_group_new ();
 * g_action_map_add_action_entries (G_ACTION_MAP (group), entries, G_N_ELEMENTS (entries), NULL);
 *
 * return G_ACTION_GROUP (group);
 * }
 * </programlisting>
 * </example>
 *
 * Since: 2.32
 */


/**
 * g_action_map_lookup_action:
 * @action_map: a #GActionMap
 * @action_name: the name of an action
 *
 * Looks up the action with the name @action_name in @action_map.
 *
 * If no such action exists, returns %NULL.
 *
 * Returns: (transfer none): a #GAction, or %NULL
 * Since: 2.32
 */


/**
 * g_action_map_remove_action:
 * @action_map: a #GActionMap
 * @action_name: the name of the action
 *
 * Removes the named action from the action map.
 *
 * If no action of this name is in the map then nothing happens.
 *
 * Since: 2.32
 */


/**
 * g_alloca:
 * @size: number of bytes to allocate.
 *
 * Allocates @size bytes on the stack; these bytes will be freed when the current
 * stack frame is cleaned up. This macro essentially just wraps the alloca()
 * function present on most UNIX variants.
 * Thus it provides the same advantages and pitfalls as alloca():
 * <variablelist>
 * <varlistentry><term></term><listitem><para>
 * + alloca() is very fast, as on most systems it's implemented by just adjusting
 * the stack pointer register.
 * </para></listitem></varlistentry>
 * <varlistentry><term></term><listitem><para>
 * + It doesn't cause any memory fragmentation, within its scope, separate alloca()
 * blocks just build up and are released together at function end.
 * </para></listitem></varlistentry>
 * <varlistentry><term></term><listitem><para>
 * - Allocation sizes have to fit into the current stack frame. For instance in a
 * threaded environment on Linux, the per-thread stack size is limited to 2 Megabytes,
 * so be sparse with alloca() uses.
 * </para></listitem></varlistentry>
 * <varlistentry><term></term><listitem><para>
 * - Allocation failure due to insufficient stack space is not indicated with a %NULL
 * return like e.g. with malloc(). Instead, most systems probably handle it the same
 * way as out of stack space situations from infinite function recursion, i.e.
 * with a segmentation fault.
 * </para></listitem></varlistentry>
 * <varlistentry><term></term><listitem><para>
 * - Special care has to be taken when mixing alloca() with GNU C variable sized arrays.
 * Stack space allocated with alloca() in the same scope as a variable sized array
 * will be freed together with the variable sized array upon exit of that scope, and
 * not upon exit of the enclosing function scope.
 * </para></listitem></varlistentry>
 * </variablelist>
 *
 * Returns: space for @size bytes, allocated on the stack
 */


/**
 * g_app_info_add_supports_type:
 * @appinfo: a #GAppInfo.
 * @content_type: a string.
 * @error: a #GError.
 *
 * Adds a content type to the application information to indicate the
 * application is capable of opening files with the given content type.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_can_delete:
 * @appinfo: a #GAppInfo
 *
 * Obtains the information whether the #GAppInfo can be deleted.
 * See g_app_info_delete().
 *
 * Returns: %TRUE if @appinfo can be deleted
 * Since: 2.20
 */


/**
 * g_app_info_can_remove_supports_type:
 * @appinfo: a #GAppInfo.
 *
 * Checks if a supported content type can be removed from an application.
 *
 * content types from a given @appinfo, %FALSE if not.
 *
 * Returns: %TRUE if it is possible to remove supported
 */


/**
 * g_app_info_create_from_commandline:
 * @commandline: the commandline to use
 * @application_name: (allow-none): the application name, or %NULL to use @commandline
 * @flags: flags that can specify details of the created #GAppInfo
 * @error: a #GError location to store the error occurring, %NULL to ignore.
 *
 * Creates a new #GAppInfo from the given information.
 *
 * Returns: (transfer full): new #GAppInfo for given command.
 */


/**
 * g_app_info_delete:
 * @appinfo: a #GAppInfo
 *
 * Tries to delete a #GAppInfo.
 *
 * On some platforms, there may be a difference between user-defined
 * #GAppInfo<!-- -->s which can be deleted, and system-wide ones which
 * cannot. See g_app_info_can_delete().
 *
 * Virtual: do_delete
 * Returns: %TRUE if @appinfo has been deleted
 * Since: 2.20
 */


/**
 * g_app_info_dup:
 * @appinfo: a #GAppInfo.
 *
 * Creates a duplicate of a #GAppInfo.
 *
 * Returns: (transfer full): a duplicate of @appinfo.
 */


/**
 * g_app_info_equal:
 * @appinfo1: the first #GAppInfo.
 * @appinfo2: the second #GAppInfo.
 *
 * Checks if two #GAppInfo<!-- -->s are equal.
 *
 * Returns: %TRUE if @appinfo1 is equal to @appinfo2. %FALSE otherwise.
 */


/**
 * g_app_info_get_all:
 *
 * Gets a list of all of the applications currently registered
 * on this system.
 *
 * For desktop files, this includes applications that have
 * <literal>NoDisplay=true</literal> set or are excluded from
 * display by means of <literal>OnlyShowIn</literal> or
 * <literal>NotShowIn</literal>. See g_app_info_should_show().
 * The returned list does not include applications which have
 * the <literal>Hidden</literal> key set.
 *
 * Returns: (element-type GAppInfo) (transfer full): a newly allocated #GList of references to #GAppInfo<!---->s.
 */


/**
 * g_app_info_get_all_for_type:
 * @content_type: the content type to find a #GAppInfo for
 *
 * Gets a list of all #GAppInfos for a given content type,
 * including the recommended and fallback #GAppInfos. See
 * g_app_info_get_recommended_for_type() and
 * g_app_info_get_fallback_for_type().
 *
 * for given @content_type or %NULL on error.
 *
 * Returns: (element-type GAppInfo) (transfer full): #GList of #GAppInfos
 */


/**
 * g_app_info_get_commandline:
 * @appinfo: a #GAppInfo
 *
 * Gets the commandline with which the application will be
 * started.
 *
 * or %NULL if this information is not available
 *
 * Returns: a string containing the @appinfo's commandline,
 * Since: 2.20
 */


/**
 * g_app_info_get_default_for_type:
 * @content_type: the content type to find a #GAppInfo for
 * @must_support_uris: if %TRUE, the #GAppInfo is expected to support URIs
 *
 * Gets the default #GAppInfo for a given content type.
 *
 * %NULL on error.
 *
 * Returns: (transfer full): #GAppInfo for given @content_type or
 */


/**
 * g_app_info_get_default_for_uri_scheme:
 * @uri_scheme: a string containing a URI scheme.
 *
 * Gets the default application for handling URIs with
 * the given URI scheme. A URI scheme is the initial part
 * of the URI, up to but not including the ':', e.g. "http",
 * "ftp" or "sip".
 *
 * Returns: (transfer full): #GAppInfo for given @uri_scheme or %NULL on error.
 */


/**
 * g_app_info_get_description:
 * @appinfo: a #GAppInfo.
 *
 * Gets a human-readable description of an installed application.
 *
 * application @appinfo, or %NULL if none.
 *
 * Returns: a string containing a description of the
 */


/**
 * g_app_info_get_display_name:
 * @appinfo: a #GAppInfo.
 *
 * Gets the display name of the application. The display name is often more
 * descriptive to the user than the name itself.
 *
 * no display name is available.
 *
 * Returns: the display name of the application for @appinfo, or the name if
 * Since: 2.24
 */


/**
 * g_app_info_get_executable:
 * @appinfo: a #GAppInfo
 *
 * Gets the executable's name for the installed application.
 *
 * binaries name
 *
 * Returns: a string containing the @appinfo's application
 */


/**
 * g_app_info_get_fallback_for_type:
 * @content_type: the content type to find a #GAppInfo for
 *
 * Gets a list of fallback #GAppInfos for a given content type, i.e.
 * those applications which claim to support the given content type
 * by MIME type subclassing and not directly.
 *
 * for given @content_type or %NULL on error.
 *
 * Returns: (element-type GAppInfo) (transfer full): #GList of #GAppInfos
 * Since: 2.28
 */


/**
 * g_app_info_get_icon:
 * @appinfo: a #GAppInfo.
 *
 * Gets the icon for the application.
 *
 * if there is no default icon.
 *
 * Returns: (transfer none): the default #GIcon for @appinfo or %NULL
 */


/**
 * g_app_info_get_id:
 * @appinfo: a #GAppInfo.
 *
 * Gets the ID of an application. An id is a string that
 * identifies the application. The exact format of the id is
 * platform dependent. For instance, on Unix this is the
 * desktop file id from the xdg menu specification.
 *
 * Note that the returned ID may be %NULL, depending on how
 * the @appinfo has been constructed.
 *
 * Returns: a string containing the application's ID.
 */


/**
 * g_app_info_get_name:
 * @appinfo: a #GAppInfo.
 *
 * Gets the installed name of the application.
 *
 * Returns: the name of the application for @appinfo.
 */


/**
 * g_app_info_get_recommended_for_type:
 * @content_type: the content type to find a #GAppInfo for
 *
 * Gets a list of recommended #GAppInfos for a given content type, i.e.
 * those applications which claim to support the given content type exactly,
 * and not by MIME type subclassing.
 * Note that the first application of the list is the last used one, i.e.
 * the last one for which g_app_info_set_as_last_used_for_type() has been
 * called.
 *
 * for given @content_type or %NULL on error.
 *
 * Returns: (element-type GAppInfo) (transfer full): #GList of #GAppInfos
 * Since: 2.28
 */


/**
 * g_app_info_launch:
 * @appinfo: a #GAppInfo
 * @files: (element-type GFile): a #GList of #GFile objects
 * @launch_context: (allow-none): a #GAppLaunchContext or %NULL
 * @error: a #GError
 *
 * Launches the application. Passes @files to the launched application
 * as arguments, using the optional @launch_context to get information
 * about the details of the launcher (like what screen it is on).
 * On error, @error will be set accordingly.
 *
 * To launch the application without arguments pass a %NULL @files list.
 *
 * Note that even if the launch is successful the application launched
 * can fail to start if it runs into problems during startup. There is
 * no way to detect this.
 *
 * Some URIs can be changed when passed through a GFile (for instance
 * unsupported URIs with strange formats like mailto:), so if you have
 * a textual URI you want to pass in as argument, consider using
 * g_app_info_launch_uris() instead.
 *
 * The launched application inherits the environment of the launching
 * process, but it can be modified with g_app_launch_context_setenv() and
 * g_app_launch_context_unsetenv().
 *
 * On UNIX, this function sets the <envar>GIO_LAUNCHED_DESKTOP_FILE</envar>
 * environment variable with the path of the launched desktop file and
 * <envar>GIO_LAUNCHED_DESKTOP_FILE_PID</envar> to the process
 * id of the launched process. This can be used to ignore
 * <envar>GIO_LAUNCHED_DESKTOP_FILE</envar>, should it be inherited
 * by further processes. The <envar>DISPLAY</envar> and
 * <envar>DESKTOP_STARTUP_ID</envar> environment variables are also
 * set, based on information provided in @launch_context.
 *
 * Returns: %TRUE on successful launch, %FALSE otherwise.
 */


/**
 * g_app_info_launch_default_for_uri:
 * @uri: the uri to show
 * @launch_context: (allow-none): an optional #GAppLaunchContext.
 * @error: a #GError.
 *
 * Utility function that launches the default application
 * registered to handle the specified uri. Synchronous I/O
 * is done on the uri to detect the type of the file if
 * required.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_launch_uris:
 * @appinfo: a #GAppInfo
 * @uris: (element-type utf8): a #GList containing URIs to launch.
 * @launch_context: (allow-none): a #GAppLaunchContext or %NULL
 * @error: a #GError
 *
 * Launches the application. This passes the @uris to the launched application
 * as arguments, using the optional @launch_context to get information
 * about the details of the launcher (like what screen it is on).
 * On error, @error will be set accordingly.
 *
 * To launch the application without arguments pass a %NULL @uris list.
 *
 * Note that even if the launch is successful the application launched
 * can fail to start if it runs into problems during startup. There is
 * no way to detect this.
 *
 * Returns: %TRUE on successful launch, %FALSE otherwise.
 */


/**
 * g_app_info_remove_supports_type:
 * @appinfo: a #GAppInfo.
 * @content_type: a string.
 * @error: a #GError.
 *
 * Removes a supported type from an application, if possible.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_reset_type_associations:
 * @content_type: a content type
 *
 * Removes all changes to the type associations done by
 * g_app_info_set_as_default_for_type(),
 * g_app_info_set_as_default_for_extension(),
 * g_app_info_add_supports_type() or
 * g_app_info_remove_supports_type().
 *
 * Since: 2.20
 */


/**
 * g_app_info_set_as_default_for_extension:
 * @appinfo: a #GAppInfo.
 * @extension: a string containing the file extension (without the dot).
 * @error: a #GError.
 *
 * Sets the application as the default handler for the given file extension.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_set_as_default_for_type:
 * @appinfo: a #GAppInfo.
 * @content_type: the content type.
 * @error: a #GError.
 *
 * Sets the application as the default handler for a given type.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_set_as_last_used_for_type:
 * @appinfo: a #GAppInfo.
 * @content_type: the content type.
 * @error: a #GError.
 *
 * Sets the application as the last used application for a given type.
 * This will make the application appear as first in the list returned
 * by g_app_info_get_recommended_for_type(), regardless of the default
 * application for that content type.
 *
 * Returns: %TRUE on success, %FALSE on error.
 */


/**
 * g_app_info_should_show:
 * @appinfo: a #GAppInfo.
 *
 * Checks if the application info should be shown in menus that
 * list available applications.
 *
 * Returns: %TRUE if the @appinfo should be shown, %FALSE otherwise.
 */


/**
 * g_app_info_supports_files:
 * @appinfo: a #GAppInfo.
 *
 * Checks if the application accepts files as arguments.
 *
 * Returns: %TRUE if the @appinfo supports files.
 */


/**
 * g_app_info_supports_uris:
 * @appinfo: a #GAppInfo.
 *
 * Checks if the application supports reading files and directories from URIs.
 *
 * Returns: %TRUE if the @appinfo supports URIs.
 */


/**
 * g_app_launch_context_get_display:
 * @context: a #GAppLaunchContext
 * @info: a #GAppInfo
 * @files: (element-type GFile): a #GList of #GFile objects
 *
 * Gets the display string for the @context. This is used to ensure new
 * applications are started on the same display as the launching
 * application, by setting the <envar>DISPLAY</envar> environment variable.
 *
 * Returns: a display string for the display.
 */


/**
 * g_app_launch_context_get_environment:
 * @context: a #GAppLaunchContext
 *
 * Gets the complete environment variable list to be passed to
 * the child process when @context is used to launch an application.
 * This is a %NULL-terminated array of strings, where each string has
 * the form <literal>KEY=VALUE</literal>.
 *
 * child's environment
 *
 * Returns: (array zero-terminated=1) (transfer full): the
 * Since: 2.32
 */


/**
 * g_app_launch_context_get_startup_notify_id:
 * @context: a #GAppLaunchContext
 * @info: a #GAppInfo
 * @files: (element-type GFile): a #GList of of #GFile objects
 *
 * Initiates startup notification for the application and returns the
 * <envar>DESKTOP_STARTUP_ID</envar> for the launched operation,
 * if supported.
 *
 * Startup notification IDs are defined in the <ulink
 * url="http://standards.freedesktop.org/startup-notification-spec/startup-notification-latest.txt">
 * FreeDesktop.Org Startup Notifications standard</ulink>.
 *
 * not supported.
 *
 * Returns: a startup notification ID for the application, or %NULL if
 */


/**
 * g_app_launch_context_launch_failed:
 * @context: a #GAppLaunchContext.
 * @startup_notify_id: the startup notification id that was returned by g_app_launch_context_get_startup_notify_id().
 *
 * Called when an application has failed to launch, so that it can cancel
 * the application startup notification started in g_app_launch_context_get_startup_notify_id().
 */


/**
 * g_app_launch_context_new:
 *
 * Creates a new application launch context. This is not normally used,
 * instead you instantiate a subclass of this, such as #GdkAppLaunchContext.
 *
 * Returns: a #GAppLaunchContext.
 */


/**
 * g_app_launch_context_setenv:
 * @context: a #GAppLaunchContext
 * @variable: the environment variable to set
 * @value: the value for to set the variable to.
 *
 * Arranges for @variable to be set to @value in the child's
 * environment when @context is used to launch an application.
 *
 * Since: 2.32
 */


/**
 * g_app_launch_context_unsetenv:
 * @context: a #GAppLaunchContext
 * @variable: the environment variable to remove
 *
 * Arranges for @variable to be unset in the child's environment
 * when @context is used to launch an application.
 *
 * Since: 2.32
 */


/**
 * g_application_activate:
 * @application: a #GApplication
 *
 * Activates the application.
 *
 * In essence, this results in the #GApplication::activate() signal being
 * emitted in the primary instance.
 *
 * The application must be registered before calling this function.
 *
 * Since: 2.28
 */


/**
 * g_application_command_line_get_arguments:
 * @cmdline: a #GApplicationCommandLine
 * @argc: (out): the length of the arguments array, or %NULL
 *
 * Gets the list of arguments that was passed on the command line.
 *
 * The strings in the array may contain non-utf8 data.
 *
 * The return value is %NULL-terminated and should be freed using
 * g_strfreev().
 *
 * containing the arguments (the argv)
 *
 * Returns: (array length=argc) (transfer full): the string array
 * Since: 2.28
 */


/**
 * g_application_command_line_get_cwd:
 * @cmdline: a #GApplicationCommandLine
 *
 * Gets the working directory of the command line invocation.
 * The string may contain non-utf8 data.
 *
 * It is possible that the remote application did not send a working
 * directory, so this may be %NULL.
 *
 * The return value should not be modified or freed and is valid for as
 * long as @cmdline exists.
 *
 * Returns: the current directory, or %NULL
 * Since: 2.28
 */


/**
 * g_application_command_line_get_environ:
 * @cmdline: a #GApplicationCommandLine
 *
 * Gets the contents of the 'environ' variable of the command line
 * invocation, as would be returned by g_get_environ(), ie as a
 * %NULL-terminated list of strings in the form 'NAME=VALUE'.
 * The strings may contain non-utf8 data.
 *
 * The remote application usually does not send an environment.  Use
 * %G_APPLICATION_SEND_ENVIRONMENT to affect that.  Even with this flag
 * set it is possible that the environment is still not available (due
 * to invocation messages from other applications).
 *
 * The return value should not be modified or freed and is valid for as
 * long as @cmdline exists.
 *
 * See g_application_command_line_getenv() if you are only interested
 * in the value of a single environment variable.
 *
 * strings, or %NULL if they were not sent
 *
 * Returns: (array zero-terminated=1) (transfer none): the environment
 * Since: 2.28
 */


/**
 * g_application_command_line_get_exit_status:
 * @cmdline: a #GApplicationCommandLine
 *
 * Gets the exit status of @cmdline.  See
 * g_application_command_line_set_exit_status() for more information.
 *
 * Returns: the exit status
 * Since: 2.28
 */


/**
 * g_application_command_line_get_is_remote:
 * @cmdline: a #GApplicationCommandLine
 *
 * Determines if @cmdline represents a remote invocation.
 *
 * Returns: %TRUE if the invocation was remote
 * Since: 2.28
 */


/**
 * g_application_command_line_get_platform_data:
 * @cmdline: #GApplicationCommandLine
 *
 * Gets the platform data associated with the invocation of @cmdline.
 *
 * This is a #GVariant dictionary containing information about the
 * context in which the invocation occurred.  It typically contains
 * information like the current working directory and the startup
 * notification ID.
 *
 * For local invocation, it will be %NULL.
 *
 * Returns: the platform data, or %NULL
 * Since: 2.28
 */


/**
 * g_application_command_line_getenv:
 * @cmdline: a #GApplicationCommandLine
 * @name: the environment variable to get
 *
 * Gets the value of a particular environment variable of the command
 * line invocation, as would be returned by g_getenv().  The strings may
 * contain non-utf8 data.
 *
 * The remote application usually does not send an environment.  Use
 * %G_APPLICATION_SEND_ENVIRONMENT to affect that.  Even with this flag
 * set it is possible that the environment is still not available (due
 * to invocation messages from other applications).
 *
 * The return value should not be modified or freed and is valid for as
 * long as @cmdline exists.
 *
 * Returns: the value of the variable, or %NULL if unset or unsent
 * Since: 2.28
 */


/**
 * g_application_command_line_print:
 * @cmdline: a #GApplicationCommandLine
 * @format: a printf-style format string
 * @...: arguments, as per @format
 *
 * Formats a message and prints it using the stdout print handler in the
 * invoking process.
 *
 * If @cmdline is a local invocation then this is exactly equivalent to
 * g_print().  If @cmdline is remote then this is equivalent to calling
 * g_print() in the invoking process.
 *
 * Since: 2.28
 */


/**
 * g_application_command_line_printerr:
 * @cmdline: a #GApplicationCommandLine
 * @format: a printf-style format string
 * @...: arguments, as per @format
 *
 * Formats a message and prints it using the stderr print handler in the
 * invoking process.
 *
 * If @cmdline is a local invocation then this is exactly equivalent to
 * g_printerr().  If @cmdline is remote then this is equivalent to
 * calling g_printerr() in the invoking process.
 *
 * Since: 2.28
 */


/**
 * g_application_command_line_set_exit_status:
 * @cmdline: a #GApplicationCommandLine
 * @exit_status: the exit status
 *
 * Sets the exit status that will be used when the invoking process
 * exits.
 *
 * The return value of the #GApplication::command-line signal is
 * passed to this function when the handler returns.  This is the usual
 * way of setting the exit status.
 *
 * In the event that you want the remote invocation to continue running
 * and want to decide on the exit status in the future, you can use this
 * call.  For the case of a remote invocation, the remote process will
 * typically exit when the last reference is dropped on @cmdline.  The
 * exit status of the remote process will be equal to the last value
 * that was set with this function.
 *
 * In the case that the commandline invocation is local, the situation
 * is slightly more complicated.  If the commandline invocation results
 * in the mainloop running (ie: because the use-count of the application
 * increased to a non-zero value) then the application is considered to
 * have been 'successful' in a certain sense, and the exit status is
 * always zero.  If the application use count is zero, though, the exit
 * status of the local #GApplicationCommandLine is used.
 *
 * Since: 2.28
 */


/**
 * g_application_get_application_id:
 * @application: a #GApplication
 *
 * Gets the unique identifier for @application.
 *
 * Returns: the identifier for @application, owned by @application
 * Since: 2.28
 */


/**
 * g_application_get_default:
 * @returns: (transfer none): the default application for this process, or %NULL
 *
 * Returns the default #GApplication instance for this process.
 *
 * Normally there is only one #GApplication per process and it becomes
 * the default when it is created.  You can exercise more control over
 * this by using g_application_set_default().
 *
 * If there is no default application then %NULL is returned.
 *
 * Since: 2.32
 */


/**
 * g_application_get_flags:
 * @application: a #GApplication
 *
 * Gets the flags for @application.
 *
 * See #GApplicationFlags.
 *
 * Returns: the flags for @application
 * Since: 2.28
 */


/**
 * g_application_get_inactivity_timeout:
 * @application: a #GApplication
 *
 * Gets the current inactivity timeout for the application.
 *
 * This is the amount of time (in milliseconds) after the last call to
 * g_application_release() before the application stops running.
 *
 * Returns: the timeout, in milliseconds
 * Since: 2.28
 */


/**
 * g_application_get_is_registered:
 * @application: a #GApplication
 *
 * Checks if @application is registered.
 *
 * An application is registered if g_application_register() has been
 * successfully called.
 *
 * Returns: %TRUE if @application is registered
 * Since: 2.28
 */


/**
 * g_application_get_is_remote:
 * @application: a #GApplication
 *
 * Checks if @application is remote.
 *
 * If @application is remote then it means that another instance of
 * application already exists (the 'primary' instance).  Calls to
 * perform actions on @application will result in the actions being
 * performed by the primary instance.
 *
 * The value of this property cannot be accessed before
 * g_application_register() has been called.  See
 * g_application_get_is_registered().
 *
 * Returns: %TRUE if @application is remote
 * Since: 2.28
 */


/**
 * g_application_hold:
 * @application: a #GApplication
 *
 * Increases the use count of @application.
 *
 * Use this function to indicate that the application has a reason to
 * continue to run.  For example, g_application_hold() is called by GTK+
 * when a toplevel window is on the screen.
 *
 * To cancel the hold, call g_application_release().
 */


/**
 * g_application_id_is_valid:
 * @application_id: a potential application identifier
 *
 * Checks if @application_id is a valid application identifier.
 *
 * A valid ID is required for calls to g_application_new() and
 * g_application_set_application_id().
 *
 * For convenience, the restrictions on application identifiers are
 * reproduced here:
 * <itemizedlist>
 * <listitem>Application identifiers must contain only the ASCII characters "[A-Z][a-z][0-9]_-." and must not begin with a digit.</listitem>
 * <listitem>Application identifiers must contain at least one '.' (period) character (and thus at least three elements).</listitem>
 * <listitem>Application identifiers must not begin or end with a '.' (period) character.</listitem>
 * <listitem>Application identifiers must not contain consecutive '.' (period) characters.</listitem>
 * <listitem>Application identifiers must not exceed 255 characters.</listitem>
 * </itemizedlist>
 *
 * Returns: %TRUE if @application_id is valid
 */


/**
 * g_application_new:
 * @application_id: the application id
 * @flags: the application flags
 *
 * Creates a new #GApplication instance.
 *
 * This function calls g_type_init() for you.
 *
 * The application id must be valid.  See g_application_id_is_valid().
 *
 * Returns: a new #GApplication instance
 */


/**
 * g_application_open:
 * @application: a #GApplication
 * @files: (array length=n_files): an array of #GFiles to open
 * @n_files: the length of the @files array
 * @hint: a hint (or ""), but never %NULL
 *
 * Opens the given files.
 *
 * In essence, this results in the #GApplication::open signal being emitted
 * in the primary instance.
 *
 * @n_files must be greater than zero.
 *
 * @hint is simply passed through to the ::open signal.  It is
 * intended to be used by applications that have multiple modes for
 * opening files (eg: "view" vs "edit", etc).  Unless you have a need
 * for this functionality, you should use "".
 *
 * The application must be registered before calling this function
 * and it must have the %G_APPLICATION_HANDLES_OPEN flag set.
 *
 * Since: 2.28
 */


/**
 * g_application_register:
 * @application: a #GApplication
 * @cancellable: a #GCancellable, or %NULL
 * @error: a pointer to a NULL #GError, or %NULL
 *
 * Attempts registration of the application.
 *
 * This is the point at which the application discovers if it is the
 * primary instance or merely acting as a remote for an already-existing
 * primary instance.  This is implemented by attempting to acquire the
 * application identifier as a unique bus name on the session bus using
 * GDBus.
 *
 * Due to the internal architecture of GDBus, method calls can be
 * dispatched at any time (even if a main loop is not running).  For
 * this reason, you must ensure that any object paths that you wish to
 * register are registered before calling this function.
 *
 * If the application has already been registered then %TRUE is
 * returned with no work performed.
 *
 * The #GApplication::startup signal is emitted if registration succeeds
 * and @application is the primary instance.
 *
 * In the event of an error (such as @cancellable being cancelled, or a
 * failure to connect to the session bus), %FALSE is returned and @error
 * is set appropriately.
 *
 * Note: the return value of this function is not an indicator that this
 * instance is or is not the primary instance of the application.  See
 * g_application_get_is_remote() for that.
 *
 * Returns: %TRUE if registration succeeded
 * Since: 2.28
 */


/**
 * g_application_release:
 * @application: a #GApplication
 *
 * Decrease the use count of @application.
 *
 * When the use count reaches zero, the application will stop running.
 *
 * Never call this function except to cancel the effect of a previous
 * call to g_application_hold().
 */


/**
 * g_application_run:
 * @application: a #GApplication
 * @argc: the argc from main() (or 0 if @argv is %NULL)
 * @argv: (array length=argc) (allow-none): the argv from main(), or %NULL
 *
 * Runs the application.
 *
 * This function is intended to be run from main() and its return value
 * is intended to be returned by main(). Although you are expected to pass
 * the @argc, @argv parameters from main() to this function, it is possible
 * to pass %NULL if @argv is not available or commandline handling is not
 * required.
 *
 * First, the local_command_line() virtual function is invoked.
 * This function always runs on the local instance. It gets passed a pointer
 * to a %NULL-terminated copy of @argv and is expected to remove the arguments
 * that it handled (shifting up remaining arguments). See
 * <xref linkend="gapplication-example-cmdline2"/> for an example of
 * parsing @argv manually. Alternatively, you may use the #GOptionContext API,
 * after setting <literal>argc = g_strv_length (argv);</literal>.
 *
 * The last argument to local_command_line() is a pointer to the @status
 * variable which can used to set the exit status that is returned from
 * g_application_run().
 *
 * If local_command_line() returns %TRUE, the command line is expected
 * to be completely handled, including possibly registering as the primary
 * instance, calling g_application_activate() or g_application_open(), etc.
 *
 * If local_command_line() returns %FALSE then the application is registered
 * and the #GApplication::command-line signal is emitted in the primary
 * instance (which may or may not be this instance). The signal handler
 * gets passed a #GApplicationCommandline object that (among other things)
 * contains the remaining commandline arguments that have not been handled
 * by local_command_line().
 *
 * If the application has the %G_APPLICATION_HANDLES_COMMAND_LINE
 * flag set then the default implementation of local_command_line()
 * always returns %FALSE immediately, resulting in the commandline
 * always being handled in the primary instance.
 *
 * Otherwise, the default implementation of local_command_line() tries
 * to do a couple of things that are probably reasonable for most
 * applications.  First, g_application_register() is called to attempt
 * to register the application.  If that works, then the command line
 * arguments are inspected.  If no commandline arguments are given, then
 * g_application_activate() is called.  If commandline arguments are
 * given and the %G_APPLICATION_HANDLES_OPEN flag is set then they
 * are assumed to be filenames and g_application_open() is called.
 *
 * If you need to handle commandline arguments that are not filenames,
 * and you don't mind commandline handling to happen in the primary
 * instance, you should set %G_APPLICATION_HANDLED_COMMAND_LINE and
 * process the commandline arguments in your #GApplication::command-line
 * signal handler, either manually or using the #GOptionContext API.
 *
 * If you are interested in doing more complicated local handling of the
 * commandline then you should implement your own #GApplication subclass
 * and override local_command_line(). In this case, you most likely want
 * to return %TRUE from your local_command_line() implementation to
 * suppress the default handling. See
 * <xref linkend="gapplication-example-cmdline2"/> for an example.
 *
 * If, after the above is done, the use count of the application is zero
 * then the exit status is returned immediately.  If the use count is
 * non-zero then the default main context is iterated until the use count
 * falls to zero, at which point 0 is returned.
 *
 * If the %G_APPLICATION_IS_SERVICE flag is set, then the exiting at
 * use count of zero is delayed for a while (ie: the instance stays
 * around to provide its <emphasis>service</emphasis> to others).
 *
 * Returns: the exit status
 * Since: 2.28
 */


/**
 * g_application_set_action_group:
 * @application: a #GApplication
 * @action_group: (allow-none): a #GActionGroup, or %NULL
 *
 * This used to be how actions were associated with a #GApplication.
 * Now there is #GActionMap for that.
 *
 *
 * Deprecated:2.32:Use the #GActionMap interface instead.  Never ever
 * mix use of this API with use of #GActionMap on the same @application
 * or things will go very badly wrong.  This function is known to
 * introduce buggy behaviour (ie: signals not emitted on changes to the
 * action group), so you should really use #GActionMap instead.
 *
 * Since: 2.28
 */


/**
 * g_application_set_application_id:
 * @application: a #GApplication
 * @application_id: the identifier for @application
 *
 * Sets the unique identifier for @application.
 *
 * The application id can only be modified if @application has not yet
 * been registered.
 *
 * The application id must be valid.  See g_application_id_is_valid().
 *
 * Since: 2.28
 */


/**
 * g_application_set_default:
 * @application: the application to set as default, or %NULL
 *
 * Sets or unsets the default application for the process, as returned
 * by g_application_get_default().
 *
 * This function does not take its own reference on @application.  If
 * @application is destroyed then the default application will revert
 * back to %NULL.
 *
 * Since: 2.32
 */


/**
 * g_application_set_flags:
 * @application: a #GApplication
 * @flags: the flags for @application
 *
 * Sets the flags for @application.
 *
 * The flags can only be modified if @application has not yet been
 * registered.
 *
 * See #GApplicationFlags.
 *
 * Since: 2.28
 */


/**
 * g_application_set_inactivity_timeout:
 * @application: a #GApplication
 * @inactivity_timeout: the timeout, in milliseconds
 *
 * Sets the current inactivity timeout for the application.
 *
 * This is the amount of time (in milliseconds) after the last call to
 * g_application_release() before the application stops running.
 *
 * This call has no side effects of its own.  The value set here is only
 * used for next time g_application_release() drops the use count to
 * zero.  Any timeouts currently in progress are not impacted.
 *
 * Since: 2.28
 */


/**
 * g_async_initable_init_async:
 * @initable: a #GAsyncInitable.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the operation.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Starts asynchronous initialization of the object implementing the
 * interface. This must be done before any real use of the object after
 * initial construction. If the object also implements #GInitable you can
 * optionally call g_initable_init() instead.
 *
 * When the initialization is finished, @callback will be called. You can
 * then call g_async_initable_init_finish() to get the result of the
 * initialization.
 *
 * Implementations may also support cancellation. If @cancellable is not
 * %NULL, then initialization can be cancelled by triggering the cancellable
 * object from another thread. If the operation was cancelled, the error
 * %G_IO_ERROR_CANCELLED will be returned. If @cancellable is not %NULL, and
 * the object doesn't support cancellable initialization, the error
 * %G_IO_ERROR_NOT_SUPPORTED will be returned.
 *
 * As with #GInitable, if the object is not initialized, or initialization
 * returns with an error, then all operations on the object except
 * g_object_ref() and g_object_unref() are considered to be invalid, and
 * have undefined behaviour. They will often fail with g_critical() or
 * g_warning(), but this must not be relied on.
 *
 * Implementations of this method must be idempotent: i.e. multiple calls
 * to this function with the same argument should return the same results.
 * Only the first call initializes the object; further calls return the result
 * of the first call. This is so that it's safe to implement the singleton
 * pattern in the GObject constructor function.
 *
 * For classes that also support the #GInitable interface, the default
 * implementation of this method will run the g_initable_init() function
 * in a thread, so if you want to support asynchronous initialization via
 * threads, just implement the #GAsyncInitable interface without overriding
 * any interface methods.
 *
 * Since: 2.22
 */


/**
 * g_async_initable_init_finish:
 * @initable: a #GAsyncInitable.
 * @res: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes asynchronous initialization and returns the result.
 * See g_async_initable_init_async().
 *
 * will return %FALSE and set @error appropriately if present.
 *
 * Returns: %TRUE if successful. If an error has occurred, this function
 * Since: 2.22
 */


/**
 * g_async_initable_new_async:
 * @object_type: a #GType supporting #GAsyncInitable.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the operation.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the initialization is finished
 * @user_data: the data to pass to callback function
 * @first_property_name: the name of the first property, or %NULL if no properties
 * @...: the value of the first property, followed by other property value pairs, and ended by %NULL.
 *
 * Helper function for constructing #GAsyncInitable object. This is
 * similar to g_object_new() but also initializes the object asynchronously.
 *
 * When the initialization is finished, @callback will be called. You can
 * then call g_async_initable_new_finish() to get the new object and check
 * for any errors.
 *
 * Since: 2.22
 */


/**
 * g_async_initable_new_finish:
 * @initable: the #GAsyncInitable from the callback
 * @res: the #GAsyncResult from the callback
 * @error: return location for errors, or %NULL to ignore
 *
 * Finishes the async construction for the various g_async_initable_new
 * calls, returning the created object or %NULL on error.
 *
 * Free with g_object_unref().
 *
 * Returns: (transfer full): a newly created #GObject, or %NULL on error.
 * Since: 2.22
 */


/**
 * g_async_initable_new_valist_async:
 * @object_type: a #GType supporting #GAsyncInitable.
 * @first_property_name: the name of the first property, followed by the value, and other property value pairs, and ended by %NULL.
 * @var_args: The var args list generated from @first_property_name.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the operation.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the initialization is finished
 * @user_data: the data to pass to callback function
 *
 * Helper function for constructing #GAsyncInitable object. This is
 * similar to g_object_new_valist() but also initializes the object
 * asynchronously.
 *
 * When the initialization is finished, @callback will be called. You can
 * then call g_async_initable_new_finish() to get the new object and check
 * for any errors.
 *
 * Since: 2.22
 */


/**
 * g_async_initable_newv_async:
 * @object_type: a #GType supporting #GAsyncInitable.
 * @n_parameters: the number of parameters in @parameters
 * @parameters: the parameters to use to construct the object
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the operation.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the initialization is finished
 * @user_data: the data to pass to callback function
 *
 * Helper function for constructing #GAsyncInitable object. This is
 * similar to g_object_newv() but also initializes the object asynchronously.
 *
 * When the initialization is finished, @callback will be called. You can
 * then call g_async_initable_new_finish() to get the new object and check
 * for any errors.
 *
 * Since: 2.22
 */


/**
 * g_async_result_get_source_object:
 * @res: a #GAsyncResult
 *
 * Gets the source object from a #GAsyncResult.
 *
 * or %NULL if there is none.
 *
 * Returns: (transfer full): a new reference to the source object for the @res,
 */


/**
 * g_async_result_get_user_data:
 * @res: a #GAsyncResult.
 *
 * Gets the user data from a #GAsyncResult.
 *
 * Returns: (transfer full): the user data for @res.
 */


/**
 * g_buffered_input_stream_fill:
 * @stream: a #GBufferedInputStream
 * @count: the number of bytes that will be read from the stream
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Tries to read @count bytes from the stream into the buffer.
 * Will block during this read.
 *
 * If @count is zero, returns zero and does nothing. A value of @count
 * larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
 *
 * On success, the number of bytes read into the buffer is returned.
 * It is not an error if this is not the same as the requested size, as it
 * can happen e.g. near the end of a file. Zero is returned on end of file
 * (or if @count is zero),  but never otherwise.
 *
 * If @count is -1 then the attempted read size is equal to the number of
 * bytes that are required to fill the buffer.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
 * operation was partially finished when the operation was cancelled the
 * partial result will be returned, without an error.
 *
 * On error -1 is returned and @error is set accordingly.
 *
 * For the asynchronous, non-blocking, version of this function, see
 * g_buffered_input_stream_fill_async().
 *
 * or -1 on error.
 *
 * Returns: the number of bytes read into @stream's buffer, up to @count,
 */


/**
 * g_buffered_input_stream_fill_async:
 * @stream: a #GBufferedInputStream
 * @count: the number of bytes that will be read from the stream
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request
 * @cancellable: (allow-none): optional #GCancellable object
 * @callback: (scope async): a #GAsyncReadyCallback
 * @user_data: (closure): a #gpointer
 *
 * Reads data into @stream's buffer asynchronously, up to @count size.
 * @io_priority can be used to prioritize reads. For the synchronous
 * version of this function, see g_buffered_input_stream_fill().
 *
 * If @count is -1 then the attempted read size is equal to the number
 * of bytes that are required to fill the buffer.
 */


/**
 * g_buffered_input_stream_fill_finish:
 * @stream: a #GBufferedInputStream
 * @result: a #GAsyncResult
 * @error: a #GError
 *
 * Finishes an asynchronous read.
 *
 * Returns: a #gssize of the read stream, or %-1 on an error.
 */


/**
 * g_buffered_input_stream_get_available:
 * @stream: #GBufferedInputStream
 *
 * Gets the size of the available data within the stream.
 *
 * Returns: size of the available stream.
 */


/**
 * g_buffered_input_stream_get_buffer_size:
 * @stream: a #GBufferedInputStream
 *
 * Gets the size of the input buffer.
 *
 * Returns: the current buffer size.
 */


/**
 * g_buffered_input_stream_new:
 * @base_stream: a #GInputStream
 *
 * Creates a new #GInputStream from the given @base_stream, with
 * a buffer set to the default size (4 kilobytes).
 *
 * Returns: a #GInputStream for the given @base_stream.
 */


/**
 * g_buffered_input_stream_new_sized:
 * @base_stream: a #GInputStream
 * @size: a #gsize
 *
 * Creates a new #GBufferedInputStream from the given @base_stream,
 * with a buffer set to @size.
 *
 * Returns: a #GInputStream.
 */


/**
 * g_buffered_input_stream_peek:
 * @stream: a #GBufferedInputStream
 * @buffer: a pointer to an allocated chunk of memory
 * @offset: a #gsize
 * @count: a #gsize
 *
 * Peeks in the buffer, copying data of size @count into @buffer,
 * offset @offset bytes.
 *
 * Returns: a #gsize of the number of bytes peeked, or -1 on error.
 */


/**
 * g_buffered_input_stream_peek_buffer:
 * @stream: a #GBufferedInputStream
 * @count: (out): a #gsize to get the number of bytes available in the buffer
 *
 * Returns the buffer with the currently available bytes. The returned
 * buffer must not be modified and will become invalid when reading from
 * the stream or filling the buffer.
 *
 * read-only buffer
 *
 * Returns: (array length=count) (element-type guint8) (transfer none):
 */


/**
 * g_buffered_input_stream_read_byte:
 * @stream: a #GBufferedInputStream
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Tries to read a single byte from the stream or the buffer. Will block
 * during this read.
 *
 * On success, the byte read from the stream is returned. On end of stream
 * -1 is returned but it's not an exceptional error and @error is not set.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
 * operation was partially finished when the operation was cancelled the
 * partial result will be returned, without an error.
 *
 * On error -1 is returned and @error is set accordingly.
 *
 * Returns: the byte read from the @stream, or -1 on end of stream or error.
 */


/**
 * g_buffered_input_stream_set_buffer_size:
 * @stream: a #GBufferedInputStream
 * @size: a #gsize
 *
 * Sets the size of the internal buffer of @stream to @size, or to the
 * size of the contents of the buffer. The buffer can never be resized
 * smaller than its current contents.
 */


/**
 * g_buffered_output_stream_get_auto_grow:
 * @stream: a #GBufferedOutputStream.
 *
 * Checks if the buffer automatically grows as data is added.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if the @stream's buffer automatically grows,
 */


/**
 * g_buffered_output_stream_get_buffer_size:
 * @stream: a #GBufferedOutputStream.
 *
 * Gets the size of the buffer in the @stream.
 *
 * Returns: the current size of the buffer.
 */


/**
 * g_buffered_output_stream_new:
 * @base_stream: a #GOutputStream.
 *
 * Creates a new buffered output stream for a base stream.
 *
 * Returns: a #GOutputStream for the given @base_stream.
 */


/**
 * g_buffered_output_stream_new_sized:
 * @base_stream: a #GOutputStream.
 * @size: a #gsize.
 *
 * Creates a new buffered output stream with a given buffer size.
 *
 * Returns: a #GOutputStream with an internal buffer set to @size.
 */


/**
 * g_buffered_output_stream_set_auto_grow:
 * @stream: a #GBufferedOutputStream.
 * @auto_grow: a #gboolean.
 *
 * Sets whether or not the @stream's buffer should automatically grow.
 * If @auto_grow is true, then each write will just make the buffer
 * larger, and you must manually flush the buffer to actually write out
 * the data to the underlying stream.
 */


/**
 * g_buffered_output_stream_set_buffer_size:
 * @stream: a #GBufferedOutputStream.
 * @size: a #gsize.
 *
 * Sets the size of the internal buffer to @size.
 */


/**
 * g_bus_get:
 * @bus_type: A #GBusType.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: The data to pass to @callback.
 *
 * Asynchronously connects to the message bus specified by @bus_type.
 *
 * When the operation is finished, @callback will be invoked. You can
 * then call g_bus_get_finish() to get the result of the operation.
 *
 * This is a asynchronous failable function. See g_bus_get_sync() for
 * the synchronous version.
 *
 * Since: 2.26
 */


/**
 * g_bus_get_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_bus_get().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_bus_get().
 *
 * The returned object is a singleton, that is, shared with other
 * callers of g_bus_get() and g_bus_get_sync() for @bus_type. In the
 * event that you need a private message bus connection, use
 * g_dbus_address_get_for_bus_sync() and
 * g_dbus_connection_new_for_address().
 *
 * Note that the returned #GDBusConnection object will (usually) have
 * the #GDBusConnection:exit-on-close property set to %TRUE.
 *
 * Returns: (transfer full): A #GDBusConnection or %NULL if @error is set. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_bus_get_sync:
 * @bus_type: A #GBusType.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously connects to the message bus specified by @bus_type.
 * Note that the returned object may shared with other callers,
 * e.g. if two separate parts of a process calls this function with
 * the same @bus_type, they will share the same object.
 *
 * This is a synchronous failable function. See g_bus_get() and
 * g_bus_get_finish() for the asynchronous version.
 *
 * The returned object is a singleton, that is, shared with other
 * callers of g_bus_get() and g_bus_get_sync() for @bus_type. In the
 * event that you need a private message bus connection, use
 * g_dbus_address_get_for_bus_sync() and
 * g_dbus_connection_new_for_address().
 *
 * Note that the returned #GDBusConnection object will (usually) have
 * the #GDBusConnection:exit-on-close property set to %TRUE.
 *
 * Returns: (transfer full): A #GDBusConnection or %NULL if @error is set. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_bus_own_name:
 * @bus_type: The type of bus to own a name on.
 * @name: The well-known name to own.
 * @flags: A set of flags from the #GBusNameOwnerFlags enumeration.
 * @bus_acquired_handler: Handler to invoke when connected to the bus of type @bus_type or %NULL.
 * @name_acquired_handler: Handler to invoke when @name is acquired or %NULL.
 * @name_lost_handler: Handler to invoke when @name is lost or %NULL.
 * @user_data: User data to pass to handlers.
 * @user_data_free_func: Function for freeing @user_data or %NULL.
 *
 * Starts acquiring @name on the bus specified by @bus_type and calls
 * @name_acquired_handler and @name_lost_handler when the name is
 * acquired respectively lost. Callbacks will be invoked in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * loop</link> of the thread you are calling this function from.
 *
 * You are guaranteed that one of the @name_acquired_handler and @name_lost_handler
 * callbacks will be invoked after calling this function - there are three
 * possible cases:
 * <itemizedlist>
 * <listitem><para>
 * @name_lost_handler with a %NULL connection (if a connection to the bus can't be made).
 * </para></listitem>
 * <listitem><para>
 * @bus_acquired_handler then @name_lost_handler (if the name can't be obtained)
 * </para></listitem>
 * <listitem><para>
 * @bus_acquired_handler then @name_acquired_handler (if the name was obtained).
 * </para></listitem>
 * </itemizedlist>
 * When you are done owning the name, just call g_bus_unown_name()
 * with the owner id this function returns.
 *
 * If the name is acquired or lost (for example another application
 * could acquire the name if you allow replacement or the application
 * currently owning the name exits), the handlers are also invoked. If the
 * #GDBusConnection that is used for attempting to own the name
 * closes, then @name_lost_handler is invoked since it is no
 * longer possible for other processes to access the process.
 *
 * You cannot use g_bus_own_name() several times for the same name (unless
 * interleaved with calls to g_bus_unown_name()) - only the first call
 * will work.
 *
 * Another guarantee is that invocations of @name_acquired_handler
 * and @name_lost_handler are guaranteed to alternate; that
 * is, if @name_acquired_handler is invoked then you are
 * guaranteed that the next time one of the handlers is invoked, it
 * will be @name_lost_handler. The reverse is also true.
 *
 * If you plan on exporting objects (using e.g.
 * g_dbus_connection_register_object()), note that it is generally too late
 * to export the objects in @name_acquired_handler. Instead, you can do this
 * in @bus_acquired_handler since you are guaranteed that this will run
 * before @name is requested from the bus.
 *
 * This behavior makes it very simple to write applications that wants
 * to own names and export objects, see <xref linkend="gdbus-owning-names"/>.
 * Simply register objects to be exported in @bus_acquired_handler and
 * unregister the objects (if any) in @name_lost_handler.
 *
 * g_bus_unown_name() to stop owning the name.
 *
 * Returns: An identifier (never 0) that an be used with
 * Since: 2.26
 */


/**
 * g_bus_own_name_on_connection:
 * @connection: A #GDBusConnection.
 * @name: The well-known name to own.
 * @flags: A set of flags from the #GBusNameOwnerFlags enumeration.
 * @name_acquired_handler: Handler to invoke when @name is acquired or %NULL.
 * @name_lost_handler: Handler to invoke when @name is lost or %NULL.
 * @user_data: User data to pass to handlers.
 * @user_data_free_func: Function for freeing @user_data or %NULL.
 *
 * Like g_bus_own_name() but takes a #GDBusConnection instead of a
 * #GBusType.
 *
 * g_bus_unown_name() to stop owning the name.
 *
 * Returns: An identifier (never 0) that an be used with
 * Since: 2.26
 */


/**
 * g_bus_own_name_on_connection_with_closures:
 * @connection: A #GDBusConnection.
 * @name: The well-known name to own.
 * @flags: A set of flags from the #GBusNameOwnerFlags enumeration.
 * @name_acquired_closure: (allow-none): #GClosure to invoke when @name is acquired or %NULL.
 * @name_lost_closure: (allow-none): #GClosure to invoke when @name is lost or %NULL.
 *
 * Version of g_bus_own_name_on_connection() using closures instead of callbacks for
 * easier binding in other languages.
 *
 * g_bus_unown_name() to stop owning the name.
 *
 * Returns: An identifier (never 0) that an be used with
 * Rename to: g_bus_own_name_on_connection
 * Since: 2.26
 */


/**
 * g_bus_own_name_with_closures:
 * @bus_type: The type of bus to own a name on.
 * @name: The well-known name to own.
 * @flags: A set of flags from the #GBusNameOwnerFlags enumeration.
 * @bus_acquired_closure: (allow-none): #GClosure to invoke when connected to the bus of type @bus_type or %NULL.
 * @name_acquired_closure: (allow-none): #GClosure to invoke when @name is acquired or %NULL.
 * @name_lost_closure: (allow-none): #GClosure to invoke when @name is lost or %NULL.
 *
 * Version of g_bus_own_name() using closures instead of callbacks for
 * easier binding in other languages.
 *
 * g_bus_unown_name() to stop owning the name.
 *
 * Returns: An identifier (never 0) that an be used with
 * Rename to: g_bus_own_name
 * Since: 2.26
 */


/**
 * g_bus_unown_name:
 * @owner_id: An identifier obtained from g_bus_own_name()
 *
 * Stops owning a name.
 *
 * Since: 2.26
 */


/**
 * g_bus_unwatch_name:
 * @watcher_id: An identifier obtained from g_bus_watch_name()
 *
 * Stops watching a name.
 *
 * Since: 2.26
 */


/**
 * g_bus_watch_name:
 * @bus_type: The type of bus to watch a name on.
 * @name: The name (well-known or unique) to watch.
 * @flags: Flags from the #GBusNameWatcherFlags enumeration.
 * @name_appeared_handler: Handler to invoke when @name is known to exist or %NULL.
 * @name_vanished_handler: Handler to invoke when @name is known to not exist or %NULL.
 * @user_data: User data to pass to handlers.
 * @user_data_free_func: Function for freeing @user_data or %NULL.
 *
 * Starts watching @name on the bus specified by @bus_type and calls
 * @name_appeared_handler and @name_vanished_handler when the name is
 * known to have a owner respectively known to lose its
 * owner. Callbacks will be invoked in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * loop</link> of the thread you are calling this function from.
 *
 * You are guaranteed that one of the handlers will be invoked after
 * calling this function. When you are done watching the name, just
 * call g_bus_unwatch_name() with the watcher id this function
 * returns.
 *
 * If the name vanishes or appears (for example the application owning
 * the name could restart), the handlers are also invoked. If the
 * #GDBusConnection that is used for watching the name disconnects, then
 * @name_vanished_handler is invoked since it is no longer
 * possible to access the name.
 *
 * Another guarantee is that invocations of @name_appeared_handler
 * and @name_vanished_handler are guaranteed to alternate; that
 * is, if @name_appeared_handler is invoked then you are
 * guaranteed that the next time one of the handlers is invoked, it
 * will be @name_vanished_handler. The reverse is also true.
 *
 * This behavior makes it very simple to write applications that wants
 * to take action when a certain name exists, see <xref
 * linkend="gdbus-watching-names"/>. Basically, the application
 * should create object proxies in @name_appeared_handler and destroy
 * them again (if any) in @name_vanished_handler.
 *
 * g_bus_unwatch_name() to stop watching the name.
 *
 * Returns: An identifier (never 0) that an be used with
 * Since: 2.26
 */


/**
 * g_bus_watch_name_on_connection:
 * @connection: A #GDBusConnection.
 * @name: The name (well-known or unique) to watch.
 * @flags: Flags from the #GBusNameWatcherFlags enumeration.
 * @name_appeared_handler: Handler to invoke when @name is known to exist or %NULL.
 * @name_vanished_handler: Handler to invoke when @name is known to not exist or %NULL.
 * @user_data: User data to pass to handlers.
 * @user_data_free_func: Function for freeing @user_data or %NULL.
 *
 * Like g_bus_watch_name() but takes a #GDBusConnection instead of a
 * #GBusType.
 *
 * g_bus_unwatch_name() to stop watching the name.
 *
 * Returns: An identifier (never 0) that an be used with
 * Since: 2.26
 */


/**
 * g_bus_watch_name_on_connection_with_closures:
 * @connection: A #GDBusConnection.
 * @name: The name (well-known or unique) to watch.
 * @flags: Flags from the #GBusNameWatcherFlags enumeration.
 * @name_appeared_closure: (allow-none): #GClosure to invoke when @name is known to exist or %NULL.
 * @name_vanished_closure: (allow-none): #GClosure to invoke when @name is known to not exist or %NULL.
 *
 * Version of g_bus_watch_name_on_connection() using closures instead of callbacks for
 * easier binding in other languages.
 *
 * g_bus_unwatch_name() to stop watching the name.
 *
 * Returns: An identifier (never 0) that an be used with
 * Rename to: g_bus_watch_name_on_connection
 * Since: 2.26
 */


/**
 * g_bus_watch_name_with_closures:
 * @bus_type: The type of bus to watch a name on.
 * @name: The name (well-known or unique) to watch.
 * @flags: Flags from the #GBusNameWatcherFlags enumeration.
 * @name_appeared_closure: (allow-none): #GClosure to invoke when @name is known to exist or %NULL.
 * @name_vanished_closure: (allow-none): #GClosure to invoke when @name is known to not exist or %NULL.
 *
 * Version of g_bus_watch_name() using closures instead of callbacks for
 * easier binding in other languages.
 *
 * g_bus_unwatch_name() to stop watching the name.
 *
 * Returns: An identifier (never 0) that an be used with
 * Rename to: g_bus_watch_name
 * Since: 2.26
 */


/**
 * g_cancellable_cancel:
 * @cancellable: a #GCancellable object.
 *
 * Will set @cancellable to cancelled, and will emit the
 * #GCancellable::cancelled signal. (However, see the warning about
 * race conditions in the documentation for that signal if you are
 * planning to connect to it.)
 *
 * This function is thread-safe. In other words, you can safely call
 * it from a thread other than the one running the operation that was
 * passed the @cancellable.
 *
 * The convention within gio is that cancelling an asynchronous
 * operation causes it to complete asynchronously. That is, if you
 * cancel the operation from the same thread in which it is running,
 * then the operation's #GAsyncReadyCallback will not be invoked until
 * the application returns to the main loop.
 */


/**
 * g_cancellable_connect:
 * @cancellable: A #GCancellable.
 * @callback: The #GCallback to connect.
 * @data: Data to pass to @callback.
 * @data_destroy_func: Free function for @data or %NULL.
 *
 * Convenience function to connect to the #GCancellable::cancelled
 * signal. Also handles the race condition that may happen
 * if the cancellable is cancelled right before connecting.
 *
 * @callback is called at most once, either directly at the
 * time of the connect if @cancellable is already cancelled,
 * or when @cancellable is cancelled in some thread.
 *
 * @data_destroy_func will be called when the handler is
 * disconnected, or immediately if the cancellable is already
 * cancelled.
 *
 * See #GCancellable::cancelled for details on how to use this.
 *
 * been cancelled.
 *
 * Returns: The id of the signal handler or 0 if @cancellable has already
 * Since: 2.22
 */


/**
 * g_cancellable_disconnect:
 * @cancellable: A #GCancellable or %NULL.
 * @handler_id: Handler id of the handler to be disconnected, or %0.
 *
 * Disconnects a handler from a cancellable instance similar to
 * g_signal_handler_disconnect().  Additionally, in the event that a
 * signal handler is currently running, this call will block until the
 * handler has finished.  Calling this function from a
 * #GCancellable::cancelled signal handler will therefore result in a
 * deadlock.
 *
 * This avoids a race condition where a thread cancels at the
 * same time as the cancellable operation is finished and the
 * signal handler is removed. See #GCancellable::cancelled for
 * details on how to use this.
 *
 * If @cancellable is %NULL or @handler_id is %0 this function does
 * nothing.
 *
 * Since: 2.22
 */


/**
 * g_cancellable_get_current:
 *
 * Gets the top cancellable from the stack.
 *
 * if the stack is empty.
 *
 * Returns: (transfer none): a #GCancellable from the top of the stack, or %NULL
 */


/**
 * g_cancellable_get_fd:
 * @cancellable: a #GCancellable.
 *
 * Gets the file descriptor for a cancellable job. This can be used to
 * implement cancellable operations on Unix systems. The returned fd will
 * turn readable when @cancellable is cancelled.
 *
 * You are not supposed to read from the fd yourself, just check for
 * readable status. Reading to unset the readable status is done
 * with g_cancellable_reset().
 *
 * After a successful return from this function, you should use
 * g_cancellable_release_fd() to free up resources allocated for
 * the returned file descriptor.
 *
 * See also g_cancellable_make_pollfd().
 *
 * is not supported, or on errors.
 *
 * Returns: A valid file descriptor. %-1 if the file descriptor
 */


/**
 * g_cancellable_is_cancelled:
 * @cancellable: (allow-none): a #GCancellable or %NULL
 *
 * Checks if a cancellable job has been cancelled.
 *
 * FALSE if called with %NULL or if item is not cancelled.
 *
 * Returns: %TRUE if @cancellable is cancelled,
 */


/**
 * g_cancellable_make_pollfd:
 * @cancellable: a #GCancellable or %NULL
 * @pollfd: a pointer to a #GPollFD
 *
 * Creates a #GPollFD corresponding to @cancellable; this can be passed
 * to g_poll() and used to poll for cancellation. This is useful both
 * for unix systems without a native poll and for portability to
 * windows.
 *
 * When this function returns %TRUE, you should use
 * g_cancellable_release_fd() to free up resources allocated for the
 * @pollfd. After a %FALSE return, do not call g_cancellable_release_fd().
 *
 * If this function returns %FALSE, either no @cancellable was given or
 * resource limits prevent this function from allocating the necessary
 * structures for polling. (On Linux, you will likely have reached
 * the maximum number of file descriptors.) The suggested way to handle
 * these cases is to ignore the @cancellable.
 *
 * You are not supposed to read from the fd yourself, just check for
 * readable status. Reading to unset the readable status is done
 * with g_cancellable_reset().
 *
 * failure to prepare the cancellable.
 *
 * Returns: %TRUE if @pollfd was successfully initialized, %FALSE on
 * Since: 2.22
 */


/**
 * g_cancellable_new:
 *
 * Creates a new #GCancellable object.
 *
 * Applications that want to start one or more operations
 * that should be cancellable should create a #GCancellable
 * and pass it to the operations.
 *
 * One #GCancellable can be used in multiple consecutive
 * operations or in multiple concurrent operations.
 *
 * Returns: a #GCancellable.
 */


/**
 * g_cancellable_pop_current:
 * @cancellable: a #GCancellable object
 *
 * Pops @cancellable off the cancellable stack (verifying that @cancellable
 * is on the top of the stack).
 */


/**
 * g_cancellable_push_current:
 * @cancellable: a #GCancellable object
 *
 * Pushes @cancellable onto the cancellable stack. The current
 * cancellable can then be received using g_cancellable_get_current().
 *
 * This is useful when implementing cancellable operations in
 * code that does not allow you to pass down the cancellable object.
 *
 * This is typically called automatically by e.g. #GFile operations,
 * so you rarely have to call this yourself.
 */


/**
 * g_cancellable_release_fd:
 * @cancellable: a #GCancellable
 *
 * Releases a resources previously allocated by g_cancellable_get_fd()
 * or g_cancellable_make_pollfd().
 *
 * For compatibility reasons with older releases, calling this function
 * is not strictly required, the resources will be automatically freed
 * when the @cancellable is finalized. However, the @cancellable will
 * block scarce file descriptors until it is finalized if this function
 * is not called. This can cause the application to run out of file
 * descriptors when many #GCancellables are used at the same time.
 *
 * Since: 2.22
 */


/**
 * g_cancellable_reset:
 * @cancellable: a #GCancellable object.
 *
 * Resets @cancellable to its uncancelled state.
 *
 * If cancellable is currently in use by any cancellable operation
 * then the behavior of this function is undefined.
 */


/**
 * g_cancellable_set_error_if_cancelled:
 * @cancellable: (allow-none): a #GCancellable or %NULL
 * @error: #GError to append error state to
 *
 * If the @cancellable is cancelled, sets the error to notify
 * that the operation was cancelled.
 *
 * Returns: %TRUE if @cancellable was cancelled, %FALSE if it was not
 */


/**
 * g_cancellable_source_new: (skip)
 * @cancellable: a #GCancellable, or %NULL
 *
 * Creates a source that triggers if @cancellable is cancelled and
 * calls its callback of type #GCancellableSourceFunc. This is
 * primarily useful for attaching to another (non-cancellable) source
 * with g_source_add_child_source() to add cancellability to it.
 *
 * For convenience, you can call this with a %NULL #GCancellable,
 * in which case the source will never trigger.
 *
 * Returns: (transfer full): the new #GSource.
 * Since: 2.28
 */


/**
 * g_charset_converter_get_num_fallbacks:
 * @converter: a #GCharsetConverter
 *
 * Gets the number of fallbacks that @converter has applied so far.
 *
 * Returns: the number of fallbacks that @converter has applied
 * Since: 2.24
 */


/**
 * g_charset_converter_get_use_fallback:
 * @converter: a #GCharsetConverter
 *
 * Gets the #GCharsetConverter:use-fallback property.
 *
 * Returns: %TRUE if fallbacks are used by @converter
 * Since: 2.24
 */


/**
 * g_charset_converter_new:
 * @to_charset: destination charset
 * @from_charset: source charset
 * @error: #GError for error reporting, or %NULL to ignore.
 *
 * Creates a new #GCharsetConverter.
 *
 * Returns: a new #GCharsetConverter or %NULL on error.
 * Since: 2.24
 */


/**
 * g_charset_converter_set_use_fallback:
 * @converter: a #GCharsetConverter
 * @use_fallback: %TRUE to use fallbacks
 *
 * Sets the #GCharsetConverter:use-fallback property.
 *
 * Since: 2.24
 */


/**
 * g_content_type_can_be_executable:
 * @type: a content type string
 *
 * Checks if a content type can be executable. Note that for instance
 * things like text files can be executables (i.e. scripts and batch files).
 *
 * can be executable, %FALSE otherwise.
 *
 * Returns: %TRUE if the file type corresponds to a type that
 */


/**
 * g_content_type_equals:
 * @type1: a content type string
 * @type2: a content type string
 *
 * Compares two content types for equality.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if the two strings are identical or equivalent,
 */


/**
 * g_content_type_from_mime_type:
 * @mime_type: a mime type string
 *
 * Tries to find a content type based on the mime type name.
 *
 * or %NULL. Free with g_free()
 *
 * Returns: (allow-none): Newly allocated string with content type
 * Since: 2.18
 */


/**
 * g_content_type_get_description:
 * @type: a content type string
 *
 * Gets the human readable description of the content type.
 *
 * returned string with g_free()
 *
 * Returns: a short description of the content type @type. Free the
 */


/**
 * g_content_type_get_icon:
 * @type: a content type string
 *
 * Gets the icon for a content type.
 *
 * object with g_object_unref()
 *
 * Returns: (transfer full): #GIcon corresponding to the content type. Free the returned
 */


/**
 * g_content_type_get_mime_type:
 * @type: a content type string
 *
 * Gets the mime type for the content type, if one is registered.
 *
 * or %NULL if unknown.
 *
 * Returns: (allow-none): the registered mime type for the given @type,
 */


/**
 * g_content_type_guess:
 * @filename: (allow-none): a string, or %NULL
 * @data: (allow-none) (array length=data_size): a stream of data, or %NULL
 * @data_size: the size of @data
 * @result_uncertain: (allow-none) (out): return location for the certainty of the result, or %NULL
 *
 * Guesses the content type based on example data. If the function is
 * uncertain, @result_uncertain will be set to %TRUE. Either @filename
 * or @data may be %NULL, in which case the guess will be based solely
 * on the other argument.
 *
 * given data. Free with g_free()
 *
 * Returns: a string indicating a guessed content type for the
 */


/**
 * g_content_type_guess_for_tree:
 * @root: the root of the tree to guess a type for
 *
 * Tries to guess the type of the tree with root @root, by
 * looking at the files it contains. The result is an array
 * of content types, with the best guess coming first.
 *
 * The types returned all have the form x-content/foo, e.g.
 * x-content/audio-cdda (for audio CDs) or x-content/image-dcf
 * (for a camera memory card). See the <ulink url="http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec">shared-mime-info</ulink>
 * specification for more on x-content types.
 *
 * This function is useful in the implementation of
 * g_mount_guess_content_type().
 *
 * array of zero or more content types, or %NULL. Free with g_strfreev()
 *
 * Returns: (transfer full) (array zero-terminated=1): an %NULL-terminated
 * Since: 2.18
 */


/**
 * g_content_type_is_a:
 * @type: a content type string
 * @supertype: a content type string
 *
 * Determines if @type is a subset of @supertype.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if @type is a kind of @supertype,
 */


/**
 * g_content_type_is_unknown:
 * @type: a content type string
 *
 * Checks if the content type is the generic "unknown" type.
 * On UNIX this is the "application/octet-stream" mimetype,
 * while on win32 it is "*".
 *
 * Returns: %TRUE if the type is the unknown type.
 */


/**
 * g_content_types_get_registered:
 *
 * Gets a list of strings containing all the registered content types
 * known to the system. The list and its data should be freed using
 * <programlisting>
 * g_list_foreach (list, g_free, NULL);
 * g_list_free (list);
 * </programlisting>
 *
 * Returns: (element-type utf8) (transfer full): #GList of the registered content types
 */


/**
 * g_converter_convert:
 * @converter: a #GConverter.
 * @inbuf: (array length=inbuf_size) (element-type guint8): the buffer containing the data to convert.
 * @inbuf_size: the number of bytes in @inbuf
 * @outbuf: a buffer to write converted data in.
 * @outbuf_size: the number of bytes in @outbuf, must be at least one
 * @flags: a #GConvertFlags controlling the conversion details
 * @bytes_read: (out): will be set to the number of bytes read from @inbuf on success
 * @bytes_written: (out): will be set to the number of bytes written to @outbuf on success
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * This is the main operation used when converting data. It is to be called
 * multiple times in a loop, and each time it will do some work, i.e.
 * producing some output (in @outbuf) or consuming some input (from @inbuf) or
 * both. If its not possible to do any work an error is returned.
 *
 * Note that a single call may not consume all input (or any input at all).
 * Also a call may produce output even if given no input, due to state stored
 * in the converter producing output.
 *
 * If any data was either produced or consumed, and then an error happens, then
 * only the successful conversion is reported and the error is returned on the
 * next call.
 *
 * A full conversion loop involves calling this method repeatedly, each time
 * giving it new input and space output space. When there is no more input
 * data after the data in @inbuf, the flag %G_CONVERTER_INPUT_AT_END must be set.
 * The loop will be (unless some error happens) returning %G_CONVERTER_CONVERTED
 * each time until all data is consumed and all output is produced, then
 * %G_CONVERTER_FINISHED is returned instead. Note, that %G_CONVERTER_FINISHED
 * may be returned even if %G_CONVERTER_INPUT_AT_END is not set, for instance
 * in a decompression converter where the end of data is detectable from the
 * data (and there might even be other data after the end of the compressed data).
 *
 * When some data has successfully been converted @bytes_read and is set to
 * the number of bytes read from @inbuf, and @bytes_written is set to indicate
 * how many bytes was written to @outbuf. If there are more data to output
 * or consume (i.e. unless the %G_CONVERTER_INPUT_AT_END is specified) then
 * %G_CONVERTER_CONVERTED is returned, and if no more data is to be output
 * then %G_CONVERTER_FINISHED is returned.
 *
 * On error %G_CONVERTER_ERROR is returned and @error is set accordingly.
 * Some errors need special handling:
 *
 * %G_IO_ERROR_NO_SPACE is returned if there is not enough space
 * to write the resulting converted data, the application should
 * call the function again with a larger @outbuf to continue.
 *
 * %G_IO_ERROR_PARTIAL_INPUT is returned if there is not enough
 * input to fully determine what the conversion should produce,
 * and the %G_CONVERTER_INPUT_AT_END flag is not set. This happens for
 * example with an incomplete multibyte sequence when converting text,
 * or when a regexp matches up to the end of the input (and may match
 * further input). It may also happen when @inbuf_size is zero and
 * there is no more data to produce.
 *
 * When this happens the application should read more input and then
 * call the function again. If further input shows that there is no
 * more data call the function again with the same data but with
 * the %G_CONVERTER_INPUT_AT_END flag set. This may cause the conversion
 * to finish as e.g. in the regexp match case (or, to fail again with
 * %G_IO_ERROR_PARTIAL_INPUT in e.g. a charset conversion where the
 * input is actually partial).
 *
 * After g_converter_convert() has returned %G_CONVERTER_FINISHED the
 * converter object is in an invalid state where its not allowed
 * to call g_converter_convert() anymore. At this time you can only
 * free the object or call g_converter_reset() to reset it to the
 * initial state.
 *
 * If the flag %G_CONVERTER_FLUSH is set then conversion is modified
 * to try to write out all internal state to the output. The application
 * has to call the function multiple times with the flag set, and when
 * the available input has been consumed and all internal state has
 * been produced then %G_CONVERTER_FLUSHED (or %G_CONVERTER_FINISHED if
 * really at the end) is returned instead of %G_CONVERTER_CONVERTED.
 * This is somewhat similar to what happens at the end of the input stream,
 * but done in the middle of the data.
 *
 * This has different meanings for different conversions. For instance
 * in a compression converter it would mean that we flush all the
 * compression state into output such that if you uncompress the
 * compressed data you get back all the input data. Doing this may
 * make the final file larger due to padding though. Another example
 * is a regexp conversion, where if you at the end of the flushed data
 * have a match, but there is also a potential longer match. In the
 * non-flushed case we would ask for more input, but when flushing we
 * treat this as the end of input and do the match.
 *
 * Flushing is not always possible (like if a charset converter flushes
 * at a partial multibyte sequence). Converters are supposed to try
 * to produce as much output as possible and then return an error
 * (typically %G_IO_ERROR_PARTIAL_INPUT).
 *
 * Returns: a #GConverterResult, %G_CONVERTER_ERROR on error.
 * Since: 2.24
 */


/**
 * g_converter_input_stream_get_converter:
 * @converter_stream: a #GConverterInputStream
 *
 * Gets the #GConverter that is used by @converter_stream.
 *
 * Returns: (transfer none): the converter of the converter input stream
 * Since: 2.24
 */


/**
 * g_converter_input_stream_new:
 * @base_stream: a #GInputStream
 * @converter: a #GConverter
 *
 * Creates a new converter input stream for the @base_stream.
 *
 * Returns: a new #GInputStream.
 */


/**
 * g_converter_output_stream_get_converter:
 * @converter_stream: a #GConverterOutputStream
 *
 * Gets the #GConverter that is used by @converter_stream.
 *
 * Returns: (transfer none): the converter of the converter output stream
 * Since: 2.24
 */


/**
 * g_converter_output_stream_new:
 * @base_stream: a #GOutputStream
 * @converter: a #GConverter
 *
 * Creates a new converter output stream for the @base_stream.
 *
 * Returns: a new #GOutputStream.
 */


/**
 * g_converter_reset:
 * @converter: a #GConverter.
 *
 * Resets all internal state in the converter, making it behave
 * as if it was just created. If the converter has any internal
 * state that would produce output then that output is lost.
 *
 * Since: 2.24
 */


/**
 * g_credentials_get_native: (skip)
 * @credentials: A #GCredentials.
 * @native_type: The type of native credentials to get.
 *
 * Gets a pointer to native credentials of type @native_type from
 * @credentials.
 *
 * It is a programming error (which will cause an warning to be
 * logged) to use this method if there is no #GCredentials support for
 * the OS or if @native_type isn't supported by the OS.
 *
 * operation there is no #GCredentials support for the OS or if
 * @native_type isn't supported by the OS. Do not free the returned
 * data, it is owned by @credentials.
 *
 * Returns: The pointer to native credentials or %NULL if the
 * Since: 2.26
 */


/**
 * g_credentials_get_unix_user:
 * @credentials: A #GCredentials
 * @error: Return location for error or %NULL.
 *
 * Tries to get the UNIX user identifier from @credentials. This
 * method is only available on UNIX platforms.
 *
 * This operation can fail if #GCredentials is not supported on the
 * OS or if the native credentials type does not contain information
 * about the UNIX user.
 *
 * Returns: The UNIX user identifier or -1 if @error is set.
 * Since: 2.26
 */


/**
 * g_credentials_is_same_user:
 * @credentials: A #GCredentials.
 * @other_credentials: A #GCredentials.
 * @error: Return location for error or %NULL.
 *
 * Checks if @credentials and @other_credentials is the same user.
 *
 * This operation can fail if #GCredentials is not supported on the
 * the OS.
 *
 * user, %FALSE otherwise or if @error is set.
 *
 * Returns: %TRUE if @credentials and @other_credentials has the same
 * Since: 2.26
 */


/**
 * g_credentials_new:
 *
 * Creates a new #GCredentials object with credentials matching the
 * the current process.
 *
 * Returns: A #GCredentials. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_credentials_set_native:
 * @credentials: A #GCredentials.
 * @native_type: The type of native credentials to set.
 * @native: A pointer to native credentials.
 *
 * Copies the native credentials of type @native_type from @native
 * into @credentials.
 *
 * It is a programming error (which will cause an warning to be
 * logged) to use this method if there is no #GCredentials support for
 * the OS or if @native_type isn't supported by the OS.
 *
 * Since: 2.26
 */


/**
 * g_credentials_set_unix_user:
 * @credentials: A #GCredentials.
 * @uid: The UNIX user identifier to set.
 * @error: Return location for error or %NULL.
 *
 * Tries to set the UNIX user identifier on @credentials. This method
 * is only available on UNIX platforms.
 *
 * This operation can fail if #GCredentials is not supported on the
 * OS or if the native credentials type does not contain information
 * about the UNIX user.
 *
 * Returns: %TRUE if @uid was set, %FALSE if error is set.
 * Since: 2.26
 */


/**
 * g_credentials_to_string:
 * @credentials: A #GCredentials object.
 *
 * Creates a human-readable textual representation of @credentials
 * that can be used in logging and debug messages. The format of the
 * returned string may change in future GLib release.
 *
 * Returns: A string that should be freed with g_free().
 * Since: 2.26
 */


/**
 * g_data_input_stream_get_byte_order:
 * @stream: a given #GDataInputStream.
 *
 * Gets the byte order for the data input stream.
 *
 * Returns: the @stream's current #GDataStreamByteOrder.
 */


/**
 * g_data_input_stream_get_newline_type:
 * @stream: a given #GDataInputStream.
 *
 * Gets the current newline type for the @stream.
 *
 * Returns: #GDataStreamNewlineType for the given @stream.
 */


/**
 * g_data_input_stream_new:
 * @base_stream: a #GInputStream.
 *
 * Creates a new data input stream for the @base_stream.
 *
 * Returns: a new #GDataInputStream.
 */


/**
 * g_data_input_stream_read_byte:
 * @stream: a given #GDataInputStream.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads an unsigned 8-bit/1-byte value from @stream.
 *
 * if an error occurred.
 *
 * Returns: an unsigned 8-bit/1-byte value read from the @stream or %0
 */


/**
 * g_data_input_stream_read_int16:
 * @stream: a given #GDataInputStream.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a 16-bit/2-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
 *
 * an error occurred.
 *
 * Returns: a signed 16-bit/2-byte value read from @stream or %0 if
 */


/**
 * g_data_input_stream_read_int32:
 * @stream: a given #GDataInputStream.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a signed 32-bit/4-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * an error occurred.
 *
 * Returns: a signed 32-bit/4-byte value read from the @stream or %0 if
 */


/**
 * g_data_input_stream_read_int64:
 * @stream: a given #GDataInputStream.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a 64-bit/8-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * an error occurred.
 *
 * Returns: a signed 64-bit/8-byte value read from @stream or %0 if
 */


/**
 * g_data_input_stream_read_line:
 * @stream: a given #GDataInputStream.
 * @length: (out): a #gsize to get the length of the data read in.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a line from the data input stream.  Note that no encoding
 * checks or conversion is performed; the input is not guaranteed to
 * be UTF-8, and may in fact have embedded NUL characters.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * NUL terminated byte array with the line that was read in (without
 * the newlines).  Set @length to a #gsize to get the length of the
 * read line.  On an error, it will return %NULL and @error will be
 * set. If there's no content to read, it will still return %NULL,
 * but @error won't be set.
 *
 * Returns: (transfer full) (array zero-terminated=1) (element-type guint8): a
 */


/**
 * g_data_input_stream_read_line_async:
 * @stream: a given #GDataInputStream.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): callback to call when the request is satisfied.
 * @user_data: (closure): the data to pass to callback function.
 *
 * The asynchronous version of g_data_input_stream_read_line().  It is
 * an error to have two outstanding calls to this function.
 *
 * When the operation is finished, @callback will be called. You
 * can then call g_data_input_stream_read_line_finish() to get
 * the result of the operation.
 *
 * Since: 2.20
 */


/**
 * g_data_input_stream_read_line_finish:
 * @stream: a given #GDataInputStream.
 * @result: the #GAsyncResult that was provided to the callback.
 * @length: (out): a #gsize to get the length of the data read in.
 * @error: #GError for error reporting.
 *
 * Finish an asynchronous call started by
 * g_data_input_stream_read_line_async().  Note the warning about
 * string encoding in g_data_input_stream_read_line() applies here as
 * well.
 *
 * NUL-terminated byte array with the line that was read in
 * (without the newlines).  Set @length to a #gsize to get the
 * length of the read line.  On an error, it will return %NULL and
 * @error will be set. If there's no content to read, it will
 * still return %NULL, but @error won't be set.
 *
 * Returns: (transfer full) (array zero-terminated=1) (element-type guint8): a
 * Since: 2.20
 */


/**
 * g_data_input_stream_read_line_finish_utf8:
 * @stream: a given #GDataInputStream.
 * @result: the #GAsyncResult that was provided to the callback.
 * @length: (out): a #gsize to get the length of the data read in.
 * @error: #GError for error reporting.
 *
 * Finish an asynchronous call started by
 * g_data_input_stream_read_line_async().
 *
 * (without the newlines).  Set @length to a #gsize to get the length
 * of the read line.  On an error, it will return %NULL and @error
 * will be set. For UTF-8 conversion errors, the set error domain is
 * %G_CONVERT_ERROR.  If there's no content to read, it will still
 * return %NULL, but @error won't be set.
 *
 * Returns: (transfer full): a string with the line that was read in
 * Since: 2.30
 */


/**
 * g_data_input_stream_read_line_utf8:
 * @stream: a given #GDataInputStream.
 * @length: (out): a #gsize to get the length of the data read in.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a UTF-8 encoded line from the data input stream.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * line that was read in (without the newlines).  Set @length to a
 * #gsize to get the length of the read line.  On an error, it will
 * return %NULL and @error will be set.  For UTF-8 conversion errors,
 * the set error domain is %G_CONVERT_ERROR.  If there's no content to
 * read, it will still return %NULL, but @error won't be set.
 *
 * Returns: (transfer full): a NUL terminated UTF-8 string with the
 * Since: 2.30
 */


/**
 * g_data_input_stream_read_uint16:
 * @stream: a given #GDataInputStream.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads an unsigned 16-bit/2-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
 *
 * an error occurred.
 *
 * Returns: an unsigned 16-bit/2-byte value read from the @stream or %0 if
 */


/**
 * g_data_input_stream_read_uint32:
 * @stream: a given #GDataInputStream.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads an unsigned 32-bit/4-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order() and g_data_input_stream_set_byte_order().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * an error occurred.
 *
 * Returns: an unsigned 32-bit/4-byte value read from the @stream or %0 if
 */


/**
 * g_data_input_stream_read_uint64:
 * @stream: a given #GDataInputStream.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads an unsigned 64-bit/8-byte value from @stream.
 *
 * In order to get the correct byte order for this read operation,
 * see g_data_input_stream_get_byte_order().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * an error occurred.
 *
 * Returns: an unsigned 64-bit/8-byte read from @stream or %0 if
 */


/**
 * g_data_input_stream_read_until:
 * @stream: a given #GDataInputStream.
 * @stop_chars: characters to terminate the read.
 * @length: (out): a #gsize to get the length of the data read in.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Reads a string from the data input stream, up to the first
 * occurrence of any of the stop characters.
 *
 * Note that, in contrast to g_data_input_stream_read_until_async(),
 * this function consumes the stop character that it finds.
 *
 * Don't use this function in new code.  Its functionality is
 * inconsistent with g_data_input_stream_read_until_async().  Both
 * functions will be marked as deprecated in a future release.  Use
 * g_data_input_stream_read_upto() instead, but note that that function
 * does not consume the stop character.
 *
 * before encountering any of the stop characters. Set @length to
 * a #gsize to get the length of the string. This function will
 * return %NULL on an error.
 *
 * Returns: (transfer full): a string with the data that was read
 */


/**
 * g_data_input_stream_read_until_async:
 * @stream: a given #GDataInputStream.
 * @stop_chars: characters to terminate the read.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): callback to call when the request is satisfied.
 * @user_data: (closure): the data to pass to callback function.
 *
 * The asynchronous version of g_data_input_stream_read_until().
 * It is an error to have two outstanding calls to this function.
 *
 * Note that, in contrast to g_data_input_stream_read_until(),
 * this function does not consume the stop character that it finds.  You
 * must read it for yourself.
 *
 * When the operation is finished, @callback will be called. You
 * can then call g_data_input_stream_read_until_finish() to get
 * the result of the operation.
 *
 * Don't use this function in new code.  Its functionality is
 * inconsistent with g_data_input_stream_read_until().  Both functions
 * will be marked as deprecated in a future release.  Use
 * g_data_input_stream_read_upto_async() instead.
 *
 * Since: 2.20
 */


/**
 * g_data_input_stream_read_until_finish:
 * @stream: a given #GDataInputStream.
 * @result: the #GAsyncResult that was provided to the callback.
 * @length: (out): a #gsize to get the length of the data read in.
 * @error: #GError for error reporting.
 *
 * Finish an asynchronous call started by
 * g_data_input_stream_read_until_async().
 *
 *
 * before encountering any of the stop characters. Set @length to
 * a #gsize to get the length of the string. This function will
 * return %NULL on an error.
 *
 * Since: 2.20
 * Returns: (transfer full): a string with the data that was read
 */


/**
 * g_data_input_stream_read_upto:
 * @stream: a #GDataInputStream
 * @stop_chars: characters to terminate the read
 * @stop_chars_len: length of @stop_chars. May be -1 if @stop_chars is nul-terminated
 * @length: (out): a #gsize to get the length of the data read in
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @error: #GError for error reporting
 *
 * Reads a string from the data input stream, up to the first
 * occurrence of any of the stop characters.
 *
 * In contrast to g_data_input_stream_read_until(), this function
 * does <emphasis>not</emphasis> consume the stop character. You have
 * to use g_data_input_stream_read_byte() to get it before calling
 * g_data_input_stream_read_upto() again.
 *
 * Note that @stop_chars may contain '\0' if @stop_chars_len is
 * specified.
 *
 * before encountering any of the stop characters. Set @length to
 * a #gsize to get the length of the string. This function will
 * return %NULL on an error
 *
 * Returns: (transfer full): a string with the data that was read
 * Since: 2.26
 */


/**
 * g_data_input_stream_read_upto_async:
 * @stream: a #GDataInputStream
 * @stop_chars: characters to terminate the read
 * @stop_chars_len: length of @stop_chars. May be -1 if @stop_chars is nul-terminated
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @callback: (scope async): callback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * The asynchronous version of g_data_input_stream_read_upto().
 * It is an error to have two outstanding calls to this function.
 *
 * In contrast to g_data_input_stream_read_until(), this function
 * does <emphasis>not</emphasis> consume the stop character. You have
 * to use g_data_input_stream_read_byte() to get it before calling
 * g_data_input_stream_read_upto() again.
 *
 * Note that @stop_chars may contain '\0' if @stop_chars_len is
 * specified.
 *
 * When the operation is finished, @callback will be called. You
 * can then call g_data_input_stream_read_upto_finish() to get
 * the result of the operation.
 *
 * Since: 2.26
 */


/**
 * g_data_input_stream_read_upto_finish:
 * @stream: a #GDataInputStream
 * @result: the #GAsyncResult that was provided to the callback
 * @length: (out): a #gsize to get the length of the data read in
 * @error: #GError for error reporting
 *
 * Finish an asynchronous call started by
 * g_data_input_stream_read_upto_async().
 *
 * Note that this function does <emphasis>not</emphasis> consume the
 * stop character. You have to use g_data_input_stream_read_byte() to
 * get it before calling g_data_input_stream_read_upto_async() again.
 *
 * before encountering any of the stop characters. Set @length to
 * a #gsize to get the length of the string. This function will
 * return %NULL on an error.
 *
 * Returns: (transfer full): a string with the data that was read
 * Since: 2.24
 */


/**
 * g_data_input_stream_set_byte_order:
 * @stream: a given #GDataInputStream.
 * @order: a #GDataStreamByteOrder to set.
 *
 * This function sets the byte order for the given @stream. All subsequent
 * reads from the @stream will be read in the given @order.
 */


/**
 * g_data_input_stream_set_newline_type:
 * @stream: a #GDataInputStream.
 * @type: the type of new line return as #GDataStreamNewlineType.
 *
 * Sets the newline type for the @stream.
 *
 * Note that using G_DATA_STREAM_NEWLINE_TYPE_ANY is slightly unsafe. If a read
 * chunk ends in "CR" we must read an additional byte to know if this is "CR" or
 * "CR LF", and this might block if there is no more data available.
 */


/**
 * g_data_output_stream_get_byte_order:
 * @stream: a #GDataOutputStream.
 *
 * Gets the byte order for the stream.
 *
 * Returns: the #GDataStreamByteOrder for the @stream.
 */


/**
 * g_data_output_stream_new:
 * @base_stream: a #GOutputStream.
 *
 * Creates a new data output stream for @base_stream.
 *
 * Returns: #GDataOutputStream.
 */


/**
 * g_data_output_stream_put_byte:
 * @stream: a #GDataOutputStream.
 * @data: a #guchar.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts a byte into the output stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_int16:
 * @stream: a #GDataOutputStream.
 * @data: a #gint16.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts a signed 16-bit integer into the output stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_int32:
 * @stream: a #GDataOutputStream.
 * @data: a #gint32.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts a signed 32-bit integer into the output stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_int64:
 * @stream: a #GDataOutputStream.
 * @data: a #gint64.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts a signed 64-bit integer into the stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_string:
 * @stream: a #GDataOutputStream.
 * @str: a string.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts a string into the output stream.
 *
 * Returns: %TRUE if @string was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_uint16:
 * @stream: a #GDataOutputStream.
 * @data: a #guint16.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts an unsigned 16-bit integer into the output stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_uint32:
 * @stream: a #GDataOutputStream.
 * @data: a #guint32.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts an unsigned 32-bit integer into the stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_put_uint64:
 * @stream: a #GDataOutputStream.
 * @data: a #guint64.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Puts an unsigned 64-bit integer into the stream.
 *
 * Returns: %TRUE if @data was successfully added to the @stream.
 */


/**
 * g_data_output_stream_set_byte_order:
 * @stream: a #GDataOutputStream.
 * @order: a %GDataStreamByteOrder.
 *
 * Sets the byte order of the data output stream to @order.
 */


/**
 * g_dbus_action_group_get:
 * @connection: A #GDBusConnection
 * @bus_name: the bus name which exports the action group
 * @object_path: the object path at which the action group is exported
 *
 * Obtains a #GDBusActionGroup for the action group which is exported at
 * the given @bus_name and @object_path.
 *
 * The thread default main context is taken at the time of this call.
 * All signals on the menu model (and any linked models) are reported
 * with respect to this context.  All calls on the returned menu model
 * (and linked models) must also originate from this same context, with
 * the thread default main context unchanged.
 *
 * This call is non-blocking.  The returned action group may or may not
 * already be filled in.  The correct thing to do is connect the signals
 * for the action group to monitor for changes and then to call
 * g_action_group_list_actions() to get the initial list.
 *
 * Returns: (transfer full): a #GDBusActionGroup
 * Since: 2.32
 */


/**
 * g_dbus_address_get_for_bus_sync:
 * @bus_type: A #GBusType.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously looks up the D-Bus address for the well-known message
 * bus instance specified by @bus_type. This may involve using various
 * platform specific mechanisms.
 *
 * Returns: A valid D-Bus address string for @bus_type or %NULL if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_address_get_stream:
 * @address: A valid D-Bus address.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: Data to pass to @callback.
 *
 * Asynchronously connects to an endpoint specified by @address and
 * sets up the connection so it is in a state to run the client-side
 * of the D-Bus authentication conversation.
 *
 * When the operation is finished, @callback will be invoked. You can
 * then call g_dbus_address_get_stream_finish() to get the result of
 * the operation.
 *
 * This is an asynchronous failable function. See
 * g_dbus_address_get_stream_sync() for the synchronous version.
 *
 * Since: 2.26
 */


/**
 * g_dbus_address_get_stream_finish:
 * @res: A #GAsyncResult obtained from the GAsyncReadyCallback passed to g_dbus_address_get_stream().
 * @out_guid: %NULL or return location to store the GUID extracted from @address, if any.
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_address_get_stream().
 *
 * Returns: (transfer full): A #GIOStream or %NULL if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_address_get_stream_sync:
 * @address: A valid D-Bus address.
 * @out_guid: %NULL or return location to store the GUID extracted from @address, if any.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously connects to an endpoint specified by @address and
 * sets up the connection so it is in a state to run the client-side
 * of the D-Bus authentication conversation.
 *
 * This is a synchronous failable function. See
 * g_dbus_address_get_stream() for the asynchronous version.
 *
 * Returns: (transfer full): A #GIOStream or %NULL if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_annotation_info_lookup:
 * @annotations: A %NULL-terminated array of annotations or %NULL.
 * @name: The name of the annotation to look up.
 *
 * Looks up the value of an annotation.
 *
 * This cost of this function is O(n) in number of annotations.
 *
 * Returns: The value or %NULL if not found. Do not free, it is owned by @annotations.
 * Since: 2.26
 */


/**
 * g_dbus_annotation_info_ref:
 * @info: A #GDBusNodeInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_annotation_info_unref:
 * @info: A #GDBusAnnotationInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_arg_info_ref:
 * @info: A #GDBusArgInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_arg_info_unref:
 * @info: A #GDBusArgInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_auth_observer_authorize_authenticated_peer:
 * @observer: A #GDBusAuthObserver.
 * @stream: A #GIOStream for the #GDBusConnection.
 * @credentials: Credentials received from the peer or %NULL.
 *
 * Emits the #GDBusAuthObserver::authorize-authenticated-peer signal on @observer.
 *
 * Returns: %TRUE if the peer is authorized, %FALSE if not.
 * Since: 2.26
 */


/**
 * g_dbus_auth_observer_new:
 *
 * Creates a new #GDBusAuthObserver object.
 *
 * Returns: A #GDBusAuthObserver. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_add_filter:
 * @connection: A #GDBusConnection.
 * @filter_function: A filter function.
 * @user_data: User data to pass to @filter_function.
 * @user_data_free_func: Function to free @user_data with when filter is removed or %NULL.
 *
 * Adds a message filter. Filters are handlers that are run on all
 * incoming and outgoing messages, prior to standard dispatch. Filters
 * are run in the order that they were added.  The same handler can be
 * added as a filter more than once, in which case it will be run more
 * than once.  Filters added during a filter callback won't be run on
 * the message being processed. Filter functions are allowed to modify
 * and even drop messages.
 *
 * Note that filters are run in a dedicated message handling thread so
 * they can't block and, generally, can't do anything but signal a
 * worker thread. Also note that filters are rarely needed - use API
 * such as g_dbus_connection_send_message_with_reply(),
 * g_dbus_connection_signal_subscribe() or g_dbus_connection_call() instead.
 *
 * If a filter consumes an incoming message the message is not
 * dispatched anywhere else - not even the standard dispatch machinery
 * (that API such as g_dbus_connection_signal_subscribe() and
 * g_dbus_connection_send_message_with_reply() relies on) will see the
 * message. Similary, if a filter consumes an outgoing message, the
 * message will not be sent to the other peer.
 *
 * g_dbus_connection_remove_filter().
 *
 * Returns: A filter identifier that can be used with
 * Since: 2.26
 */


/**
 * g_dbus_connection_call:
 * @connection: A #GDBusConnection.
 * @bus_name: (allow-none): A unique or well-known bus name or %NULL if @connection is not a message bus connection.
 * @object_path: Path of remote object.
 * @interface_name: D-Bus interface to invoke method on.
 * @method_name: The name of the method to invoke.
 * @parameters: (allow-none): A #GVariant tuple with parameters for the method or %NULL if not passing parameters.
 * @reply_type: (allow-none): The expected type of the reply, or %NULL.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds, -1 to use the default timeout or %G_MAXINT for no timeout.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: (allow-none): A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: The data to pass to @callback.
 *
 * Asynchronously invokes the @method_name method on the
 * @interface_name D-Bus interface on the remote object at
 * @object_path owned by @bus_name.
 *
 * If @connection is closed then the operation will fail with
 * %G_IO_ERROR_CLOSED. If @cancellable is canceled, the operation will
 * fail with %G_IO_ERROR_CANCELLED. If @parameters contains a value
 * not compatible with the D-Bus protocol, the operation fails with
 * %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * If @reply_type is non-%NULL then the reply will be checked for having this type and an
 * error will be raised if it does not match.  Said another way, if you give a @reply_type
 * then any non-%NULL return value will be of this type.
 *
 * If the @parameters #GVariant is floating, it is consumed. This allows
 * convenient 'inline' use of g_variant_new(), e.g.:
 * |[
 * g_dbus_connection_call (connection,
 * "org.freedesktop.StringThings",
 * "/org/freedesktop/StringThings",
 * "org.freedesktop.StringThings",
 * "TwoStrings",
 * g_variant_new ("(ss)",
 * "Thing One",
 * "Thing Two"),
 * NULL,
 * G_DBUS_CALL_FLAGS_NONE,
 * -1,
 * NULL,
 * (GAsyncReadyCallback) two_strings_done,
 * NULL);
 * ]|
 *
 * This is an asynchronous method. When the operation is finished, @callback will be invoked
 * in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link>
 * of the thread you are calling this method from. You can then call
 * g_dbus_connection_call_finish() to get the result of the operation.
 * See g_dbus_connection_call_sync() for the synchronous version of this
 * function.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_call_finish:
 * @connection: A #GDBusConnection.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_connection_call().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_connection_call().
 *
 * return values. Free with g_variant_unref().
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * Since: 2.26
 */


/**
 * g_dbus_connection_call_sync:
 * @connection: A #GDBusConnection.
 * @bus_name: A unique or well-known bus name.
 * @object_path: Path of remote object.
 * @interface_name: D-Bus interface to invoke method on.
 * @method_name: The name of the method to invoke.
 * @parameters: (allow-none): A #GVariant tuple with parameters for the method or %NULL if not passing parameters.
 * @reply_type: (allow-none): The expected type of the reply, or %NULL.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds, -1 to use the default timeout or %G_MAXINT for no timeout.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the @method_name method on the
 * @interface_name D-Bus interface on the remote object at
 * @object_path owned by @bus_name.
 *
 * If @connection is closed then the operation will fail with
 * %G_IO_ERROR_CLOSED. If @cancellable is canceled, the
 * operation will fail with %G_IO_ERROR_CANCELLED. If @parameters
 * contains a value not compatible with the D-Bus protocol, the operation
 * fails with %G_IO_ERROR_INVALID_ARGUMENT.
 * If @reply_type is non-%NULL then the reply will be checked for having
 * this type and an error will be raised if it does not match.  Said
 * another way, if you give a @reply_type then any non-%NULL return
 * value will be of this type.
 *
 * If the @parameters #GVariant is floating, it is consumed.
 * This allows convenient 'inline' use of g_variant_new(), e.g.:
 * |[
 * g_dbus_connection_call_sync (connection,
 * "org.freedesktop.StringThings",
 * "/org/freedesktop/StringThings",
 * "org.freedesktop.StringThings",
 * "TwoStrings",
 * g_variant_new ("(ss)",
 * "Thing One",
 * "Thing Two"),
 * NULL,
 * G_DBUS_CALL_FLAGS_NONE,
 * -1,
 * NULL,
 * &amp;error);
 * ]|
 *
 * The calling thread is blocked until a reply is received. See
 * g_dbus_connection_call() for the asynchronous version of
 * this method.
 *
 * return values. Free with g_variant_unref().
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * Since: 2.26
 */


/**
 * g_dbus_connection_call_with_unix_fd_list:
 * @connection: A #GDBusConnection.
 * @bus_name: (allow-none): A unique or well-known bus name or %NULL if @connection is not a message bus connection.
 * @object_path: Path of remote object.
 * @interface_name: D-Bus interface to invoke method on.
 * @method_name: The name of the method to invoke.
 * @parameters: (allow-none): A #GVariant tuple with parameters for the method or %NULL if not passing parameters.
 * @reply_type: (allow-none): The expected type of the reply, or %NULL.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds, -1 to use the default timeout or %G_MAXINT for no timeout.
 * @fd_list: (allow-none): A #GUnixFDList or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: (allow-none): A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't * care about the result of the method invocation.
 * @user_data: The data to pass to @callback.
 *
 * Like g_dbus_connection_call() but also takes a #GUnixFDList object.
 *
 * This method is only available on UNIX.
 *
 * Since: 2.30
 */


/**
 * g_dbus_connection_call_with_unix_fd_list_finish:
 * @connection: A #GDBusConnection.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_connection_call_with_unix_fd_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_connection_call_with_unix_fd_list().
 *
 * return values. Free with g_variant_unref().
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * Since: 2.30
 */


/**
 * g_dbus_connection_call_with_unix_fd_list_sync:
 * @connection: A #GDBusConnection.
 * @bus_name: A unique or well-known bus name.
 * @object_path: Path of remote object.
 * @interface_name: D-Bus interface to invoke method on.
 * @method_name: The name of the method to invoke.
 * @parameters: (allow-none): A #GVariant tuple with parameters for the method or %NULL if not passing parameters.
 * @reply_type: (allow-none): The expected type of the reply, or %NULL.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds, -1 to use the default timeout or %G_MAXINT for no timeout.
 * @fd_list: (allow-none): A #GUnixFDList or %NULL.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_connection_call_sync() but also takes and returns #GUnixFDList objects.
 *
 * This method is only available on UNIX.
 *
 * return values. Free with g_variant_unref().
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * Since: 2.30
 */


/**
 * g_dbus_connection_close:
 * @connection: A #GDBusConnection.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: (allow-none): A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result.
 * @user_data: The data to pass to @callback.
 *
 * Closes @connection. Note that this never causes the process to
 * exit (this might only happen if the other end of a shared message
 * bus connection disconnects, see #GDBusConnection:exit-on-close).
 *
 * Once the connection is closed, operations such as sending a message
 * will return with the error %G_IO_ERROR_CLOSED. Closing a connection
 * will not automatically flush the connection so queued messages may
 * be lost. Use g_dbus_connection_flush() if you need such guarantees.
 *
 * If @connection is already closed, this method fails with
 * %G_IO_ERROR_CLOSED.
 *
 * When @connection has been closed, the #GDBusConnection::closed
 * signal is emitted in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * loop</link> of the thread that @connection was constructed in.
 *
 * This is an asynchronous method. When the operation is finished,
 * @callback will be invoked in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * loop</link> of the thread you are calling this method from. You can
 * then call g_dbus_connection_close_finish() to get the result of the
 * operation.  See g_dbus_connection_close_sync() for the synchronous
 * version.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_close_finish:
 * @connection: A #GDBusConnection.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_connection_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_connection_close().
 *
 * Returns: %TRUE if the operation succeeded, %FALSE if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_connection_close_sync:
 * @connection: A #GDBusConnection.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously closees @connection. The calling thread is blocked
 * until this is done. See g_dbus_connection_close() for the
 * asynchronous version of this method and more details about what it
 * does.
 *
 * Returns: %TRUE if the operation succeeded, %FALSE if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_connection_emit_signal:
 * @connection: A #GDBusConnection.
 * @destination_bus_name: (allow-none): The unique bus name for the destination for the signal or %NULL to emit to all listeners.
 * @object_path: Path of remote object.
 * @interface_name: D-Bus interface to emit a signal on.
 * @signal_name: The name of the signal to emit.
 * @parameters: (allow-none): A #GVariant tuple with parameters for the signal or %NULL if not passing parameters.
 * @error: Return location for error or %NULL.
 *
 * Emits a signal.
 *
 * If the parameters GVariant is floating, it is consumed.
 *
 * This can only fail if @parameters is not compatible with the D-Bus protocol.
 *
 * Returns: %TRUE unless @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_connection_export_action_group:
 * @connection: a #GDBusConnection
 * @object_path: a D-Bus object path
 * @action_group: a #GActionGroup
 * @error: a pointer to a %NULL #GError, or %NULL
 *
 * Exports @action_group on @connection at @object_path.
 *
 * The implemented D-Bus API should be considered private.  It is
 * subject to change in the future.
 *
 * A given object path can only have one action group exported on it.
 * If this constraint is violated, the export will fail and 0 will be
 * returned (with @error set accordingly).
 *
 * You can unexport the action group using
 * g_dbus_connection_unexport_action_group() with the return value of
 * this function.
 *
 * The thread default main context is taken at the time of this call.
 * All incoming action activations and state change requests are
 * reported from this context.  Any changes on the action group that
 * cause it to emit signals must also come from this same context.
 * Since incoming action activations and state change requests are
 * rather likely to cause changes on the action group, this effectively
 * limits a given action group to being exported from only one main
 * context.
 *
 * Returns: the ID of the export (never zero), or 0 in case of failure
 * Since: 2.32
 */


/**
 * g_dbus_connection_export_menu_model:
 * @connection: a #GDBusConnection
 * @object_path: a D-Bus object path
 * @menu: a #GMenuModel
 * @error: return location for an error, or %NULL
 *
 * Exports @menu on @connection at @object_path.
 *
 * The implemented D-Bus API should be considered private.
 * It is subject to change in the future.
 *
 * An object path can only have one action group exported on it. If this
 * constraint is violated, the export will fail and 0 will be
 * returned (with @error set accordingly).
 *
 * You can unexport the menu model using
 * g_dbus_connection_unexport_menu_model() with the return value of
 * this function.
 *
 * Returns: the ID of the export (never zero), or 0 in case of failure
 * Since: 2.32
 */


/**
 * g_dbus_connection_flush:
 * @connection: A #GDBusConnection.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: (allow-none): A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result.
 * @user_data: The data to pass to @callback.
 *
 * Asynchronously flushes @connection, that is, writes all queued
 * outgoing message to the transport and then flushes the transport
 * (using g_output_stream_flush_async()). This is useful in programs
 * that wants to emit a D-Bus signal and then exit
 * immediately. Without flushing the connection, there is no guarantee
 * that the message has been sent to the networking buffers in the OS
 * kernel.
 *
 * This is an asynchronous method. When the operation is finished,
 * @callback will be invoked in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * loop</link> of the thread you are calling this method from. You can
 * then call g_dbus_connection_flush_finish() to get the result of the
 * operation.  See g_dbus_connection_flush_sync() for the synchronous
 * version.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_flush_finish:
 * @connection: A #GDBusConnection.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_connection_flush().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_connection_flush().
 *
 * Returns: %TRUE if the operation succeeded, %FALSE if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_connection_flush_sync:
 * @connection: A #GDBusConnection.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously flushes @connection. The calling thread is blocked
 * until this is done. See g_dbus_connection_flush() for the
 * asynchronous version of this method and more details about what it
 * does.
 *
 * Returns: %TRUE if the operation succeeded, %FALSE if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_capabilities:
 * @connection: A #GDBusConnection.
 *
 * Gets the capabilities negotiated with the remote peer
 *
 * Returns: Zero or more flags from the #GDBusCapabilityFlags enumeration.
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_exit_on_close:
 * @connection: A #GDBusConnection.
 *
 * Gets whether the process is terminated when @connection is
 * closed by the remote peer. See
 * #GDBusConnection:exit-on-close for more details.
 *
 * closed by the remote peer.
 *
 * Returns: Whether the process is terminated when @connection is
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_guid:
 * @connection: A #GDBusConnection.
 *
 * The GUID of the peer performing the role of server when
 * authenticating. See #GDBusConnection:guid for more details.
 *
 * @connection.
 *
 * Returns: The GUID. Do not free this string, it is owned by
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_peer_credentials:
 * @connection: A #GDBusConnection.
 *
 * Gets the credentials of the authenticated peer. This will always
 * return %NULL unless @connection acted as a server
 * (e.g. %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER was passed)
 * when set up and the client passed credentials as part of the
 * authentication process.
 *
 * In a message bus setup, the message bus is always the server and
 * each application is a client. So this method will always return
 * %NULL for message bus clients.
 *
 * this object, it is owned by @connection.
 *
 * Returns: (transfer none): A #GCredentials or %NULL if not available. Do not free
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_stream:
 * @connection: a #GDBusConnection
 *
 * Gets the underlying stream used for IO.
 *
 * While the #GDBusConnection is active, it will interact with this
 * stream from a worker thread, so it is not safe to interact with
 * the stream directly.
 *
 * Returns: (transfer none): the stream used for IO
 * Since: 2.26
 */


/**
 * g_dbus_connection_get_unique_name:
 * @connection: A #GDBusConnection.
 *
 * Gets the unique name of @connection as assigned by the message
 * bus. This can also be used to figure out if @connection is a
 * message bus connection.
 *
 * bus connection. Do not free this string, it is owned by
 * @connection.
 *
 * Returns: The unique name or %NULL if @connection is not a message
 * Since: 2.26
 */


/**
 * g_dbus_connection_is_closed:
 * @connection: A #GDBusConnection.
 *
 * Gets whether @connection is closed.
 *
 * Returns: %TRUE if the connection is closed, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_connection_new:
 * @stream: A #GIOStream.
 * @guid: (allow-none): The GUID to use if a authenticating as a server or %NULL.
 * @flags: Flags describing how to make the connection.
 * @observer: (allow-none): A #GDBusAuthObserver or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: The data to pass to @callback.
 *
 * Asynchronously sets up a D-Bus connection for exchanging D-Bus messages
 * with the end represented by @stream.
 *
 * If @stream is a #GSocketConnection, then the corresponding #GSocket
 * will be put into non-blocking mode.
 *
 * The D-Bus connection will interact with @stream from a worker thread.
 * As a result, the caller should not interact with @stream after this
 * method has been called, except by calling g_object_unref() on it.
 *
 * If @observer is not %NULL it may be used to control the
 * authentication process.
 *
 * When the operation is finished, @callback will be invoked. You can
 * then call g_dbus_connection_new_finish() to get the result of the
 * operation.
 *
 * This is a asynchronous failable constructor. See
 * g_dbus_connection_new_sync() for the synchronous
 * version.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_new_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_connection_new().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_connection_new().
 *
 * Returns: A #GDBusConnection or %NULL if @error is set. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_new_for_address:
 * @address: A D-Bus address.
 * @flags: Flags describing how to make the connection.
 * @observer: (allow-none): A #GDBusAuthObserver or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: The data to pass to @callback.
 *
 * Asynchronously connects and sets up a D-Bus client connection for
 * exchanging D-Bus messages with an endpoint specified by @address
 * which must be in the D-Bus address format.
 *
 * This constructor can only be used to initiate client-side
 * connections - use g_dbus_connection_new() if you need to act as the
 * server. In particular, @flags cannot contain the
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER or
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS flags.
 *
 * When the operation is finished, @callback will be invoked. You can
 * then call g_dbus_connection_new_finish() to get the result of the
 * operation.
 *
 * If @observer is not %NULL it may be used to control the
 * authentication process.
 *
 * This is a asynchronous failable constructor. See
 * g_dbus_connection_new_for_address_sync() for the synchronous
 * version.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_new_for_address_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_connection_new().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_connection_new_for_address().
 *
 * Returns: A #GDBusConnection or %NULL if @error is set. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_new_for_address_sync:
 * @address: A D-Bus address.
 * @flags: Flags describing how to make the connection.
 * @observer: (allow-none): A #GDBusAuthObserver or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously connects and sets up a D-Bus client connection for
 * exchanging D-Bus messages with an endpoint specified by @address
 * which must be in the D-Bus address format.
 *
 * This constructor can only be used to initiate client-side
 * connections - use g_dbus_connection_new_sync() if you need to act
 * as the server. In particular, @flags cannot contain the
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER or
 * %G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS flags.
 *
 * This is a synchronous failable constructor. See
 * g_dbus_connection_new_for_address() for the asynchronous version.
 *
 * If @observer is not %NULL it may be used to control the
 * authentication process.
 *
 * Returns: A #GDBusConnection or %NULL if @error is set. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_new_sync:
 * @stream: A #GIOStream.
 * @guid: (allow-none): The GUID to use if a authenticating as a server or %NULL.
 * @flags: Flags describing how to make the connection.
 * @observer: (allow-none): A #GDBusAuthObserver or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously sets up a D-Bus connection for exchanging D-Bus messages
 * with the end represented by @stream.
 *
 * If @stream is a #GSocketConnection, then the corresponding #GSocket
 * will be put into non-blocking mode.
 *
 * The D-Bus connection will interact with @stream from a worker thread.
 * As a result, the caller should not interact with @stream after this
 * method has been called, except by calling g_object_unref() on it.
 *
 * If @observer is not %NULL it may be used to control the
 * authentication process.
 *
 * This is a synchronous failable constructor. See
 * g_dbus_connection_new() for the asynchronous version.
 *
 * Returns: A #GDBusConnection or %NULL if @error is set. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_connection_register_object:
 * @connection: A #GDBusConnection.
 * @object_path: The object path to register at.
 * @interface_info: Introspection data for the interface.
 * @vtable: (allow-none): A #GDBusInterfaceVTable to call into or %NULL.
 * @user_data: (allow-none): Data to pass to functions in @vtable.
 * @user_data_free_func: Function to call when the object path is unregistered.
 * @error: Return location for error or %NULL.
 *
 * Registers callbacks for exported objects at @object_path with the
 * D-Bus interface that is described in @interface_info.
 *
 * Calls to functions in @vtable (and @user_data_free_func) will
 * happen in the <link linkend="g-main-context-push-thread-default">thread-default main
 * loop</link> of the thread you are calling this method from.
 *
 * Note that all #GVariant values passed to functions in @vtable will match
 * the signature given in @interface_info - if a remote caller passes
 * incorrect values, the <literal>org.freedesktop.DBus.Error.InvalidArgs</literal>
 * is returned to the remote caller.
 *
 * Additionally, if the remote caller attempts to invoke methods or
 * access properties not mentioned in @interface_info the
 * <literal>org.freedesktop.DBus.Error.UnknownMethod</literal> resp.
 * <literal>org.freedesktop.DBus.Error.InvalidArgs</literal> errors
 * are returned to the caller.
 *
 * It is considered a programming error if the
 * #GDBusInterfaceGetPropertyFunc function in @vtable returns a
 * #GVariant of incorrect type.
 *
 * If an existing callback is already registered at @object_path and
 * @interface_name, then @error is set to #G_IO_ERROR_EXISTS.
 *
 * GDBus automatically implements the standard D-Bus interfaces
 * org.freedesktop.DBus.Properties, org.freedesktop.DBus.Introspectable
 * and org.freedesktop.Peer, so you don't have to implement those for
 * the objects you export. You <emphasis>can</emphasis> implement
 * org.freedesktop.DBus.Properties yourself, e.g. to handle getting
 * and setting of properties asynchronously.
 *
 * Note that the reference count on @interface_info will be
 * incremented by 1 (unless allocated statically, e.g. if the
 * reference count is -1, see g_dbus_interface_info_ref()) for as long
 * as the object is exported. Also note that @vtable will be copied.
 *
 * See <xref linkend="gdbus-server"/> for an example of how to use this method.
 *
 * that can be used with g_dbus_connection_unregister_object() .
 *
 * Returns: 0 if @error is set, otherwise a registration id (never 0)
 * Since: 2.26
 */


/**
 * g_dbus_connection_register_subtree:
 * @connection: A #GDBusConnection.
 * @object_path: The object path to register the subtree at.
 * @vtable: A #GDBusSubtreeVTable to enumerate, introspect and dispatch nodes in the subtree.
 * @flags: Flags used to fine tune the behavior of the subtree.
 * @user_data: Data to pass to functions in @vtable.
 * @user_data_free_func: Function to call when the subtree is unregistered.
 * @error: Return location for error or %NULL.
 *
 * Registers a whole subtree of <quote>dynamic</quote> objects.
 *
 * The @enumerate and @introspection functions in @vtable are used to
 * convey, to remote callers, what nodes exist in the subtree rooted
 * by @object_path.
 *
 * When handling remote calls into any node in the subtree, first the
 * @enumerate function is used to check if the node exists. If the node exists
 * or the #G_DBUS_SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES flag is set
 * the @introspection function is used to check if the node supports the
 * requested method. If so, the @dispatch function is used to determine
 * where to dispatch the call. The collected #GDBusInterfaceVTable and
 * #gpointer will be used to call into the interface vtable for processing
 * the request.
 *
 * All calls into user-provided code will be invoked in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * loop</link> of the thread you are calling this method from.
 *
 * If an existing subtree is already registered at @object_path or
 * then @error is set to #G_IO_ERROR_EXISTS.
 *
 * Note that it is valid to register regular objects (using
 * g_dbus_connection_register_object()) in a subtree registered with
 * g_dbus_connection_register_subtree() - if so, the subtree handler
 * is tried as the last resort. One way to think about a subtree
 * handler is to consider it a <quote>fallback handler</quote>
 * for object paths not registered via g_dbus_connection_register_object()
 * or other bindings.
 *
 * Note that @vtable will be copied so you cannot change it after
 * registration.
 *
 * See <xref linkend="gdbus-subtree-server"/> for an example of how to use this method.
 *
 * that can be used with g_dbus_connection_unregister_subtree() .
 *
 * Returns: 0 if @error is set, otherwise a subtree registration id (never 0)
 * Since: 2.26
 */


/**
 * g_dbus_connection_remove_filter:
 * @connection: a #GDBusConnection
 * @filter_id: an identifier obtained from g_dbus_connection_add_filter()
 *
 * Removes a filter.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_send_message:
 * @connection: A #GDBusConnection.
 * @message: A #GDBusMessage
 * @flags: Flags affecting how the message is sent.
 * @out_serial: (out) (allow-none): Return location for serial number assigned to @message when sending it or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Asynchronously sends @message to the peer represented by @connection.
 *
 * Unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
 * will be assigned by @connection and set on @message via
 * g_dbus_message_set_serial(). If @out_serial is not %NULL, then the
 * serial number used will be written to this location prior to
 * submitting the message to the underlying transport.
 *
 * If @connection is closed then the operation will fail with
 * %G_IO_ERROR_CLOSED. If @message is not well-formed,
 * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * See <xref linkend="gdbus-server"/> and <xref
 * linkend="gdbus-unix-fd-client"/> for an example of how to use this
 * low-level API to send and receive UNIX file descriptors.
 *
 * Note that @message must be unlocked, unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
 *
 * transmission, %FALSE if @error is set.
 *
 * Returns: %TRUE if the message was well-formed and queued for
 * Since: 2.26
 */


/**
 * g_dbus_connection_send_message_with_reply:
 * @connection: A #GDBusConnection.
 * @message: A #GDBusMessage.
 * @flags: Flags affecting how the message is sent.
 * @timeout_msec: The timeout in milliseconds, -1 to use the default timeout or %G_MAXINT for no timeout.
 * @out_serial: (out) (allow-none): Return location for serial number assigned to @message when sending it or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: (allow-none): A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result.
 * @user_data: The data to pass to @callback.
 *
 * Asynchronously sends @message to the peer represented by @connection.
 *
 * Unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
 * will be assigned by @connection and set on @message via
 * g_dbus_message_set_serial(). If @out_serial is not %NULL, then the
 * serial number used will be written to this location prior to
 * submitting the message to the underlying transport.
 *
 * If @connection is closed then the operation will fail with
 * %G_IO_ERROR_CLOSED. If @cancellable is canceled, the operation will
 * fail with %G_IO_ERROR_CANCELLED. If @message is not well-formed,
 * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * This is an asynchronous method. When the operation is finished, @callback will be invoked
 * in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link>
 * of the thread you are calling this method from. You can then call
 * g_dbus_connection_send_message_with_reply_finish() to get the result of the operation.
 * See g_dbus_connection_send_message_with_reply_sync() for the synchronous version.
 *
 * Note that @message must be unlocked, unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
 *
 * See <xref linkend="gdbus-server"/> and <xref
 * linkend="gdbus-unix-fd-client"/> for an example of how to use this
 * low-level API to send and receive UNIX file descriptors.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_send_message_with_reply_finish:
 * @connection: a #GDBusConnection
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_connection_send_message_with_reply().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_connection_send_message_with_reply().
 *
 * Note that @error is only set if a local in-process error
 * occurred. That is to say that the returned #GDBusMessage object may
 * be of type %G_DBUS_MESSAGE_TYPE_ERROR. Use
 * g_dbus_message_to_gerror() to transcode this to a #GError.
 *
 * See <xref linkend="gdbus-server"/> and <xref
 * linkend="gdbus-unix-fd-client"/> for an example of how to use this
 * low-level API to send and receive UNIX file descriptors.
 *
 * Returns: (transfer full): A locked #GDBusMessage or %NULL if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_connection_send_message_with_reply_sync:
 * @connection: A #GDBusConnection.
 * @message: A #GDBusMessage.
 * @flags: Flags affecting how the message is sent.
 * @timeout_msec: The timeout in milliseconds, -1 to use the default timeout or %G_MAXINT for no timeout.
 * @out_serial: (out) (allow-none): Return location for serial number assigned to @message when sending it or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously sends @message to the peer represented by @connection
 * and blocks the calling thread until a reply is received or the
 * timeout is reached. See g_dbus_connection_send_message_with_reply()
 * for the asynchronous version of this method.
 *
 * Unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag, the serial number
 * will be assigned by @connection and set on @message via
 * g_dbus_message_set_serial(). If @out_serial is not %NULL, then the
 * serial number used will be written to this location prior to
 * submitting the message to the underlying transport.
 *
 * If @connection is closed then the operation will fail with
 * %G_IO_ERROR_CLOSED. If @cancellable is canceled, the operation will
 * fail with %G_IO_ERROR_CANCELLED. If @message is not well-formed,
 * the operation fails with %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * Note that @error is only set if a local in-process error
 * occurred. That is to say that the returned #GDBusMessage object may
 * be of type %G_DBUS_MESSAGE_TYPE_ERROR. Use
 * g_dbus_message_to_gerror() to transcode this to a #GError.
 *
 * See <xref linkend="gdbus-server"/> and <xref
 * linkend="gdbus-unix-fd-client"/> for an example of how to use this
 * low-level API to send and receive UNIX file descriptors.
 *
 * Note that @message must be unlocked, unless @flags contain the
 * %G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL flag.
 *
 * Returns: (transfer full): A locked #GDBusMessage that is the reply to @message or %NULL if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_connection_set_exit_on_close:
 * @connection: A #GDBusConnection.
 * @exit_on_close: Whether the process should be terminated when @connection is closed by the remote peer.
 *
 * Sets whether the process should be terminated when @connection is
 * closed by the remote peer. See #GDBusConnection:exit-on-close for
 * more details.
 *
 * Note that this function should be used with care. Most modern UNIX
 * desktops tie the notion of a user session the session bus, and expect
 * all of a users applications to quit when their bus connection goes away.
 * If you are setting @exit_on_close to %FALSE for the shared session
 * bus connection, you should make sure that your application exits
 * when the user session ends.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_signal_subscribe:
 * @connection: A #GDBusConnection.
 * @sender: (allow-none): Sender name to match on (unique or well-known name) or %NULL to listen from all senders.
 * @interface_name: (allow-none): D-Bus interface name to match on or %NULL to match on all interfaces.
 * @member: (allow-none): D-Bus signal name to match on or %NULL to match on all signals.
 * @object_path: (allow-none): Object path to match on or %NULL to match on all object paths.
 * @arg0: (allow-none): Contents of first string argument to match on or %NULL to match on all kinds of arguments.
 * @flags: Flags describing how to subscribe to the signal (currently unused).
 * @callback: Callback to invoke when there is a signal matching the requested data.
 * @user_data: User data to pass to @callback.
 * @user_data_free_func: (allow-none): Function to free @user_data with when subscription is removed or %NULL.
 *
 * Subscribes to signals on @connection and invokes @callback with a
 * whenever the signal is received. Note that @callback
 * will be invoked in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * loop</link> of the thread you are calling this method from.
 *
 * If @connection is not a message bus connection, @sender must be
 * %NULL.
 *
 * If @sender is a well-known name note that @callback is invoked with
 * the unique name for the owner of @sender, not the well-known name
 * as one would expect. This is because the message bus rewrites the
 * name. As such, to avoid certain race conditions, users should be
 * tracking the name owner of the well-known name and use that when
 * processing the received signal.
 *
 * Returns: A subscription identifier that can be used with g_dbus_connection_signal_unsubscribe().
 * Since: 2.26
 */


/**
 * g_dbus_connection_signal_unsubscribe:
 * @connection: A #GDBusConnection.
 * @subscription_id: A subscription id obtained from g_dbus_connection_signal_subscribe().
 *
 * Unsubscribes from signals.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_start_message_processing:
 * @connection: A #GDBusConnection.
 *
 * If @connection was created with
 * %G_DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING, this method
 * starts processing messages. Does nothing on if @connection wasn't
 * created with this flag or if the method has already been called.
 *
 * Since: 2.26
 */


/**
 * g_dbus_connection_unexport_action_group:
 * @connection: a #GDBusConnection
 * @export_id: the ID from g_dbus_connection_export_action_group()
 *
 * Reverses the effect of a previous call to
 * g_dbus_connection_export_action_group().
 *
 * It is an error to call this function with an ID that wasn't returned
 * from g_dbus_connection_export_action_group() or to call it with the
 * same ID more than once.
 *
 * Since: 2.32
 */


/**
 * g_dbus_connection_unexport_menu_model:
 * @connection: a #GDBusConnection
 * @export_id: the ID from g_dbus_connection_export_menu_model()
 *
 * Reverses the effect of a previous call to
 * g_dbus_connection_export_menu_model().
 *
 * It is an error to call this function with an ID that wasn't returned
 * from g_dbus_connection_export_menu_model() or to call it with the
 * same ID more than once.
 *
 * Since: 2.32
 */


/**
 * g_dbus_connection_unregister_object:
 * @connection: A #GDBusConnection.
 * @registration_id: A registration id obtained from g_dbus_connection_register_object().
 *
 * Unregisters an object.
 *
 * Returns: %TRUE if the object was unregistered, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_connection_unregister_subtree:
 * @connection: A #GDBusConnection.
 * @registration_id: A subtree registration id obtained from g_dbus_connection_register_subtree().
 *
 * Unregisters a subtree.
 *
 * Returns: %TRUE if the subtree was unregistered, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_error_encode_gerror:
 * @error: A #GError.
 *
 * Creates a D-Bus error name to use for @error. If @error matches
 * a registered error (cf. g_dbus_error_register_error()), the corresponding
 * D-Bus error name will be returned.
 *
 * Otherwise the a name of the form
 * <literal>org.gtk.GDBus.UnmappedGError.Quark._ESCAPED_QUARK_NAME.Code_ERROR_CODE</literal>
 * will be used. This allows other GDBus applications to map the error
 * on the wire back to a #GError using g_dbus_error_new_for_dbus_error().
 *
 * This function is typically only used in object mappings to put a
 * #GError on the wire. Regular applications should not use it.
 *
 * Returns: A D-Bus error name (never %NULL). Free with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_error_get_remote_error:
 * @error: A #GError.
 *
 * Gets the D-Bus error name used for @error, if any.
 *
 * This function is guaranteed to return a D-Bus error name for all
 * #GError<!-- -->s returned from functions handling remote method
 * calls (e.g. g_dbus_connection_call_finish()) unless
 * g_dbus_error_strip_remote_error() has been used on @error.
 *
 * Returns: An allocated string or %NULL if the D-Bus error name could not be found. Free with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_error_is_remote_error:
 * @error: A #GError.
 *
 * Checks if @error represents an error received via D-Bus from a remote peer. If so,
 * use g_dbus_error_get_remote_error() to get the name of the error.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if @error represents an error from a remote peer,
 * Since: 2.26
 */


/**
 * g_dbus_error_new_for_dbus_error:
 * @dbus_error_name: D-Bus error name.
 * @dbus_error_message: D-Bus error message.
 *
 * Creates a #GError based on the contents of @dbus_error_name and
 * @dbus_error_message.
 *
 * Errors registered with g_dbus_error_register_error() will be looked
 * up using @dbus_error_name and if a match is found, the error domain
 * and code is used. Applications can use g_dbus_error_get_remote_error()
 * to recover @dbus_error_name.
 *
 * If a match against a registered error is not found and the D-Bus
 * error name is in a form as returned by g_dbus_error_encode_gerror()
 * the error domain and code encoded in the name is used to
 * create the #GError. Also, @dbus_error_name is added to the error message
 * such that it can be recovered with g_dbus_error_get_remote_error().
 *
 * Otherwise, a #GError with the error code %G_IO_ERROR_DBUS_ERROR
 * in the #G_IO_ERROR error domain is returned. Also, @dbus_error_name is
 * added to the error message such that it can be recovered with
 * g_dbus_error_get_remote_error().
 *
 * In all three cases, @dbus_error_name can always be recovered from the
 * returned #GError using the g_dbus_error_get_remote_error() function
 * (unless g_dbus_error_strip_remote_error() hasn't been used on the returned error).
 *
 * This function is typically only used in object mappings to prepare
 * #GError instances for applications. Regular applications should not use
 * it.
 *
 * Returns: An allocated #GError. Free with g_error_free().
 * Since: 2.26
 */


/**
 * g_dbus_error_register_error:
 * @error_domain: A #GQuark for a error domain.
 * @error_code: An error code.
 * @dbus_error_name: A D-Bus error name.
 *
 * Creates an association to map between @dbus_error_name and
 * #GError<!-- -->s specified by @error_domain and @error_code.
 *
 * This is typically done in the routine that returns the #GQuark for
 * an error domain.
 *
 * exists.
 *
 * Returns: %TRUE if the association was created, %FALSE if it already
 * Since: 2.26
 */


/**
 * g_dbus_error_register_error_domain:
 * @error_domain_quark_name: The error domain name.
 * @quark_volatile: A pointer where to store the #GQuark.
 * @entries: A pointer to @num_entries #GDBusErrorEntry struct items.
 * @num_entries: Number of items to register.
 *
 * Helper function for associating a #GError error domain with D-Bus error names.
 *
 * Since: 2.26
 */


/**
 * g_dbus_error_set_dbus_error:
 * @error: A pointer to a #GError or %NULL.
 * @dbus_error_name: D-Bus error name.
 * @dbus_error_message: D-Bus error message.
 * @format: printf()-style format to prepend to @dbus_error_message or %NULL.
 * @...: Arguments for @format.
 *
 * Does nothing if @error is %NULL. Otherwise sets *@error to
 * a new #GError created with g_dbus_error_new_for_dbus_error()
 * with @dbus_error_message prepend with @format (unless %NULL).
 *
 * Since: 2.26
 */


/**
 * g_dbus_error_set_dbus_error_valist:
 * @error: A pointer to a #GError or %NULL.
 * @dbus_error_name: D-Bus error name.
 * @dbus_error_message: D-Bus error message.
 * @format: printf()-style format to prepend to @dbus_error_message or %NULL.
 * @var_args: Arguments for @format.
 *
 * Like g_dbus_error_set_dbus_error() but intended for language bindings.
 *
 * Since: 2.26
 */


/**
 * g_dbus_error_strip_remote_error:
 * @error: A #GError.
 *
 * Looks for extra information in the error message used to recover
 * the D-Bus error name and strips it if found. If stripped, the
 * message field in @error will correspond exactly to what was
 * received on the wire.
 *
 * This is typically used when presenting errors to the end user.
 *
 * Returns: %TRUE if information was stripped, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_error_unregister_error:
 * @error_domain: A #GQuark for a error domain.
 * @error_code: An error code.
 * @dbus_error_name: A D-Bus error name.
 *
 * Destroys an association previously set up with g_dbus_error_register_error().
 *
 * Returns: %TRUE if the association was destroyed, %FALSE if it wasn't found.
 * Since: 2.26
 */


/**
 * g_dbus_generate_guid:
 *
 * Generate a D-Bus GUID that can be used with
 * e.g. g_dbus_connection_new().
 *
 * See the D-Bus specification regarding what strings are valid D-Bus
 * GUID (for example, D-Bus GUIDs are not RFC-4122 compliant).
 *
 * Returns: A valid D-Bus GUID. Free with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_gvalue_to_gvariant:
 * @gvalue: A #GValue to convert to a #GVariant.
 * @type: A #GVariantType.
 *
 * Converts a #GValue to a #GVariant of the type indicated by the @type parameter.
 *
 * The conversion is using the following rules:
 * <table frame='all'>
 * <title>#GValue / #GVariant conversion rules</title>
 * <tgroup cols='2' align='left' colsep='1' rowsep='1'>
 * <thead>
 * <row>
 * <entry>If the #GType for @gvalue is...</entry>
 * <entry>... then @type must be</entry>
 * </row>
 * </thead>
 * <tbody>
 * <row>
 * <entry>#G_TYPE_STRING</entry>
 * <entry><link linkend="G-VARIANT-TYPE-STRING:CAPS">'s'</link>, <link linkend="G-VARIANT-TYPE-OBJECT-PATH:CAPS">'o'</link>, <link linkend="G-VARIANT-TYPE-SIGNATURE:CAPS">'g'</link> or <link linkend="G-VARIANT-TYPE-BYTESTRING:CAPS">'ay'</link></entry>
 * </row>
 * <row>
 * <entry>#G_TYPE_STRV</entry>
 * <entry><link linkend="G-VARIANT-TYPE-STRING-ARRAY:CAPS">'as'</link>, <link linkend="G-VARIANT-TYPE-OBJECT-PATH-ARRAY:CAPS">'ao'</link> or <link linkend="G-VARIANT-TYPE-BYTESTRING-ARRAY:CAPS">'aay'</link></entry>
 * </row>
 * <row>
 * <entry>#G_TYPE_BOOLEAN</entry>
 * <entry><link linkend="G-VARIANT-TYPE-BOOLEAN:CAPS">'b'</link></entry>
 * </row>
 * <row>
 * <entry>#G_TYPE_UCHAR</entry>
 * <entry><link linkend="G-VARIANT-TYPE-BYTE:CAPS">'y'</link></entry>
 * </row>
 * <row>
 * <entry>#G_TYPE_INT</entry>
 * <entry><link linkend="G-VARIANT-TYPE-INT32:CAPS">'i'</link> or <link linkend="G-VARIANT-TYPE-INT16:CAPS">'n'</link></entry>
 * </row>
 * <row>
 * <entry>#G_TYPE_UINT</entry>
 * <entry><link linkend="G-VARIANT-TYPE-UINT32:CAPS">'u'</link> or <link linkend="G-VARIANT-TYPE-UINT16:CAPS">'q'</link></entry>
 * </row>
 * <row>
 * <entry>#G_TYPE_INT64</entry>
 * <entry><link linkend="G-VARIANT-TYPE-INT64:CAPS">'x'</link></entry>
 * </row>
 * <row>
 * <entry>#G_TYPE_UINT64</entry>
 * <entry><link linkend="G-VARIANT-TYPE-UINT64:CAPS">'t'</link></entry>
 * </row>
 * <row>
 * <entry>#G_TYPE_DOUBLE</entry>
 * <entry><link linkend="G-VARIANT-TYPE-DOUBLE:CAPS">'d'</link></entry>
 * </row>
 * <row>
 * <entry>#G_TYPE_VARIANT</entry>
 * <entry>Any #GVariantType</entry>
 * </row>
 * </tbody>
 * </tgroup>
 * </table>
 * This can fail if e.g. @gvalue is of type #G_TYPE_STRING and @type
 * is <link linkend="G-VARIANT-TYPE-INT32:CAPS">'i'</link>. It will
 * also fail for any #GType (including e.g. #G_TYPE_OBJECT and
 * #G_TYPE_BOXED derived-types) not in the table above.
 *
 * Note that if @gvalue is of type #G_TYPE_VARIANT and its value is
 * %NULL, the <emphasis>empty</emphasis> #GVariant instance (never
 * %NULL) for @type is returned (e.g. 0 for scalar types, the empty
 * string for string types, <literal>'/'</literal> for object path
 * types, the empty array for any array type and so on).
 *
 * See the g_dbus_gvariant_to_gvalue() function for how to convert a
 * #GVariant to a #GValue.
 *
 * @type holding the data from @gvalue or %NULL in case of
 * failure. Free with g_variant_unref().
 *
 * Returns: A #GVariant (never floating) of #GVariantType
 * Since: 2.30
 */


/**
 * g_dbus_gvariant_to_gvalue:
 * @value: A #GVariant.
 * @out_gvalue: Return location pointing to a zero-filled (uninitialized) #GValue.
 *
 * Converts a #GVariant to a #GValue. If @value is floating, it is consumed.
 *
 * The rules specified in the g_dbus_gvalue_to_gvariant() function are
 * used - this function is essentially its reverse form.
 *
 * The conversion never fails - a valid #GValue is always returned in
 * @out_gvalue.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_get_info:
 * @interface_: An exported D-Bus interface.
 *
 * Gets D-Bus introspection information for the D-Bus interface
 * implemented by @interface_.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 * Since: 2.30
 */


/**
 * g_dbus_interface_get_object:
 * @interface_: An exported D-Bus interface.
 *
 * Gets the #GDBusObject that @interface_ belongs to, if any.
 *
 * reference belongs to @interface_ and should not be freed.
 *
 * Returns: (transfer none): A #GDBusObject or %NULL. The returned
 * Since: 2.30
 */


/**
 * g_dbus_interface_info_cache_build:
 * @info: A #GDBusInterfaceInfo.
 *
 * Builds a lookup-cache to speed up
 * g_dbus_interface_info_lookup_method(),
 * g_dbus_interface_info_lookup_signal() and
 * g_dbus_interface_info_lookup_property().
 *
 * If this has already been called with @info, the existing cache is
 * used and its use count is increased.
 *
 * Note that @info cannot be modified until
 * g_dbus_interface_info_cache_release() is called.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_info_cache_release:
 * @info: A GDBusInterfaceInfo
 *
 * Decrements the usage count for the cache for @info built by
 * g_dbus_interface_info_cache_build() (if any) and frees the
 * resources used by the cache if the usage count drops to zero.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_info_generate_xml:
 * @info: A #GDBusNodeInfo
 * @indent: Indentation level.
 * @string_builder: (out): A #GString to to append XML data to.
 *
 * Appends an XML representation of @info (and its children) to @string_builder.
 *
 * This function is typically used for generating introspection XML
 * documents at run-time for handling the
 * <literal>org.freedesktop.DBus.Introspectable.Introspect</literal>
 * method.
 *
 * Since: 2.26
 */


/**
 * g_dbus_interface_info_lookup_method:
 * @info: A #GDBusInterfaceInfo.
 * @name: A D-Bus method name (typically in CamelCase)
 *
 * Looks up information about a method.
 *
 * This cost of this function is O(n) in number of methods unless
 * g_dbus_interface_info_cache_build() has been used on @info.
 *
 * Returns: (transfer none): A #GDBusMethodInfo or %NULL if not found. Do not free, it is owned by @info.
 * Since: 2.26
 */


/**
 * g_dbus_interface_info_lookup_property:
 * @info: A #GDBusInterfaceInfo.
 * @name: A D-Bus property name (typically in CamelCase).
 *
 * Looks up information about a property.
 *
 * This cost of this function is O(n) in number of properties unless
 * g_dbus_interface_info_cache_build() has been used on @info.
 *
 * Returns: (transfer none): A #GDBusPropertyInfo or %NULL if not found. Do not free, it is owned by @info.
 * Since: 2.26
 */


/**
 * g_dbus_interface_info_lookup_signal:
 * @info: A #GDBusInterfaceInfo.
 * @name: A D-Bus signal name (typically in CamelCase)
 *
 * Looks up information about a signal.
 *
 * This cost of this function is O(n) in number of signals unless
 * g_dbus_interface_info_cache_build() has been used on @info.
 *
 * Returns: (transfer none): A #GDBusSignalInfo or %NULL if not found. Do not free, it is owned by @info.
 * Since: 2.26
 */


/**
 * g_dbus_interface_info_ref:
 * @info: A #GDBusInterfaceInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_interface_info_unref:
 * @info: A #GDBusInterfaceInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_interface_set_object:
 * @interface_: An exported D-Bus interface.
 * @object: A #GDBusObject or %NULL.
 *
 * Sets the #GDBusObject for @interface_ to @object.
 *
 * Note that @interface_ will hold a weak reference to @object.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_export:
 * @interface_: The D-Bus interface to export.
 * @connection: A #GDBusConnection to export @interface_ on.
 * @object_path: The path to export the interface at.
 * @error: Return location for error or %NULL.
 *
 * Exports @interface_ at @object_path on @connection.
 *
 * This can be called multiple times to export the same @interface_
 * onto multiple connections however the @object_path provided must be
 * the same for all connections.
 *
 * Use g_dbus_interface_skeleton_unexport() to unexport the object.
 *
 * @error set.
 *
 * Returns: %TRUE if the interface was exported on @connection, otherwise %FALSE with
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_flush:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * If @interface_ has outstanding changes, request for these changes to be
 * emitted immediately.
 *
 * For example, an exported D-Bus interface may queue up property
 * changes and emit the
 * <literal>org.freedesktop.DBus.Properties::PropertiesChanged</literal>
 * signal later (e.g. in an idle handler). This technique is useful
 * for collapsing multiple property changes into one.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_connection:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets the first connection that @interface_ is exported on, if any.
 *
 * not exported anywhere. Do not free, the object belongs to @interface_.
 *
 * Returns: (transfer none): A #GDBusConnection or %NULL if @interface_ is
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_connections:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets a list of the connections that @interface_ is exported on.
 *
 * all the connections that @interface_ is exported on. The returned
 * list should be freed with g_list_free() after each element has
 * been freed with g_object_unref().
 *
 * Returns: (element-type GDBusConnection) (transfer full): A list of
 * Since: 2.32
 */


/**
 * g_dbus_interface_skeleton_get_flags:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets the #GDBusInterfaceSkeletonFlags that describes what the behavior
 * of @interface_
 *
 * Returns: One or more flags from the #GDBusInterfaceSkeletonFlags enumeration.
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_info:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets D-Bus introspection information for the D-Bus interface
 * implemented by @interface_.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo (never %NULL). Do not free.
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_object_path:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets the object path that @interface_ is exported on, if any.
 *
 * anywhere. Do not free, the string belongs to @interface_.
 *
 * Returns: A string owned by @interface_ or %NULL if @interface_ is not exported
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_properties:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets all D-Bus properties for @interface_.
 *
 * Returns: (transfer full): A #GVariant of type <link linkend="G-VARIANT-TYPE-VARDICT:CAPS">'a{sv}'</link>. Free with g_variant_unref().
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_get_vtable: (skip)
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Gets the interface vtable for the D-Bus interface implemented by
 * @interface_. The returned function pointers should expect @interface_
 * itself to be passed as @user_data.
 *
 * Returns: A #GDBusInterfaceVTable (never %NULL).
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_has_connection:
 * @interface_: A #GDBusInterfaceSkeleton.
 * @connection: A #GDBusConnection.
 *
 * Checks if @interface_ is export on @connection.
 *
 * Returns: %TRUE if @interface_ is exported on @connection, %FALSE otherwise.
 * Since: 2.32
 */


/**
 * g_dbus_interface_skeleton_set_flags:
 * @interface_: A #GDBusInterfaceSkeleton.
 * @flags: Flags from the #GDBusInterfaceSkeletonFlags enumeration.
 *
 * Sets flags describing what the behavior of @skeleton should be.
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_unexport:
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Stops exporting @interface_ on all connections it is exported on.
 *
 * To unexport @interface_ from only a single connection, use
 * g_dbus_interface_skeleton_export_from_connection()
 *
 * Since: 2.30
 */


/**
 * g_dbus_interface_skeleton_unexport_from_connection:
 * @interface_: A #GDBusInterfaceSkeleton.
 * @connection: A #GDBusConnection.
 *
 * Stops exporting @interface_ on @connection.
 *
 * To stop exporting on all connections the interface is exported on,
 * use g_dbus_interface_skeleton_unexport().
 *
 * Since: 2.32
 */


/**
 * g_dbus_is_address:
 * @string: A string.
 *
 * Checks if @string is a D-Bus address.
 *
 * This doesn't check if @string is actually supported by #GDBusServer
 * or #GDBusConnection - use g_dbus_is_supported_address() to do more
 * checks.
 *
 * Returns: %TRUE if @string is a valid D-Bus address, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_is_guid:
 * @string: The string to check.
 *
 * Checks if @string is a D-Bus GUID.
 *
 * See the D-Bus specification regarding what strings are valid D-Bus
 * GUID (for example, D-Bus GUIDs are not RFC-4122 compliant).
 *
 * Returns: %TRUE if @string is a guid, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_is_interface_name:
 * @string: The string to check.
 *
 * Checks if @string is a valid D-Bus interface name.
 *
 * Returns: %TRUE if valid, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_is_member_name:
 * @string: The string to check.
 *
 * Checks if @string is a valid D-Bus member (e.g. signal or method) name.
 *
 * Returns: %TRUE if valid, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_is_name:
 * @string: The string to check.
 *
 * Checks if @string is a valid D-Bus bus name (either unique or well-known).
 *
 * Returns: %TRUE if valid, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_is_supported_address:
 * @string: A string.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_is_address() but also checks if the library suppors the
 * transports in @string and that key/value pairs for each transport
 * are valid.
 *
 * supported by this library, %FALSE if @error is set.
 *
 * Returns: %TRUE if @string is a valid D-Bus address that is
 * Since: 2.26
 */


/**
 * g_dbus_is_unique_name:
 * @string: The string to check.
 *
 * Checks if @string is a valid D-Bus unique bus name.
 *
 * Returns: %TRUE if valid, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_menu_model_get:
 * @connection: a #GDBusConnection
 * @bus_name: the bus name which exports the menu model
 * @object_path: the object path at which the menu model is exported
 *
 * Obtains a #GDBusMenuModel for the menu model which is exported
 * at the given @bus_name and @object_path.
 *
 * The thread default main context is taken at the time of this call.
 * All signals on the menu model (and any linked models) are reported
 * with respect to this context.  All calls on the returned menu model
 * (and linked models) must also originate from this same context, with
 * the thread default main context unchanged.
 *
 * g_object_unref().
 *
 * Returns: (transfer full): a #GDBusMenuModel object. Free with
 * Since: 2.32
 */


/**
 * g_dbus_message_bytes_needed:
 * @blob: A blob represent a binary D-Bus message.
 * @blob_len: The length of @blob (must be at least 16).
 * @error: Return location for error or %NULL.
 *
 * Utility function to calculate how many bytes are needed to
 * completely deserialize the D-Bus message stored at @blob.
 *
 * @blob contains invalid data or not enough data is available to
 * determine the size).
 *
 * Returns: Number of bytes needed or -1 if @error is set (e.g. if
 * Since: 2.26
 */


/**
 * g_dbus_message_copy:
 * @message: A #GDBusMessage.
 * @error: Return location for error or %NULL.
 *
 * Copies @message. The copy is a deep copy and the returned
 * #GDBusMessage is completely identical except that it is guaranteed
 * to not be locked.
 *
 * This operation can fail if e.g. @message contains file descriptors
 * and the per-process or system-wide open files limit is reached.
 *
 * Free with g_object_unref().
 *
 * Returns: (transfer full): A new #GDBusMessage or %NULL if @error is set.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_arg0:
 * @message: A #GDBusMessage.
 *
 * Convenience to get the first item in the body of @message.
 *
 * @message is not a string.
 *
 * Returns: The string item or %NULL if the first item in the body of
 * Since: 2.26
 */


/**
 * g_dbus_message_get_body:
 * @message: A #GDBusMessage.
 *
 * Gets the body of a message.
 *
 * Returns: A #GVariant or %NULL if the body is empty. Do not free, it is owned by @message.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_byte_order:
 * @message: A #GDBusMessage.
 *
 * Gets the byte order of @message.
 *
 * Returns: The byte order.
 */


/**
 * g_dbus_message_get_destination:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_error_name:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_flags:
 * @message: A #GDBusMessage.
 *
 * Gets the flags for @message.
 *
 * Returns: Flags that are set (typically values from the #GDBusMessageFlags enumeration bitwise ORed together).
 * Since: 2.26
 */


/**
 * g_dbus_message_get_header:
 * @message: A #GDBusMessage.
 * @header_field: A 8-bit unsigned integer (typically a value from the #GDBusMessageHeaderField enumeration)
 *
 * Gets a header field on @message.
 *
 * otherwise. Do not free, it is owned by @message.
 *
 * Returns: A #GVariant with the value if the header was found, %NULL
 * Since: 2.26
 */


/**
 * g_dbus_message_get_header_fields:
 * @message: A #GDBusMessage.
 *
 * Gets an array of all header fields on @message that are set.
 *
 * %G_DBUS_MESSAGE_HEADER_FIELD_INVALID.  Each element is a
 * #guchar. Free with g_free().
 *
 * Returns: An array of header fields terminated by
 * Since: 2.26
 */


/**
 * g_dbus_message_get_interface:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_locked:
 * @message: A #GDBusMessage.
 *
 * Checks whether @message is locked. To monitor changes to this
 * value, conncet to the #GObject::notify signal to listen for changes
 * on the #GDBusMessage:locked property.
 *
 * Returns: %TRUE if @message is locked, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_member:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_MEMBER header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_message_type:
 * @message: A #GDBusMessage.
 *
 * Gets the type of @message.
 *
 * Returns: A 8-bit unsigned integer (typically a value from the #GDBusMessageType enumeration).
 * Since: 2.26
 */


/**
 * g_dbus_message_get_num_unix_fds:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_path:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_PATH header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_reply_serial:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_sender:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_SENDER header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_serial:
 * @message: A #GDBusMessage.
 *
 * Gets the serial for @message.
 *
 * Returns: A #guint32.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_signature:
 * @message: A #GDBusMessage.
 *
 * Convenience getter for the %G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field.
 *
 * Returns: The value.
 * Since: 2.26
 */


/**
 * g_dbus_message_get_unix_fd_list:
 * @message: A #GDBusMessage.
 *
 * Gets the UNIX file descriptors associated with @message, if any.
 *
 * This method is only available on UNIX.
 *
 * associated. Do not free, this object is owned by @message.
 *
 * Returns: (transfer none): A #GUnixFDList or %NULL if no file descriptors are
 * Since: 2.26
 */


/**
 * g_dbus_message_lock:
 * @message: A #GDBusMessage.
 *
 * If @message is locked, does nothing. Otherwise locks the message.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_new:
 *
 * Creates a new empty #GDBusMessage.
 *
 * Returns: A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_from_blob:
 * @blob: A blob represent a binary D-Bus message.
 * @blob_len: The length of @blob.
 * @capabilities: A #GDBusCapabilityFlags describing what protocol features are supported.
 * @error: Return location for error or %NULL.
 *
 * Creates a new #GDBusMessage from the data stored at @blob. The byte
 * order that the message was in can be retrieved using
 * g_dbus_message_get_byte_order().
 *
 * g_object_unref().
 *
 * Returns: A new #GDBusMessage or %NULL if @error is set. Free with
 * Since: 2.26
 */


/**
 * g_dbus_message_new_method_call:
 * @name: A valid D-Bus name or %NULL.
 * @path: A valid object path.
 * @interface_: A valid D-Bus interface name or %NULL.
 * @method: A valid method name.
 *
 * Creates a new #GDBusMessage for a method call.
 *
 * Returns: A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_method_error:
 * @method_call_message: A message of type %G_DBUS_MESSAGE_TYPE_METHOD_CALL to create a reply message to.
 * @error_name: A valid D-Bus error name.
 * @error_message_format: The D-Bus error message in a printf() format.
 * @...: Arguments for @error_message_format.
 *
 * Creates a new #GDBusMessage that is an error reply to @method_call_message.
 *
 * Returns: (transfer full): A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_method_error_literal:
 * @method_call_message: A message of type %G_DBUS_MESSAGE_TYPE_METHOD_CALL to create a reply message to.
 * @error_name: A valid D-Bus error name.
 * @error_message: The D-Bus error message.
 *
 * Creates a new #GDBusMessage that is an error reply to @method_call_message.
 *
 * Returns: (transfer full): A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_method_error_valist:
 * @method_call_message: A message of type %G_DBUS_MESSAGE_TYPE_METHOD_CALL to create a reply message to.
 * @error_name: A valid D-Bus error name.
 * @error_message_format: The D-Bus error message in a printf() format.
 * @var_args: Arguments for @error_message_format.
 *
 * Like g_dbus_message_new_method_error() but intended for language bindings.
 *
 * Returns: (transfer full): A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_method_reply:
 * @method_call_message: A message of type %G_DBUS_MESSAGE_TYPE_METHOD_CALL to create a reply message to.
 *
 * Creates a new #GDBusMessage that is a reply to @method_call_message.
 *
 * Returns: (transfer full): #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_new_signal:
 * @path: A valid object path.
 * @interface_: A valid D-Bus interface name.
 * @signal: A valid signal name.
 *
 * Creates a new #GDBusMessage for a signal emission.
 *
 * Returns: A #GDBusMessage. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_message_print:
 * @message: A #GDBusMessage.
 * @indent: Indentation level.
 *
 * Produces a human-readable multi-line description of @message.
 *
 * The contents of the description has no ABI guarantees, the contents
 * and formatting is subject to change at any time. Typical output
 * looks something like this:
 * <programlisting>
 * Flags:   none
 * Version: 0
 * Serial:  4
 * Headers:
 * path -> objectpath '/org/gtk/GDBus/TestObject'
 * interface -> 'org.gtk.GDBus.TestInterface'
 * member -> 'GimmeStdout'
 * destination -> ':1.146'
 * Body: ()
 * UNIX File Descriptors:
 * (none)
 * </programlisting>
 * or
 * <programlisting>
 * Flags:   no-reply-expected
 * Version: 0
 * Serial:  477
 * Headers:
 * reply-serial -> uint32 4
 * destination -> ':1.159'
 * sender -> ':1.146'
 * num-unix-fds -> uint32 1
 * Body: ()
 * UNIX File Descriptors:
 * fd 12: dev=0:10,mode=020620,ino=5,uid=500,gid=5,rdev=136:2,size=0,atime=1273085037,mtime=1273085851,ctime=1272982635
 * </programlisting>
 *
 * Type:    method-return
 * Returns: A string that should be freed with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_message_set_body:
 * @message: A #GDBusMessage.
 * @body: Either %NULL or a #GVariant that is a tuple.
 *
 * Sets the body @message. As a side-effect the
 * %G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field is set to the
 * type string of @body (or cleared if @body is %NULL).
 *
 * If @body is floating, @message assumes ownership of @body.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_byte_order:
 * @message: A #GDBusMessage.
 * @byte_order: The byte order.
 *
 * Sets the byte order of @message.
 */


/**
 * g_dbus_message_set_destination:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_error_name:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_flags:
 * @message: A #GDBusMessage.
 * @flags: Flags for @message that are set (typically values from the #GDBusMessageFlags enumeration bitwise ORed together).
 *
 * Sets the flags to set on @message.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_header:
 * @message: A #GDBusMessage.
 * @header_field: A 8-bit unsigned integer (typically a value from the #GDBusMessageHeaderField enumeration)
 * @value: A #GVariant to set the header field or %NULL to clear the header field.
 *
 * Sets a header field on @message.
 *
 * If @value is floating, @message assumes ownership of @value.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_interface:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_member:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_MEMBER header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_message_type:
 * @message: A #GDBusMessage.
 * @type: A 8-bit unsigned integer (typically a value from the #GDBusMessageType enumeration).
 *
 * Sets @message to be of @type.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_num_unix_fds:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_path:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_PATH header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_reply_serial:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_sender:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_SENDER header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_serial:
 * @message: A #GDBusMessage.
 * @serial: A #guint32.
 *
 * Sets the serial for @message.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_signature:
 * @message: A #GDBusMessage.
 * @value: The value to set.
 *
 * Convenience setter for the %G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE header field.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_set_unix_fd_list:
 * @message: A #GDBusMessage.
 * @fd_list: (allow-none): A #GUnixFDList or %NULL.
 *
 * Sets the UNIX file descriptors associated with @message. As a
 * side-effect the %G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS header
 * field is set to the number of fds in @fd_list (or cleared if
 * @fd_list is %NULL).
 *
 * This method is only available on UNIX.
 *
 * Since: 2.26
 */


/**
 * g_dbus_message_to_blob:
 * @message: A #GDBusMessage.
 * @out_size: Return location for size of generated blob.
 * @capabilities: A #GDBusCapabilityFlags describing what protocol features are supported.
 * @error: Return location for error.
 *
 * Serializes @message to a blob. The byte order returned by
 * g_dbus_message_get_byte_order() will be used.
 *
 * generated by @message or %NULL if @error is set. Free with g_free().
 *
 * Returns: A pointer to a valid binary D-Bus message of @out_size bytes
 * Since: 2.26
 */


/**
 * g_dbus_message_to_gerror:
 * @message: A #GDBusMessage.
 * @error: The #GError to set.
 *
 * If @message is not of type %G_DBUS_MESSAGE_TYPE_ERROR does
 * nothing and returns %FALSE.
 *
 * Otherwise this method encodes the error in @message as a #GError
 * using g_dbus_error_set_dbus_error() using the information in the
 * %G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME header field of @message as
 * well as the first string item in @message's body.
 *
 * Returns: %TRUE if @error was set, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_method_info_ref:
 * @info: A #GDBusMethodInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_method_info_unref:
 * @info: A #GDBusMethodInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_connection:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the #GDBusConnection the method was invoked on.
 *
 * Returns: (transfer none): A #GDBusConnection. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_interface_name:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the name of the D-Bus interface the method was invoked on.
 *
 * Returns: A string. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_message:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the #GDBusMessage for the method invocation. This is useful if
 * you need to use low-level protocol features, such as UNIX file
 * descriptor passing, that cannot be properly expressed in the
 * #GVariant API.
 *
 * See <xref linkend="gdbus-server"/> and <xref
 * linkend="gdbus-unix-fd-client"/> for an example of how to use this
 * low-level API to send and receive UNIX file descriptors.
 *
 * Returns: (transfer none): #GDBusMessage. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_method_info:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets information about the method call, if any.
 *
 * Returns: A #GDBusMethodInfo or %NULL. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_method_name:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the name of the method that was invoked.
 *
 * Returns: A string. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_object_path:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the object path the method was invoked on.
 *
 * Returns: A string. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_parameters:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the parameters of the method invocation. If there are no input
 * parameters then this will return a GVariant with 0 children rather than NULL.
 *
 * Returns: (transfer none): A #GVariant tuple. Do not unref this because it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_sender:
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the bus name that invoked the method.
 *
 * Returns: A string. Do not free, it is owned by @invocation.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_get_user_data: (skip)
 * @invocation: A #GDBusMethodInvocation.
 *
 * Gets the @user_data #gpointer passed to g_dbus_connection_register_object().
 *
 * Returns: A #gpointer.
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_dbus_error:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @error_name: A valid D-Bus error name.
 * @error_message: A valid D-Bus error message.
 *
 * Finishes handling a D-Bus method call by returning an error.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_error:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @domain: A #GQuark for the #GError error domain.
 * @code: The error code.
 * @format: printf()-style format.
 * @...: Parameters for @format.
 *
 * Finishes handling a D-Bus method call by returning an error.
 *
 * See g_dbus_error_encode_gerror() for details about what error name
 * will be returned on the wire. In a nutshell, if the given error is
 * registered using g_dbus_error_register_error() the name given
 * during registration is used. Otherwise, a name of the form
 * <literal>org.gtk.GDBus.UnmappedGError.Quark...</literal> is
 * used. This provides transparent mapping of #GError between
 * applications using GDBus.
 *
 * If you are writing an application intended to be portable,
 * <emphasis>always</emphasis> register errors with g_dbus_error_register_error()
 * or use g_dbus_method_invocation_return_dbus_error().
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_error_literal:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @domain: A #GQuark for the #GError error domain.
 * @code: The error code.
 * @message: The error message.
 *
 * Like g_dbus_method_invocation_return_error() but without printf()-style formatting.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_error_valist:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @domain: A #GQuark for the #GError error domain.
 * @code: The error code.
 * @format: printf()-style format.
 * @var_args: #va_list of parameters for @format.
 *
 * Like g_dbus_method_invocation_return_error() but intended for
 * language bindings.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_gerror:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @error: A #GError.
 *
 * Like g_dbus_method_invocation_return_error() but takes a #GError
 * instead of the error domain, error code and message.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_value:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @parameters: (allow-none): A #GVariant tuple with out parameters for the method or %NULL if not passing any parameters.
 *
 * Finishes handling a D-Bus method call by returning @parameters.
 * If the @parameters GVariant is floating, it is consumed.
 *
 * It is an error if @parameters is not of the right format.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.26
 */


/**
 * g_dbus_method_invocation_return_value_with_unix_fd_list:
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @parameters: (allow-none): A #GVariant tuple with out parameters for the method or %NULL if not passing any parameters.
 * @fd_list: (allow-none): A #GUnixFDList or %NULL.
 *
 * Like g_dbus_method_invocation_return_value() but also takes a #GUnixFDList.
 *
 * This method is only available on UNIX.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.30
 */


/**
 * g_dbus_method_invocation_take_error: (skip)
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @error: (transfer full): A #GError.
 *
 * Like g_dbus_method_invocation_return_gerror() but takes ownership
 * of @error so the caller does not need to free it.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 2.30
 */


/**
 * g_dbus_node_info_generate_xml:
 * @info: A #GDBusNodeInfo.
 * @indent: Indentation level.
 * @string_builder: (out): A #GString to to append XML data to.
 *
 * Appends an XML representation of @info (and its children) to @string_builder.
 *
 * This function is typically used for generating introspection XML documents at run-time for
 * handling the <literal>org.freedesktop.DBus.Introspectable.Introspect</literal> method.
 *
 * Since: 2.26
 */


/**
 * g_dbus_node_info_lookup_interface:
 * @info: A #GDBusNodeInfo.
 * @name: A D-Bus interface name.
 *
 * Looks up information about an interface.
 *
 * This cost of this function is O(n) in number of interfaces.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo or %NULL if not found. Do not free, it is owned by @info.
 * Since: 2.26
 */


/**
 * g_dbus_node_info_new_for_xml:
 * @xml_data: Valid D-Bus introspection XML.
 * @error: Return location for error.
 *
 * Parses @xml_data and returns a #GDBusNodeInfo representing the data.
 *
 * Note that this routine is using a
 * <link linkend="glib-Simple-XML-Subset-Parser.description">GMarkup</link>-based
 * parser that only accepts a subset of valid XML documents.
 *
 * with g_dbus_node_info_unref().
 *
 * Returns: A #GDBusNodeInfo structure or %NULL if @error is set. Free
 * Since: 2.26
 */


/**
 * g_dbus_node_info_ref:
 * @info: A #GDBusNodeInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_node_info_unref:
 * @info: A #GDBusNodeInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_object_get_interface:
 * @object: A #GDBusObject.
 * @interface_name: A D-Bus interface name.
 *
 * Gets the D-Bus interface with name @interface_name associated with
 * @object, if any.
 *
 * #GDBusInterface that must be freed with g_object_unref().
 *
 * Returns: (transfer full): %NULL if not found, otherwise a
 * Since: 2.30
 */


/**
 * g_dbus_object_get_interfaces:
 * @object: A #GDBusObject.
 *
 * Gets the D-Bus interfaces associated with @object.
 *
 * The returned list must be freed by g_list_free() after each element has been freed
 * with g_object_unref().
 *
 * Returns: (element-type GDBusInterface) (transfer full): A list of #GDBusInterface instances.
 * Since: 2.30
 */


/**
 * g_dbus_object_get_object_path:
 * @object: A #GDBusObject.
 *
 * Gets the object path for @object.
 *
 * Returns: A string owned by @object. Do not free.
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_get_connection:
 * @manager: A #GDBusObjectManagerClient
 *
 * Gets the #GDBusConnection used by @manager.
 *
 * the object belongs to @manager.
 *
 * Returns: (transfer none): A #GDBusConnection object. Do not free,
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_get_flags:
 * @manager: A #GDBusObjectManagerClient
 *
 * Gets the flags that @manager was constructed with.
 *
 * enumeration.
 *
 * Returns: Zero of more flags from the #GDBusObjectManagerClientFlags
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_get_name:
 * @manager: A #GDBusObjectManagerClient
 *
 * Gets the name that @manager is for.
 *
 * belongs to @manager.
 *
 * Returns: A unique or well-known name. Do not free, the string
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_get_name_owner:
 * @manager: A #GDBusObjectManagerClient.
 *
 * The unique name that owns the name that @manager is for or %NULL if
 * no-one currently owns that name. You can connect to the
 * #GObject::notify signal to track changes to the
 * #GDBusObjectManagerClient:name-owner property.
 *
 * g_free().
 *
 * Returns: The name owner or %NULL if no name owner exists. Free with
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Zero or more flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: The owner of the control object (unique or well-known name).
 * @object_path: The object path of the control object.
 * @get_proxy_type_func: A #GDBusProxyTypeFunc function or %NULL to always construct #GDBusProxy proxies.
 * @get_proxy_type_user_data: User data to pass to @get_proxy_type_func.
 * @get_proxy_type_destroy_notify: (allow-none): Free function for @get_proxy_type_user_data or %NULL.
 * @cancellable: A #GCancellable or %NULL
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: The data to pass to @callback.
 *
 * Asynchronously creates a new #GDBusObjectManagerClient object.
 *
 * This is an asynchronous failable constructor. When the result is
 * ready, @callback will be invoked in the
 * <link linkend="g-main-context-push-thread-default">thread-default main loop</link>
 * of the thread you are calling this method from. You can
 * then call g_dbus_object_manager_client_new_finish() to get the result. See
 * g_dbus_object_manager_client_new_sync() for the synchronous version.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_object_manager_client_new().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_object_manager_client_new().
 *
 * #GDBusObjectManagerClient object or %NULL if @error is set. Free
 * with g_object_unref().
 *
 * Returns: (transfer full) (type GDBusObjectManagerClient): A
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Zero or more flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: The owner of the control object (unique or well-known name).
 * @object_path: The object path of the control object.
 * @get_proxy_type_func: A #GDBusProxyTypeFunc function or %NULL to always construct #GDBusProxy proxies.
 * @get_proxy_type_user_data: User data to pass to @get_proxy_type_func.
 * @get_proxy_type_destroy_notify: (allow-none): Free function for @get_proxy_type_user_data or %NULL.
 * @cancellable: A #GCancellable or %NULL
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: The data to pass to @callback.
 *
 * Like g_dbus_object_manager_client_new() but takes a #GBusType instead of a
 * #GDBusConnection.
 *
 * This is an asynchronous failable constructor. When the result is
 * ready, @callback will be invoked in the
 * <link linkend="g-main-context-push-thread-default">thread-default main loop</link>
 * of the thread you are calling this method from. You can
 * then call g_dbus_object_manager_client_new_for_bus_finish() to get the result. See
 * g_dbus_object_manager_client_new_for_bus_sync() for the synchronous version.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new_for_bus_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_object_manager_client_new_for_bus().
 *
 * #GDBusObjectManagerClient object or %NULL if @error is set. Free
 * with g_object_unref().
 *
 * Returns: (transfer full) (type GDBusObjectManagerClient): A
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Zero or more flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: The owner of the control object (unique or well-known name).
 * @object_path: The object path of the control object.
 * @get_proxy_type_func: A #GDBusProxyTypeFunc function or %NULL to always construct #GDBusProxy proxies.
 * @get_proxy_type_user_data: User data to pass to @get_proxy_type_func.
 * @get_proxy_type_destroy_notify: (allow-none): Free function for @get_proxy_type_user_data or %NULL.
 * @cancellable: A #GCancellable or %NULL
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_object_manager_client_new_sync() but takes a #GBusType instead
 * of a #GDBusConnection.
 *
 * This is a synchronous failable constructor - the calling thread is
 * blocked until a reply is received. See g_dbus_object_manager_client_new_for_bus()
 * for the asynchronous version.
 *
 * #GDBusObjectManagerClient object or %NULL if @error is set. Free
 * with g_object_unref().
 *
 * Returns: (transfer full) (type GDBusObjectManagerClient): A
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Zero or more flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: The owner of the control object (unique or well-known name).
 * @object_path: The object path of the control object.
 * @get_proxy_type_func: A #GDBusProxyTypeFunc function or %NULL to always construct #GDBusProxy proxies.
 * @get_proxy_type_user_data: User data to pass to @get_proxy_type_func.
 * @get_proxy_type_destroy_notify: (allow-none): Free function for @get_proxy_type_user_data or %NULL.
 * @cancellable: A #GCancellable or %NULL
 * @error: Return location for error or %NULL.
 *
 * Creates a new #GDBusObjectManagerClient object.
 *
 * This is a synchronous failable constructor - the calling thread is
 * blocked until a reply is received. See g_dbus_object_manager_client_new()
 * for the asynchronous version.
 *
 * #GDBusObjectManagerClient object or %NULL if @error is set. Free
 * with g_object_unref().
 *
 * Returns: (transfer full) (type GDBusObjectManagerClient): A
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_get_interface:
 * @manager: A #GDBusObjectManager.
 * @object_path: Object path to lookup.
 * @interface_name: D-Bus interface name to lookup.
 *
 * Gets the interface proxy for @interface_name at @object_path, if
 * any.
 *
 * with g_object_unref().
 *
 * Returns: (transfer full): A #GDBusInterface instance or %NULL. Free
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_get_object:
 * @manager: A #GDBusObjectManager.
 * @object_path: Object path to lookup.
 *
 * Gets the #GDBusObjectProxy at @object_path, if any.
 *
 * g_object_unref().
 *
 * Returns: (transfer full): A #GDBusObject or %NULL. Free with
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_get_object_path:
 * @manager: A #GDBusObjectManager.
 *
 * Gets the object path that @manager is for.
 *
 * Returns: A string owned by @manager. Do not free.
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_get_objects:
 * @manager: A #GDBusObjectManager.
 *
 * Gets all #GDBusObject objects known to @manager.
 *
 * #GDBusObject objects. The returned list should be freed with
 * g_list_free() after each element has been freed with
 * g_object_unref().
 *
 * Returns: (transfer full) (element-type GDBusObject): A list of
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_server_export:
 * @manager: A #GDBusObjectManagerServer.
 * @object: A #GDBusObjectSkeleton.
 *
 * Exports @object on @manager.
 *
 * If there is already a #GDBusObject exported at the object path,
 * then the old object is removed.
 *
 * The object path for @object must be in the hierarchy rooted by the
 * object path for @manager.
 *
 * Note that @manager will take a reference on @object for as long as
 * it is exported.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_server_export_uniquely:
 * @manager: A #GDBusObjectManagerServer.
 * @object: An object.
 *
 * Like g_dbus_object_manager_server_export() but appends a string of
 * the form <literal>_N</literal> (with N being a natural number) to
 * @object<!-- -->'s object path if an object with the given path
 * already exists. As such, the #GDBusObjectProxy:g-object-path property
 * of @object may be modified.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_server_get_connection:
 * @manager: A #GDBusObjectManagerServer
 *
 * Gets the #GDBusConnection used by @manager.
 *
 * @manager isn't exported on a connection. The returned object should
 * be freed with g_object_unref().
 *
 * Returns: (transfer full): A #GDBusConnection object or %NULL if
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_server_new:
 * @object_path: The object path to export the manager object at.
 *
 * Creates a new #GDBusObjectManagerServer object.
 *
 * The returned server isn't yet exported on any connection. To do so,
 * use g_dbus_object_manager_server_set_connection(). Normally you
 * want to export all of your objects before doing so to avoid <ulink
 * url="http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-objectmanager">InterfacesAdded</ulink>
 * signals being emitted.
 *
 * Returns: A #GDBusObjectManagerServer object. Free with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_manager_server_set_connection:
 * @manager: A #GDBusObjectManagerServer.
 * @connection: (allow-none): A #GDBusConnection or %NULL.
 *
 * Exports all objects managed by @manager on @connection. If
 * @connection is %NULL, stops exporting objects.
 */


/**
 * g_dbus_object_manager_server_unexport:
 * @manager: A #GDBusObjectManagerServer.
 * @object_path: An object path.
 *
 * If @manager has an object at @path, removes the object. Otherwise
 * does nothing.
 *
 * Note that @object_path must be in the hierarchy rooted by the
 * object path for @manager.
 *
 * Returns: %TRUE if object at @object_path was removed, %FALSE otherwise.
 * Since: 2.30
 */


/**
 * g_dbus_object_proxy_get_connection:
 * @proxy: a #GDBusObjectProxy
 *
 * Gets the connection that @proxy is for.
 *
 * object is owned by @proxy.
 *
 * Returns: (transfer none): A #GDBusConnection. Do not free, the
 * Since: 2.30
 */


/**
 * g_dbus_object_proxy_new:
 * @connection: a #GDBusConnection
 * @object_path: the object path
 *
 * Creates a new #GDBusObjectProxy for the given connection and
 * object path.
 *
 * Returns: a new #GDBusObjectProxy
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_add_interface:
 * @object: A #GDBusObjectSkeleton.
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Adds @interface_ to @object.
 *
 * If @object already contains a #GDBusInterfaceSkeleton with the same
 * interface name, it is removed before @interface_ is added.
 *
 * Note that @object takes its own reference on @interface_ and holds
 * it until removed.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_flush:
 * @object: A #GDBusObjectSkeleton.
 *
 * This method simply calls g_dbus_interface_skeleton_flush() on all
 * interfaces belonging to @object. See that method for when flushing
 * is useful.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new #GDBusObjectSkeleton.
 *
 * Returns: A #GDBusObjectSkeleton. Free with g_object_unref().
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_remove_interface:
 * @object: A #GDBusObjectSkeleton.
 * @interface_: A #GDBusInterfaceSkeleton.
 *
 * Removes @interface_ from @object.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_remove_interface_by_name:
 * @object: A #GDBusObjectSkeleton.
 * @interface_name: A D-Bus interface name.
 *
 * Removes the #GDBusInterface with @interface_name from @object.
 *
 * If no D-Bus interface of the given interface exists, this function
 * does nothing.
 *
 * Since: 2.30
 */


/**
 * g_dbus_object_skeleton_set_object_path:
 * @object: A #GDBusObjectSkeleton.
 * @object_path: A valid D-Bus object path.
 *
 * Sets the object path for @object.
 *
 * Since: 2.30
 */


/**
 * g_dbus_property_info_ref:
 * @info: A #GDBusPropertyInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_property_info_unref:
 * @info: A #GDBusPropertyInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_call:
 * @proxy: A #GDBusProxy.
 * @method_name: Name of method to invoke.
 * @parameters: (allow-none): A #GVariant tuple with parameters for the signal or %NULL if not passing parameters.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or -1 to use the proxy default timeout.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: The data to pass to @callback.
 *
 * Asynchronously invokes the @method_name method on @proxy.
 *
 * If @method_name contains any dots, then @name is split into interface and
 * method name parts. This allows using @proxy for invoking methods on
 * other interfaces.
 *
 * If the #GDBusConnection associated with @proxy is closed then
 * the operation will fail with %G_IO_ERROR_CLOSED. If
 * @cancellable is canceled, the operation will fail with
 * %G_IO_ERROR_CANCELLED. If @parameters contains a value not
 * compatible with the D-Bus protocol, the operation fails with
 * %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * If the @parameters #GVariant is floating, it is consumed. This allows
 * convenient 'inline' use of g_variant_new(), e.g.:
 * |[
 * g_dbus_proxy_call (proxy,
 * "TwoStrings",
 * g_variant_new ("(ss)",
 * "Thing One",
 * "Thing Two"),
 * G_DBUS_CALL_FLAGS_NONE,
 * -1,
 * NULL,
 * (GAsyncReadyCallback) two_strings_done,
 * &amp;data);
 * ]|
 *
 * If @proxy has an expected interface (see
 * #GDBusProxy:g-interface-info) and @method_name is referenced by it,
 * then the return value is checked against the return type.
 *
 * This is an asynchronous method. When the operation is finished,
 * @callback will be invoked in the
 * <link linkend="g-main-context-push-thread-default">thread-default main loop</link>
 * of the thread you are calling this method from.
 * You can then call g_dbus_proxy_call_finish() to get the result of
 * the operation. See g_dbus_proxy_call_sync() for the synchronous
 * version of this method.
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_call_finish:
 * @proxy: A #GDBusProxy.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_proxy_call().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_proxy_call().
 *
 * return values. Free with g_variant_unref().
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * Since: 2.26
 */


/**
 * g_dbus_proxy_call_sync:
 * @proxy: A #GDBusProxy.
 * @method_name: Name of method to invoke.
 * @parameters: (allow-none): A #GVariant tuple with parameters for the signal or %NULL if not passing parameters.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or -1 to use the proxy default timeout.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the @method_name method on @proxy.
 *
 * If @method_name contains any dots, then @name is split into interface and
 * method name parts. This allows using @proxy for invoking methods on
 * other interfaces.
 *
 * If the #GDBusConnection associated with @proxy is disconnected then
 * the operation will fail with %G_IO_ERROR_CLOSED. If
 * @cancellable is canceled, the operation will fail with
 * %G_IO_ERROR_CANCELLED. If @parameters contains a value not
 * compatible with the D-Bus protocol, the operation fails with
 * %G_IO_ERROR_INVALID_ARGUMENT.
 *
 * If the @parameters #GVariant is floating, it is consumed. This allows
 * convenient 'inline' use of g_variant_new(), e.g.:
 * |[
 * g_dbus_proxy_call_sync (proxy,
 * "TwoStrings",
 * g_variant_new ("(ss)",
 * "Thing One",
 * "Thing Two"),
 * G_DBUS_CALL_FLAGS_NONE,
 * -1,
 * NULL,
 * &amp;error);
 * ]|
 *
 * The calling thread is blocked until a reply is received. See
 * g_dbus_proxy_call() for the asynchronous version of this
 * method.
 *
 * If @proxy has an expected interface (see
 * #GDBusProxy:g-interface-info) and @method_name is referenced by it,
 * then the return value is checked against the return type.
 *
 * return values. Free with g_variant_unref().
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * Since: 2.26
 */


/**
 * g_dbus_proxy_call_with_unix_fd_list:
 * @proxy: A #GDBusProxy.
 * @method_name: Name of method to invoke.
 * @parameters: (allow-none): A #GVariant tuple with parameters for the signal or %NULL if not passing parameters.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or -1 to use the proxy default timeout.
 * @fd_list: (allow-none): A #GUnixFDList or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: The data to pass to @callback.
 *
 * Like g_dbus_proxy_call() but also takes a #GUnixFDList object.
 *
 * This method is only available on UNIX.
 *
 * Since: 2.30
 */


/**
 * g_dbus_proxy_call_with_unix_fd_list_finish:
 * @proxy: A #GDBusProxy.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to g_dbus_proxy_call_with_unix_fd_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with g_dbus_proxy_call_with_unix_fd_list().
 *
 * return values. Free with g_variant_unref().
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * Since: 2.30
 */


/**
 * g_dbus_proxy_call_with_unix_fd_list_sync:
 * @proxy: A #GDBusProxy.
 * @method_name: Name of method to invoke.
 * @parameters: (allow-none): A #GVariant tuple with parameters for the signal or %NULL if not passing parameters.
 * @flags: Flags from the #GDBusCallFlags enumeration.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or -1 to use the proxy default timeout.
 * @fd_list: (allow-none): A #GUnixFDList or %NULL.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_proxy_call_sync() but also takes and returns #GUnixFDList objects.
 *
 * This method is only available on UNIX.
 *
 * return values. Free with g_variant_unref().
 *
 * Returns: %NULL if @error is set. Otherwise a #GVariant tuple with
 * Since: 2.30
 */


/**
 * g_dbus_proxy_get_cached_property:
 * @proxy: A #GDBusProxy.
 * @property_name: Property name.
 *
 * Looks up the value for a property from the cache. This call does no
 * blocking IO.
 *
 * If @proxy has an expected interface (see
 * #GDBusProxy:g-interface-info) and @property_name is referenced by
 * it, then @value is checked against the type of the property.
 *
 * for @property_name or %NULL if the value is not in the cache. The
 * returned reference must be freed with g_variant_unref().
 *
 * Returns: A reference to the #GVariant instance that holds the value
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_cached_property_names:
 * @proxy: A #GDBusProxy.
 *
 * Gets the names of all cached properties on @proxy.
 *
 * @proxy has no cached properties. Free the returned array with
 * g_strfreev().
 *
 * Returns: (transfer full): A %NULL-terminated array of strings or %NULL if
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_connection:
 * @proxy: A #GDBusProxy.
 *
 * Gets the connection @proxy is for.
 *
 * Returns: (transfer none): A #GDBusConnection owned by @proxy. Do not free.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_default_timeout:
 * @proxy: A #GDBusProxy.
 *
 * Gets the timeout to use if -1 (specifying default timeout) is
 * passed as @timeout_msec in the g_dbus_proxy_call() and
 * g_dbus_proxy_call_sync() functions.
 *
 * See the #GDBusProxy:g-default-timeout property for more details.
 *
 * Returns: Timeout to use for @proxy.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_flags:
 * @proxy: A #GDBusProxy.
 *
 * Gets the flags that @proxy was constructed with.
 *
 * Returns: Flags from the #GDBusProxyFlags enumeration.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_interface_info:
 * @proxy: A #GDBusProxy
 *
 * Returns the #GDBusInterfaceInfo, if any, specifying the interface
 * that @proxy conforms to. See the #GDBusProxy:g-interface-info
 * property for more details.
 *
 * object, it is owned by @proxy.
 *
 * Returns: A #GDBusInterfaceInfo or %NULL. Do not unref the returned
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_interface_name:
 * @proxy: A #GDBusProxy.
 *
 * Gets the D-Bus interface name @proxy is for.
 *
 * Returns: A string owned by @proxy. Do not free.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_name:
 * @proxy: A #GDBusProxy.
 *
 * Gets the name that @proxy was constructed for.
 *
 * Returns: A string owned by @proxy. Do not free.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_name_owner:
 * @proxy: A #GDBusProxy.
 *
 * The unique name that owns the name that @proxy is for or %NULL if
 * no-one currently owns that name. You may connect to the
 * #GObject::notify signal to track changes to the
 * #GDBusProxy:g-name-owner property.
 *
 * Returns: The name owner or %NULL if no name owner exists. Free with g_free().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_get_object_path:
 * @proxy: A #GDBusProxy.
 *
 * Gets the object path @proxy is for.
 *
 * Returns: A string owned by @proxy. Do not free.
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags used when constructing the proxy.
 * @info: (allow-none): A #GDBusInterfaceInfo specifying the minimal interface that @proxy conforms to or %NULL.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @interface_name: A D-Bus interface name.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback function to invoke when the proxy is ready.
 * @user_data: User data to pass to @callback.
 *
 * Creates a proxy for accessing @interface_name on the remote object
 * at @object_path owned by @name at @connection and asynchronously
 * loads D-Bus properties unless the
 * %G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES flag is used. Connect to
 * the #GDBusProxy::g-properties-changed signal to get notified about
 * property changes.
 *
 * If the %G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS flag is not set, also sets up
 * match rules for signals. Connect to the #GDBusProxy::g-signal signal
 * to handle signals from the remote object.
 *
 * If @name is a well-known name and the
 * %G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START flag isn't set and no name
 * owner currently exists, the message bus will be requested to launch
 * a name owner for the name.
 *
 * This is a failable asynchronous constructor - when the proxy is
 * ready, @callback will be invoked and you can use
 * g_dbus_proxy_new_finish() to get the result.
 *
 * See g_dbus_proxy_new_sync() and for a synchronous version of this constructor.
 *
 * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how #GDBusProxy can be used.
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to g_dbus_proxy_new().
 * @error: Return location for error or %NULL.
 *
 * Finishes creating a #GDBusProxy.
 *
 * Returns: A #GDBusProxy or %NULL if @error is set. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags used when constructing the proxy.
 * @info: (allow-none): A #GDBusInterfaceInfo specifying the minimal interface that @proxy conforms to or %NULL.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @interface_name: A D-Bus interface name.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback function to invoke when the proxy is ready.
 * @user_data: User data to pass to @callback.
 *
 * Like g_dbus_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how #GDBusProxy can be used.
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new_for_bus_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to g_dbus_proxy_new_for_bus().
 * @error: Return location for error or %NULL.
 *
 * Finishes creating a #GDBusProxy.
 *
 * Returns: A #GDBusProxy or %NULL if @error is set. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags used when constructing the proxy.
 * @info: (allow-none): A #GDBusInterfaceInfo specifying the minimal interface that @proxy conforms to or %NULL.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @interface_name: A D-Bus interface name.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how #GDBusProxy can be used.
 *
 * Returns: A #GDBusProxy or %NULL if error is set. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags used when constructing the proxy.
 * @info: (allow-none): A #GDBusInterfaceInfo specifying the minimal interface that @proxy conforms to or %NULL.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @interface_name: A D-Bus interface name.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: (allow-none): Return location for error or %NULL.
 *
 * Creates a proxy for accessing @interface_name on the remote object
 * at @object_path owned by @name at @connection and synchronously
 * loads D-Bus properties unless the
 * %G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES flag is used.
 *
 * If the %G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS flag is not set, also sets up
 * match rules for signals. Connect to the #GDBusProxy::g-signal signal
 * to handle signals from the remote object.
 *
 * If @name is a well-known name and the
 * %G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START flag isn't set and no name
 * owner currently exists, the message bus will be requested to launch
 * a name owner for the name.
 *
 * This is a synchronous failable constructor. See g_dbus_proxy_new()
 * and g_dbus_proxy_new_finish() for the asynchronous version.
 *
 * See <xref linkend="gdbus-wellknown-proxy"/> for an example of how #GDBusProxy can be used.
 *
 * Returns: A #GDBusProxy or %NULL if error is set. Free with g_object_unref().
 * Since: 2.26
 */


/**
 * g_dbus_proxy_set_cached_property:
 * @proxy: A #GDBusProxy
 * @property_name: Property name.
 * @value: (allow-none): Value for the property or %NULL to remove it from the cache.
 *
 * If @value is not %NULL, sets the cached value for the property with
 * name @property_name to the value in @value.
 *
 * If @value is %NULL, then the cached value is removed from the
 * property cache.
 *
 * If @proxy has an expected interface (see
 * #GDBusProxy:g-interface-info) and @property_name is referenced by
 * it, then @value is checked against the type of the property.
 *
 * If the @value #GVariant is floating, it is consumed. This allows
 * convenient 'inline' use of g_variant_new(), e.g.
 * |[
 * g_dbus_proxy_set_cached_property (proxy,
 * "SomeProperty",
 * g_variant_new ("(si)",
 * "A String",
 * 42));
 * ]|
 *
 * Normally you will not need to use this method since @proxy is
 * tracking changes using the
 * <literal>org.freedesktop.DBus.Properties.PropertiesChanged</literal>
 * D-Bus signal. However, for performance reasons an object may decide
 * to not use this signal for some properties and instead use a
 * proprietary out-of-band mechanism to transmit changes.
 *
 * As a concrete example, consider an object with a property
 * <literal>ChatroomParticipants</literal> which is an array of
 * strings. Instead of transmitting the same (long) array every time
 * the property changes, it is more efficient to only transmit the
 * delta using e.g. signals <literal>ChatroomParticipantJoined(String
 * name)</literal> and <literal>ChatroomParticipantParted(String
 * name)</literal>.
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_set_default_timeout:
 * @proxy: A #GDBusProxy.
 * @timeout_msec: Timeout in milliseconds.
 *
 * Sets the timeout to use if -1 (specifying default timeout) is
 * passed as @timeout_msec in the g_dbus_proxy_call() and
 * g_dbus_proxy_call_sync() functions.
 *
 * See the #GDBusProxy:g-default-timeout property for more details.
 *
 * Since: 2.26
 */


/**
 * g_dbus_proxy_set_interface_info:
 * @proxy: A #GDBusProxy
 * @info: (allow-none): Minimum interface this proxy conforms to or %NULL to unset.
 *
 * Ensure that interactions with @proxy conform to the given
 * interface. See the #GDBusProxy:g-interface-info property for more
 * details.
 *
 * Since: 2.26
 */


/**
 * g_dbus_server_get_client_address:
 * @server: A #GDBusServer.
 *
 * Gets a D-Bus address string that can be used by clients to connect
 * to @server.
 *
 * by @server.
 *
 * Returns: A D-Bus address string. Do not free, the string is owned
 * Since: 2.26
 */


/**
 * g_dbus_server_get_flags:
 * @server: A #GDBusServer.
 *
 * Gets the flags for @server.
 *
 * Returns: A set of flags from the #GDBusServerFlags enumeration.
 * Since: 2.26
 */


/**
 * g_dbus_server_get_guid:
 * @server: A #GDBusServer.
 *
 * Gets the GUID for @server.
 *
 * Returns: A D-Bus GUID. Do not free this string, it is owned by @server.
 * Since: 2.26
 */


/**
 * g_dbus_server_is_active:
 * @server: A #GDBusServer.
 *
 * Gets whether @server is active.
 *
 * Returns: %TRUE if server is active, %FALSE otherwise.
 * Since: 2.26
 */


/**
 * g_dbus_server_new_sync:
 * @address: A D-Bus address.
 * @flags: Flags from the #GDBusServerFlags enumeration.
 * @guid: A D-Bus GUID.
 * @observer: A #GDBusAuthObserver or %NULL.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for server or %NULL.
 *
 * Creates a new D-Bus server that listens on the first address in
 * @address that works.
 *
 * Once constructed, you can use g_dbus_server_get_client_address() to
 * get a D-Bus address string that clients can use to connect.
 *
 * Connect to the #GDBusServer::new-connection signal to handle
 * incoming connections.
 *
 * The returned #GDBusServer isn't active - you have to start it with
 * g_dbus_server_start().
 *
 * See <xref linkend="gdbus-peer-to-peer"/> for how #GDBusServer can
 * be used.
 *
 * This is a synchronous failable constructor. See
 * g_dbus_server_new() for the asynchronous version.
 *
 * g_object_unref().
 *
 * Returns: A #GDBusServer or %NULL if @error is set. Free with
 * Since: 2.26
 */


/**
 * g_dbus_server_start:
 * @server: A #GDBusServer.
 *
 * Starts @server.
 *
 * Since: 2.26
 */


/**
 * g_dbus_server_stop:
 * @server: A #GDBusServer.
 *
 * Stops @server.
 *
 * Since: 2.26
 */


/**
 * g_dbus_signal_info_ref:
 * @info: A #GDBusSignalInfo
 *
 * If @info is statically allocated does nothing. Otherwise increases
 * the reference count.
 *
 * Returns: The same @info.
 * Since: 2.26
 */


/**
 * g_dbus_signal_info_unref:
 * @info: A #GDBusSignalInfo.
 *
 * If @info is statically allocated, does nothing. Otherwise decreases
 * the reference count of @info. When its reference count drops to 0,
 * the memory used is freed.
 *
 * Since: 2.26
 */


/**
 * g_desktop_app_info_get_categories:
 * @info: a #GDesktopAppInfo
 *
 * Gets the categories from the desktop file.
 *
 * i.e. no attempt is made to split it by ';' or validate it.
 *
 * Returns: The unparsed Categories key from the desktop file;
 */


/**
 * g_desktop_app_info_get_filename:
 * @info: a #GDesktopAppInfo
 *
 * When @info was created from a known filename, return it.  In some
 * situations such as the #GDesktopAppInfo returned from
 * g_desktop_app_info_new_from_keyfile(), this function will return %NULL.
 *
 * Returns: The full path to the file for @info, or %NULL if not known.
 * Since: 2.24
 */


/**
 * g_desktop_app_info_get_generic_name:
 * @info: a #GDesktopAppInfo
 *
 * Gets the generic name from the destkop file.
 *
 * Returns: The value of the GenericName key
 */


/**
 * g_desktop_app_info_get_is_hidden:
 * @info: a #GDesktopAppInfo.
 *
 * A desktop file is hidden if the Hidden key in it is
 * set to True.
 *
 * Returns: %TRUE if hidden, %FALSE otherwise.
 */


/**
 * g_desktop_app_info_get_keywords:
 * @info: a #GDesktopAppInfo
 *
 * Gets the keywords from the desktop file.
 *
 * Returns: (transfer none): The value of the X-GNOME-Keywords key
 * Since: 2.32
 */


/**
 * g_desktop_app_info_get_nodisplay:
 * @info: a #GDesktopAppInfo
 *
 * Gets the value of the NoDisplay key, which helps determine if the
 * application info should be shown in menus. See
 * #G_KEY_FILE_DESKTOP_KEY_NO_DISPLAY and g_app_info_should_show().
 *
 * Returns: The value of the NoDisplay key
 * Since: 2.30
 */


/**
 * g_desktop_app_info_get_show_in:
 * @info: a #GDesktopAppInfo
 * @desktop_env: a string specifying a desktop name
 *
 * Checks if the application info should be shown in menus that list available
 * applications for a specific name of the desktop, based on the
 * <literal>OnlyShowIn</literal> and <literal>NotShowIn</literal> keys.
 *
 * If @desktop_env is %NULL, then the name of the desktop set with
 * g_desktop_app_info_set_desktop_env() is used.
 *
 * Note that g_app_info_should_show() for @info will include this check (with
 * %NULL for @desktop_env) as well as additional checks.
 *
 * <literal>OnlyShowIn</literal> and <literal>NotShowIn</literal> keys, %FALSE
 * otherwise.
 *
 * Returns: %TRUE if the @info should be shown in @desktop_env according to the
 * Since: 2.30
 */


/**
 * g_desktop_app_info_launch_uris_as_manager:
 * @appinfo: a #GDesktopAppInfo
 * @uris: (element-type utf8): List of URIs
 * @launch_context: a #GAppLaunchContext
 * @spawn_flags: #GSpawnFlags, used for each process
 * @user_setup: (scope call): a #GSpawnChildSetupFunc, used once for each process.
 * @user_setup_data: (closure user_setup): User data for @user_setup
 * @pid_callback: (scope call): Callback for child processes
 * @pid_callback_data: (closure pid_callback): User data for @callback
 * @error: return location for a #GError, or %NULL
 *
 * This function performs the equivalent of g_app_info_launch_uris(),
 * but is intended primarily for operating system components that
 * launch applications.  Ordinary applications should use
 * g_app_info_launch_uris().
 *
 * In contrast to g_app_info_launch_uris(), all processes created will
 * always be run directly as children as if by the UNIX fork()/exec()
 * calls.
 *
 * This guarantee allows additional control over the exact environment
 * of the child processes, which is provided via a setup function
 * @user_setup, as well as the process identifier of each child process
 * via @pid_callback. See g_spawn_async() for more information about the
 * semantics of the @user_setup function.
 *
 * Returns: %TRUE on successful launch, %FALSE otherwise.
 */


/**
 * g_desktop_app_info_lookup_get_default_for_uri_scheme:
 * @lookup: a #GDesktopAppInfoLookup
 * @uri_scheme: a string containing a URI scheme.
 *
 * Gets the default application for launching applications
 * using this URI scheme for a particular GDesktopAppInfoLookup
 * implementation.
 *
 * The GDesktopAppInfoLookup interface and this function is used
 * to implement g_app_info_get_default_for_uri_scheme() backends
 * in a GIO module. There is no reason for applications to use it
 * directly. Applications should use g_app_info_get_default_for_uri_scheme().
 *
 * Returns: (transfer full): #GAppInfo for given @uri_scheme or %NULL on error.
 * Deprecated: The #GDesktopAppInfoLookup interface is deprecated and unused by gio.
 */


/**
 * g_desktop_app_info_new:
 * @desktop_id: the desktop file id
 *
 * Creates a new #GDesktopAppInfo based on a desktop file id.
 *
 * A desktop file id is the basename of the desktop file, including the
 * .desktop extension. GIO is looking for a desktop file with this name
 * in the <filename>applications</filename> subdirectories of the XDG data
 * directories (i.e. the directories specified in the
 * <envar>XDG_DATA_HOME</envar> and <envar>XDG_DATA_DIRS</envar> environment
 * variables). GIO also supports the prefix-to-subdirectory mapping that is
 * described in the <ulink url="http://standards.freedesktop.org/menu-spec/latest/">Menu Spec</ulink>
 * (i.e. a desktop id of kde-foo.desktop will match
 * <filename>/usr/share/applications/kde/foo.desktop</filename>).
 *
 * Returns: a new #GDesktopAppInfo, or %NULL if no desktop file with that id
 */


/**
 * g_desktop_app_info_new_from_filename:
 * @filename: the path of a desktop file, in the GLib filename encoding
 *
 * Creates a new #GDesktopAppInfo.
 *
 * Returns: a new #GDesktopAppInfo or %NULL on error.
 */


/**
 * g_desktop_app_info_new_from_keyfile:
 * @key_file: an opened #GKeyFile
 *
 * Creates a new #GDesktopAppInfo.
 *
 * Returns: a new #GDesktopAppInfo or %NULL on error.
 * Since: 2.18
 */


/**
 * g_desktop_app_info_set_desktop_env:
 * @desktop_env: a string specifying what desktop this is
 *
 * Sets the name of the desktop that the application is running in.
 * This is used by g_app_info_should_show() and
 * g_desktop_app_info_get_show_in() to evaluate the
 * <literal>OnlyShowIn</literal> and <literal>NotShowIn</literal>
 * desktop entry fields.
 *
 * The <ulink url="http://standards.freedesktop.org/menu-spec/latest/">Desktop
 * Menu specification</ulink> recognizes the following:
 * <simplelist>
 * <member>GNOME</member>
 * <member>KDE</member>
 * <member>ROX</member>
 * <member>XFCE</member>
 * <member>LXDE</member>
 * <member>Unity</member>
 * <member>Old</member>
 * </simplelist>
 *
 * Should be called only once; subsequent calls are ignored.
 */


/**
 * g_drive_can_eject:
 * @drive: a #GDrive.
 *
 * Checks if a drive can be ejected.
 *
 * Returns: %TRUE if the @drive can be ejected, %FALSE otherwise.
 */


/**
 * g_drive_can_poll_for_media:
 * @drive: a #GDrive.
 *
 * Checks if a drive can be polled for media changes.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if the @drive can be polled for media changes,
 */


/**
 * g_drive_can_start:
 * @drive: a #GDrive.
 *
 * Checks if a drive can be started.
 *
 * Returns: %TRUE if the @drive can be started, %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_drive_can_start_degraded:
 * @drive: a #GDrive.
 *
 * Checks if a drive can be started degraded.
 *
 * Returns: %TRUE if the @drive can be started degraded, %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_drive_can_stop:
 * @drive: a #GDrive.
 *
 * Checks if a drive can be stopped.
 *
 * Returns: %TRUE if the @drive can be stopped, %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_drive_eject:
 * @drive: a #GDrive.
 * @flags: flags affecting the unmount if required for eject
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (allow-none): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data to pass to @callback
 *
 * Asynchronously ejects a drive.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_drive_eject_finish() to obtain the
 * result of the operation.
 *
 * Deprecated: 2.22: Use g_drive_eject_with_operation() instead.
 */


/**
 * g_drive_eject_finish:
 * @drive: a #GDrive.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes ejecting a drive.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if the drive has been ejected successfully,
 * Deprecated: 2.22: Use g_drive_eject_with_operation_finish() instead.
 */


/**
 * g_drive_eject_with_operation:
 * @drive: a #GDrive.
 * @flags: flags affecting the unmount if required for eject
 * @mount_operation: (allow-none): a #GMountOperation or %NULL to avoid user interaction.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (allow-none): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Ejects a drive. This is an asynchronous operation, and is
 * finished by calling g_drive_eject_with_operation_finish() with the @drive
 * and #GAsyncResult data returned in the @callback.
 *
 * Since: 2.22
 */


/**
 * g_drive_eject_with_operation_finish:
 * @drive: a #GDrive.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes ejecting a drive. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the drive was successfully ejected. %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_drive_enumerate_identifiers:
 * @drive: a #GDrive
 *
 * Gets the kinds of identifiers that @drive has.
 * Use g_drive_get_identifer() to obtain the identifiers
 * themselves.
 *
 * array of strings containing kinds of identifiers. Use g_strfreev()
 * to free.
 *
 * Returns: (transfer full) (array zero-terminated=1): a %NULL-terminated
 */


/**
 * g_drive_get_icon:
 * @drive: a #GDrive.
 *
 * Gets the icon for @drive.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): #GIcon for the @drive.
 */


/**
 * g_drive_get_identifier:
 * @drive: a #GDrive
 * @kind: the kind of identifier to return
 *
 * Gets the identifier of the given kind for @drive.
 *
 * requested identfier, or %NULL if the #GDrive
 * doesn't have this kind of identifier.
 *
 * Returns: a newly allocated string containing the
 */


/**
 * g_drive_get_name:
 * @drive: a #GDrive.
 *
 * Gets the name of @drive.
 *
 * string should be freed when no longer needed.
 *
 * Returns: a string containing @drive's name. The returned
 */


/**
 * g_drive_get_sort_key:
 * @drive: A #GDrive.
 *
 * Gets the sort key for @drive, if any.
 *
 * Returns: Sorting key for @drive or %NULL if no such key is available.
 * Since: 2.32
 */


/**
 * g_drive_get_start_stop_type:
 * @drive: a #GDrive.
 *
 * Gets a hint about how a drive can be started/stopped.
 *
 * Returns: A value from the #GDriveStartStopType enumeration.
 * Since: 2.22
 */


/**
 * g_drive_get_volumes:
 * @drive: a #GDrive.
 *
 * Get a list of mountable volumes for @drive.
 *
 * The returned list should be freed with g_list_free(), after
 * its elements have been unreffed with g_object_unref().
 *
 * Returns: (element-type GVolume) (transfer full): #GList containing any #GVolume objects on the given @drive.
 */


/**
 * g_drive_has_media:
 * @drive: a #GDrive.
 *
 * Checks if the @drive has media. Note that the OS may not be polling
 * the drive for media changes; see g_drive_is_media_check_automatic()
 * for more details.
 *
 * Returns: %TRUE if @drive has media, %FALSE otherwise.
 */


/**
 * g_drive_has_volumes:
 * @drive: a #GDrive.
 *
 * Check if @drive has any mountable volumes.
 *
 * Returns: %TRUE if the @drive contains volumes, %FALSE otherwise.
 */


/**
 * g_drive_is_media_check_automatic:
 * @drive: a #GDrive.
 *
 * Checks if @drive is capabable of automatically detecting media changes.
 *
 * media changes, %FALSE otherwise.
 *
 * Returns: %TRUE if the @drive is capabable of automatically detecting
 */


/**
 * g_drive_is_media_removable:
 * @drive: a #GDrive.
 *
 * Checks if the @drive supports removable media.
 *
 * Returns: %TRUE if @drive supports removable media, %FALSE otherwise.
 */


/**
 * g_drive_poll_for_media:
 * @drive: a #GDrive.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (allow-none): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data to pass to @callback
 *
 * Asynchronously polls @drive to see if media has been inserted or removed.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_drive_poll_for_media_finish() to obtain the
 * result of the operation.
 */


/**
 * g_drive_poll_for_media_finish:
 * @drive: a #GDrive.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an operation started with g_drive_poll_for_media() on a drive.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if the drive has been poll_for_mediaed successfully,
 */


/**
 * g_drive_start:
 * @drive: a #GDrive.
 * @flags: flags affecting the start operation.
 * @mount_operation: (allow-none): a #GMountOperation or %NULL to avoid user interaction.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (allow-none): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data to pass to @callback
 *
 * Asynchronously starts a drive.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_drive_start_finish() to obtain the
 * result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_drive_start_finish:
 * @drive: a #GDrive.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes starting a drive.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if the drive has been started successfully,
 * Since: 2.22
 */


/**
 * g_drive_stop:
 * @drive: a #GDrive.
 * @flags: flags affecting the unmount if required for stopping.
 * @mount_operation: (allow-none): a #GMountOperation or %NULL to avoid user interaction.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (allow-none): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data to pass to @callback
 *
 * Asynchronously stops a drive.
 *
 * When the operation is finished, @callback will be called.
 * You can then call g_drive_stop_finish() to obtain the
 * result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_drive_stop_finish:
 * @drive: a #GDrive.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes stopping a drive.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if the drive has been stopped successfully,
 * Since: 2.22
 */


/**
 * g_emblem_get_icon:
 * @emblem: a #GEmblem from which the icon should be extracted.
 *
 * Gives back the icon from @emblem.
 *
 * the emblem and should not be modified or freed.
 *
 * Returns: (transfer none): a #GIcon. The returned object belongs to
 * Since: 2.18
 */


/**
 * g_emblem_get_origin:
 * @emblem: a #GEmblem
 *
 * Gets the origin of the emblem.
 *
 * Returns: (transfer none): the origin of the emblem
 * Since: 2.18
 */


/**
 * g_emblem_new:
 * @icon: a GIcon containing the icon.
 *
 * Creates a new emblem for @icon.
 *
 * Returns: a new #GEmblem.
 * Since: 2.18
 */


/**
 * g_emblem_new_with_origin:
 * @icon: a GIcon containing the icon.
 * @origin: a GEmblemOrigin enum defining the emblem's origin
 *
 * Creates a new emblem for @icon.
 *
 * Returns: a new #GEmblem.
 * Since: 2.18
 */


/**
 * g_emblemed_icon_add_emblem:
 * @emblemed: a #GEmblemedIcon
 * @emblem: a #GEmblem
 *
 * Adds @emblem to the #GList of #GEmblem <!-- -->s.
 *
 * Since: 2.18
 */


/**
 * g_emblemed_icon_clear_emblems:
 * @emblemed: a #GEmblemedIcon
 *
 * Removes all the emblems from @icon.
 *
 * Since: 2.28
 */


/**
 * g_emblemed_icon_get_emblems:
 * @emblemed: a #GEmblemedIcon
 *
 * Gets the list of emblems for the @icon.
 *
 * #GEmblem <!-- -->s that is owned by @emblemed
 *
 * Returns: (element-type Gio.Emblem) (transfer none): a #GList of
 * Since: 2.18
 */


/**
 * g_emblemed_icon_get_icon:
 * @emblemed: a #GEmblemedIcon
 *
 * Gets the main icon for @emblemed.
 *
 * Returns: (transfer none): a #GIcon that is owned by @emblemed
 * Since: 2.18
 */


/**
 * g_emblemed_icon_new:
 * @icon: a #GIcon
 * @emblem: (allow-none): a #GEmblem, or %NULL
 *
 * Creates a new emblemed icon for @icon with the emblem @emblem.
 *
 * Returns: (transfer full): a new #GIcon
 * Since: 2.18
 */


/**
 * g_file_append_to:
 * @file: input #GFile.
 * @flags: a set of #GFileCreateFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Gets an output stream for appending data to the file. If
 * the file doesn't already exist it is created.
 *
 * By default files created are generally readable by everyone,
 * but if you pass #G_FILE_CREATE_PRIVATE in @flags the file
 * will be made readable only to the current user, to the level that
 * is supported on the target filesystem.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Some file systems don't allow all file names, and may
 * return an %G_IO_ERROR_INVALID_FILENAME error.
 * If the file is a directory the %G_IO_ERROR_IS_DIRECTORY error will be
 * returned. Other errors are possible too, and depend on what kind of
 * filesystem the file is on.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileOutputStream, or %NULL on error.
 */


/**
 * g_file_append_to_async:
 * @file: input #GFile.
 * @flags: a set of #GFileCreateFlags.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously opens @file for appending.
 *
 * For more details, see g_file_append_to() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_append_to_finish() to get the result of the operation.
 */


/**
 * g_file_append_to_finish:
 * @file: input #GFile.
 * @res: #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file append operation started with
 * g_file_append_to_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a valid #GFileOutputStream or %NULL on error.
 */


/**
 * g_file_attribute_info_list_add:
 * @list: a #GFileAttributeInfoList.
 * @name: the name of the attribute to add.
 * @type: the #GFileAttributeType for the attribute.
 * @flags: #GFileAttributeInfoFlags for the attribute.
 *
 * Adds a new attribute with @name to the @list, setting
 * its @type and @flags.
 */


/**
 * g_file_attribute_info_list_dup:
 * @list: a #GFileAttributeInfoList to duplicate.
 *
 * Makes a duplicate of a file attribute info list.
 *
 * Returns: a copy of the given @list.
 */


/**
 * g_file_attribute_info_list_lookup:
 * @list: a #GFileAttributeInfoList.
 * @name: the name of the attribute to lookup.
 *
 * Gets the file attribute with the name @name from @list.
 *
 * attribute isn't found.
 *
 * Returns: a #GFileAttributeInfo for the @name, or %NULL if an
 */


/**
 * g_file_attribute_info_list_new:
 *
 * Creates a new file attribute info list.
 *
 * Returns: a #GFileAttributeInfoList.
 */


/**
 * g_file_attribute_info_list_ref:
 * @list: a #GFileAttributeInfoList to reference.
 *
 * References a file attribute info list.
 *
 * Returns: #GFileAttributeInfoList or %NULL on error.
 */


/**
 * g_file_attribute_info_list_unref:
 * @list: The #GFileAttributeInfoList to unreference.
 *
 * Removes a reference from the given @list. If the reference count
 * falls to zero, the @list is deleted.
 */


/**
 * g_file_attribute_matcher_enumerate_namespace:
 * @matcher: a #GFileAttributeMatcher.
 * @ns: a string containing a file attribute namespace.
 *
 * Checks if the matcher will match all of the keys in a given namespace.
 * This will always return %TRUE if a wildcard character is in use (e.g. if
 * matcher was created with "standard::*" and @ns is "standard", or if matcher was created
 * using "*" and namespace is anything.)
 *
 * TODO: this is awkwardly worded.
 *
 * in the given @ns, %FALSE otherwise.
 *
 * Returns: %TRUE if the matcher matches all of the entries
 */


/**
 * g_file_attribute_matcher_enumerate_next:
 * @matcher: a #GFileAttributeMatcher.
 *
 * Gets the next matched attribute from a #GFileAttributeMatcher.
 *
 * no more attribute exist.
 *
 * Returns: a string containing the next attribute or %NULL if
 */


/**
 * g_file_attribute_matcher_matches:
 * @matcher: a #GFileAttributeMatcher.
 * @attribute: a file attribute key.
 *
 * Checks if an attribute will be matched by an attribute matcher. If
 * the matcher was created with the "*" matching string, this function
 * will always return %TRUE.
 *
 * Returns: %TRUE if @attribute matches @matcher. %FALSE otherwise.
 */


/**
 * g_file_attribute_matcher_matches_only:
 * @matcher: a #GFileAttributeMatcher.
 * @attribute: a file attribute key.
 *
 * Checks if a attribute matcher only matches a given attribute. Always
 * returns %FALSE if "*" was used when creating the matcher.
 *
 * Returns: %TRUE if the matcher only matches @attribute. %FALSE otherwise.
 */


/**
 * g_file_attribute_matcher_new:
 * @attributes: an attribute string to match.
 *
 * Creates a new file attribute matcher, which matches attributes
 * against a given string. #GFileAttributeMatcher<!-- -->s are reference
 * counted structures, and are created with a reference count of 1. If
 * the number of references falls to 0, the #GFileAttributeMatcher is
 * automatically destroyed.
 *
 * The @attribute string should be formatted with specific keys separated
 * from namespaces with a double colon. Several "namespace::key" strings may be
 * concatenated with a single comma (e.g. "standard::type,standard::is-hidden").
 * The wildcard "*" may be used to match all keys and namespaces, or
 * "namespace::*" will match all keys in a given namespace.
 *
 * Examples of strings to use:
 * <table>
 * <title>File Attribute Matcher strings and results</title>
 * <tgroup cols='2' align='left'><thead>
 * <row><entry> Matcher String </entry><entry> Matches </entry></row></thead>
 * <tbody>
 * <row><entry>"*"</entry><entry>matches all attributes.</entry></row>
 * <row><entry>"standard::is-hidden"</entry><entry>matches only the key is-hidden in the standard namespace.</entry></row>
 * <row><entry>"standard::type,unix::*"</entry><entry>matches the type key in the standard namespace and
 * all keys in the unix namespace.</entry></row>
 * </tbody></tgroup>
 * </table>
 *
 * Returns: a #GFileAttributeMatcher.
 */


/**
 * g_file_attribute_matcher_ref:
 * @matcher: a #GFileAttributeMatcher.
 *
 * References a file attribute matcher.
 *
 * Returns: a #GFileAttributeMatcher.
 */


/**
 * g_file_attribute_matcher_subtract:
 * @matcher: Matcher to subtract from
 * @subtract: The matcher to subtract
 *
 * Subtracts all attributes of @subtract from @matcher and returns
 * a matcher that supports those attributes.
 *
 * Note that currently it is not possible to remove a single
 * attribute when the @matcher matches the whole namespace - or remove
 * a namespace or attribute when the matcher matches everything. This
 * is a limitation of the current implementation, but may be fixed
 * in the future.
 *
 * @matcher that are not matched by @subtract
 *
 * Returns: A file attribute matcher matching all attributes of
 */


/**
 * g_file_attribute_matcher_to_string:
 * @matcher: (allow-none): a #GFileAttributeMatcher.
 *
 * Prints what the matcher is matching against. The format will be
 * equal to the format passed to g_file_attribute_matcher_new().
 * The output however, might not be identical, as the matcher may
 * decide to use a different order or omit needless parts.
 *
 * against or %NULL if @matcher was %NULL.
 *
 * Returns: a string describing the attributes the matcher matches
 * Since: 2.32
 */


/**
 * g_file_attribute_matcher_unref:
 * @matcher: a #GFileAttributeMatcher.
 *
 * Unreferences @matcher. If the reference count falls below 1,
 * the @matcher is automatically freed.
 */


/**
 * g_file_copy:
 * @source: input #GFile.
 * @destination: destination #GFile
 * @flags: set of #GFileCopyFlags
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @progress_callback: (allow-none) (scope call): function to callback with progress information, or %NULL if progress information is not needed
 * @progress_callback_data: (closure): user data to pass to @progress_callback
 * @error: #GError to set on error, or %NULL
 *
 * Copies the file @source to the location specified by @destination.
 * Can not handle recursive copies of directories.
 *
 * If the flag #G_FILE_COPY_OVERWRITE is specified an already
 * existing @destination file is overwritten.
 *
 * If the flag #G_FILE_COPY_NOFOLLOW_SYMLINKS is specified then symlinks
 * will be copied as symlinks, otherwise the target of the
 * @source symlink will be copied.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If @progress_callback is not %NULL, then the operation can be monitored by
 * setting this to a #GFileProgressCallback function. @progress_callback_data
 * will be passed to this function. It is guaranteed that this callback will
 * be called after all data has been transferred with the total number of bytes
 * copied during the operation.
 *
 * If the @source file does not exist then the G_IO_ERROR_NOT_FOUND
 * error is returned, independent on the status of the @destination.
 *
 * If #G_FILE_COPY_OVERWRITE is not specified and the target exists, then the
 * error G_IO_ERROR_EXISTS is returned.
 *
 * If trying to overwrite a file over a directory the G_IO_ERROR_IS_DIRECTORY
 * error is returned. If trying to overwrite a directory with a directory the
 * G_IO_ERROR_WOULD_MERGE error is returned.
 *
 * If the source is a directory and the target does not exist, or
 * #G_FILE_COPY_OVERWRITE is specified and the target is a file, then the
 * G_IO_ERROR_WOULD_RECURSE error is returned.
 *
 * If you are interested in copying the #GFile object itself (not the on-disk
 * file), see g_file_dup().
 *
 * Returns: %TRUE on success, %FALSE otherwise.
 */


/**
 * g_file_copy_async: (skip)
 * @source: input #GFile.
 * @destination: destination #GFile
 * @flags: set of #GFileCopyFlags
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @progress_callback: (allow-none): function to callback with progress information, or %NULL if progress information is not needed
 * @progress_callback_data: (closure): user data to pass to @progress_callback
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Copies the file @source to the location specified by @destination
 * asynchronously. For details of the behaviour, see g_file_copy().
 *
 * If @progress_callback is not %NULL, then that function that will be called
 * just like in g_file_copy(), however the callback will run in the main loop,
 * not in the thread that is doing the I/O operation.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_copy_finish() to get the result of the operation.
 */


/**
 * g_file_copy_attributes:
 * @source: a #GFile with attributes.
 * @destination: a #GFile to copy attributes to.
 * @flags: a set of #GFileCopyFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Copies the file attributes from @source to @destination.
 *
 * Normally only a subset of the file attributes are copied,
 * those that are copies in a normal file copy operation
 * (which for instance does not include e.g. owner). However
 * if #G_FILE_COPY_ALL_METADATA is specified in @flags, then
 * all the metadata that is possible to copy is copied. This
 * is useful when implementing move by copy + delete source.
 *
 * Returns: %TRUE if the attributes were copied successfully, %FALSE otherwise.
 */


/**
 * g_file_copy_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes copying the file started with
 * g_file_copy_async().
 *
 * Returns: a %TRUE on success, %FALSE on error.
 */


/**
 * g_file_create:
 * @file: input #GFile.
 * @flags: a set of #GFileCreateFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Creates a new file and returns an output stream for writing to it.
 * The file must not already exist.
 *
 * By default files created are generally readable by everyone,
 * but if you pass #G_FILE_CREATE_PRIVATE in @flags the file
 * will be made readable only to the current user, to the level that
 * is supported on the target filesystem.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If a file or directory with this name already exists the G_IO_ERROR_EXISTS
 * error will be returned.
 * Some file systems don't allow all file names, and may
 * return an G_IO_ERROR_INVALID_FILENAME error, and if the name
 * is to long G_IO_ERROR_FILENAME_TOO_LONG will be returned.
 * Other errors are possible too, and depend on what kind of
 * filesystem the file is on.
 *
 * %NULL on error.
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileOutputStream for the newly created file, or
 */


/**
 * g_file_create_async:
 * @file: input #GFile.
 * @flags: a set of #GFileCreateFlags.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously creates a new file and returns an output stream for writing to it.
 * The file must not already exist.
 *
 * For more details, see g_file_create() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_create_finish() to get the result of the operation.
 */


/**
 * g_file_create_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file create operation started with
 * g_file_create_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileOutputStream or %NULL on error.
 */


/**
 * g_file_create_readwrite:
 * @file: a #GFile
 * @flags: a set of #GFileCreateFlags
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @error: return location for a #GError, or %NULL
 *
 * Creates a new file and returns a stream for reading and writing to it.
 * The file must not already exist.
 *
 * By default files created are generally readable by everyone,
 * but if you pass #G_FILE_CREATE_PRIVATE in @flags the file
 * will be made readable only to the current user, to the level that
 * is supported on the target filesystem.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If a file or directory with this name already exists the %G_IO_ERROR_EXISTS
 * error will be returned. Some file systems don't allow all file names,
 * and may return an %G_IO_ERROR_INVALID_FILENAME error, and if the name
 * is too long, %G_IO_ERROR_FILENAME_TOO_LONG will be returned. Other errors
 * are possible too, and depend on what kind of filesystem the file is on.
 *
 * Note that in many non-local file cases read and write streams are not
 * supported, so make sure you really need to do read and write streaming,
 * rather than just opening for reading or writing.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileIOStream for the newly created file, or %NULL on error.
 * Since: 2.22
 */


/**
 * g_file_create_readwrite_async:
 * @file: input #GFile
 * @flags: a set of #GFileCreateFlags
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously creates a new file and returns a stream for reading and
 * writing to it. The file must not already exist.
 *
 * For more details, see g_file_create_readwrite() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then
 * call g_file_create_readwrite_finish() to get the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_create_readwrite_finish:
 * @file: input #GFile
 * @res: a #GAsyncResult
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file create operation started with
 * g_file_create_readwrite_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileIOStream or %NULL on error.
 * Since: 2.22
 */


/**
 * g_file_delete:
 * @file: input #GFile.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Deletes a file. If the @file is a directory, it will only be deleted if it
 * is empty.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Virtual: delete_file
 * Returns: %TRUE if the file was deleted. %FALSE otherwise.
 */


/**
 * g_file_descriptor_based_get_fd:
 * @fd_based: a #GFileDescriptorBased.
 *
 * Gets the underlying file descriptor.
 *
 * Returns: The file descriptor
 * Since: 2.24
 */


/**
 * g_file_dup:
 * @file: input #GFile.
 *
 * Duplicates a #GFile handle. This operation does not duplicate
 * the actual file or directory represented by the #GFile; see
 * g_file_copy() if attempting to copy a file.
 *
 * This call does no blocking i/o.
 *
 * Returns: (transfer full): a new #GFile that is a duplicate of the given #GFile.
 */


/**
 * g_file_eject_mountable:
 * @file: input #GFile.
 * @flags: flags affecting the operation
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied, or %NULL.
 * @user_data: (closure): the data to pass to callback function
 *
 * Starts an asynchronous eject on a mountable.
 * When this operation has completed, @callback will be called with
 * @user_user data, and the operation can be finalized with
 * g_file_eject_mountable_finish().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Deprecated: 2.22: Use g_file_eject_mountable_with_operation() instead.
 */


/**
 * g_file_eject_mountable_finish:
 * @file: input #GFile.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous eject operation started by
 * g_file_eject_mountable().
 *
 * otherwise.
 *
 * Returns: %TRUE if the @file was ejected successfully. %FALSE
 * Deprecated: 2.22: Use g_file_eject_mountable_with_operation_finish() instead.
 */


/**
 * g_file_eject_mountable_with_operation:
 * @file: input #GFile.
 * @flags: flags affecting the operation
 * @mount_operation: a #GMountOperation, or %NULL to avoid user interaction.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied, or %NULL.
 * @user_data: (closure): the data to pass to callback function
 *
 * Starts an asynchronous eject on a mountable.
 * When this operation has completed, @callback will be called with
 * @user_user data, and the operation can be finalized with
 * g_file_eject_mountable_with_operation_finish().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Since: 2.22
 */


/**
 * g_file_eject_mountable_with_operation_finish:
 * @file: input #GFile.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous eject operation started by
 * g_file_eject_mountable_with_operation().
 *
 * otherwise.
 *
 * Returns: %TRUE if the @file was ejected successfully. %FALSE
 * Since: 2.22
 */


/**
 * g_file_enumerate_children:
 * @file: input #GFile.
 * @attributes: an attribute query string.
 * @flags: a set of #GFileQueryInfoFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: #GError for error reporting.
 *
 * Gets the requested information about the files in a directory. The result
 * is a #GFileEnumerator object that will give out #GFileInfo objects for
 * all the files in the directory.
 *
 * The @attributes value is a string that specifies the file attributes that
 * should be gathered. It is not an error if it's not possible to read a particular
 * requested attribute from a file - it just won't be set. @attributes should
 * be a comma-separated list of attributes or attribute wildcards. The wildcard "*"
 * means all attributes, and a wildcard like "standard::*" means all attributes in the standard
 * namespace. An example attribute query be "standard::*,owner::user".
 * The standard attributes are available as defines, like #G_FILE_ATTRIBUTE_STANDARD_NAME.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If the file does not exist, the G_IO_ERROR_NOT_FOUND error will be returned.
 * If the file is not a directory, the G_FILE_ERROR_NOTDIR error will be returned.
 * Other errors are possible too.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): A #GFileEnumerator if successful, %NULL on error.
 */


/**
 * g_file_enumerate_children_async:
 * @file: input #GFile.
 * @attributes: an attribute query string.
 * @flags: a set of #GFileQueryInfoFlags.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously gets the requested information about the files in a directory. The result
 * is a #GFileEnumerator object that will give out #GFileInfo objects for
 * all the files in the directory.
 *
 * For more details, see g_file_enumerate_children() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_enumerate_children_finish() to get the result of the operation.
 */


/**
 * g_file_enumerate_children_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @error: a #GError.
 *
 * Finishes an async enumerate children operation.
 * See g_file_enumerate_children_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileEnumerator or %NULL if an error occurred.
 */


/**
 * g_file_enumerator_close:
 * @enumerator: a #GFileEnumerator.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Releases all resources used by this enumerator, making the
 * enumerator return %G_IO_ERROR_CLOSED on all calls.
 *
 * This will be automatically called when the last reference
 * is dropped, but you might want to call this function to make
 * sure resources are released as early as possible.
 *
 * Returns: #TRUE on success or #FALSE on error.
 */


/**
 * g_file_enumerator_close_async:
 * @enumerator: a #GFileEnumerator.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously closes the file enumerator.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned in
 * g_file_enumerator_close_finish().
 */


/**
 * g_file_enumerator_close_finish:
 * @enumerator: a #GFileEnumerator.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes closing a file enumerator, started from g_file_enumerator_close_async().
 *
 * If the file enumerator was already closed when g_file_enumerator_close_async()
 * was called, then this function will report %G_IO_ERROR_CLOSED in @error, and
 * return %FALSE. If the file enumerator had pending operation when the close
 * operation was started, then this function will report %G_IO_ERROR_PENDING, and
 * return %FALSE.  If @cancellable was not %NULL, then the operation may have been
 * cancelled by triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be set, and %FALSE will be
 * returned.
 *
 * Returns: %TRUE if the close operation has finished successfully.
 */


/**
 * g_file_enumerator_get_container:
 * @enumerator: a #GFileEnumerator
 *
 * Get the #GFile container which is being enumerated.
 *
 * Returns: (transfer none): the #GFile which is being enumerated.
 * Since: 2.18
 */


/**
 * g_file_enumerator_has_pending:
 * @enumerator: a #GFileEnumerator.
 *
 * Checks if the file enumerator has pending operations.
 *
 * Returns: %TRUE if the @enumerator has pending operations.
 */


/**
 * g_file_enumerator_is_closed:
 * @enumerator: a #GFileEnumerator.
 *
 * Checks if the file enumerator has been closed.
 *
 * Returns: %TRUE if the @enumerator is closed.
 */


/**
 * g_file_enumerator_next_file:
 * @enumerator: a #GFileEnumerator.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Returns information for the next file in the enumerated object.
 * Will block until the information is available. The #GFileInfo
 * returned from this function will contain attributes that match the
 * attribute string that was passed when the #GFileEnumerator was created.
 *
 * On error, returns %NULL and sets @error to the error. If the
 * enumerator is at the end, %NULL will be returned and @error will
 * be unset.
 *
 * Free the returned object with g_object_unref() when no longer needed.
 *
 * Returns: (transfer full): A #GFileInfo or %NULL on error or end of enumerator.
 */


/**
 * g_file_enumerator_next_files_async:
 * @enumerator: a #GFileEnumerator.
 * @num_files: the number of file info objects to request
 * @io_priority: the <link linkend="gioscheduler">io priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Request information for a number of files from the enumerator asynchronously.
 * When all i/o for the operation is finished the @callback will be called with
 * the requested information.
 *
 * The callback can be called with less than @num_files files in case of error
 * or at the end of the enumerator. In case of a partial error the callback will
 * be called with any succeeding items and no error, and on the next request the
 * error will be reported. If a request is cancelled the callback will be called
 * with %G_IO_ERROR_CANCELLED.
 *
 * During an async request no other sync and async calls are allowed, and will
 * result in %G_IO_ERROR_PENDING errors.
 *
 * Any outstanding i/o request with higher priority (lower numerical value) will
 * be executed before an outstanding request with lower priority. Default
 * priority is %G_PRIORITY_DEFAULT.
 */


/**
 * g_file_enumerator_next_files_finish:
 * @enumerator: a #GFileEnumerator.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes the asynchronous operation started with g_file_enumerator_next_files_async().
 *
 * g_list_free() and unref the infos with g_object_unref() when you're
 * done with them.
 *
 * Returns: (transfer full) (element-type Gio.FileInfo): a #GList of #GFileInfo<!---->s. You must free the list with
 */


/**
 * g_file_enumerator_set_pending:
 * @enumerator: a #GFileEnumerator.
 * @pending: a boolean value.
 *
 * Sets the file enumerator as having pending operations.
 */


/**
 * g_file_equal:
 * @file1: the first #GFile.
 * @file2: the second #GFile.
 *
 * Checks equality of two given #GFile<!-- -->s. Note that two
 * #GFile<!-- -->s that differ can still refer to the same
 * file on the filesystem due to various forms of filename
 * aliasing.
 *
 * This call does no blocking i/o.
 *
 * %FALSE if either is not a #GFile.
 *
 * Returns: %TRUE if @file1 and @file2 are equal.
 */


/**
 * g_file_find_enclosing_mount:
 * @file: input #GFile.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError.
 *
 * Gets a #GMount for the #GFile.
 *
 * If the #GFileIface for @file does not have a mount (e.g. possibly a
 * remote share), @error will be set to %G_IO_ERROR_NOT_FOUND and %NULL
 * will be returned.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GMount where the @file is located or %NULL on error.
 */


/**
 * g_file_find_enclosing_mount_async:
 * @file: a #GFile
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously gets the mount for the file.
 *
 * For more details, see g_file_find_enclosing_mount() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_find_enclosing_mount_finish() to get the result of the operation.
 */


/**
 * g_file_find_enclosing_mount_finish:
 * @file: a #GFile
 * @res: a #GAsyncResult
 * @error: a #GError
 *
 * Finishes an asynchronous find mount request.
 * See g_file_find_enclosing_mount_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): #GMount for given @file or %NULL on error.
 */


/**
 * g_file_get_basename:
 * @file: input #GFile.
 *
 * Gets the base name (the last component of the path) for a given #GFile.
 *
 * If called for the top level of a system (such as the filesystem root
 * or a uri like sftp://host/) it will return a single directory separator
 * (and on Windows, possibly a drive letter).
 *
 * The base name is a byte string (*not* UTF-8). It has no defined encoding
 * or rules other than it may not contain zero bytes.  If you want to use
 * filenames in a user interface you should use the display name that you
 * can get by requesting the %G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME
 * attribute with g_file_query_info().
 *
 * This call does no blocking i/o.
 *
 * if given #GFile is invalid. The returned string should be
 * freed with g_free() when no longer needed.
 *
 * Returns: string containing the #GFile's base name, or %NULL
 */


/**
 * g_file_get_child:
 * @file: input #GFile.
 * @name: string containing the child's basename.
 *
 * Gets a child of @file with basename equal to @name.
 *
 * Note that the file with that specific name might not exist, but
 * you can still have a #GFile that points to it. You can use this
 * for instance to create that file.
 *
 * This call does no blocking i/o.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFile to a child specified by @name.
 */


/**
 * g_file_get_child_for_display_name:
 * @file: input #GFile.
 * @display_name: string to a possible child.
 * @error: #GError.
 *
 * Gets the child of @file for a given @display_name (i.e. a UTF8
 * version of the name). If this function fails, it returns %NULL and @error will be
 * set. This is very useful when constructing a GFile for a new file
 * and the user entered the filename in the user interface, for instance
 * when you select a directory and type a filename in the file selector.
 *
 * This call does no blocking i/o.
 *
 * %NULL if the display name couldn't be converted.
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFile to the specified child, or
 */


/**
 * g_file_get_parent:
 * @file: input #GFile.
 *
 * Gets the parent directory for the @file.
 * If the @file represents the root directory of the
 * file system, then %NULL will be returned.
 *
 * This call does no blocking i/o.
 *
 * #GFile or %NULL if there is no parent.
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFile structure to the parent of the given
 */


/**
 * g_file_get_parse_name:
 * @file: input #GFile.
 *
 * Gets the parse name of the @file.
 * A parse name is a UTF-8 string that describes the
 * file such that one can get the #GFile back using
 * g_file_parse_name().
 *
 * This is generally used to show the #GFile as a nice
 * full-pathname kind of string in a user interface,
 * like in a location entry.
 *
 * For local files with names that can safely be converted
 * to UTF8 the pathname is used, otherwise the IRI is used
 * (a form of URI that allows UTF8 characters unescaped).
 *
 * This call does no blocking i/o.
 *
 * string should be freed with g_free() when no longer needed.
 *
 * Returns: a string containing the #GFile's parse name. The returned
 */


/**
 * g_file_get_path:
 * @file: input #GFile.
 *
 * Gets the local pathname for #GFile, if one exists.
 *
 * This call does no blocking i/o.
 *
 * no such path exists. The returned string should be
 * freed with g_free() when no longer needed.
 *
 * Returns: string containing the #GFile's path, or %NULL if
 */


/**
 * g_file_get_relative_path:
 * @parent: input #GFile.
 * @descendant: input #GFile.
 *
 * Gets the path for @descendant relative to @parent.
 *
 * This call does no blocking i/o.
 *
 * to @parent, or %NULL if @descendant doesn't have @parent as prefix.
 * The returned string should be freed with g_free() when no longer needed.
 *
 * Returns: string with the relative path from @descendant
 */


/**
 * g_file_get_uri:
 * @file: input #GFile.
 *
 * Gets the URI for the @file.
 *
 * This call does no blocking i/o.
 *
 * The returned string should be freed with g_free() when no longer needed.
 *
 * Returns: a string containing the #GFile's URI.
 */


/**
 * g_file_get_uri_scheme:
 * @file: input #GFile.
 *
 * Gets the URI scheme for a #GFile.
 * RFC 3986 decodes the scheme as:
 * <programlisting>
 * URI = scheme ":" hier-part [ "?" query ] [ "#" fragment ]
 * </programlisting>
 * Common schemes include "file", "http", "ftp", etc.
 *
 * This call does no blocking i/o.
 *
 * #GFile. The returned string should be freed with g_free()
 * when no longer needed.
 *
 * Returns: a string containing the URI scheme for the given
 */


/**
 * g_file_has_parent:
 * @file: input #GFile
 * @parent: the parent to check for, or %NULL
 *
 * Checks if @file has a parent, and optionally, if it is @parent.
 *
 * If @parent is %NULL then this function returns %TRUE if @file has any
 * parent at all.  If @parent is non-%NULL then %TRUE is only returned
 * if @file is a child of @parent.
 *
 * case that @parent is %NULL).
 *
 * Returns: %TRUE if @file is a child of @parent (or any parent in the
 * Since: 2.24
 */


/**
 * g_file_has_prefix:
 * @file: input #GFile.
 * @prefix: input #GFile.
 *
 * Checks whether @file has the prefix specified by @prefix. In other word,
 * if the names of initial elements of @file<!-- -->s pathname match @prefix.
 * Only full pathname elements are matched, so a path like /foo is not
 * considered a prefix of /foobar, only of /foo/bar.
 *
 * This call does no i/o, as it works purely on names. As such it can
 * sometimes return %FALSE even if @file is inside a @prefix (from a
 * filesystem point of view), because the prefix of @file is an alias
 * of @prefix.
 *
 * %FALSE otherwise.
 *
 * Virtual: prefix_matches
 * Returns: %TRUE if the @files's parent, grandparent, etc is @prefix.
 */


/**
 * g_file_has_uri_scheme:
 * @file: input #GFile.
 * @uri_scheme: a string containing a URI scheme.
 *
 * Checks to see if a #GFile has a given URI scheme.
 *
 * This call does no blocking i/o.
 *
 * given URI scheme, %FALSE if URI scheme is %NULL,
 * not supported, or #GFile is invalid.
 *
 * Returns: %TRUE if #GFile's backend supports the
 */


/**
 * g_file_hash:
 * @file: (type GFile): #gconstpointer to a #GFile.
 *
 * Creates a hash value for a #GFile.
 *
 * This call does no blocking i/o.
 *
 * integer that can be used as hash value for the #GFile.
 * This function is intended for easily hashing a #GFile to
 * add to a #GHashTable or similar data structure.
 *
 * Virtual: hash
 * Returns: 0 if @file is not a valid #GFile, otherwise an
 */


/**
 * g_file_icon_get_file:
 * @icon: a #GIcon.
 *
 * Gets the #GFile associated with the given @icon.
 *
 * Returns: (transfer none): a #GFile, or %NULL.
 */


/**
 * g_file_icon_new:
 * @file: a #GFile.
 *
 * Creates a new icon for a file.
 *
 * Returns: (transfer full): a #GIcon for the given @file, or %NULL on error.
 */


/**
 * g_file_info_clear_status:
 * @info: a #GFileInfo.
 *
 * Clears the status information from @info.
 */


/**
 * g_file_info_copy_into:
 * @src_info: source to copy attributes from.
 * @dest_info: destination to copy attributes to.
 *
 * Copies all of the #GFileAttribute<!-- -->s from @src_info to @dest_info.
 */


/**
 * g_file_info_dup:
 * @other: a #GFileInfo.
 *
 * Duplicates a file info structure.
 *
 * Returns: (transfer full): a duplicate #GFileInfo of @other.
 */


/**
 * g_file_info_get_attribute_as_string:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a attribute, formated as a string.
 * This escapes things as needed to make the string valid
 * utf8.
 *
 * When you're done with the string it must be freed with g_free().
 *
 * Returns: a UTF-8 string associated with the given @attribute.
 */


/**
 * g_file_info_get_attribute_boolean:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a boolean attribute. If the attribute does not
 * contain a boolean value, %FALSE will be returned.
 *
 * Returns: the boolean value contained within the attribute.
 */


/**
 * g_file_info_get_attribute_byte_string:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a byte string attribute. If the attribute does
 * not contain a byte string, %NULL will be returned.
 *
 * %NULL otherwise.
 *
 * Returns: the contents of the @attribute value as a byte string, or
 */


/**
 * g_file_info_get_attribute_data:
 * @info: a #GFileInfo
 * @attribute: a file attribute key
 * @type: (out) (allow-none): return location for the attribute type, or %NULL
 * @value_pp: (out) (allow-none): return location for the attribute value, or %NULL
 * @status: (out) (allow-none): return location for the attribute status, or %NULL
 *
 * Gets the attribute type, value and status for an attribute key.
 *
 * %FALSE otherwise.
 *
 * Returns: (transfer none): %TRUE if @info has an attribute named @attribute,
 */


/**
 * g_file_info_get_attribute_int32:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets a signed 32-bit integer contained within the attribute. If the
 * attribute does not contain a signed 32-bit integer, or is invalid,
 * 0 will be returned.
 *
 * Returns: a signed 32-bit integer from the attribute.
 */


/**
 * g_file_info_get_attribute_int64:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets a signed 64-bit integer contained within the attribute. If the
 * attribute does not contain an signed 64-bit integer, or is invalid,
 * 0 will be returned.
 *
 * Returns: a signed 64-bit integer from the attribute.
 */


/**
 * g_file_info_get_attribute_object:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a #GObject attribute. If the attribute does
 * not contain a #GObject, %NULL will be returned.
 *
 * %NULL otherwise.
 *
 * Returns: (transfer none): a #GObject associated with the given @attribute, or
 */


/**
 * g_file_info_get_attribute_status:
 * @info: a #GFileInfo
 * @attribute: a file attribute key
 *
 * Gets the attribute status for an attribute key.
 *
 * %G_FILE_ATTRIBUTE_STATUS_UNSET if the key is invalid.
 *
 * Returns: a #GFileAttributeStatus for the given @attribute, or
 */


/**
 * g_file_info_get_attribute_string:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a string attribute. If the attribute does
 * not contain a string, %NULL will be returned.
 *
 * %NULL otherwise.
 *
 * Returns: the contents of the @attribute value as a UTF-8 string, or
 */


/**
 * g_file_info_get_attribute_stringv:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the value of a stringv attribute. If the attribute does
 * not contain a stringv, %NULL will be returned.
 *
 * %NULL otherwise. Do not free. These returned strings are UTF-8.
 *
 * Returns: (transfer none): the contents of the @attribute value as a stringv, or
 * Since: 2.22
 */


/**
 * g_file_info_get_attribute_type:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets the attribute type for an attribute key.
 *
 * %G_FILE_ATTRIBUTE_TYPE_INVALID if the key is not set.
 *
 * Returns: a #GFileAttributeType for the given @attribute, or
 */


/**
 * g_file_info_get_attribute_uint32:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets an unsigned 32-bit integer contained within the attribute. If the
 * attribute does not contain an unsigned 32-bit integer, or is invalid,
 * 0 will be returned.
 *
 * Returns: an unsigned 32-bit integer from the attribute.
 */


/**
 * g_file_info_get_attribute_uint64:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Gets a unsigned 64-bit integer contained within the attribute. If the
 * attribute does not contain an unsigned 64-bit integer, or is invalid,
 * 0 will be returned.
 *
 * Returns: a unsigned 64-bit integer from the attribute.
 */


/**
 * g_file_info_get_content_type:
 * @info: a #GFileInfo.
 *
 * Gets the file's content type.
 *
 * Returns: a string containing the file's content type.
 */


/**
 * g_file_info_get_display_name:
 * @info: a #GFileInfo.
 *
 * Gets a display name for a file.
 *
 * Returns: a string containing the display name.
 */


/**
 * g_file_info_get_edit_name:
 * @info: a #GFileInfo.
 *
 * Gets the edit name for a file.
 *
 * Returns: a string containing the edit name.
 */


/**
 * g_file_info_get_etag:
 * @info: a #GFileInfo.
 *
 * Gets the <link linkend="gfile-etag">entity tag</link> for a given
 * #GFileInfo. See %G_FILE_ATTRIBUTE_ETAG_VALUE.
 *
 * Returns: a string containing the value of the "etag:value" attribute.
 */


/**
 * g_file_info_get_file_type:
 * @info: a #GFileInfo.
 *
 * Gets a file's type (whether it is a regular file, symlink, etc).
 * This is different from the file's content type, see g_file_info_get_content_type().
 *
 * Returns: a #GFileType for the given file.
 */


/**
 * g_file_info_get_icon:
 * @info: a #GFileInfo.
 *
 * Gets the icon for a file.
 *
 * Returns: (transfer none): #GIcon for the given @info.
 */


/**
 * g_file_info_get_is_backup:
 * @info: a #GFileInfo.
 *
 * Checks if a file is a backup file.
 *
 * Returns: %TRUE if file is a backup file, %FALSE otherwise.
 */


/**
 * g_file_info_get_is_hidden:
 * @info: a #GFileInfo.
 *
 * Checks if a file is hidden.
 *
 * Returns: %TRUE if the file is a hidden file, %FALSE otherwise.
 */


/**
 * g_file_info_get_is_symlink:
 * @info: a #GFileInfo.
 *
 * Checks if a file is a symlink.
 *
 * Returns: %TRUE if the given @info is a symlink.
 */


/**
 * g_file_info_get_modification_time:
 * @info: a #GFileInfo.
 * @result: (out caller-allocates): a #GTimeVal.
 *
 * Gets the modification time of the current @info and sets it
 * in @result.
 */


/**
 * g_file_info_get_name:
 * @info: a #GFileInfo.
 *
 * Gets the name for a file.
 *
 * Returns: a string containing the file name.
 */


/**
 * g_file_info_get_size:
 * @info: a #GFileInfo.
 *
 * Gets the file's size.
 *
 * Returns: a #goffset containing the file's size.
 */


/**
 * g_file_info_get_sort_order:
 * @info: a #GFileInfo.
 *
 * Gets the value of the sort_order attribute from the #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_SORT_ORDER.
 *
 * Returns: a #gint32 containing the value of the "standard::sort_order" attribute.
 */


/**
 * g_file_info_get_symlink_target:
 * @info: a #GFileInfo.
 *
 * Gets the symlink target for a given #GFileInfo.
 *
 * Returns: a string containing the symlink target.
 */


/**
 * g_file_info_has_attribute:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Checks if a file info structure has an attribute named @attribute.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if @Ginfo has an attribute named @attribute,
 */


/**
 * g_file_info_has_namespace:
 * @info: a #GFileInfo.
 * @name_space: a file attribute namespace.
 *
 * Checks if a file info structure has an attribute in the
 * specified @name_space.
 *
 * %FALSE otherwise.
 *
 * Returns: %TRUE if @Ginfo has an attribute in @name_space,
 * Since: 2.22
 */


/**
 * g_file_info_list_attributes:
 * @info: a #GFileInfo.
 * @name_space: a file attribute key's namespace.
 *
 * Lists the file info structure's attributes.
 *
 * possible attribute types for the given @name_space, or
 * %NULL on error.
 *
 * Returns: (array zero-terminated=1) (transfer full): a null-terminated array of strings of all of the
 */


/**
 * g_file_info_new:
 *
 * Creates a new file info structure.
 *
 * Returns: a #GFileInfo.
 */


/**
 * g_file_info_remove_attribute:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 *
 * Removes all cases of @attribute from @info if it exists.
 */


/**
 * g_file_info_set_attribute:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @type: a #GFileAttributeType
 * @value_p: pointer to the value
 *
 * Sets the @attribute to contain the given value, if possible.
 */


/**
 * g_file_info_set_attribute_boolean:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: a boolean value.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_byte_string:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: a byte string.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_int32:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: a signed 32-bit integer
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_int64:
 * @info: a #GFileInfo.
 * @attribute: attribute name to set.
 * @attr_value: int64 value to set attribute to.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_mask:
 * @info: a #GFileInfo.
 * @mask: a #GFileAttributeMatcher.
 *
 * Sets @mask on @info to match specific attribute types.
 */


/**
 * g_file_info_set_attribute_object:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: a #GObject.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_status:
 * @info: a #GFileInfo
 * @attribute: a file attribute key
 * @status: a #GFileAttributeStatus
 *
 * Sets the attribute status for an attribute key. This is only
 * needed by external code that implement g_file_set_attributes_from_info()
 * or similar functions.
 *
 * The attribute must exist in @info for this to work. Otherwise %FALSE
 * is returned and @info is unchanged.
 *
 * Returns: %TRUE if the status was changed, %FALSE if the key was not set.
 * Since: 2.22
 */


/**
 * g_file_info_set_attribute_string:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: a UTF-8 string.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_stringv:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key
 * @attr_value: a %NULL terminated array of UTF-8 strings.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 *
 * Sinze: 2.22
 */


/**
 * g_file_info_set_attribute_uint32:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: an unsigned 32-bit integer.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_attribute_uint64:
 * @info: a #GFileInfo.
 * @attribute: a file attribute key.
 * @attr_value: an unsigned 64-bit integer.
 *
 * Sets the @attribute to contain the given @attr_value,
 * if possible.
 */


/**
 * g_file_info_set_content_type:
 * @info: a #GFileInfo.
 * @content_type: a content type. See <link linkend="gio-GContentType">GContentType</link>.
 *
 * Sets the content type attribute for a given #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE.
 */


/**
 * g_file_info_set_display_name:
 * @info: a #GFileInfo.
 * @display_name: a string containing a display name.
 *
 * Sets the display name for the current #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME.
 */


/**
 * g_file_info_set_edit_name:
 * @info: a #GFileInfo.
 * @edit_name: a string containing an edit name.
 *
 * Sets the edit name for the current file.
 * See %G_FILE_ATTRIBUTE_STANDARD_EDIT_NAME.
 */


/**
 * g_file_info_set_file_type:
 * @info: a #GFileInfo.
 * @type: a #GFileType.
 *
 * Sets the file type in a #GFileInfo to @type.
 * See %G_FILE_ATTRIBUTE_STANDARD_TYPE.
 */


/**
 * g_file_info_set_icon:
 * @info: a #GFileInfo.
 * @icon: a #GIcon.
 *
 * Sets the icon for a given #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_ICON.
 */


/**
 * g_file_info_set_is_hidden:
 * @info: a #GFileInfo.
 * @is_hidden: a #gboolean.
 *
 * Sets the "is_hidden" attribute in a #GFileInfo according to @is_symlink.
 * See %G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN.
 */


/**
 * g_file_info_set_is_symlink:
 * @info: a #GFileInfo.
 * @is_symlink: a #gboolean.
 *
 * Sets the "is_symlink" attribute in a #GFileInfo according to @is_symlink.
 * See %G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK.
 */


/**
 * g_file_info_set_modification_time:
 * @info: a #GFileInfo.
 * @mtime: a #GTimeVal.
 *
 * Sets the %G_FILE_ATTRIBUTE_TIME_MODIFIED attribute in the file
 * info to the given time value.
 */


/**
 * g_file_info_set_name:
 * @info: a #GFileInfo.
 * @name: a string containing a name.
 *
 * Sets the name attribute for the current #GFileInfo.
 * See %G_FILE_ATTRIBUTE_STANDARD_NAME.
 */


/**
 * g_file_info_set_size:
 * @info: a #GFileInfo.
 * @size: a #goffset containing the file's size.
 *
 * Sets the %G_FILE_ATTRIBUTE_STANDARD_SIZE attribute in the file info
 * to the given size.
 */


/**
 * g_file_info_set_sort_order:
 * @info: a #GFileInfo.
 * @sort_order: a sort order integer.
 *
 * Sets the sort order attribute in the file info structure. See
 * %G_FILE_ATTRIBUTE_STANDARD_SORT_ORDER.
 */


/**
 * g_file_info_set_symlink_target:
 * @info: a #GFileInfo.
 * @symlink_target: a static string containing a path to a symlink target.
 *
 * Sets the %G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET attribute in the file info
 * to the given symlink target.
 */


/**
 * g_file_info_unset_attribute_mask:
 * @info: #GFileInfo.
 *
 * Unsets a mask set by g_file_info_set_attribute_mask(), if one
 * is set.
 */


/**
 * g_file_input_stream_query_info:
 * @stream: a #GFileInputStream.
 * @attributes: a file attribute query string.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Queries a file input stream the given @attributes. This function blocks
 * while querying the stream. For the asynchronous (non-blocking) version
 * of this function, see g_file_input_stream_query_info_async(). While the
 * stream is blocked, the stream will set the pending flag internally, and
 * any other operations on the stream will fail with %G_IO_ERROR_PENDING.
 *
 * Returns: (transfer full): a #GFileInfo, or %NULL on error.
 */


/**
 * g_file_input_stream_query_info_async:
 * @stream: a #GFileInputStream.
 * @attributes: a file attribute query string.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): callback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Queries the stream information asynchronously.
 * When the operation is finished @callback will be called.
 * You can then call g_file_input_stream_query_info_finish()
 * to get the result of the operation.
 *
 * For the synchronous version of this function,
 * see g_file_input_stream_query_info().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be set
 */


/**
 * g_file_input_stream_query_info_finish:
 * @stream: a #GFileInputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes an asynchronous info query operation.
 *
 * Returns: (transfer full): #GFileInfo.
 */


/**
 * g_file_io_stream_get_etag:
 * @stream: a #GFileIOStream.
 *
 * Gets the entity tag for the file when it has been written.
 * This must be called after the stream has been written
 * and closed, as the etag can change while writing.
 *
 * Returns: the entity tag for the stream.
 * Since: 2.22
 */


/**
 * g_file_io_stream_query_info:
 * @stream: a #GFileIOStream.
 * @attributes: a file attribute query string.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Queries a file io stream for the given @attributes.
 * This function blocks while querying the stream. For the asynchronous
 * version of this function, see g_file_io_stream_query_info_async().
 * While the stream is blocked, the stream will set the pending flag
 * internally, and any other operations on the stream will fail with
 * %G_IO_ERROR_PENDING.
 *
 * Can fail if the stream was already closed (with @error being set to
 * %G_IO_ERROR_CLOSED), the stream has pending operations (with @error being
 * set to %G_IO_ERROR_PENDING), or if querying info is not supported for
 * the stream's interface (with @error being set to %G_IO_ERROR_NOT_SUPPORTED). I
 * all cases of failure, %NULL will be returned.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be set, and %NULL will
 * be returned.
 *
 * Returns: (transfer full): a #GFileInfo for the @stream, or %NULL on error.
 * Since: 2.22
 */


/**
 * g_file_io_stream_query_info_async:
 * @stream: a #GFileIOStream.
 * @attributes: a file attribute query string.
 * @io_priority: the <link linkend="gio-GIOScheduler">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): callback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously queries the @stream for a #GFileInfo. When completed,
 * @callback will be called with a #GAsyncResult which can be used to
 * finish the operation with g_file_io_stream_query_info_finish().
 *
 * For the synchronous version of this function, see
 * g_file_io_stream_query_info().
 *
 * Since: 2.22
 */


/**
 * g_file_io_stream_query_info_finish:
 * @stream: a #GFileIOStream.
 * @result: a #GAsyncResult.
 * @error: a #GError, %NULL to ignore.
 *
 * Finalizes the asynchronous query started
 * by g_file_io_stream_query_info_async().
 *
 * Returns: (transfer full): A #GFileInfo for the finished query.
 * Since: 2.22
 */


/**
 * g_file_is_native:
 * @file: input #GFile.
 *
 * Checks to see if a file is native to the platform.
 *
 * A native file s one expressed in the platform-native filename format,
 * e.g. "C:\Windows" or "/usr/bin/". This does not mean the file is local,
 * as it might be on a locally mounted remote filesystem.
 *
 * On some systems non-native files may be available using
 * the native filesystem via a userspace filesystem (FUSE), in
 * these cases this call will return %FALSE, but g_file_get_path()
 * will still return a native path.
 *
 * This call does no blocking i/o.
 *
 * Returns: %TRUE if file is native.
 */


/**
 * g_file_load_contents:
 * @file: input #GFile.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @contents: (out) (transfer full) (element-type guint8) (array length=length): a location to place the contents of the file.
 * @length: (out) (allow-none): a location to place the length of the contents of the file, or %NULL if the length is not needed
 * @etag_out: (out) (allow-none): a location to place the current entity tag for the file, or %NULL if the entity tag is not needed
 * @error: a #GError, or %NULL
 *
 * Loads the content of the file into memory. The data is always
 * zero-terminated, but this is not included in the resultant @length.
 * The returned @content should be freed with g_free() when no longer
 * needed.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * %FALSE if there were errors.
 *
 * Returns: %TRUE if the @file's contents were successfully loaded.
 */


/**
 * g_file_load_contents_async:
 * @file: input #GFile.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Starts an asynchronous load of the @file's contents.
 *
 * For more details, see g_file_load_contents() which is
 * the synchronous version of this call.
 *
 * When the load operation has completed, @callback will be called
 * with @user data. To finish the operation, call
 * g_file_load_contents_finish() with the #GAsyncResult returned by
 * the @callback.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 */


/**
 * g_file_load_contents_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @contents: (out) (transfer full) (element-type guint8) (array length=length): a location to place the contents of the file.
 * @length: (out) (allow-none): a location to place the length of the contents of the file, or %NULL if the length is not needed
 * @etag_out: (out) (allow-none): a location to place the current entity tag for the file, or %NULL if the entity tag is not needed
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous load of the @file's contents.
 * The contents are placed in @contents, and @length is set to the
 * size of the @contents string. The @content should be freed with
 * g_free() when no longer needed. If @etag_out is present, it will be
 * set to the new entity tag for the @file.
 *
 * present, it will be set appropriately.
 *
 * Returns: %TRUE if the load was successful. If %FALSE and @error is
 */


/**
 * g_file_load_partial_contents_async: (skip)
 * @file: input #GFile.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @read_more_callback: a #GFileReadMoreCallback to receive partial data and to specify whether further data should be read.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to the callback functions.
 *
 * Reads the partial contents of a file. A #GFileReadMoreCallback should be
 * used to stop reading from the file when appropriate, else this function
 * will behave exactly as g_file_load_contents_async(). This operation
 * can be finished by g_file_load_partial_contents_finish().
 *
 * Users of this function should be aware that @user_data is passed to
 * both the @read_more_callback and the @callback.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 */


/**
 * g_file_load_partial_contents_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @contents: (out) (transfer full) (element-type guint8) (array length=length): a location to place the contents of the file.
 * @length: (out) (allow-none): a location to place the length of the contents of the file, or %NULL if the length is not needed
 * @etag_out: (out) (allow-none): a location to place the current entity tag for the file, or %NULL if the entity tag is not needed
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous partial load operation that was started
 * with g_file_load_partial_contents_async(). The data is always
 * zero-terminated, but this is not included in the resultant @length.
 * The returned @content should be freed with g_free() when no longer
 * needed.
 *
 * present, it will be set appropriately.
 *
 * Returns: %TRUE if the load was successful. If %FALSE and @error is
 */


/**
 * g_file_make_directory:
 * @file: input #GFile.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Creates a directory. Note that this will only create a child directory of
 * the immediate parent directory of the path or URI given by the #GFile. To
 * recursively create directories, see g_file_make_directory_with_parents().
 * This function will fail if the parent directory does not exist, setting
 * @error to %G_IO_ERROR_NOT_FOUND. If the file system doesn't support creating
 * directories, this function will fail, setting @error to
 * %G_IO_ERROR_NOT_SUPPORTED.
 *
 * For a local #GFile the newly created directory will have the default
 * (current) ownership and permissions of the current process.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE on successful creation, %FALSE otherwise.
 */


/**
 * g_file_make_directory_with_parents:
 * @file: input #GFile.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Creates a directory and any parent directories that may not exist similar to
 * 'mkdir -p'. If the file system does not support creating directories, this
 * function will fail, setting @error to %G_IO_ERROR_NOT_SUPPORTED. If the
 * directory itself already exists, this function will fail setting @error
 * to %G_IO_ERROR_EXISTS, unlike the similar g_mkdir_with_parents().
 *
 * For a local #GFile the newly created directories will have the default
 * (current) ownership and permissions of the current process.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * otherwise.
 *
 * Returns: %TRUE if all directories have been successfully created, %FALSE
 * Since: 2.18
 */


/**
 * g_file_make_symbolic_link:
 * @file: a #GFile with the name of the symlink to create
 * @symlink_value: a string with the path for the target of the new symlink
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError.
 *
 * Creates a symbolic link named @file which contains the string
 * @symlink_value.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE on the creation of a new symlink, %FALSE otherwise.
 */


/**
 * g_file_monitor:
 * @file: input #GFile
 * @flags: a set of #GFileMonitorFlags
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @error: a #GError, or %NULL
 *
 * Obtains a file or directory monitor for the given file, depending
 * on the type of the file.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileMonitor for the given @file, or %NULL on error.
 * Since: 2.18
 */


/**
 * g_file_monitor_cancel:
 * @monitor: a #GFileMonitor.
 *
 * Cancels a file monitor.
 *
 * Returns: %TRUE if monitor was cancelled.
 */


/**
 * g_file_monitor_directory:
 * @file: input #GFile.
 * @flags: a set of #GFileMonitorFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL.
 *
 * Obtains a directory monitor for the given file.
 * This may fail if directory monitoring is not supported.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Free the returned object with g_object_unref().
 *
 * Virtual: monitor_dir
 * Returns: (transfer full): a #GFileMonitor for the given @file, or %NULL on error.
 */


/**
 * g_file_monitor_emit_event:
 * @monitor: a #GFileMonitor.
 * @child: a #GFile.
 * @other_file: a #GFile.
 * @event_type: a set of #GFileMonitorEvent flags.
 *
 * Emits the #GFileMonitor::changed signal if a change
 * has taken place. Should be called from file monitor
 * implementations only.
 *
 * The signal will be emitted from an idle handler (in the <link
 * linkend="g-main-context-push-thread-default">thread-default main
 * context</link>).
 */


/**
 * g_file_monitor_file:
 * @file: input #GFile.
 * @flags: a set of #GFileMonitorFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL.
 *
 * Obtains a file monitor for the given file. If no file notification
 * mechanism exists, then regular polling of the file is used.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileMonitor for the given @file, or %NULL on error.
 */


/**
 * g_file_monitor_is_cancelled:
 * @monitor: a #GFileMonitor
 *
 * Returns whether the monitor is canceled.
 *
 * Returns: %TRUE if monitor is canceled. %FALSE otherwise.
 */


/**
 * g_file_monitor_set_rate_limit:
 * @monitor: a #GFileMonitor.
 * @limit_msecs: a non-negative integer with the limit in milliseconds to poll for changes
 *
 * Sets the rate limit to which the @monitor will report
 * consecutive change events to the same file.
 */


/**
 * g_file_mount_enclosing_volume:
 * @location: input #GFile.
 * @flags: flags affecting the operation
 * @mount_operation: a #GMountOperation or %NULL to avoid user interaction.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied, or %NULL.
 * @user_data: the data to pass to callback function
 *
 * Starts a @mount_operation, mounting the volume that contains the file @location.
 *
 * When this operation has completed, @callback will be called with
 * @user_user data, and the operation can be finalized with
 * g_file_mount_enclosing_volume_finish().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 */


/**
 * g_file_mount_enclosing_volume_finish:
 * @location: input #GFile.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes a mount operation started by g_file_mount_enclosing_volume().
 *
 * has occurred, this function will return %FALSE and set @error
 * appropriately if present.
 *
 * Returns: %TRUE if successful. If an error
 */


/**
 * g_file_mount_mountable:
 * @file: input #GFile.
 * @flags: flags affecting the operation
 * @mount_operation: a #GMountOperation, or %NULL to avoid user interaction.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied, or %NULL.
 * @user_data: (closure): the data to pass to callback function
 *
 * Mounts a file of type G_FILE_TYPE_MOUNTABLE.
 * Using @mount_operation, you can request callbacks when, for instance,
 * passwords are needed during authentication.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_mount_mountable_finish() to get the result of the operation.
 */


/**
 * g_file_mount_mountable_finish:
 * @file: input #GFile.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes a mount operation. See g_file_mount_mountable() for details.
 *
 * Finish an asynchronous mount operation that was started
 * with g_file_mount_mountable().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFile or %NULL on error.
 */


/**
 * g_file_move:
 * @source: #GFile pointing to the source location.
 * @destination: #GFile pointing to the destination location.
 * @flags: set of #GFileCopyFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @progress_callback: (scope call): #GFileProgressCallback function for updates.
 * @progress_callback_data: (closure): gpointer to user data for the callback function.
 * @error: #GError for returning error conditions, or %NULL
 *
 * Tries to move the file or directory @source to the location specified by @destination.
 * If native move operations are supported then this is used, otherwise a copy + delete
 * fallback is used. The native implementation may support moving directories (for instance
 * on moves inside the same filesystem), but the fallback code does not.
 *
 * If the flag #G_FILE_COPY_OVERWRITE is specified an already
 * existing @destination file is overwritten.
 *
 * If the flag #G_FILE_COPY_NOFOLLOW_SYMLINKS is specified then symlinks
 * will be copied as symlinks, otherwise the target of the
 * @source symlink will be copied.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If @progress_callback is not %NULL, then the operation can be monitored by
 * setting this to a #GFileProgressCallback function. @progress_callback_data
 * will be passed to this function. It is guaranteed that this callback will
 * be called after all data has been transferred with the total number of bytes
 * copied during the operation.
 *
 * If the @source file does not exist then the G_IO_ERROR_NOT_FOUND
 * error is returned, independent on the status of the @destination.
 *
 * If #G_FILE_COPY_OVERWRITE is not specified and the target exists, then the
 * error G_IO_ERROR_EXISTS is returned.
 *
 * If trying to overwrite a file over a directory the G_IO_ERROR_IS_DIRECTORY
 * error is returned. If trying to overwrite a directory with a directory the
 * G_IO_ERROR_WOULD_MERGE error is returned.
 *
 * If the source is a directory and the target does not exist, or #G_FILE_COPY_OVERWRITE is
 * specified and the target is a file, then the G_IO_ERROR_WOULD_RECURSE error
 * may be returned (if the native move operation isn't available).
 *
 * Returns: %TRUE on successful move, %FALSE otherwise.
 */


/**
 * g_file_new_for_commandline_arg:
 * @arg: a command line string.
 *
 * Creates a #GFile with the given argument from the command line. The value of
 * @arg can be either a URI, an absolute path or a relative path resolved
 * relative to the current working directory.
 * This operation never fails, but the returned object might not support any
 * I/O operation if @arg points to a malformed path.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a new #GFile.
 */


/**
 * g_file_new_for_path:
 * @path: a string containing a relative or absolute path. The string must be encoded in the glib filename encoding.
 *
 * Constructs a #GFile for a given path. This operation never
 * fails, but the returned object might not support any I/O
 * operation if @path is malformed.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a new #GFile for the given @path.
 */


/**
 * g_file_new_for_uri:
 * @uri: a UTF8 string containing a URI.
 *
 * Constructs a #GFile for a given URI. This operation never
 * fails, but the returned object might not support any I/O
 * operation if @uri is malformed or if the uri type is
 * not supported.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a new #GFile for the given @uri.
 */


/**
 * g_file_new_tmp:
 * @tmpl: (type filename) (allow-none): Template for the file name, as in g_file_open_tmp(), or %NULL for a default template.
 * @iostream: (out): on return, a #GFileIOStream for the created file.
 * @error: a #GError, or %NULL
 *
 * Opens a file in the preferred directory for temporary files (as
 * returned by g_get_tmp_dir()) and returns a #GFile and
 * #GFileIOStream pointing to it.
 *
 * @template should be a string in the GLib file name encoding
 * containing a sequence of six 'X' characters, and containing no
 * directory components. If it is %NULL, a default template is used.
 *
 * Unlike the other #GFile constructors, this will return %NULL if
 * a temporary file could not be created.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a new #GFile.
 * Since: 2.32
 */


/**
 * g_file_open_readwrite:
 * @file: #GFile to open
 * @cancellable: (allow-none): a #GCancellable
 * @error: a #GError, or %NULL
 *
 * Opens an existing file for reading and writing. The result is
 * a #GFileIOStream that can be used to read and write the contents of the file.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If the file does not exist, the G_IO_ERROR_NOT_FOUND error will be returned.
 * If the file is a directory, the G_IO_ERROR_IS_DIRECTORY error will be returned.
 * Other errors are possible too, and depend on what kind of filesystem the file is on.
 * Note that in many non-local file cases read and write streams are not supported,
 * so make sure you really need to do read and write streaming, rather than
 * just opening for reading or writing.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): #GFileIOStream or %NULL on error.
 * Since: 2.22
 */


/**
 * g_file_open_readwrite_async:
 * @file: input #GFile.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously opens @file for reading and writing.
 *
 * For more details, see g_file_open_readwrite() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_open_readwrite_finish() to get the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_open_readwrite_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file read operation started with
 * g_file_open_readwrite_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileIOStream or %NULL on error.
 * Since: 2.22
 */


/**
 * g_file_output_stream_get_etag:
 * @stream: a #GFileOutputStream.
 *
 * Gets the entity tag for the file when it has been written.
 * This must be called after the stream has been written
 * and closed, as the etag can change while writing.
 *
 * Returns: the entity tag for the stream.
 */


/**
 * g_file_output_stream_query_info:
 * @stream: a #GFileOutputStream.
 * @attributes: a file attribute query string.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, %NULL to ignore.
 *
 * Queries a file output stream for the given @attributes.
 * This function blocks while querying the stream. For the asynchronous
 * version of this function, see g_file_output_stream_query_info_async().
 * While the stream is blocked, the stream will set the pending flag
 * internally, and any other operations on the stream will fail with
 * %G_IO_ERROR_PENDING.
 *
 * Can fail if the stream was already closed (with @error being set to
 * %G_IO_ERROR_CLOSED), the stream has pending operations (with @error being
 * set to %G_IO_ERROR_PENDING), or if querying info is not supported for
 * the stream's interface (with @error being set to %G_IO_ERROR_NOT_SUPPORTED). In
 * all cases of failure, %NULL will be returned.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be set, and %NULL will
 * be returned.
 *
 * Returns: (transfer full): a #GFileInfo for the @stream, or %NULL on error.
 */


/**
 * g_file_output_stream_query_info_async:
 * @stream: a #GFileOutputStream.
 * @attributes: a file attribute query string.
 * @io_priority: the <link linkend="gio-GIOScheduler">I/O priority</link> of the request.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: callback to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Asynchronously queries the @stream for a #GFileInfo. When completed,
 * @callback will be called with a #GAsyncResult which can be used to
 * finish the operation with g_file_output_stream_query_info_finish().
 *
 * For the synchronous version of this function, see
 * g_file_output_stream_query_info().
 */


/**
 * g_file_output_stream_query_info_finish:
 * @stream: a #GFileOutputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError, %NULL to ignore.
 *
 * Finalizes the asynchronous query started
 * by g_file_output_stream_query_info_async().
 *
 * Returns: (transfer full): A #GFileInfo for the finished query.
 */


/**
 * g_file_parse_name:
 * @parse_name: a file name or path to be parsed.
 *
 * Constructs a #GFile with the given @parse_name (i.e. something given by g_file_get_parse_name()).
 * This operation never fails, but the returned object might not support any I/O
 * operation if the @parse_name cannot be parsed.
 *
 * Returns: (transfer full): a new #GFile.
 */


/**
 * g_file_poll_mountable:
 * @file: input #GFile.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied, or %NULL.
 * @user_data: the data to pass to callback function
 *
 * Polls a file of type G_FILE_TYPE_MOUNTABLE.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_mount_mountable_finish() to get the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_poll_mountable_finish:
 * @file: input #GFile.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes a poll operation. See g_file_poll_mountable() for details.
 *
 * Finish an asynchronous poll operation that was polled
 * with g_file_poll_mountable().
 *
 * otherwise.
 *
 * Returns: %TRUE if the operation finished successfully. %FALSE
 * Since: 2.22
 */


/**
 * g_file_query_default_handler:
 * @file: a #GFile to open.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Returns the #GAppInfo that is registered as the default
 * application to handle the file specified by @file.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When you are done with it, release it with g_object_unref()
 *
 * Returns: (transfer full): a #GAppInfo if the handle was found, %NULL if there were errors.
 */


/**
 * g_file_query_exists:
 * @file: input #GFile.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 *
 * Utility function to check if a particular file exists. This is
 * implemented using g_file_query_info() and as such does blocking I/O.
 *
 * Note that in many cases it is racy to first check for file existence
 * and then execute something based on the outcome of that, because the
 * file might have been created or removed in between the operations. The
 * general approach to handling that is to not check, but just do the
 * operation and handle the errors as they come.
 *
 * As an example of race-free checking, take the case of reading a file, and
 * if it doesn't exist, creating it. There are two racy versions: read it, and
 * on error create it; and: check if it exists, if not create it. These
 * can both result in two processes creating the file (with perhaps a partially
 * written file as the result). The correct approach is to always try to create
 * the file with g_file_create() which will either atomically create the file
 * or fail with a G_IO_ERROR_EXISTS error.
 *
 * However, in many cases an existence check is useful in a user
 * interface, for instance to make a menu item sensitive/insensitive, so that
 * you don't have to fool users that something is possible and then just show
 * and error dialog. If you do this, you should make sure to also handle the
 * errors that can happen due to races when you execute the operation.
 *
 * Returns: %TRUE if the file exists (and can be detected without error), %FALSE otherwise (or if cancelled).
 */


/**
 * g_file_query_file_type:
 * @file: input #GFile.
 * @flags: a set of #GFileQueryInfoFlags passed to g_file_query_info().
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 *
 * Utility function to inspect the #GFileType of a file. This is
 * implemented using g_file_query_info() and as such does blocking I/O.
 *
 * The primary use case of this method is to check if a file is a regular file,
 * directory, or symlink.
 *
 * does not exist
 *
 * Returns: The #GFileType of the file and #G_FILE_TYPE_UNKNOWN if the file
 * Since: 2.18
 */


/**
 * g_file_query_filesystem_info:
 * @file: input #GFile.
 * @attributes: an attribute query string.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError.
 *
 * Similar to g_file_query_info(), but obtains information
 * about the filesystem the @file is on, rather than the file itself.
 * For instance the amount of space available and the type of
 * the filesystem.
 *
 * The @attributes value is a string that specifies the file attributes that
 * should be gathered. It is not an error if it's not possible to read a particular
 * requested attribute from a file - it just won't be set. @attributes should
 * be a comma-separated list of attributes or attribute wildcards. The wildcard "*"
 * means all attributes, and a wildcard like "filesystem::*" means all attributes in the
 * filesystem namespace. The standard namespace for filesystem attributes is "filesystem".
 * Common attributes of interest are #G_FILE_ATTRIBUTE_FILESYSTEM_SIZE
 * (the total size of the filesystem in bytes), #G_FILE_ATTRIBUTE_FILESYSTEM_FREE (number of
 * bytes available), and #G_FILE_ATTRIBUTE_FILESYSTEM_TYPE (type of the filesystem).
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If the file does not exist, the G_IO_ERROR_NOT_FOUND error will be returned.
 * Other errors are possible too, and depend on what kind of filesystem the file is on.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileInfo or %NULL if there was an error.
 */


/**
 * g_file_query_filesystem_info_async:
 * @file: input #GFile.
 * @attributes: an attribute query string.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously gets the requested information about the filesystem
 * that the specified @file is on. The result is a #GFileInfo object
 * that contains key-value attributes (such as type or size for the
 * file).
 *
 * For more details, see g_file_query_filesystem_info() which is the
 * synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can
 * then call g_file_query_info_finish() to get the result of the
 * operation.
 */


/**
 * g_file_query_filesystem_info_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @error: a #GError.
 *
 * Finishes an asynchronous filesystem info query.  See
 * g_file_query_filesystem_info_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): #GFileInfo for given @file or %NULL on error.
 */


/**
 * g_file_query_info:
 * @file: input #GFile.
 * @attributes: an attribute query string.
 * @flags: a set of #GFileQueryInfoFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError.
 *
 * Gets the requested information about specified @file. The result
 * is a #GFileInfo object that contains key-value attributes (such as
 * the type or size of the file).
 *
 * The @attributes value is a string that specifies the file attributes that
 * should be gathered. It is not an error if it's not possible to read a particular
 * requested attribute from a file - it just won't be set. @attributes should
 * be a comma-separated list of attributes or attribute wildcards. The wildcard "*"
 * means all attributes, and a wildcard like "standard::*" means all attributes in the standard
 * namespace. An example attribute query be "standard::*,owner::user".
 * The standard attributes are available as defines, like #G_FILE_ATTRIBUTE_STANDARD_NAME.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * For symlinks, normally the information about the target of the
 * symlink is returned, rather than information about the symlink itself.
 * However if you pass #G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS in @flags the
 * information about the symlink itself will be returned. Also, for symlinks
 * that point to non-existing files the information about the symlink itself
 * will be returned.
 *
 * If the file does not exist, the G_IO_ERROR_NOT_FOUND error will be returned.
 * Other errors are possible too, and depend on what kind of filesystem the file is on.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileInfo for the given @file, or %NULL on error.
 */


/**
 * g_file_query_info_async:
 * @file: input #GFile.
 * @attributes: an attribute query string.
 * @flags: a set of #GFileQueryInfoFlags.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously gets the requested information about specified @file. The result
 * is a #GFileInfo object that contains key-value attributes (such as type or size
 * for the file).
 *
 * For more details, see g_file_query_info() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_query_info_finish() to get the result of the operation.
 */


/**
 * g_file_query_info_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @error: a #GError.
 *
 * Finishes an asynchronous file info query.
 * See g_file_query_info_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): #GFileInfo for given @file or %NULL on error.
 */


/**
 * g_file_query_settable_attributes:
 * @file: input #GFile.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Obtain the list of settable attributes for the file.
 *
 * Returns the type and full attribute name of all the attributes
 * that can be set on this file. This doesn't mean setting it will always
 * succeed though, you might get an access failure, or some specific
 * file may not support a specific attribute.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When you are done with it, release it with g_file_attribute_info_list_unref()
 *
 * Returns: a #GFileAttributeInfoList describing the settable attributes.
 */


/**
 * g_file_query_writable_namespaces:
 * @file: input #GFile.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Obtain the list of attribute namespaces where new attributes
 * can be created by a user. An example of this is extended
 * attributes (in the "xattr" namespace).
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When you are done with it, release it with g_file_attribute_info_list_unref()
 *
 * Returns: a #GFileAttributeInfoList describing the writable namespaces.
 */


/**
 * g_file_read:
 * @file: #GFile to read.
 * @cancellable: (allow-none): a #GCancellable
 * @error: a #GError, or %NULL
 *
 * Opens a file for reading. The result is a #GFileInputStream that
 * can be used to read the contents of the file.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If the file does not exist, the G_IO_ERROR_NOT_FOUND error will be returned.
 * If the file is a directory, the G_IO_ERROR_IS_DIRECTORY error will be returned.
 * Other errors are possible too, and depend on what kind of filesystem the file is on.
 *
 * Free the returned object with g_object_unref().
 *
 * Virtual: read_fn
 * Returns: (transfer full): #GFileInputStream or %NULL on error.
 */


/**
 * g_file_read_async:
 * @file: input #GFile
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously opens @file for reading.
 *
 * For more details, see g_file_read() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_read_finish() to get the result of the operation.
 */


/**
 * g_file_read_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file read operation started with
 * g_file_read_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileInputStream or %NULL on error.
 */


/**
 * g_file_replace:
 * @file: input #GFile.
 * @etag: (allow-none): an optional <link linkend="gfile-etag">entity tag</link> for the current #GFile, or #NULL to ignore.
 * @make_backup: %TRUE if a backup should be created.
 * @flags: a set of #GFileCreateFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Returns an output stream for overwriting the file, possibly
 * creating a backup copy of the file first. If the file doesn't exist,
 * it will be created.
 *
 * This will try to replace the file in the safest way possible so
 * that any errors during the writing will not affect an already
 * existing copy of the file. For instance, for local files it
 * may write to a temporary file and then atomically rename over
 * the destination when the stream is closed.
 *
 * By default files created are generally readable by everyone,
 * but if you pass #G_FILE_CREATE_PRIVATE in @flags the file
 * will be made readable only to the current user, to the level that
 * is supported on the target filesystem.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If you pass in a non-#NULL @etag value, then this value is
 * compared to the current entity tag of the file, and if they differ
 * an G_IO_ERROR_WRONG_ETAG error is returned. This generally means
 * that the file has been changed since you last read it. You can get
 * the new etag from g_file_output_stream_get_etag() after you've
 * finished writing and closed the #GFileOutputStream. When you load
 * a new file you can use g_file_input_stream_query_info() to get
 * the etag of the file.
 *
 * If @make_backup is %TRUE, this function will attempt to make a backup
 * of the current file before overwriting it. If this fails a G_IO_ERROR_CANT_CREATE_BACKUP
 * error will be returned. If you want to replace anyway, try again with
 * @make_backup set to %FALSE.
 *
 * If the file is a directory the G_IO_ERROR_IS_DIRECTORY error will be returned,
 * and if the file is some other form of non-regular file then a
 * G_IO_ERROR_NOT_REGULAR_FILE error will be returned.
 * Some file systems don't allow all file names, and may
 * return an G_IO_ERROR_INVALID_FILENAME error, and if the name
 * is to long G_IO_ERROR_FILENAME_TOO_LONG will be returned.
 * Other errors are possible too, and depend on what kind of
 * filesystem the file is on.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileOutputStream or %NULL on error.
 */


/**
 * g_file_replace_async:
 * @file: input #GFile.
 * @etag: (allow-none): an <link linkend="gfile-etag">entity tag</link> for the current #GFile, or NULL to ignore.
 * @make_backup: %TRUE if a backup should be created.
 * @flags: a set of #GFileCreateFlags.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously overwrites the file, replacing the contents, possibly
 * creating a backup copy of the file first.
 *
 * For more details, see g_file_replace() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_replace_finish() to get the result of the operation.
 */


/**
 * g_file_replace_contents:
 * @file: input #GFile.
 * @contents: (element-type guint8) (array length=length): a string containing the new contents for @file.
 * @length: the length of @contents in bytes.
 * @etag: (allow-none): the old <link linkend="gfile-etag">entity tag</link> for the document, or %NULL
 * @make_backup: %TRUE if a backup should be created.
 * @flags: a set of #GFileCreateFlags.
 * @new_etag: (allow-none) (out): a location to a new <link linkend="gfile-etag">entity tag</link> for the document. This should be freed with g_free() when no longer needed, or %NULL
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Replaces the contents of @file with @contents of @length bytes.
 * If @etag is specified (not %NULL) any existing file must have that etag, or
 * the error %G_IO_ERROR_WRONG_ETAG will be returned.
 *
 * If @make_backup is %TRUE, this function will attempt to make a backup of @file.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * The returned @new_etag can be used to verify that the file hasn't changed the
 * next time it is saved over.
 *
 * has occurred, this function will return %FALSE and set @error
 * appropriately if present.
 *
 * Returns: %TRUE if successful. If an error
 */


/**
 * g_file_replace_contents_async:
 * @file: input #GFile.
 * @contents: (element-type guint8) (array length=length): string of contents to replace the file with.
 * @length: the length of @contents in bytes.
 * @etag: (allow-none): a new <link linkend="gfile-etag">entity tag</link> for the @file, or %NULL
 * @make_backup: %TRUE if a backup should be created.
 * @flags: a set of #GFileCreateFlags.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: the data to pass to callback function
 *
 * Starts an asynchronous replacement of @file with the given
 * @contents of @length bytes. @etag will replace the document's
 * current entity tag.
 *
 * When this operation has completed, @callback will be called with
 * @user_user data, and the operation can be finalized with
 * g_file_replace_contents_finish().
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * If @make_backup is %TRUE, this function will attempt to
 * make a backup of @file.
 */


/**
 * g_file_replace_contents_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @new_etag: (out) (allow-none): a location of a new <link linkend="gfile-etag">entity tag</link> for the document. This should be freed with g_free() when it is no longer needed, or %NULL
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous replace of the given @file. See
 * g_file_replace_contents_async(). Sets @new_etag to the new entity
 * tag for the document, if present.
 *
 * Returns: %TRUE on success, %FALSE on failure.
 */


/**
 * g_file_replace_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file replace operation started with
 * g_file_replace_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileOutputStream, or %NULL on error.
 */


/**
 * g_file_replace_readwrite:
 * @file: a #GFile
 * @etag: (allow-none): an optional <link linkend="gfile-etag">entity tag</link> for the current #GFile, or #NULL to ignore
 * @make_backup: %TRUE if a backup should be created
 * @flags: a set of #GFileCreateFlags
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @error: return location for a #GError, or %NULL
 *
 * Returns an output stream for overwriting the file in readwrite mode,
 * possibly creating a backup copy of the file first. If the file doesn't
 * exist, it will be created.
 *
 * For details about the behaviour, see g_file_replace() which does the same
 * thing but returns an output stream only.
 *
 * Note that in many non-local file cases read and write streams are not
 * supported, so make sure you really need to do read and write streaming,
 * rather than just opening for reading or writing.
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileIOStream or %NULL on error.
 * Since: 2.22
 */


/**
 * g_file_replace_readwrite_async:
 * @file: input #GFile.
 * @etag: (allow-none): an <link linkend="gfile-etag">entity tag</link> for the current #GFile, or NULL to ignore.
 * @make_backup: %TRUE if a backup should be created.
 * @flags: a set of #GFileCreateFlags.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously overwrites the file in read-write mode, replacing the
 * contents, possibly creating a backup copy of the file first.
 *
 * For more details, see g_file_replace_readwrite() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then
 * call g_file_replace_readwrite_finish() to get the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_replace_readwrite_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an asynchronous file replace operation started with
 * g_file_replace_readwrite_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFileIOStream, or %NULL on error.
 * Since: 2.22
 */


/**
 * g_file_resolve_relative_path:
 * @file: input #GFile.
 * @relative_path: a given relative path string.
 *
 * Resolves a relative path for @file to an absolute path.
 *
 * This call does no blocking i/o.
 *
 * is %NULL or if @file is invalid.
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): #GFile to the resolved path. %NULL if @relative_path
 */


/**
 * g_file_set_attribute:
 * @file: input #GFile.
 * @attribute: a string containing the attribute's name.
 * @type: The type of the attribute
 * @value_p: (allow-none): a pointer to the value (or the pointer itself if the type is a pointer type)
 * @flags: a set of #GFileQueryInfoFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Sets an attribute in the file with attribute name @attribute to @value.
 *
 * Some attributes can be unset by setting @attribute to
 * %G_FILE_ATTRIBUTE_TYPE_INVALID and @value_p to %NULL.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the attribute was set, %FALSE otherwise.
 */


/**
 * g_file_set_attribute_byte_string:
 * @file: input #GFile.
 * @attribute: a string containing the attribute's name.
 * @value: a string containing the attribute's new value.
 * @flags: a #GFileQueryInfoFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_BYTE_STRING to @value.
 * If @attribute is of a different type, this operation will fail,
 * returning %FALSE.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * in the @file, %FALSE otherwise.
 *
 * Returns: %TRUE if the @attribute was successfully set to @value
 */


/**
 * g_file_set_attribute_int32:
 * @file: input #GFile.
 * @attribute: a string containing the attribute's name.
 * @value: a #gint32 containing the attribute's new value.
 * @flags: a #GFileQueryInfoFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_INT32 to @value.
 * If @attribute is of a different type, this operation will fail.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * in the @file, %FALSE otherwise.
 *
 * Returns: %TRUE if the @attribute was successfully set to @value
 */


/**
 * g_file_set_attribute_int64:
 * @file: input #GFile.
 * @attribute: a string containing the attribute's name.
 * @value: a #guint64 containing the attribute's new value.
 * @flags: a #GFileQueryInfoFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_INT64 to @value.
 * If @attribute is of a different type, this operation will fail.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the @attribute was successfully set, %FALSE otherwise.
 */


/**
 * g_file_set_attribute_string:
 * @file: input #GFile.
 * @attribute: a string containing the attribute's name.
 * @value: a string containing the attribute's value.
 * @flags: #GFileQueryInfoFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_STRING to @value.
 * If @attribute is of a different type, this operation will fail.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if the @attribute was successfully set, %FALSE otherwise.
 */


/**
 * g_file_set_attribute_uint32:
 * @file: input #GFile.
 * @attribute: a string containing the attribute's name.
 * @value: a #guint32 containing the attribute's new value.
 * @flags: a #GFileQueryInfoFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_UINT32 to @value.
 * If @attribute is of a different type, this operation will fail.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * in the @file, %FALSE otherwise.
 *
 * Returns: %TRUE if the @attribute was successfully set to @value
 */


/**
 * g_file_set_attribute_uint64:
 * @file: input #GFile.
 * @attribute: a string containing the attribute's name.
 * @value: a #guint64 containing the attribute's new value.
 * @flags: a #GFileQueryInfoFlags.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Sets @attribute of type %G_FILE_ATTRIBUTE_TYPE_UINT64 to @value.
 * If @attribute is of a different type, this operation will fail.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * in the @file, %FALSE otherwise.
 *
 * Returns: %TRUE if the @attribute was successfully set to @value
 */


/**
 * g_file_set_attributes_async:
 * @file: input #GFile.
 * @info: a #GFileInfo.
 * @flags: a #GFileQueryInfoFlags.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback.
 * @user_data: (closure): a #gpointer.
 *
 * Asynchronously sets the attributes of @file with @info.
 *
 * For more details, see g_file_set_attributes_from_info() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_set_attributes_finish() to get the result of the operation.
 */


/**
 * g_file_set_attributes_finish:
 * @file: input #GFile.
 * @result: a #GAsyncResult.
 * @info: (out) (transfer full): a #GFileInfo.
 * @error: a #GError, or %NULL
 *
 * Finishes setting an attribute started in g_file_set_attributes_async().
 *
 * Returns: %TRUE if the attributes were set correctly, %FALSE otherwise.
 */


/**
 * g_file_set_attributes_from_info:
 * @file: input #GFile.
 * @info: a #GFileInfo.
 * @flags: #GFileQueryInfoFlags
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Tries to set all attributes in the #GFileInfo on the target values,
 * not stopping on the first error.
 *
 * If there is any error during this operation then @error will be set to
 * the first error. Error on particular fields are flagged by setting
 * the "status" field in the attribute value to
 * %G_FILE_ATTRIBUTE_STATUS_ERROR_SETTING, which means you can also detect
 * further errors.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE if there was any error, %FALSE otherwise.
 */


/**
 * g_file_set_display_name:
 * @file: input #GFile.
 * @display_name: a string.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Renames @file to the specified display name.
 *
 * The display name is converted from UTF8 to the correct encoding for the target
 * filesystem if possible and the @file is renamed to this.
 *
 * If you want to implement a rename operation in the user interface the edit name
 * (#G_FILE_ATTRIBUTE_STANDARD_EDIT_NAME) should be used as the initial value in the rename
 * widget, and then the result after editing should be passed to g_file_set_display_name().
 *
 * On success the resulting converted filename is returned.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * if there was an error.
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFile specifying what @file was renamed to, or %NULL
 */


/**
 * g_file_set_display_name_async:
 * @file: input #GFile.
 * @display_name: a string.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Asynchronously sets the display name for a given #GFile.
 *
 * For more details, see g_file_set_display_name() which is
 * the synchronous version of this call.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_set_display_name_finish() to get the result of the operation.
 */


/**
 * g_file_set_display_name_finish:
 * @file: input #GFile.
 * @res: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes setting a display name started with
 * g_file_set_display_name_async().
 *
 * Free the returned object with g_object_unref().
 *
 * Returns: (transfer full): a #GFile or %NULL on error.
 */


/**
 * g_file_start_mountable:
 * @file: input #GFile.
 * @flags: flags affecting the operation
 * @start_operation: a #GMountOperation, or %NULL to avoid user interaction.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied, or %NULL.
 * @user_data: the data to pass to callback function
 *
 * Starts a file of type G_FILE_TYPE_MOUNTABLE.
 * Using @start_operation, you can request callbacks when, for instance,
 * passwords are needed during authentication.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_mount_mountable_finish() to get the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_start_mountable_finish:
 * @file: input #GFile.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes a start operation. See g_file_start_mountable() for details.
 *
 * Finish an asynchronous start operation that was started
 * with g_file_start_mountable().
 *
 * otherwise.
 *
 * Returns: %TRUE if the operation finished successfully. %FALSE
 * Since: 2.22
 */


/**
 * g_file_stop_mountable:
 * @file: input #GFile.
 * @flags: flags affecting the operation
 * @mount_operation: a #GMountOperation, or %NULL to avoid user interaction.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @callback: a #GAsyncReadyCallback to call when the request is satisfied, or %NULL.
 * @user_data: the data to pass to callback function
 *
 * Stops a file of type G_FILE_TYPE_MOUNTABLE.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_stop_mountable_finish() to get the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_stop_mountable_finish:
 * @file: input #GFile.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an stop operation, see g_file_stop_mountable() for details.
 *
 * Finish an asynchronous stop operation that was started
 * with g_file_stop_mountable().
 *
 * otherwise.
 *
 * Returns: %TRUE if the operation finished successfully. %FALSE
 * Since: 2.22
 */


/**
 * g_file_supports_thread_contexts:
 * @file: a #GFile.
 *
 * Checks if @file supports <link
 * linkend="g-main-context-push-thread-default-context">thread-default
 * contexts</link>. If this returns %FALSE, you cannot perform
 * asynchronous operations on @file in a thread that has a
 * thread-default context.
 *
 * Returns: Whether or not @file supports thread-default contexts.
 * Since: 2.22
 */


/**
 * g_file_trash:
 * @file: #GFile to send to trash.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError, or %NULL
 *
 * Sends @file to the "Trashcan", if possible. This is similar to
 * deleting it, but the user can recover it before emptying the trashcan.
 * Not all file systems support trashing, so this call can return the
 * %G_IO_ERROR_NOT_SUPPORTED error.
 *
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE on successful trash, %FALSE otherwise.
 */


/**
 * g_file_unmount_mountable:
 * @file: input #GFile.
 * @flags: flags affecting the operation
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied, or %NULL.
 * @user_data: (closure): the data to pass to callback function
 *
 * Unmounts a file of type G_FILE_TYPE_MOUNTABLE.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_unmount_mountable_finish() to get the result of the operation.
 *
 * Deprecated: 2.22: Use g_file_unmount_mountable_with_operation() instead.
 */


/**
 * g_file_unmount_mountable_finish:
 * @file: input #GFile.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an unmount operation, see g_file_unmount_mountable() for details.
 *
 * Finish an asynchronous unmount operation that was started
 * with g_file_unmount_mountable().
 *
 * otherwise.
 *
 * Returns: %TRUE if the operation finished successfully. %FALSE
 * Deprecated: 2.22: Use g_file_unmount_mountable_with_operation_finish() instead.
 */


/**
 * g_file_unmount_mountable_with_operation:
 * @file: input #GFile.
 * @flags: flags affecting the operation
 * @mount_operation: a #GMountOperation, or %NULL to avoid user interaction.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied, or %NULL.
 * @user_data: (closure): the data to pass to callback function
 *
 * Unmounts a file of type G_FILE_TYPE_MOUNTABLE.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * When the operation is finished, @callback will be called. You can then call
 * g_file_unmount_mountable_finish() to get the result of the operation.
 *
 * Since: 2.22
 */


/**
 * g_file_unmount_mountable_with_operation_finish:
 * @file: input #GFile.
 * @result: a #GAsyncResult.
 * @error: a #GError, or %NULL
 *
 * Finishes an unmount operation, see g_file_unmount_mountable_with_operation() for details.
 *
 * Finish an asynchronous unmount operation that was started
 * with g_file_unmount_mountable_with_operation().
 *
 * otherwise.
 *
 * Returns: %TRUE if the operation finished successfully. %FALSE
 * Since: 2.22
 */


/**
 * g_filename_completer_get_completion_suffix:
 * @completer: the filename completer.
 * @initial_text: text to be completed.
 *
 * Obtains a completion for @initial_text from @completer.
 *
 * This string is not owned by GIO, so remember to g_free() it
 * when finished.
 *
 * Returns: a completed string, or %NULL if no completion exists.
 */


/**
 * g_filename_completer_get_completions:
 * @completer: the filename completer.
 * @initial_text: text to be completed.
 *
 * Gets an array of completion strings for a given initial text.
 *
 * This array must be freed by g_strfreev() when finished.
 *
 * Returns: (array zero-terminated=1) (transfer full): array of strings with possible completions for @initial_text.
 */


/**
 * g_filename_completer_new:
 *
 * Creates a new filename completer.
 *
 * Returns: a #GFilenameCompleter.
 */


/**
 * g_filename_completer_set_dirs_only:
 * @completer: the filename completer.
 * @dirs_only: a #gboolean.
 *
 * If @dirs_only is %TRUE, @completer will only
 * complete directory names, and not file names.
 */


/**
 * g_filter_input_stream_get_base_stream:
 * @stream: a #GFilterInputStream.
 *
 * Gets the base stream for the filter stream.
 *
 * Returns: (transfer none): a #GInputStream.
 */


/**
 * g_filter_input_stream_get_close_base_stream:
 * @stream: a #GFilterInputStream.
 *
 * Returns whether the base stream will be closed when @stream is
 * closed.
 *
 * Returns: %TRUE if the base stream will be closed.
 */


/**
 * g_filter_input_stream_set_close_base_stream:
 * @stream: a #GFilterInputStream.
 * @close_base: %TRUE to close the base stream.
 *
 * Sets whether the base stream will be closed when @stream is closed.
 */


/**
 * g_filter_output_stream_get_base_stream:
 * @stream: a #GFilterOutputStream.
 *
 * Gets the base stream for the filter stream.
 *
 * Returns: (transfer none): a #GOutputStream.
 */


/**
 * g_filter_output_stream_get_close_base_stream:
 * @stream: a #GFilterOutputStream.
 *
 * Returns whether the base stream will be closed when @stream is
 * closed.
 *
 * Returns: %TRUE if the base stream will be closed.
 */


/**
 * g_filter_output_stream_set_close_base_stream:
 * @stream: a #GFilterOutputStream.
 * @close_base: %TRUE to close the base stream.
 *
 * Sets whether the base stream will be closed when @stream is closed.
 */


/**
 * g_icon_equal:
 * @icon1: pointer to the first #GIcon.
 * @icon2: pointer to the second #GIcon.
 *
 * Checks if two icons are equal.
 *
 * Returns: %TRUE if @icon1 is equal to @icon2. %FALSE otherwise.
 */


/**
 * g_icon_hash:
 * @icon: #gconstpointer to an icon object.
 *
 * Gets a hash for an icon.
 *
 * use in a #GHashTable or similar data structure.
 *
 * Virtual: hash
 * Returns: a #guint containing a hash for the @icon, suitable for
 */


/**
 * g_icon_new_for_string:
 * @str: A string obtained via g_icon_to_string().
 * @error: Return location for error.
 *
 * Generate a #GIcon instance from @str. This function can fail if
 * @str is not valid - see g_icon_to_string() for discussion.
 *
 * If your application or library provides one or more #GIcon
 * implementations you need to ensure that each #GType is registered
 * with the type system prior to calling g_icon_new_for_string().
 *
 * interface or %NULL if @error is set.
 *
 * Returns: (transfer full): An object implementing the #GIcon
 * Since: 2.20
 */


/**
 * g_icon_to_string:
 * @icon: a #GIcon.
 *
 * Generates a textual representation of @icon that can be used for
 * serialization such as when passing @icon to a different process or
 * saving it to persistent storage. Use g_icon_new_for_string() to
 * get @icon back from the returned string.
 *
 * The encoding of the returned string is proprietary to #GIcon except
 * in the following two cases
 *
 * <itemizedlist>
 * <listitem><para>
 * If @icon is a #GFileIcon, the returned string is a native path
 * (such as <literal>/path/to/my icon.png</literal>) without escaping
 * if the #GFile for @icon is a native file.  If the file is not
 * native, the returned string is the result of g_file_get_uri()
 * (such as <literal>sftp://path/to/my&percnt;20icon.png</literal>).
 * </para></listitem>
 * <listitem><para>
 * If @icon is a #GThemedIcon with exactly one name, the encoding is
 * simply the name (such as <literal>network-server</literal>).
 * </para></listitem>
 * </itemizedlist>
 *
 * be serialized. Use g_free() to free.
 *
 * Virtual: to_tokens
 * Returns: An allocated NUL-terminated UTF8 string or %NULL if @icon can't
 * Since: 2.20
 */


/**
 * g_inet_address_equal:
 * @address: A #GInetAddress.
 * @other_address: Another #GInetAddress.
 *
 * Checks if two #GInetAddress instances are equal, e.g. the same address.
 *
 * Returns: %TRUE if @address and @other_address are equal, %FALSE otherwise.
 * Since: 2.30
 */


/**
 * g_inet_address_get_family:
 * @address: a #GInetAddress
 *
 * Gets @address's family
 *
 * Returns: @address's family
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_any:
 * @address: a #GInetAddress
 *
 * Tests whether @address is the "any" address for its family.
 *
 * Returns: %TRUE if @address is the "any" address for its family.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_link_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a link-local address (that is, if it
 * identifies a host on a local network that is not connected to the
 * Internet).
 *
 * Returns: %TRUE if @address is a link-local address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_loopback:
 * @address: a #GInetAddress
 *
 * Tests whether @address is the loopback address for its family.
 *
 * Returns: %TRUE if @address is the loopback address for its family.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_mc_global:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a global multicast address.
 *
 * Returns: %TRUE if @address is a global multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_mc_link_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a link-local multicast address.
 *
 * Returns: %TRUE if @address is a link-local multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_mc_node_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a node-local multicast address.
 *
 * Returns: %TRUE if @address is a node-local multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_mc_org_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is an organization-local multicast address.
 *
 * Returns: %TRUE if @address is an organization-local multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_mc_site_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a site-local multicast address.
 *
 * Returns: %TRUE if @address is a site-local multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_multicast:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a multicast address.
 *
 * Returns: %TRUE if @address is a multicast address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_is_site_local:
 * @address: a #GInetAddress
 *
 * Tests whether @address is a site-local address such as 10.0.0.1
 * (that is, the address identifies a host on a local network that can
 * not be reached directly from the Internet, but which may have
 * outgoing Internet connectivity via a NAT or firewall).
 *
 * Returns: %TRUE if @address is a site-local address.
 * Since: 2.22
 */


/**
 * g_inet_address_get_native_size:
 * @address: a #GInetAddress
 *
 * Gets the size of the native raw binary address for @address. This
 * is the size of the data that you get from g_inet_address_to_bytes().
 *
 * Returns: the number of bytes used for the native version of @address.
 * Since: 2.22
 */


/**
 * g_inet_address_mask_equal:
 * @mask: a #GInetAddressMask
 * @mask2: another #GInetAddressMask
 *
 * Tests if @mask and @mask2 are the same mask.
 *
 * Returns: whether @mask and @mask2 are the same mask
 * Since: 2.32
 */


/**
 * g_inet_address_mask_get_address:
 * @mask: a #GInetAddressMask
 *
 * Gets @mask's base address
 *
 * Returns: (transfer none): @mask's base address
 * Since: 2.32
 */


/**
 * g_inet_address_mask_get_family:
 * @mask: a #GInetAddressMask
 *
 * Gets the #GSocketFamily of @mask's address
 *
 * Returns: the #GSocketFamily of @mask's address
 * Since: 2.32
 */


/**
 * g_inet_address_mask_get_length:
 * @mask: a #GInetAddressMask
 *
 * Gets @mask's length
 *
 * Returns: @mask's length
 * Since: 2.32
 */


/**
 * g_inet_address_mask_matches:
 * @mask: a #GInetAddressMask
 * @address: a #GInetAddress
 *
 * Tests if @address falls within the range described by @mask.
 *
 * @mask.
 *
 * Returns: whether @address falls within the range described by
 * Since: 2.32
 */


/**
 * g_inet_address_mask_new:
 * @addr: a #GInetAddress
 * @length: number of bits of @addr to use
 * @error: return location for #GError, or %NULL
 *
 * Creates a new #GInetAddressMask representing all addresses whose
 * first @length bits match @addr.
 *
 * Returns: a new #GInetAddressMask, or %NULL on error
 * Since: 2.32
 */


/**
 * g_inet_address_mask_new_from_string:
 * @mask_string: an IP address or address/length string
 * @error: return location for #GError, or %NULL
 *
 * Parses @mask_string as an IP address and (optional) length, and
 * creates a new #GInetAddressMask. The length, if present, is
 * delimited by a "/". If it is not present, then the length is
 * assumed to be the full length of the address.
 *
 * on error.
 *
 * Returns: a new #GInetAddressMask corresponding to @string, or %NULL
 * Since: 2.32
 */


/**
 * g_inet_address_mask_to_string:
 * @mask: a #GInetAddressMask
 *
 * Converts @mask back to its corresponding string form.
 *
 * Returns: a string corresponding to @mask.
 * Since: 2.32
 */


/**
 * g_inet_address_new_any:
 * @family: the address family
 *
 * Creates a #GInetAddress for the "any" address (unassigned/"don't
 * care") for @family.
 *
 * for @family.
 *
 * Returns: a new #GInetAddress corresponding to the "any" address
 * Since: 2.22
 */


/**
 * g_inet_address_new_from_bytes:
 * @bytes: raw address data
 * @family: the address family of @bytes
 *
 * Creates a new #GInetAddress from the given @family and @bytes.
 * @bytes should be 4 bytes for %G_INET_ADDRESS_IPV4 and 16 bytes for
 * %G_INET_ADDRESS_IPV6.
 *
 * Returns: a new #GInetAddress corresponding to @family and @bytes.
 * Since: 2.22
 */


/**
 * g_inet_address_new_from_string:
 * @string: a string representation of an IP address
 *
 * Parses @string as an IP address and creates a new #GInetAddress.
 *
 * @string could not be parsed.
 *
 * Returns: a new #GInetAddress corresponding to @string, or %NULL if
 * Since: 2.22
 */


/**
 * g_inet_address_new_loopback:
 * @family: the address family
 *
 * Creates a #GInetAddress for the loopback address for @family.
 *
 * for @family.
 *
 * Returns: a new #GInetAddress corresponding to the loopback address
 * Since: 2.22
 */


/**
 * g_inet_address_to_bytes: (skip)
 * @address: a #GInetAddress
 *
 * Gets the raw binary address data from @address.
 *
 * which should not be modified, stored, or freed. The size of this
 * array can be gotten with g_inet_address_get_native_size().
 *
 * Returns: a pointer to an internal array of the bytes in @address,
 * Since: 2.22
 */


/**
 * g_inet_address_to_string:
 * @address: a #GInetAddress
 *
 * Converts @address to string form.
 *
 * freed after use.
 *
 * Returns: a representation of @address as a string, which should be
 * Since: 2.22
 */


/**
 * g_inet_socket_address_get_address:
 * @address: a #GInetSocketAddress
 *
 * Gets @address's #GInetAddress.
 *
 * g_object_ref()'d if it will be stored
 *
 * Returns: (transfer none): the #GInetAddress for @address, which must be
 * Since: 2.22
 */


/**
 * g_inet_socket_address_get_port:
 * @address: a #GInetSocketAddress
 *
 * Gets @address's port.
 *
 * Returns: the port for @address
 * Since: 2.22
 */


/**
 * g_inet_socket_address_new:
 * @address: a #GInetAddress
 * @port: a port number
 *
 * Creates a new #GInetSocketAddress for @address and @port.
 *
 * Returns: a new #GInetSocketAddress
 * Since: 2.22
 */


/**
 * g_initable_init:
 * @initable: a #GInitable.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Initializes the object implementing the interface.
 *
 * The object must be initialized before any real use after initial
 * construction, either with this function or g_async_initable_init_async().
 *
 * Implementations may also support cancellation. If @cancellable is not %NULL,
 * then initialization can be cancelled by triggering the cancellable object
 * from another thread. If the operation was cancelled, the error
 * %G_IO_ERROR_CANCELLED will be returned. If @cancellable is not %NULL and
 * the object doesn't support cancellable initialization the error
 * %G_IO_ERROR_NOT_SUPPORTED will be returned.
 *
 * If the object is not initialized, or initialization returns with an
 * error, then all operations on the object except g_object_ref() and
 * g_object_unref() are considered to be invalid, and have undefined
 * behaviour. See the <xref linkend="ginitable"/> section introduction
 * for more details.
 *
 * Implementations of this method must be idempotent, i.e. multiple calls
 * to this function with the same argument should return the same results.
 * Only the first call initializes the object, further calls return the result
 * of the first call. This is so that it's safe to implement the singleton
 * pattern in the GObject constructor function.
 *
 * return %FALSE and set @error appropriately if present.
 *
 * Returns: %TRUE if successful. If an error has occurred, this function will
 * Since: 2.22
 */


/**
 * g_initable_new:
 * @object_type: a #GType supporting #GInitable.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 * @first_property_name: the name of the first property, or %NULL if no properties
 * @...: the value if the first property, followed by and other property value pairs, and ended by %NULL.
 *
 * Helper function for constructing #GInitiable object. This is
 * similar to g_object_new() but also initializes the object
 * and returns %NULL, setting an error on failure.
 *
 * Returns: (transfer full): a newly allocated #GObject, or %NULL on error
 * Since: 2.22
 */


/**
 * g_initable_new_valist:
 * @object_type: a #GType supporting #GInitable.
 * @first_property_name: the name of the first property, followed by the value, and other property value pairs, and ended by %NULL.
 * @var_args: The var args list generated from @first_property_name.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Helper function for constructing #GInitiable object. This is
 * similar to g_object_new_valist() but also initializes the object
 * and returns %NULL, setting an error on failure.
 *
 * Returns: (transfer full): a newly allocated #GObject, or %NULL on error
 * Since: 2.22
 */


/**
 * g_initable_newv:
 * @object_type: a #GType supporting #GInitable.
 * @n_parameters: the number of parameters in @parameters
 * @parameters: the parameters to use to construct the object
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Helper function for constructing #GInitiable object. This is
 * similar to g_object_newv() but also initializes the object
 * and returns %NULL, setting an error on failure.
 *
 * Returns: (transfer full): a newly allocated #GObject, or %NULL on error
 * Since: 2.22
 */


/**
 * g_input_stream_clear_pending:
 * @stream: input stream
 *
 * Clears the pending flag on @stream.
 */


/**
 * g_input_stream_close:
 * @stream: A #GInputStream.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Closes the stream, releasing resources related to it.
 *
 * Once the stream is closed, all other operations will return %G_IO_ERROR_CLOSED.
 * Closing a stream multiple times will not return an error.
 *
 * Streams will be automatically closed when the last reference
 * is dropped, but you might want to call this function to make sure
 * resources are released as early as possible.
 *
 * Some streams might keep the backing store of the stream (e.g. a file descriptor)
 * open after the stream is closed. See the documentation for the individual
 * stream for details.
 *
 * On failure the first error that happened will be reported, but the close
 * operation will finish as much as possible. A stream that failed to
 * close will still return %G_IO_ERROR_CLOSED for all operations. Still, it
 * is important to check and report the error to the user.
 *
 * If @cancellable is not NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 * Cancelling a close will still leave the stream closed, but some streams
 * can use a faster close that doesn't block to e.g. check errors.
 *
 * Returns: %TRUE on success, %FALSE on failure
 */


/**
 * g_input_stream_close_async:
 * @stream: A #GInputStream.
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional cancellable object
 * @callback: (scope async): callback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Requests an asynchronous closes of the stream, releasing resources related to it.
 * When the operation is finished @callback will be called.
 * You can then call g_input_stream_close_finish() to get the result of the
 * operation.
 *
 * For behaviour details see g_input_stream_close().
 *
 * The asyncronous methods have a default fallback that uses threads to implement
 * asynchronicity, so they are optional for inheriting classes. However, if you
 * override one you must override all.
 */


/**
 * g_input_stream_close_finish:
 * @stream: a #GInputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes closing a stream asynchronously, started from g_input_stream_close_async().
 *
 * Returns: %TRUE if the stream was closed successfully.
 */


/**
 * g_input_stream_has_pending:
 * @stream: input stream.
 *
 * Checks if an input stream has pending actions.
 *
 * Returns: %TRUE if @stream has pending actions.
 */


/**
 * g_input_stream_is_closed:
 * @stream: input stream.
 *
 * Checks if an input stream is closed.
 *
 * Returns: %TRUE if the stream is closed.
 */


/**
 * g_input_stream_read:
 * @stream: a #GInputStream.
 * @buffer: a buffer to read data into (which should be at least count bytes long).
 * @count: the number of bytes that will be read from the stream
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Tries to read @count bytes from the stream into the buffer starting at
 * @buffer. Will block during this read.
 *
 * If count is zero returns zero and does nothing. A value of @count
 * larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
 *
 * On success, the number of bytes read into the buffer is returned.
 * It is not an error if this is not the same as the requested size, as it
 * can happen e.g. near the end of a file. Zero is returned on end of file
 * (or if @count is zero),  but never otherwise.
 *
 * If @cancellable is not NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error G_IO_ERROR_CANCELLED will be returned. If an
 * operation was partially finished when the operation was cancelled the
 * partial result will be returned, without an error.
 *
 * On error -1 is returned and @error is set accordingly.
 *
 * Returns: Number of bytes read, or -1 on error
 */


/**
 * g_input_stream_read_all:
 * @stream: a #GInputStream.
 * @buffer: a buffer to read data into (which should be at least count bytes long).
 * @count: the number of bytes that will be read from the stream
 * @bytes_read: (out): location to store the number of bytes that was read from the stream
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Tries to read @count bytes from the stream into the buffer starting at
 * @buffer. Will block during this read.
 *
 * This function is similar to g_input_stream_read(), except it tries to
 * read as many bytes as requested, only stopping on an error or end of stream.
 *
 * On a successful read of @count bytes, or if we reached the end of the
 * stream,  %TRUE is returned, and @bytes_read is set to the number of bytes
 * read into @buffer.
 *
 * If there is an error during the operation %FALSE is returned and @error
 * is set to indicate the error status, @bytes_read is updated to contain
 * the number of bytes read into @buffer before the error occurred.
 *
 * Returns: %TRUE on success, %FALSE if there was an error
 */


/**
 * g_input_stream_read_async:
 * @stream: A #GInputStream.
 * @buffer: a buffer to read data into (which should be at least count bytes long).
 * @count: the number of bytes that will be read from the stream
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): callback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Request an asynchronous read of @count bytes from the stream into the buffer
 * starting at @buffer. When the operation is finished @callback will be called.
 * You can then call g_input_stream_read_finish() to get the result of the
 * operation.
 *
 * During an async request no other sync and async calls are allowed on @stream, and will
 * result in %G_IO_ERROR_PENDING errors.
 *
 * A value of @count larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
 *
 * On success, the number of bytes read into the buffer will be passed to the
 * callback. It is not an error if this is not the same as the requested size, as it
 * can happen e.g. near the end of a file, but generally we try to read
 * as many bytes as requested. Zero is returned on end of file
 * (or if @count is zero),  but never otherwise.
 *
 * Any outstanding i/o request with higher priority (lower numerical value) will
 * be executed before an outstanding request with lower priority. Default
 * priority is %G_PRIORITY_DEFAULT.
 *
 * The asyncronous methods have a default fallback that uses threads to implement
 * asynchronicity, so they are optional for inheriting classes. However, if you
 * override one you must override all.
 */


/**
 * g_input_stream_read_finish:
 * @stream: a #GInputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes an asynchronous stream read operation.
 *
 * Returns: number of bytes read in, or -1 on error.
 */


/**
 * g_input_stream_set_pending:
 * @stream: input stream
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Sets @stream to have actions pending. If the pending flag is
 * already set or @stream is closed, it will return %FALSE and set
 * @error.
 *
 * Returns: %TRUE if pending was previously unset and is now set.
 */


/**
 * g_input_stream_skip:
 * @stream: a #GInputStream.
 * @count: the number of bytes that will be skipped from the stream
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Tries to skip @count bytes from the stream. Will block during the operation.
 *
 * This is identical to g_input_stream_read(), from a behaviour standpoint,
 * but the bytes that are skipped are not returned to the user. Some
 * streams have an implementation that is more efficient than reading the data.
 *
 * This function is optional for inherited classes, as the default implementation
 * emulates it using read.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned. If an
 * operation was partially finished when the operation was cancelled the
 * partial result will be returned, without an error.
 *
 * Returns: Number of bytes skipped, or -1 on error
 */


/**
 * g_input_stream_skip_async:
 * @stream: A #GInputStream.
 * @count: the number of bytes that will be skipped from the stream
 * @io_priority: the <link linkend="io-priority">I/O priority</link> of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): callback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Request an asynchronous skip of @count bytes from the stream.
 * When the operation is finished @callback will be called.
 * You can then call g_input_stream_skip_finish() to get the result
 * of the operation.
 *
 * During an async request no other sync and async calls are allowed,
 * and will result in %G_IO_ERROR_PENDING errors.
 *
 * A value of @count larger than %G_MAXSSIZE will cause a %G_IO_ERROR_INVALID_ARGUMENT error.
 *
 * On success, the number of bytes skipped will be passed to the callback.
 * It is not an error if this is not the same as the requested size, as it
 * can happen e.g. near the end of a file, but generally we try to skip
 * as many bytes as requested. Zero is returned on end of file
 * (or if @count is zero), but never otherwise.
 *
 * Any outstanding i/o request with higher priority (lower numerical value)
 * will be executed before an outstanding request with lower priority.
 * Default priority is %G_PRIORITY_DEFAULT.
 *
 * The asynchronous methods have a default fallback that uses threads to
 * implement asynchronicity, so they are optional for inheriting classes.
 * However, if you override one, you must override all.
 */


/**
 * g_input_stream_skip_finish:
 * @stream: a #GInputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes a stream skip operation.
 *
 * Returns: the size of the bytes skipped, or %-1 on error.
 */


/**
 * g_io_error_from_errno:
 * @err_no: Error number as defined in errno.h.
 *
 * Converts errno.h error codes into GIO error codes.
 *
 * Returns: #GIOErrorEnum value for the given errno.h error number.
 */


/**
 * g_io_error_from_win32_error:
 * @error_code: Windows error number.
 *
 * Converts some common error codes into GIO error codes. The
 * fallback value G_IO_ERROR_FAILED is returned for error codes not
 * handled.
 *
 * Returns: #GIOErrorEnum value for the given error number.
 * Since: 2.26
 */


/**
 * g_io_error_quark:
 *
 * Gets the GIO Error Quark.
 *
 * Returns: a #GQuark.
 */


/**
 * g_io_extension_get_name:
 * @extension: a #GIOExtension
 *
 * Gets the name under which @extension was registered.
 *
 * Note that the same type may be registered as extension
 * for multiple extension points, under different names.
 *
 * Returns: the name of @extension.
 */


/**
 * g_io_extension_get_priority:
 * @extension: a #GIOExtension
 *
 * Gets the priority with which @extension was registered.
 *
 * Returns: the priority of @extension
 */


/**
 * g_io_extension_get_type:
 * @extension: a #GIOExtension
 *
 * Gets the type associated with @extension.
 *
 * Returns: the type of @extension
 */


/**
 * g_io_extension_point_get_extension_by_name:
 * @extension_point: a #GIOExtensionPoint
 * @name: the name of the extension to get
 *
 * Finds a #GIOExtension for an extension point by name.
 *
 * given name, or %NULL if there is no extension with that name
 *
 * Returns: (transfer none): the #GIOExtension for @extension_point that has the
 */


/**
 * g_io_extension_point_get_extensions:
 * @extension_point: a #GIOExtensionPoint
 *
 * Gets a list of all extensions that implement this extension point.
 * The list is sorted by priority, beginning with the highest priority.
 *
 * #GIOExtension<!-- -->s. The list is owned by GIO and should not be
 * modified.
 *
 * Returns: (element-type GIOExtension) (transfer none): a #GList of
 */


/**
 * g_io_extension_point_get_required_type:
 * @extension_point: a #GIOExtensionPoint
 *
 * Gets the required type for @extension_point.
 *
 * or #G_TYPE_INVALID if the extension point has no required type
 *
 * Returns: the #GType that all implementations must have,
 */


/**
 * g_io_extension_point_implement:
 * @extension_point_name: the name of the extension point
 * @type: the #GType to register as extension
 * @extension_name: the name for the extension
 * @priority: the priority for the extension
 *
 * Registers @type as extension for the extension point with name
 * @extension_point_name.
 *
 * If @type has already been registered as an extension for this
 * extension point, the existing #GIOExtension object is returned.
 *
 * Returns: (transfer none): a #GIOExtension object for #GType
 */


/**
 * g_io_extension_point_lookup:
 * @name: the name of the extension point
 *
 * Looks up an existing extension point.
 *
 * is no registered extension point with the given name.
 *
 * Returns: (transfer none): the #GIOExtensionPoint, or %NULL if there
 */


/**
 * g_io_extension_point_register:
 * @name: The name of the extension point
 *
 * Registers an extension point.
 *
 * owned by GIO and should not be freed.
 *
 * Returns: (transfer none): the new #GIOExtensionPoint. This object is
 */


/**
 * g_io_extension_point_set_required_type:
 * @extension_point: a #GIOExtensionPoint
 * @type: the #GType to require
 *
 * Sets the required type for @extension_point to @type.
 * All implementations must henceforth have this type.
 */


/**
 * g_io_extension_ref_class:
 * @extension: a #GIOExtension
 *
 * Gets a reference to the class for the type that is
 * associated with @extension.
 *
 * Returns: (transfer full): the #GTypeClass for the type of @extension
 */


/**
 * g_io_module_load:
 * @module: a #GIOModule.
 *
 * Required API for GIO modules to implement.
 * This function is ran after the module has been loaded into GIO,
 * to initialize the module.
 */


/**
 * g_io_module_new:
 * @filename: filename of the shared library module.
 *
 * Creates a new GIOModule that will load the specific
 * shared library when in use.
 *
 * or %NULL on error.
 *
 * Returns: a #GIOModule from given @filename,
 */


/**
 * g_io_module_query:
 *
 * Optional API for GIO modules to implement.
 *
 * Should return a list of all the extension points that may be
 * implemented in this module.
 *
 * This method will not be called in normal use, however it may be
 * called when probing existing modules and recording which extension
 * points that this model is used for. This means we won't have to
 * load and initialze this module unless its needed.
 *
 * If this function is not implemented by the module the module will
 * always be loaded, initialized and then unloaded on application startup
 * so that it can register its extension points during init.
 *
 * Note that a module need not actually implement all the extension points
 * that g_io_module_query returns, since the exact list of extension may
 * depend on runtime issues. However all extension points actually implemented
 * must be returned by g_io_module_query() (if defined).
 *
 * When installing a module that implements g_io_module_query you must
 * run gio-querymodules in order to build the cache files required for
 * lazy loading.
 *
 * extension points of the module. The array must be suitable for
 * freeing with g_strfreev().
 *
 * Returns: (transfer full): A %NULL-terminated array of strings, listing the supported
 * Since: 2.24
 */


/**
 * g_io_module_scope_block:
 * @scope: a module loading scope
 * @basename: the basename to block
 *
 * Block modules with the given @basename from being loaded when
 * this scope is used with g_io_modules_scan_all_in_directory_with_scope()
 * or g_io_modules_load_all_in_directory_with_scope().
 *
 * Since: 2.30
 */


/**
 * g_io_module_scope_free:
 * @scope: a module loading scope
 *
 * Free a module scope.
 *
 * Since: 2.30
 */


/**
 * g_io_module_scope_new:
 * @flags: flags for the new scope
 *
 * Create a new scope for loading of IO modules. A scope can be used for
 * blocking duplicate modules, or blocking a module you don't want to load.
 *
 * Specify the %G_IO_MODULES_SCOPE_BLOCK_DUPLICATES flag to block modules
 * which have the same base name as a module that has already been seen
 * in this scope.
 *
 * Returns: (transfer full): the new module scope
 * Since: 2.30
 */


/**
 * g_io_module_unload:
 * @module: a #GIOModule.
 *
 * Required API for GIO modules to implement.
 * This function is ran when the module is being unloaded from GIO,
 * to finalize the module.
 */


/**
 * g_io_modules_load_all_in_directory:
 * @dirname: pathname for a directory containing modules to load.
 *
 * Loads all the modules in the specified directory.
 *
 * If don't require all modules to be initialized (and thus registering
 * all gtypes) then you can use g_io_modules_scan_all_in_directory()
 * which allows delayed/lazy loading of modules.
 *
 * from the directory,
 * All the modules are loaded into memory, if you want to
 * unload them (enabling on-demand loading) you must call
 * g_type_module_unuse() on all the modules. Free the list
 * with g_list_free().
 *
 * Returns: (element-type GIOModule) (transfer full): a list of #GIOModules loaded
 */


/**
 * g_io_modules_load_all_in_directory_with_scope:
 * @dirname: pathname for a directory containing modules to load.
 * @scope: a scope to use when scanning the modules.
 *
 * Loads all the modules in the specified directory.
 *
 * If don't require all modules to be initialized (and thus registering
 * all gtypes) then you can use g_io_modules_scan_all_in_directory()
 * which allows delayed/lazy loading of modules.
 *
 * from the directory,
 * All the modules are loaded into memory, if you want to
 * unload them (enabling on-demand loading) you must call
 * g_type_module_unuse() on all the modules. Free the list
 * with g_list_free().
 *
 * Returns: (element-type GIOModule) (transfer full): a list of #GIOModules loaded
 * Since: 2.30
 */


/**
 * g_io_modules_scan_all_in_directory:
 * @dirname: pathname for a directory containing modules to scan.
 *
 * Scans all the modules in the specified directory, ensuring that
 * any extension point implemented by a module is registered.
 *
 * This may not actually load and initialize all the types in each
 * module, some modules may be lazily loaded and initialized when
 * an extension point it implementes is used with e.g.
 * g_io_extension_point_get_extensions() or
 * g_io_extension_point_get_extension_by_name().
 *
 * If you need to guarantee that all types are loaded in all the modules,
 * use g_io_modules_load_all_in_directory().
 *
 * Since: 2.24
 */


/**
 * g_io_modules_scan_all_in_directory_with_scope:
 * @dirname: pathname for a directory containing modules to scan.
 * @scope: a scope to use when scanning the modules
 *
 * Scans all the modules in the specified directory, ensuring that
 * any extension point implemented by a module is registered.
 *
 * This may not actually load and initialize all the types in each
 * module, some modules may be lazily loaded and initialized when
 * an extension point it implementes is used with e.g.
 * g_io_extension_point_get_extensions() or
 * g_io_extension_point_get_extension_by_name().
 *
 * If you need to guarantee that all types are loaded in all the modules,
 * use g_io_modules_load_all_in_directory().
 *
 * Since: 2.30
 */


/**
 * g_io_scheduler_cancel_all_jobs:
 *
 * Cancels all cancellable I/O jobs.
 *
 * A job is cancellable if a #GCancellable was passed into
 * g_io_scheduler_push_job().
 */


/**
 * g_io_scheduler_job_send_to_mainloop:
 * @job: a #GIOSchedulerJob
 * @func: a #GSourceFunc callback that will be called in the original thread
 * @user_data: data to pass to @func
 * @notify: a #GDestroyNotify for @user_data, or %NULL
 *
 * Used from an I/O job to send a callback to be run in the thread
 * that the job was started from, waiting for the result (and thus
 * blocking the I/O job).
 *
 * Returns: The return value of @func
 */


/**
 * g_io_scheduler_job_send_to_mainloop_async:
 * @job: a #GIOSchedulerJob
 * @func: a #GSourceFunc callback that will be called in the original thread
 * @user_data: data to pass to @func
 * @notify: a #GDestroyNotify for @user_data, or %NULL
 *
 * Used from an I/O job to send a callback to be run asynchronously in
 * the thread that the job was started from. The callback will be run
 * when the main loop is available, but at that time the I/O job might
 * have finished. The return value from the callback is ignored.
 *
 * Note that if you are passing the @user_data from g_io_scheduler_push_job()
 * on to this function you have to ensure that it is not freed before
 * @func is called, either by passing %NULL as @notify to
 * g_io_scheduler_push_job() or by using refcounting for @user_data.
 */


/**
 * g_io_scheduler_push_job:
 * @job_func: a #GIOSchedulerJobFunc.
 * @user_data: data to pass to @job_func
 * @notify: a #GDestroyNotify for @user_data, or %NULL
 * @io_priority: the <link linkend="gioscheduler">I/O priority</link> of the request.
 * @cancellable: optional #GCancellable object, %NULL to ignore.
 *
 * Schedules the I/O job to run in another thread.
 *
 * @notify will be called on @user_data after @job_func has returned,
 * regardless whether the job was cancelled or has run to completion.
 *
 * If @cancellable is not %NULL, it can be used to cancel the I/O job
 * by calling g_cancellable_cancel() or by calling
 * g_io_scheduler_cancel_all_jobs().
 */


/**
 * g_io_stream_clear_pending:
 * @stream: a #GIOStream
 *
 * Clears the pending flag on @stream.
 *
 * Since: 2.22
 */


/**
 * g_io_stream_close:
 * @stream: a #GIOStream
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Closes the stream, releasing resources related to it. This will also
 * closes the individual input and output streams, if they are not already
 * closed.
 *
 * Once the stream is closed, all other operations will return
 * %G_IO_ERROR_CLOSED. Closing a stream multiple times will not
 * return an error.
 *
 * Closing a stream will automatically flush any outstanding buffers
 * in the stream.
 *
 * Streams will be automatically closed when the last reference
 * is dropped, but you might want to call this function to make sure
 * resources are released as early as possible.
 *
 * Some streams might keep the backing store of the stream (e.g. a file
 * descriptor) open after the stream is closed. See the documentation for
 * the individual stream for details.
 *
 * On failure the first error that happened will be reported, but the
 * close operation will finish as much as possible. A stream that failed
 * to close will still return %G_IO_ERROR_CLOSED for all operations.
 * Still, it is important to check and report the error to the user,
 * otherwise there might be a loss of data as all data might not be written.
 *
 * If @cancellable is not NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 * Cancelling a close will still leave the stream closed, but some streams
 * can use a faster close that doesn't block to e.g. check errors.
 *
 * The default implementation of this method just calls close on the
 * individual input/output streams.
 *
 * Returns: %TRUE on success, %FALSE on failure
 * Since: 2.22
 */


/**
 * g_io_stream_close_async:
 * @stream: a #GIOStream
 * @io_priority: the io priority of the request
 * @cancellable: (allow-none): optional cancellable object
 * @callback: (scope async): callback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Requests an asynchronous close of the stream, releasing resources
 * related to it. When the operation is finished @callback will be
 * called. You can then call g_io_stream_close_finish() to get
 * the result of the operation.
 *
 * For behaviour details see g_io_stream_close().
 *
 * The asynchronous methods have a default fallback that uses threads
 * to implement asynchronicity, so they are optional for inheriting
 * classes. However, if you override one you must override all.
 *
 * Since: 2.22
 */


/**
 * g_io_stream_close_finish:
 * @stream: a #GIOStream
 * @result: a #GAsyncResult
 * @error: a #GError location to store the error occurring, or %NULL to ignore
 *
 * Closes a stream.
 *
 * Returns: %TRUE if stream was successfully closed, %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_io_stream_get_input_stream:
 * @stream: a #GIOStream
 *
 * Gets the input stream for this object. This is used
 * for reading.
 *
 * Do not free.
 *
 * Returns: (transfer none): a #GInputStream, owned by the #GIOStream.
 * Since: 2.22
 */


/**
 * g_io_stream_get_output_stream:
 * @stream: a #GIOStream
 *
 * Gets the output stream for this object. This is used for
 * writing.
 *
 * Do not free.
 *
 * Returns: (transfer none): a #GOutputStream, owned by the #GIOStream.
 * Since: 2.22
 */


/**
 * g_io_stream_has_pending:
 * @stream: a #GIOStream
 *
 * Checks if a stream has pending actions.
 *
 * Returns: %TRUE if @stream has pending actions.
 * Since: 2.22
 */


/**
 * g_io_stream_is_closed:
 * @stream: a #GIOStream
 *
 * Checks if a stream is closed.
 *
 * Returns: %TRUE if the stream is closed.
 * Since: 2.22
 */


/**
 * g_io_stream_set_pending:
 * @stream: a #GIOStream
 * @error: a #GError location to store the error occurring, or %NULL to ignore
 *
 * Sets @stream to have actions pending. If the pending flag is
 * already set or @stream is closed, it will return %FALSE and set
 * @error.
 *
 * Returns: %TRUE if pending was previously unset and is now set.
 * Since: 2.22
 */


/**
 * g_io_stream_splice_async:
 * @stream1: a #GIOStream.
 * @stream2: a #GIOStream.
 * @flags: a set of #GIOStreamSpliceFlags.
 * @io_priority: the io priority of the request.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback.
 * @user_data: (closure): user data passed to @callback.
 *
 * Asyncronously splice the output stream of @stream1 to the input stream of
 * @stream2, and splice the output stream of @stream2 to the input stream of
 * @stream1.
 *
 * When the operation is finished @callback will be called.
 * You can then call g_io_stream_splice_finish() to get the
 * result of the operation.
 *
 * Since: 2.28
 */


/**
 * g_io_stream_splice_finish:
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes an asynchronous io stream splice operation.
 *
 * Returns: %TRUE on success, %FALSE otherwise.
 * Since: 2.28
 */


/**
 * g_keyfile_settings_backend_new:
 * @filename: the filename of the keyfile
 * @root_path: the path under which all settings keys appear
 * @root_group: (allow-none): the group name corresponding to @root_path, or %NULL
 *
 * Creates a keyfile-backed #GSettingsBackend.
 *
 * The filename of the keyfile to use is given by @filename.
 *
 * All settings read to or written from the backend must fall under the
 * path given in @root_path (which must start and end with a slash and
 * not contain two consecutive slashes).  @root_path may be "/".
 *
 * If @root_group is non-%NULL then it specifies the name of the keyfile
 * group used for keys that are written directly below @root_path.  For
 * example, if @root_path is "/apps/example/" and @root_group is
 * "toplevel", then settings the key "/apps/example/enabled" to a value
 * of %TRUE will cause the following to appear in the keyfile:
 *
 * |[
 * [toplevel]
 * enabled=true
 * ]|
 *
 * If @root_group is %NULL then it is not permitted to store keys
 * directly below the @root_path.
 *
 * For keys not stored directly below @root_path (ie: in a sub-path),
 * the name of the subpath (with the final slash stripped) is used as
 * the name of the keyfile group.  To continue the example, if
 * "/apps/example/profiles/default/font-size" were set to
 * 12 then the following would appear in the keyfile:
 *
 * |[
 * [profiles/default]
 * font-size=12
 * ]|
 *
 * The backend will refuse writes (and return writability as being
 * %FALSE) for keys outside of @root_path and, in the event that
 * @root_group is %NULL, also for keys directly under @root_path.
 * Writes will also be refused if the backend detects that it has the
 * inability to rewrite the keyfile (ie: the containing directory is not
 * writable).
 *
 * There is no checking done for your key namespace clashing with the
 * syntax of the key file format.  For example, if you have '[' or ']'
 * characters in your path names or '=' in your key names you may be in
 * trouble.
 *
 * Returns: (transfer full): a keyfile-backed #GSettingsBackend
 */


/**
 * g_loadable_icon_load:
 * @icon: a #GLoadableIcon.
 * @size: an integer.
 * @type: (out) (allow-none): a location to store the type of the loaded icon, %NULL to ignore.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Loads a loadable icon. For the asynchronous version of this function,
 * see g_loadable_icon_load_async().
 *
 * Returns: (transfer full): a #GInputStream to read the icon from.
 */


/**
 * g_loadable_icon_load_async:
 * @icon: a #GLoadableIcon.
 * @size: an integer.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (scope async): a #GAsyncReadyCallback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Loads an icon asynchronously. To finish this function, see
 * g_loadable_icon_load_finish(). For the synchronous, blocking
 * version of this function, see g_loadable_icon_load().
 */


/**
 * g_loadable_icon_load_finish:
 * @icon: a #GLoadableIcon.
 * @res: a #GAsyncResult.
 * @type: a location to store the type of the loaded icon, %NULL to ignore.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes an asynchronous icon load started in g_loadable_icon_load_async().
 *
 * Returns: (transfer full): a #GInputStream to read the icon from.
 */


/**
 * g_local_vfs_new:
 *
 * Returns a new #GVfs handle for a local vfs.
 *
 * Returns: a new #GVfs handle.
 */


/**
 * g_main_destroy:
 * @loop: a #GMainLoop
 *
 * Frees the memory allocated for the #GMainLoop.
 *
 * Deprecated: 2.2: Use g_main_loop_unref() instead
 */


/**
 * g_main_is_running:
 * @loop: a #GMainLoop
 *
 * Checks if the main loop is running.
 *
 * Returns: %TRUE if the main loop is running
 * Deprecated: 2.2: Use g_main_loop_is_running() instead
 */


/**
 * g_main_iteration:
 * @may_block: set to %TRUE if it should block (i.e. wait) until an event source becomes ready. It will return after an event source has been processed. If set to %FALSE it will return immediately if no event source is ready to be processed.
 *
 * Runs a single iteration for the default #GMainContext.
 *
 * Returns: %TRUE if more events are pending.
 * Deprecated: 2.2: Use g_main_context_iteration() instead.
 */


/**
 * g_main_new:
 * @is_running: set to %TRUE to indicate that the loop is running. This is not very important since calling g_main_run() will set this to %TRUE anyway.
 *
 * Creates a new #GMainLoop for th default main context.
 *
 * Returns: a new #GMainLoop
 * Deprecated: 2.2: Use g_main_loop_new() instead
 */


/**
 * g_main_pending:
 *
 * Checks if any events are pending for the default #GMainContext
 * (i.e. ready to be processed).
 *
 *
 * Deprected: 2.2: Use g_main_context_pending() instead.
 *
 * Returns: %TRUE if any events are pending.
 */


/**
 * g_main_quit:
 * @loop: a #GMainLoop
 *
 * Stops the #GMainLoop.
 * If g_main_run() was called to run the #GMainLoop, it will now return.
 *
 * Deprecated: 2.2: Use g_main_loop_quit() instead
 */


/**
 * g_main_run:
 * @loop: a #GMainLoop
 *
 * Runs a main loop until it stops running.
 *
 * Deprecated: 2.2: Use g_main_loop_run() instead
 */


/**
 * g_main_set_poll_func:
 * @func: the function to call to poll all file descriptors
 *
 * Sets the function to use for the handle polling of file descriptors
 * for the default main context.
 *
 * Deprecated: 2.2: Use g_main_context_set_poll_func() again
 */


/**
 * g_memory_input_stream_add_data:
 * @stream: a #GMemoryInputStream
 * @data: (array length=len) (element-type guint8): input data
 * @len: length of the data, may be -1 if @data is a nul-terminated string
 * @destroy: (allow-none): function that is called to free @data, or %NULL
 *
 * Appends @data to data that can be read from the input stream
 */


/**
 * g_memory_input_stream_new:
 *
 * Creates a new empty #GMemoryInputStream.
 *
 * Returns: a new #GInputStream
 */


/**
 * g_memory_input_stream_new_from_data:
 * @data: (array length=len) (element-type guint8): input data
 * @len: length of the data, may be -1 if @data is a nul-terminated string
 * @destroy: (allow-none): function that is called to free @data, or %NULL
 *
 * Creates a new #GMemoryInputStream with data in memory of a given size.
 *
 * Returns: new #GInputStream read from @data of @len bytes.
 */


/**
 * g_memory_output_stream_get_data:
 * @ostream: a #GMemoryOutputStream
 *
 * Gets any loaded data from the @ostream.
 *
 * Note that the returned pointer may become invalid on the next
 * write or truncate operation on the stream.
 *
 * Returns: (transfer none): pointer to the stream's data
 */


/**
 * g_memory_output_stream_get_data_size:
 * @ostream: a #GMemoryOutputStream
 *
 * Returns the number of bytes from the start up
 * to including the last byte written in the stream
 * that has not been truncated away.
 *
 * Returns: the number of bytes written to the stream
 * Since: 2.18
 */


/**
 * g_memory_output_stream_get_size:
 * @ostream: a #GMemoryOutputStream
 *
 * Gets the size of the currently allocated data area (available from
 * g_memory_output_stream_get_data()). If the stream isn't
 * growable (no realloc was passed to g_memory_output_stream_new()) then
 * this is the maximum size of the stream and further writes
 * will return %G_IO_ERROR_NO_SPACE.
 *
 * Note that for growable streams the returned size may become invalid on
 * the next write or truncate operation on the stream.
 *
 * If you want the number of bytes currently written to the stream, use
 * g_memory_output_stream_get_data_size().
 *
 * Returns: the number of bytes allocated for the data buffer
 */


/**
 * g_memory_output_stream_new: (skip)
 * @data: pointer to a chunk of memory to use, or %NULL
 * @size: the size of @data
 * @realloc_function: a function with realloc() semantics (like g_realloc()) to be called when @data needs to be grown, or %NULL
 * @destroy_function: a function to be called on @data when the stream is finalized, or %NULL
 *
 * Creates a new #GMemoryOutputStream.
 *
 * If @data is non-%NULL, the stream  will use that for its internal storage.
 * If @realloc_fn is non-%NULL, it will be used for resizing the internal
 * storage when necessary. To construct a fixed-size output stream,
 * pass %NULL as @realloc_fn.
 *
 * |[
 * /&ast; a stream that can grow &ast;/
 * stream = g_memory_output_stream_new (NULL, 0, realloc, free);
 *
 * /&ast; another stream that can grow &ast;/
 * stream2 = g_memory_output_stream_new (NULL, 0, g_realloc, g_free);
 *
 * /&ast; a fixed-size stream &ast;/
 * data = malloc (200);
 * stream3 = g_memory_output_stream_new (data, 200, NULL, free);
 * ]|
 *
 * Returns: A newly created #GMemoryOutputStream object.
 */


/**
 * g_memory_output_stream_steal_data:
 * @ostream: a #GMemoryOutputStream
 *
 * Gets any loaded data from the @ostream. Ownership of the data
 * is transferred to the caller; when no longer needed it must be
 * freed using the free function set in @ostream's
 * #GMemoryOutputStream:destroy-function property.
 *
 * @ostream must be closed before calling this function.
 *
 * Returns: (transfer full): the stream's data
 * Since: 2.26
 */


/**
 * g_memory_settings_backend_new:
 *
 * Creates a memory-backed #GSettingsBackend.
 *
 * This backend allows changes to settings, but does not write them
 * to any backing storage, so the next time you run your application,
 * the memory backend will start out with the default values again.
 *
 * Returns: (transfer full): a newly created #GSettingsBackend
 * Since: 2.28
 */


/**
 * g_menu_append:
 * @menu: a #GMenu
 * @label: (allow-none): the section label, or %NULL
 * @detailed_action: (allow-none): the detailed action string, or %NULL
 *
 * Convenience function for appending a normal menu item to the end of
 * @menu.  Combine g_menu_new() and g_menu_insert_item() for a more
 * flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_append_item:
 * @menu: a #GMenu
 * @item: a #GMenuItem to append
 *
 * Appends @item to the end of @menu.
 *
 * See g_menu_insert_item() for more information.
 *
 * Since: 2.32
 */


/**
 * g_menu_append_section:
 * @menu: a #GMenu
 * @label: (allow-none): the section label, or %NULL
 * @section: a #GMenuModel with the items of the section
 *
 * Convenience function for appending a section menu item to the end of
 * @menu.  Combine g_menu_new_section() and g_menu_insert_item() for a
 * more flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_append_submenu:
 * @menu: a #GMenu
 * @label: (allow-none): the section label, or %NULL
 * @submenu: a #GMenuModel with the items of the submenu
 *
 * Convenience function for appending a submenu menu item to the end of
 * @menu.  Combine g_menu_new_submenu() and g_menu_insert_item() for a
 * more flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_attribute_iter_get_name:
 * @iter: a #GMenuAttributeIter
 *
 * Gets the name of the attribute at the current iterator position, as
 * a string.
 *
 * The iterator is not advanced.
 *
 * Returns: the name of the attribute
 * Since: 2.32
 */


/**
 * g_menu_attribute_iter_get_next:
 * @iter: a #GMenuAttributeIter
 * @out_name: (out) (allow-none) (transfer none): the type of the attribute
 * @value: (out) (allow-none) (transfer full): the attribute value
 *
 * This function combines g_menu_attribute_iter_next() with
 * g_menu_attribute_iter_get_name() and g_menu_attribute_iter_get_value().
 *
 * First the iterator is advanced to the next (possibly first) attribute.
 * If that fails, then %FALSE is returned and there are no other
 * effects.
 *
 * If successful, @name and @value are set to the name and value of the
 * attribute that has just been advanced to.  At this point,
 * g_menu_item_get_name() and g_menu_item_get_value() will return the
 * same values again.
 *
 * The value returned in @name remains valid for as long as the iterator
 * remains at the current position.  The value returned in @value must
 * be unreffed using g_variant_unref() when it is no longer in use.
 *
 * attribute
 *
 * Returns: %TRUE on success, or %FALSE if there is no additional
 * Since: 2.32
 */


/**
 * g_menu_attribute_iter_get_value:
 * @iter: a #GMenuAttributeIter
 *
 * Gets the value of the attribute at the current iterator position.
 *
 * The iterator is not advanced.
 *
 * Returns: (transfer full): the value of the current attribute
 * Since: 2.32
 */


/**
 * g_menu_attribute_iter_next:
 * @iter: a #GMenuAttributeIter
 *
 * Attempts to advance the iterator to the next (possibly first)
 * attribute.
 *
 * %TRUE is returned on success, or %FALSE if there are no more
 * attributes.
 *
 * You must call this function when you first acquire the iterator
 * to advance it to the first attribute (and determine if the first
 * attribute exists at all).
 *
 * Returns: %TRUE on success, or %FALSE when there are no more attributes
 * Since: 2.32
 */


/**
 * g_menu_freeze:
 * @menu: a #GMenu
 *
 * Marks @menu as frozen.
 *
 * After the menu is frozen, it is an error to attempt to make any
 * changes to it.  In effect this means that the #GMenu API must no
 * longer be used.
 *
 * This function causes g_menu_model_is_mutable() to begin returning
 * %FALSE, which has some positive performance implications.
 *
 * Since: 2.32
 */


/**
 * g_menu_insert:
 * @menu: a #GMenu
 * @position: the position at which to insert the item
 * @label: (allow-none): the section label, or %NULL
 * @detailed_action: (allow-none): the detailed action string, or %NULL
 *
 * Convenience function for inserting a normal menu item into @menu.
 * Combine g_menu_new() and g_menu_insert_item() for a more flexible
 * alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_insert_item:
 * @menu: a #GMenu
 * @position: the position at which to insert the item
 * @item: the #GMenuItem to insert
 *
 * Inserts @item into @menu.
 *
 * The "insertion" is actually done by copying all of the attribute and
 * link values of @item and using them to form a new item within @menu.
 * As such, @item itself is not really inserted, but rather, a menu item
 * that is exactly the same as the one presently described by @item.
 *
 * This means that @item is essentially useless after the insertion
 * occurs.  Any changes you make to it are ignored unless it is inserted
 * again (at which point its updated values will be copied).
 *
 * You should probably just free @item once you're done.
 *
 * There are many convenience functions to take care of common cases.
 * See g_menu_insert(), g_menu_insert_section() and
 * g_menu_insert_submenu() as well as "prepend" and "append" variants of
 * each of these functions.
 *
 * Since: 2.32
 */


/**
 * g_menu_insert_section:
 * @menu: a #GMenu
 * @position: the position at which to insert the item
 * @label: (allow-none): the section label, or %NULL
 * @section: a #GMenuModel with the items of the section
 *
 * Convenience function for inserting a section menu item into @menu.
 * Combine g_menu_new_section() and g_menu_insert_item() for a more
 * flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_insert_submenu:
 * @menu: a #GMenu
 * @position: the position at which to insert the item
 * @label: (allow-none): the section label, or %NULL
 * @submenu: a #GMenuModel with the items of the submenu
 *
 * Convenience function for inserting a submenu menu item into @menu.
 * Combine g_menu_new_submenu() and g_menu_insert_item() for a more
 * flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_new:
 * @label: (allow-none): the section label, or %NULL
 * @detailed_action: (allow-none): the detailed action string, or %NULL
 *
 * Creates a new #GMenuItem.
 *
 * If @label is non-%NULL it is used to set the "label" attribute of the
 * new item.
 *
 * If @detailed_action is non-%NULL it is used to set the "action" and
 * possibly the "target" attribute of the new item.  See
 * g_menu_item_set_detailed_action() for more information.
 *
 * Returns: a new #GMenuItem
 * Since: 2.32
 */


/**
 * g_menu_item_new_section:
 * @label: (allow-none): the section label, or %NULL
 * @section: a #GMenuModel with the items of the section
 *
 * Creates a new #GMenuItem representing a section.
 *
 * This is a convenience API around g_menu_item_new() and
 * g_menu_item_set_section().
 *
 * The effect of having one menu appear as a section of another is
 * exactly as it sounds: the items from @section become a direct part of
 * the menu that @menu_item is added to.
 *
 * Visual separation is typically displayed between two non-empty
 * sections.  If @label is non-%NULL then it will be encorporated into
 * this visual indication.  This allows for labeled subsections of a
 * menu.
 *
 * As a simple example, consider a typical "Edit" menu from a simple
 * program.  It probably contains an "Undo" and "Redo" item, followed by
 * a separator, followed by "Cut", "Copy" and "Paste".
 *
 * This would be accomplished by creating three #GMenu instances.  The
 * first would be populated with the "Undo" and "Redo" items, and the
 * second with the "Cut", "Copy" and "Paste" items.  The first and
 * second menus would then be added as submenus of the third.  In XML
 * format, this would look something like the following:
 *
 * <informalexample><programlisting><![CDATA[
 * <menu id='edit-menu'>
 * <section>
 * <item label='Undo'/>
 * <item label='Redo'/>
 * </section>
 * <section>
 * <item label='Cut'/>
 * <item label='Copy'/>
 * <item label='Paste'/>
 * </section>
 * </menu>
 * ]]></programlisting></informalexample>
 *
 * The following example is exactly equivalent.  It is more illustrative
 * of the exact relationship between the menus and items (keeping in
 * mind that the 'link' element defines a new menu that is linked to the
 * containing one).  The style of the second example is more verbose and
 * difficult to read (and therefore not recommended except for the
 * purpose of understanding what is really going on).
 *
 * <informalexample><programlisting><![CDATA[
 * <menu id='edit-menu'>
 * <item>
 * <link name='section'>
 * <item label='Undo'/>
 * <item label='Redo'/>
 * </link>
 * </item>
 * <item>
 * <link name='section'>
 * <item label='Cut'/>
 * <item label='Copy'/>
 * <item label='Paste'/>
 * </link>
 * </item>
 * </menu>
 * ]]></programlisting></informalexample>
 *
 * Returns: a new #GMenuItem
 * Since: 2.32
 */


/**
 * g_menu_item_new_submenu:
 * @label: (allow-none): the section label, or %NULL
 * @submenu: a #GMenuModel with the items of the submenu
 *
 * Creates a new #GMenuItem representing a submenu.
 *
 * This is a convenience API around g_menu_item_new() and
 * g_menu_item_set_submenu().
 *
 * Returns: a new #GMenuItem
 * Since: 2.32
 */


/**
 * g_menu_item_set_action_and_target:
 * @menu_item: a #GMenuItem
 * @action: (allow-none): the name of the action for this item
 * @format_string: (allow-none): a GVariant format string
 * @...: positional parameters, as per @format_string
 *
 * Sets or unsets the "action" and "target" attributes of @menu_item.
 *
 * If @action is %NULL then both the "action" and "target" attributes
 * are unset (and @format_string is ignored along with the positional
 * parameters).
 *
 * If @action is non-%NULL then the "action" attribute is set.
 * @format_string is then inspected.  If it is non-%NULL then the proper
 * position parameters are collected to create a #GVariant instance to
 * use as the target value.  If it is %NULL then the positional
 * parameters are ignored and the "target" attribute is unset.
 *
 * See also g_menu_item_set_action_and_target_value() for an equivalent
 * call that directly accepts a #GVariant.  See
 * g_menu_item_set_detailed_action() for a more convenient version that
 * works with string-typed targets.
 *
 * See also g_menu_item_set_action_and_target_value() for a
 * description of the semantics of the action and target attributes.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_action_and_target_value:
 * @menu_item: a #GMenuItem
 * @action: (allow-none): the name of the action for this item
 * @target_value: (allow-none): a #GVariant to use as the action target
 *
 * Sets or unsets the "action" and "target" attributes of @menu_item.
 *
 * If @action is %NULL then both the "action" and "target" attributes
 * are unset (and @target_value is ignored).
 *
 * If @action is non-%NULL then the "action" attribute is set.  The
 * "target" attribute is then set to the value of @target_value if it is
 * non-%NULL or unset otherwise.
 *
 * Normal menu items (ie: not submenu, section or other custom item
 * types) are expected to have the "action" attribute set to identify
 * the action that they are associated with.  The state type of the
 * action help to determine the disposition of the menu item.  See
 * #GAction and #GActionGroup for an overview of actions.
 *
 * In general, clicking on the menu item will result in activation of
 * the named action with the "target" attribute given as the parameter
 * to the action invocation.  If the "target" attribute is not set then
 * the action is invoked with no parameter.
 *
 * If the action has no state then the menu item is usually drawn as a
 * plain menu item (ie: with no additional decoration).
 *
 * If the action has a boolean state then the menu item is usually drawn
 * as a toggle menu item (ie: with a checkmark or equivalent
 * indication).  The item should be marked as 'toggled' or 'checked'
 * when the boolean state is %TRUE.
 *
 * If the action has a string state then the menu item is usually drawn
 * as a radio menu item (ie: with a radio bullet or equivalent
 * indication).  The item should be marked as 'selected' when the string
 * state is equal to the value of the @target property.
 *
 * See g_menu_item_set_action_and_target() or
 * g_menu_item_set_detailed_action() for two equivalent calls that are
 * probably more convenient for most uses.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_attribute:
 * @menu_item: a #GMenuItem
 * @attribute: the attribute to set
 * @format_string: (allow-none): a #GVariant format string, or %NULL
 * @...: positional parameters, as per @format_string
 *
 * Sets or unsets an attribute on @menu_item.
 *
 * The attribute to set or unset is specified by @attribute. This
 * can be one of the standard attribute names %G_MENU_ATTRIBUTE_LABEL,
 * %G_MENU_ATTRIBUTE_ACTION, %G_MENU_ATTRIBUTE_TARGET, or a custom
 * attribute name.
 * Attribute names are restricted to lowercase characters, numbers
 * and '-'. Furthermore, the names must begin with a lowercase character,
 * must not end with a '-', and must not contain consecutive dashes.
 *
 * If @format_string is non-%NULL then the proper position parameters
 * are collected to create a #GVariant instance to use as the attribute
 * value.  If it is %NULL then the positional parameterrs are ignored
 * and the named attribute is unset.
 *
 * See also g_menu_item_set_attribute_value() for an equivalent call
 * that directly accepts a #GVariant.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_attribute_value:
 * @menu_item: a #GMenuItem
 * @attribute: the attribute to set
 * @value: (allow-none): a #GVariant to use as the value, or %NULL
 *
 * Sets or unsets an attribute on @menu_item.
 *
 * The attribute to set or unset is specified by @attribute. This
 * can be one of the standard attribute names %G_MENU_ATTRIBUTE_LABEL,
 * %G_MENU_ATTRIBUTE_ACTION, %G_MENU_ATTRIBUTE_TARGET, or a custom
 * attribute name.
 * Attribute names are restricted to lowercase characters, numbers
 * and '-'. Furthermore, the names must begin with a lowercase character,
 * must not end with a '-', and must not contain consecutive dashes.
 *
 * must consist only of lowercase
 * ASCII characters, digits and '-'.
 *
 * If @value is non-%NULL then it is used as the new value for the
 * attribute.  If @value is %NULL then the attribute is unset. If
 * the @value #GVariant is floating, it is consumed.
 *
 * See also g_menu_item_set_attribute() for a more convenient way to do
 * the same.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_detailed_action:
 * @menu_item: a #GMenuItem
 * @detailed_action: the "detailed" action string
 *
 * Sets the "action" and possibly the "target" attribute of @menu_item.
 *
 * If @detailed_action contains a double colon ("::") then it is used as
 * a separator between an action name and a target string.  In this
 * case, this call is equivalent to calling
 * g_menu_item_set_action_and_target() with the part before the "::" and
 * g_menu_item_set_target_value() with a string-type #GVariant
 * containing the part following the "::".
 *
 * If @detailed_action doesn't contain "::" then the action is set to
 * the given string (verbatim) and the target value is unset.
 *
 * See g_menu_item_set_action_and_target() or
 * g_menu_item_set_action_and_target_value() for more flexible (but
 * slightly less convenient) alternatives.
 *
 * See also g_menu_set_action_and_target_value() for a description of
 * the semantics of the action and target attributes.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_label:
 * @menu_item: a #GMenuItem
 * @label: (allow-none): the label to set, or %NULL to unset
 *
 * Sets or unsets the "label" attribute of @menu_item.
 *
 * If @label is non-%NULL it is used as the label for the menu item.  If
 * it is %NULL then the label attribute is unset.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_link:
 * @menu_item: a #GMenuItem
 * @link: type of link to establish or unset
 * @model: (allow-none): the #GMenuModel to link to (or %NULL to unset)
 *
 * Creates a link from @menu_item to @model if non-%NULL, or unsets it.
 *
 * Links are used to establish a relationship between a particular menu
 * item and another menu.  For example, %G_MENU_LINK_SUBMENU is used to
 * associate a submenu with a particular menu item, and %G_MENU_LINK_SECTION
 * is used to create a section. Other types of link can be used, but there
 * is no guarantee that clients will be able to make sense of them.
 * Link types are restricted to lowercase characters, numbers
 * and '-'. Furthermore, the names must begin with a lowercase character,
 * must not end with a '-', and must not contain consecutive dashes.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_section:
 * @menu_item: a #GMenuItem
 * @section: (allow-none): a #GMenuModel, or %NULL
 *
 * Sets or unsets the "section" link of @menu_item to @section.
 *
 * The effect of having one menu appear as a section of another is
 * exactly as it sounds: the items from @section become a direct part of
 * the menu that @menu_item is added to.  See g_menu_item_new_section()
 * for more information about what it means for a menu item to be a
 * section.
 *
 * Since: 2.32
 */


/**
 * g_menu_item_set_submenu:
 * @menu_item: a #GMenuItem
 * @submenu: (allow-none): a #GMenuModel, or %NULL
 *
 * Sets or unsets the "submenu" link of @menu_item to @submenu.
 *
 * If @submenu is non-%NULL, it is linked to.  If it is %NULL then the
 * link is unset.
 *
 * The effect of having one menu appear as a submenu of another is
 * exactly as it sounds.
 *
 * Since: 2.32
 */


/**
 * g_menu_link_iter_get_name:
 * @iter: a #GMenuLinkIter
 *
 * Gets the name of the link at the current iterator position.
 *
 * The iterator is not advanced.
 *
 * Returns: the type of the link
 * Since: 2.32
 */


/**
 * g_menu_link_iter_get_next:
 * @iter: a #GMenuLinkIter
 * @out_link: (out) (allow-none) (transfer none): the name of the link
 * @value: (out) (allow-none) (transfer full): the linked #GMenuModel
 *
 * This function combines g_menu_link_iter_next() with
 * g_menu_link_iter_get_name() and g_menu_link_iter_get_value().
 *
 * First the iterator is advanced to the next (possibly first) link.
 * If that fails, then %FALSE is returned and there are no other effects.
 *
 * If successful, @out_link and @value are set to the name and #GMenuModel
 * of the link that has just been advanced to.  At this point,
 * g_menu_item_get_name() and g_menu_item_get_value() will return the
 * same values again.
 *
 * The value returned in @out_link remains valid for as long as the iterator
 * remains at the current position.  The value returned in @value must
 * be unreffed using g_object_unref() when it is no longer in use.
 *
 * Returns: %TRUE on success, or %FALSE if there is no additional link
 * Since: 2.32
 */


/**
 * g_menu_link_iter_get_value:
 * @iter: a #GMenuLinkIter
 *
 * Gets the linked #GMenuModel at the current iterator position.
 *
 * The iterator is not advanced.
 *
 * Returns: (transfer full): the #GMenuModel that is linked to
 * Since: 2.32
 */


/**
 * g_menu_link_iter_next:
 * @iter: a #GMenuLinkIter
 *
 * Attempts to advance the iterator to the next (possibly first)
 * link.
 *
 * %TRUE is returned on success, or %FALSE if there are no more links.
 *
 * You must call this function when you first acquire the iterator to
 * advance it to the first link (and determine if the first link exists
 * at all).
 *
 * Returns: %TRUE on success, or %FALSE when there are no more links
 * Since: 2.32
 */


/**
 * g_menu_markup_parser_end:
 * @context: a #GMarkupParseContext
 *
 * Stop the parsing of a set of menus and return the #GHashTable.
 *
 * The #GHashTable maps strings to #GObject instances.  The parser only
 * adds #GMenu instances to the table, but it may contain other types if
 * a table was provided to g_menu_markup_parser_start().
 *
 * This call should be matched with g_menu_markup_parser_start().
 * See that function for more information
 *
 * Returns: (transfer full): the #GHashTable containing the objects
 * Since: 2.32
 */


/**
 * g_menu_markup_parser_end_menu:
 * @context: a #GMarkupParseContext
 *
 * Stop the parsing of a menu and return the newly-created #GMenu.
 *
 * This call should be matched with g_menu_markup_parser_start_menu().
 * See that function for more information
 *
 * Returns: (transfer full): the newly-created #GMenu
 * Since: 2.32
 */


/**
 * g_menu_markup_parser_start:
 * @context: a #GMarkupParseContext
 * @domain: (allow-none): translation domain for labels, or %NULL
 * @objects: (allow-none): a #GHashTable for the objects, or %NULL
 *
 * Begin parsing a group of menus in XML form.
 *
 * If @domain is not %NULL, it will be used to translate attributes
 * that are marked as translatable, using gettext().
 *
 * If @objects is specified then it must be a #GHashTable that was
 * created using g_hash_table_new_full() with g_str_hash(),
 * g_str_equal(), g_free() and g_object_unref().  Any named menus (ie:
 * those with an id='' attribute) that are encountered while parsing
 * will be added to this table.  Each toplevel menu must be named.
 *
 * If @objects is %NULL then an empty hash table will be created.
 *
 * This function should be called from the start_element function for
 * the element representing the group containing the menus.  In other
 * words, the content inside of this element is expected to be a list of
 * menus.
 *
 * Since: 2.32
 */


/**
 * g_menu_markup_parser_start_menu:
 * @context: a #GMarkupParseContext
 * @domain: (allow-none): translation domain for labels, or %NULL
 * @objects: (allow-none): a #GHashTable for the objects, or %NULL
 *
 * Begin parsing the XML definition of a menu.
 *
 * This function should be called from the start_element function for
 * the element representing the menu itself.  In other words, the
 * content inside of this element is expected to be a list of items.
 *
 * If @domain is not %NULL, it will be used to translate attributes
 * that are marked as translatable, using gettext().
 *
 * If @objects is specified then it must be a #GHashTable that was
 * created using g_hash_table_new_full() with g_str_hash(),
 * g_str_equal(), g_free() and g_object_unref().  Any named menus (ie:
 * those with an * id='' attribute) that are encountered while parsing
 * will be added to this table.
 *
 * If @objects is %NULL then named menus will not be supported.
 *
 * You should call g_menu_markup_parser_end_menu() from the
 * corresponding end_element function in order to collect the newly
 * parsed menu.
 *
 * Since: 2.32
 */


/**
 * g_menu_markup_print_stderr:
 * @model: a #GMenuModel
 *
 * Print @model to stderr for debugging purposes.
 *
 * This debugging function will be removed in the future.
 */


/**
 * g_menu_markup_print_string:
 * @string: a #GString
 * @model: the #GMenuModel to print
 * @indent: the intentation level to start at
 * @tabstop: how much to indent each level
 *
 * Print the contents of @model to @string.
 * Note that you have to provide the containing
 * <tag class="starttag">menu</tag> element yourself.
 *
 * Returns: @string
 * Since: 2.32
 */


/**
 * g_menu_model_get_item_attribute:
 * @model: a #GMenuModel
 * @item_index: the index of the item
 * @attribute: the attribute to query
 * @format_string: a #GVariant format string
 * @...: positional parameters, as per @format_string
 *
 * Queries item at position @item_index in @model for the attribute
 * specified by @attribute.
 *
 * If the attribute exists and matches the #GVariantType corresponding
 * to @format_string then @format_string is used to deconstruct the
 * value into the positional parameters and %TRUE is returned.
 *
 * If the attribute does not exist, or it does exist but has the wrong
 * type, then the positional parameters are ignored and %FALSE is
 * returned.
 *
 * type
 *
 * Returns: %TRUE if the named attribute was found with the expected
 * Since: 2.32
 */


/**
 * g_menu_model_get_item_attribute_value:
 * @model: a #GMenuModel
 * @item_index: the index of the item
 * @attribute: the attribute to query
 * @expected_type: (allow-none): the expected type of the attribute, or %NULL
 *
 * Queries the item at position @item_index in @model for the attribute
 * specified by @attribute.
 *
 * If @expected_type is non-%NULL then it specifies the expected type of
 * the attribute.  If it is %NULL then any type will be accepted.
 *
 * If the attribute exists and matches @expected_type (or if the
 * expected type is unspecified) then the value is returned.
 *
 * If the attribute does not exist, or does not match the expected type
 * then %NULL is returned.
 *
 * Returns: (transfer full): the value of the attribute
 * Since: 2.32
 */


/**
 * g_menu_model_get_item_link:
 * @model: a #GMenuModel
 * @item_index: the index of the item
 * @link: the link to query
 *
 * Queries the item at position @item_index in @model for the link
 * specified by @link.
 *
 * If the link exists, the linked #GMenuModel is returned.  If the link
 * does not exist, %NULL is returned.
 *
 * Returns: (transfer full): the linked #GMenuModel, or %NULL
 * Since: 2.32
 */


/**
 * g_menu_model_get_n_items:
 * @model: a #GMenuModel
 *
 * Query the number of items in @model.
 *
 * Returns: the number of items
 * Since: 2.32
 */


/**
 * g_menu_model_is_mutable:
 * @model: a #GMenuModel
 *
 * Queries if @model is mutable.
 *
 * An immutable #GMenuModel will never emit the #GMenuModel::items-changed
 * signal. Consumers of the model may make optimisations accordingly.
 *
 * emitted).
 *
 * Returns: %TRUE if the model is mutable (ie: "items-changed" may be
 * Since: 2.32
 */


/**
 * g_menu_model_items_changed:
 * @model: a #GMenuModel
 * @position: the position of the change
 * @removed: the number of items removed
 * @added: the number of items added
 *
 * Requests emission of the #GMenuModel::items-changed signal on @model.
 *
 * This function should never be called except by #GMenuModel
 * subclasses.  Any other calls to this function will very likely lead
 * to a violation of the interface of the model.
 *
 * The implementation should update its internal representation of the
 * menu before emitting the signal.  The implementation should further
 * expect to receive queries about the new state of the menu (and
 * particularly added menu items) while signal handlers are running.
 *
 * The implementation must dispatch this call directly from a mainloop
 * entry and not in response to calls -- particularly those from the
 * #GMenuModel API.  Said another way: the menu must not change while
 * user code is running without returning to the mainloop.
 *
 * Since: 2.32
 */


/**
 * g_menu_model_iterate_item_attributes:
 * @model: a #GMenuModel
 * @item_index: the index of the item
 *
 * Creates a #GMenuAttributeIter to iterate over the attributes of
 * the item at position @item_index in @model.
 *
 * You must free the iterator with g_object_unref() when you are done.
 *
 * Returns: (transfer full): a new #GMenuAttributeIter
 * Since: 2.32
 */


/**
 * g_menu_model_iterate_item_links:
 * @model: a #GMenuModel
 * @item_index: the index of the item
 *
 * Creates a #GMenuLinkIter to iterate over the links of the item at
 * position @item_index in @model.
 *
 * You must free the iterator with g_object_unref() when you are done.
 *
 * Returns: (transfer full): a new #GMenuLinkIter
 * Since: 2.32
 */


/**
 * g_menu_new:
 *
 * Creates a new #GMenu.
 *
 * The new menu has no items.
 *
 * Returns: a new #GMenu
 * Since: 2.32
 */


/**
 * g_menu_prepend:
 * @menu: a #GMenu
 * @label: (allow-none): the section label, or %NULL
 * @detailed_action: (allow-none): the detailed action string, or %NULL
 *
 * Convenience function for prepending a normal menu item to the start
 * of @menu.  Combine g_menu_new() and g_menu_insert_item() for a more
 * flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_prepend_item:
 * @menu: a #GMenu
 * @item: a #GMenuItem to prepend
 *
 * Prepends @item to the start of @menu.
 *
 * See g_menu_insert_item() for more information.
 *
 * Since: 2.32
 */


/**
 * g_menu_prepend_section:
 * @menu: a #GMenu
 * @label: (allow-none): the section label, or %NULL
 * @section: a #GMenuModel with the items of the section
 *
 * Convenience function for prepending a section menu item to the start
 * of @menu.  Combine g_menu_new_section() and g_menu_insert_item() for
 * a more flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_prepend_submenu:
 * @menu: a #GMenu
 * @label: (allow-none): the section label, or %NULL
 * @submenu: a #GMenuModel with the items of the submenu
 *
 * Convenience function for prepending a submenu menu item to the start
 * of @menu.  Combine g_menu_new_submenu() and g_menu_insert_item() for
 * a more flexible alternative.
 *
 * Since: 2.32
 */


/**
 * g_menu_remove:
 * @menu: a #GMenu
 * @position: the position of the item to remove
 *
 * Removes an item from the menu.
 *
 * @position gives the index of the item to remove.
 *
 * It is an error if position is not in range the range from 0 to one
 * less than the number of items in the menu.
 *
 * It is not possible to remove items by identity since items are added
 * to the menu simply by copying their links and attributes (ie:
 * identity of the item itself is not preserved).
 *
 * Since: 2.32
 */


/**
 * g_mount_can_eject:
 * @mount: a #GMount.
 *
 * Checks if @mount can be eject.
 *
 * Returns: %TRUE if the @mount can be ejected.
 */


/**
 * g_mount_can_unmount:
 * @mount: a #GMount.
 *
 * Checks if @mount can be mounted.
 *
 * Returns: %TRUE if the @mount can be unmounted.
 */


/**
 * g_mount_eject:
 * @mount: a #GMount.
 * @flags: flags affecting the unmount if required for eject
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (allow-none): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Ejects a mount. This is an asynchronous operation, and is
 * finished by calling g_mount_eject_finish() with the @mount
 * and #GAsyncResult data returned in the @callback.
 *
 * Deprecated: 2.22: Use g_mount_eject_with_operation() instead.
 */


/**
 * g_mount_eject_finish:
 * @mount: a #GMount.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes ejecting a mount. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the mount was successfully ejected. %FALSE otherwise.
 * Deprecated: 2.22: Use g_mount_eject_with_operation_finish() instead.
 */


/**
 * g_mount_eject_with_operation:
 * @mount: a #GMount.
 * @flags: flags affecting the unmount if required for eject
 * @mount_operation: (allow-none): a #GMountOperation or %NULL to avoid user interaction.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (allow-none): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Ejects a mount. This is an asynchronous operation, and is
 * finished by calling g_mount_eject_with_operation_finish() with the @mount
 * and #GAsyncResult data returned in the @callback.
 *
 * Since: 2.22
 */


/**
 * g_mount_eject_with_operation_finish:
 * @mount: a #GMount.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes ejecting a mount. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the mount was successfully ejected. %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_mount_get_default_location:
 * @mount: a #GMount.
 *
 * Gets the default location of @mount. The default location of the given
 * @mount is a path that reflects the main entry point for the user (e.g.
 * the home directory, or the root of the volume).
 *
 * The returned object should be unreffed with
 * g_object_unref() when no longer needed.
 *
 * Returns: (transfer full): a #GFile.
 */


/**
 * g_mount_get_drive:
 * @mount: a #GMount.
 *
 * Gets the drive for the @mount.
 *
 * This is a convenience method for getting the #GVolume and then
 * using that object to get the #GDrive.
 *
 * The returned object should be unreffed with
 * g_object_unref() when no longer needed.
 *
 * Returns: (transfer full): a #GDrive or %NULL if @mount is not associated with a volume or a drive.
 */


/**
 * g_mount_get_icon:
 * @mount: a #GMount.
 *
 * Gets the icon for @mount.
 *
 * The returned object should be unreffed with
 * g_object_unref() when no longer needed.
 *
 * Returns: (transfer full): a #GIcon.
 */


/**
 * g_mount_get_name:
 * @mount: a #GMount.
 *
 * Gets the name of @mount.
 *
 * The returned string should be freed with g_free()
 * when no longer needed.
 *
 * Returns: the name for the given @mount.
 */


/**
 * g_mount_get_root:
 * @mount: a #GMount.
 *
 * Gets the root directory on @mount.
 *
 * The returned object should be unreffed with
 * g_object_unref() when no longer needed.
 *
 * Returns: (transfer full): a #GFile.
 */


/**
 * g_mount_get_sort_key:
 * @mount: A #GMount.
 *
 * Gets the sort key for @mount, if any.
 *
 * Returns: Sorting key for @mount or %NULL if no such key is available.
 * Since: 2.32
 */


/**
 * g_mount_get_uuid:
 * @mount: a #GMount.
 *
 * Gets the UUID for the @mount. The reference is typically based on
 * the file system UUID for the mount in question and should be
 * considered an opaque string. Returns %NULL if there is no UUID
 * available.
 *
 * The returned string should be freed with g_free()
 * when no longer needed.
 *
 * Returns: the UUID for @mount or %NULL if no UUID can be computed.
 */


/**
 * g_mount_get_volume:
 * @mount: a #GMount.
 *
 * Gets the volume for the @mount.
 *
 * The returned object should be unreffed with
 * g_object_unref() when no longer needed.
 *
 * Returns: (transfer full): a #GVolume or %NULL if @mount is not associated with a volume.
 */


/**
 * g_mount_guess_content_type:
 * @mount: a #GMount
 * @force_rescan: Whether to force a rescan of the content. Otherwise a cached result will be used if available
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @callback: a #GAsyncReadyCallback
 * @user_data: user data passed to @callback
 *
 * Tries to guess the type of content stored on @mount. Returns one or
 * more textual identifiers of well-known content types (typically
 * prefixed with "x-content/"), e.g. x-content/image-dcf for camera
 * memory cards. See the <ulink url="http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec">shared-mime-info</ulink>
 * specification for more on x-content types.
 *
 * This is an asynchronous operation (see
 * g_mount_guess_content_type_sync() for the synchronous version), and
 * is finished by calling g_mount_guess_content_type_finish() with the
 * @mount and #GAsyncResult data returned in the @callback.
 *
 * Since: 2.18
 */


/**
 * g_mount_guess_content_type_finish:
 * @mount: a #GMount
 * @result: a #GAsyncResult
 * @error: a #GError location to store the error occurring, or %NULL to ignore
 *
 * Finishes guessing content types of @mount. If any errors occurred
 * during the operation, @error will be set to contain the errors and
 * %FALSE will be returned. In particular, you may get an
 * %G_IO_ERROR_NOT_SUPPORTED if the mount does not support content
 * guessing.
 *
 * Caller should free this array with g_strfreev() when done with it.
 *
 * Returns: (transfer full) (element-type utf8): a %NULL-terminated array of content types or %NULL on error.
 * Since: 2.18
 */


/**
 * g_mount_guess_content_type_sync:
 * @mount: a #GMount
 * @force_rescan: Whether to force a rescan of the content. Otherwise a cached result will be used if available
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore
 * @error: a #GError location to store the error occurring, or %NULL to ignore
 *
 * Tries to guess the type of content stored on @mount. Returns one or
 * more textual identifiers of well-known content types (typically
 * prefixed with "x-content/"), e.g. x-content/image-dcf for camera
 * memory cards. See the <ulink url="http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec">shared-mime-info</ulink>
 * specification for more on x-content types.
 *
 * This is an synchronous operation and as such may block doing IO;
 * see g_mount_guess_content_type() for the asynchronous version.
 *
 * Caller should free this array with g_strfreev() when done with it.
 *
 * Returns: (transfer full) (element-type utf8): a %NULL-terminated array of content types or %NULL on error.
 * Since: 2.18
 */


/**
 * g_mount_is_shadowed:
 * @mount: A #GMount.
 *
 * Determines if @mount is shadowed. Applications or libraries should
 * avoid displaying @mount in the user interface if it is shadowed.
 *
 * A mount is said to be shadowed if there exists one or more user
 * visible objects (currently #GMount objects) with a root that is
 * inside the root of @mount.
 *
 * One application of shadow mounts is when exposing a single file
 * system that is used to address several logical volumes. In this
 * situation, a #GVolumeMonitor implementation would create two
 * #GVolume objects (for example, one for the camera functionality of
 * the device and one for a SD card reader on the device) with
 * activation URIs <literal>gphoto2://[usb:001,002]/store1/</literal>
 * and <literal>gphoto2://[usb:001,002]/store2/</literal>. When the
 * underlying mount (with root
 * <literal>gphoto2://[usb:001,002]/</literal>) is mounted, said
 * #GVolumeMonitor implementation would create two #GMount objects
 * (each with their root matching the corresponding volume activation
 * root) that would shadow the original mount.
 *
 * The proxy monitor in GVfs 2.26 and later, automatically creates and
 * manage shadow mounts (and shadows the underlying mount) if the
 * activation root on a #GVolume is set.
 *
 * Returns: %TRUE if @mount is shadowed.
 * Since: 2.20
 */


/**
 * g_mount_operation_get_anonymous:
 * @op: a #GMountOperation.
 *
 * Check to see whether the mount operation is being used
 * for an anonymous user.
 *
 * Returns: %TRUE if mount operation is anonymous.
 */


/**
 * g_mount_operation_get_choice:
 * @op: a #GMountOperation.
 *
 * Gets a choice from the mount operation.
 *
 * the choice's list, or %0.
 *
 * Returns: an integer containing an index of the user's choice from
 */


/**
 * g_mount_operation_get_domain:
 * @op: a #GMountOperation.
 *
 * Gets the domain of the mount operation.
 *
 * Returns: a string set to the domain.
 */


/**
 * g_mount_operation_get_password:
 * @op: a #GMountOperation.
 *
 * Gets a password from the mount operation.
 *
 * Returns: a string containing the password within @op.
 */


/**
 * g_mount_operation_get_password_save:
 * @op: a #GMountOperation.
 *
 * Gets the state of saving passwords for the mount operation.
 *
 * Returns: a #GPasswordSave flag.
 */


/**
 * g_mount_operation_get_username:
 * @op: a #GMountOperation.
 *
 * Get the user name from the mount operation.
 *
 * Returns: a string containing the user name.
 */


/**
 * g_mount_operation_new:
 *
 * Creates a new mount operation.
 *
 * Returns: a #GMountOperation.
 */


/**
 * g_mount_operation_reply:
 * @op: a #GMountOperation
 * @result: a #GMountOperationResult
 *
 * Emits the #GMountOperation::reply signal.
 */


/**
 * g_mount_operation_set_anonymous:
 * @op: a #GMountOperation.
 * @anonymous: boolean value.
 *
 * Sets the mount operation to use an anonymous user if @anonymous is %TRUE.
 */


/**
 * g_mount_operation_set_choice:
 * @op: a #GMountOperation.
 * @choice: an integer.
 *
 * Sets a default choice for the mount operation.
 */


/**
 * g_mount_operation_set_domain:
 * @op: a #GMountOperation.
 * @domain: the domain to set.
 *
 * Sets the mount operation's domain.
 */


/**
 * g_mount_operation_set_password:
 * @op: a #GMountOperation.
 * @password: password to set.
 *
 * Sets the mount operation's password to @password.
 */


/**
 * g_mount_operation_set_password_save:
 * @op: a #GMountOperation.
 * @save: a set of #GPasswordSave flags.
 *
 * Sets the state of saving passwords for the mount operation.
 */


/**
 * g_mount_operation_set_username:
 * @op: a #GMountOperation.
 * @username: input username.
 *
 * Sets the user name within @op to @username.
 */


/**
 * g_mount_remount:
 * @mount: a #GMount.
 * @flags: flags affecting the operation
 * @mount_operation: (allow-none): a #GMountOperation or %NULL to avoid user interaction.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (allow-none): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Remounts a mount. This is an asynchronous operation, and is
 * finished by calling g_mount_remount_finish() with the @mount
 * and #GAsyncResults data returned in the @callback.
 *
 * Remounting is useful when some setting affecting the operation
 * of the volume has been changed, as these may need a remount to
 * take affect. While this is semantically equivalent with unmounting
 * and then remounting not all backends might need to actually be
 * unmounted.
 */


/**
 * g_mount_remount_finish:
 * @mount: a #GMount.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes remounting a mount. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the mount was successfully remounted. %FALSE otherwise.
 */


/**
 * g_mount_shadow:
 * @mount: A #GMount.
 *
 * Increments the shadow count on @mount. Usually used by
 * #GVolumeMonitor implementations when creating a shadow mount for
 * @mount, see g_mount_is_shadowed() for more information. The caller
 * will need to emit the #GMount::changed signal on @mount manually.
 *
 * Since: 2.20
 */


/**
 * g_mount_unmount:
 * @mount: a #GMount.
 * @flags: flags affecting the operation
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (allow-none): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Unmounts a mount. This is an asynchronous operation, and is
 * finished by calling g_mount_unmount_finish() with the @mount
 * and #GAsyncResult data returned in the @callback.
 *
 * Deprecated: 2.22: Use g_mount_unmount_with_operation() instead.
 */


/**
 * g_mount_unmount_finish:
 * @mount: a #GMount.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes unmounting a mount. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the mount was successfully unmounted. %FALSE otherwise.
 * Deprecated: 2.22: Use g_mount_unmount_with_operation_finish() instead.
 */


/**
 * g_mount_unmount_with_operation:
 * @mount: a #GMount.
 * @flags: flags affecting the operation
 * @mount_operation: (allow-none): a #GMountOperation or %NULL to avoid user interaction.
 * @cancellable: (allow-none): optional #GCancellable object, %NULL to ignore.
 * @callback: (allow-none): a #GAsyncReadyCallback, or %NULL.
 * @user_data: user data passed to @callback.
 *
 * Unmounts a mount. This is an asynchronous operation, and is
 * finished by calling g_mount_unmount_with_operation_finish() with the @mount
 * and #GAsyncResult data returned in the @callback.
 *
 * Since: 2.22
 */


/**
 * g_mount_unmount_with_operation_finish:
 * @mount: a #GMount.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Finishes unmounting a mount. If any errors occurred during the operation,
 * @error will be set to contain the errors and %FALSE will be returned.
 *
 * Returns: %TRUE if the mount was successfully unmounted. %FALSE otherwise.
 * Since: 2.22
 */


/**
 * g_mount_unshadow:
 * @mount: A #GMount.
 *
 * Decrements the shadow count on @mount. Usually used by
 * #GVolumeMonitor implementations when destroying a shadow mount for
 * @mount, see g_mount_is_shadowed() for more information. The caller
 * will need to emit the #GMount::changed signal on @mount manually.
 *
 * Since: 2.20
 */


/**
 * g_network_address_get_hostname:
 * @addr: a #GNetworkAddress
 *
 * Gets @addr's hostname. This might be either UTF-8 or ASCII-encoded,
 * depending on what @addr was created with.
 *
 * Returns: @addr's hostname
 * Since: 2.22
 */


/**
 * g_network_address_get_port:
 * @addr: a #GNetworkAddress
 *
 * Gets @addr's port number
 *
 * Returns: @addr's port (which may be 0)
 * Since: 2.22
 */


/**
 * g_network_address_get_scheme:
 * @addr: a #GNetworkAddress
 *
 * Gets @addr's scheme
 *
 * Returns: @addr's scheme (%NULL if not built from URI)
 * Since: 2.26
 */


/**
 * g_network_address_new:
 * @hostname: the hostname
 * @port: the port
 *
 * Creates a new #GSocketConnectable for connecting to the given
 * @hostname and @port.
 *
 * Returns: (transfer full): the new #GNetworkAddress
 * Since: 2.22
 */


/**
 * g_network_address_parse:
 * @host_and_port: the hostname and optionally a port
 * @default_port: the default port if not in @host_and_port
 * @error: a pointer to a #GError, or %NULL
 *
 * Creates a new #GSocketConnectable for connecting to the given
 * @hostname and @port. May fail and return %NULL in case
 * parsing @host_and_port fails.
 *
 * @host_and_port may be in any of a number of recognised formats; an IPv6
 * address, an IPv4 address, or a domain name (in which case a DNS
 * lookup is performed). Quoting with [] is supported for all address
 * types. A port override may be specified in the usual way with a
 * colon.
 *
 * If no port is specified in @host_and_port then @default_port will be
 * used as the port number to connect to.
 *
 * In general, @host_and_port is expected to be provided by the user
 * (allowing them to give the hostname, and a port overide if necessary)
 * and @default_port is expected to be provided by the application.
 *
 * (The port component of @host_and_port can also be specified as a
 * service name rather than as a numeric port, but this functionality
 * is deprecated, because it depends on the contents of /etc/services,
 * which is generally quite sparse on platforms other than Linux.)
 *
 * Returns: (transfer full): the new #GNetworkAddress, or %NULL on error
 * Since: 2.22
 */


/**
 * g_network_address_parse_uri:
 * @uri: the hostname and optionally a port
 * @default_port: The default port if none is found in the URI
 * @error: a pointer to a #GError, or %NULL
 *
 * Creates a new #GSocketConnectable for connecting to the given
 * @uri. May fail and return %NULL in case parsing @uri fails.
 *
 * Using this rather than g_network_address_new() or
 * g_network_address_parse_host() allows #GSocketClient to determine
 * when to use application-specific proxy protocols.
 *
 * Returns: (transfer full): the new #GNetworkAddress, or %NULL on error
 * Since: 2.26
 */


/**
 * g_network_monitor_base_add_network:
 * @monitor: the #GNetworkMonitorBase
 * @network: a #GInetAddressMask
 *
 * Adds @network to @monitor's list of available networks.
 *
 * Since: 2.32
 */


/**
 * g_network_monitor_base_remove_network:
 * @monitor: the #GNetworkMonitorBase
 * @network: a #GInetAddressMask
 *
 * Removes @network from @monitor's list of available networks.
 *
 * Since: 2.32
 */


/**
 * g_network_monitor_base_set_networks:
 * @monitor: the #GNetworkMonitorBase
 * @networks: (array length=length): an array of #GInetAddressMask
 * @length: length of @networks
 *
 * Drops @monitor's current list of available networks and replaces
 * it with @networks.
 */


/**
 * g_network_monitor_can_reach:
 * @monitor: a #GNetworkMonitor
 * @connectable: a #GSocketConnectable
 * @cancellable: a #GCancellable, or %NULL
 * @error: return location for a #GError, or %NULL
 *
 * Attempts to determine whether or not the host pointed to by
 * @connectable can be reached, without actually trying to connect to
 * it.
 *
 * This may return %TRUE even when #GNetworkMonitor:network-available
 * is %FALSE, if, for example, @monitor can determine that
 * @connectable refers to a host on a local network.
 *
 * If @monitor believes that an attempt to connect to @connectable
 * will succeed, it will return %TRUE. Otherwise, it will return
 * %FALSE and set @error to an appropriate error (such as
 * %G_IO_ERROR_HOST_UNREACHABLE).
 *
 * Note that although this does not attempt to connect to
 * @connectable, it may still block for a brief period of time (eg,
 * trying to do multicast DNS on the local network), so if you do not
 * want to block, you should use g_network_monitor_can_reach_async().
 *
 * Returns: %TRUE if @connectable is reachable, %FALSE if not.
 * Since: 2.32
 */


/**
 * g_network_monitor_get_default:
 *
 * Gets the default #GNetworkMonitor for the system.
 *
 * Returns: (transfer none): a #GNetworkMonitor
 * Since: 2.32
 */


/**
 * g_network_monitor_get_network_available:
 * @monitor: the #GNetworkMonitor
 *
 * Checks if the network is available. "Available" here means that the
 * system has a default route available for at least one of IPv4 or
 * IPv6. It does not necessarily imply that the public Internet is
 * reachable. See #GNetworkMonitor:network-available for more details.
 *
 * Returns: whether the network is available
 * Since: 2.32
 */


/**
 * g_network_service_get_domain:
 * @srv: a #GNetworkService
 *
 * Gets the domain that @srv serves. This might be either UTF-8 or
 * ASCII-encoded, depending on what @srv was created with.
 *
 * Returns: @srv's domain name
 * Since: 2.22
 */


/**
 * g_network_service_get_protocol:
 * @srv: a #GNetworkService
 *
 * Gets @srv's protocol name (eg, "tcp").
 *
 * Returns: @srv's protocol name
 * Since: 2.22
 */


/**
 * g_network_service_get_scheme:
 * @srv: a #GNetworkService
 *
 * Get's the URI scheme used to resolve proxies. By default, the service name
 * is used as scheme.
 *
 * Returns: @srv's scheme name
 * Since: 2.26
 */


/**
 * g_network_service_get_service:
 * @srv: a #GNetworkService
 *
 * Gets @srv's service name (eg, "ldap").
 *
 * Returns: @srv's service name
 * Since: 2.22
 */


/**
 * g_network_service_new:
 * @service: the service type to look up (eg, "ldap")
 * @protocol: the networking protocol to use for @service (eg, "tcp")
 * @domain: the DNS domain to look up the service in
 *
 * Creates a new #GNetworkService representing the given @service,
 * @protocol, and @domain. This will initially be unresolved; use the
 * #GSocketConnectable interface to resolve it.
 *
 * Returns: (transfer full): a new #GNetworkService
 * Since: 2.22
 */


/**
 * g_network_service_set_scheme:
 * @srv: a #GNetworkService
 * @scheme: a URI scheme
 *
 * Set's the URI scheme used to resolve proxies. By default, the service name
 * is used as scheme.
 *
 * Since: 2.26
 */


/**
 * g_new:
 * @struct_type: the type of the elements to allocate
 * @n_structs: the number of elements to allocate
 *
 * Allocates @n_structs elements of type @struct_type.
 * The returned pointer is cast to a pointer to the given type.
 * If @n_structs is 0 it returns %NULL.
 * Care is taken to avoid overflow when calculating the size of the allocated block.
 *
 * Since the returned pointer is already casted to the right type,
 * it is normally unnecessary to cast it explicitly, and doing
 * so might hide memory allocation errors.
 *
 * Returns: a pointer to the allocated memory, cast to a pointer to @struct_type
 */


/**
 * g_new0:
 * @struct_type: the type of the elements to allocate.
 * @n_structs: the number of elements to allocate.
 *
 * Allocates @n_structs elements of type @struct_type, initialized to 0's.
 * The returned pointer is cast to a pointer to the given type.
 * If @n_structs is 0 it returns %NULL.
 * Care is taken to avoid overflow when calculating the size of the allocated block.
 *
 * Since the returned pointer is already casted to the right type,
 * it is normally unnecessary to cast it explicitly, and doing
 * so might hide memory allocation errors.
 *
 * Returns: a pointer to the allocated memory, cast to a pointer to @struct_type.
 */


/**
 * g_newa:
 * @struct_type: Type of memory chunks to be allocated
 * @n_structs: Number of chunks to be allocated
 *
 * Wraps g_alloca() in a more typesafe manner.
 *
 * Returns: Pointer to stack space for @n_structs chunks of type @struct_type
 */


/**
 * g_node_append:
 * @parent: the #GNode to place the new #GNode under
 * @node: the #GNode to insert
 *
 * Inserts a #GNode as the last child of the given parent.
 *
 * Returns: the inserted #GNode
 */


/**
 * g_node_append_data:
 * @parent: the #GNode to place the new #GNode under
 * @data: the data for the new #GNode
 *
 * Inserts a new #GNode as the last child of the given parent.
 *
 * Returns: the new #GNode
 */


/**
 * g_node_first_child:
 * @node: a #GNode
 *
 * Gets the first child of a #GNode.
 *
 * or has no children
 *
 * Returns: the first child of @node, or %NULL if @node is %NULL
 */


/**
 * g_node_insert_data:
 * @parent: the #GNode to place the new #GNode under
 * @position: the position to place the new #GNode at. If position is -1, the new #GNode is inserted as the last child of @parent
 * @data: the data for the new #GNode
 *
 * Inserts a new #GNode at the given position.
 *
 * Returns: the new #GNode
 */


/**
 * g_node_insert_data_before:
 * @parent: the #GNode to place the new #GNode under
 * @sibling: the sibling #GNode to place the new #GNode before
 * @data: the data for the new #GNode
 *
 * Inserts a new #GNode before the given sibling.
 *
 * Returns: the new #GNode
 */


/**
 * g_node_next_sibling:
 * @node: a #GNode
 *
 * Gets the next sibling of a #GNode.
 *
 * or %NULL
 *
 * Returns: the next sibling of @node, or %NULL if @node is the last node
 */


/**
 * g_node_prepend_data:
 * @parent: the #GNode to place the new #GNode under
 * @data: the data for the new #GNode
 *
 * Inserts a new #GNode as the first child of the given parent.
 *
 * Returns: the new #GNode
 */


/**
 * g_node_prev_sibling:
 * @node: a #GNode
 *
 * Gets the previous sibling of a #GNode.
 *
 * node or %NULL
 *
 * Returns: the previous sibling of @node, or %NULL if @node is the first
 */


/**
 * g_null_settings_backend_new:
 *
 * Creates a readonly #GSettingsBackend.
 *
 * This backend does not allow changes to settings, so all settings
 * will always have their default values.
 *
 * Returns: (transfer full): a newly created #GSettingsBackend
 * Since: 2.28
 */


/**
 * g_output_stream_clear_pending:
 * @stream: output stream
 *
 * Clears the pending flag on @stream.
 */


/**
 * g_output_stream_close:
 * @stream: A #GOutputStream.
 * @cancellable: (allow-none): optional cancellable object
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Closes the stream, releasing resources related to it.
 *
 * Once the stream is closed, all other operations will return %G_IO_ERROR_CLOSED.
 * Closing a stream multiple times will not return an error.
 *
 * Closing a stream will automatically flush any outstanding buffers in the
 * stream.
 *
 * Streams will be automatically closed when the last reference
 * is dropped, but you might want to call this function to make sure
 * resources are released as early as possible.
 *
 * Some streams might keep the backing store of the stream (e.g. a file descriptor)
 * open after the stream is closed. See the documentation for the individual
 * stream for details.
 *
 * On failure the first error that happened will be reported, but the close
 * operation will finish as much as possible. A stream that failed to
 * close will still return %G_IO_ERROR_CLOSED for all operations. Still, it
 * is important to check and report the error to the user, otherwise
 * there might be a loss of data as all data might not be written.
 *
 * If @cancellable is not NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 * Cancelling a close will still leave the stream closed, but there some streams
 * can use a faster close that doesn't block to e.g. check errors. On
 * cancellation (as with any error) there is no guarantee that all written
 * data will reach the target.
 *
 * Returns: %TRUE on success, %FALSE on failure
 */


/**
 * g_output_stream_close_async:
 * @stream: A #GOutputStream.
 * @io_priority: the io priority of the request.
 * @cancellable: (allow-none): optional cancellable object
 * @callback: (scope async): callback to call when the request is satisfied
 * @user_data: (closure): the data to pass to callback function
 *
 * Requests an asynchronous close of the stream, releasing resources
 * related to it. When the operation is finished @callback will be
 * called. You can then call g_output_stream_close_finish() to get
 * the result of the operation.
 *
 * For behaviour details see g_output_stream_close().
 *
 * The asyncronous methods have a default fallback that uses threads
 * to implement asynchronicity, so they are optional for inheriting
 * classes. However, if you override one you must override all.
 */


/**
 * g_output_stream_close_finish:
 * @stream: a #GOutputStream.
 * @result: a #GAsyncResult.
 * @error: a #GError location to store the error occurring, or %NULL to ignore.
 *
 * Closes an output stream.
 *
 * Returns: %TRUE if stream was successfully closed, %FALSE otherwise.
 */


/**
 * g_output_stream_flush:
 * @stream: a #GOutputStream.
 * @cancellable: (allow-none): optional cancellable object
 * @error: location to store the error occurring, or %NULL to ignore
 *
 * Forces a write of all user-space buffered data for the given
 * @stream. Will block during the operation. Closing the stream will
 * implicitly cause a flush.
 *
 * This function is optional for inherited classes.
 *
 * If @cancellable is not %NULL, then the operation can be cancelled by
 * triggering the cancellable object from another thread. If the operation
 * was cancelled, the error %G_IO_ERROR_CANCELLED will be returned.
 *
 * Returns: %TRUE on success, %FALSE on error
 */


/**
 * g_output_stream_flush_async:
 * @st