/* vi:set ts=8 sts=0 sw=8:
 * $Id: win.h,v 1.19 1999/01/18 20:08:51 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __WIN_H__
#define __WIN_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <glib.h>
#include <gtk/gtk.h>
#include "main.h"

/* search and replace options */
#define REPLACE			0x00000001
#define	CASE_SENSITIVE		0x00000002
#define	PROMPT_REPLACE		0x00000004
#define	REPLACE_ALL		0x00000008
#define	REGULAR_EXPR		0x00000010

#define DO_REPLACE(w)		(w->soptions & REPLACE)
#define DO_CASE_SENSITIVE(w)	(w->soptions & CASE_SENSITIVE)
#define DO_PROMPT_REPLACE(w)	(w->soptions & PROMPT_REPLACE)
#define DO_REPLACE_ALL(w)	(w->soptions & REPLACE_ALL)
#define DO_REGULAR_EXPR(w)	(w->soptions & REGULAR_EXPR)

#define SET_REPLACE(w)		(w->soptions |= REPLACE)
#define SET_CASE_SENSITIVE(w)	(w->soptions |= CASE_SENSITIVE)
#define SET_PROMPT_REPLACE(w)	(w->soptions |= PROMPT_REPLACE)
#define SET_REPLACE_ALL(w)	(w->soptions |= REPLACE_ALL)
#define SET_REGULAR_EXPR(w)	(w->soptions |= REGULAR_EXPR)

#define CLEAR_REPLACE(w)	(w->soptions &= ~REPLACE)
#define CLEAR_CASE_SENSITIVE(w)	(w->soptions &= ~CASE_SENSITIVE)
#define CLEAR_PROMPT_REPLACE(w)	(w->soptions &= ~PROMPT_REPLACE)
#define CLEAR_REPLACE_ALL(w)	(w->soptions &= ~REPLACE_ALL)
#define CLEAR_REGULAR_EXPR(w)	(w->soptions &= ~REGULAR_EXPR)


#define MSGBAR_CLEAR	" "


/* the main window */
typedef struct {
	unsigned	id;		/* window id */
	unsigned	rownum;		/* row # in window list popup */
	GtkWidget *	toplev;		/* top-level window */
	GtkWidget *	mainbox;	/* main box to hold all widgets */
	GtkWidget *	menubar;	/* menus */
	GtkWidget *	menubar_h;	/* menubar handle for floating menus */
#if defined(WANT_PROJECT) && defined(APP_GNP)
	GtkWidget *	prjbar;		/* project status bar */
#endif	/* WANT_PROJECT */
	GtkWidget *	main_tb;	/* toolbar */
	GtkWidget *	main_tb_h;	/* toolbar handle */
#ifdef APP_GNP
	GtkWidget *	html_tb;	/* html toolbar */
	GtkWidget *	html_tb_h;	/* html toolbar handle */
#endif	/* APP_GNP */
	GtkWidget *	nb;		/* notebook which contains docs */
	GtkWidget *	hbox_bot;	/* holds msgbar and docinfo button */
	GtkWidget *	msgbar;		/* message bar */
	GtkWidget *	docinfo;	/* docinfo button */
	GtkWidget *	docinfo_label;	/* docinfo label  */
	char *		lastmsg;	/* last message shown */
	int		timeout_id;	/* msgbar timeout id */
	GtkWidget *	quickmenu;	/* popup menu on right mouse click */

	/* document related info.  note that we alreays track the current
	   document in curdoc whenever a doc is opened/closed.  this is to
	   avoid constantly traversing the doclist */
	GSList *	doclist;	/* doc_t list */
	gpointer	curdoc;		/* ptr to doclist->data (doc_t *) */
	guint		numdoc;		/* number of docs */
#ifdef APP_GNP
	bool_t		allclosed;	/* indicate all docs were closed */
#endif	/* APP_GNP */
	GSList *	recentlist;	/* this window's recent doc list */

	/* file selection dialog boxes; one per window */
#ifdef APP_GNP
	GtkWidget *	saveas;		/* save-as file selector */
#endif	/* APP_GNP */
	GtkWidget *	filesel;	/* open file selector */

	/* the following are used for the doc list popup window */
	GtkWidget *	dlw;		/* doc list window */
	GtkWidget *	dlw_data;	/* doc list window data */
	GtkWidget *	dlw_tb;		/* doc list window toolbar */
	GtkWidget *	dlw_tb_h;	/* doc list window toolbar handle */

#if defined(WANT_PROJECT) && defined(APP_GNP)
	/* project information */
	void *		prj;
#endif	/* WANT_PROJECT */

	/* search and replace information */
	GtkWidget *	search;		/* top level dialog widget */
	GtkWidget *	stxt_wgt;	/* search text entry widget */
	GtkWidget *	rtxt_wgt;	/* replace text entry widget */
	GtkWidget *	startcur;	/* start at cur pos radio button */
	GtkWidget *	startbeg;	/* start at doc beginning radio btn */
	GtkWidget *	casesens;	/* case-sensitive toggle button */
#ifdef NOTYET
	GtkWidget *	regexp;		/* regular expr toggle button */
#endif
	char *          stxt;		/* search text for 'search again' */
	char *          rtxt;		/* replace text */
	long		soptions;	/* search options */
} win_t;


extern int	win_autosave(gpointer cbdata);
extern void	win_close_all_cb(GtkWidget *wgt, gpointer cbdata);
extern void	win_close_cb(GtkWidget *wgt, gpointer cbdata);
extern void	win_doc_foreach(void (*func)(void *));
extern void	win_foreach(void (*func)(void *));
extern void	win_list_show(GtkWidget *wgt, gpointer cbdata);
extern win_t *	win_new(void);
extern void	win_new_with_doc(GtkWidget *wgt, gpointer cbdata);
extern void	win_dtab_toggle(GtkWidget *wgt, gpointer cbdata);
extern void	win_dtab_top(GtkWidget *wgt, gpointer cbdata);
extern void	win_dtab_bot(GtkWidget *wgt, gpointer cbdata);
extern void	win_dtab_left(GtkWidget *wgt, gpointer cbdata);
extern void	win_dtab_right(GtkWidget *wgt, gpointer cbdata);
extern void	win_list_set_curdoc(win_t *w);
extern void	win_list_set_numdoc(win_t *w);
extern void	win_redraw_doc_tab(void *);
#ifdef APP_GNP
extern void	win_wwrap_toggle(GtkWidget *wgt, gpointer cbdata);
#endif	/* APP_GNP */
extern void	win_doc_reset_style(gpointer data);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __WIN_H__ */
