// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::ColorScheme;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "HdyStyleManager")]
    pub struct StyleManager(Object<ffi::HdyStyleManager, ffi::HdyStyleManagerClass>);

    match fn {
        type_ => || ffi::hdy_style_manager_get_type(),
    }
}

impl StyleManager {
    #[doc(alias = "hdy_style_manager_get_color_scheme")]
    #[doc(alias = "get_color_scheme")]
    pub fn color_scheme(&self) -> ColorScheme {
        unsafe {
            from_glib(ffi::hdy_style_manager_get_color_scheme(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_style_manager_get_dark")]
    #[doc(alias = "get_dark")]
    pub fn is_dark(&self) -> bool {
        unsafe { from_glib(ffi::hdy_style_manager_get_dark(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_style_manager_get_display")]
    #[doc(alias = "get_display")]
    pub fn display(&self) -> Option<gdk::Display> {
        unsafe { from_glib_none(ffi::hdy_style_manager_get_display(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_style_manager_get_high_contrast")]
    #[doc(alias = "get_high_contrast")]
    pub fn is_high_contrast(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_style_manager_get_high_contrast(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_style_manager_get_system_supports_color_schemes")]
    #[doc(alias = "get_system_supports_color_schemes")]
    pub fn system_supports_color_schemes(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_style_manager_get_system_supports_color_schemes(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_style_manager_set_color_scheme")]
    pub fn set_color_scheme(&self, color_scheme: ColorScheme) {
        unsafe {
            ffi::hdy_style_manager_set_color_scheme(
                self.to_glib_none().0,
                color_scheme.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_style_manager_get_default")]
    #[doc(alias = "get_default")]
    pub fn default() -> Option<StyleManager> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::hdy_style_manager_get_default()) }
    }

    #[doc(alias = "hdy_style_manager_get_for_display")]
    #[doc(alias = "get_for_display")]
    pub fn for_display(display: &gdk::Display) -> Option<StyleManager> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::hdy_style_manager_get_for_display(
                display.to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_6")))]
    #[doc(alias = "color-scheme")]
    pub fn connect_color_scheme_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_color_scheme_trampoline<F: Fn(&StyleManager) + 'static>(
            this: *mut ffi::HdyStyleManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::color-scheme\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_color_scheme_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_6")))]
    #[doc(alias = "dark")]
    pub fn connect_dark_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_dark_trampoline<F: Fn(&StyleManager) + 'static>(
            this: *mut ffi::HdyStyleManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::dark\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_dark_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_6")))]
    #[doc(alias = "high-contrast")]
    pub fn connect_high_contrast_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_high_contrast_trampoline<F: Fn(&StyleManager) + 'static>(
            this: *mut ffi::HdyStyleManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::high-contrast\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_high_contrast_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_6")))]
    #[doc(alias = "system-supports-color-schemes")]
    pub fn connect_system_supports_color_schemes_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_system_supports_color_schemes_trampoline<
            F: Fn(&StyleManager) + 'static,
        >(
            this: *mut ffi::HdyStyleManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::system-supports-color-schemes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_system_supports_color_schemes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for StyleManager {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("StyleManager")
    }
}
