// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Swipeable;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "HdyCarousel")]
    pub struct Carousel(Object<ffi::HdyCarousel, ffi::HdyCarouselClass>) @extends gtk::EventBox, gtk::Bin, gtk::Container, gtk::Widget, @implements gtk::Buildable, gtk::Orientable, Swipeable;

    match fn {
        type_ => || ffi::hdy_carousel_get_type(),
    }
}

impl Carousel {
    #[doc(alias = "hdy_carousel_new")]
    pub fn new() -> Carousel {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::hdy_carousel_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Carousel`] objects.
    ///
    /// This method returns an instance of [`CarouselBuilder`](crate::builders::CarouselBuilder) which can be used to create [`Carousel`] objects.
    pub fn builder() -> CarouselBuilder {
        CarouselBuilder::default()
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "hdy_carousel_get_allow_long_swipes")]
    #[doc(alias = "get_allow_long_swipes")]
    pub fn allows_long_swipes(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_carousel_get_allow_long_swipes(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_carousel_get_allow_mouse_drag")]
    #[doc(alias = "get_allow_mouse_drag")]
    pub fn allows_mouse_drag(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_carousel_get_allow_mouse_drag(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "hdy_carousel_get_allow_scroll_wheel")]
    #[doc(alias = "get_allow_scroll_wheel")]
    pub fn allows_scroll_wheel(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_carousel_get_allow_scroll_wheel(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_carousel_get_animation_duration")]
    #[doc(alias = "get_animation_duration")]
    pub fn animation_duration(&self) -> u32 {
        unsafe { ffi::hdy_carousel_get_animation_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "hdy_carousel_get_interactive")]
    #[doc(alias = "get_interactive")]
    pub fn is_interactive(&self) -> bool {
        unsafe { from_glib(ffi::hdy_carousel_get_interactive(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_carousel_get_n_pages")]
    #[doc(alias = "get_n_pages")]
    pub fn n_pages(&self) -> u32 {
        unsafe { ffi::hdy_carousel_get_n_pages(self.to_glib_none().0) }
    }

    #[doc(alias = "hdy_carousel_get_position")]
    #[doc(alias = "get_position")]
    pub fn position(&self) -> f64 {
        unsafe { ffi::hdy_carousel_get_position(self.to_glib_none().0) }
    }

    #[doc(alias = "hdy_carousel_get_reveal_duration")]
    #[doc(alias = "get_reveal_duration")]
    pub fn reveal_duration(&self) -> u32 {
        unsafe { ffi::hdy_carousel_get_reveal_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "hdy_carousel_get_spacing")]
    #[doc(alias = "get_spacing")]
    pub fn spacing(&self) -> u32 {
        unsafe { ffi::hdy_carousel_get_spacing(self.to_glib_none().0) }
    }

    #[doc(alias = "hdy_carousel_insert")]
    pub fn insert(&self, child: &impl IsA<gtk::Widget>, position: i32) {
        unsafe {
            ffi::hdy_carousel_insert(
                self.to_glib_none().0,
                child.as_ref().to_glib_none().0,
                position,
            );
        }
    }

    #[doc(alias = "hdy_carousel_prepend")]
    pub fn prepend(&self, child: &impl IsA<gtk::Widget>) {
        unsafe {
            ffi::hdy_carousel_prepend(self.to_glib_none().0, child.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "hdy_carousel_reorder")]
    pub fn reorder(&self, child: &impl IsA<gtk::Widget>, position: i32) {
        unsafe {
            ffi::hdy_carousel_reorder(
                self.to_glib_none().0,
                child.as_ref().to_glib_none().0,
                position,
            );
        }
    }

    #[doc(alias = "hdy_carousel_scroll_to")]
    pub fn scroll_to(&self, widget: &impl IsA<gtk::Widget>) {
        unsafe {
            ffi::hdy_carousel_scroll_to(self.to_glib_none().0, widget.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "hdy_carousel_scroll_to_full")]
    pub fn scroll_to_full(&self, widget: &impl IsA<gtk::Widget>, duration: i64) {
        unsafe {
            ffi::hdy_carousel_scroll_to_full(
                self.to_glib_none().0,
                widget.as_ref().to_glib_none().0,
                duration,
            );
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "hdy_carousel_set_allow_long_swipes")]
    pub fn set_allow_long_swipes(&self, allow_long_swipes: bool) {
        unsafe {
            ffi::hdy_carousel_set_allow_long_swipes(
                self.to_glib_none().0,
                allow_long_swipes.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_carousel_set_allow_mouse_drag")]
    pub fn set_allow_mouse_drag(&self, allow_mouse_drag: bool) {
        unsafe {
            ffi::hdy_carousel_set_allow_mouse_drag(
                self.to_glib_none().0,
                allow_mouse_drag.into_glib(),
            );
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "hdy_carousel_set_allow_scroll_wheel")]
    pub fn set_allow_scroll_wheel(&self, allow_scroll_wheel: bool) {
        unsafe {
            ffi::hdy_carousel_set_allow_scroll_wheel(
                self.to_glib_none().0,
                allow_scroll_wheel.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_carousel_set_animation_duration")]
    pub fn set_animation_duration(&self, duration: u32) {
        unsafe {
            ffi::hdy_carousel_set_animation_duration(self.to_glib_none().0, duration);
        }
    }

    #[doc(alias = "hdy_carousel_set_interactive")]
    pub fn set_interactive(&self, interactive: bool) {
        unsafe {
            ffi::hdy_carousel_set_interactive(self.to_glib_none().0, interactive.into_glib());
        }
    }

    #[doc(alias = "hdy_carousel_set_reveal_duration")]
    pub fn set_reveal_duration(&self, reveal_duration: u32) {
        unsafe {
            ffi::hdy_carousel_set_reveal_duration(self.to_glib_none().0, reveal_duration);
        }
    }

    #[doc(alias = "hdy_carousel_set_spacing")]
    pub fn set_spacing(&self, spacing: u32) {
        unsafe {
            ffi::hdy_carousel_set_spacing(self.to_glib_none().0, spacing);
        }
    }

    #[doc(alias = "page-changed")]
    pub fn connect_page_changed<F: Fn(&Self, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn page_changed_trampoline<F: Fn(&Carousel, u32) + 'static>(
            this: *mut ffi::HdyCarousel,
            index: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), index)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"page-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    page_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "allow-long-swipes")]
    pub fn connect_allow_long_swipes_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_long_swipes_trampoline<F: Fn(&Carousel) + 'static>(
            this: *mut ffi::HdyCarousel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-long-swipes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_allow_long_swipes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "allow-mouse-drag")]
    pub fn connect_allow_mouse_drag_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_mouse_drag_trampoline<F: Fn(&Carousel) + 'static>(
            this: *mut ffi::HdyCarousel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-mouse-drag\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_allow_mouse_drag_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "allow-scroll-wheel")]
    pub fn connect_allow_scroll_wheel_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_allow_scroll_wheel_trampoline<F: Fn(&Carousel) + 'static>(
            this: *mut ffi::HdyCarousel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::allow-scroll-wheel\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_allow_scroll_wheel_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "animation-duration")]
    pub fn connect_animation_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_animation_duration_trampoline<F: Fn(&Carousel) + 'static>(
            this: *mut ffi::HdyCarousel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::animation-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_animation_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "interactive")]
    pub fn connect_interactive_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_interactive_trampoline<F: Fn(&Carousel) + 'static>(
            this: *mut ffi::HdyCarousel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::interactive\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_interactive_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "n-pages")]
    pub fn connect_n_pages_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_n_pages_trampoline<F: Fn(&Carousel) + 'static>(
            this: *mut ffi::HdyCarousel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::n-pages\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_n_pages_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "position")]
    pub fn connect_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_position_trampoline<F: Fn(&Carousel) + 'static>(
            this: *mut ffi::HdyCarousel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::position\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_position_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reveal-duration")]
    pub fn connect_reveal_duration_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reveal_duration_trampoline<F: Fn(&Carousel) + 'static>(
            this: *mut ffi::HdyCarousel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reveal-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reveal_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "spacing")]
    pub fn connect_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spacing_trampoline<F: Fn(&Carousel) + 'static>(
            this: *mut ffi::HdyCarousel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_spacing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Carousel {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Carousel`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CarouselBuilder {
    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    allow_long_swipes: Option<bool>,
    allow_mouse_drag: Option<bool>,
    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    allow_scroll_wheel: Option<bool>,
    animation_duration: Option<u32>,
    interactive: Option<bool>,
    reveal_duration: Option<u32>,
    spacing: Option<u32>,
    above_child: Option<bool>,
    visible_window: Option<bool>,
    border_width: Option<u32>,
    child: Option<gtk::Widget>,
    resize_mode: Option<gtk::ResizeMode>,
    app_paintable: Option<bool>,
    can_default: Option<bool>,
    can_focus: Option<bool>,
    events: Option<gdk::EventMask>,
    expand: Option<bool>,
    focus_on_click: Option<bool>,
    halign: Option<gtk::Align>,
    has_default: Option<bool>,
    has_focus: Option<bool>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    is_focus: Option<bool>,
    margin: Option<i32>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    no_show_all: Option<bool>,
    opacity: Option<f64>,
    parent: Option<gtk::Container>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    //style: /*Unknown type*/,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<gtk::Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    orientation: Option<gtk::Orientation>,
}

impl CarouselBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`CarouselBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Carousel`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Carousel {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        #[cfg(any(feature = "v1_2", feature = "dox"))]
        if let Some(ref allow_long_swipes) = self.allow_long_swipes {
            properties.push(("allow-long-swipes", allow_long_swipes));
        }
        if let Some(ref allow_mouse_drag) = self.allow_mouse_drag {
            properties.push(("allow-mouse-drag", allow_mouse_drag));
        }
        #[cfg(any(feature = "v1_4", feature = "dox"))]
        if let Some(ref allow_scroll_wheel) = self.allow_scroll_wheel {
            properties.push(("allow-scroll-wheel", allow_scroll_wheel));
        }
        if let Some(ref animation_duration) = self.animation_duration {
            properties.push(("animation-duration", animation_duration));
        }
        if let Some(ref interactive) = self.interactive {
            properties.push(("interactive", interactive));
        }
        if let Some(ref reveal_duration) = self.reveal_duration {
            properties.push(("reveal-duration", reveal_duration));
        }
        if let Some(ref spacing) = self.spacing {
            properties.push(("spacing", spacing));
        }
        if let Some(ref above_child) = self.above_child {
            properties.push(("above-child", above_child));
        }
        if let Some(ref visible_window) = self.visible_window {
            properties.push(("visible-window", visible_window));
        }
        if let Some(ref border_width) = self.border_width {
            properties.push(("border-width", border_width));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref resize_mode) = self.resize_mode {
            properties.push(("resize-mode", resize_mode));
        }
        if let Some(ref app_paintable) = self.app_paintable {
            properties.push(("app-paintable", app_paintable));
        }
        if let Some(ref can_default) = self.can_default {
            properties.push(("can-default", can_default));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref events) = self.events {
            properties.push(("events", events));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_default) = self.has_default {
            properties.push(("has-default", has_default));
        }
        if let Some(ref has_focus) = self.has_focus {
            properties.push(("has-focus", has_focus));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref is_focus) = self.is_focus {
            properties.push(("is-focus", is_focus));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref no_show_all) = self.no_show_all {
            properties.push(("no-show-all", no_show_all));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref orientation) = self.orientation {
            properties.push(("orientation", orientation));
        }
        glib::Object::new::<Carousel>(&properties)
            .expect("Failed to create an instance of Carousel")
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    pub fn allow_long_swipes(mut self, allow_long_swipes: bool) -> Self {
        self.allow_long_swipes = Some(allow_long_swipes);
        self
    }

    pub fn allow_mouse_drag(mut self, allow_mouse_drag: bool) -> Self {
        self.allow_mouse_drag = Some(allow_mouse_drag);
        self
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    pub fn allow_scroll_wheel(mut self, allow_scroll_wheel: bool) -> Self {
        self.allow_scroll_wheel = Some(allow_scroll_wheel);
        self
    }

    pub fn animation_duration(mut self, animation_duration: u32) -> Self {
        self.animation_duration = Some(animation_duration);
        self
    }

    pub fn interactive(mut self, interactive: bool) -> Self {
        self.interactive = Some(interactive);
        self
    }

    pub fn reveal_duration(mut self, reveal_duration: u32) -> Self {
        self.reveal_duration = Some(reveal_duration);
        self
    }

    pub fn spacing(mut self, spacing: u32) -> Self {
        self.spacing = Some(spacing);
        self
    }

    pub fn above_child(mut self, above_child: bool) -> Self {
        self.above_child = Some(above_child);
        self
    }

    pub fn visible_window(mut self, visible_window: bool) -> Self {
        self.visible_window = Some(visible_window);
        self
    }

    pub fn border_width(mut self, border_width: u32) -> Self {
        self.border_width = Some(border_width);
        self
    }

    pub fn child(mut self, child: &impl IsA<gtk::Widget>) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn resize_mode(mut self, resize_mode: gtk::ResizeMode) -> Self {
        self.resize_mode = Some(resize_mode);
        self
    }

    pub fn app_paintable(mut self, app_paintable: bool) -> Self {
        self.app_paintable = Some(app_paintable);
        self
    }

    pub fn can_default(mut self, can_default: bool) -> Self {
        self.can_default = Some(can_default);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn events(mut self, events: gdk::EventMask) -> Self {
        self.events = Some(events);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn halign(mut self, halign: gtk::Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_default(mut self, has_default: bool) -> Self {
        self.has_default = Some(has_default);
        self
    }

    pub fn has_focus(mut self, has_focus: bool) -> Self {
        self.has_focus = Some(has_focus);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn is_focus(mut self, is_focus: bool) -> Self {
        self.is_focus = Some(is_focus);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn no_show_all(mut self, no_show_all: bool) -> Self {
        self.no_show_all = Some(no_show_all);
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn parent(mut self, parent: &impl IsA<gtk::Container>) -> Self {
        self.parent = Some(parent.clone().upcast());
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: gtk::Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn orientation(mut self, orientation: gtk::Orientation) -> Self {
        self.orientation = Some(orientation);
        self
    }
}

impl fmt::Display for Carousel {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Carousel")
    }
}
