// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::EventController;
use crate::PadActionType;
use crate::PropagationPhase;
use crate::Widget;
use crate::Window;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GtkPadController")]
    pub struct PadController(Object<ffi::GtkPadController, ffi::GtkPadControllerClass>) @extends EventController;

    match fn {
        type_ => || ffi::gtk_pad_controller_get_type(),
    }
}

impl PadController {
    #[doc(alias = "gtk_pad_controller_new")]
    pub fn new(
        window: &impl IsA<Window>,
        group: &impl IsA<gio::ActionGroup>,
        pad: Option<&gdk::Device>,
    ) -> PadController {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gtk_pad_controller_new(
                window.as_ref().to_glib_none().0,
                group.as_ref().to_glib_none().0,
                pad.to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`PadController`] objects.
    ///
    /// This method returns an instance of [`PadControllerBuilder`](crate::builders::PadControllerBuilder) which can be used to create [`PadController`] objects.
    pub fn builder() -> PadControllerBuilder {
        PadControllerBuilder::default()
    }

    #[doc(alias = "gtk_pad_controller_set_action")]
    pub fn set_action(
        &self,
        type_: PadActionType,
        index: i32,
        mode: i32,
        label: &str,
        action_name: &str,
    ) {
        unsafe {
            ffi::gtk_pad_controller_set_action(
                self.to_glib_none().0,
                type_.into_glib(),
                index,
                mode,
                label.to_glib_none().0,
                action_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "action-group")]
    pub fn action_group(&self) -> Option<gio::ActionGroup> {
        glib::ObjectExt::property(self, "action-group")
    }

    pub fn pad(&self) -> Option<gdk::Device> {
        glib::ObjectExt::property(self, "pad")
    }
}

#[cfg(any(feature = "v3_22", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_22")))]
impl Default for PadController {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct PadController object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`PadController`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct PadControllerBuilder {
    action_group: Option<gio::ActionGroup>,
    pad: Option<gdk::Device>,
    propagation_phase: Option<PropagationPhase>,
    widget: Option<Widget>,
}

impl PadControllerBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`PadControllerBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`PadController`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> PadController {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref action_group) = self.action_group {
            properties.push(("action-group", action_group));
        }
        if let Some(ref pad) = self.pad {
            properties.push(("pad", pad));
        }
        if let Some(ref propagation_phase) = self.propagation_phase {
            properties.push(("propagation-phase", propagation_phase));
        }
        if let Some(ref widget) = self.widget {
            properties.push(("widget", widget));
        }
        glib::Object::new::<PadController>(&properties)
            .expect("Failed to create an instance of PadController")
    }

    pub fn action_group(mut self, action_group: &impl IsA<gio::ActionGroup>) -> Self {
        self.action_group = Some(action_group.clone().upcast());
        self
    }

    pub fn pad(mut self, pad: &gdk::Device) -> Self {
        self.pad = Some(pad.clone());
        self
    }

    pub fn propagation_phase(mut self, propagation_phase: PropagationPhase) -> Self {
        self.propagation_phase = Some(propagation_phase);
        self
    }

    pub fn widget(mut self, widget: &impl IsA<Widget>) -> Self {
        self.widget = Some(widget.clone().upcast());
        self
    }
}

impl fmt::Display for PadController {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("PadController")
    }
}
