// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::IconInfo;
use crate::IconLookupFlags;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GtkIconTheme")]
    pub struct IconTheme(Object<ffi::GtkIconTheme, ffi::GtkIconThemeClass>);

    match fn {
        type_ => || ffi::gtk_icon_theme_get_type(),
    }
}

impl IconTheme {
    pub const NONE: Option<&'static IconTheme> = None;

    #[doc(alias = "gtk_icon_theme_new")]
    pub fn new() -> IconTheme {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_icon_theme_new()) }
    }

    #[doc(alias = "gtk_icon_theme_get_default")]
    #[doc(alias = "get_default")]
    pub fn default() -> Option<IconTheme> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_icon_theme_get_default()) }
    }

    #[doc(alias = "gtk_icon_theme_get_for_screen")]
    #[doc(alias = "get_for_screen")]
    pub fn for_screen(screen: &gdk::Screen) -> Option<IconTheme> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_icon_theme_get_for_screen(screen.to_glib_none().0)) }
    }
}

impl Default for IconTheme {
    fn default() -> Self {
        Self::new()
    }
}

pub trait IconThemeExt: 'static {
    #[doc(alias = "gtk_icon_theme_add_resource_path")]
    fn add_resource_path(&self, path: &str);

    #[doc(alias = "gtk_icon_theme_append_search_path")]
    fn append_search_path(&self, path: impl AsRef<std::path::Path>);

    #[doc(alias = "gtk_icon_theme_get_example_icon_name")]
    #[doc(alias = "get_example_icon_name")]
    fn example_icon_name(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_icon_theme_has_icon")]
    fn has_icon(&self, icon_name: &str) -> bool;

    #[doc(alias = "gtk_icon_theme_list_contexts")]
    fn list_contexts(&self) -> Vec<glib::GString>;

    #[doc(alias = "gtk_icon_theme_list_icons")]
    fn list_icons(&self, context: Option<&str>) -> Vec<glib::GString>;

    #[doc(alias = "gtk_icon_theme_load_icon")]
    fn load_icon(
        &self,
        icon_name: &str,
        size: i32,
        flags: IconLookupFlags,
    ) -> Result<Option<gdk_pixbuf::Pixbuf>, glib::Error>;

    #[doc(alias = "gtk_icon_theme_load_icon_for_scale")]
    fn load_icon_for_scale(
        &self,
        icon_name: &str,
        size: i32,
        scale: i32,
        flags: IconLookupFlags,
    ) -> Result<Option<gdk_pixbuf::Pixbuf>, glib::Error>;

    #[doc(alias = "gtk_icon_theme_load_surface")]
    fn load_surface(
        &self,
        icon_name: &str,
        size: i32,
        scale: i32,
        for_window: Option<&gdk::Window>,
        flags: IconLookupFlags,
    ) -> Result<Option<cairo::Surface>, glib::Error>;

    #[doc(alias = "gtk_icon_theme_lookup_by_gicon")]
    fn lookup_by_gicon(
        &self,
        icon: &impl IsA<gio::Icon>,
        size: i32,
        flags: IconLookupFlags,
    ) -> Option<IconInfo>;

    #[doc(alias = "gtk_icon_theme_lookup_by_gicon_for_scale")]
    fn lookup_by_gicon_for_scale(
        &self,
        icon: &impl IsA<gio::Icon>,
        size: i32,
        scale: i32,
        flags: IconLookupFlags,
    ) -> Option<IconInfo>;

    #[doc(alias = "gtk_icon_theme_lookup_icon")]
    fn lookup_icon(&self, icon_name: &str, size: i32, flags: IconLookupFlags) -> Option<IconInfo>;

    #[doc(alias = "gtk_icon_theme_lookup_icon_for_scale")]
    fn lookup_icon_for_scale(
        &self,
        icon_name: &str,
        size: i32,
        scale: i32,
        flags: IconLookupFlags,
    ) -> Option<IconInfo>;

    #[doc(alias = "gtk_icon_theme_prepend_search_path")]
    fn prepend_search_path(&self, path: impl AsRef<std::path::Path>);

    #[doc(alias = "gtk_icon_theme_rescan_if_needed")]
    fn rescan_if_needed(&self) -> bool;

    #[doc(alias = "gtk_icon_theme_set_custom_theme")]
    fn set_custom_theme(&self, theme_name: Option<&str>);

    #[doc(alias = "gtk_icon_theme_set_screen")]
    fn set_screen(&self, screen: &gdk::Screen);

    #[doc(alias = "changed")]
    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<IconTheme>> IconThemeExt for O {
    fn add_resource_path(&self, path: &str) {
        unsafe {
            ffi::gtk_icon_theme_add_resource_path(
                self.as_ref().to_glib_none().0,
                path.to_glib_none().0,
            );
        }
    }

    fn append_search_path(&self, path: impl AsRef<std::path::Path>) {
        unsafe {
            ffi::gtk_icon_theme_append_search_path(
                self.as_ref().to_glib_none().0,
                path.as_ref().to_glib_none().0,
            );
        }
    }

    fn example_icon_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_icon_theme_get_example_icon_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn has_icon(&self, icon_name: &str) -> bool {
        unsafe {
            from_glib(ffi::gtk_icon_theme_has_icon(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
            ))
        }
    }

    fn list_contexts(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_icon_theme_list_contexts(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn list_icons(&self, context: Option<&str>) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_icon_theme_list_icons(
                self.as_ref().to_glib_none().0,
                context.to_glib_none().0,
            ))
        }
    }

    fn load_icon(
        &self,
        icon_name: &str,
        size: i32,
        flags: IconLookupFlags,
    ) -> Result<Option<gdk_pixbuf::Pixbuf>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::gtk_icon_theme_load_icon(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
                size,
                flags.into_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn load_icon_for_scale(
        &self,
        icon_name: &str,
        size: i32,
        scale: i32,
        flags: IconLookupFlags,
    ) -> Result<Option<gdk_pixbuf::Pixbuf>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::gtk_icon_theme_load_icon_for_scale(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
                size,
                scale,
                flags.into_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn load_surface(
        &self,
        icon_name: &str,
        size: i32,
        scale: i32,
        for_window: Option<&gdk::Window>,
        flags: IconLookupFlags,
    ) -> Result<Option<cairo::Surface>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::gtk_icon_theme_load_surface(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
                size,
                scale,
                for_window.to_glib_none().0,
                flags.into_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn lookup_by_gicon(
        &self,
        icon: &impl IsA<gio::Icon>,
        size: i32,
        flags: IconLookupFlags,
    ) -> Option<IconInfo> {
        unsafe {
            from_glib_full(ffi::gtk_icon_theme_lookup_by_gicon(
                self.as_ref().to_glib_none().0,
                icon.as_ref().to_glib_none().0,
                size,
                flags.into_glib(),
            ))
        }
    }

    fn lookup_by_gicon_for_scale(
        &self,
        icon: &impl IsA<gio::Icon>,
        size: i32,
        scale: i32,
        flags: IconLookupFlags,
    ) -> Option<IconInfo> {
        unsafe {
            from_glib_full(ffi::gtk_icon_theme_lookup_by_gicon_for_scale(
                self.as_ref().to_glib_none().0,
                icon.as_ref().to_glib_none().0,
                size,
                scale,
                flags.into_glib(),
            ))
        }
    }

    fn lookup_icon(&self, icon_name: &str, size: i32, flags: IconLookupFlags) -> Option<IconInfo> {
        unsafe {
            from_glib_full(ffi::gtk_icon_theme_lookup_icon(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
                size,
                flags.into_glib(),
            ))
        }
    }

    fn lookup_icon_for_scale(
        &self,
        icon_name: &str,
        size: i32,
        scale: i32,
        flags: IconLookupFlags,
    ) -> Option<IconInfo> {
        unsafe {
            from_glib_full(ffi::gtk_icon_theme_lookup_icon_for_scale(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
                size,
                scale,
                flags.into_glib(),
            ))
        }
    }

    fn prepend_search_path(&self, path: impl AsRef<std::path::Path>) {
        unsafe {
            ffi::gtk_icon_theme_prepend_search_path(
                self.as_ref().to_glib_none().0,
                path.as_ref().to_glib_none().0,
            );
        }
    }

    fn rescan_if_needed(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_icon_theme_rescan_if_needed(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_custom_theme(&self, theme_name: Option<&str>) {
        unsafe {
            ffi::gtk_icon_theme_set_custom_theme(
                self.as_ref().to_glib_none().0,
                theme_name.to_glib_none().0,
            );
        }
    }

    fn set_screen(&self, screen: &gdk::Screen) {
        unsafe {
            ffi::gtk_icon_theme_set_screen(self.as_ref().to_glib_none().0, screen.to_glib_none().0);
        }
    }

    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn changed_trampoline<P: IsA<IconTheme>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkIconTheme,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconTheme::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for IconTheme {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("IconTheme")
    }
}
