/* taquin-view.c generated by valac 0.42.1.36-3777c, the Vala compiler
 * generated from taquin-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014-2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

typedef enum  {
	DIRECTION_TOP,
	DIRECTION_LEFT,
	DIRECTION_RIGHT,
	DIRECTION_BOTTOM,
	DIRECTION_NONE
} Direction;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_TAQUIN_VIEW (taquin_view_get_type ())
#define TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN_VIEW, TaquinView))
#define TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN_VIEW, TaquinViewClass))
#define IS_TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN_VIEW))
#define IS_TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN_VIEW))
#define TAQUIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN_VIEW, TaquinViewClass))

typedef struct _TaquinView TaquinView;
typedef struct _TaquinViewClass TaquinViewClass;
typedef struct _TaquinViewPrivate TaquinViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	TAQUIN_VIEW_0_PROPERTY,
	TAQUIN_VIEW_GAME_PROPERTY,
	TAQUIN_VIEW_THEME_PROPERTY,
	TAQUIN_VIEW_NUM_PROPERTIES
};
static GParamSpec* taquin_view_properties[TAQUIN_VIEW_NUM_PROPERTIES];
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

#define TYPE_GAME_TYPE (game_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TaquinView {
	GtkDrawingArea parent_instance;
	TaquinViewPrivate * priv;
};

struct _TaquinViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _TaquinViewPrivate {
	gint grid_border_main;
	gint grid_border_thin;
	gint arrows;
	gint tile_size;
	gint board_size;
	gint x_arrow;
	gint y_arrow;
	gboolean draw_lights;
	gint render_size;
	cairo_pattern_t* tiles_pattern;
	gboolean animate;
	gint animation_offset;
	gboolean x_axis;
	gint number;
	gint x_gap;
	gint y_gap;
	gboolean animate_end;
	gboolean finished;
	gdouble animation_end_offset;
	Game* _game;
	gchar* _theme;
};

static gint TaquinView_private_offset;
static gpointer taquin_view_parent_class = NULL;

GType direction_get_type (void) G_GNUC_CONST;
GType taquin_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define TAQUIN_VIEW_GRID_SPACING 1
static void taquin_view_calculate (TaquinView* self);
Game* taquin_view_get_game (TaquinView* self);
gint game_get_size (Game* self);
TaquinView* taquin_view_new (void);
TaquinView* taquin_view_construct (GType object_type);
static gboolean taquin_view_real_draw (GtkWidget* base,
                                cairo_t* cr);
static void taquin_view_load_image (TaquinView* self,
                             cairo_t* c);
static gint taquin_view_get_x_offset (TaquinView* self);
static gint taquin_view_get_y_offset (TaquinView* self);
GType game_type_get_type (void) G_GNUC_CONST;
GameType game_get_game_type (Game* self);
static void taquin_view_draw_movable_lights (TaquinView* self,
                                      cairo_t* cr);
static void taquin_view_draw_fixed_arrows (TaquinView* self,
                                    cairo_t* cr);
static void taquin_view_draw_movable_arrows (TaquinView* self,
                                      cairo_t* cr);
gint* game_get_tiles (Game* self,
                      gint* result_length1,
                      gint* result_length2);
const gchar* taquin_view_get_theme (TaquinView* self);
static void taquin_view_draw_light (TaquinView* self,
                             cairo_t* cr,
                             gboolean horizontal);
static void taquin_view_draw_vertical_arrow (TaquinView* self,
                                      cairo_t* cr,
                                      gboolean inside,
                                      gint number);
static void taquin_view_draw_horizontal_arrow (TaquinView* self,
                                        cairo_t* cr,
                                        gboolean inside,
                                        gint number);
static void taquin_view_move_cb (TaquinView* self,
                          gboolean x_axis,
                          gint number,
                          gint x_gap,
                          gint y_gap);
static void taquin_view_complete_cb (TaquinView* self);
static gboolean __lambda4_ (TaquinView* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean taquin_view_real_button_press_event (GtkWidget* base,
                                              GdkEventButton* event);
void game_request_move (Game* self,
                        gint x,
                        gint y);
static gboolean taquin_view_real_key_press_event (GtkWidget* base,
                                           GdkEventKey* event);
void taquin_view_set_game (TaquinView* self,
                           Game* value);
static void _taquin_view_move_cb_game_move (Game* _sender,
                                     gboolean x_axis,
                                     gint number,
                                     gint x_gap,
                                     gint y_gap,
                                     gpointer self);
static void _taquin_view_complete_cb_game_complete (Game* _sender,
                                             gpointer self);
void taquin_view_set_theme (TaquinView* self,
                            const gchar* value);
static void taquin_view_finalize (GObject * obj);
static void _vala_taquin_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_taquin_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

GType
direction_get_type (void)
{
	static volatile gsize direction_type_id__volatile = 0;
	if (g_once_init_enter (&direction_type_id__volatile)) {
		static const GEnumValue values[] = {{DIRECTION_TOP, "DIRECTION_TOP", "top"}, {DIRECTION_LEFT, "DIRECTION_LEFT", "left"}, {DIRECTION_RIGHT, "DIRECTION_RIGHT", "right"}, {DIRECTION_BOTTOM, "DIRECTION_BOTTOM", "bottom"}, {DIRECTION_NONE, "DIRECTION_NONE", "none"}, {0, NULL, NULL}};
		GType direction_type_id;
		direction_type_id = g_enum_register_static ("Direction", values);
		g_once_init_leave (&direction_type_id__volatile, direction_type_id);
	}
	return direction_type_id__volatile;
}

static inline gpointer
taquin_view_get_instance_private (TaquinView* self)
{
	return G_STRUCT_MEMBER_P (self, TaquinView_private_offset);
}

static void
taquin_view_calculate (TaquinView* self)
{
	gint size = 0;
	Game* _tmp0_;
	Game* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	size = MIN (gtk_widget_get_allocated_width ((GtkWidget*) self), gtk_widget_get_allocated_height ((GtkWidget*) self));
	_tmp0_ = taquin_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->tile_size = ((size * 10) / 12) / _tmp3_;
	_tmp4_ = taquin_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	self->priv->board_size = (self->priv->tile_size * _tmp7_) - TAQUIN_VIEW_GRID_SPACING;
	self->priv->grid_border_main = (size - self->priv->board_size) / 2;
	self->priv->arrows = size / 100;
}

TaquinView*
taquin_view_construct (GType object_type)
{
	TaquinView * self = NULL;
	self = (TaquinView*) g_object_new (object_type, NULL);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK));
	gtk_widget_set_size_request ((GtkWidget*) self, 350, 350);
	return self;
}

TaquinView*
taquin_view_new (void)
{
	return taquin_view_construct (TYPE_TAQUIN_VIEW);
}

static gboolean
taquin_view_real_draw (GtkWidget* base,
                       cairo_t* cr)
{
	TaquinView * self;
	gboolean result = FALSE;
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	Game* _tmp15_;
	Game* _tmp16_;
	GameType _tmp17_;
	GameType _tmp18_;
	gboolean _tmp19_ = FALSE;
	self = (TaquinView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = taquin_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	taquin_view_calculate (self);
	_tmp3_ = self->priv->tiles_pattern;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->render_size != self->priv->tile_size;
	}
	if (_tmp2_) {
		cairo_surface_t* surface = NULL;
		cairo_surface_t* _tmp4_;
		cairo_surface_t* _tmp5_;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp6_;
		cairo_t* _tmp7_;
		cairo_t* _tmp8_;
		cairo_surface_t* _tmp9_;
		cairo_pattern_t* _tmp10_;
		self->priv->render_size = self->priv->tile_size;
		_tmp4_ = cairo_get_target (cr);
		_tmp5_ = cairo_surface_create_similar (_tmp4_, CAIRO_CONTENT_COLOR_ALPHA, self->priv->board_size, self->priv->board_size);
		surface = _tmp5_;
		_tmp6_ = surface;
		_tmp7_ = cairo_create (_tmp6_);
		c = _tmp7_;
		_tmp8_ = c;
		taquin_view_load_image (self, _tmp8_);
		_tmp9_ = surface;
		_tmp10_ = cairo_pattern_create_for_surface (_tmp9_);
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
		self->priv->tiles_pattern = _tmp10_;
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
	}
	_tmp11_ = taquin_view_get_x_offset (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = taquin_view_get_y_offset (self);
	_tmp14_ = _tmp13_;
	cairo_translate (cr, (gdouble) _tmp12_, (gdouble) _tmp14_);
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	cairo_set_line_join (cr, CAIRO_LINE_JOIN_ROUND);
	cairo_set_source_rgb (cr, 0.8, 0.8, 0.8);
	cairo_rectangle (cr, self->priv->grid_border_main / 2.0, self->priv->grid_border_main / 2.0, (gdouble) (self->priv->board_size + self->priv->grid_border_main), (gdouble) (self->priv->board_size + self->priv->grid_border_main));
	cairo_fill_preserve (cr);
	cairo_set_source_rgb (cr, 0.3, 0.3, 0.3);
	cairo_set_line_width (cr, (gdouble) self->priv->grid_border_main);
	cairo_stroke (cr);
	cairo_set_source_rgb (cr, 0.1, 0.1, 0.1);
	cairo_set_line_width (cr, (gdouble) self->priv->grid_border_thin);
	cairo_arc (cr, self->priv->grid_border_main / 2.0, self->priv->grid_border_main / 2.0, (self->priv->grid_border_main - self->priv->grid_border_thin) / 2.0, G_PI, (G_PI * 3) / 2.0);
	cairo_arc (cr, ((self->priv->grid_border_main * 3) / 2.0) + self->priv->board_size, self->priv->grid_border_main / 2.0, (self->priv->grid_border_main - self->priv->grid_border_thin) / 2.0, (G_PI * 3) / 2.0, (gdouble) 0);
	cairo_arc (cr, ((self->priv->grid_border_main * 3) / 2.0) + self->priv->board_size, ((self->priv->grid_border_main * 3) / 2.0) + self->priv->board_size, (self->priv->grid_border_main - self->priv->grid_border_thin) / 2.0, (gdouble) 0, G_PI / 2.0);
	cairo_arc (cr, self->priv->grid_border_main / 2.0, ((self->priv->grid_border_main * 3) / 2.0) + self->priv->board_size, (self->priv->grid_border_main - self->priv->grid_border_thin) / 2.0, G_PI / 2.0, G_PI);
	cairo_arc (cr, self->priv->grid_border_main / 2.0, self->priv->grid_border_main / 2.0, (self->priv->grid_border_main - self->priv->grid_border_thin) / 2.0, G_PI, (G_PI * 3) / 2.0);
	cairo_stroke (cr);
	cairo_set_source_rgba (cr, 0.25, 0.25, 0.25, 1.0 - self->priv->animation_end_offset);
	cairo_set_line_width (cr, (gdouble) self->priv->arrows);
	_tmp15_ = taquin_view_get_game (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = game_get_game_type (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ == GAME_TYPE_SIXTEEN) {
		if (self->priv->draw_lights) {
			taquin_view_draw_movable_lights (self, cr);
		}
		taquin_view_draw_fixed_arrows (self, cr);
	} else {
		taquin_view_draw_movable_arrows (self, cr);
	}
	cairo_stroke (cr);
	cairo_save (cr);
	cairo_translate (cr, (gdouble) self->priv->grid_border_main, (gdouble) self->priv->grid_border_main);
	if (self->priv->animate) {
		Game* _tmp20_;
		Game* _tmp21_;
		GameType _tmp22_;
		GameType _tmp23_;
		_tmp20_ = taquin_view_get_game (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = game_get_game_type (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp19_ = _tmp23_ == GAME_TYPE_SIXTEEN;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gint texture_x = 0;
		Game* _tmp24_;
		Game* _tmp25_;
		gint* _tmp26_;
		gint _tmp26__length1;
		gint _tmp26__length2;
		gint* _tmp27_;
		gint _tmp27__length1;
		gint _tmp27__length2;
		gint _tmp28_;
		Game* _tmp29_;
		Game* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint texture_y = 0;
		Game* _tmp33_;
		Game* _tmp34_;
		gint* _tmp35_;
		gint _tmp35__length1;
		gint _tmp35__length2;
		gint* _tmp36_;
		gint _tmp36__length1;
		gint _tmp36__length2;
		gint _tmp37_;
		Game* _tmp38_;
		Game* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint tile_x = 0;
		gint tile_y = 0;
		cairo_matrix_t matrix = {0};
		cairo_pattern_t* _tmp42_;
		cairo_matrix_t _tmp43_;
		cairo_pattern_t* _tmp44_;
		gint _tmp45_ = 0;
		gint _tmp51_ = 0;
		cairo_pattern_t* _tmp57_;
		cairo_matrix_t _tmp58_;
		cairo_pattern_t* _tmp59_;
		_tmp24_ = taquin_view_get_game (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = game_get_tiles (_tmp25_, &_tmp26__length1, &_tmp26__length2);
		_tmp27_ = _tmp26_;
		_tmp27__length1 = _tmp26__length1;
		_tmp27__length2 = _tmp26__length2;
		_tmp28_ = _tmp27_[(self->priv->x_gap * _tmp27__length2) + self->priv->y_gap];
		_tmp29_ = taquin_view_get_game (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = game_get_size (_tmp30_);
		_tmp32_ = _tmp31_;
		texture_x = (_tmp28_ % _tmp32_) * self->priv->tile_size;
		_tmp33_ = taquin_view_get_game (self);
		_tmp34_ = _tmp33_;
		_tmp35_ = game_get_tiles (_tmp34_, &_tmp35__length1, &_tmp35__length2);
		_tmp36_ = _tmp35_;
		_tmp36__length1 = _tmp35__length1;
		_tmp36__length2 = _tmp35__length2;
		_tmp37_ = _tmp36_[(self->priv->x_gap * _tmp36__length2) + self->priv->y_gap];
		_tmp38_ = taquin_view_get_game (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = game_get_size (_tmp39_);
		_tmp41_ = _tmp40_;
		texture_y = (_tmp37_ / _tmp41_) * self->priv->tile_size;
		tile_x = self->priv->x_gap * self->priv->tile_size;
		tile_y = self->priv->y_gap * self->priv->tile_size;
		cairo_matrix_init_identity (&matrix);
		cairo_matrix_translate (&matrix, (gdouble) (texture_x - tile_x), (gdouble) (texture_y - tile_y));
		_tmp42_ = self->priv->tiles_pattern;
		_tmp43_ = matrix;
		cairo_pattern_set_matrix (_tmp42_, &_tmp43_);
		_tmp44_ = self->priv->tiles_pattern;
		cairo_set_source (cr, _tmp44_);
		cairo_rectangle (cr, (gdouble) tile_x, (gdouble) tile_y, (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING), (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING));
		cairo_fill (cr);
		if (self->priv->x_axis) {
			gint _tmp46_ = 0;
			if (self->priv->x_gap == 0) {
				Game* _tmp47_;
				Game* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				_tmp47_ = taquin_view_get_game (self);
				_tmp48_ = _tmp47_;
				_tmp49_ = game_get_size (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp46_ = _tmp50_ - 1;
			} else {
				_tmp46_ = 0;
			}
			_tmp45_ = _tmp46_;
		} else {
			_tmp45_ = self->priv->x_gap;
		}
		tile_x = self->priv->tile_size * _tmp45_;
		if (self->priv->x_axis) {
			_tmp51_ = self->priv->y_gap;
		} else {
			gint _tmp52_ = 0;
			if (self->priv->y_gap == 0) {
				Game* _tmp53_;
				Game* _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				_tmp53_ = taquin_view_get_game (self);
				_tmp54_ = _tmp53_;
				_tmp55_ = game_get_size (_tmp54_);
				_tmp56_ = _tmp55_;
				_tmp52_ = _tmp56_ - 1;
			} else {
				_tmp52_ = 0;
			}
			_tmp51_ = _tmp52_;
		}
		tile_y = self->priv->tile_size * _tmp51_;
		cairo_matrix_init_identity (&matrix);
		cairo_matrix_translate (&matrix, (gdouble) (texture_x - tile_x), (gdouble) (texture_y - tile_y));
		_tmp57_ = self->priv->tiles_pattern;
		_tmp58_ = matrix;
		cairo_pattern_set_matrix (_tmp57_, &_tmp58_);
		_tmp59_ = self->priv->tiles_pattern;
		cairo_set_source (cr, _tmp59_);
		cairo_rectangle (cr, (gdouble) tile_x, (gdouble) tile_y, (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING), (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING));
		cairo_fill (cr);
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp60_ = FALSE;
			_tmp60_ = TRUE;
			while (TRUE) {
				Game* _tmp62_;
				Game* _tmp63_;
				gint _tmp64_;
				gint _tmp65_;
				if (!_tmp60_) {
					gint _tmp61_;
					_tmp61_ = y;
					y = _tmp61_ + 1;
				}
				_tmp60_ = FALSE;
				_tmp62_ = taquin_view_get_game (self);
				_tmp63_ = _tmp62_;
				_tmp64_ = game_get_size (_tmp63_);
				_tmp65_ = _tmp64_;
				if (!(y < _tmp65_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp66_ = FALSE;
						_tmp66_ = TRUE;
						while (TRUE) {
							Game* _tmp68_;
							Game* _tmp69_;
							gint _tmp70_;
							gint _tmp71_;
							gboolean _tmp72_ = FALSE;
							gboolean _tmp73_ = FALSE;
							gint tile_x = 0;
							gint tile_y = 0;
							gboolean _tmp74_ = FALSE;
							gint texture_x = 0;
							Game* _tmp86_;
							Game* _tmp87_;
							gint* _tmp88_;
							gint _tmp88__length1;
							gint _tmp88__length2;
							gint* _tmp89_;
							gint _tmp89__length1;
							gint _tmp89__length2;
							gint _tmp90_;
							Game* _tmp91_;
							Game* _tmp92_;
							gint _tmp93_;
							gint _tmp94_;
							gint texture_y = 0;
							Game* _tmp95_;
							Game* _tmp96_;
							gint* _tmp97_;
							gint _tmp97__length1;
							gint _tmp97__length2;
							gint* _tmp98_;
							gint _tmp98__length1;
							gint _tmp98__length2;
							gint _tmp99_;
							Game* _tmp100_;
							Game* _tmp101_;
							gint _tmp102_;
							gint _tmp103_;
							cairo_matrix_t matrix = {0};
							cairo_pattern_t* _tmp104_;
							cairo_matrix_t _tmp105_;
							cairo_pattern_t* _tmp106_;
							if (!_tmp66_) {
								gint _tmp67_;
								_tmp67_ = x;
								x = _tmp67_ + 1;
							}
							_tmp66_ = FALSE;
							_tmp68_ = taquin_view_get_game (self);
							_tmp69_ = _tmp68_;
							_tmp70_ = game_get_size (_tmp69_);
							_tmp71_ = _tmp70_;
							if (!(x < _tmp71_)) {
								break;
							}
							if (self->priv->animate) {
								_tmp73_ = x == self->priv->x_gap;
							} else {
								_tmp73_ = FALSE;
							}
							if (_tmp73_) {
								_tmp72_ = y == self->priv->y_gap;
							} else {
								_tmp72_ = FALSE;
							}
							if (_tmp72_) {
								continue;
							}
							tile_x = x * self->priv->tile_size;
							tile_y = y * self->priv->tile_size;
							if (self->priv->animate) {
								gboolean _tmp75_ = FALSE;
								if (x != self->priv->x_gap) {
									_tmp75_ = TRUE;
								} else {
									_tmp75_ = y != self->priv->y_gap;
								}
								_tmp74_ = _tmp75_;
							} else {
								_tmp74_ = FALSE;
							}
							if (_tmp74_) {
								gboolean _tmp76_ = FALSE;
								if (self->priv->x_axis) {
									_tmp76_ = y == self->priv->y_gap;
								} else {
									_tmp76_ = FALSE;
								}
								if (_tmp76_) {
									gboolean _tmp77_ = FALSE;
									gboolean _tmp78_ = FALSE;
									if (self->priv->number > 0) {
										_tmp78_ = x <= (self->priv->x_gap + self->priv->number);
									} else {
										_tmp78_ = FALSE;
									}
									if (_tmp78_) {
										_tmp77_ = x >= self->priv->x_gap;
									} else {
										_tmp77_ = FALSE;
									}
									if (_tmp77_) {
										tile_x -= self->priv->tile_size - self->priv->animation_offset;
									} else {
										gboolean _tmp79_ = FALSE;
										gboolean _tmp80_ = FALSE;
										if (self->priv->number < 0) {
											_tmp80_ = x >= (self->priv->x_gap + self->priv->number);
										} else {
											_tmp80_ = FALSE;
										}
										if (_tmp80_) {
											_tmp79_ = x <= self->priv->x_gap;
										} else {
											_tmp79_ = FALSE;
										}
										if (_tmp79_) {
											tile_x += self->priv->tile_size - self->priv->animation_offset;
										}
									}
								} else {
									gboolean _tmp81_ = FALSE;
									if (!self->priv->x_axis) {
										_tmp81_ = x == self->priv->x_gap;
									} else {
										_tmp81_ = FALSE;
									}
									if (_tmp81_) {
										gboolean _tmp82_ = FALSE;
										gboolean _tmp83_ = FALSE;
										if (self->priv->number > 0) {
											_tmp83_ = y <= (self->priv->y_gap + self->priv->number);
										} else {
											_tmp83_ = FALSE;
										}
										if (_tmp83_) {
											_tmp82_ = y >= self->priv->y_gap;
										} else {
											_tmp82_ = FALSE;
										}
										if (_tmp82_) {
											tile_y -= self->priv->tile_size - self->priv->animation_offset;
										} else {
											gboolean _tmp84_ = FALSE;
											gboolean _tmp85_ = FALSE;
											if (self->priv->number < 0) {
												_tmp85_ = y >= (self->priv->y_gap + self->priv->number);
											} else {
												_tmp85_ = FALSE;
											}
											if (_tmp85_) {
												_tmp84_ = y <= self->priv->y_gap;
											} else {
												_tmp84_ = FALSE;
											}
											if (_tmp84_) {
												tile_y += self->priv->tile_size - self->priv->animation_offset;
											}
										}
									}
								}
							}
							_tmp86_ = taquin_view_get_game (self);
							_tmp87_ = _tmp86_;
							_tmp88_ = game_get_tiles (_tmp87_, &_tmp88__length1, &_tmp88__length2);
							_tmp89_ = _tmp88_;
							_tmp89__length1 = _tmp88__length1;
							_tmp89__length2 = _tmp88__length2;
							_tmp90_ = _tmp89_[(x * _tmp89__length2) + y];
							_tmp91_ = taquin_view_get_game (self);
							_tmp92_ = _tmp91_;
							_tmp93_ = game_get_size (_tmp92_);
							_tmp94_ = _tmp93_;
							texture_x = (_tmp90_ % _tmp94_) * self->priv->tile_size;
							_tmp95_ = taquin_view_get_game (self);
							_tmp96_ = _tmp95_;
							_tmp97_ = game_get_tiles (_tmp96_, &_tmp97__length1, &_tmp97__length2);
							_tmp98_ = _tmp97_;
							_tmp98__length1 = _tmp97__length1;
							_tmp98__length2 = _tmp97__length2;
							_tmp99_ = _tmp98_[(x * _tmp98__length2) + y];
							_tmp100_ = taquin_view_get_game (self);
							_tmp101_ = _tmp100_;
							_tmp102_ = game_get_size (_tmp101_);
							_tmp103_ = _tmp102_;
							texture_y = (_tmp99_ / _tmp103_) * self->priv->tile_size;
							cairo_matrix_init_identity (&matrix);
							cairo_matrix_translate (&matrix, (gdouble) (texture_x - tile_x), (gdouble) (texture_y - tile_y));
							_tmp104_ = self->priv->tiles_pattern;
							_tmp105_ = matrix;
							cairo_pattern_set_matrix (_tmp104_, &_tmp105_);
							_tmp106_ = self->priv->tiles_pattern;
							cairo_set_source (cr, _tmp106_);
							cairo_rectangle (cr, (gdouble) tile_x, (gdouble) tile_y, (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING), (gdouble) (self->priv->tile_size - TAQUIN_VIEW_GRID_SPACING));
							cairo_fill (cr);
						}
					}
				}
			}
		}
	}
	if (self->priv->animate_end) {
		cairo_matrix_t matrix = {0};
		cairo_pattern_t* _tmp107_;
		cairo_matrix_t _tmp108_;
		self->priv->animation_end_offset = self->priv->animation_end_offset + 0.01;
		if (self->priv->animation_end_offset >= ((gdouble) 1)) {
			self->priv->animation_end_offset = (gdouble) 1;
		}
		cairo_matrix_init_identity (&matrix);
		_tmp107_ = self->priv->tiles_pattern;
		_tmp108_ = matrix;
		cairo_pattern_set_matrix (_tmp107_, &_tmp108_);
		cairo_paint_with_alpha (cr, self->priv->animation_end_offset);
		if (self->priv->animation_end_offset != ((gdouble) 1)) {
			gtk_widget_queue_draw ((GtkWidget*) self);
		}
	}
	cairo_restore (cr);
	if (self->priv->animate) {
		self->priv->animation_offset = self->priv->animation_offset + 8;
		if (self->priv->x_axis) {
			gint _tmp109_;
			gint _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			_tmp109_ = taquin_view_get_x_offset (self);
			_tmp110_ = _tmp109_;
			_tmp111_ = taquin_view_get_y_offset (self);
			_tmp112_ = _tmp111_;
			gtk_widget_queue_draw_area ((GtkWidget*) self, (_tmp110_ + self->priv->grid_border_main) + (self->priv->tile_size * MIN (self->priv->x_gap, self->priv->x_gap + self->priv->number)), (_tmp112_ + self->priv->grid_border_main) + (self->priv->tile_size * self->priv->y_gap), self->priv->tile_size * (abs (self->priv->number) + 1), self->priv->tile_size);
		} else {
			gint _tmp113_;
			gint _tmp114_;
			gint _tmp115_;
			gint _tmp116_;
			_tmp113_ = taquin_view_get_x_offset (self);
			_tmp114_ = _tmp113_;
			_tmp115_ = taquin_view_get_y_offset (self);
			_tmp116_ = _tmp115_;
			gtk_widget_queue_draw_area ((GtkWidget*) self, (_tmp114_ + self->priv->grid_border_main) + (self->priv->tile_size * self->priv->x_gap), (_tmp116_ + self->priv->grid_border_main) + (self->priv->tile_size * MIN (self->priv->y_gap, self->priv->y_gap + self->priv->number)), self->priv->tile_size, self->priv->tile_size * (abs (self->priv->number) + 1));
		}
		if (self->priv->animation_offset > self->priv->tile_size) {
			self->priv->animate = FALSE;
		}
	}
	result = FALSE;
	return result;
}

static void
taquin_view_load_image (TaquinView* self,
                        cairo_t* c)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp0_ = taquin_view_get_theme (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gdk_pixbuf_new_from_file_at_scale (_tmp1_, self->priv->board_size, self->priv->board_size, FALSE, &_inner_error_);
		p = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		gdk_cairo_set_source_pixbuf (c, p, (gdouble) 0, (gdouble) 0);
		cairo_paint (c);
		_g_object_unref0 (p);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = taquin_view_get_theme (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("taquin-view.vala:294: Failed to load theme %s: %s\n" \
"\n" \
"If you were trying to launch an unusual size, retry, it may work. But " \
"it probably implies that you have not an image adapted to the requeste" \
"d size in the current theme. If that's not the case, file a bug please" \
".\n", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}

static void
taquin_view_draw_movable_lights (TaquinView* self,
                                 cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	cairo_set_source_rgba (cr, 0.8, 0.8, 0.8, 0.3 - (0.3 * self->priv->animation_end_offset));
	cairo_save (cr);
	cairo_translate (cr, self->priv->grid_border_main + (self->priv->tile_size * (self->priv->x_arrow + 0.5)), (self->priv->grid_border_main + self->priv->grid_border_thin) / 2.0);
	taquin_view_draw_light (self, cr, TRUE);
	cairo_translate (cr, (gdouble) 0, (gdouble) ((self->priv->board_size + self->priv->grid_border_main) - self->priv->grid_border_thin));
	taquin_view_draw_light (self, cr, TRUE);
	cairo_restore (cr);
	cairo_fill (cr);
	cairo_save (cr);
	cairo_translate (cr, (self->priv->grid_border_main + self->priv->grid_border_thin) / 2.0, self->priv->grid_border_main + (self->priv->tile_size * (self->priv->y_arrow + 0.5)));
	taquin_view_draw_light (self, cr, FALSE);
	cairo_translate (cr, (gdouble) ((self->priv->board_size + self->priv->grid_border_main) - self->priv->grid_border_thin), (gdouble) 0);
	taquin_view_draw_light (self, cr, FALSE);
	cairo_restore (cr);
	cairo_fill (cr);
	cairo_restore (cr);
}

static void
taquin_view_draw_light (TaquinView* self,
                        cairo_t* cr,
                        gboolean horizontal)
{
	gdouble size = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	size = (0.3 * self->priv->tile_size) / self->priv->grid_border_main;
	if (horizontal) {
		_tmp0_ = size;
	} else {
		_tmp0_ = 0.3;
	}
	if (horizontal) {
		_tmp1_ = 0.3;
	} else {
		_tmp1_ = size;
	}
	cairo_scale (cr, _tmp0_, _tmp1_);
	cairo_arc (cr, 0.0, 0.0, (gdouble) self->priv->grid_border_main, 0.0, 2.0 * G_PI);
	cairo_restore (cr);
}

static void
taquin_view_draw_fixed_arrows (TaquinView* self,
                               cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Game* _tmp2_;
				Game* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = taquin_view_get_game (self);
				_tmp3_ = _tmp2_;
				_tmp4_ = game_get_size (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				taquin_view_draw_vertical_arrow (self, cr, FALSE, i);
				taquin_view_draw_horizontal_arrow (self, cr, FALSE, i);
			}
		}
	}
}

static void
taquin_view_draw_movable_arrows (TaquinView* self,
                                 cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	taquin_view_draw_vertical_arrow (self, cr, TRUE, self->priv->x_arrow);
	taquin_view_draw_horizontal_arrow (self, cr, TRUE, self->priv->y_arrow);
}

static void
taquin_view_draw_horizontal_arrow (TaquinView* self,
                                   cairo_t* cr,
                                   gboolean inside,
                                   gint number)
{
	gdouble x1 = 0.0;
	gdouble x2 = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	x1 = ((self->priv->grid_border_main * 1.0) / 3) + ((self->priv->grid_border_thin * 2.0) / 3);
	x2 = ((self->priv->grid_border_main * 2.0) / 3) + ((self->priv->grid_border_thin * 1.0) / 3);
	if (inside) {
		_tmp0_ = x1;
	} else {
		_tmp0_ = x2;
	}
	cairo_move_to (cr, _tmp0_, self->priv->grid_border_main + (self->priv->tile_size * (number + (1.0 / 3))));
	if (inside) {
		_tmp1_ = x2;
	} else {
		_tmp1_ = x1;
	}
	cairo_line_to (cr, _tmp1_, self->priv->grid_border_main + (self->priv->tile_size * (number + (1.0 / 2))));
	if (inside) {
		_tmp2_ = x1;
	} else {
		_tmp2_ = x2;
	}
	cairo_line_to (cr, _tmp2_, self->priv->grid_border_main + (self->priv->tile_size * (number + (2.0 / 3))));
	x1 = (self->priv->board_size + ((self->priv->grid_border_main * 5.0) / 3)) - ((self->priv->grid_border_thin * 2.0) / 3);
	x2 = (self->priv->board_size + ((self->priv->grid_border_main * 4.0) / 3)) - ((self->priv->grid_border_thin * 1.0) / 3);
	if (inside) {
		_tmp3_ = x1;
	} else {
		_tmp3_ = x2;
	}
	cairo_move_to (cr, _tmp3_, self->priv->grid_border_main + (self->priv->tile_size * (number + (1.0 / 3))));
	if (inside) {
		_tmp4_ = x2;
	} else {
		_tmp4_ = x1;
	}
	cairo_line_to (cr, _tmp4_, self->priv->grid_border_main + (self->priv->tile_size * (number + (1.0 / 2))));
	if (inside) {
		_tmp5_ = x1;
	} else {
		_tmp5_ = x2;
	}
	cairo_line_to (cr, _tmp5_, self->priv->grid_border_main + (self->priv->tile_size * (number + (2.0 / 3))));
}

static void
taquin_view_draw_vertical_arrow (TaquinView* self,
                                 cairo_t* cr,
                                 gboolean inside,
                                 gint number)
{
	gdouble y1 = 0.0;
	gdouble y2 = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	y1 = ((self->priv->grid_border_main * 1.0) / 3) + ((self->priv->grid_border_thin * 2.0) / 3);
	y2 = ((self->priv->grid_border_main * 2.0) / 3) + ((self->priv->grid_border_thin * 1.0) / 3);
	if (inside) {
		_tmp0_ = y1;
	} else {
		_tmp0_ = y2;
	}
	cairo_move_to (cr, self->priv->grid_border_main + (self->priv->tile_size * (number + (1.0 / 3))), _tmp0_);
	if (inside) {
		_tmp1_ = y2;
	} else {
		_tmp1_ = y1;
	}
	cairo_line_to (cr, self->priv->grid_border_main + (self->priv->tile_size * (number + (1.0 / 2))), _tmp1_);
	if (inside) {
		_tmp2_ = y1;
	} else {
		_tmp2_ = y2;
	}
	cairo_line_to (cr, self->priv->grid_border_main + (self->priv->tile_size * (number + (2.0 / 3))), _tmp2_);
	y1 = (self->priv->board_size + ((self->priv->grid_border_main * 5.0) / 3)) - ((self->priv->grid_border_thin * 2.0) / 3);
	y2 = (self->priv->board_size + ((self->priv->grid_border_main * 4.0) / 3)) - ((self->priv->grid_border_thin * 1.0) / 3);
	if (inside) {
		_tmp3_ = y1;
	} else {
		_tmp3_ = y2;
	}
	cairo_move_to (cr, self->priv->grid_border_main + (self->priv->tile_size * (number + (1.0 / 3))), _tmp3_);
	if (inside) {
		_tmp4_ = y2;
	} else {
		_tmp4_ = y1;
	}
	cairo_line_to (cr, self->priv->grid_border_main + (self->priv->tile_size * (number + (1.0 / 2))), _tmp4_);
	if (inside) {
		_tmp5_ = y1;
	} else {
		_tmp5_ = y2;
	}
	cairo_line_to (cr, self->priv->grid_border_main + (self->priv->tile_size * (number + (2.0 / 3))), _tmp5_);
}

static void
taquin_view_move_cb (TaquinView* self,
                     gboolean x_axis,
                     gint number,
                     gint x_gap,
                     gint y_gap)
{
	Game* _tmp0_;
	Game* _tmp1_;
	GameType _tmp2_;
	GameType _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->x_axis = x_axis;
	self->priv->number = number;
	self->priv->x_gap = x_gap;
	self->priv->y_gap = y_gap;
	_tmp0_ = taquin_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_game_type (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GAME_TYPE_FIFTEEN) {
		self->priv->x_arrow = x_gap;
		self->priv->y_arrow = y_gap;
	}
	self->priv->animation_offset = 0;
	self->priv->animate = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gboolean
__lambda4_ (TaquinView* self)
{
	gboolean result = FALSE;
	self->priv->animation_end_offset = (gdouble) 0;
	self->priv->animate_end = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ((TaquinView*) self);
	return result;
}

static void
taquin_view_complete_cb (TaquinView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->finished = TRUE;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
taquin_view_real_button_press_event (GtkWidget* base,
                                     GdkEventButton* event)
{
	TaquinView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (TaquinView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->animate) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->animate_end;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (event->button == ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = event->button == ((guint) GDK_BUTTON_SECONDARY);
	}
	if (_tmp1_) {
		Game* _tmp2_;
		Game* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		self->priv->draw_lights = FALSE;
		_tmp2_ = taquin_view_get_game (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = taquin_view_get_x_offset (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = taquin_view_get_y_offset (self);
		_tmp7_ = _tmp6_;
		game_request_move (_tmp3_, (((gint) (((event->x - _tmp5_) - self->priv->grid_border_main) + self->priv->tile_size)) / self->priv->tile_size) - 1, (((gint) (((event->y - _tmp7_) - self->priv->grid_border_main) + self->priv->tile_size)) / self->priv->tile_size) - 1);
	}
	result = TRUE;
	return result;
}

static gboolean
taquin_view_real_key_press_event (GtkWidget* base,
                                  GdkEventKey* event)
{
	TaquinView * self;
	gboolean result = FALSE;
	gchar* k_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	Game* _tmp3_;
	Game* _tmp4_;
	GameType _tmp5_;
	GameType _tmp6_;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	const gchar* _tmp32_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GQuark _tmp40_ = 0U;
	static GQuark _tmp39_label0 = 0;
	static GQuark _tmp39_label1 = 0;
	static GQuark _tmp39_label2 = 0;
	static GQuark _tmp39_label3 = 0;
	self = (TaquinView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->finished) {
		result = FALSE;
		return result;
	}
	_tmp0_ = gdk_keyval_name (event->keyval);
	_tmp1_ = g_strdup (_tmp0_);
	k_name = _tmp1_;
	_tmp3_ = taquin_view_get_game (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = game_get_game_type (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == GAME_TYPE_SIXTEEN) {
		gboolean _tmp7_ = FALSE;
		GdkModifierType _tmp8_;
		_tmp8_ = event->state;
		if ((_tmp8_ & GDK_SHIFT_MASK) > 0) {
			_tmp7_ = TRUE;
		} else {
			GdkModifierType _tmp9_;
			_tmp9_ = event->state;
			_tmp7_ = (_tmp9_ & GDK_CONTROL_MASK) > 0;
		}
		_tmp2_ = _tmp7_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		GQuark _tmp13_ = 0U;
		static GQuark _tmp12_label0 = 0;
		static GQuark _tmp12_label1 = 0;
		static GQuark _tmp12_label2 = 0;
		static GQuark _tmp12_label3 = 0;
		_tmp10_ = k_name;
		_tmp11_ = _tmp10_;
		_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
		if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string ("Left")))) {
			switch (0) {
				default:
				{
					Game* _tmp14_;
					Game* _tmp15_;
					_tmp14_ = taquin_view_get_game (self);
					_tmp15_ = _tmp14_;
					game_request_move (_tmp15_, -1, self->priv->y_arrow);
					break;
				}
			}
		} else if (_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("Right")))) {
			switch (0) {
				default:
				{
					Game* _tmp16_;
					Game* _tmp17_;
					Game* _tmp18_;
					Game* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					_tmp16_ = taquin_view_get_game (self);
					_tmp17_ = _tmp16_;
					_tmp18_ = taquin_view_get_game (self);
					_tmp19_ = _tmp18_;
					_tmp20_ = game_get_size (_tmp19_);
					_tmp21_ = _tmp20_;
					game_request_move (_tmp17_, _tmp21_, self->priv->y_arrow);
					break;
				}
			}
		} else if (_tmp13_ == ((0 != _tmp12_label2) ? _tmp12_label2 : (_tmp12_label2 = g_quark_from_static_string ("Up")))) {
			switch (0) {
				default:
				{
					Game* _tmp22_;
					Game* _tmp23_;
					_tmp22_ = taquin_view_get_game (self);
					_tmp23_ = _tmp22_;
					game_request_move (_tmp23_, self->priv->x_arrow, -1);
					break;
				}
			}
		} else if (_tmp13_ == ((0 != _tmp12_label3) ? _tmp12_label3 : (_tmp12_label3 = g_quark_from_static_string ("Down")))) {
			switch (0) {
				default:
				{
					Game* _tmp24_;
					Game* _tmp25_;
					Game* _tmp26_;
					Game* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp24_ = taquin_view_get_game (self);
					_tmp25_ = _tmp24_;
					_tmp26_ = taquin_view_get_game (self);
					_tmp27_ = _tmp26_;
					_tmp28_ = game_get_size (_tmp27_);
					_tmp29_ = _tmp28_;
					game_request_move (_tmp25_, self->priv->x_arrow, _tmp29_);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					result = FALSE;
					_g_free0 (k_name);
					return result;
				}
			}
		}
	}
	_tmp32_ = k_name;
	if (g_strcmp0 (_tmp32_, "space") == 0) {
		_tmp31_ = TRUE;
	} else {
		const gchar* _tmp33_;
		_tmp33_ = k_name;
		_tmp31_ = g_strcmp0 (_tmp33_, "KP_Enter") == 0;
	}
	if (_tmp31_) {
		_tmp30_ = TRUE;
	} else {
		const gchar* _tmp34_;
		_tmp34_ = k_name;
		_tmp30_ = g_strcmp0 (_tmp34_, "Return") == 0;
	}
	if (_tmp30_) {
		Game* _tmp35_;
		Game* _tmp36_;
		_tmp35_ = taquin_view_get_game (self);
		_tmp36_ = _tmp35_;
		game_request_move (_tmp36_, self->priv->x_arrow, self->priv->y_arrow);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp37_ = k_name;
	_tmp38_ = _tmp37_;
	_tmp40_ = (NULL == _tmp38_) ? 0 : g_quark_from_string (_tmp38_);
	if (_tmp40_ == ((0 != _tmp39_label0) ? _tmp39_label0 : (_tmp39_label0 = g_quark_from_static_string ("Left")))) {
		switch (0) {
			default:
			{
				if (self->priv->x_arrow > 0) {
					gint _tmp41_;
					_tmp41_ = self->priv->x_arrow;
					self->priv->x_arrow = _tmp41_ - 1;
				}
				break;
			}
		}
	} else if (_tmp40_ == ((0 != _tmp39_label1) ? _tmp39_label1 : (_tmp39_label1 = g_quark_from_static_string ("Right")))) {
		switch (0) {
			default:
			{
				Game* _tmp42_;
				Game* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				_tmp42_ = taquin_view_get_game (self);
				_tmp43_ = _tmp42_;
				_tmp44_ = game_get_size (_tmp43_);
				_tmp45_ = _tmp44_;
				if (self->priv->x_arrow < (_tmp45_ - 1)) {
					gint _tmp46_;
					_tmp46_ = self->priv->x_arrow;
					self->priv->x_arrow = _tmp46_ + 1;
				}
				break;
			}
		}
	} else if (_tmp40_ == ((0 != _tmp39_label2) ? _tmp39_label2 : (_tmp39_label2 = g_quark_from_static_string ("Up")))) {
		switch (0) {
			default:
			{
				if (self->priv->y_arrow > 0) {
					gint _tmp47_;
					_tmp47_ = self->priv->y_arrow;
					self->priv->y_arrow = _tmp47_ - 1;
				}
				break;
			}
		}
	} else if (_tmp40_ == ((0 != _tmp39_label3) ? _tmp39_label3 : (_tmp39_label3 = g_quark_from_static_string ("Down")))) {
		switch (0) {
			default:
			{
				Game* _tmp48_;
				Game* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				_tmp48_ = taquin_view_get_game (self);
				_tmp49_ = _tmp48_;
				_tmp50_ = game_get_size (_tmp49_);
				_tmp51_ = _tmp50_;
				if (self->priv->y_arrow < (_tmp51_ - 1)) {
					gint _tmp52_;
					_tmp52_ = self->priv->y_arrow;
					self->priv->y_arrow = _tmp52_ + 1;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (k_name);
				return result;
			}
		}
	}
	self->priv->draw_lights = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	_g_free0 (k_name);
	return result;
}

static gint
taquin_view_get_x_offset (TaquinView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ((gtk_widget_get_allocated_width ((GtkWidget*) self) - self->priv->board_size) / 2) - self->priv->grid_border_main;
	return result;
}

static gint
taquin_view_get_y_offset (TaquinView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ((gtk_widget_get_allocated_height ((GtkWidget*) self) - self->priv->board_size) / 2) - self->priv->grid_border_main;
	return result;
}

Game*
taquin_view_get_game (TaquinView* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_taquin_view_move_cb_game_move (Game* _sender,
                                gboolean x_axis,
                                gint number,
                                gint x_gap,
                                gint y_gap,
                                gpointer self)
{
	taquin_view_move_cb ((TaquinView*) self, x_axis, number, x_gap, y_gap);
}

static void
_taquin_view_complete_cb_game_complete (Game* _sender,
                                        gpointer self)
{
	taquin_view_complete_cb ((TaquinView*) self);
}

void
taquin_view_set_game (TaquinView* self,
                      Game* value)
{
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	self->priv->animate = FALSE;
	self->priv->finished = FALSE;
	self->priv->animate_end = FALSE;
	self->priv->animation_end_offset = (gdouble) 0;
	self->priv->draw_lights = FALSE;
	self->priv->x_arrow = 0;
	self->priv->y_arrow = 0;
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp2_;
	_tmp3_ = self->priv->_game;
	g_signal_connect_object (_tmp3_, "move", (GCallback) _taquin_view_move_cb_game_move, self, 0);
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (_tmp4_, "complete", (GCallback) _taquin_view_complete_cb_game_complete, self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, taquin_view_properties[TAQUIN_VIEW_GAME_PROPERTY]);
}

const gchar*
taquin_view_get_theme (TaquinView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}

void
taquin_view_set_theme (TaquinView* self,
                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp0_;
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, taquin_view_properties[TAQUIN_VIEW_THEME_PROPERTY]);
}

static void
taquin_view_class_init (TaquinViewClass * klass,
                        gpointer klass_data)
{
	taquin_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TaquinView_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) taquin_view_real_draw;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) taquin_view_real_button_press_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) taquin_view_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_taquin_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_taquin_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = taquin_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAQUIN_VIEW_GAME_PROPERTY, taquin_view_properties[TAQUIN_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAQUIN_VIEW_THEME_PROPERTY, taquin_view_properties[TAQUIN_VIEW_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
taquin_view_instance_init (TaquinView * self,
                           gpointer klass)
{
	self->priv = taquin_view_get_instance_private (self);
	self->priv->grid_border_thin = 6;
	self->priv->x_arrow = 0;
	self->priv->y_arrow = 0;
	self->priv->draw_lights = FALSE;
	self->priv->render_size = 0;
	self->priv->tiles_pattern = NULL;
	self->priv->animate = FALSE;
	self->priv->animate_end = FALSE;
	self->priv->finished = FALSE;
	self->priv->_game = NULL;
	self->priv->_theme = NULL;
}

static void
taquin_view_finalize (GObject * obj)
{
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAQUIN_VIEW, TaquinView);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	_g_object_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (taquin_view_parent_class)->finalize (obj);
}

GType
taquin_view_get_type (void)
{
	static volatile gsize taquin_view_type_id__volatile = 0;
	if (g_once_init_enter (&taquin_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaquinViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) taquin_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaquinView), 0, (GInstanceInitFunc) taquin_view_instance_init, NULL };
		GType taquin_view_type_id;
		taquin_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "TaquinView", &g_define_type_info, 0);
		TaquinView_private_offset = g_type_add_instance_private (taquin_view_type_id, sizeof (TaquinViewPrivate));
		g_once_init_leave (&taquin_view_type_id__volatile, taquin_view_type_id);
	}
	return taquin_view_type_id__volatile;
}

static void
_vala_taquin_view_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAQUIN_VIEW, TaquinView);
	switch (property_id) {
		case TAQUIN_VIEW_GAME_PROPERTY:
		g_value_set_object (value, taquin_view_get_game (self));
		break;
		case TAQUIN_VIEW_THEME_PROPERTY:
		g_value_set_string (value, taquin_view_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_taquin_view_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAQUIN_VIEW, TaquinView);
	switch (property_id) {
		case TAQUIN_VIEW_GAME_PROPERTY:
		taquin_view_set_game (self, g_value_get_object (value));
		break;
		case TAQUIN_VIEW_THEME_PROPERTY:
		taquin_view_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

