/* taquin-game.c generated by valac 0.42.1.36-3777c, the Vala compiler
 * generated from taquin-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014-2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

#define TYPE_GAME_TYPE (game_type_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define GAME_TYPE_UNDO_ITEM (game_undo_item_get_type ())
typedef struct _GameUndoItem GameUndoItem;
enum  {
	GAME_0_PROPERTY,
	GAME_SIZE_PROPERTY,
	GAME_GAME_TYPE_PROPERTY,
	GAME_NUM_PROPERTIES
};
static GParamSpec* game_properties[GAME_NUM_PROPERTIES];
#define _game_undo_item_free0(var) ((var == NULL) ? NULL : (var = (game_undo_item_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
enum  {
	GAME_COMPLETE_SIGNAL,
	GAME_MOVE_SIGNAL,
	GAME_EMPTY_TILE_SIGNAL,
	GAME_CANNOT_MOVE_SIGNAL,
	GAME_CANNOT_UNDO_MORE_SIGNAL,
	GAME_NUM_SIGNALS
};
static guint game_signals[GAME_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GameUndoItem {
	gint x;
	gint y;
	GameUndoItem* next;
	GameUndoItem* previous;
};

struct _GamePrivate {
	gint* _tiles;
	gint _tiles_length1;
	gint _tiles_length2;
	gint _size;
	GameType _game_type;
	GameUndoItem* state;
	GameUndoItem* previous_state;
	gint x_gap;
	gint y_gap;
};

static gint Game_private_offset;
static gpointer game_parent_class = NULL;

GType game_type_get_type (void) G_GNUC_CONST;
gchar* game_type_to_string (GameType self);
GType game_get_type (void) G_GNUC_CONST;
static GType game_undo_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GameUndoItem* game_undo_item_dup (const GameUndoItem* self);
static void game_undo_item_free (GameUndoItem* self);
static void game_undo_item_copy (const GameUndoItem* self,
                          GameUndoItem* dest);
static void game_undo_item_destroy (GameUndoItem* self);
Game* game_new (GameType game_type,
                gint size);
Game* game_construct (GType object_type,
                      GameType game_type,
                      gint size);
static void game_set_size (Game* self,
                    gint value);
static void game_set_game_type (Game* self,
                         GameType value);
static void game_set_tiles (Game* self,
                     gint* value,
                     gint value_length1,
                     gint value_length2);
static gint* _int_dup (gint* self);
gint* game_get_tiles (Game* self,
                      gint* result_length1,
                      gint* result_length2);
gchar* game_to_string (Game* self);
gint game_get_size (Game* self);
void game_request_move (Game* self,
                        gint x,
                        gint y);
GameType game_get_game_type (Game* self);
static void game_fifteen_move (Game* self,
                        gint x,
                        gint y,
                        gboolean undoing);
static void game_sixteen_move (Game* self,
                        gint x,
                        gint y,
                        gboolean undoing);
static void game_add_move (Game* self,
                    gint x_gap,
                    gint y_gap);
static void game_check_complete (Game* self);
void game_undo (Game* self);
static gint* _vala_array_dup1 (gint* self,
                        int length);
static void g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void game_finalize (GObject * obj);
static void _vala_game_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_game_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

gchar*
game_type_to_string (GameType self)
{
	gchar* result = NULL;
	switch (self) {
		case GAME_TYPE_FIFTEEN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("fifteen");
			result = _tmp0_;
			return result;
		}
		case GAME_TYPE_SIXTEEN:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("sixteen");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GType
game_type_get_type (void)
{
	static volatile gsize game_type_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_TYPE_FIFTEEN, "GAME_TYPE_FIFTEEN", "fifteen"}, {GAME_TYPE_SIXTEEN, "GAME_TYPE_SIXTEEN", "sixteen"}, {0, NULL, NULL}};
		GType game_type_type_id;
		game_type_type_id = g_enum_register_static ("GameType", values);
		g_once_init_leave (&game_type_type_id__volatile, game_type_type_id);
	}
	return game_type_type_id__volatile;
}

static inline gpointer
game_get_instance_private (Game* self)
{
	return G_STRUCT_MEMBER_P (self, Game_private_offset);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

Game*
game_construct (GType object_type,
                GameType game_type,
                gint size)
{
	Game * self = NULL;
	gint* _tmp0_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	gint ntiles = 0;
	gint** line = NULL;
	gint** _tmp2_;
	gint line_length1;
	gint _line_size_;
	gint i = 0;
	gboolean parity_grid = FALSE;
	gboolean parity_game = FALSE;
	_vala_return_val_if_fail (size >= 2, "size >= 2", NULL);
	self = (Game*) g_object_new (object_type, NULL);
	game_set_size (self, size);
	game_set_game_type (self, game_type);
	_tmp0_ = g_new0 (gint, size * size);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = size;
	_tmp1__length2 = size;
	game_set_tiles (self, _tmp1_, size, size);
	_tmp1_ = (g_free (_tmp1_), NULL);
	ntiles = size * size;
	_tmp2_ = g_new0 (gint*, ntiles);
	line = _tmp2_;
	line_length1 = ntiles;
	_line_size_ = line_length1;
	i = 0;
	{
		gint n = 0;
		n = ntiles - 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint** _tmp8_;
				gint _tmp8__length1;
				gint* _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = n;
					n = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				if (!(n >= 0)) {
					break;
				}
				{
					gboolean _tmp5_ = FALSE;
					_tmp5_ = TRUE;
					while (TRUE) {
						if (!_tmp5_) {
							gint** _tmp6_;
							gint _tmp6__length1;
							gint* _tmp7_;
							_tmp6_ = line;
							_tmp6__length1 = line_length1;
							_tmp7_ = _tmp6_[i];
							if (!(_tmp7_ != NULL)) {
								break;
							}
						}
						_tmp5_ = FALSE;
						i = (gint) g_random_int_range ((gint32) 0, (gint32) ntiles);
					}
				}
				_tmp8_ = line;
				_tmp8__length1 = line_length1;
				_tmp9_ = __int_dup0 (&n);
				_g_free0 (_tmp8_[i]);
				_tmp8_[i] = _tmp9_;
			}
		}
	}
	if (game_type == GAME_TYPE_FIFTEEN) {
		gint** _tmp10_;
		gint _tmp10__length1;
		gint** _tmp11_;
		gint _tmp11__length1;
		gint* _tmp12_;
		gint* _tmp13_;
		gint** _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		gint* _tmp16_;
		_tmp10_ = line;
		_tmp10__length1 = line_length1;
		_tmp11_ = line;
		_tmp11__length1 = line_length1;
		_tmp12_ = _tmp11_[0];
		_tmp13_ = __int_dup0 (_tmp12_);
		_g_free0 (_tmp10_[i]);
		_tmp10_[i] = _tmp13_;
		_tmp14_ = line;
		_tmp14__length1 = line_length1;
		_tmp15_ = -1;
		_tmp16_ = __int_dup0 (&_tmp15_);
		_g_free0 (_tmp14_[0]);
		_tmp14_[0] = _tmp16_;
		self->priv->x_gap = 0;
		self->priv->y_gap = 0;
	}
	parity_grid = ((gboolean) ((size % 2) ^ (size % 2))) & (1 == 0);
	parity_game = FALSE;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = j;
					j = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(j < (ntiles - 1))) {
					break;
				}
				{
					gint k = 0;
					k = j + 1;
					{
						gboolean _tmp19_ = FALSE;
						_tmp19_ = TRUE;
						while (TRUE) {
							gint** _tmp21_;
							gint _tmp21__length1;
							gint* _tmp22_;
							gint** _tmp23_;
							gint _tmp23__length1;
							gint* _tmp24_;
							if (!_tmp19_) {
								gint _tmp20_;
								_tmp20_ = k;
								k = _tmp20_ + 1;
							}
							_tmp19_ = FALSE;
							if (!(k < ntiles)) {
								break;
							}
							_tmp21_ = line;
							_tmp21__length1 = line_length1;
							_tmp22_ = _tmp21_[j];
							_tmp23_ = line;
							_tmp23__length1 = line_length1;
							_tmp24_ = _tmp23_[k];
							if ((*_tmp22_) > (*_tmp24_)) {
								parity_game = !parity_game;
							}
						}
					}
				}
			}
		}
	}
	if (parity_game != parity_grid) {
		gint* save = NULL;
		gint** _tmp25_;
		gint _tmp25__length1;
		gint* _tmp26_;
		gint* _tmp27_;
		gint** _tmp28_;
		gint _tmp28__length1;
		gint** _tmp29_;
		gint _tmp29__length1;
		gint* _tmp30_;
		gint* _tmp31_;
		gint** _tmp32_;
		gint _tmp32__length1;
		gint* _tmp33_;
		gint* _tmp34_;
		_tmp25_ = line;
		_tmp25__length1 = line_length1;
		_tmp26_ = _tmp25_[1];
		_tmp27_ = __int_dup0 (_tmp26_);
		save = _tmp27_;
		_tmp28_ = line;
		_tmp28__length1 = line_length1;
		_tmp29_ = line;
		_tmp29__length1 = line_length1;
		_tmp30_ = _tmp29_[size + 1];
		_tmp31_ = __int_dup0 (_tmp30_);
		_g_free0 (_tmp28_[1]);
		_tmp28_[1] = _tmp31_;
		_tmp32_ = line;
		_tmp32__length1 = line_length1;
		_tmp33_ = save;
		_tmp34_ = __int_dup0 (_tmp33_);
		_g_free0 (_tmp32_[size + 1]);
		_tmp32_[size + 1] = _tmp34_;
		_g_free0 (save);
	}
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp35_ = FALSE;
			_tmp35_ = TRUE;
			while (TRUE) {
				gint* _tmp37_;
				gint _tmp37__length1;
				gint _tmp37__length2;
				gint* _tmp38_;
				gint _tmp38__length1;
				gint _tmp38__length2;
				gint** _tmp39_;
				gint _tmp39__length1;
				gint* _tmp40_;
				if (!_tmp35_) {
					gint _tmp36_;
					_tmp36_ = j;
					j = _tmp36_ + 1;
				}
				_tmp35_ = FALSE;
				if (!(j < ntiles)) {
					break;
				}
				_tmp37_ = game_get_tiles (self, &_tmp37__length1, &_tmp37__length2);
				_tmp38_ = _tmp37_;
				_tmp38__length1 = _tmp37__length1;
				_tmp38__length2 = _tmp37__length2;
				_tmp39_ = line;
				_tmp39__length1 = line_length1;
				_tmp40_ = _tmp39_[j];
				_tmp38_[((j % size) * _tmp38__length2) + (j / size)] = *_tmp40_;
			}
		}
	}
	line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

Game*
game_new (GameType game_type,
          gint size)
{
	return game_construct (TYPE_GAME, game_type, size);
}

gchar*
game_to_string (Game* self)
{
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\n");
	s = _tmp0_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_size;
				if (!(x < _tmp3_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							const gchar* _tmp7_;
							gint* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							gint* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							gint _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = y;
								y = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = self->priv->_size;
							if (!(y < _tmp6_)) {
								break;
							}
							_tmp7_ = s;
							_tmp8_ = game_get_tiles (self, &_tmp8__length1, &_tmp8__length2);
							_tmp9_ = _tmp8_;
							_tmp9__length1 = _tmp8__length1;
							_tmp9__length2 = _tmp8__length2;
							_tmp10_ = _tmp9_[(y * _tmp9__length2) + x];
							_tmp11_ = g_strdup_printf ("%i", _tmp10_ + 1);
							_tmp12_ = _tmp11_;
							_tmp13_ = g_strconcat (" ", _tmp12_, NULL);
							_tmp14_ = _tmp13_;
							_tmp15_ = g_strconcat (_tmp7_, _tmp14_, NULL);
							_g_free0 (s);
							s = _tmp15_;
							_g_free0 (_tmp14_);
							_g_free0 (_tmp12_);
						}
					}
				}
				_tmp16_ = s;
				_tmp17_ = g_strconcat (_tmp16_, "\n", NULL);
				_g_free0 (s);
				s = _tmp17_;
			}
		}
	}
	result = s;
	return result;
}

void
game_request_move (Game* self,
                   gint x,
                   gint y)
{
	GameType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game_type;
	if (_tmp0_ == GAME_TYPE_FIFTEEN) {
		game_fifteen_move (self, x, y, FALSE);
	} else {
		game_sixteen_move (self, x, y, FALSE);
	}
}

static void
game_fifteen_move (Game* self,
                   gint x,
                   gint y,
                   gboolean undoing)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean move_x_axis = FALSE;
	gint _tmp7_ = 0;
	gint move_number = 0;
	gint* _tmp36_;
	gint _tmp36__length1;
	gint _tmp36__length2;
	gint* _tmp37_;
	gint _tmp37__length1;
	gint _tmp37__length2;
	g_return_if_fail (self != NULL);
	if (x < 0) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp3_;
		_tmp3_ = self->priv->_size;
		_tmp2_ = x >= _tmp3_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = y < 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = self->priv->_size;
		_tmp0_ = y >= _tmp4_;
	}
	if (_tmp0_) {
		return;
	}
	if (x == self->priv->x_gap) {
		_tmp5_ = y == self->priv->y_gap;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		g_signal_emit (self, game_signals[GAME_EMPTY_TILE_SIGNAL], 0);
		return;
	}
	if (x != self->priv->x_gap) {
		_tmp6_ = y != self->priv->y_gap;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		g_signal_emit (self, game_signals[GAME_CANNOT_MOVE_SIGNAL], 0, x, y);
		return;
	}
	move_x_axis = x != self->priv->x_gap;
	if (move_x_axis) {
		_tmp7_ = self->priv->x_gap - x;
	} else {
		_tmp7_ = self->priv->y_gap - y;
	}
	move_number = _tmp7_;
	if (!undoing) {
		game_add_move (self, self->priv->x_gap, self->priv->y_gap);
	}
	if (move_x_axis) {
		if (x < self->priv->x_gap) {
			{
				gboolean _tmp8_ = FALSE;
				_tmp8_ = TRUE;
				while (TRUE) {
					gint* _tmp9_;
					gint _tmp9__length1;
					gint _tmp9__length2;
					gint* _tmp10_;
					gint _tmp10__length1;
					gint _tmp10__length2;
					gint* _tmp11_;
					gint _tmp11__length1;
					gint _tmp11__length2;
					gint* _tmp12_;
					gint _tmp12__length1;
					gint _tmp12__length2;
					gint _tmp13_;
					gint _tmp14_;
					if (!_tmp8_) {
						if (!(self->priv->x_gap != x)) {
							break;
						}
					}
					_tmp8_ = FALSE;
					_tmp9_ = game_get_tiles (self, &_tmp9__length1, &_tmp9__length2);
					_tmp10_ = _tmp9_;
					_tmp10__length1 = _tmp9__length1;
					_tmp10__length2 = _tmp9__length2;
					_tmp11_ = game_get_tiles (self, &_tmp11__length1, &_tmp11__length2);
					_tmp12_ = _tmp11_;
					_tmp12__length1 = _tmp11__length1;
					_tmp12__length2 = _tmp11__length2;
					_tmp13_ = _tmp12_[((self->priv->x_gap - 1) * _tmp12__length2) + y];
					_tmp10_[(self->priv->x_gap * _tmp10__length2) + y] = _tmp13_;
					_tmp14_ = self->priv->x_gap;
					self->priv->x_gap = _tmp14_ - 1;
				}
			}
		} else {
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					gint* _tmp16_;
					gint _tmp16__length1;
					gint _tmp16__length2;
					gint* _tmp17_;
					gint _tmp17__length1;
					gint _tmp17__length2;
					gint* _tmp18_;
					gint _tmp18__length1;
					gint _tmp18__length2;
					gint* _tmp19_;
					gint _tmp19__length1;
					gint _tmp19__length2;
					gint _tmp20_;
					gint _tmp21_;
					if (!_tmp15_) {
						if (!(self->priv->x_gap != x)) {
							break;
						}
					}
					_tmp15_ = FALSE;
					_tmp16_ = game_get_tiles (self, &_tmp16__length1, &_tmp16__length2);
					_tmp17_ = _tmp16_;
					_tmp17__length1 = _tmp16__length1;
					_tmp17__length2 = _tmp16__length2;
					_tmp18_ = game_get_tiles (self, &_tmp18__length1, &_tmp18__length2);
					_tmp19_ = _tmp18_;
					_tmp19__length1 = _tmp18__length1;
					_tmp19__length2 = _tmp18__length2;
					_tmp20_ = _tmp19_[((self->priv->x_gap + 1) * _tmp19__length2) + y];
					_tmp17_[(self->priv->x_gap * _tmp17__length2) + y] = _tmp20_;
					_tmp21_ = self->priv->x_gap;
					self->priv->x_gap = _tmp21_ + 1;
				}
			}
		}
	} else {
		if (y < self->priv->y_gap) {
			{
				gboolean _tmp22_ = FALSE;
				_tmp22_ = TRUE;
				while (TRUE) {
					gint* _tmp23_;
					gint _tmp23__length1;
					gint _tmp23__length2;
					gint* _tmp24_;
					gint _tmp24__length1;
					gint _tmp24__length2;
					gint* _tmp25_;
					gint _tmp25__length1;
					gint _tmp25__length2;
					gint* _tmp26_;
					gint _tmp26__length1;
					gint _tmp26__length2;
					gint _tmp27_;
					gint _tmp28_;
					if (!_tmp22_) {
						if (!(self->priv->y_gap != y)) {
							break;
						}
					}
					_tmp22_ = FALSE;
					_tmp23_ = game_get_tiles (self, &_tmp23__length1, &_tmp23__length2);
					_tmp24_ = _tmp23_;
					_tmp24__length1 = _tmp23__length1;
					_tmp24__length2 = _tmp23__length2;
					_tmp25_ = game_get_tiles (self, &_tmp25__length1, &_tmp25__length2);
					_tmp26_ = _tmp25_;
					_tmp26__length1 = _tmp25__length1;
					_tmp26__length2 = _tmp25__length2;
					_tmp27_ = _tmp26_[(x * _tmp26__length2) + (self->priv->y_gap - 1)];
					_tmp24_[(x * _tmp24__length2) + self->priv->y_gap] = _tmp27_;
					_tmp28_ = self->priv->y_gap;
					self->priv->y_gap = _tmp28_ - 1;
				}
			}
		} else {
			{
				gboolean _tmp29_ = FALSE;
				_tmp29_ = TRUE;
				while (TRUE) {
					gint* _tmp30_;
					gint _tmp30__length1;
					gint _tmp30__length2;
					gint* _tmp31_;
					gint _tmp31__length1;
					gint _tmp31__length2;
					gint* _tmp32_;
					gint _tmp32__length1;
					gint _tmp32__length2;
					gint* _tmp33_;
					gint _tmp33__length1;
					gint _tmp33__length2;
					gint _tmp34_;
					gint _tmp35_;
					if (!_tmp29_) {
						if (!(self->priv->y_gap != y)) {
							break;
						}
					}
					_tmp29_ = FALSE;
					_tmp30_ = game_get_tiles (self, &_tmp30__length1, &_tmp30__length2);
					_tmp31_ = _tmp30_;
					_tmp31__length1 = _tmp30__length1;
					_tmp31__length2 = _tmp30__length2;
					_tmp32_ = game_get_tiles (self, &_tmp32__length1, &_tmp32__length2);
					_tmp33_ = _tmp32_;
					_tmp33__length1 = _tmp32__length1;
					_tmp33__length2 = _tmp32__length2;
					_tmp34_ = _tmp33_[(x * _tmp33__length2) + (self->priv->y_gap + 1)];
					_tmp31_[(x * _tmp31__length2) + self->priv->y_gap] = _tmp34_;
					_tmp35_ = self->priv->y_gap;
					self->priv->y_gap = _tmp35_ + 1;
				}
			}
		}
	}
	_tmp36_ = game_get_tiles (self, &_tmp36__length1, &_tmp36__length2);
	_tmp37_ = _tmp36_;
	_tmp37__length1 = _tmp36__length1;
	_tmp37__length2 = _tmp36__length2;
	_tmp37_[(self->priv->x_gap * _tmp37__length2) + self->priv->y_gap] = -1;
	g_signal_emit (self, game_signals[GAME_MOVE_SIGNAL], 0, move_x_axis, move_number, self->priv->x_gap, self->priv->y_gap);
	game_check_complete (self);
}

static void
game_sixteen_move (Game* self,
                   gint x,
                   gint y,
                   gboolean undoing)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean move_x_axis = FALSE;
	gboolean _tmp5_ = FALSE;
	gint new_coord = 0;
	gint _tmp75_ = 0;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	g_return_if_fail (self != NULL);
	if (x >= 0) {
		gint _tmp3_;
		_tmp3_ = self->priv->_size;
		_tmp2_ = x < _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = y >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp4_;
		_tmp4_ = self->priv->_size;
		_tmp0_ = y < _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	move_x_axis = FALSE;
	if (x < 0) {
		_tmp5_ = TRUE;
	} else {
		gint _tmp6_;
		_tmp6_ = self->priv->_size;
		_tmp5_ = x >= _tmp6_;
	}
	if (_tmp5_) {
		gboolean _tmp7_ = FALSE;
		if (y < 0) {
			_tmp7_ = TRUE;
		} else {
			gint _tmp8_;
			_tmp8_ = self->priv->_size;
			_tmp7_ = y >= _tmp8_;
		}
		if (_tmp7_) {
			return;
		} else {
			move_x_axis = TRUE;
		}
	} else {
		gboolean _tmp9_ = FALSE;
		if (y >= 0) {
			gint _tmp10_;
			_tmp10_ = self->priv->_size;
			_tmp9_ = y < _tmp10_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			return;
		}
	}
	new_coord = 0;
	if (move_x_axis) {
		if (x < 0) {
			gint tmp = 0;
			gint* _tmp11_;
			gint _tmp11__length1;
			gint _tmp11__length2;
			gint* _tmp12_;
			gint _tmp12__length1;
			gint _tmp12__length2;
			gint _tmp13_;
			gint* _tmp22_;
			gint _tmp22__length1;
			gint _tmp22__length2;
			gint* _tmp23_;
			gint _tmp23__length1;
			gint _tmp23__length2;
			gint _tmp24_;
			gint _tmp25_;
			_tmp11_ = game_get_tiles (self, &_tmp11__length1, &_tmp11__length2);
			_tmp12_ = _tmp11_;
			_tmp12__length1 = _tmp11__length1;
			_tmp12__length2 = _tmp11__length2;
			_tmp13_ = _tmp12_[(0 * _tmp12__length2) + y];
			tmp = _tmp13_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp14_ = FALSE;
					_tmp14_ = TRUE;
					while (TRUE) {
						gint _tmp16_;
						gint* _tmp17_;
						gint _tmp17__length1;
						gint _tmp17__length2;
						gint* _tmp18_;
						gint _tmp18__length1;
						gint _tmp18__length2;
						gint* _tmp19_;
						gint _tmp19__length1;
						gint _tmp19__length2;
						gint* _tmp20_;
						gint _tmp20__length1;
						gint _tmp20__length2;
						gint _tmp21_;
						if (!_tmp14_) {
							gint _tmp15_;
							_tmp15_ = i;
							i = _tmp15_ + 1;
						}
						_tmp14_ = FALSE;
						_tmp16_ = self->priv->_size;
						if (!(i < (_tmp16_ - 1))) {
							break;
						}
						_tmp17_ = game_get_tiles (self, &_tmp17__length1, &_tmp17__length2);
						_tmp18_ = _tmp17_;
						_tmp18__length1 = _tmp17__length1;
						_tmp18__length2 = _tmp17__length2;
						_tmp19_ = game_get_tiles (self, &_tmp19__length1, &_tmp19__length2);
						_tmp20_ = _tmp19_;
						_tmp20__length1 = _tmp19__length1;
						_tmp20__length2 = _tmp19__length2;
						_tmp21_ = _tmp20_[((i + 1) * _tmp20__length2) + y];
						_tmp18_[(i * _tmp18__length2) + y] = _tmp21_;
					}
				}
			}
			_tmp22_ = game_get_tiles (self, &_tmp22__length1, &_tmp22__length2);
			_tmp23_ = _tmp22_;
			_tmp23__length1 = _tmp22__length1;
			_tmp23__length2 = _tmp22__length2;
			_tmp24_ = self->priv->_size;
			_tmp23_[((_tmp24_ - 1) * _tmp23__length2) + y] = tmp;
			_tmp25_ = self->priv->_size;
			new_coord = _tmp25_ - 1;
		} else {
			gint tmp = 0;
			gint* _tmp26_;
			gint _tmp26__length1;
			gint _tmp26__length2;
			gint* _tmp27_;
			gint _tmp27__length1;
			gint _tmp27__length2;
			gint _tmp28_;
			gint _tmp29_;
			gint* _tmp38_;
			gint _tmp38__length1;
			gint _tmp38__length2;
			gint* _tmp39_;
			gint _tmp39__length1;
			gint _tmp39__length2;
			_tmp26_ = game_get_tiles (self, &_tmp26__length1, &_tmp26__length2);
			_tmp27_ = _tmp26_;
			_tmp27__length1 = _tmp26__length1;
			_tmp27__length2 = _tmp26__length2;
			_tmp28_ = self->priv->_size;
			_tmp29_ = _tmp27_[((_tmp28_ - 1) * _tmp27__length2) + y];
			tmp = _tmp29_;
			{
				gint i = 0;
				gint _tmp30_;
				_tmp30_ = self->priv->_size;
				i = _tmp30_ - 1;
				{
					gboolean _tmp31_ = FALSE;
					_tmp31_ = TRUE;
					while (TRUE) {
						gint* _tmp33_;
						gint _tmp33__length1;
						gint _tmp33__length2;
						gint* _tmp34_;
						gint _tmp34__length1;
						gint _tmp34__length2;
						gint* _tmp35_;
						gint _tmp35__length1;
						gint _tmp35__length2;
						gint* _tmp36_;
						gint _tmp36__length1;
						gint _tmp36__length2;
						gint _tmp37_;
						if (!_tmp31_) {
							gint _tmp32_;
							_tmp32_ = i;
							i = _tmp32_ - 1;
						}
						_tmp31_ = FALSE;
						if (!(i > 0)) {
							break;
						}
						_tmp33_ = game_get_tiles (self, &_tmp33__length1, &_tmp33__length2);
						_tmp34_ = _tmp33_;
						_tmp34__length1 = _tmp33__length1;
						_tmp34__length2 = _tmp33__length2;
						_tmp35_ = game_get_tiles (self, &_tmp35__length1, &_tmp35__length2);
						_tmp36_ = _tmp35_;
						_tmp36__length1 = _tmp35__length1;
						_tmp36__length2 = _tmp35__length2;
						_tmp37_ = _tmp36_[((i - 1) * _tmp36__length2) + y];
						_tmp34_[(i * _tmp34__length2) + y] = _tmp37_;
					}
				}
			}
			_tmp38_ = game_get_tiles (self, &_tmp38__length1, &_tmp38__length2);
			_tmp39_ = _tmp38_;
			_tmp39__length1 = _tmp38__length1;
			_tmp39__length2 = _tmp38__length2;
			_tmp39_[(0 * _tmp39__length2) + y] = tmp;
			new_coord = 0;
		}
	} else {
		if (y < 0) {
			gint tmp = 0;
			gint* _tmp40_;
			gint _tmp40__length1;
			gint _tmp40__length2;
			gint* _tmp41_;
			gint _tmp41__length1;
			gint _tmp41__length2;
			gint _tmp42_;
			gint* _tmp51_;
			gint _tmp51__length1;
			gint _tmp51__length2;
			gint* _tmp52_;
			gint _tmp52__length1;
			gint _tmp52__length2;
			gint _tmp53_;
			gint _tmp54_;
			_tmp40_ = game_get_tiles (self, &_tmp40__length1, &_tmp40__length2);
			_tmp41_ = _tmp40_;
			_tmp41__length1 = _tmp40__length1;
			_tmp41__length2 = _tmp40__length2;
			_tmp42_ = _tmp41_[(x * _tmp41__length2) + 0];
			tmp = _tmp42_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp43_ = FALSE;
					_tmp43_ = TRUE;
					while (TRUE) {
						gint _tmp45_;
						gint* _tmp46_;
						gint _tmp46__length1;
						gint _tmp46__length2;
						gint* _tmp47_;
						gint _tmp47__length1;
						gint _tmp47__length2;
						gint* _tmp48_;
						gint _tmp48__length1;
						gint _tmp48__length2;
						gint* _tmp49_;
						gint _tmp49__length1;
						gint _tmp49__length2;
						gint _tmp50_;
						if (!_tmp43_) {
							gint _tmp44_;
							_tmp44_ = i;
							i = _tmp44_ + 1;
						}
						_tmp43_ = FALSE;
						_tmp45_ = self->priv->_size;
						if (!(i < (_tmp45_ - 1))) {
							break;
						}
						_tmp46_ = game_get_tiles (self, &_tmp46__length1, &_tmp46__length2);
						_tmp47_ = _tmp46_;
						_tmp47__length1 = _tmp46__length1;
						_tmp47__length2 = _tmp46__length2;
						_tmp48_ = game_get_tiles (self, &_tmp48__length1, &_tmp48__length2);
						_tmp49_ = _tmp48_;
						_tmp49__length1 = _tmp48__length1;
						_tmp49__length2 = _tmp48__length2;
						_tmp50_ = _tmp49_[(x * _tmp49__length2) + (i + 1)];
						_tmp47_[(x * _tmp47__length2) + i] = _tmp50_;
					}
				}
			}
			_tmp51_ = game_get_tiles (self, &_tmp51__length1, &_tmp51__length2);
			_tmp52_ = _tmp51_;
			_tmp52__length1 = _tmp51__length1;
			_tmp52__length2 = _tmp51__length2;
			_tmp53_ = self->priv->_size;
			_tmp52_[(x * _tmp52__length2) + (_tmp53_ - 1)] = tmp;
			_tmp54_ = self->priv->_size;
			new_coord = _tmp54_ - 1;
		} else {
			gint tmp = 0;
			gint* _tmp55_;
			gint _tmp55__length1;
			gint _tmp55__length2;
			gint* _tmp56_;
			gint _tmp56__length1;
			gint _tmp56__length2;
			gint _tmp57_;
			gint _tmp58_;
			gint* _tmp67_;
			gint _tmp67__length1;
			gint _tmp67__length2;
			gint* _tmp68_;
			gint _tmp68__length1;
			gint _tmp68__length2;
			_tmp55_ = game_get_tiles (self, &_tmp55__length1, &_tmp55__length2);
			_tmp56_ = _tmp55_;
			_tmp56__length1 = _tmp55__length1;
			_tmp56__length2 = _tmp55__length2;
			_tmp57_ = self->priv->_size;
			_tmp58_ = _tmp56_[(x * _tmp56__length2) + (_tmp57_ - 1)];
			tmp = _tmp58_;
			{
				gint i = 0;
				gint _tmp59_;
				_tmp59_ = self->priv->_size;
				i = _tmp59_ - 1;
				{
					gboolean _tmp60_ = FALSE;
					_tmp60_ = TRUE;
					while (TRUE) {
						gint* _tmp62_;
						gint _tmp62__length1;
						gint _tmp62__length2;
						gint* _tmp63_;
						gint _tmp63__length1;
						gint _tmp63__length2;
						gint* _tmp64_;
						gint _tmp64__length1;
						gint _tmp64__length2;
						gint* _tmp65_;
						gint _tmp65__length1;
						gint _tmp65__length2;
						gint _tmp66_;
						if (!_tmp60_) {
							gint _tmp61_;
							_tmp61_ = i;
							i = _tmp61_ - 1;
						}
						_tmp60_ = FALSE;
						if (!(i > 0)) {
							break;
						}
						_tmp62_ = game_get_tiles (self, &_tmp62__length1, &_tmp62__length2);
						_tmp63_ = _tmp62_;
						_tmp63__length1 = _tmp62__length1;
						_tmp63__length2 = _tmp62__length2;
						_tmp64_ = game_get_tiles (self, &_tmp64__length1, &_tmp64__length2);
						_tmp65_ = _tmp64_;
						_tmp65__length1 = _tmp64__length1;
						_tmp65__length2 = _tmp64__length2;
						_tmp66_ = _tmp65_[(x * _tmp65__length2) + (i - 1)];
						_tmp63_[(x * _tmp63__length2) + i] = _tmp66_;
					}
				}
			}
			_tmp67_ = game_get_tiles (self, &_tmp67__length1, &_tmp67__length2);
			_tmp68_ = _tmp67_;
			_tmp68__length1 = _tmp67__length1;
			_tmp68__length2 = _tmp67__length2;
			_tmp68_[(x * _tmp68__length2) + 0] = tmp;
			new_coord = 0;
		}
	}
	if (!undoing) {
		gint _tmp69_ = 0;
		gint _tmp72_ = 0;
		if (move_x_axis) {
			gint _tmp70_ = 0;
			if (new_coord == 0) {
				_tmp70_ = -1;
			} else {
				gint _tmp71_;
				_tmp71_ = self->priv->_size;
				_tmp70_ = _tmp71_;
			}
			_tmp69_ = _tmp70_;
		} else {
			_tmp69_ = x;
		}
		if (move_x_axis) {
			_tmp72_ = y;
		} else {
			gint _tmp73_ = 0;
			if (new_coord == 0) {
				_tmp73_ = -1;
			} else {
				gint _tmp74_;
				_tmp74_ = self->priv->_size;
				_tmp73_ = _tmp74_;
			}
			_tmp72_ = _tmp73_;
		}
		game_add_move (self, _tmp69_, _tmp72_);
	}
	if (new_coord == 0) {
		gint _tmp76_;
		_tmp76_ = self->priv->_size;
		_tmp75_ = _tmp76_ - 1;
	} else {
		gint _tmp77_;
		_tmp77_ = self->priv->_size;
		_tmp75_ = 1 - _tmp77_;
	}
	if (move_x_axis) {
		_tmp78_ = new_coord;
	} else {
		_tmp78_ = x;
	}
	if (move_x_axis) {
		_tmp79_ = y;
	} else {
		_tmp79_ = new_coord;
	}
	g_signal_emit (self, game_signals[GAME_MOVE_SIGNAL], 0, move_x_axis, _tmp75_, _tmp78_, _tmp79_);
	game_check_complete (self);
}

static void
game_check_complete (Game* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gint* _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				gint* _tmp5_;
				gint _tmp5__length1;
				gint _tmp5__length2;
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_size;
				_tmp3_ = self->priv->_size;
				if (!(i < (_tmp2_ * _tmp3_))) {
					break;
				}
				_tmp4_ = game_get_tiles (self, &_tmp4__length1, &_tmp4__length2);
				_tmp5_ = _tmp4_;
				_tmp5__length1 = _tmp4__length1;
				_tmp5__length2 = _tmp4__length2;
				_tmp6_ = self->priv->_size;
				_tmp7_ = self->priv->_size;
				_tmp8_ = _tmp5_[((i % _tmp6_) * _tmp5__length2) + (i / _tmp7_)];
				if (i != _tmp8_) {
					return;
				}
			}
		}
	}
	g_signal_emit (self, game_signals[GAME_COMPLETE_SIGNAL], 0);
}

static gpointer
_game_undo_item_dup0 (gpointer self)
{
	return self ? game_undo_item_dup (self) : NULL;
}

void
game_undo (Game* self)
{
	GameUndoItem* _tmp0_;
	GameType _tmp1_;
	GameUndoItem* _tmp6_;
	GameUndoItem* _tmp7_;
	GameUndoItem* _tmp8_ = NULL;
	GameUndoItem* _tmp9_;
	GameUndoItem* _tmp12_;
	GameUndoItem* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_game_type;
	if (_tmp1_ == GAME_TYPE_FIFTEEN) {
		GameUndoItem* _tmp2_;
		GameUndoItem* _tmp3_;
		_tmp2_ = self->priv->state;
		_tmp3_ = self->priv->state;
		game_fifteen_move (self, (*_tmp2_).x, (*_tmp3_).y, TRUE);
	} else {
		GameUndoItem* _tmp4_;
		GameUndoItem* _tmp5_;
		_tmp4_ = self->priv->state;
		_tmp5_ = self->priv->state;
		game_sixteen_move (self, (*_tmp4_).x, (*_tmp5_).y, TRUE);
	}
	_tmp6_ = self->priv->previous_state;
	_tmp7_ = _game_undo_item_dup0 (_tmp6_);
	_game_undo_item_free0 (self->priv->state);
	self->priv->state = _tmp7_;
	_tmp9_ = self->priv->state;
	if (_tmp9_ == NULL) {
		_tmp8_ = NULL;
	} else {
		GameUndoItem* _tmp10_;
		GameUndoItem* _tmp11_;
		_tmp10_ = self->priv->state;
		_tmp11_ = (*_tmp10_).previous;
		_tmp8_ = _tmp11_;
	}
	_tmp12_ = _game_undo_item_dup0 (_tmp8_);
	_game_undo_item_free0 (self->priv->previous_state);
	self->priv->previous_state = _tmp12_;
	_tmp13_ = self->priv->state;
	if (_tmp13_ == NULL) {
		g_signal_emit (self, game_signals[GAME_CANNOT_UNDO_MORE_SIGNAL], 0);
	}
}

static void
game_add_move (Game* self,
               gint x_gap,
               gint y_gap)
{
	GameUndoItem* _tmp0_ = NULL;
	GameUndoItem* _tmp1_;
	GameUndoItem* _tmp3_;
	GameUndoItem* _tmp4_;
	GameUndoItem* _tmp5_;
	GameUndoItem _tmp6_ = {0};
	GameUndoItem _tmp7_;
	GameUndoItem* _tmp8_;
	GameUndoItem* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->state;
	if (_tmp1_ == NULL) {
		_tmp0_ = NULL;
	} else {
		GameUndoItem* _tmp2_;
		_tmp2_ = self->priv->state;
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _game_undo_item_dup0 (_tmp0_);
	_game_undo_item_free0 (self->priv->previous_state);
	self->priv->previous_state = _tmp3_;
	_tmp4_ = self->priv->previous_state;
	_tmp5_ = _game_undo_item_dup0 (_tmp4_);
	memset (&_tmp6_, 0, sizeof (GameUndoItem));
	_tmp6_.x = x_gap;
	_tmp6_.y = y_gap;
	_game_undo_item_free0 (_tmp6_.next);
	_tmp6_.next = NULL;
	_game_undo_item_free0 (_tmp6_.previous);
	_tmp6_.previous = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = _game_undo_item_dup0 (&_tmp7_);
	_game_undo_item_free0 (self->priv->state);
	self->priv->state = _tmp8_;
	game_undo_item_destroy (&_tmp7_);
	_tmp9_ = self->priv->previous_state;
	if (_tmp9_ != NULL) {
		GameUndoItem* _tmp10_;
		GameUndoItem* _tmp11_;
		GameUndoItem* _tmp12_;
		_tmp10_ = self->priv->previous_state;
		_tmp11_ = self->priv->state;
		_tmp12_ = _game_undo_item_dup0 (_tmp11_);
		_game_undo_item_free0 ((*_tmp10_).next);
		(*_tmp10_).next = _tmp12_;
	}
}

gint*
game_get_tiles (Game* self,
                gint* result_length1,
                gint* result_length2)
{
	gint* result;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tiles;
	_tmp0__length1 = self->priv->_tiles_length1;
	_tmp0__length2 = self->priv->_tiles_length2;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp1__length2;
	}
	result = _tmp1_;
	return result;
}

static gint*
_vala_array_dup1 (gint* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gint));
}

static void
game_set_tiles (Game* self,
                gint* value,
                gint value_length1,
                gint value_length2)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1 * value_length2) : ((gpointer) value);
	_tmp0__length1 = value_length1;
	_tmp0__length2 = value_length2;
	self->priv->_tiles = (g_free (self->priv->_tiles), NULL);
	self->priv->_tiles = _tmp0_;
	self->priv->_tiles_length1 = _tmp0__length1;
	self->priv->_tiles_length2 = _tmp0__length2;
}

gint
game_get_size (Game* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_size;
	return result;
}

static void
game_set_size (Game* self,
               gint value)
{
	g_return_if_fail (self != NULL);
	if (game_get_size (self) != value) {
		self->priv->_size = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_SIZE_PROPERTY]);
	}
}

GameType
game_get_game_type (Game* self)
{
	GameType result;
	GameType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_game_type;
	result = _tmp0_;
	return result;
}

static void
game_set_game_type (Game* self,
                    GameType value)
{
	g_return_if_fail (self != NULL);
	if (game_get_game_type (self) != value) {
		self->priv->_game_type = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_GAME_TYPE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOOLEAN_INT_INT_INT) (gpointer data1, gboolean arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
game_undo_item_copy (const GameUndoItem* self,
                     GameUndoItem* dest)
{
	GameUndoItem* _tmp0_;
	GameUndoItem* _tmp1_;
	GameUndoItem* _tmp2_;
	GameUndoItem* _tmp3_;
	(*dest).x = (*self).x;
	(*dest).y = (*self).y;
	_tmp0_ = (*self).next;
	_tmp1_ = _game_undo_item_dup0 (_tmp0_);
	_game_undo_item_free0 ((*dest).next);
	(*dest).next = _tmp1_;
	_tmp2_ = (*self).previous;
	_tmp3_ = _game_undo_item_dup0 (_tmp2_);
	_game_undo_item_free0 ((*dest).previous);
	(*dest).previous = _tmp3_;
}

static void
game_undo_item_destroy (GameUndoItem* self)
{
	_game_undo_item_free0 ((*self).next);
	_game_undo_item_free0 ((*self).previous);
}

static GameUndoItem*
game_undo_item_dup (const GameUndoItem* self)
{
	GameUndoItem* dup;
	dup = g_new0 (GameUndoItem, 1);
	game_undo_item_copy (self, dup);
	return dup;
}

static void
game_undo_item_free (GameUndoItem* self)
{
	game_undo_item_destroy (self);
	g_free (self);
}

static GType
game_undo_item_get_type (void)
{
	static volatile gsize game_undo_item_type_id__volatile = 0;
	if (g_once_init_enter (&game_undo_item_type_id__volatile)) {
		GType game_undo_item_type_id;
		game_undo_item_type_id = g_boxed_type_register_static ("GameUndoItem", (GBoxedCopyFunc) game_undo_item_dup, (GBoxedFreeFunc) game_undo_item_free);
		g_once_init_leave (&game_undo_item_type_id__volatile, game_undo_item_type_id);
	}
	return game_undo_item_type_id__volatile;
}

static void
game_class_init (GameClass * klass,
                 gpointer klass_data)
{
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Game_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SIZE_PROPERTY, game_properties[GAME_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_GAME_TYPE_PROPERTY, game_properties[GAME_GAME_TYPE_PROPERTY] = g_param_spec_enum ("game-type", "game-type", "game-type", TYPE_GAME_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	game_signals[GAME_COMPLETE_SIGNAL] = g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_MOVE_SIGNAL] = g_signal_new ("move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	game_signals[GAME_EMPTY_TILE_SIGNAL] = g_signal_new ("empty-tile", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_CANNOT_MOVE_SIGNAL] = g_signal_new ("cannot-move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	game_signals[GAME_CANNOT_UNDO_MORE_SIGNAL] = g_signal_new ("cannot-undo-more", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
game_instance_init (Game * self,
                    gpointer klass)
{
	self->priv = game_get_instance_private (self);
	self->priv->state = NULL;
	self->priv->previous_state = NULL;
	self->priv->x_gap = 0;
	self->priv->y_gap = 0;
}

static void
game_finalize (GObject * obj)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	self->priv->_tiles = (g_free (self->priv->_tiles), NULL);
	_game_undo_item_free0 (self->priv->state);
	_game_undo_item_free0 (self->priv->previous_state);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}

GType
game_get_type (void)
{
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		Game_private_offset = g_type_add_instance_private (game_type_id, sizeof (GamePrivate));
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}

static void
_vala_game_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		g_value_set_int (value, game_get_size (self));
		break;
		case GAME_GAME_TYPE_PROPERTY:
		g_value_set_enum (value, game_get_game_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		game_set_size (self, g_value_get_int (value));
		break;
		case GAME_GAME_TYPE_PROPERTY:
		game_set_game_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

