/* puzzle.c generated by valac 0.42.3, the Vala compiler
 * generated from puzzle.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*
  1   2   4

  8   *   16

  32  64  128
*/


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
typedef struct _PuzzlePrivate PuzzlePrivate;
enum  {
	PUZZLE_0_PROPERTY,
	PUZZLE_NUM_PROPERTIES
};
static GParamSpec* puzzle_properties[PUZZLE_NUM_PROPERTIES];
enum  {
	PUZZLE_CHANGED_SIGNAL,
	PUZZLE_MOVED_SIGNAL,
	PUZZLE_NUM_SIGNALS
};
static guint puzzle_signals[PUZZLE_NUM_SIGNALS] = {0};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};


static gpointer puzzle_parent_class = NULL;

GType puzzle_get_type (void) G_GNUC_CONST;
Puzzle* puzzle_new (gint width,
                    gint height,
                    const gchar* data);
Puzzle* puzzle_construct (GType object_type,
                          gint width,
                          gint height,
                          const gchar* data);
static gchar* _vala_array_dup1 (gchar* self,
                         int length);
static gchar* _vala_array_dup2 (gchar* self,
                         int length);
static void puzzle_set_piece_id (Puzzle* self,
                          gchar* src,
                          int src_length1,
                          gint x,
                          gint y,
                          gchar id);
static gchar* _vala_array_dup3 (gchar* self,
                         int length);
static gchar* _vala_array_dup4 (gchar* self,
                         int length);
gchar puzzle_get_piece_id (Puzzle* self,
                           gchar* src,
                           int src_length1,
                           gint x,
                           gint y);
gint puzzle_get_piece_nr (Puzzle* self,
                          gint x,
                          gint y);
gboolean puzzle_game_over (Puzzle* self);
gboolean puzzle_mapcmp (Puzzle* self,
                        gchar* m1,
                        int m1_length1,
                        gchar* m2,
                        int m2_length1);
gboolean puzzle_movable (Puzzle* self,
                         gint id);
gboolean puzzle_move_piece (Puzzle* self,
                            gchar id,
                            gint x1,
                            gint y1,
                            gint x2,
                            gint y2);
static gboolean puzzle_check_valid_move (Puzzle* self,
                                  gint id,
                                  gint dx,
                                  gint dy);
static gboolean puzzle_do_move_piece (Puzzle* self,
                               gchar id,
                               gint dx,
                               gint dy);
static gchar* _vala_array_dup5 (gchar* self,
                         int length);
static gchar* _vala_array_dup6 (gchar* self,
                         int length);
static void puzzle_finalize (GObject * obj);

const gint image_map[110] = {0, 0, 64, 1, 66, 2, 2, 3, 16, 4, 24, 5, 8, 6, 208, 7, 248, 8, 104, 9, 214, 10, 255, 11, 107, 12, 22, 13, 31, 14, 11, 15, 18, 16, 10, 17, 80, 18, 72, 19, 56, 5, 152, 5, 70, 2, 67, 2, 194, 2, 98, 2, 9, 6, 20, 4, 144, 4, 3, 3, 40, 6, 25, 5, 28, 5, 96, 1, 19, 16, 201, 19, 146, 16, 198, 2, 84, 18, 46, 17, 112, 18, 6, 3, 184, 5, 192, 1, 147, 16, 73, 19, 42, 17, 200, 19, 99, 2, 116, 18, 29, 5, 14, 17, 26, 25, 224, 1, -1, -1};

static gchar*
_vala_array_dup1 (gchar* self,
                  int length)
{
#line 108 "puzzle.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 142 "puzzle.c"
}


static gchar*
_vala_array_dup2 (gchar* self,
                  int length)
{
#line 109 "puzzle.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 152 "puzzle.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1180 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "glib-2.0.vapi"
	return result;
#line 170 "puzzle.c"
}


static gchar*
_vala_array_dup3 (gchar* self,
                  int length)
{
#line 122 "puzzle.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 180 "puzzle.c"
}


static gchar*
_vala_array_dup4 (gchar* self,
                  int length)
{
#line 123 "puzzle.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 190 "puzzle.c"
}


Puzzle*
puzzle_construct (GType object_type,
                  gint width,
                  gint height,
                  const gchar* data)
{
	Puzzle * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gint _tmp19__length1;
#line 103 "puzzle.vala"
	self = (Puzzle*) g_object_new (object_type, NULL);
#line 105 "puzzle.vala"
	self->width = width;
#line 106 "puzzle.vala"
	self->height = height;
#line 107 "puzzle.vala"
	_tmp0_ = g_new0 (gchar, (width + 2) * (height + 2));
#line 107 "puzzle.vala"
	self->map = (g_free (self->map), NULL);
#line 107 "puzzle.vala"
	self->map = _tmp0_;
#line 107 "puzzle.vala"
	self->map_length1 = (width + 2) * (height + 2);
#line 108 "puzzle.vala"
	_tmp1_ = self->map;
#line 108 "puzzle.vala"
	_tmp1__length1 = self->map_length1;
#line 108 "puzzle.vala"
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
#line 108 "puzzle.vala"
	_tmp2__length1 = _tmp1__length1;
#line 108 "puzzle.vala"
	self->move_map = (g_free (self->move_map), NULL);
#line 108 "puzzle.vala"
	self->move_map = _tmp2_;
#line 108 "puzzle.vala"
	self->move_map_length1 = _tmp2__length1;
#line 109 "puzzle.vala"
	_tmp3_ = self->map;
#line 109 "puzzle.vala"
	_tmp3__length1 = self->map_length1;
#line 109 "puzzle.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
#line 109 "puzzle.vala"
	_tmp4__length1 = _tmp3__length1;
#line 109 "puzzle.vala"
	self->undomove_map = (g_free (self->undomove_map), NULL);
#line 109 "puzzle.vala"
	self->undomove_map = _tmp4_;
#line 109 "puzzle.vala"
	self->undomove_map_length1 = _tmp4__length1;
#line 110 "puzzle.vala"
	if (data != NULL) {
#line 262 "puzzle.c"
		gint i = 0;
#line 112 "puzzle.vala"
		i = 0;
#line 266 "puzzle.c"
		{
			gint y = 0;
#line 113 "puzzle.vala"
			y = 0;
#line 271 "puzzle.c"
			{
				gboolean _tmp5_ = FALSE;
#line 113 "puzzle.vala"
				_tmp5_ = TRUE;
#line 113 "puzzle.vala"
				while (TRUE) {
#line 278 "puzzle.c"
					gint _tmp7_;
#line 113 "puzzle.vala"
					if (!_tmp5_) {
#line 282 "puzzle.c"
						gint _tmp6_;
#line 113 "puzzle.vala"
						_tmp6_ = y;
#line 113 "puzzle.vala"
						y = _tmp6_ + 1;
#line 288 "puzzle.c"
					}
#line 113 "puzzle.vala"
					_tmp5_ = FALSE;
#line 113 "puzzle.vala"
					_tmp7_ = y;
#line 113 "puzzle.vala"
					if (!(_tmp7_ < height)) {
#line 113 "puzzle.vala"
						break;
#line 298 "puzzle.c"
					}
					{
						gint x = 0;
#line 115 "puzzle.vala"
						x = 0;
#line 304 "puzzle.c"
						{
							gboolean _tmp8_ = FALSE;
#line 115 "puzzle.vala"
							_tmp8_ = TRUE;
#line 115 "puzzle.vala"
							while (TRUE) {
#line 311 "puzzle.c"
								gint _tmp10_;
								gchar* _tmp11_;
								gint _tmp11__length1;
								gint _tmp12_;
								gint _tmp13_;
								gint _tmp14_;
								gint _tmp15_;
#line 115 "puzzle.vala"
								if (!_tmp8_) {
#line 321 "puzzle.c"
									gint _tmp9_;
#line 115 "puzzle.vala"
									_tmp9_ = x;
#line 115 "puzzle.vala"
									x = _tmp9_ + 1;
#line 327 "puzzle.c"
								}
#line 115 "puzzle.vala"
								_tmp8_ = FALSE;
#line 115 "puzzle.vala"
								_tmp10_ = x;
#line 115 "puzzle.vala"
								if (!(_tmp10_ < width)) {
#line 115 "puzzle.vala"
									break;
#line 337 "puzzle.c"
								}
#line 117 "puzzle.vala"
								_tmp11_ = self->map;
#line 117 "puzzle.vala"
								_tmp11__length1 = self->map_length1;
#line 117 "puzzle.vala"
								_tmp12_ = x;
#line 117 "puzzle.vala"
								_tmp13_ = y;
#line 117 "puzzle.vala"
								_tmp14_ = i;
#line 117 "puzzle.vala"
								puzzle_set_piece_id (self, _tmp11_, _tmp11__length1, _tmp12_, _tmp13_, string_get (data, (glong) _tmp14_));
#line 118 "puzzle.vala"
								_tmp15_ = i;
#line 118 "puzzle.vala"
								i = _tmp15_ + 1;
#line 355 "puzzle.c"
							}
						}
					}
				}
			}
		}
	}
#line 122 "puzzle.vala"
	_tmp16_ = self->map;
#line 122 "puzzle.vala"
	_tmp16__length1 = self->map_length1;
#line 122 "puzzle.vala"
	_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup3 (_tmp16_, _tmp16__length1) : ((gpointer) _tmp16_);
#line 122 "puzzle.vala"
	_tmp17__length1 = _tmp16__length1;
#line 122 "puzzle.vala"
	self->orig_map = (g_free (self->orig_map), NULL);
#line 122 "puzzle.vala"
	self->orig_map = _tmp17_;
#line 122 "puzzle.vala"
	self->orig_map_length1 = _tmp17__length1;
#line 123 "puzzle.vala"
	_tmp18_ = self->map;
#line 123 "puzzle.vala"
	_tmp18__length1 = self->map_length1;
#line 123 "puzzle.vala"
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup4 (_tmp18_, _tmp18__length1) : ((gpointer) _tmp18_);
#line 123 "puzzle.vala"
	_tmp19__length1 = _tmp18__length1;
#line 123 "puzzle.vala"
	self->lastmove_map = (g_free (self->lastmove_map), NULL);
#line 123 "puzzle.vala"
	self->lastmove_map = _tmp19_;
#line 123 "puzzle.vala"
	self->lastmove_map_length1 = _tmp19__length1;
#line 103 "puzzle.vala"
	return self;
#line 393 "puzzle.c"
}


Puzzle*
puzzle_new (gint width,
            gint height,
            const gchar* data)
{
#line 103 "puzzle.vala"
	return puzzle_construct (TYPE_PUZZLE, width, height, data);
#line 404 "puzzle.c"
}


gchar
puzzle_get_piece_id (Puzzle* self,
                     gchar* src,
                     int src_length1,
                     gint x,
                     gint y)
{
	gchar result = '\0';
	gint _tmp0_;
	gchar _tmp1_;
#line 126 "puzzle.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 128 "puzzle.vala"
	_tmp0_ = self->width;
#line 128 "puzzle.vala"
	_tmp1_ = src[(x + 1) + ((y + 1) * (_tmp0_ + 2))];
#line 128 "puzzle.vala"
	result = _tmp1_;
#line 128 "puzzle.vala"
	return result;
#line 428 "puzzle.c"
}


static void
puzzle_set_piece_id (Puzzle* self,
                     gchar* src,
                     int src_length1,
                     gint x,
                     gint y,
                     gchar id)
{
	gint _tmp0_;
	gchar _tmp1_;
#line 131 "puzzle.vala"
	g_return_if_fail (self != NULL);
#line 133 "puzzle.vala"
	_tmp0_ = self->width;
#line 133 "puzzle.vala"
	src[(x + 1) + ((y + 1) * (_tmp0_ + 2))] = id;
#line 133 "puzzle.vala"
	_tmp1_ = src[(x + 1) + ((y + 1) * (_tmp0_ + 2))];
#line 450 "puzzle.c"
}


gint
puzzle_get_piece_nr (Puzzle* self,
                     gint x,
                     gint y)
{
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar c = '\0';
	gchar* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gchar _tmp4_;
	gchar _tmp5_;
	gchar _tmp6_;
	gchar _tmp7_;
	gint nr = 0;
	gchar* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	gchar _tmp10_;
	gchar _tmp11_;
	gchar* _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	gchar _tmp15_;
	gchar _tmp16_;
	gchar* _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_;
	gchar _tmp20_;
	gchar _tmp21_;
	gchar* _tmp23_;
	gint _tmp23__length1;
	gint _tmp24_;
	gchar _tmp25_;
	gchar _tmp26_;
	gchar* _tmp28_;
	gint _tmp28__length1;
	gint _tmp29_;
	gchar _tmp30_;
	gchar _tmp31_;
	gchar* _tmp33_;
	gint _tmp33__length1;
	gint _tmp34_;
	gchar _tmp35_;
	gchar _tmp36_;
	gchar* _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_;
	gchar _tmp40_;
	gchar _tmp41_;
	gchar* _tmp43_;
	gint _tmp43__length1;
	gint _tmp44_;
	gchar _tmp45_;
	gchar _tmp46_;
	gint i = 0;
	gint _tmp55_;
	gint _tmp56_;
#line 136 "puzzle.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 138 "puzzle.vala"
	_tmp0_ = x;
#line 138 "puzzle.vala"
	x = _tmp0_ + 1;
#line 139 "puzzle.vala"
	_tmp1_ = y;
#line 139 "puzzle.vala"
	y = _tmp1_ + 1;
#line 141 "puzzle.vala"
	_tmp2_ = self->map;
#line 141 "puzzle.vala"
	_tmp2__length1 = self->map_length1;
#line 141 "puzzle.vala"
	_tmp3_ = self->width;
#line 141 "puzzle.vala"
	_tmp4_ = _tmp2_[x + (y * (_tmp3_ + 2))];
#line 141 "puzzle.vala"
	c = _tmp4_;
#line 142 "puzzle.vala"
	_tmp5_ = c;
#line 142 "puzzle.vala"
	if (_tmp5_ == '-') {
#line 143 "puzzle.vala"
		result = 23;
#line 143 "puzzle.vala"
		return result;
#line 542 "puzzle.c"
	}
#line 144 "puzzle.vala"
	_tmp6_ = c;
#line 144 "puzzle.vala"
	if (_tmp6_ == ' ') {
#line 145 "puzzle.vala"
		result = 21;
#line 145 "puzzle.vala"
		return result;
#line 552 "puzzle.c"
	}
#line 146 "puzzle.vala"
	_tmp7_ = c;
#line 146 "puzzle.vala"
	if (_tmp7_ == '.') {
#line 147 "puzzle.vala"
		result = 20;
#line 147 "puzzle.vala"
		return result;
#line 562 "puzzle.c"
	}
#line 149 "puzzle.vala"
	nr = 0;
#line 150 "puzzle.vala"
	_tmp8_ = self->map;
#line 150 "puzzle.vala"
	_tmp8__length1 = self->map_length1;
#line 150 "puzzle.vala"
	_tmp9_ = self->width;
#line 150 "puzzle.vala"
	_tmp10_ = _tmp8_[(x - 1) + ((y - 1) * (_tmp9_ + 2))];
#line 150 "puzzle.vala"
	_tmp11_ = c;
#line 150 "puzzle.vala"
	if (_tmp10_ == _tmp11_) {
#line 578 "puzzle.c"
		gint _tmp12_;
#line 151 "puzzle.vala"
		_tmp12_ = nr;
#line 151 "puzzle.vala"
		nr = _tmp12_ + 1;
#line 584 "puzzle.c"
	}
#line 152 "puzzle.vala"
	_tmp13_ = self->map;
#line 152 "puzzle.vala"
	_tmp13__length1 = self->map_length1;
#line 152 "puzzle.vala"
	_tmp14_ = self->width;
#line 152 "puzzle.vala"
	_tmp15_ = _tmp13_[(x - 0) + ((y - 1) * (_tmp14_ + 2))];
#line 152 "puzzle.vala"
	_tmp16_ = c;
#line 152 "puzzle.vala"
	if (_tmp15_ == _tmp16_) {
#line 598 "puzzle.c"
		gint _tmp17_;
#line 153 "puzzle.vala"
		_tmp17_ = nr;
#line 153 "puzzle.vala"
		nr = _tmp17_ + 2;
#line 604 "puzzle.c"
	}
#line 154 "puzzle.vala"
	_tmp18_ = self->map;
#line 154 "puzzle.vala"
	_tmp18__length1 = self->map_length1;
#line 154 "puzzle.vala"
	_tmp19_ = self->width;
#line 154 "puzzle.vala"
	_tmp20_ = _tmp18_[(x + 1) + ((y - 1) * (_tmp19_ + 2))];
#line 154 "puzzle.vala"
	_tmp21_ = c;
#line 154 "puzzle.vala"
	if (_tmp20_ == _tmp21_) {
#line 618 "puzzle.c"
		gint _tmp22_;
#line 155 "puzzle.vala"
		_tmp22_ = nr;
#line 155 "puzzle.vala"
		nr = _tmp22_ + 4;
#line 624 "puzzle.c"
	}
#line 156 "puzzle.vala"
	_tmp23_ = self->map;
#line 156 "puzzle.vala"
	_tmp23__length1 = self->map_length1;
#line 156 "puzzle.vala"
	_tmp24_ = self->width;
#line 156 "puzzle.vala"
	_tmp25_ = _tmp23_[(x - 1) + ((y - 0) * (_tmp24_ + 2))];
#line 156 "puzzle.vala"
	_tmp26_ = c;
#line 156 "puzzle.vala"
	if (_tmp25_ == _tmp26_) {
#line 638 "puzzle.c"
		gint _tmp27_;
#line 157 "puzzle.vala"
		_tmp27_ = nr;
#line 157 "puzzle.vala"
		nr = _tmp27_ + 8;
#line 644 "puzzle.c"
	}
#line 158 "puzzle.vala"
	_tmp28_ = self->map;
#line 158 "puzzle.vala"
	_tmp28__length1 = self->map_length1;
#line 158 "puzzle.vala"
	_tmp29_ = self->width;
#line 158 "puzzle.vala"
	_tmp30_ = _tmp28_[(x + 1) + ((y - 0) * (_tmp29_ + 2))];
#line 158 "puzzle.vala"
	_tmp31_ = c;
#line 158 "puzzle.vala"
	if (_tmp30_ == _tmp31_) {
#line 658 "puzzle.c"
		gint _tmp32_;
#line 159 "puzzle.vala"
		_tmp32_ = nr;
#line 159 "puzzle.vala"
		nr = _tmp32_ + 16;
#line 664 "puzzle.c"
	}
#line 160 "puzzle.vala"
	_tmp33_ = self->map;
#line 160 "puzzle.vala"
	_tmp33__length1 = self->map_length1;
#line 160 "puzzle.vala"
	_tmp34_ = self->width;
#line 160 "puzzle.vala"
	_tmp35_ = _tmp33_[(x - 1) + ((y + 1) * (_tmp34_ + 2))];
#line 160 "puzzle.vala"
	_tmp36_ = c;
#line 160 "puzzle.vala"
	if (_tmp35_ == _tmp36_) {
#line 678 "puzzle.c"
		gint _tmp37_;
#line 161 "puzzle.vala"
		_tmp37_ = nr;
#line 161 "puzzle.vala"
		nr = _tmp37_ + 32;
#line 684 "puzzle.c"
	}
#line 162 "puzzle.vala"
	_tmp38_ = self->map;
#line 162 "puzzle.vala"
	_tmp38__length1 = self->map_length1;
#line 162 "puzzle.vala"
	_tmp39_ = self->width;
#line 162 "puzzle.vala"
	_tmp40_ = _tmp38_[(x - 0) + ((y + 1) * (_tmp39_ + 2))];
#line 162 "puzzle.vala"
	_tmp41_ = c;
#line 162 "puzzle.vala"
	if (_tmp40_ == _tmp41_) {
#line 698 "puzzle.c"
		gint _tmp42_;
#line 163 "puzzle.vala"
		_tmp42_ = nr;
#line 163 "puzzle.vala"
		nr = _tmp42_ + 64;
#line 704 "puzzle.c"
	}
#line 164 "puzzle.vala"
	_tmp43_ = self->map;
#line 164 "puzzle.vala"
	_tmp43__length1 = self->map_length1;
#line 164 "puzzle.vala"
	_tmp44_ = self->width;
#line 164 "puzzle.vala"
	_tmp45_ = _tmp43_[(x + 1) + ((y + 1) * (_tmp44_ + 2))];
#line 164 "puzzle.vala"
	_tmp46_ = c;
#line 164 "puzzle.vala"
	if (_tmp45_ == _tmp46_) {
#line 718 "puzzle.c"
		gint _tmp47_;
#line 165 "puzzle.vala"
		_tmp47_ = nr;
#line 165 "puzzle.vala"
		nr = _tmp47_ + 128;
#line 724 "puzzle.c"
	}
#line 167 "puzzle.vala"
	i = 0;
#line 168 "puzzle.vala"
	while (TRUE) {
#line 730 "puzzle.c"
		gboolean _tmp48_ = FALSE;
		gint _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _tmp54_;
#line 168 "puzzle.vala"
		_tmp49_ = nr;
#line 168 "puzzle.vala"
		_tmp50_ = i;
#line 168 "puzzle.vala"
		_tmp51_ = image_map[_tmp50_];
#line 168 "puzzle.vala"
		if (_tmp49_ != _tmp51_) {
#line 744 "puzzle.c"
			gint _tmp52_;
			gint _tmp53_;
#line 168 "puzzle.vala"
			_tmp52_ = i;
#line 168 "puzzle.vala"
			_tmp53_ = image_map[_tmp52_];
#line 168 "puzzle.vala"
			_tmp48_ = _tmp53_ != -1;
#line 753 "puzzle.c"
		} else {
#line 168 "puzzle.vala"
			_tmp48_ = FALSE;
#line 757 "puzzle.c"
		}
#line 168 "puzzle.vala"
		if (!_tmp48_) {
#line 168 "puzzle.vala"
			break;
#line 763 "puzzle.c"
		}
#line 169 "puzzle.vala"
		_tmp54_ = i;
#line 169 "puzzle.vala"
		i = _tmp54_ + 2;
#line 769 "puzzle.c"
	}
#line 171 "puzzle.vala"
	_tmp55_ = i;
#line 171 "puzzle.vala"
	_tmp56_ = image_map[_tmp55_ + 1];
#line 171 "puzzle.vala"
	result = _tmp56_;
#line 171 "puzzle.vala"
	return result;
#line 779 "puzzle.c"
}


gboolean
puzzle_game_over (Puzzle* self)
{
	gboolean result = FALSE;
	gboolean over = FALSE;
#line 174 "puzzle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 176 "puzzle.vala"
	over = TRUE;
#line 792 "puzzle.c"
	{
		gint y = 0;
#line 177 "puzzle.vala"
		y = 0;
#line 797 "puzzle.c"
		{
			gboolean _tmp0_ = FALSE;
#line 177 "puzzle.vala"
			_tmp0_ = TRUE;
#line 177 "puzzle.vala"
			while (TRUE) {
#line 804 "puzzle.c"
				gint _tmp2_;
				gint _tmp3_;
#line 177 "puzzle.vala"
				if (!_tmp0_) {
#line 809 "puzzle.c"
					gint _tmp1_;
#line 177 "puzzle.vala"
					_tmp1_ = y;
#line 177 "puzzle.vala"
					y = _tmp1_ + 1;
#line 815 "puzzle.c"
				}
#line 177 "puzzle.vala"
				_tmp0_ = FALSE;
#line 177 "puzzle.vala"
				_tmp2_ = y;
#line 177 "puzzle.vala"
				_tmp3_ = self->height;
#line 177 "puzzle.vala"
				if (!(_tmp2_ < _tmp3_)) {
#line 177 "puzzle.vala"
					break;
#line 827 "puzzle.c"
				}
				{
					gint x = 0;
#line 178 "puzzle.vala"
					x = 0;
#line 833 "puzzle.c"
					{
						gboolean _tmp4_ = FALSE;
#line 178 "puzzle.vala"
						_tmp4_ = TRUE;
#line 178 "puzzle.vala"
						while (TRUE) {
#line 840 "puzzle.c"
							gint _tmp6_;
							gint _tmp7_;
							gboolean _tmp8_ = FALSE;
							gchar* _tmp9_;
							gint _tmp9__length1;
							gint _tmp10_;
							gint _tmp11_;
#line 178 "puzzle.vala"
							if (!_tmp4_) {
#line 850 "puzzle.c"
								gint _tmp5_;
#line 178 "puzzle.vala"
								_tmp5_ = x;
#line 178 "puzzle.vala"
								x = _tmp5_ + 1;
#line 856 "puzzle.c"
							}
#line 178 "puzzle.vala"
							_tmp4_ = FALSE;
#line 178 "puzzle.vala"
							_tmp6_ = x;
#line 178 "puzzle.vala"
							_tmp7_ = self->width;
#line 178 "puzzle.vala"
							if (!(_tmp6_ < _tmp7_)) {
#line 178 "puzzle.vala"
								break;
#line 868 "puzzle.c"
							}
#line 179 "puzzle.vala"
							_tmp9_ = self->map;
#line 179 "puzzle.vala"
							_tmp9__length1 = self->map_length1;
#line 179 "puzzle.vala"
							_tmp10_ = x;
#line 179 "puzzle.vala"
							_tmp11_ = y;
#line 179 "puzzle.vala"
							if (puzzle_get_piece_id (self, _tmp9_, _tmp9__length1, _tmp10_, _tmp11_) == '*') {
#line 880 "puzzle.c"
								gchar* _tmp12_;
								gint _tmp12__length1;
								gint _tmp13_;
								gint _tmp14_;
#line 179 "puzzle.vala"
								_tmp12_ = self->orig_map;
#line 179 "puzzle.vala"
								_tmp12__length1 = self->orig_map_length1;
#line 179 "puzzle.vala"
								_tmp13_ = x;
#line 179 "puzzle.vala"
								_tmp14_ = y;
#line 179 "puzzle.vala"
								_tmp8_ = puzzle_get_piece_id (self, _tmp12_, _tmp12__length1, _tmp13_, _tmp14_) != '.';
#line 895 "puzzle.c"
							} else {
#line 179 "puzzle.vala"
								_tmp8_ = FALSE;
#line 899 "puzzle.c"
							}
#line 179 "puzzle.vala"
							if (_tmp8_) {
#line 180 "puzzle.vala"
								over = FALSE;
#line 905 "puzzle.c"
							}
						}
					}
				}
			}
		}
	}
#line 181 "puzzle.vala"
	result = over;
#line 181 "puzzle.vala"
	return result;
#line 917 "puzzle.c"
}


gboolean
puzzle_mapcmp (Puzzle* self,
               gchar* m1,
               int m1_length1,
               gchar* m2,
               int m2_length1)
{
	gboolean result = FALSE;
#line 184 "puzzle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 931 "puzzle.c"
	{
		gint y = 0;
#line 186 "puzzle.vala"
		y = 0;
#line 936 "puzzle.c"
		{
			gboolean _tmp0_ = FALSE;
#line 186 "puzzle.vala"
			_tmp0_ = TRUE;
#line 186 "puzzle.vala"
			while (TRUE) {
#line 943 "puzzle.c"
				gint _tmp2_;
				gint _tmp3_;
#line 186 "puzzle.vala"
				if (!_tmp0_) {
#line 948 "puzzle.c"
					gint _tmp1_;
#line 186 "puzzle.vala"
					_tmp1_ = y;
#line 186 "puzzle.vala"
					y = _tmp1_ + 1;
#line 954 "puzzle.c"
				}
#line 186 "puzzle.vala"
				_tmp0_ = FALSE;
#line 186 "puzzle.vala"
				_tmp2_ = y;
#line 186 "puzzle.vala"
				_tmp3_ = self->height;
#line 186 "puzzle.vala"
				if (!(_tmp2_ < _tmp3_)) {
#line 186 "puzzle.vala"
					break;
#line 966 "puzzle.c"
				}
				{
					gint x = 0;
#line 187 "puzzle.vala"
					x = 0;
#line 972 "puzzle.c"
					{
						gboolean _tmp4_ = FALSE;
#line 187 "puzzle.vala"
						_tmp4_ = TRUE;
#line 187 "puzzle.vala"
						while (TRUE) {
#line 979 "puzzle.c"
							gint _tmp6_;
							gint _tmp7_;
							gint _tmp8_;
							gint _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
#line 187 "puzzle.vala"
							if (!_tmp4_) {
#line 988 "puzzle.c"
								gint _tmp5_;
#line 187 "puzzle.vala"
								_tmp5_ = x;
#line 187 "puzzle.vala"
								x = _tmp5_ + 1;
#line 994 "puzzle.c"
							}
#line 187 "puzzle.vala"
							_tmp4_ = FALSE;
#line 187 "puzzle.vala"
							_tmp6_ = x;
#line 187 "puzzle.vala"
							_tmp7_ = self->width;
#line 187 "puzzle.vala"
							if (!(_tmp6_ < _tmp7_)) {
#line 187 "puzzle.vala"
								break;
#line 1006 "puzzle.c"
							}
#line 188 "puzzle.vala"
							_tmp8_ = x;
#line 188 "puzzle.vala"
							_tmp9_ = y;
#line 188 "puzzle.vala"
							_tmp10_ = x;
#line 188 "puzzle.vala"
							_tmp11_ = y;
#line 188 "puzzle.vala"
							if (puzzle_get_piece_id (self, m1, m1_length1, _tmp8_, _tmp9_) != puzzle_get_piece_id (self, m2, m2_length1, _tmp10_, _tmp11_)) {
#line 189 "puzzle.vala"
								result = TRUE;
#line 189 "puzzle.vala"
								return result;
#line 1022 "puzzle.c"
							}
						}
					}
				}
			}
		}
	}
#line 190 "puzzle.vala"
	result = FALSE;
#line 190 "puzzle.vala"
	return result;
#line 1034 "puzzle.c"
}


gboolean
puzzle_movable (Puzzle* self,
                gint id)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 193 "puzzle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 195 "puzzle.vala"
	if (id == ((gint) '#')) {
#line 195 "puzzle.vala"
		_tmp2_ = TRUE;
#line 1052 "puzzle.c"
	} else {
#line 195 "puzzle.vala"
		_tmp2_ = id == ((gint) '.');
#line 1056 "puzzle.c"
	}
#line 195 "puzzle.vala"
	if (_tmp2_) {
#line 195 "puzzle.vala"
		_tmp1_ = TRUE;
#line 1062 "puzzle.c"
	} else {
#line 195 "puzzle.vala"
		_tmp1_ = id == ((gint) ' ');
#line 1066 "puzzle.c"
	}
#line 195 "puzzle.vala"
	if (_tmp1_) {
#line 195 "puzzle.vala"
		_tmp0_ = TRUE;
#line 1072 "puzzle.c"
	} else {
#line 195 "puzzle.vala"
		_tmp0_ = id == ((gint) '-');
#line 1076 "puzzle.c"
	}
#line 195 "puzzle.vala"
	if (_tmp0_) {
#line 196 "puzzle.vala"
		result = FALSE;
#line 196 "puzzle.vala"
		return result;
#line 1084 "puzzle.c"
	}
#line 197 "puzzle.vala"
	result = TRUE;
#line 197 "puzzle.vala"
	return result;
#line 1090 "puzzle.c"
}


gboolean
puzzle_move_piece (Puzzle* self,
                   gchar id,
                   gint x1,
                   gint y1,
                   gint x2,
                   gint y2)
{
	gboolean result = FALSE;
	gboolean return_value = FALSE;
	gchar* _tmp0_;
	gint _tmp0__length1;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 200 "puzzle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 202 "puzzle.vala"
	return_value = FALSE;
#line 204 "puzzle.vala"
	if (!puzzle_movable (self, (gint) id)) {
#line 205 "puzzle.vala"
		result = FALSE;
#line 205 "puzzle.vala"
		return result;
#line 1118 "puzzle.c"
	}
#line 207 "puzzle.vala"
	_tmp0_ = self->map;
#line 207 "puzzle.vala"
	_tmp0__length1 = self->map_length1;
#line 207 "puzzle.vala"
	if (puzzle_get_piece_id (self, _tmp0_, _tmp0__length1, x2, y2) == id) {
#line 208 "puzzle.vala"
		return_value = TRUE;
#line 1128 "puzzle.c"
	}
#line 210 "puzzle.vala"
	if (y1 == y2) {
#line 210 "puzzle.vala"
		_tmp2_ = abs (x1 - x2) == 1;
#line 1134 "puzzle.c"
	} else {
#line 210 "puzzle.vala"
		_tmp2_ = FALSE;
#line 1138 "puzzle.c"
	}
#line 210 "puzzle.vala"
	if (_tmp2_) {
#line 210 "puzzle.vala"
		_tmp1_ = TRUE;
#line 1144 "puzzle.c"
	} else {
		gboolean _tmp3_ = FALSE;
#line 210 "puzzle.vala"
		if (x1 == x2) {
#line 210 "puzzle.vala"
			_tmp3_ = abs (y1 - y2) == 1;
#line 1151 "puzzle.c"
		} else {
#line 210 "puzzle.vala"
			_tmp3_ = FALSE;
#line 1155 "puzzle.c"
		}
#line 210 "puzzle.vala"
		_tmp1_ = _tmp3_;
#line 1159 "puzzle.c"
	}
#line 210 "puzzle.vala"
	if (!_tmp1_) {
#line 211 "puzzle.vala"
		result = FALSE;
#line 211 "puzzle.vala"
		return result;
#line 1167 "puzzle.c"
	}
#line 213 "puzzle.vala"
	if (abs (y1 - y2) == 1) {
#line 215 "puzzle.vala"
		if ((y1 - y2) < 0) {
#line 216 "puzzle.vala"
			if (puzzle_check_valid_move (self, (gint) id, 0, 1)) {
#line 217 "puzzle.vala"
				result = puzzle_do_move_piece (self, id, 0, 1);
#line 217 "puzzle.vala"
				return result;
#line 1179 "puzzle.c"
			}
		}
#line 218 "puzzle.vala"
		if ((y1 - y2) > 0) {
#line 219 "puzzle.vala"
			if (puzzle_check_valid_move (self, (gint) id, 0, -1)) {
#line 220 "puzzle.vala"
				result = puzzle_do_move_piece (self, id, 0, -1);
#line 220 "puzzle.vala"
				return result;
#line 1190 "puzzle.c"
			}
		}
	}
#line 223 "puzzle.vala"
	if (abs (x1 - x2) == 1) {
#line 225 "puzzle.vala"
		if ((x1 - x2) < 0) {
#line 226 "puzzle.vala"
			if (puzzle_check_valid_move (self, (gint) id, 1, 0)) {
#line 227 "puzzle.vala"
				result = puzzle_do_move_piece (self, id, 1, 0);
#line 227 "puzzle.vala"
				return result;
#line 1204 "puzzle.c"
			}
		}
#line 228 "puzzle.vala"
		if ((x1 - x2) > 0) {
#line 229 "puzzle.vala"
			if (puzzle_check_valid_move (self, (gint) id, -1, 0)) {
#line 230 "puzzle.vala"
				result = puzzle_do_move_piece (self, id, -1, 0);
#line 230 "puzzle.vala"
				return result;
#line 1215 "puzzle.c"
			}
		}
	}
#line 233 "puzzle.vala"
	result = return_value;
#line 233 "puzzle.vala"
	return result;
#line 1223 "puzzle.c"
}


static gboolean
puzzle_check_valid_move (Puzzle* self,
                         gint id,
                         gint dx,
                         gint dy)
{
	gboolean result = FALSE;
#line 236 "puzzle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1236 "puzzle.c"
	{
		gint y = 0;
#line 238 "puzzle.vala"
		y = 0;
#line 1241 "puzzle.c"
		{
			gboolean _tmp0_ = FALSE;
#line 238 "puzzle.vala"
			_tmp0_ = TRUE;
#line 238 "puzzle.vala"
			while (TRUE) {
#line 1248 "puzzle.c"
				gint _tmp2_;
				gint _tmp3_;
#line 238 "puzzle.vala"
				if (!_tmp0_) {
#line 1253 "puzzle.c"
					gint _tmp1_;
#line 238 "puzzle.vala"
					_tmp1_ = y;
#line 238 "puzzle.vala"
					y = _tmp1_ + 1;
#line 1259 "puzzle.c"
				}
#line 238 "puzzle.vala"
				_tmp0_ = FALSE;
#line 238 "puzzle.vala"
				_tmp2_ = y;
#line 238 "puzzle.vala"
				_tmp3_ = self->height;
#line 238 "puzzle.vala"
				if (!(_tmp2_ < _tmp3_)) {
#line 238 "puzzle.vala"
					break;
#line 1271 "puzzle.c"
				}
				{
					gint x = 0;
#line 240 "puzzle.vala"
					x = 0;
#line 1277 "puzzle.c"
					{
						gboolean _tmp4_ = FALSE;
#line 240 "puzzle.vala"
						_tmp4_ = TRUE;
#line 240 "puzzle.vala"
						while (TRUE) {
#line 1284 "puzzle.c"
							gint _tmp6_;
							gint _tmp7_;
							gchar* _tmp8_;
							gint _tmp8__length1;
							gint _tmp9_;
							gint _tmp10_;
#line 240 "puzzle.vala"
							if (!_tmp4_) {
#line 1293 "puzzle.c"
								gint _tmp5_;
#line 240 "puzzle.vala"
								_tmp5_ = x;
#line 240 "puzzle.vala"
								x = _tmp5_ + 1;
#line 1299 "puzzle.c"
							}
#line 240 "puzzle.vala"
							_tmp4_ = FALSE;
#line 240 "puzzle.vala"
							_tmp6_ = x;
#line 240 "puzzle.vala"
							_tmp7_ = self->width;
#line 240 "puzzle.vala"
							if (!(_tmp6_ < _tmp7_)) {
#line 240 "puzzle.vala"
								break;
#line 1311 "puzzle.c"
							}
#line 242 "puzzle.vala"
							_tmp8_ = self->map;
#line 242 "puzzle.vala"
							_tmp8__length1 = self->map_length1;
#line 242 "puzzle.vala"
							_tmp9_ = x;
#line 242 "puzzle.vala"
							_tmp10_ = y;
#line 242 "puzzle.vala"
							if (((gint) puzzle_get_piece_id (self, _tmp8_, _tmp8__length1, _tmp9_, _tmp10_)) == id) {
#line 1323 "puzzle.c"
								gchar z = '\0';
								gchar* _tmp11_;
								gint _tmp11__length1;
								gint _tmp12_;
								gint _tmp13_;
								gboolean _tmp14_ = FALSE;
								gboolean _tmp15_ = FALSE;
								gboolean _tmp16_ = FALSE;
								gchar _tmp17_;
#line 244 "puzzle.vala"
								_tmp11_ = self->map;
#line 244 "puzzle.vala"
								_tmp11__length1 = self->map_length1;
#line 244 "puzzle.vala"
								_tmp12_ = x;
#line 244 "puzzle.vala"
								_tmp13_ = y;
#line 244 "puzzle.vala"
								z = puzzle_get_piece_id (self, _tmp11_, _tmp11__length1, _tmp12_ + dx, _tmp13_ + dy);
#line 245 "puzzle.vala"
								_tmp17_ = z;
#line 245 "puzzle.vala"
								if (_tmp17_ == ' ') {
#line 245 "puzzle.vala"
									_tmp16_ = TRUE;
#line 1349 "puzzle.c"
								} else {
									gchar _tmp18_;
#line 245 "puzzle.vala"
									_tmp18_ = z;
#line 245 "puzzle.vala"
									_tmp16_ = _tmp18_ == '.';
#line 1356 "puzzle.c"
								}
#line 245 "puzzle.vala"
								if (_tmp16_) {
#line 245 "puzzle.vala"
									_tmp15_ = TRUE;
#line 1362 "puzzle.c"
								} else {
									gchar _tmp19_;
#line 245 "puzzle.vala"
									_tmp19_ = z;
#line 245 "puzzle.vala"
									_tmp15_ = ((gint) _tmp19_) == id;
#line 1369 "puzzle.c"
								}
#line 245 "puzzle.vala"
								if (_tmp15_) {
#line 245 "puzzle.vala"
									_tmp14_ = TRUE;
#line 1375 "puzzle.c"
								} else {
									gboolean _tmp20_ = FALSE;
#line 245 "puzzle.vala"
									if (id == ((gint) '*')) {
#line 1380 "puzzle.c"
										gchar _tmp21_;
#line 245 "puzzle.vala"
										_tmp21_ = z;
#line 245 "puzzle.vala"
										_tmp20_ = _tmp21_ == '-';
#line 1386 "puzzle.c"
									} else {
#line 245 "puzzle.vala"
										_tmp20_ = FALSE;
#line 1390 "puzzle.c"
									}
#line 245 "puzzle.vala"
									_tmp14_ = _tmp20_;
#line 1394 "puzzle.c"
								}
#line 245 "puzzle.vala"
								if (!_tmp14_) {
#line 246 "puzzle.vala"
									result = FALSE;
#line 246 "puzzle.vala"
									return result;
#line 1402 "puzzle.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 251 "puzzle.vala"
	result = TRUE;
#line 251 "puzzle.vala"
	return result;
#line 1415 "puzzle.c"
}


static gchar*
_vala_array_dup5 (gchar* self,
                  int length)
{
#line 256 "puzzle.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1425 "puzzle.c"
}


static gchar*
_vala_array_dup6 (gchar* self,
                  int length)
{
#line 290 "puzzle.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1435 "puzzle.c"
}


static gboolean
puzzle_do_move_piece (Puzzle* self,
                      gchar id,
                      gint dx,
                      gint dy)
{
	gboolean result = FALSE;
	gchar* tmpmap = NULL;
	gchar* _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gint tmpmap_length1;
	gint _tmpmap_size_;
	gchar* _tmp58_;
	gint _tmp58__length1;
	gchar* _tmp59_;
	gint _tmp59__length1;
#line 254 "puzzle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 256 "puzzle.vala"
	_tmp0_ = self->map;
#line 256 "puzzle.vala"
	_tmp0__length1 = self->map_length1;
#line 256 "puzzle.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 256 "puzzle.vala"
	_tmp1__length1 = _tmp0__length1;
#line 256 "puzzle.vala"
	tmpmap = _tmp1_;
#line 256 "puzzle.vala"
	tmpmap_length1 = _tmp1__length1;
#line 256 "puzzle.vala"
	_tmpmap_size_ = tmpmap_length1;
#line 1473 "puzzle.c"
	{
		gint y = 0;
#line 259 "puzzle.vala"
		y = 0;
#line 1478 "puzzle.c"
		{
			gboolean _tmp2_ = FALSE;
#line 259 "puzzle.vala"
			_tmp2_ = TRUE;
#line 259 "puzzle.vala"
			while (TRUE) {
#line 1485 "puzzle.c"
				gint _tmp4_;
				gint _tmp5_;
#line 259 "puzzle.vala"
				if (!_tmp2_) {
#line 1490 "puzzle.c"
					gint _tmp3_;
#line 259 "puzzle.vala"
					_tmp3_ = y;
#line 259 "puzzle.vala"
					y = _tmp3_ + 1;
#line 1496 "puzzle.c"
				}
#line 259 "puzzle.vala"
				_tmp2_ = FALSE;
#line 259 "puzzle.vala"
				_tmp4_ = y;
#line 259 "puzzle.vala"
				_tmp5_ = self->height;
#line 259 "puzzle.vala"
				if (!(_tmp4_ < _tmp5_)) {
#line 259 "puzzle.vala"
					break;
#line 1508 "puzzle.c"
				}
				{
					gint x = 0;
#line 260 "puzzle.vala"
					x = 0;
#line 1514 "puzzle.c"
					{
						gboolean _tmp6_ = FALSE;
#line 260 "puzzle.vala"
						_tmp6_ = TRUE;
#line 260 "puzzle.vala"
						while (TRUE) {
#line 1521 "puzzle.c"
							gint _tmp8_;
							gint _tmp9_;
							gchar* _tmp10_;
							gint _tmp10__length1;
							gint _tmp11_;
							gint _tmp12_;
#line 260 "puzzle.vala"
							if (!_tmp6_) {
#line 1530 "puzzle.c"
								gint _tmp7_;
#line 260 "puzzle.vala"
								_tmp7_ = x;
#line 260 "puzzle.vala"
								x = _tmp7_ + 1;
#line 1536 "puzzle.c"
							}
#line 260 "puzzle.vala"
							_tmp6_ = FALSE;
#line 260 "puzzle.vala"
							_tmp8_ = x;
#line 260 "puzzle.vala"
							_tmp9_ = self->width;
#line 260 "puzzle.vala"
							if (!(_tmp8_ < _tmp9_)) {
#line 260 "puzzle.vala"
								break;
#line 1548 "puzzle.c"
							}
#line 261 "puzzle.vala"
							_tmp10_ = tmpmap;
#line 261 "puzzle.vala"
							_tmp10__length1 = tmpmap_length1;
#line 261 "puzzle.vala"
							_tmp11_ = x;
#line 261 "puzzle.vala"
							_tmp12_ = y;
#line 261 "puzzle.vala"
							if (puzzle_get_piece_id (self, _tmp10_, _tmp10__length1, _tmp11_, _tmp12_) == id) {
#line 1560 "puzzle.c"
								gchar* _tmp13_;
								gint _tmp13__length1;
								gint _tmp14_;
								gint _tmp15_;
#line 262 "puzzle.vala"
								_tmp13_ = tmpmap;
#line 262 "puzzle.vala"
								_tmp13__length1 = tmpmap_length1;
#line 262 "puzzle.vala"
								_tmp14_ = x;
#line 262 "puzzle.vala"
								_tmp15_ = y;
#line 262 "puzzle.vala"
								puzzle_set_piece_id (self, _tmp13_, _tmp13__length1, _tmp14_, _tmp15_, ' ');
#line 1575 "puzzle.c"
							}
						}
					}
				}
			}
		}
	}
	{
		gint y = 0;
#line 264 "puzzle.vala"
		y = 0;
#line 1587 "puzzle.c"
		{
			gboolean _tmp16_ = FALSE;
#line 264 "puzzle.vala"
			_tmp16_ = TRUE;
#line 264 "puzzle.vala"
			while (TRUE) {
#line 1594 "puzzle.c"
				gint _tmp18_;
				gint _tmp19_;
#line 264 "puzzle.vala"
				if (!_tmp16_) {
#line 1599 "puzzle.c"
					gint _tmp17_;
#line 264 "puzzle.vala"
					_tmp17_ = y;
#line 264 "puzzle.vala"
					y = _tmp17_ + 1;
#line 1605 "puzzle.c"
				}
#line 264 "puzzle.vala"
				_tmp16_ = FALSE;
#line 264 "puzzle.vala"
				_tmp18_ = y;
#line 264 "puzzle.vala"
				_tmp19_ = self->height;
#line 264 "puzzle.vala"
				if (!(_tmp18_ < _tmp19_)) {
#line 264 "puzzle.vala"
					break;
#line 1617 "puzzle.c"
				}
				{
					gint x = 0;
#line 265 "puzzle.vala"
					x = 0;
#line 1623 "puzzle.c"
					{
						gboolean _tmp20_ = FALSE;
#line 265 "puzzle.vala"
						_tmp20_ = TRUE;
#line 265 "puzzle.vala"
						while (TRUE) {
#line 1630 "puzzle.c"
							gint _tmp22_;
							gint _tmp23_;
							gchar* _tmp24_;
							gint _tmp24__length1;
							gint _tmp25_;
							gint _tmp26_;
#line 265 "puzzle.vala"
							if (!_tmp20_) {
#line 1639 "puzzle.c"
								gint _tmp21_;
#line 265 "puzzle.vala"
								_tmp21_ = x;
#line 265 "puzzle.vala"
								x = _tmp21_ + 1;
#line 1645 "puzzle.c"
							}
#line 265 "puzzle.vala"
							_tmp20_ = FALSE;
#line 265 "puzzle.vala"
							_tmp22_ = x;
#line 265 "puzzle.vala"
							_tmp23_ = self->width;
#line 265 "puzzle.vala"
							if (!(_tmp22_ < _tmp23_)) {
#line 265 "puzzle.vala"
								break;
#line 1657 "puzzle.c"
							}
#line 266 "puzzle.vala"
							_tmp24_ = self->map;
#line 266 "puzzle.vala"
							_tmp24__length1 = self->map_length1;
#line 266 "puzzle.vala"
							_tmp25_ = x;
#line 266 "puzzle.vala"
							_tmp26_ = y;
#line 266 "puzzle.vala"
							if (puzzle_get_piece_id (self, _tmp24_, _tmp24__length1, _tmp25_, _tmp26_) == id) {
#line 1669 "puzzle.c"
								gchar* _tmp27_;
								gint _tmp27__length1;
								gint _tmp28_;
								gint _tmp29_;
#line 267 "puzzle.vala"
								_tmp27_ = tmpmap;
#line 267 "puzzle.vala"
								_tmp27__length1 = tmpmap_length1;
#line 267 "puzzle.vala"
								_tmp28_ = x;
#line 267 "puzzle.vala"
								_tmp29_ = y;
#line 267 "puzzle.vala"
								puzzle_set_piece_id (self, _tmp27_, _tmp27__length1, _tmp28_ + dx, _tmp29_ + dy, id);
#line 1684 "puzzle.c"
							}
						}
					}
				}
			}
		}
	}
	{
		gint y = 0;
#line 270 "puzzle.vala"
		y = 0;
#line 1696 "puzzle.c"
		{
			gboolean _tmp30_ = FALSE;
#line 270 "puzzle.vala"
			_tmp30_ = TRUE;
#line 270 "puzzle.vala"
			while (TRUE) {
#line 1703 "puzzle.c"
				gint _tmp32_;
				gint _tmp33_;
#line 270 "puzzle.vala"
				if (!_tmp30_) {
#line 1708 "puzzle.c"
					gint _tmp31_;
#line 270 "puzzle.vala"
					_tmp31_ = y;
#line 270 "puzzle.vala"
					y = _tmp31_ + 1;
#line 1714 "puzzle.c"
				}
#line 270 "puzzle.vala"
				_tmp30_ = FALSE;
#line 270 "puzzle.vala"
				_tmp32_ = y;
#line 270 "puzzle.vala"
				_tmp33_ = self->height;
#line 270 "puzzle.vala"
				if (!(_tmp32_ < _tmp33_)) {
#line 270 "puzzle.vala"
					break;
#line 1726 "puzzle.c"
				}
				{
					gint x = 0;
#line 272 "puzzle.vala"
					x = 0;
#line 1732 "puzzle.c"
					{
						gboolean _tmp34_ = FALSE;
#line 272 "puzzle.vala"
						_tmp34_ = TRUE;
#line 272 "puzzle.vala"
						while (TRUE) {
#line 1739 "puzzle.c"
							gint _tmp36_;
							gint _tmp37_;
							gboolean _tmp38_ = FALSE;
							gchar* _tmp39_;
							gint _tmp39__length1;
							gint _tmp40_;
							gint _tmp41_;
							gboolean _tmp48_ = FALSE;
							gchar* _tmp49_;
							gint _tmp49__length1;
							gint _tmp50_;
							gint _tmp51_;
#line 272 "puzzle.vala"
							if (!_tmp34_) {
#line 1754 "puzzle.c"
								gint _tmp35_;
#line 272 "puzzle.vala"
								_tmp35_ = x;
#line 272 "puzzle.vala"
								x = _tmp35_ + 1;
#line 1760 "puzzle.c"
							}
#line 272 "puzzle.vala"
							_tmp34_ = FALSE;
#line 272 "puzzle.vala"
							_tmp36_ = x;
#line 272 "puzzle.vala"
							_tmp37_ = self->width;
#line 272 "puzzle.vala"
							if (!(_tmp36_ < _tmp37_)) {
#line 272 "puzzle.vala"
								break;
#line 1772 "puzzle.c"
							}
#line 274 "puzzle.vala"
							_tmp39_ = tmpmap;
#line 274 "puzzle.vala"
							_tmp39__length1 = tmpmap_length1;
#line 274 "puzzle.vala"
							_tmp40_ = x;
#line 274 "puzzle.vala"
							_tmp41_ = y;
#line 274 "puzzle.vala"
							if (puzzle_get_piece_id (self, _tmp39_, _tmp39__length1, _tmp40_, _tmp41_) == ' ') {
#line 1784 "puzzle.c"
								gchar* _tmp42_;
								gint _tmp42__length1;
								gint _tmp43_;
								gint _tmp44_;
#line 274 "puzzle.vala"
								_tmp42_ = self->orig_map;
#line 274 "puzzle.vala"
								_tmp42__length1 = self->orig_map_length1;
#line 274 "puzzle.vala"
								_tmp43_ = x;
#line 274 "puzzle.vala"
								_tmp44_ = y;
#line 274 "puzzle.vala"
								_tmp38_ = puzzle_get_piece_id (self, _tmp42_, _tmp42__length1, _tmp43_, _tmp44_) == '.';
#line 1799 "puzzle.c"
							} else {
#line 274 "puzzle.vala"
								_tmp38_ = FALSE;
#line 1803 "puzzle.c"
							}
#line 274 "puzzle.vala"
							if (_tmp38_) {
#line 1807 "puzzle.c"
								gchar* _tmp45_;
								gint _tmp45__length1;
								gint _tmp46_;
								gint _tmp47_;
#line 275 "puzzle.vala"
								_tmp45_ = tmpmap;
#line 275 "puzzle.vala"
								_tmp45__length1 = tmpmap_length1;
#line 275 "puzzle.vala"
								_tmp46_ = x;
#line 275 "puzzle.vala"
								_tmp47_ = y;
#line 275 "puzzle.vala"
								puzzle_set_piece_id (self, _tmp45_, _tmp45__length1, _tmp46_, _tmp47_, '.');
#line 1822 "puzzle.c"
							}
#line 276 "puzzle.vala"
							_tmp49_ = tmpmap;
#line 276 "puzzle.vala"
							_tmp49__length1 = tmpmap_length1;
#line 276 "puzzle.vala"
							_tmp50_ = x;
#line 276 "puzzle.vala"
							_tmp51_ = y;
#line 276 "puzzle.vala"
							if (puzzle_get_piece_id (self, _tmp49_, _tmp49__length1, _tmp50_, _tmp51_) == ' ') {
#line 1834 "puzzle.c"
								gchar* _tmp52_;
								gint _tmp52__length1;
								gint _tmp53_;
								gint _tmp54_;
#line 276 "puzzle.vala"
								_tmp52_ = self->orig_map;
#line 276 "puzzle.vala"
								_tmp52__length1 = self->orig_map_length1;
#line 276 "puzzle.vala"
								_tmp53_ = x;
#line 276 "puzzle.vala"
								_tmp54_ = y;
#line 276 "puzzle.vala"
								_tmp48_ = puzzle_get_piece_id (self, _tmp52_, _tmp52__length1, _tmp53_, _tmp54_) == '-';
#line 1849 "puzzle.c"
							} else {
#line 276 "puzzle.vala"
								_tmp48_ = FALSE;
#line 1853 "puzzle.c"
							}
#line 276 "puzzle.vala"
							if (_tmp48_) {
#line 1857 "puzzle.c"
								gchar* _tmp55_;
								gint _tmp55__length1;
								gint _tmp56_;
								gint _tmp57_;
#line 277 "puzzle.vala"
								_tmp55_ = tmpmap;
#line 277 "puzzle.vala"
								_tmp55__length1 = tmpmap_length1;
#line 277 "puzzle.vala"
								_tmp56_ = x;
#line 277 "puzzle.vala"
								_tmp57_ = y;
#line 277 "puzzle.vala"
								puzzle_set_piece_id (self, _tmp55_, _tmp55__length1, _tmp56_, _tmp57_, '-');
#line 1872 "puzzle.c"
							}
						}
					}
				}
			}
		}
	}
#line 288 "puzzle.vala"
	g_signal_emit (self, puzzle_signals[PUZZLE_CHANGED_SIGNAL], 0);
#line 290 "puzzle.vala"
	_tmp58_ = tmpmap;
#line 290 "puzzle.vala"
	_tmp58__length1 = tmpmap_length1;
#line 290 "puzzle.vala"
	_tmp59_ = (_tmp58_ != NULL) ? _vala_array_dup6 (_tmp58_, _tmp58__length1) : ((gpointer) _tmp58_);
#line 290 "puzzle.vala"
	_tmp59__length1 = _tmp58__length1;
#line 290 "puzzle.vala"
	self->map = (g_free (self->map), NULL);
#line 290 "puzzle.vala"
	self->map = _tmp59_;
#line 290 "puzzle.vala"
	self->map_length1 = _tmp59__length1;
#line 292 "puzzle.vala"
	result = TRUE;
#line 292 "puzzle.vala"
	tmpmap = (g_free (tmpmap), NULL);
#line 292 "puzzle.vala"
	return result;
#line 1902 "puzzle.c"
}


static void
puzzle_class_init (PuzzleClass * klass)
{
#line 87 "puzzle.vala"
	puzzle_parent_class = g_type_class_peek_parent (klass);
#line 87 "puzzle.vala"
	G_OBJECT_CLASS (klass)->finalize = puzzle_finalize;
#line 87 "puzzle.vala"
	puzzle_signals[PUZZLE_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 87 "puzzle.vala"
	puzzle_signals[PUZZLE_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1917 "puzzle.c"
}


static void
puzzle_instance_init (Puzzle * self)
{
#line 98 "puzzle.vala"
	self->moves = 0;
#line 1926 "puzzle.c"
}


static void
puzzle_finalize (GObject * obj)
{
	Puzzle * self;
#line 87 "puzzle.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE, Puzzle);
#line 92 "puzzle.vala"
	self->map = (g_free (self->map), NULL);
#line 93 "puzzle.vala"
	self->move_map = (g_free (self->move_map), NULL);
#line 94 "puzzle.vala"
	self->orig_map = (g_free (self->orig_map), NULL);
#line 95 "puzzle.vala"
	self->lastmove_map = (g_free (self->lastmove_map), NULL);
#line 96 "puzzle.vala"
	self->undomove_map = (g_free (self->undomove_map), NULL);
#line 87 "puzzle.vala"
	G_OBJECT_CLASS (puzzle_parent_class)->finalize (obj);
#line 1948 "puzzle.c"
}


GType
puzzle_get_type (void)
{
	static volatile gsize puzzle_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Puzzle), 0, (GInstanceInitFunc) puzzle_instance_init, NULL };
		GType puzzle_type_id;
		puzzle_type_id = g_type_register_static (G_TYPE_OBJECT, "Puzzle", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_type_id__volatile, puzzle_type_id);
	}
	return puzzle_type_id__volatile;
}



