/* contacts-utils.c generated by valac 0.36.4, the Vala compiler
 * generated from contacts-utils.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <folks/folks-telepathy.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/folks.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_FREEDESKTOP_APPLICATION (contacts_freedesktop_application_get_type ())
#define CONTACTS_FREEDESKTOP_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_FREEDESKTOP_APPLICATION, ContactsFreedesktopApplication))
#define CONTACTS_IS_FREEDESKTOP_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_FREEDESKTOP_APPLICATION))
#define CONTACTS_FREEDESKTOP_APPLICATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CONTACTS_TYPE_FREEDESKTOP_APPLICATION, ContactsFreedesktopApplicationIface))

typedef struct _ContactsFreedesktopApplication ContactsFreedesktopApplication;
typedef struct _ContactsFreedesktopApplicationIface ContactsFreedesktopApplicationIface;

#define CONTACTS_TYPE_FREEDESKTOP_APPLICATION_PROXY (contacts_freedesktop_application_proxy_get_type ())
typedef GDBusProxy ContactsFreedesktopApplicationProxy;
typedef GDBusProxyClass ContactsFreedesktopApplicationProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_CENTER (center_get_type ())
#define CENTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CENTER, Center))
#define CENTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CENTER, CenterClass))
#define IS_CENTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CENTER))
#define IS_CENTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CENTER))
#define CENTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CENTER, CenterClass))

typedef struct _Center Center;
typedef struct _CenterClass CenterClass;
typedef struct _CenterPrivate CenterPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;

struct _ContactsFreedesktopApplicationIface {
	GTypeInterface parent_iface;
	void (*ActivateAction) (ContactsFreedesktopApplication* self, const gchar* action, GVariant** parameter, int parameter_length1, GHashTable* data, GError** error);
};

struct _Center {
	GtkBin parent_instance;
	CenterPrivate * priv;
};

struct _CenterClass {
	GtkBinClass parent_class;
};

struct _CenterPrivate {
	gint _max_width;
	gdouble _xalign;
};


static gpointer center_parent_class = NULL;

gboolean contacts_is_set (const gchar* str);
GtkBuilder* contacts_load_ui (const gchar* ui);
GtkCssProvider* contacts_load_css (const gchar* css);
void contacts_add_separator (GtkListBoxRow* row, GtkListBoxRow* before_row);
GType contacts_freedesktop_application_proxy_get_type (void) G_GNUC_CONST;
guint contacts_freedesktop_application_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType contacts_freedesktop_application_get_type (void) G_GNUC_CONST;
void contacts_freedesktop_application_ActivateAction (ContactsFreedesktopApplication* self, const gchar* action, GVariant** parameter, int parameter_length1, GHashTable* data, GError** error);
static void contacts_freedesktop_application_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void contacts_freedesktop_application_proxy_ActivateAction (ContactsFreedesktopApplication* self, const gchar* action, GVariant** parameter, int parameter_length1, GHashTable* data, GError** error);
static void contacts_freedesktop_application_proxy_contacts_freedesktop_application_interface_init (ContactsFreedesktopApplicationIface* iface);
static void _dbus_contacts_freedesktop_application_ActivateAction (ContactsFreedesktopApplication* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void contacts_freedesktop_application_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* contacts_freedesktop_application_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean contacts_freedesktop_application_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _contacts_freedesktop_application_unregister_object (gpointer user_data);
void contacts_activate_action (const gchar* app_id, const gchar* action, GVariant* parameter, guint32 timestamp);
static void _vala_array_add9 (GVariant** * array, int* length, int* size, GVariant* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
GType center_get_type (void) G_GNUC_CONST;
#define CENTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CENTER, CenterPrivate))
enum  {
	CENTER_DUMMY_PROPERTY,
	CENTER_MAX_WIDTH,
	CENTER_XALIGN
};
Center* center_new (void);
Center* center_construct (GType object_type);
void center_set_xalign (Center* self, gdouble value);
static void center_real_get_preferred_height (GtkWidget* base, gint* minimum_height, gint* natural_height);
static void center_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width);
static void center_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
gint center_get_max_width (Center* self);
gdouble center_get_xalign (Center* self);
void center_set_max_width (Center* self, gint value);
static void center_finalize (GObject * obj);
static void _vala_center_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_center_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
void contacts_utils_compose_mail (const gchar* email);
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
void contacts_utils_start_call (const gchar* contact_id, GeeHashMap* accounts);
void contacts_utils_start_call_with_account (const gchar* contact_id, TpAccount* account);
gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection);
void contacts_utils_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2);
void contacts_utils_cairo_rounded_box (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius);
gunichar contacts_utils_strip_char (gunichar ch);
gboolean contacts_utils_string_is_empty (const gchar* str);
gchar* contacts_utils_canonicalize_for_search (const gchar* str);
void contacts_utils_grab_entry_focus_no_select (GtkEntry* entry);
gchar** contacts_utils_get_stock_avatars (int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void _vala_array_add10 (gchar** * array, int* length, int* size, gchar* value);
GType contacts_store_get_type (void) G_GNUC_CONST;
FolksPersonaStore** contacts_utils_get_eds_address_books (ContactsStore* contacts_store, int* result_length1);
FolksBackendStore* contacts_store_get_backend_store (ContactsStore* self);
static void _vala_array_add11 (FolksPersonaStore** * array, int* length, int* size, FolksPersonaStore* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _contacts_freedesktop_application_dbus_arg_info_ActivateAction_action = {-1, "action", "s"};
static const GDBusArgInfo _contacts_freedesktop_application_dbus_arg_info_ActivateAction_parameter = {-1, "parameter", "av"};
static const GDBusArgInfo _contacts_freedesktop_application_dbus_arg_info_ActivateAction_data = {-1, "data", "a{sv}"};
static const GDBusArgInfo * const _contacts_freedesktop_application_dbus_arg_info_ActivateAction_in[] = {&_contacts_freedesktop_application_dbus_arg_info_ActivateAction_action, &_contacts_freedesktop_application_dbus_arg_info_ActivateAction_parameter, &_contacts_freedesktop_application_dbus_arg_info_ActivateAction_data, NULL};
static const GDBusArgInfo * const _contacts_freedesktop_application_dbus_arg_info_ActivateAction_out[] = {NULL};
static const GDBusMethodInfo _contacts_freedesktop_application_dbus_method_info_ActivateAction = {-1, "ActivateAction", (GDBusArgInfo **) (&_contacts_freedesktop_application_dbus_arg_info_ActivateAction_in), (GDBusArgInfo **) (&_contacts_freedesktop_application_dbus_arg_info_ActivateAction_out)};
static const GDBusMethodInfo * const _contacts_freedesktop_application_dbus_method_info[] = {&_contacts_freedesktop_application_dbus_method_info_ActivateAction, NULL};
static const GDBusSignalInfo * const _contacts_freedesktop_application_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _contacts_freedesktop_application_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _contacts_freedesktop_application_dbus_interface_info = {-1, "org.freedesktop.Application", (GDBusMethodInfo **) (&_contacts_freedesktop_application_dbus_method_info), (GDBusSignalInfo **) (&_contacts_freedesktop_application_dbus_signal_info), (GDBusPropertyInfo **) (&_contacts_freedesktop_application_dbus_property_info)};
static const GDBusInterfaceVTable _contacts_freedesktop_application_dbus_interface_vtable = {contacts_freedesktop_application_dbus_interface_method_call, contacts_freedesktop_application_dbus_interface_get_property, contacts_freedesktop_application_dbus_interface_set_property};

gboolean contacts_is_set (const gchar* str) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	_tmp1_ = str;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = str;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


GtkBuilder* contacts_load_ui (const gchar* ui) {
	GtkBuilder* result = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ui != NULL, NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	{
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = ui;
		_tmp2_ = g_strconcat ("/org/gnome/contacts/ui/", _tmp1_, NULL, NULL);
		_tmp3_ = _tmp2_;
		gtk_builder_add_from_resource (builder, _tmp3_, &_inner_error_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e->message;
		g_error ("contacts-utils.vala:35: loading ui file: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally27:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = builder;
	return result;
}


GtkCssProvider* contacts_load_css (const gchar* css) {
	GtkCssProvider* result = NULL;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (css != NULL, NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	{
		GFile* file = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp1_ = css;
		_tmp2_ = g_strconcat ("resource:///org/gnome/contacts/ui/", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_new_for_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		file = _tmp5_;
		gtk_css_provider_load_from_file (provider, file, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch28_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("contacts-utils.vala:46: loading css: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = provider;
	return result;
}


void contacts_add_separator (GtkListBoxRow* row, GtkListBoxRow* before_row) {
	GtkListBoxRow* _tmp0_;
	GtkSeparator* _tmp1_;
	GtkSeparator* _tmp2_;
	g_return_if_fail (row != NULL);
	_tmp0_ = row;
	_tmp1_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_list_box_row_set_header (_tmp0_, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


void contacts_freedesktop_application_ActivateAction (ContactsFreedesktopApplication* self, const gchar* action, GVariant** parameter, int parameter_length1, GHashTable* data, GError** error) {
	g_return_if_fail (self != NULL);
	CONTACTS_FREEDESKTOP_APPLICATION_GET_INTERFACE (self)->ActivateAction (self, action, parameter, parameter_length1, data, error);
}


static void contacts_freedesktop_application_base_init (ContactsFreedesktopApplicationIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType contacts_freedesktop_application_get_type (void) {
	static volatile gsize contacts_freedesktop_application_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_freedesktop_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsFreedesktopApplicationIface), (GBaseInitFunc) contacts_freedesktop_application_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType contacts_freedesktop_application_type_id;
		contacts_freedesktop_application_type_id = g_type_register_static (G_TYPE_INTERFACE, "ContactsFreedesktopApplication", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (contacts_freedesktop_application_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (contacts_freedesktop_application_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) contacts_freedesktop_application_proxy_get_type);
		g_type_set_qdata (contacts_freedesktop_application_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Application");
		g_type_set_qdata (contacts_freedesktop_application_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_contacts_freedesktop_application_dbus_interface_info));
		g_type_set_qdata (contacts_freedesktop_application_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) contacts_freedesktop_application_register_object);
		g_once_init_leave (&contacts_freedesktop_application_type_id__volatile, contacts_freedesktop_application_type_id);
	}
	return contacts_freedesktop_application_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ContactsFreedesktopApplicationProxy, contacts_freedesktop_application_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (CONTACTS_TYPE_FREEDESKTOP_APPLICATION, contacts_freedesktop_application_proxy_contacts_freedesktop_application_interface_init) )
static void contacts_freedesktop_application_proxy_class_init (ContactsFreedesktopApplicationProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = contacts_freedesktop_application_proxy_g_signal;
}


static void contacts_freedesktop_application_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void contacts_freedesktop_application_proxy_init (ContactsFreedesktopApplicationProxy* self) {
}


static void contacts_freedesktop_application_proxy_ActivateAction (ContactsFreedesktopApplication* self, const gchar* action, GVariant** parameter, int parameter_length1, GHashTable* data, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariant** _tmp0_;
	GVariantBuilder _tmp1_;
	int _tmp2_;
	GVariantBuilder _tmp3_;
	GHashTableIter _tmp4_;
	gpointer _tmp5_;
	gpointer _tmp6_;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Application", "ActivateAction");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	_tmp0_ = parameter;
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE ("av"));
	for (_tmp2_ = 0; _tmp2_ < parameter_length1; _tmp2_++) {
		g_variant_builder_add_value (&_tmp1_, g_variant_new_variant (*_tmp0_));
		_tmp0_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp1_));
	g_hash_table_iter_init (&_tmp4_, data);
	g_variant_builder_init (&_tmp3_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp4_, &_tmp5_, &_tmp6_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp5_;
		_value = (GVariant*) _tmp6_;
		g_variant_builder_add (&_tmp3_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp3_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void contacts_freedesktop_application_proxy_contacts_freedesktop_application_interface_init (ContactsFreedesktopApplicationIface* iface) {
	iface->ActivateAction = contacts_freedesktop_application_proxy_ActivateAction;
}


static void _dbus_contacts_freedesktop_application_ActivateAction (ContactsFreedesktopApplication* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* action = NULL;
	GVariant* _tmp7_;
	GVariant** parameter = NULL;
	int parameter_length1 = 0;
	GVariant* _tmp8_;
	GVariant** _tmp9_;
	int _tmp9__length;
	int _tmp9__size;
	int _tmp9__length1;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	GHashTable* data = NULL;
	GVariant* _tmp12_;
	GHashTable* _tmp13_;
	GVariantIter _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp9_ = g_new (GVariant*, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	g_variant_iter_init (&_tmp10_, _tmp8_);
	for (; (_tmp11_ = g_variant_iter_next_value (&_tmp10_)) != NULL; _tmp9__length1++) {
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (GVariant*, _tmp9_, _tmp9__size + 1);
		}
		_tmp9_[_tmp9__length++] = g_variant_get_variant (_tmp11_);
		g_variant_unref (_tmp11_);
	}
	parameter_length1 = _tmp9__length1;
	_tmp9_[_tmp9__length] = NULL;
	parameter = _tmp9_;
	g_variant_unref (_tmp8_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp13_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp14_, _tmp12_);
	while (g_variant_iter_loop (&_tmp14_, "{?*}", &_tmp15_, &_tmp16_)) {
		g_hash_table_insert (_tmp13_, g_variant_dup_string (_tmp15_, NULL), g_variant_get_variant (_tmp16_));
	}
	data = _tmp13_;
	g_variant_unref (_tmp12_);
	contacts_freedesktop_application_ActivateAction (self, action, parameter, parameter_length1, data, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (action);
	parameter = (_vala_array_free (parameter, parameter_length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_hash_table_unref0 (data);
}


static void contacts_freedesktop_application_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ActivateAction") == 0) {
		_dbus_contacts_freedesktop_application_ActivateAction (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* contacts_freedesktop_application_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean contacts_freedesktop_application_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint contacts_freedesktop_application_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_contacts_freedesktop_application_dbus_interface_info), &_contacts_freedesktop_application_dbus_interface_vtable, data, _contacts_freedesktop_application_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _contacts_freedesktop_application_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch30_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch30_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally30;
	__catch30_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally30:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void _vala_array_add9 (GVariant** * array, int* length, int* size, GVariant* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


void contacts_activate_action (const gchar* app_id, const gchar* action, GVariant* parameter, guint32 timestamp) {
	ContactsFreedesktopApplication* con = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (app_id != NULL);
	g_return_if_fail (action != NULL);
	con = NULL;
	{
		gchar* object_path = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp5_;
		GdkDisplay* _tmp6_;
		GDesktopAppInfo* info = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GDesktopAppInfo* _tmp10_;
		GDesktopAppInfo* _tmp11_;
		GdkAppLaunchContext* context = NULL;
		GdkDisplay* _tmp12_;
		GdkAppLaunchContext* _tmp13_;
		ContactsFreedesktopApplication* _tmp14_ = NULL;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		ContactsFreedesktopApplication* _tmp17_;
		ContactsFreedesktopApplication* _tmp18_;
		GdkAppLaunchContext* _tmp19_;
		guint32 _tmp20_;
		GVariant** param_array = NULL;
		GVariant** _tmp21_;
		gint param_array_length1;
		gint _param_array_size_;
		GVariant* _tmp22_;
		gchar* startup_id = NULL;
		GdkAppLaunchContext* _tmp26_;
		GDesktopAppInfo* _tmp27_;
		GList* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		GHashTable* data = NULL;
		GHashFunc _tmp31_;
		GEqualFunc _tmp32_;
		GHashTable* _tmp33_;
		GHashTable* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		GVariant* _tmp37_;
		ContactsFreedesktopApplication* _tmp38_;
		const gchar* _tmp39_;
		GVariant** _tmp40_;
		gint _tmp40__length1;
		GHashTable* _tmp41_;
		_tmp0_ = app_id;
		_tmp1_ = string_replace (_tmp0_, ".", "/");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("/", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		object_path = _tmp4_;
		_tmp5_ = gdk_display_get_default ();
		_tmp6_ = _g_object_ref0 (_tmp5_);
		display = _tmp6_;
		_tmp7_ = app_id;
		_tmp8_ = g_strconcat (_tmp7_, ".desktop", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_desktop_app_info_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		info = _tmp11_;
		_tmp12_ = display;
		_tmp13_ = gdk_display_get_app_launch_context (_tmp12_);
		context = _tmp13_;
		_tmp15_ = app_id;
		_tmp16_ = object_path;
		_tmp17_ = g_initable_new (CONTACTS_TYPE_FREEDESKTOP_APPLICATION_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp15_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp16_, "g-interface-name", "org.freedesktop.Application", "g-interface-info", g_type_get_qdata (CONTACTS_TYPE_FREEDESKTOP_APPLICATION, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_tmp14_ = (ContactsFreedesktopApplication*) _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (context);
			_g_object_unref0 (info);
			_g_object_unref0 (display);
			_g_free0 (object_path);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch29_g_io_error;
			}
			_g_object_unref0 (context);
			_g_object_unref0 (info);
			_g_object_unref0 (display);
			_g_free0 (object_path);
			_g_object_unref0 (con);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp18_ = _tmp14_;
		_tmp14_ = NULL;
		_g_object_unref0 (con);
		con = _tmp18_;
		_tmp19_ = context;
		_tmp20_ = timestamp;
		gdk_app_launch_context_set_timestamp (_tmp19_, _tmp20_);
		_tmp21_ = g_new0 (GVariant*, 0 + 1);
		param_array = _tmp21_;
		param_array_length1 = 0;
		_param_array_size_ = param_array_length1;
		_tmp22_ = parameter;
		if (_tmp22_ != NULL) {
			GVariant** _tmp23_;
			gint _tmp23__length1;
			GVariant* _tmp24_;
			GVariant* _tmp25_;
			_tmp23_ = param_array;
			_tmp23__length1 = param_array_length1;
			_tmp24_ = parameter;
			_tmp25_ = _g_variant_ref0 (_tmp24_);
			_vala_array_add9 (&param_array, &param_array_length1, &_param_array_size_, _tmp25_);
		}
		_tmp26_ = context;
		_tmp27_ = info;
		_tmp28_ = NULL;
		_tmp29_ = g_app_launch_context_get_startup_notify_id ((GAppLaunchContext*) _tmp26_, (GAppInfo*) _tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		__g_list_free__g_object_unref0_0 (_tmp28_);
		startup_id = _tmp30_;
		_tmp31_ = g_str_hash;
		_tmp32_ = g_str_equal;
		_tmp33_ = g_hash_table_new_full (_tmp31_, _tmp32_, _g_free0_, _g_variant_unref0_);
		data = _tmp33_;
		_tmp34_ = data;
		_tmp35_ = g_strdup ("desktop-startup-id");
		_tmp36_ = startup_id;
		_tmp37_ = g_variant_new_string (_tmp36_);
		g_variant_ref_sink (_tmp37_);
		g_hash_table_insert (_tmp34_, _tmp35_, _tmp37_);
		_tmp38_ = con;
		_tmp39_ = action;
		_tmp40_ = param_array;
		_tmp40__length1 = param_array_length1;
		_tmp41_ = data;
		contacts_freedesktop_application_ActivateAction (_tmp38_, _tmp39_, _tmp40_, _tmp40__length1, _tmp41_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_hash_table_unref0 (data);
			_g_free0 (startup_id);
			param_array = (_vala_array_free (param_array, param_array_length1, (GDestroyNotify) g_variant_unref), NULL);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (context);
			_g_object_unref0 (info);
			_g_object_unref0 (display);
			_g_free0 (object_path);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch29_g_io_error;
			}
			_g_hash_table_unref0 (data);
			_g_free0 (startup_id);
			param_array = (_vala_array_free (param_array, param_array_length1, (GDestroyNotify) g_variant_unref), NULL);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (context);
			_g_object_unref0 (info);
			_g_object_unref0 (display);
			_g_free0 (object_path);
			_g_object_unref0 (con);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_hash_table_unref0 (data);
		_g_free0 (startup_id);
		param_array = (_vala_array_free (param_array, param_array_length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (context);
		_g_object_unref0 (info);
		_g_object_unref0 (display);
		_g_free0 (object_path);
	}
	goto __finally29;
	__catch29_g_io_error:
	{
		GError* e = NULL;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp42_ = action;
		_tmp43_ = g_strconcat ("Failed to activate action", _tmp42_, NULL);
		_tmp44_ = _tmp43_;
		g_debug ("contacts-utils.vala:88: %s", _tmp44_);
		_g_free0 (_tmp44_);
		_g_error_free0 (e);
	}
	__finally29:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (con);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (con);
}


Center* center_construct (GType object_type) {
	Center * self = NULL;
	self = (Center*) g_object_new (object_type, NULL);
	center_set_xalign (self, 0.5);
	return self;
}


Center* center_new (void) {
	return center_construct (TYPE_CENTER);
}


static void center_real_get_preferred_height (GtkWidget* base, gint* minimum_height, gint* natural_height) {
	Center * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	self = (Center*) base;
	_tmp0_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	child = _tmp1_;
	_tmp2_ = child;
	if (_tmp2_ != NULL) {
		gint min = 0;
		gint nat = 0;
		GtkWidget* _tmp3_;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_;
		gint _tmp7_;
		_tmp3_ = child;
		gtk_widget_get_preferred_height (_tmp3_, &_tmp4_, &_tmp5_);
		min = _tmp4_;
		nat = _tmp5_;
		_tmp6_ = min;
		_vala_minimum_height = _tmp6_;
		_tmp7_ = nat;
		_vala_natural_height = _tmp7_;
	} else {
		_vala_minimum_height = -1;
		_vala_natural_height = -1;
	}
	_g_object_unref0 (child);
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}


static void center_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width) {
	Center * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	self = (Center*) base;
	_tmp0_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	child = _tmp1_;
	_tmp2_ = child;
	if (_tmp2_ != NULL) {
		gint min = 0;
		gint nat = 0;
		GtkWidget* _tmp3_;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_;
		gint _tmp7_;
		_tmp3_ = child;
		gtk_widget_get_preferred_width (_tmp3_, &_tmp4_, &_tmp5_);
		min = _tmp4_;
		nat = _tmp5_;
		_tmp6_ = min;
		_vala_minimum_width = _tmp6_;
		_tmp7_ = nat;
		_vala_natural_width = _tmp7_;
	} else {
		_vala_minimum_width = -1;
		_vala_natural_width = -1;
	}
	_g_object_unref0 (child);
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}


static void center_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	Center * self;
	GtkAllocation new_alloc = {0};
	GtkAllocation _tmp0_;
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkWidget* child = NULL;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkAllocation _tmp14_;
	self = (Center*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	gtk_widget_set_allocation ((GtkWidget*) self, &_tmp0_);
	_tmp1_ = *allocation;
	new_alloc = _tmp1_;
	_tmp2_ = *allocation;
	_tmp3_ = _tmp2_.width;
	_tmp4_ = self->priv->_max_width;
	if (_tmp3_ > _tmp4_) {
		gint _tmp5_;
		GtkAllocation _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gdouble _tmp9_;
		GtkAllocation _tmp10_;
		gint _tmp11_;
		_tmp5_ = self->priv->_max_width;
		new_alloc.width = _tmp5_;
		_tmp6_ = *allocation;
		_tmp7_ = _tmp6_.width;
		_tmp8_ = self->priv->_max_width;
		_tmp9_ = self->priv->_xalign;
		_tmp10_ = *allocation;
		_tmp11_ = _tmp10_.x;
		new_alloc.x = ((gint) ((_tmp7_ - _tmp8_) * _tmp9_)) + _tmp11_;
	}
	_tmp12_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	child = _tmp13_;
	_tmp14_ = new_alloc;
	gtk_widget_size_allocate (child, &_tmp14_);
	_g_object_unref0 (child);
}


gint center_get_max_width (Center* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_max_width;
	result = _tmp0_;
	return result;
}


void center_set_max_width (Center* self, gint value) {
	g_return_if_fail (self != NULL);
	if (center_get_max_width (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_max_width = _tmp0_;
		g_object_notify ((GObject *) self, "max-width");
	}
}


gdouble center_get_xalign (Center* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_xalign;
	result = _tmp0_;
	return result;
}


void center_set_xalign (Center* self, gdouble value) {
	g_return_if_fail (self != NULL);
	if (center_get_xalign (self) != value) {
		gdouble _tmp0_;
		_tmp0_ = value;
		self->priv->_xalign = _tmp0_;
		g_object_notify ((GObject *) self, "xalign");
	}
}


static void center_class_init (CenterClass * klass) {
	center_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CenterPrivate));
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget *, gint*, gint*)) center_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget *, gint*, gint*)) center_real_get_preferred_width;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget *, GtkAllocation*)) center_real_size_allocate;
	G_OBJECT_CLASS (klass)->get_property = _vala_center_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_center_set_property;
	G_OBJECT_CLASS (klass)->finalize = center_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CENTER_MAX_WIDTH, g_param_spec_int ("max-width", "max-width", "max-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CENTER_XALIGN, g_param_spec_double ("xalign", "xalign", "xalign", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void center_instance_init (Center * self) {
	self->priv = CENTER_GET_PRIVATE (self);
}


static void center_finalize (GObject * obj) {
	Center * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CENTER, Center);
	G_OBJECT_CLASS (center_parent_class)->finalize (obj);
}


GType center_get_type (void) {
	static volatile gsize center_type_id__volatile = 0;
	if (g_once_init_enter (&center_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CenterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) center_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Center), 0, (GInstanceInitFunc) center_instance_init, NULL };
		GType center_type_id;
		center_type_id = g_type_register_static (gtk_bin_get_type (), "Center", &g_define_type_info, 0);
		g_once_init_leave (&center_type_id__volatile, center_type_id);
	}
	return center_type_id__volatile;
}


static void _vala_center_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Center * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CENTER, Center);
	switch (property_id) {
		case CENTER_MAX_WIDTH:
		g_value_set_int (value, center_get_max_width (self));
		break;
		case CENTER_XALIGN:
		g_value_set_double (value, center_get_xalign (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_center_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Center * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CENTER, Center);
	switch (property_id) {
		case CENTER_MAX_WIDTH:
		center_set_max_width (self, g_value_get_int (value));
		break;
		case CENTER_XALIGN:
		center_set_xalign (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void contacts_utils_compose_mail (const gchar* email) {
	gchar* mailto_uri = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (email != NULL);
	_tmp0_ = email;
	_tmp1_ = g_uri_escape_string (_tmp0_, "@", FALSE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("mailto:", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	mailto_uri = _tmp4_;
	{
		gtk_show_uri_on_window (NULL, mailto_uri, (guint32) 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch31_g_error;
		}
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_debug ("contacts-utils.vala:150: Couldn't launch URI \"%s\": %s", mailto_uri, _tmp6_);
		_g_error_free0 (e);
	}
	__finally31:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (mailto_uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (mailto_uri);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id) {
	TpfPersona* im_persona = NULL;
	ContactsContact* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	TpfPersona* _tmp3_;
	TpAccount* account = NULL;
	FolksPersonaStore* _tmp4_;
	FolksPersonaStore* _tmp5_;
	TpAccount* _tmp6_;
	TpAccount* _tmp7_;
	TpAccount* _tmp8_;
	GHashTable* request_dict = NULL;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	GValue* _tmp12_ = NULL;
	GValue* _tmp13_ = NULL;
	const gchar* _tmp14_;
	GValue* _tmp15_ = NULL;
	TpAccountChannelRequest* request = NULL;
	TpAccountChannelRequest* _tmp16_;
	g_return_if_fail (contact != NULL);
	g_return_if_fail (protocol != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = contact;
	_tmp1_ = protocol;
	_tmp2_ = id;
	_tmp3_ = contacts_contact_find_im_persona (_tmp0_, _tmp1_, _tmp2_);
	im_persona = _tmp3_;
	_tmp4_ = folks_persona_get_store ((FolksPersona*) im_persona);
	_tmp5_ = _tmp4_;
	_tmp6_ = tpf_persona_store_get_account (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _tmp5_) : NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	account = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, NULL, __vala_GValue_free0_);
	request_dict = _tmp11_;
	_tmp12_ = g_new0 (GValue, 1);
	g_value_init (_tmp12_, G_TYPE_STRING);
	g_value_set_string (_tmp12_, TP_IFACE_CHANNEL_TYPE_TEXT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_CHANNEL_TYPE, _tmp12_);
	_tmp13_ = g_new0 (GValue, 1);
	g_value_init (_tmp13_, G_TYPE_INT);
	g_value_set_int (_tmp13_, (gint) TP_HANDLE_TYPE_CONTACT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_HANDLE_TYPE, _tmp13_);
	_tmp14_ = id;
	_tmp15_ = g_new0 (GValue, 1);
	g_value_init (_tmp15_, G_TYPE_STRING);
	g_value_set_string (_tmp15_, _tmp14_);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_ID, _tmp15_);
	_tmp16_ = tp_account_channel_request_new (account, request_dict, G_MAXINT64);
	request = _tmp16_;
	tp_account_channel_request_ensure_channel_async (request, "org.freedesktop.Telepathy.Client.Empathy.Chat", NULL, NULL, NULL);
	_g_object_unref0 (request);
	_g_hash_table_unref0 (request_dict);
	_g_object_unref0 (account);
	_g_object_unref0 (im_persona);
}


void contacts_utils_start_call (const gchar* contact_id, GeeHashMap* accounts) {
	TpAccount* account = NULL;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gint _tmp4_;
	gpointer* _tmp5_;
	TpAccount** _tmp6_;
	gint _tmp6__length1;
	TpAccount* _tmp7_;
	TpAccount* _tmp8_;
	TpAccount* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (contact_id != NULL);
	g_return_if_fail (accounts != NULL);
	_tmp0_ = accounts;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = gee_collection_to_array (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp7_ = _tmp6_[0];
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp3_);
	account = _tmp9_;
	_tmp10_ = contact_id;
	contacts_utils_start_call_with_account (_tmp10_, account);
	_g_object_unref0 (account);
}


void contacts_utils_start_call_with_account (const gchar* contact_id, TpAccount* account) {
	GHashTable* request_dict = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GValue* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	const gchar* _tmp5_;
	GValue* _tmp6_ = NULL;
	GValue* _tmp7_ = NULL;
	TpAccountChannelRequest* request = NULL;
	TpAccount* _tmp8_;
	TpAccountChannelRequest* _tmp9_;
	g_return_if_fail (contact_id != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, __vala_GValue_free0_);
	request_dict = _tmp2_;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_set_string (_tmp3_, TP_IFACE_CHANNEL_TYPE_CALL);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_CHANNEL_TYPE, _tmp3_);
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_INT);
	g_value_set_int (_tmp4_, (gint) TP_HANDLE_TYPE_CONTACT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_HANDLE_TYPE, _tmp4_);
	_tmp5_ = contact_id;
	_tmp6_ = g_new0 (GValue, 1);
	g_value_init (_tmp6_, G_TYPE_STRING);
	g_value_set_string (_tmp6_, _tmp5_);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_ID, _tmp6_);
	_tmp7_ = g_new0 (GValue, 1);
	g_value_init (_tmp7_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp7_, TRUE);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TYPE_CALL_INITIAL_AUDIO, _tmp7_);
	_tmp8_ = account;
	_tmp9_ = tp_account_channel_request_new (_tmp8_, request_dict, G_MAXINT64);
	request = _tmp9_;
	tp_account_channel_request_ensure_channel_async (request, "org.freedesktop.Telepathy.Client.Empathy.Call", NULL, NULL, NULL);
	_g_object_unref0 (request);
	_g_hash_table_unref0 (request_dict);
}


gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection) {
	gpointer result = NULL;
	GeeIterator* i = NULL;
	GeeCollection* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = collection;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	i = _tmp1_;
	_tmp2_ = i;
	_tmp3_ = gee_iterator_next (_tmp2_);
	if (_tmp3_) {
		GeeIterator* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = i;
		_tmp5_ = gee_iterator_get (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (i);
		return result;
	}
	result = NULL;
	_g_object_unref0 (i);
	return result;
}


void contacts_utils_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2) {
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	cairo_t* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	cairo_t* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	cairo_t* _tmp16_;
	g_return_if_fail (cr != NULL);
	_tmp1_ = xradius;
	if (_tmp1_ <= 0.0) {
		_tmp0_ = TRUE;
	} else {
		gdouble _tmp2_;
		_tmp2_ = yradius;
		_tmp0_ = _tmp2_ <= 0.0;
	}
	if (_tmp0_) {
		cairo_t* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		_tmp3_ = cr;
		_tmp4_ = xc;
		_tmp5_ = yc;
		cairo_line_to (_tmp3_, _tmp4_, _tmp5_);
		return;
	}
	_tmp6_ = cr;
	cairo_save (_tmp6_);
	_tmp7_ = cr;
	_tmp8_ = xc;
	_tmp9_ = yc;
	cairo_translate (_tmp7_, _tmp8_, _tmp9_);
	_tmp10_ = cr;
	_tmp11_ = xradius;
	_tmp12_ = yradius;
	cairo_scale (_tmp10_, _tmp11_, _tmp12_);
	_tmp13_ = cr;
	_tmp14_ = angle1;
	_tmp15_ = angle2;
	cairo_arc (_tmp13_, (gdouble) 0, (gdouble) 0, 1.0, _tmp14_, _tmp15_);
	_tmp16_ = cr;
	cairo_restore (_tmp16_);
}


void contacts_utils_cairo_rounded_box (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius) {
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	cairo_t* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	cairo_t* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	cairo_t* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	cairo_new_sub_path (_tmp0_);
	_tmp1_ = cr;
	_tmp2_ = x;
	_tmp3_ = radius;
	_tmp4_ = y;
	_tmp5_ = radius;
	_tmp6_ = radius;
	_tmp7_ = radius;
	contacts_utils_cairo_ellipsis (_tmp1_, (gdouble) (_tmp2_ + _tmp3_), (gdouble) (_tmp4_ + _tmp5_), (gdouble) _tmp6_, (gdouble) _tmp7_, G_PI, (3 * G_PI) / 2);
	_tmp8_ = cr;
	_tmp9_ = x;
	_tmp10_ = width;
	_tmp11_ = radius;
	_tmp12_ = y;
	_tmp13_ = radius;
	_tmp14_ = radius;
	_tmp15_ = radius;
	contacts_utils_cairo_ellipsis (_tmp8_, (gdouble) ((_tmp9_ + _tmp10_) - _tmp11_), (gdouble) (_tmp12_ + _tmp13_), (gdouble) _tmp14_, (gdouble) _tmp15_, (-G_PI) / 2, (gdouble) 0);
	_tmp16_ = cr;
	_tmp17_ = x;
	_tmp18_ = width;
	_tmp19_ = radius;
	_tmp20_ = y;
	_tmp21_ = height;
	_tmp22_ = radius;
	_tmp23_ = radius;
	_tmp24_ = radius;
	contacts_utils_cairo_ellipsis (_tmp16_, (gdouble) ((_tmp17_ + _tmp18_) - _tmp19_), (gdouble) ((_tmp20_ + _tmp21_) - _tmp22_), (gdouble) _tmp23_, (gdouble) _tmp24_, (gdouble) 0, G_PI / 2);
	_tmp25_ = cr;
	_tmp26_ = x;
	_tmp27_ = radius;
	_tmp28_ = y;
	_tmp29_ = height;
	_tmp30_ = radius;
	_tmp31_ = radius;
	_tmp32_ = radius;
	contacts_utils_cairo_ellipsis (_tmp25_, (gdouble) (_tmp26_ + _tmp27_), (gdouble) ((_tmp28_ + _tmp29_) - _tmp30_), (gdouble) _tmp31_, (gdouble) _tmp32_, G_PI / 2, G_PI);
}


gunichar contacts_utils_strip_char (gunichar ch) {
	gunichar result = 0U;
	gunichar _tmp0_;
	GUnicodeType _tmp1_;
	_tmp0_ = ch;
	_tmp1_ = g_unichar_type (_tmp0_);
	switch (_tmp1_) {
		case G_UNICODE_CONTROL:
		case G_UNICODE_FORMAT:
		case G_UNICODE_UNASSIGNED:
		case G_UNICODE_NON_SPACING_MARK:
		case G_UNICODE_COMBINING_MARK:
		case G_UNICODE_ENCLOSING_MARK:
		{
			result = (gunichar) 0;
			return result;
		}
		default:
		{
			gunichar _tmp2_;
			gunichar _tmp3_;
			_tmp2_ = ch;
			_tmp3_ = g_unichar_tolower (_tmp2_);
			result = _tmp3_;
			return result;
		}
	}
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


gboolean contacts_utils_string_is_empty (const gchar* str) {
	gboolean result = FALSE;
	gunichar c = 0U;
	g_return_val_if_fail (str != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp1_;
				gunichar _tmp2_ = 0U;
				gboolean _tmp3_;
				gunichar _tmp4_;
				gboolean _tmp5_;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				_tmp1_ = str;
				_tmp3_ = string_get_next_char (_tmp1_, &i, &_tmp2_);
				c = _tmp2_;
				if (!_tmp3_) {
					break;
				}
				_tmp4_ = c;
				_tmp5_ = g_unichar_isspace (_tmp4_);
				if (!_tmp5_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* contacts_utils_canonicalize_for_search (const gchar* str) {
	gchar* result = NULL;
	const gchar* s = NULL;
	gunichar* buf = NULL;
	gunichar* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	GString* res = NULL;
	GString* _tmp1_;
	GString* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_new0 (gunichar, 18);
	buf = _tmp0_;
	buf_length1 = 18;
	_buf_size_ = buf_length1;
	_tmp1_ = g_string_new ("");
	res = _tmp1_;
	{
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = str;
		s = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			const gchar* _tmp6_;
			gchar _tmp7_;
			gunichar c = 0U;
			const gchar* _tmp8_;
			gunichar _tmp9_;
			gunichar _tmp10_;
			gunichar _tmp11_;
			if (!_tmp3_) {
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = s;
				_tmp5_ = g_utf8_next_char (_tmp4_);
				s = _tmp5_;
			}
			_tmp3_ = FALSE;
			_tmp6_ = s;
			_tmp7_ = string_get (_tmp6_, (glong) 0);
			if (!(((gint) _tmp7_) != 0)) {
				break;
			}
			_tmp8_ = s;
			_tmp9_ = string_get_char (_tmp8_, (glong) 0);
			_tmp10_ = contacts_utils_strip_char (_tmp9_);
			c = _tmp10_;
			_tmp11_ = c;
			if (_tmp11_ != ((gunichar) 0)) {
				gsize size = 0UL;
				gunichar _tmp12_;
				gunichar* _tmp13_;
				gint _tmp13__length1;
				gsize _tmp14_;
				gsize _tmp15_;
				_tmp12_ = c;
				_tmp13_ = buf;
				_tmp13__length1 = buf_length1;
				_tmp14_ = g_unichar_fully_decompose (_tmp12_, FALSE, _tmp13_, _tmp13__length1);
				size = _tmp14_;
				_tmp15_ = size;
				if (_tmp15_ > ((gsize) 0)) {
					GString* _tmp16_;
					gunichar* _tmp17_;
					gint _tmp17__length1;
					gunichar _tmp18_;
					_tmp16_ = res;
					_tmp17_ = buf;
					_tmp17__length1 = buf_length1;
					_tmp18_ = _tmp17_[0];
					g_string_append_unichar (_tmp16_, _tmp18_);
				}
			}
		}
	}
	_tmp19_ = res;
	_tmp20_ = _tmp19_->str;
	_tmp21_ = g_strdup (_tmp20_);
	result = _tmp21_;
	_g_string_free0 (res);
	buf = (g_free (buf), NULL);
	return result;
}


void contacts_utils_grab_entry_focus_no_select (GtkEntry* entry) {
	gint start = 0;
	gint end = 0;
	GtkEntry* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (entry != NULL);
	_tmp0_ = entry;
	_tmp3_ = gtk_editable_get_selection_bounds ((GtkEditable*) _tmp0_, &_tmp1_, &_tmp2_);
	start = _tmp1_;
	end = _tmp2_;
	if (!_tmp3_) {
		GtkEntry* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = entry;
		_tmp5_ = gtk_editable_get_position ((GtkEditable*) _tmp4_);
		end = _tmp5_;
		_tmp6_ = end;
		start = _tmp6_;
	}
	_tmp7_ = entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
	_tmp8_ = entry;
	_tmp9_ = start;
	_tmp10_ = end;
	gtk_editable_select_region ((GtkEditable*) _tmp8_, _tmp9_, _tmp10_);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add10 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** contacts_utils_get_stock_avatars (int* result_length1) {
	gchar** result = NULL;
	gchar** files = NULL;
	gchar** _tmp0_;
	gint files_length1;
	gint _files_size_;
	gchar** system_data_dirs = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint system_data_dirs_length1;
	gint _system_data_dirs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp26_;
	gint _tmp26__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	files = _tmp0_;
	files_length1 = 0;
	_files_size_ = files_length1;
	_tmp2_ = _tmp1_ = g_get_system_data_dirs ();
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _vala_array_length (_tmp1_)) : ((gpointer) _tmp2_);
	_tmp3__length1 = _vala_array_length (_tmp1_);
	system_data_dirs = _tmp3_;
	system_data_dirs_length1 = _tmp3__length1;
	_system_data_dirs_size_ = system_data_dirs_length1;
	_tmp4_ = system_data_dirs;
	_tmp4__length1 = system_data_dirs_length1;
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp4_;
		data_dir_collection_length1 = _tmp4__length1;
		for (data_dir_it = 0; data_dir_it < _tmp4__length1; data_dir_it = data_dir_it + 1) {
			gchar* _tmp5_;
			gchar* data_dir = NULL;
			_tmp5_ = g_strdup (data_dir_collection[data_dir_it]);
			data_dir = _tmp5_;
			{
				gchar* path = NULL;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				GDir* dir = NULL;
				GDir* _tmp15_;
				_tmp6_ = data_dir;
				_tmp7_ = g_build_filename (_tmp6_, "pixmaps", "faces", NULL);
				path = _tmp7_;
				dir = NULL;
				{
					GDir* _tmp8_ = NULL;
					const gchar* _tmp9_;
					GDir* _tmp10_;
					GDir* _tmp11_;
					_tmp9_ = path;
					_tmp10_ = g_dir_open (_tmp9_, (guint) 0, &_inner_error_);
					_tmp8_ = _tmp10_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch32_g_error;
					}
					_tmp11_ = _tmp8_;
					_tmp8_ = NULL;
					_g_dir_close0 (dir);
					dir = _tmp11_;
					_g_dir_close0 (_tmp8_);
				}
				goto __finally32;
				__catch32_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp12_;
					GError* _tmp13_;
					const gchar* _tmp14_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp12_ = path;
					_tmp13_ = e;
					_tmp14_ = _tmp13_->message;
					g_debug ("contacts-utils.vala:310: Couldn't open stock avatars folder \"%s\": %s", _tmp12_, _tmp14_);
					_g_error_free0 (e);
				}
				__finally32:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_dir_close0 (dir);
					_g_free0 (path);
					_g_free0 (data_dir);
					system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp15_ = dir;
				if (_tmp15_ != NULL) {
					gchar* face = NULL;
					while (TRUE) {
						GDir* _tmp16_;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						const gchar* _tmp19_;
						gchar* filename = NULL;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						gchar** _tmp23_;
						gint _tmp23__length1;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						_tmp16_ = dir;
						_tmp17_ = g_dir_read_name (_tmp16_);
						_tmp18_ = g_strdup (_tmp17_);
						_g_free0 (face);
						face = _tmp18_;
						_tmp19_ = face;
						if (!(_tmp19_ != NULL)) {
							break;
						}
						_tmp20_ = path;
						_tmp21_ = face;
						_tmp22_ = g_build_filename (_tmp20_, _tmp21_, NULL);
						filename = _tmp22_;
						_tmp23_ = files;
						_tmp23__length1 = files_length1;
						_tmp24_ = filename;
						_tmp25_ = g_strdup (_tmp24_);
						_vala_array_add10 (&files, &files_length1, &_files_size_, _tmp25_);
						_g_free0 (filename);
					}
					_g_free0 (face);
				}
				_g_dir_close0 (dir);
				_g_free0 (path);
				_g_free0 (data_dir);
			}
		}
	}
	_tmp26_ = files;
	_tmp26__length1 = files_length1;
	if (result_length1) {
		*result_length1 = _tmp26__length1;
	}
	result = _tmp26_;
	system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _vala_array_add11 (FolksPersonaStore** * array, int* length, int* size, FolksPersonaStore* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


FolksPersonaStore** contacts_utils_get_eds_address_books (ContactsStore* contacts_store, int* result_length1) {
	FolksPersonaStore** result = NULL;
	FolksPersonaStore** stores = NULL;
	FolksPersonaStore** _tmp0_;
	gint stores_length1;
	gint _stores_size_;
	FolksPersonaStore** _tmp33_;
	gint _tmp33__length1;
	g_return_val_if_fail (contacts_store != NULL, NULL);
	_tmp0_ = g_new0 (FolksPersonaStore*, 0 + 1);
	stores = _tmp0_;
	stores_length1 = 0;
	_stores_size_ = stores_length1;
	{
		GeeIterator* _backend_it = NULL;
		ContactsStore* _tmp1_;
		FolksBackendStore* _tmp2_;
		FolksBackendStore* _tmp3_;
		GeeMap* _tmp4_;
		GeeMap* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeIterator* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp1_ = contacts_store;
		_tmp2_ = contacts_store_get_backend_store (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_backend_store_get_enabled_backends (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_map_get_values (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_backend_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			gboolean _tmp12_;
			FolksBackend* backend = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			_tmp11_ = _backend_it;
			_tmp12_ = gee_iterator_next (_tmp11_);
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = _backend_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			backend = (FolksBackend*) _tmp14_;
			{
				GeeIterator* _persona_store_it = NULL;
				FolksBackend* _tmp15_;
				GeeMap* _tmp16_;
				GeeMap* _tmp17_;
				GeeCollection* _tmp18_;
				GeeCollection* _tmp19_;
				GeeCollection* _tmp20_;
				GeeIterator* _tmp21_;
				GeeIterator* _tmp22_;
				_tmp15_ = backend;
				_tmp16_ = folks_backend_get_persona_stores (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = gee_map_get_values (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = _tmp19_;
				_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
				_tmp22_ = _tmp21_;
				_g_object_unref0 (_tmp20_);
				_persona_store_it = _tmp22_;
				while (TRUE) {
					GeeIterator* _tmp23_;
					gboolean _tmp24_;
					FolksPersonaStore* persona_store = NULL;
					GeeIterator* _tmp25_;
					gpointer _tmp26_;
					FolksPersonaStore* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					_tmp23_ = _persona_store_it;
					_tmp24_ = gee_iterator_next (_tmp23_);
					if (!_tmp24_) {
						break;
					}
					_tmp25_ = _persona_store_it;
					_tmp26_ = gee_iterator_get (_tmp25_);
					persona_store = (FolksPersonaStore*) _tmp26_;
					_tmp27_ = persona_store;
					_tmp28_ = folks_persona_store_get_type_id (_tmp27_);
					_tmp29_ = _tmp28_;
					if (g_strcmp0 (_tmp29_, "eds") == 0) {
						FolksPersonaStore** _tmp30_;
						gint _tmp30__length1;
						FolksPersonaStore* _tmp31_;
						FolksPersonaStore* _tmp32_;
						_tmp30_ = stores;
						_tmp30__length1 = stores_length1;
						_tmp31_ = persona_store;
						_tmp32_ = _g_object_ref0 (_tmp31_);
						_vala_array_add11 (&stores, &stores_length1, &_stores_size_, _tmp32_);
					}
					_g_object_unref0 (persona_store);
				}
				_g_object_unref0 (_persona_store_it);
			}
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	_tmp33_ = stores;
	_tmp33__length1 = stores_length1;
	if (result_length1) {
		*result_length1 = _tmp33__length1;
	}
	result = _tmp33_;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



