#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.gcm"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[2304]; const double alignment; void * const ptr;}  gcm_resource_data = { {
  0x47, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x28, 0x05, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
  0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
  0x05, 0x00, 0x00, 0x00, 0xd4, 0xb5, 0x02, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x4c, 0x00, 0xb0, 0x00, 0x00, 0x00, 
  0xb4, 0x00, 0x00, 0x00, 0x4b, 0x50, 0x90, 0x0b, 
  0x00, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 
  0x04, 0x00, 0x4c, 0x00, 0xb8, 0x00, 0x00, 0x00, 
  0xbc, 0x00, 0x00, 0x00, 0xf4, 0x3c, 0xaf, 0x8f, 
  0x03, 0x00, 0x00, 0x00, 0xbc, 0x00, 0x00, 0x00, 
  0x0d, 0x00, 0x76, 0x00, 0xd0, 0x00, 0x00, 0x00, 
  0xdf, 0x08, 0x00, 0x00, 0x66, 0xec, 0xb7, 0xce, 
  0x04, 0x00, 0x00, 0x00, 0xdf, 0x08, 0x00, 0x00, 
  0x0e, 0x00, 0x4c, 0x00, 0xf0, 0x08, 0x00, 0x00, 
  0xf4, 0x08, 0x00, 0x00, 0xb0, 0xb7, 0x24, 0x30, 
  0x01, 0x00, 0x00, 0x00, 0xf4, 0x08, 0x00, 0x00, 
  0x06, 0x00, 0x4c, 0x00, 0xfc, 0x08, 0x00, 0x00, 
  0x00, 0x09, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x6f, 0x72, 0x67, 0x2f, 
  0x04, 0x00, 0x00, 0x00, 0x67, 0x63, 0x6d, 0x2d, 
  0x70, 0x69, 0x63, 0x6b, 0x65, 0x72, 0x2e, 0x75, 
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x09, 0x43, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x78, 0xda, 0xed, 0x5c, 0x5b, 0x73, 0xdb, 0xba, 
  0x11, 0x7e, 0xd7, 0xaf, 0xd8, 0xf2, 0x29, 0x99, 
  0xea, 0x6a, 0x37, 0x69, 0x66, 0x62, 0xeb, 0x54, 
  0xf6, 0xb1, 0x1d, 0xcf, 0xc4, 0x8e, 0x47, 0x96, 
  0x27, 0x75, 0x5f, 0x34, 0x10, 0xb9, 0x12, 0x51, 
  0x83, 0x04, 0x0f, 0x00, 0x4a, 0x56, 0x7f, 0x7d, 
  0x17, 0x24, 0x25, 0xd9, 0x16, 0xa9, 0x9b, 0x9d, 
  0xd6, 0x3a, 0xc3, 0x17, 0x87, 0x14, 0xb0, 0x8b, 
  0xbd, 0x7d, 0x00, 0xb1, 0xc0, 0xe6, 0xe8, 0xb7, 
  0xc7, 0x40, 0xc0, 0x18, 0x95, 0xe6, 0x32, 0x3c, 
  0x76, 0x5a, 0xf5, 0xa6, 0x03, 0x18, 0xba, 0xd2, 
  0xe3, 0xe1, 0xe8, 0xd8, 0xb9, 0xeb, 0x9d, 0xd7, 
  0xbe, 0x38, 0xbf, 0xb5, 0x2b, 0x47, 0x7f, 0xa9, 
  0xd5, 0xe0, 0x02, 0x43, 0x54, 0xcc, 0xa0, 0x07, 
  0x13, 0x6e, 0x7c, 0x18, 0x09, 0xe6, 0x21, 0x1c, 
  0xd6, 0x0f, 0x9a, 0xf5, 0x26, 0x54, 0x2a, 0x17, 
  0xd7, 0x3f, 0xae, 0xce, 0xe0, 0x54, 0x0a, 0xa9, 
  0xe0, 0x8a, 0x85, 0x6c, 0x84, 0xaa, 0x72, 0x2a, 
  0xa3, 0xa9, 0xe2, 0x23, 0xdf, 0xc0, 0x87, 0xd3, 
  0x8f, 0x70, 0xd0, 0x6c, 0xb5, 0x6a, 0xf4, 0xe7, 
  0x10, 0xba, 0xdc, 0xf5, 0x99, 0xf2, 0xe0, 0x5b, 
  0x3c, 0xf2, 0x51, 0xc3, 0x91, 0x4a, 0xdf, 0xff, 
  0xe1, 0xd3, 0xbb, 0xe6, 0x58, 0x77, 0x65, 0xd0, 
  0xae, 0x54, 0x7a, 0x3e, 0xd7, 0x10, 0x29, 0x39, 
  0x52, 0x2c, 0x00, 0x7a, 0x1c, 0x2a, 0x44, 0xd0, 
  0x72, 0x68, 0x26, 0x4c, 0xe1, 0x57, 0x98, 0xca, 
  0x18, 0x5c, 0x16, 0x82, 0x42, 0x8f, 0x6b, 0xa3, 
  0xf8, 0x20, 0x36, 0x08, 0xdc, 0x00, 0x0b, 0xbd, 
  0x86, 0x54, 0x95, 0x80, 0x74, 0x18, 0x4e, 0xed, 
  0x0f, 0x71, 0xe8, 0xa1, 0x02, 0xe3, 0x23, 0x18, 
  0x54, 0x81, 0x06, 0x39, 0x4c, 0x5e, 0x2e, 0xae, 
  0xef, 0x32, 0x95, 0x04, 0xdc, 0xc4, 0x03, 0xc1, 
  0x5d, 0xf8, 0xce, 0x5d, 0x0c, 0x35, 0x56, 0x18, 
  0x8d, 0x6b, 0x7f, 0xd1, 0x3e, 0x29, 0x3b, 0x98, 
  0x26, 0xdd, 0xcf, 0xed, 0xe8, 0xb7, 0xd9, 0xe8, 
  0x70, 0x2e, 0x89, 0x2b, 0x33, 0x64, 0xb4, 0xaf, 
  0x80, 0x64, 0x0d, 0x1a, 0x20, 0x33, 0x22, 0x1c, 
  0x54, 0xb2, 0x01, 0x32, 0x6e, 0x55, 0x20, 0x8b, 
  0x7c, 0x60, 0xc6, 0x0a, 0xac, 0x40, 0x46, 0x96, 
  0xe8, 0x23, 0x49, 0x39, 0x05, 0x41, 0xc6, 0x9c, 
  0xd3, 0xd5, 0x97, 0x15, 0x5e, 0xe8, 0xe5, 0x01, 
  0x0f, 0x13, 0x9e, 0xbe, 0x8c, 0x48, 0x0d, 0x9f, 
  0xb8, 0x91, 0x62, 0x13, 0x2e, 0x04, 0x0c, 0x10, 
  0x62, 0x8d, 0xc3, 0x58, 0x54, 0x2b, 0xd4, 0x13, 
  0x7e, 0x5e, 0xf6, 0xbe, 0xfd, 0xb8, 0xeb, 0x41, 
  0xe7, 0xfa, 0x1e, 0x7e, 0x76, 0xba, 0xdd, 0xce, 
  0x75, 0xef, 0xfe, 0x6b, 0xe2, 0x30, 0x49, 0xad, 
  0x38, 0xc6, 0x94, 0x0f, 0x0f, 0x22, 0xc1, 0xad, 
  0x27, 0x99, 0x52, 0x2c, 0x34, 0x53, 0x32, 0x4a, 
  0xe5, 0xea, 0xac, 0x7b, 0xfa, 0x8d, 0xfa, 0x77, 
  0x4e, 0x2e, 0xbf, 0x5f, 0xf6, 0xee, 0xad, 0xd8, 
  0xe7, 0x97, 0xbd, 0xeb, 0xb3, 0xdb, 0x5b, 0x38, 
  0xff, 0xd1, 0x85, 0x0e, 0xdc, 0x74, 0xba, 0xbd, 
  0xcb, 0xd3, 0xbb, 0xef, 0x9d, 0x2e, 0xdc, 0xdc, 
  0x75, 0x6f, 0x7e, 0xdc, 0x9e, 0xd5, 0x01, 0x6e, 
  0xd1, 0x0a, 0x84, 0x95, 0x62, 0x73, 0xc2, 0x90, 
  0x38, 0x05, 0x92, 0xac, 0xe6, 0xa1, 0x61, 0x5c, 
  0x68, 0x52, 0xf5, 0x9e, 0x9c, 0xa7, 0x49, 0x24, 
  0xe1, 0x81, 0xcf, 0xc6, 0x48, 0x4e, 0x74, 0x91, 
  0x8f, 0x49, 0x20, 0x06, 0x2e, 0x05, 0xcd, 0x26, 
  0x3e, 0x12, 0x32, 0x1c, 0xa5, 0x91, 0x68, 0x9e, 
  0xd8, 0xed, 0x2b, 0xf0, 0x21, 0x84, 0xd2, 0x54, 
  0x61, 0xa2, 0x38, 0x05, 0x84, 0x91, 0xcb, 0xde, 
  0xab, 0x2c, 0xbc, 0x57, 0x85, 0xcb, 0xd0, 0xad, 
  0x57, 0xe1, 0x53, 0x8b, 0xba, 0xb0, 0xf0, 0x41, 
  0x90, 0x9d, 0x6f, 0x0d, 0x75, 0x26, 0x06, 0xe7, 
  0x7c, 0x48, 0xcc, 0xcf, 0x85, 0x94, 0xaa, 0x0a, 
  0x27, 0x52, 0x1b, 0xdb, 0xfd, 0xaa, 0x03, 0xd0, 
  0x3c, 0x68, 0xb5, 0x9a, 0xb5, 0xd6, 0x61, 0xb3, 
  0x55, 0x85, 0xbb, 0xdb, 0x0e, 0xa9, 0x53, 0xab, 
  0x11, 0x46, 0x78, 0x48, 0xee, 0x1c, 0x32, 0x17, 
  0xdb, 0x15, 0xa0, 0x98, 0xc6, 0x3f, 0x62, 0xae, 
  0x28, 0xba, 0x05, 0x1f, 0x1c, 0x3b, 0x23, 0xf3, 
  0xf0, 0x57, 0x67, 0x81, 0xb3, 0xc3, 0x7a, 0xeb, 
  0x8b, 0xd3, 0x48, 0xfa, 0xc9, 0xc1, 0xbf, 0xd1, 
  0x35, 0xe0, 0x0a, 0xa6, 0xf5, 0xb1, 0x73, 0x61, 
  0x1e, 0x7e, 0xe7, 0xa4, 0xda, 0xc8, 0x01, 0xee, 
  0x1d, 0x3b, 0x5e, 0xf2, 0xdc, 0x8f, 0xb8, 0xfb, 
  0x80, 0xca, 0xb1, 0xfd, 0x89, 0x82, 0x34, 0x8d, 
  0x50, 0x91, 0xcf, 0x42, 0x16, 0xe0, 0xb1, 0x43, 
  0x18, 0xe8, 0x0f, 0xa5, 0x1b, 0x6b, 0xa7, 0x7d, 
  0xce, 0x84, 0xc6, 0xa3, 0xc6, 0xac, 0x43, 0x7e, 
  0xff, 0x81, 0x54, 0x84, 0x87, 0xfe, 0x84, 0x7b, 
  0xc6, 0x77, 0xda, 0xad, 0x2f, 0xeb, 0xfa, 0x1b, 
  0x6e, 0x04, 0x3a, 0x60, 0xc8, 0x3c, 0x9a, 0x22, 
  0x96, 0x0d, 0x04, 0xfd, 0x38, 0x45, 0xed, 0x90, 
  0xa7, 0x82, 0x00, 0x43, 0x43, 0x62, 0xff, 0xe4, 
  0xa1, 0x27, 0x27, 0x90, 0x74, 0x25, 0xcb, 0x13, 
  0x1c, 0x92, 0xa0, 0xb0, 0x91, 0xa9, 0x12, 0x90, 
  0x5a, 0x0d, 0x40, 0x47, 0x92, 0x14, 0xb5, 0x33, 
  0x84, 0xa6, 0x16, 0x9a, 0x61, 0xc8, 0xdb, 0x01, 
  0x32, 0x1d, 0x2b, 0xfb, 0xec, 0xe1, 0x98, 0x5c, 
  0xeb, 0xb4, 0xd3, 0x29, 0xe4, 0x26, 0x51, 0x79, 
  0x9d, 0x6c, 0xdc, 0x95, 0x61, 0xdf, 0x3e, 0x3a, 
  0xed, 0x51, 0x28, 0x03, 0xac, 0x25, 0xdc, 0x6b, 
  0x41, 0x3a, 0xff, 0xac, 0xd5, 0x6c, 0x1a, 0x61, 
  0xdf, 0x27, 0xb7, 0x39, 0xed, 0xd4, 0xd0, 0x4b, 
  0x04, 0xae, 0xcf, 0x85, 0xc5, 0x1e, 0x39, 0x36, 
  0x64, 0xa2, 0x96, 0xbc, 0x1e, 0x3b, 0xe3, 0x81, 
  0x7c, 0xcc, 0x9c, 0x91, 0xe7, 0xc0, 0x13, 0x6a, 
  0x7d, 0xe2, 0xbd, 0x9a, 0xed, 0xde, 0x9a, 0xf7, 
  0x5f, 0x16, 0x63, 0xcc, 0x35, 0x27, 0xa3, 0x3a, 
  0xed, 0x9e, 0x8a, 0x97, 0xbc, 0xb7, 0x8b, 0xc7, 
  0xf3, 0x68, 0xa4, 0xe2, 0xe4, 0xaa, 0x24, 0xe6, 
  0x9d, 0x36, 0xc5, 0xa1, 0xe1, 0x2e, 0x13, 0x9b, 
  0x10, 0xea, 0x88, 0xb9, 0xe4, 0x9e, 0xbc, 0x48, 
  0x59, 0x61, 0x22, 0xe6, 0xda, 0x91, 0xfa, 0x04, 
  0x36, 0xf6, 0x44, 0xf3, 0x5c, 0x6b, 0xc5, 0x86, 
  0x80, 0xf5, 0xd2, 0x66, 0x4f, 0xe8, 0x5b, 0xcf, 
  0x18, 0xec, 0x66, 0x0d, 0xa2, 0x6a, 0xa4, 0x23, 
  0x3f, 0xfb, 0x8d, 0x54, 0x7b, 0x20, 0xdd, 0x56, 
  0xf3, 0xc7, 0xc7, 0x88, 0x96, 0x94, 0x95, 0xcc, 
  0x97, 0x89, 0x86, 0x34, 0x35, 0x6f, 0x49, 0x12, 
  0x49, 0xcd, 0x53, 0xf7, 0x34, 0x8b, 0x54, 0x58, 
  0x92, 0xf7, 0xa8, 0x91, 0xd8, 0xfb, 0xa5, 0x3b, 
  0xd6, 0x58, 0x7c, 0x66, 0xeb, 0x17, 0x71, 0xb9, 
  0x53, 0x6c, 0xee, 0xee, 0x91, 0x57, 0xc4, 0xe8, 
  0x0e, 0x71, 0x9a, 0x6f, 0x9c, 0x7c, 0x03, 0x5d, 
  0x06, 0x34, 0x7b, 0xa4, 0x26, 0xe2, 0xf6, 0xb1, 
  0x1f, 0x29, 0x9a, 0x9b, 0x70, 0xe2, 0xbc, 0x24, 
  0xdd, 0xd1, 0x5e, 0xaf, 0xb1, 0x59, 0x1e, 0xad, 
  0x3f, 0x0b, 0xd1, 0x6d, 0x07, 0x1d, 0x6f, 0x46, 
  0x98, 0x87, 0x9d, 0x62, 0xfc, 0xac, 0xc2, 0xd0, 
  0xb6, 0x02, 0xa6, 0x30, 0xda, 0x96, 0x6a, 0x2d, 
  0x92, 0x0a, 0xd0, 0x94, 0x8b, 0xa8, 0x6d, 0x02, 
  0xe7, 0x2c, 0x51, 0x93, 0x56, 0xea, 0x24, 0x76, 
  0x30, 0x7b, 0xeb, 0xd3, 0x57, 0x40, 0x2c, 0x8c, 
  0xfe, 0x1f, 0x85, 0xcf, 0x5a, 0xd2, 0x5c, 0x65, 
  0xf2, 0x15, 0xba, 0x50, 0xdc, 0x4b, 0x95, 0x19, 
  0xd1, 0xd3, 0x0a, 0x45, 0x5e, 0xa5, 0xcc, 0x6b, 
  0xf1, 0x90, 0x8b, 0x09, 0x26, 0xf8, 0x88, 0x22, 
  0x80, 0x3e, 0x16, 0xcd, 0xf2, 0x97, 0xc0, 0x3a, 
  0x6a, 0x25, 0x27, 0xfd, 0xf9, 0x84, 0xf2, 0x79, 
  0x6b, 0xd9, 0xa5, 0x88, 0x83, 0x70, 0xc1, 0xa0, 
  0x75, 0xb0, 0x96, 0x43, 0xa1, 0x4f, 0xf2, 0xfd, 
  0xf2, 0x9d, 0x0d, 0x50, 0xa4, 0x8e, 0x11, 0xf6, 
  0xb1, 0xff, 0x38, 0xfd, 0x8f, 0x53, 0x44, 0xfe, 
  0x4a, 0xcf, 0xbc, 0x85, 0x77, 0x56, 0x79, 0x48, 
  0x1b, 0xa6, 0xcc, 0x2e, 0x0c, 0x34, 0x0a, 0xb2, 
  0x0a, 0xdb, 0x42, 0x91, 0xa2, 0x89, 0x6c, 0xfd, 
  0x84, 0x56, 0x24, 0x83, 0xc0, 0xa1, 0xe9, 0x33, 
  0x63, 0x98, 0x6b, 0xbf, 0xa5, 0x77, 0xd1, 0xc2, 
  0xc8, 0x68, 0xce, 0xa0, 0xb9, 0x89, 0x0a, 0x2b, 
  0x65, 0xcc, 0x9d, 0xbe, 0xde, 0x32, 0xca, 0xfa, 
  0xe9, 0x76, 0x60, 0x4f, 0x63, 0x0d, 0x43, 0x6f, 
  0x17, 0x72, 0x91, 0x1a, 0x62, 0xe5, 0x16, 0xc8, 
  0x6e, 0x77, 0x92, 0xdd, 0x07, 0xed, 0x65, 0xe9, 
  0x7b, 0x41, 0x2f, 0xbe, 0x64, 0xfe, 0x79, 0xff, 
  0xaf, 0x8d, 0x06, 0xd5, 0x66, 0x2a, 0xb0, 0xb8, 
  0xdd, 0xfa, 0xcf, 0xba, 0x26, 0x93, 0xc9, 0xe3, 
  0x41, 0x2d, 0x95, 0xab, 0xb1, 0x82, 0x67, 0x63, 
  0x25, 0xd3, 0x5f, 0x8c, 0x87, 0xe6, 0x9f, 0x1d, 
  0x0f, 0xf4, 0xb7, 0xc4, 0x43, 0x01, 0x1e, 0xc8, 
  0x58, 0x36, 0x87, 0x55, 0x04, 0x0b, 0x9b, 0xa6, 
  0x83, 0xdf, 0x3f, 0x35, 0x67, 0x7d, 0x26, 0xbe, 
  0xcd, 0xd6, 0x44, 0x32, 0xd9, 0x8d, 0x5b, 0xda, 
  0x0f, 0xd4, 0xf8, 0xb1, 0xc4, 0xcd, 0x4e, 0xb8, 
  0x69, 0xbd, 0x73, 0xdc, 0x24, 0xce, 0x4e, 0x7c, 
  0x5d, 0xc2, 0xa7, 0x00, 0x3e, 0x49, 0x2e, 0x58, 
  0xe1, 0x10, 0x95, 0x9e, 0xe5, 0x30, 0x59, 0x20, 
  0xe3, 0xd0, 0xd8, 0xd4, 0x28, 0x0b, 0x06, 0x76, 
  0xa7, 0x0c, 0x22, 0xc9, 0xad, 0xcb, 0x34, 0xa5, 
  0x4b, 0xd0, 0xd2, 0x52, 0x39, 0xed, 0x2b, 0xf4, 
  0x38, 0x83, 0x85, 0x89, 0x4b, 0x0c, 0xed, 0x84, 
  0xa1, 0x83, 0x77, 0x8e, 0x21, 0x83, 0x41, 0x64, 
  0x8f, 0x63, 0x62, 0x85, 0x25, 0x88, 0xde, 0x1c, 
  0x44, 0x69, 0x12, 0xba, 0xb7, 0xb0, 0x71, 0x89, 
  0xa2, 0x9d, 0x50, 0x74, 0xf8, 0xce, 0x51, 0x94, 
  0x05, 0x41, 0x89, 0xa0, 0x37, 0x47, 0x50, 0x27, 
  0x6d, 0x2c, 0x71, 0xb3, 0x13, 0x6e, 0xfe, 0xf6, 
  0xce, 0x71, 0x93, 0x9e, 0xe2, 0x91, 0x00, 0x25, 
  0x68, 0x0a, 0x40, 0x93, 0xed, 0x6b, 0x92, 0x89, 
  0xc5, 0x42, 0xc7, 0x1e, 0x6c, 0x07, 0x03, 0x39, 
  0x90, 0x8f, 0xe9, 0xf9, 0xbd, 0x9e, 0x70, 0xe3, 
  0xda, 0xdb, 0x0f, 0xb6, 0x57, 0xf7, 0xe2, 0x84, 
  0x9a, 0xc3, 0xd9, 0x15, 0x82, 0x01, 0x9a, 0x09, 
  0x62, 0x08, 0x1e, 0x1f, 0x12, 0xf2, 0x2c, 0xc4, 
  0x16, 0xf6, 0xd6, 0xa0, 0x63, 0xd7, 0x07, 0xa6, 
  0xa1, 0xe3, 0xc9, 0x41, 0x4a, 0x6a, 0xf7, 0x52, 
  0x9a, 0x1e, 0xb2, 0x75, 0x2b, 0xe9, 0x57, 0x02, 
  0x6f, 0x27, 0xe0, 0x7d, 0x7a, 0xe7, 0xc0, 0x53, 
  0xa3, 0x32, 0xe5, 0x50, 0x8c, 0x3b, 0xd4, 0xb4, 
  0x3e, 0x65, 0x77, 0x0f, 0xc6, 0x4c, 0xc4, 0x38, 
  0xbf, 0xed, 0xe3, 0xfa, 0x92, 0x56, 0xa6, 0x2c, 
  0x15, 0xc1, 0x43, 0xe8, 0xa2, 0x57, 0x85, 0x0b, 
  0x45, 0x28, 0xab, 0xc2, 0x09, 0x75, 0x9c, 0xdf, 
  0x7a, 0x72, 0xda, 0x04, 0xa4, 0x12, 0x3c, 0x3b, 
  0x81, 0xe7, 0xf3, 0x3b, 0x07, 0x0f, 0x2a, 0x25, 
  0x55, 0x09, 0x9f, 0x55, 0xcb, 0x96, 0xf6, 0xe5, 
  0x24, 0x5d, 0x93, 0x12, 0x63, 0xcd, 0xee, 0x9d, 
  0x3d, 0x59, 0x9c, 0x68, 0x2d, 0x23, 0x84, 0xd4, 
  0x9d, 0xf6, 0x99, 0xed, 0x50, 0x22, 0x65, 0x27, 
  0xa4, 0xfc, 0xfd, 0xfd, 0x67, 0xb6, 0xcb, 0xf3, 
  0xc4, 0xbd, 0x3f, 0x4f, 0xdc, 0x9f, 0x3c, 0x70, 
  0x19, 0x6c, 0x7b, 0x1f, 0x6c, 0x07, 0xfb, 0x91, 
  0xea, 0x29, 0x23, 0x6d, 0xef, 0x23, 0xed, 0x9d, 
  0x25, 0x47, 0x4e, 0xed, 0xbe, 0x7e, 0x7e, 0xa9, 
  0x72, 0xb6, 0xcb, 0xff, 0x13, 0xa4, 0x48, 0x36, 
  0x0c, 0xb9, 0xf7, 0x1e, 0x2e, 0x7b, 0xb0, 0xa5, 
  0x2f, 0x27, 0xa5, 0xbd, 0x8f, 0xb2, 0xcf, 0xfb, 
  0x73, 0x5e, 0x58, 0x46, 0xdb, 0xde, 0x47, 0xdb, 
  0xe1, 0x3e, 0x64, 0x5a, 0xca, 0x38, 0xdb, 0xfb, 
  0x38, 0xfb, 0xa5, 0x79, 0x8a, 0x62, 0xe5, 0x0b, 
  0x89, 0xb2, 0x72, 0x23, 0x5b, 0xb9, 0x35, 0x4b, 
  0x6a, 0x6d, 0x76, 0x93, 0xfd, 0x65, 0x84, 0xb6, 
  0xf6, 0xe1, 0x12, 0xfb, 0x26, 0x59, 0xbb, 0x59, 
  0xcd, 0xc1, 0xac, 0xf8, 0xce, 0x66, 0xeb, 0xb2, 
  0x7b, 0xfa, 0x30, 0x54, 0x32, 0x78, 0x72, 0x03, 
  0x6f, 0x56, 0x46, 0xd8, 0x4d, 0x9b, 0xd7, 0x4a, 
  0x43, 0x41, 0x90, 0x96, 0x9f, 0xea, 0x42, 0xdf, 
  0xcf, 0xbb, 0x64, 0x12, 0x4f, 0xd0, 0x9e, 0x05, 
  0x3b, 0x69, 0xf2, 0xdd, 0x56, 0x18, 0x09, 0xaf, 
  0x28, 0x8b, 0x77, 0xd4, 0x58, 0xcd, 0x7f, 0xeb, 
  0xe8, 0x78, 0xbb, 0x32, 0x95, 0xad, 0x2b, 0x70, 
  0x36, 0x28, 0xf7, 0xca, 0x23, 0xb3, 0x82, 0xf5, 
  0x6d, 0x2c, 0xaf, 0xcd, 0xeb, 0x16, 0x97, 0xb8, 
  0xb4, 0xde, 0xa2, 0xc4, 0xe5, 0xf5, 0xd5, 0x71, 
  0xdb, 0xd4, 0x87, 0xad, 0xaf, 0xea, 0xf9, 0x05, 
  0xb5, 0x71, 0xcf, 0x55, 0x7c, 0xd6, 0xf8, 0x6c, 
  0x52, 0x49, 0x60, 0x34, 0x60, 0x6a, 0x45, 0x81, 
  0xe7, 0x37, 0x64, 0x04, 0xb8, 0x13, 0x96, 0xd5, 
  0xf9, 0xf8, 0xc9, 0xeb, 0x53, 0x92, 0xff, 0x53, 
  0x8d, 0x67, 0x76, 0xb0, 0xb1, 0xaa, 0x80, 0x36, 
  0x77, 0xd5, 0xf2, 0xe5, 0xa4, 0xef, 0x0a, 0xa9, 
  0xb1, 0x3f, 0x48, 0x8a, 0x31, 0x57, 0x48, 0xb9, 
  0x49, 0x79, 0x61, 0xca, 0x23, 0xad, 0x30, 0x4c, 
  0x9e, 0xfb, 0x69, 0x91, 0x2f, 0xae, 0xa9, 0x35, 
  0xdc, 0x64, 0xb6, 0x4b, 0x99, 0x83, 0xc1, 0x47, 
  0x53, 0xb5, 0x27, 0x11, 0x23, 0x34, 0xc0, 0xc0, 
  0xd6, 0x12, 0x0b, 0x04, 0xcd, 0x82, 0x88, 0xfe, 
  0x91, 0xc3, 0x74, 0xbe, 0x73, 0xda, 0xfd, 0xab, 
  0x74, 0xe0, 0x4d, 0xc3, 0x2c, 0x26, 0x13, 0xcc, 
  0x2a, 0x4f, 0xa3, 0x08, 0x19, 0x49, 0x62, 0x77, 
  0xef, 0x5b, 0x15, 0x31, 0xbe, 0xb6, 0x62, 0x72, 
  0x1b, 0xb2, 0xac, 0x6a, 0x5e, 0xf7, 0x3d, 0x1c, 
  0x32, 0x9a, 0xd2, 0xb7, 0xa3, 0xb6, 0xda, 0x26, 
  0xff, 0x37, 0x82, 0xe0, 0xe1, 0x96, 0xf2, 0x66, 
  0x65, 0x91, 0x73, 0x54, 0xd2, 0x27, 0x43, 0x21, 
  0x69, 0xee, 0x39, 0xcd, 0xb3, 0x03, 0x1f, 0x1d, 
  0x8f, 0x46, 0xa8, 0x0d, 0x7a, 0x59, 0xd9, 0xef, 
  0xcb, 0x15, 0x23, 0xe7, 0xac, 0x67, 0x79, 0xc2, 
  0xda, 0x14, 0xee, 0x8b, 0x86, 0xa3, 0xc6, 0x93, 
  0x8a, 0xfd, 0xff, 0x02, 0xaa, 0x26, 0x30, 0x59, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x28, 0x75, 0x75, 0x61, 0x79, 0x29, 0x63, 
  0x6f, 0x6c, 0x6f, 0x72, 0x2d, 0x6d, 0x61, 0x6e, 
  0x61, 0x67, 0x65, 0x72, 0x2f, 0x00, 0x00, 0x00, 
  0x02, 0x00, 0x00, 0x00, 0x67, 0x6e, 0x6f, 0x6d, 
  0x65, 0x2f, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00
} };

static GStaticResource static_resource = { gcm_resource_data.data, sizeof (gcm_resource_data.data), NULL, NULL, NULL };
extern GResource *gcm_get_resource (void);
GResource *gcm_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a sane way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for Win32 (x86) and x64 programs, as symbols on Win32 are prefixed
 * with an underscore but symbols on x64 are not.
 */
#ifdef _WIN64
#define G_MSVC_SYMBOL_PREFIX ""
#else
#define G_MSVC_SYMBOL_PREFIX "_"
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(resource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(resource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(resource_destructor)
#endif
G_DEFINE_DESTRUCTOR(resource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void resource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void resource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
