/* chess-clock.c generated by valac 0.35.7.12-e874b, the Vala compiler
 * generated from chess-clock.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CLOCK_TYPE (clock_type_get_type ())

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
typedef struct _ChessClockPrivate ChessClockPrivate;

#define TYPE_COLOR (color_get_type ())
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
enum  {
	CHESS_CLOCK_TICK_SIGNAL,
	CHESS_CLOCK_EXPIRED_SIGNAL,
	CHESS_CLOCK_LAST_SIGNAL
};
static guint chess_clock_signals[CHESS_CLOCK_LAST_SIGNAL] = {0};

typedef enum  {
	CLOCK_TYPE_SIMPLE,
	CLOCK_TYPE_FISCHER,
	CLOCK_TYPE_BRONSTEIN,
	CLOCK_TYPE_INVALID
} ClockType;

struct _ChessClock {
	GObject parent_instance;
	ChessClockPrivate * priv;
};

struct _ChessClockClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessClockPrivate {
	gint _white_initial_seconds;
	gint _black_initial_seconds;
	gint _white_seconds_used;
	gint _black_seconds_used;
	ClockType _clock_type;
	gint _white_prev_move_seconds;
	gint _black_prev_move_seconds;
	gint _white_extra_seconds;
	gint _black_extra_seconds;
	Color _active_color;
	gint _extra_seconds;
	GTimer* timer;
	guint tick_timeout_id;
	gboolean is_active;
};


static gpointer chess_clock_parent_class = NULL;

GType clock_type_get_type (void) G_GNUC_CONST;
gchar* clock_type_to_string (ClockType self);
ClockType clock_type_string_to_enum (const gchar* s);
GType chess_clock_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
#define CHESS_CLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_CLOCK, ChessClockPrivate))
enum  {
	CHESS_CLOCK_DUMMY_PROPERTY,
	CHESS_CLOCK_WHITE_INITIAL_SECONDS,
	CHESS_CLOCK_BLACK_INITIAL_SECONDS,
	CHESS_CLOCK_WHITE_SECONDS_USED,
	CHESS_CLOCK_BLACK_SECONDS_USED,
	CHESS_CLOCK_CLOCK_TYPE,
	CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS,
	CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS,
	CHESS_CLOCK_WHITE_EXTRA_SECONDS,
	CHESS_CLOCK_BLACK_EXTRA_SECONDS,
	CHESS_CLOCK_EXTRA_SECONDS,
	CHESS_CLOCK_ACTIVE_COLOR
};
void chess_clock_update_prev_move_time (ChessClock* self);
Color chess_clock_get_active_color (ChessClock* self);
gint chess_clock_get_black_seconds_used (ChessClock* self);
static void chess_clock_set_black_prev_move_seconds (ChessClock* self, gint value);
gint chess_clock_get_white_seconds_used (ChessClock* self);
static void chess_clock_set_white_prev_move_seconds (ChessClock* self, gint value);
void chess_clock_update_extra_seconds (ChessClock* self);
ClockType chess_clock_get_clock_type (ChessClock* self);
gint chess_clock_get_white_extra_seconds (ChessClock* self);
gint chess_clock_get_extra_seconds (ChessClock* self);
static void chess_clock_set_white_extra_seconds (ChessClock* self, gint value);
gint chess_clock_get_black_extra_seconds (ChessClock* self);
static void chess_clock_set_black_extra_seconds (ChessClock* self, gint value);
gint chess_clock_get_white_prev_move_seconds (ChessClock* self);
gint chess_clock_get_black_prev_move_seconds (ChessClock* self);
ChessClock* chess_clock_new (gint white_initial_seconds, gint black_initial_seconds);
ChessClock* chess_clock_construct (GType object_type, gint white_initial_seconds, gint black_initial_seconds);
static void chess_clock_set_white_initial_seconds (ChessClock* self, gint value);
static void chess_clock_set_black_initial_seconds (ChessClock* self, gint value);
void chess_clock_start (ChessClock* self);
static void chess_clock_watch_timer (ChessClock* self);
static gboolean chess_clock_tick_cb (ChessClock* self);
static void chess_clock_set_white_seconds_used (ChessClock* self, gint value);
static void chess_clock_set_black_seconds_used (ChessClock* self, gint value);
gint chess_clock_get_white_initial_seconds (ChessClock* self);
gint chess_clock_get_black_initial_seconds (ChessClock* self);
void chess_clock_stop (ChessClock* self);
static void chess_clock_stop_watching_timer (ChessClock* self);
void chess_clock_pause (ChessClock* self);
void chess_clock_unpause (ChessClock* self);
static gboolean _chess_clock_tick_cb_gsource_func (gpointer self);
void chess_clock_set_clock_type (ChessClock* self, ClockType value);
void chess_clock_set_extra_seconds (ChessClock* self, gint value);
void chess_clock_set_active_color (ChessClock* self, Color value);
static void chess_clock_finalize (GObject * obj);
static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gchar* clock_type_to_string (ClockType self) {
	gchar* result = NULL;
#line 23 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	switch (self) {
#line 23 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_SIMPLE:
#line 152 "chess-clock.c"
		{
			gchar* _tmp0_;
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp0_ = g_strdup ("simple");
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			result = _tmp0_;
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			return result;
#line 161 "chess-clock.c"
		}
#line 23 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_FISCHER:
#line 165 "chess-clock.c"
		{
			gchar* _tmp1_;
#line 28 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp1_ = g_strdup ("fischer");
#line 28 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			result = _tmp1_;
#line 28 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			return result;
#line 174 "chess-clock.c"
		}
#line 23 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_BRONSTEIN:
#line 178 "chess-clock.c"
		{
			gchar* _tmp2_;
#line 30 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp2_ = g_strdup ("bronstein");
#line 30 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			result = _tmp2_;
#line 30 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			return result;
#line 187 "chess-clock.c"
		}
		default:
		{
#line 32 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			g_assert_not_reached ();
#line 193 "chess-clock.c"
		}
	}
}


ClockType clock_type_string_to_enum (const gchar* s) {
	ClockType result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	static GQuark _tmp2_label0 = 0;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	static GQuark _tmp2_label1 = 0;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	static GQuark _tmp2_label2 = 0;
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (s != NULL, 0);
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = s;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = _tmp0_;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("simple")))) {
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		switch (0) {
#line 222 "chess-clock.c"
			default:
			{
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				result = CLOCK_TYPE_SIMPLE;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				return result;
#line 229 "chess-clock.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("fischer")))) {
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		switch (0) {
#line 235 "chess-clock.c"
			default:
			{
#line 43 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				result = CLOCK_TYPE_FISCHER;
#line 43 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				return result;
#line 242 "chess-clock.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("bronstein")))) {
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		switch (0) {
#line 248 "chess-clock.c"
			default:
			{
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				result = CLOCK_TYPE_BRONSTEIN;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				return result;
#line 255 "chess-clock.c"
			}
		}
	} else {
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		switch (0) {
#line 261 "chess-clock.c"
			default:
			{
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				result = CLOCK_TYPE_INVALID;
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				return result;
#line 268 "chess-clock.c"
			}
		}
	}
}


GType clock_type_get_type (void) {
	static volatile gsize clock_type_type_id__volatile = 0;
	if (g_once_init_enter (&clock_type_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCK_TYPE_SIMPLE, "CLOCK_TYPE_SIMPLE", "simple"}, {CLOCK_TYPE_FISCHER, "CLOCK_TYPE_FISCHER", "fischer"}, {CLOCK_TYPE_BRONSTEIN, "CLOCK_TYPE_BRONSTEIN", "bronstein"}, {CLOCK_TYPE_INVALID, "CLOCK_TYPE_INVALID", "invalid"}, {0, NULL, NULL}};
		GType clock_type_type_id;
		clock_type_type_id = g_enum_register_static ("ClockType", values);
		g_once_init_leave (&clock_type_type_id__volatile, clock_type_type_id);
	}
	return clock_type_type_id__volatile;
}


void chess_clock_update_prev_move_time (ChessClock* self) {
	Color _tmp0_;
	Color _tmp1_;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = chess_clock_get_active_color (self);
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = _tmp0_;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (_tmp1_ == COLOR_WHITE) {
#line 298 "chess-clock.c"
		gint _tmp2_;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp2_ = self->priv->_black_seconds_used;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_prev_move_seconds (self, _tmp2_);
#line 304 "chess-clock.c"
	} else {
		gint _tmp3_;
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp3_ = self->priv->_white_seconds_used;
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_prev_move_seconds (self, _tmp3_);
#line 311 "chess-clock.c"
	}
}


void chess_clock_update_extra_seconds (ChessClock* self) {
	gint white_move_used;
	gint black_move_used;
	ClockType _tmp0_;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	white_move_used = 0;
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	black_move_used = 0;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_clock_type;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	switch (_tmp0_) {
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_SIMPLE:
#line 332 "chess-clock.c"
		{
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			break;
#line 336 "chess-clock.c"
		}
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_FISCHER:
#line 340 "chess-clock.c"
		{
			Color _tmp1_;
			Color _tmp2_;
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp1_ = chess_clock_get_active_color (self);
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp2_ = _tmp1_;
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			if (_tmp2_ == COLOR_WHITE) {
#line 350 "chess-clock.c"
				gint _tmp3_;
				gint _tmp4_;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp3_ = self->priv->_white_extra_seconds;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp4_ = self->priv->_extra_seconds;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				chess_clock_set_white_extra_seconds (self, _tmp3_ + _tmp4_);
#line 359 "chess-clock.c"
			} else {
				gint _tmp5_;
				gint _tmp6_;
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp5_ = self->priv->_black_extra_seconds;
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp6_ = self->priv->_extra_seconds;
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				chess_clock_set_black_extra_seconds (self, _tmp5_ + _tmp6_);
#line 369 "chess-clock.c"
			}
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			break;
#line 373 "chess-clock.c"
		}
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_BRONSTEIN:
#line 377 "chess-clock.c"
		{
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			Color _tmp11_;
			Color _tmp12_;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp7_ = self->priv->_white_seconds_used;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp8_ = self->priv->_white_prev_move_seconds;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			white_move_used = _tmp7_ - _tmp8_;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp9_ = self->priv->_black_seconds_used;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp10_ = self->priv->_black_prev_move_seconds;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			black_move_used = _tmp9_ - _tmp10_;
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp11_ = chess_clock_get_active_color (self);
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			_tmp12_ = _tmp11_;
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			if (_tmp12_ != COLOR_WHITE) {
#line 403 "chess-clock.c"
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp13_ = self->priv->_white_extra_seconds;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp14_ = self->priv->_extra_seconds;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp15_ = white_move_used;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp16_ = MIN (_tmp14_, _tmp15_);
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				chess_clock_set_white_extra_seconds (self, _tmp13_ + _tmp16_);
#line 418 "chess-clock.c"
			} else {
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp17_ = self->priv->_black_extra_seconds;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp18_ = self->priv->_extra_seconds;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp19_ = black_move_used;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				_tmp20_ = MIN (_tmp18_, _tmp19_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
				chess_clock_set_black_extra_seconds (self, _tmp17_ + _tmp20_);
#line 434 "chess-clock.c"
			}
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			break;
#line 438 "chess-clock.c"
		}
		default:
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 443 "chess-clock.c"
	}
}


ChessClock* chess_clock_construct (GType object_type, gint white_initial_seconds, gint black_initial_seconds) {
	ChessClock * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self = (ChessClock*) g_object_new (object_type, NULL);
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = white_initial_seconds;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	chess_clock_set_white_initial_seconds (self, _tmp0_);
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = black_initial_seconds;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	chess_clock_set_black_initial_seconds (self, _tmp1_);
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return self;
#line 464 "chess-clock.c"
}


ChessClock* chess_clock_new (gint white_initial_seconds, gint black_initial_seconds) {
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return chess_clock_construct (TYPE_CHESS_CLOCK, white_initial_seconds, black_initial_seconds);
#line 471 "chess-clock.c"
}


void chess_clock_start (ChessClock* self) {
	gboolean _tmp0_;
	GTimer* _tmp1_;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->is_active;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (_tmp0_) {
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		return;
#line 486 "chess-clock.c"
	}
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->is_active = TRUE;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (_tmp1_ == NULL) {
#line 494 "chess-clock.c"
		GTimer* _tmp2_;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp2_ = g_timer_new ();
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_g_timer_destroy0 (self->priv->timer);
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->timer = _tmp2_;
#line 502 "chess-clock.c"
	} else {
		GTimer* _tmp3_;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp3_ = self->priv->timer;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_timer_start (_tmp3_);
#line 509 "chess-clock.c"
	}
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	chess_clock_watch_timer (self);
#line 513 "chess-clock.c"
}


static gboolean chess_clock_tick_cb (ChessClock* self) {
	gboolean result = FALSE;
	Color _tmp0_;
	Color _tmp1_;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gint _tmp6_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = chess_clock_get_active_color (self);
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = _tmp0_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (_tmp1_ == COLOR_WHITE) {
#line 532 "chess-clock.c"
		gint _tmp2_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp2_ = self->priv->_white_seconds_used;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_seconds_used (self, _tmp2_ + 1);
#line 538 "chess-clock.c"
	} else {
		gint _tmp3_;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp3_ = self->priv->_black_seconds_used;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_seconds_used (self, _tmp3_ + 1);
#line 545 "chess-clock.c"
	}
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_signal_emit (self, chess_clock_signals[CHESS_CLOCK_TICK_SIGNAL], 0);
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp5_ = self->priv->_white_seconds_used;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp6_ = self->priv->_white_initial_seconds;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (_tmp5_ >= _tmp6_) {
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp4_ = TRUE;
#line 557 "chess-clock.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp7_ = self->priv->_black_seconds_used;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp8_ = self->priv->_black_initial_seconds;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp4_ = _tmp7_ >= _tmp8_;
#line 567 "chess-clock.c"
	}
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (_tmp4_) {
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_stop (self);
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_signal_emit (self, chess_clock_signals[CHESS_CLOCK_EXPIRED_SIGNAL], 0);
#line 575 "chess-clock.c"
	}
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = G_SOURCE_CONTINUE;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 581 "chess-clock.c"
}


void chess_clock_stop (ChessClock* self) {
	gboolean _tmp0_;
	GTimer* _tmp1_;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->is_active;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (!_tmp0_) {
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		return;
#line 596 "chess-clock.c"
	}
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_timer_stop (_tmp1_);
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	chess_clock_stop_watching_timer (self);
#line 188 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->is_active = FALSE;
#line 606 "chess-clock.c"
}


void chess_clock_pause (ChessClock* self) {
	gboolean _tmp0_;
	GTimer* _tmp1_;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->is_active;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (!_tmp0_) {
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		return;
#line 621 "chess-clock.c"
	}
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_timer_stop (_tmp1_);
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	chess_clock_stop_watching_timer (self);
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->is_active = FALSE;
#line 631 "chess-clock.c"
}


void chess_clock_unpause (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_;
	GTimer* _tmp3_;
#line 201 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (_tmp1_ == NULL) {
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = TRUE;
#line 647 "chess-clock.c"
	} else {
		gboolean _tmp2_;
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp2_ = self->priv->is_active;
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = _tmp2_;
#line 654 "chess-clock.c"
	}
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (_tmp0_) {
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		return;
#line 660 "chess-clock.c"
	}
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp3_ = self->priv->timer;
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_timer_continue (_tmp3_);
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	chess_clock_watch_timer (self);
#line 208 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->is_active = TRUE;
#line 670 "chess-clock.c"
}


static gboolean _chess_clock_tick_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_clock_tick_cb ((ChessClock*) self);
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 679 "chess-clock.c"
}


static void chess_clock_watch_timer (ChessClock* self) {
	guint _tmp0_;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _chess_clock_tick_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->tick_timeout_id = _tmp0_;
#line 691 "chess-clock.c"
}


static void chess_clock_stop_watching_timer (ChessClock* self) {
	guint _tmp0_;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->tick_timeout_id;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_source_remove (_tmp0_);
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->tick_timeout_id = (guint) 0;
#line 705 "chess-clock.c"
}


gint chess_clock_get_white_initial_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_white_initial_seconds;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 720 "chess-clock.c"
}


static void chess_clock_set_white_initial_seconds (ChessClock* self, gint value) {
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_white_initial_seconds (self) != value) {
#line 729 "chess-clock.c"
		gint _tmp0_;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_white_initial_seconds = _tmp0_;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "white-initial-seconds");
#line 737 "chess-clock.c"
	}
}


gint chess_clock_get_black_initial_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_black_initial_seconds;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 753 "chess-clock.c"
}


static void chess_clock_set_black_initial_seconds (ChessClock* self, gint value) {
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_black_initial_seconds (self) != value) {
#line 762 "chess-clock.c"
		gint _tmp0_;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_black_initial_seconds = _tmp0_;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "black-initial-seconds");
#line 770 "chess-clock.c"
	}
}


gint chess_clock_get_white_seconds_used (ChessClock* self) {
	gint result;
	gint _tmp0_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_white_seconds_used;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 786 "chess-clock.c"
}


static void chess_clock_set_white_seconds_used (ChessClock* self, gint value) {
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_white_seconds_used (self) != value) {
#line 795 "chess-clock.c"
		gint _tmp0_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_white_seconds_used = _tmp0_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "white-seconds-used");
#line 803 "chess-clock.c"
	}
}


gint chess_clock_get_black_seconds_used (ChessClock* self) {
	gint result;
	gint _tmp0_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_black_seconds_used;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 819 "chess-clock.c"
}


static void chess_clock_set_black_seconds_used (ChessClock* self, gint value) {
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_black_seconds_used (self) != value) {
#line 828 "chess-clock.c"
		gint _tmp0_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_black_seconds_used = _tmp0_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "black-seconds-used");
#line 836 "chess-clock.c"
	}
}


ClockType chess_clock_get_clock_type (ChessClock* self) {
	ClockType result;
	ClockType _tmp0_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_clock_type;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 852 "chess-clock.c"
}


void chess_clock_set_clock_type (ChessClock* self, ClockType value) {
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_clock_type (self) != value) {
#line 861 "chess-clock.c"
		ClockType _tmp0_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_clock_type = _tmp0_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "clock-type");
#line 869 "chess-clock.c"
	}
}


gint chess_clock_get_white_prev_move_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_white_prev_move_seconds;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 885 "chess-clock.c"
}


static void chess_clock_set_white_prev_move_seconds (ChessClock* self, gint value) {
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_white_prev_move_seconds (self) != value) {
#line 894 "chess-clock.c"
		gint _tmp0_;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_white_prev_move_seconds = _tmp0_;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "white-prev-move-seconds");
#line 902 "chess-clock.c"
	}
}


gint chess_clock_get_black_prev_move_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_black_prev_move_seconds;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 918 "chess-clock.c"
}


static void chess_clock_set_black_prev_move_seconds (ChessClock* self, gint value) {
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_black_prev_move_seconds (self) != value) {
#line 927 "chess-clock.c"
		gint _tmp0_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_black_prev_move_seconds = _tmp0_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "black-prev-move-seconds");
#line 935 "chess-clock.c"
	}
}


gint chess_clock_get_white_extra_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_white_extra_seconds;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 951 "chess-clock.c"
}


static void chess_clock_set_white_extra_seconds (ChessClock* self, gint value) {
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_white_extra_seconds (self) != value) {
#line 960 "chess-clock.c"
		gint _tmp0_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_white_extra_seconds = _tmp0_;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "white-extra-seconds");
#line 968 "chess-clock.c"
	}
}


gint chess_clock_get_black_extra_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_black_extra_seconds;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 984 "chess-clock.c"
}


static void chess_clock_set_black_extra_seconds (ChessClock* self, gint value) {
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_black_extra_seconds (self) != value) {
#line 993 "chess-clock.c"
		gint _tmp0_;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_black_extra_seconds = _tmp0_;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "black-extra-seconds");
#line 1001 "chess-clock.c"
	}
}


gint chess_clock_get_extra_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_extra_seconds;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 1017 "chess-clock.c"
}


void chess_clock_set_extra_seconds (ChessClock* self, gint value) {
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_extra_seconds (self) != value) {
#line 1026 "chess-clock.c"
		gint _tmp0_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_extra_seconds = _tmp0_;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "extra-seconds");
#line 1034 "chess-clock.c"
	}
}


Color chess_clock_get_active_color (ChessClock* self) {
	Color result;
	Color _tmp0_;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_active_color;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	return result;
#line 1050 "chess-clock.c"
}


void chess_clock_set_active_color (ChessClock* self, Color value) {
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	if (chess_clock_get_active_color (self) != value) {
#line 1059 "chess-clock.c"
		Color _tmp0_;
		Color _tmp1_;
		Color _tmp2_;
		Color _tmp3_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = value;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp1_ = chess_clock_get_active_color (self);
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp2_ = _tmp1_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		if (_tmp0_ == _tmp2_) {
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
			return;
#line 1074 "chess-clock.c"
		}
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_stop (self);
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		_tmp3_ = value;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		self->priv->_active_color = _tmp3_;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_update_extra_seconds (self);
#line 122 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_update_prev_move_time (self);
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_start (self);
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_object_notify ((GObject *) self, "active-color");
#line 1090 "chess-clock.c"
	}
}


static void chess_clock_class_init (ChessClockClass * klass) {
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	chess_clock_parent_class = g_type_class_peek_parent (klass);
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_type_class_add_private (klass, sizeof (ChessClockPrivate));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_clock_get_property;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_clock_set_property;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_clock_finalize;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_INITIAL_SECONDS, g_param_spec_int ("white-initial-seconds", "white-initial-seconds", "white-initial-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_INITIAL_SECONDS, g_param_spec_int ("black-initial-seconds", "black-initial-seconds", "black-initial-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_SECONDS_USED, g_param_spec_int ("white-seconds-used", "white-seconds-used", "white-seconds-used", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_SECONDS_USED, g_param_spec_int ("black-seconds-used", "black-seconds-used", "black-seconds-used", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_CLOCK_TYPE, g_param_spec_enum ("clock-type", "clock-type", "clock-type", TYPE_CLOCK_TYPE, CLOCK_TYPE_SIMPLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS, g_param_spec_int ("white-prev-move-seconds", "white-prev-move-seconds", "white-prev-move-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS, g_param_spec_int ("black-prev-move-seconds", "black-prev-move-seconds", "black-prev-move-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_EXTRA_SECONDS, g_param_spec_int ("white-extra-seconds", "white-extra-seconds", "white-extra-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_EXTRA_SECONDS, g_param_spec_int ("black-extra-seconds", "black-extra-seconds", "black-extra-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_EXTRA_SECONDS, g_param_spec_int ("extra-seconds", "extra-seconds", "extra-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_ACTIVE_COLOR, g_param_spec_enum ("active-color", "active-color", "active-color", TYPE_COLOR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	chess_clock_signals[CHESS_CLOCK_TICK_SIGNAL] = g_signal_new ("tick", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	chess_clock_signals[CHESS_CLOCK_EXPIRED_SIGNAL] = g_signal_new ("expired", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1132 "chess-clock.c"
}


static void chess_clock_instance_init (ChessClock * self) {
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv = CHESS_CLOCK_GET_PRIVATE (self);
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->_white_seconds_used = 0;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->_black_seconds_used = 0;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->_clock_type = CLOCK_TYPE_SIMPLE;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->_white_prev_move_seconds = 0;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->_black_prev_move_seconds = 0;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->_white_extra_seconds = 0;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->_black_extra_seconds = 0;
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->_active_color = COLOR_WHITE;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->_extra_seconds = 0;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->tick_timeout_id = (guint) 0;
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self->priv->is_active = FALSE;
#line 1161 "chess-clock.c"
}


static void chess_clock_finalize (GObject * obj) {
	ChessClock * self;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_CLOCK, ChessClock);
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	_g_timer_destroy0 (self->priv->timer);
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	G_OBJECT_CLASS (chess_clock_parent_class)->finalize (obj);
#line 1173 "chess-clock.c"
}


GType chess_clock_get_type (void) {
	static volatile gsize chess_clock_type_id__volatile = 0;
	if (g_once_init_enter (&chess_clock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessClockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_clock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessClock), 0, (GInstanceInitFunc) chess_clock_instance_init, NULL };
		GType chess_clock_type_id;
		chess_clock_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessClock", &g_define_type_info, 0);
		g_once_init_leave (&chess_clock_type_id__volatile, chess_clock_type_id);
	}
	return chess_clock_type_id__volatile;
}


static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_CLOCK, ChessClock);
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	switch (property_id) {
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_INITIAL_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_white_initial_seconds (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_INITIAL_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_black_initial_seconds (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_SECONDS_USED:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_white_seconds_used (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_SECONDS_USED:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_black_seconds_used (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_CLOCK_TYPE:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_enum (value, chess_clock_get_clock_type (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_white_prev_move_seconds (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_black_prev_move_seconds (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_EXTRA_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_white_extra_seconds (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_EXTRA_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_black_extra_seconds (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_EXTRA_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_extra_seconds (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_ACTIVE_COLOR:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		g_value_set_enum (value, chess_clock_get_active_color (self));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 1260 "chess-clock.c"
		default:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 1266 "chess-clock.c"
	}
}


static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_CLOCK, ChessClock);
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
	switch (property_id) {
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_INITIAL_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_initial_seconds (self, g_value_get_int (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_INITIAL_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_initial_seconds (self, g_value_get_int (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_SECONDS_USED:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_seconds_used (self, g_value_get_int (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_SECONDS_USED:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_seconds_used (self, g_value_get_int (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_CLOCK_TYPE:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_clock_type (self, g_value_get_enum (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_prev_move_seconds (self, g_value_get_int (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_prev_move_seconds (self, g_value_get_int (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_EXTRA_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_extra_seconds (self, g_value_get_int (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_EXTRA_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_extra_seconds (self, g_value_get_int (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_EXTRA_SECONDS:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_extra_seconds (self, g_value_get_int (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_ACTIVE_COLOR:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_active_color (self, g_value_get_enum (value));
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 1342 "chess-clock.c"
		default:
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-clock.vala"
		break;
#line 1348 "chess-clock.c"
	}
}



