/* libchess.h generated by valac 0.26.0.79-670a6, the Vala compiler, do not modify */


#ifndef __LIBCHESS_H__
#define __LIBCHESS_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

G_BEGIN_DECLS


#define TYPE_BIT_BOARD (bit_board_get_type ())
#define BIT_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BIT_BOARD, BitBoard))
#define BIT_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BIT_BOARD, BitBoardClass))
#define IS_BIT_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BIT_BOARD))
#define IS_BIT_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BIT_BOARD))
#define BIT_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BIT_BOARD, BitBoardClass))

typedef struct _BitBoard BitBoard;
typedef struct _BitBoardClass BitBoardClass;
typedef struct _BitBoardPrivate BitBoardPrivate;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
typedef struct _ChessClockPrivate ChessClockPrivate;

#define TYPE_COLOR (color_get_type ())

#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ChessMovePrivate ChessMovePrivate;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;
typedef struct _PGNGamePrivate PGNGamePrivate;

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
typedef struct _PGNPrivate PGNPrivate;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
typedef struct _ChessPiecePrivate ChessPiecePrivate;
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;
typedef struct _ChessStatePrivate ChessStatePrivate;

struct _BitBoard {
	GObject parent_instance;
	BitBoardPrivate * priv;
};

struct _BitBoardClass {
	GObjectClass parent_class;
};

struct _ChessClock {
	GObject parent_instance;
	ChessClockPrivate * priv;
};

struct _ChessClockClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

struct _ChessGame {
	GObject parent_instance;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GObjectClass parent_class;
};

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessMove {
	GObject parent_instance;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GObjectClass parent_class;
};

typedef enum  {
	PGN_ERROR_LOAD_ERROR
} PGNError;
#define PGN_ERROR pgn_error_quark ()
struct _PGNGame {
	GObject parent_instance;
	PGNGamePrivate * priv;
	GHashTable* tags;
	GList* moves;
};

struct _PGNGameClass {
	GObjectClass parent_class;
};

struct _PGN {
	GObject parent_instance;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GObjectClass parent_class;
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GObject parent_instance;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GObjectClass parent_class;
};

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _ChessState {
	GObject parent_instance;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GObjectClass parent_class;
};


GType bit_board_get_type (void) G_GNUC_CONST;
gchar* bit_board_to_string (gint64 mask);
BitBoard* bit_board_new (void);
BitBoard* bit_board_construct (GType object_type);
GType chess_clock_get_type (void) G_GNUC_CONST;
ChessClock* chess_clock_new (gint white_initial_seconds, gint black_initial_seconds);
ChessClock* chess_clock_construct (GType object_type, gint white_initial_seconds, gint black_initial_seconds);
void chess_clock_start (ChessClock* self);
void chess_clock_stop (ChessClock* self);
void chess_clock_pause (ChessClock* self);
void chess_clock_unpause (ChessClock* self);
gint chess_clock_get_white_initial_seconds (ChessClock* self);
gint chess_clock_get_black_initial_seconds (ChessClock* self);
gint chess_clock_get_white_seconds_used (ChessClock* self);
gint chess_clock_get_black_seconds_used (ChessClock* self);
GType color_get_type (void) G_GNUC_CONST;
Color chess_clock_get_active_color (ChessClock* self);
void chess_clock_set_active_color (ChessClock* self, Color value);
GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
GType chess_game_get_type (void) G_GNUC_CONST;
GType chess_state_get_type (void) G_GNUC_CONST;
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1);
void chess_game_add_hold (ChessGame* self);
void chess_game_remove_hold (ChessGame* self);
gboolean chess_game_is_three_fold_repeat (ChessGame* self);
gboolean chess_game_is_fifty_move_rule_fulfilled (ChessGame* self);
gboolean chess_game_can_claim_draw (ChessGame* self);
void chess_game_start (ChessGame* self);
GType chess_piece_get_type (void) G_GNUC_CONST;
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
void chess_game_pause (ChessGame* self, gboolean show_overlay);
void chess_game_unpause (ChessGame* self);
void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule);
gboolean chess_game_get_is_paused (ChessGame* self);
gboolean chess_game_get_should_show_paused_overlay (ChessGame* self);
ChessState* chess_game_get_current_state (ChessGame* self);
GType chess_player_get_type (void) G_GNUC_CONST;
ChessPlayer* chess_game_get_white (ChessGame* self);
ChessPlayer* chess_game_get_black (ChessGame* self);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
ChessClock* chess_game_get_clock (ChessGame* self);
void chess_game_set_clock (ChessGame* self, ChessClock* value);
guint chess_game_get_n_moves (ChessGame* self);
GType chess_move_get_type (void) G_GNUC_CONST;
GType check_state_get_type (void) G_GNUC_CONST;
gchar* chess_move_get_lan (ChessMove* self);
gchar* chess_move_get_san (ChessMove* self);
gchar* chess_move_get_fan (ChessMove* self);
gchar* chess_move_get_engine (ChessMove* self);
ChessMove* chess_move_copy (ChessMove* self);
ChessMove* chess_move_new (void);
ChessMove* chess_move_construct (GType object_type);
GQuark pgn_error_quark (void);
GType pgn_game_get_type (void) G_GNUC_CONST;
extern gchar* pgn_game_RESULT_IN_PROGRESS;
extern gchar* pgn_game_RESULT_DRAW;
extern gchar* pgn_game_RESULT_WHITE;
extern gchar* pgn_game_RESULT_BLACK;
extern gchar* pgn_game_TERMINATE_ABANDONED;
extern gchar* pgn_game_TERMINATE_ADJUDICATION;
extern gchar* pgn_game_TERMINATE_DEATH;
extern gchar* pgn_game_TERMINATE_EMERGENCY;
extern gchar* pgn_game_TERMINATE_NORMAL;
extern gchar* pgn_game_TERMINATE_RULES_INFRACTION;
extern gchar* pgn_game_TERMINATE_TIME_FORFEIT;
extern gchar* pgn_game_TERMINATE_UNTERMINATED;
PGNGame* pgn_game_new (void);
PGNGame* pgn_game_construct (GType object_type);
gchar* pgn_game_escape (PGNGame* self, const gchar* value);
void pgn_game_write (PGNGame* self, GFile* file, GError** error);
const gchar* pgn_game_get_event (PGNGame* self);
void pgn_game_set_event (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_site (PGNGame* self);
void pgn_game_set_site (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_date (PGNGame* self);
void pgn_game_set_date (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_time (PGNGame* self);
void pgn_game_set_time (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_round (PGNGame* self);
void pgn_game_set_round (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_white (PGNGame* self);
void pgn_game_set_white (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_black (PGNGame* self);
void pgn_game_set_black (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_result (PGNGame* self);
void pgn_game_set_result (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_annotator (PGNGame* self);
void pgn_game_set_annotator (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_time_control (PGNGame* self);
void pgn_game_set_time_control (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_white_time_left (PGNGame* self);
void pgn_game_set_white_time_left (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_black_time_left (PGNGame* self);
void pgn_game_set_black_time_left (PGNGame* self, const gchar* value);
gboolean pgn_game_get_set_up (PGNGame* self);
void pgn_game_set_set_up (PGNGame* self, gboolean value);
const gchar* pgn_game_get_fen (PGNGame* self);
void pgn_game_set_fen (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_termination (PGNGame* self);
void pgn_game_set_termination (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_white_ai (PGNGame* self);
void pgn_game_set_white_ai (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_white_level (PGNGame* self);
void pgn_game_set_white_level (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_black_ai (PGNGame* self);
void pgn_game_set_black_ai (PGNGame* self, const gchar* value);
const gchar* pgn_game_get_black_level (PGNGame* self);
void pgn_game_set_black_level (PGNGame* self, const gchar* value);
GType pgn_get_type (void) G_GNUC_CONST;
PGN* pgn_new_from_string (const gchar* data, GError** error);
PGN* pgn_construct_from_string (GType object_type, const gchar* data, GError** error);
PGN* pgn_new_from_file (GFile* file, GError** error);
PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error);
PGN* pgn_new (void);
PGN* pgn_construct (GType object_type);
GType piece_type_get_type (void) G_GNUC_CONST;
ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type);
ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type);
Color chess_piece_get_color (ChessPiece* self);
gunichar chess_piece_get_symbol (ChessPiece* self);
ChessPlayer* chess_player_new (Color color);
ChessPlayer* chess_player_construct (GType object_type, Color color);
gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply);
gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply, PieceType promotion_type);
void chess_player_undo (ChessPlayer* self);
gboolean chess_player_resign (ChessPlayer* self);
void chess_player_claim_draw (ChessPlayer* self);
gboolean chess_player_get_local_human (ChessPlayer* self);
void chess_player_set_local_human (ChessPlayer* self, gboolean value);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
ChessState* chess_state_copy (ChessState* self);
gboolean chess_state_equals (ChessState* self, ChessState* state);
gchar* chess_state_get_fen (ChessState* self);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
gint chess_state_get_rank (ChessState* self, gint index);
gint chess_state_get_file (ChessState* self, gint index);
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check);
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player);
gboolean chess_state_have_sufficient_material (ChessState* self);
ChessPlayer* chess_state_get_opponent (ChessState* self);

extern const gint64 BIT_BOARD_set_location_masks[64];
extern const gint64 BIT_BOARD_clear_location_masks[64];
extern const gint64 BIT_BOARD_over_masks[4096];
extern const gint64 BIT_BOARD_move_masks[768];

G_END_DECLS

#endif
