/* gnome-chess.c generated by valac 0.22.0.6-e3cc, the Vala compiler
 * generated from gnome-chess.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Workaround for https://bugzilla.gnome.org/show_bug.cgi?id=647122 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <librsvg/rsvg.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;

#define TYPE_AI_PROFILE (ai_profile_get_type ())
#define AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AI_PROFILE, AIProfile))
#define AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AI_PROFILE, AIProfileClass))
#define IS_AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AI_PROFILE))
#define IS_AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AI_PROFILE))
#define AI_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AI_PROFILE, AIProfileClass))

typedef struct _AIProfile AIProfile;
typedef struct _AIProfileClass AIProfileClass;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;

#define APPLICATION_TYPE_SENSITIVITY_INDEX (application_sensitivity_index_get_type ())

#define APPLICATION_TYPE_PROMOTION_TYPE_SELECTED (application_promotion_type_selected_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pgn_game_unref0(var) ((var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL)))
#define _chess_game_unref0(var) ((var == NULL) ? NULL : (var = (chess_game_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__ai_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__ai_profile_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PIECE_TYPE (piece_type_get_type ())
#define _ai_profile_unref0(var) ((var == NULL) ? NULL : (var = (ai_profile_unref (var), NULL)))
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())

#define TYPE_CHESS_VIEW3_D (chess_view3_d_get_type ())
#define CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW3_D, ChessView3D))
#define CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW3_D, ChessView3DClass))
#define IS_CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW3_D))
#define IS_CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW3_D))
#define CHESS_VIEW3_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW3_D, ChessView3DClass))

typedef struct _ChessView3D ChessView3D;
typedef struct _ChessView3DClass ChessView3DClass;

#define TYPE_CHESS_VIEW2_D (chess_view2_d_get_type ())
#define CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW2_D, ChessView2D))
#define CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW2_D, ChessView2DClass))
#define IS_CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW2_D))
#define IS_CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW2_D))
#define CHESS_VIEW2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW2_D, ChessView2DClass))

typedef struct _ChessView2D ChessView2D;
typedef struct _ChessView2DClass ChessView2DClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))
typedef struct _PGNGamePrivate PGNGamePrivate;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _ChessMovePrivate ChessMovePrivate;
typedef struct _ChessPiecePrivate ChessPiecePrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
typedef struct _PGNPrivate PGNPrivate;
#define _pgn_unref0(var) ((var == NULL) ? NULL : (var = (pgn_unref (var), NULL)))

#define TYPE_GNOME_CHESS (gnome_chess_get_type ())
#define GNOME_CHESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GNOME_CHESS, GnomeChess))
#define GNOME_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GNOME_CHESS, GnomeChessClass))
#define IS_GNOME_CHESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GNOME_CHESS))
#define IS_GNOME_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GNOME_CHESS))
#define GNOME_CHESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GNOME_CHESS, GnomeChessClass))

typedef struct _GnomeChess GnomeChess;
typedef struct _GnomeChessClass GnomeChessClass;
typedef struct _GnomeChessPrivate GnomeChessPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _ParamSpecGnomeChess ParamSpecGnomeChess;

struct _Application {
	GtkApplication parent_instance;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ApplicationPrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkBuilder* preferences_builder;
	GtkWindow* window;
	GtkInfoBar* info_bar;
	GtkLabel* info_title_label;
	GtkLabel* info_label;
	GtkContainer* view_container;
	ChessScene* scene;
	ChessView* view;
	GtkWidget* save_button;
	GtkWidget* undo_button;
	GtkWidget* pause_button;
	GtkWidget* claim_draw_button;
	GtkWidget* resign_button;
	GtkWidget* fullscreen_button;
	GtkWidget* first_move_button;
	GtkWidget* prev_move_button;
	GtkWidget* next_move_button;
	GtkWidget* last_move_button;
	GtkComboBox* history_combo;
	GtkWidget* white_time_label;
	GtkWidget* black_time_label;
	GtkDialog* preferences_dialog;
	GtkComboBox* side_combo;
	GtkComboBox* difficulty_combo;
	GtkComboBox* duration_combo;
	GtkAdjustment* duration_adjustment;
	GtkContainer* custom_duration_box;
	GtkComboBox* custom_duration_units_combo;
	guint save_duration_timeout;
	GtkFileChooserDialog* open_dialog;
	GtkInfoBar* open_dialog_info_bar;
	GtkLabel* open_dialog_error_label;
	GtkFileChooserDialog* save_dialog;
	GtkInfoBar* save_dialog_info_bar;
	GtkLabel* save_dialog_error_label;
	GtkAboutDialog* about_dialog;
	PGNGame* pgn_game;
	ChessGame* game;
	gboolean in_history;
	gchar* autosave_filename;
	GFile* game_file;
	gboolean game_needs_saving;
	gchar* saved_filename;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
	gboolean is_fullscreen;
	gboolean widget_sensitivity[8];
};

typedef enum  {
	APPLICATION_SENSITIVITY_INDEX_UNDO,
	APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW,
	APPLICATION_SENSITIVITY_INDEX_RESIGN,
	APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE,
	APPLICATION_SENSITIVITY_INDEX_PREV_MOVE,
	APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE,
	APPLICATION_SENSITIVITY_INDEX_LAST_MOVE,
	APPLICATION_SENSITIVITY_INDEX_HISTORY
} ApplicationSensitivityIndex;

typedef enum  {
	APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN,
	APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT,
	APPLICATION_PROMOTION_TYPE_SELECTED_ROOK,
	APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP
} ApplicationPromotionTypeSelected;

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

struct _ChessGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GTypeClass parent_class;
	void (*finalize) (ChessGame *self);
};

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _PGNGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNGamePrivate * priv;
	GHashTable* tags;
	GList* moves;
};

struct _PGNGameClass {
	GTypeClass parent_class;
	void (*finalize) (PGNGame *self);
};

struct _ChessMove {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GTypeClass parent_class;
	void (*finalize) (ChessMove *self);
};

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

struct _PGN {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GTypeClass parent_class;
	void (*finalize) (PGN *self);
};

struct _GnomeChess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GnomeChessPrivate * priv;
};

struct _GnomeChessClass {
	GTypeClass parent_class;
	void (*finalize) (GnomeChess *self);
};

struct _ParamSpecGnomeChess {
	GParamSpec parent_instance;
};


static gpointer application_parent_class = NULL;
extern gchar* pgn_game_RESULT_WHITE;
extern gchar* pgn_game_RESULT_BLACK;
extern gchar* pgn_game_RESULT_DRAW;
extern gchar* pgn_game_TERMINATE_ABANDONED;
extern gchar* pgn_game_TERMINATE_DEATH;
static gpointer gnome_chess_parent_class = NULL;
static gboolean gnome_chess_show_version;
static gboolean gnome_chess_show_version = FALSE;

void gtk_file_filter_set_name (GtkFileFilter* filter, const gchar* name);
GType application_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
GType chess_view_get_type (void) G_GNUC_CONST;
gpointer pgn_game_ref (gpointer instance);
void pgn_game_unref (gpointer instance);
GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn_game (GValue* value, gpointer v_object);
void value_take_pgn_game (GValue* value, gpointer v_object);
gpointer value_get_pgn_game (const GValue* value);
GType pgn_game_get_type (void) G_GNUC_CONST;
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
gpointer ai_profile_ref (gpointer instance);
void ai_profile_unref (gpointer instance);
GParamSpec* param_spec_ai_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ai_profile (GValue* value, gpointer v_object);
void value_take_ai_profile (GValue* value, gpointer v_object);
gpointer value_get_ai_profile (const GValue* value);
GType ai_profile_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
GType chess_engine_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY
};
static GType application_sensitivity_index_get_type (void) G_GNUC_UNUSED;
static GType application_promotion_type_selected_get_type (void) G_GNUC_UNUSED;
static void _ai_profile_unref0_ (gpointer var);
static void _g_list_free__ai_profile_unref0_ (GList* self);
void application_preferences_cb (Application* self);
static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void application_help_cb (Application* self);
static void _application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void application_about_cb (Application* self);
static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void application_quit_cb (Application* self);
static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Application* application_new (GFile* game_file);
Application* application_construct (GType object_type, GFile* game_file);
gboolean application_on_window_focus_out (Application* self, GdkEventFocus* focus);
void chess_game_pause (ChessGame* self);
gboolean application_on_window_focus_in (Application* self, GdkEventFocus* focus);
void chess_game_unpause (ChessGame* self);
static void application_real_startup (GApplication* base);
static gboolean _application_on_window_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean _application_on_window_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
static gboolean __lambda2_ (Application* self, ChessPlayer* p);
static gboolean ___lambda2__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self);
static void application_scene_changed_cb (Application* self, ChessScene* scene);
static void _application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
GType piece_type_get_type (void) G_GNUC_CONST;
PieceType application_show_promotion_type_selector (Application* self);
static PieceType _application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self);
static void application_settings_changed_cb (Application* self, GSettings* settings, const gchar* key);
static void _application_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
GList* ai_profile_load_ai_profiles (const gchar* filename);
const gchar* ai_profile_get_name (AIProfile* self);
const gchar* ai_profile_get_path (AIProfile* self);
static void application_start_new_game (Application* self);
static void application_load_game (Application* self, GFile* file, GError** error);
void application_show (Application* self);
static void application_real_shutdown (GApplication* base);
void chess_engine_stop (ChessEngine* self);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
GType color_get_type (void) G_GNUC_CONST;
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void application_set_piece_image (Application* self, GtkImage* image, const gchar* filename);
void application_quit_game (Application* self);
static gboolean application_save_duration_cb (Application* self);
static void application_autosave (Application* self);
static void application_update_pgn_time_remaining (Application* self);
void pgn_game_write (PGNGame* self, GFile* file, GError** error);
ChessView3D* chess_view3_d_new (void);
ChessView3D* chess_view3_d_construct (GType object_type);
GType chess_view3_d_get_type (void) G_GNUC_CONST;
ChessView2D* chess_view2_d_new (void);
ChessView2D* chess_view2_d_construct (GType object_type);
GType chess_view2_d_get_type (void) G_GNUC_CONST;
void chess_view_set_scene (ChessView* self, ChessScene* value);
static void application_update_history_panel (Application* self);
gint chess_scene_get_move_number (ChessScene* self);
guint chess_game_get_n_moves (ChessGame* self);
GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
static void application_set_move_text (Application* self, GtkTreeIter* iter, ChessMove* move);
static void application_start_game (Application* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
gboolean pgn_game_get_set_up (PGNGame* self);
const gchar* pgn_game_get_fen (PGNGame* self);
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1);
const gchar* pgn_game_get_time_control (PGNGame* self);
const gchar* pgn_game_get_white_time_left (PGNGame* self);
const gchar* pgn_game_get_black_time_left (PGNGame* self);
ChessClock* chess_clock_new (guint white_initial_seconds, guint black_initial_seconds);
ChessClock* chess_clock_construct (GType object_type, guint white_initial_seconds, guint black_initial_seconds);
GType chess_clock_get_type (void) G_GNUC_CONST;
void chess_game_set_clock (ChessGame* self, ChessClock* value);
static void application_game_start_cb (Application* self, ChessGame* game);
static void _application_game_start_cb_chess_game_started (ChessGame* _sender, gpointer self);
static void application_game_turn_cb (Application* self, ChessGame* game, ChessPlayer* player);
static void _application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self);
static void application_game_move_cb (Application* self, ChessGame* game, ChessMove* move);
static void _application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void application_game_undo_cb (Application* self, ChessGame* game);
static void _application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
static void application_game_end_cb (Application* self, ChessGame* game);
static void _application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self);
ChessClock* chess_game_get_clock (ChessGame* self);
static void application_game_clock_tick_cb (Application* self, ChessClock* clock);
static void _application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void application_update_control_buttons (Application* self);
const gchar* pgn_game_get_white_ai (PGNGame* self);
const gchar* pgn_game_get_white_level (PGNGame* self);
const gchar* pgn_game_get_black_ai (PGNGame* self);
const gchar* pgn_game_get_black_level (PGNGame* self);
static void application_engine_ready_cb (Application* self, ChessEngine* engine);
static void _application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self);
static void application_engine_move_cb (Application* self, ChessEngine* engine, const gchar* move);
static void _application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self);
static void application_engine_resigned_cb (Application* self, ChessEngine* engine);
static void _application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self);
static void application_engine_stopped_cb (Application* self, ChessEngine* engine);
static void _application_engine_stopped_cb_chess_engine_stopped (ChessEngine* _sender, gpointer self);
static void application_engine_error_cb (Application* self, ChessEngine* engine);
static void _application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self);
static void application_engine_claim_draw_cb (Application* self, ChessEngine* engine);
static void _application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self);
static void application_engine_offer_draw_cb (Application* self, ChessEngine* engine);
static void _application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self);
ChessPlayer* chess_game_get_white (ChessGame* self);
ChessPlayer* chess_game_get_black (ChessGame* self);
static ChessEngine* application_get_engine (Application* self, const gchar* name, const gchar* difficulty);
void chess_player_set_local_human (ChessPlayer* self, gboolean value);
gboolean chess_engine_start (ChessEngine* self);
void chess_game_start (ChessGame* self);
void chess_clock_start (ChessClock* self);
gchar** ai_profile_get_easy_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
gchar** ai_profile_get_easy_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
gchar** ai_profile_get_easy_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
gchar** ai_profile_get_hard_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
gchar** ai_profile_get_hard_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup6 (gchar** self, int length);
gchar** ai_profile_get_hard_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
gchar** ai_profile_get_normal_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup8 (gchar** self, int length);
gchar** ai_profile_get_normal_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup9 (gchar** self, int length);
gchar** ai_profile_get_normal_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup10 (gchar** self, int length);
const gchar* ai_profile_get_protocol (AIProfile* self);
const gchar* ai_profile_get_binary (AIProfile* self);
ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1);
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
static void application_real_activate (GApplication* base);
gboolean chess_engine_get_ready (ChessEngine* self);
gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply);
void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule);
gboolean chess_player_resign (ChessPlayer* self);
gboolean chess_player_claim_draw (ChessPlayer* self);
void chess_engine_start_game (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
gchar* chess_move_get_san (ChessMove* self);
gchar* chess_move_get_fan (ChessMove* self);
gchar* chess_move_get_lan (ChessMove* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
void chess_scene_set_move_number (ChessScene* self, gint value);
void pgn_game_set_result (PGNGame* self, const gchar* value);
void pgn_game_set_termination (PGNGame* self, const gchar* value);
gboolean G_MODULE_EXPORT gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self);
gboolean G_MODULE_EXPORT gnome_chess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, Application* self);
gboolean G_MODULE_EXPORT gnome_chess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, Application* self);
static gboolean application_prompt_save_game (Application* self, const gchar* prompt_text);
static void application_save_game (Application* self, const gchar* cancel_button_label, const gchar* save_button_label);
void G_MODULE_EXPORT new_game_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT resign_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT claim_draw_cb (GtkWidget* widget, Application* self);
gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1);
ChessState* chess_game_get_current_state (ChessGame* self);
void G_MODULE_EXPORT undo_move_cb (GtkWidget* widget, Application* self);
void chess_player_undo (ChessPlayer* self);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
static void application_stash_button_sensitivity (Application* self);
static void application_revert_button_sensitivity (Application* self);
void G_MODULE_EXPORT pause_game_button_pressed_cb (GtkWidget* widget, Application* self);
gboolean chess_game_get_is_paused (ChessGame* self);
void chess_game_superpause (ChessGame* self);
gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self);
static void application_draw_time (Application* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1);
static gchar* application_make_clock_text (Application* self, ChessClock* clock, Color color);
gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self);
guint chess_clock_get_white_initial_seconds (ChessClock* self);
guint chess_clock_get_white_seconds_used (ChessClock* self);
guint chess_clock_get_black_initial_seconds (ChessClock* self);
guint chess_clock_get_black_seconds_used (ChessClock* self);
void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT toggle_fullscreen_cb (GtkWidget* widget, Application* self);
static void application_set_combo (Application* self, GtkComboBox* combo, gint value_index, const gchar* value);
static void application_set_duration (Application* self, gint duration, gboolean simplify);
static gchar* application_get_combo (Application* self, GtkComboBox* combo, gint value_index);
void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, Application* self);
static gint application_get_duration (Application* self);
void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, Application* self);
static void application_save_duration (Application* self);
void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, Application* self);
static gboolean _application_save_duration_cb_gsource_func (gpointer self);
void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, Application* self);
gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self);
void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT show_3d_toggle_cb (GtkToggleButton* widget, Application* self);
void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, Application* self);
static void application_about_response_cb (Application* self, gint response_id);
static void _application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void G_MODULE_EXPORT save_game_cb (GtkWidget* widget, Application* self);
static void application_add_info_bar_to_dialog (Application* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label);
static void application_save_file_cb (Application* self);
static void _application_save_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void application_save_cb (Application* self, gint response_id);
static void _application_save_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void pgn_game_set_white_time_left (PGNGame* self, const gchar* value);
void pgn_game_set_black_time_left (PGNGame* self, const gchar* value);
void G_MODULE_EXPORT open_game_cb (GtkWidget* widget, Application* self);
static void application_open_file_cb (Application* self);
static void _application_open_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void application_open_cb (Application* self, gint response_id);
static void _application_open_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
PGNGame* pgn_game_new (void);
PGNGame* pgn_game_construct (GType object_type);
void pgn_game_set_date (PGNGame* self, const gchar* value);
void pgn_game_set_time (PGNGame* self, const gchar* value);
void pgn_game_set_time_control (PGNGame* self, const gchar* value);
void pgn_game_set_black_ai (PGNGame* self, const gchar* value);
void pgn_game_set_black_level (PGNGame* self, const gchar* value);
void pgn_game_set_white_ai (PGNGame* self, const gchar* value);
void pgn_game_set_white_level (PGNGame* self, const gchar* value);
gpointer pgn_ref (gpointer instance);
void pgn_unref (gpointer instance);
GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn (GValue* value, gpointer v_object);
void value_take_pgn (GValue* value, gpointer v_object);
gpointer value_get_pgn (const GValue* value);
GType pgn_get_type (void) G_GNUC_CONST;
PGN* pgn_new_from_file (GFile* file, GError** error);
PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error);
static void application_finalize (GObject* obj);
gpointer gnome_chess_ref (gpointer instance);
void gnome_chess_unref (gpointer instance);
GParamSpec* param_spec_gnome_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_gnome_chess (GValue* value, gpointer v_object);
void value_take_gnome_chess (GValue* value, gpointer v_object);
gpointer value_get_gnome_chess (const GValue* value);
GType gnome_chess_get_type (void) G_GNUC_CONST;
enum  {
	GNOME_CHESS_DUMMY_PROPERTY
};
gint gnome_chess_main (gchar** args, int args_length1);
GnomeChess* gnome_chess_new (void);
GnomeChess* gnome_chess_construct (GType object_type);
static void gnome_chess_finalize (GnomeChess* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry APPLICATION_app_entries[4] = {{"preferences", _application_preferences_cb_gsimple_action_activate_callback}, {"help", _application_help_cb_gsimple_action_activate_callback}, {"about", _application_about_cb_gsimple_action_activate_callback}, {"quit", _application_quit_cb_gsimple_action_activate_callback}};
static const gchar* APPLICATION_authors[2] = {"Robert Ancell <robert.ancell@gmail.com>", NULL};
static const gchar* APPLICATION_artists[4] = {"John-Paul Gignac (3D Models)", "Max Froumentin (2D Models)", "Hylke Bons <h.bons@student.rug.nl> (icon)", NULL};
const GOptionEntry GNOME_CHESS_options[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &gnome_chess_show_version, "Show release version", NULL}, {NULL}};

static GType application_sensitivity_index_get_type (void) {
	static volatile gsize application_sensitivity_index_type_id__volatile = 0;
	if (g_once_init_enter (&application_sensitivity_index_type_id__volatile)) {
		static const GEnumValue values[] = {{APPLICATION_SENSITIVITY_INDEX_UNDO, "APPLICATION_SENSITIVITY_INDEX_UNDO", "undo"}, {APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW, "APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW", "claim-draw"}, {APPLICATION_SENSITIVITY_INDEX_RESIGN, "APPLICATION_SENSITIVITY_INDEX_RESIGN", "resign"}, {APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE, "APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE", "first-move"}, {APPLICATION_SENSITIVITY_INDEX_PREV_MOVE, "APPLICATION_SENSITIVITY_INDEX_PREV_MOVE", "prev-move"}, {APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE, "APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE", "next-move"}, {APPLICATION_SENSITIVITY_INDEX_LAST_MOVE, "APPLICATION_SENSITIVITY_INDEX_LAST_MOVE", "last-move"}, {APPLICATION_SENSITIVITY_INDEX_HISTORY, "APPLICATION_SENSITIVITY_INDEX_HISTORY", "history"}, {0, NULL, NULL}};
		GType application_sensitivity_index_type_id;
		application_sensitivity_index_type_id = g_enum_register_static ("ApplicationSensitivityIndex", values);
		g_once_init_leave (&application_sensitivity_index_type_id__volatile, application_sensitivity_index_type_id);
	}
	return application_sensitivity_index_type_id__volatile;
}


static GType application_promotion_type_selected_get_type (void) {
	static volatile gsize application_promotion_type_selected_type_id__volatile = 0;
	if (g_once_init_enter (&application_promotion_type_selected_type_id__volatile)) {
		static const GEnumValue values[] = {{APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN, "APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN", "queen"}, {APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT, "APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT", "knight"}, {APPLICATION_PROMOTION_TYPE_SELECTED_ROOK, "APPLICATION_PROMOTION_TYPE_SELECTED_ROOK", "rook"}, {APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP, "APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP", "bishop"}, {0, NULL, NULL}};
		GType application_promotion_type_selected_type_id;
		application_promotion_type_selected_type_id = g_enum_register_static ("ApplicationPromotionTypeSelected", values);
		g_once_init_leave (&application_promotion_type_selected_type_id__volatile, application_promotion_type_selected_type_id);
	}
	return application_promotion_type_selected_type_id__volatile;
}


static void _ai_profile_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (ai_profile_unref (var), NULL));
}


static void _g_list_free__ai_profile_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _ai_profile_unref0_, NULL);
	g_list_free (self);
}


static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_preferences_cb (self);
}


static void _application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_help_cb (self);
}


static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_about_cb (self);
}


static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_quit_cb (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Application* application_construct (GType object_type, GFile* game_file) {
	Application * self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	self = (Application*) g_object_new (object_type, "application-id", "org.gnome.gnome-chess", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	_tmp0_ = game_file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = _tmp1_;
	return self;
}


Application* application_new (GFile* game_file) {
	return application_construct (TYPE_APPLICATION, game_file);
}


gboolean application_on_window_focus_out (Application* self, GdkEventFocus* focus) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (focus != NULL, FALSE);
	_tmp0_ = self->priv->pause_button;
	_tmp1_ = gtk_tool_button_get_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "gtk-media-pause") == 0) {
		ChessGame* _tmp3_ = NULL;
		_tmp3_ = self->priv->game;
		chess_game_pause (_tmp3_);
	}
	result = FALSE;
	return result;
}


gboolean application_on_window_focus_in (Application* self, GdkEventFocus* focus) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (focus != NULL, FALSE);
	_tmp0_ = self->priv->pause_button;
	_tmp1_ = gtk_tool_button_get_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "gtk-media-pause") == 0) {
		ChessGame* _tmp3_ = NULL;
		_tmp3_ = self->priv->game;
		chess_game_unpause (_tmp3_);
	}
	result = FALSE;
	return result;
}


static gboolean _application_on_window_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = application_on_window_focus_out (self, event);
	return result;
}


static gboolean _application_on_window_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = application_on_window_focus_in (self, event);
	return result;
}


static gboolean __lambda2_ (Application* self, ChessPlayer* p) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = p;
	_tmp1_ = self->priv->human_player;
	result = _tmp0_ == _tmp1_;
	return result;
}


static gboolean ___lambda2__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self) {
	gboolean result;
	result = __lambda2_ (self, player);
	return result;
}


static void _application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
	application_scene_changed_cb (self, _sender);
}


static PieceType _application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self) {
	PieceType result;
	result = application_show_promotion_type_selector (self);
	return result;
}


static void _application_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	application_settings_changed_cb (self, _sender, key);
}


static gpointer _ai_profile_ref0 (gpointer self) {
	return self ? ai_profile_ref (self) : NULL;
}


static void application_real_startup (GApplication* base) {
	Application * self;
	GSettings* _tmp0_ = NULL;
	GFile* data_dir = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GMenuModel* menu = NULL;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GMenuModel* _tmp15_ = NULL;
	GtkBuilder* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GtkWindow* _tmp23_ = NULL;
	GtkBuilder* _tmp24_ = NULL;
	GObject* _tmp25_ = NULL;
	GtkWidget* _tmp26_ = NULL;
	GtkBuilder* _tmp27_ = NULL;
	GObject* _tmp28_ = NULL;
	GtkWidget* _tmp29_ = NULL;
	GtkBuilder* _tmp30_ = NULL;
	GObject* _tmp31_ = NULL;
	GtkWidget* _tmp32_ = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	GtkWidget* _tmp35_ = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkWidget* _tmp38_ = NULL;
	GtkBuilder* _tmp39_ = NULL;
	GObject* _tmp40_ = NULL;
	GtkWidget* _tmp41_ = NULL;
	GtkBuilder* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GtkWidget* _tmp44_ = NULL;
	GtkBuilder* _tmp45_ = NULL;
	GObject* _tmp46_ = NULL;
	GtkWidget* _tmp47_ = NULL;
	GtkBuilder* _tmp48_ = NULL;
	GObject* _tmp49_ = NULL;
	GtkWidget* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GObject* _tmp52_ = NULL;
	GtkWidget* _tmp53_ = NULL;
	GtkBuilder* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkComboBox* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	GObject* _tmp58_ = NULL;
	GtkWidget* _tmp59_ = NULL;
	GtkBuilder* _tmp60_ = NULL;
	GObject* _tmp61_ = NULL;
	GtkWidget* _tmp62_ = NULL;
	GtkVBox* view_box = NULL;
	GtkBuilder* _tmp63_ = NULL;
	GObject* _tmp64_ = NULL;
	GtkVBox* _tmp65_ = NULL;
	GtkBuilder* _tmp66_ = NULL;
	GObject* _tmp67_ = NULL;
	GtkContainer* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	GtkWindow* _tmp70_ = NULL;
	GtkWindow* _tmp71_ = NULL;
	GtkWindow* _tmp72_ = NULL;
	GtkInfoBar* _tmp73_ = NULL;
	GtkContainer* content_area = NULL;
	GtkInfoBar* _tmp74_ = NULL;
	GtkContainer* _tmp75_ = NULL;
	GtkContainer* _tmp76_ = NULL;
	GtkVBox* _tmp77_ = NULL;
	GtkInfoBar* _tmp78_ = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp79_ = NULL;
	GtkBox* _tmp80_ = NULL;
	GtkContainer* _tmp81_ = NULL;
	GtkBox* _tmp82_ = NULL;
	GtkLabel* _tmp83_ = NULL;
	GtkLabel* _tmp84_ = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkLabel* _tmp86_ = NULL;
	GtkBox* _tmp87_ = NULL;
	GtkBox* _tmp88_ = NULL;
	GtkLabel* _tmp89_ = NULL;
	GtkLabel* _tmp90_ = NULL;
	GtkBox* _tmp91_ = NULL;
	GtkLabel* _tmp92_ = NULL;
	ChessScene* _tmp93_ = NULL;
	ChessScene* _tmp94_ = NULL;
	ChessScene* _tmp95_ = NULL;
	ChessScene* _tmp96_ = NULL;
	GSettings* _tmp97_ = NULL;
	ChessScene* _tmp98_ = NULL;
	GSettings* _tmp99_ = NULL;
	ChessScene* _tmp100_ = NULL;
	GSettings* _tmp101_ = NULL;
	ChessScene* _tmp102_ = NULL;
	GSettings* _tmp103_ = NULL;
	ChessScene* _tmp104_ = NULL;
	GSettings* _tmp105_ = NULL;
	ChessScene* _tmp106_ = NULL;
	GSettings* _tmp107_ = NULL;
	ChessScene* _tmp108_ = NULL;
	GSettings* _tmp109_ = NULL;
	GSettings* _tmp110_ = NULL;
	gchar* _tmp111_ = NULL;
	gchar* _tmp112_ = NULL;
	GList* _tmp113_ = NULL;
	GList* _tmp114_ = NULL;
	gchar* _tmp122_ = NULL;
	gchar* _tmp123_ = NULL;
	gchar* _tmp124_ = NULL;
	GFile* _tmp125_ = NULL;
	GFile* _tmp131_ = NULL;
	GtkWindow* _tmp139_ = NULL;
	GSettings* _tmp140_ = NULL;
	gint _tmp141_ = 0;
	GSettings* _tmp142_ = NULL;
	gint _tmp143_ = 0;
	GSettings* _tmp144_ = NULL;
	gboolean _tmp145_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (Application*) base;
	G_APPLICATION_CLASS (application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.gnome-chess");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "gnome-chess", NULL, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	data_dir = _tmp5_;
	_tmp6_ = g_file_get_path (data_dir);
	_tmp7_ = _tmp6_;
	g_mkdir_with_parents (_tmp7_, 0755);
	_g_free0 (_tmp7_);
	g_action_map_add_action_entries ((GActionMap*) self, APPLICATION_app_entries, G_N_ELEMENTS (APPLICATION_app_entries), self);
	_tmp8_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp8_;
	{
		GtkBuilder* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp9_ = self->priv->builder;
		_tmp10_ = g_build_filename (PKGDATADIR, "menu.ui", NULL, NULL);
		_tmp11_ = _tmp10_;
		gtk_builder_add_from_file (_tmp9_, _tmp11_, &_inner_error_);
		_g_free0 (_tmp11_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e->message;
		g_error ("gnome-chess.vala:131: Error loading menu UI: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (data_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = self->priv->builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "appmenu");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp14_) : NULL);
	menu = _tmp15_;
	gtk_application_set_app_menu ((GtkApplication*) self, menu);
	{
		GtkBuilder* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp16_ = self->priv->builder;
		_tmp17_ = g_build_filename (PKGDATADIR, "gnome-chess.ui", NULL, NULL);
		_tmp18_ = _tmp17_;
		gtk_builder_add_from_file (_tmp16_, _tmp18_, &_inner_error_);
		_g_free0 (_tmp18_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("gnome-chess.vala:143: Could not load UI: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (menu);
		_g_object_unref0 (data_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp21_ = self->priv->builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "gnome_chess_app");
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_WINDOW, GtkWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp23_;
	_tmp24_ = self->priv->builder;
	_tmp25_ = gtk_builder_get_object (_tmp24_, "save_game_button");
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->save_button);
	self->priv->save_button = _tmp26_;
	_tmp27_ = self->priv->builder;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "undo_move_button");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->undo_button);
	self->priv->undo_button = _tmp29_;
	_tmp30_ = self->priv->builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "pause_game_button");
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->pause_button);
	self->priv->pause_button = _tmp32_;
	_tmp33_ = self->priv->builder;
	_tmp34_ = gtk_builder_get_object (_tmp33_, "claim_draw_button");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->claim_draw_button);
	self->priv->claim_draw_button = _tmp35_;
	_tmp36_ = self->priv->builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "resign_button");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->resign_button);
	self->priv->resign_button = _tmp38_;
	_tmp39_ = self->priv->builder;
	_tmp40_ = gtk_builder_get_object (_tmp39_, "fullscreen_button");
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->fullscreen_button);
	self->priv->fullscreen_button = _tmp41_;
	_tmp42_ = self->priv->builder;
	_tmp43_ = gtk_builder_get_object (_tmp42_, "first_move_button");
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->first_move_button);
	self->priv->first_move_button = _tmp44_;
	_tmp45_ = self->priv->builder;
	_tmp46_ = gtk_builder_get_object (_tmp45_, "prev_move_button");
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->prev_move_button);
	self->priv->prev_move_button = _tmp47_;
	_tmp48_ = self->priv->builder;
	_tmp49_ = gtk_builder_get_object (_tmp48_, "next_move_button");
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->next_move_button);
	self->priv->next_move_button = _tmp50_;
	_tmp51_ = self->priv->builder;
	_tmp52_ = gtk_builder_get_object (_tmp51_, "last_move_button");
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->last_move_button);
	self->priv->last_move_button = _tmp53_;
	_tmp54_ = self->priv->builder;
	_tmp55_ = gtk_builder_get_object (_tmp54_, "history_combo");
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	_g_object_unref0 (self->priv->history_combo);
	self->priv->history_combo = _tmp56_;
	_tmp57_ = self->priv->builder;
	_tmp58_ = gtk_builder_get_object (_tmp57_, "white_time_label");
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->white_time_label);
	self->priv->white_time_label = _tmp59_;
	_tmp60_ = self->priv->builder;
	_tmp61_ = gtk_builder_get_object (_tmp60_, "black_time_label");
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (self->priv->black_time_label);
	self->priv->black_time_label = _tmp62_;
	_tmp63_ = self->priv->builder;
	_tmp64_ = gtk_builder_get_object (_tmp63_, "view_box");
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GTK_TYPE_VBOX, GtkVBox));
	view_box = _tmp65_;
	_tmp66_ = self->priv->builder;
	_tmp67_ = gtk_builder_get_object (_tmp66_, "view_container");
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GTK_TYPE_CONTAINER, GtkContainer));
	_g_object_unref0 (self->priv->view_container);
	self->priv->view_container = _tmp68_;
	_tmp69_ = self->priv->builder;
	gtk_builder_connect_signals (_tmp69_, self);
	_tmp70_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp70_);
	_tmp71_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp71_, "focus-out-event", (GCallback) _application_on_window_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp72_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp72_, "focus-in-event", (GCallback) _application_on_window_focus_in_gtk_widget_focus_in_event, self, 0);
	_tmp73_ = (GtkInfoBar*) gtk_info_bar_new ();
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->info_bar);
	self->priv->info_bar = _tmp73_;
	_tmp74_ = self->priv->info_bar;
	_tmp75_ = gtk_info_bar_get_content_area (_tmp74_);
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, GTK_TYPE_CONTAINER, GtkContainer));
	content_area = _tmp76_;
	_tmp77_ = view_box;
	_tmp78_ = self->priv->info_bar;
	gtk_box_pack_start ((GtkBox*) _tmp77_, (GtkWidget*) _tmp78_, FALSE, TRUE, (guint) 0);
	_tmp79_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp79_);
	vbox = _tmp79_;
	_tmp80_ = vbox;
	gtk_widget_show ((GtkWidget*) _tmp80_);
	_tmp81_ = content_area;
	_tmp82_ = vbox;
	gtk_container_add (_tmp81_, (GtkWidget*) _tmp82_);
	_tmp83_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp83_);
	_g_object_unref0 (self->priv->info_title_label);
	self->priv->info_title_label = _tmp83_;
	_tmp84_ = self->priv->info_title_label;
	gtk_widget_show ((GtkWidget*) _tmp84_);
	_tmp85_ = vbox;
	_tmp86_ = self->priv->info_title_label;
	gtk_box_pack_start (_tmp85_, (GtkWidget*) _tmp86_, FALSE, TRUE, (guint) 0);
	_tmp87_ = vbox;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp87_, TRUE);
	_tmp88_ = vbox;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp88_, FALSE);
	_tmp89_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp89_);
	_g_object_unref0 (self->priv->info_label);
	self->priv->info_label = _tmp89_;
	_tmp90_ = self->priv->info_label;
	gtk_widget_show ((GtkWidget*) _tmp90_);
	_tmp91_ = vbox;
	_tmp92_ = self->priv->info_label;
	gtk_box_pack_start (_tmp91_, (GtkWidget*) _tmp92_, TRUE, TRUE, (guint) 0);
	_tmp93_ = chess_scene_new ();
	_g_object_unref0 (self->priv->scene);
	self->priv->scene = _tmp93_;
	_tmp94_ = self->priv->scene;
	g_signal_connect_object (_tmp94_, "is-human", (GCallback) ___lambda2__chess_scene_is_human, self, 0);
	_tmp95_ = self->priv->scene;
	g_signal_connect_object (_tmp95_, "changed", (GCallback) _application_scene_changed_cb_chess_scene_changed, self, 0);
	_tmp96_ = self->priv->scene;
	g_signal_connect_object (_tmp96_, "choose-promotion-type", (GCallback) _application_show_promotion_type_selector_chess_scene_choose_promotion_type, self, 0);
	_tmp97_ = self->priv->settings;
	_tmp98_ = self->priv->scene;
	g_settings_bind (_tmp97_, "show-move-hints", (GObject*) _tmp98_, "show-move-hints", G_SETTINGS_BIND_GET);
	_tmp99_ = self->priv->settings;
	_tmp100_ = self->priv->scene;
	g_settings_bind (_tmp99_, "show-numbering", (GObject*) _tmp100_, "show-numbering", G_SETTINGS_BIND_GET);
	_tmp101_ = self->priv->settings;
	_tmp102_ = self->priv->scene;
	g_settings_bind (_tmp101_, "piece-theme", (GObject*) _tmp102_, "theme-name", G_SETTINGS_BIND_GET);
	_tmp103_ = self->priv->settings;
	_tmp104_ = self->priv->scene;
	g_settings_bind (_tmp103_, "show-3d-smooth", (GObject*) _tmp104_, "show-3d-smooth", G_SETTINGS_BIND_GET);
	_tmp105_ = self->priv->settings;
	_tmp106_ = self->priv->scene;
	g_settings_bind (_tmp105_, "move-format", (GObject*) _tmp106_, "move-format", G_SETTINGS_BIND_GET);
	_tmp107_ = self->priv->settings;
	_tmp108_ = self->priv->scene;
	g_settings_bind (_tmp107_, "board-side", (GObject*) _tmp108_, "board-side", G_SETTINGS_BIND_GET);
	_tmp109_ = self->priv->settings;
	g_signal_connect_object (_tmp109_, "changed", (GCallback) _application_settings_changed_cb_g_settings_changed, self, 0);
	_tmp110_ = self->priv->settings;
	application_settings_changed_cb (self, _tmp110_, "show-3d");
	_tmp111_ = g_build_filename (SYSCONFDIR, "chess-engines.conf", NULL, NULL);
	_tmp112_ = _tmp111_;
	_tmp113_ = ai_profile_load_ai_profiles (_tmp112_);
	__g_list_free__ai_profile_unref0_0 (self->priv->ai_profiles);
	self->priv->ai_profiles = _tmp113_;
	_g_free0 (_tmp112_);
	_tmp114_ = self->priv->ai_profiles;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp114_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			AIProfile* _tmp115_ = NULL;
			AIProfile* profile = NULL;
			_tmp115_ = _ai_profile_ref0 ((AIProfile*) profile_it->data);
			profile = _tmp115_;
			{
				AIProfile* _tmp116_ = NULL;
				const gchar* _tmp117_ = NULL;
				const gchar* _tmp118_ = NULL;
				AIProfile* _tmp119_ = NULL;
				const gchar* _tmp120_ = NULL;
				const gchar* _tmp121_ = NULL;
				_tmp116_ = profile;
				_tmp117_ = ai_profile_get_name (_tmp116_);
				_tmp118_ = _tmp117_;
				_tmp119_ = profile;
				_tmp120_ = ai_profile_get_path (_tmp119_);
				_tmp121_ = _tmp120_;
				g_message ("gnome-chess.vala:198: Detected AI profile %s in %s", _tmp118_, _tmp121_);
				_ai_profile_unref0 (profile);
			}
		}
	}
	_tmp122_ = g_file_get_path (data_dir);
	_tmp123_ = _tmp122_;
	_tmp124_ = g_strconcat (_tmp123_, "/autosave.pgn", NULL);
	_g_free0 (self->priv->autosave_filename);
	self->priv->autosave_filename = _tmp124_;
	_g_free0 (_tmp123_);
	_tmp125_ = self->priv->game_file;
	if (_tmp125_ == NULL) {
		const gchar* _tmp126_ = NULL;
		gboolean _tmp127_ = FALSE;
		GFile* _tmp130_ = NULL;
		_tmp126_ = self->priv->autosave_filename;
		_tmp127_ = g_file_test (_tmp126_, G_FILE_TEST_EXISTS);
		if (_tmp127_) {
			const gchar* _tmp128_ = NULL;
			GFile* _tmp129_ = NULL;
			_tmp128_ = self->priv->autosave_filename;
			_tmp129_ = g_file_new_for_path (_tmp128_);
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp129_;
		}
		_tmp130_ = self->priv->game_file;
		if (_tmp130_ != NULL) {
			self->priv->in_history = TRUE;
		} else {
			application_start_new_game (self);
		}
	} else {
		self->priv->in_history = FALSE;
	}
	_tmp131_ = self->priv->game_file;
	if (_tmp131_ != NULL) {
		{
			GFile* _tmp132_ = NULL;
			_tmp132_ = self->priv->game_file;
			application_load_game (self, _tmp132_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp133_ = NULL;
			GFile* _tmp134_ = NULL;
			gchar* _tmp135_ = NULL;
			gchar* _tmp136_ = NULL;
			GError* _tmp137_ = NULL;
			const gchar* _tmp138_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp133_ = stderr;
			_tmp134_ = self->priv->game_file;
			_tmp135_ = g_file_get_path (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = e;
			_tmp138_ = _tmp137_->message;
			fprintf (_tmp133_, "Failed to load %s: %s\n", _tmp136_, _tmp138_);
			_g_free0 (_tmp136_);
			g_application_quit ((GApplication*) self);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (vbox);
			_g_object_unref0 (content_area);
			_g_object_unref0 (view_box);
			_g_object_unref0 (menu);
			_g_object_unref0 (data_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp139_ = self->priv->window;
	_tmp140_ = self->priv->settings;
	_tmp141_ = g_settings_get_int (_tmp140_, "width");
	_tmp142_ = self->priv->settings;
	_tmp143_ = g_settings_get_int (_tmp142_, "height");
	gtk_window_set_default_size (_tmp139_, _tmp141_, _tmp143_);
	_tmp144_ = self->priv->settings;
	_tmp145_ = g_settings_get_boolean (_tmp144_, "fullscreen");
	if (_tmp145_) {
		GtkWindow* _tmp146_ = NULL;
		_tmp146_ = self->priv->window;
		gtk_window_fullscreen (_tmp146_);
		self->priv->is_fullscreen = TRUE;
	} else {
		GSettings* _tmp147_ = NULL;
		gboolean _tmp148_ = FALSE;
		_tmp147_ = self->priv->settings;
		_tmp148_ = g_settings_get_boolean (_tmp147_, "maximized");
		if (_tmp148_) {
			GtkWindow* _tmp149_ = NULL;
			_tmp149_ = self->priv->window;
			gtk_window_maximize (_tmp149_);
		}
	}
	application_show (self);
	_g_object_unref0 (vbox);
	_g_object_unref0 (content_area);
	_g_object_unref0 (view_box);
	_g_object_unref0 (menu);
	_g_object_unref0 (data_dir);
}


static void application_real_shutdown (GApplication* base) {
	Application * self;
	ChessEngine* _tmp0_ = NULL;
	self = (Application*) base;
	G_APPLICATION_CLASS (application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_ = NULL;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp1_);
	}
}


PieceType application_show_promotion_type_selector (Application* self) {
	PieceType result = 0;
	GtkBuilder* promotion_type_selector_builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkDialog* promotion_type_selector_dialog = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	gchar* color = NULL;
	ChessGame* _tmp9_ = NULL;
	ChessPlayer* _tmp10_ = NULL;
	ChessPlayer* _tmp11_ = NULL;
	Color _tmp12_ = 0;
	gchar* filename = NULL;
	ChessScene* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	ChessScene* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	ChessScene* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	GtkBuilder* _tmp43_ = NULL;
	GObject* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	ChessScene* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	GtkBuilder* _tmp53_ = NULL;
	GObject* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	GtkBuilder* _tmp56_ = NULL;
	PieceType selection = 0;
	gint choice = 0;
	GtkDialog* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	GtkDialog* _tmp60_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (promotion_type_selector_builder);
	promotion_type_selector_builder = _tmp0_;
	{
		GtkBuilder* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = promotion_type_selector_builder;
		_tmp2_ = g_build_filename (PKGDATADIR, "promotion-type-selector.ui", NULL, NULL);
		_tmp3_ = _tmp2_;
		gtk_builder_add_from_file (_tmp1_, _tmp3_, &_inner_error_);
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("gnome-chess.vala:262: Could not load promotion type selector UI: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (promotion_type_selector_builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = promotion_type_selector_builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "dialog_promotion_type_selector");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp7_) : NULL);
	promotion_type_selector_dialog = _tmp8_;
	_tmp9_ = self->priv->game;
	_tmp10_ = chess_game_get_current_player (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->color;
	if (_tmp12_ == COLOR_WHITE) {
		gchar* _tmp13_ = NULL;
		_tmp13_ = g_strdup ("white");
		_g_free0 (color);
		color = _tmp13_;
	} else {
		gchar* _tmp14_ = NULL;
		_tmp14_ = g_strdup ("black");
		_g_free0 (color);
		color = _tmp14_;
	}
	_tmp15_ = self->priv->scene;
	_tmp16_ = chess_scene_get_theme_name (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = color;
	_tmp19_ = g_strdup_printf ("%sQueen.svg", _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_build_filename (PKGDATADIR, "pieces", _tmp17_, _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	filename = _tmp22_;
	_tmp23_ = promotion_type_selector_builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "image_queen");
	_tmp25_ = filename;
	application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp24_) : NULL, _tmp25_);
	_tmp26_ = self->priv->scene;
	_tmp27_ = chess_scene_get_theme_name (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = color;
	_tmp30_ = g_strdup_printf ("%sKnight.svg", _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_build_filename (PKGDATADIR, "pieces", _tmp28_, _tmp31_, NULL);
	_g_free0 (filename);
	filename = _tmp32_;
	_g_free0 (_tmp31_);
	_tmp33_ = promotion_type_selector_builder;
	_tmp34_ = gtk_builder_get_object (_tmp33_, "image_knight");
	_tmp35_ = filename;
	application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp34_) : NULL, _tmp35_);
	_tmp36_ = self->priv->scene;
	_tmp37_ = chess_scene_get_theme_name (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = color;
	_tmp40_ = g_strdup_printf ("%sRook.svg", _tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_build_filename (PKGDATADIR, "pieces", _tmp38_, _tmp41_, NULL);
	_g_free0 (filename);
	filename = _tmp42_;
	_g_free0 (_tmp41_);
	_tmp43_ = promotion_type_selector_builder;
	_tmp44_ = gtk_builder_get_object (_tmp43_, "image_rook");
	_tmp45_ = filename;
	application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp44_) : NULL, _tmp45_);
	_tmp46_ = self->priv->scene;
	_tmp47_ = chess_scene_get_theme_name (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = color;
	_tmp50_ = g_strdup_printf ("%sBishop.svg", _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_build_filename (PKGDATADIR, "pieces", _tmp48_, _tmp51_, NULL);
	_g_free0 (filename);
	filename = _tmp52_;
	_g_free0 (_tmp51_);
	_tmp53_ = promotion_type_selector_builder;
	_tmp54_ = gtk_builder_get_object (_tmp53_, "image_bishop");
	_tmp55_ = filename;
	application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp54_) : NULL, _tmp55_);
	_tmp56_ = promotion_type_selector_builder;
	gtk_builder_connect_signals (_tmp56_, self);
	_tmp57_ = promotion_type_selector_dialog;
	_tmp58_ = gtk_dialog_run (_tmp57_);
	choice = _tmp58_;
	_tmp59_ = choice;
	switch (_tmp59_) {
		case APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN:
		{
			selection = PIECE_TYPE_QUEEN;
			break;
		}
		case APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT:
		{
			selection = PIECE_TYPE_KNIGHT;
			break;
		}
		case APPLICATION_PROMOTION_TYPE_SELECTED_ROOK:
		{
			selection = PIECE_TYPE_ROOK;
			break;
		}
		case APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP:
		{
			selection = PIECE_TYPE_BISHOP;
			break;
		}
		default:
		{
			selection = PIECE_TYPE_QUEEN;
			break;
		}
	}
	_tmp60_ = promotion_type_selector_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp60_);
	result = selection;
	_g_free0 (filename);
	_g_free0 (color);
	_g_object_unref0 (promotion_type_selector_dialog);
	_g_object_unref0 (promotion_type_selector_builder);
	return result;
}


static void application_set_piece_image (Application* self, GtkImage* image, const gchar* filename) {
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GdkPixbuf* pixbuf = NULL;
	GtkImage* _tmp11_ = NULL;
	GdkPixbuf* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (filename != NULL);
	_tmp2_ = gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	{
		GdkPixbuf* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GdkPixbuf* _tmp7_ = NULL;
		_tmp4_ = filename;
		_tmp5_ = width;
		_tmp6_ = height;
		_tmp7_ = rsvg_pixbuf_from_file_at_size (_tmp4_, _tmp5_, _tmp6_, &_inner_error_);
		_tmp3_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp3_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = filename;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("gnome-chess.vala:325: Failed to load image %s: %s", _tmp8_, _tmp10_);
		_g_error_free0 (e);
		_g_object_unref0 (pixbuf);
		return;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = image;
	_tmp12_ = pixbuf;
	gtk_image_set_from_pixbuf (_tmp11_, _tmp12_);
	_g_object_unref0 (pixbuf);
}


void application_quit_game (Application* self) {
	guint _tmp0_ = 0U;
	GtkWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->save_duration_timeout;
	if (_tmp0_ != ((guint) 0)) {
		application_save_duration_cb (self);
	}
	application_autosave (self);
	_tmp1_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
}


static void application_autosave (Application* self) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_needs_saving;
	if (!_tmp0_) {
		GFile* _tmp1_ = NULL;
		_tmp1_ = self->priv->game_file;
		if (_tmp1_ != NULL) {
			GFile* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			_tmp2_ = self->priv->game_file;
			_tmp3_ = g_file_get_path (_tmp2_);
			_tmp4_ = _tmp3_;
			g_remove (_tmp4_);
			_g_free0 (_tmp4_);
		}
		return;
	}
	{
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp8_ = FALSE;
		GFile* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		PGNGame* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		_tmp6_ = self->priv->in_history;
		if (!_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			GFile* _tmp7_ = NULL;
			_tmp7_ = self->priv->game_file;
			_tmp5_ = _tmp7_ == NULL;
		}
		_tmp8_ = _tmp5_;
		if (_tmp8_) {
			const gchar* _tmp9_ = NULL;
			GFile* _tmp10_ = NULL;
			_tmp9_ = self->priv->autosave_filename;
			_tmp10_ = g_file_new_for_path (_tmp9_);
			_g_object_unref0 (self->priv->game_file);
			self->priv->game_file = _tmp10_;
		}
		_tmp11_ = self->priv->game_file;
		_tmp12_ = g_file_get_path (_tmp11_);
		_tmp13_ = _tmp12_;
		g_debug ("gnome-chess.vala:363: Writing current game to %s", _tmp13_);
		_g_free0 (_tmp13_);
		application_update_pgn_time_remaining (self);
		_tmp14_ = self->priv->pgn_game;
		_tmp15_ = self->priv->game_file;
		pgn_game_write (_tmp14_, _tmp15_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("gnome-chess.vala:369: Failed to autosave: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void application_settings_changed_cb (Application* self, GSettings* settings, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	if (g_strcmp0 (_tmp0_, "show-3d") == 0) {
		ChessView* _tmp1_ = NULL;
		GSettings* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		ChessView* _tmp9_ = NULL;
		ChessView* _tmp10_ = NULL;
		ChessScene* _tmp11_ = NULL;
		GtkContainer* _tmp12_ = NULL;
		ChessView* _tmp13_ = NULL;
		ChessView* _tmp14_ = NULL;
		_tmp1_ = self->priv->view;
		if (_tmp1_ != NULL) {
			GtkContainer* _tmp2_ = NULL;
			ChessView* _tmp3_ = NULL;
			ChessView* _tmp4_ = NULL;
			_tmp2_ = self->priv->view_container;
			_tmp3_ = self->priv->view;
			gtk_container_remove (_tmp2_, (GtkWidget*) _tmp3_);
			_tmp4_ = self->priv->view;
			gtk_widget_destroy ((GtkWidget*) _tmp4_);
		}
		_tmp5_ = settings;
		_tmp6_ = g_settings_get_boolean (_tmp5_, "show-3d");
		if (_tmp6_) {
			ChessView3D* _tmp7_ = NULL;
			_tmp7_ = chess_view3_d_new ();
			g_object_ref_sink (_tmp7_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = (ChessView*) _tmp7_;
		} else {
			ChessView2D* _tmp8_ = NULL;
			_tmp8_ = chess_view2_d_new ();
			g_object_ref_sink (_tmp8_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = (ChessView*) _tmp8_;
		}
		_tmp9_ = self->priv->view;
		gtk_widget_set_size_request ((GtkWidget*) _tmp9_, 300, 300);
		_tmp10_ = self->priv->view;
		_tmp11_ = self->priv->scene;
		chess_view_set_scene (_tmp10_, _tmp11_);
		_tmp12_ = self->priv->view_container;
		_tmp13_ = self->priv->view;
		gtk_container_add (_tmp12_, (GtkWidget*) _tmp13_);
		_tmp14_ = self->priv->view;
		gtk_widget_show ((GtkWidget*) _tmp14_);
	}
}


static gpointer _chess_state_ref0 (gpointer self) {
	return self ? chess_state_ref (self) : NULL;
}


static void application_update_history_panel (Application* self) {
	ChessGame* _tmp0_ = NULL;
	gint move_number = 0;
	ChessScene* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint n_moves = 0;
	ChessGame* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	gint _tmp7_ = 0;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
	GtkWidget* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GtkWidget* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GtkWidget* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_ = 0;
	GtkWidget* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gint i = 0;
	gint _tmp26_ = 0;
	ChessGame* _tmp27_ = NULL;
	GList* _tmp28_ = NULL;
	GtkComboBox* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->scene;
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
	_tmp3_ = _tmp2_;
	move_number = _tmp3_;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_n_moves (_tmp4_);
	_tmp6_ = _tmp5_;
	n_moves = (gint) _tmp6_;
	_tmp7_ = move_number;
	if (_tmp7_ < 0) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp8_ = move_number;
		_tmp9_ = n_moves;
		move_number = _tmp8_ + (1 + _tmp9_);
	}
	_tmp11_ = n_moves;
	if (_tmp11_ > 0) {
		gint _tmp12_ = 0;
		_tmp12_ = move_number;
		_tmp10_ = _tmp12_ != 0;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp13_ = self->priv->first_move_button;
	_tmp14_ = _tmp10_;
	gtk_widget_set_sensitive (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->prev_move_button;
	_tmp16_ = move_number;
	gtk_widget_set_sensitive (_tmp15_, _tmp16_ > 0);
	_tmp17_ = self->priv->next_move_button;
	_tmp18_ = move_number;
	_tmp19_ = n_moves;
	gtk_widget_set_sensitive (_tmp17_, _tmp18_ < _tmp19_);
	_tmp21_ = n_moves;
	if (_tmp21_ > 0) {
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp22_ = move_number;
		_tmp23_ = n_moves;
		_tmp20_ = _tmp22_ != _tmp23_;
	} else {
		_tmp20_ = FALSE;
	}
	_tmp24_ = self->priv->last_move_button;
	_tmp25_ = _tmp20_;
	gtk_widget_set_sensitive (_tmp24_, _tmp25_);
	_tmp26_ = n_moves;
	i = _tmp26_;
	_tmp27_ = self->priv->game;
	_tmp28_ = _tmp27_->move_stack;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = _tmp28_;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp29_ = NULL;
			ChessState* state = NULL;
			_tmp29_ = _chess_state_ref0 ((ChessState*) state_it->data);
			state = _tmp29_;
			{
				ChessState* _tmp30_ = NULL;
				ChessMove* _tmp31_ = NULL;
				gint _tmp41_ = 0;
				_tmp30_ = state;
				_tmp31_ = _tmp30_->last_move;
				if (_tmp31_ != NULL) {
					GtkTreeIter iter = {0};
					GtkComboBox* _tmp32_ = NULL;
					GtkTreeModel* _tmp33_ = NULL;
					GtkTreeModel* _tmp34_ = NULL;
					gint _tmp35_ = 0;
					GtkTreeIter _tmp36_ = {0};
					gboolean _tmp37_ = FALSE;
					_tmp32_ = self->priv->history_combo;
					_tmp33_ = gtk_combo_box_get_model (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = i;
					_tmp37_ = gtk_tree_model_iter_nth_child (_tmp34_, &_tmp36_, NULL, _tmp35_);
					iter = _tmp36_;
					if (_tmp37_) {
						GtkTreeIter _tmp38_ = {0};
						ChessState* _tmp39_ = NULL;
						ChessMove* _tmp40_ = NULL;
						_tmp38_ = iter;
						_tmp39_ = state;
						_tmp40_ = _tmp39_->last_move;
						application_set_move_text (self, &_tmp38_, _tmp40_);
					}
				}
				_tmp41_ = i;
				i = _tmp41_ - 1;
				_chess_state_unref0 (state);
			}
		}
	}
	_tmp42_ = self->priv->history_combo;
	_tmp43_ = move_number;
	gtk_combo_box_set_active (_tmp42_, _tmp43_);
}


static void application_scene_changed_cb (Application* self, ChessScene* scene) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scene != NULL);
	application_update_history_panel (self);
}


static void _application_game_start_cb_chess_game_started (ChessGame* _sender, gpointer self) {
	application_game_start_cb (self, _sender);
}


static void _application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self) {
	application_game_turn_cb (self, _sender, player);
}


static void _application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
	application_game_move_cb (self, _sender, move);
}


static void _application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
	application_game_undo_cb (self, _sender);
}


static void _application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self) {
	application_game_end_cb (self, _sender);
}


static void _application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self) {
	application_game_clock_tick_cb (self, _sender);
}


static void _application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self) {
	application_engine_ready_cb (self, _sender);
}


static void _application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self) {
	application_engine_move_cb (self, _sender, move);
}


static void _application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self) {
	application_engine_resigned_cb (self, _sender);
}


static void _application_engine_stopped_cb_chess_engine_stopped (ChessEngine* _sender, gpointer self) {
	application_engine_stopped_cb (self, _sender);
}


static void _application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self) {
	application_engine_error_cb (self, _sender);
}


static void _application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self) {
	application_engine_claim_draw_cb (self, _sender);
}


static void _application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self) {
	application_engine_offer_draw_cb (self, _sender);
}


static void application_start_game (Application* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp15_ = NULL;
	GtkTreeModel* _tmp16_ = NULL;
	GtkTreeModel* _tmp17_ = NULL;
	GtkListStore* _tmp18_ = NULL;
	GtkListStore* _tmp19_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp20_ = NULL;
	GtkTreeIter _tmp21_ = {0};
	GtkListStore* _tmp22_ = NULL;
	GtkTreeIter _tmp23_ = {0};
	const gchar* _tmp24_ = NULL;
	GtkComboBox* _tmp25_ = NULL;
	GtkTreeIter _tmp26_ = {0};
	gchar* fen = NULL;
	gchar* _tmp27_ = NULL;
	gchar** moves = NULL;
	PGNGame* _tmp28_ = NULL;
	GList* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	gchar** _tmp31_ = NULL;
	gint moves_length1 = 0;
	gint _moves_size_ = 0;
	gint i = 0;
	PGNGame* _tmp32_ = NULL;
	GList* _tmp33_ = NULL;
	PGNGame* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	const gchar* _tmp50_ = NULL;
	gchar** _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	ChessGame* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	PGNGame* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	gboolean _tmp61_ = FALSE;
	ChessGame* _tmp87_ = NULL;
	ChessGame* _tmp88_ = NULL;
	ChessGame* _tmp89_ = NULL;
	ChessGame* _tmp90_ = NULL;
	ChessGame* _tmp91_ = NULL;
	ChessGame* _tmp92_ = NULL;
	ChessClock* _tmp93_ = NULL;
	ChessClock* _tmp94_ = NULL;
	ChessScene* _tmp98_ = NULL;
	ChessGame* _tmp99_ = NULL;
	GtkInfoBar* _tmp100_ = NULL;
	GtkWidget* _tmp101_ = NULL;
	gchar* white_engine = NULL;
	PGNGame* _tmp102_ = NULL;
	const gchar* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	gchar* _tmp105_ = NULL;
	gchar* white_level = NULL;
	PGNGame* _tmp106_ = NULL;
	const gchar* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	gchar* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	gchar* black_engine = NULL;
	PGNGame* _tmp112_ = NULL;
	const gchar* _tmp113_ = NULL;
	const gchar* _tmp114_ = NULL;
	gchar* _tmp115_ = NULL;
	gchar* black_level = NULL;
	PGNGame* _tmp116_ = NULL;
	const gchar* _tmp117_ = NULL;
	const gchar* _tmp118_ = NULL;
	gchar* _tmp119_ = NULL;
	const gchar* _tmp120_ = NULL;
	ChessEngine* _tmp122_ = NULL;
	const gchar* _tmp138_ = NULL;
	ChessEngine* _tmp166_ = NULL;
	gboolean _tmp196_ = FALSE;
	GtkWidget* _tmp197_ = NULL;
	gboolean _tmp198_ = FALSE;
	ChessGame* _tmp199_ = NULL;
	gboolean _tmp200_ = FALSE;
	gchar** _tmp201_ = NULL;
	gint _tmp201__length1 = 0;
	gboolean _tmp205_ = FALSE;
	ChessGame* _tmp211_ = NULL;
	ChessResult _tmp212_ = 0;
	GtkWidget* _tmp214_ = NULL;
	GtkWidget* _tmp215_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->in_history;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp2_ = NULL;
		_tmp2_ = self->priv->game_file;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GtkWindow* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->window;
		_tmp5_ = _ ("Chess");
		gtk_window_set_title (_tmp4_, _tmp5_);
	} else {
		gchar* path = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GtkWindow* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp6_ = self->priv->game_file;
		_tmp7_ = g_file_get_path (_tmp6_);
		path = _tmp7_;
		_tmp8_ = self->priv->window;
		_tmp9_ = _ ("Chess - %1$s");
		_tmp10_ = path;
		_tmp11_ = g_path_get_basename (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf (_tmp9_, _tmp12_);
		_tmp14_ = _tmp13_;
		gtk_window_set_title (_tmp8_, _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (path);
	}
	_tmp15_ = self->priv->history_combo;
	_tmp16_ = gtk_combo_box_get_model (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GTK_TYPE_LIST_STORE, GtkListStore));
	model = _tmp18_;
	_tmp19_ = model;
	gtk_list_store_clear (_tmp19_);
	_tmp20_ = model;
	gtk_list_store_append (_tmp20_, &_tmp21_);
	iter = _tmp21_;
	_tmp22_ = model;
	_tmp23_ = iter;
	_tmp24_ = _ ("Game Start");
	gtk_list_store_set (_tmp22_, &_tmp23_, 0, _tmp24_, 1, 0, -1, -1);
	_tmp25_ = self->priv->history_combo;
	_tmp26_ = iter;
	gtk_combo_box_set_active_iter (_tmp25_, &_tmp26_);
	_tmp27_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
	fen = _tmp27_;
	_tmp28_ = self->priv->pgn_game;
	_tmp29_ = _tmp28_->moves;
	_tmp30_ = g_list_length (_tmp29_);
	_tmp31_ = g_new0 (gchar*, _tmp30_ + 1);
	moves = _tmp31_;
	moves_length1 = _tmp30_;
	_moves_size_ = moves_length1;
	i = 0;
	_tmp32_ = self->priv->pgn_game;
	_tmp33_ = _tmp32_->moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp33_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			gchar* _tmp34_ = NULL;
			gchar* move = NULL;
			_tmp34_ = g_strdup ((const gchar*) move_it->data);
			move = _tmp34_;
			{
				gchar** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gint _tmp36_ = 0;
				const gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				_tmp35_ = moves;
				_tmp35__length1 = moves_length1;
				_tmp36_ = i;
				i = _tmp36_ + 1;
				_tmp37_ = move;
				_tmp38_ = g_strdup (_tmp37_);
				_g_free0 (_tmp35_[_tmp36_]);
				_tmp35_[_tmp36_] = _tmp38_;
				_tmp39_ = _tmp35_[_tmp36_];
				_g_free0 (move);
			}
		}
	}
	_tmp40_ = self->priv->pgn_game;
	_tmp41_ = pgn_game_get_set_up (_tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_) {
		PGNGame* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		_tmp43_ = self->priv->pgn_game;
		_tmp44_ = pgn_game_get_fen (_tmp43_);
		_tmp45_ = _tmp44_;
		if (_tmp45_ != NULL) {
			PGNGame* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			_tmp46_ = self->priv->pgn_game;
			_tmp47_ = pgn_game_get_fen (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strdup (_tmp48_);
			_g_free0 (fen);
			fen = _tmp49_;
		} else {
			g_warning ("gnome-chess.vala:464: Chess game has SetUp tag but no FEN tag");
		}
	}
	_tmp50_ = fen;
	_tmp51_ = moves;
	_tmp51__length1 = moves_length1;
	_tmp52_ = chess_game_new (_tmp50_, _tmp51_, _tmp51__length1);
	_chess_game_unref0 (self->priv->game);
	self->priv->game = _tmp52_;
	_tmp54_ = self->priv->pgn_game;
	_tmp55_ = pgn_game_get_time_control (_tmp54_);
	_tmp56_ = _tmp55_;
	if (_tmp56_ != NULL) {
		PGNGame* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		_tmp57_ = self->priv->pgn_game;
		_tmp58_ = pgn_game_get_time_control (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = atoi (_tmp59_);
		_tmp53_ = _tmp60_ != 0;
	} else {
		_tmp53_ = FALSE;
	}
	_tmp61_ = _tmp53_;
	if (_tmp61_) {
		gboolean _tmp62_ = FALSE;
		PGNGame* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		const gchar* _tmp65_ = NULL;
		gboolean _tmp69_ = FALSE;
		_tmp63_ = self->priv->pgn_game;
		_tmp64_ = pgn_game_get_white_time_left (_tmp63_);
		_tmp65_ = _tmp64_;
		if (_tmp65_ != NULL) {
			PGNGame* _tmp66_ = NULL;
			const gchar* _tmp67_ = NULL;
			const gchar* _tmp68_ = NULL;
			_tmp66_ = self->priv->pgn_game;
			_tmp67_ = pgn_game_get_black_time_left (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp62_ = _tmp68_ != NULL;
		} else {
			_tmp62_ = FALSE;
		}
		_tmp69_ = _tmp62_;
		if (_tmp69_) {
			gint white_seconds = 0;
			PGNGame* _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
			gint _tmp73_ = 0;
			gint black_seconds = 0;
			PGNGame* _tmp74_ = NULL;
			const gchar* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			gint _tmp77_ = 0;
			gboolean _tmp78_ = FALSE;
			gint _tmp79_ = 0;
			gboolean _tmp81_ = FALSE;
			_tmp70_ = self->priv->pgn_game;
			_tmp71_ = pgn_game_get_white_time_left (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = atoi (_tmp72_);
			white_seconds = _tmp73_;
			_tmp74_ = self->priv->pgn_game;
			_tmp75_ = pgn_game_get_black_time_left (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = atoi (_tmp76_);
			black_seconds = _tmp77_;
			_tmp79_ = white_seconds;
			if (_tmp79_ > 0) {
				gint _tmp80_ = 0;
				_tmp80_ = black_seconds;
				_tmp78_ = _tmp80_ > 0;
			} else {
				_tmp78_ = FALSE;
			}
			_tmp81_ = _tmp78_;
			if (_tmp81_) {
				ChessGame* _tmp82_ = NULL;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				ChessClock* _tmp85_ = NULL;
				ChessClock* _tmp86_ = NULL;
				_tmp82_ = self->priv->game;
				_tmp83_ = white_seconds;
				_tmp84_ = black_seconds;
				_tmp85_ = chess_clock_new ((guint) _tmp83_, (guint) _tmp84_);
				_tmp86_ = _tmp85_;
				chess_game_set_clock (_tmp82_, _tmp86_);
				_g_object_unref0 (_tmp86_);
			}
		}
	}
	_tmp87_ = self->priv->game;
	g_signal_connect_object (_tmp87_, "started", (GCallback) _application_game_start_cb_chess_game_started, self, 0);
	_tmp88_ = self->priv->game;
	g_signal_connect_object (_tmp88_, "turn-started", (GCallback) _application_game_turn_cb_chess_game_turn_started, self, 0);
	_tmp89_ = self->priv->game;
	g_signal_connect_object (_tmp89_, "moved", (GCallback) _application_game_move_cb_chess_game_moved, self, 0);
	_tmp90_ = self->priv->game;
	g_signal_connect_object (_tmp90_, "undo", (GCallback) _application_game_undo_cb_chess_game_undo, self, 0);
	_tmp91_ = self->priv->game;
	g_signal_connect_object (_tmp91_, "ended", (GCallback) _application_game_end_cb_chess_game_ended, self, 0);
	_tmp92_ = self->priv->game;
	_tmp93_ = chess_game_get_clock (_tmp92_);
	_tmp94_ = _tmp93_;
	if (_tmp94_ != NULL) {
		ChessGame* _tmp95_ = NULL;
		ChessClock* _tmp96_ = NULL;
		ChessClock* _tmp97_ = NULL;
		_tmp95_ = self->priv->game;
		_tmp96_ = chess_game_get_clock (_tmp95_);
		_tmp97_ = _tmp96_;
		g_signal_connect_object (_tmp97_, "tick", (GCallback) _application_game_clock_tick_cb_chess_clock_tick, self, 0);
	}
	_tmp98_ = self->priv->scene;
	_tmp99_ = self->priv->game;
	chess_scene_set_game (_tmp98_, _tmp99_);
	_tmp100_ = self->priv->info_bar;
	gtk_widget_hide ((GtkWidget*) _tmp100_);
	_tmp101_ = self->priv->save_button;
	gtk_widget_set_sensitive (_tmp101_, FALSE);
	application_update_history_panel (self);
	application_update_control_buttons (self);
	_tmp102_ = self->priv->pgn_game;
	_tmp103_ = pgn_game_get_white_ai (_tmp102_);
	_tmp104_ = _tmp103_;
	_tmp105_ = g_strdup (_tmp104_);
	white_engine = _tmp105_;
	_tmp106_ = self->priv->pgn_game;
	_tmp107_ = pgn_game_get_white_level (_tmp106_);
	_tmp108_ = _tmp107_;
	_tmp109_ = g_strdup (_tmp108_);
	white_level = _tmp109_;
	_tmp110_ = white_level;
	if (_tmp110_ == NULL) {
		gchar* _tmp111_ = NULL;
		_tmp111_ = g_strdup ("normal");
		_g_free0 (white_level);
		white_level = _tmp111_;
	}
	_tmp112_ = self->priv->pgn_game;
	_tmp113_ = pgn_game_get_black_ai (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = g_strdup (_tmp114_);
	black_engine = _tmp115_;
	_tmp116_ = self->priv->pgn_game;
	_tmp117_ = pgn_game_get_black_level (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = g_strdup (_tmp118_);
	black_level = _tmp119_;
	_tmp120_ = black_level;
	if (_tmp120_ == NULL) {
		gchar* _tmp121_ = NULL;
		_tmp121_ = g_strdup ("normal");
		_g_free0 (black_level);
		black_level = _tmp121_;
	}
	_g_object_unref0 (self->priv->human_player);
	self->priv->human_player = NULL;
	_g_object_unref0 (self->priv->opponent);
	self->priv->opponent = NULL;
	_tmp122_ = self->priv->opponent_engine;
	if (_tmp122_ != NULL) {
		ChessEngine* _tmp123_ = NULL;
		ChessEngine* _tmp124_ = NULL;
		guint _tmp125_ = 0U;
		ChessEngine* _tmp126_ = NULL;
		guint _tmp127_ = 0U;
		ChessEngine* _tmp128_ = NULL;
		guint _tmp129_ = 0U;
		ChessEngine* _tmp130_ = NULL;
		guint _tmp131_ = 0U;
		ChessEngine* _tmp132_ = NULL;
		guint _tmp133_ = 0U;
		ChessEngine* _tmp134_ = NULL;
		guint _tmp135_ = 0U;
		ChessEngine* _tmp136_ = NULL;
		guint _tmp137_ = 0U;
		_tmp123_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp123_);
		_tmp124_ = self->priv->opponent_engine;
		g_signal_parse_name ("ready-changed", TYPE_CHESS_ENGINE, &_tmp125_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp124_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp125_, 0, NULL, (GCallback) _application_engine_ready_cb_chess_engine_ready_changed, self);
		_tmp126_ = self->priv->opponent_engine;
		g_signal_parse_name ("moved", TYPE_CHESS_ENGINE, &_tmp127_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp126_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp127_, 0, NULL, (GCallback) _application_engine_move_cb_chess_engine_moved, self);
		_tmp128_ = self->priv->opponent_engine;
		g_signal_parse_name ("resigned", TYPE_CHESS_ENGINE, &_tmp129_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp128_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp129_, 0, NULL, (GCallback) _application_engine_resigned_cb_chess_engine_resigned, self);
		_tmp130_ = self->priv->opponent_engine;
		g_signal_parse_name ("stopped", TYPE_CHESS_ENGINE, &_tmp131_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp130_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp131_, 0, NULL, (GCallback) _application_engine_stopped_cb_chess_engine_stopped, self);
		_tmp132_ = self->priv->opponent_engine;
		g_signal_parse_name ("error", TYPE_CHESS_ENGINE, &_tmp133_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp132_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp133_, 0, NULL, (GCallback) _application_engine_error_cb_chess_engine_error, self);
		_tmp134_ = self->priv->opponent_engine;
		g_signal_parse_name ("claim-draw", TYPE_CHESS_ENGINE, &_tmp135_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp134_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp135_, 0, NULL, (GCallback) _application_engine_claim_draw_cb_chess_engine_claim_draw, self);
		_tmp136_ = self->priv->opponent_engine;
		g_signal_parse_name ("offer-draw", TYPE_CHESS_ENGINE, &_tmp137_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp136_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp137_, 0, NULL, (GCallback) _application_engine_offer_draw_cb_chess_engine_offer_draw, self);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = NULL;
	}
	_tmp138_ = white_engine;
	if (_tmp138_ != NULL) {
		ChessGame* _tmp139_ = NULL;
		ChessPlayer* _tmp140_ = NULL;
		ChessPlayer* _tmp141_ = NULL;
		ChessPlayer* _tmp142_ = NULL;
		ChessGame* _tmp143_ = NULL;
		ChessPlayer* _tmp144_ = NULL;
		ChessPlayer* _tmp145_ = NULL;
		ChessPlayer* _tmp146_ = NULL;
		const gchar* _tmp147_ = NULL;
		const gchar* _tmp148_ = NULL;
		ChessEngine* _tmp149_ = NULL;
		ChessPlayer* _tmp150_ = NULL;
		ChessPlayer* _tmp151_ = NULL;
		_tmp139_ = self->priv->game;
		_tmp140_ = chess_game_get_white (_tmp139_);
		_tmp141_ = _tmp140_;
		_tmp142_ = _g_object_ref0 (_tmp141_);
		_g_object_unref0 (self->priv->opponent);
		self->priv->opponent = _tmp142_;
		_tmp143_ = self->priv->game;
		_tmp144_ = chess_game_get_black (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = _g_object_ref0 (_tmp145_);
		_g_object_unref0 (self->priv->human_player);
		self->priv->human_player = _tmp146_;
		_tmp147_ = white_engine;
		_tmp148_ = white_level;
		_tmp149_ = application_get_engine (self, _tmp147_, _tmp148_);
		_g_object_unref0 (self->priv->opponent_engine);
		self->priv->opponent_engine = _tmp149_;
		_tmp150_ = self->priv->opponent;
		chess_player_set_local_human (_tmp150_, FALSE);
		_tmp151_ = self->priv->human_player;
		chess_player_set_local_human (_tmp151_, TRUE);
	} else {
		const gchar* _tmp152_ = NULL;
		_tmp152_ = black_engine;
		if (_tmp152_ != NULL) {
			ChessGame* _tmp153_ = NULL;
			ChessPlayer* _tmp154_ = NULL;
			ChessPlayer* _tmp155_ = NULL;
			ChessPlayer* _tmp156_ = NULL;
			ChessGame* _tmp157_ = NULL;
			ChessPlayer* _tmp158_ = NULL;
			ChessPlayer* _tmp159_ = NULL;
			ChessPlayer* _tmp160_ = NULL;
			const gchar* _tmp161_ = NULL;
			const gchar* _tmp162_ = NULL;
			ChessEngine* _tmp163_ = NULL;
			ChessPlayer* _tmp164_ = NULL;
			ChessPlayer* _tmp165_ = NULL;
			_tmp153_ = self->priv->game;
			_tmp154_ = chess_game_get_black (_tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = _g_object_ref0 (_tmp155_);
			_g_object_unref0 (self->priv->opponent);
			self->priv->opponent = _tmp156_;
			_tmp157_ = self->priv->game;
			_tmp158_ = chess_game_get_white (_tmp157_);
			_tmp159_ = _tmp158_;
			_tmp160_ = _g_object_ref0 (_tmp159_);
			_g_object_unref0 (self->priv->human_player);
			self->priv->human_player = _tmp160_;
			_tmp161_ = black_engine;
			_tmp162_ = black_level;
			_tmp163_ = application_get_engine (self, _tmp161_, _tmp162_);
			_g_object_unref0 (self->priv->opponent_engine);
			self->priv->opponent_engine = _tmp163_;
			_tmp164_ = self->priv->opponent;
			chess_player_set_local_human (_tmp164_, FALSE);
			_tmp165_ = self->priv->human_player;
			chess_player_set_local_human (_tmp165_, TRUE);
		}
	}
	_tmp166_ = self->priv->opponent_engine;
	if (_tmp166_ == NULL) {
		ChessGame* _tmp167_ = NULL;
		ChessPlayer* _tmp168_ = NULL;
		ChessPlayer* _tmp169_ = NULL;
		ChessGame* _tmp170_ = NULL;
		ChessPlayer* _tmp171_ = NULL;
		ChessPlayer* _tmp172_ = NULL;
		_tmp167_ = self->priv->game;
		_tmp168_ = chess_game_get_black (_tmp167_);
		_tmp169_ = _tmp168_;
		chess_player_set_local_human (_tmp169_, TRUE);
		_tmp170_ = self->priv->game;
		_tmp171_ = chess_game_get_white (_tmp170_);
		_tmp172_ = _tmp171_;
		chess_player_set_local_human (_tmp172_, TRUE);
	} else {
		ChessEngine* _tmp173_ = NULL;
		ChessEngine* _tmp174_ = NULL;
		ChessEngine* _tmp175_ = NULL;
		ChessEngine* _tmp176_ = NULL;
		ChessEngine* _tmp177_ = NULL;
		ChessEngine* _tmp178_ = NULL;
		ChessEngine* _tmp179_ = NULL;
		ChessEngine* _tmp180_ = NULL;
		_tmp173_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp173_, "ready-changed", (GCallback) _application_engine_ready_cb_chess_engine_ready_changed, self, 0);
		_tmp174_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp174_, "moved", (GCallback) _application_engine_move_cb_chess_engine_moved, self, 0);
		_tmp175_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp175_, "resigned", (GCallback) _application_engine_resigned_cb_chess_engine_resigned, self, 0);
		_tmp176_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp176_, "stopped", (GCallback) _application_engine_stopped_cb_chess_engine_stopped, self, 0);
		_tmp177_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp177_, "error", (GCallback) _application_engine_error_cb_chess_engine_error, self, 0);
		_tmp178_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp178_, "claim-draw", (GCallback) _application_engine_claim_draw_cb_chess_engine_claim_draw, self, 0);
		_tmp179_ = self->priv->opponent_engine;
		g_signal_connect_object (_tmp179_, "offer-draw", (GCallback) _application_engine_offer_draw_cb_chess_engine_offer_draw, self, 0);
		_tmp180_ = self->priv->opponent_engine;
		chess_engine_start (_tmp180_);
	}
	{
		gint j = 0;
		ChessGame* _tmp181_ = NULL;
		GList* _tmp182_ = NULL;
		guint _tmp183_ = 0U;
		_tmp181_ = self->priv->game;
		_tmp182_ = _tmp181_->move_stack;
		_tmp183_ = g_list_length (_tmp182_);
		j = ((gint) _tmp183_) - 2;
		{
			gboolean _tmp184_ = FALSE;
			_tmp184_ = TRUE;
			while (TRUE) {
				gboolean _tmp185_ = FALSE;
				gint _tmp187_ = 0;
				ChessState* state = NULL;
				ChessGame* _tmp188_ = NULL;
				GList* _tmp189_ = NULL;
				gint _tmp190_ = 0;
				gconstpointer _tmp191_ = NULL;
				ChessState* _tmp192_ = NULL;
				ChessGame* _tmp193_ = NULL;
				ChessState* _tmp194_ = NULL;
				ChessMove* _tmp195_ = NULL;
				_tmp185_ = _tmp184_;
				if (!_tmp185_) {
					gint _tmp186_ = 0;
					_tmp186_ = j;
					j = _tmp186_ - 1;
				}
				_tmp184_ = FALSE;
				_tmp187_ = j;
				if (!(_tmp187_ >= 0)) {
					break;
				}
				_tmp188_ = self->priv->game;
				_tmp189_ = _tmp188_->move_stack;
				_tmp190_ = j;
				_tmp191_ = g_list_nth_data (_tmp189_, (guint) _tmp190_);
				_tmp192_ = _chess_state_ref0 ((ChessState*) _tmp191_);
				state = _tmp192_;
				_tmp193_ = self->priv->game;
				_tmp194_ = state;
				_tmp195_ = _tmp194_->last_move;
				application_game_move_cb (self, _tmp193_, _tmp195_);
				_chess_state_unref0 (state);
			}
		}
	}
	_tmp196_ = self->priv->in_history;
	self->priv->game_needs_saving = _tmp196_;
	_tmp197_ = self->priv->save_button;
	_tmp198_ = self->priv->in_history;
	gtk_widget_set_sensitive (_tmp197_, _tmp198_);
	_tmp199_ = self->priv->game;
	chess_game_start (_tmp199_);
	_tmp201_ = moves;
	_tmp201__length1 = moves_length1;
	if (_tmp201__length1 > 0) {
		ChessGame* _tmp202_ = NULL;
		ChessClock* _tmp203_ = NULL;
		ChessClock* _tmp204_ = NULL;
		_tmp202_ = self->priv->game;
		_tmp203_ = chess_game_get_clock (_tmp202_);
		_tmp204_ = _tmp203_;
		_tmp200_ = _tmp204_ != NULL;
	} else {
		_tmp200_ = FALSE;
	}
	_tmp205_ = _tmp200_;
	if (_tmp205_) {
		ChessGame* _tmp206_ = NULL;
		ChessClock* _tmp207_ = NULL;
		ChessClock* _tmp208_ = NULL;
		GtkWidget* _tmp209_ = NULL;
		_tmp206_ = self->priv->game;
		_tmp207_ = chess_game_get_clock (_tmp206_);
		_tmp208_ = _tmp207_;
		chess_clock_start (_tmp208_);
		_tmp209_ = self->priv->pause_button;
		gtk_widget_set_sensitive (_tmp209_, TRUE);
	} else {
		GtkWidget* _tmp210_ = NULL;
		_tmp210_ = self->priv->pause_button;
		gtk_widget_set_sensitive (_tmp210_, FALSE);
	}
	_tmp211_ = self->priv->game;
	_tmp212_ = _tmp211_->result;
	if (_tmp212_ != CHESS_RESULT_IN_PROGRESS) {
		ChessGame* _tmp213_ = NULL;
		_tmp213_ = self->priv->game;
		application_game_end_cb (self, _tmp213_);
	}
	_tmp214_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp214_);
	_tmp215_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp215_);
	_g_free0 (black_level);
	_g_free0 (black_engine);
	_g_free0 (white_level);
	_g_free0 (white_engine);
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (fen);
	_g_object_unref0 (model);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static ChessEngine* application_get_engine (Application* self, const gchar* name, const gchar* difficulty) {
	ChessEngine* result = NULL;
	ChessEngine* engine = NULL;
	AIProfile* profile = NULL;
	const gchar* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	AIProfile* _tmp12_ = NULL;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	gchar** uci_go_options = NULL;
	gint uci_go_options_length1 = 0;
	gint _uci_go_options_size_ = 0;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GQuark _tmp21_ = 0U;
	static GQuark _tmp20_label0 = 0;
	static GQuark _tmp20_label1 = 0;
	AIProfile* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (difficulty != NULL, NULL);
	profile = NULL;
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "human") == 0) {
		result = NULL;
		_ai_profile_unref0 (profile);
		_g_object_unref0 (engine);
		return result;
	}
	_tmp1_ = self->priv->ai_profiles;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp1_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp2_ = NULL;
			AIProfile* p = NULL;
			_tmp2_ = _ai_profile_ref0 ((AIProfile*) p_it->data);
			p = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp4_ = NULL;
				gboolean _tmp9_ = FALSE;
				_tmp4_ = name;
				if (g_strcmp0 (_tmp4_, "") == 0) {
					_tmp3_ = TRUE;
				} else {
					AIProfile* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					_tmp5_ = p;
					_tmp6_ = ai_profile_get_name (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = name;
					_tmp3_ = g_strcmp0 (_tmp7_, _tmp8_) == 0;
				}
				_tmp9_ = _tmp3_;
				if (_tmp9_) {
					AIProfile* _tmp10_ = NULL;
					AIProfile* _tmp11_ = NULL;
					_tmp10_ = p;
					_tmp11_ = _ai_profile_ref0 (_tmp10_);
					_ai_profile_unref0 (profile);
					profile = _tmp11_;
					_ai_profile_unref0 (p);
					break;
				}
				_ai_profile_unref0 (p);
			}
		}
	}
	_tmp12_ = profile;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_ = NULL;
		GList* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		AIProfile* _tmp17_ = NULL;
		_tmp13_ = name;
		g_warning ("gnome-chess.vala:605: Unknown AI profile %s", _tmp13_);
		_tmp14_ = self->priv->ai_profiles;
		if (_tmp14_ == NULL) {
			result = NULL;
			_ai_profile_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
		_tmp15_ = self->priv->ai_profiles;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = _ai_profile_ref0 ((AIProfile*) _tmp16_);
		_ai_profile_unref0 (profile);
		profile = _tmp17_;
	}
	_tmp18_ = difficulty;
	_tmp19_ = _tmp18_;
	_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
	if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("easy")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				AIProfile* _tmp26_ = NULL;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gchar** _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gchar** _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				AIProfile* _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gchar** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				_tmp22_ = profile;
				_tmp23_ = ai_profile_get_easy_options (_tmp22_, &_tmp23__length1);
				_tmp24_ = _tmp23_;
				_tmp24__length1 = _tmp23__length1;
				_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup2 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
				_tmp25__length1 = _tmp24__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp25_;
				options_length1 = _tmp25__length1;
				_options_size_ = options_length1;
				_tmp26_ = profile;
				_tmp27_ = ai_profile_get_easy_uci_go_options (_tmp26_, &_tmp27__length1);
				_tmp28_ = _tmp27_;
				_tmp28__length1 = _tmp27__length1;
				_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup3 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
				_tmp29__length1 = _tmp28__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp29_;
				uci_go_options_length1 = _tmp29__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp30_ = profile;
				_tmp31_ = ai_profile_get_easy_args (_tmp30_, &_tmp31__length1);
				_tmp32_ = _tmp31_;
				_tmp32__length1 = _tmp31__length1;
				_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup4 (_tmp32_, _tmp32__length1) : ((gpointer) _tmp32_);
				_tmp33__length1 = _tmp32__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp33_;
				args_length1 = _tmp33__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("hard")))) {
		switch (0) {
			default:
			{
				AIProfile* _tmp34_ = NULL;
				gchar** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gchar** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gchar** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				AIProfile* _tmp38_ = NULL;
				gchar** _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gchar** _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				AIProfile* _tmp42_ = NULL;
				gchar** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gchar** _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				gchar** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
				_tmp34_ = profile;
				_tmp35_ = ai_profile_get_hard_options (_tmp34_, &_tmp35__length1);
				_tmp36_ = _tmp35_;
				_tmp36__length1 = _tmp35__length1;
				_tmp37_ = (_tmp36_ != NULL) ? _vala_array_dup5 (_tmp36_, _tmp36__length1) : ((gpointer) _tmp36_);
				_tmp37__length1 = _tmp36__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp37_;
				options_length1 = _tmp37__length1;
				_options_size_ = options_length1;
				_tmp38_ = profile;
				_tmp39_ = ai_profile_get_hard_uci_go_options (_tmp38_, &_tmp39__length1);
				_tmp40_ = _tmp39_;
				_tmp40__length1 = _tmp39__length1;
				_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup6 (_tmp40_, _tmp40__length1) : ((gpointer) _tmp40_);
				_tmp41__length1 = _tmp40__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp41_;
				uci_go_options_length1 = _tmp41__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp42_ = profile;
				_tmp43_ = ai_profile_get_hard_args (_tmp42_, &_tmp43__length1);
				_tmp44_ = _tmp43_;
				_tmp44__length1 = _tmp43__length1;
				_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup7 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
				_tmp45__length1 = _tmp44__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp45_;
				args_length1 = _tmp45__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				AIProfile* _tmp46_ = NULL;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gchar** _tmp48_ = NULL;
				gint _tmp48__length1 = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				AIProfile* _tmp50_ = NULL;
				gchar** _tmp51_ = NULL;
				gint _tmp51__length1 = 0;
				gchar** _tmp52_ = NULL;
				gint _tmp52__length1 = 0;
				gchar** _tmp53_ = NULL;
				gint _tmp53__length1 = 0;
				AIProfile* _tmp54_ = NULL;
				gchar** _tmp55_ = NULL;
				gint _tmp55__length1 = 0;
				gchar** _tmp56_ = NULL;
				gint _tmp56__length1 = 0;
				gchar** _tmp57_ = NULL;
				gint _tmp57__length1 = 0;
				_tmp46_ = profile;
				_tmp47_ = ai_profile_get_normal_options (_tmp46_, &_tmp47__length1);
				_tmp48_ = _tmp47_;
				_tmp48__length1 = _tmp47__length1;
				_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup8 (_tmp48_, _tmp48__length1) : ((gpointer) _tmp48_);
				_tmp49__length1 = _tmp48__length1;
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
				options = _tmp49_;
				options_length1 = _tmp49__length1;
				_options_size_ = options_length1;
				_tmp50_ = profile;
				_tmp51_ = ai_profile_get_normal_uci_go_options (_tmp50_, &_tmp51__length1);
				_tmp52_ = _tmp51_;
				_tmp52__length1 = _tmp51__length1;
				_tmp53_ = (_tmp52_ != NULL) ? _vala_array_dup9 (_tmp52_, _tmp52__length1) : ((gpointer) _tmp52_);
				_tmp53__length1 = _tmp52__length1;
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
				uci_go_options = _tmp53_;
				uci_go_options_length1 = _tmp53__length1;
				_uci_go_options_size_ = uci_go_options_length1;
				_tmp54_ = profile;
				_tmp55_ = ai_profile_get_normal_args (_tmp54_, &_tmp55__length1);
				_tmp56_ = _tmp55_;
				_tmp56__length1 = _tmp55__length1;
				_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup10 (_tmp56_, _tmp56__length1) : ((gpointer) _tmp56_);
				_tmp57__length1 = _tmp56__length1;
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				args = _tmp57_;
				args_length1 = _tmp57__length1;
				_args_size_ = args_length1;
				break;
			}
		}
	}
	_tmp58_ = profile;
	_tmp59_ = ai_profile_get_protocol (_tmp58_);
	_tmp60_ = _tmp59_;
	if (g_strcmp0 (_tmp60_, "cecp") == 0) {
		gchar** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		AIProfile* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		gchar** _tmp65_ = NULL;
		gint _tmp65__length1 = 0;
		gchar** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		ChessEngineCECP* _tmp67_ = NULL;
		_tmp61_ = uci_go_options;
		_tmp61__length1 = uci_go_options_length1;
		g_warn_if_fail (_tmp61__length1 == 0);
		_tmp62_ = profile;
		_tmp63_ = ai_profile_get_binary (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = args;
		_tmp65__length1 = args_length1;
		_tmp66_ = options;
		_tmp66__length1 = options_length1;
		_tmp67_ = chess_engine_cecp_new (_tmp64_, _tmp65_, _tmp65__length1, _tmp66_, _tmp66__length1);
		_g_object_unref0 (engine);
		engine = (ChessEngine*) _tmp67_;
	} else {
		AIProfile* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		_tmp68_ = profile;
		_tmp69_ = ai_profile_get_protocol (_tmp68_);
		_tmp70_ = _tmp69_;
		if (g_strcmp0 (_tmp70_, "uci") == 0) {
			AIProfile* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
			const gchar* _tmp73_ = NULL;
			gchar** _tmp74_ = NULL;
			gint _tmp74__length1 = 0;
			gchar** _tmp75_ = NULL;
			gint _tmp75__length1 = 0;
			gchar** _tmp76_ = NULL;
			gint _tmp76__length1 = 0;
			ChessEngineUCI* _tmp77_ = NULL;
			_tmp71_ = profile;
			_tmp72_ = ai_profile_get_binary (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = args;
			_tmp74__length1 = args_length1;
			_tmp75_ = options;
			_tmp75__length1 = options_length1;
			_tmp76_ = uci_go_options;
			_tmp76__length1 = uci_go_options_length1;
			_tmp77_ = chess_engine_uci_new (_tmp73_, _tmp74_, _tmp74__length1, _tmp75_, _tmp75__length1, _tmp76_, _tmp76__length1);
			_g_object_unref0 (engine);
			engine = (ChessEngine*) _tmp77_;
		} else {
			AIProfile* _tmp78_ = NULL;
			const gchar* _tmp79_ = NULL;
			const gchar* _tmp80_ = NULL;
			_tmp78_ = profile;
			_tmp79_ = ai_profile_get_protocol (_tmp78_);
			_tmp80_ = _tmp79_;
			g_warning ("gnome-chess.vala:643: Unknown AI protocol %s", _tmp80_);
			result = NULL;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
			_ai_profile_unref0 (profile);
			_g_object_unref0 (engine);
			return result;
		}
	}
	result = engine;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
	_ai_profile_unref0 (profile);
	return result;
}


static void application_real_activate (GApplication* base) {
	Application * self;
	GtkWindow* _tmp0_ = NULL;
	self = (Application*) base;
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static void application_engine_ready_cb (Application* self, ChessEngine* engine) {
	ChessEngine* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent_engine;
	_tmp1_ = chess_engine_get_ready (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ChessView* _tmp3_ = NULL;
		_tmp3_ = self->priv->view;
		gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
	}
}


static void application_engine_move_cb (Application* self, ChessEngine* engine, const gchar* move) {
	ChessPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->opponent;
	_tmp1_ = move;
	_tmp2_ = chess_player_move (_tmp0_, _tmp1_, TRUE);
	if (!_tmp2_) {
		ChessGame* _tmp3_ = NULL;
		_tmp3_ = self->priv->game;
		chess_game_stop (_tmp3_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
}


static void application_engine_resigned_cb (Application* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent;
	chess_player_resign (_tmp0_);
}


static void application_engine_stopped_cb (Application* self, ChessEngine* engine) {
	ChessGame* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
}


static void application_engine_error_cb (Application* self, ChessEngine* engine) {
	ChessGame* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->game;
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
}


static void application_engine_claim_draw_cb (Application* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent;
	_tmp1_ = chess_player_claim_draw (_tmp0_);
	if (!_tmp1_) {
		ChessGame* _tmp2_ = NULL;
		_tmp2_ = self->priv->game;
		chess_game_stop (_tmp2_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
	}
}


static void application_engine_offer_draw_cb (Application* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->opponent;
	chess_player_claim_draw (_tmp0_);
}


static void application_game_start_cb (Application* self, ChessGame* game) {
	ChessEngine* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_ = NULL;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_start_game (_tmp1_);
	}
}


static void application_game_clock_tick_cb (Application* self, ChessClock* clock) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	_tmp0_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp0_);
	_tmp1_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp1_);
}


static void application_game_turn_cb (Application* self, ChessGame* game, ChessPlayer* player) {
	ChessGame* _tmp0_ = NULL;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ChessGame* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (player != NULL);
	_tmp0_ = game;
	_tmp1_ = chess_game_get_clock (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GtkWidget* _tmp3_ = NULL;
		_tmp3_ = self->priv->pause_button;
		gtk_widget_set_sensitive (_tmp3_, TRUE);
	}
	_tmp6_ = game;
	_tmp7_ = _tmp6_->is_started;
	if (_tmp7_) {
		ChessEngine* _tmp8_ = NULL;
		_tmp8_ = self->priv->opponent_engine;
		_tmp5_ = _tmp8_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp9_ = _tmp5_;
	if (_tmp9_) {
		ChessPlayer* _tmp10_ = NULL;
		ChessPlayer* _tmp11_ = NULL;
		_tmp10_ = player;
		_tmp11_ = self->priv->opponent;
		_tmp4_ = _tmp10_ == _tmp11_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp12_ = _tmp4_;
	if (_tmp12_) {
		ChessEngine* _tmp13_ = NULL;
		_tmp13_ = self->priv->opponent_engine;
		chess_engine_request_move (_tmp13_);
	}
}


static void application_set_move_text (Application* self, GtkTreeIter* iter, ChessMove* move) {
	static const gchar* human_descriptions[] = {"White pawn moves from %1$s to %2$s", "White pawn at %1$s takes the black pawn at %2$s", "White pawn at %1$s takes the black rook at %2$s", "White pawn at %1$s takes the black knight at %2$s", "White pawn at %1$s takes the black bishop at %2$s", "White pawn at %1$s takes the black queen at %2$s", "White rook moves from %1$s to %2$s", "White rook at %1$s takes the black pawn at %2$s", "White rook at %1$s takes the black rook at %2$s", "White rook at %1$s takes the black knight at %2$s", "White rook at %1$s takes the black bishop at %2$s", "White rook at %1$s takes the black queen at %2$s", "White knight moves from %1$s to %2$s", "White knight at %1$s takes the black pawn at %2$s", "White knight at %1$s takes the black rook at %2$s", "White knight at %1$s takes the black knight at %2$s", "White knight at %1$s takes the black bishop at %2$s", "White knight at %1$s takes the black queen at %2$s", "White bishop moves from %1$s to %2$s", "White bishop at %1$s takes the black pawn at %2$s", "White bishop at %1$s takes the black rook at %2$s", "White bishop at %1$s takes the black knight at %2$s", "White bishop at %1$s takes the black bishop at %2$s", "White bishop at %1$s takes the black queen at %2$s", "White queen moves from %1$s to %2$s", "White queen at %1$s takes the black pawn at %2$s", "White queen at %1$s takes the black rook at %2$s", "White queen at %1$s takes the black knight at %2$s", "White queen at %1$s takes the black bishop at %2$s", "White queen at %1$s takes the black queen at %2$s", "White king moves from %1$s to %2$s", "White king at %1$s takes the black pawn at %2$s", "White king at %1$s takes the black rook at %2$s", "White king at %1$s takes the black knight at %2$s", "White king at %1$s takes the black bishop at %2$s", "White king at %1$s takes the black queen at %2$s", "Black pawn moves from %1$s to %2$s", "Black pawn at %1$s takes the white pawn at %2$s", "Black pawn at %1$s takes the white rook at %2$s", "Black pawn at %1$s takes the white knight at %2$s", "Black pawn at %1$s takes the white bishop at %2$s", "Black pawn at %1$s takes the white queen at %2$s", "Black rook moves from %1$s to %2$s", "Black rook at %1$s takes the white pawn at %2$s", "Black rook at %1$s takes the white rook at %2$s", "Black rook at %1$s takes the white knight at %2$s", "Black rook at %1$s takes the white bishop at %2$s", "Black rook at %1$s takes the white queen at %2$s", "Black knight moves from %1$s to %2$s", "Black knight at %1$s takes the white pawn at %2$s", "Black knight at %1$s takes the white rook at %2$s", "Black knight at %1$s takes the white knight at %2$s", "Black knight at %1$s takes the white bishop at %2$s", "Black knight at %1$s takes the white queen at %2$s", "Black bishop moves from %1$s to %2$s", "Black bishop at %1$s takes the white pawn at %2$s", "Black bishop at %1$s takes the white rook at %2$s", "Black bishop at %1$s takes the white knight at %2$s", "Black bishop at %1$s takes the white bishop at %2$s", "Black bishop at %1$s takes the white queen at %2$s", "Black queen moves from %1$s to %2$s", "Black queen at %1$s takes the white pawn at %2$s", "Black queen at %1$s takes the white rook at %2$s", "Black queen at %1$s takes the white knight at %2$s", "Black queen at %1$s takes the white bishop at %2$s", "Black queen at %1$s takes the white queen at %2$s", "Black king moves from %1$s to %2$s", "Black king at %1$s takes the white pawn at %2$s", "Black king at %1$s takes the white rook at %2$s", "Black king at %1$s takes the white knight at %2$s", "Black king at %1$s takes the white bishop at %2$s", "Black king at %1$s takes the white queen at %2$s"};
	gchar* move_text = NULL;
	gchar* _tmp0_ = NULL;
	ChessScene* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp85_ = NULL;
	GtkTreeModel* _tmp86_ = NULL;
	GtkTreeModel* _tmp87_ = NULL;
	GtkListStore* _tmp88_ = NULL;
	gchar _tmp89_ = '\0';
	ChessMove* _tmp90_ = NULL;
	gint _tmp91_ = 0;
	gchar* label = NULL;
	ChessMove* _tmp92_ = NULL;
	gint _tmp93_ = 0;
	gchar _tmp94_ = '\0';
	const gchar* _tmp95_ = NULL;
	gchar* _tmp96_ = NULL;
	GtkListStore* _tmp97_ = NULL;
	GtkTreeIter _tmp98_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (move != NULL);
	_tmp0_ = g_strdup ("");
	move_text = _tmp0_;
	_tmp1_ = self->priv->scene;
	_tmp2_ = chess_scene_get_move_format (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp7_ = NULL;
				ChessPiece* _tmp8_ = NULL;
				_tmp7_ = move;
				_tmp8_ = _tmp7_->moved_rook;
				if (_tmp8_ == NULL) {
					gint index = 0;
					ChessMove* _tmp9_ = NULL;
					ChessPiece* _tmp10_ = NULL;
					gint _tmp14_ = 0;
					ChessMove* _tmp15_ = NULL;
					ChessPiece* _tmp16_ = NULL;
					PieceType _tmp17_ = 0;
					ChessMove* _tmp18_ = NULL;
					ChessPiece* _tmp19_ = NULL;
					ChessPlayer* _tmp20_ = NULL;
					Color _tmp21_ = 0;
					gchar* start = NULL;
					ChessMove* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					ChessMove* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gchar* _tmp27_ = NULL;
					gchar* end = NULL;
					ChessMove* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					ChessMove* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gchar* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					_tmp9_ = move;
					_tmp10_ = _tmp9_->victim;
					if (_tmp10_ == NULL) {
						index = 0;
					} else {
						ChessMove* _tmp11_ = NULL;
						ChessPiece* _tmp12_ = NULL;
						PieceType _tmp13_ = 0;
						_tmp11_ = move;
						_tmp12_ = _tmp11_->victim;
						_tmp13_ = _tmp12_->type;
						index = (gint) (_tmp13_ + 1);
					}
					_tmp14_ = index;
					_tmp15_ = move;
					_tmp16_ = _tmp15_->piece;
					_tmp17_ = _tmp16_->type;
					index = _tmp14_ + (_tmp17_ * 6);
					_tmp18_ = move;
					_tmp19_ = _tmp18_->piece;
					_tmp20_ = _tmp19_->player;
					_tmp21_ = _tmp20_->color;
					if (_tmp21_ == COLOR_BLACK) {
						gint _tmp22_ = 0;
						_tmp22_ = index;
						index = _tmp22_ + 36;
					}
					_tmp23_ = move;
					_tmp24_ = _tmp23_->f0;
					_tmp25_ = move;
					_tmp26_ = _tmp25_->r0;
					_tmp27_ = g_strdup_printf ("%c%d", 'a' + _tmp24_, _tmp26_ + 1);
					start = _tmp27_;
					_tmp28_ = move;
					_tmp29_ = _tmp28_->f1;
					_tmp30_ = move;
					_tmp31_ = _tmp30_->r1;
					_tmp32_ = g_strdup_printf ("%c%d", 'a' + _tmp29_, _tmp31_ + 1);
					end = _tmp32_;
					_tmp33_ = index;
					_tmp34_ = human_descriptions[_tmp33_];
					_tmp35_ = _ (_tmp34_);
					_tmp36_ = start;
					_tmp37_ = end;
					_tmp38_ = g_strdup_printf (_tmp35_, _tmp36_, _tmp37_);
					_g_free0 (move_text);
					move_text = _tmp38_;
					_g_free0 (end);
					_g_free0 (start);
				} else {
					gboolean _tmp39_ = FALSE;
					ChessMove* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					ChessMove* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					gboolean _tmp46_ = FALSE;
					_tmp40_ = move;
					_tmp41_ = _tmp40_->f0;
					_tmp42_ = move;
					_tmp43_ = _tmp42_->f1;
					if (_tmp41_ < _tmp43_) {
						ChessMove* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						_tmp44_ = move;
						_tmp45_ = _tmp44_->r0;
						_tmp39_ = _tmp45_ == 0;
					} else {
						_tmp39_ = FALSE;
					}
					_tmp46_ = _tmp39_;
					if (_tmp46_) {
						const gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
						_tmp47_ = _ ("White castles kingside");
						_tmp48_ = g_strdup (_tmp47_);
						_g_free0 (move_text);
						move_text = _tmp48_;
					} else {
						gboolean _tmp49_ = FALSE;
						ChessMove* _tmp50_ = NULL;
						gint _tmp51_ = 0;
						ChessMove* _tmp52_ = NULL;
						gint _tmp53_ = 0;
						gboolean _tmp56_ = FALSE;
						_tmp50_ = move;
						_tmp51_ = _tmp50_->f1;
						_tmp52_ = move;
						_tmp53_ = _tmp52_->f0;
						if (_tmp51_ < _tmp53_) {
							ChessMove* _tmp54_ = NULL;
							gint _tmp55_ = 0;
							_tmp54_ = move;
							_tmp55_ = _tmp54_->r0;
							_tmp49_ = _tmp55_ == 0;
						} else {
							_tmp49_ = FALSE;
						}
						_tmp56_ = _tmp49_;
						if (_tmp56_) {
							const gchar* _tmp57_ = NULL;
							gchar* _tmp58_ = NULL;
							_tmp57_ = _ ("White castles queenside");
							_tmp58_ = g_strdup (_tmp57_);
							_g_free0 (move_text);
							move_text = _tmp58_;
						} else {
							gboolean _tmp59_ = FALSE;
							ChessMove* _tmp60_ = NULL;
							gint _tmp61_ = 0;
							ChessMove* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							gboolean _tmp66_ = FALSE;
							_tmp60_ = move;
							_tmp61_ = _tmp60_->f0;
							_tmp62_ = move;
							_tmp63_ = _tmp62_->f1;
							if (_tmp61_ < _tmp63_) {
								ChessMove* _tmp64_ = NULL;
								gint _tmp65_ = 0;
								_tmp64_ = move;
								_tmp65_ = _tmp64_->r0;
								_tmp59_ = _tmp65_ == 7;
							} else {
								_tmp59_ = FALSE;
							}
							_tmp66_ = _tmp59_;
							if (_tmp66_) {
								const gchar* _tmp67_ = NULL;
								gchar* _tmp68_ = NULL;
								_tmp67_ = _ ("Black castles kingside");
								_tmp68_ = g_strdup (_tmp67_);
								_g_free0 (move_text);
								move_text = _tmp68_;
							} else {
								gboolean _tmp69_ = FALSE;
								ChessMove* _tmp70_ = NULL;
								gint _tmp71_ = 0;
								ChessMove* _tmp72_ = NULL;
								gint _tmp73_ = 0;
								gboolean _tmp76_ = FALSE;
								_tmp70_ = move;
								_tmp71_ = _tmp70_->f1;
								_tmp72_ = move;
								_tmp73_ = _tmp72_->f0;
								if (_tmp71_ < _tmp73_) {
									ChessMove* _tmp74_ = NULL;
									gint _tmp75_ = 0;
									_tmp74_ = move;
									_tmp75_ = _tmp74_->r0;
									_tmp69_ = _tmp75_ == 7;
								} else {
									_tmp69_ = FALSE;
								}
								_tmp76_ = _tmp69_;
								if (_tmp76_) {
									const gchar* _tmp77_ = NULL;
									gchar* _tmp78_ = NULL;
									_tmp77_ = _ ("Black castles queenside");
									_tmp78_ = g_strdup (_tmp77_);
									_g_free0 (move_text);
									move_text = _tmp78_;
								} else {
									g_assert_not_reached ();
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("san")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp79_ = NULL;
				gchar* _tmp80_ = NULL;
				_tmp79_ = move;
				_tmp80_ = chess_move_get_san (_tmp79_);
				_g_free0 (move_text);
				move_text = _tmp80_;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("fan")))) {
		switch (0) {
			default:
			{
				ChessMove* _tmp81_ = NULL;
				gchar* _tmp82_ = NULL;
				_tmp81_ = move;
				_tmp82_ = chess_move_get_fan (_tmp81_);
				_g_free0 (move_text);
				move_text = _tmp82_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				ChessMove* _tmp83_ = NULL;
				gchar* _tmp84_ = NULL;
				_tmp83_ = move;
				_tmp84_ = chess_move_get_lan (_tmp83_);
				_g_free0 (move_text);
				move_text = _tmp84_;
				break;
			}
		}
	}
	_tmp85_ = self->priv->history_combo;
	_tmp86_ = gtk_combo_box_get_model (_tmp85_);
	_tmp87_ = _tmp86_;
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, GTK_TYPE_LIST_STORE, GtkListStore));
	model = _tmp88_;
	_tmp90_ = move;
	_tmp91_ = _tmp90_->number;
	if ((_tmp91_ % 2) == 0) {
		_tmp89_ = 'b';
	} else {
		_tmp89_ = 'a';
	}
	_tmp92_ = move;
	_tmp93_ = _tmp92_->number;
	_tmp94_ = _tmp89_;
	_tmp95_ = move_text;
	_tmp96_ = g_strdup_printf ("%u%c. %s", (guint) ((_tmp93_ + 1) / 2), (gint) _tmp94_, _tmp95_);
	label = _tmp96_;
	_tmp97_ = model;
	_tmp98_ = *iter;
	gtk_list_store_set (_tmp97_, &_tmp98_, 0, label, -1, -1);
	_g_free0 (label);
	_g_object_unref0 (model);
	_g_free0 (move_text);
}


static void application_game_move_cb (Application* self, ChessGame* game, ChessMove* move) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ChessMove* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	PGNGame* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp17_ = NULL;
	GtkTreeModel* _tmp18_ = NULL;
	GtkTreeModel* _tmp19_ = NULL;
	GtkListStore* _tmp20_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	GtkListStore* _tmp23_ = NULL;
	GtkTreeIter _tmp24_ = {0};
	ChessMove* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	GtkTreeIter _tmp27_ = {0};
	ChessMove* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	ChessMove* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	ChessGame* _tmp32_ = NULL;
	guint _tmp33_ = 0U;
	guint _tmp34_ = 0U;
	gboolean _tmp38_ = FALSE;
	GtkWidget* _tmp41_ = NULL;
	ChessEngine* _tmp42_ = NULL;
	ChessView* _tmp45_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (move != NULL);
	self->priv->game_needs_saving = TRUE;
	_tmp2_ = move;
	_tmp3_ = _tmp2_->number;
	if (_tmp3_ == 1) {
		ChessPlayer* _tmp4_ = NULL;
		_tmp4_ = self->priv->opponent;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		ChessPlayer* _tmp6_ = NULL;
		Color _tmp7_ = 0;
		_tmp6_ = self->priv->opponent;
		_tmp7_ = _tmp6_->color;
		_tmp0_ = _tmp7_ == COLOR_WHITE;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		self->priv->game_needs_saving = FALSE;
	}
	_tmp9_ = move;
	_tmp10_ = _tmp9_->number;
	_tmp11_ = self->priv->pgn_game;
	_tmp12_ = _tmp11_->moves;
	_tmp13_ = g_list_length (_tmp12_);
	if (((guint) _tmp10_) > _tmp13_) {
		PGNGame* _tmp14_ = NULL;
		ChessMove* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp14_ = self->priv->pgn_game;
		_tmp15_ = move;
		_tmp16_ = chess_move_get_san (_tmp15_);
		_tmp14_->moves = g_list_append (_tmp14_->moves, _tmp16_);
	}
	_tmp17_ = self->priv->history_combo;
	_tmp18_ = gtk_combo_box_get_model (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GTK_TYPE_LIST_STORE, GtkListStore));
	model = _tmp20_;
	_tmp21_ = model;
	gtk_list_store_append (_tmp21_, &_tmp22_);
	iter = _tmp22_;
	_tmp23_ = model;
	_tmp24_ = iter;
	_tmp25_ = move;
	_tmp26_ = _tmp25_->number;
	gtk_list_store_set (_tmp23_, &_tmp24_, 1, _tmp26_, -1, -1);
	_tmp27_ = iter;
	_tmp28_ = move;
	application_set_move_text (self, &_tmp27_, _tmp28_);
	_tmp30_ = move;
	_tmp31_ = _tmp30_->number;
	_tmp32_ = game;
	_tmp33_ = chess_game_get_n_moves (_tmp32_);
	_tmp34_ = _tmp33_;
	if (((guint) _tmp31_) == _tmp34_) {
		ChessScene* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		_tmp35_ = self->priv->scene;
		_tmp36_ = chess_scene_get_move_number (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp29_ = _tmp37_ == (-1);
	} else {
		_tmp29_ = FALSE;
	}
	_tmp38_ = _tmp29_;
	if (_tmp38_) {
		GtkComboBox* _tmp39_ = NULL;
		GtkTreeIter _tmp40_ = {0};
		_tmp39_ = self->priv->history_combo;
		_tmp40_ = iter;
		gtk_combo_box_set_active_iter (_tmp39_, &_tmp40_);
	}
	_tmp41_ = self->priv->save_button;
	gtk_widget_set_sensitive (_tmp41_, TRUE);
	application_update_history_panel (self);
	application_update_control_buttons (self);
	_tmp42_ = self->priv->opponent_engine;
	if (_tmp42_ != NULL) {
		ChessEngine* _tmp43_ = NULL;
		ChessMove* _tmp44_ = NULL;
		_tmp43_ = self->priv->opponent_engine;
		_tmp44_ = move;
		chess_engine_report_move (_tmp43_, _tmp44_);
	}
	_tmp45_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp45_);
	_g_object_unref0 (model);
}


static void application_game_undo_cb (Application* self, ChessGame* game) {
	ChessEngine* _tmp0_ = NULL;
	PGNGame* _tmp2_ = NULL;
	PGNGame* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkListStore* _tmp9_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp10_ = NULL;
	GtkListStore* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkTreeIter _tmp13_ = {0};
	GtkListStore* _tmp14_ = NULL;
	GtkTreeIter _tmp15_ = {0};
	ChessScene* _tmp16_ = NULL;
	GtkListStore* _tmp17_ = NULL;
	GtkListStore* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkTreeIter _tmp20_ = {0};
	GtkComboBox* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	ChessView* _tmp23_ = NULL;
	ChessGame* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->opponent_engine;
	if (_tmp0_ != NULL) {
		ChessEngine* _tmp1_ = NULL;
		_tmp1_ = self->priv->opponent_engine;
		chess_engine_undo (_tmp1_);
	}
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = self->priv->pgn_game;
	_tmp4_ = _tmp3_->moves;
	_tmp5_ = g_list_last (_tmp4_);
	_tmp2_->moves = g_list_remove_link (_tmp2_->moves, _tmp5_);
	_tmp6_ = self->priv->history_combo;
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_LIST_STORE, GtkListStore));
	model = _tmp9_;
	_tmp10_ = model;
	_tmp11_ = model;
	_tmp12_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp11_, NULL);
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp10_, &_tmp13_, NULL, _tmp12_ - 1);
	iter = _tmp13_;
	_tmp14_ = model;
	_tmp15_ = iter;
	gtk_list_store_remove (_tmp14_, &_tmp15_);
	_tmp16_ = self->priv->scene;
	chess_scene_set_move_number (_tmp16_, -1);
	_tmp17_ = model;
	_tmp18_ = model;
	_tmp19_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp18_, NULL);
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp17_, &_tmp20_, NULL, _tmp19_ - 1);
	iter = _tmp20_;
	_tmp21_ = self->priv->history_combo;
	_tmp22_ = iter;
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
	_tmp23_ = self->priv->view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp23_);
	_tmp24_ = game;
	_tmp25_ = chess_game_get_n_moves (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ > ((guint) 0)) {
		GtkWidget* _tmp27_ = NULL;
		self->priv->game_needs_saving = TRUE;
		_tmp27_ = self->priv->save_button;
		gtk_widget_set_sensitive (_tmp27_, TRUE);
	} else {
		GtkWidget* _tmp28_ = NULL;
		self->priv->game_needs_saving = FALSE;
		_tmp28_ = self->priv->save_button;
		gtk_widget_set_sensitive (_tmp28_, FALSE);
	}
	application_update_history_panel (self);
	application_update_control_buttons (self);
	_g_object_unref0 (model);
}


static void application_update_control_buttons (Application* self) {
	gboolean can_resign = FALSE;
	ChessGame* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GtkWidget* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkWidget* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean can_undo = FALSE;
	ChessGame* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	gboolean _tmp16_ = FALSE;
	ChessPlayer* _tmp17_ = NULL;
	gboolean _tmp20_ = FALSE;
	GtkWidget* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_n_moves (_tmp0_);
	_tmp2_ = _tmp1_;
	can_resign = _tmp2_ > ((guint) 0);
	_tmp3_ = self->priv->resign_button;
	_tmp4_ = can_resign;
	gtk_widget_set_sensitive (_tmp3_, _tmp4_);
	_tmp6_ = can_resign;
	if (_tmp6_) {
		ChessGame* _tmp7_ = NULL;
		ChessPlayer* _tmp8_ = NULL;
		ChessPlayer* _tmp9_ = NULL;
		ChessPlayer* _tmp10_ = NULL;
		_tmp7_ = self->priv->game;
		_tmp8_ = chess_game_get_current_player (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->opponent;
		_tmp5_ = _tmp9_ != _tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp11_ = self->priv->claim_draw_button;
	_tmp12_ = _tmp5_;
	gtk_widget_set_sensitive (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->game;
	_tmp14_ = chess_game_get_n_moves (_tmp13_);
	_tmp15_ = _tmp14_;
	can_undo = _tmp15_ > ((guint) 0);
	_tmp17_ = self->priv->opponent;
	if (_tmp17_ != NULL) {
		ChessPlayer* _tmp18_ = NULL;
		Color _tmp19_ = 0;
		_tmp18_ = self->priv->opponent;
		_tmp19_ = _tmp18_->color;
		_tmp16_ = _tmp19_ == COLOR_WHITE;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp20_ = _tmp16_;
	if (_tmp20_) {
		ChessGame* _tmp21_ = NULL;
		guint _tmp22_ = 0U;
		guint _tmp23_ = 0U;
		_tmp21_ = self->priv->game;
		_tmp22_ = chess_game_get_n_moves (_tmp21_);
		_tmp23_ = _tmp22_;
		can_undo = _tmp23_ > ((guint) 1);
	}
	_tmp24_ = self->priv->undo_button;
	_tmp25_ = can_undo;
	gtk_widget_set_sensitive (_tmp24_, _tmp25_);
}


static void application_game_end_cb (Application* self, ChessGame* game) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	ChessEngine* _tmp4_ = NULL;
	gchar* title = NULL;
	gchar* _tmp6_ = NULL;
	ChessGame* _tmp7_ = NULL;
	ChessResult _tmp8_ = 0;
	gchar* reason = NULL;
	gchar* _tmp23_ = NULL;
	ChessGame* _tmp24_ = NULL;
	ChessRule _tmp25_ = 0;
	GtkLabel* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	GtkLabel* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	GtkInfoBar* _tmp60_ = NULL;
	GtkWidget* _tmp61_ = NULL;
	GtkWidget* _tmp62_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->resign_button;
	gtk_widget_set_sensitive (_tmp0_, FALSE);
	_tmp1_ = self->priv->undo_button;
	gtk_widget_set_sensitive (_tmp1_, FALSE);
	_tmp2_ = self->priv->claim_draw_button;
	gtk_widget_set_sensitive (_tmp2_, FALSE);
	_tmp3_ = self->priv->pause_button;
	gtk_widget_set_sensitive (_tmp3_, FALSE);
	self->priv->game_needs_saving = FALSE;
	_tmp4_ = self->priv->opponent_engine;
	if (_tmp4_ != NULL) {
		ChessEngine* _tmp5_ = NULL;
		_tmp5_ = self->priv->opponent_engine;
		chess_engine_stop (_tmp5_);
	}
	_tmp6_ = g_strdup ("");
	title = _tmp6_;
	_tmp7_ = game;
	_tmp8_ = _tmp7_->result;
	switch (_tmp8_) {
		case CHESS_RESULT_WHITE_WON:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			PGNGame* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp9_ = _ ("White wins");
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (title);
			title = _tmp10_;
			_tmp11_ = self->priv->pgn_game;
			_tmp12_ = pgn_game_RESULT_WHITE;
			pgn_game_set_result (_tmp11_, _tmp12_);
			break;
		}
		case CHESS_RESULT_BLACK_WON:
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			PGNGame* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			_tmp13_ = _ ("Black wins");
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (title);
			title = _tmp14_;
			_tmp15_ = self->priv->pgn_game;
			_tmp16_ = pgn_game_RESULT_BLACK;
			pgn_game_set_result (_tmp15_, _tmp16_);
			break;
		}
		case CHESS_RESULT_DRAW:
		{
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			PGNGame* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			_tmp17_ = _ ("Game is drawn");
			_tmp18_ = g_strdup (_tmp17_);
			_g_free0 (title);
			title = _tmp18_;
			_tmp19_ = self->priv->pgn_game;
			_tmp20_ = pgn_game_RESULT_DRAW;
			pgn_game_set_result (_tmp19_, _tmp20_);
			break;
		}
		case CHESS_RESULT_BUG:
		{
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			_tmp21_ = _ ("Oops! Something has gone wrong.");
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (title);
			title = _tmp22_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp23_ = g_strdup ("");
	reason = _tmp23_;
	_tmp24_ = game;
	_tmp25_ = _tmp24_->rule;
	switch (_tmp25_) {
		case CHESS_RULE_CHECKMATE:
		{
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp26_ = _ ("Opponent is in check and cannot move (checkmate)");
			_tmp27_ = g_strdup (_tmp26_);
			_g_free0 (reason);
			reason = _tmp27_;
			break;
		}
		case CHESS_RULE_STALEMATE:
		{
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			_tmp28_ = _ ("Opponent cannot move (stalemate)");
			_tmp29_ = g_strdup (_tmp28_);
			_g_free0 (reason);
			reason = _tmp29_;
			break;
		}
		case CHESS_RULE_FIFTY_MOVES:
		{
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			_tmp30_ = _ ("No piece has been taken or pawn moved in the last fifty moves");
			_tmp31_ = g_strdup (_tmp30_);
			_g_free0 (reason);
			reason = _tmp31_;
			break;
		}
		case CHESS_RULE_TIMEOUT:
		{
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			_tmp32_ = _ ("Opponent has run out of time");
			_tmp33_ = g_strdup (_tmp32_);
			_g_free0 (reason);
			reason = _tmp33_;
			break;
		}
		case CHESS_RULE_THREE_FOLD_REPETITION:
		{
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			_tmp34_ = _ ("The same board state has occurred three times (threefold repetition)");
			_tmp35_ = g_strdup (_tmp34_);
			_g_free0 (reason);
			reason = _tmp35_;
			break;
		}
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
		{
			const gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			_tmp36_ = _ ("Neither player can checkmate (insufficient material)");
			_tmp37_ = g_strdup (_tmp36_);
			_g_free0 (reason);
			reason = _tmp37_;
			break;
		}
		case CHESS_RULE_RESIGN:
		{
			ChessGame* _tmp38_ = NULL;
			ChessResult _tmp39_ = 0;
			_tmp38_ = game;
			_tmp39_ = _tmp38_->result;
			if (_tmp39_ == CHESS_RESULT_WHITE_WON) {
				const gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				_tmp40_ = _ ("The black player has resigned");
				_tmp41_ = g_strdup (_tmp40_);
				_g_free0 (reason);
				reason = _tmp41_;
			} else {
				const gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				_tmp42_ = _ ("The white player has resigned");
				_tmp43_ = g_strdup (_tmp42_);
				_g_free0 (reason);
				reason = _tmp43_;
			}
			break;
		}
		case CHESS_RULE_ABANDONMENT:
		{
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			PGNGame* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			_tmp44_ = _ ("The game has been abandoned");
			_tmp45_ = g_strdup (_tmp44_);
			_g_free0 (reason);
			reason = _tmp45_;
			_tmp46_ = self->priv->pgn_game;
			_tmp47_ = pgn_game_TERMINATE_ABANDONED;
			pgn_game_set_termination (_tmp46_, _tmp47_);
			break;
		}
		case CHESS_RULE_DEATH:
		{
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			PGNGame* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
			_tmp48_ = _ ("One of the players has died");
			_tmp49_ = g_strdup (_tmp48_);
			_g_free0 (reason);
			reason = _tmp49_;
			_tmp50_ = self->priv->pgn_game;
			_tmp51_ = pgn_game_TERMINATE_DEATH;
			pgn_game_set_termination (_tmp50_, _tmp51_);
			break;
		}
		case CHESS_RULE_BUG:
		{
			const gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			_tmp52_ = _ ("The game cannot continue.");
			_tmp53_ = g_strdup (_tmp52_);
			_g_free0 (reason);
			reason = _tmp53_;
			break;
		}
		default:
		break;
	}
	_tmp54_ = self->priv->info_title_label;
	_tmp55_ = title;
	_tmp56_ = g_strdup_printf ("<big><b>%s</b></big>", _tmp55_);
	_tmp57_ = _tmp56_;
	gtk_label_set_markup (_tmp54_, _tmp57_);
	_g_free0 (_tmp57_);
	_tmp58_ = self->priv->info_label;
	_tmp59_ = reason;
	gtk_label_set_text (_tmp58_, _tmp59_);
	_tmp60_ = self->priv->info_bar;
	gtk_widget_show ((GtkWidget*) _tmp60_);
	_tmp61_ = self->priv->white_time_label;
	gtk_widget_queue_draw (_tmp61_);
	_tmp62_ = self->priv->black_time_label;
	gtk_widget_queue_draw (_tmp62_);
	_g_free0 (reason);
	_g_free0 (title);
}


void application_show (Application* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


gboolean G_MODULE_EXPORT gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	application_quit_game (self);
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT gnome_chess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, Application* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_boolean (_tmp1_, "maximized");
	if (!_tmp2_) {
		GSettings* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_boolean (_tmp3_, "fullscreen");
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GSettings* _tmp6_ = NULL;
		GdkEventConfigure _tmp7_ = {0};
		gint _tmp8_ = 0;
		GSettings* _tmp9_ = NULL;
		GdkEventConfigure _tmp10_ = {0};
		gint _tmp11_ = 0;
		_tmp6_ = self->priv->settings;
		_tmp7_ = *event;
		_tmp8_ = _tmp7_.width;
		g_settings_set_int (_tmp6_, "width", _tmp8_);
		_tmp9_ = self->priv->settings;
		_tmp10_ = *event;
		_tmp11_ = _tmp10_.height;
		g_settings_set_int (_tmp9_, "height", _tmp11_);
	}
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT gnome_chess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, Application* self) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_ = {0};
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState _tmp6_ = {0};
	GdkWindowState _tmp7_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		gboolean is_maximized = FALSE;
		GdkEventWindowState _tmp2_ = {0};
		GdkWindowState _tmp3_ = 0;
		GSettings* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
		_tmp4_ = self->priv->settings;
		_tmp5_ = is_maximized;
		g_settings_set_boolean (_tmp4_, "maximized", _tmp5_);
	}
	_tmp6_ = *event;
	_tmp7_ = _tmp6_.changed_mask;
	if ((_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		GdkEventWindowState _tmp8_ = {0};
		GdkWindowState _tmp9_ = 0;
		GSettings* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp8_ = *event;
		_tmp9_ = _tmp8_.new_window_state;
		self->priv->is_fullscreen = (_tmp9_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
		_tmp10_ = self->priv->settings;
		_tmp11_ = self->priv->is_fullscreen;
		g_settings_set_boolean (_tmp10_, "fullscreen", _tmp11_);
	}
	result = FALSE;
	return result;
}


static gboolean application_prompt_save_game (Application* self, const gchar* prompt_text) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	GtkWindow* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkMessageDialog* _tmp9_ = NULL;
	GtkMessageDialog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	ChessGame* _tmp12_ = NULL;
	ChessResult _tmp13_ = 0;
	gint _result_ = 0;
	GtkMessageDialog* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	GtkMessageDialog* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gboolean _tmp28_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prompt_text != NULL, FALSE);
	_tmp1_ = self->priv->game_needs_saving;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = self->priv->in_history;
		if (!_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			GFile* _tmp4_ = NULL;
			_tmp4_ = self->priv->game_file;
			_tmp2_ = _tmp4_ == NULL;
		}
		_tmp5_ = _tmp2_;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = self->priv->window;
	_tmp8_ = prompt_text;
	_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (_tmp7_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "<span weight=\"bold\" size=\"larger\">%s</span>", _tmp8_);
	g_object_ref_sink (_tmp9_);
	dialog = _tmp9_;
	_tmp10_ = dialog;
	_tmp11_ = _ ("_Cancel");
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, _tmp11_, (gint) GTK_RESPONSE_CANCEL);
	_tmp12_ = self->priv->game;
	_tmp13_ = _tmp12_->result;
	if (_tmp13_ == CHESS_RESULT_IN_PROGRESS) {
		GtkMessageDialog* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GtkMessageDialog* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp14_ = dialog;
		_tmp15_ = _ ("_Abandon game");
		gtk_dialog_add_button ((GtkDialog*) _tmp14_, _tmp15_, (gint) GTK_RESPONSE_NO);
		_tmp16_ = dialog;
		_tmp17_ = _ ("_Save game for later");
		gtk_dialog_add_button ((GtkDialog*) _tmp16_, _tmp17_, (gint) GTK_RESPONSE_YES);
	} else {
		GtkMessageDialog* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GtkMessageDialog* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp18_ = dialog;
		_tmp19_ = _ ("_Discard game");
		gtk_dialog_add_button ((GtkDialog*) _tmp18_, _tmp19_, (gint) GTK_RESPONSE_NO);
		_tmp20_ = dialog;
		_tmp21_ = _ ("_Save game log");
		gtk_dialog_add_button ((GtkDialog*) _tmp20_, _tmp21_, (gint) GTK_RESPONSE_YES);
	}
	_tmp22_ = dialog;
	_tmp23_ = gtk_dialog_run ((GtkDialog*) _tmp22_);
	_result_ = _tmp23_;
	_tmp24_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp24_);
	_tmp26_ = _result_;
	if (_tmp26_ == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp25_ = TRUE;
	} else {
		gint _tmp27_ = 0;
		_tmp27_ = _result_;
		_tmp25_ = _tmp27_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	_tmp28_ = _tmp25_;
	if (_tmp28_) {
		result = FALSE;
		_g_object_unref0 (dialog);
		return result;
	} else {
		gint _tmp29_ = 0;
		_tmp29_ = _result_;
		if (_tmp29_ == ((gint) GTK_RESPONSE_YES)) {
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			_tmp30_ = _ ("_Discard");
			_tmp31_ = _ ("_Save");
			application_save_game (self, _tmp30_, _tmp31_);
		} else {
			gint _tmp32_ = 0;
			_tmp32_ = _result_;
			g_warn_if_fail (_tmp32_ == ((gint) GTK_RESPONSE_NO));
			self->priv->game_needs_saving = FALSE;
			application_autosave (self);
		}
	}
	result = TRUE;
	_g_object_unref0 (dialog);
	return result;
}


void G_MODULE_EXPORT new_game_cb (GtkWidget* widget, Application* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = _ ("Save this game before starting a new one?");
	_tmp1_ = application_prompt_save_game (self, _tmp0_);
	if (_tmp1_) {
		application_start_new_game (self);
	}
}


void G_MODULE_EXPORT resign_cb (GtkWidget* widget, Application* self) {
	ChessPlayer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->human_player;
	if (_tmp0_ != NULL) {
		ChessPlayer* _tmp1_ = NULL;
		_tmp1_ = self->priv->human_player;
		chess_player_resign (_tmp1_);
	} else {
		ChessGame* _tmp2_ = NULL;
		ChessPlayer* _tmp3_ = NULL;
		ChessPlayer* _tmp4_ = NULL;
		_tmp2_ = self->priv->game;
		_tmp3_ = chess_game_get_current_player (_tmp2_);
		_tmp4_ = _tmp3_;
		chess_player_resign (_tmp4_);
	}
}


void G_MODULE_EXPORT claim_draw_cb (GtkWidget* widget, Application* self) {
	ChessGame* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_current_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_player_claim_draw (_tmp2_);
	if (!_tmp3_) {
		GtkMessageDialog* dialog = NULL;
		GtkWindow* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GtkMessageDialog* _tmp6_ = NULL;
		gint repetitions = 0;
		ChessGame* _tmp7_ = NULL;
		ChessGame* _tmp8_ = NULL;
		ChessState* _tmp9_ = NULL;
		ChessState* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint moves = 0;
		ChessGame* _tmp12_ = NULL;
		ChessState* _tmp13_ = NULL;
		ChessState* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gboolean _tmp16_ = FALSE;
		gint _tmp17_ = 0;
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		GtkMessageDialog* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		const gchar* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_ = NULL;
		gint _tmp79_ = 0;
		GtkMessageDialog* _tmp80_ = NULL;
		GtkMessageDialog* _tmp81_ = NULL;
		_tmp4_ = self->priv->window;
		_tmp5_ = _ ("You cannot currently claim a draw.");
		_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (_tmp4_, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, "<span weight=\"bold\" size=\"larger\">%s</span>", _tmp5_);
		g_object_ref_sink (_tmp6_);
		dialog = _tmp6_;
		_tmp7_ = self->priv->game;
		_tmp8_ = self->priv->game;
		_tmp9_ = chess_game_get_current_state (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = chess_game_state_repeated_times (_tmp7_, _tmp10_);
		repetitions = _tmp11_;
		_tmp12_ = self->priv->game;
		_tmp13_ = chess_game_get_current_state (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->halfmove_clock;
		moves = _tmp15_ / 2;
		_tmp17_ = repetitions;
		if (_tmp17_ == 1) {
			_tmp16_ = TRUE;
		} else {
			gint _tmp18_ = 0;
			_tmp18_ = repetitions;
			_tmp16_ = _tmp18_ == 2;
		}
		_tmp19_ = _tmp16_;
		g_warn_if_fail (_tmp19_);
		_tmp21_ = repetitions;
		if (_tmp21_ == 1) {
			const gchar* _tmp22_ = NULL;
			_tmp22_ = _ ("It is the first time this board position has occurred");
			_tmp20_ = _tmp22_;
		} else {
			const gchar* _tmp23_ = NULL;
			_tmp23_ = _ ("It is the second time this board position has occurred");
			_tmp20_ = _tmp23_;
		}
		_tmp24_ = dialog;
		_tmp25_ = _tmp20_;
		_tmp26_ = g_strconcat ("• ", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, "\n", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, "• ", NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = moves;
		_tmp33_ = ngettext ("%d move has passed without a capture or pawn advancement", "%d moves have passed without a capture or pawn advancement", (gulong) _tmp32_);
		_tmp34_ = g_strconcat (_tmp31_, _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat (_tmp35_, "\n\n", NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = _ ("You can claim a draw when either:");
		_tmp39_ = g_strconcat (_tmp37_, _tmp38_, NULL);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strconcat (_tmp40_, "\n\n", NULL);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat (_tmp42_, "• ", NULL);
		_tmp44_ = _tmp43_;
		_tmp45_ = _ ("Any board position has occurred three times");
		_tmp46_ = g_strconcat (_tmp44_, _tmp45_, NULL);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strconcat (_tmp47_, "\n", NULL);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_strconcat (_tmp49_, "• ", NULL);
		_tmp51_ = _tmp50_;
		_tmp52_ = _ ("50 moves have passed without a capture or pawn advancement");
		_tmp53_ = g_strconcat (_tmp51_, _tmp52_, NULL);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strconcat (_tmp54_, "\n\n", NULL);
		_tmp56_ = _tmp55_;
		_tmp57_ = _ ("(Board position is affected by the ability to castle or capture en pas" \
"sant.)");
		_tmp58_ = g_strconcat (_tmp56_, _tmp57_, NULL);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_strconcat (_tmp59_, "\n\n", NULL);
		_tmp61_ = _tmp60_;
		_tmp62_ = _ ("The game is automatically a draw if:");
		_tmp63_ = g_strconcat (_tmp61_, _tmp62_, NULL);
		_tmp64_ = _tmp63_;
		_tmp65_ = g_strconcat (_tmp64_, "\n\n", NULL);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strconcat (_tmp66_, "• ", NULL);
		_tmp68_ = _tmp67_;
		_tmp69_ = _ ("The current player cannot move (stalemate)");
		_tmp70_ = g_strconcat (_tmp68_, _tmp69_, NULL);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strconcat (_tmp71_, "\n", NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strconcat (_tmp73_, "• ", NULL);
		_tmp75_ = _tmp74_;
		_tmp76_ = _ ("Neither player can checkmate (insufficient material)");
		_tmp77_ = g_strconcat (_tmp75_, _tmp76_, NULL);
		_tmp78_ = _tmp77_;
		_tmp79_ = moves;
		gtk_message_dialog_format_secondary_text (_tmp24_, _tmp78_, _tmp79_);
		_g_free0 (_tmp78_);
		_g_free0 (_tmp75_);
		_g_free0 (_tmp73_);
		_g_free0 (_tmp71_);
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		_g_free0 (_tmp64_);
		_g_free0 (_tmp61_);
		_g_free0 (_tmp59_);
		_g_free0 (_tmp56_);
		_g_free0 (_tmp54_);
		_g_free0 (_tmp51_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_tmp80_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp80_);
		_tmp81_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp81_);
		_g_object_unref0 (dialog);
	}
}


void G_MODULE_EXPORT undo_move_cb (GtkWidget* widget, Application* self) {
	ChessPlayer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->opponent;
	if (_tmp0_ != NULL) {
		ChessPlayer* _tmp1_ = NULL;
		_tmp1_ = self->priv->human_player;
		chess_player_undo (_tmp1_);
	} else {
		ChessGame* _tmp2_ = NULL;
		ChessPlayer* _tmp3_ = NULL;
		ChessPlayer* _tmp4_ = NULL;
		_tmp2_ = self->priv->game;
		_tmp3_ = chess_game_get_opponent (_tmp2_);
		_tmp4_ = _tmp3_;
		chess_player_undo (_tmp4_);
	}
}


static void application_stash_button_sensitivity (Application* self) {
	GtkWidget* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkWidget* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkWidget* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkWidget* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GtkWidget* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GtkWidget* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GtkWidget* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GtkComboBox* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_button;
	_tmp1_ = gtk_widget_get_sensitive (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_UNDO] = _tmp2_;
	_tmp3_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_UNDO];
	_tmp4_ = self->priv->claim_draw_button;
	_tmp5_ = gtk_widget_get_sensitive (_tmp4_);
	_tmp6_ = _tmp5_;
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW] = _tmp6_;
	_tmp7_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW];
	_tmp8_ = self->priv->resign_button;
	_tmp9_ = gtk_widget_get_sensitive (_tmp8_);
	_tmp10_ = _tmp9_;
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_RESIGN] = _tmp10_;
	_tmp11_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_RESIGN];
	_tmp12_ = self->priv->first_move_button;
	_tmp13_ = gtk_widget_get_sensitive (_tmp12_);
	_tmp14_ = _tmp13_;
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE] = _tmp14_;
	_tmp15_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE];
	_tmp16_ = self->priv->prev_move_button;
	_tmp17_ = gtk_widget_get_sensitive (_tmp16_);
	_tmp18_ = _tmp17_;
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_PREV_MOVE] = _tmp18_;
	_tmp19_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_PREV_MOVE];
	_tmp20_ = self->priv->next_move_button;
	_tmp21_ = gtk_widget_get_sensitive (_tmp20_);
	_tmp22_ = _tmp21_;
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE] = _tmp22_;
	_tmp23_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE];
	_tmp24_ = self->priv->last_move_button;
	_tmp25_ = gtk_widget_get_sensitive (_tmp24_);
	_tmp26_ = _tmp25_;
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_LAST_MOVE] = _tmp26_;
	_tmp27_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_LAST_MOVE];
	_tmp28_ = self->priv->history_combo;
	_tmp29_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp28_);
	_tmp30_ = _tmp29_;
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_HISTORY] = _tmp30_;
	_tmp31_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_HISTORY];
}


static void application_revert_button_sensitivity (Application* self) {
	GtkWidget* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkWidget* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkWidget* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkWidget* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GtkWidget* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GtkWidget* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GtkWidget* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GtkComboBox* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_button;
	_tmp1_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_UNDO];
	gtk_widget_set_sensitive (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->claim_draw_button;
	_tmp3_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW];
	gtk_widget_set_sensitive (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->resign_button;
	_tmp5_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_RESIGN];
	gtk_widget_set_sensitive (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->first_move_button;
	_tmp7_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE];
	gtk_widget_set_sensitive (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->prev_move_button;
	_tmp9_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_PREV_MOVE];
	gtk_widget_set_sensitive (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->next_move_button;
	_tmp11_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE];
	gtk_widget_set_sensitive (_tmp10_, _tmp11_);
	_tmp12_ = self->priv->last_move_button;
	_tmp13_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_LAST_MOVE];
	gtk_widget_set_sensitive (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->history_combo;
	_tmp15_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_HISTORY];
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, _tmp15_);
}


void G_MODULE_EXPORT pause_game_button_pressed_cb (GtkWidget* widget, Application* self) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkToolButton* tool_button = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkToolButton* _tmp6_ = NULL;
	ChessGame* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ChessGame* _tmp3_ = NULL;
		_tmp3_ = self->priv->game;
		chess_game_unpause (_tmp3_);
	} else {
		ChessGame* _tmp4_ = NULL;
		_tmp4_ = self->priv->game;
		chess_game_superpause (_tmp4_);
	}
	_tmp5_ = self->priv->pause_button;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
	tool_button = _tmp6_;
	_tmp7_ = self->priv->game;
	_tmp8_ = chess_game_get_is_paused (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		GtkToolButton* _tmp10_ = NULL;
		GtkToolButton* _tmp11_ = NULL;
		GtkWidget* _tmp12_ = NULL;
		GtkWidget* _tmp13_ = NULL;
		GtkWidget* _tmp14_ = NULL;
		GtkWidget* _tmp15_ = NULL;
		GtkWidget* _tmp16_ = NULL;
		GtkWidget* _tmp17_ = NULL;
		GtkWidget* _tmp18_ = NULL;
		GtkComboBox* _tmp19_ = NULL;
		_tmp10_ = tool_button;
		gtk_tool_button_set_stock_id (_tmp10_, "gtk-media-play");
		_tmp11_ = tool_button;
		gtk_tool_button_set_label (_tmp11_, "Start");
		application_stash_button_sensitivity (self);
		_tmp12_ = self->priv->undo_button;
		gtk_widget_set_sensitive (_tmp12_, FALSE);
		_tmp13_ = self->priv->claim_draw_button;
		gtk_widget_set_sensitive (_tmp13_, FALSE);
		_tmp14_ = self->priv->resign_button;
		gtk_widget_set_sensitive (_tmp14_, FALSE);
		_tmp15_ = self->priv->first_move_button;
		gtk_widget_set_sensitive (_tmp15_, FALSE);
		_tmp16_ = self->priv->prev_move_button;
		gtk_widget_set_sensitive (_tmp16_, FALSE);
		_tmp17_ = self->priv->next_move_button;
		gtk_widget_set_sensitive (_tmp17_, FALSE);
		_tmp18_ = self->priv->last_move_button;
		gtk_widget_set_sensitive (_tmp18_, FALSE);
		_tmp19_ = self->priv->history_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
	} else {
		GtkToolButton* _tmp20_ = NULL;
		GtkToolButton* _tmp21_ = NULL;
		_tmp20_ = tool_button;
		gtk_tool_button_set_stock_id (_tmp20_, "gtk-media-pause");
		_tmp21_ = tool_button;
		gtk_tool_button_set_label (_tmp21_, "Pause");
		application_revert_button_sensitivity (self);
	}
	_g_object_unref0 (tool_button);
}


void application_quit_cb (Application* self) {
	g_return_if_fail (self != NULL);
	application_quit_game (self);
}


gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3] = {0};
	gdouble bg[3] = {0};
	gdouble _tmp1_[3] = {0};
	GtkWidget* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessClock* _tmp5_ = NULL;
	ChessClock* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_[0] = 0.0;
	_tmp0_[1] = 0.0;
	_tmp0_[2] = 0.0;
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
	_tmp1_[0] = 1.0;
	_tmp1_[1] = 1.0;
	_tmp1_[2] = 1.0;
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
	_tmp2_ = widget;
	_tmp3_ = c;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_clock (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = application_make_clock_text (self, _tmp6_, COLOR_WHITE);
	_tmp8_ = _tmp7_;
	application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
	_g_free0 (_tmp8_);
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3] = {0};
	gdouble bg[3] = {0};
	gdouble _tmp1_[3] = {0};
	GtkWidget* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessClock* _tmp5_ = NULL;
	ChessClock* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_[0] = 1.0;
	_tmp0_[1] = 1.0;
	_tmp0_[2] = 1.0;
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
	_tmp1_[0] = 0.0;
	_tmp1_[1] = 0.0;
	_tmp1_[2] = 0.0;
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
	_tmp2_ = widget;
	_tmp3_ = c;
	_tmp4_ = self->priv->game;
	_tmp5_ = chess_game_get_clock (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = application_make_clock_text (self, _tmp6_, COLOR_BLACK);
	_tmp8_ = _tmp7_;
	application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
	_g_free0 (_tmp8_);
	result = FALSE;
	return result;
}


static gchar* application_make_clock_text (Application* self, ChessClock* clock, Color color) {
	gchar* result = NULL;
	ChessClock* _tmp0_ = NULL;
	gint used = 0;
	Color _tmp2_ = 0;
	gint _tmp23_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clock;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("∞");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = color;
	if (_tmp2_ == COLOR_WHITE) {
		ChessGame* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
		ChessClock* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		guint _tmp7_ = 0U;
		ChessGame* _tmp8_ = NULL;
		ChessClock* _tmp9_ = NULL;
		ChessClock* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
		_tmp3_ = self->priv->game;
		_tmp4_ = chess_game_get_clock (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = chess_clock_get_white_initial_seconds (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->game;
		_tmp9_ = chess_game_get_clock (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = chess_clock_get_white_seconds_used (_tmp10_);
		_tmp12_ = _tmp11_;
		used = (gint) (_tmp7_ - _tmp12_);
	} else {
		ChessGame* _tmp13_ = NULL;
		ChessClock* _tmp14_ = NULL;
		ChessClock* _tmp15_ = NULL;
		guint _tmp16_ = 0U;
		guint _tmp17_ = 0U;
		ChessGame* _tmp18_ = NULL;
		ChessClock* _tmp19_ = NULL;
		ChessClock* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		guint _tmp22_ = 0U;
		_tmp13_ = self->priv->game;
		_tmp14_ = chess_game_get_clock (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = chess_clock_get_black_initial_seconds (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->game;
		_tmp19_ = chess_game_get_clock (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = chess_clock_get_black_seconds_used (_tmp20_);
		_tmp22_ = _tmp21_;
		used = (gint) (_tmp17_ - _tmp22_);
	}
	_tmp23_ = used;
	if (_tmp23_ >= 60) {
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gchar* _tmp26_ = NULL;
		_tmp24_ = used;
		_tmp25_ = used;
		_tmp26_ = g_strdup_printf ("%d:%02d", _tmp24_ / 60, _tmp25_ % 60);
		result = _tmp26_;
		return result;
	} else {
		gint _tmp27_ = 0;
		gchar* _tmp28_ = NULL;
		_tmp27_ = used;
		_tmp28_ = g_strdup_printf (":%02d", _tmp27_);
		result = _tmp28_;
		return result;
	}
}


static void application_draw_time (Application* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1) {
	gdouble alpha = 0.0;
	GtkWidget* _tmp0_ = NULL;
	GtkStateType _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	gdouble* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gdouble _tmp4_ = 0.0;
	gdouble* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gdouble _tmp6_ = 0.0;
	gdouble* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	gdouble* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gdouble _tmp13_ = 0.0;
	gdouble* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gdouble _tmp15_ = 0.0;
	gdouble* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	cairo_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	GtkWidget* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	cairo_text_extents_t _tmp25_ = {0};
	cairo_t* _tmp26_ = NULL;
	GtkWidget* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	cairo_text_extents_t _tmp29_ = {0};
	gdouble _tmp30_ = 0.0;
	cairo_text_extents_t _tmp31_ = {0};
	gdouble _tmp32_ = 0.0;
	GtkWidget* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	cairo_text_extents_t _tmp35_ = {0};
	gdouble _tmp36_ = 0.0;
	cairo_text_extents_t _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	cairo_t* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GtkWidget* _tmp41_ = NULL;
	cairo_text_extents_t _tmp42_ = {0};
	gdouble _tmp43_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (text != NULL);
	alpha = 1.0;
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_state (_tmp0_);
	if (_tmp1_ == GTK_STATE_INSENSITIVE) {
		alpha = 0.5;
	}
	_tmp2_ = c;
	_tmp3_ = bg;
	_tmp3__length1 = bg_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = bg;
	_tmp5__length1 = bg_length1;
	_tmp6_ = _tmp5_[1];
	_tmp7_ = bg;
	_tmp7__length1 = bg_length1;
	_tmp8_ = _tmp7_[2];
	_tmp9_ = alpha;
	cairo_set_source_rgba (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_);
	_tmp10_ = c;
	cairo_paint (_tmp10_);
	_tmp11_ = c;
	_tmp12_ = fg;
	_tmp12__length1 = fg_length1;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = fg;
	_tmp14__length1 = fg_length1;
	_tmp15_ = _tmp14_[1];
	_tmp16_ = fg;
	_tmp16__length1 = fg_length1;
	_tmp17_ = _tmp16_[2];
	_tmp18_ = alpha;
	cairo_set_source_rgba (_tmp11_, _tmp13_, _tmp15_, _tmp17_, _tmp18_);
	_tmp19_ = c;
	cairo_select_font_face (_tmp19_, "fixed", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	_tmp20_ = c;
	_tmp21_ = widget;
	_tmp22_ = gtk_widget_get_allocated_height (_tmp21_);
	cairo_set_font_size (_tmp20_, 0.6 * _tmp22_);
	_tmp23_ = c;
	_tmp24_ = text;
	cairo_text_extents (_tmp23_, _tmp24_, &_tmp25_);
	extents = _tmp25_;
	_tmp26_ = c;
	_tmp27_ = widget;
	_tmp28_ = gtk_widget_get_allocated_width (_tmp27_);
	_tmp29_ = extents;
	_tmp30_ = _tmp29_.width;
	_tmp31_ = extents;
	_tmp32_ = _tmp31_.x_bearing;
	_tmp33_ = widget;
	_tmp34_ = gtk_widget_get_allocated_height (_tmp33_);
	_tmp35_ = extents;
	_tmp36_ = _tmp35_.height;
	_tmp37_ = extents;
	_tmp38_ = _tmp37_.y_bearing;
	cairo_move_to (_tmp26_, ((_tmp28_ - _tmp30_) / 2) - _tmp32_, ((_tmp34_ - _tmp36_) / 2) - _tmp38_);
	_tmp39_ = c;
	_tmp40_ = text;
	cairo_show_text (_tmp39_, _tmp40_);
	_tmp41_ = widget;
	_tmp42_ = extents;
	_tmp43_ = _tmp42_.width;
	gtk_widget_set_size_request (_tmp41_, ((gint) _tmp43_) + 6, -1);
}


void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint move_number = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_ = NULL;
	gboolean _tmp13_ = FALSE;
	ChessScene* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &move_number, -1, -1);
	_tmp8_ = self->priv->game;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		gint _tmp9_ = 0;
		ChessGame* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
		_tmp9_ = move_number;
		_tmp10_ = self->priv->game;
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp7_ = ((guint) _tmp9_) == _tmp12_;
	}
	_tmp13_ = _tmp7_;
	if (_tmp13_) {
		move_number = -1;
	}
	_tmp14_ = self->priv->scene;
	_tmp15_ = move_number;
	chess_scene_set_move_number (_tmp14_, _tmp15_);
}


void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	chess_scene_set_move_number (_tmp0_, -1);
}


void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint move_number = 0;
	ChessScene* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	ChessGame* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = self->priv->scene;
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
	_tmp5_ = _tmp4_;
	move_number = _tmp5_ + 1;
	_tmp6_ = move_number;
	_tmp7_ = self->priv->game;
	_tmp8_ = chess_game_get_n_moves (_tmp7_);
	_tmp9_ = _tmp8_;
	if (((guint) _tmp6_) >= _tmp9_) {
		ChessScene* _tmp10_ = NULL;
		_tmp10_ = self->priv->scene;
		chess_scene_set_move_number (_tmp10_, -1);
	} else {
		ChessScene* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp11_ = self->priv->scene;
		_tmp12_ = move_number;
		chess_scene_set_move_number (_tmp11_, _tmp12_);
	}
}


void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ChessScene* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = self->priv->scene;
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == (-1)) {
		ChessScene* _tmp6_ = NULL;
		ChessGame* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		_tmp6_ = self->priv->scene;
		_tmp7_ = self->priv->game;
		_tmp8_ = chess_game_get_n_moves (_tmp7_);
		_tmp9_ = _tmp8_;
		chess_scene_set_move_number (_tmp6_, ((gint) _tmp9_) - 1);
	} else {
		ChessScene* _tmp10_ = NULL;
		ChessScene* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp10_ = self->priv->scene;
		_tmp11_ = self->priv->scene;
		_tmp12_ = chess_scene_get_move_number (_tmp11_);
		_tmp13_ = _tmp12_;
		chess_scene_set_move_number (_tmp10_, _tmp13_ - 1);
	}
}


void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scene;
	chess_scene_set_move_number (_tmp0_, 0);
}


void G_MODULE_EXPORT toggle_fullscreen_cb (GtkWidget* widget, Application* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->is_fullscreen;
	if (_tmp0_) {
		GtkWidget* _tmp1_ = NULL;
		GtkWindow* _tmp2_ = NULL;
		_tmp1_ = self->priv->fullscreen_button;
		gtk_tool_button_set_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_TOOL_BUTTON, GtkToolButton), "gtk-fullscreen");
		_tmp2_ = self->priv->window;
		gtk_window_unfullscreen (_tmp2_);
	} else {
		GtkWidget* _tmp3_ = NULL;
		GtkWindow* _tmp4_ = NULL;
		_tmp3_ = self->priv->fullscreen_button;
		gtk_tool_button_set_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GTK_TYPE_TOOL_BUTTON, GtkToolButton), "gtk-leave-fullscreen");
		_tmp4_ = self->priv->window;
		gtk_window_fullscreen (_tmp4_);
	}
}


void application_preferences_cb (Application* self) {
	GtkDialog* _tmp0_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkDialog* _tmp11_ = NULL;
	GtkWindow* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GSettings* _tmp16_ = NULL;
	GtkBuilder* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	GSettings* _tmp19_ = NULL;
	GtkBuilder* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	GSettings* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkBuilder* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GtkComboBox* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	GSettings* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	GtkComboBox* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	GtkComboBox* ai_combo = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	GtkComboBox* _tmp35_ = NULL;
	GtkListStore* ai_model = NULL;
	GtkComboBox* _tmp36_ = NULL;
	GtkTreeModel* _tmp37_ = NULL;
	GtkTreeModel* _tmp38_ = NULL;
	GtkListStore* _tmp39_ = NULL;
	gchar* opponent_name = NULL;
	GSettings* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GList* _tmp44_ = NULL;
	GtkComboBox* _tmp69_ = NULL;
	gint _tmp70_ = 0;
	GtkBuilder* _tmp73_ = NULL;
	GObject* _tmp74_ = NULL;
	GtkComboBox* _tmp75_ = NULL;
	GtkComboBox* _tmp76_ = NULL;
	GSettings* _tmp77_ = NULL;
	gchar* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	GtkBuilder* _tmp80_ = NULL;
	GObject* _tmp81_ = NULL;
	GtkComboBox* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	GObject* _tmp84_ = NULL;
	GtkAdjustment* _tmp85_ = NULL;
	GtkBuilder* _tmp86_ = NULL;
	GObject* _tmp87_ = NULL;
	GtkContainer* _tmp88_ = NULL;
	GtkBuilder* _tmp89_ = NULL;
	GObject* _tmp90_ = NULL;
	GtkComboBox* _tmp91_ = NULL;
	GSettings* _tmp92_ = NULL;
	gint _tmp93_ = 0;
	GtkComboBox* orientation_combo = NULL;
	GtkBuilder* _tmp94_ = NULL;
	GObject* _tmp95_ = NULL;
	GtkComboBox* _tmp96_ = NULL;
	GtkComboBox* _tmp97_ = NULL;
	GSettings* _tmp98_ = NULL;
	gchar* _tmp99_ = NULL;
	gchar* _tmp100_ = NULL;
	GtkComboBox* move_combo = NULL;
	GtkBuilder* _tmp101_ = NULL;
	GObject* _tmp102_ = NULL;
	GtkComboBox* _tmp103_ = NULL;
	GtkComboBox* _tmp104_ = NULL;
	GSettings* _tmp105_ = NULL;
	gchar* _tmp106_ = NULL;
	gchar* _tmp107_ = NULL;
	GtkCheckButton* show_3d_check = NULL;
	GtkBuilder* _tmp108_ = NULL;
	GObject* _tmp109_ = NULL;
	GtkCheckButton* _tmp110_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkBuilder* _tmp111_ = NULL;
	GObject* _tmp112_ = NULL;
	GtkComboBox* _tmp113_ = NULL;
	GtkComboBox* _tmp114_ = NULL;
	GSettings* _tmp115_ = NULL;
	gchar* _tmp116_ = NULL;
	gchar* _tmp117_ = NULL;
	GtkComboBox* _tmp118_ = NULL;
	GtkCheckButton* _tmp119_ = NULL;
	gboolean _tmp120_ = FALSE;
	gboolean _tmp121_ = FALSE;
	GtkCheckButton* show_3d_smooth_check = NULL;
	GtkBuilder* _tmp122_ = NULL;
	GObject* _tmp123_ = NULL;
	GtkCheckButton* _tmp124_ = NULL;
	GtkCheckButton* _tmp125_ = NULL;
	GtkCheckButton* _tmp126_ = NULL;
	gboolean _tmp127_ = FALSE;
	gboolean _tmp128_ = FALSE;
	GtkBuilder* _tmp129_ = NULL;
	GtkComboBox* _tmp130_ = NULL;
	gint _tmp131_ = 0;
	GtkDialog* _tmp134_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ != NULL) {
		GtkDialog* _tmp1_ = NULL;
		_tmp1_ = self->priv->preferences_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->preferences_builder);
	self->priv->preferences_builder = _tmp2_;
	{
		GtkBuilder* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp3_ = self->priv->preferences_builder;
		_tmp4_ = g_build_filename (PKGDATADIR, "preferences.ui", NULL, NULL);
		_tmp5_ = _tmp4_;
		gtk_builder_add_from_file (_tmp3_, _tmp5_, &_inner_error_);
		_g_free0 (_tmp5_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("gnome-chess.vala:1477: Could not load preferences UI: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = self->priv->preferences_builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "preferences");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_DIALOG, GtkDialog));
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp10_;
	_tmp11_ = self->priv->preferences_dialog;
	_tmp12_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp11_, _tmp12_);
	_tmp13_ = self->priv->settings;
	_tmp14_ = self->priv->preferences_builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "show_numbering_check");
	g_settings_bind (_tmp13_, "show-numbering", _tmp15_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = self->priv->settings;
	_tmp17_ = self->priv->preferences_builder;
	_tmp18_ = gtk_builder_get_object (_tmp17_, "show_move_hints_check");
	g_settings_bind (_tmp16_, "show-move-hints", _tmp18_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp19_ = self->priv->settings;
	_tmp20_ = self->priv->preferences_builder;
	_tmp21_ = gtk_builder_get_object (_tmp20_, "show_3d_check");
	g_settings_bind (_tmp19_, "show-3d", _tmp21_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp22_ = self->priv->settings;
	_tmp23_ = self->priv->preferences_builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "show_3d_smooth_check");
	g_settings_bind (_tmp22_, "show-3d-smooth", _tmp24_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp25_ = self->priv->preferences_builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "side_combo");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	_g_object_unref0 (self->priv->side_combo);
	self->priv->side_combo = _tmp27_;
	_tmp29_ = self->priv->settings;
	_tmp30_ = g_settings_get_boolean (_tmp29_, "play-as-white");
	if (_tmp30_) {
		_tmp28_ = 0;
	} else {
		_tmp28_ = 1;
	}
	_tmp31_ = self->priv->side_combo;
	_tmp32_ = _tmp28_;
	gtk_combo_box_set_active (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->preferences_builder;
	_tmp34_ = gtk_builder_get_object (_tmp33_, "opponent_combo");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	ai_combo = _tmp35_;
	_tmp36_ = ai_combo;
	_tmp37_ = gtk_combo_box_get_model (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GTK_TYPE_LIST_STORE, GtkListStore));
	ai_model = _tmp39_;
	_tmp40_ = self->priv->settings;
	_tmp41_ = g_settings_get_string (_tmp40_, "opponent");
	opponent_name = _tmp41_;
	_tmp42_ = opponent_name;
	if (g_strcmp0 (_tmp42_, "human") == 0) {
		GtkComboBox* _tmp43_ = NULL;
		_tmp43_ = ai_combo;
		gtk_combo_box_set_active (_tmp43_, 0);
	}
	_tmp44_ = self->priv->ai_profiles;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp44_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			AIProfile* _tmp45_ = NULL;
			AIProfile* p = NULL;
			_tmp45_ = _ai_profile_ref0 ((AIProfile*) p_it->data);
			p = _tmp45_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp46_ = NULL;
				GtkTreeIter _tmp47_ = {0};
				GtkListStore* _tmp48_ = NULL;
				GtkTreeIter _tmp49_ = {0};
				AIProfile* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				const gchar* _tmp52_ = NULL;
				AIProfile* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				gboolean _tmp56_ = FALSE;
				AIProfile* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				const gchar* _tmp59_ = NULL;
				const gchar* _tmp60_ = NULL;
				gboolean _tmp66_ = FALSE;
				_tmp46_ = ai_model;
				gtk_list_store_append (_tmp46_, &_tmp47_);
				iter = _tmp47_;
				_tmp48_ = ai_model;
				_tmp49_ = iter;
				_tmp50_ = p;
				_tmp51_ = ai_profile_get_name (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = p;
				_tmp54_ = ai_profile_get_name (_tmp53_);
				_tmp55_ = _tmp54_;
				gtk_list_store_set (_tmp48_, &_tmp49_, 0, _tmp52_, 1, _tmp55_, -1, -1);
				_tmp57_ = p;
				_tmp58_ = ai_profile_get_name (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = opponent_name;
				if (g_strcmp0 (_tmp59_, _tmp60_) == 0) {
					_tmp56_ = TRUE;
				} else {
					gboolean _tmp61_ = FALSE;
					const gchar* _tmp62_ = NULL;
					gboolean _tmp65_ = FALSE;
					_tmp62_ = opponent_name;
					if (g_strcmp0 (_tmp62_, "") == 0) {
						GtkComboBox* _tmp63_ = NULL;
						gint _tmp64_ = 0;
						_tmp63_ = ai_combo;
						_tmp64_ = gtk_combo_box_get_active (_tmp63_);
						_tmp61_ = _tmp64_ == (-1);
					} else {
						_tmp61_ = FALSE;
					}
					_tmp65_ = _tmp61_;
					_tmp56_ = _tmp65_;
				}
				_tmp66_ = _tmp56_;
				if (_tmp66_) {
					GtkComboBox* _tmp67_ = NULL;
					GtkTreeIter _tmp68_ = {0};
					_tmp67_ = ai_combo;
					_tmp68_ = iter;
					gtk_combo_box_set_active_iter (_tmp67_, &_tmp68_);
				}
				_ai_profile_unref0 (p);
			}
		}
	}
	_tmp69_ = ai_combo;
	_tmp70_ = gtk_combo_box_get_active (_tmp69_);
	if (_tmp70_ == (-1)) {
		GtkComboBox* _tmp71_ = NULL;
		GSettings* _tmp72_ = NULL;
		_tmp71_ = ai_combo;
		gtk_combo_box_set_active (_tmp71_, 0);
		_tmp72_ = self->priv->settings;
		g_settings_set_string (_tmp72_, "opponent", "human");
	}
	_tmp73_ = self->priv->preferences_builder;
	_tmp74_ = gtk_builder_get_object (_tmp73_, "difficulty_combo");
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	_g_object_unref0 (self->priv->difficulty_combo);
	self->priv->difficulty_combo = _tmp75_;
	_tmp76_ = self->priv->difficulty_combo;
	_tmp77_ = self->priv->settings;
	_tmp78_ = g_settings_get_string (_tmp77_, "difficulty");
	_tmp79_ = _tmp78_;
	application_set_combo (self, _tmp76_, 1, _tmp79_);
	_g_free0 (_tmp79_);
	_tmp80_ = self->priv->preferences_builder;
	_tmp81_ = gtk_builder_get_object (_tmp80_, "duration_combo");
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	_g_object_unref0 (self->priv->duration_combo);
	self->priv->duration_combo = _tmp82_;
	_tmp83_ = self->priv->preferences_builder;
	_tmp84_ = gtk_builder_get_object (_tmp83_, "duration_adjustment");
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
	_g_object_unref0 (self->priv->duration_adjustment);
	self->priv->duration_adjustment = _tmp85_;
	_tmp86_ = self->priv->preferences_builder;
	_tmp87_ = gtk_builder_get_object (_tmp86_, "custom_duration_box");
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, GTK_TYPE_CONTAINER, GtkContainer));
	_g_object_unref0 (self->priv->custom_duration_box);
	self->priv->custom_duration_box = _tmp88_;
	_tmp89_ = self->priv->preferences_builder;
	_tmp90_ = gtk_builder_get_object (_tmp89_, "custom_duration_units_combo");
	_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	_g_object_unref0 (self->priv->custom_duration_units_combo);
	self->priv->custom_duration_units_combo = _tmp91_;
	_tmp92_ = self->priv->settings;
	_tmp93_ = g_settings_get_int (_tmp92_, "duration");
	application_set_duration (self, _tmp93_, TRUE);
	_tmp94_ = self->priv->preferences_builder;
	_tmp95_ = gtk_builder_get_object (_tmp94_, "orientation_combo");
	_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	orientation_combo = _tmp96_;
	_tmp97_ = orientation_combo;
	_tmp98_ = self->priv->settings;
	_tmp99_ = g_settings_get_string (_tmp98_, "board-side");
	_tmp100_ = _tmp99_;
	application_set_combo (self, _tmp97_, 1, _tmp100_);
	_g_free0 (_tmp100_);
	_tmp101_ = self->priv->preferences_builder;
	_tmp102_ = gtk_builder_get_object (_tmp101_, "move_format_combo");
	_tmp103_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	move_combo = _tmp103_;
	_tmp104_ = move_combo;
	_tmp105_ = self->priv->settings;
	_tmp106_ = g_settings_get_string (_tmp105_, "move-format");
	_tmp107_ = _tmp106_;
	application_set_combo (self, _tmp104_, 1, _tmp107_);
	_g_free0 (_tmp107_);
	_tmp108_ = self->priv->preferences_builder;
	_tmp109_ = gtk_builder_get_object (_tmp108_, "show_3d_check");
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, GTK_TYPE_CHECK_BUTTON, GtkCheckButton));
	show_3d_check = _tmp110_;
	_tmp111_ = self->priv->preferences_builder;
	_tmp112_ = gtk_builder_get_object (_tmp111_, "piece_style_combo");
	_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	theme_combo = _tmp113_;
	_tmp114_ = theme_combo;
	_tmp115_ = self->priv->settings;
	_tmp116_ = g_settings_get_string (_tmp115_, "piece-theme");
	_tmp117_ = _tmp116_;
	application_set_combo (self, _tmp114_, 1, _tmp117_);
	_g_free0 (_tmp117_);
	_tmp118_ = theme_combo;
	_tmp119_ = show_3d_check;
	_tmp120_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp119_);
	_tmp121_ = _tmp120_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp118_, !_tmp121_);
	_tmp122_ = self->priv->preferences_builder;
	_tmp123_ = gtk_builder_get_object (_tmp122_, "show_3d_smooth_check");
	_tmp124_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, GTK_TYPE_CHECK_BUTTON, GtkCheckButton));
	show_3d_smooth_check = _tmp124_;
	_tmp125_ = show_3d_smooth_check;
	_tmp126_ = show_3d_check;
	_tmp127_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp126_);
	_tmp128_ = _tmp127_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp125_, _tmp128_);
	_tmp129_ = self->priv->preferences_builder;
	gtk_builder_connect_signals (_tmp129_, self);
	_tmp130_ = ai_combo;
	_tmp131_ = gtk_combo_box_get_active (_tmp130_);
	if (_tmp131_ == 0) {
		GtkComboBox* _tmp132_ = NULL;
		GtkComboBox* _tmp133_ = NULL;
		_tmp132_ = self->priv->side_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp132_, FALSE);
		_tmp133_ = self->priv->difficulty_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp133_, FALSE);
	}
	_tmp134_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp134_);
	_g_object_unref0 (show_3d_smooth_check);
	_g_object_unref0 (theme_combo);
	_g_object_unref0 (show_3d_check);
	_g_object_unref0 (move_combo);
	_g_object_unref0 (orientation_combo);
	_g_free0 (opponent_name);
	_g_object_unref0 (ai_model);
	_g_object_unref0 (ai_combo);
}


static void application_set_combo (Application* self, GtkComboBox* combo, gint value_index, const gchar* value) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first (_tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (!_tmp6_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp7_ = FALSE;
		_tmp7_ = TRUE;
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			gchar* v = NULL;
			GtkTreeModel* _tmp11_ = NULL;
			GtkTreeIter _tmp12_ = {0};
			gint _tmp13_ = 0;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp8_ = _tmp7_;
			if (!_tmp8_) {
				GtkTreeModel* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp9_ = model;
				_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
				if (!_tmp10_) {
					break;
				}
			}
			_tmp7_ = FALSE;
			_tmp11_ = model;
			_tmp12_ = iter;
			_tmp13_ = value_index;
			gtk_tree_model_get (_tmp11_, &_tmp12_, _tmp13_, &v, -1, -1);
			_tmp14_ = v;
			_tmp15_ = value;
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
				GtkComboBox* _tmp16_ = NULL;
				GtkTreeIter _tmp17_ = {0};
				_tmp16_ = combo;
				_tmp17_ = iter;
				gtk_combo_box_set_active_iter (_tmp16_, &_tmp17_);
				_g_free0 (v);
				_g_object_unref0 (model);
				return;
			}
			_g_free0 (v);
		}
	}
	_g_object_unref0 (model);
}


static gchar* application_get_combo (Application* self, GtkComboBox* combo, gint value_index) {
	gchar* result = NULL;
	gchar* value = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gint _tmp7_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (combo != NULL, NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_g_free0 (value);
		return result;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	_tmp7_ = value_index;
	gtk_tree_model_get (_tmp5_, &_tmp6_, _tmp7_, &value, -1, -1);
	result = value;
	return result;
}


void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean play_as_white = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &play_as_white, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = play_as_white;
	g_settings_set_boolean (_tmp7_, "play-as-white", _tmp8_);
}


void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* opponent = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean vs_human = FALSE;
	GtkComboBox* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkComboBox* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GtkComboBox* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &opponent, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = opponent;
	g_settings_set_string (_tmp7_, "opponent", _tmp8_);
	_tmp9_ = combo;
	_tmp10_ = gtk_combo_box_get_active (_tmp9_);
	vs_human = _tmp10_ == 0;
	_tmp11_ = self->priv->side_combo;
	_tmp12_ = vs_human;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, !_tmp12_);
	_tmp13_ = self->priv->difficulty_combo;
	_tmp14_ = vs_human;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, !_tmp14_);
	_g_free0 (opponent);
}


void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* difficulty = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &difficulty, -1, -1);
	_tmp7_ = self->priv->settings;
	_tmp8_ = difficulty;
	g_settings_set_string (_tmp7_, "difficulty", _tmp8_);
	_g_free0 (difficulty);
}


static void application_set_duration (Application* self, gint duration, gboolean simplify) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter max_iter = {0};
	GtkTreeIter _tmp4_ = {0};
	gint max_multiplier = 0;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	gint value = 0;
	gint _tmp22_ = 0;
	gboolean _tmp29_ = FALSE;
	GtkComboBox* _tmp30_ = NULL;
	GtkTreeModel* _tmp31_ = NULL;
	GtkTreeModel* _tmp32_ = NULL;
	GtkTreeModel* _tmp33_ = NULL;
	GtkTreeModel* _tmp34_ = NULL;
	GtkTreeIter _tmp35_ = {0};
	gboolean _tmp36_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->custom_duration_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	max_iter = _tmp4_;
	max_multiplier = 0;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (_tmp7_) {
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_ = FALSE;
				gint multiplier = 0;
				GtkTreeModel* _tmp12_ = NULL;
				GtkTreeIter _tmp13_ = {0};
				gboolean _tmp14_ = FALSE;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gboolean _tmp19_ = FALSE;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					GtkTreeModel* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					_tmp10_ = model;
					_tmp11_ = gtk_tree_model_iter_next (_tmp10_, &iter);
					if (!_tmp11_) {
						break;
					}
				}
				_tmp8_ = FALSE;
				_tmp12_ = model;
				_tmp13_ = iter;
				gtk_tree_model_get (_tmp12_, &_tmp13_, 1, &multiplier, -1, -1);
				_tmp15_ = multiplier;
				_tmp16_ = max_multiplier;
				if (_tmp15_ > _tmp16_) {
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					_tmp17_ = duration;
					_tmp18_ = multiplier;
					_tmp14_ = (_tmp17_ % _tmp18_) == 0;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp19_ = _tmp14_;
				if (_tmp19_) {
					gint _tmp20_ = 0;
					GtkTreeIter _tmp21_ = {0};
					_tmp20_ = multiplier;
					max_multiplier = _tmp20_;
					_tmp21_ = iter;
					max_iter = _tmp21_;
				}
			}
		}
	}
	value = 0;
	_tmp22_ = max_multiplier;
	if (_tmp22_ > 0) {
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		GtkAdjustment* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		GtkComboBox* _tmp27_ = NULL;
		GtkTreeIter _tmp28_ = {0};
		_tmp23_ = duration;
		_tmp24_ = max_multiplier;
		value = _tmp23_ / _tmp24_;
		_tmp25_ = self->priv->duration_adjustment;
		_tmp26_ = value;
		gtk_adjustment_set_value (_tmp25_, (gdouble) _tmp26_);
		_tmp27_ = self->priv->custom_duration_units_combo;
		_tmp28_ = max_iter;
		gtk_combo_box_set_active_iter (_tmp27_, &_tmp28_);
	}
	_tmp29_ = simplify;
	if (!_tmp29_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp30_ = self->priv->duration_combo;
	_tmp31_ = gtk_combo_box_get_model (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _g_object_ref0 (_tmp32_);
	_g_object_unref0 (model);
	model = _tmp33_;
	_tmp34_ = model;
	_tmp36_ = gtk_tree_model_get_iter_first (_tmp34_, &_tmp35_);
	iter = _tmp35_;
	if (!_tmp36_) {
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp37_ = FALSE;
		_tmp37_ = TRUE;
		while (TRUE) {
			gboolean _tmp38_ = FALSE;
			gint v = 0;
			GtkTreeModel* _tmp41_ = NULL;
			GtkTreeIter _tmp42_ = {0};
			gboolean _tmp43_ = FALSE;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gboolean _tmp47_ = FALSE;
			_tmp38_ = _tmp37_;
			if (!_tmp38_) {
				GtkTreeModel* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
				_tmp39_ = model;
				_tmp40_ = gtk_tree_model_iter_next (_tmp39_, &iter);
				if (!_tmp40_) {
					break;
				}
			}
			_tmp37_ = FALSE;
			_tmp41_ = model;
			_tmp42_ = iter;
			gtk_tree_model_get (_tmp41_, &_tmp42_, 1, &v, -1, -1);
			_tmp44_ = v;
			_tmp45_ = duration;
			if (_tmp44_ == _tmp45_) {
				_tmp43_ = TRUE;
			} else {
				gint _tmp46_ = 0;
				_tmp46_ = v;
				_tmp43_ = _tmp46_ == (-1);
			}
			_tmp47_ = _tmp43_;
			if (_tmp47_) {
				GtkComboBox* _tmp48_ = NULL;
				GtkTreeIter _tmp49_ = {0};
				GtkContainer* _tmp50_ = NULL;
				gint _tmp51_ = 0;
				_tmp48_ = self->priv->duration_combo;
				_tmp49_ = iter;
				gtk_combo_box_set_active_iter (_tmp48_, &_tmp49_);
				_tmp50_ = self->priv->custom_duration_box;
				_tmp51_ = v;
				gtk_widget_set_visible ((GtkWidget*) _tmp50_, _tmp51_ == (-1));
				_g_object_unref0 (model);
				return;
			}
		}
	}
	_g_object_unref0 (model);
}


static gint application_get_duration (Application* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint magnitude = 0;
	GtkAdjustment* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gint multiplier = 0;
	GtkComboBox* _tmp11_ = NULL;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->duration_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gint duration = 0;
		GtkComboBox* _tmp3_ = NULL;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		gint _tmp7_ = 0;
		_tmp3_ = self->priv->duration_combo;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = iter;
		gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
		_tmp7_ = duration;
		if (_tmp7_ >= 0) {
			result = duration;
			return result;
		}
	}
	_tmp8_ = self->priv->duration_adjustment;
	_tmp9_ = gtk_adjustment_get_value (_tmp8_);
	_tmp10_ = _tmp9_;
	magnitude = (gint) _tmp10_;
	multiplier = 1;
	_tmp11_ = self->priv->custom_duration_units_combo;
	_tmp13_ = gtk_combo_box_get_active_iter (_tmp11_, &_tmp12_);
	iter = _tmp12_;
	if (_tmp13_) {
		GtkComboBox* _tmp14_ = NULL;
		GtkTreeModel* _tmp15_ = NULL;
		GtkTreeModel* _tmp16_ = NULL;
		GtkTreeIter _tmp17_ = {0};
		_tmp14_ = self->priv->custom_duration_units_combo;
		_tmp15_ = gtk_combo_box_get_model (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = iter;
		gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
	}
	_tmp18_ = magnitude;
	_tmp19_ = multiplier;
	result = _tmp18_ * _tmp19_;
	return result;
}


static gboolean application_save_duration_cb (Application* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = application_get_duration (self);
	g_settings_set_int (_tmp0_, "duration", _tmp1_);
	_tmp2_ = self->priv->save_duration_timeout;
	g_source_remove (_tmp2_);
	self->priv->save_duration_timeout = (guint) 0;
	result = FALSE;
	return result;
}


void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, Application* self) {
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->custom_duration_units_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_LIST_STORE, GtkListStore));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
	iter = _tmp5_;
	if (_tmp6_) {
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_ = FALSE;
				gint multiplier = 0;
				GtkListStore* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
				gint _tmp13_ = 0;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					GtkListStore* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = model;
					_tmp10_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp9_, &iter);
					if (!_tmp10_) {
						break;
					}
				}
				_tmp7_ = FALSE;
				_tmp11_ = model;
				_tmp12_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp11_, &_tmp12_, 1, &multiplier, -1, -1);
				_tmp13_ = multiplier;
				switch (_tmp13_) {
					case 1:
					{
						GtkListStore* _tmp14_ = NULL;
						GtkTreeIter _tmp15_ = {0};
						GtkAdjustment* _tmp16_ = NULL;
						gdouble _tmp17_ = 0.0;
						gdouble _tmp18_ = 0.0;
						const gchar* _tmp19_ = NULL;
						_tmp14_ = model;
						_tmp15_ = iter;
						_tmp16_ = adjustment;
						_tmp17_ = gtk_adjustment_get_value (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp19_ = ngettext ("second", "seconds", (gulong) _tmp18_);
						gtk_list_store_set (_tmp14_, &_tmp15_, 0, _tmp19_, -1, -1);
						break;
					}
					case 60:
					{
						GtkListStore* _tmp20_ = NULL;
						GtkTreeIter _tmp21_ = {0};
						GtkAdjustment* _tmp22_ = NULL;
						gdouble _tmp23_ = 0.0;
						gdouble _tmp24_ = 0.0;
						const gchar* _tmp25_ = NULL;
						_tmp20_ = model;
						_tmp21_ = iter;
						_tmp22_ = adjustment;
						_tmp23_ = gtk_adjustment_get_value (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = ngettext ("minute", "minutes", (gulong) _tmp24_);
						gtk_list_store_set (_tmp20_, &_tmp21_, 0, _tmp25_, -1, -1);
						break;
					}
					case 3600:
					{
						GtkListStore* _tmp26_ = NULL;
						GtkTreeIter _tmp27_ = {0};
						GtkAdjustment* _tmp28_ = NULL;
						gdouble _tmp29_ = 0.0;
						gdouble _tmp30_ = 0.0;
						const gchar* _tmp31_ = NULL;
						_tmp26_ = model;
						_tmp27_ = iter;
						_tmp28_ = adjustment;
						_tmp29_ = gtk_adjustment_get_value (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = ngettext ("hour", "hours", (gulong) _tmp30_);
						gtk_list_store_set (_tmp26_, &_tmp27_, 0, _tmp31_, -1, -1);
						break;
					}
					default:
					break;
				}
			}
		}
	}
	application_save_duration (self);
	_g_object_unref0 (model);
}


void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	application_save_duration (self);
}


static gboolean _application_save_duration_cb_gsource_func (gpointer self) {
	gboolean result;
	result = application_save_duration_cb (self);
	return result;
}


static void application_save_duration (Application* self) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->save_duration_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->save_duration_timeout;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _application_save_duration_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->save_duration_timeout = _tmp2_;
}


void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint duration = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GtkContainer* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
	_tmp7_ = self->priv->custom_duration_box;
	_tmp8_ = duration;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ < 0);
	_tmp9_ = duration;
	if (_tmp9_ >= 0) {
		gint _tmp10_ = 0;
		_tmp10_ = duration;
		application_set_duration (self, _tmp10_, FALSE);
	} else {
		gint _tmp11_ = 0;
		_tmp11_ = application_get_duration (self);
		if (_tmp11_ <= 0) {
			application_set_duration (self, 60 * 60, FALSE);
		}
	}
	application_save_duration (self);
}


void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, Application* self) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	G_MODULE_EXPORT preferences_response_cb (_tmp0_, (gint) GTK_RESPONSE_CANCEL, self);
	result = TRUE;
	return result;
}


void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "piece-theme", _tmp3_);
	_g_free0 (_tmp3_);
}


void G_MODULE_EXPORT show_3d_toggle_cb (GtkToggleButton* widget, Application* self) {
	GtkWidget* w = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkToggleButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkBuilder* _tmp7_ = NULL;
	GObject* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkToggleButton* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "show_3d_smooth_check");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_WIDGET, GtkWidget));
	w = _tmp2_;
	_tmp3_ = w;
	_tmp4_ = widget;
	_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_widget_set_sensitive (_tmp3_, _tmp6_);
	_tmp7_ = self->priv->preferences_builder;
	_tmp8_ = gtk_builder_get_object (_tmp7_, "piece_style_combo");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_WIDGET, GtkWidget));
	_g_object_unref0 (w);
	w = _tmp9_;
	_tmp10_ = w;
	_tmp11_ = widget;
	_tmp12_ = gtk_toggle_button_get_active (_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_widget_set_sensitive (_tmp10_, !_tmp13_);
	_g_object_unref0 (w);
}


void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "move-format", _tmp3_);
	_g_free0 (_tmp3_);
}


void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = combo;
	_tmp2_ = application_get_combo (self, _tmp1_, 1);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp0_, "board-side", _tmp3_);
	_g_free0 (_tmp3_);
}


void application_help_cb (Application* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-chess", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-chess.vala:1803: Unable to open help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	application_about_response_cb (self, response_id);
}


void application_about_cb (Application* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	GtkAboutDialog* _tmp2_ = NULL;
	GtkAboutDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	GtkAboutDialog* _tmp5_ = NULL;
	GtkAboutDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkAboutDialog* _tmp8_ = NULL;
	GtkAboutDialog* _tmp9_ = NULL;
	GtkAboutDialog* _tmp10_ = NULL;
	GtkAboutDialog* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkAboutDialog* _tmp13_ = NULL;
	GtkAboutDialog* _tmp14_ = NULL;
	GtkAboutDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkAboutDialog* _tmp17_ = NULL;
	GtkAboutDialog* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkAboutDialog* _tmp20_ = NULL;
	GtkAboutDialog* _tmp21_ = NULL;
	GtkAboutDialog* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->about_dialog;
	if (_tmp0_ != NULL) {
		GtkAboutDialog* _tmp1_ = NULL;
		_tmp1_ = self->priv->about_dialog;
		gtk_window_present ((GtkWindow*) _tmp1_);
		return;
	}
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = _tmp2_;
	_tmp3_ = self->priv->about_dialog;
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp4_);
	_tmp5_ = self->priv->about_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
	_tmp6_ = self->priv->about_dialog;
	_tmp7_ = _ ("Chess");
	gtk_about_dialog_set_program_name (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->about_dialog;
	gtk_about_dialog_set_version (_tmp8_, VERSION);
	_tmp9_ = self->priv->about_dialog;
	gtk_about_dialog_set_copyright (_tmp9_, "Copyright © 2010–2013 Robert Ancell\n" \
"Copyright © 2013 Michael Catanzaro");
	_tmp10_ = self->priv->about_dialog;
	gtk_about_dialog_set_license_type (_tmp10_, GTK_LICENSE_GPL_2_0);
	_tmp11_ = self->priv->about_dialog;
	_tmp12_ = _ ("The 2D/3D chess game for GNOME. \n" \
"\n" \
"GNOME Chess is a part of GNOME Games.");
	gtk_about_dialog_set_comments (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->about_dialog;
	gtk_about_dialog_set_authors (_tmp13_, APPLICATION_authors);
	_tmp14_ = self->priv->about_dialog;
	gtk_about_dialog_set_artists (_tmp14_, APPLICATION_artists);
	_tmp15_ = self->priv->about_dialog;
	_tmp16_ = _ ("translator-credits");
	gtk_about_dialog_set_translator_credits (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->about_dialog;
	gtk_about_dialog_set_website (_tmp17_, "http://www.gnome.org/projects/gnome-games/");
	_tmp18_ = self->priv->about_dialog;
	_tmp19_ = _ ("GNOME Games web site");
	gtk_about_dialog_set_website_label (_tmp18_, _tmp19_);
	_tmp20_ = self->priv->about_dialog;
	gtk_about_dialog_set_logo_icon_name (_tmp20_, "gnome-chess");
	_tmp21_ = self->priv->about_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp21_, "response", (GCallback) _application_about_response_cb_gtk_dialog_response, self, 0);
	_tmp22_ = self->priv->about_dialog;
	gtk_widget_show ((GtkWidget*) _tmp22_);
}


static void application_about_response_cb (Application* self, gint response_id) {
	GtkAboutDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->about_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = NULL;
}


void G_MODULE_EXPORT save_game_cb (GtkWidget* widget, Application* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	application_save_game (self, "_Cancel", "_Save");
}


static void application_add_info_bar_to_dialog (Application* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label) {
	GtkInfoBar* _vala_info_bar = NULL;
	GtkLabel* _vala_label = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkInfoBar* _tmp1_ = NULL;
	GtkContainer* content_area = NULL;
	GtkContainer* _tmp2_ = NULL;
	GtkContainer* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkContainer* child = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkContainer* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	GtkDialog* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	vbox = _tmp0_;
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp1_ = (GtkInfoBar*) gtk_info_bar_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (_vala_info_bar);
	_vala_info_bar = _tmp1_;
	_tmp2_ = gtk_info_bar_get_content_area (_vala_info_bar);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_CONTAINER, GtkContainer));
	content_area = _tmp3_;
	gtk_box_pack_start (vbox, (GtkWidget*) _vala_info_bar, FALSE, TRUE, (guint) 0);
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (_vala_label);
	_vala_label = _tmp4_;
	gtk_container_add (content_area, (GtkWidget*) _vala_label);
	gtk_widget_show ((GtkWidget*) _vala_label);
	_tmp5_ = dialog;
	_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_CONTAINER, GtkContainer));
	child = _tmp7_;
	gtk_widget_reparent ((GtkWidget*) child, (GtkWidget*) vbox);
	_tmp8_ = dialog;
	_tmp9_ = gtk_container_get_border_width ((GtkContainer*) _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_container_set_border_width (child, _tmp10_);
	_tmp11_ = dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp11_, (guint) 0);
	gtk_box_set_child_packing (vbox, (GtkWidget*) child, TRUE, TRUE, (guint) 0, GTK_PACK_START);
	_tmp12_ = dialog;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) vbox);
	_g_object_unref0 (child);
	_g_object_unref0 (content_area);
	_g_object_unref0 (vbox);
	if (info_bar) {
		*info_bar = _vala_info_bar;
	} else {
		_g_object_unref0 (_vala_info_bar);
	}
	if (label) {
		*label = _vala_label;
	} else {
		_g_object_unref0 (_vala_label);
	}
}


static void _application_save_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	application_save_file_cb (self);
}


static void _application_save_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	application_save_cb (self, response_id);
}


static void application_save_game (Application* self, const gchar* cancel_button_label, const gchar* save_button_label) {
	GtkFileChooserDialog* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkFileChooserDialog* _tmp6_ = NULL;
	GtkFileChooserDialog* _tmp7_ = NULL;
	GtkInfoBar* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkFileChooserDialog* _tmp10_ = NULL;
	GtkFileChooserDialog* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	GtkFileChooserDialog* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileFilter* _tmp25_ = NULL;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GtkFileFilter* _tmp29_ = NULL;
	GtkFileChooserDialog* _tmp30_ = NULL;
	GtkFileFilter* _tmp31_ = NULL;
	GtkFileFilter* _tmp32_ = NULL;
	GtkFileChooserDialog* _tmp33_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancel_button_label != NULL);
	g_return_if_fail (save_button_label != NULL);
	_tmp0_ = self->priv->save_dialog;
	if (_tmp0_ != NULL) {
		GtkFileChooserDialog* _tmp1_ = NULL;
		_tmp1_ = self->priv->save_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp1_);
		return;
	}
	_tmp2_ = _ ("Save Chess Game");
	_tmp3_ = self->priv->window;
	_tmp4_ = cancel_button_label;
	_tmp5_ = save_button_label;
	_tmp6_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp2_, _tmp3_, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp4_, GTK_RESPONSE_CANCEL, _tmp5_, GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = _tmp6_;
	_tmp7_ = self->priv->save_dialog;
	application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp7_, &_tmp8_, &_tmp9_);
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	self->priv->save_dialog_info_bar = _tmp8_;
	_g_object_unref0 (self->priv->save_dialog_error_label);
	self->priv->save_dialog_error_label = _tmp9_;
	_tmp10_ = self->priv->save_dialog;
	g_signal_connect_object ((GtkFileChooser*) _tmp10_, "file-activated", (GCallback) _application_save_file_cb_gtk_file_chooser_file_activated, self, 0);
	_tmp11_ = self->priv->save_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp11_, "response", (GCallback) _application_save_cb_gtk_dialog_response, self, 0);
	_tmp12_ = self->priv->saved_filename;
	if (_tmp12_ != NULL) {
		GtkFileChooserDialog* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp13_ = self->priv->save_dialog;
		_tmp14_ = self->priv->saved_filename;
		gtk_file_chooser_set_filename ((GtkFileChooser*) _tmp13_, _tmp14_);
	} else {
		GtkFileChooserDialog* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp15_ = self->priv->save_dialog;
		_tmp16_ = _ ("Untitled Chess Game");
		_tmp17_ = g_strconcat (_tmp16_, ".pgn", NULL);
		_tmp18_ = _tmp17_;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp18_);
		_g_free0 (_tmp18_);
	}
	_tmp19_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp19_);
	pgn_filter = _tmp19_;
	_tmp20_ = pgn_filter;
	_tmp21_ = _ ("PGN files");
	gtk_file_filter_set_name (_tmp20_, _tmp21_);
	_tmp22_ = pgn_filter;
	gtk_file_filter_add_pattern (_tmp22_, "*.pgn");
	_tmp23_ = self->priv->save_dialog;
	_tmp24_ = pgn_filter;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp23_, _tmp25_);
	_tmp26_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp26_);
	all_filter = _tmp26_;
	_tmp27_ = all_filter;
	_tmp28_ = _ ("All files");
	gtk_file_filter_set_name (_tmp27_, _tmp28_);
	_tmp29_ = all_filter;
	gtk_file_filter_add_pattern (_tmp29_, "*");
	_tmp30_ = self->priv->save_dialog;
	_tmp31_ = all_filter;
	_tmp32_ = _g_object_ref0 (_tmp31_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp30_, _tmp32_);
	_tmp33_ = self->priv->save_dialog;
	gtk_dialog_run ((GtkDialog*) _tmp33_);
	_g_object_unref0 (all_filter);
	_g_object_unref0 (pgn_filter);
}


static void application_save_file_cb (Application* self) {
	g_return_if_fail (self != NULL);
	application_save_cb (self, (gint) GTK_RESPONSE_OK);
}


static void application_update_pgn_time_remaining (Application* self) {
	ChessGame* _tmp0_ = NULL;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = chess_game_get_clock (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		guint initial_time = 0U;
		PGNGame* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		guint white_used = 0U;
		ChessGame* _tmp7_ = NULL;
		ChessClock* _tmp8_ = NULL;
		ChessClock* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		guint _tmp11_ = 0U;
		guint black_used = 0U;
		ChessGame* _tmp12_ = NULL;
		ChessClock* _tmp13_ = NULL;
		ChessClock* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
		PGNGame* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		guint _tmp19_ = 0U;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		PGNGame* _tmp22_ = NULL;
		guint _tmp23_ = 0U;
		guint _tmp24_ = 0U;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		_tmp3_ = self->priv->pgn_game;
		_tmp4_ = pgn_game_get_time_control (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = atoi (_tmp5_);
		initial_time = (guint) _tmp6_;
		_tmp7_ = self->priv->game;
		_tmp8_ = chess_game_get_clock (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = chess_clock_get_white_seconds_used (_tmp9_);
		_tmp11_ = _tmp10_;
		white_used = _tmp11_;
		_tmp12_ = self->priv->game;
		_tmp13_ = chess_game_get_clock (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = chess_clock_get_black_seconds_used (_tmp14_);
		_tmp16_ = _tmp15_;
		black_used = _tmp16_;
		_tmp17_ = self->priv->pgn_game;
		_tmp18_ = initial_time;
		_tmp19_ = white_used;
		_tmp20_ = g_strdup_printf ("%u", _tmp18_ - _tmp19_);
		_tmp21_ = _tmp20_;
		pgn_game_set_white_time_left (_tmp17_, _tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = self->priv->pgn_game;
		_tmp23_ = initial_time;
		_tmp24_ = black_used;
		_tmp25_ = g_strdup_printf ("%u", _tmp23_ - _tmp24_);
		_tmp26_ = _tmp25_;
		pgn_game_set_black_time_left (_tmp22_, _tmp26_);
		_g_free0 (_tmp26_);
	}
}


static void application_save_cb (Application* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		application_update_pgn_time_remaining (self);
		{
			PGNGame* _tmp1_ = NULL;
			GtkFileChooserDialog* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
			GtkFileChooserDialog* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			GtkWidget* _tmp6_ = NULL;
			_tmp1_ = self->priv->pgn_game;
			_tmp2_ = self->priv->save_dialog;
			_tmp3_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp2_);
			pgn_game_write (_tmp1_, _tmp3_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch8_g_error;
			}
			_tmp4_ = self->priv->save_dialog;
			_tmp5_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp4_);
			_g_free0 (self->priv->saved_filename);
			self->priv->saved_filename = _tmp5_;
			_tmp6_ = self->priv->save_button;
			gtk_widget_set_sensitive (_tmp6_, FALSE);
			self->priv->game_needs_saving = FALSE;
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* e = NULL;
			GtkLabel* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			GtkInfoBar* _tmp13_ = NULL;
			GtkInfoBar* _tmp14_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = self->priv->save_dialog_error_label;
			_tmp8_ = _ ("Failed to save game: %s");
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = g_strdup_printf (_tmp8_, _tmp10_);
			_tmp12_ = _tmp11_;
			gtk_label_set_text (_tmp7_, _tmp12_);
			_g_free0 (_tmp12_);
			_tmp13_ = self->priv->save_dialog_info_bar;
			gtk_info_bar_set_message_type (_tmp13_, GTK_MESSAGE_ERROR);
			_tmp14_ = self->priv->save_dialog_info_bar;
			gtk_widget_show ((GtkWidget*) _tmp14_);
			_g_error_free0 (e);
			return;
		}
		__finally8:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp15_ = self->priv->save_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = NULL;
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	self->priv->save_dialog_info_bar = NULL;
	_g_object_unref0 (self->priv->save_dialog_error_label);
	self->priv->save_dialog_error_label = NULL;
}


static void _application_open_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
	application_open_file_cb (self);
}


static void _application_open_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	application_open_cb (self, response_id);
}


void G_MODULE_EXPORT open_game_cb (GtkWidget* widget, Application* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkFileChooserDialog* _tmp2_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkInfoBar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp14_ = NULL;
	GtkFileFilter* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkFileFilter* _tmp17_ = NULL;
	GtkFileChooserDialog* _tmp18_ = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_ = NULL;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileChooserDialog* _tmp25_ = NULL;
	GtkFileFilter* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_ = NULL;
	GtkFileChooserDialog* _tmp28_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = _ ("Save this game before loading another one?");
	_tmp1_ = application_prompt_save_game (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->open_dialog;
	if (_tmp2_ != NULL) {
		GtkFileChooserDialog* _tmp3_ = NULL;
		_tmp3_ = self->priv->open_dialog;
		gtk_window_present ((GtkWindow*) _tmp3_);
		return;
	}
	_tmp4_ = _ ("Load Chess Game");
	_tmp5_ = self->priv->window;
	_tmp6_ = _ ("_Cancel");
	_tmp7_ = _ ("_Open");
	_tmp8_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp4_, _tmp5_, GTK_FILE_CHOOSER_ACTION_OPEN, _tmp6_, GTK_RESPONSE_CANCEL, _tmp7_, GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->open_dialog);
	self->priv->open_dialog = _tmp8_;
	_tmp9_ = self->priv->open_dialog;
	application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp9_, &_tmp10_, &_tmp11_);
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	self->priv->open_dialog_info_bar = _tmp10_;
	_g_object_unref0 (self->priv->open_dialog_error_label);
	self->priv->open_dialog_error_label = _tmp11_;
	_tmp12_ = self->priv->open_dialog;
	g_signal_connect_object ((GtkFileChooser*) _tmp12_, "file-activated", (GCallback) _application_open_file_cb_gtk_file_chooser_file_activated, self, 0);
	_tmp13_ = self->priv->open_dialog;
	g_signal_connect_object ((GtkDialog*) _tmp13_, "response", (GCallback) _application_open_cb_gtk_dialog_response, self, 0);
	_tmp14_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp14_);
	pgn_filter = _tmp14_;
	_tmp15_ = pgn_filter;
	_tmp16_ = _ ("PGN files");
	gtk_file_filter_set_name (_tmp15_, _tmp16_);
	_tmp17_ = pgn_filter;
	gtk_file_filter_add_pattern (_tmp17_, "*.pgn");
	_tmp18_ = self->priv->open_dialog;
	_tmp19_ = pgn_filter;
	_tmp20_ = _g_object_ref0 (_tmp19_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp18_, _tmp20_);
	_tmp21_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp21_);
	all_filter = _tmp21_;
	_tmp22_ = all_filter;
	_tmp23_ = _ ("All files");
	gtk_file_filter_set_name (_tmp22_, _tmp23_);
	_tmp24_ = all_filter;
	gtk_file_filter_add_pattern (_tmp24_, "*");
	_tmp25_ = self->priv->open_dialog;
	_tmp26_ = all_filter;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp25_, _tmp27_);
	_tmp28_ = self->priv->open_dialog;
	gtk_window_present ((GtkWindow*) _tmp28_);
	_g_object_unref0 (all_filter);
	_g_object_unref0 (pgn_filter);
}


static void application_open_file_cb (Application* self) {
	g_return_if_fail (self != NULL);
	application_open_cb (self, (gint) GTK_RESPONSE_OK);
}


static void application_open_cb (Application* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		{
			GtkFileChooserDialog* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			GtkFileChooserDialog* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			self->priv->in_history = FALSE;
			_tmp1_ = self->priv->open_dialog;
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
			application_load_game (self, _tmp2_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			_tmp3_ = self->priv->open_dialog;
			_tmp4_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp3_);
			_g_free0 (self->priv->saved_filename);
			self->priv->saved_filename = _tmp4_;
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError* e = NULL;
			GtkLabel* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			GError* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			GtkInfoBar* _tmp11_ = NULL;
			GtkInfoBar* _tmp12_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = self->priv->open_dialog_error_label;
			_tmp6_ = _ ("Failed to open game: %s");
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			_tmp9_ = g_strdup_printf (_tmp6_, _tmp8_);
			_tmp10_ = _tmp9_;
			gtk_label_set_text (_tmp5_, _tmp10_);
			_g_free0 (_tmp10_);
			_tmp11_ = self->priv->open_dialog_info_bar;
			gtk_info_bar_set_message_type (_tmp11_, GTK_MESSAGE_ERROR);
			_tmp12_ = self->priv->open_dialog_info_bar;
			gtk_widget_show ((GtkWidget*) _tmp12_);
			_g_error_free0 (e);
			return;
		}
		__finally9:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = self->priv->open_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
	_g_object_unref0 (self->priv->open_dialog);
	self->priv->open_dialog = NULL;
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	self->priv->open_dialog_info_bar = NULL;
	_g_object_unref0 (self->priv->open_dialog_error_label);
	self->priv->open_dialog_error_label = NULL;
}


static void application_start_new_game (Application* self) {
	PGNGame* _tmp0_ = NULL;
	GDateTime* now = NULL;
	GDateTime* _tmp1_ = NULL;
	PGNGame* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	PGNGame* _tmp6_ = NULL;
	GDateTime* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gint duration = 0;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gchar* engine_name = NULL;
	GSettings* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* engine_level = NULL;
	GSettings* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_ = NULL;
	gboolean _tmp40_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->in_history = FALSE;
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = NULL;
	_tmp0_ = pgn_game_new ();
	_pgn_game_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = self->priv->pgn_game;
	_tmp3_ = now;
	_tmp4_ = g_date_time_format (_tmp3_, "%Y.%m.%d");
	_tmp5_ = _tmp4_;
	pgn_game_set_date (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->pgn_game;
	_tmp7_ = now;
	_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
	_tmp9_ = _tmp8_;
	pgn_game_set_time (_tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_int (_tmp10_, "duration");
	duration = _tmp11_;
	_tmp12_ = duration;
	if (_tmp12_ > 0) {
		PGNGame* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		PGNGame* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		PGNGame* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp13_ = self->priv->pgn_game;
		_tmp14_ = duration;
		_tmp15_ = g_strdup_printf ("%i", _tmp14_ / 2);
		_tmp16_ = _tmp15_;
		pgn_game_set_time_control (_tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = self->priv->pgn_game;
		_tmp18_ = duration;
		_tmp19_ = g_strdup_printf ("%i", _tmp18_ / 2);
		_tmp20_ = _tmp19_;
		pgn_game_set_white_time_left (_tmp17_, _tmp20_);
		_g_free0 (_tmp20_);
		_tmp21_ = self->priv->pgn_game;
		_tmp22_ = duration;
		_tmp23_ = g_strdup_printf ("%i", _tmp22_ / 2);
		_tmp24_ = _tmp23_;
		pgn_game_set_black_time_left (_tmp21_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_tmp25_ = self->priv->settings;
	_tmp26_ = g_settings_get_string (_tmp25_, "opponent");
	engine_name = _tmp26_;
	_tmp27_ = engine_name;
	if (g_strcmp0 (_tmp27_, "") == 0) {
		GList* _tmp28_ = NULL;
		_tmp28_ = self->priv->ai_profiles;
		if (_tmp28_ != NULL) {
			GList* _tmp29_ = NULL;
			gconstpointer _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			_tmp29_ = self->priv->ai_profiles;
			_tmp30_ = _tmp29_->data;
			_tmp31_ = ai_profile_get_name ((AIProfile*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strdup (_tmp32_);
			_g_free0 (engine_name);
			engine_name = _tmp33_;
		} else {
			gchar* _tmp34_ = NULL;
			_tmp34_ = g_strdup ("human");
			_g_free0 (engine_name);
			engine_name = _tmp34_;
		}
	}
	_tmp35_ = self->priv->settings;
	_tmp36_ = g_settings_get_string (_tmp35_, "difficulty");
	engine_level = _tmp36_;
	_tmp38_ = engine_name;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_ = NULL;
		_tmp39_ = engine_name;
		_tmp37_ = g_strcmp0 (_tmp39_, "human") != 0;
	} else {
		_tmp37_ = FALSE;
	}
	_tmp40_ = _tmp37_;
	if (_tmp40_) {
		GSettings* _tmp41_ = NULL;
		gboolean _tmp42_ = FALSE;
		_tmp41_ = self->priv->settings;
		_tmp42_ = g_settings_get_boolean (_tmp41_, "play-as-white");
		if (_tmp42_) {
			PGNGame* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			PGNGame* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			_tmp43_ = self->priv->pgn_game;
			_tmp44_ = engine_name;
			pgn_game_set_black_ai (_tmp43_, _tmp44_);
			_tmp45_ = self->priv->pgn_game;
			_tmp46_ = engine_level;
			pgn_game_set_black_level (_tmp45_, _tmp46_);
		} else {
			PGNGame* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			PGNGame* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			_tmp47_ = self->priv->pgn_game;
			_tmp48_ = engine_name;
			pgn_game_set_white_ai (_tmp47_, _tmp48_);
			_tmp49_ = self->priv->pgn_game;
			_tmp50_ = engine_level;
			pgn_game_set_white_level (_tmp49_, _tmp50_);
		}
	}
	application_start_game (self);
	_g_free0 (engine_level);
	_g_free0 (engine_name);
	_g_date_time_unref0 (now);
}


static gpointer _pgn_game_ref0 (gpointer self) {
	return self ? pgn_game_ref (self) : NULL;
}


static void application_load_game (Application* self, GFile* file, GError** error) {
	PGN* pgn = NULL;
	GFile* _tmp0_ = NULL;
	PGN* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	PGNGame* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = pgn_new_from_file (_tmp0_, &_inner_error_);
	pgn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = pgn->games;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp4_ = _pgn_game_ref0 ((PGNGame*) _tmp3_);
	_pgn_game_unref0 (self->priv->pgn_game);
	self->priv->pgn_game = _tmp4_;
	_tmp5_ = file;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->game_file);
	self->priv->game_file = _tmp6_;
	application_start_game (self);
	_pgn_unref0 (pgn);
}


static void application_class_init (ApplicationClass * klass) {
	application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
	G_APPLICATION_CLASS (klass)->startup = application_real_startup;
	G_APPLICATION_CLASS (klass)->shutdown = application_real_shutdown;
	G_APPLICATION_CLASS (klass)->activate = application_real_activate;
	G_OBJECT_CLASS (klass)->finalize = application_finalize;
}


static void application_instance_init (Application * self) {
	self->priv = APPLICATION_GET_PRIVATE (self);
	self->priv->preferences_dialog = NULL;
	self->priv->save_duration_timeout = (guint) 0;
	self->priv->open_dialog = NULL;
	self->priv->open_dialog_info_bar = NULL;
	self->priv->open_dialog_error_label = NULL;
	self->priv->save_dialog = NULL;
	self->priv->save_dialog_info_bar = NULL;
	self->priv->save_dialog_error_label = NULL;
	self->priv->about_dialog = NULL;
	self->priv->saved_filename = NULL;
	self->priv->opponent = NULL;
	self->priv->human_player = NULL;
	self->priv->opponent_engine = NULL;
	self->priv->is_fullscreen = FALSE;
}


static void application_finalize (GObject* obj) {
	Application * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION, Application);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->preferences_builder);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->info_bar);
	_g_object_unref0 (self->priv->info_title_label);
	_g_object_unref0 (self->priv->info_label);
	_g_object_unref0 (self->priv->view_container);
	_g_object_unref0 (self->priv->scene);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->save_button);
	_g_object_unref0 (self->priv->undo_button);
	_g_object_unref0 (self->priv->pause_button);
	_g_object_unref0 (self->priv->claim_draw_button);
	_g_object_unref0 (self->priv->resign_button);
	_g_object_unref0 (self->priv->fullscreen_button);
	_g_object_unref0 (self->priv->first_move_button);
	_g_object_unref0 (self->priv->prev_move_button);
	_g_object_unref0 (self->priv->next_move_button);
	_g_object_unref0 (self->priv->last_move_button);
	_g_object_unref0 (self->priv->history_combo);
	_g_object_unref0 (self->priv->white_time_label);
	_g_object_unref0 (self->priv->black_time_label);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->side_combo);
	_g_object_unref0 (self->priv->difficulty_combo);
	_g_object_unref0 (self->priv->duration_combo);
	_g_object_unref0 (self->priv->duration_adjustment);
	_g_object_unref0 (self->priv->custom_duration_box);
	_g_object_unref0 (self->priv->custom_duration_units_combo);
	_g_object_unref0 (self->priv->open_dialog);
	_g_object_unref0 (self->priv->open_dialog_info_bar);
	_g_object_unref0 (self->priv->open_dialog_error_label);
	_g_object_unref0 (self->priv->save_dialog);
	_g_object_unref0 (self->priv->save_dialog_info_bar);
	_g_object_unref0 (self->priv->save_dialog_error_label);
	_g_object_unref0 (self->priv->about_dialog);
	_pgn_game_unref0 (self->priv->pgn_game);
	_chess_game_unref0 (self->priv->game);
	_g_free0 (self->priv->autosave_filename);
	_g_object_unref0 (self->priv->game_file);
	_g_free0 (self->priv->saved_filename);
	__g_list_free__ai_profile_unref0_0 (self->priv->ai_profiles);
	_g_object_unref0 (self->priv->opponent);
	_g_object_unref0 (self->priv->human_player);
	_g_object_unref0 (self->priv->opponent_engine);
	G_OBJECT_CLASS (application_parent_class)->finalize (obj);
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, NULL };
		GType application_type_id;
		application_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Application", &g_define_type_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


gint gnome_chess_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* c = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	gboolean _tmp14_ = FALSE;
	GFile* game_file = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	Application* app = NULL;
	GFile* _tmp20_ = NULL;
	Application* _tmp21_ = NULL;
	Application* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_prgname ("glchess");
	gtk_init (&args_length1, &args);
	_tmp0_ = _ ("[FILE] - Play Chess");
	_tmp1_ = g_option_context_new (_tmp0_);
	c = _tmp1_;
	_tmp2_ = c;
	g_option_context_add_main_entries (_tmp2_, GNOME_CHESS_options, GETTEXT_PACKAGE);
	_tmp3_ = c;
	_tmp4_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_ = NULL;
		_tmp5_ = c;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		FILE* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		_tmp9_ = stderr;
		_tmp10_ = _ ("Run '%s --help' to see a full list of available command line options.");
		_tmp11_ = args;
		_tmp11__length1 = args_length1;
		_tmp12_ = _tmp11_[0];
		fprintf (_tmp9_, _tmp10_, _tmp12_);
		_tmp13_ = stderr;
		fprintf (_tmp13_, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (c);
		return result;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp14_ = gnome_chess_show_version;
	if (_tmp14_) {
		FILE* _tmp15_ = NULL;
		_tmp15_ = stderr;
		fprintf (_tmp15_, "gnome-chess %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		return result;
	}
	game_file = NULL;
	_tmp16_ = args;
	_tmp16__length1 = args_length1;
	if (_tmp16__length1 > 1) {
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		_tmp17_ = args;
		_tmp17__length1 = args_length1;
		_tmp18_ = _tmp17_[1];
		_tmp19_ = g_file_new_for_path (_tmp18_);
		_g_object_unref0 (game_file);
		game_file = _tmp19_;
	}
	_tmp20_ = game_file;
	_tmp21_ = application_new (_tmp20_);
	app = _tmp21_;
	_tmp22_ = app;
	_tmp23_ = g_application_run ((GApplication*) _tmp22_, 0, NULL);
	result = _tmp23_;
	_g_object_unref0 (app);
	_g_object_unref0 (game_file);
	_g_option_context_free0 (c);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return gnome_chess_main (argv, argc);
}


GnomeChess* gnome_chess_construct (GType object_type) {
	GnomeChess* self = NULL;
	self = (GnomeChess*) g_type_create_instance (object_type);
	return self;
}


GnomeChess* gnome_chess_new (void) {
	return gnome_chess_construct (TYPE_GNOME_CHESS);
}


static void value_gnome_chess_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_gnome_chess_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gnome_chess_unref (value->data[0].v_pointer);
	}
}


static void value_gnome_chess_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gnome_chess_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_gnome_chess_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_gnome_chess_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GnomeChess* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gnome_chess_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_gnome_chess_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GnomeChess** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gnome_chess_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_gnome_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGnomeChess* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GNOME_CHESS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_gnome_chess (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GNOME_CHESS), NULL);
	return value->data[0].v_pointer;
}


void value_set_gnome_chess (GValue* value, gpointer v_object) {
	GnomeChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GNOME_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GNOME_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gnome_chess_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gnome_chess_unref (old);
	}
}


void value_take_gnome_chess (GValue* value, gpointer v_object) {
	GnomeChess* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GNOME_CHESS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GNOME_CHESS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gnome_chess_unref (old);
	}
}


static void gnome_chess_class_init (GnomeChessClass * klass) {
	gnome_chess_parent_class = g_type_class_peek_parent (klass);
	GNOME_CHESS_CLASS (klass)->finalize = gnome_chess_finalize;
}


static void gnome_chess_instance_init (GnomeChess * self) {
	self->ref_count = 1;
}


static void gnome_chess_finalize (GnomeChess* obj) {
	GnomeChess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GNOME_CHESS, GnomeChess);
}


GType gnome_chess_get_type (void) {
	static volatile gsize gnome_chess_type_id__volatile = 0;
	if (g_once_init_enter (&gnome_chess_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_gnome_chess_init, value_gnome_chess_free_value, value_gnome_chess_copy_value, value_gnome_chess_peek_pointer, "p", value_gnome_chess_collect_value, "p", value_gnome_chess_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GnomeChessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_chess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeChess), 0, (GInstanceInitFunc) gnome_chess_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gnome_chess_type_id;
		gnome_chess_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GnomeChess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gnome_chess_type_id__volatile, gnome_chess_type_id);
	}
	return gnome_chess_type_id__volatile;
}


gpointer gnome_chess_ref (gpointer instance) {
	GnomeChess* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gnome_chess_unref (gpointer instance) {
	GnomeChess* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GNOME_CHESS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



