/* grid.c generated by valac 0.32.0.61-f103e, the Vala compiler
 * generated from grid.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
 * Copyright (C) 2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;
typedef struct _GridPrivate GridPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TILE (tile_get_type ())

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;
typedef struct _Tile Tile;

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())
typedef struct _TileMovement TileMovement;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Grid {
	GObject parent_instance;
	GridPrivate * priv;
};

struct _GridClass {
	GObjectClass parent_class;
};

struct _GridPrivate {
	guint* _grid;
	gint _grid_length1;
	gint _grid_length2;
	gint _rows;
	gint _cols;
	guint _target_value;
	gboolean _target_value_reached;
};

struct _GridPosition {
	guint row;
	guint col;
};

struct _Tile {
	GridPosition pos;
	guint val;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};


static gpointer grid_parent_class = NULL;

GType grid_get_type (void) G_GNUC_CONST;
#define GRID_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GRID, GridPrivate))
enum  {
	GRID_DUMMY_PROPERTY,
	GRID_ROWS,
	GRID_COLS,
	GRID_TARGET_VALUE,
	GRID_TARGET_VALUE_REACHED
};
Grid* grid_new (gint rows, gint cols);
Grid* grid_construct (GType object_type, gint rows, gint cols);
void grid_clear (Grid* self);
Grid* grid_clone (Grid* self);
static guint* _vala_array_dup1 (guint* self, int length);
GType tile_get_type (void) G_GNUC_CONST;
GType grid_position_get_type (void) G_GNUC_CONST;
GridPosition* grid_position_dup (const GridPosition* self);
void grid_position_free (GridPosition* self);
Tile* tile_dup (const Tile* self);
void tile_free (Tile* self);
gboolean grid_new_tile (Grid* self, Tile* tile);
static gboolean _grid_grid_is_full (Grid* self);
static void _grid_random_position (Grid* self, GridPosition* result);
static void _grid_check_target_value_reached (Grid* self, guint val);
GType tile_movement_get_type (void) G_GNUC_CONST;
TileMovement* tile_movement_dup (const TileMovement* self);
void tile_movement_free (TileMovement* self);
void grid_move_down (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
gchar* grid_position_to_string (GridPosition *self);
void grid_move_up (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_left (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_right (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
gboolean grid_is_finished (Grid* self);
guint grid_get (Grid* self, gint row, gint col);
gchar* grid_save (Grid* self);
static gchar* _grid_convert_to_string (Grid* self);
gboolean grid_load (Grid* self, const gchar* content);
static gboolean _grid_load_from_string (Grid* self, const gchar* contents);
gchar* grid_to_string (Grid* self);
static guint* _vala_array_dup2 (guint* self, int length);
guint grid_get_target_value (Grid* self);
void grid_set_target_value_reached (Grid* self, gboolean value);
gint grid_get_rows (Grid* self);
void grid_set_rows (Grid* self, gint value);
gint grid_get_cols (Grid* self);
void grid_set_cols (Grid* self, gint value);
void grid_set_target_value (Grid* self, guint value);
gboolean grid_get_target_value_reached (Grid* self);
static void grid_finalize (GObject* obj);
static void _vala_grid_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_grid_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


Grid* grid_construct (GType object_type, gint rows, gint cols) {
	Grid * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	guint* _tmp4_ = NULL;
#line 26 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = rows;
#line 26 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = cols;
#line 26 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self = (Grid*) g_object_new (object_type, "rows", _tmp0_, "cols", _tmp1_, NULL);
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = rows;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = cols;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = g_new0 (guint, _tmp2_ * _tmp3_);
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid = _tmp4_;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid_length1 = _tmp2_;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid_length2 = _tmp3_;
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid_clear (self);
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_target_value = (guint) 0;
#line 24 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return self;
#line 179 "grid.c"
}


Grid* grid_new (gint rows, gint cols) {
#line 24 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return grid_construct (TYPE_GRID, rows, cols);
#line 186 "grid.c"
}


static guint* _vala_array_dup1 (guint* self, int length) {
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return g_memdup (self, length * sizeof (guint));
#line 193 "grid.c"
}


Grid* grid_clone (Grid* self) {
	Grid* result = NULL;
	Grid* grid = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Grid* _tmp2_ = NULL;
	guint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	guint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	guint _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_rows;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = self->priv->_cols;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = grid_new (_tmp0_, _tmp1_);
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid = _tmp2_;
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = self->priv->_grid;
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3__length1 = self->priv->_grid_length1;
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3__length2 = self->priv->_grid_length2;
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : ((gpointer) _tmp3_);
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4__length1 = _tmp3__length1;
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4__length2 = _tmp3__length2;
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_grid = (g_free (grid->priv->_grid), NULL);
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_grid = _tmp4_;
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_grid_length1 = _tmp4__length1;
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_grid_length2 = _tmp4__length2;
#line 53 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5_ = self->priv->_target_value;
#line 53 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_target_value = _tmp5_;
#line 54 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp6_ = self->priv->_target_value_reached;
#line 54 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_target_value_reached = _tmp6_;
#line 56 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = grid;
#line 56 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 253 "grid.c"
}


void grid_clear (Grid* self) {
#line 59 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 260 "grid.c"
	{
		guint i = 0U;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = (guint) 0;
#line 265 "grid.c"
		{
			gboolean _tmp0_ = FALSE;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp0_ = TRUE;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 272 "grid.c"
				guint _tmp2_ = 0U;
				guint* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gint _tmp3__length2 = 0;
				gint _tmp4_ = 0;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp0_) {
#line 280 "grid.c"
					guint _tmp1_ = 0U;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp1_ = i;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp1_ + 1;
#line 286 "grid.c"
				}
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp0_ = FALSE;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp2_ = i;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = self->priv->_grid;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3__length1 = self->priv->_grid_length1;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3__length2 = self->priv->_grid_length2;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp4_ = _tmp3__length1;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp2_ < ((guint) _tmp4_))) {
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 304 "grid.c"
				}
				{
					guint j = 0U;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = (guint) 0;
#line 310 "grid.c"
					{
						gboolean _tmp5_ = FALSE;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp5_ = TRUE;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 317 "grid.c"
							guint _tmp7_ = 0U;
							guint* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							guint* _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp10__length2 = 0;
							guint _tmp11_ = 0U;
							guint _tmp12_ = 0U;
							guint _tmp13_ = 0U;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp5_) {
#line 331 "grid.c"
								guint _tmp6_ = 0U;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp6_ = j;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp6_ + 1;
#line 337 "grid.c"
							}
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp5_ = FALSE;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp7_ = j;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8_ = self->priv->_grid;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8__length1 = self->priv->_grid_length1;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8__length2 = self->priv->_grid_length2;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9_ = _tmp8__length2;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp7_ < ((guint) _tmp9_))) {
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 355 "grid.c"
							}
#line 63 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = self->priv->_grid;
#line 63 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10__length1 = self->priv->_grid_length1;
#line 63 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10__length2 = self->priv->_grid_length2;
#line 63 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = i;
#line 63 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = j;
#line 63 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_] = (guint) 0;
#line 63 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 371 "grid.c"
						}
					}
				}
			}
		}
	}
}


gboolean grid_new_tile (Grid* self, Tile* tile) {
	Tile _vala_tile = {0};
	gboolean result = FALSE;
	GridPosition pos = {0};
	GridPosition _tmp0_ = {0};
	guint val = 0U;
	GridPosition _tmp1_ = {0};
	Tile _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 68 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_.row = (guint) 0;
#line 68 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_.col = (guint) 0;
#line 68 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	pos = _tmp0_;
#line 70 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = pos;
#line 70 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_.pos = _tmp1_;
#line 70 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_.val = (guint) 0;
#line 70 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_vala_tile = _tmp2_;
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = _grid_grid_is_full (self);
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp3_) {
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		if (tile) {
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			*tile = _vala_tile;
#line 416 "grid.c"
		}
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 420 "grid.c"
	}
#line 75 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	val = (guint) 2;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	while (TRUE) {
#line 426 "grid.c"
		GridPosition _tmp4_ = {0};
		guint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		GridPosition _tmp6_ = {0};
		guint _tmp7_ = 0U;
		GridPosition _tmp8_ = {0};
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_grid_random_position (self, &_tmp4_);
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		pos = _tmp4_;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp5_ = self->priv->_grid;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp5__length1 = self->priv->_grid_length1;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp5__length2 = self->priv->_grid_length2;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp6_ = pos;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp7_ = _tmp6_.row;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp8_ = pos;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp9_ = _tmp8_.col;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp10_ = _tmp5_[(_tmp7_ * _tmp5__length2) + _tmp9_];
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		if (_tmp10_ == ((guint) 0)) {
#line 458 "grid.c"
			guint* _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			gint _tmp11__length2 = 0;
			GridPosition _tmp12_ = {0};
			guint _tmp13_ = 0U;
			GridPosition _tmp14_ = {0};
			guint _tmp15_ = 0U;
			guint _tmp16_ = 0U;
			guint _tmp17_ = 0U;
			guint _tmp18_ = 0U;
			GridPosition _tmp19_ = {0};
			guint _tmp20_ = 0U;
			Tile _tmp21_ = {0};
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp11_ = self->priv->_grid;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp11__length1 = self->priv->_grid_length1;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp11__length2 = self->priv->_grid_length2;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp12_ = pos;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp13_ = _tmp12_.row;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp14_ = pos;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp15_ = _tmp14_.col;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp16_ = val;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp11_[(_tmp13_ * _tmp11__length2) + _tmp15_] = _tmp16_;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp17_ = _tmp11_[(_tmp13_ * _tmp11__length2) + _tmp15_];
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp18_ = val;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_grid_check_target_value_reached (self, _tmp18_);
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp19_ = pos;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp20_ = val;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp21_.pos = _tmp19_;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp21_.val = _tmp20_;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_vala_tile = _tmp21_;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			result = TRUE;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			if (tile) {
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				*tile = _vala_tile;
#line 512 "grid.c"
			}
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			return result;
#line 516 "grid.c"
		}
	}
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (tile) {
#line 66 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		*tile = _vala_tile;
#line 523 "grid.c"
	}
}


void grid_move_down (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint row = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_move != NULL);
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_hide != NULL);
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_show != NULL);
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = to_move;
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = to_hide;
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = to_show;
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 560 "grid.c"
	{
		gint i = 0;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 565 "grid.c"
		{
			gboolean _tmp3_ = FALSE;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp3_ = TRUE;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 572 "grid.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				GridPosition _tmp9_ = {0};
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp3_) {
#line 580 "grid.c"
					gint _tmp4_ = 0;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp4_ = i;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp4_ + 1;
#line 586 "grid.c"
				}
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = FALSE;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp5_ = i;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp6_ = self->priv->_cols;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 598 "grid.c"
				}
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp7_ = self->priv->_rows;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_ = i;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp9_.row = (guint) _tmp7_;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp9_.col = (guint) _tmp8_;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				free = _tmp9_;
#line 610 "grid.c"
				{
					gint j = 0;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 615 "grid.c"
					{
						gboolean _tmp10_ = FALSE;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp10_ = TRUE;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 622 "grid.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							GridPosition _tmp18_ = {0};
							guint* _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							gint _tmp19__length2 = 0;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							GridPosition _tmp22_ = {0};
							guint _tmp23_ = 0U;
							guint _tmp24_ = 0U;
							guint _tmp25_ = 0U;
							GridPosition _tmp30_ = {0};
							gboolean _tmp47_ = FALSE;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp10_) {
#line 643 "grid.c"
								gint _tmp11_ = 0;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp11_ = j;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp11_ + 1;
#line 649 "grid.c"
							}
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = FALSE;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = j;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = self->priv->_rows;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 661 "grid.c"
							}
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = self->priv->_rows;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = j;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							row = (_tmp14_ - _tmp15_) - 1;
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_ = row;
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17_ = i;
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_.row = (guint) _tmp16_;
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_.col = (guint) _tmp17_;
#line 115 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							cur = _tmp18_;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19_ = self->priv->_grid;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19__length1 = self->priv->_grid_length1;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19__length2 = self->priv->_grid_length2;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp20_ = cur;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp21_ = _tmp20_.row;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp22_ = cur;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp23_ = _tmp22_.col;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp24_ = _tmp19_[(_tmp21_ * _tmp19__length2) + _tmp23_];
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							val = _tmp24_;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp25_ = val;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp25_ == ((guint) 0)) {
#line 701 "grid.c"
								GridPosition _tmp26_ = {0};
								guint _tmp27_ = 0U;
								gint _tmp28_ = 0;
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp26_ = free;
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp27_ = _tmp26_.row;
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp28_ = self->priv->_rows;
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp27_ == ((guint) _tmp28_)) {
#line 713 "grid.c"
									gint _tmp29_ = 0;
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp29_ = row;
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = (guint) _tmp29_;
#line 719 "grid.c"
								}
#line 122 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								continue;
#line 723 "grid.c"
							}
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp30_.row = (guint) 0;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp30_.col = (guint) 0;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							match = _tmp30_;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							has_match = FALSE;
#line 733 "grid.c"
							{
								gint k = 0;
								gint _tmp31_ = 0;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp31_ = row;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								k = _tmp31_ - 1;
#line 741 "grid.c"
								{
									gboolean _tmp32_ = FALSE;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp32_ = TRUE;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									while (TRUE) {
#line 748 "grid.c"
										gint _tmp34_ = 0;
										guint k_val = 0U;
										guint* _tmp35_ = NULL;
										gint _tmp35__length1 = 0;
										gint _tmp35__length2 = 0;
										gint _tmp36_ = 0;
										GridPosition _tmp37_ = {0};
										guint _tmp38_ = 0U;
										guint _tmp39_ = 0U;
										guint _tmp40_ = 0U;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!_tmp32_) {
#line 761 "grid.c"
											gint _tmp33_ = 0;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp33_ = k;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											k = _tmp33_ - 1;
#line 767 "grid.c"
										}
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp32_ = FALSE;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp34_ = k;
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!(_tmp34_ >= 0)) {
#line 128 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 777 "grid.c"
										}
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35_ = self->priv->_grid;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35__length1 = self->priv->_grid_length1;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35__length2 = self->priv->_grid_length2;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp36_ = k;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp37_ = cur;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp38_ = _tmp37_.col;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp39_ = _tmp35_[(_tmp36_ * _tmp35__length2) + _tmp38_];
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										k_val = _tmp39_;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp40_ = k_val;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (_tmp40_ != ((guint) 0)) {
#line 799 "grid.c"
											guint _tmp41_ = 0U;
											guint _tmp42_ = 0U;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp41_ = k_val;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp42_ = val;
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											if (_tmp41_ == _tmp42_) {
#line 808 "grid.c"
												gint _tmp43_ = 0;
												GridPosition _tmp44_ = {0};
												guint _tmp45_ = 0U;
												GridPosition _tmp46_ = {0};
#line 136 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												has_match = TRUE;
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp43_ = k;
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_ = cur;
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp45_ = _tmp44_.col;
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp46_.row = (guint) _tmp43_;
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp46_.col = _tmp45_;
#line 137 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												match = _tmp46_;
#line 827 "grid.c"
											}
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 831 "grid.c"
										}
									}
								}
							}
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp47_ = has_match;
#line 143 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp47_) {
#line 840 "grid.c"
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_ = NULL;
								GridPosition _tmp52_ = {0};
								guint _tmp53_ = 0U;
								gint _tmp54_ = 0;
								GridPosition _tmp56_ = {0};
								GridPosition _tmp57_ = {0};
								TileMovement _tmp58_ = {0};
								GeeLinkedList* _tmp59_ = NULL;
								TileMovement _tmp60_ = {0};
								GridPosition _tmp61_ = {0};
								GridPosition _tmp62_ = {0};
								TileMovement _tmp63_ = {0};
								GeeLinkedList* _tmp64_ = NULL;
								TileMovement _tmp65_ = {0};
								GridPosition _tmp66_ = {0};
								guint _tmp67_ = 0U;
								Tile _tmp68_ = {0};
								GeeLinkedList* _tmp69_ = NULL;
								Tile _tmp70_ = {0};
								guint* _tmp71_ = NULL;
								gint _tmp71__length1 = 0;
								gint _tmp71__length2 = 0;
								GridPosition _tmp72_ = {0};
								guint _tmp73_ = 0U;
								GridPosition _tmp74_ = {0};
								guint _tmp75_ = 0U;
								guint _tmp76_ = 0U;
								guint* _tmp77_ = NULL;
								gint _tmp77__length1 = 0;
								gint _tmp77__length2 = 0;
								GridPosition _tmp78_ = {0};
								guint _tmp79_ = 0U;
								GridPosition _tmp80_ = {0};
								guint _tmp81_ = 0U;
								guint _tmp82_ = 0U;
								guint* _tmp83_ = NULL;
								gint _tmp83__length1 = 0;
								gint _tmp83__length2 = 0;
								GridPosition _tmp84_ = {0};
								guint _tmp85_ = 0U;
								GridPosition _tmp86_ = {0};
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
								guint _tmp89_ = 0U;
								guint _tmp90_ = 0U;
								guint _tmp91_ = 0U;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp48_ = grid_position_to_string (&match);
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp49_ = _tmp48_;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp50_ = g_strconcat ("matching tile found at ", _tmp49_, NULL);
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp51_ = _tmp50_;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								g_debug ("grid.vala:145: %s", _tmp51_);
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp51_);
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp49_);
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp52_ = free;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp53_ = _tmp52_.row;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp54_ = self->priv->_rows;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp53_ == ((guint) _tmp54_)) {
#line 912 "grid.c"
									gint _tmp55_ = 0;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp55_ = row;
#line 148 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = (guint) _tmp55_;
#line 918 "grid.c"
								}
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp56_ = cur;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp57_ = free;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_.from = _tmp56_;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_.to = _tmp57_;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp58_;
#line 151 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp59_ = to_hide;
#line 151 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_ = mov;
#line 151 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, &_tmp60_);
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp61_ = match;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp62_ = free;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_.from = _tmp61_;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_.to = _tmp62_;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp63_;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp64_ = to_hide;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_ = mov;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, &_tmp65_);
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp66_ = free;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp67_ = val;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_.pos = _tmp66_;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_.val = _tmp67_ * 2;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								tile = _tmp68_;
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp69_ = to_show;
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp70_ = tile;
#line 156 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, &_tmp70_);
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_ = self->priv->_grid;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71__length1 = self->priv->_grid_length1;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71__length2 = self->priv->_grid_length2;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp72_ = cur;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp73_ = _tmp72_.row;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_ = cur;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp75_ = _tmp74_.col;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_] = (guint) 0;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp76_ = _tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_];
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_ = self->priv->_grid;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77__length1 = self->priv->_grid_length1;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77__length2 = self->priv->_grid_length2;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp78_ = match;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp79_ = _tmp78_.row;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_ = match;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp81_ = _tmp80_.col;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_] = (guint) 0;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp82_ = _tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_];
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_ = self->priv->_grid;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83__length1 = self->priv->_grid_length1;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83__length2 = self->priv->_grid_length2;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp84_ = free;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp85_ = _tmp84_.row;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp86_ = free;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp87_ = _tmp86_.col;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp88_ = val;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_] = _tmp88_ * 2;
#line 160 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp89_ = _tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_];
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp90_ = val;
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_grid_check_target_value_reached (self, _tmp90_ * 2);
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp91_ = free.row;
#line 163 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								free.row = _tmp91_ - 1;
#line 1032 "grid.c"
							} else {
								GridPosition _tmp92_ = {0};
								guint _tmp93_ = 0U;
								gint _tmp94_ = 0;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp92_ = free;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp93_ = _tmp92_.row;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp94_ = self->priv->_rows;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp93_ != ((guint) _tmp94_)) {
#line 1045 "grid.c"
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									gchar* _tmp97_ = NULL;
									gchar* _tmp98_ = NULL;
									gchar* _tmp99_ = NULL;
									gchar* _tmp100_ = NULL;
									GridPosition _tmp101_ = {0};
									GridPosition _tmp102_ = {0};
									TileMovement _tmp103_ = {0};
									GeeLinkedList* _tmp104_ = NULL;
									TileMovement _tmp105_ = {0};
									guint* _tmp106_ = NULL;
									gint _tmp106__length1 = 0;
									gint _tmp106__length2 = 0;
									GridPosition _tmp107_ = {0};
									guint _tmp108_ = 0U;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									guint _tmp111_ = 0U;
									guint* _tmp112_ = NULL;
									gint _tmp112__length1 = 0;
									gint _tmp112__length2 = 0;
									GridPosition _tmp113_ = {0};
									guint _tmp114_ = 0U;
									GridPosition _tmp115_ = {0};
									guint _tmp116_ = 0U;
									guint _tmp117_ = 0U;
									guint _tmp118_ = 0U;
									guint _tmp119_ = 0U;
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp95_ = grid_position_to_string (&cur);
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp96_ = _tmp95_;
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp97_ = grid_position_to_string (&free);
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp98_ = _tmp97_;
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_ = g_strconcat ("moving ", _tmp96_, " to ", _tmp98_, NULL);
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp100_ = _tmp99_;
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									g_debug ("grid.vala:167: %s", _tmp100_);
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp100_);
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp98_);
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp96_);
#line 169 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp101_ = cur;
#line 169 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_ = free;
#line 169 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_.from = _tmp101_;
#line 169 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_.to = _tmp102_;
#line 169 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									mov = _tmp103_;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp104_ = to_move;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp105_ = mov;
#line 170 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, &_tmp105_);
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_ = self->priv->_grid;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106__length1 = self->priv->_grid_length1;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106__length2 = self->priv->_grid_length2;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp107_ = cur;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_ = _tmp107_.row;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp109_ = cur;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp110_ = _tmp109_.col;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_] = (guint) 0;
#line 172 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp111_ = _tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_];
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_ = self->priv->_grid;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112__length1 = self->priv->_grid_length1;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112__length2 = self->priv->_grid_length2;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp113_ = free;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp114_ = _tmp113_.row;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp115_ = free;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp116_ = _tmp115_.col;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp117_ = val;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_] = _tmp117_;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp118_ = _tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_];
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp119_ = free.row;
#line 175 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = _tmp119_ - 1;
#line 1153 "grid.c"
								}
							}
						}
					}
				}
			}
		}
	}
}


void grid_move_up (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint row = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_move != NULL);
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_hide != NULL);
#line 181 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_show != NULL);
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = to_move;
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = to_hide;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = to_show;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 1197 "grid.c"
	{
		gint i = 0;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 1202 "grid.c"
		{
			gboolean _tmp3_ = FALSE;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp3_ = TRUE;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 1209 "grid.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				GridPosition _tmp8_ = {0};
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp3_) {
#line 1216 "grid.c"
					gint _tmp4_ = 0;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp4_ = i;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp4_ + 1;
#line 1222 "grid.c"
				}
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = FALSE;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp5_ = i;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp6_ = self->priv->_cols;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 1234 "grid.c"
				}
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp7_ = i;
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_.row = (guint) -1;
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_.col = (guint) _tmp7_;
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				free = _tmp8_;
#line 1244 "grid.c"
				{
					gint j = 0;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 1249 "grid.c"
					{
						gboolean _tmp9_ = FALSE;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp9_ = TRUE;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 1256 "grid.c"
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							GridPosition _tmp16_ = {0};
							guint* _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							gint _tmp17__length2 = 0;
							GridPosition _tmp18_ = {0};
							guint _tmp19_ = 0U;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							guint _tmp22_ = 0U;
							guint _tmp23_ = 0U;
							GridPosition _tmp27_ = {0};
							gboolean _tmp45_ = FALSE;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp9_) {
#line 1276 "grid.c"
								gint _tmp10_ = 0;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp10_ = j;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp10_ + 1;
#line 1282 "grid.c"
							}
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9_ = FALSE;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = j;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = self->priv->_rows;
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp11_ < _tmp12_)) {
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 1294 "grid.c"
							}
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = j;
#line 204 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							row = _tmp13_;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = row;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = i;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_.row = (guint) _tmp14_;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_.col = (guint) _tmp15_;
#line 205 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							cur = _tmp16_;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17_ = self->priv->_grid;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17__length1 = self->priv->_grid_length1;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17__length2 = self->priv->_grid_length2;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_ = cur;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19_ = _tmp18_.row;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp20_ = cur;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp21_ = _tmp20_.col;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp22_ = _tmp17_[(_tmp19_ * _tmp17__length2) + _tmp21_];
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							val = _tmp22_;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp23_ = val;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp23_ == ((guint) 0)) {
#line 1332 "grid.c"
								GridPosition _tmp24_ = {0};
								guint _tmp25_ = 0U;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp24_ = free;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp25_ = _tmp24_.row;
#line 210 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp25_ == ((guint) -1)) {
#line 1341 "grid.c"
									gint _tmp26_ = 0;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp26_ = row;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = (guint) _tmp26_;
#line 1347 "grid.c"
								}
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								continue;
#line 1351 "grid.c"
							}
#line 216 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp27_.row = (guint) 0;
#line 216 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp27_.col = (guint) 0;
#line 216 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							match = _tmp27_;
#line 217 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							has_match = FALSE;
#line 1361 "grid.c"
							{
								gint k = 0;
								gint _tmp28_ = 0;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp28_ = row;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								k = _tmp28_ + 1;
#line 1369 "grid.c"
								{
									gboolean _tmp29_ = FALSE;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp29_ = TRUE;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									while (TRUE) {
#line 1376 "grid.c"
										gint _tmp31_ = 0;
										gint _tmp32_ = 0;
										guint k_val = 0U;
										guint* _tmp33_ = NULL;
										gint _tmp33__length1 = 0;
										gint _tmp33__length2 = 0;
										gint _tmp34_ = 0;
										GridPosition _tmp35_ = {0};
										guint _tmp36_ = 0U;
										guint _tmp37_ = 0U;
										guint _tmp38_ = 0U;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!_tmp29_) {
#line 1390 "grid.c"
											gint _tmp30_ = 0;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp30_ = k;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											k = _tmp30_ + 1;
#line 1396 "grid.c"
										}
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp29_ = FALSE;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp31_ = k;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp32_ = self->priv->_rows;
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!(_tmp31_ < _tmp32_)) {
#line 218 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 1408 "grid.c"
										}
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33_ = self->priv->_grid;
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33__length1 = self->priv->_grid_length1;
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33__length2 = self->priv->_grid_length2;
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp34_ = k;
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35_ = cur;
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp36_ = _tmp35_.col;
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp37_ = _tmp33_[(_tmp34_ * _tmp33__length2) + _tmp36_];
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										k_val = _tmp37_;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp38_ = k_val;
#line 222 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (_tmp38_ != ((guint) 0)) {
#line 1430 "grid.c"
											guint _tmp39_ = 0U;
											guint _tmp40_ = 0U;
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp39_ = k_val;
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp40_ = val;
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											if (_tmp39_ == _tmp40_) {
#line 1439 "grid.c"
												gint _tmp41_ = 0;
												GridPosition _tmp42_ = {0};
												guint _tmp43_ = 0U;
												GridPosition _tmp44_ = {0};
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												has_match = TRUE;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp41_ = k;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp42_ = cur;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp43_ = _tmp42_.col;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_.row = (guint) _tmp41_;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_.col = _tmp43_;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												match = _tmp44_;
#line 1458 "grid.c"
											}
#line 229 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 1462 "grid.c"
										}
									}
								}
							}
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp45_ = has_match;
#line 233 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp45_) {
#line 1471 "grid.c"
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								GridPosition _tmp50_ = {0};
								guint _tmp51_ = 0U;
								GridPosition _tmp53_ = {0};
								GridPosition _tmp54_ = {0};
								TileMovement _tmp55_ = {0};
								GeeLinkedList* _tmp56_ = NULL;
								TileMovement _tmp57_ = {0};
								GridPosition _tmp58_ = {0};
								GridPosition _tmp59_ = {0};
								TileMovement _tmp60_ = {0};
								GeeLinkedList* _tmp61_ = NULL;
								TileMovement _tmp62_ = {0};
								GridPosition _tmp63_ = {0};
								guint _tmp64_ = 0U;
								Tile _tmp65_ = {0};
								GeeLinkedList* _tmp66_ = NULL;
								Tile _tmp67_ = {0};
								guint* _tmp68_ = NULL;
								gint _tmp68__length1 = 0;
								gint _tmp68__length2 = 0;
								GridPosition _tmp69_ = {0};
								guint _tmp70_ = 0U;
								GridPosition _tmp71_ = {0};
								guint _tmp72_ = 0U;
								guint _tmp73_ = 0U;
								guint* _tmp74_ = NULL;
								gint _tmp74__length1 = 0;
								gint _tmp74__length2 = 0;
								GridPosition _tmp75_ = {0};
								guint _tmp76_ = 0U;
								GridPosition _tmp77_ = {0};
								guint _tmp78_ = 0U;
								guint _tmp79_ = 0U;
								guint* _tmp80_ = NULL;
								gint _tmp80__length1 = 0;
								gint _tmp80__length2 = 0;
								GridPosition _tmp81_ = {0};
								guint _tmp82_ = 0U;
								GridPosition _tmp83_ = {0};
								guint _tmp84_ = 0U;
								guint _tmp85_ = 0U;
								guint _tmp86_ = 0U;
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp46_ = grid_position_to_string (&match);
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp47_ = _tmp46_;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp48_ = g_strconcat ("matching tile found at ", _tmp47_, NULL);
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp49_ = _tmp48_;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								g_debug ("grid.vala:235: %s", _tmp49_);
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp49_);
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp47_);
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp50_ = free;
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp51_ = _tmp50_.row;
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp51_ == ((guint) -1)) {
#line 1540 "grid.c"
									gint _tmp52_ = 0;
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp52_ = row;
#line 238 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = (guint) _tmp52_;
#line 1546 "grid.c"
								}
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp53_ = cur;
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp54_ = free;
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp55_.from = _tmp53_;
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp55_.to = _tmp54_;
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp55_;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp56_ = to_hide;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp57_ = mov;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, &_tmp57_);
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_ = match;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp59_ = free;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_.from = _tmp58_;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_.to = _tmp59_;
#line 242 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp60_;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp61_ = to_hide;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp62_ = mov;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, &_tmp62_);
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_ = free;
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp64_ = val;
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_.pos = _tmp63_;
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_.val = _tmp64_ * 2;
#line 245 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								tile = _tmp65_;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp66_ = to_show;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp67_ = tile;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, &_tmp67_);
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_ = self->priv->_grid;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68__length1 = self->priv->_grid_length1;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68__length2 = self->priv->_grid_length2;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp69_ = cur;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp70_ = _tmp69_.row;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_ = cur;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp72_ = _tmp71_.col;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_] = (guint) 0;
#line 248 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp73_ = _tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_];
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_ = self->priv->_grid;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74__length1 = self->priv->_grid_length1;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74__length2 = self->priv->_grid_length2;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp75_ = match;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp76_ = _tmp75_.row;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_ = match;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp78_ = _tmp77_.col;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_] = (guint) 0;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp79_ = _tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_];
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_ = self->priv->_grid;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80__length1 = self->priv->_grid_length1;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80__length2 = self->priv->_grid_length2;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp81_ = free;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp82_ = _tmp81_.row;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_ = free;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp84_ = _tmp83_.col;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp85_ = val;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_] = _tmp85_ * 2;
#line 250 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp86_ = _tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_];
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp87_ = val;
#line 251 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_grid_check_target_value_reached (self, _tmp87_ * 2);
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp88_ = free.row;
#line 253 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								free.row = _tmp88_ + 1;
#line 1660 "grid.c"
							} else {
								GridPosition _tmp89_ = {0};
								guint _tmp90_ = 0U;
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp89_ = free;
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp90_ = _tmp89_.row;
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp90_ != ((guint) -1)) {
#line 1670 "grid.c"
									gchar* _tmp91_ = NULL;
									gchar* _tmp92_ = NULL;
									gchar* _tmp93_ = NULL;
									gchar* _tmp94_ = NULL;
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									GridPosition _tmp97_ = {0};
									GridPosition _tmp98_ = {0};
									TileMovement _tmp99_ = {0};
									GeeLinkedList* _tmp100_ = NULL;
									TileMovement _tmp101_ = {0};
									guint* _tmp102_ = NULL;
									gint _tmp102__length1 = 0;
									gint _tmp102__length2 = 0;
									GridPosition _tmp103_ = {0};
									guint _tmp104_ = 0U;
									GridPosition _tmp105_ = {0};
									guint _tmp106_ = 0U;
									guint _tmp107_ = 0U;
									guint* _tmp108_ = NULL;
									gint _tmp108__length1 = 0;
									gint _tmp108__length2 = 0;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									GridPosition _tmp111_ = {0};
									guint _tmp112_ = 0U;
									guint _tmp113_ = 0U;
									guint _tmp114_ = 0U;
									guint _tmp115_ = 0U;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp91_ = grid_position_to_string (&cur);
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp92_ = _tmp91_;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp93_ = grid_position_to_string (&free);
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp94_ = _tmp93_;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp95_ = g_strconcat ("moving ", _tmp92_, " to ", _tmp94_, NULL);
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp96_ = _tmp95_;
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									g_debug ("grid.vala:257: %s", _tmp96_);
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp96_);
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp94_);
#line 257 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp92_);
#line 259 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp97_ = cur;
#line 259 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp98_ = free;
#line 259 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_.from = _tmp97_;
#line 259 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_.to = _tmp98_;
#line 259 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									mov = _tmp99_;
#line 260 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp100_ = to_move;
#line 260 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp101_ = mov;
#line 260 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, &_tmp101_);
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_ = self->priv->_grid;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102__length1 = self->priv->_grid_length1;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102__length2 = self->priv->_grid_length2;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_ = cur;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp104_ = _tmp103_.row;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp105_ = cur;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_ = _tmp105_.col;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_] = (guint) 0;
#line 262 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp107_ = _tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_];
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_ = self->priv->_grid;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108__length1 = self->priv->_grid_length1;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108__length2 = self->priv->_grid_length2;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp109_ = free;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp110_ = _tmp109_.row;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp111_ = free;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_ = _tmp111_.col;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp113_ = val;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_] = _tmp113_;
#line 263 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp114_ = _tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_];
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp115_ = free.row;
#line 265 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = _tmp115_ + 1;
#line 1778 "grid.c"
								}
							}
						}
					}
				}
			}
		}
	}
}


void grid_move_left (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint col = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
#line 271 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 271 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_move != NULL);
#line 271 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_hide != NULL);
#line 271 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_show != NULL);
#line 284 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = to_move;
#line 284 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = to_hide;
#line 285 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = to_show;
#line 286 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 1822 "grid.c"
	{
		gint i = 0;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 1827 "grid.c"
		{
			gboolean _tmp3_ = FALSE;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp3_ = TRUE;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 1834 "grid.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				GridPosition _tmp8_ = {0};
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp3_) {
#line 1841 "grid.c"
					gint _tmp4_ = 0;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp4_ = i;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp4_ + 1;
#line 1847 "grid.c"
				}
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = FALSE;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp5_ = i;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp6_ = self->priv->_rows;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 1859 "grid.c"
				}
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp7_ = i;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_.row = (guint) _tmp7_;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_.col = (guint) -1;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				free = _tmp8_;
#line 1869 "grid.c"
				{
					gint j = 0;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 1874 "grid.c"
					{
						gboolean _tmp9_ = FALSE;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp9_ = TRUE;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 1881 "grid.c"
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							GridPosition _tmp16_ = {0};
							guint* _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							gint _tmp17__length2 = 0;
							GridPosition _tmp18_ = {0};
							guint _tmp19_ = 0U;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							guint _tmp22_ = 0U;
							guint _tmp23_ = 0U;
							GridPosition _tmp27_ = {0};
							gboolean _tmp45_ = FALSE;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp9_) {
#line 1901 "grid.c"
								gint _tmp10_ = 0;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp10_ = j;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp10_ + 1;
#line 1907 "grid.c"
							}
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9_ = FALSE;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = j;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = self->priv->_cols;
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp11_ < _tmp12_)) {
#line 292 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 1919 "grid.c"
							}
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = j;
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							col = _tmp13_;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = i;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = col;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_.row = (guint) _tmp14_;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_.col = (guint) _tmp15_;
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							cur = _tmp16_;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17_ = self->priv->_grid;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17__length1 = self->priv->_grid_length1;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17__length2 = self->priv->_grid_length2;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_ = cur;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19_ = _tmp18_.row;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp20_ = cur;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp21_ = _tmp20_.col;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp22_ = _tmp17_[(_tmp19_ * _tmp17__length2) + _tmp21_];
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							val = _tmp22_;
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp23_ = val;
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp23_ == ((guint) 0)) {
#line 1957 "grid.c"
								GridPosition _tmp24_ = {0};
								guint _tmp25_ = 0U;
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp24_ = free;
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp25_ = _tmp24_.col;
#line 300 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp25_ == ((guint) -1)) {
#line 1966 "grid.c"
									gint _tmp26_ = 0;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp26_ = col;
#line 301 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = (guint) _tmp26_;
#line 1972 "grid.c"
								}
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								continue;
#line 1976 "grid.c"
							}
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp27_.row = (guint) 0;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp27_.col = (guint) 0;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							match = _tmp27_;
#line 307 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							has_match = FALSE;
#line 1986 "grid.c"
							{
								gint k = 0;
								gint _tmp28_ = 0;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp28_ = col;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								k = _tmp28_ + 1;
#line 1994 "grid.c"
								{
									gboolean _tmp29_ = FALSE;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp29_ = TRUE;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									while (TRUE) {
#line 2001 "grid.c"
										gint _tmp31_ = 0;
										gint _tmp32_ = 0;
										guint k_val = 0U;
										guint* _tmp33_ = NULL;
										gint _tmp33__length1 = 0;
										gint _tmp33__length2 = 0;
										GridPosition _tmp34_ = {0};
										guint _tmp35_ = 0U;
										gint _tmp36_ = 0;
										guint _tmp37_ = 0U;
										guint _tmp38_ = 0U;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!_tmp29_) {
#line 2015 "grid.c"
											gint _tmp30_ = 0;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp30_ = k;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											k = _tmp30_ + 1;
#line 2021 "grid.c"
										}
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp29_ = FALSE;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp31_ = k;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp32_ = self->priv->_rows;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!(_tmp31_ < _tmp32_)) {
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 2033 "grid.c"
										}
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33_ = self->priv->_grid;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33__length1 = self->priv->_grid_length1;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33__length2 = self->priv->_grid_length2;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp34_ = cur;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35_ = _tmp34_.row;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp36_ = k;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp37_ = _tmp33_[(_tmp35_ * _tmp33__length2) + _tmp36_];
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										k_val = _tmp37_;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp38_ = k_val;
#line 312 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (_tmp38_ != ((guint) 0)) {
#line 2055 "grid.c"
											guint _tmp39_ = 0U;
											guint _tmp40_ = 0U;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp39_ = k_val;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp40_ = val;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											if (_tmp39_ == _tmp40_) {
#line 2064 "grid.c"
												GridPosition _tmp41_ = {0};
												guint _tmp42_ = 0U;
												gint _tmp43_ = 0;
												GridPosition _tmp44_ = {0};
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												has_match = TRUE;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp41_ = cur;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp42_ = _tmp41_.row;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp43_ = k;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_.row = _tmp42_;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_.col = (guint) _tmp43_;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												match = _tmp44_;
#line 2083 "grid.c"
											}
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 2087 "grid.c"
										}
									}
								}
							}
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp45_ = has_match;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp45_) {
#line 2096 "grid.c"
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								GridPosition _tmp50_ = {0};
								guint _tmp51_ = 0U;
								GridPosition _tmp53_ = {0};
								GridPosition _tmp54_ = {0};
								TileMovement _tmp55_ = {0};
								GeeLinkedList* _tmp56_ = NULL;
								TileMovement _tmp57_ = {0};
								GridPosition _tmp58_ = {0};
								GridPosition _tmp59_ = {0};
								TileMovement _tmp60_ = {0};
								GeeLinkedList* _tmp61_ = NULL;
								TileMovement _tmp62_ = {0};
								GridPosition _tmp63_ = {0};
								guint _tmp64_ = 0U;
								Tile _tmp65_ = {0};
								GeeLinkedList* _tmp66_ = NULL;
								Tile _tmp67_ = {0};
								guint* _tmp68_ = NULL;
								gint _tmp68__length1 = 0;
								gint _tmp68__length2 = 0;
								GridPosition _tmp69_ = {0};
								guint _tmp70_ = 0U;
								GridPosition _tmp71_ = {0};
								guint _tmp72_ = 0U;
								guint _tmp73_ = 0U;
								guint* _tmp74_ = NULL;
								gint _tmp74__length1 = 0;
								gint _tmp74__length2 = 0;
								GridPosition _tmp75_ = {0};
								guint _tmp76_ = 0U;
								GridPosition _tmp77_ = {0};
								guint _tmp78_ = 0U;
								guint _tmp79_ = 0U;
								guint* _tmp80_ = NULL;
								gint _tmp80__length1 = 0;
								gint _tmp80__length2 = 0;
								GridPosition _tmp81_ = {0};
								guint _tmp82_ = 0U;
								GridPosition _tmp83_ = {0};
								guint _tmp84_ = 0U;
								guint _tmp85_ = 0U;
								guint _tmp86_ = 0U;
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp46_ = grid_position_to_string (&match);
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp47_ = _tmp46_;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp48_ = g_strconcat ("matching tile found at ", _tmp47_, NULL);
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp49_ = _tmp48_;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								g_debug ("grid.vala:325: %s", _tmp49_);
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp49_);
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp47_);
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp50_ = free;
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp51_ = _tmp50_.col;
#line 327 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp51_ == ((guint) -1)) {
#line 2165 "grid.c"
									gint _tmp52_ = 0;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp52_ = col;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = (guint) _tmp52_;
#line 2171 "grid.c"
								}
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp53_ = cur;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp54_ = free;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp55_.from = _tmp53_;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp55_.to = _tmp54_;
#line 330 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp55_;
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp56_ = to_hide;
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp57_ = mov;
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, &_tmp57_);
#line 332 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_ = match;
#line 332 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp59_ = free;
#line 332 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_.from = _tmp58_;
#line 332 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_.to = _tmp59_;
#line 332 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp60_;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp61_ = to_hide;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp62_ = mov;
#line 333 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, &_tmp62_);
#line 335 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_ = free;
#line 335 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp64_ = val;
#line 335 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_.pos = _tmp63_;
#line 335 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_.val = _tmp64_ * 2;
#line 335 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								tile = _tmp65_;
#line 336 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp66_ = to_show;
#line 336 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp67_ = tile;
#line 336 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, &_tmp67_);
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_ = self->priv->_grid;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68__length1 = self->priv->_grid_length1;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68__length2 = self->priv->_grid_length2;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp69_ = cur;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp70_ = _tmp69_.row;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_ = cur;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp72_ = _tmp71_.col;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_] = (guint) 0;
#line 338 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp73_ = _tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_];
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_ = self->priv->_grid;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74__length1 = self->priv->_grid_length1;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74__length2 = self->priv->_grid_length2;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp75_ = match;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp76_ = _tmp75_.row;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_ = match;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp78_ = _tmp77_.col;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_] = (guint) 0;
#line 339 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp79_ = _tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_];
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_ = self->priv->_grid;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80__length1 = self->priv->_grid_length1;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80__length2 = self->priv->_grid_length2;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp81_ = free;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp82_ = _tmp81_.row;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_ = free;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp84_ = _tmp83_.col;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp85_ = val;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_] = _tmp85_ * 2;
#line 340 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp86_ = _tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_];
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp87_ = val;
#line 341 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_grid_check_target_value_reached (self, _tmp87_ * 2);
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp88_ = free.col;
#line 343 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								free.col = _tmp88_ + 1;
#line 2285 "grid.c"
							} else {
								GridPosition _tmp89_ = {0};
								guint _tmp90_ = 0U;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp89_ = free;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp90_ = _tmp89_.col;
#line 345 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp90_ != ((guint) -1)) {
#line 2295 "grid.c"
									gchar* _tmp91_ = NULL;
									gchar* _tmp92_ = NULL;
									gchar* _tmp93_ = NULL;
									gchar* _tmp94_ = NULL;
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									GridPosition _tmp97_ = {0};
									GridPosition _tmp98_ = {0};
									TileMovement _tmp99_ = {0};
									GeeLinkedList* _tmp100_ = NULL;
									TileMovement _tmp101_ = {0};
									guint* _tmp102_ = NULL;
									gint _tmp102__length1 = 0;
									gint _tmp102__length2 = 0;
									GridPosition _tmp103_ = {0};
									guint _tmp104_ = 0U;
									GridPosition _tmp105_ = {0};
									guint _tmp106_ = 0U;
									guint _tmp107_ = 0U;
									guint* _tmp108_ = NULL;
									gint _tmp108__length1 = 0;
									gint _tmp108__length2 = 0;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									GridPosition _tmp111_ = {0};
									guint _tmp112_ = 0U;
									guint _tmp113_ = 0U;
									guint _tmp114_ = 0U;
									guint _tmp115_ = 0U;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp91_ = grid_position_to_string (&cur);
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp92_ = _tmp91_;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp93_ = grid_position_to_string (&free);
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp94_ = _tmp93_;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp95_ = g_strconcat ("moving ", _tmp92_, " to ", _tmp94_, NULL);
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp96_ = _tmp95_;
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									g_debug ("grid.vala:347: %s", _tmp96_);
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp96_);
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp94_);
#line 347 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp92_);
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp97_ = cur;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp98_ = free;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_.from = _tmp97_;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_.to = _tmp98_;
#line 349 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									mov = _tmp99_;
#line 350 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp100_ = to_move;
#line 350 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp101_ = mov;
#line 350 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, &_tmp101_);
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_ = self->priv->_grid;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102__length1 = self->priv->_grid_length1;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102__length2 = self->priv->_grid_length2;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_ = cur;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp104_ = _tmp103_.row;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp105_ = cur;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_ = _tmp105_.col;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_] = (guint) 0;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp107_ = _tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_];
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_ = self->priv->_grid;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108__length1 = self->priv->_grid_length1;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108__length2 = self->priv->_grid_length2;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp109_ = free;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp110_ = _tmp109_.row;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp111_ = free;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_ = _tmp111_.col;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp113_ = val;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_] = _tmp113_;
#line 353 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp114_ = _tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_];
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp115_ = free.col;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = _tmp115_ + 1;
#line 2403 "grid.c"
								}
							}
						}
					}
				}
			}
		}
	}
}


void grid_move_right (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint col = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_move != NULL);
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_hide != NULL);
#line 361 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_show != NULL);
#line 374 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = to_move;
#line 374 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 375 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = to_hide;
#line 375 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = to_show;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 2447 "grid.c"
	{
		gint i = 0;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 2452 "grid.c"
		{
			gboolean _tmp3_ = FALSE;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp3_ = TRUE;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 2459 "grid.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				GridPosition _tmp9_ = {0};
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp3_) {
#line 2467 "grid.c"
					gint _tmp4_ = 0;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp4_ = i;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp4_ + 1;
#line 2473 "grid.c"
				}
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = FALSE;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp5_ = i;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp6_ = self->priv->_rows;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 2485 "grid.c"
				}
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp7_ = i;
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_ = self->priv->_cols;
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp9_.row = (guint) _tmp7_;
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp9_.col = (guint) _tmp8_;
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				free = _tmp9_;
#line 2497 "grid.c"
				{
					gint j = 0;
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 2502 "grid.c"
					{
						gboolean _tmp10_ = FALSE;
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp10_ = TRUE;
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 2509 "grid.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							GridPosition _tmp18_ = {0};
							guint* _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							gint _tmp19__length2 = 0;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							GridPosition _tmp22_ = {0};
							guint _tmp23_ = 0U;
							guint _tmp24_ = 0U;
							guint _tmp25_ = 0U;
							GridPosition _tmp30_ = {0};
							gboolean _tmp47_ = FALSE;
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp10_) {
#line 2530 "grid.c"
								gint _tmp11_ = 0;
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp11_ = j;
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp11_ + 1;
#line 2536 "grid.c"
							}
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = FALSE;
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = j;
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = self->priv->_cols;
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 382 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 2548 "grid.c"
							}
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = self->priv->_cols;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = j;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							col = (_tmp14_ - _tmp15_) - 1;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_ = i;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17_ = col;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_.row = (guint) _tmp16_;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_.col = (guint) _tmp17_;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							cur = _tmp18_;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19_ = self->priv->_grid;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19__length1 = self->priv->_grid_length1;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19__length2 = self->priv->_grid_length2;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp20_ = cur;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp21_ = _tmp20_.row;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp22_ = cur;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp23_ = _tmp22_.col;
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp24_ = _tmp19_[(_tmp21_ * _tmp19__length2) + _tmp23_];
#line 386 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							val = _tmp24_;
#line 388 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp25_ = val;
#line 388 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp25_ == ((guint) 0)) {
#line 2588 "grid.c"
								GridPosition _tmp26_ = {0};
								guint _tmp27_ = 0U;
								gint _tmp28_ = 0;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp26_ = free;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp27_ = _tmp26_.col;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp28_ = self->priv->_cols;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp27_ == ((guint) _tmp28_)) {
#line 2600 "grid.c"
									gint _tmp29_ = 0;
#line 391 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp29_ = col;
#line 391 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = (guint) _tmp29_;
#line 2606 "grid.c"
								}
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								continue;
#line 2610 "grid.c"
							}
#line 396 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp30_.row = (guint) 0;
#line 396 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp30_.col = (guint) 0;
#line 396 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							match = _tmp30_;
#line 397 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							has_match = FALSE;
#line 2620 "grid.c"
							{
								gint k = 0;
								gint _tmp31_ = 0;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp31_ = col;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								k = _tmp31_ - 1;
#line 2628 "grid.c"
								{
									gboolean _tmp32_ = FALSE;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp32_ = TRUE;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									while (TRUE) {
#line 2635 "grid.c"
										gint _tmp34_ = 0;
										guint k_val = 0U;
										guint* _tmp35_ = NULL;
										gint _tmp35__length1 = 0;
										gint _tmp35__length2 = 0;
										GridPosition _tmp36_ = {0};
										guint _tmp37_ = 0U;
										gint _tmp38_ = 0;
										guint _tmp39_ = 0U;
										guint _tmp40_ = 0U;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!_tmp32_) {
#line 2648 "grid.c"
											gint _tmp33_ = 0;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp33_ = k;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											k = _tmp33_ - 1;
#line 2654 "grid.c"
										}
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp32_ = FALSE;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp34_ = k;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!(_tmp34_ >= 0)) {
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 2664 "grid.c"
										}
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35_ = self->priv->_grid;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35__length1 = self->priv->_grid_length1;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35__length2 = self->priv->_grid_length2;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp36_ = cur;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp37_ = _tmp36_.row;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp38_ = k;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp39_ = _tmp35_[(_tmp37_ * _tmp35__length2) + _tmp38_];
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										k_val = _tmp39_;
#line 402 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp40_ = k_val;
#line 402 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (_tmp40_ != ((guint) 0)) {
#line 2686 "grid.c"
											guint _tmp41_ = 0U;
											guint _tmp42_ = 0U;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp41_ = k_val;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp42_ = val;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											if (_tmp41_ == _tmp42_) {
#line 2695 "grid.c"
												GridPosition _tmp43_ = {0};
												guint _tmp44_ = 0U;
												gint _tmp45_ = 0;
												GridPosition _tmp46_ = {0};
#line 406 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												has_match = TRUE;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp43_ = cur;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_ = _tmp43_.row;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp45_ = k;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp46_.row = _tmp44_;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp46_.col = (guint) _tmp45_;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												match = _tmp46_;
#line 2714 "grid.c"
											}
#line 409 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 2718 "grid.c"
										}
									}
								}
							}
#line 413 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp47_ = has_match;
#line 413 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp47_) {
#line 2727 "grid.c"
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_ = NULL;
								GridPosition _tmp52_ = {0};
								guint _tmp53_ = 0U;
								gint _tmp54_ = 0;
								GridPosition _tmp56_ = {0};
								GridPosition _tmp57_ = {0};
								TileMovement _tmp58_ = {0};
								GeeLinkedList* _tmp59_ = NULL;
								TileMovement _tmp60_ = {0};
								GridPosition _tmp61_ = {0};
								GridPosition _tmp62_ = {0};
								TileMovement _tmp63_ = {0};
								GeeLinkedList* _tmp64_ = NULL;
								TileMovement _tmp65_ = {0};
								GridPosition _tmp66_ = {0};
								guint _tmp67_ = 0U;
								Tile _tmp68_ = {0};
								GeeLinkedList* _tmp69_ = NULL;
								Tile _tmp70_ = {0};
								guint* _tmp71_ = NULL;
								gint _tmp71__length1 = 0;
								gint _tmp71__length2 = 0;
								GridPosition _tmp72_ = {0};
								guint _tmp73_ = 0U;
								GridPosition _tmp74_ = {0};
								guint _tmp75_ = 0U;
								guint _tmp76_ = 0U;
								guint* _tmp77_ = NULL;
								gint _tmp77__length1 = 0;
								gint _tmp77__length2 = 0;
								GridPosition _tmp78_ = {0};
								guint _tmp79_ = 0U;
								GridPosition _tmp80_ = {0};
								guint _tmp81_ = 0U;
								guint _tmp82_ = 0U;
								guint* _tmp83_ = NULL;
								gint _tmp83__length1 = 0;
								gint _tmp83__length2 = 0;
								GridPosition _tmp84_ = {0};
								guint _tmp85_ = 0U;
								GridPosition _tmp86_ = {0};
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
								guint _tmp89_ = 0U;
								guint _tmp90_ = 0U;
								guint _tmp91_ = 0U;
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp48_ = grid_position_to_string (&match);
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp49_ = _tmp48_;
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp50_ = g_strconcat ("matching tile found at ", _tmp49_, NULL);
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp51_ = _tmp50_;
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								g_debug ("grid.vala:415: %s", _tmp51_);
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp51_);
#line 415 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp49_);
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp52_ = free;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp53_ = _tmp52_.col;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp54_ = self->priv->_cols;
#line 417 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp53_ == ((guint) _tmp54_)) {
#line 2799 "grid.c"
									gint _tmp55_ = 0;
#line 418 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp55_ = col;
#line 418 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = (guint) _tmp55_;
#line 2805 "grid.c"
								}
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp56_ = cur;
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp57_ = free;
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_.from = _tmp56_;
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_.to = _tmp57_;
#line 420 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp58_;
#line 421 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp59_ = to_hide;
#line 421 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_ = mov;
#line 421 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, &_tmp60_);
#line 422 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp61_ = match;
#line 422 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp62_ = free;
#line 422 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_.from = _tmp61_;
#line 422 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_.to = _tmp62_;
#line 422 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp63_;
#line 423 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp64_ = to_hide;
#line 423 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_ = mov;
#line 423 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, &_tmp65_);
#line 425 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp66_ = free;
#line 425 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp67_ = val;
#line 425 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_.pos = _tmp66_;
#line 425 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_.val = _tmp67_ * 2;
#line 425 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								tile = _tmp68_;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp69_ = to_show;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp70_ = tile;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, &_tmp70_);
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_ = self->priv->_grid;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71__length1 = self->priv->_grid_length1;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71__length2 = self->priv->_grid_length2;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp72_ = cur;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp73_ = _tmp72_.row;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_ = cur;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp75_ = _tmp74_.col;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_] = (guint) 0;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp76_ = _tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_];
#line 429 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_ = self->priv->_grid;
#line 429 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77__length1 = self->priv->_grid_length1;
#line 429 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77__length2 = self->priv->_grid_length2;
#line 429 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp78_ = match;
#line 429 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp79_ = _tmp78_.row;
#line 429 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_ = match;
#line 429 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp81_ = _tmp80_.col;
#line 429 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_] = (guint) 0;
#line 429 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp82_ = _tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_];
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_ = self->priv->_grid;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83__length1 = self->priv->_grid_length1;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83__length2 = self->priv->_grid_length2;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp84_ = free;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp85_ = _tmp84_.row;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp86_ = free;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp87_ = _tmp86_.col;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp88_ = val;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_] = _tmp88_ * 2;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp89_ = _tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_];
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp90_ = val;
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_grid_check_target_value_reached (self, _tmp90_ * 2);
#line 433 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp91_ = free.col;
#line 433 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								free.col = _tmp91_ - 1;
#line 2919 "grid.c"
							} else {
								GridPosition _tmp92_ = {0};
								guint _tmp93_ = 0U;
								gint _tmp94_ = 0;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp92_ = free;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp93_ = _tmp92_.col;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp94_ = self->priv->_cols;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp93_ != ((guint) _tmp94_)) {
#line 2932 "grid.c"
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									gchar* _tmp97_ = NULL;
									gchar* _tmp98_ = NULL;
									gchar* _tmp99_ = NULL;
									gchar* _tmp100_ = NULL;
									GridPosition _tmp101_ = {0};
									GridPosition _tmp102_ = {0};
									TileMovement _tmp103_ = {0};
									GeeLinkedList* _tmp104_ = NULL;
									TileMovement _tmp105_ = {0};
									guint* _tmp106_ = NULL;
									gint _tmp106__length1 = 0;
									gint _tmp106__length2 = 0;
									GridPosition _tmp107_ = {0};
									guint _tmp108_ = 0U;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									guint _tmp111_ = 0U;
									guint* _tmp112_ = NULL;
									gint _tmp112__length1 = 0;
									gint _tmp112__length2 = 0;
									GridPosition _tmp113_ = {0};
									guint _tmp114_ = 0U;
									GridPosition _tmp115_ = {0};
									guint _tmp116_ = 0U;
									guint _tmp117_ = 0U;
									guint _tmp118_ = 0U;
									guint _tmp119_ = 0U;
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp95_ = grid_position_to_string (&cur);
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp96_ = _tmp95_;
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp97_ = grid_position_to_string (&free);
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp98_ = _tmp97_;
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_ = g_strconcat ("moving ", _tmp96_, " to ", _tmp98_, NULL);
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp100_ = _tmp99_;
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									g_debug ("grid.vala:437: %s", _tmp100_);
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp100_);
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp98_);
#line 437 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp96_);
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp101_ = cur;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_ = free;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_.from = _tmp101_;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_.to = _tmp102_;
#line 439 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									mov = _tmp103_;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp104_ = to_move;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp105_ = mov;
#line 440 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, &_tmp105_);
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_ = self->priv->_grid;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106__length1 = self->priv->_grid_length1;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106__length2 = self->priv->_grid_length2;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp107_ = cur;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_ = _tmp107_.row;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp109_ = cur;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp110_ = _tmp109_.col;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_] = (guint) 0;
#line 442 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp111_ = _tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_];
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_ = self->priv->_grid;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112__length1 = self->priv->_grid_length1;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112__length2 = self->priv->_grid_length2;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp113_ = free;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp114_ = _tmp113_.row;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp115_ = free;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp116_ = _tmp115_.col;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp117_ = val;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_] = _tmp117_;
#line 443 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp118_ = _tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_];
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp119_ = free.col;
#line 445 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = _tmp119_ - 1;
#line 3040 "grid.c"
								}
							}
						}
					}
				}
			}
		}
	}
}


gboolean grid_is_finished (Grid* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 451 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 453 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = _grid_grid_is_full (self);
#line 453 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (!_tmp0_) {
#line 454 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 454 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3065 "grid.c"
	}
	{
		gint i = 0;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 3071 "grid.c"
		{
			gboolean _tmp1_ = FALSE;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp1_ = TRUE;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 3078 "grid.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp1_) {
#line 3083 "grid.c"
					gint _tmp2_ = 0;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp2_ = i;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp2_ + 1;
#line 3089 "grid.c"
				}
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp1_ = FALSE;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = i;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp4_ = self->priv->_rows;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 3101 "grid.c"
				}
				{
					gint j = 0;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 3107 "grid.c"
					{
						gboolean _tmp5_ = FALSE;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp5_ = TRUE;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 3114 "grid.c"
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							guint val = 0U;
							guint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							guint _tmp12_ = 0U;
							gboolean _tmp13_ = FALSE;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gboolean _tmp21_ = FALSE;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp5_) {
#line 3132 "grid.c"
								gint _tmp6_ = 0;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp6_ = j;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp6_ + 1;
#line 3138 "grid.c"
							}
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp5_ = FALSE;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp7_ = j;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8_ = self->priv->_cols;
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp7_ < _tmp8_)) {
#line 458 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 3150 "grid.c"
							}
#line 460 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9_ = self->priv->_grid;
#line 460 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9__length1 = self->priv->_grid_length1;
#line 460 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9__length2 = self->priv->_grid_length2;
#line 460 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = i;
#line 460 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = j;
#line 460 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 460 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							val = _tmp12_;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = i;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = self->priv->_rows;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp14_ < (_tmp15_ - 1)) {
#line 3172 "grid.c"
								guint _tmp16_ = 0U;
								guint* _tmp17_ = NULL;
								gint _tmp17__length1 = 0;
								gint _tmp17__length2 = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								guint _tmp20_ = 0U;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp16_ = val;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp17_ = self->priv->_grid;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp17__length1 = self->priv->_grid_length1;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp17__length2 = self->priv->_grid_length2;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp18_ = i;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp19_ = j;
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp20_ = _tmp17_[((_tmp18_ + 1) * _tmp17__length2) + _tmp19_];
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp13_ = _tmp16_ == _tmp20_;
#line 3196 "grid.c"
							} else {
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp13_ = FALSE;
#line 3200 "grid.c"
							}
#line 462 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp13_) {
#line 463 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								result = FALSE;
#line 463 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								return result;
#line 3208 "grid.c"
							}
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp22_ = j;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp23_ = self->priv->_cols;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp22_ < (_tmp23_ - 1)) {
#line 3216 "grid.c"
								guint _tmp24_ = 0U;
								guint* _tmp25_ = NULL;
								gint _tmp25__length1 = 0;
								gint _tmp25__length2 = 0;
								gint _tmp26_ = 0;
								gint _tmp27_ = 0;
								guint _tmp28_ = 0U;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp24_ = val;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp25_ = self->priv->_grid;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp25__length1 = self->priv->_grid_length1;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp25__length2 = self->priv->_grid_length2;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp26_ = i;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp27_ = j;
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + (_tmp27_ + 1)];
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp21_ = _tmp24_ == _tmp28_;
#line 3240 "grid.c"
							} else {
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp21_ = FALSE;
#line 3244 "grid.c"
							}
#line 465 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp21_) {
#line 466 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								result = FALSE;
#line 466 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								return result;
#line 3252 "grid.c"
							}
						}
					}
				}
			}
		}
	}
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = TRUE;
#line 470 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3264 "grid.c"
}


guint grid_get (Grid* self, gint row, gint col) {
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	guint _tmp8_ = 0U;
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 475 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = row;
#line 475 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = self->priv->_rows;
#line 475 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp1_ >= _tmp2_) {
#line 475 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp0_ = TRUE;
#line 3289 "grid.c"
	} else {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 475 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp3_ = col;
#line 475 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp4_ = self->priv->_cols;
#line 475 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp0_ = _tmp3_ >= _tmp4_;
#line 3299 "grid.c"
	}
#line 475 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp0_) {
#line 476 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = (guint) 0;
#line 476 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3307 "grid.c"
	}
#line 478 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5_ = self->priv->_grid;
#line 478 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5__length1 = self->priv->_grid_length1;
#line 478 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5__length2 = self->priv->_grid_length2;
#line 478 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp6_ = row;
#line 478 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp7_ = col;
#line 478 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 478 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp8_;
#line 478 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3325 "grid.c"
}


gchar* grid_save (Grid* self) {
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 483 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = g_strdup ("");
#line 483 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp0_;
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = ret;
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = self->priv->_rows;
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = _tmp3_;
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5_ = g_strconcat (_tmp4_, " ", NULL);
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp6_ = _tmp5_;
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp7_ = g_strconcat (_tmp1_, _tmp6_, NULL);
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (ret);
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp7_;
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp6_);
#line 485 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp4_);
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp8_ = ret;
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp9_ = self->priv->_cols;
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp11_ = _tmp10_;
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp13_ = _tmp12_;
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp14_ = g_strconcat (_tmp8_, _tmp13_, NULL);
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (ret);
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp14_;
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp13_);
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp11_);
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp15_ = ret;
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp16_ = _grid_convert_to_string (self);
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp17_ = _tmp16_;
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (ret);
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp18_;
#line 488 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp17_);
#line 490 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = ret;
#line 490 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3419 "grid.c"
}


gboolean grid_load (Grid* self, const gchar* content) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 493 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 493 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (content != NULL, FALSE);
#line 495 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = content;
#line 495 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = _grid_load_from_string (self, _tmp0_);
#line 495 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp1_;
#line 495 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3439 "grid.c"
}


gchar* grid_to_string (Grid* self) {
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 498 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 500 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = g_strdup ("\n");
#line 500 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp0_;
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = ret;
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = _grid_convert_to_string (self);
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = _tmp2_;
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (ret);
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp4_;
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp3_);
#line 502 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = ret;
#line 502 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3475 "grid.c"
}


static gchar* _grid_convert_to_string (Grid* self) {
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_ = NULL;
#line 505 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 507 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = g_strdup ("");
#line 507 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp0_;
#line 3489 "grid.c"
	{
		guint i = 0U;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = (guint) 0;
#line 3494 "grid.c"
		{
			gboolean _tmp1_ = FALSE;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp1_ = TRUE;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 3501 "grid.c"
				guint _tmp3_ = 0U;
				gint _tmp4_ = 0;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp1_) {
#line 3506 "grid.c"
					guint _tmp2_ = 0U;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp2_ = i;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp2_ + 1;
#line 3512 "grid.c"
				}
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp1_ = FALSE;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = i;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp4_ = self->priv->_rows;
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp3_ < ((guint) _tmp4_))) {
#line 509 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 3524 "grid.c"
				}
				{
					guint j = 0U;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = (guint) 0;
#line 3530 "grid.c"
					{
						gboolean _tmp5_ = FALSE;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp5_ = TRUE;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 3537 "grid.c"
							guint _tmp7_ = 0U;
							gint _tmp8_ = 0;
							const gchar* _tmp9_ = NULL;
							guint _tmp10_ = 0U;
							gint _tmp11_ = 0;
							const gchar* _tmp12_ = NULL;
							guint* _tmp13_ = NULL;
							gint _tmp13__length1 = 0;
							gint _tmp13__length2 = 0;
							guint _tmp14_ = 0U;
							guint _tmp15_ = 0U;
							guint _tmp16_ = 0U;
							gchar* _tmp17_ = NULL;
							gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp5_) {
#line 3555 "grid.c"
								guint _tmp6_ = 0U;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp6_ = j;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp6_ + 1;
#line 3561 "grid.c"
							}
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp5_ = FALSE;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp7_ = j;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8_ = self->priv->_cols;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp7_ < ((guint) _tmp8_))) {
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 3573 "grid.c"
							}
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = j;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = self->priv->_cols;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp10_ == ((guint) (_tmp11_ - 1))) {
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp9_ = "\n";
#line 3583 "grid.c"
							} else {
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp9_ = " ";
#line 3587 "grid.c"
							}
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = ret;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = self->priv->_grid;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13__length1 = self->priv->_grid_length1;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13__length2 = self->priv->_grid_length2;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = i;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = j;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17_ = g_strdup_printf ("%u%s", _tmp16_, _tmp9_);
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_ = _tmp17_;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19_ = g_strconcat (_tmp12_, _tmp18_, NULL);
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_g_free0 (ret);
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							ret = _tmp19_;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_g_free0 (_tmp18_);
#line 3615 "grid.c"
						}
					}
				}
			}
		}
	}
#line 513 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = ret;
#line 513 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3626 "grid.c"
}


static guint* _vala_array_dup2 (guint* self, int length) {
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return g_memdup (self, length * sizeof (guint));
#line 3633 "grid.c"
}


static gboolean _grid_load_from_string (Grid* self, const gchar* contents) {
	gboolean result = FALSE;
	gint rows = 0;
	gint cols = 0;
	gchar** lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gchar** tokens = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	guint* grid = NULL;
	gint grid_length1 = 0;
	gint grid_length2 = 0;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	guint* _tmp22_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	guint* _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	gint _tmp48__length2 = 0;
	guint* _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	gint _tmp49__length2 = 0;
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (contents != NULL, FALSE);
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	rows = 0;
#line 519 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	cols = 0;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = contents;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "\n", 0);
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	lines = _tmp2_;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	lines_length1 = _vala_array_length (_tmp1_);
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_lines_size_ = lines_length1;
#line 527 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = lines;
#line 527 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3__length1 = lines_length1;
#line 527 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp3__length1 < 3) {
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid = (g_free (grid), NULL);
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 528 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3722 "grid.c"
	}
#line 530 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = lines;
#line 530 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4__length1 = lines_length1;
#line 530 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5_ = _tmp4_[0];
#line 530 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, " ", 0);
#line 530 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 530 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	tokens = _tmp7_;
#line 530 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	tokens_length1 = _vala_array_length (_tmp6_);
#line 530 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tokens_size_ = tokens_length1;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp8_ = tokens;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp8__length1 = tokens_length1;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp8__length1 != 2) {
#line 532 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 532 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid = (g_free (grid), NULL);
#line 532 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 532 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 532 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3756 "grid.c"
	}
#line 534 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp9_ = tokens;
#line 534 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp9__length1 = tokens_length1;
#line 534 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp10_ = _tmp9_[0];
#line 534 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp11_ = atoi (_tmp10_);
#line 534 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	rows = _tmp11_;
#line 535 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp12_ = tokens;
#line 535 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp12__length1 = tokens_length1;
#line 535 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp13_ = _tmp12_[1];
#line 535 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp14_ = atoi (_tmp13_);
#line 535 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	cols = _tmp14_;
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp16_ = rows;
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp16_ < 2) {
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp15_ = TRUE;
#line 3784 "grid.c"
	} else {
		gint _tmp17_ = 0;
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp17_ = cols;
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp15_ = _tmp17_ < 2;
#line 3791 "grid.c"
	}
#line 537 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp15_) {
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid = (g_free (grid), NULL);
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3805 "grid.c"
	}
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp18_ = lines;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp18__length1 = lines_length1;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp19_ = rows;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp18__length1 < (_tmp19_ + 1)) {
#line 541 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 541 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid = (g_free (grid), NULL);
#line 541 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 541 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 541 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3825 "grid.c"
	}
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp20_ = rows;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp21_ = cols;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp22_ = g_new0 (guint, _tmp20_ * _tmp21_);
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid = (g_free (grid), NULL);
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid = _tmp22_;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid_length1 = _tmp20_;
#line 543 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid_length2 = _tmp21_;
#line 3841 "grid.c"
	{
		gint i = 0;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 3846 "grid.c"
		{
			gboolean _tmp23_ = FALSE;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp23_ = TRUE;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 3853 "grid.c"
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gint _tmp28_ = 0;
				const gchar* _tmp29_ = NULL;
				gchar** _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gchar** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp33_ = 0;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp23_) {
#line 3867 "grid.c"
					gint _tmp24_ = 0;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp24_ = i;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp24_ + 1;
#line 3873 "grid.c"
				}
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp23_ = FALSE;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp25_ = i;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp26_ = rows;
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp25_ < _tmp26_)) {
#line 545 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 3885 "grid.c"
				}
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp27_ = lines;
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp27__length1 = lines_length1;
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp28_ = i;
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp29_ = _tmp27_[_tmp28_ + 1];
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, " ", 0);
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				tokens = _tmp31_;
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				tokens_length1 = _vala_array_length (_tmp30_);
#line 547 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tokens_size_ = tokens_length1;
#line 549 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp32_ = tokens;
#line 549 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp32__length1 = tokens_length1;
#line 549 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp33_ = cols;
#line 549 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (_tmp32__length1 != _tmp33_) {
#line 550 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					result = FALSE;
#line 550 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					grid = (g_free (grid), NULL);
#line 550 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 550 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 550 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					return result;
#line 3923 "grid.c"
				}
				{
					gint j = 0;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 3929 "grid.c"
					{
						gboolean _tmp34_ = FALSE;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp34_ = TRUE;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 3936 "grid.c"
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							guint* _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp38__length2 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gchar** _tmp41_ = NULL;
							gint _tmp41__length1 = 0;
							gint _tmp42_ = 0;
							const gchar* _tmp43_ = NULL;
							gint _tmp44_ = 0;
							guint _tmp45_ = 0U;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp34_) {
#line 3952 "grid.c"
								gint _tmp35_ = 0;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp35_ = j;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp35_ + 1;
#line 3958 "grid.c"
							}
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp34_ = FALSE;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp36_ = j;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp37_ = cols;
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp36_ < _tmp37_)) {
#line 552 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 3970 "grid.c"
							}
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp38_ = grid;
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp38__length1 = grid_length1;
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp38__length2 = grid_length2;
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp39_ = i;
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp40_ = j;
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp41_ = tokens;
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp41__length1 = tokens_length1;
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp42_ = j;
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp43_ = _tmp41_[_tmp42_];
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp44_ = atoi (_tmp43_);
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_] = (guint) _tmp44_;
#line 553 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp45_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
#line 3996 "grid.c"
						}
					}
				}
			}
		}
	}
#line 556 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp46_ = rows;
#line 556 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_rows = _tmp46_;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp47_ = cols;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_cols = _tmp47_;
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp48_ = grid;
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp48__length1 = grid_length1;
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp48__length2 = grid_length2;
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup2 (_tmp48_, _tmp48__length1 * _tmp48__length2) : ((gpointer) _tmp48_);
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp49__length1 = _tmp48__length1;
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp49__length2 = _tmp48__length2;
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid = _tmp49_;
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid_length1 = _tmp49__length1;
#line 558 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid_length2 = _tmp49__length2;
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = TRUE;
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid = (g_free (grid), NULL);
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4041 "grid.c"
}


static gboolean _grid_grid_is_full (Grid* self) {
	gboolean result = FALSE;
#line 563 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 4049 "grid.c"
	{
		guint i = 0U;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = (guint) 0;
#line 4054 "grid.c"
		{
			gboolean _tmp0_ = FALSE;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp0_ = TRUE;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 4061 "grid.c"
				guint _tmp2_ = 0U;
				gint _tmp3_ = 0;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp0_) {
#line 4066 "grid.c"
					guint _tmp1_ = 0U;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp1_ = i;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp1_ + 1;
#line 4072 "grid.c"
				}
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp0_ = FALSE;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp2_ = i;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = self->priv->_rows;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp2_ < ((guint) _tmp3_))) {
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 4084 "grid.c"
				}
				{
					guint j = 0U;
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = (guint) 0;
#line 4090 "grid.c"
					{
						gboolean _tmp4_ = FALSE;
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp4_ = TRUE;
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 4097 "grid.c"
							guint _tmp6_ = 0U;
							gint _tmp7_ = 0;
							guint* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							guint _tmp9_ = 0U;
							guint _tmp10_ = 0U;
							guint _tmp11_ = 0U;
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp4_) {
#line 4108 "grid.c"
								guint _tmp5_ = 0U;
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp5_ = j;
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp5_ + 1;
#line 4114 "grid.c"
							}
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp4_ = FALSE;
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp6_ = j;
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp7_ = self->priv->_cols;
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp6_ < ((guint) _tmp7_))) {
#line 566 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 4126 "grid.c"
							}
#line 567 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8_ = self->priv->_grid;
#line 567 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8__length1 = self->priv->_grid_length1;
#line 567 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8__length2 = self->priv->_grid_length2;
#line 567 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9_ = i;
#line 567 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = j;
#line 567 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
#line 567 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp11_ == ((guint) 0)) {
#line 568 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								result = FALSE;
#line 568 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								return result;
#line 4146 "grid.c"
							}
						}
					}
				}
			}
		}
	}
#line 570 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = TRUE;
#line 570 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4158 "grid.c"
}


static void _grid_random_position (Grid* self, GridPosition* result) {
	GridPosition ret = {0};
	gint _tmp0_ = 0;
	gint32 _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint32 _tmp3_ = 0;
	GridPosition _tmp4_ = {0};
#line 573 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_rows;
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp0_));
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = self->priv->_cols;
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp2_));
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_.row = (guint) _tmp1_;
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_.col = (guint) _tmp3_;
#line 575 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp4_;
#line 578 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	*result = ret;
#line 578 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return;
#line 4189 "grid.c"
}


static void _grid_check_target_value_reached (Grid* self, guint val) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
#line 581 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 583 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = self->priv->_target_value;
#line 583 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 4202 "grid.c"
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
#line 583 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp2_ = val;
#line 583 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp3_ = self->priv->_target_value;
#line 583 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp0_ = _tmp2_ == _tmp3_;
#line 4211 "grid.c"
	} else {
#line 583 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp0_ = FALSE;
#line 4215 "grid.c"
	}
#line 583 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp0_) {
#line 584 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid_set_target_value_reached (self, TRUE);
#line 4221 "grid.c"
	}
}


gint grid_get_rows (Grid* self) {
	gint result;
	gint _tmp0_ = 0;
#line 34 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_rows;
#line 34 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp0_;
#line 34 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4237 "grid.c"
}


void grid_set_rows (Grid* self, gint value) {
	gint _tmp0_ = 0;
#line 34 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 34 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = value;
#line 34 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_rows = _tmp0_;
#line 34 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_notify ((GObject *) self, "rows");
#line 4251 "grid.c"
}


gint grid_get_cols (Grid* self) {
	gint result;
	gint _tmp0_ = 0;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_cols;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp0_;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4266 "grid.c"
}


void grid_set_cols (Grid* self, gint value) {
	gint _tmp0_ = 0;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = value;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_cols = _tmp0_;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_notify ((GObject *) self, "cols");
#line 4280 "grid.c"
}


guint grid_get_target_value (Grid* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_target_value;
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp0_;
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4295 "grid.c"
}


void grid_set_target_value (Grid* self, guint value) {
	guint _tmp0_ = 0U;
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = value;
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_target_value = _tmp0_;
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_notify ((GObject *) self, "target-value");
#line 4309 "grid.c"
}


gboolean grid_get_target_value_reached (Grid* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_target_value_reached;
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp0_;
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4324 "grid.c"
}


void grid_set_target_value_reached (Grid* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = value;
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_target_value_reached = _tmp0_;
#line 46 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_notify ((GObject *) self, "target-value-reached");
#line 4338 "grid.c"
}


static void grid_class_init (GridClass * klass) {
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid_parent_class = g_type_class_peek_parent (klass);
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_type_class_add_private (klass, sizeof (GridPrivate));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_grid_get_property;
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_grid_set_property;
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	G_OBJECT_CLASS (klass)->finalize = grid_finalize;
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_ROWS, g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_COLS, g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE, g_param_spec_uint ("target-value", "target-value", "target-value", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE_REACHED, g_param_spec_boolean ("target-value-reached", "target-value-reached", "target-value-reached", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4361 "grid.c"
}


static void grid_instance_init (Grid * self) {
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv = GRID_GET_PRIVATE (self);
#line 4368 "grid.c"
}


static void grid_finalize (GObject* obj) {
	Grid * self;
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GRID, Grid);
#line 22 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	G_OBJECT_CLASS (grid_parent_class)->finalize (obj);
#line 4380 "grid.c"
}


GType grid_get_type (void) {
	static volatile gsize grid_type_id__volatile = 0;
	if (g_once_init_enter (&grid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Grid), 0, (GInstanceInitFunc) grid_instance_init, NULL };
		GType grid_type_id;
		grid_type_id = g_type_register_static (G_TYPE_OBJECT, "Grid", &g_define_type_info, 0);
		g_once_init_leave (&grid_type_id__volatile, grid_type_id);
	}
	return grid_type_id__volatile;
}


static void _vala_grid_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRID, Grid);
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	switch (property_id) {
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_ROWS:
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		g_value_set_int (value, grid_get_rows (self));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_COLS:
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		g_value_set_int (value, grid_get_cols (self));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_TARGET_VALUE:
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		g_value_set_uint (value, grid_get_target_value (self));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_TARGET_VALUE_REACHED:
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		g_value_set_boolean (value, grid_get_target_value_reached (self));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 4425 "grid.c"
		default:
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 4431 "grid.c"
	}
}


static void _vala_grid_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRID, Grid);
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	switch (property_id) {
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_ROWS:
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid_set_rows (self, g_value_get_int (value));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_COLS:
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid_set_cols (self, g_value_get_int (value));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_TARGET_VALUE:
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid_set_target_value (self, g_value_get_uint (value));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_TARGET_VALUE_REACHED:
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid_set_target_value_reached (self, g_value_get_boolean (value));
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 4465 "grid.c"
		default:
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 4471 "grid.c"
	}
}


gchar* grid_position_to_string (GridPosition *self) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = (*self).row;
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = _tmp1_;
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = (*self).col;
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5_ = _tmp4_;
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp6_ = g_strconcat ("(", _tmp2_, ",", _tmp5_, ")", NULL);
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp7_ = _tmp6_;
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp5_);
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp2_);
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp7_;
#line 595 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4510 "grid.c"
}


GridPosition* grid_position_dup (const GridPosition* self) {
	GridPosition* dup;
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	dup = g_new0 (GridPosition, 1);
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	memcpy (dup, self, sizeof (GridPosition));
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return dup;
#line 4522 "grid.c"
}


void grid_position_free (GridPosition* self) {
#line 588 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_free (self);
#line 4529 "grid.c"
}


GType grid_position_get_type (void) {
	static volatile gsize grid_position_type_id__volatile = 0;
	if (g_once_init_enter (&grid_position_type_id__volatile)) {
		GType grid_position_type_id;
		grid_position_type_id = g_boxed_type_register_static ("GridPosition", (GBoxedCopyFunc) grid_position_dup, (GBoxedFreeFunc) grid_position_free);
		g_once_init_leave (&grid_position_type_id__volatile, grid_position_type_id);
	}
	return grid_position_type_id__volatile;
}


TileMovement* tile_movement_dup (const TileMovement* self) {
	TileMovement* dup;
#line 599 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	dup = g_new0 (TileMovement, 1);
#line 599 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	memcpy (dup, self, sizeof (TileMovement));
#line 599 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return dup;
#line 4552 "grid.c"
}


void tile_movement_free (TileMovement* self) {
#line 599 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_free (self);
#line 4559 "grid.c"
}


GType tile_movement_get_type (void) {
	static volatile gsize tile_movement_type_id__volatile = 0;
	if (g_once_init_enter (&tile_movement_type_id__volatile)) {
		GType tile_movement_type_id;
		tile_movement_type_id = g_boxed_type_register_static ("TileMovement", (GBoxedCopyFunc) tile_movement_dup, (GBoxedFreeFunc) tile_movement_free);
		g_once_init_leave (&tile_movement_type_id__volatile, tile_movement_type_id);
	}
	return tile_movement_type_id__volatile;
}


Tile* tile_dup (const Tile* self) {
	Tile* dup;
#line 605 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	dup = g_new0 (Tile, 1);
#line 605 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	memcpy (dup, self, sizeof (Tile));
#line 605 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return dup;
#line 4582 "grid.c"
}


void tile_free (Tile* self) {
#line 605 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_free (self);
#line 4589 "grid.c"
}


GType tile_get_type (void) {
	static volatile gsize tile_type_id__volatile = 0;
	if (g_once_init_enter (&tile_type_id__volatile)) {
		GType tile_type_id;
		tile_type_id = g_boxed_type_register_static ("Tile", (GBoxedCopyFunc) tile_dup, (GBoxedFreeFunc) tile_free);
		g_once_init_leave (&tile_type_id__volatile, tile_type_id);
	}
	return tile_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



