/* grid.c generated by valac 0.31.1.11-094fd, the Vala compiler
 * generated from grid.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;
typedef struct _GridPrivate GridPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TILE (tile_get_type ())

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;
typedef struct _Tile Tile;

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())
typedef struct _TileMovement TileMovement;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Grid {
	GObject parent_instance;
	GridPrivate * priv;
};

struct _GridClass {
	GObjectClass parent_class;
};

struct _GridPrivate {
	guint* _grid;
	gint _grid_length1;
	gint _grid_length2;
	gint _rows;
	gint _cols;
	guint _target_value;
	gboolean _target_value_reached;
};

struct _GridPosition {
	guint row;
	guint col;
};

struct _Tile {
	GridPosition pos;
	guint val;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};


static gpointer grid_parent_class = NULL;

GType grid_get_type (void) G_GNUC_CONST;
#define GRID_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GRID, GridPrivate))
enum  {
	GRID_DUMMY_PROPERTY,
	GRID_ROWS,
	GRID_COLS,
	GRID_TARGET_VALUE,
	GRID_TARGET_VALUE_REACHED
};
Grid* grid_new (gint rows, gint cols);
Grid* grid_construct (GType object_type, gint rows, gint cols);
void grid_clear (Grid* self);
Grid* grid_clone (Grid* self);
static guint* _vala_array_dup1 (guint* self, int length);
GType tile_get_type (void) G_GNUC_CONST;
GType grid_position_get_type (void) G_GNUC_CONST;
GridPosition* grid_position_dup (const GridPosition* self);
void grid_position_free (GridPosition* self);
Tile* tile_dup (const Tile* self);
void tile_free (Tile* self);
gboolean grid_new_tile (Grid* self, Tile* tile);
static gboolean _grid_grid_is_full (Grid* self);
static void _grid_random_position (Grid* self, GridPosition* result);
static void _grid_check_target_value_reached (Grid* self, guint val);
GType tile_movement_get_type (void) G_GNUC_CONST;
TileMovement* tile_movement_dup (const TileMovement* self);
void tile_movement_free (TileMovement* self);
void grid_move_down (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
gchar* grid_position_to_string (GridPosition *self);
void grid_move_up (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_left (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_right (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
gboolean grid_is_finished (Grid* self);
guint grid_get (Grid* self, gint row, gint col);
gchar* grid_save (Grid* self);
static gchar* _grid_convert_to_string (Grid* self);
gboolean grid_load (Grid* self, const gchar* content);
static gboolean _grid_load_from_string (Grid* self, const gchar* contents);
gchar* grid_to_string (Grid* self);
static guint* _vala_array_dup2 (guint* self, int length);
guint grid_get_target_value (Grid* self);
void grid_set_target_value_reached (Grid* self, gboolean value);
gint grid_get_rows (Grid* self);
void grid_set_rows (Grid* self, gint value);
gint grid_get_cols (Grid* self);
void grid_set_cols (Grid* self, gint value);
void grid_set_target_value (Grid* self, guint value);
gboolean grid_get_target_value_reached (Grid* self);
static void grid_finalize (GObject* obj);
static void _vala_grid_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_grid_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


Grid* grid_construct (GType object_type, gint rows, gint cols) {
	Grid * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	guint* _tmp4_ = NULL;
#line 25 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = rows;
#line 25 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = cols;
#line 25 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self = (Grid*) g_object_new (object_type, "rows", _tmp0_, "cols", _tmp1_, NULL);
#line 27 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = rows;
#line 27 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = cols;
#line 27 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = g_new0 (guint, _tmp2_ * _tmp3_);
#line 27 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
#line 27 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid = _tmp4_;
#line 27 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid_length1 = _tmp2_;
#line 27 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid_length2 = _tmp3_;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid_clear (self);
#line 29 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_target_value = (guint) 0;
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return self;
#line 178 "grid.c"
}


Grid* grid_new (gint rows, gint cols) {
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return grid_construct (TYPE_GRID, rows, cols);
#line 185 "grid.c"
}


static guint* _vala_array_dup1 (guint* self, int length) {
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return g_memdup (self, length * sizeof (guint));
#line 192 "grid.c"
}


Grid* grid_clone (Grid* self) {
	Grid* result = NULL;
	Grid* grid = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Grid* _tmp2_ = NULL;
	guint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	guint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	guint _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
#line 48 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_rows;
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = self->priv->_cols;
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = grid_new (_tmp0_, _tmp1_);
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid = _tmp2_;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = self->priv->_grid;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3__length1 = self->priv->_grid_length1;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3__length2 = self->priv->_grid_length2;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : ((gpointer) _tmp3_);
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4__length1 = _tmp3__length1;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4__length2 = _tmp3__length2;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_grid = (g_free (grid->priv->_grid), NULL);
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_grid = _tmp4_;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_grid_length1 = _tmp4__length1;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_grid_length2 = _tmp4__length2;
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5_ = self->priv->_target_value;
#line 52 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_target_value = _tmp5_;
#line 53 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp6_ = self->priv->_target_value_reached;
#line 53 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid->priv->_target_value_reached = _tmp6_;
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = grid;
#line 55 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 252 "grid.c"
}


void grid_clear (Grid* self) {
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 259 "grid.c"
	{
		guint i = 0U;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = (guint) 0;
#line 264 "grid.c"
		{
			gboolean _tmp0_ = FALSE;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp0_ = TRUE;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 271 "grid.c"
				guint _tmp2_ = 0U;
				guint* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gint _tmp3__length2 = 0;
				gint _tmp4_ = 0;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp0_) {
#line 279 "grid.c"
					guint _tmp1_ = 0U;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp1_ = i;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp1_ + 1;
#line 285 "grid.c"
				}
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp0_ = FALSE;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp2_ = i;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = self->priv->_grid;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3__length1 = self->priv->_grid_length1;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3__length2 = self->priv->_grid_length2;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp4_ = _tmp3__length1;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp2_ < ((guint) _tmp4_))) {
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 303 "grid.c"
				}
				{
					guint j = 0U;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = (guint) 0;
#line 309 "grid.c"
					{
						gboolean _tmp5_ = FALSE;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp5_ = TRUE;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 316 "grid.c"
							guint _tmp7_ = 0U;
							guint* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							guint* _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp10__length2 = 0;
							guint _tmp11_ = 0U;
							guint _tmp12_ = 0U;
							guint _tmp13_ = 0U;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp5_) {
#line 330 "grid.c"
								guint _tmp6_ = 0U;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp6_ = j;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp6_ + 1;
#line 336 "grid.c"
							}
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp5_ = FALSE;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp7_ = j;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8_ = self->priv->_grid;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8__length1 = self->priv->_grid_length1;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8__length2 = self->priv->_grid_length2;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9_ = _tmp8__length2;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp7_ < ((guint) _tmp9_))) {
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 354 "grid.c"
							}
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = self->priv->_grid;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10__length1 = self->priv->_grid_length1;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10__length2 = self->priv->_grid_length2;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = i;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = j;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_] = (guint) 0;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 370 "grid.c"
						}
					}
				}
			}
		}
	}
}


gboolean grid_new_tile (Grid* self, Tile* tile) {
	Tile _vala_tile = {0};
	gboolean result = FALSE;
	GridPosition pos = {0};
	GridPosition _tmp0_ = {0};
	guint val = 0U;
	GridPosition _tmp1_ = {0};
	Tile _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_.row = (guint) 0;
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_.col = (guint) 0;
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	pos = _tmp0_;
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = pos;
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_.pos = _tmp1_;
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_.val = (guint) 0;
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_vala_tile = _tmp2_;
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = _grid_grid_is_full (self);
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp3_) {
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		if (tile) {
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			*tile = _vala_tile;
#line 415 "grid.c"
		}
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 419 "grid.c"
	}
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	val = (guint) 2;
#line 79 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	while (TRUE) {
#line 425 "grid.c"
		GridPosition _tmp4_ = {0};
		guint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		GridPosition _tmp6_ = {0};
		guint _tmp7_ = 0U;
		GridPosition _tmp8_ = {0};
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
#line 80 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_grid_random_position (self, &_tmp4_);
#line 80 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		pos = _tmp4_;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp5_ = self->priv->_grid;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp5__length1 = self->priv->_grid_length1;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp5__length2 = self->priv->_grid_length2;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp6_ = pos;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp7_ = _tmp6_.row;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp8_ = pos;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp9_ = _tmp8_.col;
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp10_ = _tmp5_[(_tmp7_ * _tmp5__length2) + _tmp9_];
#line 82 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		if (_tmp10_ == ((guint) 0)) {
#line 457 "grid.c"
			guint* _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			gint _tmp11__length2 = 0;
			GridPosition _tmp12_ = {0};
			guint _tmp13_ = 0U;
			GridPosition _tmp14_ = {0};
			guint _tmp15_ = 0U;
			guint _tmp16_ = 0U;
			guint _tmp17_ = 0U;
			guint _tmp18_ = 0U;
			GridPosition _tmp19_ = {0};
			guint _tmp20_ = 0U;
			Tile _tmp21_ = {0};
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp11_ = self->priv->_grid;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp11__length1 = self->priv->_grid_length1;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp11__length2 = self->priv->_grid_length2;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp12_ = pos;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp13_ = _tmp12_.row;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp14_ = pos;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp15_ = _tmp14_.col;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp16_ = val;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp11_[(_tmp13_ * _tmp11__length2) + _tmp15_] = _tmp16_;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp17_ = _tmp11_[(_tmp13_ * _tmp11__length2) + _tmp15_];
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp18_ = val;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_grid_check_target_value_reached (self, _tmp18_);
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp19_ = pos;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp20_ = val;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp21_.pos = _tmp19_;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp21_.val = _tmp20_;
#line 85 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_vala_tile = _tmp21_;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			result = TRUE;
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			if (tile) {
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				*tile = _vala_tile;
#line 511 "grid.c"
			}
#line 86 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			return result;
#line 515 "grid.c"
		}
	}
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (tile) {
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		*tile = _vala_tile;
#line 522 "grid.c"
	}
}


void grid_move_down (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint row = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_move != NULL);
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_hide != NULL);
#line 91 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_show != NULL);
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = to_move;
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = to_hide;
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = to_show;
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 559 "grid.c"
	{
		gint i = 0;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 564 "grid.c"
		{
			gboolean _tmp3_ = FALSE;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp3_ = TRUE;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 571 "grid.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				GridPosition _tmp9_ = {0};
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp3_) {
#line 579 "grid.c"
					gint _tmp4_ = 0;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp4_ = i;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp4_ + 1;
#line 585 "grid.c"
				}
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = FALSE;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp5_ = i;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp6_ = self->priv->_cols;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 597 "grid.c"
				}
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp7_ = self->priv->_rows;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_ = i;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp9_.row = (guint) _tmp7_;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp9_.col = (guint) _tmp8_;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				free = _tmp9_;
#line 609 "grid.c"
				{
					gint j = 0;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 614 "grid.c"
					{
						gboolean _tmp10_ = FALSE;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp10_ = TRUE;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 621 "grid.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							GridPosition _tmp18_ = {0};
							guint* _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							gint _tmp19__length2 = 0;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							GridPosition _tmp22_ = {0};
							guint _tmp23_ = 0U;
							guint _tmp24_ = 0U;
							guint _tmp25_ = 0U;
							GridPosition _tmp30_ = {0};
							gboolean _tmp47_ = FALSE;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp10_) {
#line 642 "grid.c"
								gint _tmp11_ = 0;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp11_ = j;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp11_ + 1;
#line 648 "grid.c"
							}
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = FALSE;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = j;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = self->priv->_rows;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 660 "grid.c"
							}
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = self->priv->_rows;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = j;
#line 112 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							row = (_tmp14_ - _tmp15_) - 1;
#line 113 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_ = row;
#line 113 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17_ = i;
#line 113 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_.row = (guint) _tmp16_;
#line 113 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_.col = (guint) _tmp17_;
#line 113 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							cur = _tmp18_;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19_ = self->priv->_grid;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19__length1 = self->priv->_grid_length1;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19__length2 = self->priv->_grid_length2;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp20_ = cur;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp21_ = _tmp20_.row;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp22_ = cur;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp23_ = _tmp22_.col;
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp24_ = _tmp19_[(_tmp21_ * _tmp19__length2) + _tmp23_];
#line 114 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							val = _tmp24_;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp25_ = val;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp25_ == ((guint) 0)) {
#line 700 "grid.c"
								GridPosition _tmp26_ = {0};
								guint _tmp27_ = 0U;
								gint _tmp28_ = 0;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp26_ = free;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp27_ = _tmp26_.row;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp28_ = self->priv->_rows;
#line 117 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp27_ == ((guint) _tmp28_)) {
#line 712 "grid.c"
									gint _tmp29_ = 0;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp29_ = row;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = (guint) _tmp29_;
#line 718 "grid.c"
								}
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								continue;
#line 722 "grid.c"
							}
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp30_.row = (guint) 0;
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp30_.col = (guint) 0;
#line 124 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							match = _tmp30_;
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							has_match = FALSE;
#line 732 "grid.c"
							{
								gint k = 0;
								gint _tmp31_ = 0;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp31_ = row;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								k = _tmp31_ - 1;
#line 740 "grid.c"
								{
									gboolean _tmp32_ = FALSE;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp32_ = TRUE;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									while (TRUE) {
#line 747 "grid.c"
										gint _tmp34_ = 0;
										guint k_val = 0U;
										guint* _tmp35_ = NULL;
										gint _tmp35__length1 = 0;
										gint _tmp35__length2 = 0;
										gint _tmp36_ = 0;
										GridPosition _tmp37_ = {0};
										guint _tmp38_ = 0U;
										guint _tmp39_ = 0U;
										guint _tmp40_ = 0U;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!_tmp32_) {
#line 760 "grid.c"
											gint _tmp33_ = 0;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp33_ = k;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											k = _tmp33_ - 1;
#line 766 "grid.c"
										}
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp32_ = FALSE;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp34_ = k;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!(_tmp34_ >= 0)) {
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 776 "grid.c"
										}
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35_ = self->priv->_grid;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35__length1 = self->priv->_grid_length1;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35__length2 = self->priv->_grid_length2;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp36_ = k;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp37_ = cur;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp38_ = _tmp37_.col;
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp39_ = _tmp35_[(_tmp36_ * _tmp35__length2) + _tmp38_];
#line 127 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										k_val = _tmp39_;
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp40_ = k_val;
#line 129 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (_tmp40_ != ((guint) 0)) {
#line 798 "grid.c"
											guint _tmp41_ = 0U;
											guint _tmp42_ = 0U;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp41_ = k_val;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp42_ = val;
#line 130 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											if (_tmp41_ == _tmp42_) {
#line 807 "grid.c"
												gint _tmp43_ = 0;
												GridPosition _tmp44_ = {0};
												guint _tmp45_ = 0U;
												GridPosition _tmp46_ = {0};
#line 131 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												has_match = TRUE;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp43_ = k;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_ = cur;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp45_ = _tmp44_.col;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp46_.row = (guint) _tmp43_;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp46_.col = _tmp45_;
#line 132 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												match = _tmp46_;
#line 826 "grid.c"
											}
#line 134 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 830 "grid.c"
										}
									}
								}
							}
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp47_ = has_match;
#line 138 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp47_) {
#line 839 "grid.c"
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_ = NULL;
								GridPosition _tmp52_ = {0};
								guint _tmp53_ = 0U;
								gint _tmp54_ = 0;
								GridPosition _tmp56_ = {0};
								GridPosition _tmp57_ = {0};
								TileMovement _tmp58_ = {0};
								GeeLinkedList* _tmp59_ = NULL;
								TileMovement _tmp60_ = {0};
								GridPosition _tmp61_ = {0};
								GridPosition _tmp62_ = {0};
								TileMovement _tmp63_ = {0};
								GeeLinkedList* _tmp64_ = NULL;
								TileMovement _tmp65_ = {0};
								GridPosition _tmp66_ = {0};
								guint _tmp67_ = 0U;
								Tile _tmp68_ = {0};
								GeeLinkedList* _tmp69_ = NULL;
								Tile _tmp70_ = {0};
								guint* _tmp71_ = NULL;
								gint _tmp71__length1 = 0;
								gint _tmp71__length2 = 0;
								GridPosition _tmp72_ = {0};
								guint _tmp73_ = 0U;
								GridPosition _tmp74_ = {0};
								guint _tmp75_ = 0U;
								guint _tmp76_ = 0U;
								guint* _tmp77_ = NULL;
								gint _tmp77__length1 = 0;
								gint _tmp77__length2 = 0;
								GridPosition _tmp78_ = {0};
								guint _tmp79_ = 0U;
								GridPosition _tmp80_ = {0};
								guint _tmp81_ = 0U;
								guint _tmp82_ = 0U;
								guint* _tmp83_ = NULL;
								gint _tmp83__length1 = 0;
								gint _tmp83__length2 = 0;
								GridPosition _tmp84_ = {0};
								guint _tmp85_ = 0U;
								GridPosition _tmp86_ = {0};
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
								guint _tmp89_ = 0U;
								guint _tmp90_ = 0U;
								guint _tmp91_ = 0U;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp48_ = grid_position_to_string (&match);
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp49_ = _tmp48_;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp50_ = g_strconcat ("matching tile found at ", _tmp49_, NULL);
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp51_ = _tmp50_;
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								g_debug ("grid.vala:139: %s", _tmp51_);
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp51_);
#line 139 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp49_);
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp52_ = free;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp53_ = _tmp52_.row;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp54_ = self->priv->_rows;
#line 141 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp53_ == ((guint) _tmp54_)) {
#line 911 "grid.c"
									gint _tmp55_ = 0;
#line 142 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp55_ = row;
#line 142 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = (guint) _tmp55_;
#line 917 "grid.c"
								}
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp56_ = cur;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp57_ = free;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_.from = _tmp56_;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_.to = _tmp57_;
#line 144 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp58_;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp59_ = to_hide;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_ = mov;
#line 145 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, &_tmp60_);
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp61_ = match;
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp62_ = free;
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_.from = _tmp61_;
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_.to = _tmp62_;
#line 146 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp63_;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp64_ = to_hide;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_ = mov;
#line 147 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, &_tmp65_);
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp66_ = free;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp67_ = val;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_.pos = _tmp66_;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_.val = _tmp67_ * 2;
#line 149 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								tile = _tmp68_;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp69_ = to_show;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp70_ = tile;
#line 150 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, &_tmp70_);
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_ = self->priv->_grid;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71__length1 = self->priv->_grid_length1;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71__length2 = self->priv->_grid_length2;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp72_ = cur;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp73_ = _tmp72_.row;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_ = cur;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp75_ = _tmp74_.col;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_] = (guint) 0;
#line 152 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp76_ = _tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_];
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_ = self->priv->_grid;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77__length1 = self->priv->_grid_length1;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77__length2 = self->priv->_grid_length2;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp78_ = match;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp79_ = _tmp78_.row;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_ = match;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp81_ = _tmp80_.col;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_] = (guint) 0;
#line 153 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp82_ = _tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_];
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_ = self->priv->_grid;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83__length1 = self->priv->_grid_length1;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83__length2 = self->priv->_grid_length2;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp84_ = free;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp85_ = _tmp84_.row;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp86_ = free;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp87_ = _tmp86_.col;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp88_ = val;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_] = _tmp88_ * 2;
#line 154 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp89_ = _tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_];
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp90_ = val;
#line 155 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_grid_check_target_value_reached (self, _tmp90_ * 2);
#line 157 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp91_ = free.row;
#line 157 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								free.row = _tmp91_ - 1;
#line 1031 "grid.c"
							} else {
								GridPosition _tmp92_ = {0};
								guint _tmp93_ = 0U;
								gint _tmp94_ = 0;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp92_ = free;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp93_ = _tmp92_.row;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp94_ = self->priv->_rows;
#line 158 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp93_ != ((guint) _tmp94_)) {
#line 1044 "grid.c"
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									gchar* _tmp97_ = NULL;
									gchar* _tmp98_ = NULL;
									gchar* _tmp99_ = NULL;
									gchar* _tmp100_ = NULL;
									GridPosition _tmp101_ = {0};
									GridPosition _tmp102_ = {0};
									TileMovement _tmp103_ = {0};
									GeeLinkedList* _tmp104_ = NULL;
									TileMovement _tmp105_ = {0};
									guint* _tmp106_ = NULL;
									gint _tmp106__length1 = 0;
									gint _tmp106__length2 = 0;
									GridPosition _tmp107_ = {0};
									guint _tmp108_ = 0U;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									guint _tmp111_ = 0U;
									guint* _tmp112_ = NULL;
									gint _tmp112__length1 = 0;
									gint _tmp112__length2 = 0;
									GridPosition _tmp113_ = {0};
									guint _tmp114_ = 0U;
									GridPosition _tmp115_ = {0};
									guint _tmp116_ = 0U;
									guint _tmp117_ = 0U;
									guint _tmp118_ = 0U;
									guint _tmp119_ = 0U;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp95_ = grid_position_to_string (&cur);
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp96_ = _tmp95_;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp97_ = grid_position_to_string (&free);
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp98_ = _tmp97_;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_ = g_strconcat ("moving ", _tmp96_, " to ", _tmp98_, NULL);
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp100_ = _tmp99_;
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									g_debug ("grid.vala:159: %s", _tmp100_);
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp100_);
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp98_);
#line 159 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp96_);
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp101_ = cur;
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_ = free;
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_.from = _tmp101_;
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_.to = _tmp102_;
#line 161 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									mov = _tmp103_;
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp104_ = to_move;
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp105_ = mov;
#line 162 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, &_tmp105_);
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_ = self->priv->_grid;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106__length1 = self->priv->_grid_length1;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106__length2 = self->priv->_grid_length2;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp107_ = cur;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_ = _tmp107_.row;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp109_ = cur;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp110_ = _tmp109_.col;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_] = (guint) 0;
#line 164 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp111_ = _tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_];
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_ = self->priv->_grid;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112__length1 = self->priv->_grid_length1;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112__length2 = self->priv->_grid_length2;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp113_ = free;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp114_ = _tmp113_.row;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp115_ = free;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp116_ = _tmp115_.col;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp117_ = val;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_] = _tmp117_;
#line 165 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp118_ = _tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_];
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp119_ = free.row;
#line 167 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = _tmp119_ - 1;
#line 1152 "grid.c"
								}
							}
						}
					}
				}
			}
		}
	}
}


void grid_move_up (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint row = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_move != NULL);
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_hide != NULL);
#line 173 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_show != NULL);
#line 186 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = to_move;
#line 186 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = to_hide;
#line 187 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = to_show;
#line 188 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 1196 "grid.c"
	{
		gint i = 0;
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 1201 "grid.c"
		{
			gboolean _tmp3_ = FALSE;
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp3_ = TRUE;
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 1208 "grid.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				GridPosition _tmp8_ = {0};
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp3_) {
#line 1215 "grid.c"
					gint _tmp4_ = 0;
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp4_ = i;
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp4_ + 1;
#line 1221 "grid.c"
				}
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = FALSE;
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp5_ = i;
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp6_ = self->priv->_cols;
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 190 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 1233 "grid.c"
				}
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp7_ = i;
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_.row = (guint) -1;
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_.col = (guint) _tmp7_;
#line 191 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				free = _tmp8_;
#line 1243 "grid.c"
				{
					gint j = 0;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 1248 "grid.c"
					{
						gboolean _tmp9_ = FALSE;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp9_ = TRUE;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 1255 "grid.c"
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							GridPosition _tmp16_ = {0};
							guint* _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							gint _tmp17__length2 = 0;
							GridPosition _tmp18_ = {0};
							guint _tmp19_ = 0U;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							guint _tmp22_ = 0U;
							guint _tmp23_ = 0U;
							GridPosition _tmp27_ = {0};
							gboolean _tmp45_ = FALSE;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp9_) {
#line 1275 "grid.c"
								gint _tmp10_ = 0;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp10_ = j;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp10_ + 1;
#line 1281 "grid.c"
							}
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9_ = FALSE;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = j;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = self->priv->_rows;
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp11_ < _tmp12_)) {
#line 193 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 1293 "grid.c"
							}
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = j;
#line 194 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							row = _tmp13_;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = row;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = i;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_.row = (guint) _tmp14_;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_.col = (guint) _tmp15_;
#line 195 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							cur = _tmp16_;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17_ = self->priv->_grid;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17__length1 = self->priv->_grid_length1;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17__length2 = self->priv->_grid_length2;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_ = cur;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19_ = _tmp18_.row;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp20_ = cur;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp21_ = _tmp20_.col;
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp22_ = _tmp17_[(_tmp19_ * _tmp17__length2) + _tmp21_];
#line 196 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							val = _tmp22_;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp23_ = val;
#line 198 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp23_ == ((guint) 0)) {
#line 1331 "grid.c"
								GridPosition _tmp24_ = {0};
								guint _tmp25_ = 0U;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp24_ = free;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp25_ = _tmp24_.row;
#line 199 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp25_ == ((guint) -1)) {
#line 1340 "grid.c"
									gint _tmp26_ = 0;
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp26_ = row;
#line 200 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = (guint) _tmp26_;
#line 1346 "grid.c"
								}
#line 202 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								continue;
#line 1350 "grid.c"
							}
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp27_.row = (guint) 0;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp27_.col = (guint) 0;
#line 206 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							match = _tmp27_;
#line 207 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							has_match = FALSE;
#line 1360 "grid.c"
							{
								gint k = 0;
								gint _tmp28_ = 0;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp28_ = row;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								k = _tmp28_ + 1;
#line 1368 "grid.c"
								{
									gboolean _tmp29_ = FALSE;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp29_ = TRUE;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									while (TRUE) {
#line 1375 "grid.c"
										gint _tmp31_ = 0;
										gint _tmp32_ = 0;
										guint k_val = 0U;
										guint* _tmp33_ = NULL;
										gint _tmp33__length1 = 0;
										gint _tmp33__length2 = 0;
										gint _tmp34_ = 0;
										GridPosition _tmp35_ = {0};
										guint _tmp36_ = 0U;
										guint _tmp37_ = 0U;
										guint _tmp38_ = 0U;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!_tmp29_) {
#line 1389 "grid.c"
											gint _tmp30_ = 0;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp30_ = k;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											k = _tmp30_ + 1;
#line 1395 "grid.c"
										}
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp29_ = FALSE;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp31_ = k;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp32_ = self->priv->_rows;
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!(_tmp31_ < _tmp32_)) {
#line 208 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 1407 "grid.c"
										}
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33_ = self->priv->_grid;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33__length1 = self->priv->_grid_length1;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33__length2 = self->priv->_grid_length2;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp34_ = k;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35_ = cur;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp36_ = _tmp35_.col;
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp37_ = _tmp33_[(_tmp34_ * _tmp33__length2) + _tmp36_];
#line 209 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										k_val = _tmp37_;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp38_ = k_val;
#line 211 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (_tmp38_ != ((guint) 0)) {
#line 1429 "grid.c"
											guint _tmp39_ = 0U;
											guint _tmp40_ = 0U;
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp39_ = k_val;
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp40_ = val;
#line 212 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											if (_tmp39_ == _tmp40_) {
#line 1438 "grid.c"
												gint _tmp41_ = 0;
												GridPosition _tmp42_ = {0};
												guint _tmp43_ = 0U;
												GridPosition _tmp44_ = {0};
#line 213 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												has_match = TRUE;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp41_ = k;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp42_ = cur;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp43_ = _tmp42_.col;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_.row = (guint) _tmp41_;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_.col = _tmp43_;
#line 214 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												match = _tmp44_;
#line 1457 "grid.c"
											}
#line 216 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 1461 "grid.c"
										}
									}
								}
							}
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp45_ = has_match;
#line 220 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp45_) {
#line 1470 "grid.c"
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								GridPosition _tmp50_ = {0};
								guint _tmp51_ = 0U;
								GridPosition _tmp53_ = {0};
								GridPosition _tmp54_ = {0};
								TileMovement _tmp55_ = {0};
								GeeLinkedList* _tmp56_ = NULL;
								TileMovement _tmp57_ = {0};
								GridPosition _tmp58_ = {0};
								GridPosition _tmp59_ = {0};
								TileMovement _tmp60_ = {0};
								GeeLinkedList* _tmp61_ = NULL;
								TileMovement _tmp62_ = {0};
								GridPosition _tmp63_ = {0};
								guint _tmp64_ = 0U;
								Tile _tmp65_ = {0};
								GeeLinkedList* _tmp66_ = NULL;
								Tile _tmp67_ = {0};
								guint* _tmp68_ = NULL;
								gint _tmp68__length1 = 0;
								gint _tmp68__length2 = 0;
								GridPosition _tmp69_ = {0};
								guint _tmp70_ = 0U;
								GridPosition _tmp71_ = {0};
								guint _tmp72_ = 0U;
								guint _tmp73_ = 0U;
								guint* _tmp74_ = NULL;
								gint _tmp74__length1 = 0;
								gint _tmp74__length2 = 0;
								GridPosition _tmp75_ = {0};
								guint _tmp76_ = 0U;
								GridPosition _tmp77_ = {0};
								guint _tmp78_ = 0U;
								guint _tmp79_ = 0U;
								guint* _tmp80_ = NULL;
								gint _tmp80__length1 = 0;
								gint _tmp80__length2 = 0;
								GridPosition _tmp81_ = {0};
								guint _tmp82_ = 0U;
								GridPosition _tmp83_ = {0};
								guint _tmp84_ = 0U;
								guint _tmp85_ = 0U;
								guint _tmp86_ = 0U;
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp46_ = grid_position_to_string (&match);
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp47_ = _tmp46_;
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp48_ = g_strconcat ("matching tile found at ", _tmp47_, NULL);
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp49_ = _tmp48_;
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								g_debug ("grid.vala:221: %s", _tmp49_);
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp49_);
#line 221 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp47_);
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp50_ = free;
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp51_ = _tmp50_.row;
#line 223 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp51_ == ((guint) -1)) {
#line 1539 "grid.c"
									gint _tmp52_ = 0;
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp52_ = row;
#line 224 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = (guint) _tmp52_;
#line 1545 "grid.c"
								}
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp53_ = cur;
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp54_ = free;
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp55_.from = _tmp53_;
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp55_.to = _tmp54_;
#line 226 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp55_;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp56_ = to_hide;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp57_ = mov;
#line 227 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, &_tmp57_);
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_ = match;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp59_ = free;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_.from = _tmp58_;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_.to = _tmp59_;
#line 228 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp60_;
#line 229 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp61_ = to_hide;
#line 229 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp62_ = mov;
#line 229 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, &_tmp62_);
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_ = free;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp64_ = val;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_.pos = _tmp63_;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_.val = _tmp64_ * 2;
#line 231 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								tile = _tmp65_;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp66_ = to_show;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp67_ = tile;
#line 232 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, &_tmp67_);
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_ = self->priv->_grid;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68__length1 = self->priv->_grid_length1;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68__length2 = self->priv->_grid_length2;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp69_ = cur;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp70_ = _tmp69_.row;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_ = cur;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp72_ = _tmp71_.col;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_] = (guint) 0;
#line 234 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp73_ = _tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_];
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_ = self->priv->_grid;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74__length1 = self->priv->_grid_length1;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74__length2 = self->priv->_grid_length2;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp75_ = match;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp76_ = _tmp75_.row;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_ = match;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp78_ = _tmp77_.col;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_] = (guint) 0;
#line 235 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp79_ = _tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_];
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_ = self->priv->_grid;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80__length1 = self->priv->_grid_length1;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80__length2 = self->priv->_grid_length2;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp81_ = free;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp82_ = _tmp81_.row;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_ = free;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp84_ = _tmp83_.col;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp85_ = val;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_] = _tmp85_ * 2;
#line 236 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp86_ = _tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_];
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp87_ = val;
#line 237 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_grid_check_target_value_reached (self, _tmp87_ * 2);
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp88_ = free.row;
#line 239 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								free.row = _tmp88_ + 1;
#line 1659 "grid.c"
							} else {
								GridPosition _tmp89_ = {0};
								guint _tmp90_ = 0U;
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp89_ = free;
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp90_ = _tmp89_.row;
#line 240 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp90_ != ((guint) -1)) {
#line 1669 "grid.c"
									gchar* _tmp91_ = NULL;
									gchar* _tmp92_ = NULL;
									gchar* _tmp93_ = NULL;
									gchar* _tmp94_ = NULL;
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									GridPosition _tmp97_ = {0};
									GridPosition _tmp98_ = {0};
									TileMovement _tmp99_ = {0};
									GeeLinkedList* _tmp100_ = NULL;
									TileMovement _tmp101_ = {0};
									guint* _tmp102_ = NULL;
									gint _tmp102__length1 = 0;
									gint _tmp102__length2 = 0;
									GridPosition _tmp103_ = {0};
									guint _tmp104_ = 0U;
									GridPosition _tmp105_ = {0};
									guint _tmp106_ = 0U;
									guint _tmp107_ = 0U;
									guint* _tmp108_ = NULL;
									gint _tmp108__length1 = 0;
									gint _tmp108__length2 = 0;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									GridPosition _tmp111_ = {0};
									guint _tmp112_ = 0U;
									guint _tmp113_ = 0U;
									guint _tmp114_ = 0U;
									guint _tmp115_ = 0U;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp91_ = grid_position_to_string (&cur);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp92_ = _tmp91_;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp93_ = grid_position_to_string (&free);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp94_ = _tmp93_;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp95_ = g_strconcat ("moving ", _tmp92_, " to ", _tmp94_, NULL);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp96_ = _tmp95_;
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									g_debug ("grid.vala:241: %s", _tmp96_);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp96_);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp94_);
#line 241 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp92_);
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp97_ = cur;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp98_ = free;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_.from = _tmp97_;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_.to = _tmp98_;
#line 243 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									mov = _tmp99_;
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp100_ = to_move;
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp101_ = mov;
#line 244 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, &_tmp101_);
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_ = self->priv->_grid;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102__length1 = self->priv->_grid_length1;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102__length2 = self->priv->_grid_length2;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_ = cur;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp104_ = _tmp103_.row;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp105_ = cur;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_ = _tmp105_.col;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_] = (guint) 0;
#line 246 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp107_ = _tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_];
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_ = self->priv->_grid;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108__length1 = self->priv->_grid_length1;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108__length2 = self->priv->_grid_length2;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp109_ = free;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp110_ = _tmp109_.row;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp111_ = free;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_ = _tmp111_.col;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp113_ = val;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_] = _tmp113_;
#line 247 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp114_ = _tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_];
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp115_ = free.row;
#line 249 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.row = _tmp115_ + 1;
#line 1777 "grid.c"
								}
							}
						}
					}
				}
			}
		}
	}
}


void grid_move_left (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint col = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_move != NULL);
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_hide != NULL);
#line 255 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_show != NULL);
#line 268 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = to_move;
#line 268 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = to_hide;
#line 269 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = to_show;
#line 270 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 1821 "grid.c"
	{
		gint i = 0;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 1826 "grid.c"
		{
			gboolean _tmp3_ = FALSE;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp3_ = TRUE;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 1833 "grid.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				GridPosition _tmp8_ = {0};
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp3_) {
#line 1840 "grid.c"
					gint _tmp4_ = 0;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp4_ = i;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp4_ + 1;
#line 1846 "grid.c"
				}
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = FALSE;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp5_ = i;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp6_ = self->priv->_rows;
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 272 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 1858 "grid.c"
				}
#line 273 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp7_ = i;
#line 273 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_.row = (guint) _tmp7_;
#line 273 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_.col = (guint) -1;
#line 273 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				free = _tmp8_;
#line 1868 "grid.c"
				{
					gint j = 0;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 1873 "grid.c"
					{
						gboolean _tmp9_ = FALSE;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp9_ = TRUE;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 1880 "grid.c"
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							GridPosition _tmp16_ = {0};
							guint* _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							gint _tmp17__length2 = 0;
							GridPosition _tmp18_ = {0};
							guint _tmp19_ = 0U;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							guint _tmp22_ = 0U;
							guint _tmp23_ = 0U;
							GridPosition _tmp27_ = {0};
							gboolean _tmp45_ = FALSE;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp9_) {
#line 1900 "grid.c"
								gint _tmp10_ = 0;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp10_ = j;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp10_ + 1;
#line 1906 "grid.c"
							}
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9_ = FALSE;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = j;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = self->priv->_cols;
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp11_ < _tmp12_)) {
#line 275 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 1918 "grid.c"
							}
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = j;
#line 276 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							col = _tmp13_;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = i;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = col;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_.row = (guint) _tmp14_;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_.col = (guint) _tmp15_;
#line 277 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							cur = _tmp16_;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17_ = self->priv->_grid;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17__length1 = self->priv->_grid_length1;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17__length2 = self->priv->_grid_length2;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_ = cur;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19_ = _tmp18_.row;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp20_ = cur;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp21_ = _tmp20_.col;
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp22_ = _tmp17_[(_tmp19_ * _tmp17__length2) + _tmp21_];
#line 278 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							val = _tmp22_;
#line 280 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp23_ = val;
#line 280 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp23_ == ((guint) 0)) {
#line 1956 "grid.c"
								GridPosition _tmp24_ = {0};
								guint _tmp25_ = 0U;
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp24_ = free;
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp25_ = _tmp24_.col;
#line 281 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp25_ == ((guint) -1)) {
#line 1965 "grid.c"
									gint _tmp26_ = 0;
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp26_ = col;
#line 282 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = (guint) _tmp26_;
#line 1971 "grid.c"
								}
#line 284 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								continue;
#line 1975 "grid.c"
							}
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp27_.row = (guint) 0;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp27_.col = (guint) 0;
#line 288 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							match = _tmp27_;
#line 289 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							has_match = FALSE;
#line 1985 "grid.c"
							{
								gint k = 0;
								gint _tmp28_ = 0;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp28_ = col;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								k = _tmp28_ + 1;
#line 1993 "grid.c"
								{
									gboolean _tmp29_ = FALSE;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp29_ = TRUE;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									while (TRUE) {
#line 2000 "grid.c"
										gint _tmp31_ = 0;
										gint _tmp32_ = 0;
										guint k_val = 0U;
										guint* _tmp33_ = NULL;
										gint _tmp33__length1 = 0;
										gint _tmp33__length2 = 0;
										GridPosition _tmp34_ = {0};
										guint _tmp35_ = 0U;
										gint _tmp36_ = 0;
										guint _tmp37_ = 0U;
										guint _tmp38_ = 0U;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!_tmp29_) {
#line 2014 "grid.c"
											gint _tmp30_ = 0;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp30_ = k;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											k = _tmp30_ + 1;
#line 2020 "grid.c"
										}
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp29_ = FALSE;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp31_ = k;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp32_ = self->priv->_rows;
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!(_tmp31_ < _tmp32_)) {
#line 290 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 2032 "grid.c"
										}
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33_ = self->priv->_grid;
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33__length1 = self->priv->_grid_length1;
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp33__length2 = self->priv->_grid_length2;
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp34_ = cur;
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35_ = _tmp34_.row;
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp36_ = k;
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp37_ = _tmp33_[(_tmp35_ * _tmp33__length2) + _tmp36_];
#line 291 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										k_val = _tmp37_;
#line 293 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp38_ = k_val;
#line 293 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (_tmp38_ != ((guint) 0)) {
#line 2054 "grid.c"
											guint _tmp39_ = 0U;
											guint _tmp40_ = 0U;
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp39_ = k_val;
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp40_ = val;
#line 294 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											if (_tmp39_ == _tmp40_) {
#line 2063 "grid.c"
												GridPosition _tmp41_ = {0};
												guint _tmp42_ = 0U;
												gint _tmp43_ = 0;
												GridPosition _tmp44_ = {0};
#line 295 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												has_match = TRUE;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp41_ = cur;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp42_ = _tmp41_.row;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp43_ = k;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_.row = _tmp42_;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_.col = (guint) _tmp43_;
#line 296 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												match = _tmp44_;
#line 2082 "grid.c"
											}
#line 298 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 2086 "grid.c"
										}
									}
								}
							}
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp45_ = has_match;
#line 302 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp45_) {
#line 2095 "grid.c"
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								GridPosition _tmp50_ = {0};
								guint _tmp51_ = 0U;
								GridPosition _tmp53_ = {0};
								GridPosition _tmp54_ = {0};
								TileMovement _tmp55_ = {0};
								GeeLinkedList* _tmp56_ = NULL;
								TileMovement _tmp57_ = {0};
								GridPosition _tmp58_ = {0};
								GridPosition _tmp59_ = {0};
								TileMovement _tmp60_ = {0};
								GeeLinkedList* _tmp61_ = NULL;
								TileMovement _tmp62_ = {0};
								GridPosition _tmp63_ = {0};
								guint _tmp64_ = 0U;
								Tile _tmp65_ = {0};
								GeeLinkedList* _tmp66_ = NULL;
								Tile _tmp67_ = {0};
								guint* _tmp68_ = NULL;
								gint _tmp68__length1 = 0;
								gint _tmp68__length2 = 0;
								GridPosition _tmp69_ = {0};
								guint _tmp70_ = 0U;
								GridPosition _tmp71_ = {0};
								guint _tmp72_ = 0U;
								guint _tmp73_ = 0U;
								guint* _tmp74_ = NULL;
								gint _tmp74__length1 = 0;
								gint _tmp74__length2 = 0;
								GridPosition _tmp75_ = {0};
								guint _tmp76_ = 0U;
								GridPosition _tmp77_ = {0};
								guint _tmp78_ = 0U;
								guint _tmp79_ = 0U;
								guint* _tmp80_ = NULL;
								gint _tmp80__length1 = 0;
								gint _tmp80__length2 = 0;
								GridPosition _tmp81_ = {0};
								guint _tmp82_ = 0U;
								GridPosition _tmp83_ = {0};
								guint _tmp84_ = 0U;
								guint _tmp85_ = 0U;
								guint _tmp86_ = 0U;
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp46_ = grid_position_to_string (&match);
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp47_ = _tmp46_;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp48_ = g_strconcat ("matching tile found at ", _tmp47_, NULL);
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp49_ = _tmp48_;
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								g_debug ("grid.vala:303: %s", _tmp49_);
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp49_);
#line 303 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp47_);
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp50_ = free;
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp51_ = _tmp50_.col;
#line 305 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp51_ == ((guint) -1)) {
#line 2164 "grid.c"
									gint _tmp52_ = 0;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp52_ = col;
#line 306 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = (guint) _tmp52_;
#line 2170 "grid.c"
								}
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp53_ = cur;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp54_ = free;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp55_.from = _tmp53_;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp55_.to = _tmp54_;
#line 308 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp55_;
#line 309 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp56_ = to_hide;
#line 309 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp57_ = mov;
#line 309 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, &_tmp57_);
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_ = match;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp59_ = free;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_.from = _tmp58_;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_.to = _tmp59_;
#line 310 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp60_;
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp61_ = to_hide;
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp62_ = mov;
#line 311 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, &_tmp62_);
#line 313 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_ = free;
#line 313 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp64_ = val;
#line 313 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_.pos = _tmp63_;
#line 313 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_.val = _tmp64_ * 2;
#line 313 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								tile = _tmp65_;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp66_ = to_show;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp67_ = tile;
#line 314 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, &_tmp67_);
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_ = self->priv->_grid;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68__length1 = self->priv->_grid_length1;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68__length2 = self->priv->_grid_length2;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp69_ = cur;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp70_ = _tmp69_.row;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_ = cur;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp72_ = _tmp71_.col;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_] = (guint) 0;
#line 316 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp73_ = _tmp68_[(_tmp70_ * _tmp68__length2) + _tmp72_];
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_ = self->priv->_grid;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74__length1 = self->priv->_grid_length1;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74__length2 = self->priv->_grid_length2;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp75_ = match;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp76_ = _tmp75_.row;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_ = match;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp78_ = _tmp77_.col;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_] = (guint) 0;
#line 317 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp79_ = _tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_];
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_ = self->priv->_grid;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80__length1 = self->priv->_grid_length1;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80__length2 = self->priv->_grid_length2;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp81_ = free;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp82_ = _tmp81_.row;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_ = free;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp84_ = _tmp83_.col;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp85_ = val;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_] = _tmp85_ * 2;
#line 318 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp86_ = _tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_];
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp87_ = val;
#line 319 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_grid_check_target_value_reached (self, _tmp87_ * 2);
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp88_ = free.col;
#line 321 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								free.col = _tmp88_ + 1;
#line 2284 "grid.c"
							} else {
								GridPosition _tmp89_ = {0};
								guint _tmp90_ = 0U;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp89_ = free;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp90_ = _tmp89_.col;
#line 322 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp90_ != ((guint) -1)) {
#line 2294 "grid.c"
									gchar* _tmp91_ = NULL;
									gchar* _tmp92_ = NULL;
									gchar* _tmp93_ = NULL;
									gchar* _tmp94_ = NULL;
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									GridPosition _tmp97_ = {0};
									GridPosition _tmp98_ = {0};
									TileMovement _tmp99_ = {0};
									GeeLinkedList* _tmp100_ = NULL;
									TileMovement _tmp101_ = {0};
									guint* _tmp102_ = NULL;
									gint _tmp102__length1 = 0;
									gint _tmp102__length2 = 0;
									GridPosition _tmp103_ = {0};
									guint _tmp104_ = 0U;
									GridPosition _tmp105_ = {0};
									guint _tmp106_ = 0U;
									guint _tmp107_ = 0U;
									guint* _tmp108_ = NULL;
									gint _tmp108__length1 = 0;
									gint _tmp108__length2 = 0;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									GridPosition _tmp111_ = {0};
									guint _tmp112_ = 0U;
									guint _tmp113_ = 0U;
									guint _tmp114_ = 0U;
									guint _tmp115_ = 0U;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp91_ = grid_position_to_string (&cur);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp92_ = _tmp91_;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp93_ = grid_position_to_string (&free);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp94_ = _tmp93_;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp95_ = g_strconcat ("moving ", _tmp92_, " to ", _tmp94_, NULL);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp96_ = _tmp95_;
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									g_debug ("grid.vala:323: %s", _tmp96_);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp96_);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp94_);
#line 323 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp92_);
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp97_ = cur;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp98_ = free;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_.from = _tmp97_;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_.to = _tmp98_;
#line 325 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									mov = _tmp99_;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp100_ = to_move;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp101_ = mov;
#line 326 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, &_tmp101_);
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_ = self->priv->_grid;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102__length1 = self->priv->_grid_length1;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102__length2 = self->priv->_grid_length2;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_ = cur;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp104_ = _tmp103_.row;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp105_ = cur;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_ = _tmp105_.col;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_] = (guint) 0;
#line 328 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp107_ = _tmp102_[(_tmp104_ * _tmp102__length2) + _tmp106_];
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_ = self->priv->_grid;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108__length1 = self->priv->_grid_length1;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108__length2 = self->priv->_grid_length2;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp109_ = free;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp110_ = _tmp109_.row;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp111_ = free;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_ = _tmp111_.col;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp113_ = val;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_] = _tmp113_;
#line 329 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp114_ = _tmp108_[(_tmp110_ * _tmp108__length2) + _tmp112_];
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp115_ = free.col;
#line 331 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = _tmp115_ + 1;
#line 2402 "grid.c"
								}
							}
						}
					}
				}
			}
		}
	}
}


void grid_move_right (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show) {
	GridPosition free = {0};
	GridPosition cur = {0};
	GridPosition match = {0};
	gboolean has_match = FALSE;
	gint col = 0;
	guint val = 0U;
	TileMovement mov = {0};
	Tile tile = {0};
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_move != NULL);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_hide != NULL);
#line 337 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (to_show != NULL);
#line 350 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = to_move;
#line 350 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 351 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = to_hide;
#line 351 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = to_show;
#line 352 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 2446 "grid.c"
	{
		gint i = 0;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 2451 "grid.c"
		{
			gboolean _tmp3_ = FALSE;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp3_ = TRUE;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 2458 "grid.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				GridPosition _tmp9_ = {0};
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp3_) {
#line 2466 "grid.c"
					gint _tmp4_ = 0;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp4_ = i;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp4_ + 1;
#line 2472 "grid.c"
				}
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = FALSE;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp5_ = i;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp6_ = self->priv->_rows;
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 354 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 2484 "grid.c"
				}
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp7_ = i;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp8_ = self->priv->_cols;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp9_.row = (guint) _tmp7_;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp9_.col = (guint) _tmp8_;
#line 355 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				free = _tmp9_;
#line 2496 "grid.c"
				{
					gint j = 0;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 2501 "grid.c"
					{
						gboolean _tmp10_ = FALSE;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp10_ = TRUE;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 2508 "grid.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							GridPosition _tmp18_ = {0};
							guint* _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							gint _tmp19__length2 = 0;
							GridPosition _tmp20_ = {0};
							guint _tmp21_ = 0U;
							GridPosition _tmp22_ = {0};
							guint _tmp23_ = 0U;
							guint _tmp24_ = 0U;
							guint _tmp25_ = 0U;
							GridPosition _tmp30_ = {0};
							gboolean _tmp47_ = FALSE;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp10_) {
#line 2529 "grid.c"
								gint _tmp11_ = 0;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp11_ = j;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp11_ + 1;
#line 2535 "grid.c"
							}
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = FALSE;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = j;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = self->priv->_cols;
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 357 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 2547 "grid.c"
							}
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = self->priv->_cols;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = j;
#line 358 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							col = (_tmp14_ - _tmp15_) - 1;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_ = i;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17_ = col;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_.row = (guint) _tmp16_;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_.col = (guint) _tmp17_;
#line 359 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							cur = _tmp18_;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19_ = self->priv->_grid;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19__length1 = self->priv->_grid_length1;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19__length2 = self->priv->_grid_length2;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp20_ = cur;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp21_ = _tmp20_.row;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp22_ = cur;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp23_ = _tmp22_.col;
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp24_ = _tmp19_[(_tmp21_ * _tmp19__length2) + _tmp23_];
#line 360 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							val = _tmp24_;
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp25_ = val;
#line 362 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp25_ == ((guint) 0)) {
#line 2587 "grid.c"
								GridPosition _tmp26_ = {0};
								guint _tmp27_ = 0U;
								gint _tmp28_ = 0;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp26_ = free;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp27_ = _tmp26_.col;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp28_ = self->priv->_cols;
#line 363 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp27_ == ((guint) _tmp28_)) {
#line 2599 "grid.c"
									gint _tmp29_ = 0;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp29_ = col;
#line 364 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = (guint) _tmp29_;
#line 2605 "grid.c"
								}
#line 366 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								continue;
#line 2609 "grid.c"
							}
#line 370 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp30_.row = (guint) 0;
#line 370 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp30_.col = (guint) 0;
#line 370 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							match = _tmp30_;
#line 371 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							has_match = FALSE;
#line 2619 "grid.c"
							{
								gint k = 0;
								gint _tmp31_ = 0;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp31_ = col;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								k = _tmp31_ - 1;
#line 2627 "grid.c"
								{
									gboolean _tmp32_ = FALSE;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp32_ = TRUE;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									while (TRUE) {
#line 2634 "grid.c"
										gint _tmp34_ = 0;
										guint k_val = 0U;
										guint* _tmp35_ = NULL;
										gint _tmp35__length1 = 0;
										gint _tmp35__length2 = 0;
										GridPosition _tmp36_ = {0};
										guint _tmp37_ = 0U;
										gint _tmp38_ = 0;
										guint _tmp39_ = 0U;
										guint _tmp40_ = 0U;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!_tmp32_) {
#line 2647 "grid.c"
											gint _tmp33_ = 0;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp33_ = k;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											k = _tmp33_ - 1;
#line 2653 "grid.c"
										}
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp32_ = FALSE;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp34_ = k;
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (!(_tmp34_ >= 0)) {
#line 372 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 2663 "grid.c"
										}
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35_ = self->priv->_grid;
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35__length1 = self->priv->_grid_length1;
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp35__length2 = self->priv->_grid_length2;
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp36_ = cur;
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp37_ = _tmp36_.row;
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp38_ = k;
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp39_ = _tmp35_[(_tmp37_ * _tmp35__length2) + _tmp38_];
#line 373 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										k_val = _tmp39_;
#line 375 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										_tmp40_ = k_val;
#line 375 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										if (_tmp40_ != ((guint) 0)) {
#line 2685 "grid.c"
											guint _tmp41_ = 0U;
											guint _tmp42_ = 0U;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp41_ = k_val;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											_tmp42_ = val;
#line 376 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											if (_tmp41_ == _tmp42_) {
#line 2694 "grid.c"
												GridPosition _tmp43_ = {0};
												guint _tmp44_ = 0U;
												gint _tmp45_ = 0;
												GridPosition _tmp46_ = {0};
#line 377 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												has_match = TRUE;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp43_ = cur;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp44_ = _tmp43_.row;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp45_ = k;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp46_.row = _tmp44_;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												_tmp46_.col = (guint) _tmp45_;
#line 378 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
												match = _tmp46_;
#line 2713 "grid.c"
											}
#line 380 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
											break;
#line 2717 "grid.c"
										}
									}
								}
							}
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp47_ = has_match;
#line 384 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp47_) {
#line 2726 "grid.c"
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_ = NULL;
								GridPosition _tmp52_ = {0};
								guint _tmp53_ = 0U;
								gint _tmp54_ = 0;
								GridPosition _tmp56_ = {0};
								GridPosition _tmp57_ = {0};
								TileMovement _tmp58_ = {0};
								GeeLinkedList* _tmp59_ = NULL;
								TileMovement _tmp60_ = {0};
								GridPosition _tmp61_ = {0};
								GridPosition _tmp62_ = {0};
								TileMovement _tmp63_ = {0};
								GeeLinkedList* _tmp64_ = NULL;
								TileMovement _tmp65_ = {0};
								GridPosition _tmp66_ = {0};
								guint _tmp67_ = 0U;
								Tile _tmp68_ = {0};
								GeeLinkedList* _tmp69_ = NULL;
								Tile _tmp70_ = {0};
								guint* _tmp71_ = NULL;
								gint _tmp71__length1 = 0;
								gint _tmp71__length2 = 0;
								GridPosition _tmp72_ = {0};
								guint _tmp73_ = 0U;
								GridPosition _tmp74_ = {0};
								guint _tmp75_ = 0U;
								guint _tmp76_ = 0U;
								guint* _tmp77_ = NULL;
								gint _tmp77__length1 = 0;
								gint _tmp77__length2 = 0;
								GridPosition _tmp78_ = {0};
								guint _tmp79_ = 0U;
								GridPosition _tmp80_ = {0};
								guint _tmp81_ = 0U;
								guint _tmp82_ = 0U;
								guint* _tmp83_ = NULL;
								gint _tmp83__length1 = 0;
								gint _tmp83__length2 = 0;
								GridPosition _tmp84_ = {0};
								guint _tmp85_ = 0U;
								GridPosition _tmp86_ = {0};
								guint _tmp87_ = 0U;
								guint _tmp88_ = 0U;
								guint _tmp89_ = 0U;
								guint _tmp90_ = 0U;
								guint _tmp91_ = 0U;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp48_ = grid_position_to_string (&match);
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp49_ = _tmp48_;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp50_ = g_strconcat ("matching tile found at ", _tmp49_, NULL);
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp51_ = _tmp50_;
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								g_debug ("grid.vala:385: %s", _tmp51_);
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp51_);
#line 385 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_g_free0 (_tmp49_);
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp52_ = free;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp53_ = _tmp52_.col;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp54_ = self->priv->_cols;
#line 387 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp53_ == ((guint) _tmp54_)) {
#line 2798 "grid.c"
									gint _tmp55_ = 0;
#line 388 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp55_ = col;
#line 388 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = (guint) _tmp55_;
#line 2804 "grid.c"
								}
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp56_ = cur;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp57_ = free;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_.from = _tmp56_;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp58_.to = _tmp57_;
#line 390 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp58_;
#line 391 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp59_ = to_hide;
#line 391 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp60_ = mov;
#line 391 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, &_tmp60_);
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp61_ = match;
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp62_ = free;
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_.from = _tmp61_;
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp63_.to = _tmp62_;
#line 392 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								mov = _tmp63_;
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp64_ = to_hide;
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp65_ = mov;
#line 393 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, &_tmp65_);
#line 395 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp66_ = free;
#line 395 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp67_ = val;
#line 395 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_.pos = _tmp66_;
#line 395 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp68_.val = _tmp67_ * 2;
#line 395 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								tile = _tmp68_;
#line 396 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp69_ = to_show;
#line 396 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp70_ = tile;
#line 396 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, &_tmp70_);
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_ = self->priv->_grid;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71__length1 = self->priv->_grid_length1;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71__length2 = self->priv->_grid_length2;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp72_ = cur;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp73_ = _tmp72_.row;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp74_ = cur;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp75_ = _tmp74_.col;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_] = (guint) 0;
#line 398 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp76_ = _tmp71_[(_tmp73_ * _tmp71__length2) + _tmp75_];
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_ = self->priv->_grid;
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77__length1 = self->priv->_grid_length1;
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77__length2 = self->priv->_grid_length2;
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp78_ = match;
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp79_ = _tmp78_.row;
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp80_ = match;
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp81_ = _tmp80_.col;
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_] = (guint) 0;
#line 399 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp82_ = _tmp77_[(_tmp79_ * _tmp77__length2) + _tmp81_];
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_ = self->priv->_grid;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83__length1 = self->priv->_grid_length1;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83__length2 = self->priv->_grid_length2;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp84_ = free;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp85_ = _tmp84_.row;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp86_ = free;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp87_ = _tmp86_.col;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp88_ = val;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_] = _tmp88_ * 2;
#line 400 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp89_ = _tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_];
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp90_ = val;
#line 401 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_grid_check_target_value_reached (self, _tmp90_ * 2);
#line 403 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp91_ = free.col;
#line 403 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								free.col = _tmp91_ - 1;
#line 2918 "grid.c"
							} else {
								GridPosition _tmp92_ = {0};
								guint _tmp93_ = 0U;
								gint _tmp94_ = 0;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp92_ = free;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp93_ = _tmp92_.col;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp94_ = self->priv->_cols;
#line 404 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp93_ != ((guint) _tmp94_)) {
#line 2931 "grid.c"
									gchar* _tmp95_ = NULL;
									gchar* _tmp96_ = NULL;
									gchar* _tmp97_ = NULL;
									gchar* _tmp98_ = NULL;
									gchar* _tmp99_ = NULL;
									gchar* _tmp100_ = NULL;
									GridPosition _tmp101_ = {0};
									GridPosition _tmp102_ = {0};
									TileMovement _tmp103_ = {0};
									GeeLinkedList* _tmp104_ = NULL;
									TileMovement _tmp105_ = {0};
									guint* _tmp106_ = NULL;
									gint _tmp106__length1 = 0;
									gint _tmp106__length2 = 0;
									GridPosition _tmp107_ = {0};
									guint _tmp108_ = 0U;
									GridPosition _tmp109_ = {0};
									guint _tmp110_ = 0U;
									guint _tmp111_ = 0U;
									guint* _tmp112_ = NULL;
									gint _tmp112__length1 = 0;
									gint _tmp112__length2 = 0;
									GridPosition _tmp113_ = {0};
									guint _tmp114_ = 0U;
									GridPosition _tmp115_ = {0};
									guint _tmp116_ = 0U;
									guint _tmp117_ = 0U;
									guint _tmp118_ = 0U;
									guint _tmp119_ = 0U;
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp95_ = grid_position_to_string (&cur);
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp96_ = _tmp95_;
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp97_ = grid_position_to_string (&free);
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp98_ = _tmp97_;
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp99_ = g_strconcat ("moving ", _tmp96_, " to ", _tmp98_, NULL);
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp100_ = _tmp99_;
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									g_debug ("grid.vala:405: %s", _tmp100_);
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp100_);
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp98_);
#line 405 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_g_free0 (_tmp96_);
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp101_ = cur;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp102_ = free;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_.from = _tmp101_;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp103_.to = _tmp102_;
#line 407 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									mov = _tmp103_;
#line 408 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp104_ = to_move;
#line 408 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp105_ = mov;
#line 408 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, &_tmp105_);
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_ = self->priv->_grid;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106__length1 = self->priv->_grid_length1;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106__length2 = self->priv->_grid_length2;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp107_ = cur;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp108_ = _tmp107_.row;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp109_ = cur;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp110_ = _tmp109_.col;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_] = (guint) 0;
#line 410 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp111_ = _tmp106_[(_tmp108_ * _tmp106__length2) + _tmp110_];
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_ = self->priv->_grid;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112__length1 = self->priv->_grid_length1;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112__length2 = self->priv->_grid_length2;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp113_ = free;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp114_ = _tmp113_.row;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp115_ = free;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp116_ = _tmp115_.col;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp117_ = val;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_] = _tmp117_;
#line 411 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp118_ = _tmp112_[(_tmp114_ * _tmp112__length2) + _tmp116_];
#line 413 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp119_ = free.col;
#line 413 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									free.col = _tmp119_ - 1;
#line 3039 "grid.c"
								}
							}
						}
					}
				}
			}
		}
	}
}


gboolean grid_is_finished (Grid* self) {
	gboolean result = FALSE;
	guint val = 0U;
	gboolean _tmp0_ = FALSE;
#line 419 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 423 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = _grid_grid_is_full (self);
#line 423 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (!_tmp0_) {
#line 424 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 424 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3065 "grid.c"
	} else {
		{
			gint i = 0;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			i = 0;
#line 3071 "grid.c"
			{
				gboolean _tmp1_ = FALSE;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp1_ = TRUE;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				while (TRUE) {
#line 3078 "grid.c"
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					if (!_tmp1_) {
#line 3083 "grid.c"
						gint _tmp2_ = 0;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp2_ = i;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						i = _tmp2_ + 1;
#line 3089 "grid.c"
					}
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp1_ = FALSE;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp3_ = i;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp4_ = self->priv->_rows;
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					if (!(_tmp3_ < _tmp4_)) {
#line 426 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						break;
#line 3101 "grid.c"
					}
					{
						gint j = 0;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						j = 0;
#line 3107 "grid.c"
						{
							gboolean _tmp5_ = FALSE;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp5_ = TRUE;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							while (TRUE) {
#line 3114 "grid.c"
								gint _tmp7_ = 0;
								gint _tmp8_ = 0;
								guint* _tmp9_ = NULL;
								gint _tmp9__length1 = 0;
								gint _tmp9__length2 = 0;
								gint _tmp10_ = 0;
								gint _tmp11_ = 0;
								guint _tmp12_ = 0U;
								gint _tmp13_ = 0;
								gint _tmp14_ = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (!_tmp5_) {
#line 3129 "grid.c"
									gint _tmp6_ = 0;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp6_ = j;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									j = _tmp6_ + 1;
#line 3135 "grid.c"
								}
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp5_ = FALSE;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp7_ = j;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp8_ = self->priv->_cols;
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (!(_tmp7_ < _tmp8_)) {
#line 427 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									break;
#line 3147 "grid.c"
								}
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp9_ = self->priv->_grid;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp9__length1 = self->priv->_grid_length1;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp9__length2 = self->priv->_grid_length2;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp10_ = i;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp11_ = j;
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 428 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								val = _tmp12_;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp13_ = i;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp14_ = self->priv->_rows;
#line 430 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp13_ < (_tmp14_ - 1)) {
#line 3169 "grid.c"
									guint _tmp15_ = 0U;
									guint* _tmp16_ = NULL;
									gint _tmp16__length1 = 0;
									gint _tmp16__length2 = 0;
									gint _tmp17_ = 0;
									gint _tmp18_ = 0;
									guint _tmp19_ = 0U;
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp15_ = val;
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp16_ = self->priv->_grid;
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp16__length1 = self->priv->_grid_length1;
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp16__length2 = self->priv->_grid_length2;
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp17_ = i;
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp18_ = j;
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp19_ = _tmp16_[((_tmp17_ + 1) * _tmp16__length2) + _tmp18_];
#line 431 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									if (_tmp15_ == _tmp19_) {
#line 432 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										result = FALSE;
#line 432 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										return result;
#line 3197 "grid.c"
									}
								}
#line 434 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp20_ = j;
#line 434 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp21_ = self->priv->_cols;
#line 434 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								if (_tmp20_ < (_tmp21_ - 1)) {
#line 3206 "grid.c"
									guint _tmp22_ = 0U;
									guint* _tmp23_ = NULL;
									gint _tmp23__length1 = 0;
									gint _tmp23__length2 = 0;
									gint _tmp24_ = 0;
									gint _tmp25_ = 0;
									guint _tmp26_ = 0U;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp22_ = val;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp23_ = self->priv->_grid;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp23__length1 = self->priv->_grid_length1;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp23__length2 = self->priv->_grid_length2;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp24_ = i;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp25_ = j;
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + (_tmp25_ + 1)];
#line 435 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
									if (_tmp22_ == _tmp26_) {
#line 436 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										result = FALSE;
#line 436 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
										return result;
#line 3234 "grid.c"
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 441 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = TRUE;
#line 441 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3248 "grid.c"
}


guint grid_get (Grid* self, gint row, gint col) {
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	guint _tmp8_ = 0U;
#line 444 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 446 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = row;
#line 446 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = self->priv->_rows;
#line 446 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp1_ >= _tmp2_) {
#line 446 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp0_ = TRUE;
#line 3273 "grid.c"
	} else {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 446 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp3_ = col;
#line 446 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp4_ = self->priv->_cols;
#line 446 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp0_ = _tmp3_ >= _tmp4_;
#line 3283 "grid.c"
	}
#line 446 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp0_) {
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = (guint) 0;
#line 447 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3291 "grid.c"
	}
#line 449 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5_ = self->priv->_grid;
#line 449 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5__length1 = self->priv->_grid_length1;
#line 449 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5__length2 = self->priv->_grid_length2;
#line 449 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp6_ = row;
#line 449 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp7_ = col;
#line 449 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 449 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp8_;
#line 449 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3309 "grid.c"
}


gchar* grid_save (Grid* self) {
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
#line 452 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 454 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = g_strdup ("");
#line 454 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp0_;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = ret;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = self->priv->_rows;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = _tmp3_;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5_ = g_strconcat (_tmp4_, " ", NULL);
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp6_ = _tmp5_;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp7_ = g_strconcat (_tmp1_, _tmp6_, NULL);
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (ret);
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp7_;
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp6_);
#line 456 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp4_);
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp8_ = ret;
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp9_ = self->priv->_cols;
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp11_ = _tmp10_;
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp13_ = _tmp12_;
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp14_ = g_strconcat (_tmp8_, _tmp13_, NULL);
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (ret);
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp14_;
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp13_);
#line 457 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp11_);
#line 459 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp15_ = ret;
#line 459 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp16_ = _grid_convert_to_string (self);
#line 459 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp17_ = _tmp16_;
#line 459 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
#line 459 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (ret);
#line 459 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp18_;
#line 459 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp17_);
#line 461 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = ret;
#line 461 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3403 "grid.c"
}


gboolean grid_load (Grid* self, const gchar* content) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 464 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 464 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (content != NULL, FALSE);
#line 466 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = content;
#line 466 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = _grid_load_from_string (self, _tmp0_);
#line 466 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp1_;
#line 466 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3423 "grid.c"
}


gchar* grid_to_string (Grid* self) {
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 469 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 471 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = g_strdup ("\n");
#line 471 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp0_;
#line 472 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = ret;
#line 472 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = _grid_convert_to_string (self);
#line 472 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = _tmp2_;
#line 472 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
#line 472 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (ret);
#line 472 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp4_;
#line 472 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp3_);
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = ret;
#line 473 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3459 "grid.c"
}


static gchar* _grid_convert_to_string (Grid* self) {
	gchar* result = NULL;
	gchar* ret = NULL;
	gchar* _tmp0_ = NULL;
#line 476 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 478 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = g_strdup ("");
#line 478 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp0_;
#line 3473 "grid.c"
	{
		guint i = 0U;
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = (guint) 0;
#line 3478 "grid.c"
		{
			gboolean _tmp1_ = FALSE;
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp1_ = TRUE;
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 3485 "grid.c"
				guint _tmp3_ = 0U;
				gint _tmp4_ = 0;
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp1_) {
#line 3490 "grid.c"
					guint _tmp2_ = 0U;
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp2_ = i;
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp2_ + 1;
#line 3496 "grid.c"
				}
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp1_ = FALSE;
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = i;
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp4_ = self->priv->_rows;
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp3_ < ((guint) _tmp4_))) {
#line 480 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 3508 "grid.c"
				}
				{
					guint j = 0U;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = (guint) 0;
#line 3514 "grid.c"
					{
						gboolean _tmp5_ = FALSE;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp5_ = TRUE;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 3521 "grid.c"
							guint _tmp7_ = 0U;
							gint _tmp8_ = 0;
							const gchar* _tmp9_ = NULL;
							guint _tmp10_ = 0U;
							gint _tmp11_ = 0;
							const gchar* _tmp12_ = NULL;
							guint* _tmp13_ = NULL;
							gint _tmp13__length1 = 0;
							gint _tmp13__length2 = 0;
							guint _tmp14_ = 0U;
							guint _tmp15_ = 0U;
							guint _tmp16_ = 0U;
							gchar* _tmp17_ = NULL;
							gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp5_) {
#line 3539 "grid.c"
								guint _tmp6_ = 0U;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp6_ = j;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp6_ + 1;
#line 3545 "grid.c"
							}
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp5_ = FALSE;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp7_ = j;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8_ = self->priv->_cols;
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp7_ < ((guint) _tmp8_))) {
#line 481 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 3557 "grid.c"
							}
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = j;
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = self->priv->_cols;
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp10_ == ((guint) (_tmp11_ - 1))) {
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp9_ = "\n";
#line 3567 "grid.c"
							} else {
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp9_ = " ";
#line 3571 "grid.c"
							}
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp12_ = ret;
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13_ = self->priv->_grid;
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13__length1 = self->priv->_grid_length1;
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp13__length2 = self->priv->_grid_length2;
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp14_ = i;
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp15_ = j;
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp17_ = g_strdup_printf ("%u%s", _tmp16_, _tmp9_);
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp18_ = _tmp17_;
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp19_ = g_strconcat (_tmp12_, _tmp18_, NULL);
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_g_free0 (ret);
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							ret = _tmp19_;
#line 482 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_g_free0 (_tmp18_);
#line 3599 "grid.c"
						}
					}
				}
			}
		}
	}
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = ret;
#line 486 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 3610 "grid.c"
}


static guint* _vala_array_dup2 (guint* self, int length) {
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return g_memdup (self, length * sizeof (guint));
#line 3617 "grid.c"
}


static gboolean _grid_load_from_string (Grid* self, const gchar* contents) {
	gboolean result = FALSE;
	gint rows = 0;
	gint cols = 0;
	gchar** lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gchar** tokens = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	guint* grid = NULL;
	gint grid_length1 = 0;
	gint grid_length2 = 0;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	guint* _tmp22_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	guint* _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	gint _tmp48__length2 = 0;
	guint* _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	gint _tmp49__length2 = 0;
#line 489 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 489 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (contents != NULL, FALSE);
#line 491 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	rows = 0;
#line 492 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	cols = 0;
#line 497 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = contents;
#line 497 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "\n", 0);
#line 497 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 497 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	lines = _tmp2_;
#line 497 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	lines_length1 = _vala_array_length (_tmp1_);
#line 497 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_lines_size_ = lines_length1;
#line 500 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = lines;
#line 500 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3__length1 = lines_length1;
#line 500 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp3__length1 < 3) {
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid = (g_free (grid), NULL);
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 501 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3706 "grid.c"
	}
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = lines;
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4__length1 = lines_length1;
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5_ = _tmp4_[0];
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, " ", 0);
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	tokens = _tmp7_;
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	tokens_length1 = _vala_array_length (_tmp6_);
#line 503 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tokens_size_ = tokens_length1;
#line 504 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp8_ = tokens;
#line 504 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp8__length1 = tokens_length1;
#line 504 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp8__length1 != 2) {
#line 505 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 505 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid = (g_free (grid), NULL);
#line 505 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 505 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 505 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3740 "grid.c"
	}
#line 507 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp9_ = tokens;
#line 507 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp9__length1 = tokens_length1;
#line 507 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp10_ = _tmp9_[0];
#line 507 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp11_ = atoi (_tmp10_);
#line 507 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	rows = _tmp11_;
#line 508 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp12_ = tokens;
#line 508 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp12__length1 = tokens_length1;
#line 508 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp13_ = _tmp12_[1];
#line 508 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp14_ = atoi (_tmp13_);
#line 508 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	cols = _tmp14_;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp16_ = rows;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp16_ < 2) {
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp15_ = TRUE;
#line 3768 "grid.c"
	} else {
		gint _tmp17_ = 0;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp17_ = cols;
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp15_ = _tmp17_ < 2;
#line 3775 "grid.c"
	}
#line 510 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp15_) {
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid = (g_free (grid), NULL);
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 511 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3789 "grid.c"
	}
#line 513 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp18_ = lines;
#line 513 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp18__length1 = lines_length1;
#line 513 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp19_ = rows;
#line 513 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp18__length1 < (_tmp19_ + 1)) {
#line 514 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		result = FALSE;
#line 514 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid = (g_free (grid), NULL);
#line 514 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 514 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 514 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		return result;
#line 3809 "grid.c"
	}
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp20_ = rows;
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp21_ = cols;
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp22_ = g_new0 (guint, _tmp20_ * _tmp21_);
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid = (g_free (grid), NULL);
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid = _tmp22_;
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid_length1 = _tmp20_;
#line 516 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid_length2 = _tmp21_;
#line 3825 "grid.c"
	{
		gint i = 0;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = 0;
#line 3830 "grid.c"
		{
			gboolean _tmp23_ = FALSE;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp23_ = TRUE;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 3837 "grid.c"
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gint _tmp28_ = 0;
				const gchar* _tmp29_ = NULL;
				gchar** _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gchar** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp33_ = 0;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp23_) {
#line 3851 "grid.c"
					gint _tmp24_ = 0;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp24_ = i;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp24_ + 1;
#line 3857 "grid.c"
				}
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp23_ = FALSE;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp25_ = i;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp26_ = rows;
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp25_ < _tmp26_)) {
#line 518 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 3869 "grid.c"
				}
#line 519 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp27_ = lines;
#line 519 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp27__length1 = lines_length1;
#line 519 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp28_ = i;
#line 519 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp29_ = _tmp27_[_tmp28_ + 1];
#line 519 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, " ", 0);
#line 519 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 519 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				tokens = _tmp31_;
#line 519 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				tokens_length1 = _vala_array_length (_tmp30_);
#line 519 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tokens_size_ = tokens_length1;
#line 521 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp32_ = tokens;
#line 521 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp32__length1 = tokens_length1;
#line 521 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp33_ = cols;
#line 521 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (_tmp32__length1 != _tmp33_) {
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					result = FALSE;
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					grid = (g_free (grid), NULL);
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 522 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					return result;
#line 3907 "grid.c"
				}
				{
					gint j = 0;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = 0;
#line 3913 "grid.c"
					{
						gboolean _tmp34_ = FALSE;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp34_ = TRUE;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 3920 "grid.c"
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							guint* _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp38__length2 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gchar** _tmp41_ = NULL;
							gint _tmp41__length1 = 0;
							gint _tmp42_ = 0;
							const gchar* _tmp43_ = NULL;
							gint _tmp44_ = 0;
							guint _tmp45_ = 0U;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp34_) {
#line 3936 "grid.c"
								gint _tmp35_ = 0;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp35_ = j;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp35_ + 1;
#line 3942 "grid.c"
							}
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp34_ = FALSE;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp36_ = j;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp37_ = cols;
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp36_ < _tmp37_)) {
#line 524 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 3954 "grid.c"
							}
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp38_ = grid;
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp38__length1 = grid_length1;
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp38__length2 = grid_length2;
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp39_ = i;
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp40_ = j;
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp41_ = tokens;
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp41__length1 = tokens_length1;
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp42_ = j;
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp43_ = _tmp41_[_tmp42_];
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp44_ = atoi (_tmp43_);
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_] = (guint) _tmp44_;
#line 525 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp45_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
#line 3980 "grid.c"
						}
					}
				}
			}
		}
	}
#line 529 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp46_ = rows;
#line 529 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_rows = _tmp46_;
#line 530 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp47_ = cols;
#line 530 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_cols = _tmp47_;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp48_ = grid;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp48__length1 = grid_length1;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp48__length2 = grid_length2;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup2 (_tmp48_, _tmp48__length1 * _tmp48__length2) : ((gpointer) _tmp48_);
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp49__length1 = _tmp48__length1;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp49__length2 = _tmp48__length2;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid = _tmp49_;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid_length1 = _tmp49__length1;
#line 531 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid_length2 = _tmp49__length2;
#line 533 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = TRUE;
#line 533 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid = (g_free (grid), NULL);
#line 533 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 533 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 533 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4025 "grid.c"
}


static gboolean _grid_grid_is_full (Grid* self) {
	gboolean result = FALSE;
#line 536 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 4033 "grid.c"
	{
		guint i = 0U;
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		i = (guint) 0;
#line 4038 "grid.c"
		{
			gboolean _tmp0_ = FALSE;
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			_tmp0_ = TRUE;
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			while (TRUE) {
#line 4045 "grid.c"
				guint _tmp2_ = 0U;
				gint _tmp3_ = 0;
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!_tmp0_) {
#line 4050 "grid.c"
					guint _tmp1_ = 0U;
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					_tmp1_ = i;
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					i = _tmp1_ + 1;
#line 4056 "grid.c"
				}
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp0_ = FALSE;
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp2_ = i;
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				_tmp3_ = self->priv->_rows;
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
				if (!(_tmp2_ < ((guint) _tmp3_))) {
#line 538 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					break;
#line 4068 "grid.c"
				}
				{
					guint j = 0U;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
					j = (guint) 0;
#line 4074 "grid.c"
					{
						gboolean _tmp4_ = FALSE;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						_tmp4_ = TRUE;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
						while (TRUE) {
#line 4081 "grid.c"
							guint _tmp6_ = 0U;
							gint _tmp7_ = 0;
							guint* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							guint _tmp9_ = 0U;
							guint _tmp10_ = 0U;
							guint _tmp11_ = 0U;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!_tmp4_) {
#line 4092 "grid.c"
								guint _tmp5_ = 0U;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								_tmp5_ = j;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								j = _tmp5_ + 1;
#line 4098 "grid.c"
							}
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp4_ = FALSE;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp6_ = j;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp7_ = self->priv->_cols;
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (!(_tmp6_ < ((guint) _tmp7_))) {
#line 539 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								break;
#line 4110 "grid.c"
							}
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8_ = self->priv->_grid;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8__length1 = self->priv->_grid_length1;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp8__length2 = self->priv->_grid_length2;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp9_ = i;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp10_ = j;
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
#line 540 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
							if (_tmp11_ == ((guint) 0)) {
#line 541 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								result = FALSE;
#line 541 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
								return result;
#line 4130 "grid.c"
							}
						}
					}
				}
			}
		}
	}
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = TRUE;
#line 546 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4142 "grid.c"
}


static void _grid_random_position (Grid* self, GridPosition* result) {
	GridPosition ret = {0};
	gint _tmp0_ = 0;
	gint32 _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint32 _tmp3_ = 0;
	GridPosition _tmp4_ = {0};
#line 549 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 551 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_rows;
#line 551 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp0_));
#line 551 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = self->priv->_cols;
#line 551 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp2_));
#line 551 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_.row = (guint) _tmp1_;
#line 551 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_.col = (guint) _tmp3_;
#line 551 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	ret = _tmp4_;
#line 554 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	*result = ret;
#line 554 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return;
#line 4173 "grid.c"
}


static void _grid_check_target_value_reached (Grid* self, guint val) {
	guint _tmp0_ = 0U;
#line 557 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 559 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_target_value;
#line 559 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 4185 "grid.c"
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp1_ = val;
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		_tmp2_ = self->priv->_target_value;
#line 560 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		if (_tmp1_ == _tmp2_) {
#line 561 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
			grid_set_target_value_reached (self, TRUE);
#line 4196 "grid.c"
		}
	}
}


gint grid_get_rows (Grid* self) {
	gint result;
	gint _tmp0_ = 0;
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_rows;
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp0_;
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4213 "grid.c"
}


void grid_set_rows (Grid* self, gint value) {
	gint _tmp0_ = 0;
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = value;
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_rows = _tmp0_;
#line 33 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_notify ((GObject *) self, "rows");
#line 4227 "grid.c"
}


gint grid_get_cols (Grid* self) {
	gint result;
	gint _tmp0_ = 0;
#line 37 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 37 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_cols;
#line 37 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp0_;
#line 37 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4242 "grid.c"
}


void grid_set_cols (Grid* self, gint value) {
	gint _tmp0_ = 0;
#line 37 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 37 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = value;
#line 37 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_cols = _tmp0_;
#line 37 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_notify ((GObject *) self, "cols");
#line 4256 "grid.c"
}


guint grid_get_target_value (Grid* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_target_value;
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp0_;
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4271 "grid.c"
}


void grid_set_target_value (Grid* self, guint value) {
	guint _tmp0_ = 0U;
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = value;
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_target_value = _tmp0_;
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_notify ((GObject *) self, "target-value");
#line 4285 "grid.c"
}


gboolean grid_get_target_value_reached (Grid* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = self->priv->_target_value_reached;
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp0_;
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4300 "grid.c"
}


void grid_set_target_value_reached (Grid* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_return_if_fail (self != NULL);
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = value;
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_target_value_reached = _tmp0_;
#line 45 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_notify ((GObject *) self, "target-value-reached");
#line 4314 "grid.c"
}


static void grid_class_init (GridClass * klass) {
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	grid_parent_class = g_type_class_peek_parent (klass);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_type_class_add_private (klass, sizeof (GridPrivate));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_grid_get_property;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_grid_set_property;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	G_OBJECT_CLASS (klass)->finalize = grid_finalize;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_ROWS, g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_COLS, g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE, g_param_spec_uint ("target-value", "target-value", "target-value", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE_REACHED, g_param_spec_boolean ("target-value-reached", "target-value-reached", "target-value-reached", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4337 "grid.c"
}


static void grid_instance_init (Grid * self) {
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv = GRID_GET_PRIVATE (self);
#line 4344 "grid.c"
}


static void grid_finalize (GObject* obj) {
	Grid * self;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GRID, Grid);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	self->priv->_grid = (g_free (self->priv->_grid), NULL);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	G_OBJECT_CLASS (grid_parent_class)->finalize (obj);
#line 4356 "grid.c"
}


GType grid_get_type (void) {
	static volatile gsize grid_type_id__volatile = 0;
	if (g_once_init_enter (&grid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Grid), 0, (GInstanceInitFunc) grid_instance_init, NULL };
		GType grid_type_id;
		grid_type_id = g_type_register_static (G_TYPE_OBJECT, "Grid", &g_define_type_info, 0);
		g_once_init_leave (&grid_type_id__volatile, grid_type_id);
	}
	return grid_type_id__volatile;
}


static void _vala_grid_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRID, Grid);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	switch (property_id) {
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_ROWS:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		g_value_set_int (value, grid_get_rows (self));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_COLS:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		g_value_set_int (value, grid_get_cols (self));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_TARGET_VALUE:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		g_value_set_uint (value, grid_get_target_value (self));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_TARGET_VALUE_REACHED:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		g_value_set_boolean (value, grid_get_target_value_reached (self));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 4401 "grid.c"
		default:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 4407 "grid.c"
	}
}


static void _vala_grid_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRID, Grid);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	switch (property_id) {
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_ROWS:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid_set_rows (self, g_value_get_int (value));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_COLS:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid_set_cols (self, g_value_get_int (value));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_TARGET_VALUE:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid_set_target_value (self, g_value_get_uint (value));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		case GRID_TARGET_VALUE_REACHED:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		grid_set_target_value_reached (self, g_value_get_boolean (value));
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 4441 "grid.c"
		default:
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
		break;
#line 4447 "grid.c"
	}
}


gchar* grid_position_to_string (GridPosition *self) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp0_ = (*self).row;
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp2_ = _tmp1_;
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp3_ = (*self).col;
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp5_ = _tmp4_;
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp6_ = g_strconcat ("(", _tmp2_, ",", _tmp5_, ")", NULL);
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_tmp7_ = _tmp6_;
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp5_);
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	_g_free0 (_tmp2_);
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	result = _tmp7_;
#line 572 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return result;
#line 4486 "grid.c"
}


GridPosition* grid_position_dup (const GridPosition* self) {
	GridPosition* dup;
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	dup = g_new0 (GridPosition, 1);
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	memcpy (dup, self, sizeof (GridPosition));
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return dup;
#line 4498 "grid.c"
}


void grid_position_free (GridPosition* self) {
#line 565 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_free (self);
#line 4505 "grid.c"
}


GType grid_position_get_type (void) {
	static volatile gsize grid_position_type_id__volatile = 0;
	if (g_once_init_enter (&grid_position_type_id__volatile)) {
		GType grid_position_type_id;
		grid_position_type_id = g_boxed_type_register_static ("GridPosition", (GBoxedCopyFunc) grid_position_dup, (GBoxedFreeFunc) grid_position_free);
		g_once_init_leave (&grid_position_type_id__volatile, grid_position_type_id);
	}
	return grid_position_type_id__volatile;
}


TileMovement* tile_movement_dup (const TileMovement* self) {
	TileMovement* dup;
#line 576 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	dup = g_new0 (TileMovement, 1);
#line 576 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	memcpy (dup, self, sizeof (TileMovement));
#line 576 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return dup;
#line 4528 "grid.c"
}


void tile_movement_free (TileMovement* self) {
#line 576 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_free (self);
#line 4535 "grid.c"
}


GType tile_movement_get_type (void) {
	static volatile gsize tile_movement_type_id__volatile = 0;
	if (g_once_init_enter (&tile_movement_type_id__volatile)) {
		GType tile_movement_type_id;
		tile_movement_type_id = g_boxed_type_register_static ("TileMovement", (GBoxedCopyFunc) tile_movement_dup, (GBoxedFreeFunc) tile_movement_free);
		g_once_init_leave (&tile_movement_type_id__volatile, tile_movement_type_id);
	}
	return tile_movement_type_id__volatile;
}


Tile* tile_dup (const Tile* self) {
	Tile* dup;
#line 582 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	dup = g_new0 (Tile, 1);
#line 582 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	memcpy (dup, self, sizeof (Tile));
#line 582 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	return dup;
#line 4558 "grid.c"
}


void tile_free (Tile* self) {
#line 582 "/run/media/triton/Guerre/jhbuild/jhbuild/gnome-2048/src/grid.vala"
	g_free (self);
#line 4565 "grid.c"
}


GType tile_get_type (void) {
	static volatile gsize tile_type_id__volatile = 0;
	if (g_once_init_enter (&tile_type_id__volatile)) {
		GType tile_type_id;
		tile_type_id = g_boxed_type_register_static ("Tile", (GBoxedCopyFunc) tile_dup, (GBoxedFreeFunc) tile_free);
		g_once_init_leave (&tile_type_id__volatile, tile_type_id);
	}
	return tile_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



