/* game.c generated by valac 0.29.3.4-c161d, the Vala compiler
 * generated from game.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;

#define TYPE_ROUNDED_RECTANGLE (rounded_rectangle_get_type ())
#define ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangle))
#define ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))
#define IS_ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUNDED_RECTANGLE))
#define IS_ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUNDED_RECTANGLE))
#define ROUNDED_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))

typedef struct _RoundedRectangle RoundedRectangle;
typedef struct _RoundedRectangleClass RoundedRectangleClass;

#define TYPE_TILE_VIEW (tile_view_get_type ())
#define TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_VIEW, TileView))
#define TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_VIEW, TileViewClass))
#define IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_VIEW))
#define IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_VIEW))
#define TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_VIEW, TileViewClass))

typedef struct _TileView TileView;
typedef struct _TileViewClass TileViewClass;

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;
typedef struct _TileMovement TileMovement;

#define TYPE_TILE (tile_get_type ())
typedef struct _Tile Tile;

#define GAME_TYPE_GAME_STATE (game_game_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _tile_movement_free0(var) ((var == NULL) ? NULL : (var = (tile_movement_free (var), NULL)))
#define _tile_free0(var) ((var == NULL) ? NULL : (var = (tile_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GridPosition {
	guint row;
	guint col;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};

struct _Tile {
	GridPosition pos;
	guint val;
};

typedef enum  {
	GAME_GAME_STATE_STOPPED,
	GAME_GAME_STATE_IDLE,
	GAME_GAME_STATE_MOVING_DOWN,
	GAME_GAME_STATE_MOVING_UP,
	GAME_GAME_STATE_MOVING_RIGHT,
	GAME_GAME_STATE_MOVING_LEFT,
	GAME_GAME_STATE_SHOWING_FIRST_TILE,
	GAME_GAME_STATE_SHOWING_SECOND_TILE,
	GAME_GAME_STATE_RESTORING_TILES
} GameGameState;

struct _GamePrivate {
	gint BLANK_ROW_HEIGHT;
	gint BLANK_COL_WIDTH;
	Grid* _grid;
	ClutterActor* _view;
	RoundedRectangle** _background;
	gint _background_length1;
	gint _background_length2;
	TileView** _foreground_cur;
	gint _foreground_cur_length1;
	gint _foreground_cur_length2;
	TileView** _foreground_nxt;
	gint _foreground_nxt_length1;
	gint _foreground_nxt_length2;
	GeeLinkedList* _to_move;
	GeeLinkedList* _to_hide;
	GeeLinkedList* _to_show;
	GameGameState _state;
	ClutterTransitionGroup* _show_hide_trans;
	ClutterTransitionGroup* _move_trans;
	gint _animations_duration;
	gboolean _allow_undo;
	guint _undo_stack_max_size;
	GeeLinkedList* _undo_stack;
	GSettings* _settings;
	gchar* _saved_path;
	guint _resize_view_id;
	guint _score;
};


static gpointer game_parent_class = NULL;

GType game_get_type (void) G_GNUC_CONST;
GType grid_get_type (void) G_GNUC_CONST;
GType rounded_rectangle_get_type (void) G_GNUC_CONST;
GType tile_view_get_type (void) G_GNUC_CONST;
GType tile_movement_get_type (void) G_GNUC_CONST;
GType grid_position_get_type (void) G_GNUC_CONST;
GridPosition* grid_position_dup (const GridPosition* self);
void grid_position_free (GridPosition* self);
TileMovement* tile_movement_dup (const TileMovement* self);
void tile_movement_free (TileMovement* self);
GType tile_get_type (void) G_GNUC_CONST;
Tile* tile_dup (const Tile* self);
void tile_free (Tile* self);
static GType game_game_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_VIEW,
	GAME_SCORE
};
Game* game_new (GSettings* settings);
Game* game_construct (GType object_type, GSettings* settings);
Grid* grid_new (gint rows, gint cols);
Grid* grid_construct (GType object_type, gint rows, gint cols);
void game_new_game (Game* self);
void grid_clear (Grid* self);
static void _game_clear_foreground (Game* self);
void game_set_score (Game* self, guint value);
static void _game_create_random_tile (Game* self);
void game_undo (Game* self);
static void _game_restore_foreground (Game* self, gboolean animate);
void game_save_game (Game* self);
gchar* grid_save (Grid* self);
gboolean game_restore_game (Game* self);
gboolean grid_load (Grid* self, const gchar* content);
static void _game_clear_background (Game* self);
static void _game_init_background (Game* self);
gboolean game_key_pressed (Game* self, GdkEventKey* event);
static guint _game_upper_key (Game* self, guint keyval);
static void _game_move_down (Game* self);
static void _game_move_up (Game* self);
static void _game_move_left (Game* self);
static void _game_move_right (Game* self);
gboolean game_reload_settings (Game* self);
gint grid_get_rows (Grid* self);
gint grid_get_cols (Grid* self);
static void _game_on_allocation_changed (Game* self, ClutterActorBox* box, ClutterAllocationFlags flags);
static void _game_resize_view (Game* self);
RoundedRectangle* rounded_rectangle_new (gfloat x, gfloat y, gfloat width, gfloat height, ClutterColor* color);
RoundedRectangle* rounded_rectangle_construct (GType object_type, gfloat x, gfloat y, gfloat width, gfloat height, ClutterColor* color);
ClutterActor* rounded_rectangle_get_actor (RoundedRectangle* self);
ClutterCanvas* rounded_rectangle_get_canvas (RoundedRectangle* self);
void rounded_rectangle_resize (RoundedRectangle* self, gfloat x, gfloat y, gfloat width, gfloat height);
static gboolean _game_idle_resize_view (Game* self);
static gboolean __game_idle_resize_view_gsource_func (gpointer self);
void rounded_rectangle_idle_resize (RoundedRectangle* self);
gboolean grid_new_tile (Grid* self, Tile* tile);
static void _game_create_show_hide_transition (Game* self, gboolean animate);
static void _game_create_tile (Game* self, Tile* tile);
static void _game_show_tile (Game* self, GridPosition* pos);
TileView* tile_view_new (gfloat x, gfloat y, gfloat width, gfloat height, guint val);
TileView* tile_view_construct (GType object_type, gfloat x, gfloat y, gfloat width, gfloat height, guint val);
static void _game_store_movement (Game* self);
static void _game_on_move_trans_stopped (Game* self, gboolean is_finished);
static void __game_on_move_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self);
void grid_move_down (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
static void _game_move_tile (Game* self, GridPosition* from, GridPosition* to);
static void _game_prepare_move_tile (Game* self, GridPosition* from, GridPosition* to);
void grid_move_up (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_left (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
void grid_move_right (Grid* self, GeeLinkedList* to_move, GeeLinkedList* to_hide, GeeLinkedList* to_show);
gchar* grid_position_to_string (GridPosition *self);
static void _game_dim_tile (Game* self, GridPosition* pos);
guint tile_view_get_value (TileView* self);
guint grid_get (Grid* self, gint row, gint col);
gchar* grid_to_string (Grid* self);
guint game_get_score (Game* self);
static void _game_on_show_hide_trans_stopped (Game* self, gboolean is_finished);
static gboolean _game_finish_move (Game* self);
static gboolean __game_finish_move_gsource_func (gpointer self);
static void __game_on_show_hide_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self);
gboolean grid_get_target_value_reached (Grid* self);
guint grid_get_target_value (Grid* self);
void grid_set_target_value_reached (Grid* self, gboolean value);
gboolean grid_is_finished (Grid* self);
Grid* grid_clone (Grid* self);
ClutterActor* game_get_view (Game* self);
void game_set_view (Game* self, ClutterActor* value);
static void __game_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType game_game_state_get_type (void) {
	static volatile gsize game_game_state_type_id__volatile = 0;
	if (g_once_init_enter (&game_game_state_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_GAME_STATE_STOPPED, "GAME_GAME_STATE_STOPPED", "stopped"}, {GAME_GAME_STATE_IDLE, "GAME_GAME_STATE_IDLE", "idle"}, {GAME_GAME_STATE_MOVING_DOWN, "GAME_GAME_STATE_MOVING_DOWN", "moving-down"}, {GAME_GAME_STATE_MOVING_UP, "GAME_GAME_STATE_MOVING_UP", "moving-up"}, {GAME_GAME_STATE_MOVING_RIGHT, "GAME_GAME_STATE_MOVING_RIGHT", "moving-right"}, {GAME_GAME_STATE_MOVING_LEFT, "GAME_GAME_STATE_MOVING_LEFT", "moving-left"}, {GAME_GAME_STATE_SHOWING_FIRST_TILE, "GAME_GAME_STATE_SHOWING_FIRST_TILE", "showing-first-tile"}, {GAME_GAME_STATE_SHOWING_SECOND_TILE, "GAME_GAME_STATE_SHOWING_SECOND_TILE", "showing-second-tile"}, {GAME_GAME_STATE_RESTORING_TILES, "GAME_GAME_STATE_RESTORING_TILES", "restoring-tiles"}, {0, NULL, NULL}};
		GType game_game_state_type_id;
		game_game_state_type_id = g_enum_register_static ("GameGameState", values);
		g_once_init_leave (&game_game_state_type_id__volatile, game_game_state_type_id);
	}
	return game_game_state_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return self ? g_object_ref (self) : NULL;
#line 278 "game.c"
}


Game* game_construct (GType object_type, GSettings* settings) {
	Game * self = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint rows = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint cols = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Grid* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GSettings* _tmp9_ = NULL;
	Grid* _tmp10_ = NULL;
	GeeLinkedList* _tmp11_ = NULL;
	GeeLinkedList* _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	GeeLinkedList* _tmp14_ = NULL;
	GSettings* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
#line 67 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (settings != NULL, NULL);
#line 69 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self = (Game*) g_object_new (object_type, NULL);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = settings;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_settings);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_settings = _tmp1_;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_settings;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_settings_get_int (_tmp2_, "rows");
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp3_;
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_settings;
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = g_settings_get_int (_tmp4_, "cols");
#line 74 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = grid_new (rows, cols);
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_grid);
#line 75 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_grid = _tmp6_;
#line 77 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_settings;
#line 77 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = g_settings_get_double (_tmp7_, "animations-speed");
#line 77 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_animations_duration = (gint) _tmp8_;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = self->priv->_settings;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = self->priv->_grid;
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_settings_bind (_tmp9_, "target-value", (GObject*) _tmp10_, "target_value", G_SETTINGS_BIND_DEFAULT);
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, tile_movement_free, NULL, NULL, NULL);
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_move);
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_to_move = _tmp11_;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, tile_movement_free, NULL, NULL, NULL);
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_hide);
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_to_hide = _tmp12_;
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = gee_linked_list_new (TYPE_TILE, (GBoxedCopyFunc) tile_dup, tile_free, NULL, NULL, NULL);
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_show);
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_to_show = _tmp13_;
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = gee_linked_list_new (TYPE_GRID, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_undo_stack);
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_undo_stack = _tmp14_;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = self->priv->_settings;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = g_settings_get_boolean (_tmp15_, "allow-undo");
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_allow_undo = _tmp16_;
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_settings;
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = g_settings_get_int (_tmp17_, "allow-undo-max");
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_undo_stack_max_size = (guint) _tmp18_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = g_get_user_data_dir ();
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = g_build_filename (_tmp19_, "gnome-2048", "saved", NULL);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (self->priv->_saved_path);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_saved_path = _tmp20_;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_state = GAME_GAME_STATE_STOPPED;
#line 67 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return self;
#line 397 "game.c"
}


Game* game_new (GSettings* settings) {
#line 67 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return game_construct (TYPE_GAME, settings);
#line 404 "game.c"
}


void game_new_game (Game* self) {
	Grid* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_clear (_tmp0_);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_undo_stack;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_clear_foreground (self);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_set_score (self, (guint) 0);
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_state = GAME_GAME_STATE_SHOWING_FIRST_TILE;
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_random_tile (self);
#line 429 "game.c"
}


void game_undo (Game* self) {
	Grid* grid = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	Grid* _tmp2_ = NULL;
	Grid* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_undo_stack;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = gee_deque_poll_head ((GeeDeque*) _tmp0_);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid = (Grid*) _tmp1_;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_clear_foreground (self);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_grid);
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_grid = _tmp3_;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_restore_foreground (self, FALSE);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_undo_stack;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp6_ == 0) {
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "undo-disabled");
#line 472 "game.c"
	}
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (grid);
#line 476 "game.c"
}


void game_save_game (Game* self) {
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Grid* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = g_strdup ("");
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	contents = _tmp0_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = contents;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_grid;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = grid_save (_tmp2_);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = g_strconcat (_tmp1_, _tmp4_, NULL);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	contents = _tmp5_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp4_);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = contents;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_score;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = g_strdup_printf ("%u", _tmp7_);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp8_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = g_strconcat (_tmp9_, "\n", NULL);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = _tmp10_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_strconcat (_tmp6_, _tmp11_, NULL);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	contents = _tmp12_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp11_);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp9_);
#line 540 "game.c"
	{
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp13_ = self->priv->_saved_path;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp14_ = g_path_get_dirname (_tmp13_);
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = _tmp14_;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_mkdir_with_parents (_tmp15_, 0775);
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (_tmp15_);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp16_ = self->priv->_saved_path;
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp17_ = contents;
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_file_set_contents (_tmp16_, _tmp17_, (gssize) -1, &_inner_error_);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 567 "game.c"
				goto __catch10_g_file_error;
			}
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (contents);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_clear_error (&_inner_error_);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			return;
#line 578 "game.c"
		}
#line 137 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_debug ("game.vala:137: game saved successfully");
#line 582 "game.c"
	}
	goto __finally10;
	__catch10_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		e = _inner_error_;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_inner_error_ = NULL;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp18_ = e;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp19_ = _tmp18_->message;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_warning ("game.vala:139: Failed to save game: %s", _tmp19_);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_error_free0 (e);
#line 602 "game.c"
	}
	__finally10:
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_clear_error (&_inner_error_);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return;
#line 615 "game.c"
	}
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 619 "game.c"
}


gboolean game_restore_game (Game* self) {
	gboolean result = FALSE;
	gchar* contents = NULL;
	gchar** lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	Grid* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	RoundedRectangle** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gint _tmp14__length2 = 0;
	GError * _inner_error_ = NULL;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 647 "game.c"
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp0_ = self->priv->_saved_path;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		contents = _tmp1_;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 663 "game.c"
				goto __catch11_g_file_error;
			}
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (contents);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_clear_error (&_inner_error_);
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			return FALSE;
#line 676 "game.c"
		}
	}
	goto __finally11;
	__catch11_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		e = _inner_error_;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_inner_error_ = NULL;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = e;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = _tmp2_->message;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_warning ("game.vala:151: Failed to restore game: %s", _tmp3_);
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = FALSE;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_error_free0 (e);
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 705 "game.c"
	}
	__finally11:
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_clear_error (&_inner_error_);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return FALSE;
#line 720 "game.c"
	}
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = contents;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = grid_load (_tmp4_, _tmp5_);
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (!_tmp6_) {
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = FALSE;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_free0 (contents);
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 738 "game.c"
	}
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = contents;
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "\n", 0);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines = _tmp9_;
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines_length1 = _vala_array_length (_tmp8_);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_lines_size_ = lines_length1;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = lines;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10__length1 = lines_length1;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = lines;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11__length1 = lines_length1;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp10_[_tmp11__length1 - 2];
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = atoi (_tmp12_);
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_set_score (self, (guint) _tmp13_);
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = self->priv->_background;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14__length1 = self->priv->_background_length1;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14__length2 = self->priv->_background_length2;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp14_ != NULL) {
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_clear_background (self);
#line 776 "game.c"
	}
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_init_background (self);
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_restore_foreground (self, TRUE);
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:166: game restored successfully");
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = TRUE;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (contents);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 792 "game.c"
}


gboolean game_key_pressed (Game* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GameGameState _tmp0_ = 0;
	guint keyval = 0U;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_state;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_ != GAME_GAME_STATE_IDLE) {
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = TRUE;
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 816 "game.c"
	}
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = event;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_->keyval;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _game_upper_key (self, _tmp2_);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	keyval = _tmp3_;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = keyval;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp4_ == ((guint) GDK_KEY_Down)) {
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_move_down (self);
#line 832 "game.c"
	} else {
		guint _tmp5_ = 0U;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp5_ = keyval;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (_tmp5_ == ((guint) GDK_KEY_Up)) {
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_up (self);
#line 841 "game.c"
		} else {
			guint _tmp6_ = 0U;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = keyval;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_tmp6_ == ((guint) GDK_KEY_Left)) {
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_game_move_left (self);
#line 850 "game.c"
			} else {
				guint _tmp7_ = 0U;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp7_ = keyval;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (_tmp7_ == ((guint) GDK_KEY_Right)) {
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_game_move_right (self);
#line 859 "game.c"
				}
			}
		}
	}
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 868 "game.c"
}


gboolean game_reload_settings (Game* self) {
	gboolean result = FALSE;
	gint rows = 0;
	gint cols = 0;
	gboolean allow_undo = FALSE;
	GSettings* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GSettings* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GSettings* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	Grid* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_settings;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = g_settings_get_double (_tmp0_, "animations-speed");
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_animations_duration = (gint) _tmp1_;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_settings;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_settings_get_boolean (_tmp2_, "allow-undo");
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	allow_undo = _tmp3_;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_allow_undo;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp5_) {
#line 913 "game.c"
		gboolean _tmp6_ = FALSE;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp6_ = allow_undo;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = !_tmp6_;
#line 919 "game.c"
	} else {
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = FALSE;
#line 923 "game.c"
	}
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp4_) {
#line 927 "game.c"
		GeeLinkedList* _tmp7_ = NULL;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp7_ = self->priv->_undo_stack;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "undo-disabled");
#line 935 "game.c"
	}
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = allow_undo;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_allow_undo = _tmp8_;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = self->priv->_settings;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = g_settings_get_int (_tmp9_, "allow-undo-max");
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_undo_stack_max_size = (guint) _tmp10_;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = self->priv->_settings;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_settings_get_int (_tmp11_, "rows");
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp12_;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_settings;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = g_settings_get_int (_tmp13_, "cols");
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp14_;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = rows;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_grid;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = grid_get_rows (_tmp17_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _tmp18_;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp16_ != _tmp19_) {
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = TRUE;
#line 971 "game.c"
	} else {
		gint _tmp20_ = 0;
		Grid* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp20_ = cols;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp21_ = self->priv->_grid;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp22_ = grid_get_cols (_tmp21_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = _tmp22_;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = _tmp20_ != _tmp23_;
#line 987 "game.c"
	}
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp15_) {
#line 991 "game.c"
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		Grid* _tmp26_ = NULL;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_clear_foreground (self);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_clear_background (self);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = rows;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = cols;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = grid_new (_tmp24_, _tmp25_);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (self->priv->_grid);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_grid = _tmp26_;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_init_background (self);
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		result = TRUE;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return result;
#line 1015 "game.c"
	}
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 1021 "game.c"
}


static guint _game_upper_key (Game* self, guint keyval) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = keyval;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp1_ > ((guint) 255)) {
#line 1035 "game.c"
		guint _tmp2_ = 0U;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = keyval;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp0_ = _tmp2_;
#line 1041 "game.c"
	} else {
		guint _tmp3_ = 0U;
		gchar _tmp4_ = '\0';
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = keyval;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = g_ascii_toupper ((gchar) _tmp3_);
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp0_ = (guint) _tmp4_;
#line 1051 "game.c"
	}
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = _tmp0_;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 1057 "game.c"
}


static void _game_on_allocation_changed (Game* self, ClutterActorBox* box, ClutterAllocationFlags flags) {
	RoundedRectangle** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (box != NULL);
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_background;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0__length1 = self->priv->_background_length1;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0__length2 = self->priv->_background_length2;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_ == NULL) {
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_init_background (self);
#line 1079 "game.c"
	} else {
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_resize_view (self);
#line 1083 "game.c"
	}
}


static void _game_init_background (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	ClutterColor background_color = {0};
	ClutterActor* _tmp6_ = NULL;
	ClutterColor _tmp7_ = {0};
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	RoundedRectangle** _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	TileView** _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	TileView** _tmp16_ = NULL;
	gfloat canvas_width = 0.0F;
	ClutterActor* _tmp17_ = NULL;
	gfloat _tmp18_ = 0.0F;
	gfloat _tmp19_ = 0.0F;
	gfloat canvas_height = 0.0F;
	ClutterActor* _tmp20_ = NULL;
	gfloat _tmp21_ = 0.0F;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gfloat _tmp26_ = 0.0F;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gfloat tile_width = 0.0F;
	gfloat _tmp29_ = 0.0F;
	gint _tmp30_ = 0;
	gfloat tile_height = 0.0F;
	gfloat _tmp31_ = 0.0F;
	gint _tmp32_ = 0;
	ClutterColor color = {0};
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_color_from_string (&background_color, "#babdb6");
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_view;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = background_color;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_set_background_color (_tmp6_, &_tmp7_);
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = rows;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = cols;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = g_new0 (RoundedRectangle*, (_tmp8_ * _tmp9_) + 1);
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background = (_vala_array_free (self->priv->_background, self->priv->_background_length1 * self->priv->_background_length2, (GDestroyNotify) g_object_unref), NULL);
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background = _tmp10_;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background_length1 = _tmp8_;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background_length2 = _tmp9_;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = rows;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = cols;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = g_new0 (TileView*, (_tmp11_ * _tmp12_) + 1);
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur = _tmp13_;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur_length1 = _tmp11_;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur_length2 = _tmp12_;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = rows;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = cols;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = g_new0 (TileView*, (_tmp14_ * _tmp15_) + 1);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt = _tmp16_;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt_length1 = _tmp14_;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt_length2 = _tmp15_;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_view;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = clutter_actor_get_width (_tmp17_);
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _tmp18_;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp19_;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = self->priv->_view;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = clutter_actor_get_height (_tmp20_);
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = _tmp21_;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp22_;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = canvas_width;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = cols;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = self->priv->BLANK_COL_WIDTH;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp23_ - ((_tmp24_ + 1) * _tmp25_);
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = canvas_height;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = rows;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = self->priv->BLANK_ROW_HEIGHT;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp26_ - ((_tmp27_ + 1) * _tmp28_);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp29_ = canvas_width;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = cols;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_width = _tmp29_ / _tmp30_;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = canvas_height;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = rows;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_height = _tmp31_ / _tmp32_;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_color_from_string (&color, "#ffffff");
#line 1244 "game.c"
	{
		gint i = 0;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 1249 "game.c"
		{
			gboolean _tmp33_ = FALSE;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = TRUE;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 1256 "game.c"
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp33_) {
#line 1261 "game.c"
					gint _tmp34_ = 0;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp34_ = i;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp34_ + 1;
#line 1267 "game.c"
				}
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp33_ = FALSE;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp35_ = i;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp36_ = rows;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp35_ < _tmp36_)) {
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 1279 "game.c"
				}
				{
					gint j = 0;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 1285 "game.c"
					{
						gboolean _tmp37_ = FALSE;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp37_ = TRUE;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 1292 "game.c"
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gfloat x = 0.0F;
							gint _tmp41_ = 0;
							gfloat _tmp42_ = 0.0F;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gfloat y = 0.0F;
							gint _tmp45_ = 0;
							gfloat _tmp46_ = 0.0F;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							RoundedRectangle* rect = NULL;
							gfloat _tmp49_ = 0.0F;
							gfloat _tmp50_ = 0.0F;
							gfloat _tmp51_ = 0.0F;
							gfloat _tmp52_ = 0.0F;
							ClutterColor _tmp53_ = {0};
							RoundedRectangle* _tmp54_ = NULL;
							ClutterActor* _tmp55_ = NULL;
							RoundedRectangle* _tmp56_ = NULL;
							ClutterActor* _tmp57_ = NULL;
							ClutterActor* _tmp58_ = NULL;
							RoundedRectangle* _tmp59_ = NULL;
							ClutterCanvas* _tmp60_ = NULL;
							ClutterCanvas* _tmp61_ = NULL;
							RoundedRectangle* _tmp62_ = NULL;
							ClutterActor* _tmp63_ = NULL;
							ClutterActor* _tmp64_ = NULL;
							RoundedRectangle** _tmp65_ = NULL;
							gint _tmp65__length1 = 0;
							gint _tmp65__length2 = 0;
							gint _tmp66_ = 0;
							gint _tmp67_ = 0;
							RoundedRectangle* _tmp68_ = NULL;
							RoundedRectangle* _tmp69_ = NULL;
							RoundedRectangle* _tmp70_ = NULL;
							TileView** _tmp71_ = NULL;
							gint _tmp71__length1 = 0;
							gint _tmp71__length2 = 0;
							gint _tmp72_ = 0;
							gint _tmp73_ = 0;
							TileView* _tmp74_ = NULL;
							TileView** _tmp75_ = NULL;
							gint _tmp75__length1 = 0;
							gint _tmp75__length2 = 0;
							gint _tmp76_ = 0;
							gint _tmp77_ = 0;
							TileView* _tmp78_ = NULL;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp37_) {
#line 1344 "game.c"
								gint _tmp38_ = 0;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp38_ = j;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp38_ + 1;
#line 1350 "game.c"
							}
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp37_ = FALSE;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp39_ = j;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp40_ = cols;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp39_ < _tmp40_)) {
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 1362 "game.c"
							}
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp41_ = j;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp42_ = tile_width;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp43_ = j;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp44_ = self->priv->BLANK_COL_WIDTH;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							x = (_tmp41_ * _tmp42_) + ((_tmp43_ + 1) * _tmp44_);
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp45_ = i;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46_ = tile_height;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp47_ = i;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp48_ = self->priv->BLANK_ROW_HEIGHT;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							y = (_tmp45_ * _tmp46_) + ((_tmp47_ + 1) * _tmp48_);
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp49_ = x;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp50_ = y;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp51_ = tile_width;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp52_ = tile_height;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp53_ = color;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp54_ = rounded_rectangle_new (_tmp49_, _tmp50_, _tmp51_, _tmp52_, &_tmp53_);
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rect = _tmp54_;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp55_ = self->priv->_view;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp56_ = rect;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp57_ = rounded_rectangle_get_actor (_tmp56_);
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58_ = _tmp57_;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_add_child (_tmp55_, _tmp58_);
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp59_ = rect;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp60_ = rounded_rectangle_get_canvas (_tmp59_);
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp61_ = _tmp60_;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_content_invalidate ((ClutterContent*) _tmp61_);
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp62_ = rect;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp63_ = rounded_rectangle_get_actor (_tmp62_);
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp64_ = _tmp63_;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_show (_tmp64_);
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65_ = self->priv->_background;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65__length1 = self->priv->_background_length1;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65__length2 = self->priv->_background_length2;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp66_ = i;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp67_ = j;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp68_ = rect;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp69_ = _g_object_ref0 (_tmp68_);
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_]);
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_] = _tmp69_;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp70_ = _tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_];
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71_ = self->priv->_foreground_cur;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71__length1 = self->priv->_foreground_cur_length1;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71__length2 = self->priv->_foreground_cur_length2;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp72_ = i;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp73_ = j;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (_tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_]);
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_] = NULL;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp74_ = _tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_];
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75_ = self->priv->_foreground_nxt;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75__length1 = self->priv->_foreground_nxt_length1;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75__length2 = self->priv->_foreground_nxt_length2;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp76_ = i;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp77_ = j;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (_tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_]);
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_] = NULL;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp78_ = _tmp75_[(_tmp76_ * _tmp75__length2) + _tmp77_];
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (rect);
#line 1478 "game.c"
						}
					}
				}
			}
		}
	}
}


static gboolean __game_idle_resize_view_gsource_func (gpointer self) {
	gboolean result;
	result = _game_idle_resize_view ((Game*) self);
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 1493 "game.c"
}


static void _game_resize_view (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gfloat canvas_width = 0.0F;
	ClutterActor* _tmp6_ = NULL;
	gfloat _tmp7_ = 0.0F;
	gfloat _tmp8_ = 0.0F;
	gfloat canvas_height = 0.0F;
	ClutterActor* _tmp9_ = NULL;
	gfloat _tmp10_ = 0.0F;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gfloat _tmp15_ = 0.0F;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gfloat tile_width = 0.0F;
	gfloat _tmp18_ = 0.0F;
	gint _tmp19_ = 0;
	gfloat tile_height = 0.0F;
	gfloat _tmp20_ = 0.0F;
	gint _tmp21_ = 0;
	guint _tmp70_ = 0U;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_view;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = clutter_actor_get_width (_tmp6_);
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _tmp7_;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp8_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = self->priv->_view;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = clutter_actor_get_height (_tmp9_);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = _tmp10_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp11_;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = canvas_width;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = cols;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = self->priv->BLANK_COL_WIDTH;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_width = _tmp12_ - ((_tmp13_ + 1) * _tmp14_);
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = canvas_height;
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = rows;
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->BLANK_ROW_HEIGHT;
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	canvas_height = _tmp15_ - ((_tmp16_ + 1) * _tmp17_);
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = canvas_width;
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = cols;
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_width = _tmp18_ / _tmp19_;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = canvas_height;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = rows;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile_height = _tmp20_ / _tmp21_;
#line 1589 "game.c"
	{
		gint i = 0;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 1594 "game.c"
		{
			gboolean _tmp22_ = FALSE;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = TRUE;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 1601 "game.c"
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp22_) {
#line 1606 "game.c"
					gint _tmp23_ = 0;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp23_ = i;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp23_ + 1;
#line 1612 "game.c"
				}
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp22_ = FALSE;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp24_ = i;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp25_ = rows;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp24_ < _tmp25_)) {
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 1624 "game.c"
				}
				{
					gint j = 0;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 1630 "game.c"
					{
						gboolean _tmp26_ = FALSE;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp26_ = TRUE;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 1637 "game.c"
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gfloat x = 0.0F;
							gint _tmp30_ = 0;
							gfloat _tmp31_ = 0.0F;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gfloat y = 0.0F;
							gint _tmp34_ = 0;
							gfloat _tmp35_ = 0.0F;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							RoundedRectangle** _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp38__length2 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							RoundedRectangle* _tmp41_ = NULL;
							gfloat _tmp42_ = 0.0F;
							gfloat _tmp43_ = 0.0F;
							gfloat _tmp44_ = 0.0F;
							gfloat _tmp45_ = 0.0F;
							TileView** _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							gint _tmp46__length2 = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							TileView* _tmp49_ = NULL;
							TileView** _tmp58_ = NULL;
							gint _tmp58__length1 = 0;
							gint _tmp58__length2 = 0;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
							TileView* _tmp61_ = NULL;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp26_) {
#line 1674 "game.c"
								gint _tmp27_ = 0;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp27_ = j;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp27_ + 1;
#line 1680 "game.c"
							}
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp26_ = FALSE;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp28_ = j;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp29_ = cols;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp28_ < _tmp29_)) {
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 1692 "game.c"
							}
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp30_ = j;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp31_ = tile_width;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp32_ = j;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp33_ = self->priv->BLANK_COL_WIDTH;
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							x = (_tmp30_ * _tmp31_) + ((_tmp32_ + 1) * _tmp33_);
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp34_ = i;
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp35_ = tile_height;
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp36_ = i;
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp37_ = self->priv->BLANK_ROW_HEIGHT;
#line 294 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							y = (_tmp34_ * _tmp35_) + ((_tmp36_ + 1) * _tmp37_);
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp38_ = self->priv->_background;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp38__length1 = self->priv->_background_length1;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp38__length2 = self->priv->_background_length2;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp39_ = i;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp40_ = j;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp42_ = x;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp43_ = y;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp44_ = tile_width;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp45_ = tile_height;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rounded_rectangle_resize (_tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_);
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46_ = self->priv->_foreground_cur;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46__length1 = self->priv->_foreground_cur_length1;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp46__length2 = self->priv->_foreground_cur_length2;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp47_ = i;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp48_ = j;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp49_ = _tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_];
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp49_ != NULL) {
#line 1750 "game.c"
								TileView** _tmp50_ = NULL;
								gint _tmp50__length1 = 0;
								gint _tmp50__length2 = 0;
								gint _tmp51_ = 0;
								gint _tmp52_ = 0;
								TileView* _tmp53_ = NULL;
								gfloat _tmp54_ = 0.0F;
								gfloat _tmp55_ = 0.0F;
								gfloat _tmp56_ = 0.0F;
								gfloat _tmp57_ = 0.0F;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp50_ = self->priv->_foreground_cur;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp50__length1 = self->priv->_foreground_cur_length1;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp50__length2 = self->priv->_foreground_cur_length2;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp51_ = i;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp52_ = j;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp53_ = _tmp50_[(_tmp51_ * _tmp50__length2) + _tmp52_];
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp54_ = x;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp55_ = y;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp56_ = tile_width;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp57_ = tile_height;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								rounded_rectangle_resize ((RoundedRectangle*) _tmp53_, _tmp54_, _tmp55_, _tmp56_, _tmp57_);
#line 1783 "game.c"
							}
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58_ = self->priv->_foreground_nxt;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58__length1 = self->priv->_foreground_nxt_length1;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp58__length2 = self->priv->_foreground_nxt_length2;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp59_ = i;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp60_ = j;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp61_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp61_ != NULL) {
#line 1799 "game.c"
								TileView** _tmp62_ = NULL;
								gint _tmp62__length1 = 0;
								gint _tmp62__length2 = 0;
								gint _tmp63_ = 0;
								gint _tmp64_ = 0;
								TileView* _tmp65_ = NULL;
								gfloat _tmp66_ = 0.0F;
								gfloat _tmp67_ = 0.0F;
								gfloat _tmp68_ = 0.0F;
								gfloat _tmp69_ = 0.0F;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp62_ = self->priv->_foreground_nxt;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp62__length1 = self->priv->_foreground_nxt_length1;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp62__length2 = self->priv->_foreground_nxt_length2;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp63_ = i;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp64_ = j;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp65_ = _tmp62_[(_tmp63_ * _tmp62__length2) + _tmp64_];
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp66_ = x;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp67_ = y;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp68_ = tile_width;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp69_ = tile_height;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								rounded_rectangle_resize ((RoundedRectangle*) _tmp65_, _tmp66_, _tmp67_, _tmp68_, _tmp69_);
#line 1832 "game.c"
							}
						}
					}
				}
			}
		}
	}
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp70_ = self->priv->_resize_view_id;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp70_ == ((guint) 0)) {
#line 1844 "game.c"
		guint _tmp71_ = 0U;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp71_ = clutter_threads_add_timeout ((guint) 1000, __game_idle_resize_view_gsource_func, self);
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_resize_view_id = _tmp71_;
#line 1850 "game.c"
	}
}


static gboolean _game_idle_resize_view (Game* self) {
	gboolean result = FALSE;
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 1883 "game.c"
	{
		gint i = 0;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 1888 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = TRUE;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 1895 "game.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp6_) {
#line 1900 "game.c"
					gint _tmp7_ = 0;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp7_ = i;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp7_ + 1;
#line 1906 "game.c"
				}
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp6_ = FALSE;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp8_ = i;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = rows;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 1918 "game.c"
				}
				{
					gint j = 0;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 1924 "game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp10_ = TRUE;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 1931 "game.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							RoundedRectangle** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							RoundedRectangle* _tmp17_ = NULL;
							TileView** _tmp18_ = NULL;
							gint _tmp18__length1 = 0;
							gint _tmp18__length2 = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							TileView* _tmp21_ = NULL;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp10_) {
#line 1948 "game.c"
								gint _tmp11_ = 0;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp11_ = j;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp11_ + 1;
#line 1954 "game.c"
							}
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp10_ = FALSE;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp12_ = j;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = cols;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 1966 "game.c"
							}
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = self->priv->_background;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length1 = self->priv->_background_length1;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length2 = self->priv->_background_length2;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = i;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = j;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rounded_rectangle_idle_resize (_tmp17_);
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18_ = self->priv->_foreground_cur;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18__length1 = self->priv->_foreground_cur_length1;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18__length2 = self->priv->_foreground_cur_length2;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp19_ = i;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp20_ = j;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp21_ != NULL) {
#line 1996 "game.c"
								TileView** _tmp22_ = NULL;
								gint _tmp22__length1 = 0;
								gint _tmp22__length2 = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								TileView* _tmp25_ = NULL;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_ = self->priv->_foreground_cur;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22__length1 = self->priv->_foreground_cur_length1;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22__length2 = self->priv->_foreground_cur_length2;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp23_ = i;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp24_ = j;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								rounded_rectangle_idle_resize ((RoundedRectangle*) _tmp25_);
#line 2017 "game.c"
							}
						}
					}
				}
			}
		}
	}
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_resize_view_id = (guint) 0;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 2031 "game.c"
}


static void _game_create_random_tile (Game* self) {
	Tile tile = {0};
	Grid* _tmp0_ = NULL;
	Tile _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid_new_tile (_tmp0_, &_tmp1_);
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	tile = _tmp1_;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp2_) {
#line 2050 "game.c"
		Tile _tmp3_ = {0};
		GeeLinkedList* _tmp4_ = NULL;
		Tile _tmp5_ = {0};
		Tile _tmp6_ = {0};
		GridPosition _tmp7_ = {0};
		ClutterTransitionGroup* _tmp8_ = NULL;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_create_show_hide_transition (self, TRUE);
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = tile;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_create_tile (self, &_tmp3_);
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = self->priv->_to_show;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp5_ = tile;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, &_tmp5_);
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp6_ = tile;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp7_ = _tmp6_.pos;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_show_tile (self, &_tmp7_);
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_show_hide_trans;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp8_);
#line 2079 "game.c"
	}
}


static void _game_create_tile (Game* self, Tile* tile) {
	GridPosition pos = {0};
	RoundedRectangle* rect = NULL;
	TileView* view = NULL;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	Tile _tmp0_ = {0};
	GridPosition _tmp1_ = {0};
	RoundedRectangle** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	GridPosition _tmp3_ = {0};
	guint _tmp4_ = 0U;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	RoundedRectangle* _tmp7_ = NULL;
	RoundedRectangle* _tmp8_ = NULL;
	ClutterActor* _tmp9_ = NULL;
	ClutterActor* _tmp10_ = NULL;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	gfloat _tmp15_ = 0.0F;
	gfloat _tmp16_ = 0.0F;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	gfloat _tmp19_ = 0.0F;
	gfloat _tmp20_ = 0.0F;
	ClutterActor* _tmp21_ = NULL;
	ClutterActor* _tmp22_ = NULL;
	gfloat _tmp23_ = 0.0F;
	gfloat _tmp24_ = 0.0F;
	TileView** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint _tmp25__length2 = 0;
	GridPosition _tmp26_ = {0};
	guint _tmp27_ = 0U;
	GridPosition _tmp28_ = {0};
	guint _tmp29_ = 0U;
	TileView* _tmp30_ = NULL;
	Tile _tmp31_ = {0};
	guint _tmp32_ = 0U;
	TileView* _tmp33_ = NULL;
	TileView** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	gint _tmp34__length2 = 0;
	GridPosition _tmp35_ = {0};
	guint _tmp36_ = 0U;
	GridPosition _tmp37_ = {0};
	guint _tmp38_ = 0U;
	TileView* _tmp39_ = NULL;
	TileView* _tmp40_ = NULL;
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (tile != NULL);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = *tile;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_.pos;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	pos = _tmp1_;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_background;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2__length1 = self->priv->_background_length1;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2__length2 = self->priv->_background_length2;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = pos;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_.row;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = pos;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_.col;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp2_[(_tmp4_ * _tmp2__length2) + _tmp6_];
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect);
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rect = _tmp8_;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = rounded_rectangle_get_actor (rect);
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = _tmp9_;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = clutter_actor_get_x (_tmp10_);
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	x = _tmp12_;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = rounded_rectangle_get_actor (rect);
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = _tmp13_;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = clutter_actor_get_y (_tmp14_);
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = _tmp15_;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	y = _tmp16_;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = rounded_rectangle_get_actor (rect);
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp17_;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = clutter_actor_get_width (_tmp18_);
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = _tmp19_;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	width = _tmp20_;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = rounded_rectangle_get_actor (rect);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = _tmp21_;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = clutter_actor_get_height (_tmp22_);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = _tmp23_;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	height = _tmp24_;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = self->priv->_foreground_nxt;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25__length1 = self->priv->_foreground_nxt_length1;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25__length2 = self->priv->_foreground_nxt_length2;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = pos;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = _tmp26_.row;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = pos;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp29_ = _tmp28_.col;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = _tmp25_[(_tmp27_ * _tmp25__length2) + _tmp29_];
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_vala_assert (_tmp30_ == NULL, "_foreground_nxt[pos.row,pos.col] == null");
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = *tile;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = _tmp31_.val;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp33_ = tile_view_new (x, y, width, height, _tmp32_);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	view = _tmp33_;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34_ = self->priv->_foreground_nxt;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34__length1 = self->priv->_foreground_nxt_length1;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34__length2 = self->priv->_foreground_nxt_length2;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp35_ = pos;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp36_ = _tmp35_.row;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp37_ = pos;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp38_ = _tmp37_.col;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp39_ = _g_object_ref0 (view);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (_tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_]);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_] = _tmp39_;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = _tmp34_[(_tmp36_ * _tmp34__length2) + _tmp38_];
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect);
#line 2265 "game.c"
}


static void __game_on_move_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self) {
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_on_move_trans_stopped ((Game*) self, is_finished);
#line 2272 "game.c"
}


static void _game_move_down (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 364 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:366: move down");
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 372 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 372 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 372 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_down (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 2324 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2352 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2376 "game.c"
			}
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2398 "game.c"
		}
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2402 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2431 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2455 "game.c"
			}
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2477 "game.c"
		}
#line 381 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2481 "game.c"
	}
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 2493 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 2506 "game.c"
	}
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 2512 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 2525 "game.c"
	}
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 2533 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_DOWN;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 2541 "game.c"
	}
}


static void _game_move_up (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 392 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:394: move up");
#line 398 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 400 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 400 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 400 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 401 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 401 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_up (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 2594 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2622 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2646 "game.c"
			}
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2668 "game.c"
		}
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2672 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2701 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2725 "game.c"
			}
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2747 "game.c"
		}
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2751 "game.c"
	}
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 2763 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 2776 "game.c"
	}
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 2782 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 2795 "game.c"
	}
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 2803 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 415 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_UP;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 2811 "game.c"
	}
}


static void _game_move_left (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 420 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:422: move left");
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_left (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 2864 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2892 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2916 "game.c"
			}
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 435 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 435 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 435 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 435 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 435 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 2938 "game.c"
		}
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 2942 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 2971 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 2995 "game.c"
			}
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 438 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 438 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 438 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 438 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 438 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 3017 "game.c"
		}
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 3021 "game.c"
	}
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 3033 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 3046 "game.c"
	}
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 3052 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 3065 "game.c"
	}
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 3073 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_LEFT;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 3081 "game.c"
	}
}


static void _game_move_right (Game* self) {
	gboolean has_moved = FALSE;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	ClutterTransitionGroup* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Grid* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	GeeLinkedList* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gboolean _tmp49_ = FALSE;
#line 448 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:450: move right");
#line 454 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_store_movement (self);
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_move_trans = _tmp0_;
#line 457 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_move_trans;
#line 457 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
#line 458 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_move_trans;
#line 458 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_animations_duration;
#line 458 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp2_, (guint) _tmp3_);
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_grid;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_to_move;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = self->priv->_to_hide;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = self->priv->_to_show;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	grid_move_right (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 3134 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _e_index = 0;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_to_move;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp9_;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _e_list;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = _tmp11_;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp12_;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 3162 "game.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			TileMovement* _tmp19_ = NULL;
			GridPosition _tmp20_ = {0};
			TileMovement* _tmp21_ = NULL;
			GridPosition _tmp22_ = {0};
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = _e_index;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp13_ + 1;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_size;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 3186 "game.c"
			}
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_list;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_index;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp18_;
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = e;
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = (*_tmp19_).from;
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = e;
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = (*_tmp21_).to;
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_move_tile (self, &_tmp20_, &_tmp22_);
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 3208 "game.c"
		}
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 3212 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		GeeLinkedList* _tmp24_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _e_index = 0;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = self->priv->_to_hide;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp24_;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = _e_list;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp27_ = _tmp26_;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp27_;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 3241 "game.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			TileMovement* _tmp34_ = NULL;
			GridPosition _tmp35_ = {0};
			TileMovement* _tmp36_ = NULL;
			GridPosition _tmp37_ = {0};
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp28_ + 1;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_index;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_size;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 3265 "game.c"
			}
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_list;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _e_index;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp33_;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = e;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = (*_tmp34_).from;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = e;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = (*_tmp36_).to;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_prepare_move_tile (self, &_tmp35_, &_tmp37_);
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 3287 "game.c"
		}
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 3291 "game.c"
	}
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_to_move;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = _tmp41_;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp42_ > 0) {
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = TRUE;
#line 3303 "game.c"
	} else {
		GeeLinkedList* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = self->priv->_to_hide;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp43_);
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = _tmp44_;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = _tmp45_ > 0;
#line 3316 "game.c"
	}
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp39_) {
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = TRUE;
#line 3322 "game.c"
	} else {
		GeeLinkedList* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = self->priv->_to_show;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp46_);
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = _tmp47_;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp48_ > 0;
#line 3335 "game.c"
	}
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	has_moved = _tmp38_;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = has_moved;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp49_) {
#line 3343 "game.c"
		ClutterTransitionGroup* _tmp50_ = NULL;
#line 471 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_MOVING_LEFT;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = self->priv->_move_trans;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp50_);
#line 3351 "game.c"
	}
}


static void _game_show_tile (Game* self, GridPosition* pos) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	ClutterPropertyTransition* trans = NULL;
	TileView* view = NULL;
	TileView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	GridPosition _tmp7_ = {0};
	guint _tmp8_ = 0U;
	TileView* _tmp9_ = NULL;
	TileView* _tmp10_ = NULL;
	ClutterCanvas* _tmp11_ = NULL;
	ClutterCanvas* _tmp12_ = NULL;
	ClutterActor* _tmp13_ = NULL;
	ClutterActor* _tmp14_ = NULL;
	ClutterActor* _tmp15_ = NULL;
	ClutterActor* _tmp16_ = NULL;
	ClutterActor* _tmp17_ = NULL;
	ClutterActor* _tmp18_ = NULL;
	ClutterActor* _tmp19_ = NULL;
	ClutterPropertyTransition* _tmp20_ = NULL;
	ClutterPropertyTransition* _tmp21_ = NULL;
	GValue _tmp22_ = {0};
	ClutterPropertyTransition* _tmp23_ = NULL;
	GValue _tmp24_ = {0};
	ClutterPropertyTransition* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	ClutterPropertyTransition* _tmp27_ = NULL;
	ClutterActor* _tmp28_ = NULL;
	ClutterActor* _tmp29_ = NULL;
	ClutterTransitionGroup* _tmp30_ = NULL;
	ClutterPropertyTransition* _tmp31_ = NULL;
	ClutterPropertyTransition* _tmp32_ = NULL;
	ClutterPropertyTransition* _tmp33_ = NULL;
	GValue _tmp34_ = {0};
	ClutterPropertyTransition* _tmp35_ = NULL;
	GValue _tmp36_ = {0};
	ClutterPropertyTransition* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	ClutterPropertyTransition* _tmp39_ = NULL;
	ClutterActor* _tmp40_ = NULL;
	ClutterActor* _tmp41_ = NULL;
	ClutterTransitionGroup* _tmp42_ = NULL;
	ClutterPropertyTransition* _tmp43_ = NULL;
	ClutterPropertyTransition* _tmp44_ = NULL;
	ClutterPropertyTransition* _tmp45_ = NULL;
	GValue _tmp46_ = {0};
	ClutterPropertyTransition* _tmp47_ = NULL;
	GValue _tmp48_ = {0};
	ClutterPropertyTransition* _tmp49_ = NULL;
	ClutterPropertyTransition* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	ClutterActor* _tmp52_ = NULL;
	ClutterActor* _tmp53_ = NULL;
	ClutterPropertyTransition* _tmp54_ = NULL;
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (pos != NULL);
#line 478 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (pos);
#line 478 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 478 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = g_strconcat ("show tile pos ", _tmp1_, NULL);
#line 478 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 478 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:478: %s", _tmp3_);
#line 478 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 478 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_foreground_nxt;
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length1 = self->priv->_foreground_nxt_length1;
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length2 = self->priv->_foreground_nxt_length2;
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = *pos;
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_.row;
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = *pos;
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _tmp7_.col;
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp4_[(_tmp6_ * _tmp4__length2) + _tmp8_];
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 483 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	view = _tmp10_;
#line 484 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = rounded_rectangle_get_canvas ((RoundedRectangle*) view);
#line 484 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_;
#line 484 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_content_invalidate ((ClutterContent*) _tmp12_);
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = _tmp13_;
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_set_opacity (_tmp14_, (guint8) 0);
#line 486 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 486 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = _tmp15_;
#line 486 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_show (_tmp16_);
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = self->priv->_view;
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _tmp18_;
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_add_child (_tmp17_, _tmp19_);
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-x");
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp20_;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = trans;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp22_, G_TYPE_DOUBLE);
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp22_, 1.0);
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp21_, &_tmp22_);
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp22_) ? (g_value_unset (&_tmp22_), NULL) : NULL;
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = trans;
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp24_, G_TYPE_DOUBLE);
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp24_, 1.1);
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp23_, &_tmp24_);
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp24_) ? (g_value_unset (&_tmp24_), NULL) : NULL;
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = trans;
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = self->priv->_animations_duration;
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp25_, (guint) _tmp26_);
#line 493 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = trans;
#line 493 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 493 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp29_ = _tmp28_;
#line 493 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) _tmp27_, (ClutterAnimatable*) _tmp29_);
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = self->priv->_show_hide_trans;
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = trans;
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp30_, (ClutterTransition*) _tmp31_);
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-y");
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp32_;
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp33_ = trans;
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp34_, G_TYPE_DOUBLE);
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp34_, 1.0);
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp33_, &_tmp34_);
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp34_) ? (g_value_unset (&_tmp34_), NULL) : NULL;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp35_ = trans;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp36_, G_TYPE_DOUBLE);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_double (&_tmp36_, 1.1);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp35_, &_tmp36_);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp36_) ? (g_value_unset (&_tmp36_), NULL) : NULL;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp37_ = trans;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp38_ = self->priv->_animations_duration;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp37_, (guint) _tmp38_);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp39_ = trans;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = _tmp40_;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) _tmp39_, (ClutterAnimatable*) _tmp41_);
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = self->priv->_show_hide_trans;
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp43_ = trans;
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp42_, (ClutterTransition*) _tmp43_);
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp44_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp44_;
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp45_ = trans;
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp46_, G_TYPE_INT);
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_int (&_tmp46_, 0);
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp45_, &_tmp46_);
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp46_) ? (g_value_unset (&_tmp46_), NULL) : NULL;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp47_ = trans;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp48_, G_TYPE_INT);
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_int (&_tmp48_, 255);
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp47_, &_tmp48_);
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp48_) ? (g_value_unset (&_tmp48_), NULL) : NULL;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp49_ = trans;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp49_, TRUE);
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp50_ = trans;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp51_ = self->priv->_animations_duration;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp50_, (guint) (_tmp51_ / 2));
#line 508 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp52_ = rounded_rectangle_get_actor ((RoundedRectangle*) view);
#line 508 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp53_ = _tmp52_;
#line 508 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp54_ = trans;
#line 508 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_actor_add_transition (_tmp53_, "show", (ClutterTransition*) _tmp54_);
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (view);
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 3622 "game.c"
}


static void _game_move_tile (Game* self, GridPosition* from, GridPosition* to) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GridPosition _tmp6_ = {0};
	GridPosition _tmp7_ = {0};
	TileView** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	GridPosition _tmp9_ = {0};
	guint _tmp10_ = 0U;
	GridPosition _tmp11_ = {0};
	guint _tmp12_ = 0U;
	TileView** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	GridPosition _tmp14_ = {0};
	guint _tmp15_ = 0U;
	GridPosition _tmp16_ = {0};
	guint _tmp17_ = 0U;
	TileView* _tmp18_ = NULL;
	TileView* _tmp19_ = NULL;
	TileView* _tmp20_ = NULL;
	TileView** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp21__length2 = 0;
	GridPosition _tmp22_ = {0};
	guint _tmp23_ = 0U;
	GridPosition _tmp24_ = {0};
	guint _tmp25_ = 0U;
	TileView* _tmp26_ = NULL;
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (from != NULL);
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (to != NULL);
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (from);
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid_position_to_string (to);
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = g_strconcat ("move tile from ", _tmp1_, " to ", _tmp3_, NULL);
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:513: %s", _tmp5_);
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp5_);
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = *from;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = *to;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_prepare_move_tile (self, &_tmp6_, &_tmp7_);
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = self->priv->_foreground_nxt;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8__length1 = self->priv->_foreground_nxt_length1;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8__length2 = self->priv->_foreground_nxt_length2;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = *to;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = _tmp9_.row;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = *to;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_.col;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_foreground_cur;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length1 = self->priv->_foreground_cur_length1;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length2 = self->priv->_foreground_cur_length2;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = *from;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = _tmp14_.row;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = *from;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = _tmp16_.col;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (_tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_]);
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_] = _tmp19_;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = _tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_];
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = self->priv->_foreground_cur;
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21__length1 = self->priv->_foreground_cur_length1;
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21__length2 = self->priv->_foreground_cur_length2;
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = *from;
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = _tmp22_.row;
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = *from;
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = _tmp24_.col;
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (_tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_]);
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_] = NULL;
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = _tmp21_[(_tmp23_ * _tmp21__length2) + _tmp25_];
#line 3750 "game.c"
}


static void _game_prepare_move_tile (Game* self, GridPosition* from, GridPosition* to) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean row_move = FALSE;
	gchar* trans_name = NULL;
	ClutterPropertyTransition* trans = NULL;
	RoundedRectangle* rect_from = NULL;
	RoundedRectangle* rect_to = NULL;
	GridPosition _tmp6_ = {0};
	guint _tmp7_ = 0U;
	GridPosition _tmp8_ = {0};
	guint _tmp9_ = 0U;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gchar* _tmp12_ = NULL;
	RoundedRectangle** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	GridPosition _tmp14_ = {0};
	guint _tmp15_ = 0U;
	GridPosition _tmp16_ = {0};
	guint _tmp17_ = 0U;
	RoundedRectangle* _tmp18_ = NULL;
	RoundedRectangle* _tmp19_ = NULL;
	RoundedRectangle** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp20__length2 = 0;
	GridPosition _tmp21_ = {0};
	guint _tmp22_ = 0U;
	GridPosition _tmp23_ = {0};
	guint _tmp24_ = 0U;
	RoundedRectangle* _tmp25_ = NULL;
	RoundedRectangle* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	ClutterPropertyTransition* _tmp28_ = NULL;
	gfloat _tmp29_ = 0.0F;
	gboolean _tmp30_ = FALSE;
	ClutterPropertyTransition* _tmp41_ = NULL;
	GValue _tmp42_ = {0};
	gfloat _tmp43_ = 0.0F;
	gboolean _tmp44_ = FALSE;
	ClutterPropertyTransition* _tmp55_ = NULL;
	GValue _tmp56_ = {0};
	ClutterPropertyTransition* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	ClutterPropertyTransition* _tmp59_ = NULL;
	TileView** _tmp60_ = NULL;
	gint _tmp60__length1 = 0;
	gint _tmp60__length2 = 0;
	GridPosition _tmp61_ = {0};
	guint _tmp62_ = 0U;
	GridPosition _tmp63_ = {0};
	guint _tmp64_ = 0U;
	TileView* _tmp65_ = NULL;
	ClutterActor* _tmp66_ = NULL;
	ClutterActor* _tmp67_ = NULL;
	ClutterTransitionGroup* _tmp68_ = NULL;
	ClutterPropertyTransition* _tmp69_ = NULL;
#line 521 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 521 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (from != NULL);
#line 521 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (to != NULL);
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (from);
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = grid_position_to_string (to);
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = g_strconcat ("prepare move tile from ", _tmp1_, " to ", _tmp3_, NULL);
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:523: %s", _tmp5_);
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp5_);
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = *from;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp6_.col;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = *to;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp8_.col;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	row_move = _tmp7_ == _tmp9_;
#line 532 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = row_move;
#line 532 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp11_) {
#line 532 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = "y";
#line 3858 "game.c"
	} else {
#line 532 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = "x";
#line 3862 "game.c"
	}
#line 532 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_strdup (_tmp10_);
#line 532 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (trans_name);
#line 532 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans_name = _tmp12_;
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_background;
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length1 = self->priv->_background_length1;
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13__length2 = self->priv->_background_length2;
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = *from;
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = _tmp14_.row;
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = *from;
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = _tmp16_.col;
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_from);
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rect_from = _tmp19_;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = self->priv->_background;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20__length1 = self->priv->_background_length1;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20__length2 = self->priv->_background_length2;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = *to;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = _tmp21_.row;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = *to;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = _tmp23_.col;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = _tmp20_[(_tmp22_ * _tmp20__length2) + _tmp24_];
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = _g_object_ref0 (_tmp25_);
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_to);
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rect_to = _tmp26_;
#line 537 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = trans_name;
#line 537 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp28_ = (ClutterPropertyTransition*) clutter_property_transition_new (_tmp27_);
#line 537 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 537 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp28_;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = row_move;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp30_) {
#line 3926 "game.c"
		RoundedRectangle* _tmp31_ = NULL;
		ClutterActor* _tmp32_ = NULL;
		ClutterActor* _tmp33_ = NULL;
		gfloat _tmp34_ = 0.0F;
		gfloat _tmp35_ = 0.0F;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp31_ = rect_from;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp32_ = rounded_rectangle_get_actor (_tmp31_);
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp33_ = _tmp32_;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp34_ = clutter_actor_get_y (_tmp33_);
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp35_ = _tmp34_;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp29_ = _tmp35_;
#line 3944 "game.c"
	} else {
		RoundedRectangle* _tmp36_ = NULL;
		ClutterActor* _tmp37_ = NULL;
		ClutterActor* _tmp38_ = NULL;
		gfloat _tmp39_ = 0.0F;
		gfloat _tmp40_ = 0.0F;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp36_ = rect_from;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp37_ = rounded_rectangle_get_actor (_tmp36_);
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp38_ = _tmp37_;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = clutter_actor_get_x (_tmp38_);
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp40_ = _tmp39_;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp29_ = _tmp40_;
#line 3963 "game.c"
	}
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = trans;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp42_, G_TYPE_FLOAT);
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_float (&_tmp42_, _tmp29_);
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) _tmp41_, &_tmp42_);
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp42_) ? (g_value_unset (&_tmp42_), NULL) : NULL;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp44_ = row_move;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp44_) {
#line 3979 "game.c"
		RoundedRectangle* _tmp45_ = NULL;
		ClutterActor* _tmp46_ = NULL;
		ClutterActor* _tmp47_ = NULL;
		gfloat _tmp48_ = 0.0F;
		gfloat _tmp49_ = 0.0F;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp45_ = rect_to;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp46_ = rounded_rectangle_get_actor (_tmp45_);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp47_ = _tmp46_;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp48_ = clutter_actor_get_y (_tmp47_);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp49_ = _tmp48_;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = _tmp49_;
#line 3997 "game.c"
	} else {
		RoundedRectangle* _tmp50_ = NULL;
		ClutterActor* _tmp51_ = NULL;
		ClutterActor* _tmp52_ = NULL;
		gfloat _tmp53_ = 0.0F;
		gfloat _tmp54_ = 0.0F;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp50_ = rect_to;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp51_ = rounded_rectangle_get_actor (_tmp50_);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp52_ = _tmp51_;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp53_ = clutter_actor_get_x (_tmp52_);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp54_ = _tmp53_;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = _tmp54_;
#line 4016 "game.c"
	}
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp55_ = trans;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp56_, G_TYPE_FLOAT);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_float (&_tmp56_, _tmp43_);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) _tmp55_, &_tmp56_);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp56_) ? (g_value_unset (&_tmp56_), NULL) : NULL;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp57_ = trans;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp58_ = self->priv->_animations_duration;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp57_, (guint) _tmp58_);
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp59_ = trans;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp60_ = self->priv->_foreground_cur;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp60__length1 = self->priv->_foreground_cur_length1;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp60__length2 = self->priv->_foreground_cur_length2;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp61_ = *from;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp62_ = _tmp61_.row;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp63_ = *from;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp64_ = _tmp63_.col;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp65_ = _tmp60_[(_tmp62_ * _tmp60__length2) + _tmp64_];
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp66_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp65_);
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp67_ = _tmp66_;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) _tmp59_, (ClutterAnimatable*) _tmp67_);
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp68_ = self->priv->_move_trans;
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp69_ = trans;
#line 542 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp68_, (ClutterTransition*) _tmp69_);
#line 521 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_to);
#line 521 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (rect_from);
#line 521 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 521 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (trans_name);
#line 4072 "game.c"
}


static void _game_dim_tile (Game* self, GridPosition* pos) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	TileView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	GridPosition _tmp5_ = {0};
	guint _tmp6_ = 0U;
	GridPosition _tmp7_ = {0};
	guint _tmp8_ = 0U;
	TileView* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	ClutterActor* actor = NULL;
	ClutterPropertyTransition* trans = NULL;
	TileView** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	GridPosition _tmp17_ = {0};
	guint _tmp18_ = 0U;
	GridPosition _tmp19_ = {0};
	guint _tmp20_ = 0U;
	TileView* _tmp21_ = NULL;
	ClutterActor* _tmp22_ = NULL;
	ClutterActor* _tmp23_ = NULL;
	ClutterActor* _tmp24_ = NULL;
	ClutterPropertyTransition* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	GValue _tmp28_ = {0};
	GValue _tmp29_ = {0};
	gint _tmp30_ = 0;
	ClutterTransitionGroup* _tmp31_ = NULL;
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (pos != NULL);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = grid_position_to_string (pos);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _tmp0_;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = g_strconcat ("diming tile at ", _tmp1_, " ", NULL);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = _tmp2_;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = self->priv->_foreground_cur;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length1 = self->priv->_foreground_cur_length1;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4__length2 = self->priv->_foreground_cur_length2;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = *pos;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = _tmp5_.row;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = *pos;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = _tmp7_.col;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp9_ = _tmp4_[(_tmp6_ * _tmp4__length2) + _tmp8_];
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = tile_view_get_value (_tmp9_);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = _tmp10_;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = g_strdup_printf ("%u", _tmp11_);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = _tmp12_;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp14_ = g_strconcat (_tmp3_, _tmp13_, NULL);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp15_ = _tmp14_;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:547: %s", _tmp15_);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp15_);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp13_);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp3_);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp1_);
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16_ = self->priv->_foreground_cur;
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16__length1 = self->priv->_foreground_cur_length1;
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp16__length2 = self->priv->_foreground_cur_length2;
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp17_ = *pos;
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp18_ = _tmp17_.row;
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp19_ = *pos;
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp20_ = _tmp19_.col;
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp21_ = _tmp16_[(_tmp18_ * _tmp16__length2) + _tmp20_];
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp22_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp21_);
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp23_ = _tmp22_;
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp24_ = _g_object_ref0 (_tmp23_);
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (actor);
#line 552 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	actor = _tmp24_;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp25_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	trans = _tmp25_;
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp26_ = clutter_actor_get_opacity (actor);
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp27_ = _tmp26_;
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp28_, G_TYPE_UINT);
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_uint (&_tmp28_, _tmp27_);
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_from_value ((ClutterTransition*) trans, &_tmp28_);
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp28_) ? (g_value_unset (&_tmp28_), NULL) : NULL;
#line 556 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_init (&_tmp29_, G_TYPE_INT);
#line 556 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_value_set_int (&_tmp29_, 0);
#line 556 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_to_value ((ClutterTransition*) trans, &_tmp29_);
#line 556 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_IS_VALUE (&_tmp29_) ? (g_value_unset (&_tmp29_), NULL) : NULL;
#line 557 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = self->priv->_animations_duration;
#line 557 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) trans, (guint) _tmp30_);
#line 558 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_set_animatable ((ClutterTransition*) trans, (ClutterAnimatable*) actor);
#line 560 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = self->priv->_show_hide_trans;
#line 560 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_add_transition (_tmp31_, (ClutterTransition*) trans);
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (trans);
#line 545 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (actor);
#line 4231 "game.c"
}


static void _game_clear_background (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 563 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 565 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 565 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 565 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 565 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 566 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 566 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 566 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 566 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 4262 "game.c"
	{
		gint i = 0;
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 4267 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = TRUE;
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 4274 "game.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp6_) {
#line 4279 "game.c"
					gint _tmp7_ = 0;
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp7_ = i;
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp7_ + 1;
#line 4285 "game.c"
				}
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp6_ = FALSE;
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp8_ = i;
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = rows;
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 4297 "game.c"
				}
				{
					gint j = 0;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 4303 "game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp10_ = TRUE;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 4310 "game.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							RoundedRectangle* rect = NULL;
							RoundedRectangle** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							RoundedRectangle* _tmp17_ = NULL;
							RoundedRectangle* _tmp18_ = NULL;
							RoundedRectangle* _tmp19_ = NULL;
							ClutterActor* _tmp20_ = NULL;
							ClutterActor* _tmp21_ = NULL;
							ClutterActor* _tmp22_ = NULL;
							RoundedRectangle* _tmp23_ = NULL;
							ClutterActor* _tmp24_ = NULL;
							ClutterActor* _tmp25_ = NULL;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp10_) {
#line 4330 "game.c"
								gint _tmp11_ = 0;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp11_ = j;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp11_ + 1;
#line 4336 "game.c"
							}
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp10_ = FALSE;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp12_ = j;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = cols;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 4348 "game.c"
							}
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = self->priv->_background;
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length1 = self->priv->_background_length1;
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length2 = self->priv->_background_length2;
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = i;
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = j;
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18_ = _g_object_ref0 (_tmp17_);
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							rect = _tmp18_;
#line 571 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp19_ = rect;
#line 571 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp20_ = rounded_rectangle_get_actor (_tmp19_);
#line 571 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp21_ = _tmp20_;
#line 571 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_hide (_tmp21_);
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp22_ = self->priv->_view;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp23_ = rect;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp24_ = rounded_rectangle_get_actor (_tmp23_);
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp25_ = _tmp24_;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							clutter_actor_remove_child (_tmp22_, _tmp25_);
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_g_object_unref0 (rect);
#line 4386 "game.c"
						}
					}
				}
			}
		}
	}
}


static void _game_clear_foreground (Game* self) {
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 579 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 579 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 579 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 579 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 580 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 580 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 580 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 580 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 4423 "game.c"
	{
		gint i = 0;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 4428 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = TRUE;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 4435 "game.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp6_) {
#line 4440 "game.c"
					gint _tmp7_ = 0;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp7_ = i;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp7_ + 1;
#line 4446 "game.c"
				}
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp6_ = FALSE;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp8_ = i;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = rows;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 4458 "game.c"
				}
				{
					gint j = 0;
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 4464 "game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp10_ = TRUE;
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 4471 "game.c"
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							TileView** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							TileView* _tmp17_ = NULL;
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp10_) {
#line 4482 "game.c"
								gint _tmp11_ = 0;
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp11_ = j;
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp11_ + 1;
#line 4488 "game.c"
							}
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp10_ = FALSE;
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp12_ = j;
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = cols;
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp12_ < _tmp13_)) {
#line 583 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 4500 "game.c"
							}
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = self->priv->_foreground_cur;
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length1 = self->priv->_foreground_cur_length1;
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14__length2 = self->priv->_foreground_cur_length2;
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = i;
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = j;
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp17_ != NULL) {
#line 4516 "game.c"
								TileView* tile = NULL;
								TileView** _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								gint _tmp18__length2 = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								TileView* _tmp21_ = NULL;
								TileView* _tmp22_ = NULL;
								TileView* _tmp23_ = NULL;
								ClutterActor* _tmp24_ = NULL;
								ClutterActor* _tmp25_ = NULL;
								ClutterActor* _tmp26_ = NULL;
								TileView* _tmp27_ = NULL;
								ClutterActor* _tmp28_ = NULL;
								ClutterActor* _tmp29_ = NULL;
								TileView** _tmp30_ = NULL;
								gint _tmp30__length1 = 0;
								gint _tmp30__length2 = 0;
								gint _tmp31_ = 0;
								gint _tmp32_ = 0;
								TileView* _tmp33_ = NULL;
								TileView** _tmp34_ = NULL;
								gint _tmp34__length1 = 0;
								gint _tmp34__length2 = 0;
								gint _tmp35_ = 0;
								gint _tmp36_ = 0;
								TileView* _tmp37_ = NULL;
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp18_ = self->priv->_foreground_cur;
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp18__length1 = self->priv->_foreground_cur_length1;
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp18__length2 = self->priv->_foreground_cur_length2;
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp19_ = i;
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp20_ = j;
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_ = _g_object_ref0 (_tmp21_);
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								tile = _tmp22_;
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp23_ = tile;
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp24_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp23_);
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_ = _tmp24_;
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								clutter_actor_hide (_tmp25_);
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp26_ = self->priv->_view;
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp27_ = tile;
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp28_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp27_);
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp29_ = _tmp28_;
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								clutter_actor_remove_child (_tmp26_, _tmp29_);
#line 588 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30_ = self->priv->_foreground_cur;
#line 588 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30__length1 = self->priv->_foreground_cur_length1;
#line 588 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30__length2 = self->priv->_foreground_cur_length2;
#line 588 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp31_ = i;
#line 588 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp32_ = j;
#line 588 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_g_object_unref0 (_tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_]);
#line 588 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_] = NULL;
#line 588 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp33_ = _tmp30_[(_tmp31_ * _tmp30__length2) + _tmp32_];
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34_ = self->priv->_foreground_nxt;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34__length1 = self->priv->_foreground_nxt_length1;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34__length2 = self->priv->_foreground_nxt_length2;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp35_ = i;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp36_ = j;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_g_object_unref0 (_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_]);
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_] = NULL;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp37_ = _tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_];
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_g_object_unref0 (tile);
#line 4612 "game.c"
							}
						}
					}
				}
			}
		}
	}
}


static void _game_restore_foreground (Game* self, gboolean animate) {
	guint val = 0U;
	GridPosition pos = {0};
	Tile tile = {0};
	gint rows = 0;
	Grid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint cols = 0;
	Grid* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	GeeLinkedList* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 600 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_grid;
#line 600 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = grid_get_rows (_tmp0_);
#line 600 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 600 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	rows = _tmp2_;
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = self->priv->_grid;
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = grid_get_cols (_tmp3_);
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = _tmp4_;
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	cols = _tmp5_;
#line 603 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = animate;
#line 603 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_show_hide_transition (self, _tmp6_);
#line 4661 "game.c"
	{
		gint i = 0;
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		i = 0;
#line 4666 "game.c"
		{
			gboolean _tmp7_ = FALSE;
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp7_ = TRUE;
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			while (TRUE) {
#line 4673 "game.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!_tmp7_) {
#line 4678 "game.c"
					gint _tmp8_ = 0;
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					_tmp8_ = i;
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					i = _tmp8_ + 1;
#line 4684 "game.c"
				}
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp7_ = FALSE;
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp9_ = i;
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				_tmp10_ = rows;
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				if (!(_tmp9_ < _tmp10_)) {
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					break;
#line 4696 "game.c"
				}
				{
					gint j = 0;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
					j = 0;
#line 4702 "game.c"
					{
						gboolean _tmp11_ = FALSE;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						_tmp11_ = TRUE;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
						while (TRUE) {
#line 4709 "game.c"
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							Grid* _tmp15_ = NULL;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							guint _tmp18_ = 0U;
							guint _tmp19_ = 0U;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!_tmp11_) {
#line 4719 "game.c"
								gint _tmp12_ = 0;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp12_ = j;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								j = _tmp12_ + 1;
#line 4725 "game.c"
							}
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp11_ = FALSE;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp13_ = j;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp14_ = cols;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (!(_tmp13_ < _tmp14_)) {
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								break;
#line 4737 "game.c"
							}
#line 607 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp15_ = self->priv->_grid;
#line 607 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp16_ = i;
#line 607 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp17_ = j;
#line 607 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp18_ = grid_get (_tmp15_, _tmp16_, _tmp17_);
#line 607 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							val = _tmp18_;
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							_tmp19_ = val;
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
							if (_tmp19_ != ((guint) 0)) {
#line 4753 "game.c"
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								GridPosition _tmp22_ = {0};
								GridPosition _tmp23_ = {0};
								guint _tmp24_ = 0U;
								Tile _tmp25_ = {0};
								Tile _tmp26_ = {0};
								GeeLinkedList* _tmp27_ = NULL;
								Tile _tmp28_ = {0};
								GridPosition _tmp29_ = {0};
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp20_ = i;
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp21_ = j;
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_.row = (guint) _tmp20_;
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp22_.col = (guint) _tmp21_;
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								pos = _tmp22_;
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp23_ = pos;
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp24_ = val;
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_.pos = _tmp23_;
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp25_.val = _tmp24_;
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								tile = _tmp25_;
#line 611 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp26_ = tile;
#line 611 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_game_create_tile (self, &_tmp26_);
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp27_ = self->priv->_to_show;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp28_ = tile;
#line 612 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, &_tmp28_);
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_tmp29_ = pos;
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
								_game_show_tile (self, &_tmp29_);
#line 4798 "game.c"
							}
						}
					}
				}
			}
		}
	}
#line 618 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp30_ = self->priv->_to_show;
#line 618 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp31_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp30_);
#line 618 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp32_ = _tmp31_;
#line 618 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp32_ > 0) {
#line 4814 "game.c"
		ClutterTransitionGroup* _tmp33_ = NULL;
#line 619 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_RESTORING_TILES;
#line 620 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp33_ = self->priv->_show_hide_trans;
#line 620 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp33_);
#line 4822 "game.c"
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
#line 37 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (self) {
#line 4831 "game.c"
		gchar* _tmp0_ = NULL;
#line 38 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp0_;
#line 38 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 4839 "game.c"
	} else {
		gchar* _tmp1_ = NULL;
#line 40 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp1_;
#line 40 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 4848 "game.c"
	}
}


static void _game_on_move_trans_stopped (Game* self, gboolean is_finished) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Grid* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint delta_score = 0U;
	ClutterTransitionGroup* _tmp8_ = NULL;
	guint _tmp40_ = 0U;
	guint _tmp41_ = 0U;
	ClutterTransitionGroup* _tmp42_ = NULL;
#line 624 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = is_finished;
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = bool_to_string (_tmp0_);
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_strconcat ("move animation stopped; finished ", _tmp2_, NULL);
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_;
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:626: %s", _tmp4_);
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp4_);
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp2_);
#line 627 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_grid;
#line 627 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = grid_to_string (_tmp5_);
#line 627 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp6_;
#line 627 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:627: %s", _tmp7_);
#line 627 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp7_);
#line 631 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp8_ = self->priv->_move_trans;
#line 631 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_remove_all (_tmp8_);
#line 633 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_show_hide_transition (self, TRUE);
#line 4901 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		GeeLinkedList* _tmp10_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _e_index = 0;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = self->priv->_to_hide;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp10_;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = _e_list;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp13_ = _tmp12_;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp13_;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 4929 "game.c"
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gpointer _tmp19_ = NULL;
			TileMovement* _tmp20_ = NULL;
			GridPosition _tmp21_ = {0};
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = _e_index;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp14_ + 1;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = _e_index;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = _e_size;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp15_ < _tmp16_)) {
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 4951 "game.c"
			}
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _e_list;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = _e_index;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp19_;
#line 636 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = e;
#line 636 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = (*_tmp20_).from;
#line 636 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_dim_tile (self, &_tmp21_);
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 4969 "game.c"
		}
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 4973 "game.c"
	}
#line 639 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	delta_score = (guint) 0;
#line 4977 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp22_ = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _e_index = 0;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp22_ = self->priv->_to_show;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp23_ = _g_object_ref0 (_tmp22_);
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp23_;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp24_ = _e_list;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp26_ = _tmp25_;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp26_;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5005 "game.c"
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			Tile* e = NULL;
			GeeLinkedList* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gpointer _tmp32_ = NULL;
			Tile* _tmp33_ = NULL;
			Tile _tmp34_ = {0};
			Tile* _tmp35_ = NULL;
			GridPosition _tmp36_ = {0};
			guint _tmp37_ = 0U;
			Tile* _tmp38_ = NULL;
			guint _tmp39_ = 0U;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp27_ = _e_index;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp27_ + 1;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _e_index;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _e_size;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp28_ < _tmp29_)) {
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5032 "game.c"
			}
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _e_list;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _e_index;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (Tile*) _tmp32_;
#line 641 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = e;
#line 641 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = *_tmp33_;
#line 641 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_create_tile (self, &_tmp34_);
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = e;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = (*_tmp35_).pos;
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_game_show_tile (self, &_tmp36_);
#line 643 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = delta_score;
#line 643 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp38_ = e;
#line 643 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp39_ = (*_tmp38_).val;
#line 643 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			delta_score = _tmp37_ + _tmp39_;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_free0 (e);
#line 5064 "game.c"
		}
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5068 "game.c"
	}
#line 645 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp40_ = self->priv->_score;
#line 645 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp41_ = delta_score;
#line 645 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_set_score (self, _tmp40_ + _tmp41_);
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_create_random_tile (self);
#line 649 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp42_ = self->priv->_show_hide_trans;
#line 649 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_start ((ClutterTimeline*) _tmp42_);
#line 5082 "game.c"
}


static gboolean __game_finish_move_gsource_func (gpointer self) {
	gboolean result;
	result = _game_finish_move ((Game*) self);
#line 675 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 5091 "game.c"
}


static void _game_on_show_hide_trans_stopped (Game* self, gboolean is_finished) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	ClutterTransitionGroup* _tmp5_ = NULL;
	ClutterTimelineDirection _tmp6_ = 0;
	ClutterTimelineDirection _tmp7_ = 0;
	Grid* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	ClutterTransitionGroup* _tmp13_ = NULL;
#line 652 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = is_finished;
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = bool_to_string (_tmp0_);
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = _tmp1_;
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = g_strconcat ("show/hide animation stopped; finished ", _tmp2_, NULL);
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp4_ = _tmp3_;
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:654: %s", _tmp4_);
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp4_);
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp2_);
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_show_hide_trans;
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp6_ = clutter_timeline_get_direction ((ClutterTimeline*) _tmp5_);
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp7_ = _tmp6_;
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp7_ == CLUTTER_TIMELINE_FORWARD) {
#line 5134 "game.c"
		ClutterTransitionGroup* _tmp8_ = NULL;
		ClutterTransitionGroup* _tmp9_ = NULL;
#line 657 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_show_hide_trans;
#line 657 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_set_direction ((ClutterTimeline*) _tmp8_, CLUTTER_TIMELINE_BACKWARD);
#line 658 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = self->priv->_show_hide_trans;
#line 658 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		clutter_timeline_start ((ClutterTimeline*) _tmp9_);
#line 659 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		return;
#line 5147 "game.c"
	}
#line 662 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp10_ = self->priv->_grid;
#line 662 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp11_ = grid_to_string (_tmp10_);
#line 662 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp12_ = _tmp11_;
#line 662 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_debug ("game.vala:662: %s", _tmp12_);
#line 662 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (_tmp12_);
#line 664 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp13_ = self->priv->_show_hide_trans;
#line 664 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_transition_group_remove_all (_tmp13_);
#line 5163 "game.c"
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp14_ = NULL;
		GeeLinkedList* _tmp15_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _e_index = 0;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp14_ = self->priv->_to_hide;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp15_;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp16_ = _e_list;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp17_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp16_);
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp18_ = _tmp17_;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp18_;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5191 "game.c"
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gpointer _tmp24_ = NULL;
			TileView* view = NULL;
			TileView** _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			gint _tmp25__length2 = 0;
			TileMovement* _tmp26_ = NULL;
			GridPosition _tmp27_ = {0};
			guint _tmp28_ = 0U;
			TileMovement* _tmp29_ = NULL;
			GridPosition _tmp30_ = {0};
			guint _tmp31_ = 0U;
			TileView* _tmp32_ = NULL;
			TileView* _tmp33_ = NULL;
			TileView* _tmp34_ = NULL;
			ClutterActor* _tmp35_ = NULL;
			ClutterActor* _tmp36_ = NULL;
			TileView** _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			gint _tmp37__length2 = 0;
			TileMovement* _tmp38_ = NULL;
			GridPosition _tmp39_ = {0};
			guint _tmp40_ = 0U;
			TileMovement* _tmp41_ = NULL;
			GridPosition _tmp42_ = {0};
			guint _tmp43_ = 0U;
			TileView* _tmp44_ = NULL;
			guint _tmp45_ = 0U;
			guint _tmp46_ = 0U;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			ClutterActor* _tmp51_ = NULL;
			TileView* _tmp52_ = NULL;
			ClutterActor* _tmp53_ = NULL;
			ClutterActor* _tmp54_ = NULL;
			TileView** _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			gint _tmp55__length2 = 0;
			TileMovement* _tmp56_ = NULL;
			GridPosition _tmp57_ = {0};
			guint _tmp58_ = 0U;
			TileMovement* _tmp59_ = NULL;
			GridPosition _tmp60_ = {0};
			guint _tmp61_ = 0U;
			TileView* _tmp62_ = NULL;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = _e_index;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp19_ + 1;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = _e_index;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = _e_size;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp20_ < _tmp21_)) {
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5256 "game.c"
			}
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = _e_list;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp23_ = _e_index;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _tmp23_);
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp24_;
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25_ = self->priv->_foreground_cur;
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25__length1 = self->priv->_foreground_cur_length1;
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25__length2 = self->priv->_foreground_cur_length2;
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp26_ = e;
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp27_ = (*_tmp26_).from;
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _tmp27_.row;
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = e;
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = (*_tmp29_).from;
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = _tmp30_.col;
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = _tmp25_[(_tmp28_ * _tmp25__length2) + _tmp31_];
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = _g_object_ref0 (_tmp32_);
#line 667 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			view = _tmp33_;
#line 668 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = view;
#line 668 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp34_);
#line 668 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = _tmp35_;
#line 668 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			clutter_actor_hide (_tmp36_);
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = self->priv->_foreground_cur;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37__length1 = self->priv->_foreground_cur_length1;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37__length2 = self->priv->_foreground_cur_length2;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp38_ = e;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp39_ = (*_tmp38_).from;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp40_ = _tmp39_.row;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp41_ = e;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp42_ = (*_tmp41_).from;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp43_ = _tmp42_.col;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp44_ = _tmp37_[(_tmp40_ * _tmp37__length2) + _tmp43_];
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp45_ = tile_view_get_value (_tmp44_);
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp46_ = _tmp45_;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp47_ = g_strdup_printf ("%u", _tmp46_);
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp48_ = _tmp47_;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp49_ = g_strconcat ("remove child ", _tmp48_, NULL);
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50_ = _tmp49_;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_debug ("game.vala:669: %s", _tmp50_);
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (_tmp50_);
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_free0 (_tmp48_);
#line 670 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp51_ = self->priv->_view;
#line 670 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp52_ = view;
#line 670 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp53_ = rounded_rectangle_get_actor ((RoundedRectangle*) _tmp52_);
#line 670 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp54_ = _tmp53_;
#line 670 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			clutter_actor_remove_child (_tmp51_, _tmp54_);
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55_ = self->priv->_foreground_cur;
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55__length1 = self->priv->_foreground_cur_length1;
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55__length2 = self->priv->_foreground_cur_length2;
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp56_ = e;
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57_ = (*_tmp56_).from;
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp58_ = _tmp57_.row;
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp59_ = e;
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp60_ = (*_tmp59_).from;
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp61_ = _tmp60_.col;
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_]);
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_] = NULL;
#line 672 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp62_ = _tmp55_[(_tmp58_ * _tmp55__length2) + _tmp61_];
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (view);
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 5374 "game.c"
		}
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5378 "game.c"
	}
#line 675 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, __game_finish_move_gsource_func, g_object_ref (self), g_object_unref);
#line 5382 "game.c"
}


static void __game_on_show_hide_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender, gboolean is_finished, gpointer self) {
#line 681 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_on_show_hide_trans_stopped ((Game*) self, is_finished);
#line 5389 "game.c"
}


static void _game_create_show_hide_transition (Game* self, gboolean animate) {
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterTransitionGroup* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	ClutterTransitionGroup* _tmp5_ = NULL;
#line 678 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 680 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
#line 680 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_show_hide_trans);
#line 680 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_show_hide_trans = _tmp0_;
#line 681 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = self->priv->_show_hide_trans;
#line 681 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_show_hide_trans_stopped_clutter_timeline_stopped, self, 0);
#line 682 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp3_ = animate;
#line 682 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp3_) {
#line 5415 "game.c"
		gint _tmp4_ = 0;
#line 682 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = self->priv->_animations_duration;
#line 682 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = _tmp4_;
#line 5421 "game.c"
	} else {
#line 682 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = 10;
#line 5425 "game.c"
	}
#line 682 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp5_ = self->priv->_show_hide_trans;
#line 682 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp5_, (guint) _tmp2_);
#line 5431 "game.c"
}


static gboolean _game_finish_move (Game* self) {
	gboolean result = FALSE;
	GameGameState _tmp0_ = 0;
	GeeLinkedList* _tmp75_ = NULL;
	GeeLinkedList* _tmp76_ = NULL;
	GeeLinkedList* _tmp77_ = NULL;
	Grid* _tmp78_ = NULL;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	Grid* _tmp85_ = NULL;
	gboolean _tmp86_ = FALSE;
#line 685 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_state;
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_ == GAME_GAME_STATE_SHOWING_FIRST_TILE) {
#line 688 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		self->priv->_state = GAME_GAME_STATE_SHOWING_SECOND_TILE;
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_debug ("game.vala:689: state show second tile");
#line 690 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_game_create_random_tile (self);
#line 5458 "game.c"
	} else {
		GameGameState _tmp1_ = 0;
#line 691 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp1_ = self->priv->_state;
#line 691 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (_tmp1_ == GAME_GAME_STATE_SHOWING_SECOND_TILE) {
#line 692 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			self->priv->_state = GAME_GAME_STATE_IDLE;
#line 693 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_debug ("game.vala:693: state idle");
#line 5469 "game.c"
		} else {
			GameGameState _tmp2_ = 0;
#line 694 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp2_ = self->priv->_state;
#line 694 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (_tmp2_ != GAME_GAME_STATE_IDLE) {
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				self->priv->_state = GAME_GAME_STATE_IDLE;
#line 696 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				g_debug ("game.vala:696: state idle");
#line 5480 "game.c"
			}
		}
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _e_index = 0;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = self->priv->_to_move;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp4_;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp5_ = _e_list;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp7_ = _tmp6_;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp7_;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5511 "game.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			TileView** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			TileMovement* _tmp15_ = NULL;
			GridPosition _tmp16_ = {0};
			guint _tmp17_ = 0U;
			TileMovement* _tmp18_ = NULL;
			GridPosition _tmp19_ = {0};
			guint _tmp20_ = 0U;
			TileView** _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp21__length2 = 0;
			TileMovement* _tmp22_ = NULL;
			GridPosition _tmp23_ = {0};
			guint _tmp24_ = 0U;
			TileMovement* _tmp25_ = NULL;
			GridPosition _tmp26_ = {0};
			guint _tmp27_ = 0U;
			TileView* _tmp28_ = NULL;
			TileView* _tmp29_ = NULL;
			TileView* _tmp30_ = NULL;
			TileView** _tmp31_ = NULL;
			gint _tmp31__length1 = 0;
			gint _tmp31__length2 = 0;
			TileMovement* _tmp32_ = NULL;
			GridPosition _tmp33_ = {0};
			guint _tmp34_ = 0U;
			TileMovement* _tmp35_ = NULL;
			GridPosition _tmp36_ = {0};
			guint _tmp37_ = 0U;
			TileView* _tmp38_ = NULL;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp8_ = _e_index;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp8_ + 1;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp9_ = _e_index;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp10_ = _e_size;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5562 "game.c"
			}
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp11_ = _e_list;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp12_ = _e_index;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (TileMovement*) _tmp13_;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_ = self->priv->_foreground_cur;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14__length1 = self->priv->_foreground_cur_length1;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14__length2 = self->priv->_foreground_cur_length2;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp15_ = e;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp16_ = (*_tmp15_).to;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp17_ = _tmp16_.row;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp18_ = e;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp19_ = (*_tmp18_).to;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp20_ = _tmp19_.col;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21_ = self->priv->_foreground_nxt;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21__length1 = self->priv->_foreground_nxt_length1;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp21__length2 = self->priv->_foreground_nxt_length2;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp22_ = e;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp23_ = (*_tmp22_).to;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp24_ = _tmp23_.row;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp25_ = e;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp26_ = (*_tmp25_).to;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp27_ = _tmp26_.col;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp28_ = _tmp21_[(_tmp24_ * _tmp21__length2) + _tmp27_];
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp29_ = _g_object_ref0 (_tmp28_);
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_]);
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_] = _tmp29_;
#line 700 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp30_ = _tmp14_[(_tmp17_ * _tmp14__length2) + _tmp20_];
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_ = self->priv->_foreground_nxt;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31__length1 = self->priv->_foreground_nxt_length1;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31__length2 = self->priv->_foreground_nxt_length2;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp32_ = e;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp33_ = (*_tmp32_).to;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp34_ = _tmp33_.row;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp35_ = e;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp36_ = (*_tmp35_).to;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp37_ = _tmp36_.col;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_]);
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_] = NULL;
#line 701 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp38_ = _tmp31_[(_tmp34_ * _tmp31__length2) + _tmp37_];
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_movement_free0 (e);
#line 5644 "game.c"
		}
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5648 "game.c"
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp39_ = NULL;
		GeeLinkedList* _tmp40_ = NULL;
		gint _e_size = 0;
		GeeLinkedList* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		gint _e_index = 0;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp39_ = self->priv->_to_show;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp40_ = _g_object_ref0 (_tmp39_);
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_list = _tmp40_;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp41_ = _e_list;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp42_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp41_);
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp43_ = _tmp42_;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_size = _tmp43_;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_e_index = -1;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		while (TRUE) {
#line 5677 "game.c"
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			Tile* e = NULL;
			GeeLinkedList* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gpointer _tmp49_ = NULL;
			TileView** _tmp50_ = NULL;
			gint _tmp50__length1 = 0;
			gint _tmp50__length2 = 0;
			Tile* _tmp51_ = NULL;
			GridPosition _tmp52_ = {0};
			guint _tmp53_ = 0U;
			Tile* _tmp54_ = NULL;
			GridPosition _tmp55_ = {0};
			guint _tmp56_ = 0U;
			TileView** _tmp57_ = NULL;
			gint _tmp57__length1 = 0;
			gint _tmp57__length2 = 0;
			Tile* _tmp58_ = NULL;
			GridPosition _tmp59_ = {0};
			guint _tmp60_ = 0U;
			Tile* _tmp61_ = NULL;
			GridPosition _tmp62_ = {0};
			guint _tmp63_ = 0U;
			TileView* _tmp64_ = NULL;
			TileView* _tmp65_ = NULL;
			TileView* _tmp66_ = NULL;
			TileView** _tmp67_ = NULL;
			gint _tmp67__length1 = 0;
			gint _tmp67__length2 = 0;
			Tile* _tmp68_ = NULL;
			GridPosition _tmp69_ = {0};
			guint _tmp70_ = 0U;
			Tile* _tmp71_ = NULL;
			GridPosition _tmp72_ = {0};
			guint _tmp73_ = 0U;
			TileView* _tmp74_ = NULL;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp44_ = _e_index;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_e_index = _tmp44_ + 1;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp45_ = _e_index;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp46_ = _e_size;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			if (!(_tmp45_ < _tmp46_)) {
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
				break;
#line 5728 "game.c"
			}
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp47_ = _e_list;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp48_ = _e_index;
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			e = (Tile*) _tmp49_;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50_ = self->priv->_foreground_cur;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50__length1 = self->priv->_foreground_cur_length1;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50__length2 = self->priv->_foreground_cur_length2;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp51_ = e;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp52_ = (*_tmp51_).pos;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp53_ = _tmp52_.row;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp54_ = e;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp55_ = (*_tmp54_).pos;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp56_ = _tmp55_.col;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57_ = self->priv->_foreground_nxt;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57__length1 = self->priv->_foreground_nxt_length1;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp57__length2 = self->priv->_foreground_nxt_length2;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp58_ = e;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp59_ = (*_tmp58_).pos;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp60_ = _tmp59_.row;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp61_ = e;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp62_ = (*_tmp61_).pos;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp63_ = _tmp62_.col;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp64_ = _tmp57_[(_tmp60_ * _tmp57__length2) + _tmp63_];
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp65_ = _g_object_ref0 (_tmp64_);
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_]);
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_] = _tmp65_;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp66_ = _tmp50_[(_tmp53_ * _tmp50__length2) + _tmp56_];
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67_ = self->priv->_foreground_nxt;
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67__length1 = self->priv->_foreground_nxt_length1;
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67__length2 = self->priv->_foreground_nxt_length2;
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp68_ = e;
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp69_ = (*_tmp68_).pos;
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp70_ = _tmp69_.row;
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp71_ = e;
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp72_ = (*_tmp71_).pos;
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp73_ = _tmp72_.col;
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_]);
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_] = NULL;
#line 705 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp74_ = _tmp67_[(_tmp70_ * _tmp67__length2) + _tmp73_];
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tile_free0 (e);
#line 5810 "game.c"
		}
#line 703 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_e_list);
#line 5814 "game.c"
	}
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp75_ = self->priv->_to_hide;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp75_);
#line 709 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp76_ = self->priv->_to_move;
#line 709 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp76_);
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp77_ = self->priv->_to_show;
#line 710 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp77_);
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp78_ = self->priv->_grid;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp79_ = grid_get_target_value_reached (_tmp78_);
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp80_ = _tmp79_;
#line 712 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp80_) {
#line 5836 "game.c"
		Grid* _tmp81_ = NULL;
		guint _tmp82_ = 0U;
		guint _tmp83_ = 0U;
		Grid* _tmp84_ = NULL;
#line 713 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp81_ = self->priv->_grid;
#line 713 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp82_ = grid_get_target_value (_tmp81_);
#line 713 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp83_ = _tmp82_;
#line 713 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "target-value-reached", _tmp83_);
#line 714 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp84_ = self->priv->_grid;
#line 714 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		grid_set_target_value_reached (_tmp84_, FALSE);
#line 5853 "game.c"
	}
#line 717 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp85_ = self->priv->_grid;
#line 717 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp86_ = grid_is_finished (_tmp85_);
#line 717 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp86_) {
#line 718 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_signal_emit_by_name (self, "finished");
#line 5863 "game.c"
	}
#line 720 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = FALSE;
#line 720 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 5869 "game.c"
}


static void _game_store_movement (Game* self) {
	gboolean _tmp0_ = FALSE;
#line 723 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 725 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_allow_undo;
#line 725 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	if (_tmp0_) {
#line 5881 "game.c"
		GeeLinkedList* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		guint _tmp4_ = 0U;
		GeeLinkedList* _tmp8_ = NULL;
		Grid* _tmp9_ = NULL;
		Grid* _tmp10_ = NULL;
		Grid* _tmp11_ = NULL;
		GeeLinkedList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 726 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp1_ = self->priv->_undo_stack;
#line 726 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
#line 726 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp3_ = _tmp2_;
#line 726 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp4_ = self->priv->_undo_stack_max_size;
#line 726 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (((guint) _tmp3_) == _tmp4_) {
#line 5903 "game.c"
			GeeLinkedList* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			Grid* _tmp7_ = NULL;
#line 727 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp5_ = self->priv->_undo_stack;
#line 727 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp6_ = gee_deque_poll_tail ((GeeDeque*) _tmp5_);
#line 727 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_tmp7_ = (Grid*) _tmp6_;
#line 727 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			_g_object_unref0 (_tmp7_);
#line 5915 "game.c"
		}
#line 728 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp8_ = self->priv->_undo_stack;
#line 728 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp9_ = self->priv->_grid;
#line 728 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp10_ = grid_clone (_tmp9_);
#line 728 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp11_ = _tmp10_;
#line 728 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		gee_deque_offer_head ((GeeDeque*) _tmp8_, _tmp11_);
#line 728 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_g_object_unref0 (_tmp11_);
#line 729 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp12_ = self->priv->_undo_stack;
#line 729 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
#line 729 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		_tmp14_ = _tmp13_;
#line 729 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		if (_tmp14_ == 1) {
#line 730 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
			g_signal_emit_by_name (self, "undo-enabled");
#line 5939 "game.c"
		}
	}
}


ClutterActor* game_get_view (Game* self) {
	ClutterActor* result;
	ClutterActor* _tmp0_ = NULL;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_view;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = _tmp0_;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 5956 "game.c"
}


static void __game_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_game_on_allocation_changed ((Game*) self, box, flags);
#line 5963 "game.c"
}


void game_set_view (Game* self, ClutterActor* value) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = value;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_view);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_view = _tmp1_;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp2_ = self->priv->_view;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_connect_object (_tmp2_, "allocation-changed", (GCallback) __game_on_allocation_changed_clutter_actor_allocation_changed, self, 0);
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_notify ((GObject *) self, "view");
#line 5987 "game.c"
}


guint game_get_score (Game* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = self->priv->_score;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	result = _tmp0_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	return result;
#line 6002 "game.c"
}


void game_set_score (Game* self, guint value) {
	guint _tmp0_ = 0U;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_return_if_fail (self != NULL);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_tmp0_ = value;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_score = _tmp0_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_notify ((GObject *) self, "score");
#line 6016 "game.c"
}


static void game_class_init (GameClass * klass) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	game_parent_class = g_type_class_peek_parent (klass);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_type_class_add_private (klass, sizeof (GamePrivate));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW, g_param_spec_object ("view", "view", "view", clutter_actor_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SCORE, g_param_spec_uint ("score", "score", "score", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("finished", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("target_value_reached", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("undo_enabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	g_signal_new ("undo_disabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 6043 "game.c"
}


static void game_instance_init (Game * self) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv = GAME_GET_PRIVATE (self);
#line 33 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->BLANK_ROW_HEIGHT = 10;
#line 34 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->BLANK_COL_WIDTH = 10;
#line 6054 "game.c"
}


static void game_finalize (GObject* obj) {
	Game * self;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
#line 36 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_grid);
#line 38 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_view);
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_background = (_vala_array_free (self->priv->_background, self->priv->_background_length1 * self->priv->_background_length2, (GDestroyNotify) g_object_unref), NULL);
#line 40 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_move);
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_hide);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_to_show);
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_show_hide_trans);
#line 49 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_move_trans);
#line 54 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_undo_stack);
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_object_unref0 (self->priv->_settings);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	_g_free0 (self->priv->_saved_path);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
#line 6090 "game.c"
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	switch (property_id) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_VIEW:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_value_set_object (value, game_get_view (self));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_SCORE:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		g_value_set_uint (value, game_get_score (self));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6123 "game.c"
		default:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6129 "game.c"
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
	switch (property_id) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_VIEW:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		game_set_view (self, g_value_get_object (value));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		case GAME_SCORE:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		game_set_score (self, g_value_get_uint (value));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6151 "game.c"
		default:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/gnome-2048/src/game.vala"
		break;
#line 6157 "game.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



