/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
**
** file.c
**
** Copyright (C) 1995, 1996, 1997 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@thep.physik.uni-mainz.de)
**           Department of Physics
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

/*
** Modified July 7, 1998 by Jonathan Blandford
** 
** VMS support is now removed, as has the Xt* stuff.
*/
/*#include "message.h"*/


#define MAX_FILENAME_LENGTH 100
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_PATHS_H
#include "paths.h"
#endif
#include <gtk/gtk.h>
/*#include <X11/Intrinsic.h>*/

/*#include "types.h"*/
#include "config.h"
/*#include "d_memdebug.h"*/
#include "file.h"

#include <string.h>


/*############################################################*/
/* file_getDirOfPath */
/*############################################################*/
/*
** Returns a freshly allocated string containing the current 
** directory of path.
*/
gchar *
file_getDirOfPath(gchar *path)
{
        gchar *dir = NULL;
        gchar *pos;

        if (path) {
                dir = strdup(path);
                pos = strrchr(dir,'/');
                if (pos) {
                        pos++;
                        *pos='\0';
                }
        }

        return (dir);
}

/*############################################################*/
/* file_stripVersionNumber */
/*############################################################*/
int
file_stripVersionNumber(filename)
   char *filename;
{
   int strippedVersionNumber=0;

   return(strippedVersionNumber);
}

/*############################################################*/
/* file_locateFilename */
/*############################################################*/
/*
** Returns a pointer to the location of the file in path.
*/
gchar *
file_locateFilename(gchar *path)
{
        gchar *tmp=NULL;

        if (path) {
                tmp = strrchr(path,'/');
                if (!tmp) tmp=path;
                else tmp++;
        }
        return(tmp);
}

/*############################################################*/
/* file_translateTildeInPath */
/*############################################################*/
/* 
** Replaces tilde in string by user's home directory. 
*/ 

void
file_translateTildeInPath(gchar *path)
{
        gchar *pos;

        if ((pos=strchr(path,'~'))) {
                gchar *home;
                gchar tmp[MAX_FILENAME_LENGTH];
                home=getenv("HOME");
                if (strlen(home)+strlen(path)-1 < MAX_FILENAME_LENGTH-1) {
                        *pos='\0'; pos++;
                        strcpy(tmp,path);
                        strcat(tmp,home);
                        strcat(tmp,pos);
                        strcpy(path,tmp);
                }
        }
}

/*############################################################*/
/* file_fileIsDir */
/*############################################################*/

gint
file_fileIsDir(gchar *fn)
{
        struct stat s;
        int r = 0;
        gchar *c;
        if (fn) {
                c = strrchr(fn,'/');
                if (c && (!*(c+1) || isspace(*(c+1)))) r = 1;
                if (!r && !stat(fn,&s)  && (S_ISDIR(s.st_mode))) r=1;
        }
        return(r);
}


/*############################################################*/
/* file_pdfname2psname */
/*############################################################*/
/*
** If the file ends in .pdf, change this to .ps.
** Return pointer to temp copy if changed, else to input string. 
*/
gchar *
file_pdfname2psname(gchar *name)
{
        char *e;

        if (!name) 
                return(name);
        
        e = name+strlen(name);
        if ((e-name)-4 >= 0) {
                e -= 4;
                if (!strcasecmp(e,".pdf")) 
                        strcpy(e,".ps");
        }
        return(name);
}


/*############################################################*/
/* file_getUsefulName */
/*############################################################*/
 
gchar *
file_getUsefulName(gchar *name)
{
        gchar *e,*c;
        gchar* mext, *ext;

        if (!name) 
                return (name);

        c = e = strrchr(name,'.');
        if (!e) 
                return(name);

        mext = ext = strdup (e);
        while (*ext) { *ext = tolower(*ext); ext++; }
        if      (!strncmp(mext,".gz",3))  ext = "";
        else if (!strncmp(mext,".z",2))   ext = "";
        else if (!strncmp(mext,".ps",3))  ext = ".ps";
        else if (!strncmp(mext,".pdf",4)) ext = ".pdf";
        else                              ext = e;
        if (e == name && !(*ext)) {
                return(name);
        }
        strcpy(mext,ext);
        ext=mext;
        while (*ext && *e) *ext++=*e++;
        strcpy(c,mext);
        free(mext);
        return(name);
}

