
/* Ekiga -- A VoIP and Video-Conferencing application
 * Copyright (C) 2000-2006 Damien Sandras
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *
 * Ekiga is licensed under the GPL license and as a special exception,
 * you have permission to link or otherwise combine this program with the
 * programs OPAL, OpenH323 and PWLIB, and distribute the combination,
 * without applying the requirements of the GNU GPL to the OPAL, OpenH323
 * and PWLIB programs, as long as you do follow the requirements of the
 * GNU GPL for all the rest of the software thus combined.
 */


/*
 *                         accounts.h  -  description
 *                         --------------------------
 *   begin                : Sun Feb 13 2005
 *   copyright            : (C) 2000-2006 by Damien Sandras
 *   description          : This file contains all the functions needed to
 *   			    manipulate accounts.
 */


#ifndef _ACCOUNTS_H_
#define _ACCOUNTS_H_

#include "common.h"
#include "services.h"
#include "account.h"

/* The API */

/* DESCRIPTION  : /
 * BEHAVIOR     : Builds the GMAccounts window GMObject.
 * PRE          : /
 */
GtkWidget *gm_accounts_window_new (Ekiga::ServiceCore &core);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the account corresponding to the given domain, and
 * 		   username with the given status message. Enables or not
 * 		   the refreshing state for that account (see below for
 * 		   the implications).
 * PRE          :  /
 */
//FIXME private
void gm_accounts_window_update_account_state (GtkWidget *accounts_window,
					      gboolean refreshing,
                                              const Ekiga::Account & account,
					      const gchar *status,
					      const gchar *voicemails);


#endif
