/* app-background.c - Background configuration application.  */

#include <config.h>
#include <strings.h>
#include "capplet-widget.h"

extern void background_init(void);

/* In any case, set sm commands
   If init-session-settings:
      if we get the token, do init.
      else exit.
   else
      do the thang.
*/
gint
main (gint argc, char *argv[])
{
     GnomeClient *client = NULL;
     gchar *session_args[3];
     int init_results;
     int smtoken;

     bindtextdomain (PACKAGE, GNOMELOCALEDIR);
     textdomain (PACKAGE);
    
     init_results = gnome_capplet_init("background-properties", VERSION,
				       argc, argv, NULL, 0, NULL);

     client = gnome_master_client ();
     if(client) {
       /* setup session management */
       session_args[0] = argv[0];
       session_args[1] = "--init-session-settings";
       session_args[2] = NULL;
       gnome_client_set_restart_style (client, GNOME_RESTART_ANYWAY);
       gnome_client_set_restart_command (client, 2, session_args);
       gnome_client_flush(client);
     }

     /* this goes somewhere else eventually */
     background_imlib_init ();

     switch(init_results) {
     case -1:
	  g_error ("an initialization error occurred while starting "
		   "'background-properties-capplet'.\n"
		   "aborting...\n");
     case 1:
       if(client && gnome_client_get_previous_id(client)) {
	 smtoken = gnome_startup_acquire_token("GNOME_BACKGROUND_PROPERTIES",
					       gnome_client_get_id(client));
       } else
	 smtoken = 1;

       if(smtoken)
	 background_properties_init();

       return 0;

     default: break;
     }

     background_init();
     capplet_gtk_main();
    
     return 0;
}
