#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct _client 
{
  gchar               *name;
  Window              win;
  gchar               *msg;
  gchar               *clientname;
  gchar               *version;
  gchar               *author;
  gchar               *email;
  gchar               *web;
  gchar               *address;
  gchar               *info;
}
Client;

Client *e_client = NULL;

static Window comms_win = 0;
static Window my_win = 0;
static GdkWindow *gdkwin = NULL;
static void (*msg_recieve_callback) (gchar *msg) = NULL;

void CommsInit(void (*msg_recieve_func) (gchar *msg));
void CommsSend(gchar *s);

static void CommsSetup(void);
static GdkFilterReturn CommsFilter(GdkXEvent *gdk_xevent, GdkEvent *event, gpointer data);
static Window CommsFindCommsWindow(void);
static gchar *CommsGet(Client **c, XEvent * ev);
static Client *MakeClient(Window win);
static void ListFreeClient(void *ptr);

void
CommsInit(void (*msg_recieve_func) (gchar *msg))
{
  Window win;
  gchar st[32];
  Client             *cl;
  
  CommsSetup();
  win = CommsFindCommsWindow();
  if (!win)
    {
      g_error("Cannot find E\n");
      exit(1);
    }
  else
    {      
      cl = MakeClient(win);
      g_snprintf(st, sizeof(st), "%8x", (int)win);
      cl->name = g_strdup(st);
      e_client = cl;
      XSelectInput(GDK_DISPLAY(), win, StructureNotifyMask | SubstructureNotifyMask);
      gdk_window_add_filter(gdkwin, CommsFilter, NULL);
      gdkwin = gdk_window_foreign_new(win);
      msg_recieve_callback = msg_recieve_func;
    }
}

void
CommsSend(gchar *s)
{
  gchar                ss[21];
  int                 i, j, k, len;
  XEvent              ev;
  Atom                a;
  Client             *c;
  
  c = e_client;
  if ((!s) || (!c))
    return;
  len = strlen(s);
  a = XInternAtom(GDK_DISPLAY(), "ENL_MSG", True);
  ev.xclient.type = ClientMessage;
  ev.xclient.serial = 0;
  ev.xclient.send_event = True;
  ev.xclient.window = c->win;
  ev.xclient.message_type = a;
  ev.xclient.format = 8;
  
  for (i = 0; i < len + 1; i += 12)
    {
      g_snprintf(ss, sizeof(ss), "%8x", (int)my_win);
      for (j = 0; j < 12; j++)
	{
	  ss[8 + j] = s[i + j];
	  if (!s[i + j])
	    j = 12;
	}
      ss[20] = 0;
      for (k = 0; k < 20; k++)
	ev.xclient.data.b[k] = ss[k];
      XSendEvent(GDK_DISPLAY(), c->win, False, 0, (XEvent *) & ev);
    }
  return;
}

static GdkFilterReturn
CommsFilter(GdkXEvent *gdk_xevent, GdkEvent *event, gpointer data)
{
  XEvent *xevent;
  gchar *msg = NULL;
  Client *c = NULL;

  xevent = (XEvent *)gdk_xevent;
  switch (xevent->type)
    {
     case DestroyNotify:
      gdk_window_destroy_notify(((GdkEventAny *)event)->window);
      return GDK_FILTER_REMOVE;
      break;
     case ClientMessage:
      msg = CommsGet(&c, xevent);
      if (msg) 
	{
	  if (msg_recieve_callback) 
	    (*msg_recieve_callback)(msg);
	  g_free(msg);
	}
      return GDK_FILTER_REMOVE;
      break;
     default:
      return GDK_FILTER_REMOVE;
    }
  return GDK_FILTER_REMOVE;
}

static void
CommsSetup(void)
{
  my_win = XCreateSimpleWindow(GDK_DISPLAY(), GDK_ROOT_WINDOW(), 
			       -100, -100, 5, 5, 0, 0, 0);
}

static Window
CommsFindCommsWindow(void)
{
  unsigned char      *s;
  Atom                a, ar;
  unsigned long       num, after;
  int                 format;
  Window              win = 0;

  a = XInternAtom(GDK_DISPLAY(), "ENLIGHTENMENT_COMMS", True);
  if (a != None)
    {
      s = NULL;
      XGetWindowProperty(GDK_DISPLAY(), GDK_ROOT_WINDOW(), a, 0, 14, False, 
			 AnyPropertyType, &ar, &format, &num, &after, &s);
      if (s)
	{
	  sscanf((char *)s, "%*s %x", (unsigned int *)&win);
	  XFree(s);
	}
    }
  return win;
}

static gchar *
CommsGet(Client ** c, XEvent * ev)
{
  gchar                s[13], s2[9], *msg;
  int                 i;
  Window              win;
  Client             *cl;
  
  if ((!ev) || (!c))
    return (NULL);
  if (ev->type != ClientMessage)
    return (NULL);
  s[12] = 0;
  s2[8] = 0;
  msg = NULL;
  for (i = 0; i < 8; i++)
    s2[i] = ev->xclient.data.b[i];
  for (i = 0; i < 12; i++)
    s[i] = ev->xclient.data.b[i + 8];
  sscanf(s2, "%x", (int *)&win);
  cl = e_client;
  if (!cl)
    return (NULL);
  if (cl->msg)
    {
      /* append text to end of msg */
      cl->msg = g_realloc(cl->msg, strlen(cl->msg) + strlen(s) + 1);
      if (!cl->msg)
	return (NULL);
      strcat(cl->msg, s);
    }
  else
    {
      /* new msg */
      cl->msg = g_malloc(strlen(s) + 1);
      if (!cl->msg)
	return (NULL);
      strcpy(cl->msg, s);
    }
  if (strlen(s) < 12)
    {
      msg = cl->msg;
      cl->msg = NULL;
      *c = cl;
    }
  return (msg);
}

static Client             *
MakeClient(Window win)
{
  Client             *c;
  
  c = g_malloc(sizeof(Client));
  if (!c)
    return (NULL);
  c->name = NULL;
  c->win = win;
  c->msg = NULL;
  c->clientname = NULL;
  c->version = NULL;
  c->author = NULL;
  c->email = NULL;
  c->web = NULL;
  c->address = NULL;
  c->info = NULL;
  return (c);
}

static void
ListFreeClient(void *ptr)
{
  Client             *c;
  
  c = (Client *) ptr;
  if (!c)
    return;
  if (c->name)
    g_free(c->name);
  if (c->msg)
    g_free(c->msg);
  if (c->clientname)
    g_free(c->clientname);
  if (c->version)
    g_free(c->version);
  if (c->author)
    g_free(c->author);
  if (c->email)
    g_free(c->email);
  if (c->web)
    g_free(c->web);
  if (c->address)
    g_free(c->address);
  if (c->info)
    g_free(c->info);
  g_free(c);
  return;
}
