/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/* Copyright (C) 1998 Redhat Software Inc. 
 * Authors: Jonathan Blandford <jrb@redhat.com>
 */
#include "capplet-widget.h"
#include <config.h>
#include <X11/Xlib.h>
#include <assert.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include <gdk/gdkx.h>

#include "gnome.h"

typedef struct _background
{
  char               *name;
  GdkPixmap          *pmap;
  struct _bg
    {
      GdkImlibColor       solid;
      char               *file;
      char                tile;
      char                keep_aspect;
      int                 xjust, yjust;
      int                 xperc, yperc;
    }
  bg;
  struct _top
    {
      char               *file;
      char                keep_aspect;
      int                 xjust, yjust;
      int                 xperc, yperc;
    }
  top;
}
Background;


GtkWidget *current_capplet;
gchar     e_opt_sound = 1;
gchar     e_opt_slide_cleanup = 1;
gchar     e_opt_slide_map = 1;
gchar     e_opt_slide_desk = 1;
gchar     e_opt_hq_background = 1;
gchar     e_opt_saveunders = 1;

gint      e_opt_focus = 1;
gint      e_opt_move = 0;
gint      e_opt_resize = 2;
gint      e_opt_slide_mode = 0;

gchar     e_opt_tooltips = 1;
gchar     e_opt_menuslide = 0;
gfloat    e_opt_tooltiptime = 1.5;

gfloat    e_opt_shade_speed = 4000.0;
gfloat    e_opt_map_speed = 4000.0;
gfloat    e_opt_cleanup_speed = 4000.0;
gfloat    e_opt_desk_speed = 4000.0;
gfloat    e_opt_desktop_bg_timeout = 60.0;
gfloat    e_opt_number_of_desks = 32;

gfloat    e_opt_area_width = 3;
gfloat    e_opt_area_height = 3;

gchar     e_opt_autorase = 0;
gfloat    e_opt_autoraisetime = 0.5;
gint      e_opt_dragdir = 2;
gchar     e_opt_show_icons = 1;
gchar     e_opt_transients_follow_leader = 1;
gchar     e_opt_switch_for_transient_map = 1;

GList    *backgrounds = NULL;

Background *deskbg[32];
GtkWidget  *deskbt[32];
gint        curdesk = 0;

gchar       got_e_ipc_msg = 0;
gchar      *e_ipc_msg = NULL;

GtkWidget  *progress_win = NULL, *progress = NULL;

void CommsInit(void (*msg_recieve_func) (gchar *msg));
void CommsSend(gchar *s);

static void
recieve_ipc_msg(gchar *msg)
{
  gdk_flush();
  e_ipc_msg = g_strdup(msg);
/*  gtk_main_quit();*/
  got_e_ipc_msg = 1;
}

static gchar *
wait_for_ipc_msg(void)
{
  while (!got_e_ipc_msg)
    {
      while (gtk_events_pending())
	gtk_main_iteration();
      gdk_flush();
    }
/*  gtk_main();*/
  got_e_ipc_msg = 0;
  return e_ipc_msg;
}

gchar *
get_line(gchar *str, int num)
{
  gchar *s1, *s2, *s;
  gint i, count, l;

  i = 0;
  count = 0;
  s1 = str;
  if (*str == '\n')
    i = 1;
  s2 = NULL;
  for (i = 0; ; i++)
    {
      if ((str[i] == '\n') || (str[i] == 0))
	{
	  s2 = &(str[i]);
	  if ((count == num) && (s2 > s1))
	    {
	      l = s2 - s1;
	      s = g_malloc(l + 1);
	      strncpy(s, s1, l);
	      s[l] = 0;
	      return s;
	    }
	  count++;
	  if (str[i] == 0)
	    return NULL;
	  s1 = s2 + 1;
	}
    }
}

static void
e_try (void)
{
  gchar cmd[4096];

  g_snprintf(cmd, sizeof(cmd), "set_controls"
	     " SOUND: %i"
	     " CLEANUPSLIDE: %i"
	     " MAPSLIDE: %i"
	     " DESKSLIDEIN: %i"
	     " HIQUALITYBG: %i"
	     " FOCUSMODE: %i"
	     " MOVEMODE: %i"
	     " RESIZEMODE: %i"
	     " SLIDEMODE: %i"
	     " TOOLTIPS: %i"
	     " TIPTIME: %f"
	     " SHADESPEED: %i"
	     " SLIDESPEEDMAP: %i"
	     " SLIDESPEEDCLEANUP: %i"
	     " DESKSLIDESPEED: %i"
	     " DESKTOPBGTIMEOUT: %i"
	     " SAVEUNDER: %i"
	     " NUMDESKTOPS: %i"
	     " MENUSLIDE: %i"
	     " AREA_SIZE: %i %i"
	     ,
	     e_opt_sound, e_opt_slide_cleanup, e_opt_slide_map, 
	     e_opt_slide_desk, e_opt_hq_background,
	     e_opt_focus, e_opt_move, e_opt_resize, e_opt_slide_mode,
	     e_opt_tooltips, e_opt_tooltiptime,
	     (gint)e_opt_shade_speed,
	     (gint)e_opt_map_speed,
	     (gint)e_opt_cleanup_speed,
	     (gint)e_opt_desk_speed,
	     ((gint)e_opt_desktop_bg_timeout) * 60,
	     e_opt_saveunders,
	     (gint)e_opt_number_of_desks,
	     e_opt_menuslide, 
	     (gint)e_opt_area_width, 
	     (gint)e_opt_area_height
	     );
  CommsSend(cmd);
    {
      gint i, d;
      Background *bg;
      gchar buf[256];
      
      for (i = 0; i < g_list_length(backgrounds); i++)
	{
	  if (g_list_nth(backgrounds, i))
	    bg = (g_list_nth(backgrounds, i))->data;
	  if (bg)
	    {
	      gint j;
	      
	      g_snprintf(cmd, sizeof(cmd), "use_bg %s",
			 bg->name);
	      for (j = 0; j < 32; j++)
		{
		  if (deskbg[j] == bg)
		    {
		      g_snprintf(buf, sizeof(buf), " %i", j);
		      strcat(cmd, buf);
		    }
		}
	      CommsSend(cmd);
	    }
	}
    }
}

static void
e_revert (void)
{
}

static void
e_ok (void)
{
  e_try();
}

static void
e_cancel (void)
{
}

static void
e_read (void)
{
  gchar cmd[4096];
  gchar *buf;
  gchar *msg;
  gint i;
    
  CommsSend("get_controls");
  msg = wait_for_ipc_msg();
  i = 0;
  while (buf = get_line(msg, i++))
    {
      sscanf(buf, "%4000s", cmd);
      if (!strcmp(cmd, "SOUND:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_sound = atoi(cmd);
	}
      else if (!strcmp(cmd, "CLEANUPSLIDE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_slide_cleanup = atoi(cmd);
	}
      else if (!strcmp(cmd, "MAPSLIDE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_slide_map = atoi(cmd);
	}
      else if (!strcmp(cmd, "DESKSLIDEIN:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_slide_desk = atoi(cmd);
	}
      else if (!strcmp(cmd, "HIQUALITYBG:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_hq_background = atoi(cmd);
	}
      else if (!strcmp(cmd, "FOCUSMODE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_focus = atoi(cmd);
	}
      else if (!strcmp(cmd, "MOVEMODE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_move = atoi(cmd);
	}
      else if (!strcmp(cmd, "RESIZEMODE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_resize = atoi(cmd);
	}
      else if (!strcmp(cmd, "SLIDEMODE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_slide_mode = atoi(cmd);
	}
      else if (!strcmp(cmd, "TOOLTIPS:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_tooltips = atoi(cmd);
	}
      else if (!strcmp(cmd, "TIPTIME:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_tooltiptime = atof(cmd);
	}
      else if (!strcmp(cmd, "SHADESPEED:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_shade_speed = atof(cmd);
	}
      else if (!strcmp(cmd, "SLIDESPEEDMAP:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_map_speed = atof(cmd);
	}
      else if (!strcmp(cmd, "SLIDESPEEDCLEANUP:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_cleanup_speed = atof(cmd);
	}
      else if (!strcmp(cmd, "DESKSLIDESPEED:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_desk_speed = atof(cmd);
	}
      else if (!strcmp(cmd, "DESKTOPBGTIMEOUT:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_desktop_bg_timeout = atof(cmd) / 60;
	}
      else if (!strcmp(cmd, "SAVEUNDER:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_saveunders = atoi(cmd);
	}
      else if (!strcmp(cmd, "NUMDESKTOPS:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_number_of_desks = atof(cmd);
	}
      else if (!strcmp(cmd, "MENUSLIDE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_menuslide = atof(cmd);
	}
      else if (!strcmp(cmd, "AREA_SIZE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_area_width = atof(cmd);
	  sscanf(buf, "%*s %*s %4000s", cmd);
	  e_opt_area_height = atof(cmd);
	}
      g_free(buf);
    }
  g_free(msg);

  CommsSend("list_bg");
  msg = wait_for_ipc_msg();
  i = 0;
  while (buf = get_line(msg, i++))
    {
      Background *bg;
      
      if (strlen(buf) > 0)
	{
	  bg = g_malloc(sizeof(Background));
	  bg->name = g_strdup(buf);
	  bg->pmap = NULL;
	  backgrounds = g_list_append(backgrounds, bg);
	}
      g_free(buf);
    }
  g_free(msg);
    
    {
      gint        ii, j, d;
      Background *bg;
      GList      *ptr;
      
      j = g_list_length(backgrounds);
      ptr = backgrounds;
      for (i = 0; ((i < j) && (ptr)); i++)
	{
	  if (progress)
	    gtk_progress_bar_update(GTK_PROGRESS_BAR(progress),
				    (gfloat)i / (gfloat)j);
	  bg = ptr->data;
	  ptr = ptr->next;
	  if (bg)
	    {
	      g_snprintf(cmd, sizeof(cmd), "uses_bg %s", bg->name);
	      CommsSend(cmd);
	      msg = wait_for_ipc_msg();
	      ii = 0;
	      while (buf = get_line(msg, ii++))
		{
		  if (sscanf(buf, "%i", &d) > 0)
		    {
		      if (d < 0)
			d = 0;
		      if (d > 31)
			d = 31;
		      deskbg[d] = bg;
		    }
		  g_free(buf);
		}
	      g_free(msg);
	    }
	}
    }
}

static void
e_render_bg_onto(GdkWindow *win, Background *bg)
{
  gchar cmd[4096];
  gchar *msg;
  
  g_snprintf(cmd, sizeof(cmd), "draw_bg_to %x %s",
	     (gint)GDK_WINDOW_XWINDOW(win), bg->name);
  CommsSend(cmd);
  msg = wait_for_ipc_msg();
  g_free(msg);
}

void
e_cb_multi(GtkWidget *widget, gpointer data)
{
  GtkWidget *c;
  gint *value;
  gint val;
  
  c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  val = (gint)gtk_object_get_data(GTK_OBJECT(widget), "value");
  value = (gint *)data;
  *value = val;
}

void
e_cb_onoff(GtkWidget *widget, gpointer data)
{
  GtkWidget *c;
  gchar *value;
  
  c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  value = (gchar *)data;
  if (GTK_TOGGLE_BUTTON(widget)->active)
    *value = 1;
  else
    *value = 0;
}

void
e_cb_range(GtkWidget *widget, gpointer data)
{
  GtkWidget          *c;
  GtkWidget          *w;
  GtkAdjustment      *adj;
  gfloat             *value, current_val;
  static gint        just_changed = 0;
  GtkFunction        func;
  
  w = GTK_WIDGET(data);
  c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "capplet");
  func = (GtkFunction)gtk_object_get_data(GTK_OBJECT(w), "function");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  adj = gtk_object_get_data(GTK_OBJECT(w), "adj");
  value = (gfloat *)gtk_object_get_data(GTK_OBJECT(w), "value");
  if (adj->step_increment > 0.5)
    {
      current_val = adj->value;
      adj->value = (gfloat)((gint)(adj->value / adj->step_increment)) *
	adj->step_increment;
      if (just_changed == 0)
	{
	  just_changed ++;
	  gtk_adjustment_value_changed(adj);
	}
      else if (just_changed > 0)
	just_changed--;
    }
  *value = adj->value;

  if (func)
    (*func)((gint)(adj->value));
  
  widget = NULL;
}

void
e_cb_rangeonoff_toggle(GtkWidget *widget, gpointer data)
{
  GtkWidget          *c;
  GtkWidget          *w, *ww;
  GtkAdjustment      *adj;
  gfloat             *value, offvalue;
  gchar              *onoff;
  
  w = GTK_WIDGET(data);
  c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  adj = gtk_object_get_data(GTK_OBJECT(w), "adj");
  value = (gfloat *)gtk_object_get_data(GTK_OBJECT(w), "value");
  onoff = (gchar *)gtk_object_get_data(GTK_OBJECT(w), "onoff");
  offvalue = *((gfloat *)gtk_object_get_data(GTK_OBJECT(w), "offvalue"));
  *value = adj->value;
  
  if (onoff)
    {
      if (GTK_TOGGLE_BUTTON(widget)->active)
	{
	  ww = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "l1");
	  gtk_widget_set_sensitive(ww, TRUE);
	  ww = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "l2");
	  gtk_widget_set_sensitive(ww, TRUE);
	  gtk_widget_set_sensitive(w, TRUE);
	  *onoff = 1;
	}
      else
	{
	  ww = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "l1");	
	  gtk_widget_set_sensitive(ww, FALSE);
	  ww = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "l2");
	  gtk_widget_set_sensitive(ww, FALSE);
	  gtk_widget_set_sensitive(w, FALSE);
	  *onoff = 0;
	}
    }
  else
    {    
      if (GTK_TOGGLE_BUTTON(widget)->active)
	{
	  ww = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "l1");
	  gtk_widget_set_sensitive(ww, TRUE);
	  ww = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "l2");
	  gtk_widget_set_sensitive(ww, TRUE);
	  gtk_widget_set_sensitive(w, TRUE);
	  *value = 0.0;
	}
      else
	{
	  ww = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "l1");
	  gtk_widget_set_sensitive(ww, FALSE);
	  ww = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "l2");
	  gtk_widget_set_sensitive(ww, FALSE);
	  gtk_widget_set_sensitive(w, FALSE);
	  *value = offvalue;
	}
    }
  widget = NULL;
}

void
e_add_step_range_to_frame(GtkWidget *w, gchar *text, gfloat *value, 
			  gfloat lower, gfloat upper, gchar *lower_text, 
			  gchar *upper_text, gfloat step)
{
  GtkObject *adj;
  GtkWidget *frame, *hscale, *hbox, *label, *align, *table, *align2;
  gint rows;
  
  if (!w)
    return;
  if (!text)
    return;
  table = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "table");
  if (!table)
    return;
  rows = (gint)gtk_object_get_data(GTK_OBJECT(w), "rows");
  
  frame = gtk_frame_new(text);
  gtk_widget_show(frame);
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), frame);
  gtk_table_attach(GTK_TABLE(table), align, 0, 10, rows, rows + 1,
		   GTK_EXPAND | GTK_FILL,
		   GTK_EXPAND | GTK_FILL, 0, 0);
  
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  hbox = gtk_hbox_new(FALSE, 2);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(align), hbox);
  
  label = gtk_label_new(lower_text);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  adj = gtk_adjustment_new(*value, lower, upper, step, step, step);
  hscale = gtk_hscale_new(GTK_ADJUSTMENT(adj));
  gtk_scale_set_digits(GTK_SCALE(hscale), 0);
  gtk_widget_show(hscale);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		     GTK_SIGNAL_FUNC(e_cb_range), (gpointer)hscale);
  gtk_object_set_data(GTK_OBJECT(hscale), "adj", (gpointer)adj);
  gtk_object_set_data(GTK_OBJECT(hscale), "value", (gpointer)value);  
  gtk_object_set_data(GTK_OBJECT(hscale), "capplet", (gpointer)current_capplet);  
  gtk_box_pack_start(GTK_BOX(hbox), hscale, TRUE, TRUE, 0);
  label = gtk_label_new(upper_text);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  
  gtk_object_set_data(GTK_OBJECT(w), "rows", (gpointer)(rows + 1));
}

void
e_add_step_range_to_frame_with_cb(GtkWidget *w, gchar *text, gfloat *value, 
				  gfloat lower, gfloat upper, gchar *lower_text, 
				  gchar *upper_text, gfloat step,
				  GtkFunction func)
{
  GtkObject *adj;
  GtkWidget *frame, *hscale, *hbox, *label, *align, *table, *align2;
  gint rows;
  
  if (!w)
    return;
  if (!text)
    return;
  table = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "table");
  if (!table)
    return;
  rows = (gint)gtk_object_get_data(GTK_OBJECT(w), "rows");
  
  frame = gtk_frame_new(text);
  gtk_widget_show(frame);
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), frame);
  gtk_table_attach(GTK_TABLE(table), align, 0, 10, rows, rows + 1,
		   GTK_EXPAND | GTK_FILL,
		   GTK_EXPAND | GTK_FILL, 0, 0);
  
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  hbox = gtk_hbox_new(FALSE, 2);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(align), hbox);
  
  label = gtk_label_new(lower_text);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  adj = gtk_adjustment_new(*value, lower, upper, step, step, step);
  hscale = gtk_hscale_new(GTK_ADJUSTMENT(adj));
  gtk_scale_set_digits(GTK_SCALE(hscale), 0);
  gtk_widget_show(hscale);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		     GTK_SIGNAL_FUNC(e_cb_range), (gpointer)hscale);
  gtk_object_set_data(GTK_OBJECT(hscale), "adj", (gpointer)adj);
  gtk_object_set_data(GTK_OBJECT(hscale), "value", (gpointer)value);  
  gtk_object_set_data(GTK_OBJECT(hscale), "capplet", (gpointer)current_capplet);  
  gtk_object_set_data(GTK_OBJECT(hscale), "function", (gpointer)func);  
  gtk_box_pack_start(GTK_BOX(hbox), hscale, TRUE, TRUE, 0);
  label = gtk_label_new(upper_text);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  
  gtk_object_set_data(GTK_OBJECT(w), "rows", (gpointer)(rows + 1));
}

void
e_add_range_to_frame(GtkWidget *w, gchar *text, gfloat *value, gfloat lower,
		     gfloat upper, gchar *lower_text, gchar *upper_text)
{
  GtkObject *adj;
  GtkWidget *frame, *hscale, *hbox, *label, *align, *table, *align2;
  gint rows;
  
  if (!w)
    return;
  if (!text)
    return;
  table = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "table");
  if (!table)
    return;
  rows = (gint)gtk_object_get_data(GTK_OBJECT(w), "rows");
  
  frame = gtk_frame_new(text);
  gtk_widget_show(frame);
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), frame);
  gtk_table_attach(GTK_TABLE(table), align, 0, 10, rows, rows + 1,
		   GTK_EXPAND | GTK_FILL,
		   GTK_EXPAND | GTK_FILL, 0, 0);
  
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  hbox = gtk_hbox_new(FALSE, 2);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(align), hbox);
  
  label = gtk_label_new(lower_text);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  adj = gtk_adjustment_new(*value, lower, upper, 0.1, .1, 0.1);
  hscale = gtk_hscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_show(hscale);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		     GTK_SIGNAL_FUNC(e_cb_range), (gpointer)hscale);
  gtk_object_set_data(GTK_OBJECT(hscale), "adj", (gpointer)adj);
  gtk_object_set_data(GTK_OBJECT(hscale), "value", (gpointer)value);  
  gtk_object_set_data(GTK_OBJECT(hscale), "capplet", (gpointer)current_capplet);  
  gtk_box_pack_start(GTK_BOX(hbox), hscale, TRUE, TRUE, 0);
  label = gtk_label_new(upper_text);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  
  gtk_object_set_data(GTK_OBJECT(w), "rows", (gpointer)(rows + 1));
}

void
e_add_rangeonoff_to_frame(GtkWidget *w, gchar *text, gfloat *value, 
			  gfloat lower, gfloat upper, gchar *lower_text, 
			  gchar *upper_text, gchar *onoff, gfloat offvalue)
{
  GtkObject *adj;
  GtkWidget *frame, *hscale, *hbox, *label, *align, *table, *align2, *check;
  GtkWidget *label2;
  gint rows;
  gfloat *offval;
  
  if (!w)
    return;
  if (!text)
    return;
  table = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "table");
  if (!table)
    return;
  rows = (gint)gtk_object_get_data(GTK_OBJECT(w), "rows");
  
  frame = gtk_frame_new(text);
  gtk_widget_show(frame);
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), frame);
  gtk_table_attach(GTK_TABLE(table), align, 0, 10, rows, rows + 1,
		   GTK_EXPAND | GTK_FILL,
		   GTK_EXPAND | GTK_FILL, 0, 0);
  
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  hbox = gtk_hbox_new(FALSE, 2);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(align), hbox);
  
  check = gtk_check_button_new();
  gtk_widget_show(check);
  align2 = gtk_alignment_new(1.0, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), check);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);

  if (onoff)
    {
      if (*onoff)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 1);
      else
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 0);
    }
  else
    {
      if (*value == offvalue)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 0);
      else
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 1);
    }
  
  adj = gtk_adjustment_new(*value, lower, upper, 0.1, .1, 0.1);
  hscale = gtk_hscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_show(hscale);
  
  gtk_signal_connect(GTK_OBJECT(check), "toggled",
		     GTK_SIGNAL_FUNC(e_cb_rangeonoff_toggle), (gpointer)hscale);
  
  label = gtk_label_new(lower_text);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		     GTK_SIGNAL_FUNC(e_cb_range), (gpointer)hscale);
  gtk_object_set_data(GTK_OBJECT(hscale), "adj", (gpointer)adj);
  gtk_object_set_data(GTK_OBJECT(hscale), "value", (gpointer)value);  
  gtk_object_set_data(GTK_OBJECT(hscale), "capplet", (gpointer)current_capplet);  
  gtk_object_set_data(GTK_OBJECT(hscale), "onoff", (gpointer)onoff);
  gtk_object_set_data(GTK_OBJECT(hscale), "l1", (gpointer)label);
  offval = g_malloc(sizeof(gfloat));
  *offval = offvalue;
  gtk_object_set_data(GTK_OBJECT(hscale), "offvalue", (gpointer)offval);
  
  gtk_box_pack_start(GTK_BOX(hbox), hscale, TRUE, TRUE, 0);
  label2 = label = gtk_label_new(upper_text);
  gtk_object_set_data(GTK_OBJECT(hscale), "l2", (gpointer)label);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  if (onoff)
    {
      if (GTK_TOGGLE_BUTTON(check)->active)
	{
	  gtk_widget_set_sensitive(label, TRUE);
	  gtk_widget_set_sensitive(hscale, TRUE);
	  gtk_widget_set_sensitive(label2, TRUE);
	}
      else
	{
	  gtk_widget_set_sensitive(label, FALSE);
	  gtk_widget_set_sensitive(hscale, FALSE);
	  gtk_widget_set_sensitive(label2, FALSE);
	}
    }
  else
    {    
      if (GTK_TOGGLE_BUTTON(check)->active)
	{
	  gtk_widget_set_sensitive(label, TRUE);
	  gtk_widget_set_sensitive(hscale, TRUE);
	  gtk_widget_set_sensitive(label2, TRUE);
	}
      else
	{
	  gtk_widget_set_sensitive(label, FALSE);
	  gtk_widget_set_sensitive(hscale, FALSE);
	  gtk_widget_set_sensitive(label2, FALSE);
	}
    }
  
  gtk_object_set_data(GTK_OBJECT(w), "rows", (gpointer)(rows + 1));
}

void
e_add_multi_to_frame(GtkWidget *w, gchar *text, gchar *opts, gint *value)
{
  GtkWidget *table, *label, *om, *m, *mi, *align;
  gint i, j, rows;
  gchar s[1024], tmpbuf[2];
  
  if (!w)
    return;
  if (!text)
    return;
  table = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "table");
  if (!table)
    return;
  rows = (gint)gtk_object_get_data(GTK_OBJECT(w), "rows");
  
  label = gtk_label_new(text);
  gtk_widget_show(label);
  align = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), label);
  gtk_table_attach_defaults(GTK_TABLE(table), align, 0, 1, rows, rows + 1);
  
  om = gtk_option_menu_new();
  align = gtk_alignment_new(1.0, 0.5, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), om);
  gtk_table_attach(GTK_TABLE(table), align, 9, 10, rows, rows + 1,
		   GTK_EXPAND | GTK_FILL,
		   GTK_EXPAND | GTK_FILL, 0, 0);
  
  m = gtk_menu_new();
  gtk_widget_show(m);
  
  i = 0;
  j = 0;
  tmpbuf[1] = 0;
  while (opts[j])
    {
      s[0] = 0;
      if (opts[j] == '\n')
	j++;
      while ((opts[j]) && (opts[j] != '\n'))
	{
	  tmpbuf[0] = opts[j];
	  strcat(s, tmpbuf);
	  j++;
	}
      mi = gtk_menu_item_new_with_label(s);
      gtk_object_set_data(GTK_OBJECT(mi), "value", (gpointer)i);
      gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer)current_capplet);  
      gtk_signal_connect(GTK_OBJECT(mi),
			 "activate", GTK_SIGNAL_FUNC(e_cb_multi),
			 (gpointer)value);
      gtk_menu_append(GTK_MENU(m), mi);
      gtk_widget_show(mi);
      i++;
    }

  gtk_option_menu_set_menu(GTK_OPTION_MENU(om), m);
    
  gtk_option_menu_set_history(GTK_OPTION_MENU(om), *value);
  gtk_widget_show (om);
  
  gtk_object_set_data(GTK_OBJECT(w), "rows", (gpointer)(rows + 1));
}

void
e_add_onoff_to_frame(GtkWidget *w, gchar *text, gchar *value)
{
  GtkWidget *table, *check, *align;
  gint rows;
  
  if (!w)
    return;
  if (!text)
    return;
  table = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "table");
  if (!table)
    return;
  rows = (gint)gtk_object_get_data(GTK_OBJECT(w), "rows");

  check = gtk_check_button_new_with_label(text);
  gtk_widget_show(check);
  align = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), check);
  gtk_table_attach_defaults(GTK_TABLE(table), align, 0, 10, rows, rows + 1);

  gtk_object_set_data(GTK_OBJECT(check), "capplet", (gpointer)current_capplet);  
  if (*value)
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 1);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 0);

  gtk_signal_connect(GTK_OBJECT(check), "toggled",
		     GTK_SIGNAL_FUNC(e_cb_onoff), (gpointer)value);
  
  gtk_object_set_data(GTK_OBJECT(w), "rows", (gpointer)(rows + 1));
}

void
e_add_widget_to_frame(GtkWidget *w, GtkWidget *child)
{
  GtkWidget *table, *align;
  gint rows;
  
  if (!w)
    return;
  if (!child)
    return;
  table = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "table");
  if (!table)
    return;
  rows = (gint)gtk_object_get_data(GTK_OBJECT(w), "rows");
  
  align = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), child);
  gtk_table_attach(GTK_TABLE(table), align, 0, 10, rows, rows + 1,
		   GTK_EXPAND | GTK_FILL,
		   GTK_EXPAND | GTK_FILL, 0, 0);
  
  gtk_object_set_data(GTK_OBJECT(w), "rows", (gpointer)(rows + 1));
}

void
e_add_space_to_frame(GtkWidget *w, gint size)
{
  GtkWidget *table, *align, *child;
  gint rows;
  
  if (!w)
    return;
  table = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "table");
  if (!table)
    return;
  rows = (gint)gtk_object_get_data(GTK_OBJECT(w), "rows");
  
  align = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
  gtk_widget_show(align);
  child = gtk_fixed_new();
  gtk_widget_show(child);
  gtk_widget_set_usize(child, 1, size);
  gtk_container_add(GTK_CONTAINER(align), child);
  gtk_table_attach(GTK_TABLE(table), align, 0, 10, rows, rows + 1,
		   GTK_EXPAND | GTK_FILL,
		   GTK_EXPAND | GTK_FILL, 0, 0);
  
  gtk_object_set_data(GTK_OBJECT(w), "rows", (gpointer)(rows + 1));
}


GtkWidget *
e_create_frame(gchar *title)
{
  GtkWidget *frame, *table, *align;
  
  frame = gtk_frame_new(title);
  gtk_widget_show(frame);
  
  align = gtk_alignment_new(0.0, 0.0, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  
  table = gtk_table_new(1, 1, FALSE);
  gtk_widget_show(table);
  gtk_container_set_border_width(GTK_CONTAINER(table), GNOME_PAD_SMALL);
  gtk_container_add(GTK_CONTAINER(align), table);
  
  gtk_object_set_data(GTK_OBJECT(frame), "table", (gpointer)table);
  gtk_object_set_data(GTK_OBJECT(frame), "rows", (gpointer)0);
  return frame;    
} 

static void
e_init_capplet (GtkWidget *c, GtkSignalFunc try, GtkSignalFunc revert, 
		GtkSignalFunc ok, GtkSignalFunc cancel)
{
  gtk_widget_show (c);  
    
  gtk_signal_connect (GTK_OBJECT (c), "try",
		      GTK_SIGNAL_FUNC (try), NULL);
  gtk_signal_connect (GTK_OBJECT (c), "revert",
		      GTK_SIGNAL_FUNC (revert), NULL);
  gtk_signal_connect (GTK_OBJECT (c), "ok",
		      GTK_SIGNAL_FUNC (ok), NULL);
  gtk_signal_connect (GTK_OBJECT (c), "cancel",
		      GTK_SIGNAL_FUNC (cancel), NULL);
}

typedef struct _iconoption
{
  gchar  *name;
  char  **icon_data;
  gchar  *tip;
}
IconOption;

void
e_cb_icon_option(GtkWidget *widget, gpointer data)
{
  GtkWidget *c;
  gint *value;
  gint val;
  
  c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  val = (gint)gtk_object_get_data(GTK_OBJECT(widget), "value");
  value = (gint *)data;
  *value = val;
}

GtkWidget *
e_create_icon_option(gchar *title, gint *option, gint width, 
		     gint num_options, IconOption *options)
{
  GSList *items = NULL;
  GtkWidget *frame, *align, *table, *pixmap, *radio, *label, *vbox;
  GdkPixmap *pmap, *mask, *tip;
  gint i, j, k;
  
  frame = gtk_frame_new(title);
  gtk_widget_show(frame);
  
  align = gtk_alignment_new(0.0, 0.0, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  
  table = gtk_table_new(1, 1, TRUE);
  gtk_widget_show(table);
  gtk_container_set_border_width(GTK_CONTAINER(table), 1);
  gtk_container_add(GTK_CONTAINER(align), table);
  
  j = 0;
  k = 0;
  for (i = 0; i < num_options; i++)
    {
      pmap = NULL;
      mask = NULL;
      gdk_imlib_data_to_pixmap(options[i].icon_data, &pmap, &mask);
      radio = gtk_radio_button_new(items);
      gtk_object_set_data(GTK_OBJECT(radio), "value", (gpointer)i);
      gtk_object_set_data(GTK_OBJECT(radio), "capplet", (gpointer)current_capplet);
      gtk_signal_connect(GTK_OBJECT(radio),
			 "clicked", GTK_SIGNAL_FUNC(e_cb_icon_option),
			 (gpointer)option);
      if (i == *option)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio), 1);
      GTK_TOGGLE_BUTTON(radio)->draw_indicator = 0;
      gtk_widget_show(radio);
      label = gtk_label_new(options[i].name);
      gtk_widget_show(label);
      pixmap = gtk_pixmap_new(pmap, mask);
      gtk_widget_show(pixmap);
      vbox = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (vbox);
      gtk_container_add (GTK_CONTAINER (radio), vbox);
      gtk_box_pack_start (GTK_BOX(vbox), pixmap, FALSE, FALSE, 1);
      gtk_box_pack_start (GTK_BOX(vbox), label, FALSE, FALSE, 1);
      gtk_table_attach(GTK_TABLE(table), radio, j, j + 1, k, k + 1,
		       GTK_EXPAND | GTK_FILL,
		       GTK_EXPAND | GTK_FILL, 1, 1);
      tip = (GtkWidget *)gtk_tooltips_new();
      gtk_tooltips_set_tip(GTK_TOOLTIPS(tip), radio, options[i].tip, NULL);
      gtk_tooltips_enable(GTK_TOOLTIPS(tip));
      items = g_slist_append(items, radio);
      j++;
      if (j >= width)
	{
	  j = 0;
	  k++;
	}
    }
  return frame;
}








GtkWidget *
e_create_onoff(gchar *text, gchar *value)
{
  GtkWidget *check, *align;
  gint rows;
  
  if (!text)
    return NULL;

  check = gtk_check_button_new_with_label(text);
  gtk_widget_show(check);
  align = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), check);

  gtk_object_set_data(GTK_OBJECT(check), "capplet", (gpointer)current_capplet);  
  if (*value)
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 1);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 0);

  gtk_signal_connect(GTK_OBJECT(check), "toggled",
		     GTK_SIGNAL_FUNC(e_cb_onoff), (gpointer)value);
  return align;
}

GtkWidget *
e_create_rangeonoff(gchar *text, gfloat *value, 
		    gfloat lower, gfloat upper, gchar *lower_text, 
		    gchar *upper_text, gchar *onoff, gfloat offvalue)
{
  GtkObject *adj;
  GtkWidget *frame, *hscale, *hbox, *label, *align, *align2, *check;
  GtkWidget *label2, *w;
  gfloat *offval;
  
  if (!text)
    return NULL;
  
  frame = gtk_frame_new(text);
  gtk_widget_show(frame);
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), frame);

  w = align;
  
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  hbox = gtk_hbox_new(FALSE, 2);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(align), hbox);
  
  check = gtk_check_button_new();
  gtk_widget_show(check);
  align2 = gtk_alignment_new(1.0, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), check);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);

  if (onoff)
    {
      if (*onoff)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 1);
      else
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 0);
    }
  else
    {
      if (*value == offvalue)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 0);
      else
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 1);
    }
  
  adj = gtk_adjustment_new(*value, lower, upper, 0.1, .1, 0.1);
  hscale = gtk_hscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_show(hscale);
  
  gtk_signal_connect(GTK_OBJECT(check), "toggled",
		     GTK_SIGNAL_FUNC(e_cb_rangeonoff_toggle), (gpointer)hscale);
  
  label = gtk_label_new(lower_text);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		     GTK_SIGNAL_FUNC(e_cb_range), (gpointer)hscale);
  gtk_object_set_data(GTK_OBJECT(hscale), "adj", (gpointer)adj);
  gtk_object_set_data(GTK_OBJECT(hscale), "value", (gpointer)value);  
  gtk_object_set_data(GTK_OBJECT(hscale), "capplet", (gpointer)current_capplet);  
  gtk_object_set_data(GTK_OBJECT(hscale), "onoff", (gpointer)onoff);
  gtk_object_set_data(GTK_OBJECT(hscale), "l1", (gpointer)label);
  offval = g_malloc(sizeof(gfloat));
  *offval = offvalue;
  gtk_object_set_data(GTK_OBJECT(hscale), "offvalue", (gpointer)offval);
  
  gtk_box_pack_start(GTK_BOX(hbox), hscale, TRUE, TRUE, 0);
  label2 = label = gtk_label_new(upper_text);
  gtk_object_set_data(GTK_OBJECT(hscale), "l2", (gpointer)label);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  if (GTK_TOGGLE_BUTTON(check)->active)
    {
      gtk_widget_set_sensitive(label, TRUE);
      gtk_widget_set_sensitive(hscale, TRUE);
      gtk_widget_set_sensitive(label2, TRUE);
    }
  else
    {
      gtk_widget_set_sensitive(label, FALSE);
      gtk_widget_set_sensitive(hscale, FALSE);
      gtk_widget_set_sensitive(label2, FALSE);
    }
  return w;
}


#include "screen.xpm"

static void
e_cb_area_redraw(GtkWidget *widget, gpointer data)
{
  GdkWindow          *win;
  GtkStyle           *s;
  gint                i, j, x, y, w, h, ww, hh;
  GdkImlibImage      *im = NULL;
  GdkImlibBorder      border = {4, 4, 4, 13};
  gchar               str[1024];
  GtkWidget          *label, *table;
  
  win = widget->window;
  s = widget->style;
  gdk_window_get_size(win, &ww, &hh);
  
  ww -= 40;
  hh -= 30;
  
  if (!im)
    {
      im            = gdk_imlib_create_image_from_xpm_data(screen_xpm);
      gdk_imlib_set_image_border(im, &border);
    }
  gdk_window_clear(win);
  w = 20;
  h = 15;
  if (e_opt_area_height > e_opt_area_width)
    {
      w = ww / (gint)e_opt_area_height;
      h = hh / (gint)e_opt_area_height;
    }
  else
    {
      w = ww / (gint)e_opt_area_width;
      h = hh / (gint)e_opt_area_width;
    }
  for(j = 0; j < (gint)e_opt_area_height; j++)
    {
      for(i = 0; i < (gint)e_opt_area_width; i++)
	{
	  x = 20 + (i * w);
	  y = 15 + (j * h);
	  gtk_draw_box(s, win, GTK_STATE_ACTIVE, GTK_SHADOW_OUT, x, y, w, h);
	}
    }
  x = 20;
  y = 15;
  gdk_imlib_paste_image(im, win, x - 4, y - 4, w + 8, h + 17);
  
  label = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "label");
  table = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "table");
  g_snprintf(str, sizeof(str),
	     "The virutal desktop size will be\n"
	     "%1.0f x %1.0f\n"
	     "screens in size",
	     e_opt_area_width, e_opt_area_height);
  gtk_label_set_text(GTK_LABEL(label), str);
  /* DAMNIT ! REDRAW YOU DAMN WIDGET (still doesn't help) */
  gtk_widget_draw(label, NULL);
}

static void
e_cb_desk_redraw(GtkWidget *widget, gpointer data)
{
  GdkWindow          *win;
  GtkStyle           *s;
  gint                i, x, y, w, h, ww, hh, tw, th, dummy, ascent, descent;
  gchar               str[1024];
  
  win = widget->window;
  s = widget->style;
  gdk_window_get_size(win, &ww, &hh);
  
  ww -= 4;
  hh -= 4;
  
  gdk_window_clear(win);
  w = ww - ((e_opt_number_of_desks - 1) * 3);
  h = hh - ((e_opt_number_of_desks - 1) * 3);
  for(i = (gint)e_opt_number_of_desks - 1; i >= 0; i--)
    {
      x = 2 + (i * 3);
      y = 2 + (i * 3);
      gtk_draw_box(s, win, GTK_STATE_ACTIVE, GTK_SHADOW_OUT, x, y, w, h);
    }
  if (e_opt_number_of_desks < 2.0)
    g_snprintf(str, sizeof(str), "%1.0f Desktop", e_opt_number_of_desks);
  else
    g_snprintf(str, sizeof(str), "%1.0f Desktops", e_opt_number_of_desks);
  gdk_text_extents(s->font, str, strlen(str), &dummy, &dummy, &tw,
		   &ascent, &descent);
  x = 2 + ((ww - tw) / 2);
  y = 2 + ((hh - (ascent + descent)) / 2) + ascent;			
  gtk_draw_box(s, win, GTK_STATE_NORMAL, GTK_SHADOW_IN, 
	       x - 3, y - 3 - ascent, tw + 6, ascent + descent + 6);
  gtk_draw_string(s, win, GTK_STATE_NORMAL, x, y, str);
}

static void
e_cb_area_range(GtkWidget *widget, gpointer data)
{
  GtkWidget          *c;
  GtkWidget          *w;
  GtkAdjustment      *adj;
  gfloat             *value;
  
  w = GTK_WIDGET(data);
  adj = GTK_OBJECT(widget);
  c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(adj), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  value = (gfloat *)gtk_object_get_data(GTK_OBJECT(adj), "value");
  *value = adj->value;
  e_cb_area_redraw(w, NULL);
}

static void
e_cb_desk_range(GtkWidget *widget, gpointer data)
{
  GtkWidget          *c;
  GtkWidget          *w;
  GtkAdjustment      *adj;
  gfloat             *value;
  
  w = GTK_WIDGET(data);
  adj = GTK_OBJECT(widget);
  c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(adj), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  value = (gfloat *)gtk_object_get_data(GTK_OBJECT(adj), "value");
  *value = adj->value;
  e_cb_desk_redraw(w, NULL);
}

static GtkWidget *
e_areas_config(void)
{
  GtkWidget *table, *range, *frame, *area, *label, *window;
  GtkObject *adj;
  
  table = gtk_table_new(1,1, FALSE);
  gtk_widget_show(table);
  
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_widget_show(frame);
  gtk_table_attach_defaults(GTK_TABLE(table), frame, 1, 10, 1, 10);
  
  area = gtk_drawing_area_new();
  gtk_widget_show(area);
  gtk_drawing_area_size(GTK_DRAWING_AREA(area), 200, 160);
  gtk_widget_set_usize(area, 200, 160);
  gtk_container_add(GTK_CONTAINER(frame), area);
  gtk_signal_connect(GTK_OBJECT(area), "expose_event",
		     GTK_SIGNAL_FUNC(e_cb_area_redraw), NULL);
  
  adj = gtk_adjustment_new(e_opt_area_width, 1.0, 9.0, 1.0, 1.0, 1.0);
  range = gtk_hscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_set_usize(range, 200, -1);
  gtk_object_set_data(GTK_OBJECT(adj), "capplet", current_capplet);
  gtk_object_set_data(GTK_OBJECT(adj), "value", &e_opt_area_width);
  gtk_scale_set_digits(GTK_SCALE(range), 0);
  gtk_widget_show(range);
  gtk_table_attach_defaults(GTK_TABLE(table), range, 1, 10, 0, 1);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		      GTK_SIGNAL_FUNC(e_cb_area_range), (gpointer)area);
  
  adj = gtk_adjustment_new(e_opt_area_height,1.0, 9.0, 1.0, 1.0, 1.0);
  range = gtk_vscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_set_usize(range, -1, 150);
  gtk_object_set_data(GTK_OBJECT(adj), "capplet", current_capplet);
  gtk_object_set_data(GTK_OBJECT(adj), "value", &e_opt_area_height);
  gtk_scale_set_digits(GTK_SCALE(range), 0);
  gtk_widget_show(range);
  gtk_table_attach_defaults(GTK_TABLE(table), range, 0, 1, 1, 10);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		     GTK_SIGNAL_FUNC(e_cb_area_range), (gpointer)area);
/*
 * window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 * gtk_widget_show(window);
 */
  
  label = gtk_label_new(".\n.\n.");
  gtk_widget_show(label);
/*  gtk_container_add(GTK_CONTAINER(window), label);*/
  gtk_table_attach_defaults(GTK_TABLE(table), label, 1, 10, 10, 11);
  
  gtk_object_set_data(GTK_OBJECT(area), "label", label);
  gtk_object_set_data(GTK_OBJECT(area), "table", table);
  return table;
}

static GtkWidget *
e_desktops_config(void)
{
  GtkWidget *table, *range, *frame, *area, *label, *window;
  GtkObject *adj;

  table = gtk_table_new(1,1, FALSE);
  gtk_widget_show(table);
  
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_widget_show(frame);
  gtk_table_attach_defaults(GTK_TABLE(table), frame, 1, 10, 1, 10);
  
  area = gtk_drawing_area_new();
  gtk_widget_show(area);
  gtk_drawing_area_size(GTK_DRAWING_AREA(area), 153, 138);
  gtk_widget_set_usize(area, 153, 138);
  gtk_container_add(GTK_CONTAINER(frame), area);
  gtk_signal_connect(GTK_OBJECT(area), "expose_event",
		     GTK_SIGNAL_FUNC(e_cb_desk_redraw), NULL);
  
  adj = gtk_adjustment_new(e_opt_number_of_desks, 1.0, 33.0, 1.0, 1.0, 1.0);
  range = gtk_vscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_set_usize(range, -1, 138);
  gtk_object_set_data(GTK_OBJECT(adj), "capplet", current_capplet);
  gtk_object_set_data(GTK_OBJECT(adj), "value", &e_opt_number_of_desks);
  gtk_scale_set_digits(GTK_SCALE(range), 0);
  gtk_widget_show(range);
  gtk_table_attach_defaults(GTK_TABLE(table), range, 0, 1, 1, 10);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		      GTK_SIGNAL_FUNC(e_cb_desk_range), (gpointer)area);
  label = gtk_label_new("The number of separate desktops\n"
			"layered on top of eachother");
  gtk_widget_show(label);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 10, 10, 11);
  
  return table;
}

#include "move_box.xpm"
#include "move_lined.xpm"
#include "move_opaque.xpm"
#include "move_semi-solid.xpm"
#include "move_shaded.xpm"
#include "move_translucent.xpm"

#include "resize_box.xpm"
#include "resize_lined.xpm"
#include "resize_opaque.xpm"
#include "resize_semi-solid.xpm"
#include "resize_shaded.xpm"

#include "focus_click.xpm"
#include "focus_sloppy.xpm"
#include "focus_pointer.xpm"

/* Pane for focus & display */
static GtkWidget *
__setup_pane_1(void)
{
  GtkWidget *frame, *frame2, *hbox, *vbox, *w;
  IconOption move_options[] = 
    {
	{"Opaque", move_opaque_xpm, 
	  "Windows are moved in a solid fashion"},
	{"Lined", move_lined_xpm, 
	  "Windows are moved by drawing construction lines around them"},
	{"Box", move_box_xpm, 
	  "Windows are moved by drawing a box as their outline"},
	{"Shaded", move_shaded_xpm, 
	  "Windows are moved by drawing a stippled outline of them"},
	{"Semi-Solid", move_semi_solid_xpm, 
	  "Windows are moved by drawing a chequered outline of them"},
	{"Translucent", move_translucent_xpm, 
	  "Windows are moved by drawing a translucent copy of the window"}
    };
  IconOption resize_options[] = 
    {
	{"Opaque", resize_opaque_xpm, 
	  "Windows are resized as you drag"},
	{"Lined", resize_lined_xpm, 
	  "Windows get resized by displaying construction lines around them"},
	{"Box", resize_box_xpm, 
	  "Windows are resized by drawing a box as their outline"},
	{"Shaded", resize_shaded_xpm, 
	  "windows are resized by drawing a stippled outline of them"},
	{"Semi-Solid", resize_semi_solid_xpm, 
	  "Windows are resized by drawing a chequered outline of them"}
    };
  IconOption focus_options[] = 
    {
	{"Mouse Pointer", focus_pointer_xpm, 
	  "Your keypresses are sent to whatever window your mouse is over at the time"},
	{"Sloppy Pointer", focus_sloppy_xpm, 
	  "Your keypresses are sent to the window your mouse was over last, if any"},
	{"Pointer Clicks", focus_click_xpm, 
	  "You keypresses are sent to the window you last clicked on"},
    };
  vbox = gtk_vbox_new (FALSE, 1);
  
  w = e_create_icon_option(_("Move Methods"), &e_opt_move, 
			   6, 6, move_options);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_icon_option(_("Resize Methods"), &e_opt_resize, 
			   6, 5, resize_options);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_icon_option(_("Keyboard focus follows"), &e_opt_focus, 
			   6, 3, focus_options);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);
  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for special effects */
static GtkWidget *
__setup_pane_2(void)
{
  GtkWidget *frame, *frame2, *hbox, *vbox, *w;
  IconOption slide_options[] = 
    {
	{"Opaque", move_opaque_xpm, 
	  "Windows are slid in a solid fashion"},
	{"Lined", move_lined_xpm, 
	  "Windows are slid by drawing construction lines around them"},
	{"Box", move_box_xpm, 
	  "Windows are slid by drawing a box as their outline"},
	{"Shaded", move_shaded_xpm, 
	  "Windows are slid by drawing a stippled outline of them"},
	{"Semi-Solid", move_semi_solid_xpm, 
	  "Windows are slid by drawing a chequered outline of them"},
    };
  
  vbox = gtk_vbox_new (FALSE, 1);
  w = e_create_icon_option(_("Window Sliding Methods"), &e_opt_slide_mode, 
			   6, 5, slide_options);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  w = e_create_rangeonoff(_("Windows slide in when they appear"),
			  &e_opt_map_speed,
			  16.0, 20000.0, 
			  _("-"), _("+"), 
			  &e_opt_slide_map, 0.0);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_rangeonoff(_("Windows slide about when cleanup in progress"),
			  &e_opt_cleanup_speed,
			  16.0, 20000.0, 
			  _("-"), _("+"), 
			  &e_opt_slide_cleanup, 0.0);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_rangeonoff(_("Desktops slide in when changed"),
			  &e_opt_desk_speed,
			  16.0, 20000.0, 
			  _("-"), _("+"), 
			  &e_opt_slide_desk, 0.0);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_onoff(_("Animate menus"), &e_opt_menuslide);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);

  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for behavior */
static GtkWidget *
__setup_pane_3(void)
{
  GtkWidget *vbox, *w;
  
  vbox = gtk_vbox_new (FALSE, 1);
  w = e_create_rangeonoff(_("Use tooltips & timeout (sec)"),
			  &e_opt_tooltiptime,
			  0.0, 10.0, 
			  _("-"), _("+"), 
			  &e_opt_tooltips, 0.0);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  w = e_create_rangeonoff(_("Window shading speed (pixels / sec)"),
			  &e_opt_shade_speed,
			  16.0, 20000.0, 
			  _("-"), _("+"), 
			  NULL, 99999.0);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_rangeonoff(_("Automatic raising of windows after X seconds"),
			  &e_opt_autoraisetime,
			  0.0, 10.0,
			  _("-"), _("+"), 
			  e_opt_autorase, 0.0);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_onoff(_("Reduce refresh by using memory (use saveunders)"), 
		     &e_opt_saveunders);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  w = e_create_onoff(_("Display icons when windows are iconified"), 
		     &e_opt_show_icons);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  w = e_create_onoff(_("Transient popup windows appear together with leader"), 
		     &e_opt_transients_follow_leader);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  w = e_create_onoff(_("Switch to where popup windo appears"), 
		     &e_opt_switch_for_transient_map);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  

  gtk_widget_show(vbox);
  return vbox;
}


/* Pane for desktops */
static GtkWidget *
__setup_pane_4(void)
{
  GtkWidget *hbox, *vbox, *w, *frame, *align;
  
  hbox = gtk_hbox_new (FALSE, 1);

  frame = gtk_frame_new(_("Size of Virtual Screen"));
  gtk_widget_show(frame);
  align = gtk_alignment_new(0.5, 0.0, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  gtk_box_pack_start (GTK_BOX(hbox), frame, TRUE, TRUE, 1);  
  vbox = gtk_vbox_new (FALSE, 1);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(align), vbox);
  
  w = e_areas_config();
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  
  frame = gtk_frame_new(_("Separate Desktops"));
  gtk_widget_show(frame);
  align = gtk_alignment_new(0.5, 0.0, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  gtk_box_pack_start (GTK_BOX(hbox), frame, TRUE, TRUE, 1);  
  vbox = gtk_vbox_new (FALSE, 1);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(align), vbox);

  w = e_desktops_config();
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  
  gtk_widget_show(hbox);
  return hbox;
}

/* Pane for backgrounds */
static GtkWidget *
__setup_pane_5(void)
{
  GtkWidget *hbox, *w, *scrolled_win, *list, *frame, *area, *table, *label;
  GtkWidget *button, *om, *m, *mi, *arrow, *vbox;
  gchar s[256];
  gint i;
  
  hbox = gtk_hbox_new (FALSE, 1);
  
  scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show(scrolled_win);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(scrolled_win, 180, -1);
  gtk_box_pack_start (GTK_BOX (hbox), scrolled_win, FALSE, FALSE, 0);
  
  vbox = gtk_vbox_new (FALSE, 1);
  gtk_widget_show(vbox);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 0);
  
  table = gtk_table_new(1, 1, FALSE);
  gtk_widget_show(table);
  gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, FALSE, 0);
  
  label = gtk_label_new(_("Select a background on the left\n"
			  "to apply to the current active desktop\n"
			  "below, or select \"None\"."));
  gtk_widget_show(label);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 12, 0, 1);

  m = gtk_menu_new();
  gtk_widget_show(m);

  for (i = 0; i < (gint)e_opt_number_of_desks; i++)
    {
      g_snprintf(s, sizeof(s), "%i", i);
      mi = gtk_menu_item_new_with_label(s);
      gtk_widget_show(mi);
      /*  
       gtk_object_set_data(GTK_OBJECT(mi), "value", (gpointer)i);
       gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer)current_capplet);  
       gtk_signal_connect(GTK_OBJECT(mi),
			  "activate", GTK_SIGNAL_FUNC(e_cb_multi),
			  (gpointer)value);
       */ 
      gtk_menu_append(GTK_MENU(m), mi);
    }
  
  om = gtk_option_menu_new();
  gtk_widget_show(om);
  gtk_option_menu_set_menu(GTK_OPTION_MENU(om), m);
  gtk_option_menu_set_history(GTK_OPTION_MENU(om), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), om, 11, 12, 2, 3);
  
  label = gtk_label_new(_("Desktop"));
  gtk_widget_show(label);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 10, 11, 2, 3);

  button = gtk_button_new();
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 11, 12, 1, 2);  
  arrow = gtk_arrow_new(GTK_ARROW_UP, GTK_SHADOW_IN);
  gtk_widget_show(arrow);
  gtk_container_add(GTK_CONTAINER(button), arrow);

  button = gtk_button_new();
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 11, 12, 3, 4);  
  arrow = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_IN);
  gtk_widget_show(arrow);
  gtk_container_add(GTK_CONTAINER(button), arrow);
  
  button = gtk_button_new_with_label(_("None"));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 1, 11, 12);  

  button = gtk_button_new_with_label(_("New"));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 1, 2, 11, 12);  
  
  button = gtk_button_new_with_label(_("Delete"));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 11, 12);  
  
  button = gtk_button_new_with_label(_("Apply modifications"));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 10, 12, 11, 12);  

  
  button = gtk_button_new_with_label(_("Test"));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 12, 13);    
  button = gtk_button_new_with_label(_("Test"));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 13, 14);    
  button = gtk_button_new_with_label(_("Test"));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 14, 15);    
  button = gtk_button_new_with_label(_("Test"));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 15, 16);    
  button = gtk_button_new_with_label(_("Test"));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 16, 17);    
  
  frame = gtk_frame_new(NULL);
  gtk_widget_show(frame);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_table_attach_defaults(GTK_TABLE(table), frame, 0, 10, 1, 11);  
  
  area = gtk_drawing_area_new();
  gtk_widget_show(area);
  gtk_drawing_area_size(GTK_DRAWING_AREA(area), 128, 96);
  gtk_widget_set_usize(area, 128, 96);
  gtk_container_add(GTK_CONTAINER(frame), area);
  
  list = gtk_table_new(0, 0, FALSE);
  gtk_widget_show(list);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), 
					list);
  if (backgrounds)
    {
      gchar s[4096];
      int i, j, la, ra, ta, ba;
      GList *ptr;
      
      j = g_list_length(backgrounds);

      g_snprintf(s, sizeof(s), "%s/.e-conf", getenv("HOME"));
      mkdir(s, S_IRWXU);
      ptr = backgrounds;
      for (i = 0; ((i < j) && (ptr)); i++)
	{
	  Background *bg = NULL;
	  GdkPixmap *pmap;
	  GtkWidget *l_hb, *l_label, *l_pixmap, *l_item;
	  GdkImlibImage *im;
	  
	  if (progress)
	    {
	      gtk_progress_bar_update(GTK_PROGRESS_BAR(progress),
				      (gfloat)i / (gfloat)j);
	      gtk_widget_draw(progress, NULL);
	    }
	  pmap = gdk_pixmap_new(current_capplet->window, 64, 48, -1);
	  bg = ptr->data;
	  ptr = ptr->next;
	  if (bg)
	    {
	      g_snprintf(s, sizeof(s), "%s/.e-conf/%s", getenv("HOME"), bg->name);
	      im = gdk_imlib_load_image(s);
	      if (!im)
		{
		  e_render_bg_onto(pmap, bg);
		  im = gdk_imlib_create_image_from_drawable(pmap, NULL, 0, 0,
							    64, 48);
		  if (im)
		    {
		      gdk_imlib_save_image_to_ppm(im, s);
		      gdk_imlib_kill_image(im);
		    }
		}
	      else
		{
		  gdk_imlib_paste_image(im, pmap, 0, 0, 64, 48);
		  gdk_imlib_destroy_image(im);
		}
	    }
	  l_item = gtk_button_new();
	  gtk_object_set_data(GTK_OBJECT(l_item), "bg", bg);
	  gtk_object_set_data(GTK_OBJECT(l_item), "capplet", (gpointer)current_capplet);  
	  gtk_widget_show(l_item);
	  l_hb = gtk_hbox_new(FALSE, 1);
	  gtk_container_set_border_width(GTK_CONTAINER(l_hb), 1);
	  gtk_widget_show(l_hb);
	  gtk_container_add(GTK_CONTAINER(l_item), l_hb);
	  l_pixmap = gtk_pixmap_new(pmap, NULL);
	  gtk_widget_show(l_pixmap);
	  gtk_box_pack_start(GTK_BOX(l_hb), l_pixmap, FALSE, FALSE, 0);
/*	  
	  gtk_signal_connect(GTK_OBJECT(l_item), "clicked",
			     GTK_SIGNAL_FUNC(e_cb_bg_sel), NULL);
 */
	  gdk_pixmap_unref(pmap);
	  la = i / 80;
	  ra = la + 1;
	  ta = i % 80;
	  ba = ta + 1;
	  gtk_table_attach_defaults(GTK_TABLE(list), l_item, la, ra, ta, ba);
	}
    }
  gtk_widget_show(hbox);
  return hbox;
}

/* Pane for audio */
static GtkWidget *
__setup_pane_6(void)
{
  GtkWidget *vbox, *w;
  
  vbox = gtk_vbox_new (FALSE, 1);
  w = e_create_onoff(_("Enable sounds in Enlightenment"), 
		     &e_opt_sound);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  
  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for fonts */
static GtkWidget *
__setup_pane_7(void)
{
  GtkWidget *vbox, *w;
  
  vbox = gtk_vbox_new (FALSE, 1);
  w = gtk_label_new("This page is intentionally blank.\n"
		    "\n"
		    "Widgets will be filled in here shortly");
  gtk_widget_show(w);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  
  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for colours */
static GtkWidget *
__setup_pane_8(void)
{
  GtkWidget *vbox, *w;
  
  vbox = gtk_vbox_new (FALSE, 1);
  w = gtk_label_new("This page is intentionally blank.\n"
		    "\n"
		    "Widgets will be filled in here shortly");
  gtk_widget_show(w);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  
  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for cursors */
static GtkWidget *
__setup_pane_9(void)
{
  GtkWidget *vbox, *w;
  
  vbox = gtk_vbox_new (FALSE, 1);
  w = gtk_label_new("This page is intentionally blank.\n"
		    "\n"
		    "Widgets will be filled in here shortly");
  gtk_widget_show(w);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  
  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for window matches */
static GtkWidget *
__setup_pane_10(void)
{
  GtkWidget *vbox, *w;
  
  vbox = gtk_vbox_new (FALSE, 1);
  w = gtk_label_new("This page is intentionally blank.\n"
		    "\n"
		    "Widgets will be filled in here shortly");
  gtk_widget_show(w);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  
  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for menus */
static GtkWidget *
__setup_pane_11(void)
{
  GtkWidget *vbox, *w;
  
  vbox = gtk_vbox_new (FALSE, 1);
  w = gtk_label_new("This page is intentionally blank.\n"
		    "\n"
		    "Widgets will be filled in here shortly");
  gtk_widget_show(w);
  gtk_box_pack_start (GTK_BOX(vbox), w, FALSE, FALSE, 1);  
  
  gtk_widget_show(vbox);
  return vbox;
}

void
e_cb_list_click(GtkWidget *widget, gint num)
{
  GtkWidget *note;
  
  note = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "note");
  gtk_notebook_set_page(GTK_NOTEBOOK(note), num);
}

#include "focus_and_display.xpm"
#include "e_logo.xpm"

static void
e_setup (GtkWidget *c)
{
  GtkWidget *frame, *frame2, *hbox, *vbox, *note, *w, *label, *list;
  GtkWidget *scrolled_win, *pixmap, *tip;
  GdkPixmap *pmap, *mask;
  gchar     *line[1] = {""};

  current_capplet = c;
  
  hbox = gtk_hbox_new (FALSE, 1);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (c), hbox);
  
  note = gtk_notebook_new();
  gtk_widget_show(note);
  gtk_notebook_set_show_border(GTK_NOTEBOOK(note), FALSE);
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(note), FALSE);
  
  w = __setup_pane_1(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  w = __setup_pane_2(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  w = __setup_pane_3(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  w = __setup_pane_4(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  w = __setup_pane_5(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  w = __setup_pane_6(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  w = __setup_pane_7(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  w = __setup_pane_8(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  w = __setup_pane_9(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  w = __setup_pane_10(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  w = __setup_pane_11(); scrolled_win = gtk_scrolled_window_new (NULL, NULL); gtk_widget_show(scrolled_win); gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_NEVER, GTK_POLICY_NEVER); gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), w); gtk_notebook_append_page(GTK_NOTEBOOK(note), scrolled_win, NULL);
  
  vbox = gtk_vbox_new (FALSE, 1);
  gtk_widget_show (vbox);
  gtk_box_pack_start (GTK_BOX(hbox), vbox, FALSE, FALSE, 0);
  
  scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show(scrolled_win);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(scrolled_win, 140, 141);
  gtk_box_pack_start (GTK_BOX (vbox), scrolled_win, FALSE, FALSE, 0);
  
  gdk_imlib_data_to_pixmap(e_logo_xpm, &pmap, &mask);
  pixmap = gtk_pixmap_new(pmap, mask);
  gtk_widget_show(pixmap);
  gtk_box_pack_start (GTK_BOX (vbox), pixmap, TRUE, TRUE, 0);
  list = gtk_clist_new(1);
  gtk_clist_set_row_height(GTK_CLIST(list), 16);

  gtk_object_set_data(GTK_OBJECT(list), "note", note);
  
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 0, 0, 
			"Focus & Display", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 1, 0, 
			"Special FX", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 2, 0, 
			"Behavior", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 3, 0, 
			"Desktops", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 4, 0, 
			"Backgrounds", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 5, 0, 
			"Audio", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 6, 0, 
			"Fonts", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 7, 0, 
			"Colours", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 8, 0, 
			"Mouse Cursors", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 9, 0, 
			"Borders", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 10, 0, 
			"Menus", 1, pmap, mask);
  
  gtk_clist_columns_autosize(GTK_CLIST(list));  
  gtk_clist_select_row(GTK_CLIST(list), 0, 0);  
  gtk_widget_show(list);
  gtk_container_add (GTK_CONTAINER (scrolled_win), list);
  
  gtk_signal_connect(GTK_OBJECT(list), "select_row", 
		     GTK_SIGNAL_FUNC(e_cb_list_click), note);
  
  gtk_box_pack_start (GTK_BOX (hbox), note, FALSE, FALSE, 0);
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
}

static void
e_cb_bg_display(GtkWidget *widget, gint num)
{
  Background *bg = NULL;
  GdkPixmap *pmap;
  GtkWidget *area;
  gint d;
    
  if (!(GTK_TOGGLE_BUTTON(widget)->active))
    return;
  area = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "area");
  d = (gint)gtk_object_get_data(GTK_OBJECT(widget), "desk");
  curdesk = d;
  pmap = gdk_pixmap_new(area->window, 128, 96, -1);
  gdk_window_set_back_pixmap(area->window, pmap, FALSE);
  gdk_flush();
  if (deskbg[d])
    e_render_bg_onto(pmap, deskbg[d]);
  gdk_window_clear(area->window);
  gdk_pixmap_unref(pmap);
  widget = NULL;
}

static void
e_cb_bg_sel(GtkWidget *widget, gpointer data)
{
  Background *bg;
  GtkWidget *c;

  bg = (Background *)gtk_object_get_data(GTK_OBJECT(widget), "bg");  
  if (!bg)
    return;
  if (bg != deskbg[curdesk])
    {
      c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "capplet");
      capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
      deskbg[curdesk] = bg;
      e_cb_bg_display(deskbt[curdesk], curdesk);
    }
}

static void
e_cb_bt_update(gint n)
{
  gint i;
  GtkWidget *bt;
  
  for (i = 0; i < 32; i ++)
    {
      bt = deskbt[i];
      if (i < (gint)e_opt_number_of_desks)
	gtk_widget_set_sensitive(bt, TRUE);
      else
	gtk_widget_set_sensitive(bt, FALSE);      
    }
}

static void
e_setup_desktops (GtkWidget *c)
{
  GtkWidget *frame, *frame2, *hbox, *align, *border, *area, *bar, *win;
  GtkWidget *table, *bt, *list;
  GList *btl = NULL;
  gint i, j;
  
  current_capplet = c;
  hbox = gtk_hbox_new (FALSE, GNOME_PAD_SMALL);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (c), hbox);
    
  frame = e_create_frame (_("Desktop Options"));
  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);

  e_add_step_range_to_frame_with_cb(frame, _("Number of Desktops"), 
				    &e_opt_number_of_desks, 1.0, 33.0, 
				    _("Fewer"), _("More"), 1.0,
				    e_cb_bt_update);
  
  e_add_step_range_to_frame(frame, _("Screens Across for Areas"), 
			    &e_opt_area_width, 1.0, 9.0, 
			    _("Thinner"), _("Wider"), 1.0);
  
  e_add_step_range_to_frame(frame, _("Screens Down for Areas"), 
			    &e_opt_area_height, 1.0, 9.0, 
			    _("Shorter"), _("Taller"), 1.0);
  
  frame2 = e_create_frame (_("Background Definitions"));
  e_add_widget_to_frame(frame, frame2);
  
  bar = gtk_toolbar_new  (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_TEXT);
  gtk_widget_show(bar);
  e_add_widget_to_frame(frame2, bar);
  gtk_toolbar_append_item(GTK_TOOLBAR(bar), _("New"),
			  _("Create a new background definition"), NULL,
			  NULL, 
			  NULL, NULL);
  gtk_toolbar_append_item(GTK_TOOLBAR(bar), _("Clone"),
			  _("Create a new background definition"), NULL,
			  NULL, 
			  NULL, NULL);
  gtk_toolbar_append_item(GTK_TOOLBAR(bar), _("Edit"),
			  _("Create a new background definition"), NULL,
			  NULL, 
			  NULL, NULL);
  gtk_toolbar_append_item(GTK_TOOLBAR(bar), _("Remove"),
			  _("Create a new background definition"), NULL,
			  NULL, 
			  NULL, NULL);
  win = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(win);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(win),
				 GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
  gtk_widget_realize(c);
  list = gtk_table_new(0, 0, FALSE) ;
  gtk_widget_show(list);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(win), list);
  gtk_widget_realize(c);
  if (backgrounds)
    {
      gchar s[4096];
      int la, ra, ta, ba;
      GList *ptr;
      
      j = g_list_length(backgrounds);

      g_snprintf(s, sizeof(s), "%s/.e-conf", getenv("HOME"));
      mkdir(s, S_IRWXU);
      ptr = backgrounds;
      for (i = 0; ((i < j) && (ptr)); i++)
	{
	  Background *bg = NULL;
	  GdkPixmap *pmap;
	  GtkWidget *l_hb, *l_label, *l_pixmap, *l_item;
	  GdkImlibImage *im;
	  
	  pmap = gdk_pixmap_new(c->window, 64, 48, -1);
	  bg = ptr->data;
	  ptr = ptr->next;
	  if (bg)
	    {
	      g_snprintf(s, sizeof(s), "%s/.e-conf/%s", getenv("HOME"), bg->name);
	      im = gdk_imlib_load_image(s);
	      if (!im)
		{
		  e_render_bg_onto(pmap, bg);
		  im = gdk_imlib_create_image_from_drawable(pmap, NULL, 0, 0,
							    64, 48);
		  if (im)
		    {
		      gdk_imlib_save_image_to_ppm(im, s);
		      gdk_imlib_kill_image(im);
		    }
		}
	      else
		{
		  gdk_imlib_paste_image(im, pmap, 0, 0, 64, 48);
		  gdk_imlib_destroy_image(im);
		}
	    }
	  l_item = gtk_button_new();
	  gtk_object_set_data(GTK_OBJECT(l_item), "bg", bg);
	  gtk_object_set_data(GTK_OBJECT(l_item), "capplet", (gpointer)current_capplet);  
	  gtk_widget_show(l_item);
	  l_hb = gtk_hbox_new(FALSE, 1);
	  gtk_container_set_border_width(GTK_CONTAINER(l_hb), 1);
	  gtk_widget_show(l_hb);
	  gtk_container_add(GTK_CONTAINER(l_item), l_hb);
	  l_pixmap = gtk_pixmap_new(pmap, NULL);
	  gtk_widget_show(l_pixmap);
	  gtk_box_pack_start(GTK_BOX(l_hb), l_pixmap, FALSE, FALSE, 0);
/*	  
	  l_label = gtk_label_new(_("Memory required:\n4 Mb"));
	  gtk_widget_show(l_label);
	  gtk_box_pack_start(GTK_BOX(l_hb), l_label, FALSE, FALSE, 2);
 */
	  gtk_signal_connect(GTK_OBJECT(l_item), "clicked",
			     GTK_SIGNAL_FUNC(e_cb_bg_sel), NULL);	  
	  gdk_pixmap_unref(pmap);
	  la = i / 80;
	  ra = la + 1;
	  ta = i % 80;
	  ba = ta + 1;
	  gtk_table_attach_defaults(GTK_TABLE(list), l_item, la, ra, ta, ba);
	}
    }
  align = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
  gtk_widget_set_usize(win, 270, 140);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), win);
  e_add_widget_to_frame(frame2, align);

  e_add_onoff_to_frame(frame, _("High quality rendering for backgrounds"), &e_opt_hq_background);
  e_add_rangeonoff_to_frame(frame,
			    _("Minutes to keep backgrounds in memory"),
			    &e_opt_desktop_bg_timeout,
			    0.0, 60.0, 
			    _("Sooner"), _("Later"), 
			    NULL, 0.0);
  
  frame = e_create_frame (_("Preview"));
  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);

  border = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(border), GTK_SHADOW_IN);
  gtk_widget_show(border);
  align = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), border);
  area = gtk_drawing_area_new();
  gtk_widget_show(area);
  gtk_widget_set_usize(area, 128, 96);
  gtk_container_add(GTK_CONTAINER(border), area);
  e_add_widget_to_frame(frame, align);
  
  frame2 = e_create_frame (_("Desktop"));
  e_add_widget_to_frame(frame, frame2);
  table = gtk_table_new(1, 1, TRUE);
  gtk_widget_show(table);
  for (i = 0; i < 4; i++)
    {
      for (j = 0; j < 8; j++)
	{
	  char s[32];
	  
	  g_snprintf(s, sizeof(s), "%i", (i * 8) + j);
	  bt = gtk_radio_button_new_with_label(btl, s);
	  gtk_widget_show(bt);
	  GTK_TOGGLE_BUTTON(bt)->draw_indicator = 0;
	  btl = g_list_append(btl, bt);
	  gtk_table_attach_defaults(GTK_TABLE(table), bt, j, j + 1, i, i + 1);
	  gtk_object_set_data(GTK_OBJECT(bt), "desk", (gpointer)((i * 8) + j));
	  gtk_object_set_data(GTK_OBJECT(bt), "area", area);
	  gtk_signal_connect(GTK_OBJECT(bt), "toggled",
		     GTK_SIGNAL_FUNC(e_cb_bg_display), (gpointer)((i * 8) + j));
	  deskbt[(i * 8) + j] = bt;
	}
    }
  for (i = 0; i < 32; i ++)
    {
      bt = (GtkWidget *)((g_list_nth(btl, i))->data);
      if (i < (gint)e_opt_number_of_desks)
	gtk_widget_set_sensitive(bt, TRUE);
      else
	gtk_widget_set_sensitive(bt, FALSE);      
    }
  e_add_widget_to_frame(frame2, table);
  gtk_widget_realize(area);

  e_cb_bg_display(deskbt[curdesk], curdesk);
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
}

static void
e_setup_fonts (GtkWidget *c)
{
}

static void
e_setup_sound (GtkWidget *c)
{
  GtkWidget *frame, *frame2, *hbox;
  
  current_capplet = c;
  hbox = gtk_hbox_new (FALSE, GNOME_PAD_SMALL);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (c), hbox);
    
  frame = e_create_frame (_("Options"));
  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);

  e_add_onoff_to_frame(frame, _("Sound Effects"), &e_opt_sound);

  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
}

static void
e_setup_colors (GtkWidget *c)
{
}

void 
e_setup_multi(GtkWidget *old, GtkWidget *c)
{
  gtk_signal_connect (GTK_OBJECT (c), "new_multi_capplet",
		      GTK_SIGNAL_FUNC (e_setup_multi), NULL);
  switch (CAPPLET_WIDGET(c)->capid)
    {
     default:
     case -1:
     case 0:
      e_setup(c);
      e_init_capplet(c, e_try, e_revert, e_ok, e_cancel);
      break;
    }
}

int
main (int argc, char **argv)
{
  GtkWidget *capplet;
  gint i;
  
  for (i = 0; i < 32; i++)
    deskbg[i] = NULL;


  gnome_capplet_init("e-conf", VERSION, argc,
                     argv, NULL, 0, NULL);

  capplet = capplet_widget_new();
  gtk_widget_show(capplet);
  
  progress_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(progress_win), "Talking to Enlightenment");
  gtk_window_set_policy(GTK_WINDOW(progress_win), 0, 0, 1);
  gtk_window_set_position(GTK_WINDOW(progress_win), GTK_WIN_POS_CENTER);
  gtk_widget_show(progress_win);
  progress = gtk_progress_bar_new();
  gtk_widget_set_usize(progress, 320, 16);
  gtk_widget_show(progress);
  gtk_container_add(GTK_CONTAINER(progress_win), progress);
  
  CommsInit(recieve_ipc_msg);
  e_read();
  
  e_setup_multi(NULL, capplet);
  gtk_widget_destroy(progress_win);
  progress_win = NULL;
  progress = NULL;
  capplet_gtk_main();
  return 0;
}
