/* cheese-window.c generated by valac 0.11.6, the Vala compiler
 * generated from cheese-window.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <clutter/clutter.h>
#include <gio/gio.h>
#include <clutter-gtk/clutter-gtk.h>
#include <thumbview/eog-thumb-nav.h>
#include <thumbview/cheese-thumb-view.h>
#include <gee.h>
#include <cheese-camera.h>
#include <cheese-flash.h>
#include <cheese-effect.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cheese-config.h>
#include <cheese-camera-device.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <glib/gi18n-lib.h>
#include <gst/gst.h>
#include <stdio.h>
#include <float.h>
#include <math.h>


#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
typedef struct _CheeseMainWindowPrivate CheeseMainWindowPrivate;

#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;

#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

struct _CheeseMainWindow {
	GtkWindow parent_instance;
	CheeseMainWindowPrivate * priv;
};

struct _CheeseMainWindowClass {
	GtkWindowClass parent_class;
};

struct _CheeseMainWindowPrivate {
	CheeseMediaMode current_mode;
	GtkBuilder* gtk_builder;
	ClutterScript* clutter_builder;
	GSettings* settings;
	GtkWidget* thumbnails;
	GtkClutterEmbed* viewport_widget;
	GtkVBox* main_vbox;
	EogThumbNav* thumb_nav;
	CheeseThumbView* thumb_view;
	GtkAlignment* thumbnails_right;
	GtkAlignment* thumbnails_bottom;
	GtkMenuBar* menubar;
	GtkHBox* leave_fullscreen_button_container;
	GtkToggleButton* photo_toggle_button;
	GtkToggleButton* video_toggle_button;
	GtkToggleButton* burst_toggle_button;
	GtkButton* take_action_button;
	GtkLabel* take_action_button_label;
	GtkImage* take_action_button_image;
	GtkToggleButton* effects_toggle_button;
	GtkButton* leave_fullscreen_button;
	GtkHBox* buttons_area;
	GtkMenu* thumbnail_popup;
	ClutterStage* viewport;
	ClutterBox* viewport_layout;
	ClutterTexture* video_preview;
	ClutterBinLayout* viewport_layout_manager;
	ClutterText* countdown_layer;
	ClutterRectangle* background_layer;
	ClutterText* error_layer;
	ClutterBox* current_effects_grid;
	gint current_effects_page;
	GeeArrayList* effects_grids;
	GtkAction* take_photo_action;
	GtkAction* take_video_action;
	GtkAction* take_burst_action;
	GtkAction* photo_mode_action;
	GtkAction* video_mode_action;
	GtkAction* burst_mode_action;
	GtkToggleAction* effects_toggle_action;
	GtkToggleAction* wide_mode_action;
	GtkToggleAction* fullscreen_action;
	GtkAction* countdown_action;
	GtkAction* effects_page_prev_action;
	GtkAction* effects_page_next_action;
	gboolean is_fullscreen;
	gboolean is_wide_mode;
	gboolean is_recording;
	gboolean is_bursting;
	gboolean is_effects_selector_active;
	gboolean is_camera_actions_sensitive;
	gboolean action_cancelled;
	gboolean is_command_line_startup;
	GtkButton** buttons;
	gint buttons_length1;
	gint _buttons_size_;
	CheeseCamera* camera;
	CheeseFileUtil* fileutil;
	CheeseFlash* flash;
	CheeseEffectsManager* effects_manager;
	CheesePreferencesDialog* preferences_dialog;
	CheeseEffect* selected_effect;
	GSource* fullscreen_timeout;
	CheeseCountdown* current_countdown;
	gint burst_count;
	guint burst_callback_id;
	GeeHashMap* action_sensitivities;
};

typedef void (*CheeseCountdownCountdownCallback) (void* user_data);
struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GeeArrayList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_main_window_parent_class = NULL;

#define FULLSCREEN_TIMEOUT_INTERVAL (5 * 1000)
#define EFFECTS_PER_PAGE 9
GType cheese_main_window_get_type (void) G_GNUC_CONST;
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST;
GType cheese_countdown_get_type (void) G_GNUC_CONST;
#define CHEESE_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowPrivate))
enum  {
	CHEESE_MAIN_WINDOW_DUMMY_PROPERTY
};
void cheese_main_window_on_quit (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_preferences_dialog (GtkAction* action, CheeseMainWindow* self);
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera, GSettings* settings);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera, GSettings* settings);
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode);
void cheese_preferences_dialog_show (CheesePreferencesDialog* self);
gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event);
void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_help_contents (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_help_about (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode);
void cheese_main_window_on_layout_fullscreen (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode);
void cheese_main_window_on_mode_change (GtkRadioAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self);
static gboolean _lambda0_ (CheeseMainWindow* self);
static gboolean __lambda0__gsource_func (gpointer self);
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e);
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self);
void cheese_main_window_take_photo (CheeseMainWindow* self);
CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
CheeseCountdown* cheese_countdown_construct (GType object_type, ClutterText* countdown_actor);
void cheese_countdown_start (CheeseCountdown* self, CheeseCountdownCountdownCallback completed_callback, void* completed_callback_target);
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self);
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self);
void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event);
void cheese_countdown_stop (CheeseCountdown* self);
void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start);
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self);
void cheese_main_window_on_take_action (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_effects_toggle (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active);
gboolean cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterButtonEvent* event);
void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number);
void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static gboolean _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void cheese_main_window_toggle_camera_actions_sensitivities (CheeseMainWindow* self, gboolean active);
static void cheese_main_window_camera_state_changed (CheeseMainWindow* self, GstState new_state);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name);
void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self);
void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* p0, ClutterAllocationFlags p1, gpointer self);
static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void cheese_main_window_setup_camera (CheeseMainWindow* self, const gchar* uri);
static void _cheese_main_window_camera_state_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender, GstState new_state, gpointer self);
CheeseMainWindow* cheese_main_window_new (void);
CheeseMainWindow* cheese_main_window_construct (GType object_type);
static void cheese_main_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void cheese_main_window_on_quit (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	gtk_widget_destroy ((GtkWidget*) self);
}


void cheese_main_window_on_preferences_dialog (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (self->priv->preferences_dialog == NULL) {
		CheesePreferencesDialog* _tmp0_ = NULL;
		CheesePreferencesDialog* _tmp1_;
		_tmp0_ = cheese_preferences_dialog_new (self->priv->camera, self->priv->settings);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp1_;
	}
	cheese_preferences_dialog_set_current_mode (self->priv->preferences_dialog, self->priv->current_mode);
	cheese_preferences_dialog_show (self->priv->preferences_dialog);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iconview != NULL, FALSE);
	_tmp0_ = gtk_icon_view_get_path_at_pos ((GtkIconView*) self->priv->thumb_view, (gint) (*event).x, (gint) (*event).y);
	_tmp1_ = _gtk_tree_path_copy0 (_tmp0_);
	_tmp2_ = _tmp1_;
	_gtk_tree_path_free0 (path);
	path = _tmp2_;
	if (path == NULL) {
		result = FALSE;
		_gtk_tree_path_free0 (path);
		return result;
	}
	_tmp3_ = gtk_icon_view_path_is_selected ((GtkIconView*) self->priv->thumb_view, path);
	if (!_tmp3_) {
		g_signal_emit_by_name ((GtkIconView*) self->priv->thumb_view, "unselect-all");
		gtk_icon_view_select_path ((GtkIconView*) self->priv->thumb_view, path);
		gtk_icon_view_set_cursor ((GtkIconView*) self->priv->thumb_view, path, NULL, FALSE);
	}
	if ((*event).type == GDK_BUTTON_PRESS) {
		if ((*event).button == 3) {
			gtk_menu_popup (self->priv->thumbnail_popup, NULL, (GtkWidget*) self->priv->thumb_view, NULL, NULL, (*event).button, (*event).time);
		}
	} else {
		if ((*event).type == GDK_2BUTTON_PRESS) {
			cheese_main_window_on_file_open (NULL, self);
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* uri = NULL;
	GdkScreen* screen = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GdkScreen* _tmp5_ = NULL;
	GdkScreen* _tmp6_;
	GdkScreen* _tmp7_;
	guint32 _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_thumb_view_get_selected_image (self->priv->thumb_view);
	_tmp1_ = _tmp0_;
	_g_free0 (filename);
	filename = _tmp1_;
	if (filename == NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		return;
	}
	_tmp2_ = g_filename_to_uri (filename, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	_tmp4_ = _tmp3_;
	_g_free0 (uri);
	uri = _tmp4_;
	_tmp5_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (screen);
	screen = _tmp7_;
	_tmp8_ = gtk_get_current_event_time ();
	gtk_show_uri (screen, uri, _tmp8_, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * err;
		GtkMessageDialog* _tmp9_ = NULL;
		GtkMessageDialog* error_dialog;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not open %s", filename);
		error_dialog = g_object_ref_sink (_tmp9_);
		gtk_dialog_run ((GtkDialog*) error_dialog);
		gtk_widget_destroy ((GtkWidget*) error_dialog);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
	_g_free0 (uri);
	_g_free0 (filename);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self) {
	GFile* file = NULL;
	gint response = 0;
	GtkMessageDialog* confirmation_dialog = NULL;
	GList* _tmp0_ = NULL;
	GList* files;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = cheese_thumb_view_get_selected_images_list (self->priv->thumb_view);
	files = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				GList* _tmp3_ = NULL;
				GFile* _tmp4_;
				GFile* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				GtkMessageDialog* _tmp8_ = NULL;
				GtkMessageDialog* _tmp9_;
				gint _tmp10_;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				_tmp2_ = g_list_length (files);
				if (!(i < _tmp2_)) {
					break;
				}
				_tmp3_ = g_list_nth (files, (guint) i);
				_tmp4_ = _g_object_ref0 ((GFile*) _tmp3_->data);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (file);
				file = _tmp5_;
				if (file == NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (confirmation_dialog);
					_g_object_unref0 (file);
					return;
				}
				_tmp6_ = g_file_get_basename (file);
				_tmp7_ = _tmp6_;
				_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "Are you sure you want to permanently delete the file \"%s\"?", _tmp7_, NULL);
				_tmp9_ = g_object_ref_sink (_tmp8_);
				_g_object_unref0 (confirmation_dialog);
				confirmation_dialog = _tmp9_;
				_g_free0 (_tmp7_);
				gtk_dialog_add_button ((GtkDialog*) confirmation_dialog, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
				gtk_dialog_add_button ((GtkDialog*) confirmation_dialog, GTK_STOCK_DELETE, (gint) GTK_RESPONSE_ACCEPT);
				gtk_message_dialog_format_secondary_text (confirmation_dialog, "%s", "If you delete an item, it will be permanently lost", NULL);
				_tmp10_ = gtk_dialog_run ((GtkDialog*) confirmation_dialog);
				response = _tmp10_;
				gtk_widget_destroy ((GtkWidget*) confirmation_dialog);
				if (response == GTK_RESPONSE_ACCEPT) {
					g_file_delete (file, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch3_g_error;
					}
					goto __finally3;
					__catch3_g_error:
					{
						GError * err;
						gchar* _tmp11_ = NULL;
						gchar* _tmp12_;
						GtkMessageDialog* _tmp13_ = NULL;
						GtkMessageDialog* _tmp14_;
						GtkMessageDialog* error_dialog;
						err = _inner_error_;
						_inner_error_ = NULL;
						_tmp11_ = g_file_get_path (file);
						_tmp12_ = _tmp11_;
						_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not delete %s", _tmp12_);
						error_dialog = (_tmp14_ = g_object_ref_sink (_tmp13_), _g_free0 (_tmp12_), _tmp14_);
						gtk_dialog_run ((GtkDialog*) error_dialog);
						gtk_widget_destroy ((GtkWidget*) error_dialog);
						_g_object_unref0 (error_dialog);
						_g_error_free0 (err);
					}
					__finally3:
					if (_inner_error_ != NULL) {
						__g_list_free__g_object_unref0_0 (files);
						_g_object_unref0 (confirmation_dialog);
						_g_object_unref0 (file);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (confirmation_dialog);
	_g_object_unref0 (file);
}


void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self) {
	GFile* file = NULL;
	GList* _tmp0_ = NULL;
	GList* files;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = cheese_thumb_view_get_selected_images_list (self->priv->thumb_view);
	files = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				GList* _tmp3_ = NULL;
				GFile* _tmp4_;
				GFile* _tmp5_;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				_tmp2_ = g_list_length (files);
				if (!(i < _tmp2_)) {
					break;
				}
				_tmp3_ = g_list_nth (files, (guint) i);
				_tmp4_ = _g_object_ref0 ((GFile*) _tmp3_->data);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (file);
				file = _tmp5_;
				if (file == NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					return;
				}
				g_file_trash (file, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch4_g_error;
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError * err;
					gchar* _tmp6_ = NULL;
					gchar* _tmp7_;
					GtkMessageDialog* _tmp8_ = NULL;
					GtkMessageDialog* _tmp9_;
					GtkMessageDialog* error_dialog;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp6_ = g_file_get_path (file);
					_tmp7_ = _tmp6_;
					_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not move %s to trash", _tmp7_);
					error_dialog = (_tmp9_ = g_object_ref_sink (_tmp8_), _g_free0 (_tmp7_), _tmp9_);
					gtk_dialog_run ((GtkDialog*) error_dialog);
					gtk_widget_destroy ((GtkWidget*) error_dialog);
					_g_object_unref0 (error_dialog);
					_g_error_free0 (err);
				}
				__finally4:
				if (_inner_error_ != NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (file);
}


void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self) {
	GFile* file_to_trash = NULL;
	GFileInfo* file_info = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* directory;
	GFileEnumerator* _tmp2_ = NULL;
	GFileEnumerator* enumerator;
	const gchar* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	GFile* _tmp14_;
	GFileEnumerator* _tmp15_ = NULL;
	GFileEnumerator* _tmp16_;
	GFileEnumerator* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = cheese_fileutil_get_photo_path (self->priv->fileutil);
	_tmp1_ = g_file_new_for_path (_tmp0_);
	directory = _tmp1_;
	_tmp2_ = g_file_enumerate_children (directory, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
	enumerator = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (directory);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file_to_trash);
		goto __catch5_g_error;
	}
	while (TRUE) {
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GFile* _tmp10_ = NULL;
		GFile* _tmp11_;
		_tmp3_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file_to_trash);
			goto __catch5_g_error;
		}
		_tmp5_ = _tmp4_;
		_g_object_unref0 (file_info);
		file_info = _tmp5_;
		if (!(file_info != NULL)) {
			break;
		}
		_tmp6_ = cheese_fileutil_get_photo_path (self->priv->fileutil);
		_tmp7_ = g_strconcat (_tmp6_, G_DIR_SEPARATOR_S, NULL);
		_tmp8_ = g_file_info_get_name (file_info);
		_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
		_tmp10_ = g_file_new_for_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (file_to_trash);
		file_to_trash = _tmp11_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		g_file_trash (file_to_trash, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file_to_trash);
			goto __catch5_g_error;
		}
	}
	_tmp12_ = cheese_fileutil_get_video_path (self->priv->fileutil);
	_tmp13_ = g_file_new_for_path (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (directory);
	directory = _tmp14_;
	_tmp15_ = g_file_enumerate_children (directory, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
	_tmp16_ = _tmp15_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (enumerator);
		_g_object_unref0 (directory);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file_to_trash);
		goto __catch5_g_error;
	}
	_tmp17_ = _tmp16_;
	_g_object_unref0 (enumerator);
	enumerator = _tmp17_;
	while (TRUE) {
		GFileInfo* _tmp18_ = NULL;
		GFileInfo* _tmp19_;
		GFileInfo* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		GFile* _tmp25_ = NULL;
		GFile* _tmp26_;
		_tmp18_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file_to_trash);
			goto __catch5_g_error;
		}
		_tmp20_ = _tmp19_;
		_g_object_unref0 (file_info);
		file_info = _tmp20_;
		if (!(file_info != NULL)) {
			break;
		}
		_tmp21_ = cheese_fileutil_get_photo_path (self->priv->fileutil);
		_tmp22_ = g_strconcat (_tmp21_, G_DIR_SEPARATOR_S, NULL);
		_tmp23_ = g_file_info_get_name (file_info);
		_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
		_tmp25_ = g_file_new_for_path (_tmp24_);
		_tmp26_ = _tmp25_;
		_g_object_unref0 (file_to_trash);
		file_to_trash = _tmp26_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		g_file_trash (file_to_trash, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file_to_trash);
			goto __catch5_g_error;
		}
	}
	_g_object_unref0 (enumerator);
	_g_object_unref0 (directory);
	_g_object_unref0 (file_info);
	_g_object_unref0 (file_to_trash);
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("cheese-window.vala:295: Error: %s\n", e->message);
		_g_error_free0 (e);
		return;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* basename = NULL;
	GtkFileChooserDialog* save_as_dialog = NULL;
	gint response = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GtkFileChooserDialog* _tmp2_ = NULL;
	GtkFileChooserDialog* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = cheese_thumb_view_get_selected_image (self->priv->thumb_view);
	_tmp1_ = _tmp0_;
	_g_free0 (filename);
	filename = _tmp1_;
	if (filename == NULL) {
		_g_object_unref0 (save_as_dialog);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp2_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Save File", (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (save_as_dialog);
	save_as_dialog = _tmp3_;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) save_as_dialog, TRUE);
	_tmp4_ = g_filename_display_basename (filename);
	_tmp5_ = _tmp4_;
	_g_free0 (basename);
	basename = _tmp5_;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) save_as_dialog, basename);
	_tmp6_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) save_as_dialog, _tmp6_);
	_tmp7_ = gtk_dialog_run ((GtkDialog*) save_as_dialog);
	response = _tmp7_;
	gtk_widget_hide ((GtkWidget*) save_as_dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		gchar* target_filename = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GFile* _tmp10_ = NULL;
		GFile* src;
		GFile* _tmp11_ = NULL;
		GFile* dest;
		_tmp8_ = gtk_file_chooser_get_filename ((GtkFileChooser*) save_as_dialog);
		_tmp9_ = _tmp8_;
		_g_free0 (target_filename);
		target_filename = _tmp9_;
		_tmp10_ = g_file_new_for_path (filename);
		src = _tmp10_;
		_tmp11_ = g_file_new_for_path (target_filename);
		dest = _tmp11_;
		g_file_copy (src, dest, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError * err;
			GtkMessageDialog* _tmp12_ = NULL;
			GtkMessageDialog* error_dialog;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not save %s", target_filename);
			error_dialog = g_object_ref_sink (_tmp12_);
			gtk_dialog_run ((GtkDialog*) error_dialog);
			gtk_widget_destroy ((GtkWidget*) error_dialog);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (err);
		}
		__finally6:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_object_unref0 (src);
			_g_free0 (target_filename);
			_g_object_unref0 (save_as_dialog);
			_g_free0 (basename);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (dest);
		_g_object_unref0 (src);
		_g_free0 (target_filename);
	}
	gtk_widget_destroy ((GtkWidget*) save_as_dialog);
	_g_object_unref0 (save_as_dialog);
	_g_free0 (basename);
	_g_free0 (filename);
}


void cheese_main_window_on_help_contents (GtkAction* action, CheeseMainWindow* self) {
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_;
	GdkScreen* _tmp2_;
	guint32 _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (screen);
	screen = _tmp2_;
	_tmp3_ = gtk_get_current_event_time ();
	gtk_show_uri (screen, "ghelp:cheese", _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch7_g_error;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("cheese-window.vala:364: Error: %s\n", err->message);
		_g_error_free0 (err);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
}


void cheese_main_window_on_help_about (GtkAction* action, CheeseMainWindow* self) {
	GtkAboutDialog* about_dialog = NULL;
	GObject* _tmp0_ = NULL;
	GtkAboutDialog* _tmp1_;
	GtkAboutDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_builder_get_object (self->priv->gtk_builder, "aboutdialog");
	_tmp1_ = _g_object_ref0 (GTK_ABOUT_DIALOG (_tmp0_));
	_tmp2_ = _tmp1_;
	_g_object_unref0 (about_dialog);
	about_dialog = _tmp2_;
	gtk_about_dialog_set_version (about_dialog, VERSION);
	gtk_dialog_run ((GtkDialog*) about_dialog);
	gtk_widget_hide ((GtkWidget*) about_dialog);
	_g_object_unref0 (about_dialog);
}


void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self) {
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (!self->priv->is_command_line_startup) {
		gboolean _tmp0_;
		_tmp0_ = gtk_toggle_action_get_active (action);
		g_settings_set_boolean (self->priv->settings, "wide-mode", _tmp0_);
	}
	_tmp1_ = gtk_toggle_action_get_active (action);
	cheese_main_window_set_wide_mode (self, _tmp1_);
}


void cheese_main_window_on_layout_fullscreen (GtkToggleAction* action, CheeseMainWindow* self) {
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (!self->priv->is_command_line_startup) {
		gboolean _tmp0_;
		_tmp0_ = gtk_toggle_action_get_active (action);
		g_settings_set_boolean (self->priv->settings, "fullscreen", _tmp0_);
	}
	_tmp1_ = gtk_toggle_action_get_active (action);
	cheese_main_window_set_fullscreen_mode (self, _tmp1_);
}


void cheese_main_window_on_mode_change (GtkRadioAction* action, CheeseMainWindow* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	cheese_main_window_set_mode (self, (CheeseMediaMode) (g_object_get (action, "value", &_tmp0_, NULL), _tmp0_));
}


static void cheese_main_window_enable_mode_change (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_action_set_sensitive (self->priv->photo_mode_action, TRUE);
	gtk_action_set_sensitive (self->priv->video_mode_action, TRUE);
	gtk_action_set_sensitive (self->priv->burst_mode_action, TRUE);
	gtk_action_set_sensitive ((GtkAction*) self->priv->effects_toggle_action, TRUE);
}


static void cheese_main_window_disable_mode_change (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_action_set_sensitive (self->priv->photo_mode_action, FALSE);
	gtk_action_set_sensitive (self->priv->video_mode_action, FALSE);
	gtk_action_set_sensitive (self->priv->burst_mode_action, FALSE);
	gtk_action_set_sensitive ((GtkAction*) self->priv->effects_toggle_action, FALSE);
}


static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode) {
	GList* _tmp0_ = NULL;
	GList* formats;
	CheeseVideoFormat* format = NULL;
	gint width;
	gint height;
	g_return_if_fail (self != NULL);
	if (self->priv->camera == NULL) {
		return;
	}
	_tmp0_ = cheese_camera_get_video_formats (self->priv->camera);
	formats = _tmp0_;
	if (formats == NULL) {
		return;
	}
	width = 0;
	height = 0;
	switch (mode) {
		case CHEESE_MEDIA_MODE_PHOTO:
		case CHEESE_MEDIA_MODE_BURST:
		{
			gint _tmp1_;
			gint _tmp2_;
			_tmp1_ = g_settings_get_int (self->priv->settings, "photo-x-resolution");
			width = _tmp1_;
			_tmp2_ = g_settings_get_int (self->priv->settings, "photo-y-resolution");
			height = _tmp2_;
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			gint _tmp3_;
			gint _tmp4_;
			_tmp3_ = g_settings_get_int (self->priv->settings, "video-x-resolution");
			width = _tmp3_;
			_tmp4_ = g_settings_get_int (self->priv->settings, "video-y-resolution");
			height = _tmp4_;
			break;
		}
		default:
		break;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				guint _tmp6_;
				GList* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				_tmp6_ = g_list_length (formats);
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = g_list_nth (formats, (guint) i);
				format = (CheeseVideoFormat*) _tmp7_->data;
				if (width == format->width) {
					_tmp8_ = height == format->height;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					cheese_camera_set_video_format (self->priv->camera, format);
					break;
				}
			}
		}
	}
}


static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	GtkAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->current_mode = mode;
	cheese_main_window_set_resolution (self, self->priv->current_mode);
	if (self->priv->preferences_dialog != NULL) {
		cheese_preferences_dialog_set_current_mode (self->priv->preferences_dialog, self->priv->current_mode);
	}
	switch (self->priv->current_mode) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			gtk_action_set_sensitive (self->priv->take_photo_action, TRUE);
			gtk_action_set_sensitive (self->priv->take_video_action, FALSE);
			gtk_action_set_sensitive (self->priv->take_burst_action, FALSE);
			gtk_activatable_set_related_action ((GtkActivatable*) self->priv->take_action_button, self->priv->take_photo_action);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			gtk_action_set_sensitive (self->priv->take_photo_action, FALSE);
			gtk_action_set_sensitive (self->priv->take_video_action, TRUE);
			gtk_action_set_sensitive (self->priv->take_burst_action, FALSE);
			gtk_activatable_set_related_action ((GtkActivatable*) self->priv->take_action_button, self->priv->take_video_action);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			gtk_action_set_sensitive (self->priv->take_photo_action, FALSE);
			gtk_action_set_sensitive (self->priv->take_video_action, FALSE);
			gtk_action_set_sensitive (self->priv->take_burst_action, TRUE);
			gtk_activatable_set_related_action ((GtkActivatable*) self->priv->take_action_button, self->priv->take_burst_action);
			break;
		}
		default:
		break;
	}
	_tmp0_ = gtk_activatable_get_related_action ((GtkActivatable*) self->priv->take_action_button);
	_tmp1_ = gtk_action_get_label (_tmp0_);
	_tmp2_ = g_strconcat ("<b>", _tmp1_, NULL);
	_tmp3_ = g_strconcat (_tmp2_, "</b>", NULL);
	gtk_label_set_label (self->priv->take_action_button_label, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	_tmp4_ = gtk_activatable_get_related_action ((GtkActivatable*) self->priv->take_action_button);
	_tmp5_ = gtk_action_get_tooltip (_tmp4_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->take_action_button, _tmp5_);
}


static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->fullscreen_timeout != NULL) {
		GSource* _tmp0_;
		g_source_destroy (self->priv->fullscreen_timeout);
		_tmp0_ = NULL;
		_g_source_unref0 (self->priv->fullscreen_timeout);
		self->priv->fullscreen_timeout = _tmp0_;
	}
}


static gboolean _lambda0_ (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gtk_widget_hide ((GtkWidget*) self->priv->buttons_area);
	cheese_main_window_clear_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_ = NULL;
	GSource* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timeout_source_new ((guint) FULLSCREEN_TIMEOUT_INTERVAL);
	_tmp1_ = _tmp0_;
	_g_source_unref0 (self->priv->fullscreen_timeout);
	self->priv->fullscreen_timeout = _tmp1_;
	g_source_attach (self->priv->fullscreen_timeout, NULL);
	g_source_set_callback (self->priv->fullscreen_timeout, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (viewport != NULL, FALSE);
	cheese_main_window_clear_fullscreen_timeout (self);
	gtk_widget_show ((GtkWidget*) self->priv->buttons_area);
	cheese_main_window_set_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_fullscreen_motion_notify_callback (self, _sender, event);
	return result;
}


static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode) {
	g_return_if_fail (self != NULL);
	self->priv->is_fullscreen = fullscreen_mode;
	if (fullscreen_mode) {
		if (self->priv->is_wide_mode) {
			gtk_widget_hide ((GtkWidget*) self->priv->thumbnails_right);
		} else {
			gtk_widget_hide ((GtkWidget*) self->priv->thumbnails_bottom);
		}
		gtk_widget_hide ((GtkWidget*) self->priv->menubar);
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->leave_fullscreen_button_container, FALSE);
		gtk_widget_show_all ((GtkWidget*) self->priv->leave_fullscreen_button_container);
		{
			GtkButton** b_collection;
			int b_collection_length1;
			int b_it;
			b_collection = self->priv->buttons;
			b_collection_length1 = self->priv->buttons_length1;
			for (b_it = 0; b_it < self->priv->buttons_length1; b_it = b_it + 1) {
				GtkButton* _tmp0_;
				GtkButton* b;
				_tmp0_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp0_;
				{
					const gchar* _tmp1_ = NULL;
					_tmp1_ = gtk_buildable_get_name ((GtkBuildable*) b);
					if (g_strcmp0 (_tmp1_, "take_action_button") != 0) {
						gtk_button_set_relief (b, GTK_RELIEF_NONE);
					}
					_g_object_unref0 (b);
				}
			}
		}
		gtk_window_fullscreen ((GtkWindow*) self);
		g_signal_connect_object ((GtkWidget*) self->priv->viewport_widget, "motion-notify-event", (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self, 0);
		cheese_main_window_set_fullscreen_timeout (self);
	} else {
		guint _tmp4_;
		if (self->priv->is_wide_mode) {
			gtk_widget_show_all ((GtkWidget*) self->priv->thumbnails_right);
		} else {
			gtk_widget_show_all ((GtkWidget*) self->priv->thumbnails_bottom);
		}
		gtk_widget_show_all ((GtkWidget*) self->priv->menubar);
		gtk_widget_hide ((GtkWidget*) self->priv->leave_fullscreen_button_container);
		{
			GtkButton** b_collection;
			int b_collection_length1;
			int b_it;
			b_collection = self->priv->buttons;
			b_collection_length1 = self->priv->buttons_length1;
			for (b_it = 0; b_it < self->priv->buttons_length1; b_it = b_it + 1) {
				GtkButton* _tmp2_;
				GtkButton* b;
				_tmp2_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp2_;
				{
					const gchar* _tmp3_ = NULL;
					_tmp3_ = gtk_buildable_get_name ((GtkBuildable*) b);
					if (g_strcmp0 (_tmp3_, "take_action_button") != 0) {
						gtk_button_set_relief (b, GTK_RELIEF_NORMAL);
					}
					_g_object_unref0 (b);
				}
			}
		}
		cheese_main_window_clear_fullscreen_timeout (self);
		gtk_widget_show ((GtkWidget*) self->priv->buttons_area);
		g_signal_parse_name ("motion-notify-event", GTK_TYPE_WIDGET, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->viewport_widget, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self);
		gtk_window_unfullscreen ((GtkWindow*) self);
	}
}


static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode) {
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	GtkRequisition req = {0};
	GtkRequisition _tmp3_ = {0};
	GtkRequisition _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	self->priv->is_wide_mode = wide_mode;
	gtk_widget_get_allocation ((GtkWidget*) self->priv->viewport_widget, &_tmp0_);
	alloc = _tmp0_;
	gtk_widget_set_size_request ((GtkWidget*) self->priv->viewport_widget, alloc.width, alloc.height);
	if (self->priv->is_wide_mode) {
		GtkWidget* _tmp1_ = NULL;
		gtk_icon_view_set_columns ((GtkIconView*) self->priv->thumb_view, 1);
		eog_thumb_nav_set_vertical (self->priv->thumb_nav, TRUE);
		_tmp1_ = gtk_bin_get_child ((GtkBin*) self->priv->thumbnails_bottom);
		if (_tmp1_ != NULL) {
			gtk_container_remove ((GtkContainer*) self->priv->thumbnails_bottom, (GtkWidget*) self->priv->thumb_nav);
		}
		gtk_container_add ((GtkContainer*) self->priv->thumbnails_right, (GtkWidget*) self->priv->thumb_nav);
		gtk_widget_show_all ((GtkWidget*) self->priv->thumbnails_right);
		gtk_container_resize_children ((GtkContainer*) self->priv->thumbnails_right);
		gtk_widget_hide ((GtkWidget*) self->priv->thumbnails_bottom);
	} else {
		GtkWidget* _tmp2_ = NULL;
		gtk_icon_view_set_columns ((GtkIconView*) self->priv->thumb_view, 5000);
		eog_thumb_nav_set_vertical (self->priv->thumb_nav, FALSE);
		_tmp2_ = gtk_bin_get_child ((GtkBin*) self->priv->thumbnails_right);
		if (_tmp2_ != NULL) {
			gtk_container_remove ((GtkContainer*) self->priv->thumbnails_right, (GtkWidget*) self->priv->thumb_nav);
		}
		gtk_container_add ((GtkContainer*) self->priv->thumbnails_bottom, (GtkWidget*) self->priv->thumb_nav);
		gtk_widget_show_all ((GtkWidget*) self->priv->thumbnails_bottom);
		gtk_container_resize_children ((GtkContainer*) self->priv->thumbnails_bottom);
		gtk_widget_hide ((GtkWidget*) self->priv->thumbnails_right);
	}
	gtk_widget_get_preferred_size ((GtkWidget*) self, &_tmp3_, &_tmp4_);
	req = _tmp3_;
	req = _tmp4_;
	gtk_window_resize ((GtkWindow*) self, req.width, req.height);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->viewport_widget, -1, -1);
}


void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags) {
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = clutter_actor_get_width ((ClutterActor*) self->priv->viewport);
	_tmp1_ = clutter_actor_get_height ((ClutterActor*) self->priv->viewport);
	clutter_actor_set_size ((ClutterActor*) self->priv->viewport_layout, _tmp0_, _tmp1_);
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) self->priv->viewport);
	_tmp3_ = clutter_actor_get_height ((ClutterActor*) self->priv->viewport);
	clutter_actor_set_size ((ClutterActor*) self->priv->background_layer, _tmp2_, _tmp3_);
}


void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_toggle_action_get_active (action);
	g_settings_set_boolean (self->priv->settings, "countdown", _tmp0_);
}


static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->action_cancelled == FALSE) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* file_name;
		gboolean _tmp4_;
		const gchar* _tmp5_ = NULL;
		_tmp0_ = cheese_fileutil_get_new_media_filename (self->priv->fileutil, self->priv->current_mode);
		_tmp1_ = g_strdup (_tmp0_);
		file_name = _tmp1_;
		if (self->priv->current_mode == CHEESE_MEDIA_MODE_VIDEO) {
			const gchar* _tmp2_ = NULL;
			_tmp2_ = cheese_fileutil_get_video_path (self->priv->fileutil);
			cheese_thumb_view_start_monitoring_video_path (self->priv->thumb_view, _tmp2_);
		} else {
			const gchar* _tmp3_ = NULL;
			_tmp3_ = cheese_fileutil_get_photo_path (self->priv->fileutil);
			cheese_thumb_view_start_monitoring_photo_path (self->priv->thumb_view, _tmp3_);
		}
		_tmp4_ = g_settings_get_boolean (self->priv->settings, "flash");
		if (_tmp4_) {
			cheese_flash_fire (self->priv->flash);
		}
		_tmp5_ = _ ("Shutter sound");
		ca_gtk_play_for_widget ((GtkWidget*) self->priv->main_vbox, (guint32) 0, CA_PROP_EVENT_ID, "camera-shutter", CA_PROP_MEDIA_ROLE, "event", CA_PROP_EVENT_DESCRIPTION, _tmp5_, NULL, NULL);
		cheese_camera_take_photo (self->priv->camera, file_name);
		_g_free0 (file_name);
	}
	if (self->priv->current_mode == CHEESE_MEDIA_MODE_PHOTO) {
		gtk_action_set_sensitive (self->priv->take_photo_action, TRUE);
		cheese_main_window_enable_mode_change (self);
	}
}


static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self) {
	cheese_main_window_finish_countdown_callback (self);
}


void cheese_main_window_take_photo (CheeseMainWindow* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_get_boolean (self->priv->settings, "countdown");
	if (_tmp0_) {
		CheeseCountdown* _tmp1_ = NULL;
		CheeseCountdown* _tmp2_;
		if (self->priv->current_mode == CHEESE_MEDIA_MODE_PHOTO) {
			gtk_action_set_sensitive (self->priv->take_photo_action, FALSE);
			cheese_main_window_disable_mode_change (self);
		}
		_tmp1_ = cheese_countdown_new (self->priv->countdown_layer);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (self->priv->current_countdown);
		self->priv->current_countdown = _tmp2_;
		cheese_countdown_start (self->priv->current_countdown, _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback, self);
	} else {
		cheese_main_window_finish_countdown_callback (self);
	}
}


static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->is_bursting) {
		gint _tmp1_;
		_tmp1_ = g_settings_get_int (self->priv->settings, "burst-repeat");
		_tmp0_ = self->priv->burst_count < _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		cheese_main_window_take_photo (self);
		self->priv->burst_count++;
		result = TRUE;
		return result;
	} else {
		cheese_main_window_toggle_photo_bursting (self, FALSE);
		result = FALSE;
		return result;
	}
}


static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gchar* key = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gdk_keyval_name ((*event).keyval);
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = _tmp1_;
	_g_free0 (key);
	key = _tmp2_;
	_tmp3_ = g_strcmp0 (key, "Escape");
	if (_tmp3_ == 0) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		if (self->priv->current_countdown != NULL) {
			_tmp6_ = self->priv->current_countdown->running;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = self->priv->is_bursting;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = self->priv->is_recording;
		}
		if (_tmp4_) {
			self->priv->action_cancelled = TRUE;
			if (self->priv->current_mode == CHEESE_MEDIA_MODE_PHOTO) {
				cheese_countdown_stop (self->priv->current_countdown);
				cheese_main_window_finish_countdown_callback (self);
			} else {
				if (self->priv->current_mode == CHEESE_MEDIA_MODE_BURST) {
					cheese_main_window_toggle_photo_bursting (self, FALSE);
				} else {
					if (self->priv->current_mode == CHEESE_MEDIA_MODE_VIDEO) {
						cheese_main_window_toggle_video_recording (self, FALSE);
					}
				}
			}
			self->priv->action_cancelled = FALSE;
		} else {
			if (self->priv->is_effects_selector_active) {
				gtk_toggle_action_set_active (self->priv->effects_toggle_action, FALSE);
			}
		}
	}
	result = FALSE;
	_g_free0 (key);
	return result;
}


void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start) {
	g_return_if_fail (self != NULL);
	if (is_start) {
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = cheese_fileutil_get_new_media_filename (self->priv->fileutil, self->priv->current_mode);
		cheese_camera_start_video_recording (self->priv->camera, _tmp0_);
		_tmp1_ = _ ("Stop _Recording");
		_tmp2_ = g_strconcat ("<b>", _tmp1_, NULL);
		_tmp3_ = g_strconcat (_tmp2_, "</b>", NULL);
		gtk_label_set_label (self->priv->take_action_button_label, _tmp3_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp2_);
		gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->take_action_button, "Stop recording");
		gtk_image_set_from_stock (self->priv->take_action_button_image, GTK_STOCK_MEDIA_STOP, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = TRUE;
		cheese_main_window_disable_mode_change (self);
	} else {
		GtkAction* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GtkAction* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		cheese_camera_stop_video_recording (self->priv->camera);
		_tmp4_ = gtk_activatable_get_related_action ((GtkActivatable*) self->priv->take_action_button);
		_tmp5_ = gtk_action_get_label (_tmp4_);
		_tmp6_ = g_strconcat ("<b>", _tmp5_, NULL);
		_tmp7_ = g_strconcat (_tmp6_, "</b>", NULL);
		gtk_label_set_label (self->priv->take_action_button_label, _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp6_);
		_tmp8_ = gtk_activatable_get_related_action ((GtkActivatable*) self->priv->take_action_button);
		_tmp9_ = gtk_action_get_tooltip (_tmp8_);
		gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->take_action_button, _tmp9_);
		gtk_image_set_from_stock (self->priv->take_action_button_image, GTK_STOCK_MEDIA_RECORD, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = FALSE;
		cheese_main_window_enable_mode_change (self);
	}
}


static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_burst_take_photo (self);
	return result;
}


void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start) {
	g_return_if_fail (self != NULL);
	if (is_start) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gint _tmp3_;
		guint _tmp4_;
		self->priv->is_bursting = TRUE;
		cheese_main_window_disable_mode_change (self);
		gtk_action_set_sensitive ((GtkAction*) self->priv->effects_toggle_action, FALSE);
		_tmp0_ = _ ("Stop _Taking Pictures");
		_tmp1_ = g_strconcat ("<b>", _tmp0_, NULL);
		_tmp2_ = g_strconcat (_tmp1_, "</b>", NULL);
		gtk_label_set_label (self->priv->take_action_button_label, _tmp2_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->take_action_button, "Stop taking pictures");
		cheese_main_window_burst_take_photo (self);
		_tmp3_ = g_settings_get_int (self->priv->settings, "burst-delay");
		_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((_tmp3_ / 1000) * 3500), _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->burst_callback_id = _tmp4_;
	} else {
		gboolean _tmp5_ = FALSE;
		GtkAction* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GtkAction* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		if (self->priv->current_countdown != NULL) {
			_tmp5_ = self->priv->current_countdown->running;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			cheese_countdown_stop (self->priv->current_countdown);
		}
		self->priv->is_bursting = FALSE;
		cheese_main_window_enable_mode_change (self);
		_tmp6_ = gtk_activatable_get_related_action ((GtkActivatable*) self->priv->take_action_button);
		_tmp7_ = gtk_action_get_label (_tmp6_);
		_tmp8_ = g_strconcat ("<b>", _tmp7_, NULL);
		_tmp9_ = g_strconcat (_tmp8_, "</b>", NULL);
		gtk_label_set_label (self->priv->take_action_button_label, _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp8_);
		_tmp10_ = gtk_activatable_get_related_action ((GtkActivatable*) self->priv->take_action_button);
		_tmp11_ = gtk_action_get_tooltip (_tmp10_);
		gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->take_action_button, _tmp11_);
		self->priv->burst_count = 0;
		cheese_fileutil_reset_burst (self->priv->fileutil);
		g_source_remove (self->priv->burst_callback_id);
	}
}


void cheese_main_window_on_take_action (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (self->priv->current_mode == CHEESE_MEDIA_MODE_PHOTO) {
		cheese_main_window_take_photo (self);
	} else {
		if (self->priv->current_mode == CHEESE_MEDIA_MODE_VIDEO) {
			cheese_main_window_toggle_video_recording (self, !self->priv->is_recording);
		} else {
			if (self->priv->current_mode == CHEESE_MEDIA_MODE_BURST) {
				cheese_main_window_toggle_photo_bursting (self, !self->priv->is_bursting);
			}
		}
	}
}


void cheese_main_window_on_effects_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_toggle_action_get_active (action);
	cheese_main_window_toggle_effects_selector (self, _tmp0_);
	_tmp1_ = gtk_toggle_action_get_active (action);
	gtk_action_set_sensitive (self->priv->take_photo_action, !_tmp1_);
	_tmp2_ = gtk_toggle_action_get_active (action);
	gtk_action_set_sensitive (self->priv->take_video_action, !_tmp2_);
	_tmp3_ = gtk_toggle_action_get_active (action);
	gtk_action_set_sensitive (self->priv->take_burst_action, !_tmp3_);
	_tmp4_ = gtk_toggle_action_get_active (action);
	gtk_action_set_sensitive (self->priv->photo_mode_action, !_tmp4_);
	_tmp5_ = gtk_toggle_action_get_active (action);
	gtk_action_set_sensitive (self->priv->video_mode_action, !_tmp5_);
	_tmp6_ = gtk_toggle_action_get_active (action);
	gtk_action_set_sensitive (self->priv->burst_mode_action, !_tmp6_);
}


gboolean cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	CheeseEffect* _tmp1_;
	CheeseEffect* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_object_get_data ((GObject*) (*event).source, "effect");
	_tmp1_ = _g_object_ref0 ((CheeseEffect*) _tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->selected_effect);
	self->priv->selected_effect = _tmp2_;
	cheese_camera_set_effect (self->priv->camera, self->priv->selected_effect);
	_tmp4_ = (g_object_get (self->priv->selected_effect, "name", &_tmp3_, NULL), _tmp3_);
	g_settings_set_string (self->priv->settings, "selected-effect", _tmp4_);
	_g_free0 (_tmp4_);
	gtk_toggle_action_set_active (self->priv->effects_toggle_action, FALSE);
	result = FALSE;
	return result;
}


void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (self->priv->current_effects_page != 0) {
		cheese_main_window_activate_effects_page (self, self->priv->current_effects_page - 1);
	}
}


void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects);
	if (self->priv->current_effects_page != (_tmp0_ / EFFECTS_PER_PAGE)) {
		cheese_main_window_activate_effects_page (self, self->priv->current_effects_page + 1);
	}
}


static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number) {
	GList* _tmp0_ = NULL;
	GList* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	gpointer _tmp4_ = NULL;
	ClutterBox* _tmp5_;
	g_return_if_fail (self != NULL);
	if (!self->priv->is_effects_selector_active) {
		return;
	}
	self->priv->current_effects_page = number;
	_tmp0_ = clutter_container_get_children ((ClutterContainer*) self->priv->viewport_layout);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_list_index (_tmp1_, (ClutterActor*) self->priv->current_effects_grid);
	if ((_tmp3_ = _tmp2_ != (-1), _g_list_free0 (_tmp1_), _tmp3_)) {
		clutter_container_remove ((ClutterContainer*) self->priv->viewport_layout, CLUTTER_ACTOR (self->priv->current_effects_grid), NULL);
	}
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_grids, number);
	_tmp5_ = (ClutterBox*) _tmp4_;
	_g_object_unref0 (self->priv->current_effects_grid);
	self->priv->current_effects_grid = _tmp5_;
	g_object_set ((GObject*) self->priv->current_effects_grid, "opacity", 0, NULL);
	clutter_container_add ((ClutterContainer*) self->priv->viewport_layout, CLUTTER_ACTOR (self->priv->current_effects_grid), NULL);
	clutter_actor_animate ((ClutterActor*) self->priv->current_effects_grid, (gulong) CLUTTER_LINEAR, (guint) 1000, "opacity", 255, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint page_of_effect;
				gpointer _tmp8_ = NULL;
				CheeseEffect* effect;
				if (!_tmp6_) {
					i++;
				}
				_tmp6_ = FALSE;
				_tmp7_ = gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects);
				if (!(i < _tmp7_)) {
					break;
				}
				page_of_effect = i / EFFECTS_PER_PAGE;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_manager->effects, i);
				effect = (CheeseEffect*) _tmp8_;
				if (page_of_effect == number) {
					gboolean _tmp9_;
					_tmp9_ = cheese_effect_is_preview_connected (effect);
					if (!_tmp9_) {
						gconstpointer _tmp10_ = NULL;
						ClutterTexture* _tmp11_;
						ClutterTexture* texture;
						_tmp10_ = g_object_get_data ((GObject*) effect, "texture");
						_tmp11_ = _g_object_ref0 ((ClutterTexture*) _tmp10_);
						texture = _tmp11_;
						cheese_camera_connect_effect_texture (self->priv->camera, effect, texture);
						_g_object_unref0 (texture);
					}
					cheese_effect_enable_preview (effect);
				} else {
					gboolean _tmp12_;
					_tmp12_ = cheese_effect_is_preview_connected (effect);
					if (_tmp12_) {
						cheese_effect_disable_preview (effect);
					}
				}
				_g_object_unref0 (effect);
			}
		}
	}
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->is_effects_selector_active) {
		_tmp0_ = self->priv->current_effects_page != 0;
	} else {
		_tmp0_ = FALSE;
	}
	gtk_action_set_sensitive (self->priv->effects_page_prev_action, _tmp0_);
	if (self->priv->is_effects_selector_active) {
		gint _tmp2_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects);
		_tmp1_ = self->priv->current_effects_page != (_tmp2_ / EFFECTS_PER_PAGE);
	} else {
		_tmp1_ = FALSE;
	}
	gtk_action_set_sensitive (self->priv->effects_page_next_action, _tmp1_);
}


static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active) {
	g_return_if_fail (self != NULL);
	self->priv->is_effects_selector_active = active;
	if (active) {
		gint _tmp0_;
		clutter_actor_hide ((ClutterActor*) self->priv->video_preview);
		_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->effects_grids);
		if (_tmp0_ == 0) {
			const gchar* _tmp1_ = NULL;
			_tmp1_ = _ ("No effects found");
			clutter_text_set_text (self->priv->error_layer, _tmp1_);
			clutter_actor_show ((ClutterActor*) self->priv->error_layer);
		} else {
			clutter_actor_show ((ClutterActor*) self->priv->current_effects_grid);
			cheese_main_window_activate_effects_page (self, self->priv->current_effects_page);
		}
	} else {
		gint _tmp2_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) self->priv->effects_grids);
		if (_tmp2_ == 0) {
			clutter_actor_hide ((ClutterActor*) self->priv->error_layer);
		} else {
			clutter_actor_hide ((ClutterActor*) self->priv->current_effects_grid);
		}
		clutter_actor_show ((ClutterActor*) self->priv->video_preview);
	}
	cheese_camera_toggle_effects_pipeline (self->priv->camera, active);
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


static gboolean _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_selected_effect_change (self, event);
	return result;
}


static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->current_effects_grid == NULL) {
		CheeseEffectsManager* _tmp0_ = NULL;
		CheeseEffectsManager* _tmp1_;
		gint _tmp2_;
		GeeArrayList* _tmp3_ = NULL;
		GeeArrayList* _tmp4_;
		gpointer _tmp37_ = NULL;
		ClutterBox* _tmp38_;
		_tmp0_ = cheese_effects_manager_new ();
		_tmp1_ = _tmp0_;
		_g_object_unref0 (self->priv->effects_manager);
		self->priv->effects_manager = _tmp1_;
		cheese_effects_manager_load_effects (self->priv->effects_manager);
		_tmp2_ = gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects);
		if (_tmp2_ == 0) {
			return;
		}
		_tmp3_ = gee_array_list_new (CLUTTER_TYPE_BOX, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (self->priv->effects_grids);
		self->priv->effects_grids = _tmp4_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp5_;
				_tmp5_ = TRUE;
				while (TRUE) {
					gint _tmp6_;
					ClutterTableLayout* _tmp7_ = NULL;
					ClutterTableLayout* table_layout;
					ClutterBox* _tmp8_ = NULL;
					ClutterBox* grid;
					gfloat _tmp9_;
					gfloat _tmp10_;
					if (!_tmp5_) {
						i++;
					}
					_tmp5_ = FALSE;
					_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects);
					if (!(i <= (_tmp6_ / EFFECTS_PER_PAGE))) {
						break;
					}
					_tmp7_ = (ClutterTableLayout*) clutter_table_layout_new ();
					table_layout = g_object_ref_sink (_tmp7_);
					_tmp8_ = (ClutterBox*) clutter_box_new ((ClutterLayoutManager*) table_layout);
					grid = g_object_ref_sink (_tmp8_);
					gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->effects_grids, grid);
					_tmp9_ = clutter_actor_get_width ((ClutterActor*) self->priv->viewport);
					_tmp10_ = clutter_actor_get_height ((ClutterActor*) self->priv->viewport);
					clutter_actor_set_size ((ClutterActor*) grid, _tmp9_, _tmp10_);
					clutter_table_layout_set_column_spacing (table_layout, (guint) 10);
					clutter_table_layout_set_row_spacing (table_layout, (guint) 10);
					_g_object_unref0 (grid);
					_g_object_unref0 (table_layout);
				}
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp11_;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint _tmp12_;
					gpointer _tmp13_ = NULL;
					CheeseEffect* effect;
					ClutterTexture* _tmp14_ = NULL;
					ClutterTexture* texture;
					ClutterBinLayout* _tmp15_ = NULL;
					ClutterBinLayout* layout;
					ClutterBox* _tmp16_ = NULL;
					ClutterBox* box;
					ClutterText* _tmp17_ = NULL;
					ClutterText* text;
					ClutterRectangle* _tmp18_ = NULL;
					ClutterRectangle* rect;
					ClutterColor _tmp19_ = {0};
					ClutterColor _tmp20_ = {0};
					CheeseEffect* _tmp21_;
					ClutterTexture* _tmp22_;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
					ClutterColor _tmp25_ = {0};
					ClutterColor _tmp26_ = {0};
					gfloat _tmp27_;
					gpointer _tmp28_ = NULL;
					ClutterBox* _tmp29_;
					ClutterLayoutManager* _tmp30_ = NULL;
					ClutterTableLayout* _tmp31_;
					ClutterTableLayout* _tmp32_;
					ClutterTableLayout* table_layout;
					gfloat _tmp33_;
					guint _tmp34_;
					gfloat _tmp35_;
					guint _tmp36_;
					if (!_tmp11_) {
						i++;
					}
					_tmp11_ = FALSE;
					_tmp12_ = gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects);
					if (!(i < _tmp12_)) {
						break;
					}
					_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_manager->effects, i);
					effect = (CheeseEffect*) _tmp13_;
					_tmp14_ = (ClutterTexture*) clutter_texture_new ();
					texture = g_object_ref_sink (_tmp14_);
					_tmp15_ = (ClutterBinLayout*) clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_FILL, CLUTTER_BIN_ALIGNMENT_FILL);
					layout = g_object_ref_sink (_tmp15_);
					_tmp16_ = (ClutterBox*) clutter_box_new ((ClutterLayoutManager*) layout);
					box = g_object_ref_sink (_tmp16_);
					_tmp17_ = (ClutterText*) clutter_text_new ();
					text = g_object_ref_sink (_tmp17_);
					_tmp18_ = (ClutterRectangle*) clutter_rectangle_new ();
					rect = g_object_ref_sink (_tmp18_);
					clutter_actor_set_opacity ((ClutterActor*) rect, (guint) 128);
					clutter_color_from_string (&_tmp19_, "black");
					_tmp20_ = _tmp19_;
					clutter_rectangle_set_color (rect, &_tmp20_);
					clutter_box_pack (box, CLUTTER_ACTOR (texture), "x-align", CLUTTER_BIN_ALIGNMENT_FILL, "y-align", CLUTTER_BIN_ALIGNMENT_FILL, NULL, NULL);
					clutter_actor_set_reactive ((ClutterActor*) box, TRUE);
					_tmp21_ = _g_object_ref0 (effect);
					g_object_set_data_full ((GObject*) box, "effect", _tmp21_, g_object_unref);
					_tmp22_ = _g_object_ref0 (texture);
					g_object_set_data_full ((GObject*) effect, "texture", _tmp22_, g_object_unref);
					g_signal_connect_object ((ClutterActor*) box, "button-release-event", (GCallback) _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event, self, 0);
					_tmp24_ = (g_object_get (effect, "name", &_tmp23_, NULL), _tmp23_);
					clutter_text_set_text (text, _tmp24_);
					_g_free0 (_tmp24_);
					clutter_color_from_string (&_tmp25_, "white");
					_tmp26_ = _tmp25_;
					clutter_text_set_color (text, &_tmp26_);
					_tmp27_ = clutter_actor_get_height ((ClutterActor*) text);
					clutter_actor_set_height ((ClutterActor*) rect, _tmp27_ + 5);
					clutter_box_pack (box, CLUTTER_ACTOR (rect), "x-align", CLUTTER_BIN_ALIGNMENT_FILL, "y-align", CLUTTER_BIN_ALIGNMENT_END, NULL, NULL);
					clutter_box_pack (box, CLUTTER_ACTOR (text), "x-align", CLUTTER_BIN_ALIGNMENT_CENTER, "y-align", CLUTTER_BIN_ALIGNMENT_END, NULL, NULL);
					_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_grids, i / EFFECTS_PER_PAGE);
					_tmp29_ = (ClutterBox*) _tmp28_;
					_tmp30_ = clutter_box_get_layout_manager (_tmp29_);
					_tmp31_ = _g_object_ref0 (CLUTTER_TABLE_LAYOUT (_tmp30_));
					table_layout = (_tmp32_ = _tmp31_, _g_object_unref0 (_tmp29_), _tmp32_);
					_tmp33_ = clutter_actor_get_width ((ClutterActor*) self->priv->viewport);
					_tmp34_ = clutter_table_layout_get_column_spacing (table_layout);
					clutter_actor_set_width ((ClutterActor*) box, (_tmp33_ - (2 * _tmp34_)) / 3);
					_tmp35_ = clutter_actor_get_height ((ClutterActor*) self->priv->viewport);
					_tmp36_ = clutter_table_layout_get_row_spacing (table_layout);
					clutter_actor_set_height ((ClutterActor*) box, (_tmp35_ - (2 * _tmp36_)) / 3);
					clutter_table_layout_pack (table_layout, CLUTTER_ACTOR (box), (i % EFFECTS_PER_PAGE) % 3, (i % EFFECTS_PER_PAGE) / 3);
					clutter_table_layout_set_expand (table_layout, (ClutterActor*) box, FALSE, FALSE);
					_g_object_unref0 (table_layout);
					_g_object_unref0 (rect);
					_g_object_unref0 (text);
					_g_object_unref0 (box);
					_g_object_unref0 (layout);
					_g_object_unref0 (texture);
					_g_object_unref0 (effect);
				}
			}
		}
		cheese_main_window_setup_effects_page_switch_sensitivity (self);
		_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_grids, 0);
		_tmp38_ = (ClutterBox*) _tmp37_;
		_g_object_unref0 (self->priv->current_effects_grid);
		self->priv->current_effects_grid = _tmp38_;
	}
}


void cheese_main_window_toggle_camera_actions_sensitivities (CheeseMainWindow* self, gboolean active) {
	g_return_if_fail (self != NULL);
	self->priv->is_camera_actions_sensitive = active;
	if (active) {
		{
			GeeSet* _tmp0_ = NULL;
			GeeSet* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _key_it;
			_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->action_sensitivities);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_key_it = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				gchar* key;
				GObject* _tmp6_ = NULL;
				GtkAction* _tmp7_;
				GtkAction* action;
				gpointer _tmp8_ = NULL;
				_tmp4_ = gee_iterator_next (_key_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_key_it);
				key = (gchar*) _tmp5_;
				_tmp6_ = gtk_builder_get_object (self->priv->gtk_builder, key);
				_tmp7_ = _g_object_ref0 (GTK_ACTION (_tmp6_));
				action = _tmp7_;
				_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->action_sensitivities, key);
				gtk_action_set_sensitive (action, GPOINTER_TO_INT (_tmp8_));
				_g_object_unref0 (action);
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
	} else {
		GeeHashMap* _tmp9_ = NULL;
		GeeHashMap* _tmp10_;
		GSList* _tmp11_ = NULL;
		GSList* objects;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar** _tmp27_ = NULL;
		gchar** active_actions;
		gint active_actions_length1;
		gint _active_actions_size_;
		gboolean flag = FALSE;
		_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_BOOLEAN, NULL, NULL, g_str_hash, NULL, NULL);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (self->priv->action_sensitivities);
		self->priv->action_sensitivities = _tmp10_;
		_tmp11_ = gtk_builder_get_objects (self->priv->gtk_builder);
		objects = _tmp11_;
		{
			GSList* obj_collection;
			GSList* obj_it;
			obj_collection = objects;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GObject* _tmp12_;
				GObject* obj;
				_tmp12_ = _g_object_ref0 ((GObject*) obj_it->data);
				obj = _tmp12_;
				{
					if (GTK_IS_ACTION (obj)) {
						GtkAction* _tmp13_;
						GtkAction* action;
						const gchar* _tmp14_ = NULL;
						gboolean _tmp15_;
						_tmp13_ = _g_object_ref0 (GTK_ACTION (obj));
						action = _tmp13_;
						_tmp14_ = gtk_action_get_name (action);
						_tmp15_ = gtk_action_get_sensitive (action);
						gee_abstract_map_set ((GeeAbstractMap*) self->priv->action_sensitivities, _tmp14_, GINT_TO_POINTER (_tmp15_));
						_g_object_unref0 (action);
					}
					_g_object_unref0 (obj);
				}
			}
		}
		_tmp16_ = g_strdup ("cheese_action");
		_tmp17_ = g_strdup ("edit_action");
		_tmp18_ = g_strdup ("help_action");
		_tmp19_ = g_strdup ("quit");
		_tmp20_ = g_strdup ("help_contents");
		_tmp21_ = g_strdup ("about");
		_tmp22_ = g_strdup ("open");
		_tmp23_ = g_strdup ("save_as");
		_tmp24_ = g_strdup ("move_to_trash");
		_tmp25_ = g_strdup ("delete");
		_tmp26_ = g_strdup ("move_all_to_trash");
		_tmp27_ = g_new0 (gchar*, 11 + 1);
		_tmp27_[0] = _tmp16_;
		_tmp27_[1] = _tmp17_;
		_tmp27_[2] = _tmp18_;
		_tmp27_[3] = _tmp19_;
		_tmp27_[4] = _tmp20_;
		_tmp27_[5] = _tmp21_;
		_tmp27_[6] = _tmp22_;
		_tmp27_[7] = _tmp23_;
		_tmp27_[8] = _tmp24_;
		_tmp27_[9] = _tmp25_;
		_tmp27_[10] = _tmp26_;
		active_actions = _tmp27_;
		active_actions_length1 = 11;
		_active_actions_size_ = 11;
		{
			GSList* obj_collection;
			GSList* obj_it;
			obj_collection = objects;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GObject* _tmp28_;
				GObject* obj;
				_tmp28_ = _g_object_ref0 ((GObject*) obj_it->data);
				obj = _tmp28_;
				{
					flag = FALSE;
					if (GTK_IS_ACTION (obj)) {
						GtkAction* _tmp29_;
						GtkAction* action;
						_tmp29_ = _g_object_ref0 (GTK_ACTION (obj));
						action = _tmp29_;
						{
							gchar** s_collection;
							int s_collection_length1;
							int s_it;
							s_collection = active_actions;
							s_collection_length1 = active_actions_length1;
							for (s_it = 0; s_it < active_actions_length1; s_it = s_it + 1) {
								gchar* _tmp30_;
								gchar* s;
								_tmp30_ = g_strdup (s_collection[s_it]);
								s = _tmp30_;
								{
									const gchar* _tmp31_ = NULL;
									_tmp31_ = gtk_action_get_name (action);
									if (g_strcmp0 (_tmp31_, s) == 0) {
										flag = TRUE;
									}
									_g_free0 (s);
								}
							}
						}
						if (!flag) {
							gtk_action_set_sensitive (GTK_ACTION (obj), FALSE);
						}
						_g_object_unref0 (action);
					}
					_g_object_unref0 (obj);
				}
			}
		}
		active_actions = (_vala_array_free (active_actions, active_actions_length1, (GDestroyNotify) g_free), NULL);
		_g_slist_free0 (objects);
	}
}


static void cheese_main_window_camera_state_changed (CheeseMainWindow* self, GstState new_state) {
	g_return_if_fail (self != NULL);
	if (new_state == GST_STATE_PLAYING) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		CheeseEffect* _tmp2_ = NULL;
		CheeseEffect* _tmp3_;
		CheeseEffect* effect;
		if (!self->priv->is_camera_actions_sensitive) {
			cheese_main_window_toggle_camera_actions_sensitivities (self, TRUE);
		}
		_tmp0_ = g_settings_get_string (self->priv->settings, "selected-effect");
		_tmp1_ = _tmp0_;
		_tmp2_ = cheese_effects_manager_get_effect (self->priv->effects_manager, _tmp1_);
		effect = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
		if (effect != NULL) {
			cheese_camera_set_effect (self->priv->camera, effect);
		}
		_g_object_unref0 (effect);
	}
}


void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->is_wide_mode) {
		return;
	}
	self->priv->is_command_line_startup = TRUE;
	gtk_toggle_action_set_active (self->priv->wide_mode_action, TRUE);
	self->priv->is_command_line_startup = FALSE;
}


void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	self->priv->is_command_line_startup = TRUE;
	gtk_toggle_action_set_active (self->priv->fullscreen_action, TRUE);
	self->priv->is_command_line_startup = FALSE;
}


static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* p0, ClutterAllocationFlags p1, gpointer self) {
	cheese_main_window_on_stage_resize (self, _sender, p0, p1);
}


static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_thumbnail_mouse_button_press (self, _sender, event);
	return result;
}


static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_key_release (self, event);
	return result;
}


void cheese_main_window_setup_ui (CheeseMainWindow* self) {
	GtkBuilder* _tmp0_ = NULL;
	GtkBuilder* _tmp1_;
	ClutterScript* _tmp2_ = NULL;
	ClutterScript* _tmp3_;
	CheeseFileUtil* _tmp4_ = NULL;
	CheeseFileUtil* _tmp5_;
	CheeseFlash* _tmp6_ = NULL;
	CheeseFlash* _tmp7_;
	GSettings* _tmp8_ = NULL;
	GSettings* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	GObject* _tmp18_ = NULL;
	GtkVBox* _tmp19_;
	GtkVBox* _tmp20_;
	GObject* _tmp21_ = NULL;
	GtkWidget* _tmp22_;
	GtkWidget* _tmp23_;
	GObject* _tmp24_ = NULL;
	GtkClutterEmbed* _tmp25_;
	GtkClutterEmbed* _tmp26_;
	ClutterActor* _tmp27_ = NULL;
	ClutterStage* _tmp28_;
	ClutterStage* _tmp29_;
	GObject* _tmp30_ = NULL;
	GtkAlignment* _tmp31_;
	GtkAlignment* _tmp32_;
	GObject* _tmp33_ = NULL;
	GtkAlignment* _tmp34_;
	GtkAlignment* _tmp35_;
	GObject* _tmp36_ = NULL;
	GtkMenuBar* _tmp37_;
	GtkMenuBar* _tmp38_;
	GObject* _tmp39_ = NULL;
	GtkHBox* _tmp40_;
	GtkHBox* _tmp41_;
	GObject* _tmp42_ = NULL;
	GtkToggleButton* _tmp43_;
	GtkToggleButton* _tmp44_;
	GObject* _tmp45_ = NULL;
	GtkToggleButton* _tmp46_;
	GtkToggleButton* _tmp47_;
	GObject* _tmp48_ = NULL;
	GtkToggleButton* _tmp49_;
	GtkToggleButton* _tmp50_;
	GObject* _tmp51_ = NULL;
	GtkButton* _tmp52_;
	GtkButton* _tmp53_;
	GObject* _tmp54_ = NULL;
	GtkLabel* _tmp55_;
	GtkLabel* _tmp56_;
	GObject* _tmp57_ = NULL;
	GtkImage* _tmp58_;
	GtkImage* _tmp59_;
	GObject* _tmp60_ = NULL;
	GtkToggleButton* _tmp61_;
	GtkToggleButton* _tmp62_;
	GObject* _tmp63_ = NULL;
	GtkButton* _tmp64_;
	GtkButton* _tmp65_;
	GObject* _tmp66_ = NULL;
	GtkHBox* _tmp67_;
	GtkHBox* _tmp68_;
	GObject* _tmp69_ = NULL;
	GtkMenu* _tmp70_;
	GtkMenu* _tmp71_;
	GObject* _tmp72_ = NULL;
	GtkAction* _tmp73_;
	GtkAction* _tmp74_;
	GObject* _tmp75_ = NULL;
	GtkAction* _tmp76_;
	GtkAction* _tmp77_;
	GObject* _tmp78_ = NULL;
	GtkAction* _tmp79_;
	GtkAction* _tmp80_;
	GObject* _tmp81_ = NULL;
	GtkAction* _tmp82_;
	GtkAction* _tmp83_;
	GObject* _tmp84_ = NULL;
	GtkAction* _tmp85_;
	GtkAction* _tmp86_;
	GObject* _tmp87_ = NULL;
	GtkAction* _tmp88_;
	GtkAction* _tmp89_;
	GObject* _tmp90_ = NULL;
	GtkToggleAction* _tmp91_;
	GtkToggleAction* _tmp92_;
	GObject* _tmp93_ = NULL;
	GtkAction* _tmp94_;
	GtkAction* _tmp95_;
	GObject* _tmp96_ = NULL;
	GtkToggleAction* _tmp97_;
	GtkToggleAction* _tmp98_;
	GObject* _tmp99_ = NULL;
	GtkToggleAction* _tmp100_;
	GtkToggleAction* _tmp101_;
	GObject* _tmp102_ = NULL;
	GtkAction* _tmp103_;
	GtkAction* _tmp104_;
	GObject* _tmp105_ = NULL;
	GtkAction* _tmp106_;
	GtkAction* _tmp107_;
	GtkButton* _tmp108_;
	GtkButton* _tmp109_;
	GtkButton* _tmp110_;
	GtkButton* _tmp111_;
	GtkButton* _tmp112_;
	GtkButton* _tmp113_;
	GtkButton** _tmp114_ = NULL;
	GtkButton** _tmp115_;
	GObject* _tmp116_ = NULL;
	ClutterTexture* _tmp117_;
	ClutterTexture* _tmp118_;
	GObject* _tmp119_ = NULL;
	ClutterBox* _tmp120_;
	ClutterBox* _tmp121_;
	GObject* _tmp122_ = NULL;
	ClutterBinLayout* _tmp123_;
	ClutterBinLayout* _tmp124_;
	GObject* _tmp125_ = NULL;
	ClutterText* _tmp126_;
	ClutterText* _tmp127_;
	GObject* _tmp128_ = NULL;
	ClutterRectangle* _tmp129_;
	ClutterRectangle* _tmp130_;
	GObject* _tmp131_ = NULL;
	ClutterText* _tmp132_;
	ClutterText* _tmp133_;
	CheeseThumbView* _tmp134_ = NULL;
	CheeseThumbView* _tmp135_;
	EogThumbNav* _tmp136_ = NULL;
	EogThumbNav* _tmp137_;
	GtkCssProvider* css = NULL;
	GtkCssProvider* _tmp138_ = NULL;
	GtkCssProvider* _tmp139_;
	gchar* _tmp140_ = NULL;
	gchar* _tmp141_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp142_ = NULL;
	GtkStyleContext* _tmp143_;
	GtkStyleContext* _tmp144_;
	GdkScreen* _tmp145_ = NULL;
	GdkScreen* _tmp146_ = NULL;
	gboolean _tmp147_;
	gboolean _tmp148_;
	gboolean _tmp149_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->gtk_builder);
	self->priv->gtk_builder = _tmp1_;
	_tmp2_ = clutter_script_new ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->clutter_builder);
	self->priv->clutter_builder = _tmp3_;
	_tmp4_ = cheese_fileutil_new ();
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->priv->fileutil);
	self->priv->fileutil = _tmp5_;
	_tmp6_ = cheese_flash_new ((GtkWidget*) self);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp7_;
	_tmp8_ = g_settings_new ("org.gnome.Cheese");
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp9_;
	_tmp10_ = g_build_filename (PACKAGE_DATADIR, "cheese-actions.ui", NULL);
	_tmp11_ = _tmp10_;
	gtk_builder_add_from_file (self->priv->gtk_builder, _tmp11_, &_inner_error_);
	_g_free0 (_tmp11_);
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	_tmp12_ = g_build_filename (PACKAGE_DATADIR, "cheese-about.ui", NULL);
	_tmp13_ = _tmp12_;
	gtk_builder_add_from_file (self->priv->gtk_builder, _tmp13_, &_inner_error_);
	_g_free0 (_tmp13_);
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	_tmp14_ = g_build_filename (PACKAGE_DATADIR, "cheese-main-window.ui", NULL);
	_tmp15_ = _tmp14_;
	gtk_builder_add_from_file (self->priv->gtk_builder, _tmp15_, &_inner_error_);
	_g_free0 (_tmp15_);
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	gtk_builder_connect_signals (self->priv->gtk_builder, self);
	_tmp16_ = g_build_filename (PACKAGE_DATADIR, "cheese-viewport.json", NULL);
	_tmp17_ = _tmp16_;
	clutter_script_load_from_file (self->priv->clutter_builder, _tmp17_, &_inner_error_);
	_g_free0 (_tmp17_);
	if (_inner_error_ != NULL) {
		goto __catch8_g_error;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_error ("cheese-window.vala:1128: Error: %s", err->message);
		_g_error_free0 (err);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp18_ = gtk_builder_get_object (self->priv->gtk_builder, "mainbox_normal");
	_tmp19_ = _g_object_ref0 (GTK_VBOX (_tmp18_));
	_tmp20_ = _tmp19_;
	_g_object_unref0 (self->priv->main_vbox);
	self->priv->main_vbox = _tmp20_;
	_tmp21_ = gtk_builder_get_object (self->priv->gtk_builder, "thumbnails");
	_tmp22_ = _g_object_ref0 (GTK_WIDGET (_tmp21_));
	_tmp23_ = _tmp22_;
	_g_object_unref0 (self->priv->thumbnails);
	self->priv->thumbnails = _tmp23_;
	_tmp24_ = gtk_builder_get_object (self->priv->gtk_builder, "viewport");
	_tmp25_ = _g_object_ref0 (GTK_CLUTTER_EMBED (_tmp24_));
	_tmp26_ = _tmp25_;
	_g_object_unref0 (self->priv->viewport_widget);
	self->priv->viewport_widget = _tmp26_;
	_tmp27_ = gtk_clutter_embed_get_stage (self->priv->viewport_widget);
	_tmp28_ = _g_object_ref0 (CLUTTER_STAGE (_tmp27_));
	_tmp29_ = _tmp28_;
	_g_object_unref0 (self->priv->viewport);
	self->priv->viewport = _tmp29_;
	_tmp30_ = gtk_builder_get_object (self->priv->gtk_builder, "thumbnails_right");
	_tmp31_ = _g_object_ref0 (GTK_ALIGNMENT (_tmp30_));
	_tmp32_ = _tmp31_;
	_g_object_unref0 (self->priv->thumbnails_right);
	self->priv->thumbnails_right = _tmp32_;
	_tmp33_ = gtk_builder_get_object (self->priv->gtk_builder, "thumbnails_bottom");
	_tmp34_ = _g_object_ref0 (GTK_ALIGNMENT (_tmp33_));
	_tmp35_ = _tmp34_;
	_g_object_unref0 (self->priv->thumbnails_bottom);
	self->priv->thumbnails_bottom = _tmp35_;
	_tmp36_ = gtk_builder_get_object (self->priv->gtk_builder, "main_menubar");
	_tmp37_ = _g_object_ref0 (GTK_MENU_BAR (_tmp36_));
	_tmp38_ = _tmp37_;
	_g_object_unref0 (self->priv->menubar);
	self->priv->menubar = _tmp38_;
	_tmp39_ = gtk_builder_get_object (self->priv->gtk_builder, "leave_fullscreen_button_bin");
	_tmp40_ = _g_object_ref0 (GTK_HBOX (_tmp39_));
	_tmp41_ = _tmp40_;
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	self->priv->leave_fullscreen_button_container = _tmp41_;
	_tmp42_ = gtk_builder_get_object (self->priv->gtk_builder, "photo_toggle_button");
	_tmp43_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (_tmp42_));
	_tmp44_ = _tmp43_;
	_g_object_unref0 (self->priv->photo_toggle_button);
	self->priv->photo_toggle_button = _tmp44_;
	_tmp45_ = gtk_builder_get_object (self->priv->gtk_builder, "video_toggle_button");
	_tmp46_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (_tmp45_));
	_tmp47_ = _tmp46_;
	_g_object_unref0 (self->priv->video_toggle_button);
	self->priv->video_toggle_button = _tmp47_;
	_tmp48_ = gtk_builder_get_object (self->priv->gtk_builder, "burst_toggle_button");
	_tmp49_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (_tmp48_));
	_tmp50_ = _tmp49_;
	_g_object_unref0 (self->priv->burst_toggle_button);
	self->priv->burst_toggle_button = _tmp50_;
	_tmp51_ = gtk_builder_get_object (self->priv->gtk_builder, "take_action_button");
	_tmp52_ = _g_object_ref0 (GTK_BUTTON (_tmp51_));
	_tmp53_ = _tmp52_;
	_g_object_unref0 (self->priv->take_action_button);
	self->priv->take_action_button = _tmp53_;
	_tmp54_ = gtk_builder_get_object (self->priv->gtk_builder, "take_action_button_internal_label");
	_tmp55_ = _g_object_ref0 (GTK_LABEL (_tmp54_));
	_tmp56_ = _tmp55_;
	_g_object_unref0 (self->priv->take_action_button_label);
	self->priv->take_action_button_label = _tmp56_;
	_tmp57_ = gtk_builder_get_object (self->priv->gtk_builder, "take_action_button_internal_image");
	_tmp58_ = _g_object_ref0 (GTK_IMAGE (_tmp57_));
	_tmp59_ = _tmp58_;
	_g_object_unref0 (self->priv->take_action_button_image);
	self->priv->take_action_button_image = _tmp59_;
	_tmp60_ = gtk_builder_get_object (self->priv->gtk_builder, "effects_toggle_button");
	_tmp61_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (_tmp60_));
	_tmp62_ = _tmp61_;
	_g_object_unref0 (self->priv->effects_toggle_button);
	self->priv->effects_toggle_button = _tmp62_;
	_tmp63_ = gtk_builder_get_object (self->priv->gtk_builder, "leave_fullscreen_button");
	_tmp64_ = _g_object_ref0 (GTK_BUTTON (_tmp63_));
	_tmp65_ = _tmp64_;
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	self->priv->leave_fullscreen_button = _tmp65_;
	_tmp66_ = gtk_builder_get_object (self->priv->gtk_builder, "buttons_area");
	_tmp67_ = _g_object_ref0 (GTK_HBOX (_tmp66_));
	_tmp68_ = _tmp67_;
	_g_object_unref0 (self->priv->buttons_area);
	self->priv->buttons_area = _tmp68_;
	_tmp69_ = gtk_builder_get_object (self->priv->gtk_builder, "thumbnail_popup");
	_tmp70_ = _g_object_ref0 (GTK_MENU (_tmp69_));
	_tmp71_ = _tmp70_;
	_g_object_unref0 (self->priv->thumbnail_popup);
	self->priv->thumbnail_popup = _tmp71_;
	_tmp72_ = gtk_builder_get_object (self->priv->gtk_builder, "take_photo");
	_tmp73_ = _g_object_ref0 (GTK_ACTION (_tmp72_));
	_tmp74_ = _tmp73_;
	_g_object_unref0 (self->priv->take_photo_action);
	self->priv->take_photo_action = _tmp74_;
	_tmp75_ = gtk_builder_get_object (self->priv->gtk_builder, "take_video");
	_tmp76_ = _g_object_ref0 (GTK_ACTION (_tmp75_));
	_tmp77_ = _tmp76_;
	_g_object_unref0 (self->priv->take_video_action);
	self->priv->take_video_action = _tmp77_;
	_tmp78_ = gtk_builder_get_object (self->priv->gtk_builder, "take_burst");
	_tmp79_ = _g_object_ref0 (GTK_ACTION (_tmp78_));
	_tmp80_ = _tmp79_;
	_g_object_unref0 (self->priv->take_burst_action);
	self->priv->take_burst_action = _tmp80_;
	_tmp81_ = gtk_builder_get_object (self->priv->gtk_builder, "photo_mode");
	_tmp82_ = _g_object_ref0 (GTK_ACTION (_tmp81_));
	_tmp83_ = _tmp82_;
	_g_object_unref0 (self->priv->photo_mode_action);
	self->priv->photo_mode_action = _tmp83_;
	_tmp84_ = gtk_builder_get_object (self->priv->gtk_builder, "video_mode");
	_tmp85_ = _g_object_ref0 (GTK_ACTION (_tmp84_));
	_tmp86_ = _tmp85_;
	_g_object_unref0 (self->priv->video_mode_action);
	self->priv->video_mode_action = _tmp86_;
	_tmp87_ = gtk_builder_get_object (self->priv->gtk_builder, "burst_mode");
	_tmp88_ = _g_object_ref0 (GTK_ACTION (_tmp87_));
	_tmp89_ = _tmp88_;
	_g_object_unref0 (self->priv->burst_mode_action);
	self->priv->burst_mode_action = _tmp89_;
	_tmp90_ = gtk_builder_get_object (self->priv->gtk_builder, "effects_toggle");
	_tmp91_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp90_));
	_tmp92_ = _tmp91_;
	_g_object_unref0 (self->priv->effects_toggle_action);
	self->priv->effects_toggle_action = _tmp92_;
	_tmp93_ = gtk_builder_get_object (self->priv->gtk_builder, "countdown");
	_tmp94_ = _g_object_ref0 (GTK_ACTION (_tmp93_));
	_tmp95_ = _tmp94_;
	_g_object_unref0 (self->priv->countdown_action);
	self->priv->countdown_action = _tmp95_;
	_tmp96_ = gtk_builder_get_object (self->priv->gtk_builder, "wide_mode");
	_tmp97_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp96_));
	_tmp98_ = _tmp97_;
	_g_object_unref0 (self->priv->wide_mode_action);
	self->priv->wide_mode_action = _tmp98_;
	_tmp99_ = gtk_builder_get_object (self->priv->gtk_builder, "fullscreen");
	_tmp100_ = _g_object_ref0 (GTK_TOGGLE_ACTION (_tmp99_));
	_tmp101_ = _tmp100_;
	_g_object_unref0 (self->priv->fullscreen_action);
	self->priv->fullscreen_action = _tmp101_;
	_tmp102_ = gtk_builder_get_object (self->priv->gtk_builder, "effects_page_next");
	_tmp103_ = _g_object_ref0 (GTK_ACTION (_tmp102_));
	_tmp104_ = _tmp103_;
	_g_object_unref0 (self->priv->effects_page_next_action);
	self->priv->effects_page_next_action = _tmp104_;
	_tmp105_ = gtk_builder_get_object (self->priv->gtk_builder, "effects_page_prev");
	_tmp106_ = _g_object_ref0 (GTK_ACTION (_tmp105_));
	_tmp107_ = _tmp106_;
	_g_object_unref0 (self->priv->effects_page_prev_action);
	self->priv->effects_page_prev_action = _tmp107_;
	_tmp108_ = _g_object_ref0 ((GtkButton*) self->priv->photo_toggle_button);
	_tmp109_ = _g_object_ref0 ((GtkButton*) self->priv->video_toggle_button);
	_tmp110_ = _g_object_ref0 ((GtkButton*) self->priv->burst_toggle_button);
	_tmp111_ = _g_object_ref0 (self->priv->take_action_button);
	_tmp112_ = _g_object_ref0 ((GtkButton*) self->priv->effects_toggle_button);
	_tmp113_ = _g_object_ref0 (self->priv->leave_fullscreen_button);
	_tmp114_ = g_new0 (GtkButton*, 6 + 1);
	_tmp114_[0] = _tmp108_;
	_tmp114_[1] = _tmp109_;
	_tmp114_[2] = _tmp110_;
	_tmp114_[3] = _tmp111_;
	_tmp114_[4] = _tmp112_;
	_tmp114_[5] = _tmp113_;
	_tmp115_ = _tmp114_;
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->buttons_length1 = 6;
	self->priv->_buttons_size_ = self->priv->buttons_length1;
	self->priv->buttons = _tmp115_;
	_tmp116_ = clutter_script_get_object (self->priv->clutter_builder, "video_preview");
	_tmp117_ = _g_object_ref0 (CLUTTER_TEXTURE (_tmp116_));
	_tmp118_ = _tmp117_;
	_g_object_unref0 (self->priv->video_preview);
	self->priv->video_preview = _tmp118_;
	_tmp119_ = clutter_script_get_object (self->priv->clutter_builder, "viewport_layout");
	_tmp120_ = _g_object_ref0 (CLUTTER_BOX (_tmp119_));
	_tmp121_ = _tmp120_;
	_g_object_unref0 (self->priv->viewport_layout);
	self->priv->viewport_layout = _tmp121_;
	_tmp122_ = clutter_script_get_object (self->priv->clutter_builder, "viewport_layout_manager");
	_tmp123_ = _g_object_ref0 (CLUTTER_BIN_LAYOUT (_tmp122_));
	_tmp124_ = _tmp123_;
	_g_object_unref0 (self->priv->viewport_layout_manager);
	self->priv->viewport_layout_manager = _tmp124_;
	_tmp125_ = clutter_script_get_object (self->priv->clutter_builder, "countdown_layer");
	_tmp126_ = _g_object_ref0 (CLUTTER_TEXT (_tmp125_));
	_tmp127_ = _tmp126_;
	_g_object_unref0 (self->priv->countdown_layer);
	self->priv->countdown_layer = _tmp127_;
	_tmp128_ = clutter_script_get_object (self->priv->clutter_builder, "background");
	_tmp129_ = _g_object_ref0 (CLUTTER_RECTANGLE (_tmp128_));
	_tmp130_ = _tmp129_;
	_g_object_unref0 (self->priv->background_layer);
	self->priv->background_layer = _tmp130_;
	_tmp131_ = clutter_script_get_object (self->priv->clutter_builder, "error_layer");
	_tmp132_ = _g_object_ref0 (CLUTTER_TEXT (_tmp131_));
	_tmp133_ = _tmp132_;
	_g_object_unref0 (self->priv->error_layer);
	self->priv->error_layer = _tmp133_;
	clutter_texture_set_keep_aspect_ratio (self->priv->video_preview, TRUE);
	clutter_actor_set_request_mode ((ClutterActor*) self->priv->video_preview, CLUTTER_REQUEST_HEIGHT_FOR_WIDTH);
	clutter_container_add_actor ((ClutterContainer*) self->priv->viewport, (ClutterActor*) self->priv->background_layer);
	clutter_box_set_layout_manager (self->priv->viewport_layout, (ClutterLayoutManager*) self->priv->viewport_layout_manager);
	clutter_container_add_actor ((ClutterContainer*) self->priv->viewport, (ClutterActor*) self->priv->viewport_layout);
	g_signal_connect_object ((ClutterActor*) self->priv->viewport, "allocation-changed", (GCallback) _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed, self, 0);
	_tmp134_ = cheese_thumb_view_new ();
	_tmp135_ = g_object_ref_sink (_tmp134_);
	_g_object_unref0 (self->priv->thumb_view);
	self->priv->thumb_view = _tmp135_;
	_tmp136_ = eog_thumb_nav_new ((GtkWidget*) self->priv->thumb_view, FALSE);
	_tmp137_ = g_object_ref_sink (_tmp136_);
	_g_object_unref0 (self->priv->thumb_nav);
	self->priv->thumb_nav = _tmp137_;
	_tmp138_ = gtk_css_provider_new ();
	_tmp139_ = _tmp138_;
	_g_object_unref0 (css);
	css = _tmp139_;
	_tmp140_ = g_build_filename (PACKAGE_DATADIR, "cheese.css", NULL);
	_tmp141_ = _tmp140_;
	gtk_css_provider_load_from_path (css, _tmp141_, &_inner_error_);
	_g_free0 (_tmp141_);
	if (_inner_error_ != NULL) {
		goto __catch9_g_error;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "Error: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (css);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp142_ = gtk_widget_get_style_context ((GtkWidget*) self->priv->thumb_view);
	_tmp143_ = _g_object_ref0 (_tmp142_);
	_tmp144_ = _tmp143_;
	_g_object_unref0 (context);
	context = _tmp144_;
	_tmp145_ = gdk_screen_get_default ();
	gtk_window_set_screen ((GtkWindow*) self, _tmp145_);
	_tmp146_ = gtk_window_get_screen ((GtkWindow*) self);
	gtk_style_context_add_provider_for_screen (_tmp146_, (GtkStyleProvider*) css, (guint) 600);
	g_signal_connect_object ((GtkWidget*) self->priv->thumb_view, "button-press-event", (GCallback) _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event, self, 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->main_vbox);
	gtk_widget_show_all ((GtkWidget*) self->priv->main_vbox);
	gtk_widget_realize ((GtkWidget*) self->priv->viewport_widget);
	_tmp147_ = g_settings_get_boolean (self->priv->settings, "wide-mode");
	gtk_toggle_action_set_active (self->priv->wide_mode_action, _tmp147_);
	_tmp148_ = g_settings_get_boolean (self->priv->settings, "wide-mode");
	if (!_tmp148_) {
		gtk_toggle_action_toggled (self->priv->wide_mode_action);
	}
	cheese_main_window_set_mode (self, CHEESE_MEDIA_MODE_PHOTO);
	cheese_main_window_setup_effects_selector (self);
	cheese_main_window_toggle_camera_actions_sensitivities (self, FALSE);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _cheese_main_window_on_key_release_gtk_widget_key_release_event, self, 0);
	_tmp149_ = g_settings_get_boolean (self->priv->settings, "fullscreen");
	if (_tmp149_) {
		gtk_toggle_action_set_active (self->priv->fullscreen_action, TRUE);
	}
	_g_object_unref0 (context);
	_g_object_unref0 (css);
}


static void _cheese_main_window_camera_state_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender, GstState new_state, gpointer self) {
	cheese_main_window_camera_state_changed (self, new_state);
}


void cheese_main_window_setup_camera (CheeseMainWindow* self, const gchar* uri) {
	gchar* device = NULL;
	gdouble value = 0.0;
	gboolean _tmp0_ = FALSE;
	gint _tmp6_;
	gint _tmp7_;
	CheeseCamera* _tmp8_ = NULL;
	CheeseCamera* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (uri != NULL) {
		gint _tmp1_;
		_tmp1_ = strlen (uri);
		_tmp0_ = _tmp1_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup (uri);
		_tmp3_ = _tmp2_;
		_g_free0 (device);
		device = _tmp3_;
	} else {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = g_settings_get_string (self->priv->settings, "camera");
		_tmp5_ = _tmp4_;
		_g_free0 (device);
		device = _tmp5_;
	}
	_tmp6_ = g_settings_get_int (self->priv->settings, "photo-x-resolution");
	_tmp7_ = g_settings_get_int (self->priv->settings, "photo-y-resolution");
	_tmp8_ = cheese_camera_new (self->priv->video_preview, device, _tmp6_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp9_;
	cheese_camera_setup (self->priv->camera, device, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		clutter_actor_hide ((ClutterActor*) self->priv->video_preview);
		g_warning ("cheese-window.vala:1256: Error: %s\n", err->message);
		clutter_text_set_text (self->priv->error_layer, err->message);
		clutter_actor_show ((ClutterActor*) self->priv->error_layer);
		cheese_main_window_toggle_camera_actions_sensitivities (self, FALSE);
		_g_error_free0 (err);
		_g_free0 (device);
		return;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_free0 (device);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = g_settings_get_double (self->priv->settings, "brightness");
	value = _tmp10_;
	if (value != 0.0) {
		cheese_camera_set_balance_property (self->priv->camera, "brightness", value);
	}
	_tmp11_ = g_settings_get_double (self->priv->settings, "contrast");
	value = _tmp11_;
	if (value != 1.0) {
		cheese_camera_set_balance_property (self->priv->camera, "contrast", value);
	}
	_tmp12_ = g_settings_get_double (self->priv->settings, "hue");
	value = _tmp12_;
	if (value != 0.0) {
		cheese_camera_set_balance_property (self->priv->camera, "hue", value);
	}
	_tmp13_ = g_settings_get_double (self->priv->settings, "saturation");
	value = _tmp13_;
	if (value != 1.0) {
		cheese_camera_set_balance_property (self->priv->camera, "saturation", value);
	}
	g_signal_connect_object (self->priv->camera, "state-flags-changed", (GCallback) _cheese_main_window_camera_state_changed_cheese_camera_state_flags_changed, self, 0);
	cheese_camera_play (self->priv->camera);
	_g_free0 (device);
}


CheeseMainWindow* cheese_main_window_construct (GType object_type) {
	CheeseMainWindow * self = NULL;
	self = (CheeseMainWindow*) g_object_new (object_type, NULL);
	return self;
}


CheeseMainWindow* cheese_main_window_new (void) {
	return cheese_main_window_construct (CHEESE_TYPE_MAIN_WINDOW);
}


static void cheese_main_window_class_init (CheeseMainWindowClass * klass) {
	cheese_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseMainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_main_window_finalize;
}


static void cheese_main_window_instance_init (CheeseMainWindow * self) {
	self->priv = CHEESE_MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->current_effects_page = 0;
}


static void cheese_main_window_finalize (GObject* obj) {
	CheeseMainWindow * self;
	self = CHEESE_MAIN_WINDOW (obj);
	_g_object_unref0 (self->priv->gtk_builder);
	_g_object_unref0 (self->priv->clutter_builder);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->thumbnails);
	_g_object_unref0 (self->priv->viewport_widget);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->thumb_nav);
	_g_object_unref0 (self->priv->thumb_view);
	_g_object_unref0 (self->priv->thumbnails_right);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	_g_object_unref0 (self->priv->menubar);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	_g_object_unref0 (self->priv->photo_toggle_button);
	_g_object_unref0 (self->priv->video_toggle_button);
	_g_object_unref0 (self->priv->burst_toggle_button);
	_g_object_unref0 (self->priv->take_action_button);
	_g_object_unref0 (self->priv->take_action_button_label);
	_g_object_unref0 (self->priv->take_action_button_image);
	_g_object_unref0 (self->priv->effects_toggle_button);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	_g_object_unref0 (self->priv->buttons_area);
	_g_object_unref0 (self->priv->thumbnail_popup);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->viewport_layout);
	_g_object_unref0 (self->priv->video_preview);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	_g_object_unref0 (self->priv->countdown_layer);
	_g_object_unref0 (self->priv->background_layer);
	_g_object_unref0 (self->priv->error_layer);
	_g_object_unref0 (self->priv->current_effects_grid);
	_g_object_unref0 (self->priv->effects_grids);
	_g_object_unref0 (self->priv->take_photo_action);
	_g_object_unref0 (self->priv->take_video_action);
	_g_object_unref0 (self->priv->take_burst_action);
	_g_object_unref0 (self->priv->photo_mode_action);
	_g_object_unref0 (self->priv->video_mode_action);
	_g_object_unref0 (self->priv->burst_mode_action);
	_g_object_unref0 (self->priv->effects_toggle_action);
	_g_object_unref0 (self->priv->wide_mode_action);
	_g_object_unref0 (self->priv->fullscreen_action);
	_g_object_unref0 (self->priv->countdown_action);
	_g_object_unref0 (self->priv->effects_page_prev_action);
	_g_object_unref0 (self->priv->effects_page_next_action);
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->fileutil);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->effects_manager);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->selected_effect);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	_g_object_unref0 (self->priv->current_countdown);
	_g_object_unref0 (self->priv->action_sensitivities);
	G_OBJECT_CLASS (cheese_main_window_parent_class)->finalize (obj);
}


GType cheese_main_window_get_type (void) {
	static volatile gsize cheese_main_window_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMainWindow), 0, (GInstanceInitFunc) cheese_main_window_instance_init, NULL };
		GType cheese_main_window_type_id;
		cheese_main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "CheeseMainWindow", &g_define_type_info, 0);
		g_once_init_leave (&cheese_main_window_type_id__volatile, cheese_main_window_type_id);
	}
	return cheese_main_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



