/* week-pane.c generated by valac 0.26.1, the Vala compiler
 * generated from week-pane.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define CALIFORNIA_VIEW_WEEK_TYPE_PANE (california_view_week_pane_get_type ())
#define CALIFORNIA_VIEW_WEEK_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPane))
#define CALIFORNIA_VIEW_WEEK_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPaneClass))
#define CALIFORNIA_VIEW_WEEK_IS_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_VIEW_WEEK_TYPE_PANE))
#define CALIFORNIA_VIEW_WEEK_IS_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_VIEW_WEEK_TYPE_PANE))
#define CALIFORNIA_VIEW_WEEK_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPaneClass))

typedef struct _CaliforniaViewWeekPane CaliforniaViewWeekPane;
typedef struct _CaliforniaViewWeekPaneClass CaliforniaViewWeekPaneClass;
typedef struct _CaliforniaViewWeekPanePrivate CaliforniaViewWeekPanePrivate;

#define CALIFORNIA_VIEW_WEEK_TYPE_GRID (california_view_week_grid_get_type ())
#define CALIFORNIA_VIEW_WEEK_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_VIEW_WEEK_TYPE_GRID, CaliforniaViewWeekGrid))
#define CALIFORNIA_VIEW_WEEK_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_VIEW_WEEK_TYPE_GRID, CaliforniaViewWeekGridClass))
#define CALIFORNIA_VIEW_WEEK_IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_VIEW_WEEK_TYPE_GRID))
#define CALIFORNIA_VIEW_WEEK_IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_VIEW_WEEK_TYPE_GRID))
#define CALIFORNIA_VIEW_WEEK_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_VIEW_WEEK_TYPE_GRID, CaliforniaViewWeekGridClass))

typedef struct _CaliforniaViewWeekGrid CaliforniaViewWeekGrid;
typedef struct _CaliforniaViewWeekGridClass CaliforniaViewWeekGridClass;

#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;

#define CALIFORNIA_VIEW_TYPE_PALETTE (california_view_palette_get_type ())
#define CALIFORNIA_VIEW_PALETTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_VIEW_TYPE_PALETTE, CaliforniaViewPalette))
#define CALIFORNIA_VIEW_PALETTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_VIEW_TYPE_PALETTE, CaliforniaViewPaletteClass))
#define CALIFORNIA_VIEW_IS_PALETTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_VIEW_TYPE_PALETTE))
#define CALIFORNIA_VIEW_IS_PALETTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_VIEW_TYPE_PALETTE))
#define CALIFORNIA_VIEW_PALETTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_VIEW_TYPE_PALETTE, CaliforniaViewPaletteClass))

typedef struct _CaliforniaViewPalette CaliforniaViewPalette;
typedef struct _CaliforniaViewPaletteClass CaliforniaViewPaletteClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_VIEW_WEEK_TYPE_CONTROLLER (california_view_week_controller_get_type ())
#define CALIFORNIA_VIEW_WEEK_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_VIEW_WEEK_TYPE_CONTROLLER, CaliforniaViewWeekController))
#define CALIFORNIA_VIEW_WEEK_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_VIEW_WEEK_TYPE_CONTROLLER, CaliforniaViewWeekControllerClass))
#define CALIFORNIA_VIEW_WEEK_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_VIEW_WEEK_TYPE_CONTROLLER))
#define CALIFORNIA_VIEW_WEEK_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_VIEW_WEEK_TYPE_CONTROLLER))
#define CALIFORNIA_VIEW_WEEK_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_VIEW_WEEK_TYPE_CONTROLLER, CaliforniaViewWeekControllerClass))

typedef struct _CaliforniaViewWeekController CaliforniaViewWeekController;
typedef struct _CaliforniaViewWeekControllerClass CaliforniaViewWeekControllerClass;

#define CALIFORNIA_CALENDAR_TYPE_WALL_TIME (california_calendar_wall_time_get_type ())
#define CALIFORNIA_CALENDAR_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime))
#define CALIFORNIA_CALENDAR_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))

typedef struct _CaliforniaCalendarWallTime CaliforniaCalendarWallTime;
typedef struct _CaliforniaCalendarWallTimeClass CaliforniaCalendarWallTimeClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_TIME_UNIT (california_calendar_time_unit_get_type ())

struct _CaliforniaViewWeekPane {
	GtkEventBox parent_instance;
	CaliforniaViewWeekPanePrivate * priv;
};

struct _CaliforniaViewWeekPaneClass {
	GtkEventBoxClass parent_class;
	gboolean (*on_draw) (CaliforniaViewWeekPane* self, cairo_t* ctx);
};

struct _CaliforniaViewWeekPanePrivate {
	CaliforniaViewWeekGrid* _owner;
	CaliforniaViewPalette* _palette;
	gint _line_height_px;
	gint requested_width;
	GtkDrawingArea* canvas;
};

typedef enum  {
	CALIFORNIA_CALENDAR_TIME_UNIT_SECOND,
	CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE,
	CALIFORNIA_CALENDAR_TIME_UNIT_HOUR
} CaliforniaCalendarTimeUnit;


static gpointer california_view_week_pane_parent_class = NULL;

GType california_view_week_pane_get_type (void) G_GNUC_CONST;
GType california_view_week_grid_get_type (void) G_GNUC_CONST;
GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_view_palette_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_VIEW_WEEK_PANE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPanePrivate))
enum  {
	CALIFORNIA_VIEW_WEEK_PANE_DUMMY_PROPERTY,
	CALIFORNIA_VIEW_WEEK_PANE_OWNER,
	CALIFORNIA_VIEW_WEEK_PANE_PALETTE,
	CALIFORNIA_VIEW_WEEK_PANE_LINE_HEIGHT_PX
};
CaliforniaViewPalette* california_view_week_pane_get_palette (CaliforniaViewWeekPane* self);
static void california_view_week_pane_on_palette_changed (CaliforniaViewWeekPane* self);
static void _california_view_week_pane_on_palette_changed_california_view_palette_palette_changed (CaliforniaViewPalette* _sender, gpointer self);
CaliforniaViewWeekPane* california_view_week_pane_construct (GType object_type, CaliforniaViewWeekGrid* owner, gint requested_width);
static void california_view_week_pane_set_owner (CaliforniaViewWeekPane* self, CaliforniaViewWeekGrid* value);
GType california_view_week_controller_get_type (void) G_GNUC_CONST;
CaliforniaViewWeekController* california_view_week_grid_get_owner (CaliforniaViewWeekGrid* self);
CaliforniaViewPalette* california_view_week_controller_get_palette (CaliforniaViewWeekController* self);
static void california_view_week_pane_set_palette (CaliforniaViewWeekPane* self, CaliforniaViewPalette* value);
static void california_view_week_pane_update_palette_metrics (CaliforniaViewWeekPane* self);
gboolean california_view_week_pane_on_draw (CaliforniaViewWeekPane* self, cairo_t* ctx);
static gboolean _california_view_week_pane_on_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
gint california_view_palette_get_normal_font_height_px (CaliforniaViewPalette* self);
#define CALIFORNIA_VIEW_PALETTE_LINE_PADDING_PX 4
static void california_view_week_pane_set_line_height_px (CaliforniaViewWeekPane* self, gint value);
GType california_calendar_wall_time_get_type (void) G_GNUC_CONST;
gint california_view_week_pane_get_line_y (CaliforniaViewWeekPane* self, CaliforniaCalendarWallTime* wall_time);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void);
static gboolean california_view_week_pane_real_on_draw (CaliforniaViewWeekPane* self, cairo_t* ctx);
cairo_t* california_view_palette_prepare_hairline (cairo_t* ctx, GdkRGBA* rgba);
void california_view_palette_get_border (CaliforniaViewPalette* self, GdkRGBA* result);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_earliest (void);
GType california_calendar_time_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_wall_time_adjust (CaliforniaCalendarWallTime* self, gint value, CaliforniaCalendarTimeUnit unit, gboolean* rollover);
gint california_calendar_wall_time_get_minute (CaliforniaCalendarWallTime* self);
cairo_t* california_view_palette_prepare_hairline_dashed (cairo_t* ctx, GdkRGBA* rgba);
gint california_view_week_pane_get_line_height_px (CaliforniaViewWeekPane* self);
gint california_calendar_wall_time_get_hour (CaliforniaCalendarWallTime* self);
#define CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR 60
gint california_view_week_pane_get_text_y (CaliforniaViewWeekPane* self, CaliforniaCalendarWallTime* wall_time);
CaliforniaCalendarWallTime* california_view_week_pane_get_wall_time (CaliforniaViewWeekPane* self, gint y);
CaliforniaCalendarWallTime* california_calendar_wall_time_new (gint hour, gint minute, gint second);
CaliforniaCalendarWallTime* california_calendar_wall_time_construct (GType object_type, gint hour, gint minute, gint second);
CaliforniaViewWeekGrid* california_view_week_pane_get_owner (CaliforniaViewWeekPane* self);
static void california_view_week_pane_finalize (GObject* obj);
static void _vala_california_view_week_pane_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_view_week_pane_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _california_view_week_pane_on_palette_changed_california_view_palette_palette_changed (CaliforniaViewPalette* _sender, gpointer self) {
#line 43 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_on_palette_changed ((CaliforniaViewWeekPane*) self);
#line 165 "week-pane.c"
}


static gboolean _california_view_week_pane_on_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = california_view_week_pane_on_draw ((CaliforniaViewWeekPane*) self, cr);
#line 39 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 174 "week-pane.c"
}


CaliforniaViewWeekPane* california_view_week_pane_construct (GType object_type, CaliforniaViewWeekGrid* owner, gint requested_width) {
	CaliforniaViewWeekPane * self = NULL;
	CaliforniaViewWeekGrid* _tmp0_ = NULL;
	CaliforniaViewWeekGrid* _tmp1_ = NULL;
	CaliforniaViewWeekController* _tmp2_ = NULL;
	CaliforniaViewWeekController* _tmp3_ = NULL;
	CaliforniaViewPalette* _tmp4_ = NULL;
	CaliforniaViewPalette* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GtkDrawingArea* _tmp7_ = NULL;
	CaliforniaViewPalette* _tmp8_ = NULL;
	GtkDrawingArea* _tmp9_ = NULL;
#line 27 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_GRID (owner), NULL);
#line 27 "/home/jim/git/california/src/view/week/week-pane.vala"
	self = (CaliforniaViewWeekPane*) g_object_new (object_type, NULL);
#line 28 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = owner;
#line 28 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_set_owner (self, _tmp0_);
#line 29 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = owner;
#line 29 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp2_ = california_view_week_grid_get_owner (_tmp1_);
#line 29 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp3_ = _tmp2_;
#line 29 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp4_ = california_view_week_controller_get_palette (_tmp3_);
#line 29 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp5_ = _tmp4_;
#line 29 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_set_palette (self, _tmp5_);
#line 30 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp6_ = requested_width;
#line 30 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->requested_width = _tmp6_;
#line 32 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "margin", 0, NULL);
#line 34 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp7_ = self->priv->canvas;
#line 34 "/home/jim/git/california/src/view/week/week-pane.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
#line 36 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_update_palette_metrics (self);
#line 37 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp8_ = self->priv->_palette;
#line 37 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_signal_connect_object (_tmp8_, "palette-changed", (GCallback) _california_view_week_pane_on_palette_changed_california_view_palette_palette_changed, self, 0);
#line 39 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp9_ = self->priv->canvas;
#line 39 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), "draw", (GCallback) _california_view_week_pane_on_draw_gtk_widget_draw, self, 0);
#line 27 "/home/jim/git/california/src/view/week/week-pane.vala"
	return self;
#line 232 "week-pane.c"
}


static void california_view_week_pane_update_palette_metrics (CaliforniaViewWeekPane* self) {
	CaliforniaViewPalette* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkDrawingArea* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	CaliforniaCalendarWallTime* _tmp5_ = NULL;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	gint _tmp7_ = 0;
#line 46 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self));
#line 49 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_palette;
#line 49 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = california_view_palette_get_normal_font_height_px (_tmp0_);
#line 49 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp2_ = _tmp1_;
#line 49 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_set_line_height_px (self, _tmp2_ + (CALIFORNIA_VIEW_PALETTE_LINE_PADDING_PX * 2));
#line 52 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp3_ = self->priv->canvas;
#line 52 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp4_ = self->priv->requested_width;
#line 52 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp5_ = california_calendar_wall_time_get_latest ();
#line 52 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp6_ = _tmp5_;
#line 52 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp7_ = california_view_week_pane_get_line_y (self, _tmp6_);
#line 52 "/home/jim/git/california/src/view/week/week-pane.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), _tmp4_, _tmp7_);
#line 267 "week-pane.c"
}


static void california_view_week_pane_on_palette_changed (CaliforniaViewWeekPane* self) {
#line 55 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self));
#line 56 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_update_palette_metrics (self);
#line 57 "/home/jim/git/california/src/view/week/week-pane.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 278 "week-pane.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 75 "/home/jim/git/california/src/view/week/week-pane.vala"
	return self ? g_object_ref (self) : NULL;
#line 285 "week-pane.c"
}


static gboolean california_view_week_pane_real_on_draw (CaliforniaViewWeekPane* self, cairo_t* ctx) {
	gboolean result = FALSE;
	gint width = 0;
	gint _tmp0_ = 0;
	gint height = 0;
	gint _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	CaliforniaViewPalette* _tmp4_ = NULL;
	GdkRGBA _tmp5_ = {0};
	GdkRGBA _tmp6_ = {0};
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	cairo_t* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	cairo_t* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	cairo_t* _tmp16_ = NULL;
	CaliforniaCalendarWallTime* wall_time = NULL;
	CaliforniaCalendarWallTime* _tmp17_ = NULL;
	CaliforniaCalendarWallTime* _tmp18_ = NULL;
	CaliforniaCalendarWallTime* _tmp19_ = NULL;
	cairo_t* _tmp48_ = NULL;
#line 60 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 61 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 61 "/home/jim/git/california/src/view/week/week-pane.vala"
	width = _tmp0_;
#line 62 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 62 "/home/jim/git/california/src/view/week/week-pane.vala"
	height = _tmp1_;
#line 65 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp2_ = ctx;
#line 65 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_save (_tmp2_);
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp3_ = ctx;
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp4_ = self->priv->_palette;
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_palette_get_border (_tmp4_, &_tmp5_);
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp6_ = _tmp5_;
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp7_ = california_view_palette_prepare_hairline (_tmp3_, &_tmp6_);
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp8_ = _tmp7_;
#line 68 "/home/jim/git/california/src/view/week/week-pane.vala"
	_cairo_destroy0 (_tmp8_);
#line 69 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp9_ = ctx;
#line 69 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp10_ = width;
#line 69 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_move_to (_tmp9_, (gdouble) _tmp10_, (gdouble) 0);
#line 70 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp11_ = ctx;
#line 70 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp12_ = width;
#line 70 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp13_ = height;
#line 70 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_line_to (_tmp11_, (gdouble) _tmp12_, (gdouble) _tmp13_);
#line 71 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp14_ = ctx;
#line 71 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp15_ = height;
#line 71 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_line_to (_tmp14_, (gdouble) 0, (gdouble) _tmp15_);
#line 72 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp16_ = ctx;
#line 72 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_stroke (_tmp16_);
#line 75 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp17_ = california_calendar_wall_time_get_earliest ();
#line 75 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp18_ = _tmp17_;
#line 75 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 75 "/home/jim/git/california/src/view/week/week-pane.vala"
	wall_time = _tmp19_;
#line 375 "week-pane.c"
	{
		gboolean _tmp20_ = FALSE;
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp20_ = TRUE;
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
		while (TRUE) {
#line 382 "week-pane.c"
			gboolean rollover = FALSE;
			CaliforniaCalendarWallTime* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			CaliforniaCalendarWallTime* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gint line_y = 0;
			CaliforniaCalendarWallTime* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			CaliforniaCalendarWallTime* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			cairo_t* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			cairo_t* _tmp44_ = NULL;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			cairo_t* _tmp47_ = NULL;
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
			if (!_tmp20_) {
#line 402 "week-pane.c"
			}
#line 76 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp20_ = FALSE;
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp21_ = wall_time;
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp23_ = california_calendar_wall_time_adjust (_tmp21_, 30, CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE, &_tmp22_);
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
			rollover = _tmp22_;
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
			_g_object_unref0 (wall_time);
#line 78 "/home/jim/git/california/src/view/week/week-pane.vala"
			wall_time = _tmp23_;
#line 79 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp24_ = rollover;
#line 79 "/home/jim/git/california/src/view/week/week-pane.vala"
			if (_tmp24_) {
#line 80 "/home/jim/git/california/src/view/week/week-pane.vala"
				break;
#line 422 "week-pane.c"
			}
#line 82 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp25_ = wall_time;
#line 82 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp26_ = california_view_week_pane_get_line_y (self, _tmp25_);
#line 82 "/home/jim/git/california/src/view/week/week-pane.vala"
			line_y = _tmp26_;
#line 85 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp27_ = wall_time;
#line 85 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp28_ = california_calendar_wall_time_get_minute (_tmp27_);
#line 85 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp29_ = _tmp28_;
#line 85 "/home/jim/git/california/src/view/week/week-pane.vala"
			if (_tmp29_ == 0) {
#line 438 "week-pane.c"
				cairo_t* _tmp30_ = NULL;
				CaliforniaViewPalette* _tmp31_ = NULL;
				GdkRGBA _tmp32_ = {0};
				GdkRGBA _tmp33_ = {0};
				cairo_t* _tmp34_ = NULL;
				cairo_t* _tmp35_ = NULL;
#line 86 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp30_ = ctx;
#line 86 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp31_ = self->priv->_palette;
#line 86 "/home/jim/git/california/src/view/week/week-pane.vala"
				california_view_palette_get_border (_tmp31_, &_tmp32_);
#line 86 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp33_ = _tmp32_;
#line 86 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp34_ = california_view_palette_prepare_hairline (_tmp30_, &_tmp33_);
#line 86 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp35_ = _tmp34_;
#line 86 "/home/jim/git/california/src/view/week/week-pane.vala"
				_cairo_destroy0 (_tmp35_);
#line 459 "week-pane.c"
			} else {
				cairo_t* _tmp36_ = NULL;
				CaliforniaViewPalette* _tmp37_ = NULL;
				GdkRGBA _tmp38_ = {0};
				GdkRGBA _tmp39_ = {0};
				cairo_t* _tmp40_ = NULL;
				cairo_t* _tmp41_ = NULL;
#line 88 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp36_ = ctx;
#line 88 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp37_ = self->priv->_palette;
#line 88 "/home/jim/git/california/src/view/week/week-pane.vala"
				california_view_palette_get_border (_tmp37_, &_tmp38_);
#line 88 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp39_ = _tmp38_;
#line 88 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp40_ = california_view_palette_prepare_hairline_dashed (_tmp36_, &_tmp39_);
#line 88 "/home/jim/git/california/src/view/week/week-pane.vala"
				_tmp41_ = _tmp40_;
#line 88 "/home/jim/git/california/src/view/week/week-pane.vala"
				_cairo_destroy0 (_tmp41_);
#line 481 "week-pane.c"
			}
#line 90 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp42_ = ctx;
#line 90 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp43_ = line_y;
#line 90 "/home/jim/git/california/src/view/week/week-pane.vala"
			cairo_move_to (_tmp42_, (gdouble) 0, (gdouble) _tmp43_);
#line 91 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp44_ = ctx;
#line 91 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp45_ = width;
#line 91 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp46_ = line_y;
#line 91 "/home/jim/git/california/src/view/week/week-pane.vala"
			cairo_line_to (_tmp44_, (gdouble) _tmp45_, (gdouble) _tmp46_);
#line 92 "/home/jim/git/california/src/view/week/week-pane.vala"
			_tmp47_ = ctx;
#line 92 "/home/jim/git/california/src/view/week/week-pane.vala"
			cairo_stroke (_tmp47_);
#line 501 "week-pane.c"
		}
	}
#line 95 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp48_ = ctx;
#line 95 "/home/jim/git/california/src/view/week/week-pane.vala"
	cairo_restore (_tmp48_);
#line 97 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = TRUE;
#line 97 "/home/jim/git/california/src/view/week/week-pane.vala"
	_g_object_unref0 (wall_time);
#line 97 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 514 "week-pane.c"
}


gboolean california_view_week_pane_on_draw (CaliforniaViewWeekPane* self, cairo_t* ctx) {
#line 60 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), FALSE);
#line 60 "/home/jim/git/california/src/view/week/week-pane.vala"
	return CALIFORNIA_VIEW_WEEK_PANE_GET_CLASS (self)->on_draw (self, ctx);
#line 523 "week-pane.c"
}


/**
     * Returns the y (in pixels) for a particular line of text for the {@link Calendar.WallTime}.
     *
     * If displaying text, use {@link get_text_y}, as that will deduct padding.
     */
gint california_view_week_pane_get_line_y (CaliforniaViewWeekPane* self, CaliforniaCalendarWallTime* wall_time) {
	gint result = 0;
	gint line_y = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	CaliforniaCalendarWallTime* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 105 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), 0);
#line 105 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (wall_time), 0);
#line 107 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_line_height_px;
#line 107 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = wall_time;
#line 107 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp2_ = california_calendar_wall_time_get_hour (_tmp1_);
#line 107 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp3_ = _tmp2_;
#line 107 "/home/jim/git/california/src/view/week/week-pane.vala"
	line_y = (_tmp0_ * 2) * _tmp3_;
#line 110 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp4_ = wall_time;
#line 110 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp5_ = california_calendar_wall_time_get_minute (_tmp4_);
#line 110 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp6_ = _tmp5_;
#line 110 "/home/jim/git/california/src/view/week/week-pane.vala"
	if (_tmp6_ != 0) {
#line 564 "week-pane.c"
		gdouble fraction = 0.0;
		CaliforniaCalendarWallTime* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gdouble amt = 0.0;
		gint _tmp10_ = 0;
		gdouble _tmp11_ = 0.0;
		gint _tmp12_ = 0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
#line 111 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp7_ = wall_time;
#line 111 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp8_ = california_calendar_wall_time_get_minute (_tmp7_);
#line 111 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp9_ = _tmp8_;
#line 111 "/home/jim/git/california/src/view/week/week-pane.vala"
		fraction = ((gdouble) _tmp9_) / ((gdouble) CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR);
#line 112 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp10_ = self->priv->_line_height_px;
#line 112 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp11_ = fraction;
#line 112 "/home/jim/git/california/src/view/week/week-pane.vala"
		amt = (((gdouble) _tmp10_) * 2.0) * _tmp11_;
#line 114 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp12_ = line_y;
#line 114 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp13_ = amt;
#line 114 "/home/jim/git/california/src/view/week/week-pane.vala"
		_tmp14_ = round (_tmp13_);
#line 114 "/home/jim/git/california/src/view/week/week-pane.vala"
		line_y = _tmp12_ + ((gint) _tmp14_);
#line 597 "week-pane.c"
	}
#line 117 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = line_y;
#line 117 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 603 "week-pane.c"
}


/**
     * Returns the y (in pixels) for the top of a line of text at {@link Calendar.WallTime}.
     *
     * Use this when displaying text.  Drawing lines, borders, etc. should use {@link get_line_y}.
     */
gint california_view_week_pane_get_text_y (CaliforniaViewWeekPane* self, CaliforniaCalendarWallTime* wall_time) {
	gint result = 0;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 125 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), 0);
#line 125 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (wall_time), 0);
#line 126 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = wall_time;
#line 126 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = california_view_week_pane_get_line_y (self, _tmp0_);
#line 126 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = _tmp1_ + CALIFORNIA_VIEW_PALETTE_LINE_PADDING_PX;
#line 126 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 628 "week-pane.c"
}


/**
     * Returns the {@link Calendar.WallTime} for a y-coordinate down to the minute;
     */
CaliforniaCalendarWallTime* california_view_week_pane_get_wall_time (CaliforniaViewWeekPane* self, gint y) {
	CaliforniaCalendarWallTime* result = NULL;
	gint one_hour = 0;
	gint _tmp0_ = 0;
	gint hour = 0;
	gint _tmp1_ = 0;
	gint rem = 0;
	gint _tmp2_ = 0;
	gdouble min = 0.0;
	CaliforniaCalendarWallTime* _tmp3_ = NULL;
#line 132 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), NULL);
#line 134 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_line_height_px;
#line 134 "/home/jim/git/california/src/view/week/week-pane.vala"
	one_hour = _tmp0_ * 2;
#line 136 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = y;
#line 136 "/home/jim/git/california/src/view/week/week-pane.vala"
	hour = _tmp1_ / one_hour;
#line 137 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp2_ = y;
#line 137 "/home/jim/git/california/src/view/week/week-pane.vala"
	rem = _tmp2_ % one_hour;
#line 138 "/home/jim/git/california/src/view/week/week-pane.vala"
	min = (((gdouble) rem) / ((gdouble) one_hour)) * 60.0;
#line 140 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp3_ = california_calendar_wall_time_new (hour, (gint) min, 0);
#line 140 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = _tmp3_;
#line 140 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 667 "week-pane.c"
}


CaliforniaViewWeekGrid* california_view_week_pane_get_owner (CaliforniaViewWeekPane* self) {
	CaliforniaViewWeekGrid* result;
	CaliforniaViewWeekGrid* _tmp0_ = NULL;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), NULL);
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_owner;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = _tmp0_;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 682 "week-pane.c"
}


static void california_view_week_pane_set_owner (CaliforniaViewWeekPane* self, CaliforniaViewWeekGrid* value) {
	CaliforniaViewWeekGrid* _tmp0_ = NULL;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self));
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = value;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->_owner = _tmp0_;
#line 10 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_notify ((GObject *) self, "owner");
#line 696 "week-pane.c"
}


CaliforniaViewPalette* california_view_week_pane_get_palette (CaliforniaViewWeekPane* self) {
	CaliforniaViewPalette* result;
	CaliforniaViewPalette* _tmp0_ = NULL;
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), NULL);
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_palette;
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = _tmp0_;
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 711 "week-pane.c"
}


static void california_view_week_pane_set_palette (CaliforniaViewWeekPane* self, CaliforniaViewPalette* value) {
	CaliforniaViewPalette* _tmp0_ = NULL;
	CaliforniaViewPalette* _tmp1_ = NULL;
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self));
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = value;
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	_g_object_unref0 (self->priv->_palette);
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->_palette = _tmp1_;
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_notify ((GObject *) self, "palette");
#line 730 "week-pane.c"
}


gint california_view_week_pane_get_line_height_px (CaliforniaViewWeekPane* self) {
	gint result;
	gint _tmp0_ = 0;
#line 22 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_val_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self), 0);
#line 22 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_line_height_px;
#line 22 "/home/jim/git/california/src/view/week/week-pane.vala"
	result = _tmp0_;
#line 22 "/home/jim/git/california/src/view/week/week-pane.vala"
	return result;
#line 745 "week-pane.c"
}


static void california_view_week_pane_set_line_height_px (CaliforniaViewWeekPane* self, gint value) {
	gint _tmp0_ = 0;
#line 22 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_return_if_fail (CALIFORNIA_VIEW_WEEK_IS_PANE (self));
#line 22 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = value;
#line 22 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->_line_height_px = _tmp0_;
#line 22 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_notify ((GObject *) self, "line-height-px");
#line 759 "week-pane.c"
}


static void california_view_week_pane_class_init (CaliforniaViewWeekPaneClass * klass) {
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	california_view_week_pane_parent_class = g_type_class_peek_parent (klass);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaViewWeekPanePrivate));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	((CaliforniaViewWeekPaneClass *) klass)->on_draw = california_view_week_pane_real_on_draw;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_view_week_pane_get_property;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_view_week_pane_set_property;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	G_OBJECT_CLASS (klass)->finalize = california_view_week_pane_finalize;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_VIEW_WEEK_PANE_OWNER, g_param_spec_object ("owner", "owner", "owner", CALIFORNIA_VIEW_WEEK_TYPE_GRID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 778 "week-pane.c"
	/**
	     * {@link View.Palette} for the {@link Pane}.
	     *
	     * The palette should be associated with the Gtk.Window hosting the Pane.
	     */
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_VIEW_WEEK_PANE_PALETTE, g_param_spec_object ("palette", "palette", "palette", CALIFORNIA_VIEW_TYPE_PALETTE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 786 "week-pane.c"
	/**
	     * The height of each "line" of text, including top and bottom padding
	     */
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_VIEW_WEEK_PANE_LINE_HEIGHT_PX, g_param_spec_int ("line-height-px", "line-height-px", "line-height-px", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 792 "week-pane.c"
}


static void california_view_week_pane_instance_init (CaliforniaViewWeekPane * self) {
	GtkDrawingArea* _tmp0_ = NULL;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv = CALIFORNIA_VIEW_WEEK_PANE_GET_PRIVATE (self);
#line 22 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->_line_height_px = 0;
#line 25 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = (GtkDrawingArea*) gtk_drawing_area_new ();
#line 25 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_object_ref_sink (_tmp0_);
#line 25 "/home/jim/git/california/src/view/week/week-pane.vala"
	self->priv->canvas = _tmp0_;
#line 808 "week-pane.c"
}


static void california_view_week_pane_finalize (GObject* obj) {
	CaliforniaViewWeekPane * self;
	CaliforniaViewPalette* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPane);
#line 43 "/home/jim/git/california/src/view/week/week-pane.vala"
	_tmp0_ = self->priv->_palette;
#line 43 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_signal_parse_name ("palette-changed", CALIFORNIA_VIEW_TYPE_PALETTE, &_tmp1_, NULL, FALSE);
#line 43 "/home/jim/git/california/src/view/week/week-pane.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _california_view_week_pane_on_palette_changed_california_view_palette_palette_changed, self);
#line 17 "/home/jim/git/california/src/view/week/week-pane.vala"
	_g_object_unref0 (self->priv->_palette);
#line 25 "/home/jim/git/california/src/view/week/week-pane.vala"
	_g_object_unref0 (self->priv->canvas);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	G_OBJECT_CLASS (california_view_week_pane_parent_class)->finalize (obj);
#line 830 "week-pane.c"
}


GType california_view_week_pane_get_type (void) {
	static volatile gsize california_view_week_pane_type_id__volatile = 0;
	if (g_once_init_enter (&california_view_week_pane_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaViewWeekPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_view_week_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaViewWeekPane), 0, (GInstanceInitFunc) california_view_week_pane_instance_init, NULL };
		GType california_view_week_pane_type_id;
		california_view_week_pane_type_id = g_type_register_static (gtk_event_box_get_type (), "CaliforniaViewWeekPane", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&california_view_week_pane_type_id__volatile, california_view_week_pane_type_id);
	}
	return california_view_week_pane_type_id__volatile;
}


static void _vala_california_view_week_pane_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaViewWeekPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPane);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	switch (property_id) {
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		case CALIFORNIA_VIEW_WEEK_PANE_OWNER:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		g_value_set_object (value, california_view_week_pane_get_owner (self));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		case CALIFORNIA_VIEW_WEEK_PANE_PALETTE:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		g_value_set_object (value, california_view_week_pane_get_palette (self));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		case CALIFORNIA_VIEW_WEEK_PANE_LINE_HEIGHT_PX:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		g_value_set_int (value, california_view_week_pane_get_line_height_px (self));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 869 "week-pane.c"
		default:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 875 "week-pane.c"
	}
}


static void _vala_california_view_week_pane_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaViewWeekPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_VIEW_WEEK_TYPE_PANE, CaliforniaViewWeekPane);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
	switch (property_id) {
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		case CALIFORNIA_VIEW_WEEK_PANE_OWNER:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		california_view_week_pane_set_owner (self, g_value_get_object (value));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		case CALIFORNIA_VIEW_WEEK_PANE_PALETTE:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		california_view_week_pane_set_palette (self, g_value_get_object (value));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		case CALIFORNIA_VIEW_WEEK_PANE_LINE_HEIGHT_PX:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		california_view_week_pane_set_line_height_px (self, g_value_get_int (value));
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 903 "week-pane.c"
		default:
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 9 "/home/jim/git/california/src/view/week/week-pane.vala"
		break;
#line 909 "week-pane.c"
	}
}



